﻿//bricks fall and hit the player on the head, the also rotate
//while falling
ig.module('game.entities.brick')
.requires(
    'impact.impact',
    'impact.entity'
)
.defines(function () {
    "use strict";
    ig.global.Brick = {
        //this is a flag to indicate that someone is
        //going to break a window
        breakLock: false
    }
    ig.global.EntityBrick = ig.Entity.extend({
        size: { x: IMG.SIZE(50), y: IMG.SIZE(40) },
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'brick.png', IMG.SIZE(50), IMG.SIZE(40)),
        gravityFactor: 0,
        type: ig.Entity.TYPE.A,
        maxVel: { x: 0, y: 1000 },
        vel: { x: 0, y: 0 },
        //this structure holds the distance from the top left corner of the level
        //this is used so that we know where to move to when the screen is resized
        levelOffset: { x: 0, y: 0 },
        rotationSpeed: 1,
        //the window we are going to break
        breakTarget: undefined,
        init: function (x, y, settings) {
            this.rotationSpeed = Math.random();
            this.animSheet.angle = 0;
            this.addAnim('idle', 0.1, [0]);
            this.anims.idle.angle = 0;
            this.vel.y = IMG.SIZE(Brick.vel);
            //we want to have a slightly random x offset
            var randomOffset = Math.random() * IMG.SIZE(30) - IMG.SIZE(15);
            this.offset.x += randomOffset;
            this.parent(x, y, settings);
            if (Brick.randomBreak !== undefined && Brick.breakLock === false) {
                if (Math.random() < Brick.randomBreak) {
                    this.breakTarget = this.chooseWindow();
                    if (this.breakTarget !== undefined) {
                        Brick.breakLock = true;
                    }
                }
            }

        },
        //pick a window to break, we only consider fixed windows in the current row
        //note that we can have two bricks in the same "group" select the same window
        //that is fine.
        chooseWindow: function () {
            var candidates = [];
            var windows = ig.game.level.squashWindows();
            //gets the windows in the same column as the brick
            candidates = windows.filter(function (val) {
                if (this.pos.x > val.pos.x && this.pos.x < val.pos.x + val.size.x) {
                    return true;
                } else {
                    return false;
                }
            }, this);

            //we only want to consider breaking windows that are fixed
            candidates = candidates.filter(function (val) {
                return val.currentAnim === val.anims.fixed;
            });

            var randomIndex = Math.floor(Math.random() * candidates.length);
            var breakWindow = candidates[randomIndex];
            return breakWindow;
        },
        updateLevelOffset: function () {
            var level = ig.game.level;
            this.levelOffset.x = this.pos.x - level.pos().x;
            this.levelOffset.y = this.pos.y - level.pos().y;
        },
        reposition: function () {
            var level = ig.game.level;
            this.pos.x = level.pos().x + this.levelOffset.x;
            this.pos.y = level.pos().y + this.levelOffset.y; //not really doing much since we dont change the height
        },
        update: function () {
            //update the level offset, we need to do this each frame
            this.updateLevelOffset();
            //rotate the bricke
            this.currentAnim.angle += this.rotationSpeed / 3;
            if (this.breakTarget !== undefined) {
                //3 is an arbitrary value that should be large enough
                //so that we dont miss our window yet small enough
                //so that it looks like we break the window at the center
                if (this.distanceTo(this.breakTarget) < 3) {
                    this.breakTarget.breakWindow()
                    ig.game.soundBreak.play();
                    this.breakTarget = undefined;
                    Brick.breakLock = false;
                }
            }

            //despawn the bricks when they go off the bottom of the screen
            if (this.pos.y > ig.system.height) {
                this.kill();
            }
            this.parent();
        }
    });
});
