ig.module(
    'game.entities.building'
)
.requires(
    'impact.entity'
)
.defines(function () {
    "use strict"
    //The building background entity,
    //does not do anything special
    //stored as an entity because if it was a tileset
    //then each image would have to be recreated out of
    //the tielset squares.
    //
    //Also note each part of the building is stored as a different
    //animation
    ig.global.EntityBuilding = ig.Entity.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'building.png', IMG.SIZE(1010), IMG.SIZE(270)),
        size: { x: IMG.SIZE(1010), y: IMG.SIZE(270) },
        maxVel: { x: 0, y: 500 },
        zIndex: -2,
        gravityFactor: 0,
        init: function (x, y, settings) {
            this.addAnim('bottom', 0.1, [2]);
            this.addAnim('middle', 0.1, [1]);
            this.addAnim('top', 0.1, [0]);

            this.parent(x, y, settings);
        }
    });
});
