ig.module('game.entities.cloud')
.requires(
    'impact.entity',
    'impact.impact',
    'impact.animation'
)
.defines(function () {
    "use strict";
    ig.global.EntityCloud = ig.Entity.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'cloud.png', IMG.SIZE(455), IMG.SIZE(205)),
        size: { x: IMG.SIZE(455), y: IMG.SIZE(205) },
        gravityFactor: 0,
        vel: { x: IMG.SIZE(100), y: IMG.SIZE(0) },
        zIndex: -10,
        init: function (x, y, settings) {
            this.addAnim('idle', 0.1, [0]);
            var randomVel = Math.random() * IMG.SIZE(100) - IMG.SIZE(50);
            this.vel.x = randomVel;
            
            this.parent(x, y, settings);
        },
        update: function () {

            //wrap around the level, if we are going left and we are fully off the screen
            //then teleport to the other side of the screen, if we are going write do the opposite
            if (this.vel.x < 0 && this.pos.x < 0 - this.size.x) {
                //^| we are going left
                this.pos.x = ig.system.width + this.size.x;
            } else if (this.vel.x > 0 && this.pos.x > ig.system.width + this.size.x) {
                //^| we are going right
                this.pos.x = 0 - this.size.x;
            }
            this.parent();
        }
    });
});
