ig.module(
    'game.entities.door'
)
.requires(
    'impact.entity',
    'game.entities.window'
)
.defines(function () {
    "use strict";
    ig.global.EntityDoor = EntityWindow.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'door.png', IMG.SIZE(195), IMG.SIZE(500)),
        door: true, //this is a marker property
        offset: { x: IMG.SIZE(((195 - 125) / 2)), y: IMG.SIZE ((500 - 245)) },
        maxVel: { x: 0, y: 500 },
        zIndex: 0,
        init: function (x, y, settings) {
            //make the size accessable to unity

            this.addAnim('fixed', 0.1, [0]);
            this.addAnim('topBroken', 0.1, [1]);
            this.addAnim('bothBroken', 0.1, [2]);

            this.addFixAnim('topBroken', 'fixed', 3);
            this.addFixAnim('bothBroken', 'topBroken', 3);
            this.finalAnim = this.anims.fixed;
            this.parent(x, y, settings);
        },

        //override Window's getPlayerPosition function
        //so that it returns the adjusted position for the door
        getPlayerPosition: function () {
            var retval = {
                x: this.pos.x,
                y: this.pos.y + 10
            }
            return retval;
        }

    });

});
