ig.module(
    'game.entities.duck'
)
.requires(
    'impact.impact',
    'impact.entity',
    'impact.animation'
)
.defines(function () {
    "use strict";
    ig.global.EntityDuck = ig.Entity.extend({
        type: ig.Entity.TYPE.A,
        gravityFactor: 0,
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'duck.png', IMG.SIZE(105), IMG.SIZE(95)),
        offset: {x:0, y:IMG.SIZE(-50)},
        size: { x: IMG.SIZE(105), y: IMG.SIZE(95) },
        vel: { x: 100, y: 0 },
        maxVel: {x:1000, y:0},
        //venet handler called when a duck is removed from the game
        onRemove: null,
        init: function (x, y, direction, settings) {
            this.addAnim('idle', 0.5, [0, 1]);
            this.currentAnim = this.anims.idle;
            this.direction = direction;
            if (direction === "left") {
                this.currentAnim.flip.x = true;
                this.vel.x *= -1; //negate the x velocity, we want to be going the other direction
            }
            this.parent(x, y, settings);

        },
        kill: function() {
            if(this.onRemove !== null) {
                this.onRemove();
            }
            this.parent();
        },
        update: function () {
            //handle deleteing this entity if it goes offscreen
            if (this.direction === "left" && this.pos.x < 0 - this.size.x) {
                this.kill();
            } else if (this.direction === "right" && this.pos.x > ig.system.width + this.size.x) {
                this.kill();
            }
            this.parent();
        }
    });
});