//obstacle entity, same size and shape as a window
//so that they are super easy position.
ig.module(
    'game.entities.obstacle'
)
.requires(
    'impact.impact',
    'impact.animation',
    'game.movement',
    'game.path'
)
.defines(function () {
    "use strict";
    ig.global.EntityObstacle = ig.Entity.extend({
        color: "Green",
        size: { x: IMG.SIZE(125), y: IMG.SIZE(215) },
        offset: { x: IMG.SIZE(0), y: IMG.SIZE(62) },
        maxVel: { x: 0, y: 500 },
        bounceDist: { x: IMG.SIZE(35), y: IMG.SIZE(35) },
        gravityFactor: 0,
        zIndex: 2, //we actually want this to display over the player
        init: function (x, y, settings) {
            this.color = settings.color || "Green";
            this.animSheet = new ig.AnimationSheet(IMG.PREFIX + 'obstacles' + this.color + '.png', IMG.SIZE(125), IMG.SIZE(297))
            this.addAnim('left', 0.1, [1]);
            this.addAnim('right', 0.1, [2]);
            this.addAnim('down', 0.1, [0]);
            this.addAnim('up', 0.1, [3]);
            this.parent(x, y, settings);
        },
        buildPath: function (position, direction) {
            var path = [];
            //set up a normalized direction so that we can
            // just bounceDist X normDirection and get
            // a movement destination
            var normDirection = { x: 0, y: 0 };
            if (direction === "up") {
                normDirection.y = -1;
            } else if (direction === "down") {
                normDirection.y = 1;
            } else if (direction === "left") {
                normDirection.x = -1;
            } else if (direction === "right") {
                normDirection.x = 1;
            }
            var posCpy = {
                x: position.x,
                y: position.y
            }
            var dest = {
                x: posCpy.x + normDirection.x * this.bounceDist.x,
                y: posCpy.y + normDirection.y * this.bounceDist.y
            };
            this.movements = [];
            path.push(posCpy);
            path.push(dest);
            path.push(posCpy);
            return new PathBase(path, 0.1);

        },
        handleHit: function (direction) {
            //if we are already moving then we dont want to bounce again
            if (!this.behavior) {
                //make sure to drag the player with us
                //we do this by assigning the smae path to the player
                //TODO: shorten these function calls
                this.behavior = Behavior.followBasicPath.bind(window, new ig.Timer(), this, this.buildPath(this.pos, direction), Behavior.remove.bind(window, this));
                var lastBeh = ig.game.player.behavior || function() {delete ig.game.player.behavior};
                ig.game.player.behavior = Behavior.followBasicPath.bind(window, new ig.Timer, ig.game.player, this.buildPath(ig.game.player.pos, direction), function(){ig.game.player.behavior = lastBeh;});
            }
        },
        update: function () {
            if (this.behavior) {
                this.behavior();
            }
            this.parent();
        }
    });
});
