ig.module('game.entities.person')
.requires(
    'impact.impact',
    'impact.animation',
    'impact.entity'
)
.defines(function () {
    "use strict";
    ig.global.EntityPerson = ig.Entity.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + "people.png", IMG.SIZE(60), IMG.SIZE(85)),
        menSheet: new ig.AnimationSheet(IMG.PREFIX + "men.png", IMG.SIZE(60), IMG.SIZE(85)),
        womanSheet: new ig.AnimationSheet(IMG.PREFIX + 'woman.png', IMG.SIZE(60), IMG.SIZE(85)),
        anims: [],
        size: { x: IMG.SIZE(60), y: IMG.SIZE(85) },
        gravityFactor: 0,
        zIndex: 5,
        movement: null,
        init: function (x, y, settings) {
            
            this.anims.push(new ig.Animation(this.animSheet, 0.1, [0]));
            this.anims.push(new ig.Animation(this.animSheet, 0.1, [1]));
            this.anims.push(new ig.Animation(this.animSheet, 0.1, [2]));
            this.anims.push(new ig.Animation(this.animSheet, 0.1, [3]));
            this.anims.push(new ig.Animation(this.animSheet, 0.1, [4]));
            this.anims.push(new ig.Animation(this.animSheet, 0.1, [5]));
            this.currentAnim = this.anims[0];
            this.parent(x, y, settings);
        },
        update: function () {
            if (this.movement) {
                this.pos = this.movement.getPosition();
            }
            this.parent();
        }
    });
});
