//this entity manages spawning pies across the level
//it keeps track of timers and finds places
//to spawn pies
ig.module('game.entities.pie-spawner')
.requires(
    'impact.impact',
    'impact.entity',
    'impact.animation',
    'impact.timer',
    'game.entities.pie',
    'game.level'
)
.defines(function () {
    "use strict";
    ig.global.EntityPieSpawner = ig.Entity.extend({
        minSpawnTime: 0,
        maxSpawnTime: 10,
        prob: 0.5,
        nextSpawnTime: 1,
        maxPies: 1,
        numPies: 0,
        enabled: true,
        timer: new ig.Timer(),
        init: function (x, y, settings) {
            this.minSpawnTime = settings.minSpawnTime;
            this.maxSpawnTime = settings.maxSpawnTime;
            this.prob = settings.prob;
            this.maxPies = settings.maxPies;

            //just like with the duck-spawner this is not a "real" entity
            this.parent(x, y, settings);
        },
        //remoted a pie from the given window
        handlePieRemove: function (targetWindow) {
            this.numPies -= 1;
            targetWindow.closeWindow();
            targetWindow.removeHead();
        },
        update: function () {
            //the loop structure here needs some brief explination
            //the idea with the pies is that we want to have a somewhat large
            //chance of them never spawning on a level, ideally we would just
            //say that when we are above the min spawn time we have only a small
            //chance of actually spawning a pie. That said the Unity implementation
            //of the game uses the minimum and maximum spawn times in the same way
            // as the bird spawning code but has an additional random check so that
            //when the real (a random value in the range of minTime to maxTime) is reached
            //the pie may not spawn and just say it did, resetting the timer and generating
            //and new "real" spawn time
            if (this.enabled) {
                //check if we have passed the desitred spawn time, if so
                //check if we can actually spawn some more pies, if both are ture
                //proceed to spawn pies
                if (this.timer.delta() > this.nextSpawnTime && this.numPies < this.maxPies) {
                    var randomValue = Math.random();
                    this.timer.reset();
                    this.nextSpawnTime = Math.floor(Math.random() * (this.maxSpawnTime - this.minSpawnTime + 1) + this.minSpawnTime);
                    if (this.prob >= randomValue) {
                        this.spawnPie();

                    }
                }
            }
            this.parent();
        },
        //find a window and spawn a pie
        spawnPie: function () {
            var targetWindow = this.getTargetWindow();
            if (targetWindow) {
                targetWindow.spawnHead();
                targetWindow.openWindow();

                this.numPies += 1;
                var ent = ig.game.spawnEntity(EntityPie, targetWindow.pos.x, targetWindow.pos.y);
                ent.onRemove = this.handlePieRemove.bind(this, targetWindow);
                return ent;
            }
        },
        getTargetWindow: function () {
            //LANGFEATURE: list comprehension
            //note this is commented out since it breaks my IDE
            //var windows = [x for x in ig.game.level];

            var windows = [];
            //loop through all the floors but the top ones (where the player)
            //can not reach
            for (var i = 0; i < ig.game.level.floors.length - 2; ++i) {
                for (var j = 0; j < ig.game.level.floors[i].windows.length; ++j) {
                    //and get the current window
                    windows.push(ig.game.level.floors[i].windows[j]);
                }
            }


            //go through the list of windows and select the ones that are "valid" pie
            //targets, this means that they are not doors and they are not "closed" with
            //the shudders
            var possibleWindows = windows.filter(function (val) {
                if (!(val.door) && (val.currentAnim === val.anims.fixed && val.hasInitialized === true)) {
                    return true;
                } else {
                    return false;
                }
            });
            //we have a list of possible windows, lets pick one at random!
            var randomIndex = Math.floor(Math.random() * possibleWindows.length);
            var targetWindow = possibleWindows[randomIndex];
            return targetWindow;
        }

    });

});
