//implements the pie, the pie is the same size as a window
//and it collides (checks aganst) the player, thus
//when the player is over the pie's window
//the pie can trigger the player to do stuff
//
//it is true that this arrangement (the pie does stuff with the player)
//is not as intuitive as the player doing stuff with the pie but it
//does mean that each powerup/item does not need special player code
ig.module('game.entities.pie')
.requires(
    'impact.impact',
    'impact.entity',
    'game.entities.score',
    'impact.animation',
    'game.behavior'
)
.defines(function () {
    "use strict";
    ig.global.EntityPie = ig.Entity.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'pie.png', IMG.SIZE(55), IMG.SIZE(65)),
        size: { x: IMG.SIZE(125), y: IMG.SIZE(156) }, //this is the same size as a window
        timeToLive: 5,
        zIndex: 3,
        offset: { x: IMG.SIZE(-35), y: IMG.SIZE(-125) },
        timer: null,
        gravityFactor: 0,
        checkAgainst: ig.Entity.TYPE.B,
        onRemove: null,
        init: function (x, y, settings) {
            this.addAnim('idle', 0.1, [0, 1]);
            this.timer = new ig.Timer();
            this.currentAnim = this.anims.idle;
            
            this.parent(x, y, settings);
        },
        doScoreMultiplier: function() {
            if(!ig.game.scoreEnt) {
                ig.game.spawnEntity(EntityScore, 0,0);
            }
            var x = ig.game.player.pos.x;
            var y = ig.game.player.pos.y;
            ig.game.scoreEnt.start(x,y,5);
        },
        update: function () {
            if (this.timer.delta() > this.timeToLive) {
                this.kill();
            }
            this.parent();
        },
        kill: function () {
            if (this.onRemove !== null) {
                this.onRemove();
            }
            this.parent();
        },
        check: function (other) {
            //we want to prevent activateing the pie
            //invincibility effect if the player is transitioning
            //or falling already
            if (!other.updateLock && !other.lock && !other.isDieing) {
                ig.game.soundPie.play();
                this.doScoreMultiplier();
                
                other.behavior = Behavior.and.bind(window, Behavior.Player.move.bind(window, new ig.Timer(), other), Behavior.Player.eatPie.bind(window, new ig.Timer(), other));
                this.kill();
            }

        }
    });
});
