//score represents the floating numbers that appear when the player
//fixes a window as well as the action of adding score to the display
//this entity is cached so we only need to create it once, after that
//we can just use start()
ig.module('game.entities.score')
.requires(
    'impact.impact',
    'impact.font',
    'game.movement'
)
.defines(function () {
    "use strict";
    ig.global.EntityScore = ig.Entity.extend({
        zIndex: 50,
        multiplier: 1,
        floatDist: IMG.SIZE(-30), //how far up the font floats
        animTime: 0.5, //how long the font stays around
        blinkTimer: null,
        textColors: ['#D7DF01', '#FFFF75'],
        currentColor: 0,
        lock: false,
        init: function (x, y, settings) {
            this.blinkTimer = new ig.Timer();
            this.parent(x, y, {});
            this.start(x, y, settings);
            ig.game.scoreEnt = this;
        },
        //start resets the entity to the given position without
        //actually respawning it, sort of like a primitive
        //form of pooling
        start: function (x, y, mult) {
            this.blinkTimer.reset();
            this.movement = new Movement({ x: x, y: y }, { x: x, y: y + this.floatDist }, this.animTime);
            this.multiplier = mult;
	    //console.log("Basile Test: Got Here");
            UI.addScoreAnimated(100 * mult);
        },
        update: function() {
            this.pos = this.movement.getPosition();
            if(this.blinkTimer.delta() >= 0.1) {
                this.blinkTimer.reset();
                this.currentColor = !this.currentColor + 0;
            }
            if(this.movement.isDone()) {
                this.lock = true;
            } else {
                this.lock = false;
            }
        },
        draw: function () {
            if(!this.lock) {
                var ctx = ig.system.context;
                ctx.font = IMG.SIZE(60) + 'px "Press Start 2P"';
                ctx.fillStyle = this.textColors[this.currentColor];
                ctx.fillText(100 * this.multiplier, this.pos.x, this.pos.y);
                this.parent();
            }


        }
    });
});
