ig.module('game.entities.speech-bubble')
.requires(
        'impact.entity',
        'impact.animation',
        'impact.impact'
        )
.defines(function() {
    "use strict";
    ig.global.EntitySpeechBubble = ig.Entity.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'speechBubbleRed.png', IMG.SIZE(1010), IMG.SIZE(272)),
        size: {x: IMG.SIZE(1010), y: IMG.SIZE(272)},
        zIndex: 30,
        gravityFactor: 0,
        init: function(x, y, settings) {
            this.addAnim('idle', 0.1, [0]);
            this.parent(x,y,settings);
            this.pos.x = ig.system.width / 2 - this.size.x / 2;
            this.pos.y = ig.game.level.floors[3].windows[0].pos.y;
            
        },

        draw: function() {
            this.parent();
            var ctx = ig.system.context;
            ctx.fillStyle = '#FF0000'; //red
            ctx.font = IMG.SIZE(130) + "px Press-Start-2P";
            var textWidth = ctx.measureText("You Fixed It!");
            ctx.fillText('You Fixed It!', this.pos.x + this.size.x / 2 - textWidth.width/2, this.pos.y + this.size.y/2);
        }
    });
});
