//this is a super simple timed entity wrapper
//essentially you create one of these and give it a
//entity, a time for that entity to live, and 
//something to do after the entity is gone
ig.module('game.entities.timed-entity')
.requires(
        'impact.entity',
        'impact.impact',
        'impact.timer'
        )
.defines(function() {
    "use strict";
    ig.global.EntityTimedEntity = ig.Entity.extend({
        timer: new ig.Timer(),
        time: 0,
        cont: null,
        ent: null,
        //entity: the entitiy to keep around for a given amount of time
        //time: the time to keep the entity around
        //cont: a continuation (function) to call when the entity and
        //      and the timedEntity is destroyed
        init: function(entity, time, cont) {
            this.timer.reset();
            this.time = time;
            this.cont = cont;
            this.ent = entity;
            this.parent(0,0,{});
        },
        update: function() {
            if(this.timer.delta() >= this.time) {
                this.ent.kill();
                this.cont();
                this.kill();
            }

        }
    });
});
