﻿ig.module(
    'game.entities.window-a'
)
.requires(
    'impact.entity',
    'game.entities.window',
    'game.config'
)
.defines(function () {
    "use strict";
    ig.global.EntityWindowA = EntityWindow.extend({
        init: function (x, y, settings) {
            //we want to inject the new color setting now so that it is avalible for
            //the initialization of the animationSheet
            this.color = settings.color || "Green";
            //this will not get loaded by the preloader, we want that since we want to be able to select
            //the color of the window at runtime and each color has a seperate animation sheet
            this.animSheet = new ig.AnimationSheet(IMG.PREFIX + 'windowA' + this.color + '.png', IMG.SIZE(125), IMG.SIZE(215));
            this.addAnim('fixed', 0.1, [0]);
            this.addAnim('unbreakable', 0.1, [1]);
            this.addAnim('topBroken', 0.1, [2]);
            this.addAnim('bottomBroken', 0.1, [3]);
            this.addAnim('bothBroken', 0.1, [4]);
            this.addAnim('bottomOpen', 0.1, [5]);
            this.addFixAnim('topBroken', 'fixed', 3);
            this.addFixAnim('bottomBroken', 'fixed', 3);
            this.addFixAnim('bothBroken', 'topBroken', 3);
            this.currentAnim = this.anims.fixed;
            this.finalAnim = this.anims.fixed;
            this.parent(x,y,settings);
        }
    });
});
