ig.module('game.entities.window-shard')
.requires(
    'impact.impact',
    'impact.entity',
    'impact.animation',
    'impact.timer'
)
.defines(function () {
    "use strict"
    ig.global.EntityWindowShard = ig.Entity.extend({
        animSheet: new ig.AnimationSheet(IMG.PREFIX + 'windowShard.png', IMG.SIZE(64), IMG.SIZE(64)),
        timeToLive: 0,
        timer: null,
        gravityFactor: 1,
        enabled: true,
        maxVel: { x: 500, y: 500 },
        onDisable: null,
        init: function (x, y, settings) {
            this.addAnim('idle', 0.1, [0]);
            //get some random amount to rotate this particle
            var rndRot = Math.random() * Math.PI * 2;

            //get a random number between 0 and 200 then sutract 100
            //thus getting a random number between -100 and 100
            var velocityX = Math.random() * IMG.SIZE(400 - 200);
            var velocityY = Math.random() * IMG.SIZE(500);
            this.vel = {
                x: velocityX,
                y: velocityY
            };

            //specify the current animation and its angle
            this.currentAnim = this.anims.idle;
            this.currentAnim.angle = rndRot;

            //specify a time to live around 3 seconds
            //and make a timer to measure that
            this.timeToLive = 2 + (Math.random() * 2 - 1);
            this.timer = new ig.Timer();


            this.parent(x, y, settings);
        },
        reset: function (x, y) {
            this.enabled = true;
            this.timer.reset();
            this.pos.x = x;
            this.pos.y = y;
        },
        update: function () {
            if (this.enabled === true) {
                //if we harve timed out then call kill
                if (this.timer.delta() >= this.timeToLive) {
                    this.enabled = false;
                    if (this.onDisable) {
                        this.onDisable(this);
                    }
                }
                this.parent();
            }
        },
        draw: function () {
            if (this.enabled === true) {
                this.parent();
            }
        }
    });
});