//these two global variables represent
//the path to look for images in
//and the size they are at. The size is
//a percent (0-1) of the original size of the image
//it is expected that the folder at PREFIX will contain
//images of that size, thus this does not scale images
//when the game loads but rather specifies that images were scaled
//beforehand as part of the build process
window.IMG = {};
//make sure to include a trailing slash
window.IMG.PREFIX = "media/25/";
window.IMG.SCALE = 0.25;
//this function takes the size of the image
//and returns the size of the scaled image.
//this funciton should be referentially transparent
window.IMG.SIZE = function (size) {
    return Math.round(size * IMG.SCALE);
};

ig.module(
    'game.main'
)
.requires(
    'impact.game',
    'impact.font',
    'impact.sound',
    'game.entities.speech-bubble',
    'game.entities.building',
    'game.entities.door',
    'game.entities.window-b',
    'game.entities.brick',
    'game.entities.ralph',
    'game.entities.ledge',
    'game.entities.player',
    'game.config',
    'game.floor',
    'game.behavior',
    'game.utils',
    'game.xml-loader',
    'game.level-transition',
    'game.level',
    // 'impact.debug.debug',
    'game.entities.cloud'
)
.defines(function () {
    "use strict";
    ig.global.TestGame = ig.Game.extend({

        // Load a font



        init: function () {
            // Initialize your game here; bind keys etc.
            //do a test to see if dpawning entiteis causes FFOS leaks
            this.img = new ig.Image('media/25/door.png');
            /*for (var i = 0; i < 50; ++i) {
            this.ledge = this.spawnEntity(EntityLedge, 200, 200);
            }*/
            //this.level = new Floor(0);
        },

        update: function () {
            // Update all entities and backgroundMaps
            //ig.show("drawCnt", ig.Image.drawCount);
            this.parent();

            // Add your own, additional update code here
        },

        draw: function () {
            // Draw all entities and backgroundMaps

            this.parent();


            // Add your own drawing code here
            for (var i = 0; i < 50; ++i) {
                this.img.drawTile(i * 2, 200, 0, 48, 125, false, false);
            }
        }
    });
    ig.global.MyGame = ig.Game.extend({
        pauseCount: 0,
        music: new ig.Sound('media/audio/music.*'),
        soundFix: new ig.Sound('media/audio/fix.*'),
        soundEarthquake: new ig.Sound('media/audio/earthquake.*'),
        soundBreak: new ig.Sound('media/audio/break.*'),
        soundLevelComplete: new ig.Sound('media/audio/levelComplete.*'),
        soundPie: new ig.Sound('media/audio/pie.*'),
        soundBrick: new ig.Sound('media/audio/brick.*'),
        soundButton: new ig.Sound('media/audio/button.*'),
        soundFixButton: new ig.Sound('media/audio/lowButton.*'),
	soundButtonAndFix: new ig.Sound('media/audio/buttonAndFix.*'),
        gravity: 10, //turn on gravity
        floors: [],
        postDraw: undefined,
        init: function () {
            this.soundFixButton.volume = 0.5;
            // Initialize your game here; bind keys etc.
            //init keys, presumably this will change on a touch device
            //for now we are just using keyboard keys
            ig.input.bind(ig.KEY.RIGHT_ARROW, 'right');
            ig.input.bind(ig.KEY.LEFT_ARROW, 'left');
            ig.input.bind(ig.KEY.SPACE, 'fix');
            ig.input.bind(ig.KEY.UP_ARROW, 'up');
            ig.input.bind(ig.KEY.DOWN_ARROW, 'down');

            //init music


            ig.music.add(this.music);
            ig.music.volume = UI.Options.musicVolume;
            ig.soundManager.volume = UI.Options.soundVolume;
            //ig.music.play();
            ig.Sound.enabled = true;
	    document.getElementById("gamemusic").play();

            //spawn five(5) clouds
            for (var i = 0; i < 5; ++i) {
                this.spawnEntity(EntityCloud, IMG.SIZE(-300), IMG.SIZE(i * 300));
            }
            XmlLoader.init("resources/FixIt_Levels.xml");
            var startingLevel = UI.startLevel || 0;
            this.level = XmlLoader.parseXLevel(XmlLoader.getXLevel(XmlLoader.getXStage(0), startingLevel), 0);
            this.transition = new LevelTransition(this.level, startingLevel + 1);
            var ralphOpts = XmlLoader.parseXRalph(XmlLoader.getXLevel(XmlLoader.getXStage(0), startingLevel));
            Brick = XmlLoader.parseXBrick(XmlLoader.getXLevel(XmlLoader.getXStage(0), startingLevel));
            Brick.breakLock = false;
            /*var level = Level.init;
            level.prototype = Level;
            level = new level();
            level.floors[0].windows[1].spawnObstacle(Utils.directionsEnum.LEFT);
            level.getWindow({ floor: 1, window: 3 }).spawnObstacle(Utils.directionsEnum.DOWN);
            this.level = level;*/
            //var level2 = XmlLoader.parseXLevel(XmlLoader.getXLevel(XmlLoader.getXStage(0),1));

            this.player = this.spawnEntity(EntityPlayer, 0, 0);
            this.ralph = this.spawnEntity(EntityRalph, 4, 0);
            this.ralph.aiOptions = ralphOpts;
            //this.spawnEntityAt(EntityDoor, { x: ig.system.width / 2, y: ig.system.height });
            this.sortEntities();
            //this.loadLevel(LevelTest);

            //kick off the level timer
            UI.Timer.startTimer(60);
            UI.Timer.pauseTimer();

        },

        update: function () {

            // Update all entities and backgroundMaps
            var numBroken = this.transition.level.brokenWindows();
            if (numBroken === 0 && this.transition.hasStarted === false) {
                this.transition.cullEntities();
                this.level.pieSpawner.enabled = false;
                UI.addTimeScore();
                ig.game.soundLevelComplete.play();

                this.ralph.behavior = Behavior.levelTransition.bind(window, new ig.Timer(), this.ralph, this.player);
                this.transition.hasStarted = true
            } else if (numBroken !== 0 || this.transition.isEnding === true) {
                this.ralph.transitionLock = false;
                this.ralph.vel = { x: 0, y: 0 };
            }
            if (this.ralph.transitionLock) {
                if (!this.trnasitionStarted) {
                    this.transition.changeLevel();
                    this.transitionStarted = true;
                }
                this.ralph.pos = this.transition.getPositionOnNewLevel(this.ralph.gridPosition);
            }
            if (!this.transition.isEnding) {
                this.transition = this.transition.updateTransition();
                this.transitionStarted = false;
            }
            this.level = this.transition.level;

            this.parent();
            // Add your own, additional update code here
        },
        
        /**
         * playHammerSound
         * plays the hammer sound, can be played multiple times
         */
        playHammerSound:function(){
        	var hammerSound = new ig.Sound('media/audio/lowButton.*');
        	hammerSound.play();
        	
        },
        
        /**
         * playWindowFixSound
         * plays the window fix sound, can be played multiple times
         */
        playWindowFixSound:function(){
        	var windowFixSound = new ig.Sound('media/audio/buttonAndFix.*');
        	windowFixSound.play();
        },
        

        draw: function () {
            // Draw all entities and backgroundMaps
            this.parent();


            // Add your own drawing code here
            var x = ig.system.width / 2,
            y = ig.system.height / 2;

            //this.font.draw('It Works!', x, y, ig.Font.ALIGN.CENTER);
            if (this.postDraw !== undefined) {
                this.postDraw();
            }
        },
        run: function () {
            if (this.pauseCount <= 0) {
                this.parent();
            }
        }
    });



    //ig.main('#canvas', MyGame, 60, UI.Sizeing.calculateSize().x, UI.Sizeing.calculateSize().y, 1);

});
