// Object to help with movement, each instance of this object
// represents a movement for felix
ig.module(
    'game.movement'
)
.requires(
    'impact.timer',
    'impact.entity',
    'impact.system',
    'impact.impact',
    'game.movement-style',
    'game.config'
)
.defines(function () {
    "use strict"
    ig.global.Movement = function (start, end, time, style) {
        this.start = start;
        this.end = end;
        this.transitionTime = time;

        this.getPosition = getPosition;
        this.isDone = isDone;
        //relitive start and end positions
        var rStart = { x: 0, y: 0 };
        var rEnd = { x: this.end.x - this.start.x, y: this.end.y - this.start.y };
        var timer;
        var animStyle = {};

        //this whole deal could probably be simplified
        if (style !== undefined) {
            if (style.x || style.y) {
                animStyle.x = style.x || MovementStyle.linear;
                animStyle.y = style.y || MovementStyle.linear;
            } else {
                //style is just a function
                animStyle.x = style;
                animStyle.y = style;
            }
        } else {
            animStyle.x = MovementStyle.linear;
            animStyle.y = MovementStyle.linear;
        }
        //check if we are going up

        var goingUp = function () {
            if (rEnd.x === 0) {
                return true;
            } else {
                return false;
            }
        };
        function getPosition() {
            //we want to wait to start the timer
            //until we are actually called for the first time
            if (timer === undefined) {
                timer = new ig.Timer();
            }
            //empty object atm we set it in the following lines
            var retval = {};
            var animNorm = timer.delta() / time;
            retval.x = start.x + rEnd.x * animNorm + animStyle.x(animNorm);
            retval.y = start.y + rEnd.y * animNorm + animStyle.y(animNorm);
            //check if we are at our destination,
            //the check is different depending on the direction that we moved
            //also check the ease value to make sure we are in the general area of our destination
            if (animNorm >= 0.90) {
                if (rEnd.x > 0 && retval.x >= end.x) {
                    return end;
                } else if (rEnd.x < 0 && retval.x <= end.x) {
                    return end;
                } else if (rEnd.y > 0 && retval.y >= end.y) {
                    return end;
                } else if (rEnd.y < 0 && retval.y <= end.y) {
                    return end;
                } else if (animNorm >= 2) {
                    //this is an escape in case we miss our
                    //target, just give up after a while
                    return end;
                }
            }
            return retval;

        }
        function isDone() {
            if (start.x === end.x && start.y === end.y) {
                return true;
            } else if (getPosition() === end) {
                return true;
            } else {
                return false;
            }
        };
        //sets a new timer, really useful for testing
        this.setTimer = function(newTimer) {
            timer = newTimer;
        };

    };
});
