ig.module('game.people')
.requires(
    'game.entities.person',
    'game.movement'
)
.defines(function () {
    "use strict";
    ig.global.People = ig.Class.extend({
        entities: [],
        init: function () {

            for (var i = 0; i < 6; ++i) {
                this.entities.push(ig.game.spawnEntity(EntityPerson, 0, 0));
                this.entities[i].currentAnim = this.entities[i].anims[i];
                //move the entity so that all the people are in a row
                this.entities[i].pos.x = i * this.entities[i].size.x;
                //we want to move the men (first 3 poeple) a little bit so there
                //is that offset, this is a hack because artists
                if (i < 3) {
                    this.entities[i].pos.x -= (-1 * i + 4) * IMG.SIZE(10);
                }
            }


        },
        getPosition: function () {
            return this.entities[0].pos;
        },
        setPosition: function (x, y) {
            //when we set the groups position we need to go through and offset
            //each person
            for (var i = 0; i < this.entities.length; ++i) {
                this.entities[i].pos.x = x + i * this.entities[i].size.x;
                this.entities[i].pos.y = y;
                if (i < 3) {
                    this.entities[i].pos.x -= (-1 * i + 4) * IMG.SIZE(10);
                }
            }
        },
        setMovement: function (movement) {
            var initialStart = movement.start;
            var initialEnd = movement.end;
            for (var i = 0; i < this.entities.length; ++i) {

                var newStart = {
                    x: initialStart.x + i * this.entities[i].size.x,
                    y: initialStart.y
                };
                var newEnd = {
                    x: initialEnd.x + i * this.entities[i].size.x,
                    y: initialEnd.y
                };
                if (i < 3) {
                    newStart.x -= (-i + 4) * IMG.SIZE(10);
                    newEnd.x -= (-i + 4) * IMG.SIZE(10);
                }
                var movement = new Movement(newStart, newEnd, movement.transitionTime);
                this.entities[i].movement = movement;
            }
        },
        getSize: function () {
            var retval = {
                x: this.entities[0].size.x * this.entities.length,
                y: this.entities[0].size.y
            };
            return retval;
        },
        kill: function () {
            for (var i = 0; i < this.entities.length; ++i) {
                this.entities[i].kill();
            }
        }
    });
});
