ig.module('game.test')
.requires(
    'game.movement',
    'game.movement-style'
)
.defines(function () {
    "use strict";
    window.Test = function () {
        var tests = [];
        var testMovement = new Movement({ x: 0, y: 0 }, { x: 50, y: 50 }, 5, MovementStyle.linear);
        tests.push(new ChTest.Test("zeroTimeMovement", function () {
            var timer1 = { delta: function () { return 0; } };
            testMovement.setTimer(timer1);
            var position = testMovement.getPosition();
            return (position.x === 0 && position.y === 0);
        }, "test movement position at 0 sec"));

        tests.push(new ChTest.Test("fiveTimeMovement", function () {
            var timer = { delta: function () { return 5; } };
            testMovement.setTimer(timer);
            var position = testMovement.getPosition();
            return (position.x === 50 && position.y === 50)
        }, "test movement position at five seconds"));

        tests.push(new ChTest.Test("UniformMovement", function () {
            var timers = [];
            for (var i = 0; i < 5; ++i) {
                timers.push({ delta: function () { return i * (50 / 5); } });
            }
            var correctPosD = 50 / 5;
            var realD = [];
            for (var i = 0; i < 5; ++i) {
                testMovement.setTimer(timers[i]);
                if (realD[i - 1] !== undefined) {
                    var lastx = realD[i - 1].x;
                    var lasty = realD[i - 1].y;
                } else {
                    var lastx = 0;
                    var lasty = 0;
                }
                realD[i] = {
                    x: testMovement.getPosition().x - lastx,
                    y: testMovement.getPosition().y - lasty
                };
            }
            return realD.every(function (val) {
                return (val.x === correctPosD && val.y === correctPosD);
            })


        }, "test for uniform movement"));
        ChTest.runTests(tests);
    };
});