ig.module('game.utils')
.defines(function () {
    "use strict";
    ig.global.Utils = {
        //spawn an entity at position pos
        //pos is the location of the bottom middle
        //of the entity
        //|---|
        //|   |
        //|pos|
        spawnEntityAt: function (type, pos) {

            var ent = ig.game.spawnEntity(type, 0, 0);
            //move the spawned ent to the right position
            ent.pos = this.convertFromBottomCenterToCorner(ent, pos);
            return ent;
        },
        //find the position of the top corner of an entity given the
        //position of the bottom middle
        convertFromBottomCenterToCorner: function (entity, centerPos) {
            var retval = {
                x: centerPos.x - entity.size.x / 2,
                y: centerPos.y - entity.size.y
            };
            return retval;
        },
        convertFromCornerToCenter: function (entity, cornerPos) {
            var retval = {
                x: cornerPos.x + entity.size.x / 2,
                y: cornerPos.y + entity.size.y
            };
            return retval;
        },
        directionsEnum: {
            //WEEEEE lots of functions
            UP: {
                toString: function () {
                    return "up";
                },
                opposite: "down"
            },
            DOWN: {
                toString: function () {
                    return "down";
                },
                opposite: "up"
            },
            LEFT: {
                toString: function () {
                    return "left";
                },
                opposite: "right"
            },
            RIGHT: {
                toString: function () {
                    return "right";
                },
                opposite: "left"
            }

        }
    };
});
