"use strict";
window.ChTest = {
    //pass and fail are type synonyms for true and false
    pass: true,
    fail: false,
    draw: function (test, passed, extraString) {
        var title = document.createElement("span");
        title.className = "title";
        title.innerHTML = test.name + ": ";
        var result = document.createElement("span");
        result.className = "result";
        if (passed) {
            result.innerHTML = "PASS";
            result.style.color = "green";
        } else {
            result.innerHTML = "FAIL";
            result.style.color = "red";
        }
        var extra = document.createElement("span");
        extra.className = "extra";
        extra.innerHTML = " | " + extraString;
        var enclosingDiv = document.createElement("div");
        enclosingDiv.appendChild(title);
        enclosingDiv.appendChild(result);
        enclosingDiv.appendChild(extra);
        document.getElementById("testDiv").appendChild(enclosingDiv);

    },
    Test: function (name, testFn, description) {
        this.name = name;
        this.run = testFn();
        this.description = description;
        this.draw = function () {
            window.ChTest.draw(this, testFn(), description);
        }
    },
    //takes an array of tests
    runTests: function (tests) {
        for (var i = 0; i < tests.length; ++i) {
            tests[i].draw();
        }
    }
};