/* Ready: Document 
 * Descripcion: Carga las opciones generales de la aplicacion
 * @version 1.0
 * @since 2015-08-21
 */
$(document).ready(function () {

    // Variables generales
    var txt_origen = "#txt_origen";
    var txt_destino = "#txt_destino";

    // Carga de Funciones
    cambiar();
});


// Funciones
// -----------------------------------------------------------------------------


/* 
 * Funcion: cambiar   
 * Descripcion: Cambia los valores de input entrada en input salida
 * @param none
 * @return none
 * @version 1.0
 * @since 2015-08-21
 */
function cambiar() {
    $("#btn_cambiar").click(function () {

        // Entrada
        var texto = $(txt_origen).val();

        // Verifica Largo
        if (verificaLargo(texto) == true) {
            // Reemplazo
            salida = convertFlaite(texto);
            $(txt_destino).val(salida);
        }
    });
}

/* 
 * Funcion: verificaLargo   
 * Descripcion: Verifica si una cadena tiene al menos un caracter
 * @param texto
 * @return salida
 * @version 1.0
 * @since 2015-08-21
 */
function verificaLargo(texto) {

    salida = true;
    if (texto == '') {
        alert('Debe ingresar una frase a convertir');
        salida = false;
    }
    return salida;

}

/* 
 * Funcion: convertFlaite   
 * Descripcion: Convierte una cadena a texto flaite
 * @param texto
 * @return salida
 * @version 1.0
 * @since 2015-08-21
 */
function convertFlaite(texto) {

    var perv = 1;

    texto = texto.toLowerCase();
    texto = texto.replace(/hola/gi, "wena");
    texto = texto.replace(/mujer/gi, "bellaka");
    texto = texto.replace(/hombre/gi, "bellako");
    texto = texto.replace(/mina/gi, "washa");
    texto = texto.replace(/minitas/gi, "washitas");
    texto = texto.replace(/bakan/gi, "del korte");
    texto = texto.replace(/bacan/gi, "del korte");
    texto = texto.replace(/bkn/gi, "del korte");
    texto = texto.replace(/arregla/gi, "azicala");
    texto = texto.replace(/fino/gi, "fino y elegante");
    texto = texto.replace(/bailar/gi, "perrear");
    texto = texto.replace(/el pico/gi, "la cayampa");
    texto = texto.replace(/beso/gi, "kiss");
    texto = texto.replace(/besito/gi, "chupada");
    texto = texto.replace(/compadre/gi, "longui");
    texto = texto.replace(/en serio/gi, "la pulenta");
    texto = texto.replace(/en serio/gi, "la pulenta");
    texto = texto.replace(/cacha /gi, "sapea ");
    texto = texto.replace(/buena /gi, "wena ");
    texto = texto.replace(/destacado/gi, "connotado");
    texto = texto.replace(/script/gi, "scrip");
    texto = texto.replace(/facebook/gi, "feibu");
    texto = texto.replace(/vivo/gi, "vio");
    texto = texto.replace(/amigo/gi, "perro");
    texto = texto.replace(/amiga/gi, "perra");
    texto = texto.replace(/carrete/gi, "vacilon");
    texto = texto.replace(/internet/gi, "interneh");
    texto = texto.replace(/top/gi, "del one");
    texto = texto.replace(/senos/gi, "lo pesho");

    if (perv)
        texto = texto.toUpperCase();
    else
        texto = texto.toLowerCase();
    var last = texto.length;
    var result = "";
    var vowels = new Array('A', 'E', 'I', 'O', 'U');
    for (var i = 0; i < last; i++) {
        if (perv) {
            var isVowel = false;
            for (e in vowels) {
                if (vowels[e] == texto.charAt(i))
                    isVowel = true;
            }
            if (isVowel)
                result += caracterFlaite(texto.charAt(i).toLowerCase());
            else
                result += caracterFlaite(texto.charAt(i));
        }
        else
            result += caracterFlaite(texto.charAt(i));
    }
    if (result.length > 10) {
        if (!perv)
            result += ' \xF3\xE8z\xED\xED';
        else
            result += ' m\xE1Zn\xE1\xE1t\xE8d\xED\xEDgh\xF3 \xF3\xE8z\xED\xED';
    }
    return result;
}

/* 
 * Funcion: caracterFlaite   
 * Descripcion: Convierte un caracter a flaite
 * @param c
 * @return c
 * @version 1.0
 * @since 2015-08-21
 */
function caracterFlaite(c) {

    var perv = 1;

    if (c == 'a') {
        return '\xE1\xE1';
    }
    else if (c == 'e') {
        return '\xE8';
    }
    else if (c == 'i') {
        return '\xED\xED\xED';
    }
    else if (c == 'o') {
        return '\xF3';
    }
    else if (c == 'u') {
        return '\xFA\xFA';
    }

    if (perv) {
        if (c == 'S' || c == 's')
            return 'z';
        else if (c == 'H' || c == 'h')
            return '';
        else if (c == 'R' || c == 'r')
            return 'r';
        else if (c == 'V' || c == 'v')
            return 'b';
        else if (c == 'B' || c == 'b')
            return 'v';
    }

    return c;
}