var play_state = {

    // No more preload, since it is already done in the 'load' state

    create: function() { 
        var space_key = this.game.input;
        space_key.onDown.add(this.jump, this); 

        this.pipes = game.add.group();
        this.pipes.createMultiple(20, 'pipe');  
        this.timer = this.game.time.events.loop(2000, this.add_row_of_pipes, this);           

        this.bird = this.game.add.sprite(20, 245, 'bird');
        this.bird.body.gravity.y = 1000; 
        this.bird.anchor.setTo(-0.2, 0.5);
        
        // Not 'this.score', but just 'score'
        score = 0; 
        var style = { font: "30px Arial", fill: "#ffffff" };
        this.label_score = this.game.add.text(20, 20, "0", style); 

        this.jump_sound = this.game.add.audio('jump');
        this.crash_sound = this.game.add.audio('crash'); 
    },

    update: function() {
        if (this.bird.inWorld == false)
            this.restart_game(); 
			
			var score=this.label_score.content;
			if(score >3 && score < 7)
			{
       		if (this.bird.angle < 5)
            this.bird.angle += 1;
			}
			else if (score > 7)
			{
				
				if (this.bird.angle < 20)
                  this.bird.angle += 1;
			}
        this.game.physics.overlap(this.bird, this.pipes, this.hit_pipe, null, this);      
    },

    jump: function() {
        if (this.bird.alive == false)
            return; 

        this.bird.body.velocity.y = -350;
			var score=this.label_score.content;
			if(score >3  && score < 7)
			{
				
              this.game.add.tween(this.bird).to({angle: -5}, 1).start();
			}
			else if (score > 7)
			{
				
			 this.game.add.tween(this.bird).to({angle: -20}, 1).start();
			}
        this.jump_sound.play();
    },

    hit_pipe: function() {
        if (this.bird.alive == false){
            this.crash_sound.play();
            return;
        }

        this.bird.alive = false;
        this.game.time.events.remove(this.timer);

        this.pipes.forEachAlive(function(p){
            p.body.velocity.x = 0;
        }, this);
    },

    restart_game: function() {
        this.game.time.events.remove(this.timer);

        // This time we go back to the 'menu' state
        this.game.state.start('menu');
    },

    add_one_pipe: function(x, y) {
        var pipe = this.pipes.getFirstDead();
        pipe.reset(x, y);		
        pipe.body.velocity.x = -200; 
        pipe.outOfBoundsKill = true;
    },

    add_row_of_pipes: function() {		
        var hole = Math.floor(Math.random()*5)+1; // random from 1 to 5	
        for (var i = 0; i < 8; i++) // number of boxes to show on screen
            if (i != hole && i != hole +1) 
                this.add_one_pipe(w, i*60+10);   
        
        // Not 'this.score', but just 'score'
        score += 1; 
        this.label_score.content = score;  
    },
};