(function (body, canvas) {
        var score, player;

        var started = false;
        var width=350, height=400

        var ctx = canvas.getContext("2d");
        var loop_intervalms = 50;
        var gravity = 1.7, punt = -16;
        var tile_h = parseInt(height*0.11), tile_w = parseInt(tile_h/1.618);
        var start_value = 1;
        var sizecache = {}
        var size_si_cache = {}
        var pipes = []
        var tile_speed = 7;
        var best;
        var font_style ="px Roboto-Light";

        if (best == null) { 
                best=0;
            }

        function draw_number(num, x ,y) {
            if (num <=1024) {
                if (sizecache[num]) {
                    size = sizecache[num];
                } else {
                        var size = parseInt(tile_h*0.4)
                        ctx.font = size+font_style;
                        w = ctx.measureText(num).width;
                        if (w > tile_w-6) {
                            size = parseInt(size*(tile_w/w*0.9))
                        }
                        sizecache[num] = size;
                }
                ctx.font = size+font_style;
                ctx.textBaseline = 'bottom'
                w = ctx.measureText(num).width;
                ctx.fillText(num, x+(tile_w-w)/2, y-1, tile_w);
                ctx.textBaseline = 'top'
                w = ctx.measureText("3").width;
                ctx.fillText("3", x+(tile_w-w)/2, y, tile_w);
            } else {
                num = parseInt(Math.log(num) / Math.LN2);
                var mantissa, exponent;
                if (size_si_cache[num]) {
                    mantissa = size_si_cache[num][0];
                    exponent = size_si_cache[num][1];
                } else {
                    mantissa = parseInt(tile_h*0.35)
                    ctx.font = mantissa+"px sans-serif";
                    w = ctx.measureText("2").width;
                    if (w > tile_w-6) {
                        mantissa = parseInt(mantissa*(tile_w/w*0.9))
                    }

                    exponent = parseInt(tile_h*0.25)
                    ctx.font = exponent+font_style;
                    w = ctx.measureText(num).width;
                    if (w > tile_w-6-mantissa) {
                        exponent = parseInt(exponent*(tile_w/(w+mantissa)*0.9))
                    }

                    size_si_cache[num] = [mantissa, exponent];
                }
                ctx.font = mantissa+font_style;
                w_man = ctx.measureText("2").width;

                ctx.font = exponent+font_style;
                w_exp = ctx.measureText(num).width;

                w=w_man+w_exp;

                ctx.textBaseline = 'bottom'
                ctx.font = mantissa+font_style;
                ctx.fillText("2", x+(tile_w-w)/2, y-1, tile_w);

                ctx.textBaseline = 'bottom'
                ctx.font = exponent+font_style;
                ctx.fillText(num, x+w_exp-2+(tile_w-w)/2, y-exponent-(mantissa/5), tile_w);

                ctx.textBaseline = 'top'
                ctx.font = mantissa+font_style;
                w = ctx.measureText("3").width;
                ctx.fillText("3", x+(tile_w-w)/2, y, tile_w);

            }
            ctx.fillRect(x+3, y-2, tile_w-6, 1);
        }
        function drawRoundRect(x,y,w,h) {
            var radius = 5
            ctx.beginPath();
            ctx.moveTo(x + radius, y);
            ctx.lineTo(x + w - radius, y);
            ctx.quadraticCurveTo(x + w, y, x + w, y + radius);
            ctx.lineTo(x + w, y + h - radius);
            ctx.quadraticCurveTo(x + w, y + h, x + w - radius, y + h);
            ctx.lineTo(x + radius, y + h);
            ctx.quadraticCurveTo(x, y + h, x, y + h - radius);
            ctx.lineTo(x, y + radius);
            ctx.quadraticCurveTo(x, y, x + radius, y);
            ctx.closePath();
            ctx.stroke();
            ctx.fill();
        }
        function draw_text(text, baseline) {

            ctx.font = "40px Roboto-Light";
            ctx.textBaseline = baseline || 'middle';
            var w = ctx.measureText(text).width;

            ctx.fillStyle = ctx.strokeStyle = 'rgba(255,255,255,0.1)';
            ctx.lineJoin = 'round';
            ctx.lineWidth=5;
            ctx.fillRect((width-w)/2, height/2-20, w, 40);

            ctx.fillStyle='black';
            ctx.fillText(text, (width-w)/2, height/2);

            ctx.restore();
       }

        function shuffleArray(array) {
            for (var i = array.length - 1; i > 0; i--) {
                var j = Math.floor(Math.random() * (i + 1));
                var temp = array[i];
                array[i] = array[j];
                array[j] = temp;
            }
            return array;
        }


        function Tile(x, y, n) {
            this.x = x;
            this.y = y;
            this.value = n

            this.draw = function draw(ctx) {
                ctx.save();
                ctx.strokeStyle = 'black';
                ctx.fillStyle = 'white';
                ctx.lineWidth = 3;
                drawRoundRect(this.x, this.y, tile_w, tile_h);

                ctx.fillStyle = 'black';
        y = this.y + tile_h/2;
                draw_number(this.value, this.x, y);
                ctx.restore();
            }

            this.collide = function collide(other) {
                return (this.x < other.x+tile_w &&
                        this.x+tile_w > other.x && 
                        this.y < other.y+tile_h &&
                        this.y+tile_h > other.y);
            }

            this.move = function move() {
                this.x -= tile_speed;
                return this.x + tile_w > 0;
            }
        }

        function Player(x, y) {
            Tile.call(this, x, y, start_value);
            this.velocity = 0;
                
            this.punt = function (scale) {
                   this.velocity = scale ? (scale*punt) : (punt)
            }

            this.update = function update() {
                this.velocity = this.velocity + gravity;
                this.y = this.y + this.velocity;
                if (this.y < 0) {this.y =0}
                if (this.y+tile_h > height) {this.y = height-tile_h}
            }

            this.alive = function alive() {
                return this.y > 0 && this.y+tile_h < height;
            }
        }
            
        // Set up canvas, global state. Called at beginning & before new game.

        function reset() {
            canvas.height = height; 
            canvas.width = width;
            score = 0;
            player = new Player(width/4-tile_w/2, height/2- tile_h/2);
            pipes = []
            new_pipe()
        }

        function new_pipe() {
            if (pipes.length == 0) { 
                score++;
                var arr = shuffleArray([0,1,2,4]);
                for (var i=0; i<4; i++) {
                    var m = arr[i];
                    if (m) {
                        var y = -20+height/4.5*(i+1)-tile_h/2 ;
                        pipes.push(new Tile(width-tile_w, y, player.value*m))
                    }
                }
            }

            best = window.localStorage.getItem('best');
            

            if (best < player.value*score) { 
                best=player.value*score;
            }
            
            window.localStorage.setItem('best', best);
        }

        // State of Game.

        function start_screen() {

            ctx.clearRect(0, 0, width, height);
            player.draw(ctx);

            window.ontouchstart = window.onmousedown = function tap(e) {
                started = true;
            }
            window.onkeydown = function tap(e) {
                k = window.event ? e.keyCode : e.which;
                if (k == 38) { started = true };
            }
            start_loop();
        }

        function death_screen() {

            ctx.clearRect(0, 0, width, height);

            for (var i=0; i<pipes.length; i++){
                pipes[i].draw(ctx);
            }

            player.draw(ctx);

            started = false;
            

            var score_text = "Puntos: "+player.value*score;
            var best_text = "Mejor: "+best;
            draw_text(score_text, 'bottom')
            draw_text(best_text, 'top');
            ctx.save();


            window.ontouchstart = window.onmousedown = function tap(e) {
                reset();
                start_screen();
            }
            window.onkeydown = function tap(e) {
                k = window.event ? e.keyCode : e.which;
                if (k == 38) {
                    reset();
                    start_screen();
                }
            }
        }

        function play_screen() {
            window.ontouchstart = window.onmousedown = function tap(e) {
                player.punt();
            }
            window.onkeydown = function tap(e) {
                k = window.event ? e.keyCode : e.which;
                if (k == 38) {
                    player.punt();
                }
            }
            play_loop();
        }

        function start_loop() {
            ctx.clearRect(0,0,width,height);
            draw_text('Flappy Thirds', 'bottom')
            draw_text('Toca y empieza', 'top');
            player.update();

            if (player.y > 0.6*height) {
                player.punt(0.5);
    player.value=player.value*2
    if (player.value > 262144) {
      player.value =1;
    }
            }
            player.draw(ctx);
        
            if (started) {
        player.value = 1;
                play_screen();
            } else {
                setTimeout(start_loop, loop_intervalms);
            }
        }

        function play_loop() {
            ctx.clearRect(0,0,width,height);
            player.update();

            var alive = player.alive();
            var new_pipes = []
            for (var i=0; i<pipes.length; i++){
                var p = pipes[i]
                if (p.move()) {
                    if (player.collide(p)) {
                        if (alive && player.value == p.value) {
                            player.value*=2;
                        } else {
              new_pipes.push(p);
                            alive = false;
                        }
                    } else {
                        new_pipes.push(p);
                    }
                }
                p.draw(ctx)
            }
            pipes = new_pipes
            new_pipe()


            player.draw(ctx);
        
            if (alive) {
                setTimeout(play_loop, loop_intervalms);
            } else {
                death_screen()
            }
        }
        reset();
        start_screen();

        })
(document.getElementById('content'),document.getElementById('flappy-thirds'));

