/*
	meSpeak  v.1.9.7.1
	based on speak.js, https://github.com/kripken/speak.js
	eSpeak and other code here are under the GNU GPL.
	meSpeak (Modular eSpeak) is a mod of 'speak.js' by N.Landsteiner (2011-2015), www.masswerk.at
	adding support for Webkit/Safari and external voice-modules
	v.1.1 and later default to play via the Web Audio API and uses the HTMLAudioElement as a second option.
	official project page: http://www.masswerk.at/mespeak
*/
var meSpeak=(function(){"use strict";function ESpeak(){var vprint=(self.console)?console.log:function(){};var Module={noInitialRun:true};"use strict";if(!Module.arguments){try{Module.arguments=arguments;}catch(e){Module.arguments=[];}}
var Runtime={stackSave:function(){return STACKTOP;},stackRestore:function(stackTop){STACKTOP=stackTop;},forceAlign:function(target,quantum){quantum=quantum||4;if(isNumber(target)&&isNumber(quantum)){return Math.ceil(target/quantum)*quantum;}else{return'Math.ceil(('+target+')/'+quantum+')*'+quantum;}},isNumberType:function(type){return type in Runtime.INT_TYPES||type in Runtime.FLOAT_TYPES;},isPointerType:function isPointerType(type){return pointingLevels(type)>0;},isStructType:function isStructType(type){if(isPointerType(type))return false;if(new RegExp(/^\[\d+\ x\ (.*)\]/g).test(type))return true;if(new RegExp(/<?{ [^}]* }>?/g).test(type))return true;return!Runtime.isNumberType(type)&&type[0]=='%';},INT_TYPES:{"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},FLOAT_TYPES:{"float":0,"double":0},or64:function(x,y){var l=(x|0)|(y|0);var h=(Math.round(x/4294967296)|Math.round(y/4294967296))*4294967296;return l+h;},and64:function(x,y){var l=(x|0)&(y|0);var h=(Math.round(x/4294967296)&Math.round(y/4294967296))*4294967296;return l+h;},xor64:function(x,y){var l=(x|0)^(y|0);var h=(Math.round(x/4294967296)^Math.round(y/4294967296))*4294967296;return l+h;},getNativeFieldSize:function getNativeFieldSize(type){return Math.max(Runtime.getNativeTypeSize(type),4);},getNativeTypeSize:function getNativeTypeSize(type){if(4==1)return 1;var size={'_i1':1,'_i8':1,'_i16':2,'_i32':4,'_i64':8,"_float":4,"_double":8}['_'+type];if(!size&&type[type.length-1]=='*'){size=4;}
return size;},dedup:function dedup(items,ident){var seen={};if(ident){return items.filter(function(item){if(seen[item[ident]])return false;seen[item[ident]]=true;return true;});}else{return items.filter(function(item){if(seen[item])return false;seen[item]=true;return true;});}},set:function set(){var args=typeof arguments[0]==='object'?arguments[0]:arguments;var ret={};for(var i=0;i<args.length;i++){ret[args[i]]=0;}
return ret;},calculateStructAlignment:function calculateStructAlignment(type){type.flatSize=0;type.alignSize=0;var diffs=[];var prev=-1;type.flatIndexes=type.fields.map(function(field){var size,alignSize;if(Runtime.isNumberType(field)||Runtime.isPointerType(field)){size=Runtime.getNativeTypeSize(field);alignSize=size;}else if(Runtime.isStructType(field)){size=Types.types[field].flatSize;alignSize=Types.types[field].alignSize;}else{dprint('Unclear type in struct: '+field+', in '+type.name_+' :: '+dump(Types.types[type.name_]));assert(0);}
alignSize=type.packed?1:Math.min(alignSize,4);type.alignSize=Math.max(type.alignSize,alignSize);var curr=Runtime.alignMemory(type.flatSize,alignSize);type.flatSize=curr+size;if(prev>=0){diffs.push(curr-prev);}
prev=curr;return curr;});type.flatSize=Runtime.alignMemory(type.flatSize,type.alignSize);if(diffs.length==0){type.flatFactor=type.flatSize;}else if(Runtime.dedup(diffs).length==1){type.flatFactor=diffs[0];}
type.needsFlattening=(type.flatFactor!=1);return type.flatIndexes;},generateStructInfo:function(struct,typeName,offset){var type,alignment;if(typeName){offset=offset||0;type=(typeof Types==='undefined'?Runtime.typeInfo:Types.types)[typeName];if(!type)return null;if(!struct)struct=(typeof Types==='undefined'?Runtime:Types).structMetadata[typeName.replace(/.*\./,'')];if(!struct)return null;assert(type.fields.length===struct.length,'Number of named fields must match the type for '+typeName+'. Perhaps due to inheritance, which is not supported yet?');alignment=type.flatIndexes;}else{var type={fields:struct.map(function(item){return item[0]})};alignment=Runtime.calculateStructAlignment(type);}
var ret={__size__:type.flatSize};if(typeName){struct.forEach(function(item,i){if(typeof item==='string'){ret[item]=alignment[i]+offset;}else{var key;for(var k in item)key=k;ret[key]=Runtime.generateStructInfo(item[key],type.fields[i],alignment[i]);}});}else{struct.forEach(function(item,i){ret[item[1]]=alignment[i];});}
return ret;},stackAlloc:function stackAlloc(size){var ret=STACKTOP;_memset(STACKTOP,0,size);STACKTOP+=size;STACKTOP=Math.ceil((STACKTOP)/4)*4;;return ret;},staticAlloc:function staticAlloc(size){var ret=STATICTOP;STATICTOP+=size;STATICTOP=Math.ceil((STATICTOP)/4)*4;;return ret;},alignMemory:function alignMemory(size,quantum){var ret=size=Math.ceil((size)/(quantum?quantum:4))*(quantum?quantum:4);;return ret;},__dummy__:0}
var CorrectionsMonitor={MAX_ALLOWED:0,corrections:0,sigs:{},note:function(type,succeed,sig){if(!succeed){this.corrections++;if(this.corrections>=this.MAX_ALLOWED)abort('\n\nToo many corrections!');}},vprint:function(){var items=[];for(var sig in this.sigs){items.push({sig:sig,fails:this.sigs[sig][0],succeeds:this.sigs[sig][1],total:this.sigs[sig][0]+this.sigs[sig][1]});}
items.sort(function(x,y){return y.total-x.total;});for(var i=0;i<items.length;i++){var item=items[i];vprint(item.sig+' : '+item.total+' hits, %'+(Math.ceil(100*item.fails/item.total))+' failures');}}};function cRound(x){return x>=0?Math.floor(x):Math.ceil(x);}
var __globalConstructor__=function globalConstructor(){};var __THREW__=false;var __ATEXIT__=[];var ABORT=false;var undef=0;var tempValue,tempInt,tempBigInt;function abort(text){vprint(text+':\n'+(new Error).stack);ABORT=true;throw"Assertion: "+text;}
function assert(condition,text){if(!condition){abort('Assertion failed: '+text);}}
function setValue(ptr,value,type){if(type[type.length-1]==='*')type='i32';switch(type){case'i1':HEAP8[(ptr)]=value;;break;case'i8':HEAP8[(ptr)]=value;;break;case'i16':HEAP16[((ptr)>>1)]=value;;break;case'i32':HEAP32[((ptr)>>2)]=value;;break;case'i64':HEAP32[((ptr)>>2)]=value;;break;case'float':HEAPF32[((ptr)>>2)]=value;;break;case'double':HEAPF32[((ptr)>>2)]=value;;break;default:abort('invalid type for setValue: '+type);}}
Module.setValue=setValue;function getValue(ptr,type){if(type[type.length-1]==='*')type='i32';switch(type){case'i1':return HEAP8[(ptr)];case'i8':return HEAP8[(ptr)];case'i16':return HEAP16[((ptr)>>1)];case'i32':return HEAP32[((ptr)>>2)];case'i64':return HEAP32[((ptr)>>2)];case'float':return HEAPF32[((ptr)>>2)];case'double':return HEAPF32[((ptr)>>2)];default:abort('invalid type for setValue: '+type);}
return null;}
Module.getValue=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;Module.ALLOC_NORMAL=ALLOC_NORMAL;Module.ALLOC_STACK=ALLOC_STACK;Module.ALLOC_STATIC=ALLOC_STATIC;function allocate(slab,types,allocator){var zeroinit,size;if(typeof slab==='number'){zeroinit=true;size=slab;}else{zeroinit=false;size=slab.length;}
var ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc][typeof allocator==='undefined'?ALLOC_STATIC:allocator](Math.max(size,1));var singleType=typeof types==='string'?types:null;var i=0,type;while(i<size){var curr=zeroinit?0:slab[i];if(typeof curr==='function'){curr=Runtime.getFunctionIndex(curr);}
type=singleType||types[i];if(type===0){i++;continue;}
setValue(ret+i,curr,type);i+=Runtime.getNativeTypeSize(type);}
return ret;}
Module.allocate=allocate;function Pointer_stringify(ptr){var ret="";var i=0;var t;var nullByte=String.fromCharCode(0);while(1){t=String.fromCharCode(HEAPU8[(ptr+i)]);if(t==nullByte){break;}else{}
ret+=t;i+=1;}
return ret;}
Module.Pointer_stringify=Pointer_stringify;function Array_stringify(array){var ret="";for(var i=0;i<array.length;i++){ret+=String.fromCharCode(array[i]);}
return ret;}
Module.Array_stringify=Array_stringify;var FUNCTION_TABLE;var PAGE_SIZE=4096;function alignMemoryPage(x){return Math.ceil(x/PAGE_SIZE)*PAGE_SIZE;}
var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32;var STACK_ROOT,STACKTOP,STACK_MAX;var STATICTOP;var HAS_TYPED_ARRAYS=false;var TOTAL_MEMORY=Module.TOTAL_MEMORY||52428800;var FAST_MEMORY=Module.FAST_MEMORY||2097152;HAS_TYPED_ARRAYS=false;try{HAS_TYPED_ARRAYS=!!Int32Array&&!!Float32Array&&!!(new Int32Array(1).subarray);}catch(e){}
if(HAS_TYPED_ARRAYS){var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,'Typed arrays 2 must be run on a little-endian system');}else
{abort('Cannot fallback to non-typed array case in USE_TYPED_ARRAYS == 2: Code is too specialized');}
var base=intArrayFromString('(null)');for(var i=0;i<base.length;i++){HEAP8[(i)]=base[i];}
Module.HEAP=HEAP;Module.HEAP8=HEAP8;Module.HEAP16=HEAP16;Module.HEAP32=HEAP32;Module.HEAPU8=HEAPU8;Module.HEAPU16=HEAPU16;Module.HEAPU32=HEAPU32;Module.HEAPF32=HEAPF32;STACK_ROOT=STACKTOP=alignMemoryPage(10);var TOTAL_STACK=1024*1024;STACK_MAX=STACK_ROOT+TOTAL_STACK;STATICTOP=alignMemoryPage(STACK_MAX);function __shutdownRuntime__(){while(__ATEXIT__.length>0){var atexit=__ATEXIT__.pop();var func=atexit.func;if(typeof func==='number'){func=FUNCTION_TABLE[func];}
func(typeof atexit.arg==='undefined'?null:atexit.arg);}
CorrectionsMonitor.vprint();}
function Array_copy(ptr,num){if(HAS_TYPED_ARRAYS){return Array.prototype.slice.call(HEAP8.subarray(ptr,ptr+num));}else{return HEAP8.slice(ptr,ptr+num);}
return HEAP.slice(ptr,ptr+num);}
Module.Array_copy=Array_copy;function String_len(ptr){var i=0;while(HEAP8[(ptr+i)])i++;return i;}
Module.String_len=String_len;function String_copy(ptr,addZero){var len=String_len(ptr);if(addZero)len++;var ret=Array_copy(ptr,len);if(addZero)ret[len-1]=0;return ret;}
Module.String_copy=String_copy;if(typeof self.console==='object'&&typeof console.log==='function'){this.vprint=function(x){console.log(x)};}else if(typeof vprint==='undefined'){this.vprint=function(){};}
function intArrayFromString(stringy,dontAddNull){var ret=[];var t;var i=0;while(i<stringy.length){var chr=stringy.charCodeAt(i);if(chr>0xFF){chr&=0xFF;}
ret.push(chr);i=i+1;}
if(!dontAddNull){ret.push(0);}
return ret;}
Module.intArrayFromString=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>0xFF){chr&=0xFF;}
ret.push(String.fromCharCode(chr));}
return ret.join('');}
Module.intArrayToString=intArrayToString;function unSign(value,bits,ignore,sig){if(value>=0){return value;}
return bits<=32?2*Math.abs(1<<(bits-1))+value:Math.pow(2,bits)+value;}
function reSign(value,bits,ignore,sig){if(value<=0){return value;}
var half=bits<=32?Math.abs(1<<(bits-1)):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value;}
return value;}
Runtime.QUANTUM_SIZE=4
var $struct___sFILE___SIZE=104;var $struct___sFILE___FLATTENER=[0,4,8,12,14,16,24,28,32,36,40,44,48,56,60,64,67,68,76,80,84,88,92,100];var $struct___sbuf___SIZE=8;var $struct__reent___SIZE=1060;var $struct__reent___FLATTENER=[0,4,8,12,16,20,48,52,56,60,64,68,72,76,80,84,88,328,332,732,736,748];var $struct__Bigint___SIZE=24;var $union_anon_0___SIZE=240;var $struct_anon_1___SIZE=240;var $struct__atexit___SIZE=400;var $struct__atexit___FLATTENER=[0,4,8,136];var $struct__on_exit_args___SIZE=264;var $struct__on_exit_args___FLATTENER=[0,128,256,260];var $struct__glue___SIZE=12;var $struct__mbstate_t___SIZE=8;var $union_anon___SIZE=4;var $struct_option___SIZE=16;var $struct_MNEM_TAB___SIZE=8;var $struct_MatchRecord___SIZE=16;var $struct_TUNE___SIZE=68;var $struct_TUNE___FLATTENER=[0,12,16,24,25,26,27,28,29,30,31,32,33,34,35,36,39,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,64];var $struct_SYLLABLE___SIZE=6;var $struct_TONE_HEAD___SIZE=16;var $struct_TONE_HEAD___FLATTENER=[0,1,2,3,4,8,9,10,12];var $struct_SSML_STACK___SIZE=76;var $struct_SSML_STACK___FLATTENER=[0,4,8,12,16,56];var $struct_PARAM_STACK_45___SIZE=64;var $struct_ACCENTS___SIZE=8;var $struct_MBROLA_TAB___SIZE=24;var $struct_PHONEME_TAB___SIZE=16;var $struct_PHONEME_TAB___FLATTENER=[0,4,8,10,11,12,13,14,15];var $struct_PHONEME_TAB_LIST_106___SIZE=48;var $struct_PHONEME_TAB_LIST_106___FLATTENER=[0,32,36,40,44];var $struct_frameref_t___SIZE=8;var $struct_frame_t___SIZE=64;var $struct_frame_t___FLATTENER=[0,2,16,17,18,26,32,35,39,44,49,56,63];var $struct_PHONEME_DATA___SIZE=152;var $struct_PHONEME_DATA___FLATTENER=[0,4,68,88,108,124,128,132];var $struct_PHONEME_LIST___SIZE=24;var $struct_PHONEME_LIST___FLATTENER=[0,1,2,3,4,6,8,12,14,15,16,17,18,19,20,21];var $struct_SPEED_FACTORS___SIZE=64;var $struct_voice_t___SIZE=1344;var $struct_voice_t___FLATTENER=[0,40,44,48,52,56,60,64,68,72,76,80,84,88,92,96,100,104,108,112,144,162,180,198,216,234,252,272,308,344];var $struct_SOUND_ICON___SIZE=16;var $struct_Translator___SIZE=8328;var $struct_Translator___FLATTENER=[0,280,284,288,292,332,632,652,656,660,668,676,692,696,700,704,708,964,968,1000,1048,1052,1056,5152,5256,6280,6792,7272,7752,7756,8012,8268,8272,8276,8280,8284,8288,8292,8296,8300,8304,8308,8312,8316,8320,8324];var $struct_LANGUAGE_OPTIONS___SIZE=280;var $struct_LANGUAGE_OPTIONS___FLATTENER=[0,4,8,12,16,20,24,100,176,180,184,188,192,196,200,204,208,212,216,220,224,228,232,240,244,248,249,250,251,252,256,260,264,268,272,276];var $struct_PHONEME_LIST2___SIZE=8;var $struct_PHONEME_LIST2___FLATTENER=[0,1,2,3,4,6];var $struct_REPLACE_PHONEMES___SIZE=3;var $struct_datablock___SIZE=16;var $struct_espeak_VOICE___SIZE=24;var $struct_espeak_VOICE___FLATTENER=[0,4,8,12,13,14,15,16,20];var $struct_wavegen_peaks_t___SIZE=80;var $struct_wavegen_peaks_t___FLATTENER=[0,4,8,12,16,24,32,40,48,56,64,72];var $struct_RESONATOR___SIZE=40;var $struct_WGEN_DATA___SIZE=64;var $struct_sonicStreamStruct___SIZE=88;var $struct_klatt_frame_t___SIZE=288;var $struct_klatt_frame_t___FLATTENER=[0,4,8,48,88,128,168,172,176,180,184,188,192,196,200,204,208,248];var $struct_klatt_global_t___SIZE=2748;var $struct_klatt_global_t___FLATTENER=[0,4,8,12,16,20,24,28,32,36,40,44,48,52,56,64,72,80,88,96,104,112,120,128,136,144,152,160,164,172,176,180,184,188,1468];var $struct_resonator_t___SIZE=64;var $struct_klatt_peaks_t___SIZE=80;var $struct_klatt_peaks_t___FLATTENER=[0,4,8,12,16,24,32,40,48,56,64,72];var $struct_frame_t_199___SIZE=64;var $struct_frame_t_199___FLATTENER=[0,2,16,17,18,26,32,35,39,44,49,56,63];var $struct_stat___SIZE=80;var $struct_stat___FLATTENER=[0,8,12,16,20,24,28,36,40,44,48,52,56,60,64,68,72];var $struct_PARAM_STACK___SIZE=64;var $struct_PHONEME_TAB_LIST___SIZE=48;var $struct_PHONEME_TAB_LIST___FLATTENER=[0,32,36,40,44];var $struct_PHONEME_TAB_11___SIZE=16;var $struct_PHONEME_TAB_11___FLATTENER=[0,4,8,10,11,12,13,14,15];var $struct_RGROUP___SIZE=28;var $struct_RGROUP___FLATTENER=[0,16,20,24];var $struct_WORD_TAB___SIZE=12;var $struct_WORD_TAB___FLATTENER=[0,4,6,8,9,10];var $struct_PHONEME_TAB_LIST_25___SIZE=48;var $struct_PHONEME_TAB_LIST_25___FLATTENER=[0,32,36,40,44];var $struct_WORD_TAB_29___SIZE=12;var $struct_WORD_TAB_29___FLATTENER=[0,4,6,8,9,10];var $struct_Translator_33___SIZE=8328;var $struct_Translator_33___FLATTENER=[0,280,284,288,292,332,632,652,656,660,668,676,692,696,700,704,708,964,968,1000,1048,1052,1056,5152,5256,6280,6792,7272,7752,7756,8012,8268,8272,8276,8280,8284,8288,8292,8296,8300,8304,8308,8312,8316,8320,8324];var $struct_LANGUAGE_OPTIONS_32___SIZE=280;var $struct_LANGUAGE_OPTIONS_32___FLATTENER=[0,4,8,12,16,20,24,100,176,180,184,188,192,196,200,204,208,212,216,220,224,228,232,240,244,248,249,250,251,252,256,260,264,268,272,276];var $struct_TONE_NUCLEUS___SIZE=16;var $struct_TONE_NUCLEUS___FLATTENER=[0,1,2,3,4,5,8,12,13,14];var $struct_PARAM_STACK_54___SIZE=64;var $struct_FMT_PARAMS___SIZE=48;var $struct_FMT_PARAMS_111___SIZE=48;var $struct_SPECT_SEQ___SIZE=1104;var $struct_SPECT_SEQ___FLATTENER=[0,2,3,4];var $struct_frame_t2___SIZE=44;var $struct_frame_t2___FLATTENER=[0,2,16,17,18,26,32,35,39];var $struct_SPECT_SEQK___SIZE=1604;var $struct_SPECT_SEQK___FLATTENER=[0,2,3,4];var $struct_pollfd___SIZE=8;var $struct_pollfd___FLATTENER=[0,4,6];var $struct_dirent___SIZE=1040;var $struct_dirent___FLATTENER=[0,4,1028,1032,1036];var $struct_getopt_data___SIZE=20;var _path_home;var _filetype;var _wavefile;var _uri_callback;var _phoneme_callback;var _f_wave;var _quiet;var _samples_total;var _samples_split;var _wavefile_count;var _end_of_sentence;var _voice_pcnt;var __impure_ptr;var __ZZ13DisplayVoicesP7__sFILEPcE7genders;var __str1;var __str3;var __str4;var __str5;var __ZZ4mainE12long_options;var __str6;var __str7;var __str8;var __str9;var __str10;var __str11;var __str12;var __str13;var __str14;var __str15;var __str16;var __str17;var __str18;var __str19;var __str21;var __str23;var __str25;var __str27;var __str28;var __str29;var __str30;var __ZZL12OpenWaveFilePKciE8wave_hdr;var __str32;var __str33;var __str35;var __str36;var __str37;var __str38;var __str39;var __str40;var __str41;var __ZL5f_log;var __str42;var __str143;var __str244;var __str345;var __str446;var __str547;var __str648;var _mnem_rules;var __str749;var __str850;var __str951;var __str1052;var __str1153;var __str1254;var __str1355;var __str1456;var __str1557;var __str1658;var __str1759;var __str1860;var __str1961;var __str2062;var __str2163;var __str2264;var __str2365;var __str2466;var __str2567;var __str2668;var __str2769;var __str2870;var __str2971;var __str3072;var __str3173;var __str3274;var __str3375;var __str3476;var __str3577;var __str3678;var __str3779;var __str3880;var __str3981;var __str4082;var __str4183;var __str4284;var __str43;var __str44;var __str45;var __str46;var __str47;var __str48;var __str49;var __str50;var __str51;var __str52;var __str53;var __str54;var __str55;var __str56;var __str57;var _mnem_flags;var __ZZ22print_dictionary_flagsPjE3buf;var __str59;var __ZZ10DecodeRulePKciPciE6output;var __ZZ10DecodeRulePKciPciE7symbols;var __ZZ10DecodeRulePKciPciE10symbols_lg;var __str60;var __str61;var __str62;var __str64;var __str65;var __ZL11error_count;var __ZL21error_need_dictionary;var __ZL19letterGroupsDefined;var __ZL10debug_flag;var __str66;var __str67;var __str69;var __str71;var __str72;var __str73;var __str74;var __str75;var __str76;var __str77;var __str78;var __ZL7linenum;var __ZL10group_name;var __str79;var __ZL9group3_ix;var __str81;var __str82;var __str83;var __str84;var __str85;var __str89;var __ZL9rule_cond;var __ZL8rule_pre;var __ZL9rule_post;var __ZL10rule_match;var __ZL13rule_phonemes;var __str90;var __str91;var __str92;var __str93;var __str94;var __str95;var __ZZL16copy_rule_stringPcRiE6outbuf;var __ZZL16copy_rule_stringPcRiE10next_state;var __ZZL16copy_rule_stringPcRiE16lettergp_letters;var __str97;var __str98;var __str99;var __str100;var __str101;var __str102;var __str103;var __ZL11hash_chains;var __ZL11hash_counts;var __ZL9text_mode_b;var __str104;var __str106;var __str107;var __ZZL12compile_linePcS_PiE10nullstring;var __str108;var __str109;var __str110;var __str111;var __str112;var __str113;var __str114;var __str115;var _dictionary_skipwords;var _dictionary_name;var __ZL13remove_accent;var __str116;var __str2118;var __str3119;var __str4120;var __str5121;var __str7123;var _ipa1;var __str8124;var __str9125;var __ZL15stress_phonemes;var __ZZ13SetWordStressP10TranslatorPcPjiiE15consonant_types;var __ZZ13SetWordStressP10TranslatorPcPjiiE8guess_ru;var __ZZ13SetWordStressP10TranslatorPcPjiiE10guess_ru_v;var __ZZ13SetWordStressP10TranslatorPcPjiiE10guess_ru_t;var __ZZ14TranslateRulesP10TranslatorPcS1_iS1_iPjE9str_pause;var __str10126;var __str11127;var __ZL13diereses_list;var __ZZ14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TABE16word_replacement;var __str15131;var __str16132;var __ZZ11LookupFlagsP10TranslatorPKcE5flags;var __ZZ12RemoveEndingP10TranslatorPciS1_E6ending;var __ZZ12RemoveEndingP10TranslatorPciS1_E16add_e_exceptions;var __str17133;var __ZZ12RemoveEndingP10TranslatorPciS1_E15add_e_additions;var __str18134;var __str19135;var __str20136;var __str21137;var __str22138;var __str23139;var __str24140;var __str25141;var __str27143;var __str28144;var __str29145;var __str30146;var __str31147;var __ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best;var __str32148;var __str34150;var _env_fall;var _env_rise;var _env_frise;var __ZL11env_r_frise;var __ZL10env_frise2;var __ZL12env_r_frise2;var __ZL12env_risefall;var __ZL13env_fallrise3;var __ZL13env_fallrise4;var __ZL9env_fall2;var __ZL9env_rise2;var __ZL16env_risefallrise;var _envelope_data;var __ZL18tone_nucleus_table;var _punctuation_to_tone;var _n_tunes;var _tunes;var __ZL12syllable_tab;var __ZL8no_tonic_b;var __ZL15tone_head_table;var __ZL10number_pre;var __ZL10tone_posn2;var __ZL9tone_posn;var __ZL11number_tail;var __ZL14tone_pitch_env;var __ZZL18calc_pitch_segmentiiP9TONE_HEADP12TONE_NUCLEUSiiE12continue_tab;var __ZL8min_drop;var __ZL7drops_0;var __ZL5oflow;var __ZL9oflow_emf;var __ZL10oflow_less;var __ZL12last_primary;var _namedata;var __ZL7f_input;var _p_textinput;var _p_wchar_input;var __ZL10ungot_word;var _count_characters;var __ZL10ssml_stack;var __ZL16current_voice_id;var _param_stack;var _param_defaults;var _walpha_tab;var __ZL10ungot_char;var __ZL12end_of_input_b;var __str167;var __str1168;var __str2169;var __str3170;var __str4171;var __str5172;var __str6173;var __str7174;var __str8175;var __str9176;var __str10177;var __str11178;var __str12179;var __str13180;var __str14181;var __str15182;var __str16183;var __str17184;var __str18185;var __str19186;var __str20187;var __str21188;var __str22189;var __str23190;var __str24191;var __str25192;var __str26193;var __str27194;var __str28195;var __str29196;var __str30197;var __str31198;var __ZL8ssmltags;var __ZL10n_namedata;var __ZL11namedata_ix;var __str32199;var __str33200;var __str34201;var __str35202;var __str36203;var __str37204;var __ZL18xml_char_mnemonics;var __ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E12ungot_string;var __ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix;var __ZL19clear_skipping_text_b;var __ZL11ungot_char2;var __ZL19ssml_ignore_l_angle;var __str38205;var __ZL10sayas_mode;var __ZL11ignore_text_b;var __ZL11punct_chars;var __ZL16punct_attributes;var __str41208;var __ZL12chars_ignore;var __str42209;var __ZL10audio_text_b;var __ZL17speech_parameters;var __ZL12n_ssml_stack;var __ZL13n_param_stack;var __ZL7xmlbase;var __ZZL14LookupCharNameP10TranslatoriiE3buf;var __str47214;var __str48215;var __str49216;var __ZZL13WordToString2jE3buf;var __str50217;var __str51218;var __str52219;var __str53220;var __str54221;var __str55222;var __str57224;var __str58225;var __str59226;var __str60227;var __ZZL14ProcessSsmlTagPwPcRiiiE10mnem_punct;var __str61228;var __str62229;var __str63230;var __ZZL14ProcessSsmlTagPwPcRiiiE13mnem_capitals;var __str64231;var __str65232;var __str66233;var __ZZL14ProcessSsmlTagPwPcRiiiE17mnem_interpret_as;var __str68235;var __str69236;var __str70237;var __str71238;var __str72239;var __ZZL14ProcessSsmlTagPwPcRiiiE17mnem_sayas_format;var __str73240;var __ZZL14ProcessSsmlTagPwPcRiiiE10mnem_break;var __str74241;var __str75242;var __str76243;var __str77244;var __ZZL14ProcessSsmlTagPwPcRiiiE13mnem_emphasis;var __str78245;var __str79246;var __ZZL14ProcessSsmlTagPwPcRiiiE12prosody_attr;var __str80247;var __str81248;var __str82249;var __ZL22ignore_if_self_closing;var __str83250;var __str84251;var __str85252;var __str86253;var __str87254;var __ZZL14ProcessSsmlTagPwPcRiiiE23emphasis_to_pitch_range;var __ZZL14ProcessSsmlTagPwPcRiiiE18emphasis_to_volume;var __str88255;var __str89256;var __str90257;var __str91258;var __ZL11sayas_start;var __str92259;var __str94261;var __str95262;var __str96263;var __str97264;var __str98265;var __str99266;var __ZZL14ProcessSsmlTagPwPcRiiiE11break_value;var __str100267;var __str101268;var __str102269;var __ZZL18GetVoiceAttributesPwiE11mnem_gender;var __str105272;var __str106273;var __str108275;var __ZZL14LoadSoundFile2PKcE4slot;var __str111278;var __str112279;var __str113280;var __str114281;var __ZZL14ReplaceKeyNamePciRiE8keynames;var __ZZL19SetProsodyParameteriPwP11PARAM_STACKE11mnem_volume;var __str115282;var __str116283;var __str117;var __str118;var __str119;var __ZZL19SetProsodyParameteriPwP11PARAM_STACKE9mnem_rate;var __str120;var __str121;var __str122;var __str123;var __ZZL19SetProsodyParameteriPwP11PARAM_STACKE10mnem_pitch;var __str124;var __str125;var __str126;var __str127;var __ZZL19SetProsodyParameteriPwP11PARAM_STACKE10mnem_range;var __ZZL19SetProsodyParameteriPwP11PARAM_STACKE9mnem_tabs;var __ZZL17ProcessParamStackPcRiE10cmd_letter;var __str128;var __ZZL16GetSsmlAttributePwPKcE5empty;var __ZZL4GetCvE6ungot2;var __ZZL4GetCvE5mask2;var __ZL6speed1;var __ZL6speed2;var __ZL6speed3;var __ZL12speed_lookup;var __ZL14wav_factor_350;var __ZL16pause_factor_350;var __ZZ11CalcLengthsP10TranslatorE14more_syllables;var __str294;var __ZL18letter_accents_0e0;var __ZL18letter_accents_250;var __ZL13non_ascii_tab;var __ZL11accents_tab;var __str297;var __str1298;var __str2299;var __ZZ12LookupLetterP10TranslatorjiPciE13single_letter;var __str5302;var __str6303;var __str7304;var __str8305;var __str9306;var __str10307;var __str11308;var __str12309;var __ZZ14TranslateRomanP10TranslatorPcS1_P8WORD_TABE12roman_values;var __str13310;var __str14311;var __ZZL17TranslateNumber_1P10TranslatorPcS1_PjP8WORD_TABiE9str_pause;var __ZL14n_digit_lookup;var __ZL12digit_lookup;var __ZL14number_control;var __ZL23speak_missing_thousands;var __ZL11ph_ordinal2;var __str15312;var __str16313;var __str17314;var __str18315;var __str19316;var __str20317;var __str21318;var __str22319;var __str23320;var __str24321;var __str25322;var __str26323;var __str27324;var __str28325;var __str29326;var __str30327;var __str31328;var __str32329;var __str33330;var __str35332;var __str36333;var __str37334;var __str39336;var __str40337;var __str41338;var __str42339;var __str43340;var __str44341;var __str45342;var __str46343;var __str47344;var __str48345;var __str49346;var __str50347;var __str51348;var __str52349;var __str53350;var __str54351;var __str55352;var __str56353;var __str57354;var __str58355;var __str59356;var __str60357;var __str61358;var __str62359;var __str63360;var __str64361;var __str65362;var __str66363;var __str67364;var __str68365;var __str69366;var __str70367;var __str71368;var __str72369;var __str73370;var __str74371;var __str75372;var __str76373;var __str77374;var __str78375;var _option_mbrola_phonemes;var __ZL10mbrola_tab;var __ZL15mbr_name_prefix;var __str382;var __str1383;var __str2384;var __str3385;var __str4386;var __ZL14mbrola_control;var __ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix;var __ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE11embedded_ix;var __ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE10word_count;var __str6388;var __str8390;var __str9391;var __str10392;var __str11393;var __str12394;var __ZZ10MbrolaFilliiE9n_samples;var __ZZL10WritePitchiiiiiE6output;var __str13395;var __str14396;var __str15397;var __str16398;var __ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem;var __str399;var _version_string;var _version_phdata;var _option_device_number;var _f_logespeak;var _logging_type;var _n_phoneme_tab;var _current_phoneme_table;var _phoneme_tab;var _phoneme_tab_flags;var _phoneme_index;var _phondata_ptr;var _wavefile_data;var __ZL16phoneme_tab_data;var _n_phoneme_tables;var _phoneme_tab_list;var _phoneme_tab_number;var _wavefile_ix;var _wavefile_amp;var _wavefile_ix2;var _wavefile_amp2;var _seq_len_adjust;var _vowel_transition;var _vowel_transition0;var _vowel_transition1;var __str1412;var __str2413;var __str3414;var __str4415;var __ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf;var __str5416;var __str7418;var __str9420;var __str10421;var __str11422;var __str13424;var __str15426;var __str16427;var _this_ph_data;var __ZZL13NumInstnWordsPtE7n_words;var __ZZL18InterpretConditionP10TranslatoriP12PHONEME_LISTiE11ph_position;var __ZZL15StressConditionP10TranslatorP12PHONEME_LISTiiE15condition_level;var __str17428;var __str18429;var __str19430;var _n_phoneme_list;var _phoneme_list;var _mbrola_delay;var _mbrola_name;var _speed;var __ZL9new_voice;var _n_soundicon_tab;var _soundicon_tab;var __ZZ12WordToStringjE3buf;var __ZL14last_pitch_cmd;var __ZL12last_amp_cmd;var __ZL10last_frame;var __ZL15syllable_centre;var __ZZ18FormantTransition2P10frameref_tRijjP11PHONEME_TABiE10vcolouring;var __ZL10modn_flags;var __ZZ8DoSpect2P11PHONEME_TABiP10FMT_PARAMSP12PHONEME_LISTiE9wave_flag_b;var __ZL13fmt_amplitude;var __ZL10last_wcmdq;var __ZL12pitch_length;var __ZL10amp_length;var __ZZ8GenerateP12PHONEME_LISTPiiE2ix;var __ZZ8GenerateP12PHONEME_LISTPiiE11embedded_ix;var __ZZ8GenerateP12PHONEME_LISTPiiE10word_count;var __ZZ8GenerateP12PHONEME_LISTPiiE8sourceix;var __ZL14syllable_start;var __ZL12syllable_end;var __ZL8timer_on_b;var __ZL6paused_b;var __ZZ15SpeakNextClauseP7__sFILEPKviE6f_text;var __ZZ15SpeakNextClauseP7__sFILEPKviE6p_text;var __str459;var __str1460;var __ZZL13set_frame_rmsP7frame_tiE8sqrt_tab;var __ZZL10AllocFramevE2ix;var __ZZL10AllocFramevE10frame_pool;var _translator;var _translator2;var __ZL20translator2_language;var _f_trans;var _option_tone2;var _option_tone_flags;var _option_phonemes;var _option_phoneme_events;var _option_quiet;var _option_endpause;var _option_capitals;var _option_punctuation;var _option_sayas;var _option_ssml;var _option_phoneme_input;var _option_phoneme_variants;var _option_wordgap;var _skip_sentences;var _skip_words;var _skip_characters;var _skip_marker;var _skipping_text;var _end_character_position;var _count_sentences;var _count_words;var _clause_start_char;var _clause_start_word;var _new_sentence;var _pre_pause;var _word_phonemes;var _n_ph_list2;var _ph_list2;var _option_punctlist;var _ctrl_embedded;var _option_multibyte;var _option_linelength;var _embedded_list;var _n_replace_phonemes;var _replace_phonemes;var __ZL10ISO_8859_1;var __ZL10ISO_8859_2;var __ZL10ISO_8859_3;var __ZL10ISO_8859_4;var __ZL10ISO_8859_5;var __ZL10ISO_8859_7;var __ZL10ISO_8859_9;var __ZL11ISO_8859_14;var __ZL6KOI8_R;var __ZL5ISCII;var _charsets;var __ZL15length_mod_tabs;var __ZZ7IsAlphajE18extra_indic_alphas;var __ZL8brackets;var __ZZ8utf8_outjPcE4code;var __ZZ8utf8_in2PiPKciE4mask;var __str543;var __str1544;var __ZZ13TranslateWordP10TranslatorPciP8WORD_TABE7word_zz;var __ZZ13TranslateWordP10TranslatorPciP8WORD_TABE7word_iz;var __ZZ13TranslateWordP10TranslatorPciP8WORD_TABE7word_ss;var __str2545;var __str4547;var __str5548;var __str6549;var __ZL18any_stressed_words_b;var __ZZ15TranslateClauseP10TranslatorP7__sFILEPKvPiPPcE17voice_change_name;var __ZL11embedded_ix;var __ZL13embedded_read;var __ZL6source;var __str7550;var __str8551;var __ZL16max_clause_pause;var __ZL13option_sayas2;var __ZL18count_sayas_digits;var __ZL6breaks;var __ZL13word_emphasis_b;var __ZL15option_emphasis;var __ZL13embedded_flag_b;var __str9552;var __str10553;var __str11554;var __ZZL13TranslateCharP10TranslatorPcijjPiE20hangul_compatibility;var __ZZL14SubstituteCharP10TranslatorjjPiE11ignore_next_b;var __str12555;var __ZL14length_mods_en;var __ZL15length_mods_en0;var __ZL17length_mods_equal;var __str580;var __str1581;var __str2582;var __str3583;var __str4584;var __ZL14mbr_samplerate;var __ZL14mbr_voice_path;var __ZL10mbr_volume;var __ZL9mbr_state;var __ZL7mbr_pid;var __ZL10mbr_cmd_fd;var __str5585;var __ZL12mbr_audio_fd;var __ZL12mbr_errorbuf;var __ZL12mbr_error_fd;var __str7587;var __str8588;var __str9589;var __str10590;var __str11591;var __str12592;var __str13593;var __str14594;var __str15595;var __str16596;var __str17597;var __ZL21mbr_pending_data_head;var __ZL21mbr_pending_data_tail;var __str18598;var __str19599;var __str20600;var __str21601;var __ZL13mbr_proc_stat;var __str22602;var __str23603;var __str24604;var __str25605;var __str27607;var __str28608;var __str30610;var __str31611;var __str32612;var __str33613;var __str34614;var __str35615;var __ZZ15SetIndicLettersP10TranslatorE15dev_consonants2;var __ZZ16SelectTranslatorPKcE17stress_lengths_fr;var __ZZ16SelectTranslatorPKcE14stress_amps_fr;var __ZZ16SelectTranslatorPKcE14stress_amps_sk;var __ZZ16SelectTranslatorPKcE17stress_lengths_sk;var __ZZ16SelectTranslatorPKcE17stress_lengths_ta;var __ZZ16SelectTranslatorPKcE14stress_amps_ta;var __ZZ16SelectTranslatorPKcE17stress_lengths_af;var __ZZ16SelectTranslatorPKcE17stress_lengths_bn;var __ZZ16SelectTranslatorPKcE14stress_amps_bn;var __ZZ16SelectTranslatorPKcE17stress_lengths_cy;var __ZZ16SelectTranslatorPKcE14stress_amps_cy;var __ZZ16SelectTranslatorPKcE17stress_lengths_da;var __ZZ16SelectTranslatorPKcE17stress_lengths_de;var __ZZ16SelectTranslatorPKcE14stress_amps_de;var __ZZ16SelectTranslatorPKcE17stress_lengths_en;var __str630;var __ZZ16SelectTranslatorPKcE17stress_lengths_el;var __ZZ16SelectTranslatorPKcE14stress_amps_el;var __ZZ16SelectTranslatorPKcE9el_vowels;var __ZZ16SelectTranslatorPKcE10el_fvowels;var __ZZ16SelectTranslatorPKcE12el_voiceless;var __ZZ16SelectTranslatorPKcE13el_consonants;var __ZZ16SelectTranslatorPKcE18el_char_apostrophe;var __ZZ16SelectTranslatorPKcE17stress_lengths_eo;var __ZZ16SelectTranslatorPKcE14stress_amps_eo;var __ZZ16SelectTranslatorPKcE18eo_char_apostrophe;var __ZZ16SelectTranslatorPKcE17stress_lengths_es;var __ZZ16SelectTranslatorPKcE14stress_amps_es;var __ZZ16SelectTranslatorPKcE20ca_punct_within_word;var __ZZ16SelectTranslatorPKcE17stress_lengths_eu;var __ZZ16SelectTranslatorPKcE14stress_amps_eu;var __ZZ16SelectTranslatorPKcE14stress_amps_fi;var __ZZ16SelectTranslatorPKcE17stress_lengths_fi;var __ZZ16SelectTranslatorPKcE17stress_lengths_hi;var __ZZ16SelectTranslatorPKcE14stress_amps_hi;var __ZZ16SelectTranslatorPKcE14stress_amps_hr;var __ZZ16SelectTranslatorPKcE17stress_lengths_hr;var __ZZ16SelectTranslatorPKcE17stress_lengths_sr;var __ZL22replace_cyrillic_latin;var __ZZ16SelectTranslatorPKcE14stress_amps_hu;var __ZZ16SelectTranslatorPKcE17stress_lengths_hu;var __ZZ16SelectTranslatorPKcE17stress_lengths_hy;var __ZZ16SelectTranslatorPKcE9hy_vowels;var __ZZ16SelectTranslatorPKcE13hy_consonants;var __ZZ16SelectTranslatorPKcE17stress_lengths_id;var __ZZ16SelectTranslatorPKcE14stress_amps_id;var __ZZ16SelectTranslatorPKcE17stress_lengths_is;var __ZZ16SelectTranslatorPKcE16is_lettergroup_B;var __str1631;var __str2632;var __ZZ16SelectTranslatorPKcE17stress_lengths_it;var __ZZ16SelectTranslatorPKcE14stress_amps_it;var __ZZ16SelectTranslatorPKcE18stress_lengths_jbo;var __ZZ16SelectTranslatorPKcE21jbo_punct_within_word;var __ZZ16SelectTranslatorPKcE9ka_vowels;var __ZZ16SelectTranslatorPKcE13ka_consonants;var __ZZ16SelectTranslatorPKcE10ko_ivowels;var __ZZ16SelectTranslatorPKcE9ko_voiced;var __ZZ16SelectTranslatorPKcE14stress_amps_ku;var __ZZ16SelectTranslatorPKcE17stress_lengths_ku;var __ZZ16SelectTranslatorPKcE14stress_amps_lv;var __ZZ16SelectTranslatorPKcE17stress_lengths_lv;var __ZZ16SelectTranslatorPKcE15vowels_cyrillic;var __ZZ16SelectTranslatorPKcE14stress_amps_mk;var __ZZ16SelectTranslatorPKcE17stress_lengths_mk;var __ZZ16SelectTranslatorPKcE17stress_lengths_nl;var __str3633;var __ZZ16SelectTranslatorPKcE17stress_lengths_no;var __ZZ16SelectTranslatorPKcE14stress_amps_om;var __ZZ16SelectTranslatorPKcE17stress_lengths_om;var __ZZ16SelectTranslatorPKcE17stress_lengths_pl;var __ZZ16SelectTranslatorPKcE14stress_amps_pl;var __ZZ16SelectTranslatorPKcE17stress_lengths_pt;var __ZZ16SelectTranslatorPKcE14stress_amps_pt;var __str4634;var __ZZ16SelectTranslatorPKcE17stress_lengths_ro;var __ZZ16SelectTranslatorPKcE14stress_amps_ro;var __str5635;var __ZZ16SelectTranslatorPKcE17stress_lengths_sq;var __ZZ16SelectTranslatorPKcE14stress_amps_sq;var __ZZ16SelectTranslatorPKcE14stress_amps_sv;var __ZZ16SelectTranslatorPKcE17stress_lengths_sv;var __ZZ16SelectTranslatorPKcE17stress_lengths_sw;var __ZZ16SelectTranslatorPKcE14stress_amps_sw;var __ZZ16SelectTranslatorPKcE14stress_amps_tr;var __ZZ16SelectTranslatorPKcE17stress_lengths_tr;var __ZZ16SelectTranslatorPKcE17stress_lengths_vi;var __ZZ16SelectTranslatorPKcE14stress_amps_vi;var __ZZ16SelectTranslatorPKcE9vowels_vi;var __ZZ16SelectTranslatorPKcE17stress_lengths_zh;var __ZZ16SelectTranslatorPKcE14stress_amps_zh;var __ZZL18Translator_RussianP10TranslatorE14stress_amps_ru;var __ZZL18Translator_RussianP10TranslatorE17stress_lengths_ru;var __ZZL18Translator_RussianP10TranslatorE11ru_ivowels2;var __ZZL18SetCyrillicLettersP10TranslatorE9ru_vowels;var __ZZL18SetCyrillicLettersP10TranslatorE13ru_consonants;var __ZZL18SetCyrillicLettersP10TranslatorE7ru_soft;var __ZZL18SetCyrillicLettersP10TranslatorE7ru_hard;var __ZZL18SetCyrillicLettersP10TranslatorE10ru_nothard;var __ZZL18SetCyrillicLettersP10TranslatorE9ru_voiced;var __ZZL18SetCyrillicLettersP10TranslatorE10ru_ivowels;var __ZL8pairs_ru;var __ZZL13NewTranslatorvE12stress_amps2;var __ZZL13NewTranslatorvE15stress_lengths2;var __ZZL13NewTranslatorvE13empty_wstring;var __ZZL13NewTranslatorvE13punct_in_word;var __ZZL13NewTranslatorvE13default_tunes;var __str6636;var __str7637;var __str8638;var __str9639;var __str10640;var __str11641;var __str12642;var __str13643;var __str646;var __str1647;var __str2648;var _genders;var _tone_points;var _formant_rate;var _voice_selected;var __str3653;var __str4654;var __ZL11options_tab;var __str5655;var __str6656;var __str7657;var __str8658;var __str9659;var __str10660;var __str11661;var __str12662;var __str13663;var __str14664;var __str15665;var __str16666;var __str17667;var __str18668;var __str19669;var __str20670;var __str21671;var __str22672;var __str23673;var __str24674;var __str25675;var __str26676;var __str27677;var __str28678;var __str29679;var __str30680;var __str31681;var __str32682;var __str33683;var __str34684;var __str35685;var __str36686;var __str37687;var __str38688;var __str39689;var __str40690;var __str41691;var __str42692;var __str43693;var __ZL11keyword_tab;var __ZL15variants_either;var __ZL13variants_male;var __ZL15variants_female;var _variant_lists;var __ZL9voicedata;var _voice;var __str44696;var __ZZ10VoiceResetiE15default_heights;var __ZZ10VoiceResetiE14default_widths;var __ZZ10VoiceResetiE13breath_widths;var __ZL18formant_rate_22050;var __ZZ9LoadVoicePKciE16voice_identifier;var __ZZ9LoadVoicePKciE10voice_name;var __ZZ9LoadVoicePKciE15voice_languages;var __str45697;var __str46698;var __str47699;var __str48700;var __str49701;var __str50702;var __str51703;var __str52704;var __str53705;var __str54706;var __str55707;var __str56708;var __str57709;var __str58710;var __str59711;var __str60712;var __str61713;var __str62714;var __str63715;var __str64716;var __str65717;var __str66718;var __str67719;var __str68720;var __str69721;var __ZL13n_voices_list;var __ZL11voices_list;var __str70722;var __ZZ11SelectVoiceP12espeak_VOICEPiE14voice_variants;var __ZZ11SelectVoiceP12espeak_VOICEPiE8voice_id;var __ZZ11SelectVoiceP12espeak_VOICEPiE3buf;var __str71723;var __ZZ14SetVoiceByNamePKcE3buf;var __ZZ17espeak_ListVoicesE6voices;var __str72724;var __ZL15len_path_voices;var __str73725;var __str74726;var __str75727;var __ZZL23ExtractVoiceVariantNamePciE12variant_name;var __str76728;var __str77729;var __str78730;var __str79731;var __str80732;var __str81733;var __str82734;var _sin_tab;var _wvoice;var _f_log;var _option_waveout;var _option_log_frames;var _embedded_value;var _samplerate;var _samplerate_native;var __ZL5peaks;var _echo_head;var _echo_tail;var _echo_amp;var _echo_buf;var __ZL7rbreath;var _wdata;var __ZL13amplitude_env;var _out_ptr;var _out_start;var _out_end;var _outbuf_size;var _wcmdq;var _wcmdq_head;var _wcmdq_tail;var _embedded_default;var _current_source_index;var __ZL18sonicSpeedupStream;var _sonicSpeed;var _pitch_adjust_tab;var _pk_shape1;var __ZL16PHASE_INC_FACTOR;var __ZL11Flutter_inc;var __ZL11samplecount;var __ZL8nsamples;var __ZL9wavephase;var __ZL12wavemult_max;var __ZL15wavemult_offset;var __ZL8wavemult;var __ZL9pk_shape2;var __ZL8pk_shape;var __ZZ12GetAmplitudevE12amp_emphasis;var __ZL17general_amplitude;var __ZL11peak_height;var __ZL13peak_harmonic;var __ZL16option_harmonic1_b;var __ZL9harmspect;var __ZL8harm_inc;var __ZL10minus_pi_t;var __ZL8two_pi_t;var __ZZ7WavegenvE4maxh;var __ZZ7WavegenvE5maxh2;var __ZZ7WavegenvE3agc;var __ZZ7WavegenvE13h_switch_sign;var __ZZ7WavegenvE11cycle_count;var __ZZ7WavegenvE10amplitude2;var __ZL8end_wave_b;var __ZL7hswitch;var __ZL6hspect;var __ZL8phaseinc;var __ZL13cycle_samples;var __ZL9hf_factor;var __ZL6cbytes;var __ZL12glottal_flag;var __ZL14glottal_reduce;var __ZL6amp_ix;var __ZL15modulation_type;var __ZL14modulation_tab;var __ZL7voicing;var __ZL12embedded_max;var __ZZ15WavegenSetVoiceP7voice_tE2v2;var __ZL13consonant_amp;var __ZL11flutter_amp;var __ZZ8SetSynthiiP7frame_tS0_P7voice_tE19glottal_reduce_tab1;var __ZZ8SetSynthiiP7frame_tS0_P7voice_tE19glottal_reduce_tab2;var __ZL17samplecount_start;var __ZZ12WavegenFill2iE6resume;var __ZZ12WavegenFill2iE13echo_complete;var __ZL11echo_length;var __ZL7amp_inc;var __ZZL8PlayWaveiiPhiiE9n_samples;var __ZZL8PlayWaveiiPhiiE2ix;var __ZZL11PlaySilenceiiE9n_samples;var __ZZL17AdvanceParametersvE10Flutter_ix;var __ZL11Flutter_tab;var _pause_phonemes;var __ZZ15MakePhonemeListP10TranslatoriiE12types_double;var __ZL8kt_frame;var __ZL10kt_globals;var __ZL5peaks801;var __ZL12sample_count;var __ZL8nsamples802;var __ZL6klattp;var __ZL10klattp_inc;var __ZL7klattp1;var __ZL8end_wave803;var __ZZ14SetSynth_KlattiiP7frame_tS0_P7voice_tiE7prev_fr;var __ZL13scale_wav_tab;var __ZZ9KlattInitvE15natural_samples;var __ZZ9KlattInitvE10formant_hz;var __ZZ9KlattInitvE9bandwidth;var __ZZ9KlattInitvE12parallel_amp;var __ZZ9KlattInitvE11parallel_bw;var __ZZL7parwaveP13klatt_frame_tE5noise;var __ZZL7parwaveP13klatt_frame_tE5voice;var __ZZL7parwaveP13klatt_frame_tE5vlast;var __ZZL7parwaveP13klatt_frame_tE8glotlast;var __ZZL7parwaveP13klatt_frame_tE5sourc;var __ZZL21pitch_synch_par_resetP13klatt_frame_tE4skew;var __ZZL21pitch_synch_par_resetP13klatt_frame_tE2B0;var __ZZL7DBtoLINlE8amptable;var __ZZL14natural_sourcevE5vwave;var __ZZL16impulsive_sourcevE7doublet;var __ZZL16impulsive_sourcevE5vwave;var __ZZL9gen_noisedE5nlast;var __ZZL7flutterP13klatt_frame_tE10time_count;var __ZZL10frame_initP13klatt_frame_tE14amp_par_factor;var __str810;var __str1811;var _optarg;var _optind;var _opterr;var _optopt;var __ZL8optwhere;var __str831;var __str1832;var __str2833;var __str3834;var __str4835;var __str5836;var __str6837;var _llvm_dbg_declare;var ERRNO_CODES={E2BIG:7,EACCES:13,EADDRINUSE:98,EADDRNOTAVAIL:99,EAFNOSUPPORT:97,EAGAIN:11,EALREADY:114,EBADF:9,EBADMSG:74,EBUSY:16,ECANCELED:125,ECHILD:10,ECONNABORTED:103,ECONNREFUSED:111,ECONNRESET:104,EDEADLK:35,EDESTADDRREQ:89,EDOM:33,EDQUOT:122,EEXIST:17,EFAULT:14,EFBIG:27,EHOSTUNREACH:113,EIDRM:43,EILSEQ:84,EINPROGRESS:115,EINTR:4,EINVAL:22,EIO:5,EISCONN:106,EISDIR:21,ELOOP:40,EMFILE:24,EMLINK:31,EMSGSIZE:90,EMULTIHOP:72,ENAMETOOLONG:36,ENETDOWN:100,ENETRESET:102,ENETUNREACH:101,ENFILE:23,ENOBUFS:105,ENODATA:61,ENODEV:19,ENOENT:2,ENOEXEC:8,ENOLCK:37,ENOLINK:67,ENOMEM:12,ENOMSG:42,ENOPROTOOPT:92,ENOSPC:28,ENOSR:63,ENOSTR:60,ENOSYS:38,ENOTCONN:107,ENOTDIR:20,ENOTEMPTY:39,ENOTRECOVERABLE:131,ENOTSOCK:88,ENOTSUP:95,ENOTTY:25,ENXIO:6,EOVERFLOW:75,EOWNERDEAD:130,EPERM:1,EPIPE:32,EPROTO:71,EPROTONOSUPPORT:93,EPROTOTYPE:91,ERANGE:34,EROFS:30,ESPIPE:29,ESRCH:3,ESTALE:116,ETIME:62,ETIMEDOUT:110,ETXTBSY:26,EWOULDBLOCK:11,EXDEV:18};function ___setErrNo(value){if(!___setErrNo.ret)___setErrNo.ret=allocate([0],'i32',ALLOC_STATIC);HEAP32[((___setErrNo.ret)>>2)]=value;return value;}
var _stdin=0;var _stdout=0;var _stderr=0;var __impure_ptr=0;var FS={currentPath:"/",nextInode:2,streams:[null],ignorePermissions:true,absolutePath:function(relative,base){if(typeof relative!=='string')return null;if(typeof base==='undefined')base=FS.currentPath;if(relative&&relative[0]=='/')base='';var full=base+'/'+relative;var parts=full.split('/').reverse();var absolute=[''];while(parts.length){var part=parts.pop();if(part==''||part=='.'){}else if(part=='..'){if(absolute.length>1)absolute.pop();}else{absolute.push(part);}}
return absolute.length==1?'/':absolute.join('/');},analyzePath:function(path,dontResolveLastLink,linksVisited){var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};path=FS.absolutePath(path);if(path=='/'){ret.isRoot=true;ret.exists=ret.parentExists=true;ret.name='/';ret.path=ret.parentPath='/';ret.object=ret.parentObject=FS.root;}else if(path!==null){linksVisited=linksVisited||0;path=path.slice(1).split('/');var current=FS.root;var traversed=[''];while(path.length){if(path.length==1&&current.isFolder){ret.parentExists=true;ret.parentPath=traversed.length==1?'/':traversed.join('/');ret.parentObject=current;ret.name=path[0];}
var target=path.shift();if(!current.isFolder){ret.error=ERRNO_CODES.ENOTDIR;break;}else if(!current.read){ret.error=ERRNO_CODES.EACCES;break;}else if(!current.contents.hasOwnProperty(target)){ret.error=ERRNO_CODES.ENOENT;break;}
current=current.contents[target];if(current.link&&!(dontResolveLastLink&&path.length==0)){if(linksVisited>40){ret.error=ERRNO_CODES.ELOOP;break;}
var link=FS.absolutePath(current.link,traversed.join('/'));return FS.analyzePath([link].concat(path).join('/'),dontResolveLastLink,linksVisited+1);}
traversed.push(target);if(path.length==0){ret.exists=true;ret.path=traversed.join('/');ret.object=current;}}
return ret;}
return ret;},findObject:function(path,dontResolveLastLink){FS.ensureRoot();var ret=FS.analyzePath(path,dontResolveLastLink);if(ret.exists){return ret.object;}else{___setErrNo(ret.error);return null;}},createObject:function(parent,name,properties,canRead,canWrite){if(!parent)parent='/';if(typeof parent==='string')parent=FS.findObject(parent);if(!parent){___setErrNo(ERRNO_CODES.EACCES);throw new Error('Parent path must exist.');}
if(!parent.isFolder){___setErrNo(ERRNO_CODES.ENOTDIR);throw new Error('Parent must be a folder.');}
if(!parent.write&&!FS.ignorePermissions){___setErrNo(ERRNO_CODES.EACCES);throw new Error('Parent folder must be writeable.');}
if(!name||name=='.'||name=='..'){___setErrNo(ERRNO_CODES.ENOENT);throw new Error('Name must not be empty.');}
if(parent.contents.hasOwnProperty(name)){___setErrNo(ERRNO_CODES.EEXIST);throw new Error("Can't overwrite object.");}
parent.contents[name]={read:(typeof canRead==='undefined')?true:canRead,write:(typeof canWrite==='undefined')?false:canWrite,timestamp:Date.now(),inodeNumber:FS.nextInode++};for(var key in properties){if(properties.hasOwnProperty(key)){parent.contents[name][key]=properties[key];}}
return parent.contents[name];},createFolder:function(parent,name,canRead,canWrite){var properties={isFolder:true,isDevice:false,contents:{}};return FS.createObject(parent,name,properties,canRead,canWrite);},createPath:function(parent,path,canRead,canWrite){var current=FS.findObject(parent);if(current===null)throw new Error('Invalid parent.');path=path.split('/').reverse();while(path.length){var part=path.pop();if(!part)continue;if(!current.contents.hasOwnProperty(part)){FS.createFolder(current,part,canRead,canWrite);}
current=current.contents[part];}
return current;},createFile:function(parent,name,properties,canRead,canWrite){properties.isFolder=false;return FS.createObject(parent,name,properties,canRead,canWrite);},createDataFile:function(parent,name,data,canRead,canWrite){if(typeof data==='string'){var dataArray=[];for(var i=0;i<data.length;i++)dataArray.push(data.charCodeAt(i));data=dataArray;}
var properties={isDevice:false,contents:data};return FS.createFile(parent,name,properties,canRead,canWrite);},createLazyFile:function(parent,name,url,canRead,canWrite){var properties={isDevice:false,url:url};return FS.createFile(parent,name,properties,canRead,canWrite);},createLink:function(parent,name,target,canRead,canWrite){var properties={isDevice:false,link:target};return FS.createFile(parent,name,properties,canRead,canWrite);},createDevice:function(parent,name,input,output){if(!(input||output)){throw new Error('A device must have at least one callback defined.');}
var ops={isDevice:true,input:input,output:output};return FS.createFile(parent,name,ops,Boolean(input),Boolean(output));},forceLoadFile:function(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;___setErrNo(ERRNO_CODES.EIO);return false;},ensureRoot:function(){if(FS.root)return;FS.root={read:true,write:false,isFolder:true,isDevice:false,timestamp:Date.now(),inodeNumber:1,contents:{}};},init:function(input,output,error){if(FS.init.initialized)return;FS.init.initialized=true;FS.ensureRoot();if(!input)input=function(){if(!input.cache||!input.cache.length){var result;if(typeof readline=='function'){result=readline();}
if(!result)result='';input.cache=intArrayFromString(result+'\n',true);input.cache=intArrayFromString('\n',true);}
return input.cache.shift();};if(!output)output=function(val){if(val===null||val==='\n'.charCodeAt(0)){output.printer(output.buffer.join(''));output.buffer=[];}else{output.buffer.push(String.fromCharCode(val));}};if(!output.printer)output.printer=vprint;if(!output.buffer)output.buffer=[];if(!error)error=output;FS.createFolder('/','tmp',true,true);var devFolder=FS.createFolder('/','dev',true,false);var stdin=FS.createDevice(devFolder,'stdin',input);var stdout=FS.createDevice(devFolder,'stdout',null,output);var stderr=FS.createDevice(devFolder,'stderr',null,error);FS.createDevice(devFolder,'tty',input,output);FS.streams[1]={path:'/dev/stdin',object:stdin,position:0,isRead:true,isWrite:false,isAppend:false,error:false,eof:false,ungotten:[]};FS.streams[2]={path:'/dev/stdout',object:stdout,position:0,isRead:false,isWrite:true,isAppend:false,error:false,eof:false,ungotten:[]};FS.streams[3]={path:'/dev/stderr',object:stderr,position:0,isRead:false,isWrite:true,isAppend:false,error:false,eof:false,ungotten:[]};_stdin=allocate([1],'void*',ALLOC_STATIC);_stdout=allocate([2],'void*',ALLOC_STATIC);_stderr=allocate([3],'void*',ALLOC_STATIC);FS.streams[_stdin]=FS.streams[1];FS.streams[_stdout]=FS.streams[2];FS.streams[_stderr]=FS.streams[3];__impure_ptr=allocate([allocate([0,0,0,0,_stdin,0,0,0,_stdout,0,0,0,_stderr,0,0,0],'void*',ALLOC_STATIC)],'void*',ALLOC_STATIC);FS.ignorePermissions=false;},quit:function(){try{if(FS.streams[2].object.output.buffer.length>0)FS.streams[2].object.output('\n'.charCodeAt(0));if(FS.streams[3].object.output.buffer.length>0)FS.streams[3].object.output('\n'.charCodeAt(0));}
catch(e){recoverFromFSError(e);}}};var ___stat_struct_layout={__size__:80,st_dev:0,st_ino:8,st_mode:12,st_nlink:16,st_uid:20,st_gid:24,st_rdev:28,st_size:36,st_atime:40,st_spare1:44,st_mtime:48,st_spare2:52,st_ctime:56,st_spare3:60,st_blksize:64,st_blocks:68,st_spare4:72};function _stat(path,buf,dontResolveLastLink){var obj=FS.findObject(Pointer_stringify(path),dontResolveLastLink);if(obj===null||!FS.forceLoadFile(obj))return-1;var offsets=___stat_struct_layout;HEAP32[((buf+offsets.st_nlink)>>2)]=1;HEAP32[((buf+offsets.st_uid)>>2)]=0;HEAP32[((buf+offsets.st_gid)>>2)]=0;HEAP32[((buf+offsets.st_blksize)>>2)]=4096;HEAP32[((buf+offsets.st_ino)>>2)]=obj.inodeNumber;var time=Math.floor(obj.timestamp/1000);if(typeof offsets.st_atime==='undefined'){offsets.st_atime=offsets.st_atim.tv_sec;offsets.st_mtime=offsets.st_mtim.tv_sec;offsets.st_ctime=offsets.st_ctim.tv_sec;var nanosec=(obj.timestamp%1000)*1000;HEAP32[((buf+offsets.st_atim.tv_nsec)>>2)]=nanosec;HEAP32[((buf+offsets.st_mtim.tv_nsec)>>2)]=nanosec;HEAP32[((buf+offsets.st_ctim.tv_nsec)>>2)]=nanosec;}
HEAP32[((buf+offsets.st_atime)>>2)]=time;HEAP32[((buf+offsets.st_mtime)>>2)]=time;HEAP32[((buf+offsets.st_ctime)>>2)]=time;var mode=0;var size=0;var blocks=0;var dev=0;var rdev=0;if(obj.isDevice){dev=rdev=obj.inodeNumber;size=blocks=0;mode=0x2000;}else{dev=1;rdev=0;if(obj.isFolder){size=4096;blocks=1;mode=0x4000;}else{var data=obj.contents||obj.link;size=data.length;blocks=Math.ceil(data.length/4096);mode=(typeof obj.link==='undefined')?0x8000:0xA000;}}
HEAP32[((buf+offsets.st_dev)>>2)]=dev;HEAP32[((buf+offsets.st_rdev)>>2)]=rdev;HEAP32[((buf+offsets.st_size)>>2)]=size;HEAP32[((buf+offsets.st_blocks)>>2)]=blocks;if(obj.read)mode|=0x16D;if(obj.write)mode|=0x92;HEAP32[((buf+offsets.st_mode)>>2)]=mode;return 0;}
function _malloc(size){var ret=STATICTOP;STATICTOP+=size;STATICTOP=Math.ceil((STATICTOP)/4)*4;;return ret;}
function _pwrite(fildes,buf,nbyte,offset){var stream=FS.streams[fildes];if(!stream||stream.object.isDevice){___setErrNo(ERRNO_CODES.EBADF);return-1;}else if(!stream.isWrite){___setErrNo(ERRNO_CODES.EACCES);return-1;}else if(stream.object.isFolder){___setErrNo(ERRNO_CODES.EISDIR);return-1;}else if(nbyte<0||offset<0){___setErrNo(ERRNO_CODES.EINVAL);return-1;}else{var contents=stream.object.contents;while(contents.length<offset)contents.push(0);for(var i=0;i<nbyte;i++){contents[offset+i]=HEAP8[(buf+i)];}
stream.object.timestamp=Date.now();return i;}}function _write(fildes,buf,nbyte){var stream=FS.streams[fildes];if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1;}else if(!stream.isWrite){___setErrNo(ERRNO_CODES.EACCES);return-1;}else if(nbyte<0){___setErrNo(ERRNO_CODES.EINVAL);return-1;}else{if(stream.object.isDevice){if(stream.object.output){for(var i=0;i<nbyte;i++){try{stream.object.output(HEAP8[(buf+i)]);}catch(e){___setErrNo(ERRNO_CODES.EIO);return-1;}}
stream.object.timestamp=Date.now();return i;}else{___setErrNo(ERRNO_CODES.ENXIO);return-1;}}else{var bytesWritten=_pwrite(fildes,buf,nbyte,stream.position);if(bytesWritten!=-1)stream.position+=bytesWritten;return bytesWritten;}}}function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var bytesWritten=_write(stream,ptr,bytesToWrite);if(bytesWritten==-1){if(FS.streams[stream])FS.streams[stream].error=true;return-1;}else{return Math.floor(bytesWritten/size);}}
function __formatString(format,varargs){var textIndex=format;var argIndex=0;var getNextArg=function(type){var ret;if(type==='float'||type==='double'){ret=HEAPF32[((varargs+argIndex)>>2)];}else{ret=HEAP32[((varargs+argIndex)>>2)];}
argIndex+=Runtime.getNativeFieldSize(type);return Number(ret);};var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[(textIndex)];if(curr===0)break;next=HEAP8[(textIndex+1)];if(curr=='%'.charCodeAt(0)){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;flagsLoop:while(1){switch(next){case'+'.charCodeAt(0):flagAlwaysSigned=true;break;case'-'.charCodeAt(0):flagLeftAlign=true;break;case'#'.charCodeAt(0):flagAlternative=true;break;case'0'.charCodeAt(0):if(flagZeroPad){break flagsLoop;}else{flagZeroPad=true;break;}
default:break flagsLoop;}
textIndex++;next=HEAP8[(textIndex+1)];}
var width=0;if(next=='*'.charCodeAt(0)){width=getNextArg('i32');textIndex++;next=HEAP8[(textIndex+1)];}else{while(next>='0'.charCodeAt(0)&&next<='9'.charCodeAt(0)){width=width*10+(next-'0'.charCodeAt(0));textIndex++;next=HEAP8[(textIndex+1)];}}
var precisionSet=false;if(next=='.'.charCodeAt(0)){var precision=0;precisionSet=true;textIndex++;next=HEAP8[(textIndex+1)];if(next=='*'.charCodeAt(0)){precision=getNextArg('i32');textIndex++;}else{while(1){var precisionChr=HEAP8[(textIndex+1)];if(precisionChr<'0'.charCodeAt(0)||precisionChr>'9'.charCodeAt(0))break;precision=precision*10+(precisionChr-'0'.charCodeAt(0));textIndex++;}}
next=HEAP8[(textIndex+1)];}else{var precision=6;}
var argSize;switch(String.fromCharCode(next)){case'h':var nextNext=HEAP8[(textIndex+2)];if(nextNext=='h'.charCodeAt(0)){textIndex++;argSize=1;}else{argSize=2;}
break;case'l':var nextNext=HEAP8[(textIndex+2)];if(nextNext=='l'.charCodeAt(0)){textIndex++;argSize=8;}else{argSize=4;}
break;case'L':case'q':case'j':argSize=8;break;case'z':case't':case'I':argSize=4;break;default:argSize=undefined;}
if(typeof argSize!=='undefined')textIndex++;next=HEAP8[(textIndex+1)];if(['d','i','u','o','x','X','p'].indexOf(String.fromCharCode(next))!=-1){var signed=next=='d'.charCodeAt(0)||next=='i'.charCodeAt(0);argSize=argSize||4;var currArg=getNextArg('i'+(argSize*8));if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8);}
var currAbsArg=Math.abs(currArg);var argText;var prefix='';if(next=='d'.charCodeAt(0)||next=='i'.charCodeAt(0)){argText=reSign(currArg,8*argSize,1).toString(10);}else if(next=='u'.charCodeAt(0)){argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg);}else if(next=='o'.charCodeAt(0)){argText=(flagAlternative?'0':'')+currAbsArg.toString(8);}else if(next=='x'.charCodeAt(0)||next=='X'.charCodeAt(0)){prefix=flagAlternative?'0x':'';if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((0xF-parseInt(argText[i],16)).toString(16));}
argText=buffer.join('');while(argText.length<argSize*2)argText='f'+argText;}else{argText=currAbsArg.toString(16);}
if(next=='X'.charCodeAt(0)){prefix=prefix.toUpperCase();argText=argText.toUpperCase();}}else if(next=='p'.charCodeAt(0)){if(currAbsArg===0){argText='(nil)';}else{prefix='0x';argText=currAbsArg.toString(16);}}
if(precisionSet){while(argText.length<precision){argText='0'+argText;}}
if(flagAlwaysSigned){if(currArg<0){prefix='-'+prefix;}else{prefix='+'+prefix;}}
while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=' ';}else{if(flagZeroPad){argText='0'+argText;}else{prefix=' '+prefix;}}}
argText=prefix+argText;argText.split('').forEach(function(chr){ret.push(chr.charCodeAt(0));});}else if(['f','F','e','E','g','G'].indexOf(String.fromCharCode(next))!=-1){var currArg=getNextArg(argSize===4?'float':'double');var argText;if(isNaN(currArg)){argText='nan';flagZeroPad=false;}else if(!isFinite(currArg)){argText=(currArg<0?'-':'')+'inf';flagZeroPad=false;}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next=='g'.charCodeAt(0)||next=='G'.charCodeAt(0)){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split('e')[1],10);if(precision>exponent&&exponent>=-4){next=((next=='g'.charCodeAt(0))?'f':'F').charCodeAt(0);precision-=exponent+1;}else{next=((next=='g'.charCodeAt(0))?'e':'E').charCodeAt(0);precision--;}
effectivePrecision=Math.min(precision,20);}
if(next=='e'.charCodeAt(0)||next=='E'.charCodeAt(0)){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+'0'+argText.slice(-1);}}else if(next=='f'.charCodeAt(0)||next=='F'.charCodeAt(0)){argText=currArg.toFixed(effectivePrecision);}
var parts=argText.split('e');if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf('.')!=-1&&(parts[0].slice(-1)=='0'||parts[0].slice(-1)=='.')){parts[0]=parts[0].slice(0,-1);}}else{if(flagAlternative&&argText.indexOf('.')==-1)parts[0]+='.';while(precision>effectivePrecision++)parts[0]+='0';}
argText=parts[0]+(parts.length>1?'e'+parts[1]:'');if(next=='E'.charCodeAt(0))argText=argText.toUpperCase();if(flagAlwaysSigned&&currArg>=0){argText='+'+argText;}}
while(argText.length<width){if(flagLeftAlign){argText+=' ';}else{if(flagZeroPad&&(argText[0]=='-'||argText[0]=='+')){argText=argText[0]+'0'+argText.slice(1);}else{argText=(flagZeroPad?'0':' ')+argText;}}}
if(next<'a'.charCodeAt(0))argText=argText.toUpperCase();argText.split('').forEach(function(chr){ret.push(chr.charCodeAt(0));});}else if(next=='s'.charCodeAt(0)){var arg=getNextArg('i8*');var copiedString;if(arg){copiedString=String_copy(arg);if(precisionSet&&copiedString.length>precision){copiedString=copiedString.slice(0,precision);}}else{copiedString=intArrayFromString('(null)',true);}
if(!flagLeftAlign){while(copiedString.length<width--){ret.push(' '.charCodeAt(0));}}
ret=ret.concat(copiedString);if(flagLeftAlign){while(copiedString.length<width--){ret.push(' '.charCodeAt(0));}}}else if(next=='c'.charCodeAt(0)){if(flagLeftAlign)ret.push(getNextArg('i8'));while(--width>0){ret.push(' '.charCodeAt(0));}
if(!flagLeftAlign)ret.push(getNextArg('i8'));}else if(next=='n'.charCodeAt(0)){var ptr=getNextArg('i32*');HEAP32[((ptr)>>2)]=ret.length;}else if(next=='%'.charCodeAt(0)){ret.push(curr);}else{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[(i)]);}}
textIndex+=2;}else{ret.push(curr);textIndex+=1;}}
return ret;}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,'i8',ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret;}
function _free(){}
function _strlen(ptr){return String_len(ptr);}
function _strcpy(pdest,psrc){var i=0;do{var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=psrc+i;$dest$=pdest+i;$stop$=$src$+1;if(($dest$%4)==($src$%4)&&1>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
i++;}while(HEAP8[(psrc+i-1)]!=0);return pdest;}
function _snprintf(s,n,format,varargs){var result=__formatString(format,varargs);var limit=(typeof n==='undefined')?result.length:Math.min(result.length,n-1);for(var i=0;i<limit;i++){HEAP8[(s+i)]=result[i];;}
HEAP8[(s+i)]=0;;return result.length;}function _sprintf(s,format,varargs){return _snprintf(s,undefined,format,varargs);}
function _fputc(c,stream){var chr=unSign(c&0xFF);HEAP8[(_fputc.ret)]=chr;var ret=_write(stream,_fputc.ret,1);if(ret==-1){if(stream in FS.streams)FS.streams[stream].error=true;return-1;}else{return chr;}}
function __scanString(format,get,unget,varargs){format=Pointer_stringify(format);var formatIndex=0;var argsi=0;var fields=0;var argIndex=0;for(var formatIndex=0;formatIndex<format.length;formatIndex++){if(next<=0)return fields;var next=get();if(next<=0)return fields;if(format[formatIndex]==='%'){formatIndex++;var maxSpecifierStart=formatIndex;while(format[formatIndex].charCodeAt(0)>='0'.charCodeAt(0)&&format[formatIndex].charCodeAt(0)<='9'.charCodeAt(0)){formatIndex++;}
var max_;if(formatIndex!=maxSpecifierStart){max_=parseInt(format.slice(maxSpecifierStart,formatIndex),10);}
var type=format[formatIndex];formatIndex++;var curr=0;var buffer=[];while((curr<max_||isNaN(max_))&&next>0){if((type==='d'&&next>='0'.charCodeAt(0)&&next<='9'.charCodeAt(0))||(type==='x'&&(next>='0'.charCodeAt(0)&&next<='9'.charCodeAt(0)||next>='a'.charCodeAt(0)&&next<='f'.charCodeAt(0)||next>='A'.charCodeAt(0)&&next<='F'.charCodeAt(0)))||(type==='s')&&(formatIndex>=format.length||next!==format[formatIndex].charCodeAt(0))){buffer.push(String.fromCharCode(next));next=get();curr++;}else{break;}}
if(buffer.length===0)return 0;var text=buffer.join('');var argPtr=HEAP32[((varargs+argIndex)>>2)];argIndex+=Runtime.getNativeFieldSize('void*');switch(type){case'd':HEAP32[((argPtr)>>2)]=parseInt(text,10);break;case'x':HEAP32[((argPtr)>>2)]=parseInt(text,16);break;case's':var array=intArrayFromString(text);for(var j=0;j<array.length;j++){HEAP8[(argPtr+j)]=array[j];}
break;}
fields++;}else{if(format[formatIndex].charCodeAt(0)!==next){unget(next);return fields;}}}
return fields;}function _sscanf(s,format,varargs){var index=0;var get=function(){return HEAP8[(s+index++)];};var unget=function(){index--;};return __scanString(format,get,unget,varargs);}
function _printf(format,varargs){var stdout=HEAP32[((_stdout)>>2)];return _fprintf(stdout,format,varargs);}
function __exit(status){__shutdownRuntime__();ABORT=true;throw'exit('+status+') called, at '+new Error().stack;}function _exit(status){__exit(status);}
function _isspace(chr){return chr in{32:0,9:0,10:0,11:0,12:0,13:0};}
function _isdigit(chr){return chr>='0'.charCodeAt(0)&&chr<='9'.charCodeAt(0);}function _atoi(s){var c;while((c=HEAP8[(s)])&&_isspace(c))s++;if(!c||!_isdigit(c))return 0;var e=s;while((c=HEAP8[(e)])&&_isdigit(c))e++;return Math.floor(Number(Pointer_stringify(s).substr(0,e-s)));}
var ___dirent_struct_layout={__size__:1040,d_ino:0,d_name:4,d_off:1028,d_reclen:1032,d_type:1036};function _open(path,oflag,varargs){var mode=HEAP32[((varargs)>>2)];var accessMode=oflag&3;var isWrite=accessMode!=0;var isRead=accessMode!=1;var isCreate=Boolean(oflag&512);var isExistCheck=Boolean(oflag&2048);var isTruncate=Boolean(oflag&1024);var isAppend=Boolean(oflag&8);var origPath=path;path=FS.analyzePath(Pointer_stringify(path));if(!path.parentExists){___setErrNo(path.error);return-1;}
var target=path.object||null;var finalPath;if(target){if(isCreate&&isExistCheck){___setErrNo(ERRNO_CODES.EEXIST);return-1;}
if((isWrite||isCreate||isTruncate)&&target.isFolder){___setErrNo(ERRNO_CODES.EISDIR);return-1;}
if(isRead&&!target.read||isWrite&&!target.write){___setErrNo(ERRNO_CODES.EACCES);return-1;}
if(isTruncate&&!target.isDevice){target.contents=[];}else{if(!FS.forceLoadFile(target)){___setErrNo(ERRNO_CODES.EIO);return-1;}}
finalPath=path.path;}else{if(!isCreate){___setErrNo(ERRNO_CODES.ENOENT);return-1;}
if(!path.parentObject.write){___setErrNo(ERRNO_CODES.EACCES);return-1;}
target=FS.createDataFile(path.parentObject,path.name,[],mode&0x100,mode&0x80);finalPath=path.parentPath+'/'+path.name;}
var id=FS.streams.length;if(target.isFolder){var entryBuffer=0;if(___dirent_struct_layout){entryBuffer=_malloc(___dirent_struct_layout.__size__);}
var contents=[];for(var key in target.contents)contents.push(key);FS.streams[id]={path:finalPath,object:target,position:-2,isRead:true,isWrite:false,isAppend:false,error:false,eof:false,ungotten:[],contents:contents,currentEntry:entryBuffer};}else{FS.streams[id]={path:finalPath,object:target,position:0,isRead:isRead,isWrite:isWrite,isAppend:isAppend,error:false,eof:false,ungotten:[]};}
return id;}function _fopen(filename,mode){var flags;mode=Pointer_stringify(mode);if(mode[0]=='r'){if(mode.indexOf('+')!=-1){flags=2;}else{flags=0;}}else if(mode[0]=='w'){if(mode.indexOf('+')!=-1){flags=2;}else{flags=1;}
flags|=512;flags|=1024;}else if(mode[0]=='a'){if(mode.indexOf('+')!=-1){flags=2;}else{flags=1;}
flags|=512;flags|=8;}else{___setErrNo(ERRNO_CODES.EINVAL);return 0;}
var ret=_open(filename,flags,allocate([0x1FF,0,0,0],'i32',ALLOC_STACK));return(ret==-1)?0:ret;}
function _memset(ptr,value,num){var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=ptr;$stop$=$dest$+num;$value4$=value;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=value;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=value;}}var _llvm_memset_p0i8_i32=_memset;function _strrchr(ptr,chr){var ptr2=ptr+_strlen(ptr);do{if(HEAP8[(ptr2)]==chr)return ptr2;ptr2--;}while(ptr2>=ptr);return 0;}
function _close(fildes){if(FS.streams[fildes]){if(FS.streams[fildes].currentEntry){_free(FS.streams[fildes].currentEntry);}
delete FS.streams[fildes];return 0;}else{___setErrNo(ERRNO_CODES.EBADF);return-1;}}
function _fsync(fildes){if(FS.streams[fildes]){return 0;}else{___setErrNo(ERRNO_CODES.EBADF);return-1;}}function _fclose(stream){_fsync(stream);return _close(stream);}
function _fflush(stream){var flush=function(filedes){if(filedes in FS.streams&&FS.streams[filedes].object.output){FS.streams[filedes].object.output(null);}};try{if(stream===0){for(var i in FS.streams)flush(i);}else{flush(stream);}
return 0;}catch(e){___setErrNo(ERRNO_CODES.EIO);return-1;}}
function _ftell(stream){if(stream in FS.streams){stream=FS.streams[stream];if(stream.object.isDevice){___setErrNo(ERRNO_CODES.ESPIPE);return-1;}else{return stream.position;}}else{___setErrNo(ERRNO_CODES.EBADF);return-1;}}
function _lseek(fildes,offset,whence){if(FS.streams[fildes]&&!FS.streams[fildes].isDevice){var stream=FS.streams[fildes];var position=offset;if(whence===1){position+=stream.position;}else if(whence===2){position+=stream.object.contents.length;}
if(position<0){___setErrNo(ERRNO_CODES.EINVAL);return-1;}else{stream.ungotten=[];stream.position=position;return position;}}else{___setErrNo(ERRNO_CODES.EBADF);return-1;}}function _fseek(stream,offset,whence){var ret=_lseek(stream,offset,whence);if(ret==-1){return-1;}else{FS.streams[stream].eof=false;return 0;}}
function _strncmp(px,py,n){var i=0;while(i<n){var x=HEAP8[(px+i)];var y=HEAP8[(py+i)];if(x==y&&x==0)return 0;if(x==0)return-1;if(y==0)return 1;if(x==y){i++;continue;}else{return x>y?1:-1;}}
return 0;}function _strcmp(px,py){return _strncmp(px,py,TOTAL_MEMORY);}
function _setlocale(category,locale){if(!_setlocale.ret)_setlocale.ret=allocate([0],'i8',ALLOC_NORMAL);return _setlocale.ret;}
var _environ=null;var ___environ=null;function ___buildEnvironment(env){var MAX_ENV_VALUES=64;var TOTAL_ENV_SIZE=1024;var poolPtr;var envPtr;if(_environ===null){ENV.USER='root';ENV.PATH='/';ENV.PWD='/';ENV.HOME='/';ENV.LANG='en_US.UTF-8';ENV._='./this.program';poolPtr=allocate(TOTAL_ENV_SIZE,'i8',ALLOC_STATIC);envPtr=allocate(MAX_ENV_VALUES*4,'i8*',ALLOC_STATIC);HEAP32[((envPtr)>>2)]=poolPtr;_environ=allocate([envPtr],'i8**',ALLOC_STATIC);___environ=_environ;}else{envPtr=HEAP32[((_environ)>>2)];poolPtr=HEAP32[((envPtr)>>2)];}
var strings=[];var totalSize=0;for(var key in env){if(typeof env[key]==='string'){var line=key+'='+env[key];strings.push(line);totalSize+=line.length;}}
if(totalSize>TOTAL_ENV_SIZE){throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');}
var ptrSize=4;for(var i=0;i<strings.length;i++){var line=strings[i];for(var j=0;j<line.length;j++){HEAP8[(poolPtr+j)]=line.charCodeAt(j);}
HEAP8[(poolPtr+j)]=0;HEAP32[((envPtr+i*ptrSize)>>2)]=poolPtr;poolPtr+=line.length+1;}
HEAP32[((envPtr+strings.length*ptrSize)>>2)]=0;}var ENV={};function _getenv(name){if(name===0)return 0;name=Pointer_stringify(name);if(!ENV.hasOwnProperty(name))return 0;if(_getenv.ret)_free(_getenv.ret);_getenv.ret=allocate(intArrayFromString(ENV[name]),'i8',ALLOC_NORMAL);return _getenv.ret;}
function _access(path,amode){path=Pointer_stringify(path);var target=FS.findObject(path);if(target===null)return-1;if((amode&2&&!target.write)||((amode&1||amode&4)&&!target.read)){___setErrNo(ERRNO_CODES.EACCES);return-1;}else{return 0;}}
function _strcat(pdest,psrc){var len=_strlen(pdest);var i=0;do{var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=psrc+i;$dest$=pdest+len+i;$stop$=$src$+1;if(($dest$%4)==($src$%4)&&1>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
i++;}while(HEAP8[(psrc+i-1)]!=0);return pdest;}
function _pread(fildes,buf,nbyte,offset){var stream=FS.streams[fildes];if(!stream||stream.object.isDevice){___setErrNo(ERRNO_CODES.EBADF);return-1;}else if(!stream.isRead){___setErrNo(ERRNO_CODES.EACCES);return-1;}else if(stream.object.isFolder){___setErrNo(ERRNO_CODES.EISDIR);return-1;}else if(nbyte<0||offset<0){___setErrNo(ERRNO_CODES.EINVAL);return-1;}else{var bytesRead=0;while(stream.ungotten.length&&nbyte>0){HEAP8[(buf++)]=stream.ungotten.pop();nbyte--;bytesRead++;}
var contents=stream.object.contents;var size=Math.min(contents.length-offset,nbyte);for(var i=0;i<size;i++){HEAP8[(buf+i)]=contents[offset+i];bytesRead++;}
return bytesRead;}}function _read(fildes,buf,nbyte){var stream=FS.streams[fildes];if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1;}else if(!stream.isRead){___setErrNo(ERRNO_CODES.EACCES);return-1;}else if(nbyte<0){___setErrNo(ERRNO_CODES.EINVAL);return-1;}else{var bytesRead;if(stream.object.isDevice){if(stream.object.input){bytesRead=0;while(stream.ungotten.length&&nbyte>0){HEAP8[(buf++)]=stream.ungotten.pop();nbyte--;bytesRead++;}
for(var i=0;i<nbyte;i++){try{var result=stream.object.input();}catch(e){___setErrNo(ERRNO_CODES.EIO);return-1;}
if(result===null||typeof result==='undefined')break;bytesRead++;HEAP8[(buf+i)]=result;}
return bytesRead;}else{___setErrNo(ERRNO_CODES.ENXIO);return-1;}}else{var ungotSize=stream.ungotten.length;bytesRead=_pread(fildes,buf,nbyte,stream.position);if(bytesRead!=-1){stream.position+=(stream.ungotten.length-ungotSize)+bytesRead;}
return bytesRead;}}}function _fgetc(stream){if(!(stream in FS.streams))return-1;var streamObj=FS.streams[stream];if(streamObj.eof||streamObj.error)return-1;var ret=_read(stream,_fgetc.ret,1);if(ret==0){streamObj.eof=true;return-1;}else if(ret==-1){streamObj.error=true;return-1;}else{return HEAP8[(_fgetc.ret)];}}function _fgets(s,n,stream){if(!(stream in FS.streams))return 0;var streamObj=FS.streams[stream];if(streamObj.error||streamObj.eof)return 0;var byte_;for(var i=0;i<n-1&&byte_!='\n'.charCodeAt(0);i++){byte_=_fgetc(stream);if(byte_==-1){if(streamObj.error)return 0;else if(streamObj.eof)break;}
HEAP8[(s+i)]=byte_;}
HEAP8[(s+i)]=0;return s;}
function _strstr(ptr1,ptr2){var str1=Pointer_stringify(ptr1);var str2=Pointer_stringify(ptr2);var ret=str1.search(str2);return ret>=0?ptr1+ret:0;}
function _memcmp(p1,p2,num){for(var i=0;i<num;i++){var v1=HEAP8[(p1+i)];var v2=HEAP8[(p2+i)];if(v1!=v2)return v1>v2?1:-1;}
return 0;}
function _memcpy(dest,src,num,idunno){var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=src;$dest$=dest;$stop$=$src$+num;if(($dest$%4)==($src$%4)&&num>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};}function _qsort(base,num,size,comparator){if(num==0||size==0)return;comparator=FUNCTION_TABLE[comparator];var keys=[];for(var i=0;i<num;i++)keys.push(i);keys.sort(function(a,b){return comparator(base+a*size,base+b*size);});var temp=_malloc(num*size);_memcpy(temp,base,num*size);for(var i=0;i<num;i++){if(keys[i]==i)continue;_memcpy(base+i*size,temp+keys[i]*size,size);}
_free(temp);}
function _unlink(path){path=FS.analyzePath(Pointer_stringify(path));if(!path.parentExists||!path.exists){___setErrNo(path.error);return-1;}else if(path.object.isFolder){___setErrNo(ERRNO_CODES.EISDIR);return-1;}else if(!path.object.write){___setErrNo(ERRNO_CODES.EACCES);return-1;}else{delete path.parentObject.contents[path.name];return 0;}}
function _rmdir(path){path=FS.analyzePath(Pointer_stringify(path));if(!path.parentExists||!path.exists){___setErrNo(path.error);return-1;}else if(!path.object.write||path.isRoot){___setErrNo(ERRNO_CODES.EACCES);return-1;}else if(!path.object.isFolder){___setErrNo(ERRNO_CODES.ENOTDIR);return-1;}else{for(var i in path.object.contents){___setErrNo(ERRNO_CODES.ENOTEMPTY);return-1;}
if(path.path==FS.currentPath){___setErrNo(ERRNO_CODES.EBUSY);return-1;}else{delete path.parentObject.contents[path.name];return 0;}}}function _remove(path){var ret=_unlink(path);if(ret==-1)ret=_rmdir(path);return ret;}
var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;function _isalnum(chr){return(chr>=48&&chr<=57)||(chr>=97&&chr<=122)||(chr>=65&&chr<=90)||(chr>=0xC0&&chr<=0xD6)||(chr>=0xDF&&chr<=0xF6)||(chr>=0xD8&&chr<=0xDE)||(chr>=0xF8&&chr<=0xFF);}
function _strchr(ptr,chr){ptr--;do{ptr++;var val=HEAP8[(ptr)];if(val==chr)return ptr;}while(val);return 0;}
function _strncpy(pdest,psrc,num){var padding=false,curr;for(var i=0;i<num;i++){curr=padding?0:HEAP8[(psrc+i)];HEAP8[(pdest+i)]=curr;padding=padding||HEAP8[(psrc+i)]==0;}
return pdest;}
function _fread(ptr,size,nitems,stream){var bytesToRead=nitems*size;if(bytesToRead==0)return 0;var bytesRead=_read(stream,ptr,bytesToRead);var streamObj=FS.streams[stream];if(bytesRead==-1){if(streamObj)streamObj.error=true;return-1;}else{if(bytesRead<bytesToRead)streamObj.eof=true;return Math.floor(bytesRead/size);}}
function _tolower(chr){if((chr>=65&&chr<90)||(chr>=0xC0&&chr<=0xD6)||(chr>=0xD8&&chr<=0xDE))return chr-65+97;return chr;}
function _isalpha(chr){return(chr>=97&&chr<=122)||(chr>=65&&chr<=90)||(chr>=0xC0&&chr<=0xD6)||(chr>=0xDF&&chr<=0xF6)||(chr>=0xD8&&chr<=0xDE)||(chr>=0xF8&&chr<=0xFF);}
function _isupper(chr){return(chr>=65&&chr<=90)||(chr>=0xC0&&chr<=0xD6)||(chr>=0xD8&&chr<=0xDE);}
function _islower(chr){return(chr>=97&&chr<=122)||(chr>=0xDF&&chr<=0xF6)||(chr>=0xF8&&chr<=0xFF);}
function _ispunct(chr){return(chr>=33&&chr<=47)||(chr>=58&&chr<=64)||(chr>=91&&chr<=96)||(chr>=123&&chr<=126);}
var _atof;function _realloc(ptr,size){if(!size){if(ptr)_free(ptr);return 0;}
var ret=_malloc(size);if(ptr){_memcpy(ret,ptr,size);_free(ptr);}
return ret;}
var _mkstemp;function _system(command){___setErrNo(ERRNO_CODES.EAGAIN);return-1;}
function _ungetc(c,stream){if(stream in FS.streams){c=unSign(c&0xFF);FS.streams[stream].ungotten.push(c);return c;}else{return-1;}}
function _strdup(ptr){var len=String_len(ptr);var newStr=_malloc(len+1);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=ptr;$dest$=newStr;$stop$=$src$+len;if(($dest$%4)==($src$%4)&&len>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};HEAP8[(newStr+len)]=0;;return newStr;}
function _kill(pid,sig){___setErrNo(ERRNO_CODES.EPERM);return-1;}
function ___errno_location(){return ___setErrNo.ret;}
var ___errno=___errno_location;var ERRNO_MESSAGES={1:"Operation not permitted",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"Input/output error",6:"No such device or address",8:"Exec format error",9:"Bad file descriptor",10:"No child processes",11:"Resource temporarily unavailable",12:"Cannot allocate memory",13:"Permission denied",14:"Bad address",16:"Device or resource busy",17:"File exists",18:"Invalid cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Inappropriate ioctl for device",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read-only file system",31:"Too many links",32:"Broken pipe",33:"Numerical argument out of domain",34:"Numerical result out of range",35:"Resource deadlock avoided",36:"File name too long",37:"No locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many levels of symbolic links",42:"No message of desired type",43:"Identifier removed",60:"Device not a stream",61:"No data available",62:"Timer expired",63:"Out of streams resources",67:"Link has been severed",71:"Protocol error",72:"Multihop attempted",74:"Bad message",75:"Value too large for defined data type",84:"Invalid or incomplete multibyte or wide character",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Protocol not supported",95:"Operation not supported",97:"Address family not supported by protocol",98:"Address already in use",99:"Cannot assign requested address",100:"Network is down",101:"Network is unreachable",102:"Network dropped connection on reset",103:"Software caused connection abort",104:"Connection reset by peer",105:"No buffer space available",106:"Transport endpoint is already connected",107:"Transport endpoint is not connected",110:"Connection timed out",111:"Connection refused",113:"No route to host",114:"Operation already in progress",115:"Operation now in progress",116:"Stale NFS file handle",122:"Disk quota exceeded",125:"Operation canceled",130:"Owner died",131:"State not recoverable"};function _strerror_r(errnum,strerrbuf,buflen){if(errnum in ERRNO_MESSAGES){if(ERRNO_MESSAGES[errnum].length>buflen-1){return ___setErrNo(ERRNO_CODES.ERANGE);}else{var msg=ERRNO_MESSAGES[errnum];for(var i=0;i<msg.length;i++){HEAP8[(strerrbuf+i)]=msg.charCodeAt(i);}
HEAP8[(strerrbuf+i)]=0;return 0;}}else{return ___setErrNo(ERRNO_CODES.EINVAL);}}function _strerror(errnum){if(!_strerror.buffer)_strerror.buffer=_malloc(256);_strerror_r(errnum,_strerror.buffer,256);return _strerror.buffer;}
function _memmove(dest,src,num,idunno){if(num===0)return;var tmp=_malloc(num);_memcpy(tmp,src,num);_memcpy(dest,tmp,num);_free(tmp);}
var _llvm_memmove_p0i8_p0i8_i32=_memmove;var _llvm_va_start;var _vfprintf=_fprintf;function _llvm_va_end(){}
function _wait(stat_loc){___setErrNo(ERRNO_CODES.ECHILD);return-1;}
var _waitpid=_wait;var _vsnprintf=_snprintf;var ___pollfd_struct_layout=null;function _poll(fds,nfds,timeout){var offsets=___pollfd_struct_layout;var nonzero=0;for(var i=0;i<nfds;i++){var pollfd=fds+___pollfd_struct_layout.__size__*i;var fd=HEAP32[((pollfd+offsets.fd)>>2)];var events=HEAP16[((pollfd+offsets.events)>>1)];var revents=0;if(fd in FS.streams){var stream=FS.streams[fd];if(events&1)revents|=1;if(events&2)revents|=2;}else{if(events&4)revents|=4;}
if(revents)nonzero++;HEAP16[((pollfd+offsets.revents)>>1)]=revents;}
return nonzero;}
function _memchr(ptr,chr,num){chr=unSign(chr);for(var i=0;i<num;i++){if(HEAP8[(ptr)]==chr)return ptr;ptr++;}
return 0;}
function _fork(){___setErrNo(ERRNO_CODES.EAGAIN);return-1;}
var ___flock_struct_layout=null;function _fcntl(fildes,cmd,varargs){if(!(fildes in FS.streams)){___setErrNo(ERRNO_CODES.EBADF);return-1;}
var stream=FS.streams[fildes];switch(cmd){case 0:var arg=HEAP32[((varargs)>>2)];if(arg<0){___setErrNo(ERRNO_CODES.EINVAL);return-1;}
var newStream={};for(var member in stream){newStream[member]=stream[member];}
if(arg in FS.streams)arg=FS.streams.length;FS.streams[arg]=newStream;return arg;case 1:case 2:return 0;case 3:var flags=0;if(stream.isRead&&stream.isWrite)flags=2;else if(!stream.isRead&&stream.isWrite)flags=1;else if(stream.isRead&&!stream.isWrite)flags=0;if(stream.isAppend)flags|=8;return flags;case 4:var arg=HEAP32[((varargs)>>2)];stream.isAppend=Boolean(arg|8);return 0;case 7:case 20:var arg=HEAP32[((varargs)>>2)];var offset=___flock_struct_layout.l_type;HEAP16[((arg+offset)>>1)]=3;return 0;case 8:case 9:case 21:case 22:return 0;case 6:case 5:___setErrNo(ERRNO_CODES.EINVAL);return-1;default:___setErrNo(ERRNO_CODES.EINVAL);return-1;}
return-1;}
function _dup2(fildes,fildes2){if(fildes2<0){___setErrNo(ERRNO_CODES.EBADF);return-1;}else if(fildes===fildes2&&FS.streams[fildes]){return fildes;}else{_close(fildes2);return _fcntl(fildes,0,allocate([fildes2,0,0,0],'i32',ALLOC_STACK));}}
function _signal(sig,func){return 0;}
function _execl(){___setErrNo(ERRNO_CODES.ENOEXEC);return-1;}
var _execlp=_execl;function _pipe(fildes){___setErrNo(ERRNO_CODES.ENOSYS);return-1;}
function _opendir(dirname){var path=FS.absolutePath(Pointer_stringify(dirname));if(path===null){___setErrNo(ERRNO_CODES.ENOENT);return 0;}
var target=FS.findObject(path);if(target===null)return 0;if(!target.isFolder){___setErrNo(ERRNO_CODES.ENOTDIR);return 0;}else if(!target.read){___setErrNo(ERRNO_CODES.EACCES);return 0;}
var id=FS.streams.length;var contents=[];for(var key in target.contents)contents.push(key);FS.streams[id]={path:path,object:target,position:-2,isRead:true,isWrite:false,isAppend:false,error:false,eof:false,ungotten:[],contents:contents,currentEntry:_malloc(___dirent_struct_layout.__size__)};return id;}
function _readdir_r(dirp,entry,result){if(!FS.streams[dirp]||!FS.streams[dirp].object.isFolder){return ___setErrNo(ERRNO_CODES.EBADF);}
var stream=FS.streams[dirp];var loc=stream.position;var entries=0;for(var key in stream.contents)entries++;if(loc<-2||loc>=entries){HEAP32[((result)>>2)]=0;}else{var name,inode;if(loc===-2){name='.';inode=1;}else if(loc===-1){name='..';inode=1;}else{name=stream.contents[loc];inode=stream.object.contents[name].inodeNumber;}
stream.position++;var offsets=___dirent_struct_layout;HEAP32[((entry+offsets.d_ino)>>2)]=inode;HEAP32[((entry+offsets.d_off)>>2)]=stream.position;HEAP32[((entry+offsets.d_reclen)>>2)]=name.length+1;for(var i=0;i<name.length;i++){HEAP8[(entry+offsets.d_name+i)]=name.charCodeAt(i);}
HEAP8[(entry+offsets.d_name+i)]=0;var type=stream.object.isDevice?2:stream.object.isFolder?4:(typeof stream.object.link!=='undefined')?10:8;HEAP8[(entry+offsets.d_type)]=type;HEAP32[((result)>>2)]=entry;}
return 0;}
function _readdir(dirp){if(!FS.streams[dirp]||!FS.streams[dirp].object.isFolder){___setErrNo(ERRNO_CODES.EBADF);return 0;}else{if(!_readdir.result)_readdir.result=_malloc(4);_readdir_r(dirp,FS.streams[dirp].currentEntry,_readdir.result);if(HEAP32[((_readdir.result)>>2)]===0){return 0;}else{return FS.streams[dirp].currentEntry;}}}
function _closedir(dirp){if(!FS.streams[dirp]||!FS.streams[dirp].object.isFolder){return ___setErrNo(ERRNO_CODES.EBADF);}else{_free(FS.streams[dirp].currentEntry);delete FS.streams[dirp];return 0;}}
function _calloc(n,s){var ret=_malloc(n*s);_memset(ret,0,n*s);return ret;}
var _cos=Math.cos;var ___rand_state=42;function _rand(){___rand_state=(1103515245*___rand_state+12345)%0x100000000;return ___rand_state&0x7FFFFFFF;}
var _exp=Math.exp;var _sin=Math.sin;var _vsprintf=_sprintf;function _fputs(s,stream){return _write(stream,s,_strlen(s));}
function _exp2(x){return Math.pow(2,x);}
function __Z13GetFileLengthPKc($filename){var __stackBase__=STACKTOP;STACKTOP+=80;_memset(__stackBase__,0,80);var __label__;var $retval;var $filename_addr;var $statbuf=__stackBase__;$filename_addr=$filename;var $0=$filename_addr;var $call=_stat($0,$statbuf);var $cmp=((($call))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=0;;}
else if(__label__==2){var $st_mode=(($statbuf+12)&4294967295);var $1=HEAP32[(($st_mode)>>2)];var $and=($1)&61440;var $cmp1=((($and))|0)==16384;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){$retval=-2;;}
else if(__label__==4){var $st_size=(($statbuf+36)&4294967295);var $2=HEAP32[(($st_size)>>2)];$retval=$2;;}}
var $3=$retval;STACKTOP=__stackBase__;return $3;return null;}
function __Z5Alloci($size){;var __label__;var $size_addr;var $p;$size_addr=$size;var $0=$size_addr;var $call=_malloc($0);$p=$call;var $cmp=((($call))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($1+12)&4294967295);var $2=HEAP32[(($_stderr)>>2)];var $3=_fwrite(((__str106)&4294967295),22,1,$2);;}
var $4=$p;;return $4;return null;}
function __Z4FreePv($ptr){;var __label__;var $ptr_addr;$ptr_addr=$ptr;var $0=$ptr_addr;var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$ptr_addr;;;};return;return;}
function __Z13DisplayVoicesP7__sFILEPc($f_out,$language){var __stackBase__=STACKTOP;STACKTOP+=36;_memset(__stackBase__,0,36);var __label__;var $f_out_addr;var $language_addr;var $ix;var $p;var $len;var $count;var $scores;var $v;var $lang_name;var $age_buf=__stackBase__;var $voices;var $voice_select=__stackBase__+12;$f_out_addr=$f_out;$language_addr=$language;$scores=0;var $0=$language_addr;var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=3;;}
$land_lhs_true$$if_else$2:do{if(__label__==1){var $1=$language_addr;var $arrayidx=(($1)&4294967295);var $2=HEAP8[($arrayidx)];var $conv=(tempInt=(($2)),(tempInt>=128?tempInt-256:tempInt));var $cmp1=((($conv))|0)!=0;if(!($cmp1)){__label__=3;break $land_lhs_true$$if_else$2;}
var $3=$language_addr;var $languages=(($voice_select+4)&4294967295);HEAP32[(($languages)>>2)]=$3;var $age=(($voice_select+13)&4294967295);HEAP8[($age)]=0;var $gender=(($voice_select+12)&4294967295);HEAP8[($gender)]=0;var $name=(($voice_select)&4294967295);HEAP32[(($name)>>2)]=0;var $call=_espeak_ListVoices($voice_select);$voices=((__ZZ17espeak_ListVoicesE6voices)&4294967295);$scores=1;__label__=4;break $land_lhs_true$$if_else$2;}}while(0);if(__label__==3){var $call2=_espeak_ListVoices(0);$voices=((__ZZ17espeak_ListVoicesE6voices)&4294967295);;}
var $4=$f_out_addr;var $5=_fwrite(((__str1)&4294967295),64,1,$4);$ix=0;var $6=$ix;var $7=$voices;var $arrayidx43=(($7+4*$6)&4294967295);var $8=HEAP32[(($arrayidx43)>>2)];$v=$8;var $cmp54=((($8))|0)!=0;if($cmp54){__label__=5;;}else{__label__=15;;}
$for_body_lr_ph$$for_end$8:do{if(__label__==5){var $arraydecay=(($age_buf)&4294967295);var $arraydecay26=(($age_buf)&4294967295);;$for_body$10:while(1){$count=0;var $9=$v;var $languages6=(($9+4)&4294967295);var $10=HEAP32[(($languages6)>>2)];$p=$10;var $11=$p;var $12=HEAP8[($11)];var $conv71=(tempInt=(($12)),(tempInt>=128?tempInt-256:tempInt));var $cmp82=((($conv71))|0)!=0;if($cmp82){__label__=7;;}else{__label__=14;;}
$while_body$$while_end$12:do{if(__label__==7){while(1){var $13=$p;var $add_ptr=(($13+1)&4294967295);var $call9=_strlen($add_ptr);$len=$call9;var $14=$p;var $add_ptr10=(($14+1)&4294967295);$lang_name=$add_ptr10;var $15=$v;var $age11=(($15+13)&4294967295);var $16=HEAPU8[($age11)];var $conv12=((($16))&255);var $cmp13=((($conv12))|0)==0;if($cmp13){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str41208)&4294967295);$dest$=$arraydecay;$stop$=$src$+4;if(($dest$%4)==($src$%4)&&4>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}
else if(__label__==9){var $17=$v;var $age18=(($17+13)&4294967295);var $18=HEAPU8[($age18)];var $conv19=((($18))&255);var $call20=_sprintf($arraydecay,((__str3)&4294967295),allocate([$conv19,0,0,0],["i32",0,0,0],ALLOC_STACK));;}
var $19=$count;var $cmp22=((($19))|0)==0;var $20=$f_out_addr;if($cmp22){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $21=$p;var $arrayidx24=(($21)&4294967295);var $22=HEAP8[($arrayidx24)];var $conv25=(tempInt=(($22)),(tempInt>=128?tempInt-256:tempInt));var $23=$lang_name;var $24=$v;var $gender27=(($24+12)&4294967295);var $25=HEAPU8[($gender27)];var $idxprom=((($25))&255);var $arrayidx28=((__ZZ13DisplayVoicesP7__sFILEPcE7genders+$idxprom)&4294967295);var $26=HEAP8[($arrayidx28)];var $conv29=(tempInt=(($26)),(tempInt>=128?tempInt-256:tempInt));var $27=$v;var $name30=(($27)&4294967295);var $28=HEAP32[(($name30)>>2)];var $29=$v;var $identifier=(($29+8)&4294967295);var $30=HEAP32[(($identifier)>>2)];var $call31=_fprintf($20,((__str4)&4294967295),allocate([$conv25,0,0,0,$23,0,0,0,$arraydecay26,0,0,0,$conv29,0,0,0,$28,0,0,0,$30,0,0,0],["i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==12){var $31=$lang_name;var $32=$p;var $arrayidx33=(($32)&4294967295);var $33=HEAP8[($arrayidx33)];var $conv34=(tempInt=(($33)),(tempInt>=128?tempInt-256:tempInt));var $call35=_fprintf($20,((__str5)&4294967295),allocate([$31,0,0,0,$conv34,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));;}
var $34=$count;var $inc=((($34)+1)&4294967295);$count=$inc;var $35=$len;var $add=((($35)+2)&4294967295);var $36=$p;var $add_ptr37=(($36+$add)&4294967295);$p=$add_ptr37;var $37=$p;var $38=HEAP8[($37)];var $conv7=(tempInt=(($38)),(tempInt>=128?tempInt-256:tempInt));var $cmp8=((($conv7))|0)!=0;if($cmp8){__label__=7;continue;}else{__label__=14;break $while_body$$while_end$12;}}}}while(0);var $39=$f_out_addr;var $call38=_fputc(10,$39);var $40=$ix;var $inc39=((($40)+1)&4294967295);$ix=$inc39;var $41=$ix;var $42=$voices;var $arrayidx4=(($42+4*$41)&4294967295);var $43=HEAP32[(($arrayidx4)>>2)];$v=$43;var $cmp5=((($43))|0)!=0;if($cmp5){__label__=6;continue $for_body$10;}else{__label__=15;break $for_body_lr_ph$$for_end$8;}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __Z13WVoiceChangedP7voice_t($wvoice){;var __label__;;return;return;}
function __Z11MarkerEventijiPh($type,$char_position,$value,$out_ptr){;var __label__;var $type_addr;var $char_position_addr;var $value_addr;var $out_ptr_addr;$type_addr=$type;$char_position_addr=$char_position;$value_addr=$value;$out_ptr_addr=$out_ptr;var $0=$type_addr;var $cmp=((($0))|0)==2;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){HEAP32[((_end_of_sentence)>>2)]=1;;};return;return;}
function _main($argc,$argv){;var __label__;var __lastLabel__=null;var $_ZL9help_text;$_ZL9help_text=((__str37)&4294967295);var $_ZZ4mainE8err_load;$_ZZ4mainE8err_load=((__str18)&4294967295);var $retval;var $argc_addr;var $argv_addr;var $f_text;var $p_text;var $data_path;var $option_index=STACKTOP;_memset(STACKTOP,0,4);STACKTOP+=4;STACKTOP=Math.ceil((STACKTOP)/4)*4;;var $c;var $value=STACKTOP;_memset(STACKTOP,0,4);STACKTOP+=4;STACKTOP=Math.ceil((STACKTOP)/4)*4;;var $speed;var $ix;var $optarg2;var $amp;var $wordgap;var $speaking;var $flag_stdin;var $flag_compile;var $pitch_adjustment;var $voice_select=STACKTOP;_memset(STACKTOP,0,24);STACKTOP+=24;STACKTOP=Math.ceil((STACKTOP)/4)*4;;var $filename=STACKTOP;_memset(STACKTOP,0,200);STACKTOP+=200;STACKTOP=Math.ceil((STACKTOP)/4)*4;;var $voicename=STACKTOP;_memset(STACKTOP,0,40);STACKTOP+=40;STACKTOP=Math.ceil((STACKTOP)/4)*4;;var $dictname=STACKTOP;_memset(STACKTOP,0,40);STACKTOP+=40;STACKTOP=Math.ceil((STACKTOP)/4)*4;;var $extn;$retval=0;$argc_addr=$argc;$argv_addr=$argv;$f_text=0;$p_text=0;$data_path=0;HEAP32[(($option_index)>>2)]=0;$speed=175;$amp=100;$wordgap=0;$speaking=0;$flag_stdin=0;$flag_compile=0;$pitch_adjustment=50;var $arrayidx=(($voicename)&4294967295);HEAP8[($arrayidx)]=0;HEAP8[(((_mbrola_name)&4294967295))]=0;var $arrayidx1=(($dictname)&4294967295);HEAP8[($arrayidx1)]=0;HEAP8[(((_wavefile)&4294967295))]=0;var $arrayidx2=(($filename)&4294967295);HEAP8[($arrayidx2)]=0;HEAP32[((_option_linelength)>>2)]=0;HEAP32[((_option_phonemes)>>2)]=0;HEAP32[((_option_waveout)>>2)]=0;HEAP32[((_option_wordgap)>>2)]=0;HEAP32[((_option_endpause)>>2)]=1;HEAP32[((_option_phoneme_input)>>2)]=1;HEAP32[((_option_multibyte)>>2)]=0;var $0=HEAP32[((__impure_ptr)>>2)];var $_stdout=(($0+8)&4294967295);var $1=HEAP32[(($_stdout)>>2)];HEAP32[((_f_trans)>>2)]=$1;var $2=$argc_addr;var $3=$argv_addr;var $call6=_getopt_long($2,$3,((__str19)&4294967295),((__ZZ4mainE12long_options)&4294967295),$option_index);$c=$call6;var $cmp7=((($call6))|0)==-1;if($cmp7){__label__=43;;}else{__label__=1;;}
$while_end71$$if_end_lr_ph$2:do{if(__label__==1){var $arraydecay=(($filename)&4294967295);var $arraydecay32=(($voicename)&4294967295);var $arraydecay41=(($voicename)&4294967295);var $_pr8=$c;__lastLabel__=1;;$if_end$4:while(1){var $4=__lastLabel__==1?$_pr8:($call);var $5=HEAP32[((_optarg)>>2)];$optarg2=$5;if($4==98){__lastLabel__=2;__label__=3;;}
else if($4==104){__lastLabel__=2;__label__=5;;}
else if($4==107){__lastLabel__=2;__label__=6;;}
else if($4==120){__lastLabel__=2;__label__=7;;}
else if($4==88){__lastLabel__=2;__label__=8;;}
else if($4==109){__lastLabel__=2;__label__=9;;}
else if($4==112){__lastLabel__=2;__label__=10;;}
else if($4==113){__lastLabel__=2;__label__=12;;}
else if($4==102){__lastLabel__=2;__label__=13;;}
else if($4==108){__lastLabel__=2;__label__=14;;}
else if($4==97){__lastLabel__=2;__label__=15;;}
else if($4==115){__lastLabel__=2;__label__=16;;}
else if($4==103){__lastLabel__=2;__label__=17;;}
else if($4==118){__lastLabel__=2;__label__=18;;}
else if($4==119){__lastLabel__=2;__label__=19;;}
else if($4==122){__lastLabel__=2;__label__=20;;}
else if($4==256){__lastLabel__=2;__label__=21;;}
else if($4==261){__lastLabel__=2;__label__=22;;}
else if($4==257){__lastLabel__=2;__label__=23;;}
else if($4==258){__lastLabel__=2;__label__=23;;}
else if($4==259){__lastLabel__=2;__label__=26;;}
else if($4==260){__lastLabel__=2;__label__=32;;}
else if($4==262){__lastLabel__=2;__label__=33;;}
else if($4==263){__lastLabel__=2;__label__=36;;}
else if($4==264){__lastLabel__=2;__label__=37;;}
else if($4==265){__lastLabel__=2;__label__=40;;}
else if($4==266){__lastLabel__=2;__label__=41;;}
else{__lastLabel__=2;__label__=42;;}
$sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6:do{if(__label__==42){_exit(0);__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==3){HEAP32[((_option_multibyte)>>2)]=2;var $6=$optarg2;var $call3=_sscanf($6,((__str63715)&4294967295),allocate([$value,0,0,0],["i32*",0,0,0],ALLOC_STACK));var $cmp4=((($call3))|0)==1;var $7=HEAP32[(($value)>>2)];var $cmp5=((($7))|0)<=4;var $or_cond=($cmp4)&($cmp5);if(!($or_cond)){__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
var $8=HEAP32[(($value)>>2)];HEAP32[((_option_multibyte)>>2)]=$8;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==5){var $9=$argv_addr;var $arrayidx9=(($9)&4294967295);var $10=HEAP32[(($arrayidx9)>>2)];var $11=$data_path;__ZL9init_pathPcS_($10,$11);var $12=HEAP32[((_version_string)>>2)];var $13=$_ZL9help_text;var $call10=_printf(((__str21)&4294967295),allocate([$12,0,0,0,((_path_home)&4294967295),0,0,0,$13,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));_exit(0);__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==6){var $14=$optarg2;var $call12=_atoi($14);HEAP32[((_option_capitals)>>2)]=$call12;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==7){HEAP32[((_option_phonemes)>>2)]=1;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==8){HEAP32[((_option_phonemes)>>2)]=2;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==9){HEAP32[((_option_ssml)>>2)]=1;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==10){var $15=$optarg2;var $call17=_atoi($15);$pitch_adjustment=$call17;var $16=$pitch_adjustment;var $cmp18=((($16))|0)>99;if(!($cmp18)){__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
$pitch_adjustment=99;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==12){HEAP32[((_quiet)>>2)]=1;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==13){var $17=$optarg2;__Z8strncpy0PcPKci($arraydecay,$17,200);__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==14){HEAP32[(($value)>>2)]=0;var $18=$optarg2;var $call24=_atoi($18);HEAP32[(($value)>>2)]=$call24;var $19=HEAP32[(($value)>>2)];HEAP32[((_option_linelength)>>2)]=$19;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==15){var $20=$optarg2;var $call26=_atoi($20);$amp=$call26;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==16){var $21=$optarg2;var $call28=_atoi($21);$speed=$call28;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==17){var $22=$optarg2;var $call30=_atoi($22);$wordgap=$call30;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==18){var $23=$optarg2;__Z8strncpy0PcPKci($arraydecay32,$23,40);__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==19){HEAP32[((_option_waveout)>>2)]=1;var $24=$optarg2;__Z8strncpy0PcPKci(((_wavefile)&4294967295),$24,200);__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==20){HEAP32[((_option_endpause)>>2)]=0;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==21){$flag_stdin=1;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==22){HEAP32[((_option_waveout)>>2)]=1;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str12)&4294967295);$dest$=((_wavefile)&4294967295);$stop$=$src$+7;if(($dest$%4)==($src$%4)&&7>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==23){var $cmp39=((($5))|0)!=0;if($cmp39){__label__=24;;}else{__label__=25;;}
if(__label__==24){var $25=$optarg2;__Z8strncpy0PcPKci($arraydecay41,$25,40);;}
var $26=$c;$flag_compile=$26;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==26){HEAP32[((_option_punctuation)>>2)]=1;var $27=$optarg2;var $cmp44=((($27))|0)!=0;if(!($cmp44)){__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
$ix=0;__lastLabel__=27;;while(1){var $28=__lastLabel__==30?$inc:(0);var $cmp47=((($28))|0)<60;if(!($cmp47)){__label__=31;break;}
var $29=$ix;var $30=$optarg2;var $arrayidx48=(($30+$29)&4294967295);var $31=HEAP8[($arrayidx48)];var $conv=(tempInt=(($31)),(tempInt>=128?tempInt-256:tempInt));var $32=$ix;var $arrayidx49=((_option_punctlist+$32*4)&4294967295);HEAP32[(($arrayidx49)>>2)]=$conv;var $cmp50=((($conv))|0)!=0;if(!($cmp50)){__label__=31;break;}
var $33=$ix;var $inc=((($33)+1)&4294967295);$ix=$inc;__lastLabel__=30;__label__=28;continue;}
HEAP32[((((_option_punctlist+236)&4294967295))>>2)]=0;HEAP32[((_option_punctuation)>>2)]=2;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==32){var $34=$argv_addr;var $arrayidx54=(($34)&4294967295);var $35=HEAP32[(($arrayidx54)>>2)];var $36=$data_path;__ZL9init_pathPcS_($35,$36);var $37=HEAP32[((__impure_ptr)>>2)];var $_stdout55=(($37+8)&4294967295);var $38=HEAP32[(($_stdout55)>>2)];var $39=$optarg2;__Z13DisplayVoicesP7__sFILEPc($38,$39);_exit(0);var $_pr=$optarg2;__lastLabel__=32;__label__=33;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==36){var $42=$optarg2;$data_path=$42;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==37){var $43=$optarg2;var $call63=_fopen($43,((__str11422)&4294967295));HEAP32[((_f_trans)>>2)]=$call63;var $cmp64=((($call63))|0)==0;if(!($cmp64)){__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
var $46=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($46+12)&4294967295);var $47=HEAP32[(($_stderr)>>2)];var $48=$optarg2;var $call66=_fprintf($47,((__str23)&4294967295),allocate([$48,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $49=HEAP32[((__impure_ptr)>>2)];var $_stderr67=(($49+12)&4294967295);var $50=HEAP32[(($_stderr67)>>2)];HEAP32[((_f_trans)>>2)]=$50;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==40){HEAP32[((_option_mbrola_phonemes)>>2)]=16;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}
else if(__label__==41){HEAP32[((_option_phonemes)>>2)]=3;__label__=38;break $sw_default$$sw_bb$$sw_bb8$$sw_bb11$$sw_bb13$$sw_bb14$$sw_bb15$$sw_bb16$$sw_bb21$$sw_bb22$$sw_bb23$$sw_bb25$$sw_bb27$$sw_bb29$$sw_bb31$$sw_bb33$$sw_bb34$$sw_bb35$$sw_bb36$$sw_bb38$$sw_bb43$$sw_bb53$$sw_bb56$$sw_bb61$$sw_bb62$$sw_bb69$$sw_bb70$6;}}while(0);if(__label__==33){var $40=__lastLabel__==32?$_pr:($5);var $cmp57=((($40))|0)==0;if($cmp57){__label__=34;;}else{__label__=35;;}
if(__label__==34){HEAP32[((_samples_split)>>2)]=30;;}
else if(__label__==35){var $41=$optarg2;var $call59=_atoi($41);HEAP32[((_samples_split)>>2)]=$call59;;}}
var $44=$argc_addr;var $45=$argv_addr;var $call=_getopt_long($44,$45,((__str19)&4294967295),((__ZZ4mainE12long_options)&4294967295),$option_index);$c=$call;var $cmp=((($call))|0)==-1;if($cmp){__lastLabel__=38;__label__=43;break $while_end71$$if_end_lr_ph$2;}else{__lastLabel__=38;__label__=2;continue $if_end$4;}}}}while(0);var $51=$argv_addr;var $arrayidx72=(($51)&4294967295);var $52=HEAP32[(($arrayidx72)>>2)];var $53=$data_path;__ZL9init_pathPcS_($52,$53);__ZL10initialisev();var $54=$flag_compile;var $tobool=((($54))|0)!=0;if($tobool){__label__=44;;}else{__label__=45;;}
if(__label__==44){var $arraydecay75=(($voicename)&4294967295);var $call76=__Z9LoadVoicePKci($arraydecay75,5);var $55=$flag_compile;var $and=($55)&1;var $call77=__Z17CompileDictionaryPKcS0_P7__sFILEPci(0,((_dictionary_name)&4294967295),0,0,$and);_exit(0);;}
var $arrayidx79=(($voicename)&4294967295);var $56=HEAP8[($arrayidx79)];var $conv80=(tempInt=(($56)),(tempInt>=128?tempInt-256:tempInt));var $cmp81=((($conv80))|0)==0;if($cmp81){__label__=46;;}else{__label__=47;;}
if(__label__==46){var $arraydecay83=(($voicename)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str45697)&4294967295);$dest$=$arraydecay83;$stop$=$src$+8;if(($dest$%4)==($src$%4)&&8>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}
var $arraydecay86=(($voicename)&4294967295);var $call87=__Z14SetVoiceByNamePKc($arraydecay86);var $cmp88=((($call87))|0)!=0;if($cmp88){__label__=48;;}else{__label__=50;;}
$if_then89$$if_end98$58:do{if(__label__==48){var $57=$voice_select;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$57;$stop$=$dest$+24;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $arraydecay90=(($voicename)&4294967295);var $languages=(($voice_select+4)&4294967295);HEAP32[(($languages)>>2)]=$arraydecay90;var $call91=__Z20SetVoiceByPropertiesP12espeak_VOICE($voice_select);var $cmp92=((($call91))|0)!=0;if(!($cmp92)){__label__=50;break $if_then89$$if_end98$58;}
var $58=HEAP32[((__impure_ptr)>>2)];var $_stderr94=(($58+12)&4294967295);var $59=HEAP32[(($_stderr94)>>2)];var $60=$_ZZ4mainE8err_load;var $arraydecay95=(($voicename)&4294967295);var $call96=_fprintf($59,((__str25)&4294967295),allocate([$60,0,0,0,$arraydecay95,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));_exit(2);;}}while(0);var $61=$speed;__Z12SetParameteriii(1,$61,0);var $62=$amp;__Z12SetParameteriii(2,$62,0);var $63=HEAP32[((_option_capitals)>>2)];__Z12SetParameteriii(6,$63,0);var $64=HEAP32[((_option_punctuation)>>2)];__Z12SetParameteriii(5,$64,0);var $65=$wordgap;__Z12SetParameteriii(7,$65,0);var $66=$pitch_adjustment;var $cmp99=((($66))|0)!=50;if($cmp99){__label__=51;;}else{__label__=52;;}
if(__label__==51){var $67=$pitch_adjustment;__Z12SetParameteriii(3,$67,0);;}
var $68=HEAP32[((_voice)>>2)];__Z13DoVoiceChangeP7voice_t($68);var $arrayidx102=(($filename)&4294967295);var $69=HEAP8[($arrayidx102)];var $conv103=(tempInt=(($69)),(tempInt>=128?tempInt-256:tempInt));var $cmp104=((($conv103))|0)==0;if($cmp104){__label__=53;;}else{__label__=59;;}
$if_then105$$if_else116$65:do{if(__label__==53){var $70=HEAP32[((_optind)>>2)];var $71=$argc_addr;var $cmp106=((($70))|0)<((($71))|0);var $72=$flag_stdin;if($cmp106){__label__=54;;}else{__label__=57;;}
if(__label__==54){var $cmp108=((($72))|0)==0;if($cmp108){__label__=56;;}else{__label__=55;;}
if(__label__==56){var $75=HEAP32[((_optind)>>2)];var $76=$argv_addr;var $arrayidx110=(($76+4*$75)&4294967295);var $77=HEAP32[(($arrayidx110)>>2)];$p_text=$77;;}
else if(__label__==55){var $73=HEAP32[((__impure_ptr)>>2)];var $_stdin3=(($73+4)&4294967295);var $74=HEAP32[(($_stdin3)>>2)];$f_text=$74;__lastLabel__=55;__label__=61;break $if_then105$$if_else116$65;}}
else if(__label__==57){var $78=HEAP32[((__impure_ptr)>>2)];var $_stdin=(($78+4)&4294967295);var $79=HEAP32[(($_stdin)>>2)];$f_text=$79;var $cmp112=((($72))|0)==0;if($cmp112){__lastLabel__=57;;}else{__lastLabel__=57;__label__=61;break $if_then105$$if_else116$65;}
HEAP32[((_option_linelength)>>2)]=-1;;}
var $_pr5=$f_text;__lastLabel__=60;;}
else if(__label__==59){var $arraydecay117=(($filename)&4294967295);var $call118=_fopen($arraydecay117,((__str51703)&4294967295));$f_text=$call118;__lastLabel__=59;;}}while(0);var $80=__lastLabel__==60?$_pr5:(__lastLabel__==55?$74:(__lastLabel__==57?$79:($call118)));var $cmp120=((($80))|0)==0;if($cmp120){__label__=62;;}else{__label__=64;;}
$land_lhs_true121$$if_end127$77:do{if(__label__==62){var $81=$p_text;var $cmp122=((($81))|0)==0;if(!($cmp122)){__label__=64;break $land_lhs_true121$$if_end127$77;}
var $82=HEAP32[((__impure_ptr)>>2)];var $_stderr124=(($82+12)&4294967295);var $83=HEAP32[(($_stderr124)>>2)];var $84=$_ZZ4mainE8err_load;var $arraydecay125=(($filename)&4294967295);var $call126=_fprintf($83,((__str27)&4294967295),allocate([$84,0,0,0,$arraydecay125,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));_exit(1);;}}while(0);var $85=HEAP32[((_option_waveout)>>2)];var $tobool128=((($85))|0)!=0;var $86=HEAP32[((_quiet)>>2)];var $tobool129=((($86))|0)!=0;var $or_cond1=($tobool128)|($tobool129);if($or_cond1){__label__=65;;}else{__label__=79;;}
$if_then130$$if_else168$81:do{if(__label__==65){var $87=HEAP32[((_quiet)>>2)];var $tobool131=((($87))|0)!=0;var $88=HEAP32[((_samplerate)>>2)];if($tobool131){__label__=66;;}else{__label__=67;;}
$if_then132$$if_else134$83:do{if(__label__==66){var $call133=__ZL12OpenWaveFilePKci(0,$88);HEAP32[((_option_waveout)>>2)]=1;;}
else if(__label__==67){var $89=HEAP32[((_samples_split)>>2)];var $mul=((($88)*60)&4294967295);var $mul135=((($mul)*($89))&4294967295);HEAP32[((_samples_split)>>2)]=$mul135;var $90=HEAP32[((_samples_split)>>2)];var $tobool136=((($90))|0)!=0;if($tobool136){__label__=68;;}else{__label__=71;;}
if(__label__==68){var $call138=_strrchr(((_wavefile)&4294967295),46);$extn=$call138;var $91=$extn;var $cmp139=((($91))|0)!=0;if(!($cmp139)){__label__=73;break $if_then132$$if_else134$83;}
var $call141=_strlen(((_wavefile)&4294967295));var $add_ptr=((((_wavefile)&4294967295)+$call141)&4294967295);var $92=$extn;var $sub_ptr_lhs_cast=($add_ptr);var $sub_ptr_rhs_cast=($92);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $cmp142=((($sub_ptr_sub))|0)<=4;if(!($cmp142)){__label__=73;break $if_then132$$if_else134$83;}
var $93=$extn;var $call144=_strcpy(((_filetype)&4294967295),$93);var $94=$extn;HEAP8[($94)]=0;;}
else if(__label__==71){var $95=HEAP32[((_samplerate)>>2)];var $call147=__ZL12OpenWaveFilePKci(((_wavefile)&4294967295),$95);var $cmp148=((($call147))|0)!=0;if(!($cmp148)){__label__=73;break $if_then132$$if_else134$83;}
var $96=HEAP32[((__impure_ptr)>>2)];var $_stderr150=(($96+12)&4294967295);var $97=HEAP32[(($_stderr150)>>2)];var $call151=_fprintf($97,((__str28)&4294967295),allocate([((_wavefile)&4294967295),0,0,0],["i8*",0,0,0],ALLOC_STACK));_exit(3);;}}}while(0);__Z8InitTexti(0);var $98=$f_text;var $99=$p_text;var $call155=__Z15SpeakNextClauseP7__sFILEPKvi($98,$99,0);$ix=1;;while(1){var $call156=__ZL11WavegenFilev();var $cmp157=((($call156))|0)!=0;if($cmp157){__label__=75;;}else{__label__=76;;}
if(__label__==75){var $100=$ix;var $cmp159=((($100))|0)==0;if($cmp159){__label__=78;break;}}
var $call163=__Z8GenerateP12PHONEME_LISTPii(((_phoneme_list)&4294967295),_n_phoneme_list,1);var $cmp164=((($call163))|0)==0;if(!($cmp164)){__label__=74;continue;}
var $call166=__Z15SpeakNextClauseP7__sFILEPKvi(0,0,1);$ix=$call166;__label__=74;continue;}
__ZL13CloseWaveFilev();__label__=83;break $if_then130$$if_else168$81;}
else if(__label__==79){__Z8InitTexti(0);var $101=$f_text;var $102=$p_text;var $call170=__Z15SpeakNextClauseP7__sFILEPKvi($101,$102,0);var $103=HEAP32[((_option_quiet)>>2)];var $tobool171=((($103))|0)!=0;if($tobool171){__label__=80;;}else{__label__=82;;}
if(__label__==80){while(1){var $call173=__Z15SpeakNextClauseP7__sFILEPKvi(0,0,1);var $cmp174=((($call173))|0)!=0;if($cmp174){__label__=80;continue;}else{__label__=81;break;}}
$retval=0;__label__=87;break $if_then130$$if_else168$81;}
else if(__label__==82){var $104=HEAP32[((__impure_ptr)>>2)];var $_stderr178=(($104+12)&4294967295);var $105=HEAP32[(($_stderr178)>>2)];var $106=_fwrite(((__str29)&4294967295),79,1,$105);__label__=83;break $if_then130$$if_else168$81;}}}while(0);if(__label__==83){var $107=HEAP32[((_f_trans)>>2)];var $108=HEAP32[((__impure_ptr)>>2)];var $_stdout181=(($108+8)&4294967295);var $109=HEAP32[(($_stdout181)>>2)];var $cmp182=((($107))|0)!=((($109))|0);if($cmp182){__label__=84;;}else{__label__=86;;}
$land_lhs_true183$$if_end188$108:do{if(__label__==84){var $110=HEAP32[((_f_trans)>>2)];var $111=HEAP32[((__impure_ptr)>>2)];var $_stderr184=(($111+12)&4294967295);var $112=HEAP32[(($_stderr184)>>2)];var $cmp185=((($110))|0)!=((($112))|0);if(!($cmp185)){__label__=86;break $land_lhs_true183$$if_end188$108;}
var $113=HEAP32[((_f_trans)>>2)];var $call187=_fclose($113);;}}while(0);$retval=0;;}
var $114=$retval;;return $114;return null;}
Module["_main"]=_main;function __ZL9init_pathPcS_($argv0,$path_specified){;var __label__;var $argv0_addr;var $path_specified_addr;var $env;$argv0_addr=$argv0;$path_specified_addr=$path_specified;var $0=$path_specified_addr;var $tobool=((($0))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){var $1=$path_specified_addr;var $call=_sprintf(((_path_home)&4294967295),((__str38)&4294967295),allocate([$1,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==2){var $call1=_getenv(((__str39)&4294967295));$env=$call1;var $cmp=((($call1))|0)!=0;if($cmp){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $2=$env;var $call3=_snprintf(((_path_home)&4294967295),150,((__str38)&4294967295),allocate([$2,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $call4=__Z13GetFileLengthPKc(((_path_home)&4294967295));var $cmp5=((($call4))|0)==-2;if($cmp5){__label__=6;break $if_then$$if_end$2;}}
var $call9=_getenv(((__str40)&4294967295));var $call10=_snprintf(((_path_home)&4294967295),150,((__str38)&4294967295),allocate([$call9,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $call11=_access(((_path_home)&4294967295),4);var $cmp12=((($call11))|0)!=0;if(!($cmp12)){__label__=6;break $if_then$$if_end$2;}
var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str41)&4294967295);$dest$=((_path_home)&4294967295);$stop$=$src$+23;if(($dest$%4)==($src$%4)&&23>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}}while(0);;return;return;}
function __ZL10initialisev(){;var __label__;var $param;var $result;var $call=_setlocale(2,((__str32)&4294967295));var $cmp=((($call))|0)==0;if($cmp){__label__=1;;}else{__label__=3;;}
$if_then$$if_end5$2:do{if(__label__==1){var $call1=_setlocale(2,((__str33)&4294967295));var $cmp2=((($call1))|0)==0;if(!($cmp2)){__label__=3;break $if_then$$if_end5$2;}
var $call4=_setlocale(2,((__str13643)&4294967295));;}}while(0);__Z11WavegenInitii(22050,0);var $call6=__Z10LoadPhDatav();$result=$call6;var $cmp7=((($call6))|0)!=1;if($cmp7){__label__=4;;}else{__label__=7;;}
if(__label__==4){var $0=$result;var $cmp9=((($0))|0)==-1;var $1=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($1+12)&4294967295);var $2=HEAP32[(($_stderr)>>2)];if($cmp9){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $3=_fwrite(((__str35)&4294967295),27,1,$2);_exit(1);;}
else if(__label__==6){var $4=$result;var $call13=_fprintf($2,((__str36)&4294967295),allocate([$4,0,0,0,83200,0,0,0,((_path_home)&4294967295),0,0,0],["i32",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}
__Z10LoadConfigv();__Z13SetVoiceStackP12espeak_VOICE(0);__Z14SynthesizeInitv();$param=0;;while(1){var $5=$param;var $arrayidx=((_param_defaults+$5*4)&4294967295);var $6=HEAP32[(($arrayidx)>>2)];var $7=$param;var $arrayidx17=((((_param_stack+4)&4294967295)+$7*4)&4294967295);HEAP32[(($arrayidx17)>>2)]=$6;var $8=$param;var $inc=((($8)+1)&4294967295);$param=$inc;var $cmp16=((($inc))|0)<15;if($cmp16){__label__=8;continue;}else{__label__=9;break;}};return;return;}
function __ZL12OpenWaveFilePKci($path,$rate){;var __label__;var __lastLabel__=null;var $retval;var $path_addr;var $rate_addr;$path_addr=$path;$rate_addr=$rate;var $0=$path_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=2;;}
else if(__label__==2){var $1=$path_addr;var $call=_strcmp($1,((__str12)&4294967295));var $cmp1=((($call))|0)==0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $2=HEAP32[((__impure_ptr)>>2)];var $_stdout=(($2+8)&4294967295);var $3=HEAP32[(($_stdout)>>2)];HEAP32[((_f_wave)>>2)]=$3;__lastLabel__=3;;}
else if(__label__==4){var $4=$path_addr;var $call3=_fopen($4,((__str79)&4294967295));HEAP32[((_f_wave)>>2)]=$call3;__lastLabel__=4;;}
var $5=__lastLabel__==4?$call3:($3);var $cmp5=((($5))|0)!=0;if($cmp5){__label__=6;;}else{__label__=7;;}
if(__label__==6){var $6=HEAP32[((_f_wave)>>2)];var $call7=_fwrite(((__ZZL12OpenWaveFilePKciE8wave_hdr)&4294967295),1,24,$6);var $7=HEAP32[((_f_wave)>>2)];var $8=$rate_addr;__Z11Write4BytesP7__sFILEi($7,$8);var $9=HEAP32[((_f_wave)>>2)];var $10=$rate_addr;var $mul=((($10)*2)&4294967295);__Z11Write4BytesP7__sFILEi($9,$mul);var $11=HEAP32[((_f_wave)>>2)];var $call8=_fwrite(((__ZZL12OpenWaveFilePKciE8wave_hdr+32)&4294967295),1,12,$11);$retval=0;;}
else if(__label__==7){$retval=1;;}}
var $12=$retval;;return $12;return null;}
function __ZL11WavegenFilev(){var __stackBase__=STACKTOP;STACKTOP+=1236;_memset(__stackBase__,0,1236);var __label__;var $retval;var $finished;var $wav_outbuf=__stackBase__;var $fname=__stackBase__+1024;var $arraydecay=(($wav_outbuf)&4294967295);HEAP32[((_out_start)>>2)]=$arraydecay;HEAP32[((_out_ptr)>>2)]=$arraydecay;var $arraydecay1=(($wav_outbuf)&4294967295);var $add_ptr=(($arraydecay1+1024)&4294967295);HEAP32[((_out_end)>>2)]=$add_ptr;var $call=__Z11WavegenFilli(0);$finished=$call;var $0=HEAP32[((_quiet)>>2)];var $tobool=((($0))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){var $1=$finished;$retval=$1;;}
else if(__label__==2){var $2=HEAP32[((_f_wave)>>2)];var $cmp=((($2))|0)==0;if($cmp){__label__=3;;}else{__label__=5;;}
$if_then2$$if_end10$5:do{if(__label__==3){var $arraydecay3=(($fname)&4294967295);var $3=HEAP32[((_wavefile_count)>>2)];var $inc=((($3)+1)&4294967295);HEAP32[((_wavefile_count)>>2)]=$inc;var $call4=_sprintf($arraydecay3,((__str30)&4294967295),allocate([((_wavefile)&4294967295),0,0,0,$inc,0,0,0,((_filetype)&4294967295),0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay5=(($fname)&4294967295);var $4=HEAP32[((_samplerate)>>2)];var $call6=__ZL12OpenWaveFilePKci($arraydecay5,$4);var $cmp7=((($call6))|0)!=0;if(!($cmp7)){__label__=5;break $if_then2$$if_end10$5;}
$retval=1;__label__=12;break $if_then$$if_end$2;}}while(0);var $5=HEAP32[((_end_of_sentence)>>2)];var $tobool11=((($5))|0)!=0;if($tobool11){__label__=6;;}else{__label__=9;;}
$if_then12$$if_end17$9:do{if(__label__==6){HEAP32[((_end_of_sentence)>>2)]=0;var $6=HEAPU32[((_samples_split)>>2)];var $cmp13=((($6))>>>0)>0;if(!($cmp13)){__label__=9;break $if_then12$$if_end17$9;}
var $7=HEAPU32[((_samples_total)>>2)];var $8=HEAPU32[((_samples_split)>>2)];var $cmp14=((($7))>>>0)>((($8))>>>0);if(!($cmp14)){__label__=9;break $if_then12$$if_end17$9;}
__ZL13CloseWaveFilev();HEAP32[((_samples_total)>>2)]=0;;}}while(0);var $9=HEAP32[((_f_wave)>>2)];var $cmp18=((($9))|0)!=0;if($cmp18){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $10=HEAP32[((_out_ptr)>>2)];var $arraydecay20=(($wav_outbuf)&4294967295);var $sub_ptr_lhs_cast=($10);var $sub_ptr_rhs_cast=($arraydecay20);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $div=((((($sub_ptr_sub))|0)/2)|0);var $11=HEAP32[((_samples_total)>>2)];var $add=((($11)+($div))&4294967295);HEAP32[((_samples_total)>>2)]=$add;var $arraydecay21=(($wav_outbuf)&4294967295);var $12=HEAP32[((_out_ptr)>>2)];var $arraydecay22=(($wav_outbuf)&4294967295);var $sub_ptr_lhs_cast23=($12);var $sub_ptr_rhs_cast24=($arraydecay22);var $sub_ptr_sub25=((($sub_ptr_lhs_cast23)-($sub_ptr_rhs_cast24))&4294967295);var $13=HEAP32[((_f_wave)>>2)];var $call26=_fwrite($arraydecay21,1,$sub_ptr_sub25,$13);;}
var $14=$finished;$retval=$14;;}}while(0);var $15=$retval;STACKTOP=__stackBase__;return $15;return null;}
function __ZL13CloseWaveFilev(){;var __label__;var $pos;var $0=HEAP32[((_f_wave)>>2)];var $cmp=((($0))|0)==0;if($cmp){__label__=3;;}else{__label__=1;;}
$return$$lor_lhs_false$2:do{if(__label__==1){var $1=HEAP32[((_f_wave)>>2)];var $2=HEAP32[((__impure_ptr)>>2)];var $_stdout=(($2+8)&4294967295);var $3=HEAP32[(($_stdout)>>2)];var $cmp1=((($1))|0)==((($3))|0);if($cmp1){__label__=3;break $return$$lor_lhs_false$2;}
var $4=HEAP32[((_f_wave)>>2)];var $call=_fflush($4);var $5=HEAP32[((_f_wave)>>2)];var $call2=_ftell($5);$pos=$call2;var $6=HEAP32[((_f_wave)>>2)];var $call3=_fseek($6,4,0);var $7=HEAP32[((_f_wave)>>2)];var $8=$pos;var $sub=((($8)-8)&4294967295);__Z11Write4BytesP7__sFILEi($7,$sub);var $9=HEAP32[((_f_wave)>>2)];var $call4=_fseek($9,40,0);var $10=HEAP32[((_f_wave)>>2)];var $11=$pos;var $sub5=((($11)-44)&4294967295);__Z11Write4BytesP7__sFILEi($10,$sub5);var $12=HEAP32[((_f_wave)>>2)];var $call6=_fclose($12);HEAP32[((_f_wave)>>2)]=0;;}}while(0);;return;return;}
function __Z8isspace2j($c){;var __label__;var $retval;var $c_addr;var $c2;$c_addr=$c;var $0=$c_addr;var $and=($0)&255;$c2=$and;var $cmp=((($and))|0)==0;var $1=$c_addr;var $cmp1=((($1))>>>0)>32;var $or_cond=($cmp)|($cmp1);if($or_cond){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=0;;}
else if(__label__==2){$retval=1;;}
var $2=$retval;;return $2;return null;}
function __Z14LookupMnemNameP8MNEM_TABi($table,$value){;var __label__;var $retval;var $table_addr;var $value_addr;$table_addr=$table;$value_addr=$value;;while(1){var $0=$table_addr;var $mnem=(($0)&4294967295);var $1=HEAP32[(($mnem)>>2)];var $cmp=((($1))|0)!=0;if(!($cmp)){__label__=5;break;}
var $2=$table_addr;var $value1=(($2+4)&4294967295);var $3=HEAP32[(($value1)>>2)];var $4=$value_addr;var $cmp2=((($3))|0)==((($4))|0);var $5=$table_addr;if($cmp2){__label__=3;break;}
var $incdec_ptr=(($5+8)&4294967295);$table_addr=$incdec_ptr;__label__=1;continue;}
if(__label__==5){$retval=((__str13643)&4294967295);;}
else if(__label__==3){var $mnem3=(($5)&4294967295);var $6=HEAP32[(($mnem3)>>2)];$retval=$6;;}
var $7=$retval;;return $7;return null;}
function __Z22print_dictionary_flagsPj($flags){;var __label__;var $flags_addr;$flags_addr=$flags;var $0=$flags_addr;var $arrayidx=(($0)&4294967295);var $1=HEAP32[(($arrayidx)>>2)];var $and=($1)&15;var $add=((($and)+64)&4294967295);var $call=__Z14LookupMnemNameP8MNEM_TABi(((_mnem_flags)&4294967295),$add);var $2=$flags_addr;var $arrayidx1=(($2)&4294967295);var $3=HEAP32[(($arrayidx1)>>2)];var $4=$flags_addr;var $arrayidx2=(($4+4)&4294967295);var $5=HEAP32[(($arrayidx2)>>2)];var $call3=_sprintf(((__ZZ22print_dictionary_flagsPjE3buf)&4294967295),((__str59)&4294967295),allocate([$call,0,0,0,$3,0,0,0,$5,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i32",0,0,0],ALLOC_STACK));;return((__ZZ22print_dictionary_flagsPjE3buf)&4294967295);return null;}
function __Z10DecodeRulePKciPci($group_chars,$group_length,$rule,$control){var __stackBase__=STACKTOP;STACKTOP+=140;_memset(__stackBase__,0,140);var __label__;var __lastLabel__=null;var $group_chars_addr;var $group_length_addr;var $rule_addr;var $control_addr;var $rb;var $c;var $p;var $ix;var $match_type;var $finished;var $value;var $linenum;var $flags;var $suffix_char;var $condition_num;var $at_start;var $name;var $buf=__stackBase__;var $buf_pre=__stackBase__+60;var $suffix=__stackBase__+120;$group_chars_addr=$group_chars;$group_length_addr=$group_length;$rule_addr=$rule;$control_addr=$control;$finished=0;$linenum=0;$condition_num=0;$at_start=0;$match_type=0;var $arrayidx=(($buf_pre)&4294967295);HEAP8[($arrayidx)]=0;$ix=0;var $0=$ix;var $1=$group_length_addr;var $cmp9=((($0))|0)<((($1))|0);var $2=$ix;if($cmp9){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=2;;}
$for_body$$for_end$2:do{if(__label__==1){while(1){var $3=__lastLabel__==1?$10:($2);var $4=$group_chars_addr;var $arrayidx1=(($4+$3)&4294967295);var $5=HEAP8[($arrayidx1)];var $6=$ix;var $arrayidx2=(($buf+$6)&4294967295);HEAP8[($arrayidx2)]=$5;var $7=$ix;var $inc=((($7)+1)&4294967295);$ix=$inc;var $8=$ix;var $9=$group_length_addr;var $cmp=((($8))|0)<((($9))|0);var $10=$ix;if($cmp){__lastLabel__=1;__label__=1;continue;}else{__lastLabel__=1;__label__=2;break $for_body$$for_end$2;}}}}while(0);var $_lcssa8=__lastLabel__==0?$2:($10);var $arrayidx3=(($buf+$_lcssa8)&4294967295);HEAP8[($arrayidx3)]=0;var $arraydecay=(($buf)&4294967295);var $call=_strlen($arraydecay);var $arrayidx4=(($buf+$call)&4294967295);$p=$arrayidx4;var $11=$finished;var $tobool6=((($11))|0)!=0;var $lnot7=($tobool6)^1;if($lnot7){__label__=3;;}else{__label__=38;;}
$while_body_lr_ph$$while_end$6:do{if(__label__==3){var $arraydecay9=(($buf_pre)&4294967295);var $arraydecay11=(($buf)&4294967295);var $arraydecay13=(($buf)&4294967295);var $arraydecay58=(($suffix)&4294967295);var $arraydecay70=(($suffix)&4294967295);var $arraydecay80=(($suffix)&4294967295);var $arraydecay82=(($suffix)&4294967295);;$while_body$8:while(1){var $12=$rule_addr;var $incdec_ptr=(($12+1)&4294967295);$rule_addr=$incdec_ptr;var $13=HEAP8[($12)];$rb=$13;var $14=$rb;var $conv=((($14))&255);var $cmp5=((($conv))|0)<=9;var $15=$rb;var $conv6=((($15))&255);if($cmp5){__label__=5;;}else{__label__=12;;}
$if_then$$if_end$10:do{if(__label__==5){if($conv6==0){__label__=6;;}
else if($conv6==3){__label__=6;;}
else if($conv6==8){__label__=7;;}
else if($conv6==1){__label__=8;;}
else if($conv6==2){__label__=9;;}
else if($conv6==9){__label__=11;;}
else if($conv6==5){__label__=10;;}
else{__label__=37;break $if_then$$if_end$10;}
if(__label__==6){$finished=1;__label__=37;break $if_then$$if_end$10;}
else if(__label__==7){$at_start=1;;}
else if(__label__==9){$match_type=2;var $17=$p;HEAP8[($17)]=0;var $strlen=_strlen($arraydecay11);var $endptr=(($arraydecay11+$strlen)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str60)&4294967295);$dest$=$endptr;$stop$=$src$+3;if(($dest$%4)==($src$%4)&&3>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $call14=_strlen($arraydecay13);var $arrayidx15=(($buf+$call14)&4294967295);$p=$arrayidx15;__label__=37;break $if_then$$if_end$10;}
else if(__label__==11){var $20=$rule_addr;var $arrayidx20=(($20+1)&4294967295);var $21=HEAP8[($arrayidx20)];var $conv21=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));var $and=($conv21)&255;var $sub=((($and)-1)&4294967295);$value=$sub;var $22=$rule_addr;var $arrayidx22=(($22)&4294967295);var $23=HEAP8[($arrayidx22)];var $conv23=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt));var $and24=($conv23)&255;var $24=$value;var $mul=((($24)*255)&4294967295);var $sub25=((($mul)-1)&4294967295);var $add=((($sub25)+($and24))&4294967295);$linenum=$add;var $25=$rule_addr;var $add_ptr=(($25+2)&4294967295);$rule_addr=$add_ptr;__label__=37;break $if_then$$if_end$10;}
else if(__label__==10){var $18=$rule_addr;var $incdec_ptr17=(($18+1)&4294967295);$rule_addr=$incdec_ptr17;var $19=HEAP8[($18)];var $conv18=(tempInt=(($19)),(tempInt>=128?tempInt-256:tempInt));$condition_num=$conv18;__label__=37;break $if_then$$if_end$10;}
$match_type=1;var $16=$p;HEAP8[($16)]=0;$p=$arraydecay9;;}
else if(__label__==12){var $cmp27=((($conv6))|0)==28;if($cmp27){__label__=13;;}else{__label__=17;;}
if(__label__==13){var $26=$rule_addr;var $incdec_ptr29=(($26+1)&4294967295);$rule_addr=$incdec_ptr29;var $27=HEAP8[($26)];var $conv30=(tempInt=(($27)),(tempInt>=128?tempInt-256:tempInt));var $and31=($conv30)&255;$value=$and31;var $28=$value;var $cmp32=((($28))|0)!=1;if($cmp32){__label__=15;;}else{__label__=14;;}
$if_then35$$lor_lhs_false$22:do{if(__label__==14){var $29=$control_addr;var $and33=($29)&-2147483648;var $tobool34=((($and33))|0)!=0;if($tobool34){__label__=15;break $if_then35$$lor_lhs_false$22;}else{__label__=16;break $if_then35$$lor_lhs_false$22;}}}while(0);if(__label__==15){var $30=$p;var $arrayidx36=(($30)&4294967295);HEAP8[($arrayidx36)]=36;var $31=$value;var $call37=__Z14LookupMnemNameP8MNEM_TABi(((_mnem_rules)&4294967295),$31);$name=$call37;var $32=$p;var $arrayidx38=(($32+1)&4294967295);var $33=$name;var $call39=_strcpy($arrayidx38,$33);var $34=$name;var $call40=_strlen($34);var $add41=((($call40)+1)&4294967295);var $35=$p;var $add_ptr42=(($35+$add41)&4294967295);$p=$add_ptr42;;}
$c=32;;}
else if(__label__==17){var $36=$rb;var $conv44=((($36))&255);var $cmp45=((($conv44))|0)==14;if($cmp45){__label__=18;;}else{__label__=25;;}
if(__label__==18){var $37=$rule_addr;var $arrayidx47=(($37)&4294967295);var $38=HEAP8[($arrayidx47)];var $conv48=(tempInt=(($38)),(tempInt>=128?tempInt-256:tempInt));var $and49=($conv48)&127;var $shl=((($and49)*256)&4294967295);var $39=$rule_addr;var $arrayidx50=(($39+1)&4294967295);var $40=HEAP8[($arrayidx50)];var $conv51=(tempInt=(($40)),(tempInt>=128?tempInt-256:tempInt));var $and52=($conv51)&127;var $add53=((($and52)+($shl))&4294967295);$flags=$add53;$suffix_char=83;var $41=$flags;var $and54=($41)&4;var $tobool55=((($and54))|0)!=0;if($tobool55){__label__=19;;}else{__label__=20;;}
if(__label__==19){$suffix_char=80;;}
var $42=$suffix_char;var $43=$rule_addr;var $arrayidx59=(($43+2)&4294967295);var $44=HEAP8[($arrayidx59)];var $conv60=(tempInt=(($44)),(tempInt>=128?tempInt-256:tempInt));var $and61=($conv60)&127;var $call62=_sprintf($arraydecay58,((__str62)&4294967295),allocate([$42,0,0,0,$and61,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $45=$rule_addr;var $add_ptr63=(($45+3)&4294967295);$rule_addr=$add_ptr63;$ix=0;;while(1){var $46=$flags;var $and67=($46)&1;var $tobool68=((($and67))|0)!=0;if($tobool68){__label__=22;;}else{__label__=23;;}
if(__label__==22){var $call71=_strlen($arraydecay70);var $arrayidx72=(($suffix+$call71)&4294967295);var $47=$ix;var $arrayidx73=((((__str61)&4294967295)+$47)&4294967295);var $48=HEAP8[($arrayidx73)];var $conv74=(tempInt=(($48)),(tempInt>=128?tempInt-256:tempInt));var $char=((($conv74))&255);HEAP8[($arrayidx72)]=$char;var $nul=(($arrayidx72+1)&4294967295);HEAP8[($nul)]=0;;}
var $49=$flags;var $shr=($49)>>1;$flags=$shr;var $50=$ix;var $inc78=((($50)+1)&4294967295);$ix=$inc78;var $cmp65=((($inc78))|0)<9;if($cmp65){__label__=21;continue;}else{__label__=24;break;}}
var $51=$p;var $call81=_strcpy($51,$arraydecay80);var $call83=_strlen($arraydecay82);var $52=$p;var $add_ptr84=(($52+$call83)&4294967295);$p=$add_ptr84;$c=32;;}
else if(__label__==25){var $53=$rb;var $conv86=((($53))&255);var $cmp87=((($conv86))|0)==17;if($cmp87){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $54=$rule_addr;var $incdec_ptr89=(($54+1)&4294967295);$rule_addr=$incdec_ptr89;var $55=HEAP8[($54)];var $conv90=(tempInt=(($55)),(tempInt>=128?tempInt-256:tempInt));var $sub91=((($conv90)-65)&4294967295);var $arrayidx92=((__ZZ10DecodeRulePKciPciE10symbols_lg+$sub91)&4294967295);var $56=HEAP8[($arrayidx92)];$c=$56;;}
else if(__label__==27){var $57=$rb;var $conv94=((($57))&255);var $cmp95=((($conv94))|0)==18;if($cmp95){__label__=28;;}else{__label__=31;;}
if(__label__==28){var $58=$rule_addr;var $incdec_ptr97=(($58+1)&4294967295);$rule_addr=$incdec_ptr97;var $59=HEAP8[($58)];var $conv98=(tempInt=(($59)),(tempInt>=128?tempInt-256:tempInt));var $sub99=((($conv98)-65)&4294967295);$value=$sub99;var $60=$p;var $arrayidx100=(($60)&4294967295);HEAP8[($arrayidx100)]=76;var $61=$value;var $div=((((($61))|0)/10)|0);var $add101=((($div)+48)&4294967295);var $conv102=((($add101))&255);var $62=$p;var $arrayidx103=(($62+1)&4294967295);HEAP8[($arrayidx103)]=$conv102;var $63=$value;var $rem=((($63))|0)%10;var $add104=((($rem)+48)&4294967295);var $conv105=((($add104))&255);$c=$conv105;var $64=$match_type;var $cmp106=((($64))|0)==1;if($cmp106){__label__=29;;}else{__label__=30;;}
if(__label__==29){var $65=$c;var $66=$p;var $arrayidx108=(($66)&4294967295);HEAP8[($arrayidx108)]=$65;$c=76;;}
var $67=$p;var $add_ptr110=(($67+2)&4294967295);$p=$add_ptr110;;}
else if(__label__==31){var $68=$rb;var $conv112=((($68))&255);var $cmp113=((($conv112))|0)<=31;var $69=$rb;var $idxprom=((($69))&255);if($cmp113){__label__=32;;}else{__label__=33;;}
if(__label__==32){var $arrayidx115=((__ZZ10DecodeRulePKciPciE7symbols+$idxprom)&4294967295);var $70=HEAP8[($arrayidx115)];$c=$70;;}
else if(__label__==33){var $cmp118=((($idxprom))|0)==32;if($cmp118){__label__=34;;}else{__label__=35;;}
if(__label__==34){$c=95;;}
else if(__label__==35){var $71=$rb;$c=$71;;}}}}}}
var $72=$c;var $73=$p;var $incdec_ptr127=(($73+1)&4294967295);$p=$incdec_ptr127;HEAP8[($73)]=$72;;}}while(0);var $74=$finished;var $tobool=((($74))|0)!=0;var $lnot=($tobool)^1;if($lnot){__label__=4;continue $while_body$8;}else{__label__=38;break $while_body_lr_ph$$while_end$6;}}}}while(0);var $75=$p;HEAP8[($75)]=0;$p=((__ZZ10DecodeRulePKciPciE6output)&4294967295);var $76=$linenum;var $cmp128=((($76))|0)>0;if($cmp128){__label__=39;;}else{__label__=40;;}
if(__label__==39){var $77=$p;var $78=$linenum;var $call130=_sprintf($77,((__str64)&4294967295),allocate([$78,0,0,0],["i32",0,0,0],ALLOC_STACK));var $79=$p;var $add_ptr131=(($79+7)&4294967295);$p=$add_ptr131;;}
var $80=$condition_num;var $cmp133=((($80))|0)>0;if($cmp133){__label__=41;;}else{__label__=42;;}
if(__label__==41){var $81=$p;var $82=$condition_num;var $call135=_sprintf($81,((__str65)&4294967295),allocate([$82,0,0,0],["i32",0,0,0],ALLOC_STACK));var $83=$p;var $call136=_strlen($83);var $84=$p;var $arrayidx137=(($84+$call136)&4294967295);$p=$arrayidx137;;}
var $arraydecay139=(($buf_pre)&4294967295);var $call140=_strlen($arraydecay139);$ix=$call140;var $cmp141=((($call140))|0)>0;var $_pr=$at_start;var $tobool145=((($_pr))|0)!=0;if($cmp141){__label__=44;;}else{__label__=43;;}
$if_then144$$lor_lhs_false142$64:do{if(__label__==44){if($tobool145){__label__=45;break $if_then144$$lor_lhs_false142$64;}else{__label__=46;break $if_then144$$lor_lhs_false142$64;}}
else if(__label__==43){if($tobool145){__label__=45;break $if_then144$$lor_lhs_false142$64;}else{__label__=49;break $if_then144$$lor_lhs_false142$64;}}}while(0);$if_then146$$while_cond149_preheader$$if_end157$67:do{if(__label__==45){var $85=$p;var $incdec_ptr147=(($85+1)&4294967295);$p=$incdec_ptr147;HEAP8[($85)]=95;__label__=46;break $if_then146$$while_cond149_preheader$$if_end157$67;}}while(0);if(__label__==46){var $86=$ix;var $dec4=((($86)-1)&4294967295);$ix=$dec4;var $cmp1505=((($dec4))|0)>=0;if($cmp1505){__label__=47;;}else{__label__=48;;}
$while_body151$$while_end154$71:do{if(__label__==47){while(1){var $87=$ix;var $arrayidx152=(($buf_pre+$87)&4294967295);var $88=HEAP8[($arrayidx152)];var $89=$p;var $incdec_ptr153=(($89+1)&4294967295);$p=$incdec_ptr153;HEAP8[($89)]=$88;var $90=$ix;var $dec=((($90)-1)&4294967295);$ix=$dec;var $cmp150=((($dec))|0)>=0;if($cmp150){__label__=47;continue;}else{__label__=48;break $while_body151$$while_end154$71;}}}}while(0);var $91=$p;var $incdec_ptr155=(($91+1)&4294967295);$p=$incdec_ptr155;HEAP8[($91)]=41;var $92=$p;var $incdec_ptr156=(($92+1)&4294967295);$p=$incdec_ptr156;HEAP8[($92)]=32;;}
var $93=$p;HEAP8[($93)]=0;var $94=$p;var $arraydecay158=(($buf)&4294967295);var $call159=_strcat($94,$arraydecay158);var $call160=_strlen(((__ZZ10DecodeRulePKciPciE6output)&4294967295));$ix=$call160;var $cmp1623=((($call160))|0)<8;var $95=$ix;if($cmp1623){__lastLabel__=49;__label__=50;;}else{__lastLabel__=49;__label__=51;;}
$while_body163$$while_end166$76:do{if(__label__==50){while(1){var $96=__lastLabel__==50?$97:($95);var $inc164=((($96)+1)&4294967295);$ix=$inc164;var $arrayidx165=((__ZZ10DecodeRulePKciPciE6output+$96)&4294967295);HEAP8[($arrayidx165)]=32;var $_pr2=$ix;var $cmp162=((($_pr2))|0)<8;var $97=$ix;if($cmp162){__lastLabel__=50;__label__=50;continue;}else{__lastLabel__=50;__label__=51;break $while_body163$$while_end166$76;}}}}while(0);var $_lcssa=__lastLabel__==49?$95:($97);var $arrayidx167=((__ZZ10DecodeRulePKciPciE6output+$_lcssa)&4294967295);HEAP8[($arrayidx167)]=0;STACKTOP=__stackBase__;return((__ZZ10DecodeRulePKciPciE6output)&4294967295);return null;}
function __Z13string_sorterPPcS0_($a,$b){;var __label__;var $retval;var $a_addr;var $b_addr;var $pa;var $pb;var $ix;$a_addr=$a;$b_addr=$b;var $0=$a_addr;var $1=HEAP32[(($0)>>2)];$pa=$1;var $2=$b_addr;var $3=HEAP32[(($2)>>2)];$pb=$3;var $call=_strcmp($1,$3);$ix=$call;var $cmp=((($call))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $4=$ix;$retval=$4;;}
else if(__label__==2){var $5=$pa;var $call1=_strlen($5);var $add=((($call1)+1)&4294967295);var $6=$pa;var $add_ptr=(($6+$add)&4294967295);$pa=$add_ptr;var $7=$pb;var $call2=_strlen($7);var $add3=((($call2)+1)&4294967295);var $8=$pb;var $add_ptr4=(($8+$add3)&4294967295);$pb=$add_ptr4;var $9=$pa;var $10=$pb;var $call5=_strcmp($9,$10);$retval=$call5;;}
var $11=$retval;;return $11;return null;}
function __Z17CompileDictionaryPKcS0_P7__sFILEPci($dsource,$dict_name,$log,$fname_err,$flags){var __stackBase__=STACKTOP;STACKTOP+=724;_memset(__stackBase__,0,724);var __label__;var $retval;var $dsource_addr;var $dict_name_addr;var $log_addr;var $fname_err_addr;var $flags_addr;var $f_in;var $f_out;var $offset_rules;var $value;var $fname_in=__stackBase__;var $fname_out=__stackBase__+196;var $fname_temp=__stackBase__+364;var $path=__stackBase__+532;$dsource_addr=$dsource;$dict_name_addr=$dict_name;$log_addr=$log;$fname_err_addr=$fname_err;$flags_addr=$flags;$offset_rules=0;HEAP32[((__ZL11error_count)>>2)]=0;HEAP32[((__ZL21error_need_dictionary)>>2)]=0;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=((__ZL19letterGroupsDefined)&4294967295);$stop$=$dest$+26;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $0=$flags_addr;var $and=($0)&1;HEAP32[((__ZL10debug_flag)>>2)]=$and;var $1=$dsource_addr;var $cmp=((($1))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$dsource_addr=((__str13643)&4294967295);;}
var $2=$log_addr;HEAP32[((__ZL5f_log)>>2)]=$2;var $cmp1=((($2))|0)==0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $3=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($3+12)&4294967295);var $4=HEAP32[(($_stderr)>>2)];HEAP32[((__ZL5f_log)>>2)]=$4;;}
var $arraydecay=(($path)&4294967295);var $5=$dsource_addr;var $6=$dict_name_addr;var $call=_sprintf($arraydecay,((__str66)&4294967295),allocate([$5,0,0,0,$6,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay4=(($fname_in)&4294967295);var $arraydecay5=(($path)&4294967295);var $call6=_sprintf($arraydecay4,((__str67)&4294967295),allocate([$arraydecay5,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $arraydecay7=(($fname_in)&4294967295);var $call8=_fopen($arraydecay7,((__str51703)&4294967295));$f_in=$call8;var $cmp9=((($call8))|0)==0;if($cmp9){__label__=5;;}else{__label__=9;;}
$if_then10$$if_end23$8:do{if(__label__==5){var $arraydecay11=(($fname_in)&4294967295);var $arraydecay12=(($path)&4294967295);var $call13=_sprintf($arraydecay11,((__str69)&4294967295),allocate([$arraydecay12,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $arraydecay14=(($fname_in)&4294967295);var $call15=__ZL9fopen_logPKcS0_($arraydecay14,((__str51703)&4294967295));$f_in=$call15;var $cmp16=((($call15))|0)==0;if(!($cmp16)){__label__=9;break $if_then10$$if_end23$8;}
var $7=$fname_err_addr;var $tobool=((($7))|0)!=0;if($tobool){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $8=$fname_err_addr;var $arraydecay19=(($fname_in)&4294967295);var $call20=_strcpy($8,$arraydecay19);;}
$retval=-1;__label__=17;break $if_then10$$if_end23$8;}}while(0);if(__label__==9){var $arraydecay24=(($fname_out)&4294967295);var $9=$dict_name_addr;var $call25=_sprintf($arraydecay24,((__str116)&4294967295),allocate([((_path_home)&4294967295),0,0,0,47,0,0,0,$9,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay26=(($fname_out)&4294967295);var $call27=__ZL9fopen_logPKcS0_($arraydecay26,((__str71)&4294967295));$f_out=$call27;var $cmp28=((($call27))|0)==0;if($cmp28){__label__=10;;}else{__label__=13;;}
if(__label__==10){var $10=$fname_err_addr;var $tobool30=((($10))|0)!=0;if($tobool30){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $11=$fname_err_addr;var $arraydecay32=(($fname_in)&4294967295);var $call33=_strcpy($11,$arraydecay32);;}
$retval=-1;;}
else if(__label__==13){var $arraydecay36=(($fname_temp)&4294967295);var $call37=_sprintf($arraydecay36,((__str72)&4294967295),allocate([((_path_home)&4294967295),0,0,0,47,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));$value=1024;var $12=$f_out;var $13=$value;__Z11Write4BytesP7__sFILEi($12,$13);var $14=$f_out;var $15=$offset_rules;__Z11Write4BytesP7__sFILEi($14,$15);__ZL22compile_dictlist_startv();var $16=HEAP32[((__ZL5f_log)>>2)];var $17=HEAP32[((_phoneme_tab_number)>>2)];var $arrayidx=((_phoneme_tab_list+$17*48)&4294967295);var $name=(($arrayidx)&4294967295);var $arraydecay38=(($name)&4294967295);var $call39=_fprintf($16,((__str73)&4294967295),allocate([$arraydecay38,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $arraydecay40=(($path)&4294967295);__ZL21compile_dictlist_filePKcS0_($arraydecay40,((__str74)&4294967295));var $18=HEAP32[((_translator)>>2)];var $langopts=(($18)&4294967295);var $listx=(($langopts+260)&4294967295);var $19=HEAP32[(($listx)>>2)];var $tobool42=((($19))|0)!=0;var $arraydecay44=(($path)&4294967295);if($tobool42){__label__=14;;}else{__label__=15;;}
if(__label__==14){__ZL21compile_dictlist_filePKcS0_($arraydecay44,((__str75)&4294967295));var $arraydecay46=(($path)&4294967295);__ZL21compile_dictlist_filePKcS0_($arraydecay46,((__str76)&4294967295));;}
else if(__label__==15){__ZL21compile_dictlist_filePKcS0_($arraydecay44,((__str76)&4294967295));var $arraydecay50=(($path)&4294967295);__ZL21compile_dictlist_filePKcS0_($arraydecay50,((__str75)&4294967295));;}
var $arraydecay53=(($path)&4294967295);__ZL21compile_dictlist_filePKcS0_($arraydecay53,((__str77)&4294967295));var $20=$f_out;__ZL20compile_dictlist_endP7__sFILE($20);var $21=$f_out;var $call55=_ftell($21);$offset_rules=$call55;var $22=HEAP32[((__ZL5f_log)>>2)];var $arraydecay56=(($fname_in)&4294967295);var $call57=_fprintf($22,((__str78)&4294967295),allocate([$arraydecay56,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $23=$f_in;var $24=$f_out;var $arraydecay58=(($fname_temp)&4294967295);__ZL17compile_dictrulesP7__sFILES0_Pc($23,$24,$arraydecay58);var $25=$f_in;var $call60=_fclose($25);var $26=$f_out;var $call61=_fseek($26,4,0);var $27=$f_out;var $28=$offset_rules;__Z11Write4BytesP7__sFILEi($27,$28);var $29=$f_out;var $call62=_fclose($29);var $30=HEAP32[((_translator)>>2)];var $31=$dict_name_addr;var $call63=__Z14LoadDictionaryP10TranslatorPKci($30,$31,0);var $32=HEAP32[((__ZL11error_count)>>2)];$retval=$32;;}}
var $33=$retval;STACKTOP=__stackBase__;return $33;return null;}
function __ZL9fopen_logPKcS0_($fname,$access){;var __label__;var $fname_addr;var $access_addr;var $f;$fname_addr=$fname;$access_addr=$access;var $0=$fname_addr;var $1=$access_addr;var $call=_fopen($0,$1);$f=$call;var $cmp=((($call))|0)==0;var $2=HEAP32[((__ZL5f_log)>>2)];var $cmp1=((($2))|0)!=0;var $or_cond=($cmp)&($cmp1);if($or_cond){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $3=HEAP32[((__ZL5f_log)>>2)];var $4=$access_addr;var $5=$fname_addr;var $call3=_fprintf($3,((__str115)&4294967295),allocate([$4,0,0,0,$5,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
var $6=$f;;return $6;return null;}
function __ZL22compile_dictlist_startv(){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $ix;var $p;var $p2=__stackBase__;$ix=0;var $0=$p2;;$for_body$2:while(1){var $1=$ix;var $arrayidx=((__ZL11hash_chains+$1*4)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];$p=$2;var $cmp11=((($2))|0)!=0;if($cmp11){__label__=2;;}else{__label__=3;;}
$while_body$$while_end$4:do{if(__label__==2){while(1){var $3=$p;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$3;$dest$=$0;$stop$=$src$+4;if(($dest$%4)==($src$%4)&&4>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $4=$p;;var $5=HEAP32[(($p2)>>2)];$p=$5;var $cmp1=((($5))|0)!=0;if($cmp1){__label__=2;continue;}else{__label__=3;break $while_body$$while_end$4;}}}}while(0);var $6=$ix;var $arrayidx2=((__ZL11hash_chains+$6*4)&4294967295);HEAP32[(($arrayidx2)>>2)]=0;var $7=$ix;var $arrayidx3=((__ZL11hash_counts+$7*4)&4294967295);HEAP32[(($arrayidx3)>>2)]=0;var $8=$ix;var $inc=((($8)+1)&4294967295);$ix=$inc;var $cmp=((($inc))|0)<1024;if($cmp){__label__=1;continue $for_body$2;}else{__label__=4;break $for_body$2;}}
STACKTOP=__stackBase__;return;return;}
function __ZL21compile_dictlist_filePKcS0_($path,$filename){var __stackBase__=STACKTOP;STACKTOP+=528;_memset(__stackBase__,0,528);var __label__;var $retval;var $path_addr;var $filename_addr;var $length;var $hash=__stackBase__;var $p;var $count;var $f_in;var $buf=__stackBase__+4;var $fname=__stackBase__+204;var $dict_line=__stackBase__+400;$path_addr=$path;$filename_addr=$filename;$count=0;HEAP8[(__ZL9text_mode_b)]=0;var $arraydecay=(($fname)&4294967295);var $0=$path_addr;var $1=$filename_addr;var $call=_sprintf($arraydecay,((__str104)&4294967295),allocate([$0,0,0,0,$1,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay1=(($fname)&4294967295);var $call2=_fopen($arraydecay1,((__str51703)&4294967295));$f_in=$call2;var $cmp=((($call2))|0)==0;if($cmp){__label__=1;;}else{__label__=3;;}
$if_then$$if_end9$2:do{if(__label__==1){var $arraydecay3=(($fname)&4294967295);var $2=$path_addr;var $3=$filename_addr;var $call4=_sprintf($arraydecay3,((__str47699)&4294967295),allocate([$2,0,0,0,$3,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay5=(($fname)&4294967295);var $call6=_fopen($arraydecay5,((__str51703)&4294967295));$f_in=$call6;var $cmp7=((($call6))|0)==0;if(!($cmp7)){__label__=3;break $if_then$$if_end9$2;}
$retval=-1;__label__=11;break $if_then$$if_end9$2;}}while(0);if(__label__==3){var $4=HEAP32[((__ZL5f_log)>>2)];var $arraydecay10=(($fname)&4294967295);var $call11=_fprintf($4,((__str78)&4294967295),allocate([$arraydecay10,0,0,0],["i8*",0,0,0],ALLOC_STACK));HEAP32[((__ZL7linenum)>>2)]=0;var $arraydecay12=(($buf)&4294967295);var $arraydecay15=(($buf)&4294967295);var $arraydecay16=(($dict_line)&4294967295);var $arraydecay33=(($dict_line)&4294967295);;$while_cond$7:while(1){var $5=$f_in;var $call13=_fgets($arraydecay12,200,$5);var $cmp14=((($call13))|0)!=0;if(!($cmp14)){__label__=10;break $while_cond$7;}
var $6=HEAP32[((__ZL7linenum)>>2)];var $inc=((($6)+1)&4294967295);HEAP32[((__ZL7linenum)>>2)]=$inc;var $call17=__ZL12compile_linePcS_Pi($arraydecay15,$arraydecay16,$hash);$length=$call17;var $7=$length;var $cmp18=((($7))|0)==0;if($cmp18){__label__=4;continue $while_cond$7;}
var $8=HEAP32[(($hash)>>2)];var $arrayidx=((__ZL11hash_counts+$8*4)&4294967295);var $9=HEAP32[(($arrayidx)>>2)];var $inc21=((($9)+1)&4294967295);HEAP32[(($arrayidx)>>2)]=$inc21;var $10=$length;var $add=((($10)+4)&4294967295);var $call22=_malloc($add);$p=$call22;var $11=$p;var $cmp23=((($11))|0)==0;if($cmp23){__label__=7;break $while_cond$7;}
var $16=$p;var $17=HEAP32[(($hash)>>2)];var $arrayidx31=((__ZL11hash_chains+$17*4)&4294967295);var $18=$arrayidx31;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$18;$dest$=$16;$stop$=$src$+4;if(($dest$%4)==($src$%4)&&4>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $19=$p;var $20=HEAP32[(($hash)>>2)];var $arrayidx32=((__ZL11hash_chains+$20*4)&4294967295);HEAP32[(($arrayidx32)>>2)]=$19;var $21=$p;var $add_ptr=(($21+4)&4294967295);var $22=$length;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$arraydecay33;$dest$=$add_ptr;$stop$=$src$+$22;if(($dest$%4)==($src$%4)&&$22>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $23=$count;var $inc34=((($23)+1)&4294967295);$count=$inc34;__label__=4;continue $while_cond$7;}
$while_end$$if_then24$12:do{if(__label__==7){var $12=HEAP32[((__ZL5f_log)>>2)];var $cmp25=((($12))|0)!=0;if(!($cmp25)){__label__=10;break $while_end$$if_then24$12;}
var $13=HEAP32[((__ZL5f_log)>>2)];var $14=_fwrite(((__str106)&4294967295),22,1,$13);var $15=HEAP32[((__ZL11error_count)>>2)];var $inc28=((($15)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc28;;}}while(0);var $24=HEAP32[((__ZL5f_log)>>2)];var $25=$count;var $call35=_fprintf($24,((__str107)&4294967295),allocate([$25,0,0,0],["i32",0,0,0],ALLOC_STACK));var $26=$f_in;var $call36=_fclose($26);$retval=0;;}
STACKTOP=__stackBase__;return;return;}
function __ZL20compile_dictlist_endP7__sFILE($f_out){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $f_out_addr;var $hash;var $length;var $p=__stackBase__;$f_out_addr=$f_out;$hash=0;var $0=$p;;$for_body$2:while(1){var $1=$hash;var $arrayidx=((__ZL11hash_chains+$1*4)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];HEAP32[(($p)>>2)]=$2;var $3=$f_out_addr;var $call=_ftell($3);var $4=$hash;var $arrayidx2=((__ZL11hash_counts+$4*4)&4294967295);HEAP32[(($arrayidx2)>>2)]=$call;var $5=HEAP32[(($p)>>2)];var $cmp31=((($5))|0)!=0;if($cmp31){__label__=2;;}else{__label__=3;;}
$while_body$$while_end$4:do{if(__label__==2){while(1){var $6=HEAP32[(($p)>>2)];var $add_ptr=(($6+4)&4294967295);var $7=HEAP8[($add_ptr)];var $conv=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));$length=$conv;var $8=HEAP32[(($p)>>2)];var $add_ptr4=(($8+4)&4294967295);var $9=$length;var $10=$f_out_addr;var $call5=_fwrite($add_ptr4,$9,1,$10);var $11=HEAP32[(($p)>>2)];var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$11;$dest$=$0;$stop$=$src$+4;if(($dest$%4)==($src$%4)&&4>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $12=HEAP32[(($p)>>2)];var $cmp3=((($12))|0)!=0;if($cmp3){__label__=2;continue;}else{__label__=3;break $while_body$$while_end$4;}}}}while(0);var $13=$f_out_addr;var $call6=_fputc(0,$13);var $14=$hash;var $inc=((($14)+1)&4294967295);$hash=$inc;var $cmp1=((($inc))|0)<1024;if($cmp1){__label__=1;continue $for_body$2;}else{__label__=4;break $for_body$2;}}
STACKTOP=__stackBase__;return;return;}
function __ZL17compile_dictrulesP7__sFILES0_Pc($f_in,$f_out,$fname_temp){var __stackBase__=STACKTOP;STACKTOP+=11876;_memset(__stackBase__,0,11876);var __label__;var __lastLabel__=null;var $retval;var $f_in_addr;var $f_out_addr;var $fname_temp_addr;var $prule;var $p;var $ix;var $c=__stackBase__;var $gp;var $f_temp;var $n_rules=__stackBase__+4;var $count;var $different;var $wc=__stackBase__+8;var $prev_rgroup_name;var $char_code=__stackBase__+12;var $compile_mode;var $buf;var $buf1=__stackBase__+16;var $rules=__stackBase__+516;var $n_rgroups;var $n_groups3;var $rgroup=__stackBase__+8516;var $replace1;var $replace2;var $p123;$f_in_addr=$f_in;$f_out_addr=$f_out;$fname_temp_addr=$fname_temp;HEAP32[(($n_rules)>>2)]=0;$count=0;$compile_mode=0;$n_rgroups=0;$n_groups3=0;HEAP32[((__ZL7linenum)>>2)]=0;HEAP8[(((__ZL10group_name)&4294967295))]=0;var $0=$fname_temp_addr;var $call=__ZL9fopen_logPKcS0_($0,((__str79)&4294967295));$f_temp=$call;var $cmp=((($call))|0)==0;if($cmp){__label__=2;;}else{__label__=1;;}
if(__label__==2){$retval=1;;}
else if(__label__==1){var $arraydecay=(($buf1)&4294967295);var $arraydecay25=(($rules)&4294967295);var $1=$n_rules;;$for_cond$5:while(1){var $2=HEAP32[((__ZL7linenum)>>2)];var $inc=((($2)+1)&4294967295);HEAP32[((__ZL7linenum)>>2)]=$inc;var $3=$f_in_addr;var $call1=_fgets($arraydecay,500,$3);$buf=$call1;var $cmp2=((($call1))|0)!=0;if($cmp2){__label__=4;;}else{__label__=10;;}
$if_then3$$if_then16$7:do{if(__label__==4){var $4=$buf;var $call4=_strstr($4,((__str82734)&4294967295));$p=$call4;var $cmp5=((($call4))|0)!=0;if($cmp5){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $5=$p;HEAP8[($5)]=0;;}
var $6=$buf;var $arrayidx=(($6)&4294967295);var $7=HEAP8[($arrayidx)];var $conv=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $cmp8=((($conv))|0)==13;if($cmp8){__lastLabel__=6;__label__=7;;}else{__lastLabel__=6;__label__=8;;}
if(__label__==7){var $8=$buf;var $incdec_ptr=(($8+1)&4294967295);$buf=$incdec_ptr;__lastLabel__=7;;}
var $9=__lastLabel__==6?$6:($incdec_ptr);var $cmp12=((($9))|0)==0;if($cmp12){__label__=10;break $if_then3$$if_then16$7;}
var $10=$buf;var $arrayidx13=(($10)&4294967295);var $11=HEAP8[($arrayidx13)];var $conv14=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $cmp15=((($conv14))|0)==46;if($cmp15){__label__=10;break $if_then3$$if_then16$7;}
var $69=$compile_mode;if($69==1){__label__=44;;}
else if($69==2){__label__=47;;}
else{__label__=3;continue $for_cond$5;}
if(__label__==44){var $70=$buf;var $call114=__ZL12compile_rulePc($70);$prule=$call114;var $71=$prule;var $cmp115=((($71))|0)!=0;if(!($cmp115)){__label__=3;continue $for_cond$5;}
var $72=HEAP32[(($n_rules)>>2)];var $cmp117=((($72))|0)<2000;if(!($cmp117)){__label__=3;continue $for_cond$5;}
var $73=$prule;var $74=HEAP32[(($n_rules)>>2)];var $inc119=((($74)+1)&4294967295);HEAP32[(($n_rules)>>2)]=$inc119;var $arrayidx120=(($rules+$74*4)&4294967295);HEAP32[(($arrayidx120)>>2)]=$73;__label__=3;continue $for_cond$5;}
else if(__label__==47){var $75=$buf;$p123=$75;$replace1=0;$replace2=0;var $76=$p123;var $77=HEAP8[($76)];var $conv1254=(tempInt=(($77)),(tempInt>=128?tempInt-256:tempInt));var $call1265=__Z8isspace2j($conv1254);var $tobool6=((($call1265))|0)!=0;if($tobool6){__label__=48;;}else{__label__=49;;}
$while_body127$$while_end129$22:do{if(__label__==48){while(1){var $78=$p123;var $incdec_ptr128=(($78+1)&4294967295);$p123=$incdec_ptr128;var $79=$p123;var $80=HEAP8[($79)];var $conv125=(tempInt=(($80)),(tempInt>=128?tempInt-256:tempInt));var $call126=__Z8isspace2j($conv125);var $tobool=((($call126))|0)!=0;if($tobool){__label__=48;continue;}else{__label__=49;break $while_body127$$while_end129$22;}}}}while(0);$ix=0;var $81=$p123;var $82=HEAPU8[($81)];var $conv1317=((($82))&255);var $cmp1328=((($conv1317))|0)>32;if($cmp1328){__label__=50;;}else{__label__=51;;}
$while_body133$$while_cond138_loopexit$26:do{if(__label__==50){while(1){var $83=$p123;var $call134=__Z7utf8_inPiPKc($c,$83);var $84=$p123;var $add_ptr=(($84+$call134)&4294967295);$p123=$add_ptr;var $85=HEAP32[(($c)>>2)];var $86=$ix;var $shl=($85)<<($86);var $87=$replace1;var $add135=((($87)+($shl))&4294967295);$replace1=$add135;var $88=$ix;var $add136=((($88)+16)&4294967295);$ix=$add136;var $89=$p123;var $90=HEAPU8[($89)];var $conv131=((($90))&255);var $cmp132=((($conv131))|0)>32;if($cmp132){__label__=50;continue;}else{__label__=51;break $while_body133$$while_cond138_loopexit$26;}}}}while(0);var $91=$p123;var $92=HEAP8[($91)];var $conv1399=(tempInt=(($92)),(tempInt>=128?tempInt-256:tempInt));var $call14010=__Z8isspace2j($conv1399);var $tobool14111=((($call14010))|0)!=0;if($tobool14111){__label__=52;;}else{__label__=53;;}
$while_body142$$while_end144$30:do{if(__label__==52){while(1){var $93=$p123;var $incdec_ptr143=(($93+1)&4294967295);$p123=$incdec_ptr143;var $94=$p123;var $95=HEAP8[($94)];var $conv139=(tempInt=(($95)),(tempInt>=128?tempInt-256:tempInt));var $call140=__Z8isspace2j($conv139);var $tobool141=((($call140))|0)!=0;if($tobool141){__label__=52;continue;}else{__label__=53;break $while_body142$$while_end144$30;}}}}while(0);$ix=0;var $96=$p123;var $97=HEAPU8[($96)];var $conv14612=((($97))&255);var $cmp14713=((($conv14612))|0)>32;if($cmp14713){__label__=54;;}else{__label__=55;;}
$while_body148$$while_end154$34:do{if(__label__==54){while(1){var $98=$p123;var $call149=__Z7utf8_inPiPKc($c,$98);var $99=$p123;var $add_ptr150=(($99+$call149)&4294967295);$p123=$add_ptr150;var $100=HEAP32[(($c)>>2)];var $101=$ix;var $shl151=($100)<<($101);var $102=$replace2;var $add152=((($102)+($shl151))&4294967295);$replace2=$add152;var $103=$ix;var $add153=((($103)+16)&4294967295);$ix=$add153;var $104=$p123;var $105=HEAPU8[($104)];var $conv146=((($105))&255);var $cmp147=((($conv146))|0)>32;if($cmp147){__label__=54;continue;}else{__label__=55;break $while_body148$$while_end154$34;}}}}while(0);var $106=$replace1;var $cmp155=((($106))|0)!=0;if(!($cmp155)){__label__=3;continue $for_cond$5;}
var $107=$f_out_addr;var $108=$replace1;__Z11Write4BytesP7__sFILEi($107,$108);var $109=$f_out_addr;var $110=$replace2;__Z11Write4BytesP7__sFILEi($109,$110);__label__=3;continue $for_cond$5;}}}while(0);var $12=HEAP32[(($n_rules)>>2)];var $cmp17=((($12))|0)>0;if($cmp17){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $13=$n_rgroups;var $arrayidx19=(($rgroup+$13*28)&4294967295);var $name=(($arrayidx19)&4294967295);var $arraydecay20=(($name)&4294967295);var $call21=_strcpy($arraydecay20,((__ZL10group_name)&4294967295));var $14=HEAP32[((__ZL9group3_ix)>>2)];var $15=$n_rgroups;var $arrayidx22=(($rgroup+$15*28)&4294967295);var $group3_ix=(($arrayidx22+24)&4294967295);HEAP32[(($group3_ix)>>2)]=$14;var $16=$f_temp;var $call23=_ftell($16);var $17=$n_rgroups;var $arrayidx24=(($rgroup+$17*28)&4294967295);var $start=(($arrayidx24+16)&4294967295);HEAP32[(($start)>>2)]=$call23;var $18=$f_temp;var $19=HEAP32[(($n_rules)>>2)];__ZL17output_rule_groupP7__sFILEiPPcS1_($18,$19,$arraydecay25);var $20=$f_temp;var $call26=_ftell($20);var $21=$n_rgroups;var $arrayidx27=(($rgroup+$21*28)&4294967295);var $start28=(($arrayidx27+16)&4294967295);var $22=HEAP32[(($start28)>>2)];var $sub=((($call26)-($22))&4294967295);var $23=$n_rgroups;var $arrayidx29=(($rgroup+$23*28)&4294967295);var $length=(($arrayidx29+20)&4294967295);HEAP32[(($length)>>2)]=$sub;var $24=$n_rgroups;var $inc30=((($24)+1)&4294967295);$n_rgroups=$inc30;var $25=HEAP32[(($n_rules)>>2)];var $26=$count;var $add=((($26)+($25))&4294967295);$count=$add;;}
HEAP32[(($n_rules)>>2)]=0;var $27=$compile_mode;var $cmp32=((($27))|0)==2;if($cmp32){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $28=$f_out_addr;var $call34=_fwrite($1,1,4,$28);$compile_mode=0;;}
var $29=$buf;var $cmp36=((($29))|0)==0;if($cmp36){__label__=57;break $for_cond$5;}
var $30=$buf;var $call39=_memcmp($30,((__str81)&4294967295),2);var $cmp40=((($call39))|0)==0;var $31=$buf;if($cmp40){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $arrayidx42=(($31+2)&4294967295);var $32=$f_out_addr;__ZL19compile_lettergroupPcP7__sFILE($arrayidx42,$32);__label__=3;continue $for_cond$5;}
else if(__label__==17){var $call45=_memcmp($31,((__str82)&4294967295),8);var $cmp46=((($call45))|0)==0;if($cmp46){__label__=18;;}else{__label__=20;;}
$if_then47$$if_end53$50:do{if(__label__==18){$compile_mode=2;var $33=$f_out_addr;var $call48=_fputc(6,$33);var $34=$f_out_addr;var $call49=_fputc(20,$34);var $35=$f_out_addr;var $call5014=_ftell($35);var $and15=($call5014)&3;var $cmp5116=((($and15))|0)!=0;if(!($cmp5116)){__label__=20;break $if_then47$$if_end53$50;}
while(1){var $36=$f_out_addr;var $call52=_fputc(0,$36);var $37=$f_out_addr;var $call50=_ftell($37);var $and=($call50)&3;var $cmp51=((($and))|0)!=0;if($cmp51){__label__=19;continue;}else{__label__=20;break $if_then47$$if_end53$50;}}}}while(0);var $38=$buf;var $call54=_memcmp($38,((__str83)&4294967295),6);var $cmp55=((($call54))|0)==0;if(!($cmp55)){__label__=3;continue $for_cond$5;}
$compile_mode=1;var $39=$buf;var $arrayidx57=(($39+6)&4294967295);$p=$arrayidx57;;$while_cond58$56:while(1){var $40=$p;var $arrayidx59=(($40)&4294967295);var $41=HEAPU8[($arrayidx59)];var $conv60=((($41))&255);var $cmp61=((($conv60))|0)==32;if($cmp61){__label__=24;;}else{__label__=23;;}
if(__label__==23){var $42=$p;var $arrayidx62=(($42)&4294967295);var $43=HEAPU8[($arrayidx62)];var $conv63=((($43))&255);var $cmp64=((($conv63))|0)==9;if(!($cmp64)){__label__=25;break $while_cond58$56;}}
var $44=$p;var $incdec_ptr66=(($44+1)&4294967295);$p=$incdec_ptr66;__label__=22;continue $while_cond58$56;}
$ix=0;;$while_cond68$62:while(1){var $45=$p;var $46=HEAPU8[($45)];var $conv69=((($46))&255);var $cmp70=((($conv69))|0)>32;if(!($cmp70)){__label__=29;break $while_cond68$62;}
var $47=$ix;var $cmp71=((($47))|0)<12;if(!($cmp71)){__label__=29;break $while_cond68$62;}
var $48=$p;var $incdec_ptr73=(($48+1)&4294967295);$p=$incdec_ptr73;var $49=HEAP8[($48)];var $50=$ix;var $inc74=((($50)+1)&4294967295);$ix=$inc74;var $arrayidx75=((__ZL10group_name+$50)&4294967295);HEAP8[($arrayidx75)]=$49;__label__=26;continue $while_cond68$62;}
var $51=$ix;var $arrayidx77=((__ZL10group_name+$51)&4294967295);HEAP8[($arrayidx77)]=0;HEAP32[((__ZL9group3_ix)>>2)]=0;var $call78=_sscanf(((__ZL10group_name)&4294967295),((__str84)&4294967295),allocate([$char_code,0,0,0],["i32*",0,0,0],ALLOC_STACK));var $cmp79=((($call78))|0)==1;if($cmp79){__label__=30;;}else{__label__=33;;}
$if_then80$$if_else$67:do{if(__label__==30){$p=((__ZL10group_name)&4294967295);var $52=HEAPU32[(($char_code)>>2)];var $cmp81=((($52))>>>0)>256;if($cmp81){__label__=31;;}else{__label__=32;;}
if(__label__==31){var $53=HEAPU32[(($char_code)>>2)];var $shr=($53)>>>8;var $conv83=((($shr))&255);var $54=$p;var $incdec_ptr84=(($54+1)&4294967295);$p=$incdec_ptr84;HEAP8[($54)]=$conv83;;}
var $55=HEAP32[(($char_code)>>2)];var $conv86=((($55))&255);var $56=$p;var $incdec_ptr87=(($56+1)&4294967295);$p=$incdec_ptr87;HEAP8[($56)]=$conv86;var $57=$p;HEAP8[($57)]=0;__label__=37;break $if_then80$$if_else$67;}
else if(__label__==33){var $58=HEAP32[((_translator)>>2)];var $letter_bits_offset=(($58+964)&4294967295);var $59=HEAP32[(($letter_bits_offset)>>2)];var $cmp88=((($59))|0)>0;if(!($cmp88)){__label__=37;break $if_then80$$if_else$67;}
var $call90=__Z7utf8_inPiPKc($wc,((__ZL10group_name)&4294967295));var $60=HEAP32[(($wc)>>2)];var $61=HEAP32[((_translator)>>2)];var $letter_bits_offset91=(($61+964)&4294967295);var $62=HEAP32[(($letter_bits_offset91)>>2)];var $sub92=((($60)-($62))&4294967295);$ix=$sub92;var $cmp93=((($sub92))|0)>=0;if(!($cmp93)){__label__=37;break $if_then80$$if_else$67;}
var $63=$ix;var $cmp94=((($63))|0)<128;if(!($cmp94)){__label__=37;break $if_then80$$if_else$67;}
var $64=$ix;var $add96=((($64)+1)&4294967295);HEAP32[((__ZL9group3_ix)>>2)]=$add96;__lastLabel__=36;__label__=38;break $if_then80$$if_else$67;}}while(0);if(__label__==37){var $_pr=HEAP32[((__ZL9group3_ix)>>2)];__lastLabel__=37;;}
var $65=__lastLabel__==37?$_pr:($add96);var $cmp100=((($65))|0)==0;if(!($cmp100)){__label__=3;continue $for_cond$5;}
var $call102=_strlen(((__ZL10group_name)&4294967295));var $cmp103=((($call102))>>>0)>2;if(!($cmp103)){__label__=3;continue $for_cond$5;}
var $call105=__Z7utf8_inPiPKc($c,((__ZL10group_name)&4294967295));var $cmp106=((($call105))|0)<2;if($cmp106){__label__=41;;}else{__label__=42;;}
if(__label__==41){var $66=HEAP32[((__ZL5f_log)>>2)];var $67=HEAP32[((__ZL7linenum)>>2)];var $call108=_fprintf($66,((__str85)&4294967295),allocate([$67,0,0,0],["i32",0,0,0],ALLOC_STACK));var $68=HEAP32[((__ZL11error_count)>>2)];var $inc109=((($68)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc109;;}
HEAP8[(((__ZL10group_name+2)&4294967295))]=0;__label__=3;continue $for_cond$5;}}
var $111=$f_temp;var $call158=_fclose($111);var $arraydecay159=(($rgroup)&4294967295);var $112=$arraydecay159;var $113=$n_rgroups;_qsort($112,$113,28,2);var $114=$fname_temp_addr;var $call160=_fopen($114,((__str18429)&4294967295));$f_temp=$call160;var $cmp161=((($call160))|0)==0;if($cmp161){__label__=58;;}else{__label__=59;;}
if(__label__==58){$retval=2;;}
else if(__label__==59){$prev_rgroup_name=((__str15397)&4294967295);$gp=0;var $115=$gp;var $116=$n_rgroups;var $cmp1653=((($115))|0)<((($116))|0);if($cmp1653){__label__=60;;}else{__label__=70;;}
$for_body$$for_end210$88:do{if(__label__==60){$for_body$89:while(1){var $117=$f_temp;var $118=$gp;var $arrayidx166=(($rgroup+$118*28)&4294967295);var $start167=(($arrayidx166+16)&4294967295);var $119=HEAP32[(($start167)>>2)];var $call168=_fseek($117,$119,0);var $120=$gp;var $arrayidx169=(($rgroup+$120*28)&4294967295);var $name170=(($arrayidx169)&4294967295);var $arraydecay171=(($name170)&4294967295);var $121=$prev_rgroup_name;var $call172=_strcmp($arraydecay171,$121);$different=$call172;var $cmp173=((($call172))|0)!=0;if($cmp173){__label__=61;;}else{__label__=67;;}
if(__label__==61){var $122=$gp;var $cmp175=((($122))|0)>0;if($cmp175){__label__=62;;}else{__label__=63;;}
if(__label__==62){var $123=$f_out_addr;var $call177=_fputc(7,$123);;}
var $124=$f_out_addr;var $call179=_fputc(6,$124);var $125=$gp;var $arrayidx180=(($rgroup+$125*28)&4294967295);var $group3_ix181=(($arrayidx180+24)&4294967295);var $126=HEAP32[(($group3_ix181)>>2)];var $cmp182=((($126))|0)!=0;if($cmp182){__label__=64;;}else{__label__=65;;}
if(__label__==64){var $127=$n_groups3;var $inc184=((($127)+1)&4294967295);$n_groups3=$inc184;var $128=$f_out_addr;var $call185=_fputc(1,$128);var $129=$gp;var $arrayidx186=(($rgroup+$129*28)&4294967295);var $group3_ix187=(($arrayidx186+24)&4294967295);var $130=HEAP32[(($group3_ix187)>>2)];var $131=$f_out_addr;var $call188=_fputc($130,$131);;}
else if(__label__==65){var $132=$f_out_addr;var $133=$gp;var $arrayidx190=(($rgroup+$133*28)&4294967295);var $name191=(($arrayidx190)&4294967295);var $arraydecay192=(($name191)&4294967295);$prev_rgroup_name=$arraydecay192;var $fputs=_fputs($arraydecay192,$132);;}
var $134=$f_out_addr;var $call195=_fputc(0,$134);;}
var $135=$gp;var $arrayidx197=(($rgroup+$135*28)&4294967295);var $length198=(($arrayidx197+20)&4294967295);var $136=HEAP32[(($length198)>>2)];$ix=$136;var $cmp2002=((($136))|0)>0;if($cmp2002){__label__=68;;}else{__label__=69;;}
$for_body201$$for_end204$101:do{if(__label__==68){while(1){var $137=$f_temp;var $call202=_fgetc($137);HEAP32[(($c)>>2)]=$call202;var $138=HEAP32[(($c)>>2)];var $139=$f_out_addr;var $call203=_fputc($138,$139);var $140=$ix;var $dec=((($140)-1)&4294967295);$ix=$dec;var $cmp200=((($dec))|0)>0;if($cmp200){__label__=68;continue;}else{__label__=69;break $for_body201$$for_end204$101;}}}}while(0);var $141=$gp;var $inc209=((($141)+1)&4294967295);$gp=$inc209;var $142=$gp;var $143=$n_rgroups;var $cmp165=((($142))|0)<((($143))|0);if($cmp165){__label__=60;continue $for_body$89;}else{__label__=70;break $for_body$$for_end210$88;}}}}while(0);var $144=$f_out_addr;var $call211=_fputc(7,$144);var $145=$f_out_addr;var $call212=_fputc(0,$145);var $146=$f_temp;var $call213=_fclose($146);var $147=$fname_temp_addr;var $call214=_remove($147);var $148=HEAP32[((__ZL5f_log)>>2)];var $149=$count;var $150=$n_rgroups;var $151=$n_groups3;var $call215=_fprintf($148,((__str89)&4294967295),allocate([$149,0,0,0,$150,0,0,0,$151,0,0,0],["i32",0,0,0,"i32",0,0,0,"i32",0,0,0],ALLOC_STACK));$retval=0;;}}
STACKTOP=__stackBase__;return;return;}
function __ZL17output_rule_groupP7__sFILEiPPcS1_($f_out,$n_rules,$rules){var __stackBase__=STACKTOP;STACKTOP+=512;_memset(__stackBase__,0,512);var __label__;var $f_out_addr;var $n_rules_addr;var $rules_addr;var $name_addr;var $ix;var $len1;var $len2;var $len_name;var $p;var $p2;var $p3;var $common;var $nextchar_count=__stackBase__;$f_out_addr=$f_out;$n_rules_addr=$n_rules;$rules_addr=$rules;$name_addr=((__ZL10group_name)&4294967295);var $arraydecay=(($nextchar_count)&4294967295);var $0=$arraydecay;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$0;$stop$=$dest$+512;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $1=$name_addr;var $call=_strlen($1);$len_name=$call;$common=((__str13643)&4294967295);var $2=$rules_addr;var $3=$2;var $4=$n_rules_addr;_qsort($3,$4,4,4);var $5=$name_addr;var $call1=_strcmp($5,((__str103)&4294967295));var $cmp=((($call1))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$len_name=0;;}
$ix=0;var $6=$ix;var $7=$n_rules_addr;var $cmp21=((($6))|0)<((($7))|0);if($cmp21){__label__=3;;}else{__label__=11;;}
$for_body$$for_end$5:do{if(__label__==3){$for_body$6:while(1){var $8=$ix;var $9=$rules_addr;var $arrayidx=(($9+4*$8)&4294967295);var $10=HEAP32[(($arrayidx)>>2)];$p=$10;var $11=$p;var $call3=_strlen($11);var $add=((($call3)+1)&4294967295);$len1=$add;var $12=$len1;var $13=$p;var $arrayidx4=(($13+$12)&4294967295);$p3=$arrayidx4;var $14=$p3;var $15=$len_name;var $add_ptr=(($14+$15)&4294967295);$p2=$add_ptr;var $16=$p2;var $call5=_strlen($16);$len2=$call5;var $17=$p2;var $arrayidx6=(($17)&4294967295);var $18=HEAPU8[($arrayidx6)];var $idxprom=((($18))&255);var $arrayidx7=(($nextchar_count+$idxprom*2)&4294967295);var $19=HEAP16[(($arrayidx7)>>1)];var $inc=((($19)+1)&65535);HEAP16[(($arrayidx7)>>1)]=$inc;var $20=$common;var $arrayidx8=(($20)&4294967295);var $21=HEAP8[($arrayidx8)];var $conv=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));var $cmp9=((($conv))|0)!=0;if($cmp9){__label__=4;;}else{__label__=6;;}
$land_lhs_true$$if_else$8:do{if(__label__==4){var $22=$p;var $23=$common;var $call10=_strcmp($22,$23);var $cmp11=((($call10))|0)==0;if(!($cmp11)){__label__=6;break $land_lhs_true$$if_else$8;}
var $24=$p2;var $25=$len2;var $26=$f_out_addr;var $call13=_fwrite($24,$25,1,$26);var $27=$f_out_addr;var $call14=_fputc(0,$27);__label__=10;break $land_lhs_true$$if_else$8;}}while(0);if(__label__==6){var $28=$ix;var $29=$n_rules_addr;var $sub=((($29)-1)&4294967295);var $cmp15=((($28))|0)<((($sub))|0);if($cmp15){__label__=7;;}else{__label__=9;;}
$land_lhs_true16$$if_end24$13:do{if(__label__==7){var $30=$p;var $31=$ix;var $add17=((($31)+1)&4294967295);var $32=$rules_addr;var $arrayidx18=(($32+4*$add17)&4294967295);var $33=HEAP32[(($arrayidx18)>>2)];var $call19=_strcmp($30,$33);var $cmp20=((($call19))|0)==0;if(!($cmp20)){__label__=9;break $land_lhs_true16$$if_end24$13;}
var $34=$ix;var $35=$rules_addr;var $arrayidx22=(($35+4*$34)&4294967295);var $36=HEAP32[(($arrayidx22)>>2)];$common=$36;var $37=$f_out_addr;var $call23=_fputc(4,$37);;}}while(0);var $38=$p2;var $39=$len2;var $40=$f_out_addr;var $call25=_fwrite($38,$39,1,$40);var $41=$f_out_addr;var $call26=_fputc(3,$41);var $42=$p;var $43=$len1;var $44=$f_out_addr;var $call27=_fwrite($42,$43,1,$44);;}
var $45=$ix;var $inc29=((($45)+1)&4294967295);$ix=$inc29;var $46=$ix;var $47=$n_rules_addr;var $cmp2=((($46))|0)<((($47))|0);if($cmp2){__label__=3;continue $for_body$6;}else{__label__=11;break $for_body$$for_end$5;}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __ZL19compile_lettergroupPcP7__sFILE($input,$f_out){var __stackBase__=STACKTOP;STACKTOP+=1000;_memset(__stackBase__,0,1000);var __label__;var __lastLabel__=null;var $retval;var $input_addr;var $f_out_addr;var $p;var $p_start;var $group;var $ix;var $n_items;var $length;var $max_length;var $items=__stackBase__;var $item_length=__stackBase__+800;$input_addr=$input;$f_out_addr=$f_out;$max_length=0;var $0=$input_addr;$p=$0;var $1=$p;var $arrayidx=(($1)&4294967295);var $2=HEAP8[($arrayidx)];var $conv=(tempInt=(($2)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp=((($conv)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call=((($isdigit))&1);var $tobool=((($call))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
$lor_lhs_false$$if_then$2:do{if(__label__==1){var $3=$p;var $arrayidx1=(($3+1)&4294967295);var $4=HEAP8[($arrayidx1)];var $conv2=(tempInt=(($4)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp1=((($conv2)-48)&4294967295);var $isdigit2=((($isdigittmp1))>>>0)<10;var $call3=((($isdigit2))&1);var $tobool4=((($call3))|0)!=0;if(!($tobool4)){__label__=2;break $lor_lhs_false$$if_then$2;}
var $8=$p;var $arrayidx6=(($8)&4294967295);var $call7=_atoi($arrayidx6);$group=$call7;var $9=$group;var $cmp=((($9))|0)>=26;if($cmp){__label__=5;;}else{__label__=4;;}
if(__label__==5){var $12=HEAP32[((__ZL5f_log)>>2)];var $13=HEAP32[((__ZL7linenum)>>2)];var $call9=_fprintf($12,((__str101)&4294967295),allocate([$13,0,0,0,25,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $14=HEAP32[((__ZL11error_count)>>2)];var $inc10=((($14)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc10;$retval=1;__label__=26;break $lor_lhs_false$$if_then$2;}
else if(__label__==4){var $10=$p;var $11=HEAP8[($10)];var $conv1210=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $call1311=__Z8isspace2j($conv1210);var $tobool1412=((($call1311))|0)!=0;var $lnot13=($tobool1412)^1;if($lnot13){__label__=6;;}else{__label__=7;;}
$while_body$$while_end$8:do{if(__label__==6){while(1){var $15=$p;var $incdec_ptr=(($15+1)&4294967295);$p=$incdec_ptr;var $16=$p;var $17=HEAP8[($16)];var $conv12=(tempInt=(($17)),(tempInt>=128?tempInt-256:tempInt));var $call13=__Z8isspace2j($conv12);var $tobool14=((($call13))|0)!=0;var $lnot=($tobool14)^1;if($lnot){__label__=6;continue;}else{__label__=7;break $while_body$$while_end$8;}}}}while(0);var $18=$f_out_addr;var $call15=_fputc(6,$18);var $19=$f_out_addr;var $call16=_fputc(18,$19);var $20=$group;var $add=((($20)+65)&4294967295);var $21=$f_out_addr;var $call17=_fputc($add,$21);var $22=$group;var $arrayidx18=((__ZL19letterGroupsDefined+$22)&4294967295);var $23=HEAP8[($arrayidx18)];var $conv19=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt));var $cmp20=((($conv19))|0)!=0;if($cmp20){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $24=HEAP32[((__ZL5f_log)>>2)];var $25=HEAP32[((__ZL7linenum)>>2)];var $26=$group;var $call22=_fprintf($24,((__str102)&4294967295),allocate([$25,0,0,0,$26,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $27=HEAP32[((__ZL11error_count)>>2)];var $inc23=((($27)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc23;;}
var $28=$group;var $arrayidx25=((__ZL19letterGroupsDefined+$28)&4294967295);HEAP8[($arrayidx25)]=1;$n_items=0;__lastLabel__=9;;$while_cond26$15:while(1){var $29=__lastLabel__==18?$_pr:(0);var $cmp27=((($29))|0)<200;if(!($cmp27)){__label__=19;break $while_cond26$15;}
var $30=$p;var $31=HEAP8[($30)];var $conv306=(tempInt=(($31)),(tempInt>=128?tempInt-256:tempInt));var $call317=__Z8isspace2j($conv306);var $tobool328=((($call317))|0)!=0;var $32=$p;if($tobool328){__lastLabel__=11;__label__=12;;}else{__lastLabel__=11;__label__=13;;}
$while_body33$$while_end35$18:do{if(__label__==12){while(1){var $33=__lastLabel__==12?$36:($32);var $incdec_ptr34=(($33+1)&4294967295);$p=$incdec_ptr34;var $34=$p;var $35=HEAP8[($34)];var $conv30=(tempInt=(($35)),(tempInt>=128?tempInt-256:tempInt));var $call31=__Z8isspace2j($conv30);var $tobool32=((($call31))|0)!=0;var $36=$p;if($tobool32){__lastLabel__=12;__label__=12;continue;}else{__lastLabel__=12;__label__=13;break $while_body33$$while_end35$18;}}}}while(0);var $_lcssa=__lastLabel__==11?$32:($36);var $37=HEAP8[($_lcssa)];var $conv36=(tempInt=(($37)),(tempInt>=128?tempInt-256:tempInt));var $cmp37=((($conv36))|0)==0;if($cmp37){__label__=19;break $while_cond26$15;}
var $38=$p;$p_start=$38;var $39=$n_items;var $arrayidx40=(($items+$39*4)&4294967295);HEAP32[(($arrayidx40)>>2)]=$38;;while(1){var $40=$p;var $41=HEAP8[($40)];var $conv42=(tempInt=(($41)),(tempInt>=128?tempInt-256:tempInt));var $and=($conv42)&255;var $cmp43=((($and))|0)>32;var $42=$p;var $incdec_ptr45=(($42+1)&4294967295);$p=$incdec_ptr45;if($cmp43){__label__=15;continue;}else{__label__=16;break;}}
HEAP8[($42)]=0;var $43=$p;var $44=$p_start;var $sub_ptr_lhs_cast=($43);var $sub_ptr_rhs_cast=($44);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);$length=$sub_ptr_sub;var $45=$length;var $46=$max_length;var $cmp48=((($45))|0)>((($46))|0);if($cmp48){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $47=$length;$max_length=$47;;}
var $48=$length;var $conv51=((($48))&255);var $49=$n_items;var $inc52=((($49)+1)&4294967295);$n_items=$inc52;var $arrayidx53=(($item_length+$49)&4294967295);HEAP8[($arrayidx53)]=$conv51;var $_pr=$n_items;__lastLabel__=18;__label__=10;continue $while_cond26$15;}
var $_pr3=$max_length;var $cmp565=((($_pr3))|0)>1;if($cmp565){__label__=20;;}else{__label__=25;;}
$while_body57$$while_end67$30:do{if(__label__==20){$while_body57$31:while(1){$ix=0;var $50=$ix;var $51=$n_items;var $cmp584=((($50))|0)<((($51))|0);if($cmp584){__label__=21;;}else{__label__=24;;}
$for_body$$for_end$33:do{if(__label__==21){while(1){var $52=$ix;var $arrayidx59=(($item_length+$52)&4294967295);var $53=HEAP8[($arrayidx59)];var $conv60=(tempInt=(($53)),(tempInt>=128?tempInt-256:tempInt));var $54=$max_length;var $cmp61=((($conv60))|0)==((($54))|0);if($cmp61){__label__=22;;}else{__label__=23;;}
if(__label__==22){var $55=$ix;var $arrayidx63=(($items+$55*4)&4294967295);var $56=HEAP32[(($arrayidx63)>>2)];var $57=$max_length;var $58=$f_out_addr;var $call64=_fwrite($56,1,$57,$58);;}
var $59=$ix;var $inc66=((($59)+1)&4294967295);$ix=$inc66;var $60=$ix;var $61=$n_items;var $cmp58=((($60))|0)<((($61))|0);if($cmp58){__label__=21;continue;}else{__label__=24;break $for_body$$for_end$33;}}}}while(0);var $62=$max_length;var $dec=((($62)-1)&4294967295);$max_length=$dec;var $cmp56=((($dec))|0)>1;if($cmp56){__label__=20;continue $while_body57$31;}else{__label__=25;break $while_body57$$while_end67$30;}}}}while(0);var $63=$f_out_addr;var $call68=_fputc(7,$63);$retval=0;__label__=26;break $lor_lhs_false$$if_then$2;}}}while(0);if(__label__==2){var $5=HEAP32[((__ZL5f_log)>>2)];var $6=HEAP32[((__ZL7linenum)>>2)];var $call5=_fprintf($5,((__str100)&4294967295),allocate([$6,0,0,0],["i32",0,0,0],ALLOC_STACK));var $7=HEAP32[((__ZL11error_count)>>2)];var $inc=((($7)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc;$retval=1;;}
STACKTOP=__stackBase__;return;return;}
function __ZL12compile_rulePc($input){var __stackBase__=STACKTOP;STACKTOP+=244;_memset(__stackBase__,0,244);var __label__;var $retval;var $input_addr;var $ix;var $c;var $wc=__stackBase__;var $p;var $prule;var $len;var $len_name;var $start;var $state=__stackBase__+4;var $finish;var $pre_bracket;var $buf=__stackBase__+8;var $output=__stackBase__+88;var $bad_phoneme=__stackBase__+240;$input_addr=$input;HEAP32[(($state)>>2)]=2;$finish=0;$pre_bracket=0;var $arrayidx=(($buf)&4294967295);HEAP8[($arrayidx)]=0;HEAP8[(((__ZL9rule_cond)&4294967295))]=0;HEAP8[(((__ZL8rule_pre)&4294967295))]=0;HEAP8[(((__ZL9rule_post)&4294967295))]=0;HEAP8[(((__ZL10rule_match)&4294967295))]=0;HEAP8[(((__ZL13rule_phonemes)&4294967295))]=0;var $arraydecay=(($buf)&4294967295);$p=$arraydecay;$ix=0;var $0=$finish;var $cmp2=((($0))|0)==0;if($cmp2){__label__=1;;}else{__label__=13;;}
$for_body_lr_ph$$for_end$2:do{if(__label__==1){var $arraydecay3=(($buf)&4294967295);var $arraydecay4=(($buf)&4294967295);var $arraydecay6=(($buf)&4294967295);var $arraydecay7=(($buf)&4294967295);var $arraydecay12=(($buf)&4294967295);var $arraydecay14=(($buf)&4294967295);var $arraydecay15=(($buf)&4294967295);;$for_body$4:while(1){var $1=$ix;var $2=$input_addr;var $arrayidx1=(($2+$1)&4294967295);var $3=HEAP8[($arrayidx1)];$c=$3;var $4=$ix;var $5=$input_addr;var $arrayidx2=(($5+$4)&4294967295);var $6=HEAPU8[($arrayidx2)];$c=$6;var $conv=((($6))&255);if($conv==41){__label__=3;;}
else if($conv==40){__label__=4;;}
else if($conv==10){__label__=6;break $for_body$4;}
else if($conv==13){__label__=6;break $for_body$4;}
else if($conv==0){__label__=6;break $for_body$4;}
else if($conv==9){__label__=7;;}
else if($conv==32){__label__=7;;}
else if($conv==63){__label__=8;;}
else{__label__=11;;}
$sw_default$$sw_bb$$sw_bb5$$sw_bb13$$sw_bb16$6:do{if(__label__==11){var $21=$c;var $22=$p;var $incdec_ptr20=(($22+1)&4294967295);$p=$incdec_ptr20;HEAP8[($22)]=$21;;}
else if(__label__==3){var $7=$p;HEAP8[($7)]=0;HEAP32[(($state)>>2)]=1;$pre_bracket=1;__ZL16copy_rule_stringPcRi($arraydecay3,$state);$p=$arraydecay4;;}
else if(__label__==4){var $8=$p;HEAP8[($8)]=0;HEAP32[(($state)>>2)]=2;__ZL16copy_rule_stringPcRi($arraydecay6,$state);HEAP32[(($state)>>2)]=3;$p=$arraydecay7;var $9=$ix;var $add=((($9)+1)&4294967295);var $10=$input_addr;var $arrayidx8=(($10+$add)&4294967295);var $11=HEAP8[($arrayidx8)];var $conv9=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $cmp10=((($conv9))|0)==32;if(!($cmp10)){__label__=12;break $sw_default$$sw_bb$$sw_bb5$$sw_bb13$$sw_bb16$6;}
var $12=HEAP32[((__ZL5f_log)>>2)];var $13=HEAP32[((__ZL7linenum)>>2)];var $call=_fprintf($12,((__str90)&4294967295),allocate([$13,0,0,0],["i32",0,0,0],ALLOC_STACK));var $14=HEAP32[((__ZL11error_count)>>2)];var $inc=((($14)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc;;}
else if(__label__==7){var $17=$p;HEAP8[($17)]=0;__ZL16copy_rule_stringPcRi($arraydecay14,$state);$p=$arraydecay15;;}
else if(__label__==8){var $18=HEAP32[(($state)>>2)];var $cmp17=((($18))|0)==2;if($cmp17){__label__=9;;}else{__label__=10;;}
if(__label__==9){HEAP32[(($state)>>2)]=0;;}
else if(__label__==10){var $19=$c;var $20=$p;var $incdec_ptr=(($20+1)&4294967295);$p=$incdec_ptr;HEAP8[($20)]=$19;;}}}while(0);var $_pr=$finish;var $23=$ix;var $inc21=((($23)+1)&4294967295);$ix=$inc21;var $cmp=((($_pr))|0)==0;if($cmp){__label__=2;continue $for_body$4;}else{__label__=13;break $for_body_lr_ph$$for_end$2;}}
var $15=$p;HEAP8[($15)]=0;__ZL16copy_rule_stringPcRi($arraydecay12,$state);$finish=1;var $16=$ix;var $inc213=((($16)+1)&4294967295);$ix=$inc213;;}}while(0);var $call22=_strcmp(((__ZL10rule_match)&4294967295),((__str91)&4294967295));var $cmp23=((($call22))|0)==0;if($cmp23){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $call25=_strcpy(((__ZL10rule_match)&4294967295),((__ZL10group_name)&4294967295));;}
var $24=HEAP8[(((__ZL10rule_match)&4294967295))];var $conv27=(tempInt=(($24)),(tempInt>=128?tempInt-256:tempInt));var $cmp28=((($conv27))|0)==0;if($cmp28){__label__=16;;}else{__label__=19;;}
if(__label__==16){var $25=HEAP8[(((__ZL9rule_post)&4294967295))];var $conv30=(tempInt=(($25)),(tempInt>=128?tempInt-256:tempInt));var $cmp31=((($conv30))|0)!=0;if($cmp31){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $26=HEAP32[((__ZL5f_log)>>2)];var $27=HEAP32[((__ZL7linenum)>>2)];var $call33=_fprintf($26,((__str92)&4294967295),allocate([$27,0,0,0],["i32",0,0,0],ALLOC_STACK));var $28=HEAP32[((__ZL11error_count)>>2)];var $inc34=((($28)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc34;;}
$retval=0;;}
else if(__label__==19){var $arraydecay37=(($buf)&4294967295);var $arraydecay38=(($bad_phoneme)&4294967295);var $call39=__Z14EncodePhonemesPcS_Ph(((__ZL13rule_phonemes)&4294967295),$arraydecay37,$arraydecay38);var $arrayidx40=(($bad_phoneme)&4294967295);var $29=HEAPU8[($arrayidx40)];var $conv41=((($29))&255);var $cmp42=((($conv41))|0)!=0;if($cmp42){__label__=20;;}else{__label__=21;;}
if(__label__==20){var $30=HEAP32[((__ZL5f_log)>>2)];var $31=HEAP32[((__ZL7linenum)>>2)];var $arrayidx44=(($bad_phoneme)&4294967295);var $32=HEAPU8[($arrayidx44)];var $conv45=((($32))&255);var $33=$input_addr;var $call46=_fprintf($30,((__str93)&4294967295),allocate([$31,0,0,0,$conv45,0,0,0,$33,0,0,0],["i32",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $34=HEAP32[((__ZL11error_count)>>2)];var $inc47=((($34)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc47;;}
var $arraydecay49=(($output)&4294967295);var $arraydecay50=(($buf)&4294967295);var $call51=_strcpy($arraydecay49,$arraydecay50);var $arraydecay52=(($buf)&4294967295);var $call53=_strlen($arraydecay52);var $add54=((($call53)+1)&4294967295);$len=$add54;var $call55=_strlen(((__ZL10group_name)&4294967295));$len_name=$call55;var $cmp56=((($call55))|0)>0;if($cmp56){__label__=22;;}else{__label__=26;;}
$land_lhs_true$$if_end70$31:do{if(__label__==22){var $35=$len_name;var $call57=_memcmp(((__ZL10rule_match)&4294967295),((__ZL10group_name)&4294967295),$35);var $cmp58=((($call57))|0)!=0;if(!($cmp58)){__label__=26;break $land_lhs_true$$if_end70$31;}
var $call60=__Z7utf8_inPiPKc($wc,((__ZL10rule_match)&4294967295));var $36=HEAP8[(((__ZL10group_name)&4294967295))];var $conv61=(tempInt=(($36)),(tempInt>=128?tempInt-256:tempInt));var $cmp62=((($conv61))|0)==57;if($cmp62){__label__=24;;}else{__label__=25;;}
if(__label__==24){var $37=HEAP32[(($wc)>>2)];var $call64=__Z7IsDigitj($37);var $tobool=((($call64))|0)!=0;if($tobool){__label__=26;break $land_lhs_true$$if_end70$31;}}
var $38=HEAP32[((__ZL5f_log)>>2)];var $39=HEAP32[((__ZL7linenum)>>2)];var $call67=_fprintf($38,((__str94)&4294967295),allocate([$39,0,0,0,((__ZL10rule_match)&4294967295),0,0,0,((__ZL10group_name)&4294967295),0,0,0],["i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $40=HEAP32[((__ZL11error_count)>>2)];var $inc68=((($40)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc68;;}}while(0);var $41=$len;var $arrayidx71=(($output+$41)&4294967295);var $call72=_strcpy($arrayidx71,((__ZL10rule_match)&4294967295));var $call73=_strlen(((__ZL10rule_match)&4294967295));var $42=$len;var $add74=((($42)+($call73))&4294967295);$len=$add74;var $43=HEAP32[((__ZL10debug_flag)>>2)];var $tobool75=((($43))|0)!=0;if($tobool75){__label__=27;;}else{__label__=28;;}
if(__label__==27){var $44=$len;var $arrayidx77=(($output+$44)&4294967295);HEAP8[($arrayidx77)]=9;var $45=HEAP32[((__ZL7linenum)>>2)];var $rem=((($45))|0)%255;var $add78=((($rem)+1)&4294967295);var $conv79=((($add78))&255);var $46=$len;var $add80=((($46)+1)&4294967295);var $arrayidx81=(($output+$add80)&4294967295);HEAP8[($arrayidx81)]=$conv79;var $47=HEAP32[((__ZL7linenum)>>2)];var $div=((((($47))|0)/255)|0);var $add82=((($div)+1)&4294967295);var $conv83=((($add82))&255);var $48=$len;var $add84=((($48)+2)&4294967295);var $arrayidx85=(($output+$add84)&4294967295);HEAP8[($arrayidx85)]=$conv83;var $49=$len;var $add86=((($49)+3)&4294967295);$len=$add86;;}
var $50=HEAP8[(((__ZL9rule_cond)&4294967295))];var $conv88=(tempInt=(($50)),(tempInt>=128?tempInt-256:tempInt));var $cmp89=((($conv88))|0)!=0;if($cmp89){__label__=29;;}else{__label__=35;;}
if(__label__==29){$ix=-1;var $51=HEAP8[(((__ZL9rule_cond)&4294967295))];var $conv91=(tempInt=(($51)),(tempInt>=128?tempInt-256:tempInt));var $cmp92=((($conv91))|0)==33;if($cmp92){__label__=30;;}else{__label__=31;;}
if(__label__==30){var $call94=_atoi(((__ZL9rule_cond+1)&4294967295));var $add95=((($call94)+32)&4294967295);$ix=$add95;;}
else if(__label__==31){var $call97=_atoi(((__ZL9rule_cond)&4294967295));$ix=$call97;;}
var $52=$ix;var $cmp99=((($52))|0)>0;var $53=$ix;var $cmp101=((($53))|0)<255;var $or_cond=($cmp99)&($cmp101);if($or_cond){__label__=33;;}else{__label__=34;;}
if(__label__==33){var $54=$len;var $inc103=((($54)+1)&4294967295);$len=$inc103;var $arrayidx104=(($output+$54)&4294967295);HEAP8[($arrayidx104)]=5;var $55=$ix;var $conv105=((($55))&255);var $56=$len;var $inc106=((($56)+1)&4294967295);$len=$inc106;var $arrayidx107=(($output+$56)&4294967295);HEAP8[($arrayidx107)]=$conv105;;}
else if(__label__==34){var $57=HEAP32[((__ZL5f_log)>>2)];var $58=HEAP32[((__ZL7linenum)>>2)];var $59=$ix;var $call109=_fprintf($57,((__str95)&4294967295),allocate([$58,0,0,0,$59,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $60=HEAP32[((__ZL11error_count)>>2)];var $inc110=((($60)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc110;;}}
var $61=HEAP8[(((__ZL8rule_pre)&4294967295))];var $conv113=(tempInt=(($61)),(tempInt>=128?tempInt-256:tempInt));var $cmp114=((($conv113))|0)!=0;if($cmp114){__label__=36;;}else{__label__=41;;}
$if_then115$$if_end132$51:do{if(__label__==36){$start=0;var $62=HEAP8[(((__ZL8rule_pre)&4294967295))];var $conv116=(tempInt=(($62)),(tempInt>=128?tempInt-256:tempInt));var $cmp117=((($conv116))|0)==32;if($cmp117){__label__=37;;}else{__label__=38;;}
if(__label__==37){$c=8;$start=1;;}
else if(__label__==38){$c=1;;}
var $63=$c;var $64=$len;var $inc121=((($64)+1)&4294967295);$len=$inc121;var $arrayidx122=(($output+$64)&4294967295);HEAP8[($arrayidx122)]=$63;var $call123=_strlen(((__ZL8rule_pre)&4294967295));var $sub=((($call123)-1)&4294967295);$ix=$sub;var $65=$ix;var $66=$start;var $cmp1251=((($65))|0)>=((($66))|0);if(!($cmp1251)){__label__=41;break $if_then115$$if_end132$51;}
while(1){var $67=$ix;var $arrayidx127=((__ZL8rule_pre+$67)&4294967295);var $68=HEAP8[($arrayidx127)];var $69=$len;var $inc128=((($69)+1)&4294967295);$len=$inc128;var $arrayidx129=(($output+$69)&4294967295);HEAP8[($arrayidx129)]=$68;var $70=$ix;var $dec=((($70)-1)&4294967295);$ix=$dec;var $71=$ix;var $72=$start;var $cmp125=((($71))|0)>=((($72))|0);if($cmp125){__label__=40;continue;}else{__label__=41;break $if_then115$$if_end132$51;}}}}while(0);var $73=HEAP8[(((__ZL9rule_post)&4294967295))];var $conv133=(tempInt=(($73)),(tempInt>=128?tempInt-256:tempInt));var $cmp134=((($conv133))|0)!=0;if($cmp134){__label__=42;;}else{__label__=43;;}
if(__label__==42){var $74=$len;var $arrayidx136=(($output+$74)&4294967295);var $call137=_sprintf($arrayidx136,((__str70722)&4294967295),allocate([2,0,0,0,((__ZL9rule_post)&4294967295),0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $call138=_strlen(((__ZL9rule_post)&4294967295));var $75=$len;var $add139=((($call138)+1)&4294967295);var $add140=((($add139)+($75))&4294967295);$len=$add140;;}
var $76=$len;var $inc142=((($76)+1)&4294967295);$len=$inc142;var $arrayidx143=(($output+$76)&4294967295);HEAP8[($arrayidx143)]=0;var $77=$len;var $call144=_malloc($77);$prule=$call144;var $78=$prule;var $arraydecay145=(($output)&4294967295);var $79=$len;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$arraydecay145;$dest$=$78;$stop$=$src$+$79;if(($dest$%4)==($src$%4)&&$79>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $80=$prule;$retval=$80;;}
var $81=$retval;STACKTOP=__stackBase__;return $81;return null;}
function __ZL13rgroup_sorterP6RGROUPS0_($a,$b){;var __label__;var $retval;var $a_addr;var $b_addr;var $ix;$a_addr=$a;$b_addr=$b;var $0=$b_addr;var $name=(($0)&4294967295);var $arraydecay=(($name)&4294967295);var $call=_strlen($arraydecay);var $1=$a_addr;var $name1=(($1)&4294967295);var $arraydecay2=(($name1)&4294967295);var $call3=_strlen($arraydecay2);var $sub=((($call)-($call3))&4294967295);$ix=$sub;var $2=$ix;var $cmp=((($2))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $3=$ix;$retval=$3;;}
else if(__label__==2){var $4=$a_addr;var $name4=(($4)&4294967295);var $arraydecay5=(($name4)&4294967295);var $5=$b_addr;var $name6=(($5)&4294967295);var $arraydecay7=(($name6)&4294967295);var $call8=_strcmp($arraydecay5,$arraydecay7);$ix=$call8;var $6=$ix;var $cmp9=((($6))|0)!=0;if($cmp9){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $7=$ix;$retval=$7;;}
else if(__label__==4){var $8=$a_addr;var $start=(($8+16)&4294967295);var $9=HEAP32[(($start)>>2)];var $10=$b_addr;var $start12=(($10+16)&4294967295);var $11=HEAP32[(($start12)>>2)];var $sub13=((($9)-($11))&4294967295);$retval=$sub13;;}}
var $12=$retval;;return $12;return null;}
function __ZL16copy_rule_stringPcRi($string,$state){;var __label__;var $string_addr;var $state_addr;var $output;var $p;var $ix;var $len;var $c;var $sxflags;var $value;var $literal;var $mr;$string_addr=$string;$state_addr=$state;var $0=$string_addr;var $arrayidx=(($0)&4294967295);var $1=HEAP8[($arrayidx)];var $conv=(tempInt=(($1)),(tempInt>=128?tempInt-256:tempInt));var $cmp=((($conv))|0)==0;if($cmp){__label__=75;;}else{__label__=1;;}
if(__label__==1){var $2=$state_addr;var $3=HEAP32[(($2)>>2)];var $arrayidx1=((__ZZL16copy_rule_stringPcRiE6outbuf+$3*4)&4294967295);var $4=HEAP32[(($arrayidx1)>>2)];$output=$4;var $5=$state_addr;var $6=HEAP32[(($5)>>2)];var $cmp2=((($6))|0)==4;if($cmp2){__label__=2;;}else{__label__=5;;}
if(__label__==2){var $call=_strlen(((__ZL13rule_phonemes)&4294967295));$len=$call;var $7=$len;var $cmp4=((($7))|0)>0;if($cmp4){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $8=$len;var $inc=((($8)+1)&4294967295);$len=$inc;var $arrayidx6=((__ZL13rule_phonemes+$8)&4294967295);HEAP8[($arrayidx6)]=32;;}
var $9=$len;var $arrayidx8=((__ZL13rule_phonemes+$9)&4294967295);$output=$arrayidx8;;}
$sxflags=8421376;var $10=$string_addr;$p=$10;$ix=0;;$for_cond$10:while(1){$literal=0;var $11=$p;var $incdec_ptr=(($11+1)&4294967295);$p=$incdec_ptr;var $12=HEAP8[($11)];$c=$12;var $13=$c;var $conv10=(tempInt=(($13)),(tempInt>=128?tempInt-256:tempInt));var $cmp11=((($conv10))|0)==92;if($cmp11){__label__=7;;}else{__label__=15;;}
if(__label__==7){var $14=$p;var $incdec_ptr13=(($14+1)&4294967295);$p=$incdec_ptr13;var $15=HEAP8[($14)];$c=$15;var $16=$c;var $conv14=(tempInt=(($16)),(tempInt>=128?tempInt-256:tempInt));var $cmp15=((($conv14))|0)>=48;if($cmp15){__label__=8;;}else{__label__=14;;}
$land_lhs_true$$if_end45$14:do{if(__label__==8){var $17=$c;var $conv16=(tempInt=(($17)),(tempInt>=128?tempInt-256:tempInt));var $cmp17=((($conv16))|0)<=51;if(!($cmp17)){__label__=14;break $land_lhs_true$$if_end45$14;}
var $18=$p;var $arrayidx19=(($18)&4294967295);var $19=HEAP8[($arrayidx19)];var $conv20=(tempInt=(($19)),(tempInt>=128?tempInt-256:tempInt));var $cmp21=((($conv20))|0)>=48;if(!($cmp21)){__label__=14;break $land_lhs_true$$if_end45$14;}
var $20=$p;var $arrayidx23=(($20)&4294967295);var $21=HEAP8[($arrayidx23)];var $conv24=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));var $cmp25=((($conv24))|0)<=55;if(!($cmp25)){__label__=14;break $land_lhs_true$$if_end45$14;}
var $22=$p;var $arrayidx27=(($22+1)&4294967295);var $23=HEAP8[($arrayidx27)];var $conv28=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt));var $cmp29=((($conv28))|0)>=48;if(!($cmp29)){__label__=14;break $land_lhs_true$$if_end45$14;}
var $24=$p;var $arrayidx31=(($24+1)&4294967295);var $25=HEAP8[($arrayidx31)];var $conv32=(tempInt=(($25)),(tempInt>=128?tempInt-256:tempInt));var $cmp33=((($conv32))|0)<=55;if(!($cmp33)){__label__=14;break $land_lhs_true$$if_end45$14;}
var $26=$c;var $conv35=(tempInt=(($26)),(tempInt>=128?tempInt-256:tempInt));var $sub=((($conv35)-48)&4294967295);var $mul=((($sub)*64)&4294967295);var $27=$p;var $arrayidx36=(($27)&4294967295);var $28=HEAP8[($arrayidx36)];var $conv37=(tempInt=(($28)),(tempInt>=128?tempInt-256:tempInt));var $sub38=((($conv37)-48)&4294967295);var $mul39=((($sub38)*8)&4294967295);var $29=$p;var $arrayidx40=(($29+1)&4294967295);var $30=HEAP8[($arrayidx40)];var $conv41=(tempInt=(($30)),(tempInt>=128?tempInt-256:tempInt));var $add=((($mul)-48)&4294967295);var $sub42=((($add)+($conv41))&4294967295);var $add43=((($sub42)+($mul39))&4294967295);var $conv44=((($add43))&255);$c=$conv44;var $31=$p;var $add_ptr=(($31+2)&4294967295);$p=$add_ptr;;}}while(0);$literal=1;;}
var $32=$state_addr;var $33=HEAP32[(($32)>>2)];var $cmp47=((($33))|0)==1;if($cmp47){__label__=17;;}else{__label__=16;;}
$if_then49$$lor_lhs_false$23:do{if(__label__==16){var $34=$state_addr;var $35=HEAP32[(($34)>>2)];var $cmp48=((($35))|0)==3;if($cmp48){__label__=17;break $if_then49$$lor_lhs_false$23;}else{__label__=73;break $if_then49$$lor_lhs_false$23;}}}while(0);$if_then49$$if_end212$25:do{if(__label__==17){var $36=$literal;var $cmp50=((($36))|0)==0;if(!($cmp50)){__label__=73;break $if_then49$$if_end212$25;}
var $37=$c;var $conv52=(tempInt=(($37)),(tempInt>=128?tempInt-256:tempInt));if($conv52==95){__label__=19;;}
else if($conv52==89){__label__=20;;}
else if($conv52==65){__label__=21;;}
else if($conv52==66){__label__=21;;}
else if($conv52==67){__label__=21;;}
else if($conv52==72){__label__=21;;}
else if($conv52==70){__label__=21;;}
else if($conv52==71){__label__=21;;}
else if($conv52==68){__label__=24;;}
else if($conv52==75){__label__=25;;}
else if($conv52==78){__label__=26;;}
else if($conv52==86){__label__=27;;}
else if($conv52==90){__label__=28;;}
else if($conv52==43){__label__=29;;}
else if($conv52==64){__label__=30;;}
else if($conv52==38){__label__=31;;}
else if($conv52==37){__label__=32;;}
else if($conv52==35){__label__=33;;}
else if($conv52==33){__label__=34;;}
else if($conv52==84){__label__=35;;}
else if($conv52==87){__label__=36;;}
else if($conv52==88){__label__=37;;}
else if($conv52==74){__label__=38;;}
else if($conv52==76){__label__=39;;}
else if($conv52==36){__label__=48;;}
else if($conv52==80){__label__=55;;}
else if($conv52==83){__label__=56;;}
else{__label__=73;break $if_then49$$if_end212$25;}
$sw_bb$$sw_bb53$$sw_bb54$$sw_bb74$$sw_bb75$$sw_bb76$$sw_bb77$$sw_bb78$$sw_bb79$$sw_bb80$$sw_bb81$$sw_bb82$$sw_bb83$$sw_bb84$$sw_bb85$$sw_bb88$$sw_bb89$$sw_bb90$$sw_bb91$$sw_bb137$$sw_bb158$$sw_bb159$28:do{if(__label__==19){$c=32;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==20){$c=73;__label__=21;break $sw_bb$$sw_bb53$$sw_bb54$$sw_bb74$$sw_bb75$$sw_bb76$$sw_bb77$$sw_bb78$$sw_bb79$$sw_bb80$$sw_bb81$$sw_bb82$$sw_bb83$$sw_bb84$$sw_bb85$$sw_bb88$$sw_bb89$$sw_bb90$$sw_bb91$$sw_bb137$$sw_bb158$$sw_bb159$28;}
else if(__label__==24){$c=15;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==25){$c=25;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==26){$c=24;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==27){$c=26;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==28){$c=16;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==29){$c=12;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==30){$c=21;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==31){$c=10;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==32){$c=11;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==33){$c=13;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==34){$c=19;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==35){var $48=$ix;var $inc86=((($48)+1)&4294967295);$ix=$inc86;var $49=$output;var $arrayidx87=(($49+$48)&4294967295);HEAP8[($arrayidx87)]=28;$c=17;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==36){$c=31;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==37){$c=29;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==38){$c=23;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==39){var $50=$p;var $incdec_ptr92=(($50+1)&4294967295);$p=$incdec_ptr92;var $51=HEAP8[($50)];var $conv93=(tempInt=(($51)),(tempInt>=128?tempInt-256:tempInt));var $sub94=((($conv93)-48)&4294967295);var $conv95=((($sub94))&255);$c=$conv95;var $52=$p;var $incdec_ptr96=(($52+1)&4294967295);$p=$incdec_ptr96;var $53=HEAP8[($52)];var $conv97=(tempInt=(($53)),(tempInt>=128?tempInt-256:tempInt));var $sub98=((($conv97)-48)&4294967295);$value=$sub98;var $54=$c;var $conv99=(tempInt=(($54)),(tempInt>=128?tempInt-256:tempInt));var $mul100=((($conv99)*10)&4294967295);var $55=$value;var $add101=((($mul100)+($55))&4294967295);var $conv102=((($add101))&255);$c=$conv102;var $56=$value;var $cmp103=((($56))|0)<0;var $57=$value;var $cmp105=((($57))|0)>9;var $or_cond=($cmp103)|($cmp105);if($or_cond){__label__=40;;}else{__label__=41;;}
$if_then106$$if_else109$47:do{if(__label__==40){$c=0;var $58=HEAP32[((__ZL5f_log)>>2)];var $59=HEAP32[((__ZL7linenum)>>2)];var $call107=_fprintf($58,((__str97)&4294967295),allocate([$59,0,0,0],["i32",0,0,0],ALLOC_STACK));var $60=HEAP32[((__ZL11error_count)>>2)];var $inc108=((($60)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc108;;}
else if(__label__==41){var $61=$c;var $conv110=(tempInt=(($61)),(tempInt>=128?tempInt-256:tempInt));var $cmp111=((($conv110))|0)<=0;if($cmp111){__label__=44;;}else{__label__=42;;}
$if_then120$$lor_lhs_false112$50:do{if(__label__==42){var $62=$c;var $conv113=(tempInt=(($62)),(tempInt>=128?tempInt-256:tempInt));var $cmp114=((($conv113))|0)>=26;if($cmp114){__label__=44;break $if_then120$$lor_lhs_false112$50;}
var $63=$c;var $conv116=(tempInt=(($63)),(tempInt>=128?tempInt-256:tempInt));var $arrayidx117=((__ZL19letterGroupsDefined+$conv116)&4294967295);var $64=HEAP8[($arrayidx117)];var $conv118=(tempInt=(($64)),(tempInt>=128?tempInt-256:tempInt));var $cmp119=((($conv118))|0)==0;if(!($cmp119)){__label__=45;break $if_then106$$if_else109$47;}}}while(0);var $65=HEAP32[((__ZL5f_log)>>2)];var $66=HEAP32[((__ZL7linenum)>>2)];var $67=$c;var $conv121=(tempInt=(($67)),(tempInt>=128?tempInt-256:tempInt));var $call122=_fprintf($65,((__str98)&4294967295),allocate([$66,0,0,0,$conv121,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $68=HEAP32[((__ZL11error_count)>>2)];var $inc123=((($68)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc123;;}}while(0);var $69=$c;var $conv126=(tempInt=(($69)),(tempInt>=128?tempInt-256:tempInt));var $add127=((($conv126)+65)&4294967295);var $conv128=((($add127))&255);$c=$conv128;var $70=$state_addr;var $71=HEAP32[(($70)>>2)];var $cmp129=((($71))|0)==1;if($cmp129){__label__=46;;}else{__label__=47;;}
if(__label__==46){var $72=$c;var $73=$ix;var $inc131=((($73)+1)&4294967295);$ix=$inc131;var $74=$output;var $arrayidx132=(($74+$73)&4294967295);HEAP8[($arrayidx132)]=$72;$c=18;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==47){var $75=$ix;var $inc134=((($75)+1)&4294967295);$ix=$inc134;var $76=$output;var $arrayidx135=(($76+$75)&4294967295);HEAP8[($arrayidx135)]=18;__label__=73;break $if_then49$$if_end212$25;}}
else if(__label__==48){var $77=$ix;var $inc138=((($77)+1)&4294967295);$ix=$inc138;var $78=$output;var $arrayidx139=(($78+$77)&4294967295);HEAP8[($arrayidx139)]=28;$c=0;$mr=((_mnem_rules)&4294967295);;while(1){var $79=$mr;var $mnem=(($79)&4294967295);var $80=HEAP32[(($mnem)>>2)];var $cmp140=((($80))|0)!=0;if(!($cmp140)){__label__=53;break;}
var $81=$mr;var $mnem141=(($81)&4294967295);var $82=HEAP32[(($mnem141)>>2)];var $call142=_strlen($82);$len=$call142;var $83=$p;var $84=$mr;var $mnem143=(($84)&4294967295);var $85=HEAP32[(($mnem143)>>2)];var $86=$len;var $call144=_memcmp($83,$85,$86);var $cmp145=((($call144))|0)==0;var $87=$mr;if($cmp145){__label__=51;break;}
var $incdec_ptr151=(($87+8)&4294967295);$mr=$incdec_ptr151;__label__=49;continue;}
if(__label__==51){var $value147=(($87+4)&4294967295);var $88=HEAP32[(($value147)>>2)];var $conv148=((($88))&255);$c=$conv148;var $89=$len;var $90=$p;var $add_ptr149=(($90+$89)&4294967295);$p=$add_ptr149;;}
var $91=$c;var $conv152=(tempInt=(($91)),(tempInt>=128?tempInt-256:tempInt));var $cmp153=((($conv152))|0)==0;if(!($cmp153)){__label__=73;break $if_then49$$if_end212$25;}
var $92=HEAP32[((__ZL5f_log)>>2)];var $93=HEAP32[((__ZL7linenum)>>2)];var $call155=_fprintf($92,((__str99)&4294967295),allocate([$93,0,0,0],["i32",0,0,0],ALLOC_STACK));var $94=HEAP32[((__ZL11error_count)>>2)];var $inc156=((($94)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc156;__label__=73;break $if_then49$$if_end212$25;}
else if(__label__==55){var $95=$sxflags;var $or=($95)|1024;$sxflags=$or;__label__=56;break $sw_bb$$sw_bb53$$sw_bb54$$sw_bb74$$sw_bb75$$sw_bb76$$sw_bb77$$sw_bb78$$sw_bb79$$sw_bb80$$sw_bb81$$sw_bb82$$sw_bb83$$sw_bb84$$sw_bb85$$sw_bb88$$sw_bb89$$sw_bb90$$sw_bb91$$sw_bb137$$sw_bb158$$sw_bb159$28;}}while(0);if(__label__==21){var $38=$state_addr;var $39=HEAP32[(($38)>>2)];var $cmp55=((($39))|0)==1;if($cmp55){__label__=22;;}else{__label__=23;;}
if(__label__==22){var $40=$c;var $conv57=(tempInt=(($40)),(tempInt>=128?tempInt-256:tempInt));var $sub58=((($conv57)-65)&4294967295);var $arrayidx59=((__ZZL16copy_rule_stringPcRiE16lettergp_letters+$sub58)&4294967295);var $41=HEAP8[($arrayidx59)];var $conv60=(tempInt=(($41)),(tempInt>=128?tempInt-256:tempInt));var $add61=((($conv60)+65)&4294967295);var $conv62=((($add61))&255);var $42=$ix;var $inc63=((($42)+1)&4294967295);$ix=$inc63;var $43=$output;var $arrayidx64=(($43+$42)&4294967295);HEAP8[($arrayidx64)]=$conv62;$c=17;;}
else if(__label__==23){var $44=$ix;var $inc65=((($44)+1)&4294967295);$ix=$inc65;var $45=$output;var $arrayidx66=(($45+$44)&4294967295);HEAP8[($arrayidx66)]=17;var $46=$c;var $conv67=(tempInt=(($46)),(tempInt>=128?tempInt-256:tempInt));var $sub68=((($conv67)-65)&4294967295);var $arrayidx69=((__ZZL16copy_rule_stringPcRiE16lettergp_letters+$sub68)&4294967295);var $47=HEAP8[($arrayidx69)];var $conv70=(tempInt=(($47)),(tempInt>=128?tempInt-256:tempInt));var $add71=((($conv70)+65)&4294967295);var $conv72=((($add71))&255);$c=$conv72;;}}
else if(__label__==56){var $96=$ix;var $inc160=((($96)+1)&4294967295);$ix=$inc160;var $97=$output;var $arrayidx161=(($97+$96)&4294967295);HEAP8[($arrayidx161)]=14;$value=0;;while(1){var $98=$p;var $incdec_ptr163=(($98+1)&4294967295);$p=$incdec_ptr163;var $99=HEAP8[($98)];$c=$99;var $conv164=(tempInt=(($99)),(tempInt>=128?tempInt-256:tempInt));var $call165=__Z8isspace2j($conv164);var $tobool=((($call165))|0)!=0;if($tobool){__label__=72;break;}
var $100=$c;var $conv166=(tempInt=(($100)),(tempInt>=128?tempInt-256:tempInt));var $cmp167=((($conv166))|0)!=0;if(!($cmp167)){__label__=72;break;}
var $101=$c;var $conv169=(tempInt=(($101)),(tempInt>=128?tempInt-256:tempInt));if($conv169==101){__label__=60;;}
else if($conv169==105){__label__=61;;}
else if($conv169==112){__label__=62;;}
else if($conv169==118){__label__=63;;}
else if($conv169==100){__label__=64;;}
else if($conv169==102){__label__=65;;}
else if($conv169==113){__label__=66;;}
else if($conv169==116){__label__=67;;}
else if($conv169==98){__label__=68;;}
else if($conv169==97){__label__=69;;}
else{__label__=70;;}
if(__label__==70){var $112=$c;var $conv190=(tempInt=(($112)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp=((($conv190)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call191=((($isdigit))&1);var $tobool192=((($call191))|0)!=0;if(!($tobool192)){__label__=57;continue;}
var $113=$value;var $mul194=((($113)*10)&4294967295);var $114=$c;var $conv195=(tempInt=(($114)),(tempInt>=128?tempInt-256:tempInt));var $sub196=((($mul194)-48)&4294967295);var $add197=((($sub196)+($conv195))&4294967295);$value=$add197;__label__=57;continue;}
else if(__label__==60){var $102=$sxflags;var $or171=($102)|256;$sxflags=$or171;__label__=57;continue;}
else if(__label__==61){var $103=$sxflags;var $or173=($103)|512;$sxflags=$or173;__label__=57;continue;}
else if(__label__==62){var $104=$sxflags;var $or175=($104)|1024;$sxflags=$or175;__label__=57;continue;}
else if(__label__==63){var $105=$sxflags;var $or177=($105)|2048;$sxflags=$or177;__label__=57;continue;}
else if(__label__==64){var $106=$sxflags;var $or179=($106)|4096;$sxflags=$or179;__label__=57;continue;}
else if(__label__==65){var $107=$sxflags;var $or181=($107)|8192;$sxflags=$or181;__label__=57;continue;}
else if(__label__==66){var $108=$sxflags;var $or183=($108)|16384;$sxflags=$or183;__label__=57;continue;}
else if(__label__==67){var $109=$sxflags;var $or185=($109)|65536;$sxflags=$or185;__label__=57;continue;}
else if(__label__==68){var $110=$sxflags;var $or187=($110)|131072;$sxflags=$or187;__label__=57;continue;}
else if(__label__==69){var $111=$sxflags;var $or189=($111)|262144;$sxflags=$or189;__label__=57;continue;}}
var $115=$p;var $incdec_ptr200=(($115+-1)&4294967295);$p=$incdec_ptr200;var $116=$sxflags;var $shr=($116)>>16;var $conv201=((($shr))&255);var $117=$ix;var $inc202=((($117)+1)&4294967295);$ix=$inc202;var $118=$output;var $arrayidx203=(($118+$117)&4294967295);HEAP8[($arrayidx203)]=$conv201;var $119=$sxflags;var $shr204=($119)>>8;var $conv205=((($shr204))&255);var $120=$ix;var $inc206=((($120)+1)&4294967295);$ix=$inc206;var $121=$output;var $arrayidx207=(($121+$120)&4294967295);HEAP8[($arrayidx207)]=$conv205;var $122=$value;var $or208=($122)|128;var $conv209=((($or208))&255);$c=$conv209;;}}}while(0);var $123=$c;var $124=$ix;var $inc213=((($124)+1)&4294967295);$ix=$inc213;var $125=$output;var $arrayidx214=(($125+$124)&4294967295);HEAP8[($arrayidx214)]=$123;var $126=$c;var $conv215=(tempInt=(($126)),(tempInt>=128?tempInt-256:tempInt));var $cmp216=((($conv215))|0)==0;if($cmp216){__label__=74;break $for_cond$10;}else{__label__=6;continue $for_cond$10;}}
var $127=$state_addr;var $128=HEAP32[(($127)>>2)];var $arrayidx219=((__ZZL16copy_rule_stringPcRiE10next_state+$128*4)&4294967295);var $129=HEAP32[(($arrayidx219)>>2)];var $130=$state_addr;HEAP32[(($130)>>2)]=$129;;};return;return;}
function __ZL12compile_linePcS_Pi($linebuf,$dict_line,$hash){var __stackBase__=STACKTOP;STACKTOP+=312;_memset(__stackBase__,0,312);var __label__;var __lastLabel__=null;var $retval;var $linebuf_addr;var $dict_line_addr;var $hash_addr;var $c;var $p;var $word;var $phonetic;var $ix;var $step;var $n_flag_codes;var $flag_offset;var $length;var $multiple_words;var $multiple_numeric_hyphen;var $multiple_string;var $multiple_string_end;var $len_word;var $len_phonetic;var $text_not_phonemes;var $wc=__stackBase__;var $all_upper_case;var $mnemptr;var $comment;var $flag_codes=__stackBase__+4;var $encoded_ph=__stackBase__+104;var $bad_phoneme=__stackBase__+304;var $c2=__stackBase__+308;$linebuf_addr=$linebuf;$dict_line_addr=$dict_line;$hash_addr=$hash;$n_flag_codes=0;$multiple_words=0;$multiple_numeric_hyphen=0;$multiple_string=0;$multiple_string_end=0;$comment=0;$text_not_phonemes=0;$word=((__ZZL12compile_linePcS_PiE10nullstring)&4294967295);$phonetic=((__ZZL12compile_linePcS_PiE10nullstring)&4294967295);var $0=$linebuf_addr;var $call=_memcmp($0,((__str108)&4294967295),2);var $cmp=((($call))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$step=1;;}
var $1=$linebuf_addr;$p=$1;$step=0;$c=0;var $2=$c;var $conv13=((($2))&255);var $cmp114=((($conv13))|0)!=10;if($cmp114){__label__=3;;}else{__label__=55;;}
$while_body$$while_end147$5:do{if(__label__==3){$while_body$6:while(1){var $3=$p;var $4=HEAP8[($3)];$c=$4;var $5=$c;var $conv2=((($5))&255);var $cmp3=((($conv2))|0)==63;if($cmp3){__label__=4;;}else{__label__=12;;}
$land_lhs_true$$if_end28$8:do{if(__label__==4){var $6=$step;var $cmp4=((($6))|0)==0;if(!($cmp4)){__label__=12;break $land_lhs_true$$if_end28$8;}
$flag_offset=100;var $7=$p;var $incdec_ptr=(($7+1)&4294967295);$p=$incdec_ptr;var $8=$p;var $9=HEAP8[($8)];var $conv6=(tempInt=(($9)),(tempInt>=128?tempInt-256:tempInt));var $cmp7=((($conv6))|0)==33;if($cmp7){__label__=6;;}else{__label__=7;;}
if(__label__==6){$flag_offset=132;var $10=$p;var $incdec_ptr9=(($10+1)&4294967295);$p=$incdec_ptr9;;}
$ix=0;var $11=$p;var $12=HEAP8[($11)];var $conv11=(tempInt=(($12)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp=((($conv11)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call12=((($isdigit))&1);var $tobool=((($call12))|0)!=0;if($tobool){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $13=$p;var $14=HEAP8[($13)];var $conv14=(tempInt=(($14)),(tempInt>=128?tempInt-256:tempInt));var $15=$ix;var $sub=((($15)-48)&4294967295);var $add=((($sub)+($conv14))&4294967295);$ix=$add;var $16=$p;var $incdec_ptr15=(($16+1)&4294967295);$p=$incdec_ptr15;;}
var $17=$p;var $18=HEAP8[($17)];var $conv17=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp1=((($conv17)-48)&4294967295);var $isdigit2=((($isdigittmp1))>>>0)<10;var $call18=((($isdigit2))&1);var $tobool19=((($call18))|0)!=0;if($tobool19){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $19=$ix;var $mul=((($19)*10)&4294967295);var $20=$p;var $21=HEAP8[($20)];var $conv21=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));var $sub22=((($mul)-48)&4294967295);var $add23=((($sub22)+($conv21))&4294967295);$ix=$add23;var $22=$p;var $incdec_ptr24=(($22+1)&4294967295);$p=$incdec_ptr24;;}
var $23=$ix;var $24=$flag_offset;var $add26=((($24)+($23))&4294967295);var $conv27=((($add26))&255);var $25=$n_flag_codes;var $inc=((($25)+1)&4294967295);$n_flag_codes=$inc;var $arrayidx=(($flag_codes+$25)&4294967295);HEAP8[($arrayidx)]=$conv27;var $26=$p;var $27=HEAP8[($26)];$c=$27;;}}while(0);var $28=$c;var $conv29=((($28))&255);var $cmp30=((($conv29))|0)==36;if($cmp30){__label__=13;;}else{__label__=25;;}
$land_lhs_true31$$if_end64$21:do{if(__label__==13){var $29=$p;var $arrayidx32=(($29+1)&4294967295);var $30=HEAP8[($arrayidx32)];var $conv33=(tempInt=(($30)),(tempInt>=128?tempInt-256:tempInt));var $call34=_isalnum($conv33);var $tobool35=((($call34))|0)!=0;if(!($tobool35)){__label__=25;break $land_lhs_true31$$if_end64$21;}
var $31=$p;$mnemptr=$31;var $32=$p;var $33=HEAPU8[($32)];$c=$33;var $conv389=((($33))&255);var $call3910=__Z8isspace2j($conv389);var $tobool4011=((($call3910))|0)!=0;var $lnot12=($tobool4011)^1;var $34=$p;if($lnot12){__lastLabel__=14;__label__=15;;}else{__lastLabel__=14;__label__=16;;}
$while_body41$$while_end$24:do{if(__label__==15){while(1){var $35=__lastLabel__==15?$38:($34);var $incdec_ptr42=(($35+1)&4294967295);$p=$incdec_ptr42;var $36=$p;var $37=HEAPU8[($36)];$c=$37;var $conv38=((($37))&255);var $call39=__Z8isspace2j($conv38);var $tobool40=((($call39))|0)!=0;var $lnot=($tobool40)^1;var $38=$p;if($lnot){__lastLabel__=15;__label__=15;continue;}else{__lastLabel__=15;__label__=16;break $while_body41$$while_end$24;}}}}while(0);var $_lcssa=__lastLabel__==14?$34:($38);HEAP8[($_lcssa)]=0;var $39=$mnemptr;var $call43=__Z10LookupMnemP8MNEM_TABPKc(((_mnem_flags)&4294967295),$39);$ix=$call43;var $cmp44=((($call43))>>>0)>0;if($cmp44){__label__=17;;}else{__label__=24;;}
if(__label__==17){var $40=$ix;var $cmp46=((($40))|0)==200;if($cmp46){__label__=18;;}else{__label__=19;;}
if(__label__==18){HEAP8[(__ZL9text_mode_b)]=1;;}
else if(__label__==19){var $41=$ix;var $cmp48=((($41))|0)==201;if($cmp48){__label__=20;;}else{__label__=21;;}
if(__label__==20){HEAP8[(__ZL9text_mode_b)]=0;;}
else if(__label__==21){var $42=$ix;var $cmp51=((($42))|0)==29;if($cmp51){__label__=22;;}else{__label__=23;;}
if(__label__==22){$text_not_phonemes=1;;}
else if(__label__==23){var $43=$ix;var $conv54=((($43))&255);var $44=$n_flag_codes;var $inc55=((($44)+1)&4294967295);$n_flag_codes=$inc55;var $arrayidx56=(($flag_codes+$44)&4294967295);HEAP8[($arrayidx56)]=$conv54;;}}}}
else if(__label__==24){var $45=HEAP32[((__ZL5f_log)>>2)];var $46=HEAP32[((__ZL7linenum)>>2)];var $47=$mnemptr;var $call61=_fprintf($45,((__str109)&4294967295),allocate([$46,0,0,0,$47,0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $48=HEAP32[((__ZL11error_count)>>2)];var $inc62=((($48)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc62;;}}}while(0);var $49=$c;var $conv65=((($49))&255);var $cmp66=((($conv65))|0)==47;if($cmp66){__label__=26;;}else{__label__=29;;}
$land_lhs_true67$$if_end74$41:do{if(__label__==26){var $50=$p;var $arrayidx68=(($50+1)&4294967295);var $51=HEAP8[($arrayidx68)];var $conv69=(tempInt=(($51)),(tempInt>=128?tempInt-256:tempInt));var $cmp70=((($conv69))|0)==47;if(!($cmp70)){__label__=29;break $land_lhs_true67$$if_end74$41;}
var $52=$multiple_words;var $cmp72=((($52))|0)==0;if(!($cmp72)){__label__=29;break $land_lhs_true67$$if_end74$41;}
$c=10;var $53=$p;$comment=$53;;}}while(0);var $54=$step;if($54==0){__label__=30;;}
else if($54==1){__label__=34;;}
else if($54==2){__label__=46;;}
else if($54==3){__label__=50;;}
else if($54==4){__label__=52;;}
else{__label__=54;;}
$sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46:do{if(__label__==30){var $55=$c;var $conv75=((($55))&255);var $cmp76=((($conv75))|0)==40;if($cmp76){__label__=31;;}else{__label__=32;;}
if(__label__==31){$multiple_words=1;var $56=$p;var $add_ptr=(($56+1)&4294967295);$word=$add_ptr;$step=1;;}
else if(__label__==32){var $57=$c;var $conv79=((($57))&255);var $call80=__Z8isspace2j($conv79);var $tobool81=((($call80))|0)!=0;if($tobool81){__label__=54;break $sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46;}
var $58=$p;$word=$58;$step=1;;}}
else if(__label__==34){var $59=$c;var $conv86=((($59))&255);var $cmp87=((($conv86))|0)==45;if($cmp87){__label__=35;;}else{__label__=39;;}
$land_lhs_true88$$if_end99$53:do{if(__label__==35){var $60=$multiple_words;var $tobool89=((($60))|0)!=0;if(!($tobool89)){__label__=39;break $land_lhs_true88$$if_end99$53;}
var $61=$word;var $arrayidx91=(($61)&4294967295);var $62=HEAP8[($arrayidx91)];var $conv92=(tempInt=(($62)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp3=((($conv92)-48)&4294967295);var $isdigit4=((($isdigittmp3))>>>0)<10;var $call93=((($isdigit4))&1);var $tobool94=((($call93))|0)!=0;if($tobool94){__label__=37;;}else{__label__=38;;}
if(__label__==37){$multiple_numeric_hyphen=1;;}
var $63=$n_flag_codes;var $inc97=((($63)+1)&4294967295);$n_flag_codes=$inc97;var $arrayidx98=(($flag_codes+$63)&4294967295);HEAP8[($arrayidx98)]=44;$c=32;;}}while(0);var $64=$c;var $conv100=((($64))&255);var $call101=__Z8isspace2j($conv100);var $tobool102=((($call101))|0)!=0;if($tobool102){__label__=40;;}else{__label__=43;;}
if(__label__==40){var $65=$p;var $arrayidx104=(($65)&4294967295);HEAP8[($arrayidx104)]=0;var $66=$multiple_words;var $tobool105=((($66))|0)!=0;if($tobool105){__label__=41;;}else{__label__=42;;}
if(__label__==41){var $67=$p;var $add_ptr107=(($67+1)&4294967295);$multiple_string_end=$add_ptr107;$multiple_string=$add_ptr107;$step=2;;}
else if(__label__==42){$step=3;;}}
else if(__label__==43){var $68=$c;var $conv111=((($68))&255);var $cmp112=((($conv111))|0)==41;if(!($cmp112)){__label__=54;break $sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46;}
var $69=$multiple_words;var $tobool114=((($69))|0)!=0;if(!($tobool114)){__label__=54;break $sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46;}
var $70=$p;var $arrayidx116=(($70)&4294967295);HEAP8[($arrayidx116)]=0;$step=3;$multiple_words=0;;}}
else if(__label__==46){var $71=$c;var $conv120=((($71))&255);var $call121=__Z8isspace2j($conv120);var $tobool122=((($call121))|0)!=0;if($tobool122){__label__=47;;}else{__label__=48;;}
if(__label__==47){var $72=$multiple_words;var $inc124=((($72)+1)&4294967295);$multiple_words=$inc124;;}
else if(__label__==48){var $73=$c;var $conv126=((($73))&255);var $cmp127=((($conv126))|0)==41;if(!($cmp127)){__label__=54;break $sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46;}
var $74=$p;var $arrayidx129=(($74)&4294967295);HEAP8[($arrayidx129)]=32;var $75=$p;var $add_ptr130=(($75+1)&4294967295);$multiple_string_end=$add_ptr130;$step=3;;}}
else if(__label__==50){var $76=$c;var $conv134=((($76))&255);var $call135=__Z8isspace2j($conv134);var $tobool136=((($call135))|0)!=0;if($tobool136){__label__=54;break $sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46;}
var $77=$p;$phonetic=$77;$step=4;;}
else if(__label__==52){var $78=$c;var $conv140=((($78))&255);var $call141=__Z8isspace2j($conv140);var $tobool142=((($call141))|0)!=0;if(!($tobool142)){__label__=54;break $sw_epilog$$sw_bb$$sw_bb85$$sw_bb119$$sw_bb133$$sw_bb139$46;}
var $79=$p;var $arrayidx144=(($79)&4294967295);HEAP8[($arrayidx144)]=0;$step=5;;}}while(0);var $80=$p;var $incdec_ptr146=(($80+1)&4294967295);$p=$incdec_ptr146;var $81=$c;var $conv=((($81))&255);var $cmp1=((($conv))|0)!=10;if($cmp1){__label__=3;continue $while_body$6;}else{__label__=55;break $while_body$$while_end147$5;}}}}while(0);var $82=$word;var $arrayidx148=(($82)&4294967295);var $83=HEAP8[($arrayidx148)];var $conv149=(tempInt=(($83)),(tempInt>=128?tempInt-256:tempInt));var $cmp150=((($conv149))|0)==0;if($cmp150){__label__=56;;}else{__label__=57;;}
if(__label__==56){$retval=0;;}
else if(__label__==57){var $_b=HEAPU8[(__ZL9text_mode_b)];var $84=((($_b))&1);var $tobool153=((($84))|0)!=0;if($tobool153){__label__=58;;}else{__label__=59;;}
$if_end155_thread$$if_end155$82:do{if(__label__==58){$text_not_phonemes=1;__label__=60;break $if_end155_thread$$if_end155$82;}
else if(__label__==59){var $_pr=$text_not_phonemes;var $tobool156=((($_pr))|0)!=0;if($tobool156){__label__=60;break $if_end155_thread$$if_end155$82;}
var $96=$phonetic;var $arraydecay176=(($encoded_ph)&4294967295);var $arraydecay177=(($bad_phoneme)&4294967295);var $call178=__Z14EncodePhonemesPcS_Ph($96,$arraydecay176,$arraydecay177);var $arraydecay179=(($encoded_ph)&4294967295);var $call180=_strchr($arraydecay179,21);var $cmp181=((($call180))|0)!=0;if($cmp181){__label__=65;;}else{__label__=66;;}
if(__label__==65){var $97=$n_flag_codes;var $inc183=((($97)+1)&4294967295);$n_flag_codes=$inc183;var $arrayidx184=(($flag_codes+$97)&4294967295);HEAP8[($arrayidx184)]=10;;}
var $arrayidx186=(($bad_phoneme)&4294967295);var $98=HEAPU8[($arrayidx186)];var $conv187=((($98))&255);var $cmp188=((($conv187))|0)!=0;if(!($cmp188)){__label__=68;break $if_end155_thread$$if_end155$82;}
var $99=HEAP32[((__ZL5f_log)>>2)];var $100=HEAP32[((__ZL7linenum)>>2)];var $arrayidx190=(($bad_phoneme)&4294967295);var $101=HEAPU8[($arrayidx190)];var $conv191=((($101))&255);var $arrayidx192=(($bad_phoneme)&4294967295);var $102=HEAPU8[($arrayidx192)];var $conv193=((($102))&255);var $103=$word;var $104=$phonetic;var $call194=_fprintf($99,((__str112)&4294967295),allocate([$100,0,0,0,$conv191,0,0,0,$conv193,0,0,0,$103,0,0,0,$104,0,0,0],["i32",0,0,0,"i32",0,0,0,"i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $105=HEAP32[((__ZL11error_count)>>2)];var $inc195=((($105)+1)&4294967295);HEAP32[((__ZL11error_count)>>2)]=$inc195;__label__=68;break $if_end155_thread$$if_end155$82;}}while(0);$if_then157$$if_end197$90:do{if(__label__==60){var $85=$word;var $arrayidx158=(($85)&4294967295);var $86=HEAP8[($arrayidx158)];var $conv159=(tempInt=(($86)),(tempInt>=128?tempInt-256:tempInt));var $cmp160=((($conv159))|0)==95;if($cmp160){__label__=61;;}else{__label__=63;;}
if(__label__==61){var $87=$phonetic;var $strlen=_strlen($87);var $endptr=(($87+$strlen)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str110)&4294967295);$dest$=$endptr;$stop$=$src$+2;if(($dest$%4)==($src$%4)&&2>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $88=HEAP32[((_translator)>>2)];var $89=$phonetic;var $call163=__Z13TranslateWordP10TranslatorPciP8WORD_TAB($88,$89,0,0);$text_not_phonemes=0;var $arraydecay=(($encoded_ph)&4294967295);__Z8strncpy0PcPKci($arraydecay,((_word_phonemes)&4294967295),156);var $90=HEAP8[(((_word_phonemes)&4294967295))];var $conv164=(tempInt=(($90)),(tempInt>=128?tempInt-256:tempInt));var $cmp165=((($conv164))|0)==0;var $91=HEAP32[((__ZL21error_need_dictionary)>>2)];var $cmp167=((($91))|0)<3;var $or_cond=($cmp165)&($cmp167);if(!($or_cond)){__label__=68;break $if_then157$$if_end197$90;}
var $92=HEAP32[((__ZL21error_need_dictionary)>>2)];var $inc169=((($92)+1)&4294967295);HEAP32[((__ZL21error_need_dictionary)>>2)]=$inc169;var $93=HEAP32[((__ZL5f_log)>>2)];var $94=HEAP32[((__ZL7linenum)>>2)];var $call170=_fprintf($93,((__str111)&4294967295),allocate([$94,0,0,0],["i32",0,0,0],ALLOC_STACK));;}
else if(__label__==63){var $arraydecay173=(($encoded_ph)&4294967295);var $95=$phonetic;__Z8strncpy0PcPKci($arraydecay173,$95,156);;}}}while(0);var $106=$text_not_phonemes;var $107=HEAP32[((_translator)>>2)];var $langopts=(($107)&4294967295);var $textmode=(($langopts+252)&4294967295);var $108=HEAP8[($textmode)];var $conv198=(tempInt=(($108)),(tempInt>=128?tempInt-256:tempInt));var $cmp199=((($106))|0)!=((($conv198))|0);if($cmp199){__label__=69;;}else{__label__=70;;}
if(__label__==69){var $109=$n_flag_codes;var $inc201=((($109)+1)&4294967295);$n_flag_codes=$inc201;var $arrayidx202=(($flag_codes+$109)&4294967295);HEAP8[($arrayidx202)]=29;;}
var $110=$word;var $call204=_sscanf($110,((__str113)&4294967295),allocate([$wc,0,0,0],["i32*",0,0,0],ALLOC_STACK));var $cmp205=((($call204))|0)==1;if($cmp205){__label__=71;;}else{__label__=72;;}
$if_then206$$if_else209$100:do{if(__label__==71){var $111=HEAP32[(($wc)>>2)];var $112=$word;var $call207=__Z8utf8_outjPc($111,$112);$ix=$call207;var $113=$ix;var $114=$word;var $arrayidx208=(($114+$113)&4294967295);HEAP8[($arrayidx208)]=0;;}
else if(__label__==72){var $115=$word;var $arrayidx210=(($115)&4294967295);var $116=HEAP8[($arrayidx210)];var $conv211=(tempInt=(($116)),(tempInt>=128?tempInt-256:tempInt));var $cmp212=((($conv211))|0)!=95;if(!($cmp212)){__label__=80;break $if_then206$$if_else209$100;}
$all_upper_case=1;var $117=$word;$p=$117;var $118=$word;$p=$118;var $119=$p;var $call2146=__Z7utf8_inPiPKc($c2,$119);$ix=$call2146;var $120=HEAP32[(($c2)>>2)];var $cmp2157=((($120))|0)==0;if($cmp2157){__label__=78;;}else{__label__=74;;}
$for_end$$if_end217$104:do{if(__label__==74){while(1){var $121=HEAP32[(($c2)>>2)];var $call218=_iswupper($121);var $tobool219=((($call218))|0)!=0;if($tobool219){__label__=75;;}else{__label__=76;;}
if(__label__==75){var $122=HEAP32[(($c2)>>2)];var $call221=_towlower($122);var $123=$p;var $call222=__Z8utf8_outjPc($call221,$123);;}
else if(__label__==76){$all_upper_case=0;;}
var $124=$ix;var $125=$p;var $add_ptr225=(($125+$124)&4294967295);$p=$add_ptr225;var $126=$p;var $call214=__Z7utf8_inPiPKc($c2,$126);$ix=$call214;var $127=HEAP32[(($c2)>>2)];var $cmp215=((($127))|0)==0;if($cmp215){__label__=78;break $for_end$$if_end217$104;}else{__label__=74;continue;}}}}while(0);var $128=$all_upper_case;var $tobool226=((($128))|0)!=0;if(!($tobool226)){__label__=80;break $if_then206$$if_else209$100;}
var $129=$n_flag_codes;var $inc228=((($129)+1)&4294967295);$n_flag_codes=$inc228;var $arrayidx229=(($flag_codes+$129)&4294967295);HEAP8[($arrayidx229)]=42;;}}while(0);var $130=$word;var $call233=_strlen($130);$len_word=$call233;var $131=HEAP32[((_translator)>>2)];var $transpose_min=(($131+288)&4294967295);var $132=HEAP32[(($transpose_min)>>2)];var $cmp234=((($132))|0)>0;if($cmp234){__label__=81;;}else{__label__=82;;}
if(__label__==81){var $133=HEAP32[((_translator)>>2)];var $134=$word;var $call236=__Z17TransposeAlphabetP10TranslatorPc($133,$134);$len_word=$call236;;}
var $135=$word;var $call238=__Z14HashDictionaryPKc($135);var $136=$hash_addr;HEAP32[(($136)>>2)]=$call238;var $arraydecay239=(($encoded_ph)&4294967295);var $call240=_strlen($arraydecay239);$len_phonetic=$call240;var $137=$len_word;var $conv241=((($137))&255);var $138=$dict_line_addr;var $arrayidx242=(($138+1)&4294967295);HEAP8[($arrayidx242)]=$conv241;var $139=$len_word;var $and=($139)&63;$len_word=$and;var $140=$dict_line_addr;var $arrayidx243=(($140+2)&4294967295);var $141=$word;var $142=$len_word;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$141;$dest$=$arrayidx243;$stop$=$src$+$142;if(($dest$%4)==($src$%4)&&$142>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $143=$len_phonetic;var $cmp244=((($143))|0)==0;if($cmp244){__label__=83;;}else{__label__=84;;}
if(__label__==83){var $144=$dict_line_addr;var $arrayidx246=(($144+1)&4294967295);var $145=HEAP8[($arrayidx246)];var $conv247=(tempInt=(($145)),(tempInt>=128?tempInt-256:tempInt));var $or=($conv247)|128;var $conv248=((($or))&255);HEAP8[($arrayidx246)]=$conv248;var $146=$len_word;var $add249=((($146)+2)&4294967295);$length=$add249;;}
else if(__label__==84){var $147=$len_word;var $148=$len_phonetic;var $add251=((($147)+3)&4294967295);var $add252=((($add251)+($148))&4294967295);$length=$add252;var $149=$len_word;var $add253=((($149)+2)&4294967295);var $150=$dict_line_addr;var $arrayidx254=(($150+$add253)&4294967295);var $arraydecay255=(($encoded_ph)&4294967295);var $call256=_strcpy($arrayidx254,$arraydecay255);;}
$ix=0;var $151=$ix;var $152=$n_flag_codes;var $cmp2598=((($151))>>>0)<((($152))>>>0);if($cmp2598){__label__=86;;}else{__label__=87;;}
$for_body$$for_end264$121:do{if(__label__==86){while(1){var $153=$ix;var $arrayidx260=(($flag_codes+$153)&4294967295);var $154=HEAP8[($arrayidx260)];var $155=$ix;var $156=$length;var $add261=((($156)+($155))&4294967295);var $157=$dict_line_addr;var $arrayidx262=(($157+$add261)&4294967295);HEAP8[($arrayidx262)]=$154;var $158=$ix;var $inc263=((($158)+1)&4294967295);$ix=$inc263;var $159=$ix;var $160=$n_flag_codes;var $cmp259=((($159))>>>0)<((($160))>>>0);if($cmp259){__label__=86;continue;}else{__label__=87;break $for_body$$for_end264$121;}}}}while(0);var $161=$n_flag_codes;var $162=$length;var $add265=((($162)+($161))&4294967295);$length=$add265;var $163=$multiple_string;var $cmp266=((($163))|0)!=0;if($cmp266){__label__=88;;}else{__label__=94;;}
$land_lhs_true267$$if_end286$125:do{if(__label__==88){var $164=$multiple_words;var $cmp268=((($164))|0)>0;if(!($cmp268)){__label__=94;break $land_lhs_true267$$if_end286$125;}
var $165=$multiple_words;var $cmp270=((($165))|0)>10;if($cmp270){__label__=90;;}else{__label__=91;;}
if(__label__==90){var $166=HEAP32[((__ZL5f_log)>>2)];var $167=HEAP32[((__ZL7linenum)>>2)];var $168=$multiple_words;var $call272=_fprintf($166,((__str114)&4294967295),allocate([$167,0,0,0,$168,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));;}
else if(__label__==91){var $169=$multiple_words;var $add274=((($169)+80)&4294967295);var $conv275=((($add274))&255);var $170=$length;var $inc276=((($170)+1)&4294967295);$length=$inc276;var $171=$dict_line_addr;var $arrayidx277=(($171+$170)&4294967295);HEAP8[($arrayidx277)]=$conv275;var $172=$multiple_string_end;var $173=$multiple_string;var $sub_ptr_lhs_cast=($172);var $sub_ptr_rhs_cast=($173);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);$ix=$sub_ptr_sub;var $174=$multiple_numeric_hyphen;var $tobool278=((($174))|0)!=0;if($tobool278){__label__=92;;}else{__label__=93;;}
if(__label__==92){var $175=$length;var $inc280=((($175)+1)&4294967295);$length=$inc280;var $176=$dict_line_addr;var $arrayidx281=(($176+$175)&4294967295);HEAP8[($arrayidx281)]=32;;}
var $177=$length;var $178=$dict_line_addr;var $arrayidx283=(($178+$177)&4294967295);var $179=$multiple_string;var $180=$ix;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$179;$dest$=$arrayidx283;$stop$=$src$+$180;if(($dest$%4)==($src$%4)&&$180>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $181=$ix;var $182=$length;var $add284=((($182)+($181))&4294967295);$length=$add284;;}}}while(0);var $183=$length;var $conv287=((($183))&255);var $184=$dict_line_addr;var $arrayidx288=(($184)&4294967295);HEAP8[($arrayidx288)]=$conv287;var $185=$length;$retval=$185;;}
var $186=$retval;STACKTOP=__stackBase__;return $186;return null;}
function __Z8strncpy0PcPKci($to,$from,$size){;var __label__;var $to_addr;var $from_addr;var $size_addr;$to_addr=$to;$from_addr=$from;$size_addr=$size;var $0=$to_addr;var $1=$from_addr;var $2=$size_addr;var $call=_strncpy($0,$1,$2);var $3=$size_addr;var $sub=((($3)-1)&4294967295);var $4=$to_addr;var $arrayidx=(($4+$sub)&4294967295);HEAP8[($arrayidx)]=0;;return;return;}
function __Z13Reverse4Bytesi($word){;var __label__;var $word_addr;$word_addr=$word;var $0=$word_addr;;return $0;return null;}
function __Z10LookupMnemP8MNEM_TABPKc($table,$string){;var __label__;var $retval;var $table_addr;var $string_addr;$table_addr=$table;$string_addr=$string;;while(1){var $0=$table_addr;var $mnem=(($0)&4294967295);var $1=HEAP32[(($mnem)>>2)];var $cmp=((($1))|0)!=0;if(!($cmp)){__label__=5;break;}
var $2=$string_addr;var $3=$table_addr;var $mnem1=(($3)&4294967295);var $4=HEAP32[(($mnem1)>>2)];var $call=_strcmp($2,$4);var $cmp2=((($call))|0)==0;var $5=$table_addr;if($cmp2){__label__=3;break;}
var $incdec_ptr=(($5+8)&4294967295);$table_addr=$incdec_ptr;__label__=1;continue;}
if(__label__==5){var $7=$table_addr;var $value3=(($7+4)&4294967295);var $8=HEAP32[(($value3)>>2)];$retval=$8;;}
else if(__label__==3){var $value=(($5+4)&4294967295);var $6=HEAP32[(($value)>>2)];$retval=$6;;}
var $9=$retval;;return $9;return null;}
function __Z14LoadDictionaryP10TranslatorPKci($tr,$name,$no_error){var __stackBase__=STACKTOP;STACKTOP+=172;_memset(__stackBase__,0,172);var __label__;var $retval;var $tr_addr;var $name_addr;var $no_error_addr;var $hash;var $p;var $pw;var $length;var $f;var $size;var $fname=__stackBase__;$tr_addr=$tr;$name_addr=$name;$no_error_addr=$no_error;var $0=$name_addr;var $call=_strcpy(((_dictionary_name)&4294967295),$0);var $1=$tr_addr;var $dictionary_name=(($1+292)&4294967295);var $arraydecay=(($dictionary_name)&4294967295);var $2=$name_addr;var $call1=_strcpy($arraydecay,$2);var $arraydecay2=(($fname)&4294967295);var $3=$name_addr;var $call3=_sprintf($arraydecay2,((__str116)&4294967295),allocate([((_path_home)&4294967295),0,0,0,47,0,0,0,$3,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay4=(($fname)&4294967295);var $call5=__Z13GetFileLengthPKc($arraydecay4);$size=$call5;var $4=$tr_addr;var $data_dictlist=(($4+1052)&4294967295);var $5=HEAP32[(($data_dictlist)>>2)];var $cmp=((($5))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $6=$tr_addr;var $data_dictlist6=(($6+1052)&4294967295);var $7=HEAP32[(($data_dictlist6)>>2)];__Z4FreePv($7);var $8=$tr_addr;var $data_dictlist7=(($8+1052)&4294967295);HEAP32[(($data_dictlist7)>>2)]=0;;}
var $arraydecay8=(($fname)&4294967295);var $call9=_fopen($arraydecay8,((__str18429)&4294967295));$f=$call9;var $cmp10=((($call9))|0)==0;if($cmp10){__label__=4;;}else{__label__=3;;}
$if_then12$$lor_lhs_false$5:do{if(__label__==3){var $9=$size;var $cmp11=((($9))>>>0)<=0;if($cmp11){__label__=4;break $if_then12$$lor_lhs_false$5;}
var $13=$size;var $call19=__Z5Alloci($13);var $14=$tr_addr;var $data_dictlist20=(($14+1052)&4294967295);HEAP32[(($data_dictlist20)>>2)]=$call19;var $15=$tr_addr;var $data_dictlist21=(($15+1052)&4294967295);var $16=HEAP32[(($data_dictlist21)>>2)];var $17=$size;var $18=$f;var $call22=_fread($16,1,$17,$18);$size=$call22;var $19=$f;var $call23=_fclose($19);var $20=$tr_addr;var $data_dictlist24=(($20+1052)&4294967295);var $21=HEAP32[(($data_dictlist24)>>2)];var $22=$21;$pw=$22;var $23=$pw;var $arrayidx=(($23+4)&4294967295);var $24=HEAP32[(($arrayidx)>>2)];var $call25=__Z13Reverse4Bytesi($24);$length=$call25;var $25=$size;var $cmp26=((($25))>>>0)<=1032;if($cmp26){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $26=HEAP32[((__impure_ptr)>>2)];var $_stderr28=(($26+12)&4294967295);var $27=HEAP32[(($_stderr28)>>2)];var $arraydecay29=(($fname)&4294967295);var $call30=_fprintf($27,((__str3119)&4294967295),allocate([$arraydecay29,0,0,0],["i8*",0,0,0],ALLOC_STACK));$retval=2;__label__=19;break $if_then12$$lor_lhs_false$5;}
else if(__label__==9){var $28=$pw;var $arrayidx32=(($28)&4294967295);var $29=HEAP32[(($arrayidx32)>>2)];var $call33=__Z13Reverse4Bytesi($29);var $cmp34=((($call33))|0)!=1024;if($cmp34){__label__=11;;}else{__label__=10;;}
$if_then39$$lor_lhs_false35$11:do{if(__label__==10){var $30=$length;var $cmp36=((($30))|0)<=0;var $31=$length;var $cmp38=((($31))|0)>134217728;var $or_cond=($cmp36)|($cmp38);if($or_cond){__label__=11;break $if_then39$$lor_lhs_false35$11;}
var $37=$length;var $38=$tr_addr;var $data_dictlist46=(($38+1052)&4294967295);var $39=HEAP32[(($data_dictlist46)>>2)];var $arrayidx47=(($39+$37)&4294967295);var $40=$tr_addr;var $data_dictrules=(($40+1048)&4294967295);HEAP32[(($data_dictrules)>>2)]=$arrayidx47;var $41=$tr_addr;__ZL10InitGroupsP10Translator($41);var $42=$tr_addr;var $groups1=(($42+5256)&4294967295);var $arrayidx48=(($groups1)&4294967295);var $43=HEAP32[(($arrayidx48)>>2)];var $cmp49=((($43))|0)==0;if($cmp49){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $44=HEAP32[((__impure_ptr)>>2)];var $_stderr51=(($44+12)&4294967295);var $45=HEAP32[(($_stderr51)>>2)];var $46=$name_addr;var $call52=_fprintf($45,((__str5121)&4294967295),allocate([$46,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
var $47=$tr_addr;var $data_dictlist54=(($47+1052)&4294967295);var $48=HEAP32[(($data_dictlist54)>>2)];var $arrayidx55=(($48+8)&4294967295);$p=$arrayidx55;$hash=0;;$for_body$17:while(1){var $49=$p;var $50=$hash;var $51=$tr_addr;var $dict_hashtab=(($51+1056)&4294967295);var $arrayidx57=(($dict_hashtab+$50*4)&4294967295);HEAP32[(($arrayidx57)>>2)]=$49;var $52=$p;var $53=HEAP8[($52)];var $conv1=(tempInt=(($53)),(tempInt>=128?tempInt-256:tempInt));$length=$conv1;var $cmp582=((($conv1))|0)!=0;if($cmp582){__label__=16;;}else{__label__=17;;}
$while_body$$while_end$19:do{if(__label__==16){while(1){var $54=$length;var $55=$p;var $add_ptr=(($55+$54)&4294967295);$p=$add_ptr;var $56=$p;var $57=HEAP8[($56)];var $conv=(tempInt=(($57)),(tempInt>=128?tempInt-256:tempInt));$length=$conv;var $cmp58=((($conv))|0)!=0;if($cmp58){__label__=16;continue;}else{__label__=17;break $while_body$$while_end$19;}}}}while(0);var $58=$p;var $incdec_ptr=(($58+1)&4294967295);$p=$incdec_ptr;var $59=$hash;var $inc=((($59)+1)&4294967295);$hash=$inc;var $cmp56=((($inc))|0)<1024;if($cmp56){__label__=15;continue $for_body$17;}else{__label__=18;break $for_body$17;}}
$retval=0;__label__=19;break $if_then12$$lor_lhs_false$5;}}while(0);var $32=HEAP32[((__impure_ptr)>>2)];var $_stderr40=(($32+12)&4294967295);var $33=HEAP32[(($_stderr40)>>2)];var $arraydecay41=(($fname)&4294967295);var $34=$pw;var $arrayidx42=(($34)&4294967295);var $35=HEAP32[(($arrayidx42)>>2)];var $call43=__Z13Reverse4Bytesi($35);var $36=$length;var $call44=_fprintf($33,((__str4120)&4294967295),allocate([$arraydecay41,0,0,0,$call43,0,0,0,$36,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i32",0,0,0],ALLOC_STACK));$retval=2;__label__=19;break $if_then12$$lor_lhs_false$5;}}}while(0);if(__label__==4){var $10=$no_error_addr;var $cmp13=((($10))|0)==0;if($cmp13){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $11=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($11+12)&4294967295);var $12=HEAP32[(($_stderr)>>2)];var $arraydecay15=(($fname)&4294967295);var $call16=_fprintf($12,((__str2118)&4294967295),allocate([$arraydecay15,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
$retval=1;;}
var $60=$retval;STACKTOP=__stackBase__;return $60;return null;}
function __ZL10InitGroupsP10Translator($tr){;var __label__;var __lastLabel__=null;var $tr_addr;var $ix;var $p;var $p_name;var $pw;var $c;var $c2;var $len;$tr_addr=$tr;var $0=$tr_addr;var $n_groups2=(($0+7752)&4294967295);HEAP32[(($n_groups2)>>2)]=0;$ix=0;;$for_body$2:while(1){var $1=$ix;var $2=$tr_addr;var $groups1=(($2+5256)&4294967295);var $arrayidx=(($groups1+$1*4)&4294967295);HEAP32[(($arrayidx)>>2)]=0;var $3=$ix;var $4=$tr_addr;var $groups2_count=(($4+7756)&4294967295);var $arrayidx1=(($groups2_count+$3)&4294967295);HEAP8[($arrayidx1)]=0;var $5=$ix;var $6=$tr_addr;var $groups2_start=(($6+8012)&4294967295);var $arrayidx2=(($groups2_start+$5)&4294967295);HEAP8[($arrayidx2)]=-1;var $7=$ix;var $inc=((($7)+1)&4294967295);$ix=$inc;var $cmp=((($inc))|0)<256;if($cmp){__label__=1;continue $for_body$2;}else{__label__=2;break $for_body$2;}}
var $8=$tr_addr;var $letterGroups=(($8+5152)&4294967295);var $arraydecay=(($letterGroups)&4294967295);var $9=$arraydecay;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$9;$stop$=$dest$+104;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $10=$tr_addr;var $groups3=(($10+6280)&4294967295);var $arraydecay3=(($groups3)&4294967295);var $11=$arraydecay3;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$11;$stop$=$dest$+512;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $12=$tr_addr;var $data_dictrules=(($12+1048)&4294967295);var $13=HEAP32[(($data_dictrules)>>2)];$p=$13;;$while_cond$5:while(1){var $14=$p;var $15=HEAP8[($14)];var $conv=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));var $cmp4=((($conv))|0)!=0;if(!($cmp4)){__label__=25;break $while_cond$5;}
var $16=$p;var $17=HEAP8[($16)];var $conv5=(tempInt=(($17)),(tempInt>=128?tempInt-256:tempInt));var $cmp6=((($conv5))|0)!=6;if($cmp6){__label__=5;break $while_cond$5;}
var $23=$p;var $incdec_ptr=(($23+1)&4294967295);$p=$incdec_ptr;var $24=$p;var $arrayidx8=(($24)&4294967295);var $25=HEAP8[($arrayidx8)];var $conv9=(tempInt=(($25)),(tempInt>=128?tempInt-256:tempInt));var $cmp10=((($conv9))|0)==20;var $26=$p;if($cmp10){__label__=7;;}else{__label__=10;;}
if(__label__==7){var $27=($26);var $add=((($27)+4)&4294967295);var $and=($add)&-4;var $28=($and);$pw=$28;var $29=$pw;var $30=$tr_addr;var $langopts=(($30)&4294967295);var $replace_chars=(($langopts+264)&4294967295);HEAP32[(($replace_chars)>>2)]=$29;var $31=$pw;var $arrayidx134=(($31)&4294967295);var $32=HEAP32[(($arrayidx134)>>2)];var $cmp145=((($32))|0)!=0;var $33=$pw;if($cmp145){__lastLabel__=7;__label__=8;;}else{__lastLabel__=7;__label__=9;;}
$while_body15$$while_end$11:do{if(__label__==8){while(1){var $34=__lastLabel__==8?$37:($33);var $add_ptr=(($34+8)&4294967295);$pw=$add_ptr;var $35=$pw;var $arrayidx13=(($35)&4294967295);var $36=HEAP32[(($arrayidx13)>>2)];var $cmp14=((($36))|0)!=0;var $37=$pw;if($cmp14){__lastLabel__=8;__label__=8;continue;}else{__lastLabel__=8;__label__=9;break $while_body15$$while_end$11;}}}}while(0);var $_lcssa3=__lastLabel__==7?$33:($37);var $add_ptr16=(($_lcssa3+4)&4294967295);var $38=$add_ptr16;$p=$38;__label__=3;continue $while_cond$5;}
else if(__label__==10){var $arrayidx18=(($26)&4294967295);var $39=HEAP8[($arrayidx18)];var $conv19=(tempInt=(($39)),(tempInt>=128?tempInt-256:tempInt));var $cmp20=((($conv19))|0)==18;var $40=$p;if($cmp20){__label__=11;;}else{__label__=13;;}
$if_then21$$if_else$16:do{if(__label__==11){var $arrayidx22=(($40+1)&4294967295);var $41=HEAP8[($arrayidx22)];var $conv23=(tempInt=(($41)),(tempInt>=128?tempInt-256:tempInt));var $sub=((($conv23)-65)&4294967295);$ix=$sub;var $42=$p;var $add_ptr24=(($42+2)&4294967295);$p=$add_ptr24;var $43=$ix;var $cmp25=((($43))|0)>=0;var $44=$ix;var $cmp26=((($44))|0)<26;var $or_cond=($cmp25)&($cmp26);if(!($or_cond)){__label__=22;break $if_then21$$if_else$16;}
var $45=$p;var $46=$ix;var $47=$tr_addr;var $letterGroups28=(($47+5152)&4294967295);var $arrayidx29=(($letterGroups28+$46*4)&4294967295);HEAP32[(($arrayidx29)>>2)]=$45;;}
else if(__label__==13){var $call31=_strlen($40);$len=$call31;var $48=$p;$p_name=$48;var $49=$p_name;var $arrayidx32=(($49)&4294967295);var $50=HEAP8[($arrayidx32)];$c=$50;var $51=$p_name;var $arrayidx33=(($51+1)&4294967295);var $52=HEAP8[($arrayidx33)];$c2=$52;var $53=$len;var $add34=((($53)+1)&4294967295);var $54=$p;var $add_ptr35=(($54+$add34)&4294967295);$p=$add_ptr35;var $55=$len;var $cmp36=((($55))|0)==1;if($cmp36){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $56=$p;var $57=$c;var $idxprom=((($57))&255);var $58=$tr_addr;var $groups138=(($58+5256)&4294967295);var $arrayidx39=(($groups138+$idxprom*4)&4294967295);HEAP32[(($arrayidx39)>>2)]=$56;;}
else if(__label__==15){var $59=$len;var $cmp41=((($59))|0)==0;if($cmp41){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $60=$p;var $61=$tr_addr;var $groups143=(($61+5256)&4294967295);var $arrayidx44=(($groups143)&4294967295);HEAP32[(($arrayidx44)>>2)]=$60;;}
else if(__label__==17){var $62=$c;var $conv46=((($62))&255);var $cmp47=((($conv46))|0)==1;if($cmp47){__label__=18;;}else{__label__=19;;}
if(__label__==18){var $63=$p;var $64=$c2;var $conv49=((($64))&255);var $sub50=((($conv49)-1)&4294967295);var $65=$tr_addr;var $groups351=(($65+6280)&4294967295);var $arrayidx52=(($groups351+$sub50*4)&4294967295);HEAP32[(($arrayidx52)>>2)]=$63;;}
else if(__label__==19){var $66=$c;var $idxprom54=((($66))&255);var $67=$tr_addr;var $groups2_start55=(($67+8012)&4294967295);var $arrayidx56=(($groups2_start55+$idxprom54)&4294967295);var $68=HEAPU8[($arrayidx56)];var $conv57=((($68))&255);var $cmp58=((($conv57))|0)==255;if($cmp58){__label__=20;;}else{__label__=21;;}
if(__label__==20){var $69=$tr_addr;var $n_groups260=(($69+7752)&4294967295);var $70=HEAP32[(($n_groups260)>>2)];var $conv61=((($70))&255);var $71=$c;var $idxprom62=((($71))&255);var $72=$tr_addr;var $groups2_start63=(($72+8012)&4294967295);var $arrayidx64=(($groups2_start63+$idxprom62)&4294967295);HEAP8[($arrayidx64)]=$conv61;;}
var $73=$c;var $idxprom66=((($73))&255);var $74=$tr_addr;var $groups2_count67=(($74+7756)&4294967295);var $arrayidx68=(($groups2_count67+$idxprom66)&4294967295);var $75=HEAP8[($arrayidx68)];var $inc69=((($75)+1)&255);HEAP8[($arrayidx68)]=$inc69;var $76=$p;var $77=$tr_addr;var $n_groups270=(($77+7752)&4294967295);var $78=HEAP32[(($n_groups270)>>2)];var $79=$tr_addr;var $groups2=(($79+6792)&4294967295);var $arrayidx71=(($groups2+$78*4)&4294967295);HEAP32[(($arrayidx71)>>2)]=$76;var $80=$c;var $conv72=((($80))&255);var $81=$c2;var $conv73=((($81))&255);var $shl=((($conv73)*256)&4294967295);var $add74=((($shl)+($conv72))&4294967295);var $82=$tr_addr;var $n_groups275=(($82+7752)&4294967295);var $83=HEAPU32[(($n_groups275)>>2)];var $inc76=((($83)+1)&4294967295);HEAP32[(($n_groups275)>>2)]=$inc76;var $84=$tr_addr;var $groups2_name=(($84+7272)&4294967295);var $arrayidx77=(($groups2_name+$83*4)&4294967295);HEAP32[(($arrayidx77)>>2)]=$add74;;}}}}}while(0);var $85=$p;var $86=HEAP8[($85)];var $conv831=(tempInt=(($86)),(tempInt>=128?tempInt-256:tempInt));var $cmp842=((($conv831))|0)!=7;var $87=$p;if($cmp842){__lastLabel__=22;__label__=23;;}else{__lastLabel__=22;__label__=24;;}
$while_body85$$while_end89$33:do{if(__label__==23){while(1){var $88=__lastLabel__==23?$92:($87);var $call86=_strlen($88);var $add87=((($call86)+1)&4294967295);var $89=$p;var $add_ptr88=(($89+$add87)&4294967295);$p=$add_ptr88;var $90=$p;var $91=HEAP8[($90)];var $conv83=(tempInt=(($91)),(tempInt>=128?tempInt-256:tempInt));var $cmp84=((($conv83))|0)!=7;var $92=$p;if($cmp84){__lastLabel__=23;__label__=23;continue;}else{__lastLabel__=23;__label__=24;break $while_body85$$while_end89$33;}}}}while(0);var $_lcssa=__lastLabel__==22?$87:($92);var $incdec_ptr90=(($_lcssa+1)&4294967295);$p=$incdec_ptr90;__label__=3;continue $while_cond$5;}}
if(__label__==5){var $18=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($18+12)&4294967295);var $19=HEAP32[(($_stderr)>>2)];var $20=$p;var $21=$tr_addr;var $data_dictrules7=(($21+1048)&4294967295);var $22=HEAP32[(($data_dictrules7)>>2)];var $sub_ptr_lhs_cast=($20);var $sub_ptr_rhs_cast=($22);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $call=_fprintf($19,((__str34150)&4294967295),allocate([((_dictionary_name)&4294967295),0,0,0,$sub_ptr_sub,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));;};return;return;}
function __Z14HashDictionaryPKc($string){;var __label__;var __lastLabel__=null;var $string_addr;var $c;var $chars;var $hash;$string_addr=$string;$chars=0;$hash=0;var $0=$string_addr;var $incdec_ptr1=(($0+1)&4294967295);$string_addr=$incdec_ptr1;var $1=HEAP8[($0)];var $conv2=(tempInt=(($1)),(tempInt>=128?tempInt-256:tempInt));var $and4=($conv2)&255;$c=$and4;var $cmp5=((($and4))|0)!=0;var $2=$hash;if($cmp5){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=2;;}
$while_body$$while_end$2:do{if(__label__==1){while(1){var $3=__lastLabel__==1?$10:($2);var $mul=((($3)*8)&4294967295);var $4=$c;var $add=((($4)+($mul))&4294967295);$hash=$add;var $5=$hash;var $and1=($5)&1023;var $6=$hash;var $shr=($6)>>8;var $xor=($shr)^($and1);$hash=$xor;var $7=$chars;var $inc=((($7)+1)&4294967295);$chars=$inc;var $8=$string_addr;var $incdec_ptr=(($8+1)&4294967295);$string_addr=$incdec_ptr;var $9=HEAP8[($8)];var $conv=(tempInt=(($9)),(tempInt>=128?tempInt-256:tempInt));var $and=($conv)&255;$c=$and;var $cmp=((($and))|0)!=0;var $10=$hash;if($cmp){__lastLabel__=1;__label__=1;continue;}else{__lastLabel__=1;__label__=2;break $while_body$$while_end$2;}}}}while(0);var $_lcssa=__lastLabel__==0?$2:($10);var $11=$chars;var $add2=((($11)+($_lcssa))&4294967295);var $and3=($add2)&1023;;return $and3;return null;}
function __Z14EncodePhonemesPcS_Ph($p,$outptr,$bad_phoneme){;var __label__;var __lastLabel__=null;var $retval;var $p_addr;var $outptr_addr;var $bad_phoneme_addr;var $ix;var $c;var $count;var $max;var $max_ph;var $consumed;var $mnemonic_word;var $p_lang;$p_addr=$p;$outptr_addr=$outptr;$bad_phoneme_addr=$bad_phoneme;var $0=$bad_phoneme_addr;var $arrayidx=(($0)&4294967295);HEAP8[($arrayidx)]=0;var $1=$p_addr;var $2=HEAP8[($1)];var $conv4=(tempInt=(($2)),(tempInt>=128?tempInt-256:tempInt));var $call5=_isspace($conv4);var $tobool6=((($call5))|0)!=0;if($tobool6){__label__=1;;}else{__label__=2;;}
$while_body$$while_cond1$2:do{if(__label__==1){while(1){var $3=$p_addr;var $incdec_ptr=(($3+1)&4294967295);$p_addr=$incdec_ptr;var $4=$p_addr;var $5=HEAP8[($4)];var $conv=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));var $call=_isspace($conv);var $tobool=((($call))|0)!=0;if($tobool){__label__=1;continue;}else{__label__=2;break $while_body$$while_cond1$2;}}}}while(0);$while_cond1$5:while(1){var $6=$p_addr;var $7=HEAPU8[($6)];$c=$7;var $conv2=((($7))&255);var $cmp=((($conv2))|0)!=0;if(!($cmp)){__label__=34;break $while_cond1$5;}
var $8=$c;var $conv3=((($8))&255);var $call4=_isspace($conv3);var $tobool5=((($call4))|0)!=0;var $lnot=($tobool5)^1;if(!($lnot)){__label__=34;break $while_cond1$5;}
$consumed=0;var $9=$c;var $conv7=((($9))&255);var $cond=((($conv7))|0)==124;if($cond){__label__=5;;}else{__label__=7;;}
$sw_bb$$sw_default$9:do{if(__label__==5){var $10=$p_addr;var $arrayidx8=(($10+1)&4294967295);var $11=HEAPU8[($arrayidx8)];$c=$11;var $conv9=((($11))&255);var $cmp10=((($conv9))|0)==124;if($cmp10){__label__=7;break $sw_bb$$sw_default$9;}
var $12=$p_addr;var $incdec_ptr11=(($12+1)&4294967295);$p_addr=$incdec_ptr11;__label__=2;continue $while_cond1$5;}}while(0);$max=-1;$max_ph=0;$ix=1;var $13=$ix;var $14=HEAP32[((_n_phoneme_tab)>>2)];var $cmp121=((($13))|0)<((($14))|0);if(!($cmp121)){__label__=22;break $while_cond1$5;}
$for_body$13:while(1){var $15=$ix;var $arrayidx13=((_phoneme_tab+$15*4)&4294967295);var $16=HEAP32[(($arrayidx13)>>2)];var $cmp14=((($16))|0)==0;if($cmp14){__label__=20;;}else{__label__=9;;}
$for_inc$$if_end16$15:do{if(__label__==9){var $17=$ix;var $arrayidx17=((_phoneme_tab+$17*4)&4294967295);var $18=HEAP32[(($arrayidx17)>>2)];var $type=(($18+11)&4294967295);var $19=HEAPU8[($type)];var $conv18=((($19))&255);var $cmp19=((($conv18))|0)==15;if($cmp19){__label__=20;break $for_inc$$if_end16$15;}
$count=0;var $20=$ix;var $arrayidx22=((_phoneme_tab+$20*4)&4294967295);var $21=HEAP32[(($arrayidx22)>>2)];var $mnemonic=(($21)&4294967295);var $22=HEAP32[(($mnemonic)>>2)];$mnemonic_word=$22;;while(1){var $23=$count;var $24=$p_addr;var $arrayidx24=(($24+$23)&4294967295);var $25=HEAPU8[($arrayidx24)];$c=$25;var $conv25=((($25))&255);var $cmp26=((($conv25))|0)>32;if(!($cmp26)){__label__=13;break;}
var $26=$count;var $cmp27=((($26))|0)<4;if(!($cmp27)){__label__=13;break;}
var $28=$c;var $conv29=((($28))&255);var $29=$mnemonic_word;var $30=$count;var $mul=((($30)*8)&4294967295);var $shr=($29)>>>((($mul))>>>0);var $and=($shr)&255;var $cmp30=((($conv29))|0)==((($and))|0);var $31=$count;if($cmp30){__lastLabel__=14;;}else{__lastLabel__=14;__label__=16;break;}
var $inc=((($31)+1)&4294967295);$count=$inc;__label__=11;continue;}
if(__label__==13){var $27=$count;__lastLabel__=13;;}
var $32=__lastLabel__==13?$27:($31);var $33=$max;var $cmp34=((($32))|0)>((($33))|0);if(!($cmp34)){__label__=20;break $for_inc$$if_end16$15;}
var $34=$count;var $cmp36=((($34))|0)==4;if($cmp36){__label__=19;;}else{__label__=18;;}
if(__label__==18){var $35=$mnemonic_word;var $36=$count;var $mul37=((($36)*8)&4294967295);var $shr38=($35)>>>((($mul37))>>>0);var $and39=($shr38)&255;var $cmp40=((($and39))|0)==0;if(!($cmp40)){__label__=20;break $for_inc$$if_end16$15;}}
var $37=$count;$max=$37;var $38=$ix;var $arrayidx42=((_phoneme_tab+$38*4)&4294967295);var $39=HEAP32[(($arrayidx42)>>2)];var $code=(($39+10)&4294967295);var $40=HEAPU8[($code)];var $conv43=((($40))&255);$max_ph=$conv43;;}}while(0);var $41=$ix;var $inc45=((($41)+1)&4294967295);$ix=$inc45;var $42=$ix;var $43=HEAP32[((_n_phoneme_tab)>>2)];var $cmp12=((($42))|0)<((($43))|0);if($cmp12){__label__=8;continue $for_body$13;}else{__label__=21;break $for_body$13;}}
var $_pr=$max_ph;var $cmp46=((($_pr))|0)==0;if($cmp46){__label__=22;break $while_cond1$5;}
var $50=$max;var $cmp52=((($50))|0)<=0;if($cmp52){__label__=24;;}else{__label__=25;;}
if(__label__==24){$max=1;;}
var $51=$consumed;var $52=$max;var $add=((($52)+($51))&4294967295);var $53=$p_addr;var $add_ptr55=(($53+$add)&4294967295);$p_addr=$add_ptr55;var $54=$max_ph;var $conv56=((($54))&255);var $55=$outptr_addr;var $incdec_ptr57=(($55+1)&4294967295);$outptr_addr=$incdec_ptr57;HEAP8[($55)]=$conv56;var $56=$max_ph;var $cmp58=((($56))|0)==21;if(!($cmp58)){__label__=2;continue $while_cond1$5;}
var $57=$outptr_addr;$p_lang=$57;;while(1){var $58=$p_addr;var $59=HEAPU8[($58)];$c=$59;var $conv61=((($59))&255);var $call62=_isspace($conv61);var $tobool63=((($call62))|0)!=0;if($tobool63){__label__=30;break;}
var $60=$c;var $conv65=((($60))&255);var $cmp66=((($conv65))|0)!=0;if(!($cmp66)){__label__=30;break;}
var $61=$p_addr;var $incdec_ptr69=(($61+1)&4294967295);$p_addr=$incdec_ptr69;var $62=$c;var $conv70=((($62))&255);var $call71=_tolower($conv70);var $conv72=((($call71))&255);var $63=$outptr_addr;var $incdec_ptr73=(($63+1)&4294967295);$outptr_addr=$incdec_ptr73;HEAP8[($63)]=$conv72;__label__=27;continue;}
var $64=$outptr_addr;HEAP8[($64)]=0;var $65=$c;var $conv75=((($65))&255);var $cmp76=((($conv75))|0)==0;if($cmp76){__label__=31;;}else{__label__=33;;}
if(__label__==31){var $66=$p_lang;var $call78=_strcmp($66,((__str52704)&4294967295));var $cmp79=((($call78))|0)==0;if($cmp79){__label__=32;break $while_cond1$5;}else{__label__=2;continue $while_cond1$5;}}
else if(__label__==33){var $69=$outptr_addr;var $incdec_ptr83=(($69+1)&4294967295);$outptr_addr=$incdec_ptr83;HEAP8[($69)]=124;__label__=2;continue $while_cond1$5;}}
if(__label__==34){var $70=$outptr_addr;HEAP8[($70)]=0;var $71=$p_addr;$retval=$71;;}
else if(__label__==22){var $44=$p_addr;var $45=HEAP8[($44)];var $46=$bad_phoneme_addr;var $arrayidx48=(($46)&4294967295);HEAP8[($arrayidx48)]=$45;var $47=$bad_phoneme_addr;var $arrayidx49=(($47+1)&4294967295);HEAP8[($arrayidx49)]=0;var $48=$outptr_addr;var $incdec_ptr50=(($48+1)&4294967295);$outptr_addr=$incdec_ptr50;HEAP8[($48)]=0;var $49=$p_addr;var $add_ptr=(($49+1)&4294967295);$retval=$add_ptr;;}
else if(__label__==32){var $67=$p_lang;HEAP8[($67)]=0;var $68=$p_addr;$retval=$68;;}
var $72=$retval;;return $72;return null;}
function __Z14DecodePhonemesPKcPc($inptr,$outptr){;var __label__;var $inptr_addr;var $outptr_addr;var $phcode;var $c;var $mnem;var $ph;$inptr_addr=$inptr;$outptr_addr=$outptr;var $0=$inptr_addr;var $incdec_ptr8=(($0+1)&4294967295);$inptr_addr=$incdec_ptr8;var $1=HEAPU8[($0)];$phcode=$1;var $conv9=((($1))&255);var $cmp10=((($conv9))|0)>0;if($cmp10){__label__=1;;}else{__label__=14;;}
$while_body$$while_end40$2:do{if(__label__==1){$while_body$3:while(1){var $2=$phcode;var $conv1=((($2))&255);var $cmp2=((($conv1))|0)==255;if($cmp2){__label__=2;;}else{__label__=3;;}
$while_cond_backedge$$if_end$5:do{if(__label__==3){var $5=$phcode;var $idxprom=((($5))&255);var $arrayidx=((_phoneme_tab+$idxprom*4)&4294967295);var $6=HEAPU32[(($arrayidx)>>2)];$ph=$6;var $cmp3=((($6))|0)==0;if($cmp3){__label__=2;break $while_cond_backedge$$if_end$5;}
var $7=$ph;var $type=(($7+11)&4294967295);var $8=HEAPU8[($type)];var $conv6=((($8))&255);var $cmp7=((($conv6))|0)==1;if($cmp7){__label__=5;;}else{__label__=9;;}
$land_lhs_true$$if_else$8:do{if(__label__==5){var $9=$ph;var $std_length=(($9+14)&4294967295);var $10=HEAPU8[($std_length)];var $conv8=((($10))&255);var $cmp9=((($conv8))|0)<=4;if(!($cmp9)){__label__=9;break $land_lhs_true$$if_else$8;}
var $11=$ph;var $program=(($11+8)&4294967295);var $12=HEAPU16[(($program)>>1)];var $conv11=((($12))&65535);var $cmp12=((($conv11))|0)==0;if(!($cmp12)){__label__=9;break $land_lhs_true$$if_else$8;}
var $13=$ph;var $std_length14=(($13+14)&4294967295);var $14=HEAPU8[($std_length14)];var $conv15=((($14))&255);var $cmp16=((($conv15))|0)>1;if(!($cmp16)){__label__=2;break $while_cond_backedge$$if_end$5;}
var $15=$ph;var $std_length18=(($15+14)&4294967295);var $16=HEAPU8[($std_length18)];var $idxprom19=((($16))&255);var $arrayidx20=((((__str7123)&4294967295)+$idxprom19)&4294967295);var $17=HEAP8[($arrayidx20)];var $18=$outptr_addr;var $incdec_ptr21=(($18+1)&4294967295);$outptr_addr=$incdec_ptr21;HEAP8[($18)]=$17;__label__=2;break $while_cond_backedge$$if_end$5;}}while(0);var $19=$ph;var $mnemonic=(($19)&4294967295);var $20=HEAP32[(($mnemonic)>>2)];$mnem=$20;var $21=$mnem;var $and4=($21)&255;var $conv245=((($and4))&255);$c=$conv245;var $conv256=((($conv245))&255);var $cmp267=((($conv256))|0)!=0;if($cmp267){__label__=10;;}else{__label__=11;;}
$while_body27$$while_end$14:do{if(__label__==10){while(1){var $22=$c;var $23=$outptr_addr;var $incdec_ptr28=(($23+1)&4294967295);$outptr_addr=$incdec_ptr28;HEAP8[($23)]=$22;var $24=$mnem;var $shr=($24)>>>8;$mnem=$shr;var $25=$mnem;var $and=($25)&255;var $conv24=((($and))&255);$c=$conv24;var $conv25=((($conv24))&255);var $cmp26=((($conv25))|0)!=0;if($cmp26){__label__=10;continue;}else{__label__=11;break $while_body27$$while_end$14;}}}}while(0);var $26=$phcode;var $conv29=((($26))&255);var $cmp30=((($conv29))|0)==21;if(!($cmp30)){__label__=2;break $while_cond_backedge$$if_end$5;}
var $27=$inptr_addr;var $28=HEAP8[($27)];var $conv331=(tempInt=(($28)),(tempInt>=128?tempInt-256:tempInt));var $call2=_isalpha($conv331);var $tobool3=((($call2))|0)!=0;if(!($tobool3)){__label__=2;break $while_cond_backedge$$if_end$5;}
while(1){var $29=$inptr_addr;var $incdec_ptr35=(($29+1)&4294967295);$inptr_addr=$incdec_ptr35;var $30=HEAP8[($29)];var $31=$outptr_addr;var $incdec_ptr36=(($31+1)&4294967295);$outptr_addr=$incdec_ptr36;HEAP8[($31)]=$30;var $32=$inptr_addr;var $33=HEAP8[($32)];var $conv33=(tempInt=(($33)),(tempInt>=128?tempInt-256:tempInt));var $call=_isalpha($conv33);var $tobool=((($call))|0)!=0;if($tobool){__label__=13;continue;}else{__label__=2;break $while_cond_backedge$$if_end$5;}}}}while(0);var $3=$inptr_addr;var $incdec_ptr=(($3+1)&4294967295);$inptr_addr=$incdec_ptr;var $4=HEAPU8[($3)];$phcode=$4;var $conv=((($4))&255);var $cmp=((($conv))|0)>0;if($cmp){__label__=1;continue $while_body$3;}else{__label__=14;break $while_body$$while_end40$2;}}}}while(0);var $34=$outptr_addr;HEAP8[($34)]=0;;return;return;}
function __Z26GetTranslatedPhonemeStringPci($phon_out,$n_phon_out){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $phon_out_addr;var $n_phon_out_addr;var $ix;var $phon_out_ix=__stackBase__;var $stress;var $c;var $p;var $plist;$phon_out_addr=$phon_out;$n_phon_out_addr=$n_phon_out;HEAP32[(($phon_out_ix)>>2)]=0;var $0=$phon_out_addr;var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=28;;}
if(__label__==1){$ix=1;;$for_cond$4:while(1){var $1=$ix;var $2=HEAP32[((_n_phoneme_list)>>2)];var $sub=((($2)-2)&4294967295);var $cmp1=((($1))|0)<((($sub))|0);if(!($cmp1)){__label__=25;break $for_cond$4;}
var $3=HEAP32[(($phon_out_ix)>>2)];var $4=$n_phon_out_addr;var $sub2=((($4)-6)&4294967295);var $cmp3=((($3))|0)<((($sub2))|0);if(!($cmp3)){__label__=25;break $for_cond$4;}
var $5=$ix;var $arrayidx=((_phoneme_list+$5*24)&4294967295);$plist=$arrayidx;var $6=$plist;var $newword=(($6+19)&4294967295);var $7=HEAP8[($newword)];var $tobool=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $8=HEAP32[(($phon_out_ix)>>2)];var $inc=((($8)+1)&4294967295);HEAP32[(($phon_out_ix)>>2)]=$inc;var $9=$phon_out_addr;var $arrayidx5=(($9+$8)&4294967295);HEAP8[($arrayidx5)]=32;;}
var $10=$plist;var $synthflags=(($10+4)&4294967295);var $11=HEAPU16[(($synthflags)>>1)];var $conv=((($11))&65535);var $and=($conv)&4;var $tobool6=((($and))|0)!=0;if($tobool6){__label__=7;;}else{__label__=15;;}
$if_then7$$if_end27$11:do{if(__label__==7){var $12=$plist;var $stresslevel=(($12+1)&4294967295);var $13=HEAPU8[($stresslevel)];var $conv8=((($13))&255);$stress=$conv8;var $cmp9=((($conv8))|0)>1;if(!($cmp9)){__label__=15;break $if_then7$$if_end27$11;}
$c=0;var $14=$stress;var $cmp11=((($14))|0)>5;if($cmp11){__label__=9;;}else{__label__=10;;}
if(__label__==9){$stress=5;;}
var $15=HEAP32[((_option_phonemes)>>2)];var $cmp14=((($15))|0)==3;if($cmp14){__label__=11;;}else{__label__=13;;}
$if_then15$$if_end21$17:do{if(__label__==11){$c=716;var $16=$stress;var $cmp16=((($16))|0)>3;if(!($cmp16)){__label__=14;break $if_then15$$if_end21$17;}
$c=712;;}
else if(__label__==13){var $17=$stress;var $arrayidx19=((((__str8124)&4294967295)+$17)&4294967295);var $18=HEAP8[($arrayidx19)];var $conv20=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));$c=$conv20;var $cmp22=((($conv20))|0)!=0;if(!($cmp22)){__label__=15;break $if_then7$$if_end27$11;}}}while(0);var $19=$c;var $20=HEAP32[(($phon_out_ix)>>2)];var $21=$phon_out_addr;var $arrayidx24=(($21+$20)&4294967295);var $call=__Z8utf8_outjPc($19,$arrayidx24);var $22=HEAP32[(($phon_out_ix)>>2)];var $add=((($22)+($call))&4294967295);HEAP32[(($phon_out_ix)>>2)]=$add;;}}while(0);var $23=$plist;var $ph=(($23+8)&4294967295);var $24=HEAP32[(($ph)>>2)];var $code=(($24+10)&4294967295);var $25=HEAPU8[($code)];var $conv28=((($25))&255);var $cmp29=((($conv28))|0)==21;if($cmp29){__label__=16;;}else{__label__=17;;}
$if_then30$$if_else37$23:do{if(__label__==16){var $26=$plist;var $tone_ph=(($26+3)&4294967295);var $27=HEAPU8[($tone_ph)];var $idxprom=((($27))&255);var $arrayidx31=((_phoneme_tab_list+$idxprom*48)&4294967295);var $name=(($arrayidx31)&4294967295);var $arraydecay=(($name)&4294967295);$p=$arraydecay;var $28=HEAP32[(($phon_out_ix)>>2)];var $29=$phon_out_addr;var $arrayidx32=(($29+$28)&4294967295);var $30=$p;var $call33=_sprintf($arrayidx32,((__str9125)&4294967295),allocate([$30,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $31=$p;var $call34=_strlen($31);var $32=HEAP32[(($phon_out_ix)>>2)];var $add35=((($call34)+2)&4294967295);var $add36=((($add35)+($32))&4294967295);HEAP32[(($phon_out_ix)>>2)]=$add36;;}
else if(__label__==17){var $33=$phon_out_addr;var $34=$plist;var $ph38=(($34+8)&4294967295);var $35=HEAP32[(($ph38)>>2)];var $36=$plist;__ZL15WritePhMnemonicPcPiP11PHONEME_TABP12PHONEME_LIST($33,$phon_out_ix,$35,$36);var $37=$plist;var $synthflags39=(($37+4)&4294967295);var $38=HEAPU16[(($synthflags39)>>1)];var $conv40=((($38))&65535);var $and41=($conv40)&8;var $tobool42=((($and41))|0)!=0;if($tobool42){__label__=18;;}else{__label__=19;;}
if(__label__==18){var $39=$phon_out_addr;var $40=HEAP32[((((_phoneme_tab+48)&4294967295))>>2)];__ZL15WritePhMnemonicPcPiP11PHONEME_TABP12PHONEME_LIST($39,$phon_out_ix,$40,0);;}
var $41=$plist;var $synthflags45=(($41+4)&4294967295);var $42=HEAPU16[(($synthflags45)>>1)];var $conv46=((($42))&65535);var $and47=($conv46)&4;var $tobool48=((($and47))|0)!=0;if($tobool48){__label__=20;;}else{__label__=22;;}
$land_lhs_true$$if_end52$29:do{if(__label__==20){var $43=$plist;var $type=(($43+15)&4294967295);var $44=HEAPU8[($type)];var $conv49=((($44))&255);var $cmp50=((($conv49))|0)!=2;if(!($cmp50)){__label__=22;break $land_lhs_true$$if_end52$29;}
var $45=$phon_out_addr;var $46=HEAP32[((((_phoneme_tab+80)&4294967295))>>2)];__ZL15WritePhMnemonicPcPiP11PHONEME_TABP12PHONEME_LIST($45,$phon_out_ix,$46,0);;}}while(0);var $47=$plist;var $tone_ph53=(($47+3)&4294967295);var $48=HEAPU8[($tone_ph53)];var $conv54=((($48))&255);var $cmp55=((($conv54))|0)>0;if(!($cmp55)){__label__=24;break $if_then30$$if_else37$23;}
var $49=$phon_out_addr;var $50=$plist;var $tone_ph57=(($50+3)&4294967295);var $51=HEAPU8[($tone_ph57)];var $idxprom58=((($51))&255);var $arrayidx59=((_phoneme_tab+$idxprom58*4)&4294967295);var $52=HEAP32[(($arrayidx59)>>2)];__ZL15WritePhMnemonicPcPiP11PHONEME_TABP12PHONEME_LIST($49,$phon_out_ix,$52,0);;}}while(0);var $53=$ix;var $inc62=((($53)+1)&4294967295);$ix=$inc62;__label__=2;continue $for_cond$4;}
var $54=HEAP32[(($phon_out_ix)>>2)];var $55=$n_phon_out_addr;var $cmp63=((($54))|0)>=((($55))|0);if($cmp63){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $56=$n_phon_out_addr;var $sub65=((($56)-1)&4294967295);HEAP32[(($phon_out_ix)>>2)]=$sub65;;}
var $57=HEAP32[(($phon_out_ix)>>2)];var $58=$phon_out_addr;var $arrayidx67=(($58+$57)&4294967295);HEAP8[($arrayidx67)]=0;;}
STACKTOP=__stackBase__;return;return;}
function __ZL15WritePhMnemonicPcPiP11PHONEME_TABP12PHONEME_LIST($phon_out,$ix,$ph,$plist){var __stackBase__=STACKTOP;STACKTOP+=152;_memset(__stackBase__,0,152);var __label__;var __lastLabel__=null;var $phon_out_addr;var $ix_addr;var $ph_addr;var $plist_addr;var $c;var $mnem;var $len;var $first;var $ipa_control;var $phdata=__stackBase__;$phon_out_addr=$phon_out;$ix_addr=$ix;$ph_addr=$ph;$plist_addr=$plist;$ipa_control=0;var $0=HEAP32[((_option_phonemes)>>2)];var $cmp=((($0))|0)==3;if($cmp){__label__=1;;}else{__label__=8;;}
$if_then$$if_end20$2:do{if(__label__==1){var $ipa_string=(($phdata+132)&4294967295);var $arrayidx=(($ipa_string)&4294967295);HEAP8[($arrayidx)]=0;var $1=$plist_addr;var $cmp1=((($1))|0)==0;if($cmp1){__label__=2;;}else{__label__=3;;}
if(__label__==2){var $2=$ph_addr;var $code=(($2+10)&4294967295);var $3=HEAPU8[($code)];var $conv=((($3))&255);__Z17InterpretPhoneme2iP12PHONEME_DATA($conv,$phdata);;}
else if(__label__==3){var $4=$plist_addr;__Z16InterpretPhonemeP10TranslatoriP12PHONEME_LISTP12PHONEME_DATA(0,0,$4,$phdata);;}
var $ipa_string3=(($phdata+132)&4294967295);var $arraydecay=(($ipa_string3)&4294967295);var $call=_strlen($arraydecay);$len=$call;var $cmp4=((($call))|0)>0;if(!($cmp4)){__label__=8;break $if_then$$if_end20$2;}
var $ipa_string6=(($phdata+132)&4294967295);var $arrayidx7=(($ipa_string6)&4294967295);var $5=HEAP8[($arrayidx7)];var $conv8=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));$ipa_control=$conv8;var $cmp9=((($conv8))>>>0)>32;if($cmp9){__lastLabel__=5;__label__=6;;}else{__lastLabel__=5;__label__=7;;}
if(__label__==6){var $6=$ix_addr;var $7=HEAP32[(($6)>>2)];var $8=$phon_out_addr;var $arrayidx11=(($8+$7)&4294967295);var $ipa_string12=(($phdata+132)&4294967295);var $arraydecay13=(($ipa_string12)&4294967295);var $call14=_strcpy($arrayidx11,$arraydecay13);var $9=$len;var $10=$ix_addr;var $11=HEAP32[(($10)>>2)];var $add=((($11)+($9))&4294967295);HEAP32[(($10)>>2)]=$add;var $_pr=$ipa_control;__lastLabel__=6;;}
var $12=__lastLabel__==6?$_pr:($conv8);var $cmp16=((($12))>>>0)>=32;if($cmp16){__label__=23;break $if_then$$if_end20$2;}else{__label__=8;break $if_then$$if_end20$2;}}}while(0);$for_end$$if_end20$12:do{if(__label__==8){$first=1;var $13=$ph_addr;var $mnemonic=(($13)&4294967295);var $14=HEAP32[(($mnemonic)>>2)];$mnem=$14;;$for_cond$14:while(1){var $15=$mnem;var $and=($15)&255;$c=$and;var $cmp21=((($and))|0)!=0;if(!($cmp21)){__label__=23;break $for_end$$if_end20$12;}
var $16=$c;var $cmp22=((($16))|0)==47;var $17=HEAP32[((_option_phoneme_variants)>>2)];var $cmp23=((($17))|0)==0;var $or_cond=($cmp22)&($cmp23);if($or_cond){__label__=23;break $for_end$$if_end20$12;}
var $18=HEAP32[((_option_phonemes)>>2)];var $cmp26=((($18))|0)==3;if($cmp26){__label__=12;;}else{__label__=20;;}
$if_then27$$if_else54$18:do{if(__label__==12){var $19=$first;var $tobool=((($19))|0)!=0;var $20=$c;var $cmp29=((($20))|0)==95;var $or_cond3=($tobool)&($cmp29);if($or_cond3){__label__=23;break $for_end$$if_end20$12;}
var $cmp32=((($20))|0)==35;if($cmp32){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $21=$ph_addr;var $type=(($21+11)&4294967295);var $22=HEAPU8[($type)];var $conv34=((($22))&255);var $cmp35=((($conv34))|0)==2;if($cmp35){__label__=23;break $for_end$$if_end20$12;}}
var $23=$first;var $tobool38=((($23))|0)!=0;if($tobool38){__label__=17;;}else{__label__=16;;}
if(__label__==16){var $24=$c;var $isdigittmp=((($24)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call40=((($isdigit))&1);var $tobool41=((($call40))|0)!=0;if($tobool41){__label__=22;break $if_then27$$if_else54$18;}}
var $25=$c;var $cmp44=((($25))|0)>=32;var $26=$c;var $cmp46=((($26))|0)<128;var $or_cond1=($cmp44)&($cmp46);if($or_cond1){__label__=18;;}else{__label__=19;;}
if(__label__==18){var $27=$c;var $sub=((($27)-32)&4294967295);var $arrayidx48=((_ipa1+$sub*2)&4294967295);var $28=HEAPU16[(($arrayidx48)>>1)];var $conv49=((($28))&65535);$c=$conv49;;}
var $29=$c;var $30=$ix_addr;var $31=HEAP32[(($30)>>2)];var $32=$phon_out_addr;var $arrayidx51=(($32+$31)&4294967295);var $call52=__Z8utf8_outjPc($29,$arrayidx51);var $33=$ix_addr;var $34=HEAP32[(($33)>>2)];var $add53=((($34)+($call52))&4294967295);HEAP32[(($33)>>2)]=$add53;__label__=21;break $if_then27$$if_else54$18;}
else if(__label__==20){var $35=$c;var $conv55=((($35))&255);var $36=$ix_addr;var $37=HEAP32[(($36)>>2)];var $inc=((($37)+1)&4294967295);HEAP32[(($36)>>2)]=$inc;var $38=$phon_out_addr;var $arrayidx56=(($38+$37)&4294967295);HEAP8[($arrayidx56)]=$conv55;__label__=21;break $if_then27$$if_else54$18;}}while(0);if(__label__==21){$first=0;;}
var $39=$mnem;var $shr=($39)>>8;$mnem=$shr;__label__=9;continue $for_cond$14;}}}while(0);STACKTOP=__stackBase__;return;return;}
function __Z7IsVowelP10Translatori($tr,$letter){;var __label__;var $tr_addr;var $letter_addr;$tr_addr=$tr;$letter_addr=$letter;var $0=$tr_addr;var $1=$letter_addr;var $call=__ZL8IsLetterP10Translatorii($0,$1,7);;return $call;return null;}
function __ZL8IsLetterP10Translatorii($tr,$letter,$group){;var __label__;var $retval;var $tr_addr;var $letter_addr;var $group_addr;var $letter2;$tr_addr=$tr;$letter_addr=$letter;$group_addr=$group;var $0=$group_addr;var $1=$tr_addr;var $letter_groups=(($1+968)&4294967295);var $arrayidx=(($letter_groups+$0*4)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];var $cmp=((($2))|0)!=0;var $3=$group_addr;if($cmp){__label__=1;;}else{__label__=4;;}
$if_then$$if_end4$2:do{if(__label__==1){var $4=$tr_addr;var $letter_groups1=(($4+968)&4294967295);var $arrayidx2=(($letter_groups1+$3*4)&4294967295);var $5=HEAP32[(($arrayidx2)>>2)];var $6=$letter_addr;var $call=_wcschr($5,$6);var $tobool=((($call))|0)!=0;if($tobool){__label__=2;;}else{__label__=3;;}
if(__label__==2){$retval=1;;}
else if(__label__==3){$retval=0;;}}
else if(__label__==4){var $cmp5=((($3))|0)>7;if($cmp5){__label__=5;;}else{__label__=6;;}
if(__label__==5){$retval=0;;}
else if(__label__==6){var $7=$tr_addr;var $letter_bits_offset=(($7+964)&4294967295);var $8=HEAP32[(($letter_bits_offset)>>2)];var $cmp8=((($8))|0)>0;var $9=$letter_addr;if($cmp8){__label__=7;;}else{__label__=11;;}
$if_then9$$if_else15$11:do{if(__label__==7){var $10=$tr_addr;var $letter_bits_offset10=(($10+964)&4294967295);var $11=HEAP32[(($letter_bits_offset10)>>2)];var $sub=((($9)-($11))&4294967295);$letter2=$sub;var $cmp11=((($sub))|0)>0;if($cmp11){__label__=8;;}else{__label__=10;;}
$land_lhs_true$$if_else$13:do{if(__label__==8){var $12=$letter2;var $cmp12=((($12))|0)<128;if(!($cmp12)){__label__=10;break $land_lhs_true$$if_else$13;}
var $13=$letter2;$letter_addr=$13;__label__=13;break $if_then9$$if_else15$11;}}while(0);$retval=0;__label__=16;break $if_then$$if_end4$2;}
else if(__label__==11){var $cmp16=((($9))|0)>=192;var $14=$letter_addr;var $cmp18=((($14))|0)<606;var $or_cond=($cmp16)&($cmp18);if(!($or_cond)){__label__=13;break $if_then9$$if_else15$11;}
var $15=$letter_addr;var $sub20=((($15)-192)&4294967295);var $arrayidx21=((__ZL13remove_accent+$sub20)&4294967295);var $16=HEAPU8[($arrayidx21)];var $idxprom=((($16))&255);var $17=$tr_addr;var $letter_bits=(($17+708)&4294967295);var $arrayidx22=(($letter_bits+$idxprom)&4294967295);var $18=HEAPU8[($arrayidx22)];var $conv=((($18))&255);var $19=$group_addr;var $shl=1<<($19);var $and=($shl)&($conv);$retval=$and;__label__=16;break $if_then$$if_end4$2;}}while(0);var $20=$letter_addr;var $cmp25=((($20))|0)>=0;var $21=$letter_addr;var $cmp27=((($21))|0)<128;var $or_cond1=($cmp25)&($cmp27);if($or_cond1){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $22=$letter_addr;var $23=$tr_addr;var $letter_bits29=(($23+708)&4294967295);var $arrayidx30=(($letter_bits29+$22)&4294967295);var $24=HEAPU8[($arrayidx30)];var $conv31=((($24))&255);var $25=$group_addr;var $shl32=1<<($25);var $and33=($shl32)&($conv31);$retval=$and33;;}
else if(__label__==15){$retval=0;;}}}}while(0);var $26=$retval;;return $26;return null;}
function __Z14UnpronouncableP10TranslatorPci($tr,$word,$posn){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $word_addr;var $posn_addr;var $c=__stackBase__;var $c1;var $vowel_posn;var $index;var $count;var $apostrophe;$tr_addr=$tr;$word_addr=$word;$posn_addr=$posn;$c1=0;$vowel_posn=9;$apostrophe=0;var $0=$word_addr;var $call=__Z7utf8_inPiPKc($c,$0);var $1=$tr_addr;var $letter_bits_offset=(($1+964)&4294967295);var $2=HEAP32[(($letter_bits_offset)>>2)];var $cmp=((($2))|0)>0;if($cmp){__label__=1;;}else{__label__=3;;}
$land_lhs_true$$if_end$2:do{if(__label__==1){var $3=HEAP32[(($c)>>2)];var $cmp1=((($3))|0)<577;if(!($cmp1)){__label__=3;break $land_lhs_true$$if_end$2;}
$retval=0;__label__=30;break $land_lhs_true$$if_end$2;}}while(0);$return$$if_end$5:do{if(__label__==3){var $4=$tr_addr;var $langopts=(($4)&4294967295);var $param=(($langopts+24)&4294967295);var $arrayidx=(($param+20)&4294967295);var $5=HEAP32[(($arrayidx)>>2)];var $cmp2=((($5))|0)==1;if($cmp2){__label__=4;;}else{__label__=5;;}
if(__label__==4){$retval=0;;}
else if(__label__==5){var $6=$word_addr;var $7=HEAP8[($6)];var $conv=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($c)>>2)]=$conv;var $cmp5=((($conv))|0)==32;if($cmp5){__label__=7;;}else{__label__=6;;}
$if_then9$$lor_lhs_false$10:do{if(__label__==6){var $8=HEAP32[(($c)>>2)];var $cmp6=((($8))|0)==0;var $9=HEAP32[(($c)>>2)];var $cmp8=((($9))|0)==39;var $or_cond=($cmp6)|($cmp8);if($or_cond){__label__=7;break $if_then9$$lor_lhs_false$10;}
$index=0;$count=0;;$for_cond$13:while(1){var $10=$index;var $11=$word_addr;var $arrayidx11=(($11+$10)&4294967295);var $call12=__Z7utf8_inPiPKc($c,$arrayidx11);var $12=$index;var $add=((($12)+($call12))&4294967295);$index=$add;var $13=HEAP32[(($c)>>2)];var $cmp13=((($13))|0)==0;var $14=HEAP32[(($c)>>2)];var $cmp15=((($14))|0)==32;var $or_cond1=($cmp13)|($cmp15);if($or_cond1){__label__=21;break $for_cond$13;}
var $15=HEAP32[(($c)>>2)];var $cmp18=((($15))|0)==39;if($cmp18){__label__=11;;}else{__label__=13;;}
if(__label__==11){var $16=$count;var $cmp20=((($16))|0)>1;if($cmp20){__label__=21;break $for_cond$13;}
var $17=$posn_addr;var $cmp22=((($17))|0)>0;if($cmp22){__label__=21;break $for_cond$13;}}
var $18=$count;var $cmp25=((($18))|0)==0;if($cmp25){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $19=HEAP32[(($c)>>2)];$c1=$19;;}
var $20=$count;var $inc=((($20)+1)&4294967295);$count=$inc;var $21=$tr_addr;var $22=HEAP32[(($c)>>2)];var $call28=__Z7IsVowelP10Translatori($21,$22);var $tobool=((($call28))|0)!=0;if($tobool){__label__=16;break $for_cond$13;}
var $24=HEAP32[(($c)>>2)];var $cmp31=((($24))|0)==39;if($cmp31){__label__=18;;}else{__label__=19;;}
if(__label__==18){$apostrophe=1;__label__=9;continue $for_cond$13;}
else if(__label__==19){var $25=HEAP32[(($c)>>2)];var $call33=_iswalpha($25);var $tobool34=((($call33))|0)!=0;if($tobool34){__label__=9;continue $for_cond$13;}else{__label__=20;break $for_cond$13;}}}
if(__label__==21){var $_pr=$vowel_posn;__lastLabel__=21;;}
else if(__label__==16){var $23=$count;$vowel_posn=$23;__lastLabel__=16;;}
else if(__label__==20){$retval=0;__label__=30;break $return$$if_end$5;}
var $26=__lastLabel__==21?$_pr:($23);var $cmp38=((($26))|0)>2;if($cmp38){__label__=23;;}else{__label__=25;;}
$land_lhs_true39$$if_end46$32:do{if(__label__==23){var $27=$tr_addr;var $langopts40=(($27)&4294967295);var $param41=(($langopts40+24)&4294967295);var $arrayidx42=(($param41+20)&4294967295);var $28=HEAP32[(($arrayidx42)>>2)];var $cmp43=((($28))|0)==2;if(!($cmp43)){__label__=25;break $land_lhs_true39$$if_end46$32;}
var $29=$tr_addr;var $30=$word_addr;var $call45=__ZL15Unpronouncable2P10TranslatorPc($29,$30);$retval=$call45;__label__=30;break $return$$if_end$5;}}while(0);var $31=$c1;var $32=$tr_addr;var $langopts47=(($32)&4294967295);var $param48=(($langopts47+24)&4294967295);var $arrayidx49=(($param48+20)&4294967295);var $33=HEAP32[(($arrayidx49)>>2)];var $cmp50=((($31))|0)==((($33))|0);if($cmp50){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $34=$vowel_posn;var $dec=((($34)-1)&4294967295);$vowel_posn=$dec;;}
var $35=$vowel_posn;var $36=$tr_addr;var $langopts53=(($36)&4294967295);var $max_initial_consonants=(($langopts53+248)&4294967295);var $37=HEAP8[($max_initial_consonants)];var $conv54=(tempInt=(($37)),(tempInt>=128?tempInt-256:tempInt));var $add55=((($conv54)+1)&4294967295);var $cmp56=((($35))|0)>((($add55))|0);if($cmp56){__label__=28;;}else{__label__=29;;}
if(__label__==28){$retval=1;__label__=30;break $return$$if_end$5;}
else if(__label__==29){$retval=0;__label__=30;break $return$$if_end$5;}}}while(0);$retval=0;;}}}while(0);var $38=$retval;STACKTOP=__stackBase__;return $38;return null;}
function __ZL15Unpronouncable2P10TranslatorPc($tr,$word){var __stackBase__=STACKTOP;STACKTOP+=160;_memset(__stackBase__,0,160);var __label__;var $retval;var $tr_addr;var $word_addr;var $c;var $end_flags;var $ph_buf=__stackBase__;$tr_addr=$tr;$word_addr=$word;var $arrayidx=(($ph_buf)&4294967295);HEAP8[($arrayidx)]=0;var $0=$word_addr;var $arrayidx1=(($0+-1)&4294967295);var $1=HEAP8[($arrayidx1)];var $conv=(tempInt=(($1)),(tempInt>=128?tempInt-256:tempInt));$c=$conv;var $2=$word_addr;var $arrayidx2=(($2+-1)&4294967295);HEAP8[($arrayidx2)]=32;var $3=$tr_addr;var $4=$word_addr;var $arraydecay=(($ph_buf)&4294967295);var $call=__Z14TranslateRulesP10TranslatorPcS1_iS1_iPj($3,$4,$arraydecay,160,0,-2147483648,0);$end_flags=$call;var $5=$c;var $conv3=((($5))&255);var $6=$word_addr;var $arrayidx4=(($6+-1)&4294967295);HEAP8[($arrayidx4)]=$conv3;var $7=$end_flags;var $cmp=((($7))|0)==0;if($cmp){__label__=2;;}else{__label__=1;;}
$if_then$$lor_lhs_false$2:do{if(__label__==1){var $8=$end_flags;var $and=($8)&32768;var $tobool=((($and))|0)!=0;if($tobool){__label__=2;break $if_then$$lor_lhs_false$2;}
$retval=0;__label__=4;break $if_then$$lor_lhs_false$2;}}while(0);if(__label__==2){$retval=1;;}
var $9=$retval;STACKTOP=__stackBase__;return $9;return null;}
function __Z16ChangeWordStressP10TranslatorPci($tr,$word,$new_stress){var __stackBase__=STACKTOP;STACKTOP+=248;_memset(__stackBase__,0,248);var __label__;var $tr_addr;var $word_addr;var $new_stress_addr;var $ix;var $p;var $max_stress;var $vowel_count=__stackBase__;var $stressed_syllable=__stackBase__+4;var $phonetic=__stackBase__+8;var $vowel_stress=__stackBase__+168;$tr_addr=$tr;$word_addr=$word;$new_stress_addr=$new_stress;HEAP32[(($stressed_syllable)>>2)]=0;var $arraydecay=(($phonetic)&4294967295);var $0=$word_addr;var $call=_strcpy($arraydecay,$0);var $1=$tr_addr;var $arraydecay1=(($phonetic)&4294967295);var $arraydecay2=(($vowel_stress)&4294967295);var $call3=__ZL14GetVowelStressP10TranslatorPhPaRiS3_i($1,$arraydecay1,$arraydecay2,$vowel_count,$stressed_syllable,0);$max_stress=$call3;var $2=$new_stress_addr;var $cmp=((($2))|0)>=4;$ix=1;if($cmp){__label__=2;;}else{__label__=1;;}
$for_cond$$for_cond9_preheader$2:do{if(__label__==2){while(1){var $5=$ix;var $6=HEAP32[(($vowel_count)>>2)];var $cmp4=((($5))|0)<((($6))|0);if(!($cmp4)){__label__=9;break $for_cond$$for_cond9_preheader$2;}
var $7=$ix;var $arrayidx=(($vowel_stress+$7)&4294967295);var $8=HEAP8[($arrayidx)];var $conv=(tempInt=(($8)),(tempInt>=128?tempInt-256:tempInt));var $9=$max_stress;var $cmp5=((($conv))|0)>=((($9))|0);if($cmp5){__label__=4;break;}
var $12=$ix;var $inc=((($12)+1)&4294967295);$ix=$inc;__label__=2;continue;}
var $10=$new_stress_addr;var $conv7=((($10))&255);var $11=$ix;var $arrayidx8=(($vowel_stress+$11)&4294967295);HEAP8[($arrayidx8)]=$conv7;;}
else if(__label__==1){var $3=$ix;var $4=HEAP32[(($vowel_count)>>2)];var $cmp101=((($3))|0)<((($4))|0);if(!($cmp101)){__label__=9;break $for_cond$$for_cond9_preheader$2;}
while(1){var $13=$ix;var $arrayidx12=(($vowel_stress+$13)&4294967295);var $14=HEAP8[($arrayidx12)];var $conv13=(tempInt=(($14)),(tempInt>=128?tempInt-256:tempInt));var $15=$new_stress_addr;var $cmp14=((($conv13))|0)>((($15))|0);if($cmp14){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $16=$new_stress_addr;var $conv16=((($16))&255);var $17=$ix;var $arrayidx17=(($vowel_stress+$17)&4294967295);HEAP8[($arrayidx17)]=$conv16;;}
var $18=$ix;var $inc20=((($18)+1)&4294967295);$ix=$inc20;var $19=$ix;var $20=HEAP32[(($vowel_count)>>2)];var $cmp10=((($19))|0)<((($20))|0);if($cmp10){__label__=6;continue;}else{__label__=9;break $for_cond$$for_cond9_preheader$2;}}}}while(0);$ix=1;var $arraydecay23=(($phonetic)&4294967295);$p=$arraydecay23;var $21=$p;var $22=HEAPU8[($21)];var $conv242=((($22))&255);var $cmp253=((($conv242))|0)!=0;if($cmp253){__label__=10;;}else{__label__=17;;}
$while_body$$while_end$15:do{if(__label__==10){$while_body$16:while(1){var $23=$p;var $24=HEAPU8[($23)];var $idxprom=((($24))&255);var $arrayidx26=((_phoneme_tab+$idxprom*4)&4294967295);var $25=HEAP32[(($arrayidx26)>>2)];var $type=(($25+11)&4294967295);var $26=HEAPU8[($type)];var $conv27=((($26))&255);var $cmp28=((($conv27))|0)==2;if($cmp28){__label__=11;;}else{__label__=16;;}
$land_lhs_true$$if_end44$18:do{if(__label__==11){var $27=$p;var $28=HEAPU8[($27)];var $idxprom29=((($28))&255);var $arrayidx30=((_phoneme_tab+$idxprom29*4)&4294967295);var $29=HEAP32[(($arrayidx30)>>2)];var $phflags=(($29+4)&4294967295);var $30=HEAP32[(($phflags)>>2)];var $and=($30)&1048576;var $tobool=((($and))|0)!=0;if($tobool){__label__=16;break $land_lhs_true$$if_end44$18;}
var $31=$ix;var $arrayidx32=(($vowel_stress+$31)&4294967295);var $32=HEAP8[($arrayidx32)];var $conv33=(tempInt=(($32)),(tempInt>=128?tempInt-256:tempInt));var $cmp34=((($conv33))|0)==0;if($cmp34){__label__=14;;}else{__label__=13;;}
$if_then38$$lor_lhs_false$21:do{if(__label__==13){var $33=$ix;var $arrayidx35=(($vowel_stress+$33)&4294967295);var $34=HEAP8[($arrayidx35)];var $conv36=(tempInt=(($34)),(tempInt>=128?tempInt-256:tempInt));var $cmp37=((($conv36))|0)>1;if($cmp37){__label__=14;break $if_then38$$lor_lhs_false$21;}else{__label__=15;break $if_then38$$lor_lhs_false$21;}}}while(0);if(__label__==14){var $35=$ix;var $arrayidx39=(($vowel_stress+$35)&4294967295);var $36=HEAPU8[($arrayidx39)];var $idxprom40=((($36))&255);var $arrayidx41=((__ZL15stress_phonemes+$idxprom40)&4294967295);var $37=HEAP8[($arrayidx41)];var $38=$word_addr;var $incdec_ptr=(($38+1)&4294967295);$word_addr=$incdec_ptr;HEAP8[($38)]=$37;;}
var $39=$ix;var $inc43=((($39)+1)&4294967295);$ix=$inc43;;}}while(0);var $40=$p;var $incdec_ptr45=(($40+1)&4294967295);$p=$incdec_ptr45;var $41=HEAP8[($40)];var $42=$word_addr;var $incdec_ptr46=(($42+1)&4294967295);$word_addr=$incdec_ptr46;HEAP8[($42)]=$41;var $43=$p;var $44=HEAPU8[($43)];var $conv24=((($44))&255);var $cmp25=((($conv24))|0)!=0;if($cmp25){__label__=10;continue $while_body$16;}else{__label__=17;break $while_body$$while_end$15;}}}}while(0);var $45=$word_addr;HEAP8[($45)]=0;STACKTOP=__stackBase__;return;return;}
function __ZL14GetVowelStressP10TranslatorPhPaRiS3_i($tr,$phonemes,$vowel_stress,$vowel_count,$stressed_syllable,$control){;var __label__;var __lastLabel__=null;var $tr_addr;var $phonemes_addr;var $vowel_stress_addr;var $vowel_count_addr;var $stressed_syllable_addr;var $control_addr;var $phcode;var $ph;var $ph_out;var $count;var $max_stress;var $ix;var $j;var $stress;var $primary_posn;$tr_addr=$tr;$phonemes_addr=$phonemes;$vowel_stress_addr=$vowel_stress;$vowel_count_addr=$vowel_count;$stressed_syllable_addr=$stressed_syllable;$control_addr=$control;var $0=$phonemes_addr;$ph_out=$0;$count=1;$max_stress=-1;$stress=-1;$primary_posn=0;var $1=$vowel_stress_addr;var $arrayidx=(($1)&4294967295);HEAP8[($arrayidx)]=1;;$while_cond$2:while(1){var $2=$phonemes_addr;var $incdec_ptr=(($2+1)&4294967295);$phonemes_addr=$incdec_ptr;var $3=HEAPU8[($2)];$phcode=$3;var $conv=((($3))&255);var $cmp=((($conv))|0)!=0;if(!($cmp)){__label__=39;break $while_cond$2;}
var $4=$count;var $cmp1=((($4))|0)<79;if(!($cmp1)){__label__=39;break $while_cond$2;}
var $5=$phcode;var $idxprom=((($5))&255);var $arrayidx2=((_phoneme_tab+$idxprom*4)&4294967295);var $6=HEAPU32[(($arrayidx2)>>2)];$ph=$6;var $cmp3=((($6))|0)==0;if($cmp3){__label__=1;continue $while_cond$2;}
var $7=$ph;var $type=(($7+11)&4294967295);var $8=HEAPU8[($type)];var $conv4=((($8))&255);var $cmp5=((($conv4))|0)==1;if($cmp5){__label__=5;;}else{__label__=24;;}
$land_lhs_true$$if_end53$7:do{if(__label__==5){var $9=$ph;var $program=(($9+8)&4294967295);var $10=HEAPU16[(($program)>>1)];var $conv6=((($10))&65535);var $cmp7=((($conv6))|0)==0;if(!($cmp7)){__label__=24;break $land_lhs_true$$if_end53$7;}
var $11=$phcode;var $conv9=((($11))&255);var $cmp10=((($conv9))|0)==8;if($cmp10){__label__=7;;}else{__label__=20;;}
if(__label__==7){var $12=$count;var $sub=((($12)-1)&4294967295);$j=$sub;__lastLabel__=7;;$while_cond12$12:while(1){var $13=__lastLabel__==19?$dec:($sub);var $cmp13=((($13))|0)>0;if(!($cmp13)){__label__=1;continue $while_cond$2;}
var $14=$stressed_syllable_addr;var $15=HEAP32[(($14)>>2)];var $cmp15=((($15))|0)==0;if(!($cmp15)){__label__=1;continue $while_cond$2;}
var $16=$j;var $17=$vowel_stress_addr;var $arrayidx17=(($17+$16)&4294967295);var $18=HEAP8[($arrayidx17)];var $conv18=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));var $cmp19=((($conv18))|0)<4;if(!($cmp19)){__label__=1;continue $while_cond$2;}
var $19=$j;var $20=$vowel_stress_addr;var $arrayidx22=(($20+$19)&4294967295);var $21=HEAP8[($arrayidx22)];var $conv23=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));var $cmp24=((($conv23))|0)!=0;if($cmp24){__label__=12;;}else{__label__=19;;}
if(__label__==12){var $22=$j;var $23=$vowel_stress_addr;var $arrayidx26=(($23+$22)&4294967295);var $24=HEAP8[($arrayidx26)];var $conv27=(tempInt=(($24)),(tempInt>=128?tempInt-256:tempInt));var $cmp28=((($conv27))|0)!=1;if($cmp28){__label__=13;break $while_cond12$12;}}
var $39=$j;var $dec=((($39)-1)&4294967295);$j=$dec;__lastLabel__=19;__label__=8;continue $while_cond12$12;}
var $25=$j;var $26=$vowel_stress_addr;var $arrayidx30=(($26+$25)&4294967295);HEAP8[($arrayidx30)]=4;var $27=$max_stress;var $cmp31=((($27))|0)<4;if($cmp31){__label__=14;;}else{__label__=15;;}
if(__label__==14){$max_stress=4;var $28=$j;$primary_posn=$28;;}
$ix=1;var $29=$ix;var $30=$j;var $cmp344=((($29))|0)<((($30))|0);if(!($cmp344)){__label__=1;continue $while_cond$2;}
while(1){var $31=$ix;var $32=$vowel_stress_addr;var $arrayidx35=(($32+$31)&4294967295);var $33=HEAP8[($arrayidx35)];var $conv36=(tempInt=(($33)),(tempInt>=128?tempInt-256:tempInt));var $cmp37=((($conv36))|0)==4;if($cmp37){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $34=$ix;var $35=$vowel_stress_addr;var $arrayidx39=(($35+$34)&4294967295);HEAP8[($arrayidx39)]=3;;}
var $36=$ix;var $inc=((($36)+1)&4294967295);$ix=$inc;var $37=$ix;var $38=$j;var $cmp34=((($37))|0)<((($38))|0);if($cmp34){__label__=16;continue;}else{__label__=1;continue $while_cond$2;}}}
else if(__label__==20){var $40=$ph;var $std_length=(($40+14)&4294967295);var $41=HEAPU8[($std_length)];var $conv42=((($41))&255);var $cmp43=((($conv42))|0)<4;if($cmp43){__label__=22;;}else{__label__=21;;}
if(__label__==21){var $42=$stressed_syllable_addr;var $43=HEAP32[(($42)>>2)];var $cmp44=((($43))|0)==0;if(!($cmp44)){__label__=1;continue $while_cond$2;}}
var $44=$ph;var $std_length46=(($44+14)&4294967295);var $45=HEAPU8[($std_length46)];var $conv47=((($45))&255);$stress=$conv47;var $46=$stress;var $47=$max_stress;var $cmp48=((($46))|0)>((($47))|0);if(!($cmp48)){__label__=1;continue $while_cond$2;}
var $48=$stress;$max_stress=$48;__label__=1;continue $while_cond$2;}}}while(0);var $49=$ph;var $type54=(($49+11)&4294967295);var $50=HEAPU8[($type54)];var $conv55=((($50))&255);var $cmp56=((($conv55))|0)==2;if($cmp56){__label__=25;;}else{__label__=34;;}
$land_lhs_true57$$if_else78$35:do{if(__label__==25){var $51=$ph;var $phflags=(($51+4)&4294967295);var $52=HEAP32[(($phflags)>>2)];var $and=($52)&1048576;var $tobool=((($and))|0)!=0;if($tobool){__label__=34;break $land_lhs_true57$$if_else78$35;}
var $53=$stress;var $conv59=((($53))&255);var $54=$count;var $55=$vowel_stress_addr;var $arrayidx60=(($55+$54)&4294967295);HEAP8[($arrayidx60)]=$conv59;var $56=$stress;var $cmp61=((($56))|0)>=4;if($cmp61){__lastLabel__=26;__label__=27;;}else{__lastLabel__=26;__label__=29;;}
$land_lhs_true62$$if_end65$38:do{if(__label__==27){var $57=$stress;var $58=$max_stress;var $cmp63=((($57))|0)>=((($58))|0);if($cmp63){__lastLabel__=27;;}else{__lastLabel__=27;__label__=29;break $land_lhs_true62$$if_end65$38;}
var $59=$count;$primary_posn=$59;var $60=$stress;$max_stress=$60;__lastLabel__=28;;}}while(0);var $61=__lastLabel__==28?$60:(__lastLabel__==27?$57:($56));var $cmp66=((($61))|0)<0;if($cmp66){__label__=30;;}else{__label__=33;;}
$land_lhs_true67$$if_end76$42:do{if(__label__==30){var $62=$control_addr;var $and68=($62)&1;var $tobool69=((($and68))|0)!=0;if(!($tobool69)){__label__=33;break $land_lhs_true67$$if_end76$42;}
var $63=$ph;var $phflags71=(($63+4)&4294967295);var $64=HEAP32[(($phflags71)>>2)];var $and72=($64)&2;var $tobool73=((($and72))|0)!=0;if(!($tobool73)){__label__=33;break $land_lhs_true67$$if_end76$42;}
var $65=$count;var $66=$vowel_stress_addr;var $arrayidx75=(($66+$65)&4294967295);HEAP8[($arrayidx75)]=1;;}}while(0);var $67=$count;var $inc77=((($67)+1)&4294967295);$count=$inc77;$stress=-1;__label__=38;break $land_lhs_true57$$if_else78$35;}}while(0);$if_else78$$if_end93$47:do{if(__label__==34){var $68=$phcode;var $conv79=((($68))&255);var $cmp80=((($conv79))|0)==20;if(!($cmp80)){__label__=38;break $if_else78$$if_end93$47;}
var $69=$stress;var $conv82=((($69))&255);var $70=$count;var $71=$vowel_stress_addr;var $arrayidx83=(($71+$70)&4294967295);HEAP8[($arrayidx83)]=$conv82;var $72=$stress;var $cmp84=((($72))|0)==0;if(!($cmp84)){__label__=38;break $if_else78$$if_end93$47;}
var $73=$control_addr;var $and86=($73)&1;var $tobool87=((($and86))|0)!=0;if(!($tobool87)){__label__=38;break $if_else78$$if_end93$47;}
var $74=$count;var $inc89=((($74)+1)&4294967295);$count=$inc89;var $75=$vowel_stress_addr;var $arrayidx90=(($75+$74)&4294967295);HEAP8[($arrayidx90)]=1;;}}while(0);var $76=$phcode;var $77=$ph_out;var $incdec_ptr94=(($77+1)&4294967295);$ph_out=$incdec_ptr94;HEAP8[($77)]=$76;__label__=1;continue $while_cond$2;}
var $78=$count;var $79=$vowel_stress_addr;var $arrayidx96=(($79+$78)&4294967295);HEAP8[($arrayidx96)]=1;var $80=$ph_out;HEAP8[($80)]=0;var $81=$stressed_syllable_addr;var $82=HEAP32[(($81)>>2)];var $cmp97=((($82))|0)>0;if($cmp97){__label__=40;;}else{__label__=43;;}
$if_then98$$if_end104$54:do{if(__label__==40){var $83=$stressed_syllable_addr;var $84=HEAP32[(($83)>>2)];var $85=$count;var $cmp99=((($84))|0)>=((($85))|0);if($cmp99){__label__=41;;}else{__label__=42;;}
if(__label__==41){var $86=$count;var $sub101=((($86)-1)&4294967295);var $87=$stressed_syllable_addr;HEAP32[(($87)>>2)]=$sub101;;}
var $88=$stressed_syllable_addr;var $89=HEAP32[(($88)>>2)];var $90=$vowel_stress_addr;var $arrayidx103=(($90+$89)&4294967295);HEAP8[($arrayidx103)]=4;$max_stress=4;var $91=$stressed_syllable_addr;var $92=HEAP32[(($91)>>2)];$primary_posn=$92;;}
else if(__label__==43){var $_pr=$max_stress;var $cmp105=((($_pr))|0)==5;if(!($cmp105)){__label__=53;break $if_then98$$if_end104$54;}
$ix=1;var $93=$ix;var $94=$count;var $cmp1083=((($93))|0)<((($94))|0);if($cmp1083){__label__=45;;}else{__label__=52;;}
$for_body109$$for_end130$61:do{if(__label__==45){while(1){var $95=$ix;var $96=$vowel_stress_addr;var $arrayidx110=(($96+$95)&4294967295);var $97=HEAP8[($arrayidx110)];var $conv111=(tempInt=(($97)),(tempInt>=128?tempInt-256:tempInt));var $cmp112=((($conv111))|0)==4;if($cmp112){__label__=46;;}else{__label__=49;;}
if(__label__==46){var $98=$tr_addr;var $langopts=(($98)&4294967295);var $stress_flags=(($langopts+12)&4294967295);var $99=HEAP32[(($stress_flags)>>2)];var $and114=($99)&131072;var $tobool115=((($and114))|0)!=0;var $100=$ix;var $101=$vowel_stress_addr;var $arrayidx117=(($101+$100)&4294967295);if($tobool115){__label__=47;;}else{__label__=48;;}
if(__label__==47){HEAP8[($arrayidx117)]=1;;}
else if(__label__==48){HEAP8[($arrayidx117)]=3;;}}
var $102=$ix;var $103=$vowel_stress_addr;var $arrayidx122=(($103+$102)&4294967295);var $104=HEAP8[($arrayidx122)];var $conv123=(tempInt=(($104)),(tempInt>=128?tempInt-256:tempInt));var $cmp124=((($conv123))|0)==5;if($cmp124){__label__=50;;}else{__label__=51;;}
if(__label__==50){var $105=$ix;var $106=$vowel_stress_addr;var $arrayidx126=(($106+$105)&4294967295);HEAP8[($arrayidx126)]=4;var $107=$ix;$primary_posn=$107;;}
var $108=$ix;var $inc129=((($108)+1)&4294967295);$ix=$inc129;var $109=$ix;var $110=$count;var $cmp108=((($109))|0)<((($110))|0);if($cmp108){__label__=45;continue;}else{__label__=52;break $for_body109$$for_end130$61;}}}}while(0);$max_stress=4;;}}while(0);var $111=$primary_posn;var $112=$stressed_syllable_addr;HEAP32[(($112)>>2)]=$111;var $113=$count;var $114=$vowel_count_addr;HEAP32[(($114)>>2)]=$113;var $115=$max_stress;;return $115;return null;}
function __Z13SetWordStressP10TranslatorPcPjii($tr,$output,$dictionary_flags,$tonic,$control){var __stackBase__=STACKTOP;STACKTOP+=408;_memset(__stackBase__,0,408);var __label__;var __lastLabel__=null;var $tr_addr;var $output_addr;var $dictionary_flags_addr;var $tonic_addr;var $control_addr;var $phcode;var $p;var $ph;var $stress;var $max_stress;var $vowel_count=__stackBase__;var $ix;var $v;var $v_stress;var $stressed_syllable=__stackBase__+4;var $max_stress_posn;var $unstressed_word;var $max_output;var $final_ph;var $final_ph2;var $mnem;var $mnem2;var $post_tonic;var $opt_length;var $done;var $stressflags;var $dflags;var $first_primary;var $vowel_stress=__stackBase__+8;var $syllable_weight=__stackBase__+88;var $vowel_length=__stackBase__+168;var $phonetic=__stackBase__+248;var $weight;var $lengthened;var $wt;var $max_weight;var $prev_stressed;var $shorten;$tr_addr=$tr;$output_addr=$output;$dictionary_flags_addr=$dictionary_flags;$tonic_addr=$tonic;$control_addr=$control;$unstressed_word=0;$dflags=0;var $0=$tr_addr;var $langopts=(($0)&4294967295);var $stress_flags=(($langopts+12)&4294967295);var $1=HEAP32[(($stress_flags)>>2)];$stressflags=$1;var $2=$dictionary_flags_addr;var $cmp=((($2))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $3=$dictionary_flags_addr;var $arrayidx=(($3)&4294967295);var $4=HEAP32[(($arrayidx)>>2)];$dflags=$4;;}
$ix=0;__lastLabel__=2;;$for_cond$5:while(1){var $5=__lastLabel__==7?$inc:(0);var $cmp1=((($5))|0)<160;var $6=$ix;if($cmp1){__lastLabel__=3;;}else{__lastLabel__=3;__label__=8;break $for_cond$5;}
var $7=$output_addr;var $arrayidx2=(($7+$6)&4294967295);var $8=HEAP8[($arrayidx2)];var $9=$ix;var $arrayidx3=(($phonetic+$9)&4294967295);HEAP8[($arrayidx3)]=$8;var $10=$ix;var $arrayidx4=(($phonetic+$10)&4294967295);var $11=HEAPU8[($arrayidx4)];var $conv=((($11))&255);var $12=HEAP32[((_n_phoneme_tab)>>2)];var $cmp5=((($conv))|0)>=((($12))|0);if($cmp5){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $13=$ix;var $arrayidx7=(($phonetic+$13)&4294967295);HEAP8[($arrayidx7)]=13;;}
var $14=$ix;var $arrayidx9=(($phonetic+$14)&4294967295);var $15=HEAPU8[($arrayidx9)];var $conv10=((($15))&255);var $cmp11=((($conv10))|0)==0;if($cmp11){__lastLabel__=6;__label__=8;break $for_cond$5;}else{__lastLabel__=6;;}
var $16=$ix;var $inc=((($16)+1)&4294967295);$ix=$inc;__lastLabel__=7;__label__=3;continue $for_cond$5;}
var $17=__lastLabel__==6?$14:($6);var $cmp14=((($17))|0)==0;if($cmp14){__label__=223;;}else{__label__=9;;}
if(__label__==9){var $18=$ix;var $sub=((($18)-1)&4294967295);var $arrayidx17=(($phonetic+$sub)&4294967295);var $19=HEAPU8[($arrayidx17)];var $conv18=((($19))&255);$final_ph=$conv18;var $20=$ix;var $sub19=((($20)-2)&4294967295);var $arrayidx20=(($phonetic+$sub19)&4294967295);var $21=HEAPU8[($arrayidx20)];var $conv21=((($21))&255);$final_ph2=$conv21;var $22=$output_addr;var $add_ptr=(($22+157)&4294967295);$max_output=$add_ptr;var $23=$dflags;var $and=($23)&7;HEAP32[(($stressed_syllable)>>2)]=$and;var $24=$dflags;var $and22=($24)&8;var $tobool=((($and22))|0)!=0;if($tobool){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $25=$dflags;var $and24=($25)&3;HEAP32[(($stressed_syllable)>>2)]=$and24;$unstressed_word=1;;}
var $26=$tr_addr;var $arraydecay=(($phonetic)&4294967295);var $arraydecay26=(($vowel_stress)&4294967295);var $call=__ZL14GetVowelStressP10TranslatorPhPaRiS3_i($26,$arraydecay,$arraydecay26,$vowel_count,$stressed_syllable,1);$max_stress=$call;var $cmp27=((($call))|0)<0;if($cmp27){__label__=12;;}else{__label__=17;;}
$land_lhs_true$$if_end40$18:do{if(__label__==12){var $27=$dictionary_flags_addr;var $tobool28=((($27))|0)!=0;if(!($tobool28)){__label__=17;break $land_lhs_true$$if_end40$18;}
var $28=$tr_addr;var $langopts30=(($28)&4294967295);var $stress_flags31=(($langopts30+12)&4294967295);var $29=HEAP32[(($stress_flags31)>>2)];var $and32=($29)&1;var $tobool33=((($and32))|0)!=0;if($tobool33){__label__=14;;}else{__label__=16;;}
$land_lhs_true34$$if_end39$21:do{if(__label__==14){var $30=HEAP32[(($vowel_count)>>2)];var $cmp35=((($30))|0)==2;if(!($cmp35)){__label__=16;break $land_lhs_true34$$if_end39$21;}
var $arrayidx37=(($vowel_stress+1)&4294967295);HEAP8[($arrayidx37)]=0;var $31=$dictionary_flags_addr;var $arrayidx38=(($31)&4294967295);var $32=HEAP32[(($arrayidx38)>>2)];var $or=($32)|4096;HEAP32[(($arrayidx38)>>2)]=$or;;}}while(0);$max_stress=0;;}}while(0);$ix=1;var $arraydecay41=(($phonetic)&4294967295);$p=$arraydecay41;var $33=$p;var $34=HEAPU8[($33)];var $conv4319=((($34))&255);var $cmp4420=((($conv4319))|0)!=0;if($cmp4420){__label__=18;;}else{__label__=33;;}
$for_body45$$for_end109$26:do{if(__label__==18){$for_body45$27:while(1){var $35=$p;var $arrayidx46=(($35)&4294967295);var $36=HEAPU8[($arrayidx46)];var $idxprom=((($36))&255);var $arrayidx47=((_phoneme_tab+$idxprom*4)&4294967295);var $37=HEAP32[(($arrayidx47)>>2)];var $type=(($37+11)&4294967295);var $38=HEAPU8[($type)];var $conv48=((($38))&255);var $cmp49=((($conv48))|0)==2;if($cmp49){__label__=19;;}else{__label__=32;;}
$land_lhs_true50$$for_inc107$29:do{if(__label__==19){var $39=$p;var $arrayidx51=(($39)&4294967295);var $40=HEAPU8[($arrayidx51)];var $idxprom52=((($40))&255);var $arrayidx53=((_phoneme_tab+$idxprom52*4)&4294967295);var $41=HEAP32[(($arrayidx53)>>2)];var $phflags=(($41+4)&4294967295);var $42=HEAP32[(($phflags)>>2)];var $and54=($42)&1048576;var $tobool55=((($and54))|0)!=0;if($tobool55){__label__=32;break $land_lhs_true50$$for_inc107$29;}
$weight=0;$lengthened=0;var $43=$p;var $arrayidx57=(($43+1)&4294967295);var $44=HEAPU8[($arrayidx57)];var $idxprom58=((($44))&255);var $arrayidx59=((_phoneme_tab+$idxprom58*4)&4294967295);var $45=HEAP32[(($arrayidx59)>>2)];var $code=(($45+10)&4294967295);var $46=HEAPU8[($code)];var $conv60=((($46))&255);var $cmp61=((($conv60))|0)==12;if($cmp61){__label__=21;;}else{__label__=22;;}
$if_end63_thread$$if_end63$32:do{if(__label__==21){$lengthened=1;__label__=24;break $if_end63_thread$$if_end63$32;}
else if(__label__==22){var $_pr3=$lengthened;var $tobool64=((($_pr3))|0)!=0;if($tobool64){__label__=24;break $if_end63_thread$$if_end63$32;}
var $47=$p;var $arrayidx65=(($47)&4294967295);var $48=HEAPU8[($arrayidx65)];var $idxprom66=((($48))&255);var $arrayidx67=((_phoneme_tab+$idxprom66*4)&4294967295);var $49=HEAP32[(($arrayidx67)>>2)];var $phflags68=(($49+4)&4294967295);var $50=HEAP32[(($phflags68)>>2)];var $and69=($50)&2097152;var $tobool70=((($and69))|0)!=0;if($tobool70){__label__=24;break $if_end63_thread$$if_end63$32;}else{__label__=25;break $if_end63_thread$$if_end63$32;}}}while(0);if(__label__==24){var $51=$weight;var $inc72=((($51)+1)&4294967295);$weight=$inc72;;}
var $52=$weight;var $conv74=((($52))&255);var $53=$ix;var $arrayidx75=(($vowel_length+$53)&4294967295);HEAP8[($arrayidx75)]=$conv74;var $54=$lengthened;var $tobool76=((($54))|0)!=0;if($tobool76){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $55=$p;var $incdec_ptr=(($55+1)&4294967295);$p=$incdec_ptr;;}
var $56=$p;var $arrayidx79=(($56+1)&4294967295);var $57=HEAPU8[($arrayidx79)];var $idxprom80=((($57))&255);var $arrayidx81=((_phoneme_tab+$idxprom80*4)&4294967295);var $58=HEAP32[(($arrayidx81)>>2)];var $type82=(($58+11)&4294967295);var $59=HEAPU8[($type82)];var $idxprom83=((($59))&255);var $arrayidx84=((__ZZ13SetWordStressP10TranslatorPcPjiiE15consonant_types+$idxprom83)&4294967295);var $60=HEAP8[($arrayidx84)];var $tobool85=(tempInt=(($60)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool85){__label__=28;;}else{__label__=31;;}
$land_lhs_true86$$if_end102$42:do{if(__label__==28){var $61=$p;var $arrayidx87=(($61+2)&4294967295);var $62=HEAPU8[($arrayidx87)];var $idxprom88=((($62))&255);var $arrayidx89=((_phoneme_tab+$idxprom88*4)&4294967295);var $63=HEAP32[(($arrayidx89)>>2)];var $type90=(($63+11)&4294967295);var $64=HEAPU8[($type90)];var $conv91=((($64))&255);var $cmp92=((($conv91))|0)!=2;if($cmp92){__label__=30;;}else{__label__=29;;}
if(__label__==29){var $65=$p;var $arrayidx94=(($65+1)&4294967295);var $66=HEAPU8[($arrayidx94)];var $idxprom95=((($66))&255);var $arrayidx96=((_phoneme_tab+$idxprom95*4)&4294967295);var $67=HEAP32[(($arrayidx96)>>2)];var $phflags97=(($67+4)&4294967295);var $68=HEAP32[(($phflags97)>>2)];var $and98=($68)&2097152;var $tobool99=((($and98))|0)!=0;if(!($tobool99)){__label__=31;break $land_lhs_true86$$if_end102$42;}}
var $69=$weight;var $inc101=((($69)+1)&4294967295);$weight=$inc101;;}}while(0);var $70=$weight;var $conv103=((($70))&255);var $71=$ix;var $arrayidx104=(($syllable_weight+$71)&4294967295);HEAP8[($arrayidx104)]=$conv103;var $72=$ix;var $inc105=((($72)+1)&4294967295);$ix=$inc105;;}}while(0);var $73=$p;var $incdec_ptr108=(($73+1)&4294967295);$p=$incdec_ptr108;var $74=$p;var $75=HEAPU8[($74)];var $conv43=((($75))&255);var $cmp44=((($conv43))|0)!=0;if($cmp44){__label__=18;continue $for_body45$27;}else{__label__=33;break $for_body45$$for_end109$26;}}}}while(0);var $76=$tr_addr;var $langopts110=(($76)&4294967295);var $stress_rule=(($langopts110+8)&4294967295);var $77=HEAP32[(($stress_rule)>>2)];if($77==8){__label__=34;;}
else if($77==1){__label__=36;;}
else if($77==10){__label__=41;;}
else if($77==2){__label__=44;;}
else if($77==3){__label__=68;;}
else if($77==4){__label__=75;;}
else if($77==5){__label__=81;;}
else if($77==6){__label__=89;;}
else if($77==7){__label__=101;;}
else if($77==9){__label__=108;;}
else{__label__=112;;}
$sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50:do{if(__label__==34){var $arrayidx111=(($syllable_weight+1)&4294967295);var $78=HEAP8[($arrayidx111)];var $conv112=(tempInt=(($78)),(tempInt>=128?tempInt-256:tempInt));var $cmp113=((($conv112))|0)>0;if($cmp113){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $arrayidx115=(($syllable_weight+2)&4294967295);var $79=HEAP8[($arrayidx115)];var $conv116=(tempInt=(($79)),(tempInt>=128?tempInt-256:tempInt));var $cmp117=((($conv116))|0)==0;if($cmp117){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}else{__label__=36;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}}
else if(__label__==41){var $84=HEAP32[(($stressed_syllable)>>2)];var $cmp131=((($84))|0)==0;if(!($cmp131)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $85=HEAP32[(($vowel_count)>>2)];var $cmp133=((($85))|0)<4;if(!($cmp133)){__label__=44;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $86=HEAP32[(($vowel_count)>>2)];var $sub135=((($86)-1)&4294967295);var $arrayidx136=(($vowel_stress+$sub135)&4294967295);HEAP8[($arrayidx136)]=4;$max_stress=4;__label__=114;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
else if(__label__==68){var $129=HEAP32[(($stressed_syllable)>>2)];var $cmp229=((($129))|0)==0;if(!($cmp229)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $130=HEAP32[(($vowel_count)>>2)];var $sub231=((($130)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub231;__lastLabel__=69;;while(1){var $131=__lastLabel__==73?$dec239:($sub231);var $cmp232=((($131))|0)>0;if(!($cmp232)){__label__=74;break;}
var $132=HEAP32[(($stressed_syllable)>>2)];var $arrayidx233=(($vowel_stress+$132)&4294967295);var $133=HEAP8[($arrayidx233)];var $conv234=(tempInt=(($133)),(tempInt>=128?tempInt-256:tempInt));var $cmp235=((($conv234))|0)<0;var $134=HEAP32[(($stressed_syllable)>>2)];if($cmp235){__label__=72;break;}
var $dec239=((($134)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$dec239;__lastLabel__=73;__label__=70;continue;}
if(__label__==72){var $arrayidx237=(($vowel_stress+$134)&4294967295);HEAP8[($arrayidx237)]=4;;}
$max_stress=4;__label__=114;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
else if(__label__==75){var $135=HEAP32[(($stressed_syllable)>>2)];var $cmp243=((($135))|0)==0;if(!($cmp243)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $136=HEAP32[(($vowel_count)>>2)];var $sub245=((($136)-3)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub245;var $137=HEAP32[(($stressed_syllable)>>2)];var $cmp246=((($137))|0)<1;if($cmp246){__label__=77;;}else{__label__=78;;}
if(__label__==77){HEAP32[(($stressed_syllable)>>2)]=1;;}
var $138=$max_stress;var $cmp249=((($138))|0)==0;if($cmp249){__label__=79;;}else{__label__=80;;}
if(__label__==79){var $139=HEAP32[(($stressed_syllable)>>2)];var $arrayidx251=(($vowel_stress+$139)&4294967295);HEAP8[($arrayidx251)]=4;;}
$max_stress=4;__label__=114;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
else if(__label__==81){var $140=HEAP32[(($stressed_syllable)>>2)];var $cmp255=((($140))|0)==0;if(!($cmp255)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $141=HEAP32[(($vowel_count)>>2)];var $sub257=((($141)-3)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub257;var $142=HEAP32[(($vowel_count)>>2)];var $cmp258=((($142))|0)<16;if($cmp258){__label__=83;;}else{__label__=88;;}
if(__label__==83){var $143=$final_ph;var $arrayidx260=((_phoneme_tab+$143*4)&4294967295);var $144=HEAP32[(($arrayidx260)>>2)];var $type261=(($144+11)&4294967295);var $145=HEAPU8[($type261)];var $conv262=((($145))&255);var $cmp263=((($conv262))|0)==2;if($cmp263){__label__=84;;}else{__label__=85;;}
if(__label__==84){var $146=HEAP32[(($vowel_count)>>2)];var $arrayidx265=((__ZZ13SetWordStressP10TranslatorPcPjiiE10guess_ru_v+$146)&4294967295);var $147=HEAP8[($arrayidx265)];var $conv266=(tempInt=(($147)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($stressed_syllable)>>2)]=$conv266;;}
else if(__label__==85){var $148=$final_ph;var $arrayidx268=((_phoneme_tab+$148*4)&4294967295);var $149=HEAP32[(($arrayidx268)>>2)];var $type269=(($149+11)&4294967295);var $150=HEAPU8[($type269)];var $conv270=((($150))&255);var $cmp271=((($conv270))|0)==4;var $151=HEAP32[(($vowel_count)>>2)];if($cmp271){__label__=86;;}else{__label__=87;;}
if(__label__==86){var $arrayidx273=((__ZZ13SetWordStressP10TranslatorPcPjiiE10guess_ru_t+$151)&4294967295);var $152=HEAP8[($arrayidx273)];var $conv274=(tempInt=(($152)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($stressed_syllable)>>2)]=$conv274;;}
else if(__label__==87){var $arrayidx276=((__ZZ13SetWordStressP10TranslatorPcPjiiE8guess_ru+$151)&4294967295);var $153=HEAP8[($arrayidx276)];var $conv277=(tempInt=(($153)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($stressed_syllable)>>2)]=$conv277;;}}}
var $154=HEAP32[(($stressed_syllable)>>2)];var $arrayidx281=(($vowel_stress+$154)&4294967295);HEAP8[($arrayidx281)]=4;$max_stress=4;__label__=114;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
else if(__label__==89){var $155=HEAP32[(($stressed_syllable)>>2)];var $cmp284=((($155))|0)==0;if(!($cmp284)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
$max_weight=-1;$ix=1;var $156=$ix;var $157=HEAP32[(($vowel_count)>>2)];var $sub28714=((($157)-1)&4294967295);var $cmp28815=((($156))|0)<((($sub28714))|0);if($cmp28815){__label__=91;;}else{__label__=95;;}
$for_body289$$for_end302$86:do{if(__label__==91){$for_body289$87:while(1){var $158=$ix;var $arrayidx290=(($vowel_stress+$158)&4294967295);var $159=HEAP8[($arrayidx290)];var $conv291=(tempInt=(($159)),(tempInt>=128?tempInt-256:tempInt));var $cmp292=((($conv291))|0)<0;if($cmp292){__label__=92;;}else{__label__=94;;}
$if_then293$$for_inc300$89:do{if(__label__==92){var $160=$ix;var $arrayidx294=(($syllable_weight+$160)&4294967295);var $161=HEAP8[($arrayidx294)];var $conv295=(tempInt=(($161)),(tempInt>=128?tempInt-256:tempInt));$wt=$conv295;var $162=$max_weight;var $cmp296=((($conv295))|0)>=((($162))|0);if(!($cmp296)){__label__=94;break $if_then293$$for_inc300$89;}
var $163=$wt;$max_weight=$163;var $164=HEAP32[(($stressed_syllable)>>2)];$prev_stressed=$164;var $165=$ix;HEAP32[(($stressed_syllable)>>2)]=$165;;}}while(0);var $166=$ix;var $inc301=((($166)+1)&4294967295);$ix=$inc301;var $167=$ix;var $168=HEAP32[(($vowel_count)>>2)];var $sub287=((($168)-1)&4294967295);var $cmp288=((($167))|0)<((($sub287))|0);if($cmp288){__label__=91;continue $for_body289$87;}else{__label__=95;break $for_body289$$for_end302$86;}}}}while(0);var $169=HEAP32[(($vowel_count)>>2)];var $sub303=((($169)-1)&4294967295);var $arrayidx304=(($syllable_weight+$sub303)&4294967295);var $170=HEAP8[($arrayidx304)];var $conv305=(tempInt=(($170)),(tempInt>=128?tempInt-256:tempInt));var $cmp306=((($conv305))|0)==2;var $171=$max_weight;if($cmp306){__label__=96;;}else{__label__=98;;}
$land_lhs_true307$$if_else311$94:do{if(__label__==96){var $cmp308=((($171))|0)<2;if(!($cmp308)){__label__=100;break $land_lhs_true307$$if_else311$94;}
var $172=HEAP32[(($vowel_count)>>2)];var $sub310=((($172)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub310;;}
else if(__label__==98){var $cmp312=((($171))|0)<=0;if(!($cmp312)){__label__=100;break $land_lhs_true307$$if_else311$94;}
HEAP32[(($stressed_syllable)>>2)]=1;;}}while(0);var $173=HEAP32[(($stressed_syllable)>>2)];var $arrayidx316=(($vowel_stress+$173)&4294967295);HEAP8[($arrayidx316)]=4;$max_stress=4;__label__=114;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
else if(__label__==101){var $174=HEAP32[(($stressed_syllable)>>2)];var $cmp319=((($174))|0)==0;if(!($cmp319)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
var $175=HEAP32[(($vowel_count)>>2)];var $sub321=((($175)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub321;$ix=1;;while(1){var $176=$ix;var $177=HEAP32[(($vowel_count)>>2)];var $cmp323=((($176))|0)<((($177))|0);if(!($cmp323)){__label__=107;break;}
var $178=$ix;var $arrayidx325=(($vowel_stress+$178)&4294967295);var $179=HEAP8[($arrayidx325)];var $conv326=(tempInt=(($179)),(tempInt>=128?tempInt-256:tempInt));var $cmp327=((($conv326))|0)==1;var $180=$ix;if($cmp327){__label__=105;break;}
var $inc332=((($180)+1)&4294967295);$ix=$inc332;__label__=103;continue;}
if(__label__==105){var $sub329=((($180)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub329;;}
var $181=HEAP32[(($stressed_syllable)>>2)];var $arrayidx334=(($vowel_stress+$181)&4294967295);HEAP8[($arrayidx334)]=4;$max_stress=4;__label__=114;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
else if(__label__==108){$ix=1;var $182=$ix;var $183=HEAP32[(($vowel_count)>>2)];var $cmp33813=((($182))|0)<((($183))|0);if(!($cmp33813)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}
while(1){var $184=$ix;var $arrayidx340=(($vowel_stress+$184)&4294967295);var $185=HEAP8[($arrayidx340)];var $conv341=(tempInt=(($185)),(tempInt>=128?tempInt-256:tempInt));var $cmp342=((($conv341))|0)<0;if($cmp342){__label__=110;;}else{__label__=111;;}
if(__label__==110){var $186=$ix;var $arrayidx344=(($vowel_stress+$186)&4294967295);HEAP8[($arrayidx344)]=4;;}
var $187=$ix;var $inc347=((($187)+1)&4294967295);$ix=$inc347;var $188=$ix;var $189=HEAP32[(($vowel_count)>>2)];var $cmp338=((($188))|0)<((($189))|0);if($cmp338){__label__=109;continue;}else{__label__=112;break $sw_epilog$$sw_bb$$sw_bb120$$sw_bb130$$sw_bb139$$sw_bb228$$sw_bb242$$sw_bb254$$sw_bb283$$sw_bb318$$sw_bb336$50;}}}}while(0);$sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115:do{if(__label__==36){var $80=HEAP32[(($stressed_syllable)>>2)];var $cmp121=((($80))|0)==0;if(!($cmp121)){__label__=112;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}
var $81=HEAP32[(($vowel_count)>>2)];var $cmp123=((($81))|0)>2;if(!($cmp123)){__label__=112;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}
HEAP32[(($stressed_syllable)>>2)]=2;var $82=$max_stress;var $cmp125=((($82))|0)==0;if($cmp125){__label__=39;;}else{__label__=40;;}
if(__label__==39){var $83=HEAP32[(($stressed_syllable)>>2)];var $arrayidx127=(($vowel_stress+$83)&4294967295);HEAP8[($arrayidx127)]=4;;}
$max_stress=4;__label__=114;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}
else if(__label__==44){var $_pr5=HEAP32[(($stressed_syllable)>>2)];var $cmp140=((($_pr5))|0)==0;if(!($cmp140)){__label__=112;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}
$max_stress=4;var $87=HEAP32[(($vowel_count)>>2)];var $cmp142=((($87))|0)>2;if($cmp142){__label__=46;;}else{__label__=63;;}
$if_then143$$if_else208$124:do{if(__label__==46){var $88=HEAP32[(($vowel_count)>>2)];var $sub144=((($88)-2)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub144;var $89=$stressflags;var $and145=($89)&768;var $tobool146=((($and145))|0)!=0;if($tobool146){__label__=47;;}else{__label__=55;;}
$if_then147$$if_end179$126:do{if(__label__==47){var $90=$final_ph;var $arrayidx148=((_phoneme_tab+$90*4)&4294967295);var $91=HEAP32[(($arrayidx148)>>2)];var $type149=(($91+11)&4294967295);var $92=HEAPU8[($type149)];var $conv150=((($92))&255);var $cmp151=((($conv150))|0)!=2;if(!($cmp151)){__label__=55;break $if_then147$$if_end179$126;}
var $93=$stressflags;var $and153=($93)&256;var $tobool154=((($and153))|0)!=0;if($tobool154){__label__=49;;}else{__label__=50;;}
if(__label__==49){var $94=HEAP32[(($vowel_count)>>2)];var $sub156=((($94)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub156;;}
else if(__label__==50){var $95=$final_ph;var $arrayidx157=((_phoneme_tab+$95*4)&4294967295);var $96=HEAP32[(($arrayidx157)>>2)];var $mnemonic=(($96)&4294967295);var $97=HEAP32[(($mnemonic)>>2)];$mnem=$97;var $98=$final_ph2;var $arrayidx158=((_phoneme_tab+$98*4)&4294967295);var $99=HEAP32[(($arrayidx158)>>2)];var $mnemonic159=(($99)&4294967295);var $100=HEAP32[(($mnemonic159)>>2)];$mnem2=$100;var $101=$mnem;var $cmp160=((($101))|0)==115;if($cmp160){__label__=51;;}else{__label__=52;;}
if(__label__==51){var $102=$mnem2;var $cmp162=((($102))|0)==110;if($cmp162){__label__=55;break $if_then147$$if_end179$126;}}
var $103=$mnem;var $cmp165=((($103))|0)!=110;var $104=$mnem;var $cmp167=((($104))|0)!=115;var $or_cond=($cmp165)&($cmp167);if($or_cond){__label__=54;;}else{__label__=53;;}
if(__label__==53){var $105=$final_ph2;var $arrayidx169=((_phoneme_tab+$105*4)&4294967295);var $106=HEAP32[(($arrayidx169)>>2)];var $type170=(($106+11)&4294967295);var $107=HEAPU8[($type170)];var $conv171=((($107))&255);var $cmp172=((($conv171))|0)!=2;if(!($cmp172)){__label__=55;break $if_then147$$if_end179$126;}}
var $108=HEAP32[(($vowel_count)>>2)];var $sub174=((($108)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub174;;}}}while(0);var $109=$stressflags;var $and180=($109)&524288;var $tobool181=((($and180))|0)!=0;if($tobool181){__label__=56;;}else{__label__=58;;}
$if_then182$$if_end193$139:do{if(__label__==56){var $110=HEAP32[(($vowel_count)>>2)];var $sub183=((($110)-1)&4294967295);var $arrayidx184=(($vowel_length+$sub183)&4294967295);var $111=HEAP8[($arrayidx184)];var $conv185=(tempInt=(($111)),(tempInt>=128?tempInt-256:tempInt));var $112=HEAP32[(($vowel_count)>>2)];var $sub186=((($112)-2)&4294967295);var $arrayidx187=(($vowel_length+$sub186)&4294967295);var $113=HEAP8[($arrayidx187)];var $conv188=(tempInt=(($113)),(tempInt>=128?tempInt-256:tempInt));var $cmp189=((($conv185))|0)>((($conv188))|0);if(!($cmp189)){__label__=58;break $if_then182$$if_end193$139;}
var $114=HEAP32[(($vowel_count)>>2)];var $sub191=((($114)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$sub191;;}}while(0);var $115=HEAP32[(($stressed_syllable)>>2)];var $arrayidx194=(($vowel_stress+$115)&4294967295);var $116=HEAP8[($arrayidx194)];var $conv195=(tempInt=(($116)),(tempInt>=128?tempInt-256:tempInt));var $cmp196=((($conv195))|0)==0;if($cmp196){__lastLabel__=58;__label__=60;;}else{__lastLabel__=58;__label__=59;;}
if(__label__==59){var $117=HEAP32[(($stressed_syllable)>>2)];var $arrayidx198=(($vowel_stress+$117)&4294967295);var $118=HEAP8[($arrayidx198)];var $conv199=(tempInt=(($118)),(tempInt>=128?tempInt-256:tempInt));var $cmp200=((($conv199))|0)==1;if($cmp200){__lastLabel__=59;;}else{__lastLabel__=59;__label__=64;break $if_then143$$if_else208$124;}}
var $119=__lastLabel__==59?$117:($115);var $cmp202=((($119))|0)>1;var $120=HEAP32[(($stressed_syllable)>>2)];if($cmp202){__label__=61;;}else{__label__=62;;}
if(__label__==61){var $dec=((($120)-1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$dec;;}
else if(__label__==62){var $inc205=((($120)+1)&4294967295);HEAP32[(($stressed_syllable)>>2)]=$inc205;;}}
else if(__label__==63){HEAP32[(($stressed_syllable)>>2)]=1;;}}while(0);var $121=HEAP32[(($stressed_syllable)>>2)];var $arrayidx210=(($vowel_stress+$121)&4294967295);var $122=HEAP8[($arrayidx210)];var $conv211=(tempInt=(($122)),(tempInt>=128?tempInt-256:tempInt));var $cmp212=((($conv211))|0)<0;if(!($cmp212)){__label__=112;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}
var $123=HEAP32[(($stressed_syllable)>>2)];var $sub214=((($123)-1)&4294967295);var $arrayidx215=(($vowel_stress+$sub214)&4294967295);var $124=HEAP8[($arrayidx215)];var $conv216=(tempInt=(($124)),(tempInt>=128?tempInt-256:tempInt));var $cmp217=((($conv216))|0)<4;if($cmp217){__label__=67;;}else{__label__=66;;}
if(__label__==66){var $125=HEAP32[(($stressed_syllable)>>2)];var $add=((($125)+1)&4294967295);var $arrayidx219=(($vowel_stress+$add)&4294967295);var $126=HEAP8[($arrayidx219)];var $conv220=(tempInt=(($126)),(tempInt>=128?tempInt-256:tempInt));var $cmp221=((($conv220))|0)<4;if(!($cmp221)){__label__=112;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}}
var $127=$max_stress;var $conv223=((($127))&255);var $128=HEAP32[(($stressed_syllable)>>2)];var $arrayidx224=(($vowel_stress+$128)&4294967295);HEAP8[($arrayidx224)]=$conv223;__label__=112;break $sw_epilog$$sw_bb120$$if_else351$$sw_bb139$115;}}while(0);$sw_epilog$$if_else351$155:do{if(__label__==112){var $_pr9=$max_stress;var $cmp349=((($_pr9))|0)<4;if(!($cmp349)){__label__=114;break $sw_epilog$$if_else351$155;}
$stress=4;__label__=115;break $sw_epilog$$if_else351$155;}}while(0);if(__label__==114){$stress=3;;}
var $190=$stressflags;var $and353=($190)&4096;var $tobool354=((($and353))|0)!=0;if($tobool354){__label__=116;;}else{__label__=121;;}
$land_lhs_true355$$if_end370$161:do{if(__label__==116){var $191=HEAP32[(($vowel_count)>>2)];var $cmp356=((($191))|0)==2;if(!($cmp356)){__label__=121;break $land_lhs_true355$$if_end370$161;}
var $arrayidx358=(($vowel_stress+1)&4294967295);var $192=HEAP8[($arrayidx358)];var $conv359=(tempInt=(($192)),(tempInt>=128?tempInt-256:tempInt));var $cmp360=((($conv359))|0)==4;if($cmp360){__label__=118;;}else{__label__=119;;}
if(__label__==118){var $arrayidx362=(($vowel_stress+2)&4294967295);HEAP8[($arrayidx362)]=3;;}
var $arrayidx364=(($vowel_stress+2)&4294967295);var $193=HEAP8[($arrayidx364)];var $conv365=(tempInt=(($193)),(tempInt>=128?tempInt-256:tempInt));var $cmp366=((($conv365))|0)==4;if(!($cmp366)){__label__=121;break $land_lhs_true355$$if_end370$161;}
var $arrayidx368=(($vowel_stress+1)&4294967295);HEAP8[($arrayidx368)]=3;;}}while(0);var $194=$stressflags;var $and371=($194)&8192;var $tobool372=((($and371))|0)!=0;if($tobool372){__label__=122;;}else{__label__=126;;}
$land_lhs_true373$$if_end386$169:do{if(__label__==122){var $arrayidx374=(($vowel_stress+1)&4294967295);var $195=HEAP8[($arrayidx374)];var $conv375=(tempInt=(($195)),(tempInt>=128?tempInt-256:tempInt));var $cmp376=((($conv375))|0)<0;if(!($cmp376)){__label__=126;break $land_lhs_true373$$if_end386$169;}
var $196=HEAP32[(($vowel_count)>>2)];var $cmp378=((($196))|0)>2;if(!($cmp378)){__label__=126;break $land_lhs_true373$$if_end386$169;}
var $arrayidx380=(($vowel_stress+2)&4294967295);var $197=HEAP8[($arrayidx380)];var $conv381=(tempInt=(($197)),(tempInt>=128?tempInt-256:tempInt));var $cmp382=((($conv381))|0)>=4;if(!($cmp382)){__label__=126;break $land_lhs_true373$$if_end386$169;}
var $arrayidx384=(($vowel_stress+1)&4294967295);HEAP8[($arrayidx384)]=3;;}}while(0);$done=0;$first_primary=0;$v=1;var $198=$v;var $199=HEAP32[(($vowel_count)>>2)];var $cmp38818=((($198))|0)<((($199))|0);if($cmp38818){__label__=127;;}else{__label__=151;;}
$for_body389$$for_end471$175:do{if(__label__==127){$for_body389$176:while(1){var $200=$v;var $arrayidx390=(($vowel_stress+$200)&4294967295);var $201=HEAP8[($arrayidx390)];var $conv391=(tempInt=(($201)),(tempInt>=128?tempInt-256:tempInt));var $cmp392=((($conv391))|0)<0;if($cmp392){__label__=128;;}else{__label__=145;;}
$if_then393$$if_end454$178:do{if(__label__==128){var $202=$stressflags;var $and394=($202)&16;var $tobool395=((($and394))|0)!=0;if($tobool395){__label__=129;;}else{__label__=131;;}
$land_lhs_true396$$if_else402$180:do{if(__label__==129){var $203=$stress;var $cmp397=((($203))|0)<4;if(!($cmp397)){__label__=131;break $land_lhs_true396$$if_else402$180;}
var $204=$v;var $205=HEAP32[(($vowel_count)>>2)];var $sub399=((($205)-1)&4294967295);var $cmp400=((($204))|0)==((($sub399))|0);if($cmp400){__label__=145;break $if_then393$$if_end454$178;}}}while(0);var $206=$stressflags;var $and403=($206)&32768;var $tobool404=((($and403))|0)!=0;if($tobool404){__label__=132;;}else{__label__=134;;}
$land_lhs_true405$$if_else410$184:do{if(__label__==132){var $207=$done;var $cmp406=((($207))|0)==0;if(!($cmp406)){__label__=134;break $land_lhs_true405$$if_else410$184;}
var $208=$stress;var $conv408=((($208))&255);var $209=$v;var $arrayidx409=(($vowel_stress+$209)&4294967295);HEAP8[($arrayidx409)]=$conv408;$done=1;$stress=3;__label__=145;break $if_then393$$if_end454$178;}}while(0);var $210=$v;var $sub411=((($210)-1)&4294967295);var $arrayidx412=(($vowel_stress+$sub411)&4294967295);var $211=HEAP8[($arrayidx412)];var $conv413=(tempInt=(($211)),(tempInt>=128?tempInt-256:tempInt));var $cmp414=((($conv413))|0)<=1;if(!($cmp414)){__label__=145;break $if_then393$$if_end454$178;}
var $212=$v;var $add416=((($212)+1)&4294967295);var $arrayidx417=(($vowel_stress+$add416)&4294967295);var $213=HEAP8[($arrayidx417)];var $conv418=(tempInt=(($213)),(tempInt>=128?tempInt-256:tempInt));var $cmp419=((($conv418))|0)<=1;if($cmp419){__label__=138;;}else{__label__=136;;}
if(__label__==136){var $214=$stress;var $cmp421=((($214))|0)==4;if(!($cmp421)){__label__=145;break $if_then393$$if_end454$178;}
var $215=$v;var $add423=((($215)+1)&4294967295);var $arrayidx424=(($vowel_stress+$add423)&4294967295);var $216=HEAP8[($arrayidx424)];var $conv425=(tempInt=(($216)),(tempInt>=128?tempInt-256:tempInt));var $cmp426=((($conv425))|0)<=2;if(!($cmp426)){__label__=145;break $if_then393$$if_end454$178;}}
var $217=$stress;var $cmp428=((($217))|0)==3;if($cmp428){__label__=139;;}else{__label__=140;;}
if(__label__==139){var $218=$stressflags;var $and430=($218)&32;var $tobool431=((($and430))|0)!=0;if($tobool431){__label__=150;break $if_then393$$if_end454$178;}}
var $219=$v;var $cmp434=((($219))|0)>1;if($cmp434){__label__=141;;}else{__label__=144;;}
$land_lhs_true435$$if_end448$196:do{if(__label__==141){var $220=$stressflags;var $and436=($220)&64;var $tobool437=((($and436))|0)!=0;if(!($tobool437)){__label__=144;break $land_lhs_true435$$if_end448$196;}
var $221=$v;var $arrayidx439=(($syllable_weight+$221)&4294967295);var $222=HEAP8[($arrayidx439)];var $conv440=(tempInt=(($222)),(tempInt>=128?tempInt-256:tempInt));var $cmp441=((($conv440))|0)==0;if(!($cmp441)){__label__=144;break $land_lhs_true435$$if_end448$196;}
var $223=$v;var $add443=((($223)+1)&4294967295);var $arrayidx444=(($syllable_weight+$add443)&4294967295);var $224=HEAP8[($arrayidx444)];var $conv445=(tempInt=(($224)),(tempInt>=128?tempInt-256:tempInt));var $cmp446=((($conv445))|0)>0;if($cmp446){__label__=150;break $if_then393$$if_end454$178;}}}while(0);var $225=$stress;var $conv449=((($225))&255);var $226=$v;var $arrayidx450=(($vowel_stress+$226)&4294967295);HEAP8[($arrayidx450)]=$conv449;$done=1;$stress=3;__label__=145;break $if_then393$$if_end454$178;}}while(0);$if_end454$$for_inc469$201:do{if(__label__==145){var $227=$v;var $arrayidx455=(($vowel_stress+$227)&4294967295);var $228=HEAP8[($arrayidx455)];var $conv456=(tempInt=(($228)),(tempInt>=128?tempInt-256:tempInt));var $cmp457=((($conv456))|0)>=4;if(!($cmp457)){__label__=150;break $if_end454$$for_inc469$201;}
var $229=$first_primary;var $cmp459=((($229))|0)==0;if($cmp459){__label__=147;;}else{__label__=148;;}
if(__label__==147){var $230=$v;$first_primary=$230;;}
else if(__label__==148){var $231=$stressflags;var $and462=($231)&128;var $tobool463=((($and462))|0)!=0;if(!($tobool463)){__label__=150;break $if_end454$$for_inc469$201;}
var $232=$v;var $arrayidx465=(($vowel_stress+$232)&4294967295);HEAP8[($arrayidx465)]=3;;}}}while(0);var $233=$v;var $inc470=((($233)+1)&4294967295);$v=$inc470;var $234=$v;var $235=HEAP32[(($vowel_count)>>2)];var $cmp388=((($234))|0)<((($235))|0);if($cmp388){__label__=127;continue $for_body389$176;}else{__label__=151;break $for_body389$$for_end471$175;}}}}while(0);var $236=$unstressed_word;var $tobool472=((($236))|0)!=0;if($tobool472){__label__=152;;}else{__label__=156;;}
$land_lhs_true473$$if_end482$210:do{if(__label__==152){var $237=$tonic_addr;var $cmp474=((($237))|0)<0;if(!($cmp474)){__label__=156;break $land_lhs_true473$$if_end482$210;}
var $238=HEAP32[(($vowel_count)>>2)];var $cmp476=((($238))|0)<=2;var $239=$tr_addr;var $langopts478=(($239)&4294967295);if($cmp476){__label__=154;;}else{__label__=155;;}
if(__label__==154){var $unstressed_wd1=(($langopts478+16)&4294967295);var $240=HEAP32[(($unstressed_wd1)>>2)];$tonic_addr=$240;;}
else if(__label__==155){var $unstressed_wd2=(($langopts478+20)&4294967295);var $241=HEAP32[(($unstressed_wd2)>>2)];$tonic_addr=$241;;}}}while(0);$max_stress=0;$max_stress_posn=0;$v=1;var $242=$v;var $243=HEAP32[(($vowel_count)>>2)];var $cmp48417=((($242))|0)<((($243))|0);if($cmp48417){__label__=157;;}else{__label__=160;;}
$for_body485$$for_end495$217:do{if(__label__==157){while(1){var $244=$v;var $arrayidx486=(($vowel_stress+$244)&4294967295);var $245=HEAP8[($arrayidx486)];var $conv487=(tempInt=(($245)),(tempInt>=128?tempInt-256:tempInt));var $246=$max_stress;var $cmp488=((($conv487))|0)>=((($246))|0);if($cmp488){__label__=158;;}else{__label__=159;;}
if(__label__==158){var $247=$v;var $arrayidx490=(($vowel_stress+$247)&4294967295);var $248=HEAP8[($arrayidx490)];var $conv491=(tempInt=(($248)),(tempInt>=128?tempInt-256:tempInt));$max_stress=$conv491;var $249=$v;$max_stress_posn=$249;;}
var $250=$v;var $inc494=((($250)+1)&4294967295);$v=$inc494;var $251=$v;var $252=HEAP32[(($vowel_count)>>2)];var $cmp484=((($251))|0)<((($252))|0);if($cmp484){__label__=157;continue;}else{__label__=160;break $for_body485$$for_end495$217;}}}}while(0);var $253=$tonic_addr;var $cmp496=((($253))|0)>=0;if($cmp496){__label__=161;;}else{__label__=164;;}
if(__label__==161){var $254=$tonic_addr;var $255=$max_stress;var $cmp498=((($254))|0)>((($255))|0);var $256=$max_stress;var $cmp500=((($256))|0)<=4;var $or_cond1=($cmp498)|($cmp500);if($or_cond1){__label__=162;;}else{__label__=163;;}
if(__label__==162){var $257=$tonic_addr;var $conv502=((($257))&255);var $258=$max_stress_posn;var $arrayidx503=(($vowel_stress+$258)&4294967295);HEAP8[($arrayidx503)]=$conv502;;}
var $259=$tonic_addr;$max_stress=$259;;}
var $arraydecay506=(($phonetic)&4294967295);$p=$arraydecay506;$v=1;var $260=$control_addr;var $and507=($260)&1;var $tobool508=((($and507))|0)!=0;if($tobool508){__label__=174;;}else{__label__=165;;}
$if_end544$$land_lhs_true509$230:do{if(__label__==165){var $261=$p;var $262=HEAPU8[($261)];var $idxprom510=((($262))&255);var $arrayidx511=((_phoneme_tab+$idxprom510*4)&4294967295);var $263=HEAPU32[(($arrayidx511)>>2)];$ph=$263;var $cmp512=((($263))|0)!=0;if(!($cmp512)){__label__=174;break $if_end544$$land_lhs_true509$230;}
var $264=$ph;var $type514=(($264+11)&4294967295);var $265=HEAPU8[($type514)];var $conv515=((($265))&255);var $cmp516=((($conv515))|0)==1;if($cmp516){__label__=167;;}else{__label__=168;;}
if(__label__==167){var $266=$p;var $arrayidx518=(($266+1)&4294967295);var $267=HEAPU8[($arrayidx518)];var $idxprom519=((($267))&255);var $arrayidx520=((_phoneme_tab+$idxprom519*4)&4294967295);var $268=HEAP32[(($arrayidx520)>>2)];$ph=$268;;}
var $269=$tr_addr;var $langopts522=(($269)&4294967295);var $vowel_pause=(($langopts522+4)&4294967295);var $270=HEAP32[(($vowel_pause)>>2)];var $and523=($270)&48;var $tobool524=((($and523))|0)!=0;if(!($tobool524)){__label__=174;break $if_end544$$land_lhs_true509$230;}
var $271=$ph;var $type526=(($271+11)&4294967295);var $272=HEAPU8[($type526)];var $conv527=((($272))&255);var $cmp528=((($conv527))|0)==2;if(!($cmp528)){__label__=174;break $if_end544$$land_lhs_true509$230;}
var $273=$tr_addr;var $langopts530=(($273)&4294967295);var $vowel_pause531=(($langopts530+4)&4294967295);var $274=HEAP32[(($vowel_pause531)>>2)];var $and532=($274)&32;var $tobool533=((($and532))|0)!=0;if($tobool533){__label__=171;;}else{__label__=173;;}
$land_lhs_true534$$if_else540$238:do{if(__label__==171){var $arrayidx535=(($vowel_stress+1)&4294967295);var $275=HEAP8[($arrayidx535)];var $conv536=(tempInt=(($275)),(tempInt>=128?tempInt-256:tempInt));var $cmp537=((($conv536))|0)>=4;if(!($cmp537)){__label__=173;break $land_lhs_true534$$if_else540$238;}
var $276=$output_addr;var $incdec_ptr539=(($276+1)&4294967295);$output_addr=$incdec_ptr539;HEAP8[($276)]=11;__label__=174;break $if_end544$$land_lhs_true509$230;}}while(0);var $277=$output_addr;var $incdec_ptr541=(($277+1)&4294967295);$output_addr=$incdec_ptr541;HEAP8[($277)]=23;;}}while(0);var $arraydecay545=(($phonetic)&4294967295);$p=$arraydecay545;$post_tonic=0;;$while_cond546$243:while(1){var $278=$p;var $incdec_ptr547=(($278+1)&4294967295);$p=$incdec_ptr547;var $279=HEAPU8[($278)];$phcode=$279;var $conv548=((($279))&255);var $cmp549=((($conv548))|0)!=0;if(!($cmp549)){__label__=222;break $while_cond546$243;}
var $280=$output_addr;var $281=$max_output;var $cmp550=((($280))>>>0)<((($281))>>>0);if(!($cmp550)){__label__=222;break $while_cond546$243;}
var $282=$phcode;var $idxprom552=((($282))&255);var $arrayidx553=((_phoneme_tab+$idxprom552*4)&4294967295);var $283=HEAPU32[(($arrayidx553)>>2)];$ph=$283;var $cmp554=((($283))|0)==0;if($cmp554){__label__=175;continue $while_cond546$243;}
var $284=$ph;var $type557=(($284+11)&4294967295);var $285=HEAPU8[($type557)];var $conv558=((($285))&255);var $cmp559=((($conv558))|0)==0;if($cmp559){__label__=179;;}else{__label__=180;;}
$if_then560$$if_else561$248:do{if(__label__==179){var $286=$tr_addr;var $prev_last_stress=(($286+8288)&4294967295);HEAP32[(($prev_last_stress)>>2)]=0;;}
else if(__label__==180){var $287=$ph;var $type562=(($287+11)&4294967295);var $288=HEAPU8[($type562)];var $conv563=((($288))&255);var $cmp564=((($conv563))|0)==2;if($cmp564){__label__=181;;}else{__label__=182;;}
$land_lhs_true565$$lor_lhs_false569$251:do{if(__label__==181){var $289=$ph;var $phflags566=(($289+4)&4294967295);var $290=HEAP32[(($phflags566)>>2)];var $and567=($290)&1048576;var $tobool568=((($and567))|0)!=0;if($tobool568){__label__=182;break $land_lhs_true565$$lor_lhs_false569$251;}else{__label__=183;break $land_lhs_true565$$lor_lhs_false569$251;}}}while(0);if(__label__==182){var $291=$p;var $292=HEAPU8[($291)];var $conv570=((($292))&255);var $cmp571=((($conv570))|0)==20;if(!($cmp571)){__label__=220;break $if_then560$$if_else561$248;}}
var $293=$v;var $arrayidx573=(($vowel_stress+$293)&4294967295);var $294=HEAP8[($arrayidx573)];var $conv574=(tempInt=(($294)),(tempInt>=128?tempInt-256:tempInt));$v_stress=$conv574;var $295=$v_stress;var $296=$tr_addr;var $prev_last_stress575=(($296+8288)&4294967295);HEAP32[(($prev_last_stress575)>>2)]=$295;var $297=$v;var $sub576=((($297)-1)&4294967295);var $arrayidx577=(($vowel_stress+$sub576)&4294967295);var $298=HEAP8[($arrayidx577)];var $conv578=(tempInt=(($298)),(tempInt>=128?tempInt-256:tempInt));var $299=$max_stress;var $cmp579=((($conv578))|0)>=((($299))|0);if($cmp579){__label__=184;;}else{__label__=185;;}
if(__label__==184){$post_tonic=1;;}
var $300=$v_stress;var $cmp582=((($300))|0)<=1;if($cmp582){__label__=186;;}else{__label__=201;;}
$if_then583$$if_end627$259:do{if(__label__==186){var $301=$v;var $cmp584=((($301))|0)>1;if($cmp584){__label__=187;;}else{__label__=191;;}
$land_lhs_true585$$if_else594$261:do{if(__label__==187){var $302=$max_stress;var $cmp586=((($302))|0)>=4;if(!($cmp586)){__label__=191;break $land_lhs_true585$$if_else594$261;}
var $303=$stressflags;var $and588=($303)&4;var $tobool589=((($and588))|0)!=0;if(!($tobool589)){__label__=191;break $land_lhs_true585$$if_else594$261;}
var $304=$v;var $305=HEAP32[(($vowel_count)>>2)];var $sub591=((($305)-1)&4294967295);var $cmp592=((($304))|0)==((($sub591))|0);if(!($cmp592)){__label__=191;break $land_lhs_true585$$if_else594$261;}
$v_stress=0;__label__=201;break $if_then583$$if_end627$259;}}while(0);var $306=$stressflags;var $and595=($306)&2;var $tobool596=((($and595))|0)!=0;if($tobool596){__label__=194;;}else{__label__=192;;}
$if_then602$$lor_lhs_false597$267:do{if(__label__==192){var $307=$v;var $cmp598=((($307))|0)==1;if($cmp598){__label__=194;break $if_then602$$lor_lhs_false597$267;}
var $308=$v;var $309=HEAP32[(($vowel_count)>>2)];var $sub600=((($309)-1)&4294967295);var $cmp601=((($308))|0)==((($sub600))|0);if($cmp601){__label__=194;break $if_then602$$lor_lhs_false597$267;}
var $310=$v;var $311=HEAP32[(($vowel_count)>>2)];var $sub604=((($311)-2)&4294967295);var $cmp605=((($310))|0)==((($sub604))|0);if($cmp605){__label__=196;;}else{__label__=198;;}
$land_lhs_true606$$if_else612$271:do{if(__label__==196){var $312=HEAP32[(($vowel_count)>>2)];var $sub607=((($312)-1)&4294967295);var $arrayidx608=(($vowel_stress+$sub607)&4294967295);var $313=HEAP8[($arrayidx608)];var $conv609=(tempInt=(($313)),(tempInt>=128?tempInt-256:tempInt));var $cmp610=((($conv609))|0)<=1;if(!($cmp610)){__label__=198;break $land_lhs_true606$$if_else612$271;}
$v_stress=1;__label__=201;break $if_then583$$if_end627$259;}}while(0);var $314=$v;var $sub613=((($314)-1)&4294967295);var $arrayidx614=(($vowel_stress+$sub613)&4294967295);var $315=HEAP8[($arrayidx614)];var $conv615=(tempInt=(($315)),(tempInt>=128?tempInt-256:tempInt));var $cmp616=((($conv615))|0)<0;if($cmp616){__label__=200;;}else{__label__=199;;}
if(__label__==199){var $316=$stressflags;var $and618=($316)&65536;var $cmp619=((($and618))|0)==0;if(!($cmp619)){__label__=201;break $if_then583$$if_end627$259;}}
$v_stress=0;var $317=$v_stress;var $conv621=((($317))&255);var $318=$v;var $arrayidx622=(($vowel_stress+$318)&4294967295);HEAP8[($arrayidx622)]=$conv621;__label__=201;break $if_then583$$if_end627$259;}}while(0);$v_stress=1;;}}while(0);var $319=$v_stress;var $cmp628=((($319))|0)==0;var $320=$v_stress;var $cmp630=((($320))|0)>1;var $or_cond2=($cmp628)|($cmp630);if($or_cond2){__label__=202;;}else{__label__=203;;}
if(__label__==202){var $321=$v_stress;var $arrayidx632=((__ZL15stress_phonemes+$321)&4294967295);var $322=HEAP8[($arrayidx632)];var $323=$output_addr;var $incdec_ptr633=(($323+1)&4294967295);$output_addr=$incdec_ptr633;HEAP8[($323)]=$322;;}
var $324=$v;var $arrayidx635=(($vowel_stress+$324)&4294967295);var $325=HEAP8[($arrayidx635)];var $conv636=(tempInt=(($325)),(tempInt>=128?tempInt-256:tempInt));var $326=$max_stress;var $cmp637=((($conv636))|0)>((($326))|0);if($cmp637){__label__=204;;}else{__label__=205;;}
if(__label__==204){var $327=$v;var $arrayidx639=(($vowel_stress+$327)&4294967295);var $328=HEAP8[($arrayidx639)];var $conv640=(tempInt=(($328)),(tempInt>=128?tempInt-256:tempInt));$max_stress=$conv640;;}
var $329=$p;var $330=HEAPU8[($329)];var $conv642=((($330))&255);var $cmp643=((($conv642))|0)==12;if($cmp643){__label__=206;;}else{__label__=214;;}
$land_lhs_true644$$if_end665$286:do{if(__label__==206){var $331=$tr_addr;var $langopts645=(($331)&4294967295);var $param=(($langopts645+24)&4294967295);var $arrayidx646=(($param+8)&4294967295);var $332=HEAP32[(($arrayidx646)>>2)];$opt_length=$332;var $and647=($332)&1;var $tobool648=((($and647))|0)!=0;if(!($tobool648)){__label__=214;break $land_lhs_true644$$if_end665$286;}
$shorten=0;var $333=$opt_length;var $and650=($333)&16;var $tobool651=((($and650))|0)!=0;if($tobool651){__label__=208;;}else{__label__=210;;}
$if_then652$$if_else656$289:do{if(__label__==208){var $334=$v;var $335=$max_stress_posn;var $cmp653=((($334))|0)!=((($335))|0);if(!($cmp653)){__label__=212;break $if_then652$$if_else656$289;}
$shorten=1;__label__=213;break $if_then652$$if_else656$289;}
else if(__label__==210){var $336=$v_stress;var $cmp657=((($336))|0)<4;if(!($cmp657)){__label__=212;break $if_then652$$if_else656$289;}
$shorten=1;__label__=213;break $if_then652$$if_else656$289;}}while(0);if(__label__==212){var $_pr11=$shorten;var $tobool661=((($_pr11))|0)!=0;if(!($tobool661)){__label__=214;break $land_lhs_true644$$if_end665$286;}}
var $337=$p;var $incdec_ptr663=(($337+1)&4294967295);$p=$incdec_ptr663;;}}while(0);var $338=$v_stress;var $cmp666=((($338))|0)>=4;if($cmp666){__label__=215;;}else{__label__=219;;}
$land_lhs_true667$$if_end682$298:do{if(__label__==215){var $339=$tr_addr;var $langopts668=(($339)&4294967295);var $param669=(($langopts668+24)&4294967295);var $arrayidx670=(($param669+8)&4294967295);var $340=HEAP32[(($arrayidx670)>>2)];var $cmp671=((($340))|0)==2;if(!($cmp671)){__label__=219;break $land_lhs_true667$$if_end682$298;}
var $341=$v;var $342=HEAP32[(($vowel_count)>>2)];var $sub673=((($342)-2)&4294967295);var $cmp674=((($341))|0)==((($sub673))|0);if(!($cmp674)){__label__=219;break $land_lhs_true667$$if_end682$298;}
var $343=$v;var $arrayidx676=(($syllable_weight+$343)&4294967295);var $344=HEAP8[($arrayidx676)];var $conv677=(tempInt=(($344)),(tempInt>=128?tempInt-256:tempInt));var $cmp678=((($conv677))|0)==0;if(!($cmp678)){__label__=219;break $land_lhs_true667$$if_end682$298;}
var $345=$phcode;var $346=$output_addr;var $incdec_ptr680=(($346+1)&4294967295);$output_addr=$incdec_ptr680;HEAP8[($346)]=$345;$phcode=12;;}}while(0);var $347=$v;var $inc683=((($347)+1)&4294967295);$v=$inc683;;}}while(0);var $348=$phcode;var $conv686=((($348))&255);var $cmp687=((($conv686))|0)!=1;if(!($cmp687)){__label__=175;continue $while_cond546$243;}
var $349=$phcode;var $350=$output_addr;var $incdec_ptr689=(($350+1)&4294967295);$output_addr=$incdec_ptr689;HEAP8[($350)]=$349;__label__=175;continue $while_cond546$243;}
var $351=$output_addr;var $incdec_ptr692=(($351+1)&4294967295);$output_addr=$incdec_ptr692;HEAP8[($351)]=0;;}
STACKTOP=__stackBase__;return;return;}
function __Z14AppendPhonemesP10TranslatorPciPKc($tr,$string,$size,$ph){;var __label__;var $tr_addr;var $string_addr;var $size_addr;var $ph_addr;var $p;var $c;var $unstress_mark;var $length;$tr_addr=$tr;$string_addr=$string;$size_addr=$size;$ph_addr=$ph;var $0=$ph_addr;var $call=_strlen($0);var $1=$string_addr;var $call1=_strlen($1);var $add=((($call1)+($call))&4294967295);$length=$add;var $2=$length;var $3=$size_addr;var $cmp=((($2))|0)>=((($3))|0);if($cmp){__label__=14;;}else{__label__=1;;}
$if_end34$$if_end$2:do{if(__label__==1){$unstress_mark=0;var $4=$ph_addr;$p=$4;var $5=$p;var $incdec_ptr1=(($5+1)&4294967295);$p=$incdec_ptr1;var $6=HEAPU8[($5)];$c=$6;var $conv2=((($6))&255);var $cmp23=((($conv2))|0)!=0;if($cmp23){__label__=2;;}else{__label__=12;;}
$while_body$$while_end$4:do{if(__label__==2){$while_body$5:while(1){var $7=$c;var $conv3=((($7))&255);var $8=HEAP32[((_n_phoneme_tab)>>2)];var $cmp4=((($conv3))|0)>=((($8))|0);if($cmp4){__label__=3;;}else{__label__=4;;}
$while_cond_backedge$$if_end6$7:do{if(__label__==4){var $11=$c;var $idxprom=((($11))&255);var $arrayidx=((_phoneme_tab+$idxprom*4)&4294967295);var $12=HEAP32[(($arrayidx)>>2)];var $type=(($12+11)&4294967295);var $13=HEAPU8[($type)];var $conv7=((($13))&255);var $cmp8=((($conv7))|0)==1;var $14=$c;var $idxprom10=((($14))&255);var $arrayidx11=((_phoneme_tab+$idxprom10*4)&4294967295);var $15=HEAP32[(($arrayidx11)>>2)];if($cmp8){__label__=5;;}else{__label__=7;;}
if(__label__==5){var $std_length=(($15+14)&4294967295);var $16=HEAPU8[($std_length)];var $conv12=((($16))&255);var $cmp13=((($conv12))|0)<4;if(!($cmp13)){__label__=3;break $while_cond_backedge$$if_end6$7;}
$unstress_mark=1;;}
else if(__label__==7){var $type18=(($15+11)&4294967295);var $17=HEAPU8[($type18)];var $conv19=((($17))&255);var $cmp20=((($conv19))|0)==2;if(!($cmp20)){__label__=3;break $while_cond_backedge$$if_end6$7;}
var $18=$c;var $idxprom22=((($18))&255);var $arrayidx23=((_phoneme_tab+$idxprom22*4)&4294967295);var $19=HEAP32[(($arrayidx23)>>2)];var $phflags=(($19+4)&4294967295);var $20=HEAP32[(($phflags)>>2)];var $and=($20)&2;var $cmp24=((($and))|0)==0;if($cmp24){__label__=9;;}else{__label__=11;;}
$land_lhs_true$$if_end27$14:do{if(__label__==9){var $21=$unstress_mark;var $cmp25=((($21))|0)==0;if(!($cmp25)){__label__=11;break $land_lhs_true$$if_end27$14;}
var $22=$tr_addr;var $word_stressed_count=(($22+8300)&4294967295);var $23=HEAP32[(($word_stressed_count)>>2)];var $inc=((($23)+1)&4294967295);HEAP32[(($word_stressed_count)>>2)]=$inc;;}}while(0);$unstress_mark=0;var $24=$tr_addr;var $word_vowel_count=(($24+8296)&4294967295);var $25=HEAP32[(($word_vowel_count)>>2)];var $inc28=((($25)+1)&4294967295);HEAP32[(($word_vowel_count)>>2)]=$inc28;;}}}while(0);var $9=$p;var $incdec_ptr=(($9+1)&4294967295);$p=$incdec_ptr;var $10=HEAPU8[($9)];$c=$10;var $conv=((($10))&255);var $cmp2=((($conv))|0)!=0;if($cmp2){__label__=2;continue $while_body$5;}else{__label__=12;break $while_body$$while_end$4;}}}}while(0);var $26=$string_addr;var $cmp31=((($26))|0)!=0;if(!($cmp31)){__label__=14;break $if_end34$$if_end$2;}
var $27=$string_addr;var $28=$ph_addr;var $call33=_strcat($27,$28);;}}while(0);;return;return;}
function __Z14TranslateRulesP10TranslatorPcS1_iS1_iPj($tr,$p_start,$phonemes,$ph_size,$end_phonemes,$word_flags,$dict_flags){var __stackBase__=STACKTOP;STACKTOP+=416;_memset(__stackBase__,0,416);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $p_start_addr;var $phonemes_addr;var $ph_size_addr;var $end_phonemes_addr;var $word_flags_addr;var $dict_flags_addr;var $c;var $c2;var $c12;var $c123;var $wc=__stackBase__;var $wc_prev;var $wc_bytes;var $p2=__stackBase__+4;var $found;var $g;var $g1;var $n;var $letter=__stackBase__+8;var $any_alpha;var $ix;var $digit_count;var $p=__stackBase__+12;var $dict_flags0;var $match1=__stackBase__+16;var $match2=__stackBase__+32;var $ph_buf=__stackBase__+48;var $word_copy=__stackBase__+88;var $wordbuf=__stackBase__+248;var $ix14;var $string=__stackBase__+368;var $buf=__stackBase__+376;$tr_addr=$tr;$p_start_addr=$p_start;$phonemes_addr=$phonemes;$ph_size_addr=$ph_size;$end_phonemes_addr=$end_phonemes;$word_flags_addr=$word_flags;$dict_flags_addr=$dict_flags;HEAP32[(($wc)>>2)]=0;$any_alpha=0;$digit_count=0;$dict_flags0=0;var $0=$tr_addr;var $data_dictrules=(($0+1048)&4294967295);var $1=HEAP32[(($data_dictrules)>>2)];var $cmp=((($1))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){$retval=0;;}
else if(__label__==2){var $2=$dict_flags_addr;var $cmp1=((($2))|0)!=0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $3=$dict_flags_addr;var $arrayidx=(($3)&4294967295);var $4=HEAP32[(($arrayidx)>>2)];$dict_flags0=$4;;}
$ix=0;__lastLabel__=4;;$for_cond$8:while(1){var $5=__lastLabel__==5?$_pr:(0);var $cmp4=((($5))|0)<159;if(!($cmp4)){__label__=8;break $for_cond$8;}
var $6=$ix;var $7=$p_start_addr;var $arrayidx5=(($7+$6)&4294967295);var $8=HEAP8[($arrayidx5)];$c=$8;var $9=$c;var $10=$ix;var $inc=((($10)+1)&4294967295);$ix=$inc;var $arrayidx6=(($word_copy+$10)&4294967295);HEAP8[($arrayidx6)]=$9;var $11=$c;var $conv=((($11))&255);var $cmp7=((($conv))|0)==0;if($cmp7){__label__=8;break $for_cond$8;}
var $_pr=$ix;__lastLabel__=5;__label__=6;continue $for_cond$8;}
var $12=$ix;var $arrayidx10=(($word_copy+$12)&4294967295);HEAP8[($arrayidx10)]=0;var $13=HEAP32[((_option_phonemes)>>2)];var $cmp11=((($13))|0)==2;if($cmp11){__label__=9;;}else{__label__=17;;}
$land_lhs_true$$if_end31$13:do{if(__label__==9){var $14=$word_flags_addr;var $and=($14)&268435456;var $cmp12=((($and))|0)==0;if(!($cmp12)){__label__=17;break $land_lhs_true$$if_end31$13;}
$ix14=0;;while(1){var $15=$ix14;var $16=$p_start_addr;var $arrayidx16=(($16+$15)&4294967295);var $17=HEAPU8[($arrayidx16)];$c=$17;var $conv17=((($17))&255);var $cmp18=((($conv17))|0)!=32;if(!($cmp18)){__label__=14;break;}
var $18=$c;var $conv19=((($18))&255);var $cmp20=((($conv19))|0)!=0;if(!($cmp20)){__label__=14;break;}
var $19=$c;var $20=$ix14;var $arrayidx22=(($wordbuf+$20)&4294967295);HEAP8[($arrayidx22)]=$19;var $21=$ix14;var $inc23=((($21)+1)&4294967295);$ix14=$inc23;__label__=11;continue;}
var $22=$ix14;var $arrayidx25=(($wordbuf+$22)&4294967295);HEAP8[($arrayidx25)]=0;var $23=$word_flags_addr;var $and26=($23)&-2147483648;var $tobool=((($and26))|0)!=0;var $24=HEAP32[((_f_trans)>>2)];var $arraydecay=(($wordbuf)&4294967295);if($tobool){__label__=15;;}else{__label__=16;;}
if(__label__==15){var $call=_fprintf($24,((__str10126)&4294967295),allocate([$arraydecay,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==16){var $call29=_fprintf($24,((__str11127)&4294967295),allocate([$arraydecay,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}}}while(0);var $25=$p_start_addr;HEAP32[(($p)>>2)]=$25;var $26=$tr_addr;var $word_vowel_count=(($26+8296)&4294967295);HEAP32[(($word_vowel_count)>>2)]=0;var $27=$tr_addr;var $word_stressed_count=(($27+8300)&4294967295);HEAP32[(($word_stressed_count)>>2)]=0;var $28=$end_phonemes_addr;var $cmp32=((($28))|0)!=0;if($cmp32){__label__=18;;}else{__label__=19;;}
if(__label__==18){var $29=$end_phonemes_addr;var $arrayidx34=(($29)&4294967295);HEAP8[($arrayidx34)]=0;;}
var $arrayidx57=(($string)&4294967295);var $arrayidx58=(($string+1)&4294967295);var $arraydecay60=(($string)&4294967295);var $arraydecay61=(($buf)&4294967295);var $arraydecay66=(($buf)&4294967295);var $arraydecay69=(($buf)&4294967295);var $phonemes282=(($match1+4)&4294967295);var $phonemes285=(($match1+4)&4294967295);var $points287=(($match1)&4294967295);var $phonemes295=(($match1+4)&4294967295);var $end_type306=(($match1+8)&4294967295);var $end_type313=(($match1+8)&4294967295);var $del_fwd=(($match1+12)&4294967295);var $del_fwd342=(($match1+12)&4294967295);var $phonemes344=(($match1+4)&4294967295);var $points=(($match2)&4294967295);var $points107=(($match2)&4294967295);var $points112=(($match2)&4294967295);var $points113=(($match1)&4294967295);var $30=$match1;var $31=$match2;var $points241=(($match1)&4294967295);var $arraydecay266=(($ph_buf)&4294967295);var $arrayidx267=(($ph_buf)&4294967295);var $arraydecay270=(($ph_buf)&4294967295);var $phonemes271=(($match1+4)&4294967295);var $points272=(($match1)&4294967295);var $points135=(($match1)&4294967295);var $arraydecay230=(($ph_buf)&4294967295);var $arraydecay232=(($ph_buf)&4294967295);var $phonemes233=(($match1+4)&4294967295);var $points234=(($match1)&4294967295);;$while_cond$28:while(1){var $32=HEAP32[(($p)>>2)];var $33=HEAPU8[($32)];$c=$33;var $conv36=((($33))&255);var $cmp37=((($conv36))|0)!=32;if(!($cmp37)){__label__=104;break $while_cond$28;}
var $34=$c;var $conv39=((($34))&255);var $cmp40=((($conv39))|0)!=0;if(!($cmp40)){__label__=104;break $while_cond$28;}
var $35=HEAP32[(($wc)>>2)];$wc_prev=$35;var $36=HEAP32[(($p)>>2)];var $call42=__Z7utf8_inPiPKc($wc,$36);$wc_bytes=$call42;var $37=HEAP32[(($wc)>>2)];var $call43=__Z7IsAlphaj($37);var $tobool44=((($call43))|0)!=0;if($tobool44){__label__=23;;}else{__label__=24;;}
if(__label__==23){var $38=$any_alpha;var $inc46=((($38)+1)&4294967295);$any_alpha=$inc46;;}
var $39=$c;var $idxprom=((($39))&255);var $40=$tr_addr;var $groups2_count=(($40+7756)&4294967295);var $arrayidx48=(($groups2_count+$idxprom)&4294967295);var $41=HEAPU8[($arrayidx48)];var $conv49=((($41))&255);$n=$conv49;var $42=HEAP32[(($wc)>>2)];var $call50=__Z7IsDigitj($42);var $tobool51=((($call50))|0)!=0;if($tobool51){__label__=25;;}else{__label__=30;;}
$land_lhs_true52$$if_else70$35:do{if(__label__==25){var $43=$tr_addr;var $langopts=(($43)&4294967295);var $tone_numbers=(($langopts+250)&4294967295);var $44=HEAP8[($tone_numbers)];var $conv53=(tempInt=(($44)),(tempInt>=128?tempInt-256:tempInt));var $cmp54=((($conv53))|0)==0;if($cmp54){__label__=27;;}else{__label__=26;;}
if(__label__==26){var $45=$any_alpha;var $tobool55=((($45))|0)!=0;if($tobool55){__label__=30;break $land_lhs_true52$$if_else70$35;}}
HEAP8[($arrayidx57)]=95;var $46=HEAP32[(($p)>>2)];var $47=$wc_bytes;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$46;$dest$=$arrayidx58;$stop$=$src$+$47;if(($dest$%4)==($src$%4)&&$47>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $48=$wc_bytes;var $add=((($48)+1)&4294967295);var $arrayidx59=(($string+$add)&4294967295);HEAP8[($arrayidx59)]=0;var $49=$tr_addr;var $call62=__Z6LookupP10TranslatorPKcPc($49,$arraydecay60,$arraydecay61);var $50=$digit_count;var $inc63=((($50)+1)&4294967295);$digit_count=$inc63;var $cmp64=((($inc63))>>>0)>=2;if($cmp64){__label__=28;;}else{__label__=29;;}
if(__label__==28){var $strlen=_strlen($arraydecay66);var $endptr=(($arraydecay66+$strlen)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__ZZ14TranslateRulesP10TranslatorPcS1_iS1_iPjE9str_pause)&4294967295);$dest$=$endptr;$stop$=$src$+2;if(($dest$%4)==($src$%4)&&2>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};$digit_count=0;;}
var $51=$tr_addr;var $52=$phonemes_addr;var $53=$ph_size_addr;__Z14AppendPhonemesP10TranslatorPciPKc($51,$52,$53,$arraydecay69);var $54=$wc_bytes;var $55=HEAP32[(($p)>>2)];var $add_ptr=(($55+$54)&4294967295);HEAP32[(($p)>>2)]=$add_ptr;__label__=20;continue $while_cond$28;}}while(0);$digit_count=0;$found=0;var $56=HEAP32[(($wc)>>2)];var $57=$tr_addr;var $letter_bits_offset=(($57+964)&4294967295);var $58=HEAP32[(($letter_bits_offset)>>2)];var $sub=((($56)-($58))&4294967295);$ix=$sub;var $cmp71=((($sub))|0)>=0;if($cmp71){__label__=31;;}else{__label__=34;;}
$land_lhs_true72$$if_end81$44:do{if(__label__==31){var $59=$ix;var $cmp73=((($59))|0)<128;if(!($cmp73)){__label__=34;break $land_lhs_true72$$if_end81$44;}
var $60=$ix;var $61=$tr_addr;var $groups3=(($61+6280)&4294967295);var $arrayidx75=(($groups3+$60*4)&4294967295);var $62=HEAP32[(($arrayidx75)>>2)];var $cmp76=((($62))|0)!=0;if(!($cmp76)){__label__=34;break $land_lhs_true72$$if_end81$44;}
var $63=$tr_addr;var $64=$p_start_addr;var $65=$wc_bytes;var $66=$ix;var $67=$tr_addr;var $groups378=(($67+6280)&4294967295);var $arrayidx79=(($groups378+$66*4)&4294967295);var $68=HEAP32[(($arrayidx79)>>2)];var $69=$word_flags_addr;var $70=$dict_flags0;__ZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordii($63,$p,$64,$65,$68,$match1,$69,$70);$found=1;__label__=85;break $land_lhs_true72$$if_end81$44;}}while(0);$if_end281$$if_end81$48:do{if(__label__==34){var $_pr3=$found;var $tobool82=((($_pr3))|0)!=0;if($tobool82){__label__=85;break $if_end281$$if_end81$48;}
var $71=$n;var $cmp84=((($71))|0)>0;if($cmp84){__label__=36;;}else{__label__=43;;}
$if_then85$$if_end121$51:do{if(__label__==36){var $72=HEAP32[(($p)>>2)];var $arrayidx86=(($72+1)&4294967295);var $73=HEAP8[($arrayidx86)];$c2=$73;var $74=$c;var $conv87=((($74))&255);var $75=$c2;var $conv88=((($75))&255);var $shl=((($conv88)*256)&4294967295);var $add89=((($shl)+($conv87))&4294967295);$c12=$add89;var $76=$c12;var $77=HEAP32[(($p)>>2)];var $arrayidx90=(($77+2)&4294967295);var $78=HEAP8[($arrayidx90)];var $conv91=(tempInt=(($78)),(tempInt>=128?tempInt-256:tempInt));var $shl92=((($conv91)*65536)&4294967295);var $add93=((($shl92)+($76))&4294967295);$c123=$add93;var $79=$c;var $idxprom94=((($79))&255);var $80=$tr_addr;var $groups2_start=(($80+8012)&4294967295);var $arrayidx95=(($groups2_start+$idxprom94)&4294967295);var $81=HEAPU8[($arrayidx95)];var $conv96=((($81))&255);$g1=$conv96;var $82=$g1;$g=$82;var $83=$g;var $84=$g1;var $85=$n;var $add989=((($85)+($84))&4294967295);var $cmp9910=((($83))|0)<((($add989))|0);if(!($cmp9910)){__label__=43;break $if_then85$$if_end121$51;}
$for_body100$53:while(1){var $86=$g;var $87=$tr_addr;var $groups2_name=(($87+7272)&4294967295);var $arrayidx101=(($groups2_name+$86*4)&4294967295);var $88=HEAP32[(($arrayidx101)>>2)];var $89=$c12;var $cmp102=((($88))|0)==((($89))|0);if($cmp102){__label__=38;;}else{__label__=42;;}
$if_then103$$for_inc118$55:do{if(__label__==38){$found=1;var $90=HEAP32[(($p)>>2)];HEAP32[(($p2)>>2)]=$90;var $91=$tr_addr;var $92=$p_start_addr;var $93=$g;var $94=$tr_addr;var $groups2=(($94+6792)&4294967295);var $arrayidx104=(($groups2+$93*4)&4294967295);var $95=HEAP32[(($arrayidx104)>>2)];var $96=$word_flags_addr;var $97=$dict_flags0;__ZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordii($91,$p2,$92,2,$95,$match2,$96,$97);var $98=HEAP32[(($points)>>2)];var $cmp105=((($98))|0)>0;if($cmp105){__label__=39;;}else{__label__=40;;}
if(__label__==39){var $99=HEAP32[(($points107)>>2)];var $add108=((($99)+35)&4294967295);HEAP32[(($points107)>>2)]=$add108;;}
var $100=$tr_addr;var $101=$p_start_addr;var $102=$c;var $idxprom110=((($102))&255);var $103=$tr_addr;var $groups1=(($103+5256)&4294967295);var $arrayidx111=(($groups1+$idxprom110*4)&4294967295);var $104=HEAP32[(($arrayidx111)>>2)];var $105=$word_flags_addr;var $106=$dict_flags0;__ZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordii($100,$p,$101,1,$104,$match1,$105,$106);var $107=HEAP32[(($points112)>>2)];var $108=HEAP32[(($points113)>>2)];var $cmp114=((($107))|0)>=((($108))|0);if(!($cmp114)){__label__=42;break $if_then103$$for_inc118$55;}
var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$31;$dest$=$30;$stop$=$src$+16;if(($dest$%4)==($src$%4)&&16>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $109=HEAP32[(($p2)>>2)];HEAP32[(($p)>>2)]=$109;;}}while(0);var $110=$g;var $inc119=((($110)+1)&4294967295);$g=$inc119;var $111=$g;var $112=$g1;var $113=$n;var $add98=((($113)+($112))&4294967295);var $cmp99=((($111))|0)<((($add98))|0);if($cmp99){__label__=37;continue $for_body100$53;}else{__label__=43;break $if_then85$$if_end121$51;}}}}while(0);var $_pr5_pr=$found;var $tobool122=((($_pr5_pr))|0)!=0;if($tobool122){__label__=85;break $if_end281$$if_end81$48;}
var $114=$c;var $idxprom124=((($114))&255);var $115=$tr_addr;var $groups1125=(($115+5256)&4294967295);var $arrayidx126=(($groups1125+$idxprom124*4)&4294967295);var $116=HEAP32[(($arrayidx126)>>2)];var $cmp127=((($116))|0)!=0;var $117=$tr_addr;var $118=$p_start_addr;if($cmp127){__label__=45;;}else{__label__=46;;}
$if_then128$$if_else132$64:do{if(__label__==45){var $119=$c;var $idxprom129=((($119))&255);var $120=$tr_addr;var $groups1130=(($120+5256)&4294967295);var $arrayidx131=(($groups1130+$idxprom129*4)&4294967295);var $121=HEAP32[(($arrayidx131)>>2)];var $122=$word_flags_addr;var $123=$dict_flags0;__ZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordii($117,$p,$118,1,$121,$match1,$122,$123);__label__=74;break $if_then128$$if_else132$64;}
else if(__label__==46){var $124=$tr_addr;var $groups1133=(($124+5256)&4294967295);var $arrayidx134=(($groups1133)&4294967295);var $125=HEAP32[(($arrayidx134)>>2)];var $126=$word_flags_addr;var $127=$dict_flags0;__ZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordii($117,$p,$118,0,$125,$match1,$126,$127);var $128=HEAP32[(($points135)>>2)];var $cmp136=((($128))|0)==0;if(!($cmp136)){__label__=84;break $if_then128$$if_else132$64;}
var $129=HEAP32[((_option_sayas)>>2)];var $and138=($129)&16;var $cmp139=((($and138))|0)==0;if(!($cmp139)){__label__=74;break $if_then128$$if_else132$64;}
var $130=HEAP32[(($p)>>2)];var $add_ptr141=(($130+-1)&4294967295);var $call142=__Z7utf8_inPiPKc($letter,$add_ptr141);var $sub143=((($call142)-1)&4294967295);$n=$sub143;var $131=$tr_addr;var $letter_bits_offset144=(($131+964)&4294967295);var $132=HEAP32[(($letter_bits_offset144)>>2)];var $cmp145=((($132))|0)>0;if($cmp145){__label__=49;;}else{__label__=52;;}
$if_then146$$if_end155thread_pre_split$69:do{if(__label__==49){var $133=HEAP32[(($letter)>>2)];var $cmp147=((($133))|0)<=577;if($cmp147){__lastLabel__=49;;}else{__lastLabel__=49;__label__=53;break $if_then146$$if_end155thread_pre_split$69;}
var $134=HEAP32[(($letter)>>2)];var $call149=_iswalpha($134);var $tobool150=((($call149))|0)!=0;if($tobool150){__label__=51;break $while_cond$28;}else{__label__=52;break $if_then146$$if_end155thread_pre_split$69;}}}while(0);if(__label__==52){var $_pr7=HEAP32[(($letter)>>2)];__lastLabel__=52;;}
var $138=__lastLabel__==52?$_pr7:($133);var $cmp156=((($138))|0)==57384;if($cmp156){__label__=54;;}else{__label__=56;;}
$if_then157$$if_end166$75:do{if(__label__==54){var $139=HEAP32[((_pre_pause)>>2)];var $140=$tr_addr;var $langopts158=(($140)&4294967295);var $param2=(($langopts158+100)&4294967295);var $arrayidx159=(($param2+64)&4294967295);var $141=HEAP32[(($arrayidx159)>>2)];var $cmp160=((($139))|0)<((($141))|0);if(!($cmp160)){__label__=56;break $if_then157$$if_end166$75;}
var $142=$tr_addr;var $langopts162=(($142)&4294967295);var $param2163=(($langopts162+100)&4294967295);var $arrayidx164=(($param2163+64)&4294967295);var $143=HEAP32[(($arrayidx164)>>2)];HEAP32[((_pre_pause)>>2)]=$143;;}}while(0);var $144=HEAP32[(($letter)>>2)];var $call167=__Z9IsBracketi($144);var $tobool168=((($call167))|0)!=0;if($tobool168){__label__=57;;}else{__label__=59;;}
$if_then169$$if_end178$79:do{if(__label__==57){var $145=HEAP32[((_pre_pause)>>2)];var $146=$tr_addr;var $langopts170=(($146)&4294967295);var $param=(($langopts170+24)&4294967295);var $arrayidx171=(($param+64)&4294967295);var $147=HEAP32[(($arrayidx171)>>2)];var $cmp172=((($145))|0)<((($147))|0);if(!($cmp172)){__label__=59;break $if_then169$$if_end178$79;}
var $148=$tr_addr;var $langopts174=(($148)&4294967295);var $param175=(($langopts174+24)&4294967295);var $arrayidx176=(($param175+64)&4294967295);var $149=HEAP32[(($arrayidx176)>>2)];HEAP32[((_pre_pause)>>2)]=$149;;}}while(0);var $150=HEAP32[(($letter)>>2)];var $cmp179=((($150))|0)>=192;var $151=HEAP32[(($letter)>>2)];var $cmp181=((($151))|0)<606;var $or_cond=($cmp179)&($cmp181);if($or_cond){__label__=60;;}else{__label__=71;;}
$land_lhs_true182$$if_else223$83:do{if(__label__==60){var $152=HEAP32[(($letter)>>2)];var $sub183=((($152)-192)&4294967295);var $arrayidx184=((__ZL13remove_accent+$sub183)&4294967295);var $153=HEAPU8[($arrayidx184)];var $conv185=((($153))&255);$ix=$conv185;var $cmp186=((($conv185))|0)!=0;if(!($cmp186)){__label__=71;break $land_lhs_true182$$if_else223$83;}
var $154=HEAP32[(($p)>>2)];var $arrayidx188=(($154+-2)&4294967295);var $155=HEAP8[($arrayidx188)];var $conv189=(tempInt=(($155)),(tempInt>=128?tempInt-256:tempInt));var $cmp190=((($conv189))|0)!=32;if($cmp190){__label__=63;;}else{__label__=62;;}
if(__label__==62){var $156=$n;var $157=HEAP32[(($p)>>2)];var $arrayidx192=(($157+$156)&4294967295);var $158=HEAP8[($arrayidx192)];var $conv193=(tempInt=(($158)),(tempInt>=128?tempInt-256:tempInt));var $cmp194=((($conv193))|0)!=32;if(!($cmp194)){__label__=74;break $if_then128$$if_else132$64;}}
var $159=HEAP32[(($p)>>2)];var $add_ptr196=(($159+-1)&4294967295);HEAP32[(($p2)>>2)]=$add_ptr196;var $160=$ix;var $conv197=((($160))&255);var $161=HEAP32[(($p)>>2)];var $arrayidx198=(($161+-1)&4294967295);HEAP8[($arrayidx198)]=$conv197;var $162=$n;var $163=HEAP32[(($p)>>2)];var $arrayidx20011=(($163+$162)&4294967295);var $164=HEAP8[($arrayidx20011)];var $165=HEAP32[(($p)>>2)];var $arrayidx20112=(($165)&4294967295);HEAP8[($arrayidx20112)]=$164;var $conv20213=(tempInt=(($164)),(tempInt>=128?tempInt-256:tempInt));var $cmp20314=((($conv20213))|0)!=32;if($cmp20314){__label__=64;;}else{__label__=65;;}
$while_body204$$while_cond205_loopexit$89:do{if(__label__==64){while(1){var $166=HEAP32[(($p)>>2)];var $incdec_ptr=(($166+1)&4294967295);HEAP32[(($p)>>2)]=$incdec_ptr;var $167=$n;var $168=HEAP32[(($p)>>2)];var $arrayidx200=(($168+$167)&4294967295);var $169=HEAP8[($arrayidx200)];var $170=HEAP32[(($p)>>2)];var $arrayidx201=(($170)&4294967295);HEAP8[($arrayidx201)]=$169;var $conv202=(tempInt=(($169)),(tempInt>=128?tempInt-256:tempInt));var $cmp203=((($conv202))|0)!=32;if($cmp203){__label__=64;continue;}else{__label__=65;break $while_body204$$while_cond205_loopexit$89;}}}}while(0);var $171=$n;var $dec15=((($171)-1)&4294967295);$n=$dec15;var $cmp20616=((($171))|0)>0;if($cmp20616){__label__=66;;}else{__label__=67;;}
$while_body207$$while_end209$93:do{if(__label__==66){while(1){var $172=HEAP32[(($p)>>2)];var $incdec_ptr208=(($172+1)&4294967295);HEAP32[(($p)>>2)]=$incdec_ptr208;HEAP8[($172)]=32;var $173=$n;var $dec=((($173)-1)&4294967295);$n=$dec;var $cmp206=((($173))|0)>0;if($cmp206){__label__=66;continue;}else{__label__=67;break $while_body207$$while_end209$93;}}}}while(0);var $174=$tr_addr;var $langopts210=(($174)&4294967295);var $param211=(($langopts210+24)&4294967295);var $arrayidx212=(($param211+4)&4294967295);var $175=HEAP32[(($arrayidx212)>>2)];var $tobool213=((($175))|0)!=0;if($tobool213){__label__=68;;}else{__label__=70;;}
$land_lhs_true214$$if_end218$97:do{if(__label__==68){var $176=HEAP32[(($letter)>>2)];var $call215=__Z11lookupwcharPKti(((__ZL13diereses_list)&4294967295),$176);var $cmp216=((($call215))|0)>0;if(!($cmp216)){__label__=70;break $land_lhs_true214$$if_end218$97;}
var $177=HEAP32[(($p2)>>2)];HEAP32[(($p)>>2)]=$177;__label__=20;continue $while_cond$28;}}while(0);var $178=$phonemes_addr;var $arrayidx219=(($178)&4294967295);HEAP8[($arrayidx219)]=0;var $179=$p_start_addr;HEAP32[(($p)>>2)]=$179;var $180=$tr_addr;var $word_vowel_count220=(($180+8296)&4294967295);HEAP32[(($word_vowel_count220)>>2)]=0;var $181=$tr_addr;var $word_stressed_count221=(($181+8300)&4294967295);HEAP32[(($word_stressed_count221)>>2)]=0;__label__=20;continue $while_cond$28;}}while(0);var $182=HEAP32[(($letter)>>2)];var $cmp224=((($182))|0)>=12800;var $183=HEAP32[(($letter)>>2)];var $cmp226=((($183))|0)<42752;var $or_cond1=($cmp224)&($cmp226);if(!($or_cond1)){__label__=74;break $if_then128$$if_else132$64;}
var $184=$end_phonemes_addr;var $cmp228=((($184))|0)!=0;if(!($cmp228)){__label__=74;break $if_then128$$if_else132$64;}
var $185=$tr_addr;var $call231=__Z6LookupP10TranslatorPKcPc($185,((__str9306)&4294967295),$arraydecay230);HEAP32[(($phonemes233)>>2)]=$arraydecay232;HEAP32[(($points234)>>2)]=1;var $186=$wc_bytes;var $sub235=((($186)-1)&4294967295);var $187=HEAP32[(($p)>>2)];var $add_ptr236=(($187+$sub235)&4294967295);HEAP32[(($p)>>2)]=$add_ptr236;__label__=74;break $if_then128$$if_else132$64;}}while(0);$if_end240$$if_else278$104:do{if(__label__==74){var $_pr17=HEAP32[(($points241)>>2)];var $cmp242=((($_pr17))|0)==0;if(!($cmp242)){__label__=84;break $if_end240$$if_else278$104;}
var $188=HEAP32[(($wc)>>2)];var $cmp244=((($188))|0)>=768;var $189=HEAP32[(($wc)>>2)];var $cmp246=((($189))|0)<=879;var $or_cond2=($cmp244)&($cmp246);if($or_cond2){__label__=83;;}else{__label__=76;;}
$if_end275$$if_else248$107:do{if(__label__==76){var $190=HEAP32[(($wc)>>2)];var $call249=__Z7IsAlphaj($190);var $tobool250=((($call249))|0)!=0;if($tobool250){__label__=77;;}else{__label__=81;;}
if(__label__==77){var $191=$any_alpha;var $cmp252=((($191))|0)>1;if($cmp252){__label__=79;break $while_cond$28;}
var $192=$wc_bytes;var $sub254=((($192)-1)&4294967295);var $193=HEAP32[(($p)>>2)];var $arrayidx255=(($193+$sub254)&4294967295);var $194=HEAP8[($arrayidx255)];var $conv256=(tempInt=(($194)),(tempInt>=128?tempInt-256:tempInt));var $cmp257=((($conv256))|0)>32;if($cmp257){__label__=79;break $while_cond$28;}}
else if(__label__==81){var $199=$tr_addr;var $200=HEAP32[(($wc)>>2)];__Z12LookupLetterP10TranslatorjiPci($199,$200,-1,$arraydecay266,0);var $201=HEAP8[($arrayidx267)];var $tobool268=(tempInt=(($201)),(tempInt>=128?tempInt-256:tempInt))!=0;if(!($tobool268)){__label__=83;break $if_end275$$if_else248$107;}
HEAP32[(($phonemes271)>>2)]=$arraydecay270;HEAP32[(($points272)>>2)]=1;;}}}while(0);var $202=$wc_bytes;var $sub276=((($202)-1)&4294967295);var $203=HEAP32[(($p)>>2)];var $add_ptr277=(($203+$sub276)&4294967295);HEAP32[(($p)>>2)]=$add_ptr277;__label__=85;break $if_end281$$if_end81$48;}}while(0);var $204=$tr_addr;var $phonemes_repeat_count=(($204+652)&4294967295);HEAP32[(($phonemes_repeat_count)>>2)]=0;;}}while(0);var $205=HEAP32[(($phonemes282)>>2)];var $cmp283=((($205))|0)==0;if($cmp283){__label__=86;;}else{__label__=87;;}
if(__label__==86){HEAP32[(($phonemes285)>>2)]=((__str13643)&4294967295);;}
var $206=HEAP32[(($points287)>>2)];var $cmp288=((($206))|0)>0;if(!($cmp288)){__label__=20;continue $while_cond$28;}
var $207=$word_flags_addr;var $and290=($207)&-2147483648;var $tobool291=((($and290))|0)!=0;if($tobool291){__label__=89;break $while_cond$28;}
var $209=HEAP32[(($phonemes295)>>2)];var $arrayidx296=(($209)&4294967295);var $210=HEAP8[($arrayidx296)];var $conv297=(tempInt=(($210)),(tempInt>=128?tempInt-256:tempInt));var $cmp298=((($conv297))|0)==21;if($cmp298){__label__=91;;}else{__label__=93;;}
if(__label__==91){var $211=$word_flags_addr;var $and300=($211)&4096;var $cmp301=((($and300))|0)==0;if($cmp301){__label__=92;break $while_cond$28;}}
var $214=HEAP32[(($end_type306)>>2)];var $and307=($214)&-32769;HEAP32[(($end_type306)>>2)]=$and307;var $cmp309=((($and307))|0)!=0;if($cmp309){__label__=94;;}else{__label__=101;;}
$land_lhs_true310$$if_end339$125:do{if(__label__==94){var $215=$end_phonemes_addr;var $cmp311=((($215))|0)!=0;if(!($cmp311)){__label__=101;break $land_lhs_true310$$if_end339$125;}
var $216=HEAP32[(($end_type313)>>2)];var $and314=($216)&1024;var $tobool315=((($and314))|0)!=0;if(!($tobool315)){__label__=97;break $while_cond$28;}
var $217=$word_flags_addr;var $and317=($217)&536870912;var $tobool318=((($and317))|0)!=0;if(!($tobool318)){__label__=97;break $while_cond$28;}}}while(0);var $227=HEAP32[(($del_fwd)>>2)];var $cmp340=((($227))|0)!=0;if($cmp340){__label__=102;;}else{__label__=103;;}
if(__label__==102){var $228=HEAP32[(($del_fwd342)>>2)];HEAP8[($228)]=69;;}
var $229=$tr_addr;var $230=$phonemes_addr;var $231=$ph_size_addr;var $232=HEAP32[(($phonemes344)>>2)];__Z14AppendPhonemesP10TranslatorPciPKc($229,$230,$231,$232);__label__=20;continue $while_cond$28;}
$while_end346$$if_then292$$if_then302$$if_else320$$if_then258$$if_then151$133:do{if(__label__==89){var $end_type=(($match1+8)&4294967295);var $208=HEAP32[(($end_type)>>2)];var $or293=($208)|1;$retval=$or293;__label__=105;break $if_then$$if_end$2;}
else if(__label__==92){var $212=$phonemes_addr;var $phonemes303=(($match1+4)&4294967295);var $213=HEAP32[(($phonemes303)>>2)];var $call304=_strcpy($212,$213);$retval=0;__label__=105;break $if_then$$if_end$2;}
else if(__label__==97){var $end_type321=(($match1+8)&4294967295);var $218=HEAP32[(($end_type321)>>2)];var $and322=($218)&1024;var $tobool323=((($and322))|0)!=0;if($tobool323){__label__=98;;}else{__label__=100;;}
$land_lhs_true324$$if_end331$137:do{if(__label__==98){var $end_type325=(($match1+8)&4294967295);var $219=HEAP32[(($end_type325)>>2)];var $and326=($219)&127;var $cmp327=((($and326))|0)==0;if(!($cmp327)){__label__=100;break $land_lhs_true324$$if_end331$137;}
var $220=HEAP32[(($p)>>2)];var $221=$p_start_addr;var $sub_ptr_lhs_cast=($220);var $sub_ptr_rhs_cast=($221);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $end_type329=(($match1+8)&4294967295);var $222=HEAP32[(($end_type329)>>2)];var $or330=($sub_ptr_sub)|($222);HEAP32[(($end_type329)>>2)]=$or330;;}}while(0);var $223=$end_phonemes_addr;var $phonemes332=(($match1+4)&4294967295);var $224=HEAP32[(($phonemes332)>>2)];var $call333=_strcpy($223,$224);var $225=$p_start_addr;var $arraydecay334=(($word_copy)&4294967295);var $arraydecay335=(($word_copy)&4294967295);var $call336=_strlen($arraydecay335);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$arraydecay334;$dest$=$225;$stop$=$src$+$call336;if(($dest$%4)==($src$%4)&&$call336>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $end_type337=(($match1+8)&4294967295);var $226=HEAP32[(($end_type337)>>2)];$retval=$226;__label__=105;break $if_then$$if_end$2;}
else if(__label__==79){var $195=$phonemes_addr;var $arrayidx259=(($195)&4294967295);HEAP8[($arrayidx259)]=0;var $196=$dict_flags_addr;var $cmp260=((($196))|0)!=0;if(!($cmp260)){__label__=104;break $while_end346$$if_then292$$if_then302$$if_else320$$if_then258$$if_then151$133;}
var $197=$dict_flags_addr;var $arrayidx262=(($197)&4294967295);var $198=HEAP32[(($arrayidx262)>>2)];var $or=($198)|65536;HEAP32[(($arrayidx262)>>2)]=$or;;}
else if(__label__==51){var $135=$phonemes_addr;var $136=$tr_addr;var $langopts152=(($136)&4294967295);var $ascii_language=(($langopts152+268)&4294967295);var $137=HEAP32[(($ascii_language)>>2)];var $call153=_sprintf($135,((__str70722)&4294967295),allocate([21,0,0,0,$137,0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));$retval=0;__label__=105;break $if_then$$if_end$2;}}while(0);var $233=$tr_addr;var $234=$phonemes_addr;var $235=$dict_flags0;__Z21ApplySpecialAttributeP10TranslatorPci($233,$234,$235);var $236=$p_start_addr;var $arraydecay347=(($word_copy)&4294967295);var $arraydecay348=(($word_copy)&4294967295);var $call349=_strlen($arraydecay348);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$arraydecay347;$dest$=$236;$stop$=$src$+$call349;if(($dest$%4)==($src$%4)&&$call349>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};$retval=0;;}}while(0);var $237=$retval;STACKTOP=__stackBase__;return $237;return null;}
function __Z6LookupP10TranslatorPKcPc($tr,$word,$ph_out){var __stackBase__=STACKTOP;STACKTOP+=12;_memset(__stackBase__,0,12);var __label__;var $tr_addr;var $word_addr;var $ph_out_addr;var $flags=__stackBase__;var $word1=__stackBase__+8;$tr_addr=$tr;$word_addr=$word;$ph_out_addr=$ph_out;var $arrayidx=(($flags+4)&4294967295);HEAP32[(($arrayidx)>>2)]=0;var $arrayidx1=(($flags)&4294967295);HEAP32[(($arrayidx1)>>2)]=0;var $0=$word_addr;HEAP32[(($word1)>>2)]=$0;var $1=$tr_addr;var $2=$ph_out_addr;var $arraydecay=(($flags)&4294967295);var $call=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($1,$word1,$2,$arraydecay,0,0);STACKTOP=__stackBase__;return $call;return null;}
function __ZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordii($tr,$word,$word_start,$group_length,$rule,$match_out,$word_flags,$dict_flags){var __stackBase__=STACKTOP;STACKTOP+=264;_memset(__stackBase__,0,264);var __label__;var __lastLabel__=null;var $tr_addr;var $word_addr;var $word_start_addr;var $group_length_addr;var $rule_addr;var $match_out_addr;var $word_flags_addr;var $dict_flags_addr;var $rb;var $letter;var $letter_w=__stackBase__;var $letter_xbytes;var $last_letter;var $pre_ptr;var $post_ptr;var $rule_start;var $p;var $ix;var $match_type;var $failed;var $unpron_ignore;var $consumed;var $syllable_count;var $vowel;var $letter_group;var $distance_right;var $distance_left;var $lg_pts;var $n_bytes;var $add_points;var $command;var $check_atstart;var $match=__stackBase__+4;var $total_consumed;var $condition_num;var $common_phonemes;var $group_chars;var $word_buf=__stackBase__+20;var $p222;var $vowel_count;var $p252;var $p269;var $p2;var $rule_w=__stackBase__+180;var $p419;var $pts;var $decoded_phonemes=__stackBase__+184;$tr_addr=$tr;$word_addr=$word;$word_start_addr=$word_start;$group_length_addr=$group_length;$rule_addr=$rule;$match_out_addr=$match_out;$word_flags_addr=$word_flags;$dict_flags_addr=$dict_flags;var $0=$word_addr;var $1=HEAP32[(($0)>>2)];$group_chars=$1;var $2=$rule_addr;var $cmp=((($2))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $3=$match_out_addr;var $points=(($3)&4294967295);HEAP32[(($points)>>2)]=0;var $4=$word_addr;var $5=HEAP32[(($4)>>2)];var $incdec_ptr=(($5+1)&4294967295);HEAP32[(($4)>>2)]=$incdec_ptr;;}
else if(__label__==2){$total_consumed=0;$common_phonemes=0;$match_type=0;HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best)&4294967295))>>2)]=0;HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best+4)&4294967295))>>2)]=((__str13643)&4294967295);HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best+8)&4294967295))>>2)]=0;HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best+12)&4294967295))>>2)]=0;var $6=$rule_addr;var $7=HEAP8[($6)];var $conv22=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $cmp123=((($conv22))|0)!=7;if($cmp123){__label__=3;;}else{__label__=198;;}
$while_body_lr_ph$$while_end549$5:do{if(__label__==3){var $points2=(($match)&4294967295);var $end_type=(($match+8)&4294967295);var $del_fwd=(($match+12)&4294967295);var $points518=(($match)&4294967295);var $8=$match;var $points524=(($match)&4294967295);var $points530=(($match)&4294967295);var $phonemes535=(($match+4)&4294967295);var $arraydecay536=(($decoded_phonemes)&4294967295);var $arraydecay538=(($decoded_phonemes)&4294967295);var $points515=(($match)&4294967295);var $phonemes=(($match+4)&4294967295);var $phonemes13=(($match+4)&4294967295);var $phonemes23=(($match+4)&4294967295);var $phonemes29=(($match+4)&4294967295);var $phonemes32=(($match+4)&4294967295);var $phonemes43=(($match+4)&4294967295);var $points66=(($match)&4294967295);var $points499=(($match)&4294967295);var $end_type171=(($match+8)&4294967295);var $arraydecay=(($word_buf)&4294967295);var $arrayidx195=(($word_buf+1)&4294967295);var $del_fwd291=(($match+12)&4294967295);var $end_type307=(($match+8)&4294967295);;$while_body$7:while(1){var $11=$word_flags_addr;var $and=($11)&-2147483648;$unpron_ignore=$and;$match_type=0;$consumed=0;$letter=0;$distance_right=-6;$distance_left=-2;$check_atstart=0;HEAP32[(($points2)>>2)]=1;HEAP32[(($end_type)>>2)]=0;HEAP32[(($del_fwd)>>2)]=0;var $12=$word_addr;var $13=HEAP32[(($12)>>2)];$pre_ptr=$13;var $14=$word_addr;var $15=HEAP32[(($14)>>2)];var $16=$group_length_addr;var $add_ptr=(($15+$16)&4294967295);$post_ptr=$add_ptr;var $17=$rule_addr;$rule_start=$17;$failed=0;var $18=$failed;var $tobool20=((($18))|0)!=0;var $lnot21=($tobool20)^1;if($lnot21){__lastLabel__=5;__label__=6;;}else{__lastLabel__=5;__label__=183;;}
$while_body4$$while_end502$9:do{if(__label__==6){$while_body4$10:while(1){var $19=$rule_addr;var $incdec_ptr5=(($19+1)&4294967295);$rule_addr=$incdec_ptr5;var $20=HEAP8[($19)];$rb=$20;var $21=$rb;var $conv6=((($21))&255);var $cmp7=((($conv6))|0)<=9;if($cmp7){__label__=7;;}else{__label__=33;;}
$if_then8$$if_end70$12:do{if(__label__==7){var $22=$rb;var $conv9=((($22))&255);if($conv9==0){__label__=8;;}
else if($conv9==8){__label__=18;;}
else if($conv9==1){__label__=19;;}
else if($conv9==2){__label__=21;;}
else if($conv9==3){__label__=22;;}
else if($conv9==4){__label__=23;;}
else if($conv9==5){__label__=24;;}
else if($conv9==9){__label__=32;;}
else{__label__=30;break $if_then8$$if_end70$12;}
if(__label__==8){var $23=$common_phonemes;var $cmp10=((($23))|0)!=0;if($cmp10){__label__=9;;}else{__label__=16;;}
$if_then11$$if_else$16:do{if(__label__==9){var $24=$common_phonemes;HEAP32[(($phonemes)>>2)]=$24;;while(1){var $25=HEAP32[(($phonemes13)>>2)];var $incdec_ptr14=(($25+1)&4294967295);HEAP32[(($phonemes13)>>2)]=$incdec_ptr14;var $26=HEAPU8[($25)];$rb=$26;var $conv15=((($26))&255);var $cmp16=((($conv15))|0)!=0;if(!($cmp16)){__label__=17;break $if_then11$$if_else$16;}
var $27=$rb;var $conv17=((($27))&255);var $cmp18=((($conv17))|0)!=3;if(!($cmp18)){__label__=17;break $if_then11$$if_else$16;}
var $28=$rb;var $conv20=((($28))&255);var $cmp21=((($conv20))|0)==5;if($cmp21){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $29=HEAP32[(($phonemes23)>>2)];var $incdec_ptr24=(($29+1)&4294967295);HEAP32[(($phonemes23)>>2)]=$incdec_ptr24;;}
var $30=$rb;var $conv26=((($30))&255);var $cmp27=((($conv26))|0)==9;if(!($cmp27)){__label__=10;continue;}
var $31=HEAP32[(($phonemes29)>>2)];var $add_ptr30=(($31+2)&4294967295);HEAP32[(($phonemes29)>>2)]=$add_ptr30;__label__=10;continue;}}
else if(__label__==16){HEAP32[(($phonemes32)>>2)]=((__str13643)&4294967295);;}}while(0);var $32=$rule_addr;var $incdec_ptr34=(($32+-1)&4294967295);$rule_addr=$incdec_ptr34;$failed=2;;}
else if(__label__==18){$check_atstart=1;$unpron_ignore=0;$match_type=1;;}
else if(__label__==19){$match_type=1;var $33=$word_flags_addr;var $and37=($33)&-2147483648;var $tobool38=((($and37))|0)!=0;if(!($tobool38)){__label__=30;break $if_then8$$if_end70$12;}
$failed=1;;}
else if(__label__==21){$match_type=2;;}
else if(__label__==22){var $34=$rule_addr;HEAP32[(($phonemes43)>>2)]=$34;$failed=2;;}
else if(__label__==23){var $35=$rule_addr;$common_phonemes=$35;;}
else if(__label__==24){var $36=$rule_addr;var $incdec_ptr46=(($36+1)&4294967295);$rule_addr=$incdec_ptr46;var $37=HEAP8[($36)];$condition_num=$37;var $38=$condition_num;var $conv47=((($38))&255);var $cmp48=((($conv47))|0)>=32;var $39=$tr_addr;var $dict_condition=(($39+692)&4294967295);var $40=HEAP32[(($dict_condition)>>2)];var $41=$condition_num;var $conv50=((($41))&255);if($cmp48){__label__=25;;}else{__label__=27;;}
$if_then49$$if_else55$35:do{if(__label__==25){var $sub=((($conv50)-32)&4294967295);var $shl=1<<($sub);var $and51=($shl)&($40);var $cmp52=((($and51))|0)!=0;if(!($cmp52)){__label__=29;break $if_then49$$if_else55$35;}
$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==27){var $shl58=1<<($conv50);var $and59=($shl58)&($40);var $cmp60=((($and59))|0)==0;if(!($cmp60)){__label__=29;break $if_then49$$if_else55$35;}
$failed=1;__label__=30;break $if_then8$$if_end70$12;}}while(0);var $_pr=$failed;var $tobool64=((($_pr))|0)!=0;if($tobool64){__label__=30;break $if_then8$$if_end70$12;}
var $43=HEAP32[(($points66)>>2)];var $inc=((($43)+1)&4294967295);HEAP32[(($points66)>>2)]=$inc;;}
else if(__label__==32){var $44=$rule_addr;var $add_ptr69=(($44+2)&4294967295);$rule_addr=$add_ptr69;;}}
else if(__label__==33){$add_points=0;var $45=$match_type;if($45==0){__label__=34;;}
else if($45==2){__label__=41;;}
else if($45==1){__label__=119;;}
else{__label__=181;;}
$sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44:do{if(__label__==34){var $46=$letter;$last_letter=$46;var $47=$post_ptr;var $incdec_ptr72=(($47+1)&4294967295);$post_ptr=$incdec_ptr72;var $48=HEAP8[($47)];$letter=$48;var $49=$letter;var $conv73=((($49))&255);var $50=$rb;var $conv74=((($50))&255);var $cmp75=((($conv73))|0)==((($conv74))|0);if($cmp75){__label__=37;;}else{__label__=35;;}
$if_then80$$lor_lhs_false$46:do{if(__label__==35){var $51=$letter;var $conv76=((($51))&255);var $cmp77=((($conv76))|0)==69;if($cmp77){__label__=36;;}else{__label__=40;;}
if(__label__==36){var $52=$rb;var $conv78=((($52))&255);var $cmp79=((($conv78))|0)==101;if($cmp79){__label__=37;break $if_then80$$lor_lhs_false$46;}}
$failed=1;__label__=30;break $if_then8$$if_end70$12;}}while(0);var $53=$letter;var $conv81=((($53))&255);var $and82=($conv81)&192;var $cmp83=((($and82))|0)!=128;if($cmp83){__label__=38;;}else{__label__=39;;}
if(__label__==38){$add_points=21;;}
var $54=$consumed;var $inc86=((($54)+1)&4294967295);$consumed=$inc86;;}
else if(__label__==41){var $55=$distance_right;var $add=((($55)+6)&4294967295);$distance_right=$add;var $56=$distance_right;var $cmp90=((($56))|0)>18;if($cmp90){__label__=42;;}else{__label__=43;;}
if(__label__==42){$distance_right=19;;}
var $57=$letter;$last_letter=$57;var $58=$post_ptr;var $call=__Z7utf8_inPiPKc($letter_w,$58);var $sub93=((($call)-1)&4294967295);$letter_xbytes=$sub93;var $59=$post_ptr;var $incdec_ptr94=(($59+1)&4294967295);$post_ptr=$incdec_ptr94;var $60=HEAP8[($59)];$letter=$60;var $61=$rb;var $conv95=((($61))&255);if($conv95==17){__label__=44;;}
else if($conv95==18){__label__=49;;}
else if($conv95==25){__label__=52;;}
else if($conv95==15){__label__=57;;}
else if($conv95==16){__label__=62;;}
else if($conv95==11){__label__=65;;}
else if($conv95==28){__label__=68;;}
else if($conv95==45){__label__=78;;}
else if($conv95==21){__label__=83;;}
else if($conv95==29){__label__=94;;}
else if($conv95==23){__label__=101;;}
else if($conv95==12){__label__=105;;}
else if($conv95==13){__label__=106;;}
else if($conv95==14){__label__=111;;}
else if($conv95==24){__label__=112;;}
else{__label__=115;;}
if(__label__==115){var $186=$letter;var $conv315=((($186))&255);var $187=$rb;var $conv316=((($187))&255);var $cmp317=((($conv315))|0)==((($conv316))|0);if($cmp317){__label__=116;;}else{__label__=118;;}
if(__label__==116){var $188=$letter;var $conv319=((($188))&255);var $and320=($conv319)&192;var $cmp321=((($and320))|0)!=128;if(!($cmp321)){__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}
var $189=$distance_right;var $sub323=((21-($189))&4294967295);$add_points=$sub323;;}
else if(__label__==118){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==44){var $62=$rule_addr;var $incdec_ptr97=(($62+1)&4294967295);$rule_addr=$incdec_ptr97;var $63=HEAP8[($62)];var $conv98=(tempInt=(($63)),(tempInt>=128?tempInt-256:tempInt));var $sub99=((($conv98)-65)&4294967295);$letter_group=$sub99;var $64=$tr_addr;var $65=HEAP32[(($letter_w)>>2)];var $66=$letter_group;var $call100=__ZL8IsLetterP10Translatorii($64,$65,$66);var $tobool101=((($call100))|0)!=0;if($tobool101){__label__=45;;}else{__label__=48;;}
if(__label__==45){$lg_pts=20;var $67=$letter_group;var $cmp103=((($67))|0)==2;if($cmp103){__label__=46;;}else{__label__=47;;}
if(__label__==46){$lg_pts=19;;}
var $68=$lg_pts;var $69=$distance_right;var $sub106=((($68)-($69))&4294967295);$add_points=$sub106;var $70=$letter_xbytes;var $71=$post_ptr;var $add_ptr107=(($71+$70)&4294967295);$post_ptr=$add_ptr107;;}
else if(__label__==48){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==49){var $72=$rule_addr;var $incdec_ptr111=(($72+1)&4294967295);$rule_addr=$incdec_ptr111;var $73=HEAP8[($72)];var $conv112=(tempInt=(($73)),(tempInt>=128?tempInt-256:tempInt));var $sub113=((($conv112)-65)&4294967295);$letter_group=$sub113;var $74=$tr_addr;var $75=$post_ptr;var $add_ptr114=(($75+-1)&4294967295);var $76=$letter_group;var $call115=__ZL13IsLetterGroupP10TranslatorPcii($74,$add_ptr114,$76,0);$n_bytes=$call115;var $cmp116=((($call115))|0)>0;if($cmp116){__label__=50;;}else{__label__=51;;}
if(__label__==50){var $77=$distance_right;var $sub118=((20-($77))&4294967295);$add_points=$sub118;var $78=$n_bytes;var $sub119=((($78)-1)&4294967295);var $79=$post_ptr;var $add_ptr120=(($79+$sub119)&4294967295);$post_ptr=$add_ptr120;;}
else if(__label__==51){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==52){var $80=$tr_addr;var $81=HEAP32[(($letter_w)>>2)];var $call124=__ZL8IsLetterP10Translatorii($80,$81,0);var $tobool125=((($call124))|0)!=0;if($tobool125){__label__=55;;}else{__label__=53;;}
$if_then131$$lor_lhs_false126$77:do{if(__label__==53){var $82=HEAP32[(($letter_w)>>2)];var $cmp127=((($82))|0)==32;if($cmp127){__label__=54;;}else{__label__=56;;}
if(__label__==54){var $83=$word_flags_addr;var $and129=($83)&134217728;var $tobool130=((($and129))|0)!=0;if($tobool130){__label__=55;break $if_then131$$lor_lhs_false126$77;}}
var $84=$distance_right;var $sub133=((20-($84))&4294967295);$add_points=$sub133;var $85=$letter_xbytes;var $86=$post_ptr;var $add_ptr134=(($86+$85)&4294967295);$post_ptr=$add_ptr134;__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}}while(0);$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==57){var $87=HEAP32[(($letter_w)>>2)];var $call137=__Z7IsDigitj($87);var $tobool138=((($call137))|0)!=0;if($tobool138){__label__=58;;}else{__label__=59;;}
if(__label__==58){var $88=$distance_right;var $sub140=((20-($88))&4294967295);$add_points=$sub140;var $89=$letter_xbytes;var $90=$post_ptr;var $add_ptr141=(($90+$89)&4294967295);$post_ptr=$add_ptr141;;}
else if(__label__==59){var $91=$tr_addr;var $langopts=(($91)&4294967295);var $tone_numbers=(($langopts+250)&4294967295);var $92=HEAP8[($tone_numbers)];var $tobool143=(tempInt=(($92)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool143){__label__=60;;}else{__label__=61;;}
if(__label__==60){var $93=$distance_right;var $sub145=((20-($93))&4294967295);$add_points=$sub145;var $94=$post_ptr;var $incdec_ptr146=(($94+-1)&4294967295);$post_ptr=$incdec_ptr146;;}
else if(__label__==61){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}}
else if(__label__==62){var $95=HEAP32[(($letter_w)>>2)];var $call151=_iswalpha($95);var $tobool152=((($call151))|0)!=0;if($tobool152){__label__=64;;}else{__label__=63;;}
if(__label__==64){$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==63){var $96=$distance_right;var $sub154=((21-($96))&4294967295);$add_points=$sub154;var $97=$letter_xbytes;var $98=$post_ptr;var $add_ptr155=(($98+$97)&4294967295);$post_ptr=$add_ptr155;;}}
else if(__label__==65){var $99=$letter;var $conv159=((($99))&255);var $100=$last_letter;var $conv160=((($100))&255);var $cmp161=((($conv159))|0)==((($conv160))|0);if($cmp161){__label__=66;;}else{__label__=67;;}
if(__label__==66){var $101=$distance_right;var $sub163=((21-($101))&4294967295);$add_points=$sub163;;}
else if(__label__==67){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==68){var $102=$rule_addr;var $incdec_ptr167=(($102+1)&4294967295);$rule_addr=$incdec_ptr167;var $103=HEAP8[($102)];var $conv168=(tempInt=(($103)),(tempInt>=128?tempInt-256:tempInt));$command=$conv168;var $104=$command;var $cmp169=((($104))|0)==1;if($cmp169){__label__=69;;}else{__label__=70;;}
if(__label__==69){HEAP32[(($end_type171)>>2)]=32768;;}
else if(__label__==70){var $105=$command;var $and173=($105)&240;var $cmp174=((($and173))|0)==16;if($cmp174){__label__=71;;}else{__label__=74;;}
if(__label__==71){var $106=$dict_flags_addr;var $107=$command;var $and176=($107)&15;var $add177=((($and176)+19)&4294967295);var $shl178=1<<($add177);var $and179=($shl178)&($106);var $tobool180=((($and179))|0)!=0;if($tobool180){__label__=72;;}else{__label__=73;;}
if(__label__==72){$add_points=23;;}
else if(__label__==73){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==74){var $108=$command;var $and185=($108)&240;var $cmp186=((($and185))|0)==32;if(!($cmp186)){__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}
var $109=$word_addr;var $110=HEAP32[(($109)>>2)];var $111=$word_start_addr;var $sub_ptr_lhs_cast=($110);var $sub_ptr_rhs_cast=($111);var $sub_ptr_rhs_cast_neg=(((-($sub_ptr_rhs_cast)))&4294967295);var $112=$consumed;var $113=$group_length_addr;var $sub_ptr_sub=((($sub_ptr_lhs_cast)+1)&4294967295);var $add188=((($sub_ptr_sub)+($112))&4294967295);var $add189=((($add188)+($sub_ptr_rhs_cast_neg))&4294967295);var $add190=((($add189)+($113))&4294967295);$ix=$add190;var $114=$word_start_addr;var $add_ptr191=(($114+-1)&4294967295);var $115=$ix;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$add_ptr191;$dest$=$arraydecay;$stop$=$src$+$115;if(($dest$%4)==($src$%4)&&$115>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $116=$ix;var $arrayidx192=(($word_buf+$116)&4294967295);HEAP8[($arrayidx192)]=32;var $117=$ix;var $add193=((($117)+1)&4294967295);var $arrayidx194=(($word_buf+$add193)&4294967295);HEAP8[($arrayidx194)]=0;var $118=$tr_addr;var $call196=__Z11LookupFlagsP10TranslatorPKc($118,$arrayidx195);var $119=$command;var $and197=($119)&15;var $add198=((($and197)+19)&4294967295);var $shl199=1<<($add198);var $and200=($shl199)&($call196);var $tobool201=((($and200))|0)!=0;if($tobool201){__label__=76;;}else{__label__=77;;}
if(__label__==76){$add_points=23;;}
else if(__label__==77){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}}}
else if(__label__==78){var $120=$letter;var $conv209=((($120))&255);var $cmp210=((($conv209))|0)==45;if($cmp210){__label__=81;;}else{__label__=79;;}
$if_then217$$lor_lhs_false211$113:do{if(__label__==79){var $121=$letter;var $conv212=((($121))&255);var $cmp213=((($conv212))|0)==32;if($cmp213){__label__=80;;}else{__label__=82;;}
if(__label__==80){var $122=$word_flags_addr;var $and215=($122)&16384;var $tobool216=((($and215))|0)!=0;if($tobool216){__label__=81;break $if_then217$$lor_lhs_false211$113;}}
$failed=1;__label__=30;break $if_then8$$if_end70$12;}}while(0);var $123=$distance_right;var $sub218=((22-($123))&4294967295);$add_points=$sub218;;}
else if(__label__==83){var $124=$post_ptr;var $125=$letter_xbytes;var $add_ptr223=(($124+$125)&4294967295);$p222=$add_ptr223;$vowel_count=0;$syllable_count=1;var $126=$rule_addr;var $127=HEAP8[($126)];var $conv22514=(tempInt=(($127)),(tempInt>=128?tempInt-256:tempInt));var $cmp22615=((($conv22514))|0)==21;if($cmp22615){__label__=84;;}else{__label__=85;;}
$while_body227$$while_end230$120:do{if(__label__==84){while(1){var $128=$rule_addr;var $incdec_ptr228=(($128+1)&4294967295);$rule_addr=$incdec_ptr228;var $129=$syllable_count;var $add229=((($129)+1)&4294967295);$syllable_count=$add229;var $130=$rule_addr;var $131=HEAP8[($130)];var $conv225=(tempInt=(($131)),(tempInt>=128?tempInt-256:tempInt));var $cmp226=((($conv225))|0)==21;if($cmp226){__label__=84;continue;}else{__label__=85;break $while_body227$$while_end230$120;}}}}while(0);$vowel=0;var $132=HEAP32[(($letter_w)>>2)];var $cmp23216=((($132))|0)!=32;if($cmp23216){__lastLabel__=85;__label__=87;;}else{__lastLabel__=85;__label__=91;;}
$while_body233$$while_end244$124:do{if(__label__==87){$while_body233$125:while(1){var $133=__lastLabel__==86?$_pr24:(0);var $cmp234=((($133))|0)==0;if($cmp234){__label__=88;;}else{__label__=90;;}
$land_lhs_true235$$if_end240$127:do{if(__label__==88){var $134=$tr_addr;var $135=HEAP32[(($letter_w)>>2)];var $call236=__ZL8IsLetterP10Translatorii($134,$135,7);var $tobool237=((($call236))|0)!=0;if(!($tobool237)){__label__=90;break $land_lhs_true235$$if_end240$127;}
var $136=$vowel_count;var $inc239=((($136)+1)&4294967295);$vowel_count=$inc239;;}}while(0);var $137=$tr_addr;var $138=HEAP32[(($letter_w)>>2)];var $call241=__ZL8IsLetterP10Translatorii($137,$138,7);$vowel=$call241;var $139=$p222;var $call242=__Z7utf8_inPiPKc($letter_w,$139);var $140=$p222;var $add_ptr243=(($140+$call242)&4294967295);$p222=$add_ptr243;var $141=HEAP32[(($letter_w)>>2)];var $cmp232=((($141))|0)!=32;if(!($cmp232)){__label__=91;break $while_body233$$while_end244$124;}
var $_pr24=$vowel;__lastLabel__=86;__label__=87;continue $while_body233$125;}}}while(0);var $142=$syllable_count;var $143=$vowel_count;var $cmp245=((($142))|0)<=((($143))|0);if($cmp245){__label__=92;;}else{__label__=93;;}
if(__label__==92){var $144=$syllable_count;var $145=$distance_right;var $_neg=(((-($145)))&4294967295);var $add247=((($144)+18)&4294967295);var $sub248=((($add247)+($_neg))&4294967295);$add_points=$sub248;;}
else if(__label__==93){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==94){var $146=$post_ptr;var $147=$letter_xbytes;var $add_ptr253=(($146+$147)&4294967295);$p252=$add_ptr253;;while(1){var $148=HEAP32[(($letter_w)>>2)];var $cmp255=((($148))|0)!=32;if(!($cmp255)){__label__=99;break;}
var $149=$tr_addr;var $150=HEAP32[(($letter_w)>>2)];var $call257=__ZL8IsLetterP10Translatorii($149,$150,7);var $tobool258=((($call257))|0)!=0;if($tobool258){__label__=97;break;}
var $151=$p252;var $call261=__Z7utf8_inPiPKc($letter_w,$151);var $152=$p252;var $add_ptr262=(($152+$call261)&4294967295);$p252=$add_ptr262;__label__=95;continue;}
if(__label__==99){var $_pr2=$failed;var $tobool264=((($_pr2))|0)!=0;if($tobool264){__label__=30;break $if_then8$$if_end70$12;}
var $153=$distance_right;var $sub266=((19-($153))&4294967295);$add_points=$sub266;;}
else if(__label__==97){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==101){var $154=$post_ptr;var $155=$letter_xbytes;var $add_ptr270=(($154+$155)&4294967295);$p269=$add_ptr270;var $156=$p269;$p2=$156;var $157=$rule_addr;var $call271=__Z7utf8_inPiPKc($rule_w,$157);var $158=HEAP32[(($letter_w)>>2)];var $159=HEAP32[(($rule_w)>>2)];var $cmp27317=((($158))|0)!=((($159))|0);var $160=HEAP32[(($letter_w)>>2)];var $cmp27518=((($160))|0)!=32;var $or_cond19=($cmp27317)&($cmp27518);if($or_cond19){__label__=102;;}else{__label__=103;;}
$while_body277$$while_end280$146:do{if(__label__==102){while(1){var $161=$p269;$p2=$161;var $162=$p269;var $call278=__Z7utf8_inPiPKc($letter_w,$162);var $163=$p269;var $add_ptr279=(($163+$call278)&4294967295);$p269=$add_ptr279;var $164=HEAP32[(($letter_w)>>2)];var $165=HEAP32[(($rule_w)>>2)];var $cmp273=((($164))|0)!=((($165))|0);var $166=HEAP32[(($letter_w)>>2)];var $cmp275=((($166))|0)!=32;var $or_cond=($cmp273)&($cmp275);if($or_cond){__label__=102;continue;}else{__label__=103;break $while_body277$$while_end280$146;}}}}while(0);var $167=HEAP32[(($letter_w)>>2)];var $168=HEAP32[(($rule_w)>>2)];var $cmp281=((($167))|0)==((($168))|0);if(!($cmp281)){__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}
var $169=$p2;$post_ptr=$169;;}
else if(__label__==105){$add_points=20;;}
else if(__label__==106){var $170=$word_addr;var $171=HEAP32[(($170)>>2)];var $172=$group_length_addr;var $add_ptr286=(($171+$172)&4294967295);$p=$add_ptr286;;while(1){var $173=$p;var $174=$post_ptr;var $cmp287=((($173))>>>0)<((($174))>>>0);if(!($cmp287)){__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}
var $175=$p;var $176=HEAP8[($175)];var $conv288=(tempInt=(($176)),(tempInt>=128?tempInt-256:tempInt));var $cmp289=((($conv288))|0)==101;var $177=$p;if($cmp289){__label__=109;break;}
var $incdec_ptr293=(($177+1)&4294967295);$p=$incdec_ptr293;__label__=107;continue;}
HEAP32[(($del_fwd291)>>2)]=$177;;}
else if(__label__==111){var $178=$rule_addr;var $arrayidx295=(($178)&4294967295);var $179=HEAP8[($arrayidx295)];var $conv296=(tempInt=(($179)),(tempInt>=128?tempInt-256:tempInt));var $shl297=((($conv296)*65536)&4294967295);var $180=$rule_addr;var $arrayidx298=(($180+1)&4294967295);var $181=HEAP8[($arrayidx298)];var $conv299=(tempInt=(($181)),(tempInt>=128?tempInt-256:tempInt));var $and300=($conv299)&127;var $shl301=((($and300)*256)&4294967295);var $182=$rule_addr;var $arrayidx303=(($182+2)&4294967295);var $183=HEAP8[($arrayidx303)];var $conv304=(tempInt=(($183)),(tempInt>=128?tempInt-256:tempInt));var $and305=($conv304)&127;var $add302=((($shl301)+($shl297))&4294967295);var $add306=((($add302)+($and305))&4294967295);HEAP32[(($end_type307)>>2)]=$add306;var $184=$rule_addr;var $add_ptr308=(($184+3)&4294967295);$rule_addr=$add_ptr308;;}
else if(__label__==112){var $185=$word_flags_addr;var $and310=($185)&8192;var $tobool311=((($and310))|0)!=0;if($tobool311){__label__=113;;}else{__label__=114;;}
if(__label__==113){$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==114){$add_points=1;;}}}
else if(__label__==119){var $190=$distance_left;var $add329=((($190)+2)&4294967295);$distance_left=$add329;var $191=$distance_left;var $cmp330=((($191))|0)>18;if($cmp330){__label__=120;;}else{__label__=121;;}
if(__label__==120){$distance_left=19;;}
var $192=$pre_ptr;var $193=HEAP8[($192)];$last_letter=$193;var $194=$pre_ptr;var $incdec_ptr333=(($194+-1)&4294967295);$pre_ptr=$incdec_ptr333;var $195=$pre_ptr;var $call334=__Z8utf8_in2PiPKci($letter_w,$195,1);var $sub335=((($call334)-1)&4294967295);$letter_xbytes=$sub335;var $196=$pre_ptr;var $197=HEAP8[($196)];$letter=$197;var $198=$rb;var $conv336=((($198))&255);if($conv336==17){__label__=122;;}
else if($conv336==18){__label__=127;;}
else if($conv336==25){__label__=130;;}
else if($conv336==11){__label__=133;;}
else if($conv336==15){__label__=136;;}
else if($conv336==16){__label__=139;;}
else if($conv336==21){__label__=142;;}
else if($conv336==10){__label__=147;;}
else if($conv336==29){__label__=150;;}
else if($conv336==26){__label__=157;;}
else if($conv336==19){__label__=160;;}
else if($conv336==46){__label__=163;;}
else if($conv336==45){__label__=170;;}
else{__label__=175;;}
if(__label__==175){var $268=$letter;var $conv478=((($268))&255);var $269=$rb;var $conv479=((($269))&255);var $cmp480=((($conv478))|0)==((($conv479))|0);if($cmp480){__label__=176;;}else{__label__=180;;}
if(__label__==176){var $270=$letter;var $conv482=((($270))&255);var $cmp483=((($conv482))|0)==32;if($cmp483){__label__=177;;}else{__label__=178;;}
if(__label__==177){$add_points=4;;}
else if(__label__==178){var $271=$letter;var $conv486=((($271))&255);var $and487=($conv486)&192;var $cmp488=((($and487))|0)!=128;if(!($cmp488)){__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}
var $272=$distance_left;var $sub490=((21-($272))&4294967295);$add_points=$sub490;;}}
else if(__label__==180){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==122){var $199=$rule_addr;var $incdec_ptr338=(($199+1)&4294967295);$rule_addr=$incdec_ptr338;var $200=HEAP8[($199)];var $conv339=(tempInt=(($200)),(tempInt>=128?tempInt-256:tempInt));var $sub340=((($conv339)-65)&4294967295);$letter_group=$sub340;var $201=$tr_addr;var $202=HEAP32[(($letter_w)>>2)];var $203=$letter_group;var $call341=__ZL8IsLetterP10Translatorii($201,$202,$203);var $tobool342=((($call341))|0)!=0;if($tobool342){__label__=123;;}else{__label__=126;;}
if(__label__==123){$lg_pts=20;var $204=$letter_group;var $cmp344=((($204))|0)==2;if($cmp344){__label__=124;;}else{__label__=125;;}
if(__label__==124){$lg_pts=19;;}
var $205=$lg_pts;var $206=$distance_left;var $sub347=((($205)-($206))&4294967295);$add_points=$sub347;var $207=$letter_xbytes;var $208=$pre_ptr;var $idx_neg=(((-($207)))&4294967295);var $add_ptr348=(($208+$idx_neg)&4294967295);$pre_ptr=$add_ptr348;;}
else if(__label__==126){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==127){var $209=$rule_addr;var $incdec_ptr352=(($209+1)&4294967295);$rule_addr=$incdec_ptr352;var $210=HEAP8[($209)];var $conv353=(tempInt=(($210)),(tempInt>=128?tempInt-256:tempInt));var $sub354=((($conv353)-65)&4294967295);$letter_group=$sub354;var $211=$tr_addr;var $212=$pre_ptr;var $213=$letter_group;var $call355=__ZL13IsLetterGroupP10TranslatorPcii($211,$212,$213,1);$n_bytes=$call355;var $cmp356=((($call355))|0)>0;if($cmp356){__label__=128;;}else{__label__=129;;}
if(__label__==128){var $214=$distance_right;var $sub358=((20-($214))&4294967295);$add_points=$sub358;var $215=$n_bytes;var $sub359=((($215)-1)&4294967295);var $216=$pre_ptr;var $idx_neg360=(((-($sub359)))&4294967295);var $add_ptr361=(($216+$idx_neg360)&4294967295);$pre_ptr=$add_ptr361;;}
else if(__label__==129){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==130){var $217=$tr_addr;var $218=HEAP32[(($letter_w)>>2)];var $call365=__ZL8IsLetterP10Translatorii($217,$218,0);var $tobool366=((($call365))|0)!=0;if($tobool366){__label__=132;;}else{__label__=131;;}
if(__label__==132){$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==131){var $219=$distance_left;var $sub368=((20-($219))&4294967295);$add_points=$sub368;var $220=$letter_xbytes;var $221=$pre_ptr;var $idx_neg369=(((-($220)))&4294967295);var $add_ptr370=(($221+$idx_neg369)&4294967295);$pre_ptr=$add_ptr370;;}}
else if(__label__==133){var $222=$letter;var $conv374=((($222))&255);var $223=$last_letter;var $conv375=((($223))&255);var $cmp376=((($conv374))|0)==((($conv375))|0);if($cmp376){__label__=134;;}else{__label__=135;;}
if(__label__==134){var $224=$distance_left;var $sub378=((21-($224))&4294967295);$add_points=$sub378;;}
else if(__label__==135){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==136){var $225=HEAP32[(($letter_w)>>2)];var $call382=__Z7IsDigitj($225);var $tobool383=((($call382))|0)!=0;if($tobool383){__label__=137;;}else{__label__=138;;}
if(__label__==137){var $226=$distance_left;var $sub385=((21-($226))&4294967295);$add_points=$sub385;var $227=$letter_xbytes;var $228=$pre_ptr;var $idx_neg386=(((-($227)))&4294967295);var $add_ptr387=(($228+$idx_neg386)&4294967295);$pre_ptr=$add_ptr387;;}
else if(__label__==138){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==139){var $229=HEAP32[(($letter_w)>>2)];var $call391=_iswalpha($229);var $tobool392=((($call391))|0)!=0;if($tobool392){__label__=141;;}else{__label__=140;;}
if(__label__==141){$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==140){var $230=$distance_right;var $sub394=((21-($230))&4294967295);$add_points=$sub394;var $231=$letter_xbytes;var $232=$pre_ptr;var $idx_neg395=(((-($231)))&4294967295);var $add_ptr396=(($232+$idx_neg395)&4294967295);$pre_ptr=$add_ptr396;;}}
else if(__label__==142){$syllable_count=1;var $233=$rule_addr;var $234=HEAP8[($233)];var $conv40112=(tempInt=(($234)),(tempInt>=128?tempInt-256:tempInt));var $cmp40213=((($conv40112))|0)==21;if($cmp40213){__label__=143;;}else{__label__=144;;}
$while_body403$$while_end406$204:do{if(__label__==143){while(1){var $235=$rule_addr;var $incdec_ptr404=(($235+1)&4294967295);$rule_addr=$incdec_ptr404;var $236=$syllable_count;var $inc405=((($236)+1)&4294967295);$syllable_count=$inc405;var $237=$rule_addr;var $238=HEAP8[($237)];var $conv401=(tempInt=(($238)),(tempInt>=128?tempInt-256:tempInt));var $cmp402=((($conv401))|0)==21;if($cmp402){__label__=143;continue;}else{__label__=144;break $while_body403$$while_end406$204;}}}}while(0);var $239=$syllable_count;var $240=$tr_addr;var $word_vowel_count=(($240+8296)&4294967295);var $241=HEAP32[(($word_vowel_count)>>2)];var $cmp407=((($239))|0)<=((($241))|0);if($cmp407){__label__=145;;}else{__label__=146;;}
if(__label__==145){var $242=$syllable_count;var $243=$distance_left;var $_neg11=(((-($243)))&4294967295);var $add409=((($242)+18)&4294967295);var $sub410=((($add409)+($_neg11))&4294967295);$add_points=$sub410;;}
else if(__label__==146){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==147){var $244=$tr_addr;var $word_stressed_count=(($244+8300)&4294967295);var $245=HEAP32[(($word_stressed_count)>>2)];var $cmp414=((($245))|0)>0;if($cmp414){__label__=148;;}else{__label__=149;;}
if(__label__==148){$add_points=19;;}
else if(__label__==149){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==150){var $246=$pre_ptr;var $247=$letter_xbytes;var $idx_neg420=(((-($247)))&4294967295);var $add_ptr421=(($246+$idx_neg420)&4294967295);var $add_ptr422=(($add_ptr421+-1)&4294967295);$p419=$add_ptr422;;while(1){var $248=HEAP32[(($letter_w)>>2)];var $cmp424=((($248))|0)!=32;if(!($cmp424)){__label__=155;break;}
var $249=$tr_addr;var $250=HEAP32[(($letter_w)>>2)];var $call426=__ZL8IsLetterP10Translatorii($249,$250,7);var $tobool427=((($call426))|0)!=0;if($tobool427){__label__=153;break;}
var $251=$p419;var $call430=__Z8utf8_in2PiPKci($letter_w,$251,1);var $252=$p419;var $idx_neg431=(((-($call430)))&4294967295);var $add_ptr432=(($252+$idx_neg431)&4294967295);$p419=$add_ptr432;__label__=151;continue;}
if(__label__==155){var $_pr4=$failed;var $tobool434=((($_pr4))|0)!=0;if($tobool434){__label__=30;break $if_then8$$if_end70$12;}
$add_points=3;;}
else if(__label__==153){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==157){var $253=$tr_addr;var $expect_verb=(($253+8272)&4294967295);var $254=HEAP32[(($expect_verb)>>2)];var $tobool438=((($254))|0)!=0;if($tobool438){__label__=158;;}else{__label__=159;;}
if(__label__==158){$add_points=1;;}
else if(__label__==159){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==160){var $255=$word_flags_addr;var $and443=($255)&2;var $tobool444=((($and443))|0)!=0;if($tobool444){__label__=161;;}else{__label__=162;;}
if(__label__==161){$add_points=1;;}
else if(__label__==162){$failed=1;__label__=30;break $if_then8$$if_end70$12;}}
else if(__label__==163){var $256=$pre_ptr;$p=$256;;while(1){var $257=$p;var $258=HEAP8[($257)];var $conv450=(tempInt=(($258)),(tempInt>=128?tempInt-256:tempInt));var $cmp451=((($conv450))|0)!=32;if(!($cmp451)){__label__=168;break;}
var $259=$p;var $260=HEAP8[($259)];var $conv453=(tempInt=(($260)),(tempInt>=128?tempInt-256:tempInt));var $cmp454=((($conv453))|0)==46;if($cmp454){__label__=166;break;}
var $261=$p;var $incdec_ptr458=(($261+-1)&4294967295);$p=$incdec_ptr458;__label__=164;continue;}
if(__label__==166){$add_points=50;;}
var $262=$p;var $263=HEAP8[($262)];var $conv460=(tempInt=(($263)),(tempInt>=128?tempInt-256:tempInt));var $cmp461=((($conv460))|0)==32;if(!($cmp461)){__label__=181;break $sw_epilog496$$sw_bb71$$sw_bb89$$sw_bb328$44;}
$failed=1;__label__=30;break $if_then8$$if_end70$12;}
else if(__label__==170){var $264=$letter;var $conv465=((($264))&255);var $cmp466=((($conv465))|0)==45;if($cmp466){__label__=173;;}else{__label__=171;;}
$if_then473$$lor_lhs_false467$242:do{if(__label__==171){var $265=$letter;var $conv468=((($265))&255);var $cmp469=((($conv468))|0)==32;if($cmp469){__label__=172;;}else{__label__=174;;}
if(__label__==172){var $266=$word_flags_addr;var $and471=($266)&128;var $tobool472=((($and471))|0)!=0;if($tobool472){__label__=173;break $if_then473$$lor_lhs_false467$242;}}
$failed=1;__label__=30;break $if_then8$$if_end70$12;}}while(0);var $267=$distance_right;var $sub474=((22-($267))&4294967295);$add_points=$sub474;;}}}while(0);var $_pr6_pr=$failed;var $cmp497=((($_pr6_pr))|0)==0;if(!($cmp497)){__label__=30;break $if_then8$$if_end70$12;}
var $273=$add_points;var $274=HEAP32[(($points499)>>2)];var $add500=((($274)+($273))&4294967295);HEAP32[(($points499)>>2)]=$add500;;}}while(0);var $42=$failed;var $tobool=((($42))|0)!=0;var $lnot=($tobool)^1;if($lnot){__lastLabel__=30;__label__=6;continue $while_body4$10;}else{__lastLabel__=30;__label__=183;break $while_body4$$while_end502$9;}}}}while(0);var $275=__lastLabel__==30?$42:($18);var $cmp503=((($275))|0)==2;if($cmp503){__label__=184;;}else{__label__=197;;}
$land_lhs_true504$$while_cond543$252:do{if(__label__==184){var $276=$unpron_ignore;var $cmp505=((($276))|0)==0;if(!($cmp505)){__label__=197;break $land_lhs_true504$$while_cond543$252;}
var $277=$check_atstart;var $cmp507=((($277))|0)==0;if($cmp507){__label__=189;;}else{__label__=186;;}
$if_end517$$lor_lhs_false508$255:do{if(__label__==186){var $278=$pre_ptr;var $arrayidx509=(($278+-1)&4294967295);var $279=HEAP8[($arrayidx509)];var $conv510=(tempInt=(($279)),(tempInt>=128?tempInt-256:tempInt));var $cmp511=((($conv510))|0)==32;if(!($cmp511)){__label__=197;break $land_lhs_true504$$while_cond543$252;}
var $_pr8=$check_atstart;var $tobool513=((($_pr8))|0)!=0;if(!($tobool513)){__label__=189;break $if_end517$$lor_lhs_false508$255;}
var $280=HEAP32[(($points515)>>2)];var $add516=((($280)+4)&4294967295);HEAP32[(($points515)>>2)]=$add516;;}}while(0);var $281=HEAP32[(($points518)>>2)];var $282=HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best)&4294967295))>>2)];var $cmp519=((($281))|0)>=((($282))|0);if($cmp519){__label__=190;;}else{__label__=191;;}
if(__label__==190){var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$8;$dest$=__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best;$stop$=$src$+16;if(($dest$%4)==($src$%4)&&16>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $283=$consumed;$total_consumed=$283;;}
var $284=HEAP32[((_option_phonemes)>>2)];var $cmp522=((($284))|0)==2;if(!($cmp522)){__label__=197;break $land_lhs_true504$$while_cond543$252;}
var $285=HEAP32[(($points524)>>2)];var $cmp525=((($285))|0)>0;if(!($cmp525)){__label__=197;break $land_lhs_true504$$while_cond543$252;}
var $286=$word_flags_addr;var $and527=($286)&268435456;var $cmp528=((($and527))|0)==0;if(!($cmp528)){__label__=197;break $land_lhs_true504$$while_cond543$252;}
var $287=HEAP32[(($points530)>>2)];$pts=$287;var $288=$group_length_addr;var $cmp531=((($288))|0)>1;if($cmp531){__label__=195;;}else{__label__=196;;}
if(__label__==195){var $289=$pts;var $add533=((($289)+35)&4294967295);$pts=$add533;;}
var $290=HEAP32[(($phonemes535)>>2)];__Z14DecodePhonemesPKcPc($290,$arraydecay536);var $291=HEAP32[((_f_trans)>>2)];var $292=$pts;var $293=$group_chars;var $294=$group_length_addr;var $295=$rule_start;var $296=$word_flags_addr;var $call537=__Z10DecodeRulePKciPci($293,$294,$295,$296);var $call539=_fprintf($291,((__str32148)&4294967295),allocate([$292,0,0,0,((__ZZ10DecodeRulePKciPciE6output)&4294967295),0,0,0,$arraydecay538,0,0,0],["i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}while(0);while(1){var $297=$rule_addr;var $incdec_ptr544=(($297+1)&4294967295);$rule_addr=$incdec_ptr544;var $298=HEAP8[($297)];var $conv545=(tempInt=(($298)),(tempInt>=128?tempInt-256:tempInt));var $cmp546=((($conv545))|0)!=0;if($cmp546){__label__=197;continue;}else{__label__=4;break;}}
var $9=$rule_addr;var $arrayidx=(($9)&4294967295);var $10=HEAP8[($arrayidx)];var $conv=(tempInt=(($10)),(tempInt>=128?tempInt-256:tempInt));var $cmp1=((($conv))|0)!=7;if($cmp1){__label__=5;continue $while_body$7;}else{__label__=198;break $while_body_lr_ph$$while_end549$5;}}}}while(0);var $299=HEAP32[((_option_phonemes)>>2)];var $cmp550=((($299))|0)==2;if($cmp550){__label__=199;;}else{__label__=202;;}
$land_lhs_true551$$if_end559$273:do{if(__label__==199){var $300=$word_flags_addr;var $and552=($300)&268435456;var $cmp553=((($and552))|0)==0;if(!($cmp553)){__label__=202;break $land_lhs_true551$$if_end559$273;}
var $301=$group_length_addr;var $cmp555=((($301))|0)<=1;if(!($cmp555)){__label__=202;break $land_lhs_true551$$if_end559$273;}
var $302=HEAP32[((_f_trans)>>2)];var $fputc=_fputc(10,$302);;}}while(0);var $303=$group_length_addr;var $304=$total_consumed;var $add560=((($304)+($303))&4294967295);$total_consumed=$add560;var $cmp561=((($add560))|0)==0;if($cmp561){__label__=203;;}else{__label__=204;;}
if(__label__==203){$total_consumed=1;;}
var $305=$total_consumed;var $306=$word_addr;var $307=HEAP32[(($306)>>2)];var $add_ptr564=(($307+$305)&4294967295);HEAP32[(($306)>>2)]=$add_ptr564;var $308=HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best)&4294967295))>>2)];var $cmp565=((($308))|0)==0;if($cmp565){__label__=205;;}else{__label__=206;;}
if(__label__==205){HEAP32[((((__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best+4)&4294967295))>>2)]=((__str13643)&4294967295);;}
var $309=$match_out_addr;var $310=$309;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=__ZZL9MatchRuleP10TranslatorPPcS1_iS1_P11MatchRecordiiE4best;$dest$=$310;$stop$=$src$+16;if(($dest$%4)==($src$%4)&&16>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}
STACKTOP=__stackBase__;return;return;}
function __Z21ApplySpecialAttributeP10TranslatorPci($tr,$phonemes,$dict_flags){;var __label__;var $tr_addr;var $phonemes_addr;var $dict_flags_addr;var $len;var $p_end;$tr_addr=$tr;$phonemes_addr=$phonemes;$dict_flags_addr=$dict_flags;var $0=$dict_flags_addr;var $and=($0)&3145728;var $cmp=((($and))|0)==0;if($cmp){__label__=4;;}else{__label__=1;;}
$sw_epilog$$if_end$2:do{if(__label__==1){var $1=$phonemes_addr;var $call=_strlen($1);$len=$call;var $2=$len;var $sub=((($2)-1)&4294967295);var $3=$phonemes_addr;var $arrayidx=(($3+$sub)&4294967295);$p_end=$arrayidx;var $4=$tr_addr;var $translator_name=(($4+280)&4294967295);var $5=HEAP32[(($translator_name)>>2)];var $cond=((($5))|0)==29295;if(!($cond)){__label__=4;break $sw_epilog$$if_end$2;}
var $6=$p_end;var $arrayidx1=(($6)&4294967295);var $7=HEAP8[($arrayidx1)];var $conv=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $call2=__Z11PhonemeCodej(106);var $cmp3=((($conv))|0)==((($call2))|0);if(!($cmp3)){__label__=4;break $sw_epilog$$if_end$2;}
var $8=$p_end;var $arrayidx5=(($8)&4294967295);HEAP8[($arrayidx5)]=6;var $call6=__Z11PhonemeCodej(105);var $conv7=((($call6))&255);var $9=$p_end;var $arrayidx8=(($9+1)&4294967295);HEAP8[($arrayidx8)]=$conv7;var $10=$p_end;var $arrayidx9=(($10+2)&4294967295);HEAP8[($arrayidx9)]=0;;}}while(0);;return;return;}
function __Z22ApplySpecialAttribute2P10TranslatorPci($tr,$phonemes,$dict_flags){;var __label__;var $tr_addr;var $phonemes_addr;var $dict_flags_addr;var $ix;var $len;var $p;$tr_addr=$tr;$phonemes_addr=$phonemes;$dict_flags_addr=$dict_flags;var $0=$phonemes_addr;var $call=_strlen($0);$len=$call;var $1=$tr_addr;var $langopts=(($1)&4294967295);var $param=(($langopts+24)&4294967295);var $arrayidx=(($param+60)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];var $and=($2)&2;var $tobool=((($and))|0)!=0;if($tobool){__label__=1;;}else{__label__=14;;}
$if_then$$if_end37$2:do{if(__label__==1){$ix=0;;while(1){var $3=$ix;var $4=$len;var $sub=((($4)-1)&4294967295);var $cmp=((($3))|0)<((($sub))|0);if(!($cmp)){__label__=14;break $if_then$$if_end37$2;}
var $5=$ix;var $6=$phonemes_addr;var $arrayidx1=(($6+$5)&4294967295);var $7=HEAP8[($arrayidx1)];var $conv=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $cmp2=((($conv))|0)==6;var $8=$ix;var $add=((($8)+1)&4294967295);if($cmp2){__label__=4;break;}
$ix=$add;__label__=2;continue;}
var $9=$phonemes_addr;var $arrayidx4=(($9+$add)&4294967295);$p=$arrayidx4;var $10=$dict_flags_addr;var $and5=($10)&2097152;var $cmp6=((($and5))|0)!=0;var $11=$p;var $12=HEAP8[($11)];var $conv8=(tempInt=(($12)),(tempInt>=128?tempInt-256:tempInt));if($cmp6){__label__=5;;}else{__label__=9;;}
if(__label__==5){var $call9=__Z11PhonemeCodej(69);var $cmp10=((($conv8))|0)==((($call9))|0);if($cmp10){__label__=6;;}else{__label__=7;;}
if(__label__==6){var $call12=__Z11PhonemeCodej(101);var $conv13=((($call12))&255);var $13=$p;HEAP8[($13)]=$conv13;;}
var $14=$p;var $15=HEAP8[($14)];var $conv14=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));var $call15=__Z11PhonemeCodej(79);var $cmp16=((($conv14))|0)==((($call15))|0);if(!($cmp16)){__label__=14;break $if_then$$if_end37$2;}
var $call18=__Z11PhonemeCodej(111);var $conv19=((($call18))&255);var $16=$p;HEAP8[($16)]=$conv19;;}
else if(__label__==9){var $call22=__Z11PhonemeCodej(101);var $cmp23=((($conv8))|0)==((($call22))|0);if($cmp23){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $call25=__Z11PhonemeCodej(69);var $conv26=((($call25))&255);var $17=$p;HEAP8[($17)]=$conv26;;}
var $18=$p;var $19=HEAP8[($18)];var $conv28=(tempInt=(($19)),(tempInt>=128?tempInt-256:tempInt));var $call29=__Z11PhonemeCodej(111);var $cmp30=((($conv28))|0)==((($call29))|0);if(!($cmp30)){__label__=14;break $if_then$$if_end37$2;}
var $call32=__Z11PhonemeCodej(79);var $conv33=((($call32))&255);var $20=$p;HEAP8[($20)]=$conv33;;}}}while(0);;return;return;}
function __Z17TransposeAlphabetP10TranslatorPc($tr,$text){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $text_addr;var $c=__stackBase__;var $c2;var $ix;var $offset;var $min;var $max;var $p;var $p2;var $all_alpha;var $bits;var $acc;var $pairs_start;var $pairs_list;$tr_addr=$tr;$text_addr=$text;var $0=$text_addr;$p=$0;var $1=$text_addr;$p2=$1;$all_alpha=1;var $2=$tr_addr;var $transpose_min=(($2+288)&4294967295);var $3=HEAP32[(($transpose_min)>>2)];var $sub=((($3)-1)&4294967295);$offset=$sub;var $4=$tr_addr;var $transpose_min1=(($4+288)&4294967295);var $5=HEAP32[(($transpose_min1)>>2)];$min=$5;var $6=$tr_addr;var $transpose_max=(($6+284)&4294967295);var $7=HEAP32[(($transpose_max)>>2)];$max=$7;var $8=$max;var $9=$min;var $_neg=(((-($9)))&4294967295);var $sub2=((($8)+2)&4294967295);var $add=((($sub2)+($_neg))&4294967295);$pairs_start=$add;;$do_body$2:while(1){var $10=$p;var $call=__Z7utf8_inPiPKc($c,$10);var $11=$p;var $add_ptr=(($11+$call)&4294967295);$p=$add_ptr;var $12=HEAP32[(($c)>>2)];var $13=$min;var $cmp=((($12))|0)>=((($13))|0);if($cmp){__lastLabel__=1;__label__=2;;}else{__lastLabel__=1;__label__=4;;}
$land_lhs_true$$if_else$4:do{if(__label__==2){var $14=HEAP32[(($c)>>2)];var $15=$max;var $cmp3=((($14))|0)<=((($15))|0);if($cmp3){__lastLabel__=2;;}else{__lastLabel__=2;__label__=4;break $land_lhs_true$$if_else$4;}
var $16=HEAP32[(($c)>>2)];var $17=$offset;var $sub4=((($16)-($17))&4294967295);var $conv=((($sub4))&255);var $18=$p2;var $incdec_ptr=(($18+1)&4294967295);$p2=$incdec_ptr;HEAP8[($18)]=$conv;__label__=6;break $land_lhs_true$$if_else$4;}}while(0);$do_cond$$if_else$7:do{if(__label__==4){var $19=__lastLabel__==2?$14:($12);var $cmp5=((($19))|0)!=0;if(!($cmp5)){__label__=6;break $do_cond$$if_else$7;}
var $20=HEAP32[(($c)>>2)];var $21=$p2;var $call7=__Z8utf8_outjPc($20,$21);var $22=$p2;var $add_ptr8=(($22+$call7)&4294967295);$p2=$add_ptr8;$all_alpha=0;;}}while(0);var $23=HEAP32[(($c)>>2)];var $cmp10=((($23))|0)!=0;if($cmp10){__label__=1;continue $do_body$2;}else{__label__=7;break $do_body$2;}}
var $24=$p2;HEAP8[($24)]=0;var $25=$all_alpha;var $tobool=((($25))|0)!=0;if($tobool){__label__=8;;}else{__label__=21;;}
if(__label__==8){$acc=0;$bits=0;var $26=$text_addr;$p=$26;var $27=$text_addr;$p2=$27;var $28=$p;var $incdec_ptr121=(($28+1)&4294967295);$p=$incdec_ptr121;var $29=HEAP8[($28)];var $conv132=(tempInt=(($29)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($c)>>2)]=$conv132;var $cmp143=((($conv132))|0)!=0;if($cmp143){__label__=9;;}else{__label__=18;;}
$while_body$$while_end$14:do{if(__label__==9){$while_body$15:while(1){var $30=$tr_addr;var $frequent_pairs=(($30+8268)&4294967295);var $31=HEAP32[(($frequent_pairs)>>2)];$pairs_list=$31;var $cmp15=((($31))|0)!=0;if($cmp15){__label__=10;;}else{__label__=15;;}
$if_then16$$if_end28$17:do{if(__label__==10){var $32=HEAP32[(($c)>>2)];var $33=$p;var $34=HEAP8[($33)];var $conv17=(tempInt=(($34)),(tempInt>=128?tempInt-256:tempInt));var $shl=((($conv17)*256)&4294967295);var $add18=((($shl)+($32))&4294967295);$c2=$add18;$ix=0;;while(1){var $35=$c2;var $36=$ix;var $37=$pairs_list;var $arrayidx=(($37+2*$36)&4294967295);var $38=HEAP16[(($arrayidx)>>1)];var $conv19=(tempInt=(($38)),(tempInt>=32768?tempInt-65536:tempInt));var $cmp20=((($35))|0)>=((($conv19))|0);if(!($cmp20)){__label__=15;break $if_then16$$if_end28$17;}
var $39=$c2;var $40=$ix;var $41=$pairs_list;var $arrayidx21=(($41+2*$40)&4294967295);var $42=HEAP16[(($arrayidx21)>>1)];var $conv22=(tempInt=(($42)),(tempInt>=32768?tempInt-65536:tempInt));var $cmp23=((($39))|0)==((($conv22))|0);var $43=$ix;if($cmp23){__label__=13;break;}
var $inc=((($43)+1)&4294967295);$ix=$inc;__label__=11;continue;}
var $44=$pairs_start;var $add25=((($44)+($43))&4294967295);HEAP32[(($c)>>2)]=$add25;var $45=$p;var $incdec_ptr26=(($45+1)&4294967295);$p=$incdec_ptr26;;}}while(0);var $46=$acc;var $shl29=((($46)*64)&4294967295);var $47=HEAP32[(($c)>>2)];var $and=($47)&63;var $add30=((($and)+($shl29))&4294967295);$acc=$add30;var $48=$bits;var $add31=((($48)+6)&4294967295);$bits=$add31;var $cmp32=((($add31))|0)>=8;if($cmp32){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $49=$bits;var $sub34=((($49)-8)&4294967295);$bits=$sub34;var $50=$acc;var $51=$bits;var $shr=($50)>>((($51))|0);var $conv35=((($shr))&255);var $52=$p2;var $incdec_ptr36=(($52+1)&4294967295);$p2=$incdec_ptr36;HEAP8[($52)]=$conv35;;}
var $53=$p;var $incdec_ptr12=(($53+1)&4294967295);$p=$incdec_ptr12;var $54=HEAP8[($53)];var $conv13=(tempInt=(($54)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($c)>>2)]=$conv13;var $cmp14=((($conv13))|0)!=0;if($cmp14){__label__=9;continue $while_body$15;}else{__label__=18;break $while_body$$while_end$14;}}}}while(0);var $55=$bits;var $cmp38=((($55))|0)>0;if($cmp38){__label__=19;;}else{__label__=20;;}
if(__label__==19){var $56=$acc;var $57=$bits;var $sub40=((8-($57))&4294967295);var $shl41=($56)<<($sub40);var $conv42=((($shl41))&255);var $58=$p2;var $incdec_ptr43=(($58+1)&4294967295);$p2=$incdec_ptr43;HEAP8[($58)]=$conv42;;}
var $59=$p2;HEAP8[($59)]=0;var $60=$p2;var $61=$text_addr;var $sub_ptr_lhs_cast=($60);var $sub_ptr_rhs_cast=($61);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $or=($sub_ptr_sub)|64;$retval=$or;;}
else if(__label__==21){var $62=$p2;var $63=$text_addr;var $sub_ptr_lhs_cast46=($62);var $sub_ptr_rhs_cast47=($63);var $sub_ptr_sub48=((($sub_ptr_lhs_cast46)-($sub_ptr_rhs_cast47))&4294967295);$retval=$sub_ptr_sub48;;}
var $64=$retval;STACKTOP=__stackBase__;return $64;return null;}
function __Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($tr,$wordptr,$ph_out,$flags,$end_flags,$wtab){var __stackBase__=STACKTOP;STACKTOP+=164;_memset(__stackBase__,0,164);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $wordptr_addr;var $ph_out_addr;var $flags_addr;var $end_flags_addr;var $wtab_addr;var $length;var $found;var $word1;var $word2;var $c;var $nbytes;var $len;var $word=__stackBase__;var $letter=__stackBase__+160;$tr_addr=$tr;$wordptr_addr=$wordptr;$ph_out_addr=$ph_out;$flags_addr=$flags;$end_flags_addr=$end_flags;$wtab_addr=$wtab;$length=0;var $0=$wordptr_addr;var $1=HEAP32[(($0)>>2)];$word1=$1;$word2=$1;;$while_cond$2:while(1){var $2=$word2;var $call=__Z11utf8_nbytesPKc($2);$nbytes=$call;var $3=$word2;var $arrayidx=(($3+$call)&4294967295);var $4=HEAP8[($arrayidx)];var $conv=(tempInt=(($4)),(tempInt>=128?tempInt-256:tempInt));var $cmp=((($conv))|0)==32;if(!($cmp)){__label__=2;break $while_cond$2;}
var $6=$nbytes;var $add=((($6)+1)&4294967295);var $7=$word2;var $arrayidx1=(($7+$add)&4294967295);var $8=HEAP8[($arrayidx1)];var $conv2=(tempInt=(($8)),(tempInt>=128?tempInt-256:tempInt));var $cmp3=((($conv2))|0)==46;var $9=$length;if($cmp3){__lastLabel__=3;;}else{__lastLabel__=3;__label__=5;break $while_cond$2;}
var $arrayidx4=(($word+$9)&4294967295);var $10=$word2;var $11=$nbytes;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$10;$dest$=$arrayidx4;$stop$=$src$+$11;if(($dest$%4)==($src$%4)&&$11>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $12=$nbytes;var $13=$length;var $add5=((($13)+($12))&4294967295);$length=$add5;var $14=$length;var $inc=((($14)+1)&4294967295);$length=$inc;var $arrayidx6=(($word+$14)&4294967295);HEAP8[($arrayidx6)]=46;var $15=$nbytes;var $add7=((($15)+3)&4294967295);var $16=$word2;var $add_ptr=(($16+$add7)&4294967295);$word2=$add_ptr;__label__=1;continue $while_cond$2;}
if(__label__==2){var $5=$length;__lastLabel__=2;;}
var $17=__lastLabel__==2?$5:($9);var $cmp8=((($17))|0)>0;if($cmp8){__label__=6;;}else{__label__=12;;}
$if_then$$if_end26$9:do{if(__label__==6){$nbytes=0;;while(1){var $18=$nbytes;var $19=$word2;var $arrayidx10=(($19+$18)&4294967295);var $20=HEAPU8[($arrayidx10)];$c=$20;var $conv11=((($20))&255);var $cmp12=((($conv11))|0)!=0;if(!($cmp12)){__label__=10;break;}
var $21=$c;var $conv14=((($21))&255);var $cmp15=((($conv14))|0)!=32;if(!($cmp15)){__label__=10;break;}
var $22=$nbytes;var $inc18=((($22)+1)&4294967295);$nbytes=$inc18;__label__=7;continue;}
var $23=$length;var $arrayidx20=(($word+$23)&4294967295);var $24=$word2;var $25=$nbytes;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$24;$dest$=$arrayidx20;$stop$=$src$+$25;if(($dest$%4)==($src$%4)&&$25>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $26=$length;var $27=$nbytes;var $add21=((($27)+($26))&4294967295);var $arrayidx22=(($word+$add21)&4294967295);HEAP8[($arrayidx22)]=0;var $28=$tr_addr;var $arraydecay=(($word)&4294967295);var $29=$word2;var $30=$ph_out_addr;var $31=$flags_addr;var $32=$end_flags_addr;var $33=$wtab_addr;var $call23=__ZL11LookupDict2P10TranslatorPKcS2_PcPjiP8WORD_TAB($28,$arraydecay,$29,$30,$31,$32,$33);$found=$call23;var $tobool=((($call23))|0)!=0;if(!($tobool)){__label__=12;break $if_then$$if_end26$9;}
var $34=$flags_addr;var $arrayidx25=(($34)&4294967295);var $35=HEAP32[(($arrayidx25)>>2)];var $or=($35)|128;HEAP32[(($arrayidx25)>>2)]=$or;var $36=$length;HEAP32[((_dictionary_skipwords)>>2)]=$36;$retval=1;__label__=50;break $if_then$$if_end26$9;}}while(0);if(__label__==12){$length=0;__lastLabel__=12;;$for_cond$19:while(1){var $37=__lastLabel__==19?$inc45:(0);var $cmp27=((($37))|0)<159;if(!($cmp27)){__label__=20;break $for_cond$19;}
var $38=$word1;var $incdec_ptr=(($38+1)&4294967295);$word1=$incdec_ptr;var $39=HEAPU8[($38)];$c=$39;var $conv28=((($39))&255);var $cmp29=((($conv28))|0)==0;if($cmp29){__label__=20;break $for_cond$19;}
var $40=$c;var $conv30=((($40))&255);var $cmp31=((($conv30))|0)==32;if($cmp31){__label__=20;break $for_cond$19;}
var $41=$c;var $conv34=((($41))&255);var $cmp35=((($conv34))|0)==46;if($cmp35){__label__=17;;}else{__label__=19;;}
$land_lhs_true$$if_end43$24:do{if(__label__==17){var $42=$length;var $cmp36=((($42))|0)>0;if(!($cmp36)){__label__=19;break $land_lhs_true$$if_end43$24;}
var $43=$length;var $sub=((($43)-1)&4294967295);var $arrayidx38=(($word+$sub)&4294967295);var $44=HEAP8[($arrayidx38)];var $conv39=(tempInt=(($44)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp=((($conv39)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call40=((($isdigit))&1);var $tobool41=((($call40))|0)!=0;if($tobool41){__label__=20;break $for_cond$19;}}}while(0);var $45=$c;var $46=$length;var $arrayidx44=(($word+$46)&4294967295);HEAP8[($arrayidx44)]=$45;var $47=$length;var $inc45=((($47)+1)&4294967295);$length=$inc45;__lastLabel__=19;__label__=13;continue $for_cond$19;}
var $48=$length;var $arrayidx46=(($word+$48)&4294967295);HEAP8[($arrayidx46)]=0;var $49=$tr_addr;var $arraydecay47=(($word)&4294967295);var $50=$word1;var $51=$ph_out_addr;var $52=$flags_addr;var $53=$end_flags_addr;var $54=$wtab_addr;var $call48=__ZL11LookupDict2P10TranslatorPKcS2_PcPjiP8WORD_TAB($49,$arraydecay47,$50,$51,$52,$53,$54);$found=$call48;var $55=$flags_addr;var $arrayidx49=(($55)&4294967295);var $56=HEAP32[(($arrayidx49)>>2)];var $and=($56)&134217728;var $tobool50=((($and))|0)!=0;if($tobool50){__label__=21;;}else{__label__=25;;}
$if_then51$$if_else66$29:do{if(__label__==21){var $57=$ph_out_addr;var $58=$tr_addr;var $phonemes_repeat=(($58+632)&4294967295);var $arraydecay52=(($phonemes_repeat)&4294967295);var $call53=_strcmp($57,$arraydecay52);var $cmp54=((($call53))|0)==0;var $59=$tr_addr;if($cmp54){__label__=22;;}else{__label__=24;;}
if(__label__==22){var $phonemes_repeat_count=(($59+652)&4294967295);var $60=HEAP32[(($phonemes_repeat_count)>>2)];var $inc56=((($60)+1)&4294967295);HEAP32[(($phonemes_repeat_count)>>2)]=$inc56;var $61=$tr_addr;var $phonemes_repeat_count57=(($61+652)&4294967295);var $62=HEAP32[(($phonemes_repeat_count57)>>2)];var $cmp58=((($62))|0)>3;if(!($cmp58)){__label__=26;break $if_then51$$if_else66$29;}
var $63=$ph_out_addr;var $arrayidx60=(($63)&4294967295);HEAP8[($arrayidx60)]=0;;}
else if(__label__==24){var $phonemes_repeat62=(($59+632)&4294967295);var $arraydecay63=(($phonemes_repeat62)&4294967295);var $64=$ph_out_addr;__Z8strncpy0PcPKci($arraydecay63,$64,20);var $65=$tr_addr;var $phonemes_repeat_count64=(($65+652)&4294967295);HEAP32[(($phonemes_repeat_count64)>>2)]=1;;}}
else if(__label__==25){var $66=$tr_addr;var $phonemes_repeat_count67=(($66+652)&4294967295);HEAP32[(($phonemes_repeat_count67)>>2)]=0;;}}while(0);var $67=$found;var $cmp69=((($67))|0)==0;if($cmp69){__label__=27;;}else{__label__=39;;}
$land_lhs_true70$$if_end117thread_pre_split$37:do{if(__label__==27){var $68=$flags_addr;var $arrayidx71=(($68+4)&4294967295);var $69=HEAP32[(($arrayidx71)>>2)];var $and72=($69)&2048;var $tobool73=((($and72))|0)!=0;if($tobool73){__label__=28;;}else{__label__=31;;}
if(__label__==28){var $arraydecay75=(($word)&4294967295);$word2=$arraydecay75;var $70=$word2;var $71=HEAP8[($70)];var $conv76=(tempInt=(($71)),(tempInt>=128?tempInt-256:tempInt));var $cmp77=((($conv76))|0)==95;if($cmp77){__label__=29;;}else{__label__=30;;}
if(__label__==29){var $72=$word2;var $incdec_ptr79=(($72+1)&4294967295);$word2=$incdec_ptr79;;}
var $73=$word2;var $call81=__Z7utf8_inPiPKc($letter,$73);$len=$call81;var $74=$tr_addr;var $75=HEAP32[(($letter)>>2)];var $76=$ph_out_addr;__Z20LookupAccentedLetterP10TranslatorjPc($74,$75,$76);var $77=$word2;var $78=$len;var $add_ptr82=(($77+$78)&4294967295);$found=$add_ptr82;__lastLabel__=30;;}
else if(__label__==31){var $_pr=$found;__lastLabel__=31;;}
var $79=__lastLabel__==31?$_pr:($add_ptr82);var $cmp84=((($79))|0)==0;if(!($cmp84)){__label__=39;break $land_lhs_true70$$if_end117thread_pre_split$37;}
var $80=$ph_out_addr;var $arrayidx86=(($80)&4294967295);HEAP8[($arrayidx86)]=0;var $81=$end_flags_addr;var $and87=($81)&16;var $tobool88=((($and87))|0)!=0;if($tobool88){__label__=34;;}else{__label__=36;;}
$land_lhs_true89$$if_else99$47:do{if(__label__==34){var $82=$length;var $sub90=((($82)-1)&4294967295);var $arrayidx91=(($word+$sub90)&4294967295);var $83=HEAP8[($arrayidx91)];var $conv92=(tempInt=(($83)),(tempInt>=128?tempInt-256:tempInt));var $cmp93=((($conv92))|0)==101;if(!($cmp93)){__label__=36;break $land_lhs_true89$$if_else99$47;}
var $84=$length;var $sub95=((($84)-1)&4294967295);var $arrayidx96=(($word+$sub95)&4294967295);HEAP8[($arrayidx96)]=0;var $85=$tr_addr;var $arraydecay97=(($word)&4294967295);var $86=$word1;var $87=$ph_out_addr;var $88=$flags_addr;var $89=$end_flags_addr;var $90=$wtab_addr;var $call98=__ZL11LookupDict2P10TranslatorPKcS2_PcPjiP8WORD_TAB($85,$arraydecay97,$86,$87,$88,$89,$90);$found=$call98;__lastLabel__=35;__label__=40;break $land_lhs_true70$$if_end117thread_pre_split$37;}}while(0);var $91=$end_flags_addr;var $and100=($91)&4096;var $tobool101=((($and100))|0)!=0;if(!($tobool101)){__label__=39;break $land_lhs_true70$$if_end117thread_pre_split$37;}
var $92=$length;var $sub103=((($92)-1)&4294967295);var $arrayidx104=(($word+$sub103)&4294967295);var $93=HEAP8[($arrayidx104)];var $conv105=(tempInt=(($93)),(tempInt>=128?tempInt-256:tempInt));var $94=$length;var $sub106=((($94)-2)&4294967295);var $arrayidx107=(($word+$sub106)&4294967295);var $95=HEAP8[($arrayidx107)];var $conv108=(tempInt=(($95)),(tempInt>=128?tempInt-256:tempInt));var $cmp109=((($conv105))|0)==((($conv108))|0);if(!($cmp109)){__label__=39;break $land_lhs_true70$$if_end117thread_pre_split$37;}
var $96=$length;var $sub111=((($96)-1)&4294967295);var $arrayidx112=(($word+$sub111)&4294967295);HEAP8[($arrayidx112)]=0;var $97=$tr_addr;var $arraydecay113=(($word)&4294967295);var $98=$word1;var $99=$ph_out_addr;var $100=$flags_addr;var $101=$end_flags_addr;var $102=$wtab_addr;var $call114=__ZL11LookupDict2P10TranslatorPKcS2_PcPjiP8WORD_TAB($97,$arraydecay113,$98,$99,$100,$101,$102);$found=$call114;__lastLabel__=38;__label__=40;break $land_lhs_true70$$if_end117thread_pre_split$37;}}while(0);if(__label__==39){var $_pr2=$found;__lastLabel__=39;;}
var $103=__lastLabel__==39?$_pr2:(__lastLabel__==35?$call98:($call114));var $tobool118=((($103))|0)!=0;if($tobool118){__label__=41;;}else{__label__=49;;}
if(__label__==41){var $104=$tr_addr;var $langopts=(($104)&4294967295);var $textmode=(($langopts+252)&4294967295);var $105=HEAP8[($textmode)];var $tobool120=(tempInt=(($105)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool120){__label__=42;;}else{__label__=43;;}
if(__label__==42){var $106=$flags_addr;var $107=HEAP32[(($106)>>2)];var $xor=($107)^536870912;HEAP32[(($106)>>2)]=$xor;;}
var $108=$flags_addr;var $109=HEAP32[(($108)>>2)];var $and123=($109)&536870912;var $tobool124=((($and123))|0)!=0;if($tobool124){__label__=44;;}else{__label__=48;;}
if(__label__==44){var $110=$end_flags_addr;var $and126=($110)&2;var $tobool127=((($and126))|0)!=0;if($tobool127){__label__=45;;}else{__label__=47;;}
$if_then128$$if_end138$63:do{if(__label__==45){HEAP8[(((__ZZ14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TABE16word_replacement)&4294967295))]=0;HEAP8[(((__ZZ14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TABE16word_replacement+1)&4294967295))]=32;var $111=$ph_out_addr;var $call129=_sprintf(((__ZZ14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TABE16word_replacement+2)&4294967295),((__str15131)&4294967295),allocate([$111,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $112=$wordptr_addr;var $113=HEAP32[(($112)>>2)];$word1=$113;var $114=$wordptr_addr;HEAP32[(($114)>>2)]=((__ZZ14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TABE16word_replacement+2)&4294967295);var $115=HEAP32[((_option_phonemes)>>2)];var $cmp130=((($115))|0)==2;if(!($cmp130)){__label__=47;break $if_then128$$if_end138$63;}
var $116=$found;var $117=$word1;var $sub_ptr_lhs_cast=($116);var $sub_ptr_rhs_cast=($117);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);$len=$sub_ptr_sub;var $arraydecay132=(($word)&4294967295);var $118=$word1;var $119=$len;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$118;$dest$=$arraydecay132;$stop$=$src$+$119;if(($dest$%4)==($src$%4)&&$119>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $120=$len;var $arrayidx133=(($word+$120)&4294967295);HEAP8[($arrayidx133)]=0;var $121=HEAP32[((_f_trans)>>2)];var $arraydecay134=(($word)&4294967295);var $122=$wordptr_addr;var $123=HEAP32[(($122)>>2)];var $call135=_fprintf($121,((__str16132)&4294967295),allocate([$arraydecay134,0,0,0,$123,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}while(0);var $124=$ph_out_addr;var $arrayidx139=(($124)&4294967295);HEAP8[($arrayidx139)]=0;$retval=0;;}
else if(__label__==48){$retval=1;;}}
else if(__label__==49){var $125=$ph_out_addr;var $arrayidx142=(($125)&4294967295);HEAP8[($arrayidx142)]=0;$retval=0;;}}
var $126=$retval;STACKTOP=__stackBase__;return $126;return null;}
function __ZL11LookupDict2P10TranslatorPKcS2_PcPjiP8WORD_TAB($tr,$word,$word2,$phonetic,$flags,$end_flags,$wtab){var __stackBase__=STACKTOP;STACKTOP+=320;_memset(__stackBase__,0,320);var __label__;var $retval;var $tr_addr;var $word_addr;var $word2_addr;var $phonetic_addr;var $flags_addr;var $end_flags_addr;var $wtab_addr;var $p;var $next;var $hash;var $phoneme_len;var $wlen;var $flag;var $dictionary_flags;var $dictionary_flags2;var $condition_failed;var $n_chars;var $no_phonemes;var $skipwords;var $ix;var $word_end;var $word1;var $wflags;var $word_buf=__stackBase__;var $flags1259;var $ph_decoded=__stackBase__+160;var $textmode;$tr_addr=$tr;$word_addr=$word;$word2_addr=$word2;$phonetic_addr=$phonetic;$flags_addr=$flags;$end_flags_addr=$end_flags;$wtab_addr=$wtab;$condition_failed=0;$wflags=0;var $0=$wtab_addr;var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$wtab_addr;var $flags1=(($1)&4294967295);var $2=HEAP32[(($flags1)>>2)];$wflags=$2;;}
var $3=$word_addr;$word1=$3;var $4=$tr_addr;var $transpose_min=(($4+288)&4294967295);var $5=HEAP32[(($transpose_min)>>2)];var $cmp2=((($5))|0)>0;if($cmp2){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $arraydecay=(($word_buf)&4294967295);var $6=$word_addr;var $call=_strcpy($arraydecay,$6);var $7=$tr_addr;var $arraydecay4=(($word_buf)&4294967295);var $call5=__Z17TransposeAlphabetP10TranslatorPc($7,$arraydecay4);$wlen=$call5;var $arraydecay6=(($word_buf)&4294967295);$word_addr=$arraydecay6;;}
else if(__label__==4){var $8=$word_addr;var $call7=_strlen($8);$wlen=$call7;;}
var $9=$word_addr;var $call9=__Z14HashDictionaryPKc($9);$hash=$call9;var $10=$hash;var $11=$tr_addr;var $dict_hashtab=(($11+1056)&4294967295);var $arrayidx=(($dict_hashtab+$10*4)&4294967295);var $12=HEAP32[(($arrayidx)>>2)];$p=$12;var $cmp10=((($12))|0)==0;if($cmp10){__label__=6;;}else{__label__=9;;}
if(__label__==6){var $13=$flags_addr;var $cmp12=((($13))|0)!=0;if($cmp12){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $14=$flags_addr;HEAP32[(($14)>>2)]=0;;}
$retval=0;;}
else if(__label__==9){$while_cond$14:while(1){var $15=$p;var $16=HEAP8[($15)];var $conv=(tempInt=(($16)),(tempInt>=128?tempInt-256:tempInt));var $cmp16=((($conv))|0)!=0;if(!($cmp16)){__label__=95;break $while_cond$14;}
var $17=$p;var $18=$p;var $arrayidx17=(($18)&4294967295);var $19=HEAP8[($arrayidx17)];var $conv18=(tempInt=(($19)),(tempInt>=128?tempInt-256:tempInt));var $add_ptr=(($17+$conv18)&4294967295);$next=$add_ptr;var $20=$p;var $arrayidx19=(($20+1)&4294967295);var $21=HEAP8[($arrayidx19)];var $conv20=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));var $and=($conv20)&127;var $22=$wlen;var $cmp21=((($and))|0)!=((($22))|0);if($cmp21){__label__=12;;}else{__label__=11;;}
$if_then26$$lor_lhs_false$17:do{if(__label__==11){var $23=$word_addr;var $24=$p;var $arrayidx22=(($24+2)&4294967295);var $25=$wlen;var $and23=($25)&63;var $call24=_memcmp($23,$arrayidx22,$and23);var $cmp25=((($call24))|0)!=0;if($cmp25){__label__=12;break $if_then26$$lor_lhs_false$17;}
var $27=$word2_addr;$word_end=$27;$dictionary_flags=0;$dictionary_flags2=0;var $28=$p;var $arrayidx28=(($28+1)&4294967295);var $29=HEAP8[($arrayidx28)];var $conv29=(tempInt=(($29)),(tempInt>=128?tempInt-256:tempInt));var $and30=($conv29)&128;$no_phonemes=$and30;var $30=$p;var $arrayidx31=(($30+1)&4294967295);var $31=HEAP8[($arrayidx31)];var $conv32=(tempInt=(($31)),(tempInt>=128?tempInt-256:tempInt));var $and33=($conv32)&63;var $add=((($and33)+2)&4294967295);var $32=$p;var $add_ptr34=(($32+$add)&4294967295);$p=$add_ptr34;var $33=$no_phonemes;var $tobool=((($33))|0)!=0;var $34=$phonetic_addr;if($tobool){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $arrayidx36=(($34)&4294967295);HEAP8[($arrayidx36)]=0;$phoneme_len=0;;}
else if(__label__==15){var $35=$p;var $call38=_strcpy($34,$35);var $36=$p;var $call39=_strlen($36);$phoneme_len=$call39;var $37=$phoneme_len;var $add40=((($37)+1)&4294967295);var $38=$p;var $add_ptr41=(($38+$add40)&4294967295);$p=$add_ptr41;;}
$while_cond43$23:while(1){var $39=$p;var $40=$next;var $cmp44=((($39))>>>0)<((($40))>>>0);if(!($cmp44)){__label__=39;break $while_cond43$23;}
var $41=$p;var $incdec_ptr=(($41+1)&4294967295);$p=$incdec_ptr;var $42=HEAP8[($41)];$flag=$42;var $43=$flag;var $conv46=((($43))&255);var $cmp47=((($conv46))|0)>=100;var $44=$flag;var $conv49=((($44))&255);if($cmp47){__label__=18;;}else{__label__=23;;}
if(__label__==18){var $cmp50=((($conv49))|0)>=132;var $45=$tr_addr;var $dict_condition=(($45+692)&4294967295);var $46=HEAPU32[(($dict_condition)>>2)];var $47=$flag;var $conv52=((($47))&255);if($cmp50){__label__=19;;}else{__label__=21;;}
if(__label__==19){var $sub=((($conv52)-132)&4294967295);var $shl=1<<($sub);var $and53=($shl)&($46);var $cmp54=((($and53))|0)!=0;if(!($cmp54)){__label__=16;continue $while_cond43$23;}
$condition_failed=1;__label__=16;continue $while_cond43$23;}
else if(__label__==21){var $sub60=((($conv52)-100)&4294967295);var $shl61=1<<($sub60);var $and62=($shl61)&($46);var $cmp63=((($and62))|0)==0;if(!($cmp63)){__label__=16;continue $while_cond43$23;}
$condition_failed=1;__label__=16;continue $while_cond43$23;}}
else if(__label__==23){var $cmp69=((($conv49))|0)>80;if($cmp69){__label__=24;;}else{__label__=33;;}
if(__label__==24){var $48=$next;var $49=$p;var $sub_ptr_lhs_cast=($48);var $sub_ptr_rhs_cast=($49);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);$n_chars=$sub_ptr_sub;var $50=$flag;var $conv71=((($50))&255);var $sub72=((($conv71)-80)&4294967295);$skipwords=$sub72;$ix=0;var $51=$ix;var $52=$skipwords;var $cmp732=((($51))|0)<=((($52))|0);if($cmp732){__label__=25;;}else{__label__=28;;}
$for_body$$for_end$36:do{if(__label__==25){while(1){var $53=$wflags;var $and74=($53)&3072;var $tobool75=((($and74))|0)!=0;if($tobool75){__label__=26;;}else{__label__=27;;}
if(__label__==26){$condition_failed=1;;}
var $54=$ix;var $inc=((($54)+1)&4294967295);$ix=$inc;var $55=$ix;var $56=$skipwords;var $cmp73=((($55))|0)<=((($56))|0);if($cmp73){__label__=25;continue;}else{__label__=28;break $for_body$$for_end$36;}}}}while(0);var $57=$word2_addr;var $58=$p;var $59=$n_chars;var $call78=_memcmp($57,$58,$59);var $cmp79=((($call78))|0)!=0;if($cmp79){__label__=29;break $while_cond43$23;}
var $_pr=$condition_failed;var $tobool82=((($_pr))|0)!=0;if($tobool82){__label__=31;break $while_cond43$23;}
var $61=$dictionary_flags;var $or=($61)|128;$dictionary_flags=$or;var $62=$skipwords;HEAP32[((_dictionary_skipwords)>>2)]=$62;var $63=$next;$p=$63;var $64=$word2_addr;var $65=$n_chars;var $add_ptr85=(($64+$65)&4294967295);$word_end=$add_ptr85;__label__=16;continue $while_cond43$23;}
else if(__label__==33){var $66=$flag;var $conv87=((($66))&255);var $cmp88=((($conv87))|0)>64;if($cmp88){__label__=34;;}else{__label__=36;;}
if(__label__==34){var $67=$dictionary_flags;var $and90=($67)&-16;var $68=$flag;var $conv91=((($68))&255);var $and92=($conv91)&15;var $or93=($and92)|($and90);$dictionary_flags=$or93;var $69=$flag;var $conv94=((($69))&255);var $and95=($conv94)&12;var $cmp96=((($and95))|0)==12;if(!($cmp96)){__label__=16;continue $while_cond43$23;}
var $70=$dictionary_flags;var $or98=($70)|2048;$dictionary_flags=$or98;__label__=16;continue $while_cond43$23;}
else if(__label__==36){var $71=$flag;var $conv101=((($71))&255);var $cmp102=((($conv101))|0)>=32;var $72=$flag;var $conv104=((($72))&255);if($cmp102){__label__=37;;}else{__label__=38;;}
if(__label__==37){var $sub105=((($conv104)-32)&4294967295);var $shl106=1<<($sub105);var $73=$dictionary_flags2;var $or107=($73)|($shl106);$dictionary_flags2=$or107;__label__=16;continue $while_cond43$23;}
else if(__label__==38){var $shl110=1<<($conv104);var $74=$dictionary_flags;var $or111=($74)|($shl110);$dictionary_flags=$or111;__label__=16;continue $while_cond43$23;}}}}}
$while_end$$if_end81_thread$$if_then83$53:do{if(__label__==29){$condition_failed=1;__label__=31;break $while_end$$if_end81_thread$$if_then83$53;}}while(0);if(__label__==31){var $60=$next;$p=$60;;}
var $75=$condition_failed;var $tobool116=((($75))|0)!=0;if($tobool116){__label__=40;;}else{__label__=41;;}
if(__label__==40){$condition_failed=0;__label__=9;continue $while_cond$14;}
else if(__label__==41){var $76=$end_flags_addr;var $and119=($76)&4;var $cmp120=((($and119))|0)==0;if($cmp120){__label__=42;;}else{__label__=43;;}
if(__label__==42){var $77=$dictionary_flags;var $and122=($77)&262144;var $tobool123=((($and122))|0)!=0;if($tobool123){__label__=9;continue $while_cond$14;}}
var $78=$end_flags_addr;var $and127=($78)&1024;var $tobool128=((($and127))|0)!=0;if($tobool128){__label__=44;;}else{__label__=45;;}
if(__label__==44){var $79=$dictionary_flags;var $and129=($79)&1536;var $tobool130=((($and129))|0)!=0;if($tobool130){__label__=9;continue $while_cond$14;}}
var $80=$end_flags_addr;var $and133=($80)&4;var $tobool134=((($and133))|0)!=0;if($tobool134){__label__=46;;}else{__label__=49;;}
$if_then135$$if_end147$67:do{if(__label__==46){var $81=$dictionary_flags;var $and136=($81)&512;var $tobool137=((($and136))|0)!=0;if($tobool137){__label__=9;continue $while_cond$14;}
var $82=$dictionary_flags;var $and140=($82)&1024;var $tobool141=((($and140))|0)!=0;if(!($tobool141)){__label__=49;break $if_then135$$if_end147$67;}
var $83=$end_flags_addr;var $and143=($83)&8;var $cmp144=((($and143))|0)==0;if($cmp144){__label__=9;continue $while_cond$14;}}}while(0);var $84=$dictionary_flags2;var $and148=($84)&4096;var $tobool149=((($and148))|0)!=0;if($tobool149){__label__=50;;}else{__label__=51;;}
if(__label__==50){var $85=$wflags;var $and151=($85)&16384;var $tobool152=((($and151))|0)!=0;if(!($tobool152)){__label__=9;continue $while_cond$14;}}
var $86=$dictionary_flags2;var $and156=($86)&512;var $tobool157=((($and156))|0)!=0;if($tobool157){__label__=52;;}else{__label__=53;;}
if(__label__==52){var $87=$wflags;var $and159=($87)&2;var $tobool160=((($and159))|0)!=0;if(!($tobool160)){__label__=9;continue $while_cond$14;}}
var $88=$dictionary_flags2;var $and164=($88)&1024;var $tobool165=((($and164))|0)!=0;if($tobool165){__label__=54;;}else{__label__=55;;}
if(__label__==54){var $89=$wflags;var $and167=($89)&1;var $tobool168=((($and167))|0)!=0;if(!($tobool168)){__label__=9;continue $while_cond$14;}}
var $90=$dictionary_flags;var $and172=($90)&33554432;var $tobool173=((($and172))|0)!=0;if($tobool173){__label__=56;;}else{__label__=57;;}
if(__label__==56){var $91=$wflags;var $and175=($91)&65536;var $tobool176=((($and175))|0)!=0;if(!($tobool176)){__label__=9;continue $while_cond$14;}}
var $92=$dictionary_flags;var $and180=($92)&16384;var $tobool181=((($and180))|0)!=0;if($tobool181){__label__=58;;}else{__label__=59;;}
if(__label__==58){var $93=$word_end;var $94=$tr_addr;var $clause_end=(($94+8292)&4294967295);var $95=HEAPU32[(($clause_end)>>2)];var $cmp183=((($93))>>>0)<((($95))>>>0);if($cmp183){__label__=9;continue $while_cond$14;}}
var $96=$dictionary_flags;var $and186=($96)&32768;var $tobool187=((($and186))|0)!=0;if($tobool187){__label__=60;;}else{__label__=61;;}
if(__label__==60){var $97=$wtab_addr;var $flags189=(($97)&4294967295);var $98=HEAP32[(($flags189)>>2)];var $and190=($98)&512;var $tobool191=((($and190))|0)!=0;if(!($tobool191)){__label__=9;continue $while_cond$14;}}
var $99=$dictionary_flags2;var $and194=($99)&8192;var $tobool195=((($and194))|0)!=0;if($tobool195){__label__=62;;}else{__label__=63;;}
if(__label__==62){var $100=$tr_addr;var $clause_terminator=(($100+8324)&4294967295);var $101=HEAP32[(($clause_terminator)>>2)];var $and197=($101)&524288;var $tobool198=((($and197))|0)!=0;if(!($tobool198)){__label__=9;continue $while_cond$14;}}
var $102=$dictionary_flags2;var $and201=($102)&16;var $tobool202=((($and201))|0)!=0;if($tobool202){__label__=64;;}else{__label__=67;;}
$if_then203$$if_end213$93:do{if(__label__==64){var $103=$tr_addr;var $expect_verb=(($103+8272)&4294967295);var $104=HEAP32[(($expect_verb)>>2)];var $tobool204=((($104))|0)!=0;if($tobool204){__label__=67;break $if_then203$$if_end213$93;}
var $105=$tr_addr;var $expect_verb_s=(($105+8280)&4294967295);var $106=HEAP32[(($expect_verb_s)>>2)];var $tobool206=((($106))|0)!=0;if(!($tobool206)){__label__=9;continue $while_cond$14;}
var $107=$end_flags_addr;var $and208=($107)&8;var $tobool209=((($and208))|0)!=0;if(!($tobool209)){__label__=9;continue $while_cond$14;}}}while(0);var $108=$dictionary_flags2;var $and214=($108)&64;var $tobool215=((($and214))|0)!=0;if($tobool215){__label__=68;;}else{__label__=69;;}
if(__label__==68){var $109=$tr_addr;var $expect_past=(($109+8276)&4294967295);var $110=HEAP32[(($expect_past)>>2)];var $tobool217=((($110))|0)!=0;if(!($tobool217)){__label__=9;continue $while_cond$14;}}
var $111=$dictionary_flags2;var $and221=($111)&32;var $tobool222=((($and221))|0)!=0;if($tobool222){__label__=70;;}else{__label__=71;;}
if(__label__==70){var $112=$tr_addr;var $expect_noun=(($112+8284)&4294967295);var $113=HEAP32[(($expect_noun)>>2)];var $tobool224=((($113))|0)!=0;if(!($tobool224)){__label__=9;continue $while_cond$14;}}
var $114=$dictionary_flags;var $and228=($114)&2097152;var $tobool229=((($and228))|0)!=0;if(!($tobool229)){__label__=74;break $while_cond$14;}
var $115=$tr_addr;var $translator_name=(($115+280)&4294967295);var $116=HEAP32[(($translator_name)>>2)];var $cmp231=((($116))|0)==26741;if(!($cmp231)){__label__=74;break $while_cond$14;}
var $117=$tr_addr;var $prev_dict_flags=(($117+8320)&4294967295);var $118=HEAP32[(($prev_dict_flags)>>2)];var $and233=($118)&1048576;var $tobool234=((($and233))|0)!=0;if($tobool234){__label__=74;break $while_cond$14;}else{__label__=9;continue $while_cond$14;}}}}while(0);var $26=$next;$p=$26;__label__=9;continue $while_cond$14;}
if(__label__==95){$retval=0;;}
else if(__label__==74){var $119=$flags_addr;var $cmp238=((($119))|0)!=0;if($cmp238){__label__=75;;}else{__label__=76;;}
if(__label__==75){var $120=$dictionary_flags;var $or240=($120)|1073741824;var $121=$flags_addr;var $arrayidx241=(($121)&4294967295);HEAP32[(($arrayidx241)>>2)]=$or240;var $122=$dictionary_flags2;var $123=$flags_addr;var $arrayidx242=(($123+4)&4294967295);HEAP32[(($arrayidx242)>>2)]=$122;;}
var $124=$phoneme_len;var $cmp244=((($124))|0)==0;if($cmp244){__label__=77;;}else{__label__=80;;}
if(__label__==77){var $125=HEAP32[((_option_phonemes)>>2)];var $cmp246=((($125))|0)==2;if($cmp246){__label__=78;;}else{__label__=79;;}
if(__label__==78){var $126=HEAP32[((_f_trans)>>2)];var $127=$word1;var $128=$flags_addr;var $call248=__Z22print_dictionary_flagsPj($128);var $call249=_fprintf($126,((__str28144)&4294967295),allocate([$127,0,0,0,((__ZZ22print_dictionary_flagsPjE3buf)&4294967295),0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
$retval=0;;}
else if(__label__==80){var $129=$flags_addr;var $cmp252=((($129))|0)!=0;if($cmp252){__label__=81;;}else{__label__=82;;}
if(__label__==81){var $130=$flags_addr;var $arrayidx254=(($130)&4294967295);var $131=HEAP32[(($arrayidx254)>>2)];var $or255=($131)|-2147483648;HEAP32[(($arrayidx254)>>2)]=$or255;;}
var $132=HEAP32[((_option_phonemes)>>2)];var $cmp257=((($132))|0)==2;if($cmp257){__label__=83;;}else{__label__=94;;}
$if_then258$$if_end296$122:do{if(__label__==83){$flags1259=0;var $133=$phonetic_addr;var $arraydecay260=(($ph_decoded)&4294967295);__Z14DecodePhonemesPKcPc($133,$arraydecay260);var $134=$flags_addr;var $cmp261=((($134))|0)!=0;if($cmp261){__label__=84;;}else{__label__=85;;}
if(__label__==84){var $135=$flags_addr;var $arrayidx263=(($135)&4294967295);var $136=HEAP32[(($arrayidx263)>>2)];$flags1259=$136;;}
var $137=$dictionary_flags;var $and265=($137)&536870912;var $cmp266=((($and265))|0)==0;if($cmp266){__label__=86;;}else{__label__=87;;}
if(__label__==86){$textmode=0;;}
else if(__label__==87){$textmode=1;;}
var $138=$textmode;var $139=HEAP32[((_translator)>>2)];var $langopts=(($139)&4294967295);var $textmode270=(($langopts+252)&4294967295);var $140=HEAP8[($textmode270)];var $conv271=(tempInt=(($140)),(tempInt>=128?tempInt-256:tempInt));var $cmp272=((($138))|0)==((($conv271))|0);if(!($cmp272)){__label__=94;break $if_then258$$if_end296$122;}
var $141=HEAP32[((_dictionary_skipwords)>>2)];var $tobool274=((($141))|0)!=0;if($tobool274){__label__=90;;}else{__label__=92;;}
$land_lhs_true275$$if_else289$132:do{if(__label__==90){var $142=$wtab_addr;var $cmp276=((($142))|0)!=0;if(!($cmp276)){__label__=92;break $land_lhs_true275$$if_else289$132;}
var $arraydecay278=(($word_buf)&4294967295);var $143=$word2_addr;var $144=$word_end;var $145=$word2_addr;var $sub_ptr_lhs_cast279=($144);var $sub_ptr_rhs_cast280=($145);var $sub_ptr_sub281=((($sub_ptr_lhs_cast279)-($sub_ptr_rhs_cast280))&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$143;$dest$=$arraydecay278;$stop$=$src$+$sub_ptr_sub281;if(($dest$%4)==($src$%4)&&$sub_ptr_sub281>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $146=$word_end;var $147=$word2_addr;var $sub_ptr_lhs_cast282=($146);var $sub_ptr_rhs_cast283=($147);var $sub_ptr_rhs_cast283_neg=(((-($sub_ptr_rhs_cast283)))&4294967295);var $sub_ptr_sub284=((($sub_ptr_lhs_cast282)-1)&4294967295);var $sub285=((($sub_ptr_sub284)+($sub_ptr_rhs_cast283_neg))&4294967295);var $arrayidx286=(($word_buf+$sub285)&4294967295);HEAP8[($arrayidx286)]=0;var $148=HEAP32[((_f_trans)>>2)];var $149=$word1;var $arraydecay287=(($word_buf)&4294967295);var $call288=_fprintf($148,((__str29145)&4294967295),allocate([$149,0,0,0,$arraydecay287,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));__label__=93;break $land_lhs_true275$$if_else289$132;}}while(0);if(__label__==92){var $150=HEAP32[((_f_trans)>>2)];var $151=$word1;var $call290=_fprintf($150,((__str30146)&4294967295),allocate([$151,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
var $152=HEAP32[((_f_trans)>>2)];var $arraydecay292=(($ph_decoded)&4294967295);var $153=$flags_addr;var $call293=__Z22print_dictionary_flagsPj($153);var $call294=_fprintf($152,((__str31147)&4294967295),allocate([$arraydecay292,0,0,0,((__ZZ22print_dictionary_flagsPjE3buf)&4294967295),0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}while(0);var $154=$word_end;$retval=$154;;}}}
var $155=$retval;STACKTOP=__stackBase__;return $155;return null;}
function __Z11LookupFlagsP10TranslatorPKc($tr,$word){var __stackBase__=STACKTOP;STACKTOP+=104;_memset(__stackBase__,0,104);var __label__;var $tr_addr;var $word_addr;var $buf=__stackBase__;var $word1=__stackBase__+100;$tr_addr=$tr;$word_addr=$word;HEAP32[((((__ZZ11LookupFlagsP10TranslatorPKcE5flags+4)&4294967295))>>2)]=0;HEAP32[((((__ZZ11LookupFlagsP10TranslatorPKcE5flags)&4294967295))>>2)]=0;var $0=$word_addr;HEAP32[(($word1)>>2)]=$0;var $1=$tr_addr;var $arraydecay=(($buf)&4294967295);var $call=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($1,$word1,$arraydecay,((__ZZ11LookupFlagsP10TranslatorPKcE5flags)&4294967295),0,0);var $2=HEAP32[((((__ZZ11LookupFlagsP10TranslatorPKcE5flags)&4294967295))>>2)];STACKTOP=__stackBase__;return $2;return null;}
function __Z12RemoveEndingP10TranslatorPciS1_($tr,$word,$end_type,$word_copy){;var __label__;var __lastLabel__=null;var $tr_addr;var $word_addr;var $end_type_addr;var $word_copy_addr;var $i;var $word_end;var $len_ending;var $end_flags;var $p;var $len;$tr_addr=$tr;$word_addr=$word;$end_type_addr=$end_type;$word_copy_addr=$word_copy;var $0=$word_addr;$word_end=$0;var $1=$word_end;var $2=HEAP8[($1)];var $conv8=(tempInt=(($2)),(tempInt>=128?tempInt-256:tempInt));var $cmp10=((($conv8))|0)!=32;var $3=$word_end;if($cmp10){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=4;;}
$for_body$$for_end$2:do{if(__label__==1){while(1){var $4=__lastLabel__==3?$10:($3);var $5=HEAP8[($4)];var $conv1=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));var $cmp2=((($conv1))|0)==69;if($cmp2){__label__=2;;}else{__label__=3;;}
if(__label__==2){var $6=$word_end;HEAP8[($6)]=101;;}
var $7=$word_end;var $incdec_ptr=(($7+1)&4294967295);$word_end=$incdec_ptr;var $8=$word_end;var $9=HEAP8[($8)];var $conv=(tempInt=(($9)),(tempInt>=128?tempInt-256:tempInt));var $cmp=((($conv))|0)!=32;var $10=$word_end;if($cmp){__lastLabel__=3;__label__=1;continue;}else{__lastLabel__=3;__label__=4;break $for_body$$for_end$2;}}}}while(0);var $_lcssa7=__lastLabel__==0?$3:($10);var $11=$word_addr;var $sub_ptr_lhs_cast=($_lcssa7);var $sub_ptr_rhs_cast=($11);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);$i=$sub_ptr_sub;var $12=$word_copy_addr;var $13=$word_addr;var $14=$i;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$13;$dest$=$12;$stop$=$src$+$14;if(($dest$%4)==($src$%4)&&$14>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $15=$i;var $16=$word_copy_addr;var $arrayidx=(($16+$15)&4294967295);HEAP8[($arrayidx)]=0;var $17=$end_type_addr;var $and=($17)&63;$i=$and;$len_ending=$and;var $cmp46=((($and))|0)>0;if($cmp46){__label__=5;;}else{__label__=8;;}
$for_body5$$for_end12$9:do{if(__label__==5){$for_body5$10:while(1){var $18=$word_end;var $incdec_ptr6=(($18+-1)&4294967295);$word_end=$incdec_ptr6;var $19=$word_end;var $20=HEAP8[($19)];var $conv73=(tempInt=(($20)),(tempInt>=128?tempInt-256:tempInt));var $and84=($conv73)&192;var $cmp95=((($and84))|0)==128;if($cmp95){__label__=6;;}else{__label__=7;;}
$while_body$$for_inc11$12:do{if(__label__==6){while(1){var $21=$word_end;var $incdec_ptr10=(($21+-1)&4294967295);$word_end=$incdec_ptr10;var $22=$len_ending;var $inc=((($22)+1)&4294967295);$len_ending=$inc;var $23=$word_end;var $24=HEAP8[($23)];var $conv7=(tempInt=(($24)),(tempInt>=128?tempInt-256:tempInt));var $and8=($conv7)&192;var $cmp9=((($and8))|0)==128;if($cmp9){__label__=6;continue;}else{__label__=7;break $while_body$$for_inc11$12;}}}}while(0);var $25=$i;var $dec=((($25)-1)&4294967295);$i=$dec;var $cmp4=((($dec))|0)>0;if($cmp4){__label__=5;continue $for_body5$10;}else{__label__=8;break $for_body5$$for_end12$9;}}}}while(0);$i=0;var $26=$i;var $27=$len_ending;var $cmp142=((($26))|0)<((($27))|0);var $28=$i;if($cmp142){__lastLabel__=8;__label__=9;;}else{__lastLabel__=8;__label__=10;;}
$for_body15$$for_end21$17:do{if(__label__==9){while(1){var $29=__lastLabel__==9?$38:($28);var $30=$word_end;var $arrayidx16=(($30+$29)&4294967295);var $31=HEAP8[($arrayidx16)];var $32=$i;var $arrayidx17=((__ZZ12RemoveEndingP10TranslatorPciS1_E6ending+$32)&4294967295);HEAP8[($arrayidx17)]=$31;var $33=$i;var $34=$word_end;var $arrayidx18=(($34+$33)&4294967295);HEAP8[($arrayidx18)]=32;var $35=$i;var $inc20=((($35)+1)&4294967295);$i=$inc20;var $36=$i;var $37=$len_ending;var $cmp14=((($36))|0)<((($37))|0);var $38=$i;if($cmp14){__lastLabel__=9;__label__=9;continue;}else{__lastLabel__=9;__label__=10;break $for_body15$$for_end21$17;}}}}while(0);var $_lcssa=__lastLabel__==8?$28:($38);var $arrayidx22=((__ZZ12RemoveEndingP10TranslatorPciS1_E6ending+$_lcssa)&4294967295);HEAP8[($arrayidx22)]=0;var $39=$word_end;var $incdec_ptr23=(($39+-1)&4294967295);$word_end=$incdec_ptr23;var $40=$end_type_addr;var $and24=($40)&65520;var $or=($and24)|4;$end_flags=$or;var $41=$end_type_addr;var $and25=($41)&512;var $tobool=((($and25))|0)!=0;if($tobool){__label__=11;;}else{__label__=13;;}
$if_then26$$if_end33$21:do{if(__label__==11){var $42=$word_end;var $arrayidx27=(($42)&4294967295);var $43=HEAP8[($arrayidx27)];var $conv28=(tempInt=(($43)),(tempInt>=128?tempInt-256:tempInt));var $cmp29=((($conv28))|0)==105;if(!($cmp29)){__label__=13;break $if_then26$$if_end33$21;}
var $44=$word_end;var $arrayidx31=(($44)&4294967295);HEAP8[($arrayidx31)]=121;;}}while(0);var $45=$end_type_addr;var $and34=($45)&256;var $tobool35=((($and34))|0)!=0;if($tobool35){__label__=14;;}else{__label__=33;;}
$if_then36$$if_end98$25:do{if(__label__==14){var $46=$tr_addr;var $translator_name=(($46+280)&4294967295);var $47=HEAP32[(($translator_name)>>2)];var $cmp37=((($47))|0)==25966;var $48=$tr_addr;if($cmp37){__label__=15;;}else{__label__=28;;}
$if_then38$$if_else80$27:do{if(__label__==15){var $49=$word_end;var $arrayidx39=(($49+-1)&4294967295);var $50=HEAP8[($arrayidx39)];var $conv40=(tempInt=(($50)),(tempInt>=128?tempInt-256:tempInt));var $call=__ZL8IsLetterP10Translatorii($48,$conv40,7);var $tobool41=((($call))|0)!=0;if($tobool41){__label__=16;;}else{__label__=23;;}
$land_lhs_true$$if_else$29:do{if(__label__==16){var $51=$tr_addr;var $52=$word_end;var $arrayidx42=(($52)&4294967295);var $53=HEAP8[($arrayidx42)];var $conv43=(tempInt=(($53)),(tempInt>=128?tempInt-256:tempInt));var $call44=__ZL8IsLetterP10Translatorii($51,$conv43,1);var $tobool45=((($call44))|0)!=0;if(!($tobool45)){__label__=23;break $land_lhs_true$$if_else$29;}
$i=0;;while(1){var $54=$i;var $arrayidx48=((__ZZ12RemoveEndingP10TranslatorPciS1_E16add_e_exceptions+$54*4)&4294967295);var $55=HEAP32[(($arrayidx48)>>2)];$p=$55;var $cmp49=((($55))|0)!=0;if(!($cmp49)){__label__=22;break;}
var $56=$p;var $call51=_strlen($56);$len=$call51;var $57=$p;var $58=$len;var $sub=((1-($58))&4294967295);var $59=$word_end;var $arrayidx52=(($59+$sub)&4294967295);var $60=$len;var $call53=_memcmp($57,$arrayidx52,$60);var $cmp54=((($call53))|0)==0;if($cmp54){__label__=21;break;}
var $61=$i;var $inc58=((($61)+1)&4294967295);$i=$inc58;__label__=18;continue;}
if(__label__==21){var $_pr=$p;var $cmp60=((($_pr))|0)==0;if(!($cmp60)){__label__=30;break $if_then38$$if_else80$27;}}
var $62=$end_flags;var $or62=($62)|16;$end_flags=$or62;__label__=30;break $if_then38$$if_else80$27;}}while(0);$i=0;;while(1){var $63=$i;var $arrayidx65=((__ZZ12RemoveEndingP10TranslatorPciS1_E15add_e_additions+$63*4)&4294967295);var $64=HEAP32[(($arrayidx65)>>2)];$p=$64;var $cmp66=((($64))|0)!=0;if(!($cmp66)){__label__=30;break $if_then38$$if_else80$27;}
var $65=$p;var $call68=_strlen($65);$len=$call68;var $66=$p;var $67=$len;var $sub69=((1-($67))&4294967295);var $68=$word_end;var $arrayidx70=(($68+$sub69)&4294967295);var $69=$len;var $call71=_memcmp($66,$arrayidx70,$69);var $cmp72=((($call71))|0)==0;if($cmp72){__label__=26;break;}
var $71=$i;var $inc77=((($71)+1)&4294967295);$i=$inc77;__label__=24;continue;}
var $70=$end_flags;var $or74=($70)|16;$end_flags=$or74;;}
else if(__label__==28){var $langopts=(($48)&4294967295);var $suffix_add_e=(($langopts+276)&4294967295);var $72=HEAP32[(($suffix_add_e)>>2)];var $cmp81=((($72))|0)!=0;if(!($cmp81)){__label__=30;break $if_then38$$if_else80$27;}
var $73=$end_flags;var $or83=($73)|16;$end_flags=$or83;;}}while(0);var $74=$end_flags;var $and86=($74)&16;var $tobool87=((($and86))|0)!=0;if(!($tobool87)){__label__=33;break $if_then36$$if_end98$25;}
var $75=$tr_addr;var $langopts89=(($75)&4294967295);var $suffix_add_e90=(($langopts89+276)&4294967295);var $76=HEAP32[(($suffix_add_e90)>>2)];var $77=$word_end;var $arrayidx91=(($77+1)&4294967295);var $call92=__Z8utf8_outjPc($76,$arrayidx91);var $78=HEAP32[((_option_phonemes)>>2)];var $cmp93=((($78))|0)==2;if(!($cmp93)){__label__=33;break $if_then36$$if_end98$25;}
var $79=HEAP32[((_f_trans)>>2)];var $80=_fwrite(((__str25141)&4294967295),6,1,$79);;}}while(0);var $81=$end_type_addr;var $and99=($81)&2048;var $tobool100=((($and99))|0)!=0;if($tobool100){__label__=34;;}else{__label__=36;;}
$land_lhs_true101$$if_end105$51:do{if(__label__==34){var $82=$tr_addr;var $expect_verb=(($82+8272)&4294967295);var $83=HEAP32[(($expect_verb)>>2)];var $cmp102=((($83))|0)==0;if(!($cmp102)){__label__=36;break $land_lhs_true101$$if_end105$51;}
var $84=$tr_addr;var $expect_verb104=(($84+8272)&4294967295);HEAP32[(($expect_verb104)>>2)]=1;;}}while(0);var $call106=_strcmp(((__ZZ12RemoveEndingP10TranslatorPciS1_E6ending)&4294967295),((__str5172)&4294967295));var $cmp107=((($call106))|0)==0;if($cmp107){__label__=38;;}else{__label__=37;;}
$if_then110$$lor_lhs_false$55:do{if(__label__==37){var $call108=_strcmp(((__ZZ12RemoveEndingP10TranslatorPciS1_E6ending)&4294967295),((__str27143)&4294967295));var $cmp109=((($call108))|0)==0;if($cmp109){__label__=38;break $if_then110$$lor_lhs_false$55;}else{__label__=39;break $if_then110$$lor_lhs_false$55;}}}while(0);if(__label__==38){var $85=$end_flags;var $or111=($85)|8;$end_flags=$or111;;}
var $86=HEAP8[(((__ZZ12RemoveEndingP10TranslatorPciS1_E6ending)&4294967295))];var $conv113=(tempInt=(($86)),(tempInt>=128?tempInt-256:tempInt));var $cmp114=((($conv113))|0)==39;if($cmp114){__label__=40;;}else{__label__=41;;}
if(__label__==40){var $87=$end_flags;var $and116=($87)&-5;$end_flags=$and116;;}
var $88=$end_flags;;return $88;return null;}
function __ZL13IsLetterGroupP10TranslatorPcii($tr,$word,$group,$pre){;var __label__;var $retval;var $tr_addr;var $word_addr;var $group_addr;var $pre_addr;var $p;var $w;var $len;$tr_addr=$tr;$word_addr=$word;$group_addr=$group;$pre_addr=$pre;$len=0;var $0=$group_addr;var $1=$tr_addr;var $letterGroups=(($1+5152)&4294967295);var $arrayidx=(($letterGroups+$0*4)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];$p=$2;var $3=$p;var $cmp=((($3))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=0;;}
else if(__label__==2){$while_cond$4:while(1){var $4=$p;var $5=HEAP8[($4)];var $conv=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));var $cmp1=((($conv))|0)!=7;if(!($cmp1)){__label__=13;break $while_cond$4;}
var $6=$pre_addr;var $tobool=((($6))|0)!=0;if($tobool){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $7=$p;var $call=_strlen($7);$len=$call;var $8=$word_addr;var $9=$len;var $idx_neg=(((-($9)))&4294967295);var $add_ptr=(($8+$idx_neg)&4294967295);var $add_ptr3=(($add_ptr+1)&4294967295);$w=$add_ptr3;;}
else if(__label__==5){var $10=$word_addr;$w=$10;;}
var $11=$p;var $12=HEAP8[($11)];var $conv61=(tempInt=(($12)),(tempInt>=128?tempInt-256:tempInt));var $13=$w;var $14=HEAP8[($13)];var $conv72=(tempInt=(($14)),(tempInt>=128?tempInt-256:tempInt));var $cmp83=((($conv61))|0)==((($conv72))|0);if($cmp83){__label__=7;;}else{__label__=8;;}
$while_body9$$while_end$11:do{if(__label__==7){while(1){var $15=$w;var $incdec_ptr=(($15+1)&4294967295);$w=$incdec_ptr;var $16=$p;var $incdec_ptr10=(($16+1)&4294967295);$p=$incdec_ptr10;var $17=$p;var $18=HEAP8[($17)];var $conv6=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));var $19=$w;var $20=HEAP8[($19)];var $conv7=(tempInt=(($20)),(tempInt>=128?tempInt-256:tempInt));var $cmp8=((($conv6))|0)==((($conv7))|0);if($cmp8){__label__=7;continue;}else{__label__=8;break $while_body9$$while_end$11;}}}}while(0);var $21=$p;var $22=HEAP8[($21)];var $conv11=(tempInt=(($22)),(tempInt>=128?tempInt-256:tempInt));var $cmp12=((($conv11))|0)==0;if($cmp12){__label__=9;break $while_cond$4;}
while(1){var $27=$p;var $incdec_ptr19=(($27+1)&4294967295);$p=$incdec_ptr19;var $28=HEAP8[($27)];var $conv20=(tempInt=(($28)),(tempInt>=128?tempInt-256:tempInt));var $cmp21=((($conv20))|0)!=0;if($cmp21){__label__=12;continue;}else{__label__=2;continue $while_cond$4;}}}
if(__label__==13){$retval=0;;}
else if(__label__==9){var $23=$pre_addr;var $tobool14=((($23))|0)!=0;if($tobool14){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $24=$len;$retval=$24;;}
else if(__label__==11){var $25=$w;var $26=$word_addr;var $sub_ptr_lhs_cast=($25);var $sub_ptr_rhs_cast=($26);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);$retval=$sub_ptr_sub;;}}}
var $29=$retval;;return $29;return null;}
function __Z11CalcPitchesP10Translatori($tr,$clause_type){var __stackBase__=STACKTOP;STACKTOP+=6000;_memset(__stackBase__,0,6000);var __label__;var __lastLabel__=null;var $tr_addr;var $clause_type_addr;var $p;var $syl;var $ix;var $x;var $st_ix;var $n_st;var $option;var $group_tone;var $group_tone_emph;var $group_tone_comma;var $ph_start;var $st_start;var $st_clause_end;var $count;var $n_primary;var $count_primary;var $ph;var $ph_end;var $syllable_tab2=__stackBase__;$tr_addr=$tr;$clause_type_addr=$clause_type;$ph_start=0;var $0=HEAP32[((_n_phoneme_list)>>2)];$ph_end=$0;var $arraydecay=(($syllable_tab2)&4294967295);HEAP32[((__ZL12syllable_tab)>>2)]=$arraydecay;$n_st=0;$n_primary=0;$ix=0;var $1=$ix;var $2=HEAP32[((_n_phoneme_list)>>2)];var $sub4=((($2)-1)&4294967295);var $cmp5=((($1))|0)<((($sub4))|0);if($cmp5){__label__=1;;}else{__label__=8;;}
$for_body$$for_end$2:do{if(__label__==1){$for_body$3:while(1){var $3=$ix;var $arrayidx=((_phoneme_list+$3*24)&4294967295);$p=$arrayidx;var $4=$p;var $synthflags=(($4+4)&4294967295);var $5=HEAPU16[(($synthflags)>>1)];var $conv=((($5))&65535);var $and=($conv)&4;var $tobool=((($and))|0)!=0;if($tobool){__label__=2;;}else{__label__=4;;}
$if_then$$if_else$5:do{if(__label__==2){var $6=$n_st;var $7=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx1=(($7+6*$6)&4294967295);var $flags=(($arrayidx1+2)&4294967295);HEAP8[($flags)]=0;var $8=$n_st;var $9=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx2=(($9+6*$8)&4294967295);var $env=(($arrayidx2+1)&4294967295);HEAP8[($env)]=0;var $10=$ix;var $add=((($10)+1)&4294967295);var $arrayidx3=((_phoneme_list+$add*24)&4294967295);var $type=(($arrayidx3+15)&4294967295);var $11=HEAP8[($type)];var $12=$n_st;var $13=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx4=(($13+6*$12)&4294967295);var $nextph_type=(($arrayidx4+3)&4294967295);HEAP8[($nextph_type)]=$11;var $14=$p;var $stresslevel=(($14+1)&4294967295);var $15=HEAP8[($stresslevel)];var $16=$n_st;var $inc=((($16)+1)&4294967295);$n_st=$inc;var $17=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx5=(($17+6*$16)&4294967295);var $stress=(($arrayidx5)&4294967295);HEAP8[($stress)]=$15;var $18=$p;var $stresslevel6=(($18+1)&4294967295);var $19=HEAPU8[($stresslevel6)];var $conv7=((($19))&255);var $cmp8=((($conv7))|0)>=4;if(!($cmp8)){__label__=7;break $if_then$$if_else$5;}
var $20=$n_primary;var $inc10=((($20)+1)&4294967295);$n_primary=$inc10;;}
else if(__label__==4){var $21=$p;var $ph11=(($21+8)&4294967295);var $22=HEAP32[(($ph11)>>2)];var $code=(($22+10)&4294967295);var $23=HEAPU8[($code)];var $conv12=((($23))&255);var $cmp13=((($conv12))|0)==27;if(!($cmp13)){__label__=7;break $if_then$$if_else$5;}
var $24=$n_st;var $cmp14=((($24))|0)>0;if(!($cmp14)){__label__=7;break $if_then$$if_else$5;}
var $25=$n_st;var $sub16=((($25)-1)&4294967295);var $26=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx17=(($26+6*$sub16)&4294967295);var $flags18=(($arrayidx17+2)&4294967295);var $27=HEAP8[($flags18)];var $conv19=(tempInt=(($27)),(tempInt>=128?tempInt-256:tempInt));var $or=($conv19)|4;var $conv20=((($or))&255);HEAP8[($flags18)]=$conv20;;}}while(0);var $28=$ix;var $inc23=((($28)+1)&4294967295);$ix=$inc23;var $29=$ix;var $30=HEAP32[((_n_phoneme_list)>>2)];var $sub=((($30)-1)&4294967295);var $cmp=((($29))|0)<((($sub))|0);if($cmp){__label__=1;continue $for_body$3;}else{__label__=8;break $for_body$$for_end$2;}}}}while(0);var $31=$n_st;var $32=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx24=(($32+6*$31)&4294967295);var $stress25=(($arrayidx24)&4294967295);HEAP8[($stress25)]=0;var $33=$n_st;var $cmp26=((($33))|0)==0;if($cmp26){__label__=70;;}else{__label__=9;;}
$for_end258$$if_end28$13:do{if(__label__==9){var $34=$tr_addr;var $langopts=(($34)&4294967295);var $tone_language=(($langopts+224)&4294967295);var $35=HEAP32[(($tone_language)>>2)];var $cmp29=((($35))|0)==1;var $36=$tr_addr;if($cmp29){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $37=$clause_type_addr;__ZL16CalcPitches_ToneP10Translatori($36,$37);;}
else if(__label__==11){var $langopts32=(($36)&4294967295);var $intonation_group=(($langopts32+228)&4294967295);var $38=HEAP32[(($intonation_group)>>2)];$option=$38;var $39=$option;var $cmp33=((($39))|0)>=8;if($cmp33){__label__=12;;}else{__label__=13;;}
$if_end35_thread$$if_end35$18:do{if(__label__==12){$option=1;var $40=$clause_type_addr;__lastLabel__=12;__label__=15;break $if_end35_thread$$if_end35$18;}
else if(__label__==13){var $cmp36=((($39))|0)==0;var $41=$clause_type_addr;if($cmp36){__lastLabel__=13;;}else{__lastLabel__=13;__label__=15;break $if_end35_thread$$if_end35$18;}
var $42=$tr_addr;var $langopts38=(($42)&4294967295);var $tunes=(($langopts38+232)&4294967295);var $arrayidx39=(($tunes+$41)&4294967295);var $43=HEAPU8[($arrayidx39)];var $conv40=((($43))&255);$group_tone=$conv40;var $44=$tr_addr;var $langopts41=(($44)&4294967295);var $tunes42=(($langopts41+232)&4294967295);var $arrayidx43=(($tunes42+5)&4294967295);var $45=HEAPU8[($arrayidx43)];var $conv44=((($45))&255);$group_tone_emph=$conv44;var $46=$tr_addr;var $langopts45=(($46)&4294967295);var $tunes46=(($langopts45+232)&4294967295);var $arrayidx47=(($tunes46+1)&4294967295);var $47=HEAPU8[($arrayidx47)];var $conv48=((($47))&255);$group_tone_comma=$conv48;__label__=16;break $if_end35_thread$$if_end35$18;}}while(0);if(__label__==15){var $48=__lastLabel__==12?$40:($41);var $49=$option;var $50=$tr_addr;var $punct_to_tone=(($50+1000)&4294967295);var $arrayidx50=(($punct_to_tone+$49*6)&4294967295);var $arrayidx51=(($arrayidx50+$48)&4294967295);var $51=HEAPU8[($arrayidx51)];var $conv52=((($51))&255);$group_tone=$conv52;var $52=$option;var $53=$tr_addr;var $punct_to_tone53=(($53+1000)&4294967295);var $arrayidx54=(($punct_to_tone53+$52*6)&4294967295);var $arrayidx55=(($arrayidx54+5)&4294967295);var $54=HEAPU8[($arrayidx55)];var $conv56=((($54))&255);$group_tone_emph=$conv56;var $55=$option;var $56=$tr_addr;var $punct_to_tone57=(($56+1000)&4294967295);var $arrayidx58=(($punct_to_tone57+$55*6)&4294967295);var $arrayidx59=(($arrayidx58+1)&4294967295);var $57=HEAPU8[($arrayidx59)];var $conv60=((($57))&255);$group_tone_comma=$conv60;;}
var $58=$clause_type_addr;var $cmp62=((($58))|0)==4;if($cmp62){__label__=17;;}else{__label__=18;;}
if(__label__==17){HEAP8[(__ZL8no_tonic_b)]=1;;}
else if(__label__==18){HEAP8[(__ZL8no_tonic_b)]=0;;}
$st_start=0;$count_primary=0;$st_ix=0;var $59=$st_ix;var $60=$n_st;var $cmp673=((($59))|0)<((($60))|0);if($cmp673){__label__=20;;}else{__label__=54;;}
$for_body68$$for_end177$29:do{if(__label__==20){$for_body68$30:while(1){var $61=$st_ix;var $62=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx69=(($62+6*$61)&4294967295);$syl=$arrayidx69;var $63=$syl;var $stress70=(($63)&4294967295);var $64=HEAP8[($stress70)];var $conv71=(tempInt=(($64)),(tempInt>=128?tempInt-256:tempInt));var $cmp72=((($conv71))|0)>=4;if($cmp72){__label__=21;;}else{__label__=22;;}
if(__label__==21){var $65=$count_primary;var $inc74=((($65)+1)&4294967295);$count_primary=$inc74;;}
var $66=$syl;var $stress76=(($66)&4294967295);var $67=HEAP8[($stress76)];var $conv77=(tempInt=(($67)),(tempInt>=128?tempInt-256:tempInt));var $cmp78=((($conv77))|0)==6;if($cmp78){__label__=23;;}else{__label__=36;;}
$if_then79$$if_end124$35:do{if(__label__==23){var $68=$st_ix;var $sub80=((($68)-1)&4294967295);$ix=$sub80;;$for_cond81$37:while(1){var $69=$ix;var $70=$st_start;var $cmp82=((($69))|0)>=((($70))|0);if(!($cmp82)){__label__=30;break $for_cond81$37;}
var $71=$ix;var $72=$st_ix;var $sub83=((($72)-3)&4294967295);var $cmp84=((($71))|0)>=((($sub83))|0);if(!($cmp84)){__label__=30;break $for_cond81$37;}
var $73=$ix;var $74=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx86=(($74+6*$73)&4294967295);var $stress87=(($arrayidx86)&4294967295);var $75=HEAP8[($stress87)];var $conv88=(tempInt=(($75)),(tempInt>=128?tempInt-256:tempInt));var $cmp89=((($conv88))|0)==6;if($cmp89){__label__=30;break $for_cond81$37;}
var $76=$ix;var $77=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx92=(($77+6*$76)&4294967295);var $stress93=(($arrayidx92)&4294967295);var $78=HEAP8[($stress93)];var $conv94=(tempInt=(($78)),(tempInt>=128?tempInt-256:tempInt));var $cmp95=((($conv94))|0)==4;var $79=$ix;if($cmp95){__label__=28;break $for_cond81$37;}
var $dec=((($79)-1)&4294967295);$ix=$dec;__label__=24;continue $for_cond81$37;}
if(__label__==28){var $80=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx97=(($80+6*$79)&4294967295);var $stress98=(($arrayidx97)&4294967295);HEAP8[($stress98)]=3;;}
var $81=$st_ix;var $add102=((($81)+1)&4294967295);$ix=$add102;;while(1){var $82=$ix;var $83=$n_st;var $cmp104=((($82))|0)<((($83))|0);if(!($cmp104)){__label__=36;break $if_then79$$if_end124$35;}
var $84=$ix;var $85=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx106=(($85+6*$84)&4294967295);var $stress107=(($arrayidx106)&4294967295);var $86=HEAP8[($stress107)];var $conv108=(tempInt=(($86)),(tempInt>=128?tempInt-256:tempInt));var $cmp109=((($conv108))|0)==4;if($cmp109){__label__=36;break $if_then79$$if_end124$35;}
var $87=$ix;var $88=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx112=(($88+6*$87)&4294967295);var $stress113=(($arrayidx112)&4294967295);var $89=HEAP8[($stress113)];var $conv114=(tempInt=(($89)),(tempInt>=128?tempInt-256:tempInt));var $cmp115=((($conv114))|0)==6;if($cmp115){__label__=34;break;}
var $93=$ix;var $inc122=((($93)+1)&4294967295);$ix=$inc122;__label__=31;continue;}
var $90=$st_ix;var $91=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx117=(($91+6*$90)&4294967295);var $flags118=(($arrayidx117+2)&4294967295);HEAP8[($flags118)]=2;var $92=$syl;var $stress119=(($92)&4294967295);HEAP8[($stress119)]=5;;}}while(0);var $94=$syl;var $stress125=(($94)&4294967295);var $95=HEAP8[($stress125)];var $conv126=(tempInt=(($95)),(tempInt>=128?tempInt-256:tempInt));var $cmp127=((($conv126))|0)==6;if($cmp127){__label__=37;;}else{__label__=50;;}
if(__label__==37){var $96=$st_ix;var $97=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx129=(($97+6*$96)&4294967295);var $flags130=(($arrayidx129+2)&4294967295);HEAP8[($flags130)]=2;$count=0;var $98=$n_primary;var $99=$count_primary;var $sub131=((($98)-($99))&4294967295);var $cmp132=((($sub131))|0)>1;if($cmp132){__label__=38;;}else{__label__=39;;}
if(__label__==38){$count=1;;}
var $100=$st_ix;var $add135=((($100)+1)&4294967295);$ix=$add135;;$for_cond136$58:while(1){var $101=$ix;var $102=$n_st;var $cmp137=((($101))|0)<((($102))|0);if(!($cmp137)){__label__=45;break $for_cond136$58;}
var $103=$ix;var $104=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx139=(($104+6*$103)&4294967295);var $stress140=(($arrayidx139)&4294967295);var $105=HEAP8[($stress140)];var $conv141=(tempInt=(($105)),(tempInt>=128?tempInt-256:tempInt));var $cmp142=((($conv141))|0)>4;if($cmp142){__label__=45;break $for_cond136$58;}
var $106=$ix;var $107=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx145=(($107+6*$106)&4294967295);var $stress146=(($arrayidx145)&4294967295);var $108=HEAP8[($stress146)];var $conv147=(tempInt=(($108)),(tempInt>=128?tempInt-256:tempInt));var $cmp148=((($conv147))|0)==4;if($cmp148){__label__=43;;}else{__label__=44;;}
if(__label__==43){var $109=$count;var $inc150=((($109)+1)&4294967295);$count=$inc150;var $110=$count;var $cmp151=((($110))|0)>1;if($cmp151){__label__=45;break $for_cond136$58;}}
var $111=$ix;var $inc156=((($111)+1)&4294967295);$ix=$inc156;__label__=40;continue $for_cond136$58;}
var $112=$st_start;var $113=$ix;var $114=$n_st;__ZL18count_pitch_vowelsiii($112,$113,$114);var $115=$ix;var $116=$n_st;var $cmp158=((($115))|0)<((($116))|0);if($cmp158){__label__=47;;}else{__label__=46;;}
$if_then160$$lor_lhs_false$66:do{if(__label__==46){var $117=$clause_type_addr;var $cmp159=((($117))|0)==0;if($cmp159){__label__=47;break $if_then160$$lor_lhs_false$66;}
var $122=$option;var $123=$st_start;var $124=$ix;var $125=$group_tone;__ZL12calc_pitchesiiii($122,$123,$124,$125);__label__=49;break $if_then160$$lor_lhs_false$66;}}while(0);if(__label__==47){var $118=$option;var $119=$st_start;var $120=$ix;var $121=$group_tone_emph;__ZL12calc_pitchesiiii($118,$119,$120,$121);;}
var $126=$ix;$st_start=$126;;}
var $127=$st_start;var $128=$st_ix;var $cmp165=((($127))|0)<((($128))|0);if($cmp165){__label__=51;;}else{__label__=53;;}
$land_lhs_true166$$for_inc175$73:do{if(__label__==51){var $129=$syl;var $flags167=(($129+2)&4294967295);var $130=HEAP8[($flags167)];var $conv168=(tempInt=(($130)),(tempInt>=128?tempInt-256:tempInt));var $and169=($conv168)&4;var $tobool170=((($and169))|0)!=0;if(!($tobool170)){__label__=53;break $land_lhs_true166$$for_inc175$73;}
var $131=$st_ix;var $add172=((($131)+1)&4294967295);$st_clause_end=$add172;var $132=$st_start;var $133=$st_clause_end;var $134=$st_clause_end;__ZL18count_pitch_vowelsiii($132,$133,$134);var $135=$option;var $136=$st_start;var $137=$st_clause_end;var $138=$group_tone_comma;__ZL12calc_pitchesiiii($135,$136,$137,$138);var $139=$st_clause_end;$st_start=$139;;}}while(0);var $140=$st_ix;var $inc176=((($140)+1)&4294967295);$st_ix=$inc176;var $141=$st_ix;var $142=$n_st;var $cmp67=((($141))|0)<((($142))|0);if($cmp67){__label__=20;continue $for_body68$30;}else{__label__=54;break $for_body68$$for_end177$29;}}}}while(0);var $143=$st_start;var $144=$st_ix;var $cmp178=((($143))|0)<((($144))|0);if($cmp178){__label__=55;;}else{__label__=56;;}
if(__label__==55){var $145=$st_start;var $146=$st_ix;var $147=$n_st;__ZL18count_pitch_vowelsiii($145,$146,$147);var $148=$option;var $149=$st_start;var $150=$st_ix;var $151=$group_tone;__ZL12calc_pitchesiiii($148,$149,$150,$151);;}
$st_ix=0;var $152=$ph_start;$ix=$152;var $153=$ix;var $154=$ph_end;var $cmp1832=((($153))|0)<((($154))|0);if(!($cmp1832)){__label__=70;break $for_end258$$if_end28$13;}
$for_body184$81:while(1){var $155=$ix;var $arrayidx185=((_phoneme_list+$155*24)&4294967295);$p=$arrayidx185;var $156=$st_ix;var $157=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx186=(($157+6*$156)&4294967295);var $stress187=(($arrayidx186)&4294967295);var $158=HEAP8[($stress187)];var $159=$p;var $stresslevel188=(($159+1)&4294967295);HEAP8[($stresslevel188)]=$158;var $160=$p;var $synthflags189=(($160+4)&4294967295);var $161=HEAPU16[(($synthflags189)>>1)];var $conv190=((($161))&65535);var $and191=($conv190)&4;var $tobool192=((($and191))|0)!=0;if($tobool192){__label__=58;;}else{__label__=69;;}
if(__label__==58){var $162=$st_ix;var $163=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx194=(($163+6*$162)&4294967295);$syl=$arrayidx194;var $164=$syl;var $pitch1=(($164+4)&4294967295);var $165=HEAP8[($pitch1)];var $166=$p;var $pitch1195=(($166+20)&4294967295);HEAP8[($pitch1195)]=$165;var $167=$syl;var $pitch2=(($167+5)&4294967295);var $168=HEAP8[($pitch2)];var $169=$p;var $pitch2196=(($169+21)&4294967295);HEAP8[($pitch2196)]=$168;var $170=$p;var $env197=(($170+14)&4294967295);HEAP8[($env197)]=0;var $171=$syl;var $flags198=(($171+2)&4294967295);var $172=HEAP8[($flags198)];var $conv199=(tempInt=(($172)),(tempInt>=128?tempInt-256:tempInt));var $and200=($conv199)&1;var $tobool201=((($and200))|0)!=0;var $173=$p;if($tobool201){__label__=59;;}else{__label__=60;;}
$if_then202$$if_else204$85:do{if(__label__==59){var $env203=(($173+14)&4294967295);HEAP8[($env203)]=2;;}
else if(__label__==60){var $stresslevel205=(($173+1)&4294967295);var $174=HEAPU8[($stresslevel205)];var $conv206=((($174))&255);var $cmp207=((($conv206))|0)>5;if(!($cmp207)){__label__=62;break $if_then202$$if_else204$85;}
var $175=$syl;var $env209=(($175+1)&4294967295);var $176=HEAP8[($env209)];var $177=$p;var $env210=(($177+14)&4294967295);HEAP8[($env210)]=$176;;}}while(0);var $178=$p;var $pitch1213=(($178+20)&4294967295);var $179=HEAPU8[($pitch1213)];var $conv214=((($179))&255);var $180=$p;var $pitch2215=(($180+21)&4294967295);var $181=HEAPU8[($pitch2215)];var $conv216=((($181))&255);var $cmp217=((($conv214))|0)>((($conv216))|0);if($cmp217){__label__=63;;}else{__label__=64;;}
if(__label__==63){var $182=$p;var $pitch1219=(($182+20)&4294967295);var $183=HEAPU8[($pitch1219)];var $conv220=((($183))&255);$x=$conv220;var $184=$p;var $pitch2221=(($184+21)&4294967295);var $185=HEAP8[($pitch2221)];var $186=$p;var $pitch1222=(($186+20)&4294967295);HEAP8[($pitch1222)]=$185;var $187=$x;var $conv223=((($187))&255);var $188=$p;var $pitch2224=(($188+21)&4294967295);HEAP8[($pitch2224)]=$conv223;;}
var $189=$p;var $tone_ph=(($189+3)&4294967295);var $190=HEAP8[($tone_ph)];var $tobool226=(tempInt=(($190)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool226){__label__=65;;}else{__label__=66;;}
if(__label__==65){var $191=$p;var $tone_ph228=(($191+3)&4294967295);var $192=HEAPU8[($tone_ph228)];var $idxprom=((($192))&255);var $arrayidx229=((_phoneme_tab+$idxprom*4)&4294967295);var $193=HEAP32[(($arrayidx229)>>2)];$ph=$193;var $194=$p;var $pitch1230=(($194+20)&4294967295);var $195=HEAPU8[($pitch1230)];var $conv231=((($195))&255);var $196=$p;var $pitch2232=(($196+21)&4294967295);var $197=HEAPU8[($pitch2232)];var $conv233=((($197))&255);var $add234=((($conv233)+($conv231))&4294967295);var $div=((((($add234))|0)/2)|0);$x=$div;var $198=$x;var $199=$ph;var $end_type=(($199+13)&4294967295);var $200=HEAPU8[($end_type)];var $conv235=((($200))&255);var $add236=((($conv235)+($198))&4294967295);var $conv237=((($add236))&255);var $201=$p;var $pitch2238=(($201+21)&4294967295);HEAP8[($pitch2238)]=$conv237;var $202=$x;var $203=$ph;var $start_type=(($203+12)&4294967295);var $204=HEAPU8[($start_type)];var $conv239=((($204))&255);var $add240=((($conv239)+($202))&4294967295);var $conv241=((($add240))&255);var $205=$p;var $pitch1242=(($205+20)&4294967295);HEAP8[($pitch1242)]=$conv241;;}
var $206=$syl;var $flags244=(($206+2)&4294967295);var $207=HEAP8[($flags244)];var $conv245=(tempInt=(($207)),(tempInt>=128?tempInt-256:tempInt));var $and246=($conv245)&2;var $tobool247=((($and246))|0)!=0;if($tobool247){__label__=67;;}else{__label__=68;;}
if(__label__==67){var $208=$p;var $stresslevel249=(($208+1)&4294967295);var $209=HEAPU8[($stresslevel249)];var $conv250=((($209))&255);var $or251=($conv250)|8;var $conv252=((($or251))&255);HEAP8[($stresslevel249)]=$conv252;;}
var $210=$st_ix;var $inc254=((($210)+1)&4294967295);$st_ix=$inc254;;}
var $211=$ix;var $inc257=((($211)+1)&4294967295);$ix=$inc257;var $212=$ix;var $213=$ph_end;var $cmp183=((($212))|0)<((($213))|0);if($cmp183){__label__=57;continue $for_body184$81;}else{__label__=70;break $for_end258$$if_end28$13;}}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __ZL16CalcPitches_ToneP10Translatori($tr,$clause_tone){;var __label__;var $tr_addr;var $clause_tone_addr;var $p;var $ix;var $count_stressed;var $final_stressed;var $tone_ph;var $pause;var $tone_promoted;var $tph;var $prev_tph;var $prevw_tph;var $prev2_tph;var $prev_p;var $pitch_adjust;var $pitch_decrement;var $pitch_low;var $pitch_high;$tr_addr=$tr;$clause_tone_addr=$clause_tone;$count_stressed=0;$final_stressed=0;$pitch_adjust=0;$pitch_decrement=0;$pitch_low=0;$pitch_high=0;$p=((_phoneme_list)&4294967295);$ix=0;var $0=$ix;var $1=HEAP32[((_n_phoneme_list)>>2)];var $cmp5=((($0))|0)<((($1))|0);if($cmp5){__label__=1;;}else{__label__=8;;}
$for_body$$for_end$2:do{if(__label__==1){$for_body$3:while(1){var $2=$p;var $type=(($2+15)&4294967295);var $3=HEAPU8[($type)];var $conv=((($3))&255);var $cmp1=((($conv))|0)==2;if($cmp1){__label__=2;;}else{__label__=7;;}
$land_lhs_true$$for_inc$5:do{if(__label__==2){var $4=$p;var $stresslevel=(($4+1)&4294967295);var $5=HEAPU8[($stresslevel)];var $conv2=((($5))&255);var $cmp3=((($conv2))|0)>=4;if(!($cmp3)){__label__=7;break $land_lhs_true$$for_inc$5;}
var $6=$count_stressed;var $cmp4=((($6))|0)==0;if($cmp4){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $7=$ix;$final_stressed=$7;;}
var $8=$p;var $stresslevel6=(($8+1)&4294967295);var $9=HEAPU8[($stresslevel6)];var $conv7=((($9))&255);var $cmp8=((($conv7))|0)>=4;if(!($cmp8)){__label__=7;break $land_lhs_true$$for_inc$5;}
var $10=$ix;$final_stressed=$10;var $11=$count_stressed;var $inc=((($11)+1)&4294967295);$count_stressed=$inc;;}}while(0);var $12=$ix;var $inc12=((($12)+1)&4294967295);$ix=$inc12;var $13=$p;var $incdec_ptr=(($13+24)&4294967295);$p=$incdec_ptr;var $14=$ix;var $15=HEAP32[((_n_phoneme_list)>>2)];var $cmp=((($14))|0)<((($15))|0);if($cmp){__label__=1;continue $for_body$3;}else{__label__=8;break $for_body$$for_end$2;}}}}while(0);var $16=$final_stressed;var $arrayidx=((_phoneme_list+$16*24)&4294967295);var $stresslevel13=(($arrayidx+1)&4294967295);HEAP8[($stresslevel13)]=7;var $17=$tr_addr;var $translator_name=(($17+280)&4294967295);var $18=HEAP32[(($translator_name)>>2)];var $cmp14=((($18))|0)==30313;if($cmp14){__label__=9;;}else{__label__=11;;}
$if_then15$$if_end24$14:do{if(__label__==9){var $19=$final_stressed;var $arrayidx16=((_phoneme_list+$19*24)&4294967295);$p=$arrayidx16;var $20=$p;var $tone_ph17=(($20+3)&4294967295);var $21=HEAPU8[($tone_ph17)];var $conv18=((($21))&255);var $cmp19=((($conv18))|0)==0;if(!($cmp19)){__label__=11;break $if_then15$$if_end24$14;}
var $call=__Z11PhonemeCodej(55);var $conv21=((($call))&255);var $22=$p;var $tone_ph22=(($22+3)&4294967295);HEAP8[($tone_ph22)]=$conv21;;}}while(0);$pause=1;$tone_promoted=0;$p=((_phoneme_list)&4294967295);$prev_p=((_phoneme_list)&4294967295);var $23=HEAP32[((((_phoneme_tab+36)&4294967295))>>2)];$prevw_tph=$23;$prev_tph=$23;$ix=0;var $24=$ix;var $25=HEAP32[((_n_phoneme_list)>>2)];var $cmp262=((($24))|0)<((($25))|0);if($cmp262){__label__=12;;}else{__label__=47;;}
$for_body27$$for_end127$18:do{if(__label__==12){$for_body27$19:while(1){var $26=$p;var $type28=(($26+15)&4294967295);var $27=HEAPU8[($type28)];var $conv29=((($27))&255);var $cmp30=((($conv29))|0)==0;if($cmp30){__label__=13;;}else{__label__=15;;}
$land_lhs_true31$$if_end35$21:do{if(__label__==13){var $28=$p;var $ph=(($28+8)&4294967295);var $29=HEAP32[(($ph)>>2)];var $std_length=(($29+14)&4294967295);var $30=HEAPU8[($std_length)];var $conv32=((($30))&255);var $cmp33=((($conv32))|0)>50;if(!($cmp33)){__label__=15;break $land_lhs_true31$$if_end35$21;}
$pause=1;var $31=HEAP32[((((_phoneme_tab+36)&4294967295))>>2)];$prevw_tph=$31;;}}while(0);var $32=$p;var $newword=(($32+19)&4294967295);var $33=HEAP8[($newword)];var $tobool=(tempInt=(($33)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $34=HEAP32[((((_phoneme_tab+36)&4294967295))>>2)];$prev_tph=$34;;}
var $35=$p;var $synthflags=(($35+4)&4294967295);var $36=HEAPU16[(($synthflags)>>1)];var $conv38=((($36))&65535);var $and=($conv38)&4;var $tobool39=((($and))|0)!=0;if($tobool39){__label__=18;;}else{__label__=46;;}
if(__label__==18){var $37=$p;var $tone_ph41=(($37+3)&4294967295);var $38=HEAPU8[($tone_ph41)];var $conv42=((($38))&255);$tone_ph=$conv42;var $39=$tone_ph;var $arrayidx43=((_phoneme_tab+$39*4)&4294967295);var $40=HEAP32[(($arrayidx43)>>2)];$tph=$40;var $41=$tr_addr;var $translator_name44=(($41+280)&4294967295);var $42=HEAP32[(($translator_name44)>>2)];var $cmp45=((($42))|0)==31336;if($cmp45){__label__=19;;}else{__label__=45;;}
$if_then46$$if_end122$30:do{if(__label__==19){var $43=$tone_ph;var $cmp47=((($43))|0)==0;if($cmp47){__label__=20;;}else{__label__=25;;}
if(__label__==20){var $44=$pause;var $tobool49=((($44))|0)!=0;if($tobool49){__label__=22;;}else{__label__=21;;}
$if_then51$$lor_lhs_false$34:do{if(__label__==21){var $45=$tone_promoted;var $tobool50=((($45))|0)!=0;if($tobool50){__label__=22;break $if_then51$$lor_lhs_false$34;}
var $call53=__Z11PhonemeCodej(12593);$tone_ph=$call53;__label__=24;break $if_then51$$lor_lhs_false$34;}}while(0);if(__label__==22){var $call52=__Z11PhonemeCodej(13621);$tone_ph=$call52;$tone_promoted=1;;}
var $46=$tone_ph;var $conv55=((($46))&255);var $47=$p;var $tone_ph56=(($47+3)&4294967295);HEAP8[($tone_ph56)]=$conv55;var $48=$tone_ph;var $arrayidx57=((_phoneme_tab+$48*4)&4294967295);var $49=HEAP32[(($arrayidx57)>>2)];$tph=$49;;}
else if(__label__==25){$tone_promoted=0;;}
var $50=$ix;var $51=$final_stressed;var $cmp60=((($50))|0)==((($51))|0);if($cmp60){__label__=27;;}else{__label__=30;;}
$if_then61$$if_end70$42:do{if(__label__==27){var $52=$tph;var $mnemonic=(($52)&4294967295);var $53=HEAP32[(($mnemonic)>>2)];var $cmp62=((($53))|0)==13621;if($cmp62){__label__=29;;}else{__label__=28;;}
if(__label__==28){var $54=$tph;var $mnemonic64=(($54)&4294967295);var $55=HEAP32[(($mnemonic64)>>2)];var $cmp65=((($55))|0)==12597;if(!($cmp65)){__label__=30;break $if_then61$$if_end70$42;}}
var $56=$final_stressed;var $arrayidx67=((_phoneme_list+$56*24)&4294967295);var $stresslevel68=(($arrayidx67+1)&4294967295);HEAP8[($stresslevel68)]=6;;}}while(0);var $57=$prevw_tph;var $mnemonic71=(($57)&4294967295);var $58=HEAP32[(($mnemonic71)>>2)];var $cmp72=((($58))|0)==3420466;if($cmp72){__label__=31;;}else{__label__=34;;}
if(__label__==31){var $59=$tph;var $mnemonic74=(($59)&4294967295);var $60=HEAP32[(($mnemonic74)>>2)];var $cmp75=((($60))|0)==3420466;if($cmp75){__label__=32;;}else{__label__=33;;}
if(__label__==32){var $call77=__Z11PhonemeCodej(13619);var $conv78=((($call77))&255);var $61=$prev_p;var $tone_ph79=(($61+3)&4294967295);HEAP8[($tone_ph79)]=$conv78;;}
else if(__label__==33){var $call81=__Z11PhonemeCodej(12594);var $conv82=((($call81))&255);var $62=$prev_p;var $tone_ph83=(($62+3)&4294967295);HEAP8[($tone_ph83)]=$conv82;;}}
var $63=$prev_tph;var $mnemonic86=(($63)&4294967295);var $64=HEAP32[(($mnemonic86)>>2)];var $cmp87=((($64))|0)==12597;if($cmp87){__label__=35;;}else{__label__=37;;}
$land_lhs_true88$$if_end95$54:do{if(__label__==35){var $65=$tph;var $mnemonic89=(($65)&4294967295);var $66=HEAP32[(($mnemonic89)>>2)];var $cmp90=((($66))|0)==12597;if(!($cmp90)){__label__=37;break $land_lhs_true88$$if_end95$54;}
var $call92=__Z11PhonemeCodej(13109);var $conv93=((($call92))&255);var $67=$prev_p;var $tone_ph94=(($67+3)&4294967295);HEAP8[($tone_ph94)]=$conv93;;}}while(0);var $68=$tph;var $mnemonic96=(($68)&4294967295);var $69=HEAP32[(($mnemonic96)>>2)];var $cmp97=((($69))|0)==12593;if(!($cmp97)){__label__=45;break $if_then46$$if_end122$30;}
var $70=$prevw_tph;var $mnemonic99=(($70)&4294967295);var $71=HEAP32[(($mnemonic99)>>2)];var $cmp100=((($71))|0)==13621;if($cmp100){__label__=39;;}else{__label__=40;;}
if(__label__==39){var $call102=__Z11PhonemeCodej(12850);var $conv103=((($call102))&255);var $72=$p;var $tone_ph104=(($72+3)&4294967295);HEAP8[($tone_ph104)]=$conv103;;}
var $73=$prevw_tph;var $mnemonic106=(($73)&4294967295);var $74=HEAP32[(($mnemonic106)>>2)];var $cmp107=((($74))|0)==13619;if($cmp107){__label__=41;;}else{__label__=42;;}
if(__label__==41){var $call109=__Z11PhonemeCodej(13107);var $conv110=((($call109))&255);var $75=$p;var $tone_ph111=(($75+3)&4294967295);HEAP8[($tone_ph111)]=$conv110;;}
var $76=$prevw_tph;var $mnemonic113=(($76)&4294967295);var $77=HEAP32[(($mnemonic113)>>2)];var $cmp114=((($77))|0)==3420466;if($cmp114){__label__=43;;}else{__label__=44;;}
if(__label__==43){var $call116=__Z11PhonemeCodej(13364);var $conv117=((($call116))&255);var $78=$p;var $tone_ph118=(($78+3)&4294967295);HEAP8[($tone_ph118)]=$conv117;;}
var $79=$p;var $stresslevel120=(($79+1)&4294967295);HEAP8[($stresslevel120)]=0;;}}while(0);var $80=$p;$prev_p=$80;var $81=$prevw_tph;$prev2_tph=$81;var $82=$tph;$prev_tph=$82;$prevw_tph=$82;$pause=0;;}
var $83=$ix;var $inc125=((($83)+1)&4294967295);$ix=$inc125;var $84=$p;var $incdec_ptr126=(($84+24)&4294967295);$p=$incdec_ptr126;var $85=$ix;var $86=HEAP32[((_n_phoneme_list)>>2)];var $cmp26=((($85))|0)<((($86))|0);if($cmp26){__label__=12;continue $for_body27$19;}else{__label__=47;break $for_body27$$for_end127$18;}}}}while(0);$p=((_phoneme_list)&4294967295);$ix=0;var $87=$ix;var $88=HEAP32[((_n_phoneme_list)>>2)];var $cmp1291=((($87))|0)<((($88))|0);if($cmp1291){__label__=48;;}else{__label__=58;;}
$for_body130$$for_end166$71:do{if(__label__==48){$for_body130$72:while(1){var $89=$p;var $synthflags131=(($89+4)&4294967295);var $90=HEAPU16[(($synthflags131)>>1)];var $conv132=((($90))&65535);var $and133=($conv132)&4;var $tobool134=((($and133))|0)!=0;if($tobool134){__label__=49;;}else{__label__=57;;}
if(__label__==49){var $91=$p;var $tone_ph136=(($91+3)&4294967295);var $92=HEAPU8[($tone_ph136)];var $conv137=((($92))&255);$tone_ph=$conv137;var $93=$p;var $stresslevel138=(($93+1)&4294967295);var $94=HEAPU8[($stresslevel138)];var $conv139=((($94))&255);var $cmp140=((($conv139))|0)!=0;if($cmp140){__label__=50;;}else{__label__=54;;}
$if_then141$$if_end149$76:do{if(__label__==50){var $95=$ix;var $96=$final_stressed;var $cmp142=((($95))|0)==((($96))|0);if($cmp142){__label__=51;;}else{__label__=52;;}
if(__label__==51){var $97=$pitch_low;$pitch_adjust=$97;;}
else if(__label__==52){var $98=$pitch_decrement;var $99=$pitch_adjust;var $sub=((($99)-($98))&4294967295);$pitch_adjust=$sub;var $100=$pitch_adjust;var $101=$pitch_low;var $cmp145=((($100))|0)<=((($101))|0);if(!($cmp145)){__label__=54;break $if_then141$$if_end149$76;}
var $102=$pitch_high;$pitch_adjust=$102;;}}}while(0);var $103=$tone_ph;var $cmp150=((($103))|0)==0;if($cmp150){__label__=55;;}else{__label__=56;;}
if(__label__==55){$tone_ph=17;var $104=$tone_ph;var $conv152=((($104))&255);var $105=$p;var $tone_ph153=(($105+3)&4294967295);HEAP8[($tone_ph153)]=$conv152;;}
var $106=$pitch_adjust;var $107=$tone_ph;var $arrayidx155=((_phoneme_tab+$107*4)&4294967295);var $108=HEAP32[(($arrayidx155)>>2)];var $start_type=(($108+12)&4294967295);var $109=HEAPU8[($start_type)];var $conv156=((($109))&255);var $add=((($conv156)+($106))&4294967295);var $conv157=((($add))&255);var $110=$p;var $pitch1=(($110+20)&4294967295);HEAP8[($pitch1)]=$conv157;var $111=$pitch_adjust;var $112=$tone_ph;var $arrayidx158=((_phoneme_tab+$112*4)&4294967295);var $113=HEAP32[(($arrayidx158)>>2)];var $end_type=(($113+13)&4294967295);var $114=HEAPU8[($end_type)];var $conv159=((($114))&255);var $add160=((($conv159)+($111))&4294967295);var $conv161=((($add160))&255);var $115=$p;var $pitch2=(($115+21)&4294967295);HEAP8[($pitch2)]=$conv161;;}
var $116=$ix;var $inc164=((($116)+1)&4294967295);$ix=$inc164;var $117=$p;var $incdec_ptr165=(($117+24)&4294967295);$p=$incdec_ptr165;var $118=$ix;var $119=HEAP32[((_n_phoneme_list)>>2)];var $cmp129=((($118))|0)<((($119))|0);if($cmp129){__label__=48;continue $for_body130$72;}else{__label__=58;break $for_body130$$for_end166$71;}}}}while(0);;return;return;}
function __ZL18count_pitch_vowelsiii($start,$end,$clause_end){;var __label__;var __lastLabel__=null;var $start_addr;var $end_addr;var $clause_end_addr;var $ix;var $stress;var $max_stress;var $max_stress_posn;var $max_stress_posn2;$start_addr=$start;$end_addr=$end;$clause_end_addr=$clause_end;$max_stress=0;$max_stress_posn=0;$max_stress_posn2=0;HEAP32[((__ZL10number_pre)>>2)]=-1;HEAP32[((__ZL11number_tail)>>2)]=0;HEAP32[((__ZL12last_primary)>>2)]=-1;var $0=$start_addr;$ix=$0;var $1=$ix;var $2=$end_addr;var $cmp1=((($1))|0)<((($2))|0);if($cmp1){__label__=1;;}else{__label__=11;;}
$for_body$$for_end$2:do{if(__label__==1){while(1){var $3=$ix;var $4=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx=(($4+6*$3)&4294967295);var $stress1=(($arrayidx)&4294967295);var $5=HEAP8[($stress1)];var $conv=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));$stress=$conv;var $6=$stress;var $7=$max_stress;var $cmp2=((($6))|0)>=((($7))|0);if($cmp2){__lastLabel__=1;__label__=2;;}else{__lastLabel__=1;__label__=6;;}
if(__label__==2){var $8=$stress;var $9=$max_stress;var $cmp3=((($8))|0)>((($9))|0);if($cmp3){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $10=$ix;$max_stress_posn2=$10;;}
else if(__label__==4){var $11=$max_stress_posn;$max_stress_posn2=$11;;}
var $12=$ix;$max_stress_posn=$12;var $13=$stress;$max_stress=$13;__lastLabel__=5;;}
var $14=__lastLabel__==5?$13:($6);var $cmp6=((($14))|0)>=4;if($cmp6){__label__=7;;}else{__label__=10;;}
if(__label__==7){var $15=HEAP32[((__ZL10number_pre)>>2)];var $cmp8=((($15))|0)<0;if($cmp8){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $16=$ix;var $17=$start_addr;var $sub=((($16)-($17))&4294967295);HEAP32[((__ZL10number_pre)>>2)]=$sub;;}
var $18=$ix;HEAP32[((__ZL12last_primary)>>2)]=$18;;}
var $19=$ix;var $inc=((($19)+1)&4294967295);$ix=$inc;var $20=$ix;var $21=$end_addr;var $cmp=((($20))|0)<((($21))|0);if($cmp){__label__=1;continue;}else{__label__=11;break $for_body$$for_end$2;}}}}while(0);var $22=HEAP32[((__ZL10number_pre)>>2)];var $cmp12=((($22))|0)<0;if($cmp12){__label__=12;;}else{__label__=13;;}
if(__label__==12){var $23=$end_addr;HEAP32[((__ZL10number_pre)>>2)]=$23;;}
var $24=$end_addr;var $25=$max_stress_posn;var $_neg=(((-($25)))&4294967295);var $sub15=((($24)-1)&4294967295);var $sub16=((($sub15)+($_neg))&4294967295);HEAP32[((__ZL11number_tail)>>2)]=$sub16;var $26=$max_stress_posn;HEAP32[((__ZL9tone_posn)>>2)]=$26;var $27=$max_stress_posn2;HEAP32[((__ZL10tone_posn2)>>2)]=$27;var $_b=HEAPU8[(__ZL8no_tonic_b)];var $28=((($_b))&1);var $tobool=((($28))|0)!=0;if($tobool){__label__=14;;}else{__label__=15;;}
$if_then17$$if_else18$22:do{if(__label__==14){var $29=$end_addr;HEAP32[((__ZL10tone_posn2)>>2)]=$29;HEAP32[((__ZL9tone_posn)>>2)]=$29;;}
else if(__label__==15){var $30=HEAP32[((__ZL12last_primary)>>2)];var $cmp19=((($30))|0)>=0;if($cmp19){__label__=16;;}else{__label__=18;;}
if(__label__==16){var $31=$end_addr;var $32=$clause_end_addr;var $cmp21=((($31))|0)==((($32))|0);if(!($cmp21)){__label__=19;break $if_then17$$if_else18$22;}
var $33=HEAP32[((__ZL12last_primary)>>2)];var $34=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx23=(($34+6*$33)&4294967295);var $stress24=(($arrayidx23)&4294967295);HEAP8[($stress24)]=7;;}
else if(__label__==18){var $35=HEAP32[((__ZL9tone_posn)>>2)];var $36=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx27=(($36+6*$35)&4294967295);var $stress28=(($arrayidx27)&4294967295);HEAP8[($stress28)]=7;;}}}while(0);;return;return;}
function __ZL12calc_pitchesiiii($control,$start,$end,$tune_number){;var __label__;var $retval;var $control_addr;var $start_addr;var $end_addr;var $tune_number_addr;var $ix;var $th;var $tn;var $drop;var $continuing;$control_addr=$control;$start_addr=$start;$end_addr=$end;$tune_number_addr=$tune_number;$continuing=0;var $0=$control_addr;var $cmp=((($0))|0)==0;var $1=$start_addr;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $2=$end_addr;var $3=$tune_number_addr;var $call=__ZL13calc_pitches2iii($1,$2,$3);$retval=$call;;}
else if(__label__==2){var $cmp1=((($1))|0)>0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){$continuing=1;;}
var $4=$tune_number_addr;var $arrayidx=((__ZL15tone_head_table+$4*16)&4294967295);$th=$arrayidx;var $5=$tune_number_addr;var $arrayidx4=((__ZL18tone_nucleus_table+$5*16)&4294967295);$tn=$arrayidx4;var $6=$start_addr;$ix=$6;var $7=$ix;var $8=$ix;var $9=HEAP32[((__ZL10number_pre)>>2)];var $add=((($9)+($8))&4294967295);var $10=$th;var $pre_start=(($10)&4294967295);var $11=HEAPU8[($pre_start)];var $conv=((($11))&255);var $12=$th;var $pre_end=(($12+1)&4294967295);var $13=HEAPU8[($pre_end)];var $conv5=((($13))&255);__ZL16SetPitchGradientiiii($7,$add,$conv,$conv5);var $14=HEAP32[((__ZL10number_pre)>>2)];var $15=$ix;var $add6=((($15)+($14))&4294967295);$ix=$add6;var $16=HEAP32[((_option_tone_flags)>>2)];var $and=($16)&512;var $tobool=((($and))|0)!=0;if($tobool){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $17=HEAP32[((__ZL10tone_posn2)>>2)];HEAP32[((__ZL9tone_posn)>>2)]=$17;;}
var $18=$ix;var $19=HEAP32[((__ZL9tone_posn)>>2)];var $20=$th;var $21=$tn;var $22=$continuing;var $call9=__ZL18calc_pitch_segmentiiP9TONE_HEADP12TONE_NUCLEUSii($18,$19,$20,$21,$22);$ix=$call9;var $_b=HEAPU8[(__ZL8no_tonic_b)];var $23=((($_b))&1);var $tobool10=((($23))|0)!=0;if($tobool10){__label__=7;;}else{__label__=8;;}
if(__label__==7){$retval=0;;}
else if(__label__==8){var $24=$tn;var $flags=(($24+14)&4294967295);var $25=HEAPU8[($flags)];var $conv13=((($25))&255);var $and14=($conv13)&1;var $tobool15=((($and14))|0)!=0;if($tobool15){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $26=$ix;var $27=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx17=(($27+6*$26)&4294967295);var $flags18=(($arrayidx17+2)&4294967295);var $28=HEAP8[($flags18)];var $conv19=(tempInt=(($28)),(tempInt>=128?tempInt-256:tempInt));var $or=($conv19)|2;var $conv20=((($or))&255);HEAP8[($flags18)]=$conv20;;}
var $29=HEAP32[((__ZL11number_tail)>>2)];var $cmp22=((($29))|0)==0;var $30=$tn;if($cmp22){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $pitch_env0=(($30)&4294967295);var $31=HEAPU8[($pitch_env0)];var $conv24=((($31))&255);HEAP32[((__ZL14tone_pitch_env)>>2)]=$conv24;var $32=$tn;var $tonic_max0=(($32+1)&4294967295);var $33=HEAPU8[($tonic_max0)];var $conv25=((($33))&255);var $34=$tn;var $tonic_min0=(($34+2)&4294967295);var $35=HEAPU8[($tonic_min0)];var $conv26=((($35))&255);var $sub=((($conv25)-($conv26))&4294967295);$drop=$sub;var $36=$ix;var $inc=((($36)+1)&4294967295);$ix=$inc;var $37=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx27=(($37+6*$36)&4294967295);var $38=$tn;var $tonic_min028=(($38+2)&4294967295);var $39=HEAPU8[($tonic_min028)];var $conv29=((($39))&255);var $40=$drop;__ZL9set_pitchP8SYLLABLEii($arrayidx27,$conv29,$40);;}
else if(__label__==12){var $pitch_env1=(($30+3)&4294967295);var $41=HEAPU8[($pitch_env1)];var $conv30=((($41))&255);HEAP32[((__ZL14tone_pitch_env)>>2)]=$conv30;var $42=$tn;var $tonic_max1=(($42+4)&4294967295);var $43=HEAPU8[($tonic_max1)];var $conv31=((($43))&255);var $44=$tn;var $tonic_min1=(($44+5)&4294967295);var $45=HEAPU8[($tonic_min1)];var $conv32=((($45))&255);var $sub33=((($conv31)-($conv32))&4294967295);$drop=$sub33;var $46=$ix;var $inc34=((($46)+1)&4294967295);$ix=$inc34;var $47=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx35=(($47+6*$46)&4294967295);var $48=$tn;var $tonic_min136=(($48+5)&4294967295);var $49=HEAPU8[($tonic_min136)];var $conv37=((($49))&255);var $50=$drop;__ZL9set_pitchP8SYLLABLEii($arrayidx35,$conv37,$50);;}
var $51=HEAP32[((__ZL14tone_pitch_env)>>2)];var $conv39=((($51))&255);var $52=HEAP32[((__ZL9tone_posn)>>2)];var $53=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx40=(($53+6*$52)&4294967295);var $env=(($arrayidx40+1)&4294967295);HEAP8[($env)]=$conv39;var $54=HEAP32[((__ZL9tone_posn)>>2)];var $55=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx41=(($55+6*$54)&4294967295);var $stress=(($arrayidx41)&4294967295);var $56=HEAP8[($stress)];var $conv42=(tempInt=(($56)),(tempInt>=128?tempInt-256:tempInt));var $cmp43=((($conv42))|0)==4;if($cmp43){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $57=HEAP32[((__ZL9tone_posn)>>2)];var $58=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx45=(($58+6*$57)&4294967295);var $stress46=(($arrayidx45)&4294967295);HEAP8[($stress46)]=6;;}
var $59=$ix;var $60=$end_addr;var $61=$tn;var $tail_start=(($61+12)&4294967295);var $62=HEAPU8[($tail_start)];var $conv48=((($62))&255);var $63=$tn;var $tail_end=(($63+13)&4294967295);var $64=HEAPU8[($tail_end)];var $conv49=((($64))&255);__ZL16SetPitchGradientiiii($59,$60,$conv48,$conv49);var $65=HEAP32[((__ZL14tone_pitch_env)>>2)];$retval=$65;;}};return;return;}
function __ZL13calc_pitches2iii($start,$end,$tune_number){;var __label__;var $retval;var $start_addr;var $end_addr;var $tune_number_addr;var $ix;var $tune;var $drop;var $continuing;$start_addr=$start;$end_addr=$end;$tune_number_addr=$tune_number;$continuing=0;var $0=$start_addr;var $cmp=((($0))|0)>0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$continuing=1;;}
var $1=$tune_number_addr;var $2=HEAP32[((_tunes)>>2)];var $arrayidx=(($2+68*$1)&4294967295);$tune=$arrayidx;var $3=$start_addr;$ix=$3;var $4=$ix;var $5=$ix;var $6=HEAP32[((__ZL10number_pre)>>2)];var $add=((($6)+($5))&4294967295);var $7=$tune;var $prehead_start=(($7+24)&4294967295);var $8=HEAPU8[($prehead_start)];var $conv=((($8))&255);var $9=$tune;var $prehead_end=(($9+25)&4294967295);var $10=HEAPU8[($prehead_end)];var $conv1=((($10))&255);__ZL16SetPitchGradientiiii($4,$add,$conv,$conv1);var $11=HEAP32[((__ZL10number_pre)>>2)];var $12=$ix;var $add2=((($12)+($11))&4294967295);$ix=$add2;var $13=HEAP32[((_option_tone_flags)>>2)];var $and=($13)&512;var $tobool=((($and))|0)!=0;if($tobool){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $14=HEAP32[((__ZL10tone_posn2)>>2)];HEAP32[((__ZL9tone_posn)>>2)]=$14;;}
var $15=$tune;var $16=$ix;var $17=HEAP32[((__ZL9tone_posn)>>2)];var $call=__ZL17SetHeadIntonationP4TUNEiii($15,$16,$17);$ix=$call;var $_b=HEAPU8[(__ZL8no_tonic_b)];var $18=((($_b))&1);var $tobool5=((($18))|0)!=0;if($tobool5){__label__=5;;}else{__label__=6;;}
if(__label__==5){$retval=0;;}
else if(__label__==6){var $19=HEAP32[((__ZL11number_tail)>>2)];var $cmp8=((($19))|0)==0;var $20=$tune;if($cmp8){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $nucleus0_env=(($20+42)&4294967295);var $21=HEAPU8[($nucleus0_env)];var $conv10=((($21))&255);HEAP32[((__ZL14tone_pitch_env)>>2)]=$conv10;var $22=$tune;var $nucleus0_max=(($22+43)&4294967295);var $23=HEAPU8[($nucleus0_max)];var $conv11=((($23))&255);var $24=$tune;var $nucleus0_min=(($24+44)&4294967295);var $25=HEAPU8[($nucleus0_min)];var $conv12=((($25))&255);var $sub=((($conv11)-($conv12))&4294967295);$drop=$sub;var $26=$ix;var $inc=((($26)+1)&4294967295);$ix=$inc;var $27=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx13=(($27+6*$26)&4294967295);var $28=$tune;var $nucleus0_min14=(($28+44)&4294967295);var $29=HEAPU8[($nucleus0_min14)];var $conv15=((($29))&255);var $30=$drop;__ZL9set_pitchP8SYLLABLEii($arrayidx13,$conv15,$30);;}
else if(__label__==8){var $nucleus1_env=(($20+45)&4294967295);var $31=HEAPU8[($nucleus1_env)];var $conv16=((($31))&255);HEAP32[((__ZL14tone_pitch_env)>>2)]=$conv16;var $32=$tune;var $nucleus1_max=(($32+46)&4294967295);var $33=HEAPU8[($nucleus1_max)];var $conv17=((($33))&255);var $34=$tune;var $nucleus1_min=(($34+47)&4294967295);var $35=HEAPU8[($nucleus1_min)];var $conv18=((($35))&255);var $sub19=((($conv17)-($conv18))&4294967295);$drop=$sub19;var $36=$ix;var $inc20=((($36)+1)&4294967295);$ix=$inc20;var $37=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx21=(($37+6*$36)&4294967295);var $38=$tune;var $nucleus1_min22=(($38+47)&4294967295);var $39=HEAPU8[($nucleus1_min22)];var $conv23=((($39))&255);var $40=$drop;__ZL9set_pitchP8SYLLABLEii($arrayidx21,$conv23,$40);;}
var $41=HEAP32[((__ZL14tone_pitch_env)>>2)];var $conv25=((($41))&255);var $42=HEAP32[((__ZL9tone_posn)>>2)];var $43=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx26=(($43+6*$42)&4294967295);var $env=(($arrayidx26+1)&4294967295);HEAP8[($env)]=$conv25;var $44=HEAP32[((__ZL9tone_posn)>>2)];var $45=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx27=(($45+6*$44)&4294967295);var $stress=(($arrayidx27)&4294967295);var $46=HEAP8[($stress)];var $conv28=(tempInt=(($46)),(tempInt>=128?tempInt-256:tempInt));var $cmp29=((($conv28))|0)==4;if($cmp29){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $47=HEAP32[((__ZL9tone_posn)>>2)];var $48=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx31=(($48+6*$47)&4294967295);var $stress32=(($arrayidx31)&4294967295);HEAP8[($stress32)]=6;;}
var $49=$ix;var $50=$end_addr;var $51=$tune;var $tail_start=(($51+48)&4294967295);var $52=HEAPU8[($tail_start)];var $conv34=((($52))&255);var $53=$tune;var $tail_end=(($53+49)&4294967295);var $54=HEAPU8[($tail_end)];var $conv35=((($54))&255);__ZL16SetPitchGradientiiii($49,$50,$conv34,$conv35);var $55=HEAP32[((__ZL14tone_pitch_env)>>2)];$retval=$55;;}
var $56=$retval;;return $56;return null;}
function __ZL16SetPitchGradientiiii($start_ix,$end_ix,$start_pitch,$end_pitch){;var __label__;var __lastLabel__=null;var $start_ix_addr;var $end_ix_addr;var $start_pitch_addr;var $end_pitch_addr;var $ix;var $stress;var $pitch;var $increment;var $n_increments;var $drop;var $syl;$start_ix_addr=$start_ix;$end_ix_addr=$end_ix;$start_pitch_addr=$start_pitch;$end_pitch_addr=$end_pitch;var $0=$end_pitch_addr;var $1=$start_pitch_addr;var $sub=((($0)-($1))&4294967295);var $shl=($sub)<<8;$increment=$shl;var $2=$end_ix_addr;var $3=$start_ix_addr;var $sub1=((($2)-($3))&4294967295);$n_increments=$sub1;var $4=$n_increments;var $cmp=((($4))|0)<=0;if($cmp){__label__=12;;}else{__label__=1;;}
$for_end$$if_end$2:do{if(__label__==1){var $5=$n_increments;var $cmp2=((($5))|0)>1;if($cmp2){__label__=2;;}else{__label__=3;;}
if(__label__==2){var $6=$increment;var $7=$n_increments;var $div=((((($6))|0)/((($7))|0))|0);$increment=$div;;}
var $8=$start_pitch_addr;var $shl5=($8)<<8;$pitch=$shl5;var $9=$start_ix_addr;$ix=$9;var $10=$ix;var $11=$end_ix_addr;var $cmp61=((($10))|0)<((($11))|0);if(!($cmp61)){__label__=12;break $for_end$$if_end$2;}
while(1){var $12=$ix;var $13=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx=(($13+6*$12)&4294967295);$syl=$arrayidx;var $14=$syl;var $stress7=(($14)&4294967295);var $15=HEAP8[($stress7)];var $conv=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));$stress=$conv;var $16=$increment;var $cmp8=((($16))|0)>0;if($cmp8){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $17=$syl;var $18=$pitch;var $shr=($18)>>8;var $19=$increment;var $shr10=($19)>>8;var $sub11=(((-($shr10)))&4294967295);__ZL9set_pitchP8SYLLABLEii($17,$shr,$sub11);var $20=$increment;var $21=$pitch;var $add=((($21)+($20))&4294967295);$pitch=$add;;}
else if(__label__==6){var $22=$increment;var $shr12=($22)>>8;var $sub13=(((-($shr12)))&4294967295);$drop=$sub13;var $23=$drop;var $24=$stress;var $arrayidx14=((__ZL8min_drop+$24*4)&4294967295);var $25=HEAP32[(($arrayidx14)>>2)];var $cmp15=((($23))|0)<((($25))|0);if($cmp15){__lastLabel__=6;__label__=7;;}else{__lastLabel__=6;__label__=8;;}
if(__label__==7){var $26=$stress;var $arrayidx17=((__ZL8min_drop+$26*4)&4294967295);var $27=HEAP32[(($arrayidx17)>>2)];$drop=$27;__lastLabel__=7;;}
var $28=__lastLabel__==7?$27:($23);var $29=$increment;var $30=$pitch;var $add19=((($30)+($29))&4294967295);$pitch=$add19;var $cmp20=((($28))|0)>18;if($cmp20){__label__=9;;}else{__label__=10;;}
if(__label__==9){$drop=18;;}
var $31=$syl;var $32=$pitch;var $shr23=($32)>>8;var $33=$drop;__ZL9set_pitchP8SYLLABLEii($31,$shr23,$33);;}
var $34=$ix;var $inc=((($34)+1)&4294967295);$ix=$inc;var $35=$ix;var $36=$end_ix_addr;var $cmp6=((($35))|0)<((($36))|0);if($cmp6){__label__=4;continue;}else{__label__=12;break $for_end$$if_end$2;}}}}while(0);;return;return;}
function __ZL18calc_pitch_segmentiiP9TONE_HEADP12TONE_NUCLEUSii($ix,$end_ix,$th,$tn,$continuing){;var __label__;var __lastLabel__=null;var $ix_addr;var $end_ix_addr;var $th_addr;var $tn_addr;var $min_stress_addr;var $continuing_addr;var $stress;var $pitch;var $increment;var $n_primary;var $n_steps;var $initial;var $overflow;var $n_overflow;var $pitch_range;var $pitch_range_abs;var $drops;var $overflow_tab;var $syl;$ix_addr=$ix;$end_ix_addr=$end_ix;$th_addr=$th;$tn_addr=$tn;$min_stress_addr=4;$continuing_addr=$continuing;$pitch=0;$increment=0;$n_primary=0;$n_steps=0;$overflow=0;var $0=$th_addr;var $body_drops=(($0+4)&4294967295);var $1=HEAP32[(($body_drops)>>2)];$drops=$1;var $2=$th_addr;var $body_end=(($2+3)&4294967295);var $3=HEAPU8[($body_end)];var $conv=((($3))&255);var $4=$th_addr;var $body_start=(($4+2)&4294967295);var $5=HEAPU8[($body_start)];var $conv1=((($5))&255);var $sub=((($conv)-($conv1))&4294967295);var $shl=($sub)<<8;$pitch_range=$shl;var $6=$pitch_range;var $ispos=((($6))|0)>-1;var $neg=(((-($6)))&4294967295);var $call=($ispos)?($6):($neg);$pitch_range_abs=$call;var $7=$continuing_addr;var $tobool=((($7))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
if(__label__==1){$initial=0;$overflow=0;$n_overflow=5;$overflow_tab=((__ZZL18calc_pitch_segmentiiP9TONE_HEADP12TONE_NUCLEUSiiE12continue_tab)&4294967295);var $8=$pitch_range;var $9=$th_addr;var $body_max_steps=(($9+8)&4294967295);var $10=HEAPU8[($body_max_steps)];var $conv2=((($10))&255);var $sub3=((($conv2)-1)&4294967295);var $div=((((($8))|0)/((($sub3))|0))|0);$increment=$div;;}
else if(__label__==2){var $11=$th_addr;var $n_overflow4=(($11+10)&4294967295);var $12=HEAPU8[($n_overflow4)];var $conv5=((($12))&255);$n_overflow=$conv5;var $13=$th_addr;var $overflow6=(($13+12)&4294967295);var $14=HEAP32[(($overflow6)>>2)];$overflow_tab=$14;$initial=1;;}
var $15=$ix_addr;var $16=$end_ix_addr;var $cmp4=((($15))|0)<((($16))|0);var $17=$ix_addr;if($cmp4){__lastLabel__=3;__label__=4;;}else{__lastLabel__=3;__label__=31;;}
$while_body$$while_end$6:do{if(__label__==4){$while_body$7:while(1){var $18=__lastLabel__==30?$90:($17);var $19=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx=(($19+6*$18)&4294967295);$syl=$arrayidx;var $20=$syl;var $stress7=(($20)&4294967295);var $21=HEAP8[($stress7)];var $conv8=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt));$stress=$conv8;var $22=$initial;var $tobool9=((($22))|0)!=0;if($tobool9){__label__=8;;}else{__label__=5;;}
$if_then15$$lor_lhs_false$9:do{if(__label__==5){var $23=$stress;var $24=$min_stress_addr;var $cmp10=((($23))|0)>=((($24))|0);if($cmp10){__lastLabel__=5;;}else{__lastLabel__=5;__label__=23;break $if_then15$$lor_lhs_false$9;}
var $_pr=$initial;var $tobool12=((($_pr))|0)!=0;if($tobool12){__label__=8;break $if_then15$$lor_lhs_false$9;}
var $25=$stress;var $cmp14=((($25))|0)==5;if($cmp14){__label__=8;break $if_then15$$lor_lhs_false$9;}
var $39=$n_steps;var $cmp34=((($39))|0)>0;if($cmp34){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $40=$increment;var $41=$pitch;var $add=((($41)+($40))&4294967295);$pitch=$add;__label__=19;break $if_then15$$lor_lhs_false$9;}
else if(__label__==17){var $42=$th_addr;var $body_end37=(($42+3)&4294967295);var $43=HEAPU8[($body_end37)];var $conv38=((($43))&255);var $shl39=((($conv38)*256)&4294967295);var $44=$pitch_range_abs;var $45=$overflow;var $inc=((($45)+1)&4294967295);$overflow=$inc;var $46=$overflow_tab;var $arrayidx40=(($46+$45)&4294967295);var $47=HEAP8[($arrayidx40)];var $conv41=(tempInt=(($47)),(tempInt>=128?tempInt-256:tempInt));var $mul=((($conv41)*($44))&4294967295);var $div42=((((($mul))|0)/64)|0);var $add43=((($div42)+($shl39))&4294967295);$pitch=$add43;var $48=$overflow;var $49=$n_overflow;var $cmp44=((($48))|0)>=((($49))|0);if(!($cmp44)){__label__=19;break $if_then15$$lor_lhs_false$9;}
$overflow=0;var $50=$th_addr;var $overflow46=(($50+12)&4294967295);var $51=HEAP32[(($overflow46)>>2)];$overflow_tab=$51;__label__=19;break $if_then15$$lor_lhs_false$9;}}}while(0);$if_then15$$if_end49$$if_end59$18:do{if(__label__==8){$initial=0;$overflow=0;var $26=$ix_addr;var $27=$end_ix_addr;var $28=$min_stress_addr;var $call16=__ZL16count_incrementsiii($26,$27,$28);$n_primary=$call16;$n_steps=$call16;var $29=$n_steps;var $30=$th_addr;var $body_max_steps17=(($30+8)&4294967295);var $31=HEAPU8[($body_max_steps17)];var $conv18=((($31))&255);var $cmp19=((($29))|0)>((($conv18))|0);if($cmp19){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $32=$th_addr;var $body_max_steps21=(($32+8)&4294967295);var $33=HEAPU8[($body_max_steps21)];var $conv22=((($33))&255);$n_steps=$conv22;__lastLabel__=9;;}
else if(__label__==10){var $_pr2=$n_steps;__lastLabel__=10;;}
var $34=__lastLabel__==10?$_pr2:($conv22);var $cmp24=((($34))|0)>1;if($cmp24){__label__=12;;}else{__label__=13;;}
if(__label__==12){var $35=$pitch_range;var $36=$n_steps;var $sub26=((($36)-1)&4294967295);var $div27=((((($35))|0)/((($sub26))|0))|0);$increment=$div27;;}
else if(__label__==13){$increment=0;;}
var $37=$th_addr;var $body_start30=(($37+2)&4294967295);var $38=HEAPU8[($body_start30)];var $conv31=((($38))&255);var $shl32=($conv31)<<8;$pitch=$shl32;__label__=19;break $if_then15$$if_end49$$if_end59$18;}}while(0);if(__label__==19){var $52=$n_steps;var $dec=((($52)-1)&4294967295);$n_steps=$dec;var $53=$n_primary;var $dec50=((($53)-1)&4294967295);$n_primary=$dec50;var $54=$tn_addr;var $backwards=(($54+8)&4294967295);var $55=HEAP32[(($backwards)>>2)];var $tobool51=((($55))|0)!=0;if($tobool51){__label__=20;;}else{__label__=22;;}
$land_lhs_true$$if_end59thread_pre_split$30:do{if(__label__==20){var $56=$n_primary;var $cmp52=((($56))|0)<2;if(!($cmp52)){__label__=22;break $land_lhs_true$$if_end59thread_pre_split$30;}
var $57=$n_primary;var $58=$tn_addr;var $backwards54=(($58+8)&4294967295);var $59=HEAP32[(($backwards54)>>2)];var $arrayidx55=(($59+2*$57)&4294967295);var $60=HEAP16[(($arrayidx55)>>1)];var $conv56=(tempInt=(($60)),(tempInt>=32768?tempInt-65536:tempInt));var $shl57=($conv56)<<8;$pitch=$shl57;;}}while(0);var $_pr3=$stress;__lastLabel__=22;;}
var $61=__lastLabel__==22?$_pr3:($23);var $cmp60=((($61))|0)>=4;if($cmp60){__label__=24;;}else{__label__=25;;}
if(__label__==24){var $62=$syl;var $stress62=(($62)&4294967295);HEAP8[($stress62)]=6;var $63=$syl;var $64=$pitch;var $shr=($64)>>8;var $65=$stress;var $66=$drops;var $arrayidx63=(($66+4*$65)&4294967295);var $67=HEAP32[(($arrayidx63)>>2)];__ZL9set_pitchP8SYLLABLEii($63,$shr,$67);;}
else if(__label__==25){var $68=$stress;var $cmp65=((($68))|0)>=3;if($cmp65){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $69=$syl;var $70=$pitch;var $shr67=($70)>>8;var $71=$stress;var $72=$drops;var $arrayidx68=(($72+4*$71)&4294967295);var $73=HEAP32[(($arrayidx68)>>2)];__ZL9set_pitchP8SYLLABLEii($69,$shr67,$73);;}
else if(__label__==27){var $74=$ix_addr;var $sub70=((($74)-1)&4294967295);var $75=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx71=(($75+6*$sub70)&4294967295);var $stress72=(($arrayidx71)&4294967295);var $76=HEAP8[($stress72)];var $conv73=(tempInt=(($76)),(tempInt>=128?tempInt-256:tempInt));var $and=($conv73)&63;var $cmp74=((($and))|0)>=3;var $77=$syl;var $78=$pitch;var $shr76=($78)>>8;if($cmp74){__label__=28;;}else{__label__=29;;}
if(__label__==28){var $79=$th_addr;var $body_lower_u=(($79+9)&4294967295);var $80=HEAP8[($body_lower_u)];var $conv77=(tempInt=(($80)),(tempInt>=128?tempInt-256:tempInt));var $sub78=((($shr76)-($conv77))&4294967295);var $81=$stress;var $82=$drops;var $arrayidx79=(($82+4*$81)&4294967295);var $83=HEAP32[(($arrayidx79)>>2)];__ZL9set_pitchP8SYLLABLEii($77,$sub78,$83);;}
else if(__label__==29){var $84=$stress;var $85=$drops;var $arrayidx82=(($85+4*$84)&4294967295);var $86=HEAP32[(($arrayidx82)>>2)];__ZL9set_pitchP8SYLLABLEii($77,$shr76,$86);;}}}
var $87=$ix_addr;var $inc86=((($87)+1)&4294967295);$ix_addr=$inc86;var $88=$ix_addr;var $89=$end_ix_addr;var $cmp=((($88))|0)<((($89))|0);var $90=$ix_addr;if($cmp){__lastLabel__=30;__label__=4;continue $while_body$7;}else{__lastLabel__=30;__label__=31;break $while_body$$while_end$6;}}}}while(0);var $_lcssa=__lastLabel__==3?$17:($90);;return $_lcssa;return null;}
function __ZL9set_pitchP8SYLLABLEii($syl,$base,$drop){;var __label__;var __lastLabel__=null;var $syl_addr;var $base_addr;var $drop_addr;var $pitch1;var $pitch2;var $flags;$syl_addr=$syl;$base_addr=$base;$drop_addr=$drop;$flags=0;var $0=$base_addr;var $cmp=((($0))|0)<0;if($cmp){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=2;;}
if(__label__==1){$base_addr=0;var $_pr=$drop_addr;__lastLabel__=1;;}
var $1=__lastLabel__==1?$_pr:($drop);var $2=$base_addr;$pitch2=$2;var $cmp1=((($1))|0)<0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){$flags=1;var $3=$drop_addr;var $sub=(((-($3)))&4294967295);$drop_addr=$sub;;}
var $4=$pitch2;var $5=$drop_addr;var $add=((($5)+($4))&4294967295);$pitch1=$add;var $cmp4=((($add))|0)<0;if($cmp4){__label__=5;;}else{__label__=6;;}
$if_end6_thread$$if_end6$8:do{if(__label__==5){$pitch1=0;;}
else if(__label__==6){var $cmp7=((($add))|0)>254;if(!($cmp7)){__label__=8;break $if_end6_thread$$if_end6$8;}
$pitch1=254;;}}while(0);var $6=$pitch2;var $cmp10=((($6))|0)>254;if($cmp10){__label__=9;;}else{__label__=10;;}
if(__label__==9){$pitch2=254;;}
var $7=$pitch1;var $conv=((($7))&255);var $8=$syl_addr;var $pitch113=(($8+4)&4294967295);HEAP8[($pitch113)]=$conv;var $9=$pitch2;var $conv14=((($9))&255);var $10=$syl_addr;var $pitch215=(($10+5)&4294967295);HEAP8[($pitch215)]=$conv14;var $11=$flags;var $12=$syl_addr;var $flags16=(($12+2)&4294967295);var $13=HEAP8[($flags16)];var $conv17=(tempInt=(($13)),(tempInt>=128?tempInt-256:tempInt));var $or=($conv17)|($11);var $conv18=((($or))&255);HEAP8[($flags16)]=$conv18;;return;return;}
function __ZL16count_incrementsiii($ix,$end_ix,$min_stress){;var __label__;var $ix_addr;var $end_ix_addr;var $min_stress_addr;var $count;var $stress;$ix_addr=$ix;$end_ix_addr=$end_ix;$min_stress_addr=$min_stress;$count=0;;while(1){var $0=$ix_addr;var $1=$end_ix_addr;var $cmp=((($0))|0)<((($1))|0);if(!($cmp)){__label__=5;break;}
var $2=$ix_addr;var $inc=((($2)+1)&4294967295);$ix_addr=$inc;var $3=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx=(($3+6*$2)&4294967295);var $stress1=(($arrayidx)&4294967295);var $4=HEAP8[($stress1)];var $conv=(tempInt=(($4)),(tempInt>=128?tempInt-256:tempInt));$stress=$conv;var $5=$stress;var $cmp2=((($5))|0)>=7;if($cmp2){__label__=5;break;}
var $6=$stress;var $7=$min_stress_addr;var $cmp3=((($6))|0)>=((($7))|0);if(!($cmp3)){__label__=1;continue;}
var $8=$count;var $inc5=((($8)+1)&4294967295);$count=$inc5;__label__=1;continue;}
var $9=$count;;return $9;return null;}
function __ZL17SetHeadIntonationP4TUNEiii($tune,$syl_ix,$end_ix){;var __label__;var __lastLabel__=null;var $tune_addr;var $syl_ix_addr;var $end_ix_addr;var $control_addr;var $stress;var $syl;var $ix;var $pitch;var $increment;var $n_steps;var $stage;var $initial;var $overflow_ix;var $pitch_range;var $pitch_range_abs;var $drops;var $n_unstressed;var $unstressed_ix;var $unstressed_inc;var $used_onset;var $head_final;var $secondary;$tune_addr=$tune;$syl_ix_addr=$syl_ix;$end_ix_addr=$end_ix;$control_addr=0;$pitch=0;$increment=0;$n_steps=0;$overflow_ix=0;$n_unstressed=0;$unstressed_ix=0;$used_onset=0;var $0=$end_ix_addr;$head_final=$0;$secondary=2;var $1=$tune_addr;var $head_end=(($1+32)&4294967295);var $2=HEAPU8[($head_end)];var $conv=((($2))&255);var $3=$tune_addr;var $head_start=(($3+31)&4294967295);var $4=HEAPU8[($head_start)];var $conv1=((($4))&255);var $sub=((($conv)-($conv1))&4294967295);var $shl=($sub)<<8;$pitch_range=$shl;var $5=$pitch_range;var $ispos=((($5))|0)>-1;var $neg=(((-($5)))&4294967295);var $call=($ispos)?($5):($neg);$pitch_range_abs=$call;$drops=((__ZL7drops_0)&4294967295);$initial=1;$stage=0;var $6=$tune_addr;var $onset=(($6+30)&4294967295);var $7=HEAPU8[($onset)];var $conv2=((($7))&255);var $cmp=((($conv2))|0)==255;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$stage=1;;}
var $8=$tune_addr;var $head_last=(($8+33)&4294967295);var $9=HEAPU8[($head_last)];var $conv3=((($9))&255);var $cmp4=((($conv3))|0)!=255;if($cmp4){__label__=4;;}else{__label__=3;;}
$if_then5$$while_cond_preheader$5:do{if(__label__==4){var $13=$end_ix_addr;var $sub6=((($13)-1)&4294967295);$ix=$sub6;;while(1){var $14=$ix;var $15=$syl_ix_addr;var $cmp7=((($14))|0)>=((($15))|0);if(!($cmp7)){__label__=3;break $if_then5$$while_cond_preheader$5;}
var $16=$ix;var $17=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx=(($17+6*$16)&4294967295);var $stress8=(($arrayidx)&4294967295);var $18=HEAP8[($stress8)];var $conv9=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));var $cmp10=((($conv9))|0)>=4;var $19=$ix;if($cmp10){__label__=7;break;}
var $dec=((($19)-1)&4294967295);$ix=$dec;__label__=5;continue;}
$head_final=$19;;}}while(0);var $10=$syl_ix_addr;var $11=$end_ix_addr;var $cmp145=((($10))|0)<((($11))|0);var $12=$syl_ix_addr;if($cmp145){__lastLabel__=3;__label__=9;;}else{__lastLabel__=3;__label__=39;;}
$while_body$$while_end$13:do{if(__label__==9){$while_body$14:while(1){var $20=__lastLabel__==38?$108:($12);var $21=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx15=(($21+6*$20)&4294967295);$syl=$arrayidx15;var $22=$syl;var $stress16=(($22)&4294967295);var $23=HEAP8[($stress16)];var $conv17=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt));$stress=$conv17;var $24=$initial;var $tobool=((($24))|0)!=0;if($tobool){__label__=13;;}else{__label__=10;;}
$if_then23$$lor_lhs_false$16:do{if(__label__==10){var $25=$stress;var $cmp18=((($25))|0)>=4;if(!($cmp18)){__label__=32;break $if_then23$$lor_lhs_false$16;}
var $_pr=$initial;var $tobool20=((($_pr))|0)!=0;if($tobool20){__label__=13;break $if_then23$$lor_lhs_false$16;}
var $26=$stress;var $cmp22=((($26))|0)==5;if($cmp22){__label__=13;break $if_then23$$lor_lhs_false$16;}
var $44=$syl_ix_addr;var $45=$head_final;var $cmp49=((($44))|0)==((($45))|0);if($cmp49){__label__=23;;}else{__label__=24;;}
if(__label__==23){var $46=$tune_addr;var $head_last51=(($46+33)&4294967295);var $47=HEAPU8[($head_last51)];var $conv52=((($47))&255);var $shl53=($conv52)<<8;$pitch=$shl53;$stage=2;__label__=30;break $if_then23$$lor_lhs_false$16;}
else if(__label__==24){var $48=$used_onset;var $tobool55=((($48))|0)!=0;if($tobool55){__label__=25;;}else{__label__=26;;}
if(__label__==25){$stage=1;$used_onset=0;var $49=$tune_addr;var $head_start57=(($49+31)&4294967295);var $50=HEAPU8[($head_start57)];var $conv58=((($50))&255);var $shl59=($conv58)<<8;$pitch=$shl59;var $51=$n_steps;var $inc=((($51)+1)&4294967295);$n_steps=$inc;__label__=30;break $if_then23$$lor_lhs_false$16;}
else if(__label__==26){var $52=$n_steps;var $cmp61=((($52))|0)>0;if($cmp61){__label__=27;;}else{__label__=28;;}
if(__label__==27){var $53=$increment;var $54=$pitch;var $add63=((($54)+($53))&4294967295);$pitch=$add63;__label__=30;break $if_then23$$lor_lhs_false$16;}
else if(__label__==28){var $55=$tune_addr;var $head_end65=(($55+32)&4294967295);var $56=HEAPU8[($head_end65)];var $conv66=((($56))&255);var $shl67=((($conv66)*256)&4294967295);var $57=$pitch_range_abs;var $58=$overflow_ix;var $inc68=((($58)+1)&4294967295);$overflow_ix=$inc68;var $59=$tune_addr;var $head_extend=(($59+16)&4294967295);var $arrayidx69=(($head_extend+$58)&4294967295);var $60=HEAP8[($arrayidx69)];var $conv70=(tempInt=(($60)),(tempInt>=128?tempInt-256:tempInt));var $mul=((($conv70)*($57))&4294967295);var $div71=((((($mul))|0)/64)|0);var $add72=((($div71)+($shl67))&4294967295);$pitch=$add72;var $61=$overflow_ix;var $62=$tune_addr;var $n_head_extend=(($62+35)&4294967295);var $63=HEAPU8[($n_head_extend)];var $conv73=((($63))&255);var $cmp74=((($61))|0)>=((($conv73))|0);if(!($cmp74)){__label__=30;break $if_then23$$lor_lhs_false$16;}
$overflow_ix=0;__label__=30;break $if_then23$$lor_lhs_false$16;}}}}}while(0);$if_then23$$if_end82$$if_else89$31:do{if(__label__==13){$initial=0;$overflow_ix=0;var $27=$tune_addr;var $onset24=(($27+30)&4294967295);var $28=HEAPU8[($onset24)];var $conv25=((($28))&255);var $cmp26=((($conv25))|0)==255;var $29=$syl_ix_addr;if($cmp26){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $30=$head_final;var $call28=__ZL16count_incrementsiii($29,$30,4);$n_steps=$call28;var $31=$tune_addr;var $head_start29=(($31+31)&4294967295);var $32=HEAPU8[($head_start29)];var $conv30=((($32))&255);var $shl31=($conv30)<<8;$pitch=$shl31;;}
else if(__label__==15){var $add=((($29)+1)&4294967295);var $33=$head_final;var $call32=__ZL16count_incrementsiii($add,$33,4);$n_steps=$call32;var $34=$tune_addr;var $onset33=(($34+30)&4294967295);var $35=HEAPU8[($onset33)];var $conv34=((($35))&255);var $shl35=($conv34)<<8;$pitch=$shl35;$used_onset=1;;}
var $36=$n_steps;var $37=$tune_addr;var $head_max_steps=(($37+34)&4294967295);var $38=HEAPU8[($head_max_steps)];var $conv37=((($38))&255);var $cmp38=((($36))|0)>((($conv37))|0);if($cmp38){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $39=$tune_addr;var $head_max_steps40=(($39+34)&4294967295);var $40=HEAPU8[($head_max_steps40)];var $conv41=((($40))&255);$n_steps=$conv41;__lastLabel__=17;;}
else if(__label__==18){var $_pr2=$n_steps;__lastLabel__=18;;}
var $41=__lastLabel__==18?$_pr2:($conv41);var $cmp43=((($41))|0)>1;if($cmp43){__label__=20;;}else{__label__=21;;}
if(__label__==20){var $42=$pitch_range;var $43=$n_steps;var $sub45=((($43)-1)&4294967295);var $div=((((($42))|0)/((($sub45))|0))|0);$increment=$div;__label__=30;break $if_then23$$if_end82$$if_else89$31;}
else if(__label__==21){$increment=0;__label__=30;break $if_then23$$if_end82$$if_else89$31;}}}while(0);$if_end82$$if_else89$44:do{if(__label__==30){var $64=$n_steps;var $dec81=((($64)-1)&4294967295);$n_steps=$dec81;var $_pr3=$stress;var $cmp83=((($_pr3))|0)>=4;if(!($cmp83)){__label__=32;break $if_end82$$if_else89$44;}
var $65=$syl_ix_addr;var $add85=((($65)+1)&4294967295);var $66=$end_ix_addr;var $67=$secondary;var $call86=__ZL15CountUnstressediii($add85,$66,$67);$n_unstressed=$call86;$unstressed_ix=0;var $68=$syl;var $stress87=(($68)&4294967295);HEAP8[($stress87)]=6;var $69=$tune_addr;var $stressed_env=(($69+26)&4294967295);var $70=HEAP8[($stressed_env)];var $71=$syl;var $env=(($71+1)&4294967295);HEAP8[($env)]=$70;var $72=$syl;var $73=$pitch;var $shr=($73)>>8;var $74=$tune_addr;var $stressed_drop=(($74+27)&4294967295);var $75=HEAPU8[($stressed_drop)];var $conv88=((($75))&255);__ZL9set_pitchP8SYLLABLEii($72,$shr,$conv88);__label__=38;break $if_end82$$if_else89$44;}}while(0);if(__label__==32){var $76=$stress;var $77=$secondary;var $cmp90=((($76))|0)>=((($77))|0);if($cmp90){__label__=33;;}else{__label__=34;;}
if(__label__==33){var $78=$syl_ix_addr;var $add92=((($78)+1)&4294967295);var $79=$end_ix_addr;var $80=$secondary;var $call93=__ZL15CountUnstressediii($add92,$79,$80);$n_unstressed=$call93;$unstressed_ix=0;var $81=$syl;var $82=$pitch;var $shr94=($82)>>8;var $83=$stress;var $84=$drops;var $arrayidx95=(($84+4*$83)&4294967295);var $85=HEAP32[(($arrayidx95)>>2)];__ZL9set_pitchP8SYLLABLEii($81,$shr94,$85);;}
else if(__label__==34){var $86=$n_unstressed;var $cmp97=((($86))|0)>1;if($cmp97){__label__=35;;}else{__label__=36;;}
if(__label__==35){var $87=$stage;var $88=$tune_addr;var $unstr_end=(($88+39)&4294967295);var $arrayidx99=(($unstr_end+$87)&4294967295);var $89=HEAP8[($arrayidx99)];var $conv100=(tempInt=(($89)),(tempInt>=128?tempInt-256:tempInt));var $90=$stage;var $91=$tune_addr;var $unstr_start=(($91+36)&4294967295);var $arrayidx101=(($unstr_start+$90)&4294967295);var $92=HEAP8[($arrayidx101)];var $conv102=(tempInt=(($92)),(tempInt>=128?tempInt-256:tempInt));var $sub103=((($conv100)-($conv102))&4294967295);var $93=$n_unstressed;var $sub104=((($93)-1)&4294967295);var $div105=((((($sub103))|0)/((($sub104))|0))|0);$unstressed_inc=$div105;;}
else if(__label__==36){$unstressed_inc=0;;}
var $94=$syl;var $95=$pitch;var $shr108=($95)>>8;var $96=$stage;var $97=$tune_addr;var $unstr_start109=(($97+36)&4294967295);var $arrayidx110=(($unstr_start109+$96)&4294967295);var $98=HEAP8[($arrayidx110)];var $conv111=(tempInt=(($98)),(tempInt>=128?tempInt-256:tempInt));var $99=$unstressed_inc;var $100=$unstressed_ix;var $mul113=((($100)*($99))&4294967295);var $add112=((($conv111)+($shr108))&4294967295);var $add114=((($add112)+($mul113))&4294967295);var $101=$stress;var $102=$drops;var $arrayidx115=(($102+4*$101)&4294967295);var $103=HEAP32[(($arrayidx115)>>2)];__ZL9set_pitchP8SYLLABLEii($94,$add114,$103);var $104=$unstressed_ix;var $inc116=((($104)+1)&4294967295);$unstressed_ix=$inc116;;}}
var $105=$syl_ix_addr;var $inc119=((($105)+1)&4294967295);$syl_ix_addr=$inc119;var $106=$syl_ix_addr;var $107=$end_ix_addr;var $cmp14=((($106))|0)<((($107))|0);var $108=$syl_ix_addr;if($cmp14){__lastLabel__=38;__label__=9;continue $while_body$14;}else{__lastLabel__=38;__label__=39;break $while_body$$while_end$13;}}}}while(0);var $_lcssa=__lastLabel__==3?$12:($108);;return $_lcssa;return null;}
function __ZL15CountUnstressediii($start,$end,$limit){;var __label__;var $start_addr;var $end_addr;var $limit_addr;var $ix;$start_addr=$start;$end_addr=$end;$limit_addr=$limit;var $0=$start_addr;$ix=$0;;while(1){var $1=$ix;var $2=$end_addr;var $cmp=((($1))|0)<=((($2))|0);if(!($cmp)){__label__=4;break;}
var $3=$ix;var $4=HEAP32[((__ZL12syllable_tab)>>2)];var $arrayidx=(($4+6*$3)&4294967295);var $stress=(($arrayidx)&4294967295);var $5=HEAP8[($stress)];var $conv=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));var $6=$limit_addr;var $cmp1=((($conv))|0)>=((($6))|0);if($cmp1){__label__=4;break;}
var $7=$ix;var $inc=((($7)+1)&4294967295);$ix=$inc;__label__=1;continue;}
var $8=$ix;var $9=$start_addr;var $sub=((($8)-($9))&4294967295);;return $sub;return null;}
function _iswalpha($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;var $1=$c_addr;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $call=_isalpha($1);$retval=$call;;}
else if(__label__==2){var $cmp1=((($1))>>>0)>12352;var $2=$c_addr;var $cmp2=((($2))>>>0)<=42752;var $or_cond=($cmp1)&($cmp2);if($or_cond){__label__=3;;}else{__label__=4;;}
if(__label__==3){$retval=1;;}
else if(__label__==4){var $3=$c_addr;var $cmp5=((($3))>>>0)>563;if($cmp5){__label__=5;;}else{__label__=6;;}
if(__label__==5){$retval=0;;}
else if(__label__==6){var $4=$c_addr;var $sub=((($4)-256)&4294967295);var $arrayidx=((_walpha_tab+$sub)&4294967295);var $5=HEAPU8[($arrayidx)];var $conv=((($5))&255);$retval=$conv;;}}}
var $6=$retval;;return $6;return null;}
function _iswdigit($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$c_addr;var $isdigittmp=((($1)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call=((($isdigit))&1);$retval=$call;;}
else if(__label__==2){$retval=0;;}
var $2=$retval;;return $2;return null;}
function _iswalnum($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $call=_iswdigit($0);var $tobool=((($call))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=1;;}
else if(__label__==2){var $1=$c_addr;var $call1=_iswalpha($1);$retval=$call1;;}
var $2=$retval;;return $2;return null;}
function _towlower($c){;var __label__;var $retval;var $c_addr;var $x;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;var $1=$c_addr;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){var $call=_tolower($1);$retval=$call;;}
else if(__label__==2){var $cmp1=((($1))>>>0)>563;if($cmp1){__label__=4;;}else{__label__=3;;}
$if_then3$$lor_lhs_false$5:do{if(__label__==3){var $2=$c_addr;var $sub=((($2)-256)&4294967295);var $arrayidx=((_walpha_tab+$sub)&4294967295);var $3=HEAPU8[($arrayidx)];var $conv=((($3))&255);$x=$conv;var $cmp2=((($conv))|0)==255;if($cmp2){__label__=4;break $if_then3$$lor_lhs_false$5;}
var $5=$x;var $cmp5=((($5))|0)==254;if($cmp5){__label__=6;;}else{__label__=8;;}
$if_then6$$if_end10$8:do{if(__label__==6){var $6=$c_addr;var $cmp7=((($6))|0)==304;if(!($cmp7)){__label__=8;break $if_then6$$if_end10$8;}
$retval=105;__label__=9;break $if_then$$if_end$2;}}while(0);var $7=$c_addr;var $8=$x;var $add=((($8)+($7))&4294967295);$retval=$add;__label__=9;break $if_then$$if_end$2;}}while(0);var $4=$c_addr;$retval=$4;;}}while(0);var $9=$retval;;return $9;return null;}
function _towupper($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $sub=((($0)-1)&4294967295);var $call=_tolower($sub);var $1=$c_addr;var $cmp=((($call))|0)==((($1))|0);var $2=$c_addr;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $sub1=((($2)-1)&4294967295);$retval=$sub1;;}
else if(__label__==2){$retval=$2;;}
var $3=$retval;;return $3;return null;}
function _iswupper($c){;var __label__;var $retval;var $c_addr;var $x;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;var $1=$c_addr;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){var $call=_isupper($1);$retval=$call;;}
else if(__label__==2){var $cmp1=((($1))>>>0)>563;if($cmp1){__label__=5;;}else{__label__=3;;}
$if_then5$$lor_lhs_false$5:do{if(__label__==3){var $2=$c_addr;var $sub=((($2)-256)&4294967295);var $arrayidx=((_walpha_tab+$sub)&4294967295);var $3=HEAPU8[($arrayidx)];var $conv=((($3))&255);$x=$conv;var $cmp2=((($conv))|0)==0;if($cmp2){__label__=5;break $if_then5$$lor_lhs_false$5;}
var $4=$x;var $cmp4=((($4))|0)==255;if($cmp4){__label__=5;break $if_then5$$lor_lhs_false$5;}
$retval=1;__label__=7;break $if_then$$if_end$2;}}while(0);$retval=0;;}}while(0);var $5=$retval;;return $5;return null;}
function _iswlower($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;var $1=$c_addr;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){var $call=_islower($1);$retval=$call;;}
else if(__label__==2){var $cmp1=((($1))>>>0)>563;if($cmp1){__label__=4;;}else{__label__=3;;}
$if_then3$$lor_lhs_false$5:do{if(__label__==3){var $2=$c_addr;var $sub=((($2)-256)&4294967295);var $arrayidx=((_walpha_tab+$sub)&4294967295);var $3=HEAPU8[($arrayidx)];var $conv=((($3))&255);var $cmp2=((($conv))|0)!=255;if($cmp2){__label__=4;break $if_then3$$lor_lhs_false$5;}
$retval=1;__label__=6;break $if_then$$if_end$2;}}while(0);$retval=0;;}}while(0);var $4=$retval;;return $4;return null;}
function _iswspace($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$c_addr;var $call=_isspace($1);$retval=$call;;}
else if(__label__==2){$retval=0;;}
var $2=$retval;;return $2;return null;}
function _iswpunct($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))>>>0)<256;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$c_addr;var $call=_ispunct($1);$retval=$call;;}
else if(__label__==2){$retval=0;;}
var $2=$retval;;return $2;return null;}
function _wcschr($str,$c){;var __label__;var $retval;var $str_addr;var $c_addr;$str_addr=$str;$c_addr=$c;;while(1){var $0=$str_addr;var $1=HEAP32[(($0)>>2)];var $cmp=((($1))|0)!=0;if(!($cmp)){__label__=5;break;}
var $2=$str_addr;var $3=HEAP32[(($2)>>2)];var $4=$c_addr;var $cmp1=((($3))|0)==((($4))|0);var $5=$str_addr;if($cmp1){__label__=3;break;}
var $incdec_ptr=(($5+4)&4294967295);$str_addr=$incdec_ptr;__label__=1;continue;}
if(__label__==5){$retval=0;;}
else if(__label__==3){$retval=$5;;}
var $6=$retval;;return $6;return null;}
function _wcslen($str){;var __label__;var __lastLabel__=null;var $str_addr;var $ix;$str_addr=$str;$ix=0;var $0=$str_addr;var $1=HEAP32[(($0)>>2)];var $cmp1=((($1))|0)!=0;var $2=$ix;if($cmp1){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=2;;}
$while_body$$while_end$2:do{if(__label__==1){while(1){var $3=__lastLabel__==1?$6:($2);var $inc=((($3)+1)&4294967295);$ix=$inc;var $4=$str_addr;var $5=HEAP32[(($4)>>2)];var $cmp=((($5))|0)!=0;var $6=$ix;if($cmp){__lastLabel__=1;__label__=1;continue;}else{__lastLabel__=1;__label__=2;break $while_body$$while_end$2;}}}}while(0);var $_lcssa=__lastLabel__==0?$2:($6);;return $_lcssa;return null;}
function _wcstod($str,$tailptr){var __stackBase__=STACKTOP;STACKTOP+=80;_memset(__stackBase__,0,80);var __label__;var __lastLabel__=null;var $str_addr;var $tailptr_addr;var $ix;var $buf=__stackBase__;$str_addr=$str;$tailptr_addr=$tailptr;var $0=$str_addr;var $1=HEAP32[(($0)>>2)];var $call1=_isspace($1);var $tobool2=((($call1))|0)!=0;if($tobool2){__label__=1;;}else{__label__=2;;}
$while_body$$while_end$2:do{if(__label__==1){while(1){var $2=$str_addr;var $incdec_ptr=(($2+4)&4294967295);$str_addr=$incdec_ptr;var $3=$str_addr;var $4=HEAP32[(($3)>>2)];var $call=_isspace($4);var $tobool=((($call))|0)!=0;if($tobool){__label__=1;continue;}else{__label__=2;break $while_body$$while_end$2;}}}}while(0);$ix=0;__lastLabel__=2;;while(1){var $5=__lastLabel__==5?$inc:(0);var $cmp=((($5))|0)<80;if(!($cmp)){__label__=6;break;}
var $6=$ix;var $7=$str_addr;var $arrayidx=(($7+4*$6)&4294967295);var $8=HEAP32[(($arrayidx)>>2)];var $conv=((($8))&255);var $9=$ix;var $arrayidx1=(($buf+$9)&4294967295);HEAP8[($arrayidx1)]=$conv;var $10=$ix;var $arrayidx2=(($buf+$10)&4294967295);var $11=HEAP8[($arrayidx2)];var $conv3=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $call4=_isspace($conv3);var $tobool5=((($call4))|0)!=0;if($tobool5){__label__=6;break;}
var $12=$ix;var $inc=((($12)+1)&4294967295);$ix=$inc;__lastLabel__=5;__label__=3;continue;}
var $13=$ix;var $14=$str_addr;var $arrayidx6=(($14+4*$13)&4294967295);var $15=$tailptr_addr;HEAP32[(($15)>>2)]=$arrayidx6;var $arraydecay=(($buf)&4294967295);var $call7=_atof($arraydecay);var $conv8=($call7);STACKTOP=__stackBase__;return $conv8;return null;}
function __Z9towlower2j($c){;var __label__;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))|0)==73;if($cmp){__label__=1;;}else{__label__=3;;}
$if_then$$if_end3$2:do{if(__label__==1){var $1=HEAP32[((_translator)>>2)];var $translator_name=(($1+280)&4294967295);var $2=HEAP32[(($translator_name)>>2)];var $cmp1=((($2))|0)==29810;if(!($cmp1)){__label__=3;break $if_then$$if_end3$2;}
$c_addr=305;;}}while(0);var $3=$c_addr;var $call=_towlower($3);;return $call;return null;}
function __Z3Eofv(){;var __label__;var $retval;var $0=HEAP32[((__ZL10ungot_char)>>2)];var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=0;;}
else if(__label__==2){var $1=HEAP32[((__ZL7f_input)>>2)];var $cmp1=((($1))|0)!=0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $2=HEAP32[((__ZL7f_input)>>2)];var $_flags=(($2+12)&4294967295);var $3=HEAP16[(($_flags)>>1)];var $conv=(tempInt=(($3)),(tempInt>=32768?tempInt-65536:tempInt));var $and=($conv)&32;var $cmp3=((($and))|0)!=0;var $conv4=((($cmp3))&1);$retval=$conv4;;}
else if(__label__==4){var $_b=HEAPU8[(__ZL12end_of_input_b)];var $4=((($_b))&1);$retval=$4;;}}
var $5=$retval;;return $5;return null;}
function __Z10Read4BytesP7__sFILE($f){;var __label__;var $f_addr;var $ix;var $c;var $acc;$f_addr=$f;$acc=0;$ix=0;;while(1){var $0=$f_addr;var $call=_fgetc($0);var $and=($call)&255;var $conv=((($and))&255);$c=$conv;var $1=$c;var $conv1=((($1))&255);var $2=$ix;var $mul=((($2)*8)&4294967295);var $shl=($conv1)<<($mul);var $3=$acc;var $add=((($shl)+($3))&4294967295);$acc=$add;var $4=$ix;var $inc=((($4)+1)&4294967295);$ix=$inc;var $cmp=((($inc))|0)<4;if($cmp){__label__=1;continue;}else{__label__=2;break;}}
var $5=$acc;;return $5;return null;}
function __Z11AddNameDataPKci($name,$wide){;var __label__;var $retval;var $name_addr;var $wide_addr;var $ix;var $len;var $vp;$name_addr=$name;$wide_addr=$wide;var $0=$wide_addr;var $tobool=((($0))|0)!=0;var $1=$name_addr;if($tobool){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $2=$1;var $call=_wcslen($2);var $add=((($call)+1)&4294967295);var $mul=((($add)*4)&4294967295);$len=$mul;var $3=HEAP32[((__ZL10n_namedata)>>2)];var $sub=((($3)+3)&4294967295);var $rem=((($sub))>>>0)%4;HEAP32[((__ZL10n_namedata)>>2)]=$rem;;}
else if(__label__==2){var $call2=_strlen($1);var $add3=((($call2)+1)&4294967295);$len=$add3;;}
var $4=HEAP32[((__ZL11namedata_ix)>>2)];var $5=$len;var $add4=((($5)+($4))&4294967295);var $6=HEAP32[((__ZL10n_namedata)>>2)];var $cmp=((($add4))|0)>=((($6))|0);if($cmp){__label__=4;;}else{__label__=7;;}
$if_then5$$if_end14$6:do{if(__label__==4){var $7=HEAP32[((_namedata)>>2)];var $8=HEAP32[((__ZL11namedata_ix)>>2)];var $9=$len;var $add6=((($8)+300)&4294967295);var $add7=((($add6)+($9))&4294967295);var $call8=_realloc($7,$add7);$vp=$call8;var $cmp9=((($call8))|0)==0;if($cmp9){__label__=5;;}else{__label__=6;;}
if(__label__==5){$retval=-1;__label__=8;break $if_then5$$if_end14$6;}
else if(__label__==6){var $10=$vp;HEAP32[((_namedata)>>2)]=$10;var $11=HEAP32[((__ZL11namedata_ix)>>2)];var $12=$len;var $add12=((($11)+300)&4294967295);var $add13=((($add12)+($12))&4294967295);HEAP32[((__ZL10n_namedata)>>2)]=$add13;__label__=7;break $if_then5$$if_end14$6;}}}while(0);if(__label__==7){var $13=HEAP32[((__ZL11namedata_ix)>>2)];$ix=$13;var $14=HEAP32[((_namedata)>>2)];var $arrayidx=(($14+$13)&4294967295);var $15=$name_addr;var $16=$len;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$15;$dest$=$arrayidx;$stop$=$src$+$16;if(($dest$%4)==($src$%4)&&$16>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $17=$len;var $18=HEAP32[((__ZL11namedata_ix)>>2)];var $add15=((($18)+($17))&4294967295);HEAP32[((__ZL11namedata_ix)>>2)]=$add15;var $19=$ix;$retval=$19;;}
var $20=$retval;;return $20;return null;}
function __Z13SetVoiceStackP12espeak_VOICE($v){;var __label__;var $v_addr;var $sp;$v_addr=$v;$sp=((__ZL10ssml_stack)&4294967295);var $0=$v_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$sp;var $2=$1;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$2;$stop$=$dest$+76;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};;}
else if(__label__==2){var $3=$v_addr;var $languages=(($3+4)&4294967295);var $4=HEAP32[(($languages)>>2)];var $cmp1=((($4))|0)!=0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $5=$sp;var $language=(($5+56)&4294967295);var $arraydecay=(($language)&4294967295);var $6=$v_addr;var $languages3=(($6+4)&4294967295);var $7=HEAP32[(($languages3)>>2)];var $call=_strcpy($arraydecay,$7);;}
var $8=$v_addr;var $name=(($8)&4294967295);var $9=HEAP32[(($name)>>2)];var $cmp5=((($9))|0)!=0;if($cmp5){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $10=$sp;var $voice_name=(($10+16)&4294967295);var $arraydecay7=(($voice_name)&4294967295);var $11=$v_addr;var $name8=(($11)&4294967295);var $12=HEAP32[(($name8)>>2)];var $call9=_strcpy($arraydecay7,$12);;}
var $13=$v_addr;var $variant=(($13+14)&4294967295);var $14=HEAPU8[($variant)];var $conv=((($14))&255);var $15=$sp;var $voice_variant=(($15+4)&4294967295);HEAP32[(($voice_variant)>>2)]=$conv;var $16=$v_addr;var $age=(($16+13)&4294967295);var $17=HEAPU8[($age)];var $conv11=((($17))&255);var $18=$sp;var $voice_age=(($18+12)&4294967295);HEAP32[(($voice_age)>>2)]=$conv11;var $19=$v_addr;var $gender=(($19+12)&4294967295);var $20=HEAPU8[($gender)];var $conv12=((($20))&255);var $21=$sp;var $voice_gender=(($21+8)&4294967295);HEAP32[(($voice_gender)>>2)]=$conv12;;};return;return;}
function __Z10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_($tr,$f_in,$buf,$charix,$charix_top,$n_buf,$tone_type,$voice_change){var __stackBase__=STACKTOP;STACKTOP+=1136;_memset(__stackBase__,0,1136);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $f_in_addr;var $buf_addr;var $charix_addr;var $charix_top_addr;var $n_buf_addr;var $tone_type_addr;var $voice_change_addr;var $c1=__stackBase__;var $c2=__stackBase__+4;var $cprev;var $cprev2;var $c_next;var $parag;var $ix=__stackBase__+8;var $j;var $nl_count;var $linelength;var $phoneme_mode;var $n_xml_buf;var $terminator;var $punct;var $found;var $any_alnum;var $self_closing;var $punct_data;var $is_end_clause;var $announced_punctuation;var $prev_announced_punctuation;var $stressed_word;var $end_clause_after_tag;var $end_clause_index;var $xml_buf=__stackBase__+12;var $xml_buf2=__stackBase__+1040;var $p_word;var $text_buf=__stackBase__+1064;var $text_buf2=__stackBase__+1104;var $p2;$tr_addr=$tr;$f_in_addr=$f_in;$buf_addr=$buf;$charix_addr=$charix;$charix_top_addr=$charix_top;$n_buf_addr=$n_buf;$tone_type_addr=$tone_type;$voice_change_addr=$voice_change;HEAP32[(($c1)>>2)]=32;$cprev=32;$cprev2=32;HEAP32[(($ix)>>2)]=0;$linelength=0;$phoneme_mode=0;$any_alnum=0;$punct_data=0;$announced_punctuation=0;$stressed_word=0;$end_clause_after_tag=0;$end_clause_index=0;var $_b=HEAPU8[(__ZL19clear_skipping_text_b)];var $0=((($_b))&1);var $tobool=((($0))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
if(__label__==1){HEAP32[((_skipping_text)>>2)]=0;HEAP8[(__ZL19clear_skipping_text_b)]=0;;}
var $1=$tr_addr;var $phonemes_repeat_count=(($1+652)&4294967295);HEAP32[(($phonemes_repeat_count)>>2)]=0;var $2=$tr_addr;var $clause_upper_count=(($2+8304)&4294967295);HEAP32[(($clause_upper_count)>>2)]=0;var $3=$tr_addr;var $clause_lower_count=(($3+8308)&4294967295);HEAP32[(($clause_lower_count)>>2)]=0;HEAP8[(__ZL12end_of_input_b)]=0;var $4=$tone_type_addr;HEAP32[(($4)>>2)]=0;var $5=$voice_change_addr;HEAP8[($5)]=0;var $6=$f_in_addr;HEAP32[((__ZL7f_input)>>2)]=$6;var $7=HEAP32[((__ZL10ungot_word)>>2)];var $cmp=((($7))|0)!=0;if($cmp){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $8=$buf_addr;var $9=HEAP32[((__ZL10ungot_word)>>2)];var $call=_strcpy($8,$9);var $10=HEAP32[((__ZL10ungot_word)>>2)];var $call2=_strlen($10);var $11=HEAP32[(($ix)>>2)];var $add=((($11)+($call2))&4294967295);HEAP32[(($ix)>>2)]=$add;HEAP32[((__ZL10ungot_word)>>2)]=0;;}
var $12=HEAP32[((__ZL11ungot_char2)>>2)];var $cmp4=((($12))|0)!=0;if($cmp4){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $13=HEAP32[((__ZL11ungot_char2)>>2)];HEAP32[(($c2)>>2)]=$13;;}
else if(__label__==6){var $call6=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call6;;}
var $arrayidx82=(($xml_buf2)&4294967295);var $arrayidx86=(($xml_buf2)&4294967295);var $arrayidx90=(($xml_buf2+1)&4294967295);var $arrayidx94=(($xml_buf2+2)&4294967295);var $arrayidx97=(($xml_buf2+1)&4294967295);var $arraydecay=(($xml_buf2)&4294967295);var $arraydecay164=(($xml_buf)&4294967295);var $arraydecay324=(($text_buf2)&4294967295);var $arraydecay328=(($text_buf)&4294967295);var $arraydecay329=(($text_buf2)&4294967295);var $arraydecay331=(($text_buf)&4294967295);var $arraydecay337=(($text_buf)&4294967295);;$while_cond$12:while(1){var $call8=__Z3Eofv();var $tobool9=((($call8))|0)==0;var $14=HEAP32[((__ZL10ungot_char)>>2)];var $cmp10=((($14))|0)!=0;var $or_cond=($tobool9)|($cmp10);var $15=HEAP32[((__ZL11ungot_char2)>>2)];var $cmp12=((($15))|0)!=0;var $or_cond3=($or_cond)|($cmp12);var $16=HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)];var $cmp13=((($16))|0)>=0;var $or_cond19=($or_cond3)|($cmp13);if(!($or_cond19)){__label__=256;break $while_cond$12;}
var $17=HEAP32[(($c1)>>2)];var $call14=_iswalnum($17);var $tobool15=((($call14))|0)!=0;if($tobool15){__label__=16;;}else{__label__=10;;}
$if_end26$$if_then16$15:do{if(__label__==10){var $18=HEAP32[((_end_character_position)>>2)];var $cmp17=((($18))|0)>0;if($cmp17){__label__=11;;}else{__label__=13;;}
if(__label__==11){var $19=HEAP32[((_count_characters)>>2)];var $20=HEAP32[((_end_character_position)>>2)];var $cmp18=((($19))|0)>((($20))|0);if($cmp18){__label__=12;break $while_cond$12;}}
var $21=HEAP32[((_skip_characters)>>2)];var $cmp21=((($21))|0)>0;if(!($cmp21)){__label__=16;break $if_end26$$if_then16$15;}
var $22=HEAP32[((_count_characters)>>2)];var $23=HEAP32[((_skip_characters)>>2)];var $cmp23=((($22))|0)>((($23))|0);if($cmp23){__label__=15;break $while_cond$12;}}}while(0);var $25=$cprev;$cprev2=$25;var $26=HEAP32[(($c1)>>2)];$cprev=$26;var $27=HEAP32[(($c2)>>2)];HEAP32[(($c1)>>2)]=$27;var $28=HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)];var $cmp27=((($28))|0)>=0;if($cmp27){__label__=17;;}else{__label__=19;;}
$if_then28$$if_end32$22:do{if(__label__==17){var $29=HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)];var $arrayidx=((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E12ungot_string+$29)&4294967295);var $30=HEAP8[($arrayidx)];var $conv=(tempInt=(($30)),(tempInt>=128?tempInt-256:tempInt));var $cmp29=((($conv))|0)==0;if(!($cmp29)){__label__=19;break $if_then28$$if_end32$22;}
HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)]=-1;;}}while(0);var $31=HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)];var $cmp33=((($31))|0)==0;var $32=HEAP32[((__ZL11ungot_char2)>>2)];var $cmp35=((($32))|0)==0;var $or_cond4=($cmp33)&($cmp35);if($or_cond4){__lastLabel__=19;__label__=20;;}else{__lastLabel__=19;__label__=21;;}
if(__label__==20){var $33=HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)];var $inc=((($33)+1)&4294967295);HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)]=$inc;var $arrayidx37=((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E12ungot_string+$33)&4294967295);var $34=HEAP8[($arrayidx37)];var $conv38=(tempInt=(($34)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($c1)>>2)]=$conv38;__lastLabel__=20;;}
var $35=__lastLabel__==20?$inc:($31);var $cmp40=((($35))|0)>=0;if($cmp40){__label__=22;;}else{__label__=23;;}
$if_then41$$if_else45$29:do{if(__label__==22){var $36=HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)];var $inc42=((($36)+1)&4294967295);HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)]=$inc42;var $arrayidx43=((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E12ungot_string+$36)&4294967295);var $37=HEAP8[($arrayidx43)];var $conv44=(tempInt=(($37)),(tempInt>=128?tempInt-256:tempInt));HEAP32[(($c2)>>2)]=$conv44;;}
else if(__label__==23){var $call46=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call46;var $call47=__Z3Eofv();var $tobool48=((($call47))|0)!=0;if(!($tobool48)){__label__=25;break $if_then41$$if_else45$29;}
HEAP32[(($c2)>>2)]=32;;}}while(0);HEAP32[((__ZL11ungot_char2)>>2)]=0;var $38=HEAP32[((_option_ssml)>>2)];var $tobool52=((($38))|0)!=0;if($tobool52){__label__=26;;}else{__label__=72;;}
$land_lhs_true53$$if_end184$34:do{if(__label__==26){var $39=$phoneme_mode;var $cmp54=((($39))|0)==0;if(!($cmp54)){__label__=72;break $land_lhs_true53$$if_end184$34;}
var $40=HEAP32[((__ZL19ssml_ignore_l_angle)>>2)];var $cmp56=((($40))|0)!=38;if($cmp56){__label__=28;;}else{__label__=50;;}
$land_lhs_true57$$if_else122$37:do{if(__label__==28){var $41=HEAP32[(($c1)>>2)];var $cmp58=((($41))|0)==38;if(!($cmp58)){__label__=50;break $land_lhs_true57$$if_else122$37;}
var $42=HEAP32[(($c2)>>2)];var $cmp60=((($42))|0)==35;if($cmp60){__label__=31;;}else{__label__=30;;}
if(__label__==30){var $43=HEAP32[(($c2)>>2)];var $cmp62=((($43))|0)>=97;var $44=HEAP32[(($c2)>>2)];var $cmp64=((($44))|0)<=122;var $or_cond5=($cmp62)&($cmp64);if(!($or_cond5)){__label__=50;break $land_lhs_true57$$if_else122$37;}}
$n_xml_buf=0;var $45=HEAP32[(($c2)>>2)];HEAP32[(($c1)>>2)]=$45;;$while_cond66$43:while(1){var $call67=__Z3Eofv();var $tobool68=((($call67))|0)!=0;if($tobool68){__label__=36;break $while_cond66$43;}
var $46=HEAP32[(($c1)>>2)];var $call70=_iswalnum($46);var $tobool71=((($call70))|0)!=0;var $47=HEAP32[(($c1)>>2)];var $cmp73=((($47))|0)==35;var $or_cond6=($tobool71)|($cmp73);if(!($or_cond6)){__label__=36;break $while_cond66$43;}
var $48=$n_xml_buf;var $cmp74=((($48))|0)<20;if(!($cmp74)){__label__=36;break $while_cond66$43;}
var $49=HEAP32[(($c1)>>2)];var $conv76=((($49))&255);var $50=$n_xml_buf;var $inc77=((($50)+1)&4294967295);$n_xml_buf=$inc77;var $arrayidx78=(($xml_buf2+$50)&4294967295);HEAP8[($arrayidx78)]=$conv76;var $call79=__ZL4GetCv();HEAP32[(($c1)>>2)]=$call79;__label__=32;continue $while_cond66$43;}
var $51=$n_xml_buf;var $arrayidx80=(($xml_buf2+$51)&4294967295);HEAP8[($arrayidx80)]=0;var $call81=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call81;var $52=HEAP32[(($c1)>>2)];var $53=HEAP32[(($c2)>>2)];var $call83=_sprintf(((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E12ungot_string)&4294967295),((__str38205)&4294967295),allocate([$arrayidx82,0,0,0,$52,0,0,0,$53,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $54=HEAP32[(($c1)>>2)];var $cmp84=((($54))|0)==59;if($cmp84){__label__=37;;}else{__label__=44;;}
$if_then85$$if_else109$49:do{if(__label__==37){var $55=HEAP8[($arrayidx86)];var $conv87=(tempInt=(($55)),(tempInt>=128?tempInt-256:tempInt));var $cmp88=((($conv87))|0)==35;if($cmp88){__label__=38;;}else{__label__=41;;}
$if_then89$$if_else100$51:do{if(__label__==38){var $56=HEAP8[($arrayidx90)];var $conv91=(tempInt=(($56)),(tempInt>=128?tempInt-256:tempInt));var $cmp92=((($conv91))|0)==120;if($cmp92){__label__=39;;}else{__label__=40;;}
if(__label__==39){var $call95=_sscanf($arrayidx94,((__str10307)&4294967295),allocate([$c1,0,0,0],["i32*",0,0,0],ALLOC_STACK));$found=$call95;__lastLabel__=39;;}
else if(__label__==40){var $call98=_sscanf($arrayidx97,((__str63715)&4294967295),allocate([$c1,0,0,0],["i32*",0,0,0],ALLOC_STACK));$found=$call98;__lastLabel__=40;;}}
else if(__label__==41){var $call101=__Z10LookupMnemP8MNEM_TABPKc(((__ZL18xml_char_mnemonics)&4294967295),$arraydecay);$found=$call101;var $cmp102=((($call101))|0)!=-1;if(!($cmp102)){__label__=46;break $if_then85$$if_else109$49;}
var $57=$found;HEAP32[(($c1)>>2)]=$57;var $58=HEAP32[(($c2)>>2)];var $cmp104=((($58))|0)==0;if($cmp104){__lastLabel__=42;;}else{__lastLabel__=42;__label__=45;break $if_then89$$if_else100$51;}
HEAP32[(($c2)>>2)]=32;var $_pr=$found;__lastLabel__=43;;}}while(0);var $59=__lastLabel__==40?$call98:(__lastLabel__==39?$call95:(__lastLabel__==42?$57:($_pr)));var $cmp111=((($59))|0)<=0;if($cmp111){__label__=46;break $if_then85$$if_else109$49;}
var $_pr23=HEAP32[(($c1)>>2)];var $cmp114=((($_pr23))|0)<=32;if(!($cmp114)){__label__=72;break $land_lhs_true53$$if_end184$34;}
var $60=HEAP32[((__ZL10sayas_mode)>>2)];var $cmp116=((($60))|0)==20;var $61=HEAP32[((__ZL10sayas_mode)>>2)];var $cmp118=((($61))|0)==36;var $or_cond8=($cmp116)|($cmp118);if(!($or_cond8)){__label__=72;break $land_lhs_true53$$if_end184$34;}
var $62=HEAP32[(($c1)>>2)];var $add120=((($62)+57344)&4294967295);HEAP32[(($c1)>>2)]=$add120;__label__=72;break $land_lhs_true53$$if_end184$34;}
else if(__label__==44){$found=-1;;}}while(0);HEAP32[((__ZZ10ReadClauseP10TranslatorP7__sFILEPcPsPiiS5_S3_E15ungot_string_ix)>>2)]=0;HEAP32[(($c1)>>2)]=38;HEAP32[(($c2)>>2)]=32;__label__=72;break $land_lhs_true53$$if_end184$34;}}while(0);var $63=HEAP32[(($c1)>>2)];var $cmp123=((($63))|0)==60;var $64=HEAP32[((__ZL19ssml_ignore_l_angle)>>2)];var $cmp125=((($64))|0)!=60;var $or_cond9=($cmp123)&($cmp125);if(!($or_cond9)){__label__=72;break $land_lhs_true53$$if_end184$34;}
var $65=HEAP32[(($c2)>>2)];var $cmp127=((($65))|0)==33;if($cmp127){__label__=52;;}else{__label__=56;;}
if(__label__==52){while(1){var $call130=__Z3Eofv();var $tobool131=((($call130))|0)!=0;if($tobool131){__label__=55;break;}
var $66=HEAP32[(($c1)>>2)];var $cmp133=((($66))|0)!=62;if(!($cmp133)){__label__=55;break;}
var $call136=__ZL4GetCv();HEAP32[(($c1)>>2)]=$call136;__label__=52;continue;}
HEAP32[(($c2)>>2)]=32;;}
else if(__label__==56){var $67=HEAP32[(($c2)>>2)];var $cmp139=((($67))|0)==47;if($cmp139){__label__=58;;}else{__label__=57;;}
if(__label__==57){var $68=HEAP32[(($c2)>>2)];var $call141=_iswalpha($68);var $tobool142=((($call141))|0)!=0;if(!($tobool142)){__label__=72;break $land_lhs_true53$$if_end184$34;}}
$n_xml_buf=0;var $69=HEAP32[(($c2)>>2)];HEAP32[(($c1)>>2)]=$69;;while(1){var $call145=__Z3Eofv();var $tobool146=((($call145))|0)!=0;if($tobool146){__label__=63;break;}
var $70=HEAP32[(($c1)>>2)];var $cmp148=((($70))|0)!=62;if(!($cmp148)){__label__=63;break;}
var $71=$n_xml_buf;var $cmp150=((($71))|0)<256;if(!($cmp150)){__label__=63;break;}
var $72=HEAP32[(($c1)>>2)];var $73=$n_xml_buf;var $inc153=((($73)+1)&4294967295);$n_xml_buf=$inc153;var $arrayidx154=(($xml_buf+$73*4)&4294967295);HEAP32[(($arrayidx154)>>2)]=$72;var $call155=__ZL4GetCv();HEAP32[(($c1)>>2)]=$call155;__label__=59;continue;}
var $74=$n_xml_buf;var $arrayidx157=(($xml_buf+$74*4)&4294967295);HEAP32[(($arrayidx157)>>2)]=0;HEAP32[(($c2)>>2)]=32;$self_closing=0;var $75=$n_xml_buf;var $sub=((($75)-1)&4294967295);var $arrayidx158=(($xml_buf+$sub*4)&4294967295);var $76=HEAP32[(($arrayidx158)>>2)];var $cmp159=((($76))|0)==47;if($cmp159){__label__=64;;}else{__label__=65;;}
if(__label__==64){var $77=$n_xml_buf;var $sub161=((($77)-1)&4294967295);var $arrayidx162=(($xml_buf+$sub161*4)&4294967295);HEAP32[(($arrayidx162)>>2)]=32;$self_closing=1;;}
var $78=$buf_addr;var $79=$n_buf_addr;var $80=$self_closing;var $call165=__ZL14ProcessSsmlTagPwPcRiii($arraydecay164,$78,$ix,$79,$80);$terminator=$call165;var $cmp166=((($call165))|0)!=0;if($cmp166){__label__=66;break $while_cond$12;}
HEAP32[(($c1)>>2)]=32;var $call179=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call179;__label__=8;continue $while_cond$12;}}}while(0);HEAP32[((__ZL19ssml_ignore_l_angle)>>2)]=0;var $_b1=HEAPU8[(__ZL11ignore_text_b)];var $90=((($_b1))&1);var $tobool185=((($90))|0)!=0;if($tobool185){__label__=8;continue $while_cond$12;}
var $91=HEAP32[(($c2)>>2)];var $cmp188=((($91))|0)==10;var $92=HEAP32[((_option_linelength)>>2)];var $cmp190=((($92))|0)==-1;var $or_cond11=($cmp188)&($cmp190);var $93=HEAPU32[(($c1)>>2)];if($or_cond11){__label__=74;break $while_cond$12;}
var $cmp208=((($93))|0)==1;if($cmp208){__label__=80;;}else{__label__=79;;}
$if_then212$$lor_lhs_false209$90:do{if(__label__==79){var $111=HEAP32[(($c1)>>2)];var $112=HEAP8[(_ctrl_embedded)];var $conv210=(tempInt=(($112)),(tempInt>=128?tempInt-256:tempInt));var $cmp211=((($111))|0)==((($conv210))|0);if($cmp211){__label__=80;break $if_then212$$lor_lhs_false209$90;}else{__label__=97;break $if_then212$$lor_lhs_false209$90;}}}while(0);$if_then212$$if_end267$92:do{if(__label__==80){var $113=HEAP32[(($c2)>>2)];var $cmp213=((($113))|0)==86;if($cmp213){__label__=81;break $while_cond$12;}
var $123=HEAP32[(($c2)>>2)];var $cmp236=((($123))|0)==66;if(!($cmp236)){__label__=97;break $if_then212$$if_end267$92;}
var $124=HEAP32[(($ix)>>2)];var $125=$buf_addr;var $arrayidx238=(($125+$124)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str41208)&4294967295);$dest$=$arrayidx238;$stop$=$src$+4;if(($dest$%4)==($src$%4)&&4>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $126=HEAP32[(($ix)>>2)];var $add240=((($126)+3)&4294967295);HEAP32[(($ix)>>2)]=$add240;var $call241=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call241;var $cmp242=((($call241))|0)==48;if($cmp242){__label__=89;;}else{__label__=90;;}
$if_then243$$if_else244$96:do{if(__label__==89){HEAP32[((_option_punctuation)>>2)]=0;;}
else if(__label__==90){HEAP32[((_option_punctuation)>>2)]=1;HEAP32[((((_option_punctlist)&4294967295))>>2)]=0;var $127=HEAP32[(($c2)>>2)];var $cmp245=((($127))|0)!=49;if(!($cmp245)){__label__=96;break $if_then243$$if_else244$96;}
$j=0;;while(1){var $128=HEAP32[(($c2)>>2)];var $call248=_iswspace($128);var $tobool249=((($call248))|0)!=0;if($tobool249){__label__=95;break;}
var $call251=__Z3Eofv();var $tobool252=((($call251))|0)!=0;var $lnot=($tobool252)^1;if(!($lnot)){__label__=95;break;}
var $129=HEAP32[(($c2)>>2)];var $130=$j;var $inc255=((($130)+1)&4294967295);$j=$inc255;var $arrayidx256=((_option_punctlist+$130*4)&4294967295);HEAP32[(($arrayidx256)>>2)]=$129;var $call257=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call257;var $131=HEAP32[(($ix)>>2)];var $inc258=((($131)+1)&4294967295);HEAP32[(($ix)>>2)]=$inc258;var $132=$buf_addr;var $arrayidx259=(($132+$131)&4294967295);HEAP8[($arrayidx259)]=32;__label__=92;continue;}
var $133=$j;var $arrayidx261=((_option_punctlist+$133*4)&4294967295);HEAP32[(($arrayidx261)>>2)]=0;HEAP32[((_option_punctuation)>>2)]=2;;}}while(0);var $call264=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call264;__label__=8;continue $while_cond$12;}}while(0);var $134=$linelength;var $inc268=((($134)+1)&4294967295);$linelength=$inc268;var $135=HEAP32[(($c1)>>2)];var $call269=_iswalnum($135);var $tobool270=((($call269))|0)!=0;if($tobool270){__label__=98;;}else{__label__=99;;}
$if_then271$$if_else272$107:do{if(__label__==98){$any_alnum=1;;}
else if(__label__==99){var $136=$stressed_word;var $tobool273=((($136))|0)!=0;if($tobool273){__label__=100;;}else{__label__=101;;}
if(__label__==100){$stressed_word=0;HEAP32[(($c1)>>2)]=1328;var $137=HEAP32[(($c2)>>2)];__ZL6UngetCi($137);HEAP32[(($c2)>>2)]=32;;}
var $138=HEAP32[(($c1)>>2)];var $call276=__Z11lookupwcharPKti(((__ZL12chars_ignore)&4294967295),$138);var $tobool277=((($call276))|0)!=0;if($tobool277){__label__=8;continue $while_cond$12;}
var $139=HEAP32[(($c1)>>2)];var $call280=_iswspace($139);var $tobool281=((($call280))|0)!=0;if($tobool281){__label__=103;;}else{__label__=109;;}
$if_then282$$if_end304$114:do{if(__label__==103){var $140=$tr_addr;var $translator_name=(($140+280)&4294967295);var $141=HEAP32[(($translator_name)>>2)];var $cmp283=((($141))|0)==6972015;if(!($cmp283)){__label__=109;break $if_then282$$if_end304$114;}
var $142=HEAP32[(($ix)>>2)];var $sub285=((($142)-1)&4294967295);var $143=$buf_addr;var $arrayidx286=(($143+$sub285)&4294967295);$p_word=$arrayidx286;var $144=$p_word;var $arrayidx287=(($144)&4294967295);var $145=HEAP8[($arrayidx287)];var $conv288=(tempInt=(($145)),(tempInt>=128?tempInt-256:tempInt));var $cmp289=((($conv288))|0)==105;if(!($cmp289)){__label__=109;break $if_then282$$if_end304$114;}
var $146=$p_word;var $arrayidx291=(($146+-1)&4294967295);var $147=HEAP8[($arrayidx291)];var $conv292=(tempInt=(($147)),(tempInt>=128?tempInt-256:tempInt));var $cmp293=((($conv292))|0)==46;if($cmp293){__label__=106;;}else{__label__=107;;}
if(__label__==106){var $148=$p_word;var $incdec_ptr=(($148+-1)&4294967295);$p_word=$incdec_ptr;;}
var $149=$p_word;var $arrayidx296=(($149+-1)&4294967295);var $150=HEAP8[($arrayidx296)];var $conv297=(tempInt=(($150)),(tempInt>=128?tempInt-256:tempInt));var $cmp298=((($conv297))|0)==32;if($cmp298){__label__=108;break $while_cond$12;}}}while(0);var $153=HEAP32[(($c1)>>2)];var $cmp305=((($153))|0)==3405;if(!($cmp305)){__label__=112;break $if_then271$$if_else272$107;}
var $154=HEAP32[(($c2)>>2)];var $cmp307=((($154))|0)==8205;if(!($cmp307)){__label__=112;break $if_then271$$if_else272$107;}
HEAP32[(($c1)>>2)]=3406;;}}while(0);var $155=HEAP32[(($c1)>>2)];var $call312=_iswupper($155);var $tobool313=((($call312))|0)!=0;if($tobool313){__label__=113;;}else{__label__=118;;}
$if_then314$$if_else343$125:do{if(__label__==113){var $156=$tr_addr;var $clause_upper_count315=(($156+8304)&4294967295);var $157=HEAP32[(($clause_upper_count315)>>2)];var $inc316=((($157)+1)&4294967295);HEAP32[(($clause_upper_count315)>>2)]=$inc316;var $158=HEAP32[((_option_capitals)>>2)];var $cmp317=((($158))|0)==2;var $159=HEAP32[((__ZL10sayas_mode)>>2)];var $cmp319=((($159))|0)==0;var $or_cond13=($cmp317)&($cmp319);if(!($or_cond13)){__label__=120;break $if_then314$$if_else343$125;}
var $160=$cprev;var $call321=_iswupper($160);var $tobool322=((($call321))|0)!=0;if($tobool322){__label__=120;break $if_then314$$if_else343$125;}
var $161=$tr_addr;var $call325=__ZL13LookupSpecialP10TranslatorPKcPc($161,$arraydecay324);var $cmp326=((($call325))|0)!=0;if(!($cmp326)){__label__=120;break $if_then314$$if_else343$125;}
var $strlen=_strlen($arraydecay329);var $leninc=((($strlen)+1)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$arraydecay329;$dest$=$arraydecay328;$stop$=$src$+$leninc;if(($dest$%4)==($src$%4)&&$leninc>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $call332=_strlen($arraydecay331);$j=$call332;var $162=HEAP32[(($ix)>>2)];var $163=$j;var $add333=((($163)+($162))&4294967295);var $164=$n_buf_addr;var $cmp334=((($add333))|0)<((($164))|0);if(!($cmp334)){__label__=120;break $if_then314$$if_else343$125;}
var $165=HEAP32[(($ix)>>2)];var $166=$buf_addr;var $arrayidx336=(($166+$165)&4294967295);var $call338=_strcpy($arrayidx336,$arraydecay337);var $167=$j;var $168=HEAP32[(($ix)>>2)];var $add339=((($168)+($167))&4294967295);HEAP32[(($ix)>>2)]=$add339;;}
else if(__label__==118){var $169=HEAP32[(($c1)>>2)];var $call344=_iswalpha($169);var $tobool345=((($call344))|0)!=0;if(!($tobool345)){__label__=120;break $if_then314$$if_else343$125;}
var $170=$tr_addr;var $clause_lower_count347=(($170+8308)&4294967295);var $171=HEAP32[(($clause_lower_count347)>>2)];var $inc348=((($171)+1)&4294967295);HEAP32[(($clause_lower_count347)>>2)]=$inc348;;}}while(0);var $172=HEAP32[((_option_phoneme_input)>>2)];var $tobool351=((($172))|0)!=0;if($tobool351){__label__=121;;}else{__label__=130;;}
$if_then352$$if_end368$134:do{if(__label__==121){var $173=$phoneme_mode;var $cmp353=((($173))|0)>0;if($cmp353){__label__=122;;}else{__label__=123;;}
if(__label__==122){var $174=$phoneme_mode;var $dec=((($174)-1)&4294967295);$phoneme_mode=$dec;;}
else if(__label__==123){var $175=HEAP32[(($c1)>>2)];var $cmp356=((($175))|0)==91;if($cmp356){__lastLabel__=123;__label__=124;;}else{__lastLabel__=123;__label__=127;;}
if(__label__==124){var $176=HEAP32[(($c2)>>2)];var $cmp358=((($176))|0)==91;if($cmp358){__label__=125;;}else{__label__=126;;}
if(__label__==125){$phoneme_mode=-1;__label__=130;break $if_then352$$if_end368$134;}
else if(__label__==126){var $_pr25=HEAP32[(($c1)>>2)];__lastLabel__=126;;}}
var $177=__lastLabel__==126?$_pr25:($175);var $cmp361=((($177))|0)==93;if(!($cmp361)){__label__=130;break $if_then352$$if_end368$134;}
var $178=HEAP32[(($c2)>>2)];var $cmp363=((($178))|0)==93;if(!($cmp363)){__label__=130;break $if_then352$$if_end368$134;}
$phoneme_mode=2;;}}}while(0);var $179=HEAP32[(($c1)>>2)];var $cmp369=((($179))|0)==10;if($cmp369){__label__=131;;}else{__label__=148;;}
if(__label__==131){$parag=0;;while(1){var $call372=__Z3Eofv();var $tobool373=((($call372))|0)!=0;if($tobool373){__label__=137;break;}
var $180=HEAP32[(($c2)>>2)];var $call375=_iswspace($180);var $tobool376=((($call375))|0)!=0;if(!($tobool376)){__label__=137;break;}
var $181=HEAP32[(($c2)>>2)];var $cmp379=((($181))|0)==10;if($cmp379){__label__=135;;}else{__label__=136;;}
if(__label__==135){var $182=$parag;var $inc381=((($182)+1)&4294967295);$parag=$inc381;;}
var $call383=__ZL4GetCv();HEAP32[(($c2)>>2)]=$call383;__label__=132;continue;}
var $183=$parag;var $cmp385=((($183))|0)>0;if($cmp385){__label__=138;break $while_cond$12;}
var $195=$linelength;var $196=HEAP32[((_option_linelength)>>2)];var $cmp402=((($195))|0)<=((($196))|0);if($cmp402){__label__=146;break $while_cond$12;}
$linelength=0;;}
var $202=$announced_punctuation;$prev_announced_punctuation=$202;$announced_punctuation=0;var $203=$phoneme_mode;var $cmp409=((($203))|0)==0;var $204=HEAP32[((__ZL10sayas_mode)>>2)];var $cmp411=((($204))|0)==0;var $or_cond14=($cmp409)&($cmp411);if($or_cond14){__label__=149;;}else{__label__=238;;}
$if_then412$$if_end643$161:do{if(__label__==149){$is_end_clause=0;var $205=$end_clause_after_tag;var $tobool413=((($205))|0)!=0;if($tobool413){__label__=150;;}else{__label__=155;;}
$if_then414$$if_end429$163:do{if(__label__==150){var $206=HEAP32[(($c1)>>2)];var $call415=_iswspace($206);var $tobool416=((($call415))|0)!=0;if($tobool416){__label__=155;break $if_then414$$if_end429$163;}
var $207=HEAP32[(($c1)>>2)];var $call418=__Z7IsAlphaj($207);var $tobool419=((($call418))|0)!=0;if(!($tobool419)){__label__=153;break $while_cond$12;}
var $208=HEAP32[(($c1)>>2)];var $call421=_iswlower($208);var $tobool422=((($call421))|0)!=0;if(!($tobool422)){__label__=153;break $while_cond$12;}
$end_clause_after_tag=0;;}}while(0);var $216=HEAP32[(($c1)>>2)];var $cmp430=((($216))|0)==46;if($cmp430){__label__=156;;}else{__label__=162;;}
$land_lhs_true431$$if_end443$169:do{if(__label__==156){var $217=HEAP32[(($c2)>>2)];var $cmp432=((($217))|0)==46;if(!($cmp432)){__label__=162;break $land_lhs_true431$$if_end443$169;}
var $call43538=__ZL4GetCv();$c_next=$call43538;var $cmp43639=((($call43538))|0)==46;if($cmp43639){__label__=158;;}else{__label__=159;;}
$while_body437$$while_end438$172:do{if(__label__==158){while(1){HEAP32[(($c1)>>2)]=8230;HEAP32[(($c2)>>2)]=32;var $call435=__ZL4GetCv();$c_next=$call435;var $cmp436=((($call435))|0)==46;if($cmp436){__label__=158;continue;}else{__label__=159;break $while_body437$$while_end438$172;}}}}while(0);var $218=HEAP32[(($c1)>>2)];var $cmp439=((($218))|0)==8230;var $219=$c_next;if($cmp439){__label__=160;;}else{__label__=161;;}
if(__label__==160){HEAP32[(($c2)>>2)]=$219;;}
else if(__label__==161){__ZL6UngetCi($219);;}}}while(0);$punct_data=0;var $220=HEAP32[(($c1)>>2)];var $call444=__Z11lookupwcharPKti(((__ZL11punct_chars)&4294967295),$220);$punct=$call444;var $cmp445=((($call444))|0)!=0;if($cmp445){__label__=163;;}else{__label__=171;;}
$if_then446$$if_end471$180:do{if(__label__==163){var $221=$punct;var $arrayidx447=((__ZL16punct_attributes+$221*4)&4294967295);var $222=HEAP32[(($arrayidx447)>>2)];$punct_data=$222;var $223=$punct_data;var $and448=($223)&1048576;var $tobool449=((($and448))|0)!=0;if($tobool449){__label__=164;;}else{__label__=165;;}
if(__label__==164){$stressed_word=1;var $224=$punct_data;var $shr=($224)>>12;var $and451=($shr)&15;var $225=$tone_type_addr;HEAP32[(($225)>>2)]=$and451;__label__=8;continue $while_cond$12;}
else if(__label__==165){var $226=HEAP32[(($c2)>>2)];var $call453=_iswspace($226);var $tobool454=((($call453))|0)!=0;if($tobool454){__label__=170;;}else{__label__=166;;}
$if_then469$$lor_lhs_false455$185:do{if(__label__==166){var $227=$punct_data;var $and456=($227)&32768;var $tobool457=((($and456))|0)!=0;if($tobool457){__label__=170;break $if_then469$$lor_lhs_false455$185;}
var $228=HEAP32[(($c2)>>2)];var $call459=__Z9IsBracketi($228);var $tobool460=((($call459))|0)!=0;var $229=HEAP32[(($c2)>>2)];var $cmp462=((($229))|0)==63;var $or_cond15=($tobool460)|($cmp462);if($or_cond15){__label__=170;break $if_then469$$lor_lhs_false455$185;}
var $call464=__Z3Eofv();var $tobool465=((($call464))|0)!=0;if($tobool465){__label__=170;break $if_then469$$lor_lhs_false455$185;}
var $230=HEAP32[(($c2)>>2)];var $231=HEAP8[(_ctrl_embedded)];var $conv467=(tempInt=(($231)),(tempInt>=128?tempInt-256:tempInt));var $cmp468=((($230))|0)==((($conv467))|0);if(!($cmp468)){__label__=171;break $if_then446$$if_end471$180;}}}while(0);$is_end_clause=1;;}}}while(0);var $232=HEAP32[(($c1)>>2)];var $cmp472=((($232))|0)==57404;if($cmp472){__label__=172;;}else{__label__=173;;}
if(__label__==172){HEAP32[(($c1)>>2)]=60;;}
var $233=HEAP32[((_option_punctuation)>>2)];var $tobool475=((($233))|0)!=0;if($tobool475){__label__=174;;}else{__label__=181;;}
$land_lhs_true476$$if_end493$195:do{if(__label__==174){var $234=HEAP32[(($c1)>>2)];var $call477=_iswpunct($234);var $tobool478=((($call477))|0)!=0;if(!($tobool478)){__label__=181;break $land_lhs_true476$$if_end493$195;}
var $_b2=HEAPU8[(__ZL10audio_text_b)];var $235=((($_b2))&1);var $cmp480=((($235))|0)==0;if(!($cmp480)){__label__=181;break $land_lhs_true476$$if_end493$195;}
var $236=HEAP32[((_option_punctuation)>>2)];var $cmp482=((($236))|0)==1;if($cmp482){__label__=178;;}else{__label__=177;;}
if(__label__==177){var $237=HEAP32[(($c1)>>2)];var $call484=_wcschr(((_option_punctlist)&4294967295),$237);var $cmp485=((($call484))|0)!=0;if(!($cmp485)){__label__=181;break $land_lhs_true476$$if_end493$195;}}
var $238=$tr_addr;var $phonemes_repeat_count487=(($238+652)&4294967295);HEAP32[(($phonemes_repeat_count487)>>2)]=0;var $239=$tr_addr;var $240=HEAP32[(($c1)>>2)];var $241=$buf_addr;var $242=$is_end_clause;var $call488=__ZL19AnnouncePunctuationP10TranslatoriPiPcS1_i($239,$240,$c2,$241,$ix,$242);$terminator=$call488;var $cmp489=((($call488))|0)>=0;if($cmp489){__label__=179;break $while_cond$12;}
var $244=HEAP32[(($c1)>>2)];$announced_punctuation=$244;;}}while(0);var $245=$punct_data;var $and494=($245)&2097152;var $tobool495=((($and494))|0)!=0;if($tobool495){__label__=182;;}else{__label__=185;;}
$land_lhs_true496$$if_end510$204:do{if(__label__==182){var $246=$announced_punctuation;var $cmp497=((($246))|0)==0;if(!($cmp497)){__label__=185;break $land_lhs_true496$$if_end510$204;}
var $247=HEAP32[(($ix)>>2)];var $248=$buf_addr;var $arrayidx499=(($248+$247)&4294967295);$p2=$arrayidx499;var $249=$p2;var $250=$tr_addr;var $251=HEAP32[(($c1)>>2)];__ZL14LookupCharNameP10Translatorii($250,$251,1);var $strlen20=_strlen(((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295));var $leninc21=((($strlen20)+1)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295);$dest$=$249;$stop$=$src$+$leninc21;if(($dest$%4)==($src$%4)&&$leninc21>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $252=$p2;var $arrayidx502=(($252)&4294967295);var $253=HEAP8[($arrayidx502)];var $conv503=(tempInt=(($253)),(tempInt>=128?tempInt-256:tempInt));var $cmp504=((($conv503))|0)!=0;if(!($cmp504)){__label__=185;break $land_lhs_true496$$if_end510$204;}
var $254=$p2;var $call506=_strlen($254);var $255=HEAP32[(($ix)>>2)];var $add507=((($255)+($call506))&4294967295);HEAP32[(($ix)>>2)]=$add507;var $256=HEAP32[(($c1)>>2)];$announced_punctuation=$256;var $257=$punct_data;var $and508=($257)&-28673;$punct_data=$and508;;}}while(0);var $258=$is_end_clause;var $tobool511=((($258))|0)!=0;if(!($tobool511)){__label__=238;break $if_then412$$if_end643$161;}
$nl_count=0;var $259=HEAP32[(($c2)>>2)];$c_next=$259;var $260=$c_next;var $call513=_iswspace($260);var $tobool514=((($call513))|0)!=0;if($tobool514){__label__=187;;}else{__label__=192;;}
$while_cond516$$if_end530$210:do{if(__label__==187){while(1){var $call517=__Z3Eofv();var $tobool518=((($call517))|0)!=0;if($tobool518){__label__=192;break $while_cond516$$if_end530$210;}
var $261=$c_next;var $call520=_iswspace($261);var $tobool521=((($call520))|0)!=0;if(!($tobool521)){__label__=192;break $while_cond516$$if_end530$210;}
var $262=$c_next;var $cmp524=((($262))|0)==10;if($cmp524){__label__=190;;}else{__label__=191;;}
if(__label__==190){var $263=$nl_count;var $inc526=((($263)+1)&4294967295);$nl_count=$inc526;;}
var $call528=__ZL4GetCv();$c_next=$call528;__label__=187;continue;}}}while(0);var $264=HEAP32[(($c1)>>2)];var $cmp531=((($264))|0)==46;if($cmp531){__label__=193;;}else{__label__=195;;}
$land_lhs_true532$$if_end535$219:do{if(__label__==193){var $265=$nl_count;var $cmp533=((($265))|0)<2;if(!($cmp533)){__label__=226;break $land_lhs_true532$$if_end535$219;}
var $266=$punct_data;var $or=($266)|4194304;$punct_data=$or;__label__=195;break $land_lhs_true532$$if_end535$219;}}while(0);$if_end535$$if_end609$222:do{if(__label__==195){var $_pr26=$nl_count;var $cmp536=((($_pr26))|0)==0;if(!($cmp536)){__label__=226;break $if_end535$$if_end609$222;}
var $267=HEAP32[(($c1)>>2)];var $cmp538=((($267))|0)==44;if($cmp538){__lastLabel__=196;__label__=197;;}else{__lastLabel__=196;__label__=204;;}
$land_lhs_true539$$if_end554$225:do{if(__label__==197){var $268=$cprev;var $cmp540=((($268))|0)==46;if($cmp540){__label__=198;;}else{__label__=203;;}
$land_lhs_true541$$if_end554thread_pre_split$227:do{if(__label__==198){var $269=$tr_addr;var $translator_name542=(($269+280)&4294967295);var $270=HEAP32[(($translator_name542)>>2)];var $cmp543=((($270))|0)==26741;if(!($cmp543)){__label__=203;break $land_lhs_true541$$if_end554thread_pre_split$227;}
var $271=$cprev2;var $call545=_iswdigit($271);var $tobool546=((($call545))|0)!=0;if(!($tobool546)){__label__=203;break $land_lhs_true541$$if_end554thread_pre_split$227;}
var $272=$c_next;var $call548=_iswdigit($272);var $tobool549=((($call548))|0)!=0;if($tobool549){__label__=202;;}else{__label__=201;;}
if(__label__==201){var $273=$c_next;var $call551=_iswlower($273);var $tobool552=((($call551))|0)!=0;if(!($tobool552)){__label__=203;break $land_lhs_true541$$if_end554thread_pre_split$227;}}
HEAP32[(($c1)>>2)]=1367;$is_end_clause=0;__label__=220;break $land_lhs_true539$$if_end554$225;}}while(0);var $_pr28=HEAP32[(($c1)>>2)];__lastLabel__=203;__label__=204;break $land_lhs_true539$$if_end554$225;}}while(0);$if_else595$$if_end554$235:do{if(__label__==204){var $274=__lastLabel__==203?$_pr28:($267);var $cmp555=((($274))|0)==46;if(!($cmp555)){__label__=220;break $if_else595$$if_end554$235;}
var $275=$tr_addr;var $langopts=(($275)&4294967295);var $numbers=(($langopts+184)&4294967295);var $276=HEAP32[(($numbers)>>2)];var $and557=($276)&65536;var $tobool558=((($and557))|0)!=0;if($tobool558){__label__=206;;}else{__label__=214;;}
$land_lhs_true559$$if_else583$238:do{if(__label__==206){var $277=$cprev;var $call560=_iswdigit($277);var $tobool561=((($call560))|0)!=0;if($tobool561){__label__=210;;}else{__label__=207;;}
$if_then571$$lor_lhs_false562$240:do{if(__label__==207){var $278=$cprev;var $call563=__ZL8IsRomanUj($278);var $tobool564=((($call563))|0)!=0;if(!($tobool564)){__label__=214;break $land_lhs_true559$$if_else583$238;}
var $279=$cprev2;var $call566=__ZL8IsRomanUj($279);var $tobool567=((($call566))|0)!=0;if($tobool567){__label__=210;break $if_then571$$lor_lhs_false562$240;}
var $280=$cprev2;var $call569=_iswspace($280);var $tobool570=((($call569))|0)!=0;if(!($tobool570)){__label__=214;break $land_lhs_true559$$if_else583$238;}}}while(0);var $281=$cprev;var $call572=_iswdigit($281);var $tobool573=((($call572))|0)!=0;if($tobool573){__label__=212;;}else{__label__=211;;}
if(__label__==212){var $282=$c_next;var $call576=_iswlower($282);var $tobool577=((($call576))|0)!=0;var $283=$c_next;var $cmp579=((($283))|0)==45;var $or_cond16=($tobool577)|($cmp579);if(!($or_cond16)){__label__=216;break $land_lhs_true559$$if_else583$238;}
$is_end_clause=0;__label__=216;break $land_lhs_true559$$if_else583$238;}
else if(__label__==211){$is_end_clause=0;__label__=216;break $land_lhs_true559$$if_else583$238;}}}while(0);$if_end587$$if_else583$249:do{if(__label__==214){var $284=$c_next;var $cmp584=((($284))|0)==39;if(!($cmp584)){__label__=216;break $if_end587$$if_else583$249;}
$is_end_clause=0;;}}while(0);var $285=$c_next;var $call588=_iswlower($285);var $tobool589=((($call588))|0)!=0;if($tobool589){__label__=217;;}else{__label__=218;;}
if(__label__==217){$is_end_clause=0;;}
var $286=$any_alnum;var $cmp592=((($286))|0)==0;if(!($cmp592)){__label__=222;break $if_else595$$if_end554$235;}
HEAP32[(($c1)>>2)]=32;$is_end_clause=0;__label__=235;break $if_end535$$if_end609$222;}}while(0);$if_else595$$if_end599$257:do{if(__label__==220){var $287=$any_alnum;var $cmp596=((($287))|0)==0;if(!($cmp596)){__label__=222;break $if_else595$$if_end599$257;}
$is_end_clause=0;__label__=235;break $if_end535$$if_end609$222;}}while(0);var $_pr30=$is_end_clause;var $tobool600=((($_pr30))|0)!=0;if(!($tobool600)){__label__=235;break $if_end535$$if_end609$222;}
var $288=HEAP32[(($c1)>>2)];var $cmp602=((($288))|0)==46;if(!($cmp602)){__label__=226;break $if_end535$$if_end609$222;}
var $289=$c_next;var $cmp604=((($289))|0)==60;var $290=HEAP32[((_option_ssml)>>2)];var $tobool606=((($290))|0)!=0;var $or_cond17=($cmp604)&($tobool606);if(!($or_cond17)){__label__=226;break $if_end535$$if_end609$222;}
$is_end_clause=0;var $291=HEAP32[(($ix)>>2)];$end_clause_index=$291;var $292=$punct_data;$end_clause_after_tag=$292;__label__=235;break $if_end535$$if_end609$222;}}while(0);if(__label__==226){var $_pr32_pr=$is_end_clause;var $tobool610=((($_pr32_pr))|0)!=0;if($tobool610){__label__=227;break $while_cond$12;}}
var $call633=__Z3Eofv();var $tobool634=((($call633))|0)!=0;if($tobool634){__label__=238;break $if_then412$$if_end643$161;}
var $305=HEAP32[(($c2)>>2)];var $call636=_iswspace($305);var $tobool637=((($call636))|0)!=0;if(!($tobool637)){__label__=238;break $if_then412$$if_end643$161;}
var $306=$c_next;__ZL6UngetCi($306);;}}while(0);var $307=HEAP32[((((__ZL17speech_parameters)&4294967295))>>2)];var $cmp644=((($307))|0)==1;if($cmp644){__label__=8;continue $while_cond$12;}
var $308=HEAP32[(($c1)>>2)];var $309=$announced_punctuation;var $cmp647=((($308))|0)==((($309))|0);if($cmp647){__label__=240;;}else{__label__=245;;}
$if_then648$$if_end657$271:do{if(__label__==240){var $310=HEAP32[(($c1)>>2)];var $call649=__Z9IsBracketi($310);var $tobool650=((($call649))|0)!=0;if($tobool650){__label__=241;;}else{__label__=242;;}
$if_then651$$if_else652$273:do{if(__label__==241){HEAP32[(($c1)>>2)]=57384;;}
else if(__label__==242){var $311=HEAP32[(($c1)>>2)];var $cmp653=((($311))|0)!=45;if(!($cmp653)){__label__=244;break $if_then651$$if_else652$273;}
HEAP32[(($c1)>>2)]=32;;}}while(0);var $312=HEAP32[(($ix)>>2)];var $add65834=((($312)+1)&4294967295);$j=$add65834;;}
else if(__label__==245){var $313=HEAP32[(($ix)>>2)];var $add658=((($313)+1)&4294967295);$j=$add658;var $cmp659=((($308))|0)==57404;if(!($cmp659)){__label__=247;break $if_then648$$if_end657$271;}
HEAP32[(($c1)>>2)]=60;;}}while(0);var $314=HEAP32[(($c1)>>2)];var $315=HEAP32[(($ix)>>2)];var $316=$buf_addr;var $arrayidx662=(($316+$315)&4294967295);var $call663=__Z8utf8_outjPc($314,$arrayidx662);var $317=HEAP32[(($ix)>>2)];var $add664=((($317)+($call663))&4294967295);HEAP32[(($ix)>>2)]=$add664;var $318=HEAP32[(($c1)>>2)];var $call665=_iswspace($318);var $tobool666=((($call665))|0)!=0;if($tobool666){__label__=251;;}else{__label__=248;;}
$if_end680$$land_lhs_true667$281:do{if(__label__==248){var $319=HEAP32[(($c1)>>2)];var $call668=__Z9IsBracketi($319);var $tobool669=((($call668))|0)!=0;if($tobool669){__label__=251;break $if_end680$$land_lhs_true667$281;}
var $320=HEAP32[((_count_characters)>>2)];var $321=HEAP32[((_clause_start_char)>>2)];var $sub671=((($320)-($321))&4294967295);var $conv672=((($sub671))&65535);var $322=HEAP32[(($ix)>>2)];var $323=$charix_addr;var $arrayidx673=(($323+2*$322)&4294967295);HEAP16[(($arrayidx673)>>1)]=$conv672;var $324=$j;var $325=HEAP32[(($ix)>>2)];var $cmp67537=((($324))|0)<((($325))|0);if(!($cmp67537)){__label__=251;break $if_end680$$land_lhs_true667$281;}
while(1){var $326=$j;var $inc677=((($326)+1)&4294967295);$j=$inc677;var $327=$charix_addr;var $arrayidx678=(($327+2*$326)&4294967295);HEAP16[(($arrayidx678)>>1)]=-1;var $328=$j;var $329=HEAP32[(($ix)>>2)];var $cmp675=((($328))|0)<((($329))|0);if($cmp675){__label__=250;continue;}else{__label__=251;break $if_end680$$land_lhs_true667$281;}}}}while(0);var $330=HEAP32[(($ix)>>2)];var $331=$charix_top_addr;HEAP32[(($331)>>2)]=$330;var $332=HEAP32[(($ix)>>2)];var $333=$n_buf_addr;var $sub681=((($333)-20)&4294967295);var $cmp682=((($332))|0)>((($sub681))|0);if($cmp682){__label__=252;;}else{__label__=254;;}
$land_lhs_true683$$lor_lhs_false689$287:do{if(__label__==252){var $334=HEAP32[(($c1)>>2)];var $call684=__Z7IsAlphaj($334);var $tobool685=((($call684))|0)!=0;if($tobool685){__label__=254;break $land_lhs_true683$$lor_lhs_false689$287;}
var $335=HEAP32[(($c1)>>2)];var $call687=_iswdigit($335);var $tobool688=((($call687))|0)!=0;if(!($tobool688)){__label__=255;break $while_cond$12;}}}while(0);var $336=HEAP32[(($ix)>>2)];var $337=$n_buf_addr;var $sub690=((($337)-2)&4294967295);var $cmp691=((($336))|0)>=((($sub690))|0);if($cmp691){__label__=255;break $while_cond$12;}else{__label__=8;continue $while_cond$12;}}
if(__label__==256){var $343=$stressed_word;var $tobool698=((($343))|0)!=0;if($tobool698){__label__=257;;}else{__label__=258;;}
if(__label__==257){var $344=HEAP32[(($ix)>>2)];var $345=$buf_addr;var $arrayidx700=(($345+$344)&4294967295);var $call701=__Z8utf8_outjPc(1328,$arrayidx700);var $346=HEAP32[(($ix)>>2)];var $add702=((($346)+($call701))&4294967295);HEAP32[(($ix)>>2)]=$add702;;}
var $347=$end_clause_after_tag;var $tobool704=((($347))|0)!=0;if($tobool704){__label__=259;;}else{__label__=260;;}
if(__label__==259){var $348=$end_clause_index;var $349=$buf_addr;var $arrayidx706=(($349+$348)&4294967295);__ZL10RemoveCharPc($arrayidx706);;}
var $350=HEAP32[(($ix)>>2)];var $351=$buf_addr;var $arrayidx708=(($351+$350)&4294967295);HEAP8[($arrayidx708)]=32;var $352=HEAP32[(($ix)>>2)];var $add709=((($352)+1)&4294967295);var $353=$buf_addr;var $arrayidx710=(($353+$add709)&4294967295);HEAP8[($arrayidx710)]=0;$retval=589864;;}
else if(__label__==12){HEAP8[(__ZL12end_of_input_b)]=1;$retval=589864;;}
else if(__label__==15){HEAP8[(__ZL19clear_skipping_text_b)]=1;HEAP32[((_skip_characters)>>2)]=0;var $24=HEAP32[(($c2)>>2)];__ZL6UngetCi($24);$retval=16384;;}
else if(__label__==66){var $81=$end_clause_after_tag;var $tobool168=((($81))|0)!=0;if($tobool168){__label__=67;;}else{__label__=68;;}
if(__label__==67){var $82=$end_clause_index;HEAP32[(($ix)>>2)]=$82;;}
var $83=HEAP32[(($ix)>>2)];var $84=$buf_addr;var $arrayidx171=(($84+$83)&4294967295);HEAP8[($arrayidx171)]=32;var $85=HEAP32[(($ix)>>2)];var $inc172=((($85)+1)&4294967295);HEAP32[(($ix)>>2)]=$inc172;var $86=$buf_addr;var $arrayidx173=(($86+$85)&4294967295);HEAP8[($arrayidx173)]=0;var $87=$terminator;var $and=($87)&131072;var $tobool174=((($and))|0)!=0;if($tobool174){__label__=69;;}else{__label__=70;;}
if(__label__==69){var $88=$voice_change_addr;var $call176=_strcpy($88,((__ZL16current_voice_id)&4294967295));;}
var $89=$terminator;$retval=$89;;}
else if(__label__==74){var $call192=__Z11lookupwcharPKti(((__ZL11punct_chars)&4294967295),$93);$punct=$call192;var $cmp193=((($call192))|0)==0;if($cmp193){__label__=75;;}else{__label__=76;;}
if(__label__==75){var $94=HEAP32[((_count_characters)>>2)];var $95=HEAP32[((_clause_start_char)>>2)];var $sub195=((($94)-($95))&4294967295);var $conv196=((($sub195))&65535);var $96=HEAP32[(($ix)>>2)];var $97=$charix_addr;var $arrayidx197=(($97+2*$96)&4294967295);HEAP16[(($arrayidx197)>>1)]=$conv196;var $98=HEAP32[(($ix)>>2)];var $99=$charix_top_addr;HEAP32[(($99)>>2)]=$98;var $100=HEAP32[(($c1)>>2)];var $101=HEAP32[(($ix)>>2)];var $102=$buf_addr;var $arrayidx198=(($102+$101)&4294967295);var $call199=__Z8utf8_outjPc($100,$arrayidx198);var $103=HEAP32[(($ix)>>2)];var $add200=((($103)+($call199))&4294967295);HEAP32[(($ix)>>2)]=$add200;$terminator=524328;;}
else if(__label__==76){var $104=$punct;var $arrayidx202=((__ZL16punct_attributes+$104*4)&4294967295);var $105=HEAP32[(($arrayidx202)>>2)];$terminator=$105;;}
var $106=HEAP32[(($ix)>>2)];var $107=$buf_addr;var $arrayidx204=(($107+$106)&4294967295);HEAP8[($arrayidx204)]=32;var $108=HEAP32[(($ix)>>2)];var $add205=((($108)+1)&4294967295);var $109=$buf_addr;var $arrayidx206=(($109+$add205)&4294967295);HEAP8[($arrayidx206)]=0;var $110=$terminator;$retval=$110;;}
else if(__label__==81){var $114=HEAP32[(($ix)>>2)];var $inc215=((($114)+1)&4294967295);HEAP32[(($ix)>>2)]=$inc215;var $115=$buf_addr;var $arrayidx216=(($115+$114)&4294967295);HEAP8[($arrayidx216)]=0;;while(1){var $call218=__ZL4GetCv();HEAP32[(($c1)>>2)]=$call218;var $call219=_iswspace($call218);var $tobool220=((($call219))|0)!=0;if($tobool220){__label__=86;break;}
var $call222=__Z3Eofv();var $tobool223=((($call222))|0)!=0;if($tobool223){__label__=86;break;}
var $116=HEAP32[(($ix)>>2)];var $117=$n_buf_addr;var $sub225=((($117)-1)&4294967295);var $cmp226=((($116))|0)<((($sub225))|0);if(!($cmp226)){__label__=86;break;}
var $118=HEAP32[(($c1)>>2)];var $conv229=((($118))&255);var $119=HEAP32[(($ix)>>2)];var $inc230=((($119)+1)&4294967295);HEAP32[(($ix)>>2)]=$inc230;var $120=$buf_addr;var $arrayidx231=(($120+$119)&4294967295);HEAP8[($arrayidx231)]=$conv229;__label__=82;continue;}
var $121=HEAP32[(($ix)>>2)];var $inc233=((($121)+1)&4294967295);HEAP32[(($ix)>>2)]=$inc233;var $122=$buf_addr;var $arrayidx234=(($122+$121)&4294967295);HEAP8[($arrayidx234)]=0;$retval=147456;;}
else if(__label__==108){HEAP32[((__ZL10ungot_word)>>2)]=((__str42209)&4294967295);var $151=HEAP32[(($c2)>>2)];__ZL6UngetCi($151);var $152=$p_word;var $arrayidx300=(($152)&4294967295);HEAP8[($arrayidx300)]=0;$retval=524328;;}
else if(__label__==138){var $184=HEAP32[(($c2)>>2)];__ZL6UngetCi($184);var $185=$end_clause_after_tag;var $tobool387=((($185))|0)!=0;if($tobool387){__label__=139;;}else{__label__=140;;}
if(__label__==139){var $186=$end_clause_index;var $187=$buf_addr;var $arrayidx389=(($187+$186)&4294967295);__ZL10RemoveCharPc($arrayidx389);;}
var $188=HEAP32[(($ix)>>2)];var $189=$buf_addr;var $arrayidx391=(($189+$188)&4294967295);HEAP8[($arrayidx391)]=32;var $190=HEAP32[(($ix)>>2)];var $add392=((($190)+1)&4294967295);var $191=$buf_addr;var $arrayidx393=(($191+$add392)&4294967295);HEAP8[($arrayidx393)]=0;var $192=$parag;var $cmp394=((($192))|0)>3;if($cmp394){__label__=141;;}else{__label__=142;;}
if(__label__==141){$parag=3;;}
var $193=HEAP32[((_option_ssml)>>2)];var $tobool397=((($193))|0)!=0;if($tobool397){__label__=143;;}else{__label__=144;;}
if(__label__==143){$parag=1;;}
var $194=$parag;var $mul=((($194)*30)&4294967295);var $add400=((($mul)+524328)&4294967295);$retval=$add400;;}
else if(__label__==146){var $197=HEAP32[(($c2)>>2)];__ZL6UngetCi($197);var $198=HEAP32[(($ix)>>2)];var $199=$buf_addr;var $arrayidx404=(($199+$198)&4294967295);HEAP8[($arrayidx404)]=32;var $200=HEAP32[(($ix)>>2)];var $add405=((($200)+1)&4294967295);var $201=$buf_addr;var $arrayidx406=(($201+$add405)&4294967295);HEAP8[($arrayidx406)]=0;$retval=262174;;}
else if(__label__==153){var $209=HEAP32[(($c2)>>2)];__ZL6UngetCi($209);var $210=HEAP32[(($c1)>>2)];HEAP32[((__ZL11ungot_char2)>>2)]=$210;var $211=$end_clause_index;var $212=$buf_addr;var $arrayidx424=(($212+$211)&4294967295);HEAP8[($arrayidx424)]=32;var $213=$end_clause_index;var $add425=((($213)+1)&4294967295);var $214=$buf_addr;var $arrayidx426=(($214+$add425)&4294967295);HEAP8[($arrayidx426)]=0;var $215=$end_clause_after_tag;$retval=$215;;}
else if(__label__==179){var $243=$terminator;$retval=$243;;}
else if(__label__==227){var $293=$c_next;__ZL6UngetCi($293);var $294=HEAP32[(($ix)>>2)];var $295=$buf_addr;var $arrayidx612=(($295+$294)&4294967295);HEAP8[($arrayidx612)]=32;var $296=HEAP32[(($ix)>>2)];var $add613=((($296)+1)&4294967295);var $297=$buf_addr;var $arrayidx614=(($297+$add613)&4294967295);HEAP8[($arrayidx614)]=0;var $298=$cprev;var $call615=_iswdigit($298);var $tobool616=((($call615))|0)!=0;if($tobool616){__label__=228;;}else{__label__=230;;}
$land_lhs_true617$$if_end622$335:do{if(__label__==228){var $299=$c_next;var $call618=__Z7IsAlphaj($299);var $tobool619=((($call618))|0)!=0;if($tobool619){__label__=230;break $land_lhs_true617$$if_end622$335;}
var $300=$punct_data;var $and621=($300)&-4194305;$punct_data=$and621;;}}while(0);var $301=$nl_count;var $cmp623=((($301))|0)>1;var $302=$punct_data;if($cmp623){__label__=231;;}else{__label__=234;;}
if(__label__==231){var $cmp625=((($302))|0)==532520;var $303=$punct_data;var $cmp627=((($303))|0)==536621;var $or_cond18=($cmp625)|($cmp627);if($or_cond18){__label__=232;;}else{__label__=233;;}
if(__label__==232){var $304=$punct_data;var $add629=((($304)+35)&4294967295);$retval=$add629;;}
else if(__label__==233){$retval=524358;;}}
else if(__label__==234){$retval=$302;;}}
else if(__label__==255){var $338=HEAP32[(($ix)>>2)];var $339=$buf_addr;var $arrayidx693=(($339+$338)&4294967295);HEAP8[($arrayidx693)]=32;var $340=HEAP32[(($ix)>>2)];var $add694=((($340)+1)&4294967295);var $341=$buf_addr;var $arrayidx695=(($341+$add694)&4294967295);HEAP8[($arrayidx695)]=0;var $342=HEAP32[(($c2)>>2)];__ZL6UngetCi($342);$retval=16384;;}
var $354=$retval;STACKTOP=__stackBase__;return $354;return null;}
function __ZL4GetCv(){var __stackBase__=STACKTOP;STACKTOP+=16;_memset(__stackBase__,0,16);var __label__;var __lastLabel__=null;var $retval;var $c;var $c1;var $c2;var $cbuf=__stackBase__;var $ix;var $n_bytes;var $m;var $0=HEAP32[((__ZL10ungot_char)>>2)];$c1=$0;var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){HEAP32[((__ZL10ungot_char)>>2)]=0;var $1=$c1;$retval=$1;;}
else if(__label__==2){var $2=HEAP32[((__ZZL4GetCvE6ungot2)>>2)];var $cmp1=((($2))|0)!=0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $3=HEAP32[((__ZZL4GetCvE6ungot2)>>2)];$c1=$3;HEAP32[((__ZZL4GetCvE6ungot2)>>2)]=0;;}
else if(__label__==4){var $call=__ZL8GetC_getv();$c1=$call;;}
var $4=HEAP32[((_option_multibyte)>>2)];var $cmp4=((($4))|0)==3;var $5=HEAP32[((_option_multibyte)>>2)];var $cmp5=((($5))|0)==4;var $or_cond=($cmp4)|($cmp5);if($or_cond){__label__=6;;}else{__label__=7;;}
if(__label__==6){var $6=HEAP32[((_count_characters)>>2)];var $inc=((($6)+1)&4294967295);HEAP32[((_count_characters)>>2)]=$inc;var $7=$c1;$retval=$7;;}
else if(__label__==7){var $8=HEAP32[((_option_multibyte)>>2)];var $cmp8=((($8))|0)<2;if($cmp8){__label__=8;;}else{__label__=36;;}
$land_lhs_true$$if_end65thread_pre_split$12:do{if(__label__==8){var $9=$c1;var $and=($9)&128;var $tobool=((($and))|0)!=0;if($tobool){__lastLabel__=8;;}else{__lastLabel__=8;__label__=37;break $land_lhs_true$$if_end65thread_pre_split$12;}
$n_bytes=0;var $10=$c1;var $and10=($10)&224;var $cmp11=((($and10))|0)==192;if($cmp11){__label__=10;;}else{__label__=12;;}
$land_lhs_true12$$if_else16$15:do{if(__label__==10){var $11=$c1;var $and13=($11)&30;var $cmp14=((($and13))|0)!=0;if(!($cmp14)){__label__=12;break $land_lhs_true12$$if_else16$15;}
$n_bytes=1;__lastLabel__=11;__label__=17;break $land_lhs_true12$$if_else16$15;}}while(0);$if_end29_thread$$if_else16$18:do{if(__label__==12){var $12=$c1;var $and17=($12)&240;var $cmp18=((($and17))|0)==224;if($cmp18){__label__=13;;}else{__label__=14;;}
if(__label__==13){$n_bytes=2;__lastLabel__=13;__label__=17;break $if_end29_thread$$if_else16$18;}
else if(__label__==14){var $13=$c1;var $and21=($13)&248;var $cmp22=((($and21))|0)==240;if($cmp22){__label__=15;;}else{__label__=18;;}
$land_lhs_true23$$if_end29$23:do{if(__label__==15){var $14=$c1;var $and24=($14)&15;var $cmp25=((($and24))|0)<=4;if(!($cmp25)){__label__=18;break $land_lhs_true23$$if_end29$23;}
$n_bytes=3;__lastLabel__=16;__label__=17;break $if_end29_thread$$if_else16$18;}}while(0);var $_pr=$n_bytes;$ix=$_pr;var $cmp30=((($_pr))|0)>0;if($cmp30){__label__=19;break $if_end29_thread$$if_else16$18;}else{__label__=33;break $if_end29_thread$$if_else16$18;}}}}while(0);$if_end29_thread$$if_then31$$if_end58$27:do{if(__label__==17){var $_ph=__lastLabel__==13?2:(__lastLabel__==16?3:(1));$ix=$_ph;__label__=19;break $if_end29_thread$$if_then31$$if_end58$27;}}while(0);$if_then31$$if_end58$29:do{if(__label__==19){var $15=$c1;var $16=$ix;var $arrayidx=((__ZZ8utf8_in2PiPKciE4mask+$16)&4294967295);var $17=HEAPU8[($arrayidx)];var $conv=((($17))&255);var $and32=($conv)&($15);$c=$and32;var $18=$ix;var $arrayidx33=((__ZZL4GetCvE5mask2+$18)&4294967295);var $19=HEAP8[($arrayidx33)];$m=$19;__lastLabel__=19;;$while_cond$31:while(1){var $20=__lastLabel__==30?$dec:($18);var $cmp34=((($20))|0)>0;if(!($cmp34)){__label__=31;break $while_cond$31;}
var $call35=__ZL8GetC_getv();var $21=$ix;var $arrayidx36=(($cbuf+$21*4)&4294967295);HEAP32[(($arrayidx36)>>2)]=$call35;$c2=$call35;var $cmp37=((($call35))|0)==0;if($cmp37){__label__=22;break $while_cond$31;}
var $23=$c2;var $and43=($23)&192;var $cmp44=((($and43))|0)!=128;if($cmp44){__label__=26;break $while_cond$31;}
$m=-128;var $28=$c;var $shl=((($28)*64)&4294967295);var $29=$c2;var $and53=($29)&63;var $add=((($and53)+($shl))&4294967295);$c=$add;var $30=$ix;var $dec=((($30)-1)&4294967295);$ix=$dec;__lastLabel__=30;__label__=20;continue $while_cond$31;}
if(__label__==22){var $22=HEAP32[((_option_multibyte)>>2)];var $cmp39=((($22))|0)==0;if($cmp39){__label__=23;;}else{__label__=24;;}
if(__label__==23){HEAP32[((_option_multibyte)>>2)]=2;;}
__ZL10GetC_ungeti(32);;}
else if(__label__==26){var $24=$n_bytes;var $cmp46=((($24))|0)==2;if($cmp46){__label__=27;;}else{__label__=29;;}
$land_lhs_true47$$if_end51$42:do{if(__label__==27){var $25=$ix;var $cmp48=((($25))|0)==1;if(!($cmp48)){__label__=29;break $land_lhs_true47$$if_end51$42;}
var $arrayidx50=(($cbuf+8)&4294967295);var $26=HEAP32[(($arrayidx50)>>2)];HEAP32[((__ZZL4GetCvE6ungot2)>>2)]=$26;;}}while(0);var $27=$c2;__ZL10GetC_ungeti($27);;}
var $31=$ix;var $cmp54=((($31))|0)==0;if(!($cmp54)){__label__=33;break $if_then31$$if_end58$29;}
var $32=HEAP32[((_count_characters)>>2)];var $inc56=((($32)+1)&4294967295);HEAP32[((_count_characters)>>2)]=$inc56;var $33=$c;$retval=$33;__label__=40;break $if_then$$if_end$2;}}while(0);var $34=HEAP32[((_option_multibyte)>>2)];var $cmp59=((($34))|0)==0;if(!($cmp59)){__label__=36;break $land_lhs_true$$if_end65thread_pre_split$12;}
var $call61=__Z3Eofv();var $tobool62=((($call61))|0)!=0;if($tobool62){__label__=36;break $land_lhs_true$$if_end65thread_pre_split$12;}
HEAP32[((_option_multibyte)>>2)]=2;__label__=36;break $land_lhs_true$$if_end65thread_pre_split$12;}}while(0);if(__label__==36){var $_pr2=$c1;__lastLabel__=36;;}
var $35=__lastLabel__==36?$_pr2:($9);var $36=HEAP32[((_count_characters)>>2)];var $inc66=((($36)+1)&4294967295);HEAP32[((_count_characters)>>2)]=$inc66;var $cmp67=((($35))|0)>=160;var $37=$c1;if($cmp67){__label__=38;;}else{__label__=39;;}
if(__label__==38){var $sub=((($37)-160)&4294967295);var $38=HEAP32[((_translator)>>2)];var $charset_a0=(($38+696)&4294967295);var $39=HEAP32[(($charset_a0)>>2)];var $arrayidx69=(($39+2*$sub)&4294967295);var $40=HEAPU16[(($arrayidx69)>>1)];var $conv70=((($40))&65535);$retval=$conv70;;}
else if(__label__==39){$retval=$37;;}}}}while(0);var $41=$retval;STACKTOP=__stackBase__;return $41;return null;}
function __ZL6UngetCi($c){;var __label__;var $c_addr;$c_addr=$c;var $0=$c_addr;HEAP32[((__ZL10ungot_char)>>2)]=$0;;return;return;}
function __ZL14ProcessSsmlTagPwPcRiii($xml_buf,$outbuf,$outix,$n_outbuf,$self_closing){var __stackBase__=STACKTOP;STACKTOP+=376;_memset(__stackBase__,0,376);var __label__;var __lastLabel__=null;var $retval;var $xml_buf_addr;var $outbuf_addr;var $outix_addr;var $n_outbuf_addr;var $self_closing_addr;var $ix;var $index;var $c;var $tag_type;var $value;var $value2;var $value3;var $voice_change_flag;var $px;var $attr1;var $attr2;var $attr3;var $terminator;var $uri;var $param_type;var $tag_name=__stackBase__;var $buf=__stackBase__+40;var $sp;var $ssml_sp;var $fname=__stackBase__+120;$xml_buf_addr=$xml_buf;$outbuf_addr=$outbuf;$outix_addr=$outix;$n_outbuf_addr=$n_outbuf;$self_closing_addr=$self_closing;$ix=0;__lastLabel__=0;;$for_cond$2:while(1){var $0=__lastLabel__==4?$inc:(0);var $cmp=((($0))>>>0)<39;if(!($cmp)){__label__=5;break $for_cond$2;}
var $1=$ix;var $2=$xml_buf_addr;var $arrayidx=(($2+4*$1)&4294967295);var $3=HEAP32[(($arrayidx)>>2)];$c=$3;var $cmp1=((($3))|0)==0;if($cmp1){__label__=5;break $for_cond$2;}
var $4=$c;var $call=_iswspace($4);var $tobool=((($call))|0)!=0;if($tobool){__label__=5;break $for_cond$2;}
var $5=$c;var $conv=((($5))&255);var $conv2=(tempInt=(($conv)),(tempInt>=128?tempInt-256:tempInt));var $call3=_tolower($conv2);var $conv4=((($call3))&255);var $6=$ix;var $arrayidx5=(($tag_name+$6)&4294967295);HEAP8[($arrayidx5)]=$conv4;var $7=$ix;var $inc=((($7)+1)&4294967295);$ix=$inc;__lastLabel__=4;__label__=1;continue $for_cond$2;}
var $8=$ix;var $arrayidx6=(($tag_name+$8)&4294967295);HEAP8[($arrayidx6)]=0;var $9=$ix;var $10=$xml_buf_addr;var $arrayidx7=(($10+4*$9)&4294967295);$px=$arrayidx7;var $arrayidx8=(($tag_name)&4294967295);var $11=HEAP8[($arrayidx8)];var $conv9=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $cmp10=((($conv9))|0)==47;if($cmp10){__label__=6;;}else{__label__=9;;}
$if_then11$$if_else$8:do{if(__label__==6){var $arrayidx12=(($tag_name+1)&4294967295);var $call13=__Z10LookupMnemP8MNEM_TABPKc(((__ZL8ssmltags)&4294967295),$arrayidx12);$tag_type=$call13;var $cmp14=((($call13))|0)!=16;if($cmp14){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $12=$outix_addr;var $13=HEAP32[(($12)>>2)];var $inc16=((($13)+1)&4294967295);HEAP32[(($12)>>2)]=$inc16;var $14=$outbuf_addr;var $arrayidx17=(($14+$13)&4294967295);HEAP8[($arrayidx17)]=32;;}
var $15=$tag_type;var $add=((($15)+32)&4294967295);$tag_type=$add;__lastLabel__=8;__label__=14;break $if_then11$$if_else$8;}
else if(__label__==9){var $arraydecay=(($tag_name)&4294967295);var $call19=__Z10LookupMnemP8MNEM_TABPKc(((__ZL8ssmltags)&4294967295),$arraydecay);$tag_type=$call19;var $cmp20=((($call19))|0)!=16;if($cmp20){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $16=$outix_addr;var $17=HEAP32[(($16)>>2)];var $inc22=((($17)+1)&4294967295);HEAP32[(($16)>>2)]=$inc22;var $18=$outbuf_addr;var $arrayidx23=(($18+$17)&4294967295);HEAP8[($arrayidx23)]=32;;}
var $19=$self_closing_addr;var $tobool25=((($19))|0)!=0;var $20=$tag_type;if($tobool25){__lastLabel__=11;;}else{__lastLabel__=11;__label__=14;break $if_then11$$if_else$8;}
var $arrayidx26=((__ZL22ignore_if_self_closing+$20)&4294967295);var $21=HEAP8[($arrayidx26)];var $tobool27=(tempInt=(($21)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool27){__lastLabel__=12;;}else{__lastLabel__=12;__label__=14;break $if_then11$$if_else$8;}
$retval=0;__label__=113;break $if_then11$$if_else$8;}}while(0);$if_end30$$return$19:do{if(__label__==14){var $22=__lastLabel__==12?$20:(__lastLabel__==8?$add:($20));$voice_change_flag=0;$terminator=16384;var $23=HEAPU32[((__ZL12n_ssml_stack)>>2)];var $sub=((($23)-1)&4294967295);var $arrayidx31=((__ZL10ssml_stack+$sub*76)&4294967295);$ssml_sp=$arrayidx31;if($22==10){__lastLabel__=14;__label__=15;;}
else if($22==3){__lastLabel__=14;__label__=20;;}
else if($22==12){__lastLabel__=14;__label__=25;;}
else if($22==42){__lastLabel__=14;__label__=31;;}
else if($22==35){__lastLabel__=14;__label__=31;;}
else if($22==44){__lastLabel__=14;__label__=31;;}
else if($22==4){__lastLabel__=14;__label__=32;;}
else if($22==36){__lastLabel__=14;__label__=39;;}
else if($22==9){__lastLabel__=14;__label__=42;;}
else if($22==14){__lastLabel__=14;__label__=44;;}
else if($22==41){__lastLabel__=14;__label__=45;;}
else if($22==46){__lastLabel__=14;__label__=45;;}
else if($22==5){__lastLabel__=14;__label__=46;;}
else if($22==11){__lastLabel__=14;__label__=51;;}
else if($22==43){__lastLabel__=14;__label__=66;;}
else if($22==13){__lastLabel__=14;__label__=67;;}
else if($22==1){__lastLabel__=14;__label__=79;;}
else if($22==2){__lastLabel__=14;__label__=85;;}
else if($22==33){__lastLabel__=14;__label__=88;;}
else if($22==34){__lastLabel__=14;__label__=92;;}
else if($22==15){__lastLabel__=14;__label__=96;;}
else if($22==47){__lastLabel__=14;__label__=96;;}
else if($22==6){__lastLabel__=14;__label__=97;;}
else if($22==7){__lastLabel__=14;__label__=100;;}
else if($22==38){__lastLabel__=14;__label__=105;;}
else if($22==39){__lastLabel__=14;__label__=108;;}
else{__lastLabel__=14;__label__=112;;}
$sw_epilog$$sw_bb$$sw_bb49$$sw_bb62$$sw_bb83$$sw_bb84$$sw_bb110$$sw_bb120$$sw_bb129$$sw_bb130$$sw_bb131$$sw_bb156$$sw_bb220$$sw_bb221$$sw_bb249$$sw_bb266$$while_cond$$while_cond280$$sw_bb293$$sw_bb294$$sw_bb302$$sw_bb317$$sw_bb324$21:do{if(__label__==15){var $24=$tag_type;var $call32=__ZL14PushParamStacki($24);$sp=$call32;var $25=$px;var $call33=__ZL16GetSsmlAttributePwPKc($25,((__str83250)&4294967295));$attr1=$call33;var $26=$px;var $call34=__ZL16GetSsmlAttributePwPKc($26,((__str84251)&4294967295));$attr2=$call34;var $27=$attr1;var $call35=__ZL7attrcmpPKwPKc($27,((__str85252)&4294967295));var $cmp36=((($call35))|0)==0;if($cmp36){__label__=16;;}else{__label__=17;;}
$if_then37$$if_else40$23:do{if(__label__==16){var $28=$attr2;var $call38=__ZL10attrlookupPKwPK8MNEM_TAB($28,((__ZZL14ProcessSsmlTagPwPcRiiiE10mnem_punct)&4294967295));$value=$call38;var $29=$value;var $30=$sp;var $parameter=(($30+4)&4294967295);var $arrayidx39=(($parameter+20)&4294967295);HEAP32[(($arrayidx39)>>2)]=$29;;}
else if(__label__==17){var $31=$attr1;var $call41=__ZL7attrcmpPKwPKc($31,((__str86253)&4294967295));var $cmp42=((($call41))|0)==0;if(!($cmp42)){__label__=19;break $if_then37$$if_else40$23;}
var $32=$attr2;var $call44=__ZL10attrlookupPKwPK8MNEM_TAB($32,((__ZZL14ProcessSsmlTagPwPcRiiiE13mnem_capitals)&4294967295));$value=$call44;var $33=$value;var $34=$sp;var $parameter45=(($34+4)&4294967295);var $arrayidx46=(($parameter45+24)&4294967295);HEAP32[(($arrayidx46)>>2)]=$33;;}}while(0);var $35=$outbuf_addr;var $36=$outix_addr;__ZL17ProcessParamStackPcRi($35,$36);;}
else if(__label__==20){var $37=$tag_type;var $call50=__ZL14PushParamStacki($37);$sp=$call50;$param_type=1;;while(1){var $38=$px;var $39=$param_type;var $arrayidx54=((__ZZL14ProcessSsmlTagPwPcRiiiE12prosody_attr+$39*4)&4294967295);var $40=HEAP32[(($arrayidx54)>>2)];var $call55=__ZL16GetSsmlAttributePwPKc($38,$40);$attr1=$call55;var $cmp56=((($call55))|0)!=0;if($cmp56){__label__=22;;}else{__label__=23;;}
if(__label__==22){var $41=$param_type;var $42=$attr1;var $43=$sp;__ZL19SetProsodyParameteriPwP11PARAM_STACK($41,$42,$43);;}
var $44=$param_type;var $inc60=((($44)+1)&4294967295);$param_type=$inc60;var $cmp52=((($inc60))|0)<=4;if($cmp52){__label__=21;continue;}else{__label__=24;break;}}
var $45=$outbuf_addr;var $46=$outix_addr;__ZL17ProcessParamStackPcRi($45,$46);;}
else if(__label__==25){var $47=$tag_type;var $call63=__ZL14PushParamStacki($47);$sp=$call63;$value=3;var $48=$px;var $call64=__ZL16GetSsmlAttributePwPKc($48,((__str87254)&4294967295));$attr1=$call64;var $cmp65=((($call64))|0)!=0;if($cmp65){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $49=$attr1;var $call67=__ZL10attrlookupPKwPK8MNEM_TAB($49,((__ZZL14ProcessSsmlTagPwPcRiiiE13mnem_emphasis)&4294967295));$value=$call67;;}
var $50=HEAP32[((_translator)>>2)];var $langopts=(($50)&4294967295);var $tone_language=(($langopts+224)&4294967295);var $51=HEAP32[(($tone_language)>>2)];var $cmp69=((($51))|0)==1;var $52=$value;if($cmp69){__label__=28;;}else{__label__=29;;}
if(__label__==28){var $arrayidx71=((__ZZL14ProcessSsmlTagPwPcRiiiE23emphasis_to_pitch_range+$52)&4294967295);var $53=HEAPU8[($arrayidx71)];var $conv72=((($53))&255);var $54=$sp;var $parameter73=(($54+4)&4294967295);var $arrayidx74=(($parameter73+16)&4294967295);HEAP32[(($arrayidx74)>>2)]=$conv72;var $55=$value;var $arrayidx75=((__ZZL14ProcessSsmlTagPwPcRiiiE18emphasis_to_volume+$55)&4294967295);var $56=HEAPU8[($arrayidx75)];var $conv76=((($56))&255);var $57=$sp;var $parameter77=(($57+4)&4294967295);var $arrayidx78=(($parameter77+8)&4294967295);HEAP32[(($arrayidx78)>>2)]=$conv76;;}
else if(__label__==29){var $58=$sp;var $parameter80=(($58+4)&4294967295);var $arrayidx81=(($parameter80+48)&4294967295);HEAP32[(($arrayidx81)>>2)]=$52;;}
var $59=$outbuf_addr;var $60=$outix_addr;__ZL17ProcessParamStackPcRi($59,$60);;}
else if(__label__==31){var $61=$tag_type;var $62=$outbuf_addr;var $63=$outix_addr;__ZL13PopParamStackiPcRi($61,$62,$63);;}
else if(__label__==32){var $64=$px;var $call85=__ZL16GetSsmlAttributePwPKc($64,((__str88255)&4294967295));$attr1=$call85;var $65=$px;var $call86=__ZL16GetSsmlAttributePwPKc($65,((__str89256)&4294967295));$attr2=$call86;var $66=$px;var $call87=__ZL16GetSsmlAttributePwPKc($66,((__str90257)&4294967295));$attr3=$call87;var $67=$attr1;var $call88=__ZL10attrlookupPKwPK8MNEM_TAB($67,((__ZZL14ProcessSsmlTagPwPcRiiiE17mnem_interpret_as)&4294967295));$value=$call88;var $68=$attr2;var $call89=__ZL10attrlookupPKwPK8MNEM_TAB($68,((__ZZL14ProcessSsmlTagPwPcRiiiE17mnem_sayas_format)&4294967295));$value2=$call89;var $69=$value2;var $cmp90=((($69))|0)==1;if($cmp90){__label__=33;;}else{__label__=34;;}
if(__label__==33){$value=19;;}
var $70=$attr3;var $call93=__ZL10attrnumberPKwii($70,0,0);$value3=$call93;var $71=$value;var $cmp94=((($71))|0)==64;if($cmp94){__label__=35;;}else{__label__=38;;}
if(__label__==35){var $72=$value3;var $cmp96=((($72))|0)<=1;if($cmp96){__label__=36;;}else{__label__=37;;}
if(__label__==36){$value=193;;}
else if(__label__==37){var $73=$value3;var $add99=((($73)+64)&4294967295);$value=$add99;;}}
var $arraydecay102=(($buf)&4294967295);var $74=$value;var $call103=_sprintf($arraydecay102,((__str91258)&4294967295),allocate([1,0,0,0,$74,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $75=$outix_addr;var $76=HEAP32[(($75)>>2)];var $77=$outbuf_addr;var $arrayidx104=(($77+$76)&4294967295);var $arraydecay105=(($buf)&4294967295);var $call106=_strcpy($arrayidx104,$arraydecay105);var $arraydecay107=(($buf)&4294967295);var $call108=_strlen($arraydecay107);var $78=$outix_addr;var $79=HEAP32[(($78)>>2)];var $add109=((($79)+($call108))&4294967295);HEAP32[(($78)>>2)]=$add109;var $80=$outix_addr;var $81=HEAP32[(($80)>>2)];HEAP32[((__ZL11sayas_start)>>2)]=$81;var $82=$value;HEAP32[((__ZL10sayas_mode)>>2)]=$82;;}
else if(__label__==39){var $83=HEAP32[((__ZL10sayas_mode)>>2)];var $cmp111=((($83))|0)==36;if($cmp111){__label__=40;;}else{__label__=41;;}
if(__label__==40){var $84=$outix_addr;var $85=HEAP32[(($84)>>2)];var $86=$outbuf_addr;var $arrayidx113=(($86+$85)&4294967295);HEAP8[($arrayidx113)]=0;var $87=$outbuf_addr;var $88=HEAP32[((__ZL11sayas_start)>>2)];var $89=$outix_addr;__ZL14ReplaceKeyNamePciRi($87,$88,$89);;}
var $90=$outix_addr;var $91=HEAP32[(($90)>>2)];var $inc116=((($91)+1)&4294967295);HEAP32[(($90)>>2)]=$inc116;var $92=$outbuf_addr;var $arrayidx117=(($92+$91)&4294967295);HEAP8[($arrayidx117)]=1;var $93=$outix_addr;var $94=HEAP32[(($93)>>2)];var $inc118=((($94)+1)&4294967295);HEAP32[(($93)>>2)]=$inc118;var $95=$outbuf_addr;var $arrayidx119=(($95+$94)&4294967295);HEAP8[($arrayidx119)]=89;HEAP32[((__ZL10sayas_mode)>>2)]=0;;}
else if(__label__==42){var $96=$px;var $call121=__ZL16GetSsmlAttributePwPKc($96,((__str92259)&4294967295));$attr1=$call121;var $cmp122=((($call121))|0)!=0;if(!($cmp122)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb49$$sw_bb62$$sw_bb83$$sw_bb84$$sw_bb110$$sw_bb120$$sw_bb129$$sw_bb130$$sw_bb131$$sw_bb156$$sw_bb220$$sw_bb221$$sw_bb249$$sw_bb266$$while_cond$$while_cond280$$sw_bb293$$sw_bb294$$sw_bb302$$sw_bb317$$sw_bb324$21;}
HEAP8[(__ZL11ignore_text_b)]=1;var $97=$outix_addr;var $98=HEAP32[(($97)>>2)];var $99=$outbuf_addr;var $arrayidx124=(($99+$98)&4294967295);var $100=$attr1;var $101=$n_outbuf_addr;var $102=$outix_addr;var $103=HEAP32[(($102)>>2)];var $sub125=((($101)-($103))&4294967295);var $call126=__ZL13attrcopy_utf8PcPKwi($arrayidx124,$100,$sub125);var $104=$outix_addr;var $105=HEAP32[(($104)>>2)];var $add127=((($105)+($call126))&4294967295);HEAP32[(($104)>>2)]=$add127;;}
else if(__label__==44){HEAP8[(__ZL11ignore_text_b)]=1;;}
else if(__label__==45){HEAP8[(__ZL11ignore_text_b)]=0;;}
else if(__label__==46){var $106=$px;var $call132=__ZL16GetSsmlAttributePwPKc($106,((__str5655)&4294967295));$attr1=$call132;var $cmp133=((($call132))|0)!=0;if(!($cmp133)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb49$$sw_bb62$$sw_bb83$$sw_bb84$$sw_bb110$$sw_bb120$$sw_bb129$$sw_bb130$$sw_bb131$$sw_bb156$$sw_bb220$$sw_bb221$$sw_bb249$$sw_bb266$$while_cond$$while_cond280$$sw_bb293$$sw_bb294$$sw_bb302$$sw_bb317$$sw_bb324$21;}
var $arraydecay135=(($buf)&4294967295);var $107=$attr1;var $call136=__ZL13attrcopy_utf8PcPKwi($arraydecay135,$107,80);var $arraydecay137=(($buf)&4294967295);var $call138=_strcmp(((_skip_marker)&4294967295),$arraydecay137);var $cmp139=((($call138))|0)==0;if($cmp139){__label__=48;;}else{__label__=49;;}
if(__label__==48){HEAP8[(__ZL19clear_skipping_text_b)]=1;HEAP8[(((_skip_marker)&4294967295))]=0;$retval=16384;__label__=113;break $if_end30$$return$19;}
else if(__label__==49){var $arraydecay142=(($buf)&4294967295);var $call143=__Z11AddNameDataPKci($arraydecay142,0);$index=$call143;var $cmp144=((($call143))|0)>=0;if(!($cmp144)){__label__=112;break $sw_epilog$$sw_bb$$sw_bb49$$sw_bb62$$sw_bb83$$sw_bb84$$sw_bb110$$sw_bb120$$sw_bb129$$sw_bb130$$sw_bb131$$sw_bb156$$sw_bb220$$sw_bb221$$sw_bb249$$sw_bb266$$while_cond$$while_cond280$$sw_bb293$$sw_bb294$$sw_bb302$$sw_bb317$$sw_bb324$21;}
var $arraydecay146=(($buf)&4294967295);var $108=$index;var $call147=_sprintf($arraydecay146,((__str94261)&4294967295),allocate([1,0,0,0,$108,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $109=$outix_addr;var $110=HEAP32[(($109)>>2)];var $111=$outbuf_addr;var $arrayidx148=(($111+$110)&4294967295);var $arraydecay149=(($buf)&4294967295);var $call150=_strcpy($arrayidx148,$arraydecay149);var $arraydecay151=(($buf)&4294967295);var $call152=_strlen($arraydecay151);var $112=$outix_addr;var $113=HEAP32[(($112)>>2)];var $add153=((($113)+($call152))&4294967295);HEAP32[(($112)>>2)]=$add153;;}}
else if(__label__==51){var $114=$tag_type;var $call157=__ZL14PushParamStacki($114);$sp=$call157;var $115=$px;var $call158=__ZL16GetSsmlAttributePwPKc($115,((__str95262)&4294967295));$attr1=$call158;var $cmp159=((($call158))|0)!=0;if($cmp159){__label__=52;;}else{__label__=62;;}
$if_then160$$if_end215$69:do{if(__label__==52){var $arraydecay161=(($buf)&4294967295);var $116=$attr1;var $call162=__ZL13attrcopy_utf8PcPKwi($arraydecay161,$116,80);var $117=HEAP32[((_uri_callback)>>2)];var $cmp163=((($117))|0)==0;if($cmp163){__label__=53;;}else{__label__=59;;}
if(__label__==53){var $118=HEAP32[((__ZL7xmlbase)>>2)];var $cmp165=((($118))|0)!=0;if($cmp165){__label__=54;;}else{__label__=56;;}
$land_lhs_true166$$if_else176$73:do{if(__label__==54){var $arrayidx167=(($buf)&4294967295);var $119=HEAP8[($arrayidx167)];var $conv168=(tempInt=(($119)),(tempInt>=128?tempInt-256:tempInt));var $cmp169=((($conv168))|0)!=47;if(!($cmp169)){__label__=56;break $land_lhs_true166$$if_else176$73;}
var $arraydecay171=(($fname)&4294967295);var $120=HEAP32[((__ZL7xmlbase)>>2)];var $arraydecay172=(($buf)&4294967295);var $call173=_sprintf($arraydecay171,((__str96263)&4294967295),allocate([$120,0,0,0,$arraydecay172,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay174=(($fname)&4294967295);var $call175=__ZL14LoadSoundFile2PKc($arraydecay174);$index=$call175;__lastLabel__=55;__label__=57;break $land_lhs_true166$$if_else176$73;}}while(0);if(__label__==56){var $arraydecay177=(($buf)&4294967295);var $call178=__ZL14LoadSoundFile2PKc($arraydecay177);$index=$call178;__lastLabel__=56;;}
var $121=__lastLabel__==56?$call178:($call175);var $cmp180=((($121))|0)>=0;if(!($cmp180)){__label__=62;break $if_then160$$if_end215$69;}
var $arraydecay182=(($buf)&4294967295);var $122=$index;var $call183=_sprintf($arraydecay182,((__str97264)&4294967295),allocate([1,0,0,0,$122,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $123=$outix_addr;var $124=HEAP32[(($123)>>2)];var $125=$outbuf_addr;var $arrayidx184=(($125+$124)&4294967295);var $arraydecay185=(($buf)&4294967295);var $call186=_strcpy($arrayidx184,$arraydecay185);var $arraydecay187=(($buf)&4294967295);var $call188=_strlen($arraydecay187);var $126=$outix_addr;var $127=HEAP32[(($126)>>2)];var $add189=((($127)+($call188))&4294967295);HEAP32[(($126)>>2)]=$add189;var $128=$sp;var $parameter190=(($128+4)&4294967295);var $arrayidx191=(($parameter190)&4294967295);HEAP32[(($arrayidx191)>>2)]=1;;}
else if(__label__==59){var $arraydecay194=(($buf)&4294967295);var $call195=__Z11AddNameDataPKci($arraydecay194,0);$index=$call195;var $cmp196=((($call195))|0)>=0;if(!($cmp196)){__label__=62;break $if_then160$$if_end215$69;}
var $129=$index;var $130=HEAP32[((_namedata)>>2)];var $arrayidx198=(($130+$129)&4294967295);$uri=$arrayidx198;var $131=HEAP32[((_uri_callback)>>2)];var $132=$uri;var $133=HEAP32[((__ZL7xmlbase)>>2)];var $call199=FUNCTION_TABLE[$131](1,$132,$133);var $cmp200=((($call199))|0)==0;if(!($cmp200)){__label__=62;break $if_then160$$if_end215$69;}
var $arraydecay202=(($buf)&4294967295);var $134=$index;var $call203=_sprintf($arraydecay202,((__str98265)&4294967295),allocate([1,0,0,0,$134,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $135=$outix_addr;var $136=HEAP32[(($135)>>2)];var $137=$outbuf_addr;var $arrayidx204=(($137+$136)&4294967295);var $arraydecay205=(($buf)&4294967295);var $call206=_strcpy($arrayidx204,$arraydecay205);var $arraydecay207=(($buf)&4294967295);var $call208=_strlen($arraydecay207);var $138=$outix_addr;var $139=HEAP32[(($138)>>2)];var $add209=((($139)+($call208))&4294967295);HEAP32[(($138)>>2)]=$add209;var $140=$sp;var $parameter210=(($140+4)&4294967295);var $arrayidx211=(($parameter210)&4294967295);HEAP32[(($arrayidx211)>>2)]=1;;}}}while(0);var $141=$outbuf_addr;var $142=$outix_addr;__ZL17ProcessParamStackPcRi($141,$142);var $143=$self_closing_addr;var $tobool216=((($143))|0)!=0;if($tobool216){__label__=63;;}else{__label__=64;;}
if(__label__==63){var $144=$tag_type;var $145=$outbuf_addr;var $146=$outix_addr;__ZL13PopParamStackiPcRi($144,$145,$146);;}
else if(__label__==64){HEAP8[(__ZL10audio_text_b)]=1;;}
$retval=16384;__label__=113;break $if_end30$$return$19;}
else if(__label__==66){var $147=$tag_type;var $148=$outbuf_addr;var $149=$outix_addr;__ZL13PopParamStackiPcRi($147,$148,$149);HEAP8[(__ZL10audio_text_b)]=0;$retval=16384;__label__=113;break $if_end30$$return$19;}
else if(__label__==67){$value=21;$terminator=16384;var $150=$px;var $call222=__ZL16GetSsmlAttributePwPKc($150,((__str99266)&4294967295));$attr1=$call222;var $cmp223=((($call222))|0)!=0;if($cmp223){__label__=68;;}else{__label__=71;;}
if(__label__==68){var $151=$attr1;var $call225=__ZL10attrlookupPKwPK8MNEM_TAB($151,((__ZZL14ProcessSsmlTagPwPcRiiiE10mnem_break)&4294967295));$value=$call225;var $152=$value;var $cmp226=((($152))|0)<3;if($cmp226){__label__=69;;}else{__label__=70;;}
if(__label__==69){var $153=$outix_addr;var $154=HEAP32[(($153)>>2)];var $155=$outbuf_addr;var $arrayidx228=(($155+$154)&4294967295);var $156=$value;var $call229=_sprintf($arrayidx228,((__str100267)&4294967295),allocate([1,0,0,0,$156,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $157=$outix_addr;var $158=HEAP32[(($157)>>2)];var $add230=((($158)+3)&4294967295);HEAP32[(($157)>>2)]=$add230;$terminator=0;;}
var $159=$value;var $arrayidx232=((__ZZL14ProcessSsmlTagPwPcRiiiE11break_value+$159*4)&4294967295);var $160=HEAP32[(($arrayidx232)>>2)];$value=$160;;}
var $161=$px;var $call234=__ZL16GetSsmlAttributePwPKc($161,((__str101268)&4294967295));$attr2=$call234;var $cmp235=((($call234))|0)!=0;if($cmp235){__label__=72;;}else{__label__=74;;}
$if_then236$$if_end241$96:do{if(__label__==72){var $162=$attr2;var $call237=__ZL10attrnumberPKwii($162,0,1);var $mul=((($call237)*25)&4294967295);var $163=HEAP32[((((_speed)&4294967295))>>2)];var $div=((((($mul))|0)/((($163))|0))|0);$value=$div;var $164=$terminator;var $cmp238=((($164))|0)==0;if($cmp238){__lastLabel__=72;;}else{__lastLabel__=72;__label__=76;break $if_then236$$if_end241$96;}
$terminator=16384;__label__=75;break $if_then236$$if_end241$96;}
else if(__label__==74){var $_pr1=$terminator;var $tobool242=((($_pr1))|0)!=0;if($tobool242){__label__=75;break $if_then236$$if_end241$96;}else{__label__=112;break $sw_epilog$$sw_bb$$sw_bb49$$sw_bb62$$sw_bb83$$sw_bb84$$sw_bb110$$sw_bb120$$sw_bb129$$sw_bb130$$sw_bb131$$sw_bb156$$sw_bb220$$sw_bb221$$sw_bb249$$sw_bb266$$while_cond$$while_cond280$$sw_bb293$$sw_bb294$$sw_bb302$$sw_bb317$$sw_bb324$21;}}}while(0);if(__label__==75){var $_pr3=$value;__lastLabel__=75;;}
var $165=__lastLabel__==75?$_pr3:($div);var $cmp244=((($165))|0)>4095;if($cmp244){__label__=77;;}else{__label__=78;;}
if(__label__==77){$value=4095;;}
var $166=$terminator;var $167=$value;var $add247=((($167)+($166))&4294967295);$retval=$add247;__label__=113;break $if_end30$$return$19;}
else if(__label__==79){var $168=$px;var $call250=__ZL16GetSsmlAttributePwPKc($168,((__str102269)&4294967295));$attr1=$call250;var $cmp251=((($call250))|0)!=0;if($cmp251){__label__=80;;}else{__label__=82;;}
$if_then252$$if_end261$107:do{if(__label__==80){var $arraydecay253=(($buf)&4294967295);var $169=$attr1;var $call254=__ZL13attrcopy_utf8PcPKwi($arraydecay253,$169,80);var $arraydecay255=(($buf)&4294967295);var $call256=__Z11AddNameDataPKci($arraydecay255,0);$index=$call256;var $cmp257=((($call256))|0)>=0;if(!($cmp257)){__label__=82;break $if_then252$$if_end261$107;}
var $170=$index;var $171=HEAP32[((_namedata)>>2)];var $arrayidx259=(($171+$170)&4294967295);HEAP32[((__ZL7xmlbase)>>2)]=$arrayidx259;;}}while(0);var $172=$px;var $173=$tag_type;var $call262=__ZL18GetVoiceAttributesPwi($172,$173);var $cmp263=((($call262))|0)==0;if($cmp263){__label__=83;;}else{__label__=84;;}
if(__label__==83){$retval=0;__label__=113;break $if_end30$$return$19;}
else if(__label__==84){$retval=147456;__label__=113;break $if_end30$$return$19;}}
else if(__label__==85){var $174=$px;var $175=$tag_type;var $call267=__ZL18GetVoiceAttributesPwi($174,$175);var $cmp268=((($call267))|0)==0;if($cmp268){__label__=86;;}else{__label__=87;;}
if(__label__==86){$retval=0;__label__=113;break $if_end30$$return$19;}
else if(__label__==87){$retval=147456;__label__=113;break $if_end30$$return$19;}}
else if(__label__==88){while(1){var $176=__lastLabel__==90?$dec:($23);var $cmp272=((($176))|0)>1;if(!($cmp272)){__label__=91;break;}
var $177=HEAP32[((__ZL12n_ssml_stack)>>2)];var $sub273=((($177)-1)&4294967295);var $arrayidx274=((__ZL10ssml_stack+$sub273*76)&4294967295);var $tag_type275=(($arrayidx274)&4294967295);var $178=HEAP32[(($tag_type275)>>2)];var $cmp276=((($178))|0)!=1;if(!($cmp276)){__label__=91;break;}
var $179=HEAP32[((__ZL12n_ssml_stack)>>2)];var $dec=((($179)-1)&4294967295);HEAP32[((__ZL12n_ssml_stack)>>2)]=$dec;__lastLabel__=90;__label__=88;continue;}
var $180=$px;var $181=$tag_type;var $call277=__ZL18GetVoiceAttributesPwi($180,$181);var $add278=((($call277)+524328)&4294967295);$retval=$add278;__label__=113;break $if_end30$$return$19;}
else if(__label__==92){while(1){var $182=__lastLabel__==94?$dec289:($23);var $cmp281=((($182))|0)>1;if(!($cmp281)){__label__=95;break;}
var $183=HEAP32[((__ZL12n_ssml_stack)>>2)];var $sub283=((($183)-1)&4294967295);var $arrayidx284=((__ZL10ssml_stack+$sub283*76)&4294967295);var $tag_type285=(($arrayidx284)&4294967295);var $184=HEAP32[(($tag_type285)>>2)];var $cmp286=((($184))|0)!=2;if(!($cmp286)){__label__=95;break;}
var $185=HEAP32[((__ZL12n_ssml_stack)>>2)];var $dec289=((($185)-1)&4294967295);HEAP32[((__ZL12n_ssml_stack)>>2)]=$dec289;__lastLabel__=94;__label__=92;continue;}
$terminator=0;var $186=$terminator;var $187=$px;var $188=$tag_type;var $call291=__ZL18GetVoiceAttributesPwi($187,$188);var $add292=((($call291)+($186))&4294967295);$retval=$add292;__label__=113;break $if_end30$$return$19;}
else if(__label__==96){$retval=262174;__label__=113;break $if_end30$$return$19;}
else if(__label__==97){var $189=$ssml_sp;var $tag_type295=(($189)&4294967295);var $190=HEAP32[(($tag_type295)>>2)];var $cmp296=((($190))|0)==6;if($cmp296){__label__=98;;}else{__label__=99;;}
if(__label__==98){var $191=$px;var $call298=__ZL18GetVoiceAttributesPwi($191,38);$voice_change_flag=$call298;;}
var $192=$px;var $193=$tag_type;var $call300=__ZL18GetVoiceAttributesPwi($192,$193);var $194=$voice_change_flag;var $or=($194)|($call300);$voice_change_flag=$or;var $195=$voice_change_flag;var $add301=((($195)+524358)&4294967295);$retval=$add301;__label__=113;break $if_end30$$return$19;}
else if(__label__==100){var $196=$ssml_sp;var $tag_type303=(($196)&4294967295);var $197=HEAP32[(($tag_type303)>>2)];var $cmp304=((($197))|0)==6;if($cmp304){__label__=101;;}else{__label__=102;;}
if(__label__==101){var $198=$px;var $call306=__ZL18GetVoiceAttributesPwi($198,38);$voice_change_flag=$call306;;}
var $199=$ssml_sp;var $tag_type308=(($199)&4294967295);var $200=HEAP32[(($tag_type308)>>2)];var $cmp309=((($200))|0)==7;if($cmp309){__label__=103;;}else{__label__=104;;}
if(__label__==103){var $201=$px;var $call311=__ZL18GetVoiceAttributesPwi($201,39);var $202=$voice_change_flag;var $or312=($202)|($call311);$voice_change_flag=$or312;;}
var $203=$px;var $204=$tag_type;var $call314=__ZL18GetVoiceAttributesPwi($203,$204);var $205=$voice_change_flag;var $or315=($205)|($call314);$voice_change_flag=$or315;var $206=$voice_change_flag;var $add316=((($206)+524358)&4294967295);$retval=$add316;__label__=113;break $if_end30$$return$19;}
else if(__label__==105){var $207=$ssml_sp;var $tag_type318=(($207)&4294967295);var $208=HEAP32[(($tag_type318)>>2)];var $cmp319=((($208))|0)==6;if($cmp319){__label__=106;;}else{__label__=107;;}
if(__label__==106){var $209=$px;var $210=$tag_type;var $call321=__ZL18GetVoiceAttributesPwi($209,$210);$voice_change_flag=$call321;;}
var $211=$voice_change_flag;var $add323=((($211)+524328)&4294967295);$retval=$add323;__label__=113;break $if_end30$$return$19;}
else if(__label__==108){var $212=$ssml_sp;var $tag_type325=(($212)&4294967295);var $213=HEAP32[(($tag_type325)>>2)];var $cmp326=((($213))|0)==6;if($cmp326){__label__=110;;}else{__label__=109;;}
$if_then330$$lor_lhs_false327$145:do{if(__label__==109){var $214=$ssml_sp;var $tag_type328=(($214)&4294967295);var $215=HEAP32[(($tag_type328)>>2)];var $cmp329=((($215))|0)==7;if($cmp329){__label__=110;break $if_then330$$lor_lhs_false327$145;}
$retval=524358;__label__=113;break $if_end30$$return$19;}}while(0);var $216=$px;var $217=$tag_type;var $call331=__ZL18GetVoiceAttributesPwi($216,$217);var $add332=((($call331)+524358)&4294967295);$retval=$add332;__label__=113;break $if_end30$$return$19;}}while(0);$retval=0;;}}while(0);var $218=$retval;STACKTOP=__stackBase__;return $218;return null;}
function __ZL13LookupSpecialP10TranslatorPKcPc($tr,$text_out){var __stackBase__=STACKTOP;STACKTOP+=124;_memset(__stackBase__,0,124);var __label__;var $retval;var $tr_addr;var $string_addr;var $text_out_addr;var $flags=__stackBase__;var $phonemes=__stackBase__+8;var $phonemes2=__stackBase__+64;var $string1=__stackBase__+120;$tr_addr=$tr;$string_addr=((__str6303)&4294967295);$text_out_addr=$text_out;var $0=$string_addr;HEAP32[(($string1)>>2)]=$0;var $arrayidx=(($flags+4)&4294967295);HEAP32[(($arrayidx)>>2)]=0;var $arrayidx1=(($flags)&4294967295);HEAP32[(($arrayidx1)>>2)]=0;var $1=$tr_addr;var $arraydecay=(($phonemes)&4294967295);var $arraydecay2=(($flags)&4294967295);var $call=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($1,$string1,$arraydecay,$arraydecay2,0,0);var $tobool=((($call))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $2=$tr_addr;var $arraydecay3=(($phonemes)&4294967295);var $arraydecay4=(($flags)&4294967295);__Z13SetWordStressP10TranslatorPcPjii($2,$arraydecay3,$arraydecay4,-1,0);var $arraydecay5=(($phonemes)&4294967295);var $arraydecay6=(($phonemes2)&4294967295);__Z14DecodePhonemesPKcPc($arraydecay5,$arraydecay6);var $3=$text_out_addr;var $arraydecay7=(($phonemes2)&4294967295);var $call8=_sprintf($3,((__str60227)&4294967295),allocate([$arraydecay7,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $4=$text_out_addr;$retval=$4;;}
else if(__label__==2){$retval=0;;}
var $5=$retval;STACKTOP=__stackBase__;return $5;return null;}
function __ZL10RemoveCharPc($p){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $p_addr;var $c=__stackBase__;$p_addr=$p;var $0=$p_addr;var $1=$p_addr;var $call=__Z7utf8_inPiPKc($c,$1);var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$0;$stop$=$dest$+$call;$value4$=32;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=32;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=32;};STACKTOP=__stackBase__;return;return;}
function __ZL19AnnouncePunctuationP10TranslatoriPiPcS1_i($tr,$c1,$c2_ptr,$output,$bufix,$end_clause){var __stackBase__=STACKTOP;STACKTOP+=280;_memset(__stackBase__,0,280);var __label__;var $retval;var $tr_addr;var $c1_addr;var $c2_ptr_addr;var $output_addr;var $bufix_addr;var $end_clause_addr;var $punct_count;var $punctname;var $found;var $soundicon;var $attributes;var $short_pause;var $c2;var $len;var $bufix1;var $buf=__stackBase__;var $buf2=__stackBase__+200;$tr_addr=$tr;$c1_addr=$c1;$c2_ptr_addr=$c2_ptr;$output_addr=$output;$bufix_addr=$bufix;$end_clause_addr=$end_clause;$found=0;var $0=$c2_ptr_addr;var $1=HEAP32[(($0)>>2)];$c2=$1;var $arrayidx=(($buf)&4294967295);HEAP8[($arrayidx)]=0;var $2=$c1_addr;var $call=__ZL15LookupSoundiconi($2);$soundicon=$call;var $cmp=((($call))|0)>=0;if($cmp){__label__=1;;}else{__label__=2;;}
$if_end63_thread$$if_else$2:do{if(__label__==1){var $arraydecay=(($buf)&4294967295);var $3=$soundicon;var $call1=_sprintf($arraydecay,((__str50217)&4294967295),allocate([$3,0,0,0],["i32",0,0,0],ALLOC_STACK));var $4=$c2;__ZL6UngetCi($4);$found=1;__label__=26;break $if_end63_thread$$if_else$2;}
else if(__label__==2){var $5=$tr_addr;var $6=$c1_addr;__ZL14LookupCharNameP10Translatorii($5,$6,0);$punctname=((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295);$found=1;var $7=$bufix_addr;var $8=HEAP32[(($7)>>2)];var $cmp5=((($8))|0)==0;if($cmp5){__label__=5;;}else{__label__=3;;}
$if_then9$$lor_lhs_false$5:do{if(__label__==3){var $9=$end_clause_addr;var $cmp6=((($9))|0)==0;if($cmp6){__label__=5;break $if_then9$$lor_lhs_false$5;}
var $10=$tr_addr;var $langopts=(($10)&4294967295);var $param=(($langopts+24)&4294967295);var $arrayidx8=(($param+68)&4294967295);var $11=HEAP32[(($arrayidx8)>>2)];var $and=($11)&2;var $tobool=((($and))|0)!=0;if($tobool){__label__=5;break $if_then9$$lor_lhs_false$5;}
var $34=$c2;__ZL6UngetCi($34);var $35=HEAP32[((_option_ssml)>>2)];var $tobool51=((($35))|0)!=0;if($tobool51){__label__=21;;}else{__label__=23;;}
$if_then52$$if_end58$9:do{if(__label__==21){var $36=$c1_addr;var $cmp53=((($36))|0)==60;var $37=$c1_addr;var $cmp55=((($37))|0)==38;var $or_cond=($cmp53)|($cmp55);if(!($or_cond)){__label__=23;break $if_then52$$if_end58$9;}
var $38=$c1_addr;HEAP32[((__ZL19ssml_ignore_l_angle)>>2)]=$38;;}}while(0);var $39=$c1_addr;HEAP32[((__ZL11ungot_char2)>>2)]=$39;var $arrayidx59=(($buf)&4294967295);HEAP8[($arrayidx59)]=32;var $arrayidx60=(($buf+1)&4294967295);HEAP8[($arrayidx60)]=0;__label__=24;break $if_then9$$lor_lhs_false$5;}}while(0);$if_then9$$if_end63$13:do{if(__label__==5){$punct_count=1;var $12=$c2;var $13=$c1_addr;var $cmp105=((($12))|0)==((($13))|0);var $14=$c1_addr;var $cmp116=((($14))|0)!=60;var $or_cond17=($cmp105)&($cmp116);if($or_cond17){__label__=6;;}else{__label__=7;;}
$while_body$$while_end$15:do{if(__label__==6){while(1){var $15=$punct_count;var $inc=((($15)+1)&4294967295);$punct_count=$inc;var $call12=__ZL4GetCv();$c2=$call12;var $16=$c2;var $17=$c1_addr;var $cmp10=((($16))|0)==((($17))|0);var $18=$c1_addr;var $cmp11=((($18))|0)!=60;var $or_cond1=($cmp10)&($cmp11);if($or_cond1){__label__=6;continue;}else{__label__=7;break $while_body$$while_end$15;}}}}while(0);var $19=$c2;var $20=$c2_ptr_addr;HEAP32[(($20)>>2)]=$19;var $21=$end_clause_addr;var $tobool13=((($21))|0)!=0;if($tobool13){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $22=$c2;__ZL6UngetCi($22);;}
var $23=$punct_count;var $cmp15=((($23))|0)==1;if($cmp15){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $arraydecay17=(($buf)&4294967295);var $24=$punctname;var $call18=_sprintf($arraydecay17,((__str51218)&4294967295),allocate([$24,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==11){var $25=$punct_count;var $cmp20=((($25))|0)<4;var $arrayidx22=(($buf)&4294967295);if($cmp20){__label__=12;;}else{__label__=19;;}
if(__label__==12){HEAP8[($arrayidx22)]=0;var $26=HEAP32[((((_embedded_value+8)&4294967295))>>2)];var $cmp23=((($26))|0)<300;if($cmp23){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $arraydecay25=(($buf)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str52219)&4294967295);$dest$=$arraydecay25;$stop$=$src$+6;if(($dest$%4)==($src$%4)&&6>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}
var $27=$punct_count;var $dec3=((($27)-1)&4294967295);$punct_count=$dec3;var $cmp294=((($27))|0)>0;if($cmp294){__label__=15;;}else{__label__=17;;}
$while_body30_lr_ph$$while_end36$30:do{if(__label__==15){var $arraydecay31=(($buf2)&4294967295);var $arraydecay33=(($buf)&4294967295);var $arraydecay34=(($buf2)&4294967295);;while(1){var $28=$punctname;var $call32=_sprintf($arraydecay31,((__str51218)&4294967295),allocate([$28,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $call35=_strcat($arraydecay33,$arraydecay34);var $29=$punct_count;var $dec=((($29)-1)&4294967295);$punct_count=$dec;var $cmp29=((($29))|0)>0;if($cmp29){__label__=16;continue;}else{__label__=17;break $while_body30_lr_ph$$while_end36$30;}}}}while(0);var $30=HEAP32[((((_embedded_value+8)&4294967295))>>2)];var $cmp37=((($30))|0)<300;if(!($cmp37)){__label__=24;break $if_then9$$if_end63$13;}
var $arraydecay39=(($buf2)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str53220)&4294967295);$dest$=$arraydecay39;$stop$=$src$+7;if(($dest$%4)==($src$%4)&&7>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $arraydecay41=(($buf)&4294967295);var $arraydecay42=(($buf2)&4294967295);var $call43=_strcat($arraydecay41,$arraydecay42);;}
else if(__label__==19){var $31=$punctname;var $32=$punct_count;var $33=$punctname;var $call47=_sprintf($arrayidx22,((__str54221)&4294967295),allocate([$31,0,0,0,$32,0,0,0,$33,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}}}while(0);var $_pr=$found;var $cmp64=((($_pr))|0)==0;if(!($cmp64)){__label__=26;break $if_end63_thread$$if_else$2;}
$retval=-1;__label__=40;break $if_end63_thread$$if_else$2;}}while(0);$if_end66$$return$39:do{if(__label__==26){var $40=$bufix_addr;var $41=HEAP32[(($40)>>2)];$bufix1=$41;var $arraydecay67=(($buf)&4294967295);var $call68=_strlen($arraydecay67);$len=$call68;var $42=$bufix_addr;var $43=HEAP32[(($42)>>2)];var $44=$output_addr;var $arrayidx69=(($44+$43)&4294967295);var $arraydecay70=(($buf)&4294967295);var $call71=_strcpy($arrayidx69,$arraydecay70);var $45=$len;var $46=$bufix_addr;var $47=HEAP32[(($46)>>2)];var $add=((($47)+($45))&4294967295);HEAP32[(($46)>>2)]=$add;var $48=$end_clause_addr;var $cmp72=((($48))|0)==0;if($cmp72){__label__=27;;}else{__label__=28;;}
if(__label__==27){$retval=-1;;}
else if(__label__==28){var $49=$c1_addr;var $cmp75=((($49))|0)==45;if($cmp75){__label__=29;;}else{__label__=30;;}
if(__label__==29){$retval=16384;;}
else if(__label__==30){var $50=$c1_addr;var $call78=__Z11lookupwcharPKti(((__ZL11punct_chars)&4294967295),$50);var $arrayidx79=((__ZL16punct_attributes+$call78*4)&4294967295);var $51=HEAP32[(($arrayidx79)>>2)];$attributes=$51;$short_pause=262148;var $52=$attributes;var $and80=($52)&28672;var $cmp81=((($and80))|0)==4096;if($cmp81){__label__=31;;}else{__label__=32;;}
if(__label__==31){$short_pause=266244;;}
var $53=$bufix1;var $cmp84=((($53))|0)>0;if($cmp84){__label__=33;;}else{__label__=37;;}
$land_lhs_true$$if_end95$50:do{if(__label__==33){var $54=$tr_addr;var $langopts85=(($54)&4294967295);var $param86=(($langopts85+24)&4294967295);var $arrayidx87=(($param86+68)&4294967295);var $55=HEAP32[(($arrayidx87)>>2)];var $and88=($55)&2;var $tobool89=((($and88))|0)!=0;if($tobool89){__label__=37;break $land_lhs_true$$if_end95$50;}
var $56=$attributes;var $and91=($56)&-32769;var $cmp92=((($and91))|0)==266270;if($cmp92){__label__=35;;}else{__label__=36;;}
if(__label__==35){$retval=262148;__label__=40;break $if_end66$$return$39;}
else if(__label__==36){var $57=$short_pause;$retval=$57;__label__=40;break $if_end66$$return$39;}}}while(0);var $58=$attributes;var $and96=($58)&524288;var $tobool97=((($and96))|0)!=0;if($tobool97){__label__=38;;}else{__label__=39;;}
if(__label__==38){var $59=$attributes;$retval=$59;;}
else if(__label__==39){var $60=$short_pause;$retval=$60;;}}}}}while(0);var $61=$retval;STACKTOP=__stackBase__;return $61;return null;}
function __ZL14LookupCharNameP10Translatorii($tr,$c,$only){var __stackBase__=STACKTOP;STACKTOP+=156;_memset(__stackBase__,0,156);var __label__;var $tr_addr;var $c_addr;var $only_addr;var $ix;var $flags=__stackBase__;var $single_letter=__stackBase__+8;var $phonemes=__stackBase__+32;var $phonemes2=__stackBase__+92;var $lang_name;var $string=__stackBase__+152;$tr_addr=$tr;$c_addr=$c;$only_addr=$only;$lang_name=0;HEAP8[(((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295))]=0;var $arrayidx=(($flags)&4294967295);HEAP32[(($arrayidx)>>2)]=0;var $arrayidx1=(($flags+4)&4294967295);HEAP32[(($arrayidx1)>>2)]=0;var $arrayidx2=(($single_letter)&4294967295);HEAP8[($arrayidx2)]=0;var $arrayidx3=(($single_letter+1)&4294967295);HEAP8[($arrayidx3)]=95;var $0=$c_addr;var $arrayidx4=(($single_letter+2)&4294967295);var $call=__Z8utf8_outjPc($0,$arrayidx4);$ix=$call;var $1=$ix;var $add=((($1)+2)&4294967295);var $arrayidx5=(($single_letter+$add)&4294967295);HEAP8[($arrayidx5)]=0;var $2=$only_addr;var $tobool=((($2))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
$if_then$$if_else$2:do{if(__label__==1){var $arrayidx6=(($single_letter+2)&4294967295);HEAP32[(($string)>>2)]=$arrayidx6;var $3=$tr_addr;var $arraydecay=(($phonemes)&4294967295);var $arraydecay7=(($flags)&4294967295);var $call8=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($3,$string,$arraydecay,$arraydecay7,0,0);;}
else if(__label__==2){var $arrayidx9=(($single_letter+1)&4294967295);HEAP32[(($string)>>2)]=$arrayidx9;var $4=$tr_addr;var $arraydecay10=(($phonemes)&4294967295);var $arraydecay11=(($flags)&4294967295);var $call12=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($4,$string,$arraydecay10,$arraydecay11,0,0);var $cmp=((($call12))|0)==0;if(!($cmp)){__label__=5;break $if_then$$if_else$2;}
var $arrayidx14=(($single_letter+2)&4294967295);HEAP32[(($string)>>2)]=$arrayidx14;var $5=$tr_addr;var $arraydecay15=(($phonemes)&4294967295);var $arraydecay16=(($flags)&4294967295);var $call17=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($5,$string,$arraydecay15,$arraydecay16,0,0);var $cmp18=((($call17))|0)==0;if(!($cmp18)){__label__=5;break $if_then$$if_else$2;}
var $arrayidx20=(($single_letter+1)&4294967295);HEAP8[($arrayidx20)]=32;var $6=$tr_addr;var $arrayidx21=(($single_letter+2)&4294967295);var $arraydecay22=(($phonemes)&4294967295);var $call23=__Z14TranslateRulesP10TranslatorPcS1_iS1_iPj($6,$arrayidx21,$arraydecay22,60,0,0,0);;}}while(0);var $7=$only_addr;var $cmp26=((($7))|0)==0;if($cmp26){__label__=6;;}else{__label__=13;;}
$land_lhs_true$$if_end50$8:do{if(__label__==6){var $arrayidx27=(($phonemes)&4294967295);var $8=HEAP8[($arrayidx27)];var $conv=(tempInt=(($8)),(tempInt>=128?tempInt-256:tempInt));var $cmp28=((($conv))|0)==0;if(!($cmp28)){__label__=13;break $land_lhs_true$$if_end50$8;}
var $9=$tr_addr;var $translator_name=(($9+280)&4294967295);var $10=HEAP32[(($translator_name)>>2)];var $cmp30=((($10))|0)!=25966;if(!($cmp30)){__label__=13;break $land_lhs_true$$if_end50$8;}
var $call32=__Z14SetTranslator2PKc(((__str52704)&4294967295));var $arrayidx33=(($single_letter+1)&4294967295);HEAP32[(($string)>>2)]=$arrayidx33;var $arrayidx34=(($single_letter+1)&4294967295);HEAP8[($arrayidx34)]=95;var $11=HEAP32[((_translator2)>>2)];var $arraydecay35=(($phonemes)&4294967295);var $arraydecay36=(($flags)&4294967295);var $call37=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($11,$string,$arraydecay35,$arraydecay36,0,0);var $cmp38=((($call37))|0)==0;if($cmp38){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $arrayidx40=(($single_letter+2)&4294967295);HEAP32[(($string)>>2)]=$arrayidx40;var $12=HEAP32[((_translator2)>>2)];var $arraydecay41=(($phonemes)&4294967295);var $arraydecay42=(($flags)&4294967295);var $call43=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($12,$string,$arraydecay41,$arraydecay42,0,0);;}
var $arrayidx45=(($phonemes)&4294967295);var $13=HEAP8[($arrayidx45)];var $tobool46=(tempInt=(($13)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool46){__label__=11;;}else{__label__=12;;}
if(__label__==11){$lang_name=((__str52704)&4294967295);;}
else if(__label__==12){var $14=HEAP32[((_voice)>>2)];var $phoneme_tab_ix=(($14+40)&4294967295);var $15=HEAP32[(($phoneme_tab_ix)>>2)];__Z18SelectPhonemeTablei($15);;}}}while(0);var $arrayidx51=(($phonemes)&4294967295);var $16=HEAP8[($arrayidx51)];var $tobool52=(tempInt=(($16)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool52){__label__=14;;}else{__label__=17;;}
$if_then53$$if_else73$19:do{if(__label__==14){var $17=$lang_name;var $tobool54=((($17))|0)!=0;if($tobool54){__label__=15;;}else{__label__=16;;}
if(__label__==15){var $18=HEAP32[((_translator2)>>2)];var $arraydecay56=(($phonemes)&4294967295);var $arraydecay57=(($flags)&4294967295);__Z13SetWordStressP10TranslatorPcPjii($18,$arraydecay56,$arraydecay57,-1,0);var $arraydecay58=(($phonemes)&4294967295);var $arraydecay59=(($phonemes2)&4294967295);__Z14DecodePhonemesPKcPc($arraydecay58,$arraydecay59);var $arraydecay60=(($phonemes2)&4294967295);var $19=$tr_addr;var $translator_name61=(($19+280)&4294967295);var $20=HEAP32[(($translator_name61)>>2)];__ZL13WordToString2j($20);var $call63=_sprintf(((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295),((__str47214)&4294967295),allocate([((__str52704)&4294967295),0,0,0,$arraydecay60,0,0,0,((__ZZL13WordToString2jE3buf)&4294967295),0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $21=HEAP32[((_voice)>>2)];var $phoneme_tab_ix64=(($21+40)&4294967295);var $22=HEAP32[(($phoneme_tab_ix64)>>2)];__Z18SelectPhonemeTablei($22);;}
else if(__label__==16){var $23=$tr_addr;var $arraydecay66=(($phonemes)&4294967295);var $arraydecay67=(($flags)&4294967295);__Z13SetWordStressP10TranslatorPcPjii($23,$arraydecay66,$arraydecay67,-1,0);var $arraydecay68=(($phonemes)&4294967295);var $arraydecay69=(($phonemes2)&4294967295);__Z14DecodePhonemesPKcPc($arraydecay68,$arraydecay69);var $arraydecay70=(($phonemes2)&4294967295);var $call71=_sprintf(((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295),((__str48215)&4294967295),allocate([$arraydecay70,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}}
else if(__label__==17){var $24=$only_addr;var $cmp74=((($24))|0)==0;if(!($cmp74)){__label__=19;break $if_then53$$if_else73$19;}
var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str49216)&4294967295);$dest$=((__ZZL14LookupCharNameP10TranslatoriiE3buf)&4294967295);$stop$=$src$+17;if(($dest$%4)==($src$%4)&&17>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}}while(0);STACKTOP=__stackBase__;return;return;}
function __ZL8IsRomanUj($c){;var __label__;var $retval;var $c_addr;$c_addr=$c;var $0=$c_addr;var $cmp=((($0))|0)==73;var $1=$c_addr;var $cmp1=((($1))|0)==86;var $or_cond=($cmp)|($cmp1);var $2=$c_addr;var $cmp3=((($2))|0)==88;var $or_cond1=($or_cond)|($cmp3);var $3=$c_addr;var $cmp5=((($3))|0)==76;var $or_cond2=($or_cond1)|($cmp5);if($or_cond2){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=1;;}
else if(__label__==2){$retval=0;;}
var $4=$retval;;return $4;return null;}
function __Z12InitNamedatav(){;var __label__;HEAP32[((__ZL11namedata_ix)>>2)]=0;var $0=HEAP32[((_namedata)>>2)];var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=HEAP32[((_namedata)>>2)];;HEAP32[((_namedata)>>2)]=0;HEAP32[((__ZL10n_namedata)>>2)]=0;;};return;return;}
function __Z9InitText2v(){;var __label__;var $param;HEAP32[((__ZL10ungot_char)>>2)]=0;HEAP32[((__ZL11ungot_char2)>>2)]=0;HEAP32[((__ZL12n_ssml_stack)>>2)]=1;HEAP32[((__ZL13n_param_stack)>>2)]=1;HEAP32[((((__ZL10ssml_stack)&4294967295))>>2)]=0;$param=0;;while(1){var $0=$param;var $arrayidx=((((_param_stack+4)&4294967295)+$0*4)&4294967295);var $1=HEAP32[(($arrayidx)>>2)];var $2=$param;var $arrayidx1=((__ZL17speech_parameters+$2*4)&4294967295);HEAP32[(($arrayidx1)>>2)]=$1;var $3=$param;var $inc=((($3)+1)&4294967295);$param=$inc;var $cmp=((($inc))|0)<15;if($cmp){__label__=1;continue;}else{__label__=2;break;}}
var $4=HEAP32[((((__ZL17speech_parameters+20)&4294967295))>>2)];HEAP32[((_option_punctuation)>>2)]=$4;var $5=HEAP32[((((__ZL17speech_parameters+24)&4294967295))>>2)];HEAP32[((_option_capitals)>>2)]=$5;HEAP8[(((__ZL16current_voice_id)&4294967295))]=0;HEAP8[(__ZL11ignore_text_b)]=0;HEAP8[(__ZL10audio_text_b)]=0;HEAP8[(__ZL19clear_skipping_text_b)]=0;HEAP32[((_count_characters)>>2)]=-1;HEAP32[((__ZL10sayas_mode)>>2)]=0;HEAP32[((__ZL7xmlbase)>>2)]=0;;return;return;}
function __ZL13WordToString2j($word){;var __label__;var $word_addr;var $ix;var $p;$word_addr=$word;$p=((__ZZL13WordToString2jE3buf)&4294967295);$ix=3;;while(1){var $0=$word_addr;var $1=$ix;var $mul=((($1)*8)&4294967295);var $shr=($0)>>>((($mul))>>>0);var $conv=((($shr))&255);var $2=$p;HEAP8[($2)]=$conv;var $conv1=(tempInt=(($conv)),(tempInt>=128?tempInt-256:tempInt));var $cmp2=((($conv1))|0)!=0;if($cmp2){__label__=2;;}else{__label__=3;;}
if(__label__==2){var $3=$p;var $incdec_ptr=(($3+1)&4294967295);$p=$incdec_ptr;;}
var $4=$ix;var $dec=((($4)-1)&4294967295);$ix=$dec;var $cmp=((($dec))|0)>=0;if($cmp){__label__=1;continue;}else{__label__=4;break;}}
var $5=$p;HEAP8[($5)]=0;;return;return;}
function __ZL15LookupSoundiconi($c){;var __label__;var $retval;var $c_addr;var $ix;$c_addr=$c;$ix=4;;$for_cond$2:while(1){var $0=$ix;var $1=HEAP32[((_n_soundicon_tab)>>2)];var $cmp=((($0))|0)<((($1))|0);if(!($cmp)){__label__=8;break $for_cond$2;}
var $2=$ix;var $arrayidx=((_soundicon_tab+$2*16)&4294967295);var $name=(($arrayidx)&4294967295);var $3=HEAP32[(($name)>>2)];var $4=$c_addr;var $cmp1=((($3))|0)==((($4))|0);var $5=$ix;if($cmp1){__label__=3;break $for_cond$2;}
var $inc=((($5)+1)&4294967295);$ix=$inc;__label__=1;continue $for_cond$2;}
$for_end$$if_then$6:do{if(__label__==8){$retval=-1;;}
else if(__label__==3){var $arrayidx2=((_soundicon_tab+$5*16)&4294967295);var $length=(($arrayidx2+4)&4294967295);var $6=HEAP32[(($length)>>2)];var $cmp3=((($6))|0)==0;if($cmp3){__label__=4;;}else{__label__=6;;}
$if_then4$$if_end7$9:do{if(__label__==4){var $7=$ix;var $call=__ZL13LoadSoundFilePKci(0,$7);var $cmp5=((($call))|0)!=0;if(!($cmp5)){__label__=6;break $if_then4$$if_end7$9;}
$retval=-1;__label__=9;break $for_end$$if_then$6;}}while(0);var $8=$ix;$retval=$8;;}}while(0);var $9=$retval;;return $9;return null;}
function __ZL13LoadSoundFilePKci($fname,$index){var __stackBase__=STACKTOP;STACKTOP+=764;_memset(__stackBase__,0,764);var __label__;var $retval;var $fname_addr;var $index_addr;var $f;var $p;var $ip;var $length;var $fname_temp=__stackBase__;var $fname2=__stackBase__+100;var $ix;var $fd_temp;var $resample;var $header=__stackBase__+304;var $command=__stackBase__+316;$fname_addr=$fname;$index_addr=$index;var $0=$fname_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=3;;}
$if_end$$if_end3$2:do{if(__label__==1){var $1=$index_addr;var $arrayidx=((_soundicon_tab+$1*16)&4294967295);var $filename=(($arrayidx+12)&4294967295);var $2=HEAP32[(($filename)>>2)];$fname_addr=$2;var $cmp1=((($2))|0)==0;if(!($cmp1)){__label__=3;break $if_end$$if_end3$2;}
$retval=1;__label__=23;break $if_end$$if_end3$2;}}while(0);$return$$if_end3$5:do{if(__label__==3){var $3=$fname_addr;var $arrayidx4=(($3)&4294967295);var $4=HEAP8[($arrayidx4)];var $conv=(tempInt=(($4)),(tempInt>=128?tempInt-256:tempInt));var $cmp5=((($conv))|0)!=47;if($cmp5){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $arraydecay=(($fname2)&4294967295);var $5=$fname_addr;var $call=_sprintf($arraydecay,((__str55222)&4294967295),allocate([((_path_home)&4294967295),0,0,0,47,0,0,0,47,0,0,0,$5,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay7=(($fname2)&4294967295);$fname_addr=$arraydecay7;;}
$f=0;var $6=$fname_addr;var $call9=_fopen($6,((__str18429)&4294967295));$f=$call9;var $cmp10=((($call9))|0)!=0;if($cmp10){__label__=6;;}else{__label__=18;;}
$if_then11$$if_then49$10:do{if(__label__==6){var $7=$f;var $call12=_fseek($7,20,0);$ix=0;;$for_body$12:while(1){var $8=$f;var $call14=__Z10Read4BytesP7__sFILE($8);var $9=$ix;var $arrayidx15=(($header+$9*4)&4294967295);HEAP32[(($arrayidx15)>>2)]=$call14;var $10=$ix;var $inc=((($10)+1)&4294967295);$ix=$inc;var $cmp13=((($inc))|0)<3;if($cmp13){__label__=7;continue $for_body$12;}else{__label__=8;break $for_body$12;}}
var $arrayidx16=(($header)&4294967295);var $11=HEAP32[(($arrayidx16)>>2)];var $cmp17=((($11))|0)!=65537;if($cmp17){__label__=11;;}else{__label__=9;;}
$if_then23$$lor_lhs_false$15:do{if(__label__==9){var $arrayidx18=(($header+4)&4294967295);var $12=HEAP32[(($arrayidx18)>>2)];var $13=HEAP32[((_samplerate)>>2)];var $cmp19=((($12))|0)!=((($13))|0);if($cmp19){__label__=11;break $if_then23$$lor_lhs_false$15;}
var $arrayidx21=(($header+8)&4294967295);var $14=HEAP32[(($arrayidx21)>>2)];var $15=HEAP32[((_samplerate)>>2)];var $mul=((($15)*2)&4294967295);var $cmp22=((($14))|0)!=((($mul))|0);if($cmp22){__label__=11;break $if_then23$$lor_lhs_false$15;}else{__label__=17;break $if_then23$$lor_lhs_false$15;}}}while(0);$if_then23$$if_end47$18:do{if(__label__==11){var $16=$f;var $call24=_fclose($16);$f=0;var $arrayidx25=(($header+8)&4294967295);var $17=HEAP32[(($arrayidx25)>>2)];var $18=HEAP32[((_samplerate)>>2)];var $cmp26=((($17))|0)==((($18))|0);if($cmp26){__label__=12;;}else{__label__=13;;}
if(__label__==12){$resample=((__str13643)&4294967295);;}
else if(__label__==13){$resample=((__str57224)&4294967295);;}
var $arraydecay29=(($fname_temp)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str58225)&4294967295);$dest$=$arraydecay29;$stop$=$src$+18;if(($dest$%4)==($src$%4)&&18>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $arraydecay31=(($fname_temp)&4294967295);var $call32=_mkstemp($arraydecay31);$fd_temp=$call32;var $cmp33=((($call32))|0)>=0;if(!($cmp33)){__label__=17;break $if_then23$$if_end47$18;}
var $19=$fd_temp;var $call35=_close($19);var $arraydecay36=(($command)&4294967295);var $20=$fname_addr;var $21=HEAP32[((_samplerate)>>2)];var $arraydecay37=(($fname_temp)&4294967295);var $22=$resample;var $call38=_sprintf($arraydecay36,((__str59226)&4294967295),allocate([$20,0,0,0,$21,0,0,0,$arraydecay37,0,0,0,$22,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay39=(($command)&4294967295);var $call40=_system($arraydecay39);var $cmp41=((($call40))|0)==0;if(!($cmp41)){__label__=17;break $if_then23$$if_end47$18;}
var $arraydecay43=(($fname_temp)&4294967295);$fname_addr=$arraydecay43;;}}while(0);var $_pr=$f;var $cmp48=((($_pr))|0)==0;if($cmp48){__label__=18;break $if_then11$$if_then49$10;}else{__label__=20;break $if_then11$$if_then49$10;}}}while(0);$if_then49$$if_end54$27:do{if(__label__==18){var $23=$fname_addr;var $call50=_fopen($23,((__str18429)&4294967295));$f=$call50;var $cmp51=((($call50))|0)==0;if(!($cmp51)){__label__=20;break $if_then49$$if_end54$27;}
$retval=3;__label__=23;break $return$$if_end3$5;}}while(0);var $24=$fname_addr;var $call55=__Z13GetFileLengthPKc($24);$length=$call55;var $25=$f;var $call56=_fseek($25,0,0);var $26=$index_addr;var $arrayidx57=((_soundicon_tab+$26*16)&4294967295);var $data=(($arrayidx57+8)&4294967295);var $27=HEAP32[(($data)>>2)];var $28=$length;var $call58=_realloc($27,$28);$p=$call58;var $cmp59=((($call58))|0)==0;if($cmp59){__label__=21;;}else{__label__=22;;}
if(__label__==21){var $29=$f;var $call61=_fclose($29);$retval=4;;}
else if(__label__==22){var $30=$p;var $31=$length;var $32=$f;var $call63=_fread($30,1,$31,$32);$length=$call63;var $33=$f;var $call64=_fclose($33);var $arraydecay65=(($fname_temp)&4294967295);var $call66=_remove($arraydecay65);var $34=$p;var $arrayidx67=(($34+40)&4294967295);var $35=$arrayidx67;$ip=$35;var $36=$ip;var $37=HEAP32[(($36)>>2)];var $div=((((($37))|0)/2)|0);var $38=$index_addr;var $arrayidx68=((_soundicon_tab+$38*16)&4294967295);var $length69=(($arrayidx68+4)&4294967295);HEAP32[(($length69)>>2)]=$div;var $39=$p;var $40=$index_addr;var $arrayidx70=((_soundicon_tab+$40*16)&4294967295);var $data71=(($arrayidx70+8)&4294967295);HEAP32[(($data71)>>2)]=$39;$retval=0;;}}}while(0);var $41=$retval;STACKTOP=__stackBase__;return $41;return null;}
function __ZL14PushParamStacki($tag_type){;var __label__;var $tag_type_addr;var $ix;var $sp;$tag_type_addr=$tag_type;var $0=HEAP32[((__ZL13n_param_stack)>>2)];var $arrayidx=((_param_stack+$0*64)&4294967295);$sp=$arrayidx;var $cmp=((($0))|0)<19;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=HEAP32[((__ZL13n_param_stack)>>2)];var $inc=((($1)+1)&4294967295);HEAP32[((__ZL13n_param_stack)>>2)]=$inc;;}
var $2=$tag_type_addr;var $3=$sp;var $type=(($3)&4294967295);HEAP32[(($type)>>2)]=$2;$ix=0;;while(1){var $4=$ix;var $5=$sp;var $parameter=(($5+4)&4294967295);var $arrayidx2=(($parameter+$4*4)&4294967295);HEAP32[(($arrayidx2)>>2)]=-1;var $6=$ix;var $inc3=((($6)+1)&4294967295);$ix=$inc3;var $cmp1=((($inc3))|0)<15;if($cmp1){__label__=3;continue;}else{__label__=4;break;}}
var $7=$sp;;return $7;return null;}
function __ZL16GetSsmlAttributePwPKc($pw,$name){;var __label__;var __lastLabel__=null;var $retval;var $pw_addr;var $name_addr;var $ix;$pw_addr=$pw;$name_addr=$name;;$while_cond$2:while(1){var $0=$pw_addr;var $1=HEAP32[(($0)>>2)];var $cmp=((($1))|0)!=0;if(!($cmp)){__label__=17;break $while_cond$2;}
var $2=$pw_addr;var $arrayidx=(($2+-4)&4294967295);var $3=HEAP32[(($arrayidx)>>2)];var $call=_iswspace($3);var $tobool=((($call))|0)!=0;if($tobool){__label__=3;;}else{__label__=16;;}
if(__label__==3){$ix=0;var $4=$pw_addr;var $5=HEAP32[(($4)>>2)];var $6=$ix;var $7=$name_addr;var $arrayidx27=(($7+$6)&4294967295);var $8=HEAP8[($arrayidx27)];var $conv8=(tempInt=(($8)),(tempInt>=128?tempInt-256:tempInt));var $cmp39=((($5))|0)==((($conv8))|0);if($cmp39){__label__=4;;}else{__label__=5;;}
$while_body4$$while_end$7:do{if(__label__==4){while(1){var $9=$pw_addr;var $incdec_ptr=(($9+4)&4294967295);$pw_addr=$incdec_ptr;var $10=$ix;var $inc=((($10)+1)&4294967295);$ix=$inc;var $11=$pw_addr;var $12=HEAP32[(($11)>>2)];var $13=$ix;var $14=$name_addr;var $arrayidx2=(($14+$13)&4294967295);var $15=HEAP8[($arrayidx2)];var $conv=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));var $cmp3=((($12))|0)==((($conv))|0);if($cmp3){__label__=4;continue;}else{__label__=5;break $while_body4$$while_end$7;}}}}while(0);var $16=$ix;var $17=$name_addr;var $arrayidx5=(($17+$16)&4294967295);var $18=HEAP8[($arrayidx5)];var $conv6=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));var $cmp7=((($conv6))|0)==0;if($cmp7){__label__=6;break $while_cond$2;}}
var $39=$pw_addr;var $incdec_ptr29=(($39+4)&4294967295);$pw_addr=$incdec_ptr29;__label__=1;continue $while_cond$2;}
$while_end30$$while_cond9_preheader$12:do{if(__label__==17){$retval=0;;}
else if(__label__==6){var $19=$pw_addr;var $20=HEAP32[(($19)>>2)];var $call104=_iswspace($20);var $tobool115=((($call104))|0)!=0;var $21=$pw_addr;if($tobool115){__lastLabel__=6;__label__=7;;}else{__lastLabel__=6;__label__=8;;}
$while_body12$$while_end14$15:do{if(__label__==7){while(1){var $22=__lastLabel__==7?$25:($21);var $incdec_ptr13=(($22+4)&4294967295);$pw_addr=$incdec_ptr13;var $23=$pw_addr;var $24=HEAP32[(($23)>>2)];var $call10=_iswspace($24);var $tobool11=((($call10))|0)!=0;var $25=$pw_addr;if($tobool11){__lastLabel__=7;__label__=7;continue;}else{__lastLabel__=7;__label__=8;break $while_body12$$while_end14$15;}}}}while(0);var $_lcssa3=__lastLabel__==6?$21:($25);var $26=HEAP32[(($_lcssa3)>>2)];var $cmp15=((($26))|0)==61;if($cmp15){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $27=$pw_addr;var $incdec_ptr17=(($27+4)&4294967295);$pw_addr=$incdec_ptr17;;}
var $28=$pw_addr;var $29=HEAP32[(($28)>>2)];var $call191=_iswspace($29);var $tobool202=((($call191))|0)!=0;var $30=$pw_addr;if($tobool202){__lastLabel__=10;__label__=11;;}else{__lastLabel__=10;__label__=12;;}
$while_body21$$while_end23$22:do{if(__label__==11){while(1){var $31=__lastLabel__==11?$34:($30);var $incdec_ptr22=(($31+4)&4294967295);$pw_addr=$incdec_ptr22;var $32=$pw_addr;var $33=HEAP32[(($32)>>2)];var $call19=_iswspace($33);var $tobool20=((($call19))|0)!=0;var $34=$pw_addr;if($tobool20){__lastLabel__=11;__label__=11;continue;}else{__lastLabel__=11;__label__=12;break $while_body21$$while_end23$22;}}}}while(0);var $_lcssa=__lastLabel__==10?$30:($34);var $35=HEAP32[(($_lcssa)>>2)];var $cmp24=((($35))|0)==34;if($cmp24){__label__=14;;}else{__label__=13;;}
$if_then26$$lor_lhs_false$26:do{if(__label__==13){var $36=$pw_addr;var $37=HEAP32[(($36)>>2)];var $cmp25=((($37))|0)==39;if($cmp25){__label__=14;break $if_then26$$lor_lhs_false$26;}
$retval=((__ZZL16GetSsmlAttributePwPKcE5empty)&4294967295);__label__=18;break $while_end30$$while_cond9_preheader$12;}}while(0);var $38=$pw_addr;var $add_ptr=(($38+4)&4294967295);$retval=$add_ptr;;}}while(0);var $40=$retval;;return $40;return null;}
function __ZL7attrcmpPKwPKc($string1,$string2){;var __label__;var $retval;var $string1_addr;var $string2_addr;var $ix;$string1_addr=$string1;$string2_addr=$string2;var $0=$string1_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_end$2:do{if(__label__==1){$retval=1;;}
else if(__label__==2){$ix=0;;$for_cond$5:while(1){var $1=$ix;var $2=$string1_addr;var $arrayidx=(($2+4*$1)&4294967295);var $3=HEAP32[(($arrayidx)>>2)];var $4=$ix;var $5=$string2_addr;var $arrayidx1=(($5+$4)&4294967295);var $6=HEAP8[($arrayidx1)];var $conv=(tempInt=(($6)),(tempInt>=128?tempInt-256:tempInt));var $cmp2=((($3))|0)==((($conv))|0);if(!($cmp2)){__label__=6;break $for_cond$5;}
var $7=$ix;var $8=$string1_addr;var $arrayidx3=(($8+4*$7)&4294967295);var $9=HEAP32[(($arrayidx3)>>2)];var $cmp4=((($9))|0)!=0;if(!($cmp4)){__label__=6;break $for_cond$5;}
var $10=$ix;var $inc=((($10)+1)&4294967295);$ix=$inc;__label__=3;continue $for_cond$5;}
var $11=$ix;var $12=$string1_addr;var $arrayidx5=(($12+4*$11)&4294967295);var $13=HEAP32[(($arrayidx5)>>2)];var $cmp6=((($13))|0)==34;if($cmp6){__label__=8;;}else{__label__=7;;}
$land_lhs_true$$lor_lhs_false$10:do{if(__label__==7){var $14=$ix;var $15=$string1_addr;var $arrayidx7=(($15+4*$14)&4294967295);var $16=HEAP32[(($arrayidx7)>>2)];var $cmp8=((($16))|0)==39;if($cmp8){__label__=8;break $land_lhs_true$$lor_lhs_false$10;}else{__label__=10;break $land_lhs_true$$lor_lhs_false$10;}}}while(0);$land_lhs_true$$if_end13$12:do{if(__label__==8){var $17=$ix;var $18=$string2_addr;var $arrayidx9=(($18+$17)&4294967295);var $19=HEAP8[($arrayidx9)];var $conv10=(tempInt=(($19)),(tempInt>=128?tempInt-256:tempInt));var $cmp11=((($conv10))|0)==0;if(!($cmp11)){__label__=10;break $land_lhs_true$$if_end13$12;}
$retval=0;__label__=11;break $if_then$$if_end$2;}}while(0);$retval=1;;}}while(0);var $20=$retval;;return $20;return null;}
function __ZL10attrlookupPKwPK8MNEM_TAB($string1,$mtab){;var __label__;var $retval;var $string1_addr;var $mtab_addr;var $ix;$string1_addr=$string1;$mtab_addr=$mtab;$ix=0;;while(1){var $0=$ix;var $1=$mtab_addr;var $arrayidx=(($1+8*$0)&4294967295);var $mnem=(($arrayidx)&4294967295);var $2=HEAP32[(($mnem)>>2)];var $cmp=((($2))|0)!=0;if(!($cmp)){__label__=5;break;}
var $3=$string1_addr;var $4=$ix;var $5=$mtab_addr;var $arrayidx1=(($5+8*$4)&4294967295);var $mnem2=(($arrayidx1)&4294967295);var $6=HEAP32[(($mnem2)>>2)];var $call=__ZL7attrcmpPKwPKc($3,$6);var $cmp3=((($call))|0)==0;var $7=$ix;if($cmp3){__label__=3;break;}
var $inc=((($7)+1)&4294967295);$ix=$inc;__label__=1;continue;}
if(__label__==5){var $10=$ix;var $11=$mtab_addr;var $arrayidx5=(($11+8*$10)&4294967295);var $value6=(($arrayidx5+4)&4294967295);var $12=HEAP32[(($value6)>>2)];$retval=$12;;}
else if(__label__==3){var $8=$mtab_addr;var $arrayidx4=(($8+8*$7)&4294967295);var $value=(($arrayidx4+4)&4294967295);var $9=HEAP32[(($value)>>2)];$retval=$9;;}
var $13=$retval;;return $13;return null;}
function __ZL17ProcessParamStackPcRi($outbuf,$outix){var __stackBase__=STACKTOP;STACKTOP+=80;_memset(__stackBase__,0,80);var __label__;var $outbuf_addr;var $outix_addr;var $param;var $ix;var $value;var $buf=__stackBase__;var $new_parameters=__stackBase__+20;$outbuf_addr=$outbuf;$outix_addr=$outix;$param=0;;$for_body$2:while(1){var $0=$param;var $arrayidx=(($new_parameters+$0*4)&4294967295);HEAP32[(($arrayidx)>>2)]=-1;var $1=$param;var $inc=((($1)+1)&4294967295);$param=$inc;var $cmp=((($inc))|0)<15;if($cmp){__label__=1;continue $for_body$2;}else{__label__=2;break $for_body$2;}}
$ix=0;var $2=$ix;var $3=HEAP32[((__ZL13n_param_stack)>>2)];var $cmp22=((($2))|0)<((($3))|0);$param=0;if($cmp22){__label__=4;;}else{__label__=3;;}
$for_body6$$for_cond20_preheader$5:do{if(__label__==4){while(1){var $4=$param;var $5=$ix;var $arrayidx7=((_param_stack+$5*64)&4294967295);var $parameter=(($arrayidx7+4)&4294967295);var $arrayidx8=(($parameter+$4*4)&4294967295);var $6=HEAP32[(($arrayidx8)>>2)];var $cmp9=((($6))|0)>=0;if($cmp9){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $7=$param;var $8=$ix;var $arrayidx10=((_param_stack+$8*64)&4294967295);var $parameter11=(($arrayidx10+4)&4294967295);var $arrayidx12=(($parameter11+$7*4)&4294967295);var $9=HEAP32[(($arrayidx12)>>2)];var $10=$param;var $arrayidx13=(($new_parameters+$10*4)&4294967295);HEAP32[(($arrayidx13)>>2)]=$9;;}
var $11=$param;var $inc15=((($11)+1)&4294967295);$param=$inc15;var $cmp5=((($inc15))|0)<15;if($cmp5){__label__=4;continue;}
var $12=$ix;var $inc18=((($12)+1)&4294967295);$ix=$inc18;var $13=$ix;var $14=HEAP32[((__ZL13n_param_stack)>>2)];var $cmp2=((($13))|0)<((($14))|0);$param=0;if($cmp2){__label__=4;continue;}else{__label__=3;break $for_body6$$for_cond20_preheader$5;}}}}while(0);var $arrayidx27=(($buf)&4294967295);var $arraydecay34=(($buf)&4294967295);var $arraydecay36=(($buf)&4294967295);var $arraydecay=(($buf)&4294967295);;while(1){var $15=$param;var $arrayidx23=(($new_parameters+$15*4)&4294967295);var $16=HEAP32[(($arrayidx23)>>2)];$value=$16;var $17=$param;var $arrayidx24=((__ZL17speech_parameters+$17*4)&4294967295);var $18=HEAP32[(($arrayidx24)>>2)];var $cmp25=((($16))|0)!=((($18))|0);if($cmp25){__label__=9;;}else{__label__=14;;}
if(__label__==9){HEAP8[($arrayidx27)]=0;var $19=$param;if($19==5){__label__=10;;}
else if($19==6){__label__=11;;}
else if($19==1){__label__=12;;}
else if($19==2){__label__=12;;}
else if($19==3){__label__=12;;}
else if($19==4){__label__=12;;}
else if($19==12){__label__=12;;}
else{__label__=13;;}
if(__label__==10){var $20=$value;var $sub=((($20)-1)&4294967295);HEAP32[((_option_punctuation)>>2)]=$sub;;}
else if(__label__==11){var $21=$value;HEAP32[((_option_capitals)>>2)]=$21;;}
else if(__label__==12){var $22=$value;var $23=$param;var $arrayidx30=((__ZZL17ProcessParamStackPcRiE10cmd_letter+$23)&4294967295);var $24=HEAP8[($arrayidx30)];var $conv=(tempInt=(($24)),(tempInt>=128?tempInt-256:tempInt));var $call=_sprintf($arraydecay,((__str128)&4294967295),allocate([1,0,0,0,$22,0,0,0,$conv,0,0,0],["i32",0,0,0,"i32",0,0,0,"i32",0,0,0],ALLOC_STACK));;}
var $25=$param;var $arrayidx31=(($new_parameters+$25*4)&4294967295);var $26=HEAP32[(($arrayidx31)>>2)];var $27=$param;var $arrayidx32=((__ZL17speech_parameters+$27*4)&4294967295);HEAP32[(($arrayidx32)>>2)]=$26;var $28=$outix_addr;var $29=HEAP32[(($28)>>2)];var $30=$outbuf_addr;var $arrayidx33=(($30+$29)&4294967295);var $call35=_strcpy($arrayidx33,$arraydecay34);var $call37=_strlen($arraydecay36);var $31=$outix_addr;var $32=HEAP32[(($31)>>2)];var $add=((($32)+($call37))&4294967295);HEAP32[(($31)>>2)]=$add;;}
var $33=$param;var $inc40=((($33)+1)&4294967295);$param=$inc40;var $cmp21=((($inc40))|0)<15;if($cmp21){__label__=8;continue;}else{__label__=15;break;}}
STACKTOP=__stackBase__;return;return;}
function __ZL19SetProsodyParameteriPwP11PARAM_STACK($param_type,$attr1,$sp){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $param_type_addr;var $attr1_addr;var $sp_addr;var $value=__stackBase__;var $sign;$param_type_addr=$param_type;$attr1_addr=$attr1;$sp_addr=$sp;var $0=$attr1_addr;var $1=$param_type_addr;var $arrayidx=((__ZZL19SetProsodyParameteriPwP11PARAM_STACKE9mnem_tabs+$1*4)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];var $call=__ZL10attrlookupPKwPK8MNEM_TAB($0,$2);HEAP32[(($value)>>2)]=$call;var $cmp=((($call))|0)>=0;var $3=$param_type_addr;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $arrayidx1=((((_param_stack+4)&4294967295)+$3*4)&4294967295);var $4=HEAP32[(($arrayidx1)>>2)];var $5=HEAP32[(($value)>>2)];var $mul=((($5)*($4))&4294967295);var $div=((((($mul))|0)/100)|0);var $6=$param_type_addr;var $7=$sp_addr;var $parameter=(($7+4)&4294967295);var $arrayidx2=(($parameter+$6*4)&4294967295);HEAP32[(($arrayidx2)>>2)]=$div;;}
else if(__label__==2){var $8=$attr1_addr;var $call3=__ZL18attr_prosody_valueiPKwPi($3,$8,$value);$sign=$call3;var $9=$sign;var $cmp4=((($9))|0)==0;if($cmp4){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $10=HEAP32[(($value)>>2)];var $11=$param_type_addr;var $12=$sp_addr;var $parameter6=(($12+4)&4294967295);var $arrayidx7=(($parameter6+$11*4)&4294967295);HEAP32[(($arrayidx7)>>2)]=$10;;}
else if(__label__==4){var $13=$sign;var $cmp9=((($13))|0)==2;var $14=$param_type_addr;var $arrayidx11=((__ZL17speech_parameters+$14*4)&4294967295);var $15=HEAP32[(($arrayidx11)>>2)];var $16=HEAP32[(($value)>>2)];if($cmp9){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $mul12=((($16)*($15))&4294967295);var $div13=((((($mul12))|0)/100)|0);var $17=$param_type_addr;var $18=$sp_addr;var $parameter14=(($18+4)&4294967295);var $arrayidx15=(($parameter14+$17*4)&4294967295);HEAP32[(($arrayidx15)>>2)]=$div13;;}
else if(__label__==6){var $19=$sign;var $mul18=((($19)*($16))&4294967295);var $add=((($mul18)+($15))&4294967295);var $20=$param_type_addr;var $21=$sp_addr;var $parameter19=(($21+4)&4294967295);var $arrayidx20=(($parameter19+$20*4)&4294967295);HEAP32[(($arrayidx20)>>2)]=$add;;}}}
STACKTOP=__stackBase__;return;return;}
function __ZL13PopParamStackiPcRi($tag_type,$outbuf,$outix){;var __label__;var $tag_type_addr;var $outbuf_addr;var $outix_addr;var $ix;var $top;$tag_type_addr=$tag_type;$outbuf_addr=$outbuf;$outix_addr=$outix;$top=0;var $0=$tag_type_addr;var $cmp=((($0))|0)>=32;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$tag_type_addr;var $sub=((($1)-32)&4294967295);$tag_type_addr=$sub;;}
$ix=0;var $2=$ix;var $3=HEAP32[((__ZL13n_param_stack)>>2)];var $cmp11=((($2))|0)<((($3))|0);if($cmp11){__label__=3;;}else{__label__=6;;}
$for_body$$for_end$5:do{if(__label__==3){while(1){var $4=$ix;var $arrayidx=((_param_stack+$4*64)&4294967295);var $type=(($arrayidx)&4294967295);var $5=HEAP32[(($type)>>2)];var $6=$tag_type_addr;var $cmp2=((($5))|0)==((($6))|0);if($cmp2){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $7=$ix;$top=$7;;}
var $8=$ix;var $inc=((($8)+1)&4294967295);$ix=$inc;var $9=$ix;var $10=HEAP32[((__ZL13n_param_stack)>>2)];var $cmp1=((($9))|0)<((($10))|0);if($cmp1){__label__=3;continue;}else{__label__=6;break $for_body$$for_end$5;}}}}while(0);var $11=$top;var $cmp5=((($11))|0)>0;if($cmp5){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $12=$top;HEAP32[((__ZL13n_param_stack)>>2)]=$12;;}
var $13=$outbuf_addr;var $14=$outix_addr;__ZL17ProcessParamStackPcRi($13,$14);;return;return;}
function __ZL10attrnumberPKwii($pw,$default_value,$type){;var __label__;var $retval;var $pw_addr;var $default_value_addr;var $type_addr;var $value;$pw_addr=$pw;$default_value_addr=$default_value;$type_addr=$type;$value=0;var $0=$pw_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=3;;}else{__label__=1;;}
$if_then$$lor_lhs_false$2:do{if(__label__==1){var $1=$pw_addr;var $2=HEAP32[(($1)>>2)];var $isdigittmp=((($2)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call=((($isdigit))&1);var $tobool=((($call))|0)!=0;if(!($tobool)){__label__=3;break $if_then$$lor_lhs_false$2;}
var $3=$pw_addr;var $4=HEAP32[(($3)>>2)];var $isdigittmp13=((($4)-48)&4294967295);var $isdigit24=((($isdigittmp13))>>>0)<10;if($isdigit24){__label__=4;;}else{__label__=5;;}
$while_body$$while_end$5:do{if(__label__==4){while(1){var $6=$value;var $mul=((($6)*10)&4294967295);var $7=$pw_addr;var $incdec_ptr=(($7+4)&4294967295);$pw_addr=$incdec_ptr;var $8=HEAP32[(($7)>>2)];var $add=((($mul)-48)&4294967295);var $sub=((($add)+($8))&4294967295);$value=$sub;var $9=$pw_addr;var $10=HEAP32[(($9)>>2)];var $isdigittmp1=((($10)-48)&4294967295);var $isdigit2=((($isdigittmp1))>>>0)<10;var $call1=((($isdigit2))&1);var $tobool2=((($call1))|0)!=0;if($tobool2){__label__=4;continue;}else{__label__=5;break $while_body$$while_end$5;}}}}while(0);var $11=$type_addr;var $cmp3=((($11))|0)==1;if($cmp3){__label__=6;;}else{__label__=8;;}
$land_lhs_true$$if_end8$9:do{if(__label__==6){var $12=$pw_addr;var $13=HEAP32[(($12)>>2)];var $call4=_towlower($13);var $cmp5=((($call4))|0)==115;if(!($cmp5)){__label__=8;break $land_lhs_true$$if_end8$9;}
var $14=$value;var $mul7=((($14)*1000)&4294967295);$value=$mul7;;}}while(0);var $15=$value;$retval=$15;__label__=9;break $if_then$$lor_lhs_false$2;}}while(0);if(__label__==3){var $5=$default_value_addr;$retval=$5;;}
var $16=$retval;;return $16;return null;}
function __ZL14ReplaceKeyNamePciRi($outbuf,$index,$outix){var __stackBase__=STACKTOP;STACKTOP+=40;_memset(__stackBase__,0,40);var __label__;var $retval;var $outbuf_addr;var $index_addr;var $outix_addr;var $keynames=__stackBase__;var $ix;var $letter;var $p;$outbuf_addr=$outbuf;$index_addr=$index;$outix_addr=$outix;var $0=$keynames;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=__ZZL14ReplaceKeyNamePciRiE8keynames;$dest$=$0;$stop$=$src$+40;if(($dest$%4)==($src$%4)&&40>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $1=$index_addr;var $2=$outbuf_addr;var $arrayidx=(($2+$1)&4294967295);$p=$arrayidx;var $arraydecay=(($keynames)&4294967295);var $3=$p;var $call=__Z10LookupMnemP8MNEM_TABPKc($arraydecay,$3);$letter=$call;var $cmp=((($call))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $4=$letter;var $5=$p;var $call1=__Z8utf8_outjPc($4,$5);$ix=$call1;var $6=$index_addr;var $7=$ix;var $add=((($7)+($6))&4294967295);var $8=$outix_addr;HEAP32[(($8)>>2)]=$add;var $9=$letter;$retval=$9;;}
else if(__label__==2){$retval=0;;}
STACKTOP=__stackBase__;return;return;}
function __ZL13attrcopy_utf8PcPKwi($buf,$pw,$len){;var __label__;var $buf_addr;var $pw_addr;var $len_addr;var $c;var $ix;var $n;var $prev_c;$buf_addr=$buf;$pw_addr=$pw;$len_addr=$len;$ix=0;$prev_c=0;var $0=$pw_addr;var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=6;;}
$while_cond$$if_end6$2:do{if(__label__==1){while(1){var $1=$ix;var $2=$len_addr;var $sub=((($2)-4)&4294967295);var $cmp1=((($1))|0)<((($sub))|0);if(!($cmp1)){__label__=6;break $while_cond$$if_end6$2;}
var $3=$pw_addr;var $incdec_ptr=(($3+4)&4294967295);$pw_addr=$incdec_ptr;var $4=HEAP32[(($3)>>2)];$c=$4;var $cmp2=((($4))|0)!=0;if(!($cmp2)){__label__=6;break $while_cond$$if_end6$2;}
var $5=$c;var $cmp3=((($5))|0)==34;if($cmp3){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $6=$prev_c;var $cmp4=((($6))|0)!=92;if($cmp4){__label__=6;break $while_cond$$if_end6$2;}}
var $7=$c;var $8=$ix;var $9=$buf_addr;var $arrayidx=(($9+$8)&4294967295);var $call=__Z8utf8_outjPc($7,$arrayidx);$n=$call;var $10=$n;var $11=$ix;var $add=((($11)+($10))&4294967295);$ix=$add;var $12=$c;$prev_c=$12;__label__=1;continue;}}}while(0);var $13=$ix;var $14=$buf_addr;var $arrayidx7=(($14+$13)&4294967295);HEAP8[($arrayidx7)]=0;var $15=$ix;;return $15;return null;}
function __ZL14LoadSoundFile2PKc($fname){;var __label__;var $retval;var $fname_addr;var $ix;$fname_addr=$fname;$ix=0;;while(1){var $0=$ix;var $1=HEAP32[((_n_soundicon_tab)>>2)];var $cmp=((($0))|0)<((($1))|0);if(!($cmp)){__label__=6;break;}
var $2=$ix;var $arrayidx=((_soundicon_tab+$2*16)&4294967295);var $filename=(($arrayidx+12)&4294967295);var $3=HEAP32[(($filename)>>2)];var $cmp1=((($3))|0)!=0;if($cmp1){__label__=3;;}else{__label__=5;;}
if(__label__==3){var $4=$fname_addr;var $5=$ix;var $arrayidx2=((_soundicon_tab+$5*16)&4294967295);var $filename3=(($arrayidx2+12)&4294967295);var $6=HEAP32[(($filename3)>>2)];var $call=_strcmp($4,$6);var $cmp4=((($call))|0)==0;if($cmp4){__label__=4;break;}}
var $8=$ix;var $inc=((($8)+1)&4294967295);$ix=$inc;__label__=1;continue;}
if(__label__==6){var $9=HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)];var $inc5=((($9)+1)&4294967295);HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)]=$inc5;var $10=HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)];var $cmp6=((($10))|0)>=4;if($cmp6){__label__=7;;}else{__label__=8;;}
if(__label__==7){HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)]=0;;}
var $11=$fname_addr;var $12=HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)];var $call9=__ZL13LoadSoundFilePKci($11,$12);var $cmp10=((($call9))|0)!=0;if($cmp10){__label__=9;;}else{__label__=10;;}
if(__label__==9){$retval=-1;;}
else if(__label__==10){var $13=$ix;var $arrayidx13=((_soundicon_tab+$13*16)&4294967295);var $filename14=(($arrayidx13+12)&4294967295);var $14=HEAP32[(($filename14)>>2)];var $15=$fname_addr;var $call15=_strlen($15);var $add=((($call15)+1)&4294967295);var $call16=_realloc($14,$add);var $16=HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)];var $arrayidx17=((_soundicon_tab+$16*16)&4294967295);var $filename18=(($arrayidx17+12)&4294967295);HEAP32[(($filename18)>>2)]=$call16;var $17=HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)];var $arrayidx19=((_soundicon_tab+$17*16)&4294967295);var $filename20=(($arrayidx19+12)&4294967295);var $18=HEAP32[(($filename20)>>2)];var $19=$fname_addr;var $call21=_strcpy($18,$19);var $20=HEAP32[((__ZZL14LoadSoundFile2PKcE4slot)>>2)];$retval=$20;;}}
else if(__label__==4){var $7=$ix;$retval=$7;;}
var $21=$retval;;return $21;return null;}
function __ZL18GetVoiceAttributesPwi($pw,$tag_type){;var __label__;var $retval;var $pw_addr;var $tag_type_addr;var $lang;var $gender;var $name;var $age;var $variant;var $new_voice_id;var $ssml_sp;$pw_addr=$pw;$tag_type_addr=$tag_type;var $0=$tag_type_addr;var $and=($0)&32;var $tobool=((($and))|0)!=0;if($tobool){__label__=1;;}else{__label__=3;;}
$if_then$$if_else$2:do{if(__label__==1){var $1=HEAP32[((__ZL12n_ssml_stack)>>2)];var $cmp=((($1))|0)>1;if(!($cmp)){__label__=10;break $if_then$$if_else$2;}
var $2=HEAP32[((__ZL12n_ssml_stack)>>2)];var $dec=((($2)-1)&4294967295);HEAP32[((__ZL12n_ssml_stack)>>2)]=$dec;__label__=10;break $if_then$$if_else$2;}
else if(__label__==3){var $3=$pw_addr;var $call=__ZL16GetSsmlAttributePwPKc($3,((__str106273)&4294967295));$lang=$call;var $4=$tag_type_addr;var $cmp2=((($4))|0)!=2;if($cmp2){__label__=4;;}else{__label__=5;;}
if(__label__==4){$name=0;$variant=0;$age=0;$gender=0;;}
else if(__label__==5){var $5=$pw_addr;var $call5=__ZL16GetSsmlAttributePwPKc($5,((__str5655)&4294967295));$name=$call5;var $6=$pw_addr;var $call6=__ZL16GetSsmlAttributePwPKc($6,((__str55707)&4294967295));$variant=$call6;var $7=$pw_addr;var $call7=__ZL16GetSsmlAttributePwPKc($7,((__str108275)&4294967295));$age=$call7;var $8=$pw_addr;var $call8=__ZL16GetSsmlAttributePwPKc($8,((__str7657)&4294967295));$gender=$call8;;}
var $9=$tag_type_addr;var $cmp10=((($9))|0)!=2;if($cmp10){__label__=7;;}else{__label__=9;;}
$land_lhs_true$$if_end13$10:do{if(__label__==7){var $10=$lang;var $cmp11=((($10))|0)==0;if(!($cmp11)){__label__=9;break $land_lhs_true$$if_end13$10;}
$retval=0;__label__=13;break $if_then$$if_else$2;}}while(0);var $11=HEAP32[((__ZL12n_ssml_stack)>>2)];var $inc=((($11)+1)&4294967295);HEAP32[((__ZL12n_ssml_stack)>>2)]=$inc;var $arrayidx=((__ZL10ssml_stack+$11*76)&4294967295);$ssml_sp=$arrayidx;var $12=$ssml_sp;var $language=(($12+56)&4294967295);var $arraydecay=(($language)&4294967295);var $13=$lang;var $call14=__ZL13attrcopy_utf8PcPKwi($arraydecay,$13,20);var $14=$ssml_sp;var $voice_name=(($14+16)&4294967295);var $arraydecay15=(($voice_name)&4294967295);var $15=$name;var $call16=__ZL13attrcopy_utf8PcPKwi($arraydecay15,$15,40);var $16=$variant;var $call17=__ZL10attrnumberPKwii($16,1,0);var $sub=((($call17)-1)&4294967295);var $17=$ssml_sp;var $voice_variant=(($17+4)&4294967295);HEAP32[(($voice_variant)>>2)]=$sub;var $18=$age;var $call18=__ZL10attrnumberPKwii($18,0,0);var $19=$ssml_sp;var $voice_age=(($19+12)&4294967295);HEAP32[(($voice_age)>>2)]=$call18;var $20=$gender;var $call19=__ZL10attrlookupPKwPK8MNEM_TAB($20,((__ZZL18GetVoiceAttributesPwiE11mnem_gender)&4294967295));var $21=$ssml_sp;var $voice_gender=(($21+8)&4294967295);HEAP32[(($voice_gender)>>2)]=$call19;var $22=$tag_type_addr;var $23=$ssml_sp;var $tag_type20=(($23)&4294967295);HEAP32[(($tag_type20)>>2)]=$22;__label__=10;break $if_then$$if_else$2;}}while(0);if(__label__==10){var $call22=__ZL14VoiceFromStackv();$new_voice_id=$call22;var $24=$new_voice_id;var $call23=_strcmp($24,((__ZL16current_voice_id)&4294967295));var $cmp24=((($call23))|0)!=0;if($cmp24){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $25=$new_voice_id;var $call26=_strcpy(((__ZL16current_voice_id)&4294967295),$25);$retval=131072;;}
else if(__label__==12){$retval=0;;}}
var $26=$retval;;return $26;return null;}
function __ZL14VoiceFromStackv(){var __stackBase__=STACKTOP;STACKTOP+=108;_memset(__stackBase__,0,108);var __label__;var $retval;var $ix;var $sp;var $v_id;var $voice_name_specified;var $voice_found=__stackBase__;var $voice_select=__stackBase__+4;var $voice_name=__stackBase__+28;var $language=__stackBase__+68;var $arraydecay=(($voice_name)&4294967295);var $call=_strcpy($arraydecay,((__ZL10ssml_stack+16)&4294967295));var $arraydecay1=(($language)&4294967295);var $call2=_strcpy($arraydecay1,((__ZL10ssml_stack+56)&4294967295));var $0=HEAP32[((((__ZL10ssml_stack+12)&4294967295))>>2)];var $conv=((($0))&255);var $age=(($voice_select+13)&4294967295);HEAP8[($age)]=$conv;var $1=HEAP32[((((__ZL10ssml_stack+8)&4294967295))>>2)];var $conv3=((($1))&255);var $gender=(($voice_select+12)&4294967295);HEAP8[($gender)]=$conv3;var $2=HEAP32[((((__ZL10ssml_stack+4)&4294967295))>>2)];var $conv4=((($2))&255);var $variant=(($voice_select+14)&4294967295);HEAP8[($variant)]=$conv4;var $identifier=(($voice_select+8)&4294967295);HEAP32[(($identifier)>>2)]=0;$ix=0;var $3=$ix;var $4=HEAP32[((__ZL12n_ssml_stack)>>2)];var $cmp1=((($3))|0)<((($4))|0);if($cmp1){__label__=1;;}else{__label__=15;;}
$for_body_lr_ph$$for_end$2:do{if(__label__==1){var $arraydecay13=(($voice_name)&4294967295);var $arrayidx17=(($language)&4294967295);var $gender18=(($voice_select+12)&4294967295);var $age19=(($voice_select+13)&4294967295);var $variant20=(($voice_select+14)&4294967295);var $arraydecay26=(($language)&4294967295);var $arrayidx32=(($voice_name)&4294967295);var $gender39=(($voice_select+12)&4294967295);var $age45=(($voice_select+13)&4294967295);var $variant51=(($voice_select+14)&4294967295);;$for_body$4:while(1){var $5=$ix;var $arrayidx=((__ZL10ssml_stack+$5*76)&4294967295);$sp=$arrayidx;$voice_name_specified=0;var $6=$sp;var $voice_name5=(($6+16)&4294967295);var $arrayidx6=(($voice_name5)&4294967295);var $7=HEAP8[($arrayidx6)];var $conv7=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $cmp8=((($conv7))|0)!=0;if($cmp8){__label__=3;;}else{__label__=5;;}
$land_lhs_true$$if_end$6:do{if(__label__==3){var $8=$sp;var $voice_name9=(($8+16)&4294967295);var $arraydecay10=(($voice_name9)&4294967295);var $call11=__Z17SelectVoiceByNamePP12espeak_VOICEPKc(0,$arraydecay10);var $cmp12=((($call11))|0)!=0;if(!($cmp12)){__label__=5;break $land_lhs_true$$if_end$6;}
$voice_name_specified=1;var $9=$sp;var $voice_name14=(($9+16)&4294967295);var $arraydecay15=(($voice_name14)&4294967295);var $call16=_strcpy($arraydecay13,$arraydecay15);HEAP8[($arrayidx17)]=0;HEAP8[($gender18)]=0;HEAP8[($age19)]=0;HEAP8[($variant20)]=0;;}}while(0);var $10=$sp;var $language21=(($10+56)&4294967295);var $arrayidx22=(($language21)&4294967295);var $11=HEAP8[($arrayidx22)];var $conv23=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $cmp24=((($conv23))|0)!=0;if($cmp24){__label__=6;;}else{__label__=8;;}
$if_then25$$if_end34$10:do{if(__label__==6){var $12=$sp;var $language27=(($12+56)&4294967295);var $arraydecay28=(($language27)&4294967295);var $call29=_strcpy($arraydecay26,$arraydecay28);var $13=$voice_name_specified;var $cmp30=((($13))|0)==0;if(!($cmp30)){__label__=8;break $if_then25$$if_end34$10;}
HEAP8[($arrayidx32)]=0;;}}while(0);var $14=$sp;var $voice_gender=(($14+8)&4294967295);var $15=HEAP32[(($voice_gender)>>2)];var $cmp35=((($15))|0)!=0;if($cmp35){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $16=$sp;var $voice_gender37=(($16+8)&4294967295);var $17=HEAP32[(($voice_gender37)>>2)];var $conv38=((($17))&255);HEAP8[($gender39)]=$conv38;;}
var $18=$sp;var $voice_age=(($18+12)&4294967295);var $19=HEAP32[(($voice_age)>>2)];var $cmp41=((($19))|0)!=0;if($cmp41){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $20=$sp;var $voice_age43=(($20+12)&4294967295);var $21=HEAP32[(($voice_age43)>>2)];var $conv44=((($21))&255);HEAP8[($age45)]=$conv44;;}
var $22=$sp;var $voice_variant=(($22+4)&4294967295);var $23=HEAP32[(($voice_variant)>>2)];var $cmp47=((($23))|0)!=0;if($cmp47){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $24=$sp;var $voice_variant49=(($24+4)&4294967295);var $25=HEAP32[(($voice_variant49)>>2)];var $conv50=((($25))&255);HEAP8[($variant51)]=$conv50;;}
var $26=$ix;var $inc=((($26)+1)&4294967295);$ix=$inc;var $27=$ix;var $28=HEAP32[((__ZL12n_ssml_stack)>>2)];var $cmp=((($27))|0)<((($28))|0);if($cmp){__label__=2;continue $for_body$4;}else{__label__=15;break $for_body_lr_ph$$for_end$2;}}}}while(0);var $arraydecay53=(($voice_name)&4294967295);var $name=(($voice_select)&4294967295);HEAP32[(($name)>>2)]=$arraydecay53;var $arraydecay54=(($language)&4294967295);var $languages=(($voice_select+4)&4294967295);HEAP32[(($languages)>>2)]=$arraydecay54;var $call55=__Z11SelectVoiceP12espeak_VOICEPi($voice_select,$voice_found);$v_id=$call55;var $cmp56=((($call55))|0)==0;if($cmp56){__label__=16;;}else{__label__=17;;}
if(__label__==16){$retval=((__str45697)&4294967295);;}
else if(__label__==17){var $29=$v_id;$retval=$29;;}
var $30=$retval;STACKTOP=__stackBase__;return $30;return null;}
function __ZL18attr_prosody_valueiPKwPi($param_type,$pw,$value_out){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var __lastLabel__=null;var $retval;var $param_type_addr;var $pw_addr;var $value_out_addr;var $sign;var $tail=__stackBase__;var $value;var $x;$param_type_addr=$param_type;$pw_addr=$pw;$value_out_addr=$value_out;$sign=0;var $0=$pw_addr;var $1=HEAP32[(($0)>>2)];var $call1=_iswspace($1);var $tobool2=((($call1))|0)!=0;var $2=$pw_addr;if($tobool2){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=2;;}
$while_body$$while_end$2:do{if(__label__==1){while(1){var $3=__lastLabel__==1?$6:($2);var $incdec_ptr=(($3+4)&4294967295);$pw_addr=$incdec_ptr;var $4=$pw_addr;var $5=HEAP32[(($4)>>2)];var $call=_iswspace($5);var $tobool=((($call))|0)!=0;var $6=$pw_addr;if($tobool){__lastLabel__=1;__label__=1;continue;}else{__lastLabel__=1;__label__=2;break $while_body$$while_end$2;}}}}while(0);var $_lcssa=__lastLabel__==0?$2:($6);var $7=HEAP32[(($_lcssa)>>2)];var $cmp=((($7))|0)==43;if($cmp){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $8=$pw_addr;var $incdec_ptr1=(($8+4)&4294967295);$pw_addr=$incdec_ptr1;$sign=1;;}
var $9=$pw_addr;var $10=HEAP32[(($9)>>2)];var $cmp2=((($10))|0)==45;if($cmp2){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $11=$pw_addr;var $incdec_ptr4=(($11+4)&4294967295);$pw_addr=$incdec_ptr4;$sign=-1;;}
var $12=$pw_addr;var $call6=_wcstod($12,$tail);var $conv=($call6);$value=$conv;var $13=HEAP32[(($tail)>>2)];var $14=$pw_addr;var $cmp7=((($13))|0)==((($14))|0);if($cmp7){__label__=7;;}else{__label__=8;;}
$if_then8$$if_end9$12:do{if(__label__==7){var $15=$value_out_addr;HEAP32[(($15)>>2)]=100;$retval=2;;}
else if(__label__==8){var $16=HEAP32[(($tail)>>2)];var $17=HEAP32[(($16)>>2)];var $cmp10=((($17))|0)==37;if($cmp10){__label__=9;;}else{__label__=12;;}
if(__label__==9){var $18=$sign;var $cmp12=((($18))|0)!=0;if($cmp12){__label__=10;;}else{__label__=11;;}
if(__label__==10){var $19=$sign;var $conv14=((($19))|0);var $20=$value;var $mul=($conv14)*($20);var $add=100+($mul);$value=$add;;}
var $21=$value;var $conv16=((($21))|0);var $22=$value_out_addr;HEAP32[(($22)>>2)]=$conv16;$retval=2;;}
else if(__label__==12){var $23=HEAP32[(($tail)>>2)];var $arrayidx=(($23)&4294967295);var $24=HEAP32[(($arrayidx)>>2)];var $cmp18=((($24))|0)==115;if($cmp18){__label__=13;;}else{__label__=15;;}
$land_lhs_true$$if_end26$21:do{if(__label__==13){var $25=HEAP32[(($tail)>>2)];var $arrayidx19=(($25+4)&4294967295);var $26=HEAP32[(($arrayidx19)>>2)];var $cmp20=((($26))|0)==116;if(!($cmp20)){__label__=15;break $land_lhs_true$$if_end26$21;}
var $27=$value;var $28=$sign;var $conv22=((($28))|0);var $mul23=($27)*($conv22);var $div=($mul23)/12;var $exp2=_exp2($div);var $mul24=($exp2)*100;$x=$mul24;var $29=$x;var $conv25=((($29))|0);var $30=$value_out_addr;HEAP32[(($30)>>2)]=$conv25;$retval=2;__label__=21;break $if_then8$$if_end9$12;}}while(0);var $31=$param_type_addr;var $cmp27=((($31))|0)==1;if($cmp27){__label__=16;;}else{__label__=20;;}
if(__label__==16){var $32=$sign;var $cmp29=((($32))|0)==0;if($cmp29){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $33=$value;var $mul31=($33)*100;var $conv32=((($mul31))|0);var $34=$value_out_addr;HEAP32[(($34)>>2)]=$conv32;;}
else if(__label__==18){var $35=$sign;var $conv33=((($35))|0);var $36=$value;var $mul34=($conv33)*($36);var $mul35=($mul34)*100;var $conv36=((($mul35))|0);var $add37=((($conv36)+100)&4294967295);var $37=$value_out_addr;HEAP32[(($37)>>2)]=$add37;;}
$retval=2;;}
else if(__label__==20){var $38=$value;var $conv40=((($38))|0);var $39=$value_out_addr;HEAP32[(($39)>>2)]=$conv40;var $40=$sign;$retval=$40;;}}}}while(0);var $41=$retval;STACKTOP=__stackBase__;return $41;return null;}
function __ZL8GetC_getv(){;var __label__;var $retval;var $c;var $c2;var $0=HEAP32[((__ZL7f_input)>>2)];var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=8;;}
$if_then$$if_end13$2:do{if(__label__==1){var $1=HEAP32[((__ZL7f_input)>>2)];var $call=_fgetc($1);$c=$call;var $2=HEAP32[((__ZL7f_input)>>2)];var $_flags=(($2+12)&4294967295);var $3=HEAP16[(($_flags)>>1)];var $conv=(tempInt=(($3)),(tempInt>=32768?tempInt-65536:tempInt));var $and=($conv)&32;var $cmp1=((($and))|0)!=0;if($cmp1){__label__=2;;}else{__label__=3;;}
if(__label__==2){$c=32;;}
var $4=HEAP32[((_option_multibyte)>>2)];var $cmp3=((($4))|0)==4;if($cmp3){__label__=4;;}else{__label__=7;;}
if(__label__==4){var $5=HEAP32[((__ZL7f_input)>>2)];var $call5=_fgetc($5);$c2=$call5;var $6=HEAP32[((__ZL7f_input)>>2)];var $_flags6=(($6+12)&4294967295);var $7=HEAP16[(($_flags6)>>1)];var $conv7=(tempInt=(($7)),(tempInt>=32768?tempInt-65536:tempInt));var $and8=($conv7)&32;var $cmp9=((($and8))|0)!=0;if($cmp9){__label__=5;;}else{__label__=6;;}
if(__label__==5){$c2=0;;}
var $8=$c;var $9=$c2;var $shl=((($9)*256)&4294967295);var $add=((($shl)+($8))&4294967295);$c=$add;;}
var $10=$c;$retval=$10;;}
else if(__label__==8){var $11=HEAP32[((_option_multibyte)>>2)];var $cmp14=((($11))|0)==3;if($cmp14){__label__=9;;}else{__label__=13;;}
$if_then15$$if_else$14:do{if(__label__==9){var $12=HEAP32[((_p_wchar_input)>>2)];var $13=HEAP32[(($12)>>2)];var $cmp16=((($13))|0)==0;if($cmp16){__label__=10;;}else{__label__=11;;}
if(__label__==10){HEAP8[(__ZL12end_of_input_b)]=1;$retval=0;__label__=20;break $if_then$$if_end13$2;}
else if(__label__==11){var $_b1=HEAPU8[(__ZL12end_of_input_b)];var $14=((($_b1))&1);var $tobool=((($14))|0)!=0;if($tobool){__label__=19;break $if_then15$$if_else$14;}
var $15=HEAP32[((_p_wchar_input)>>2)];var $incdec_ptr=(($15+4)&4294967295);HEAP32[((_p_wchar_input)>>2)]=$incdec_ptr;var $16=HEAP32[(($15)>>2)];$retval=$16;__label__=20;break $if_then$$if_end13$2;}}
else if(__label__==13){var $17=HEAP32[((_p_textinput)>>2)];var $18=HEAPU8[($17)];var $conv21=((($18))&255);var $cmp22=((($conv21))|0)==0;if($cmp22){__label__=14;;}else{__label__=15;;}
if(__label__==14){HEAP8[(__ZL12end_of_input_b)]=1;$retval=0;__label__=20;break $if_then$$if_end13$2;}
else if(__label__==15){var $_b=HEAPU8[(__ZL12end_of_input_b)];var $19=((($_b))&1);var $tobool25=((($19))|0)!=0;if($tobool25){__label__=19;break $if_then15$$if_else$14;}
var $20=HEAP32[((_option_multibyte)>>2)];var $cmp27=((($20))|0)==4;var $21=HEAPU32[((_p_textinput)>>2)];if($cmp27){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $arrayidx=(($21)&4294967295);var $22=HEAPU8[($arrayidx)];var $conv29=((($22))&255);var $23=HEAP32[((_p_textinput)>>2)];var $arrayidx30=(($23+1)&4294967295);var $24=HEAPU8[($arrayidx30)];var $conv31=((($24))&255);var $shl32=((($conv31)*256)&4294967295);var $add33=((($shl32)+($conv29))&4294967295);$c=$add33;var $25=HEAP32[((_p_textinput)>>2)];var $add_ptr=(($25+2)&4294967295);HEAP32[((_p_textinput)>>2)]=$add_ptr;var $26=$c;$retval=$26;__label__=20;break $if_then$$if_end13$2;}
else if(__label__==18){var $incdec_ptr35=(($21+1)&4294967295);HEAP32[((_p_textinput)>>2)]=$incdec_ptr35;var $27=HEAPU8[($21)];var $conv36=((($27))&255);var $and37=($conv36)&255;$retval=$and37;__label__=20;break $if_then$$if_end13$2;}}}}while(0);$retval=0;;}}while(0);var $28=$retval;;return $28;return null;}
function __ZL10GetC_ungeti($c){;var __label__;var $c_addr;$c_addr=$c;var $0=HEAP32[((__ZL7f_input)>>2)];var $cmp=((($0))|0)!=0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=$c_addr;var $2=HEAP32[((__ZL7f_input)>>2)];var $call=_ungetc($1,$2);;}
else if(__label__==2){var $3=HEAP32[((_p_textinput)>>2)];var $incdec_ptr=(($3+-1)&4294967295);HEAP32[((_p_textinput)>>2)]=$incdec_ptr;var $4=$c_addr;var $conv=((($4))&255);var $5=HEAP32[((_p_textinput)>>2)];HEAP8[($5)]=$conv;HEAP8[(__ZL12end_of_input_b)]=0;;};return;return;}
function __Z8SetSpeedi($control){;var __label__;var __lastLabel__=null;var $control_addr;var $x;var $s1;var $wpm;var $wpm2;var $wpm_value;var $sonic;$control_addr=$control;HEAP32[((((_speed+28)&4294967295))>>2)]=0;HEAP32[((((_speed+24)&4294967295))>>2)]=450;HEAP32[((((_speed+16)&4294967295))>>2)]=110;HEAP32[((((_speed+20)&4294967295))>>2)]=100;HEAP32[((((_speed+8)&4294967295))>>2)]=5;var $0=HEAP32[((((_embedded_value+8)&4294967295))>>2)];$wpm=$0;var $1=$control_addr;var $cmp=((($1))|0)==2;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $2=HEAP32[((((_embedded_value+32)&4294967295))>>2)];$wpm=$2;;}
var $3=$wpm;$wpm_value=$3;var $4=HEAP32[((_voice)>>2)];var $speed_percent=(($4+64)&4294967295);var $5=HEAP32[(($speed_percent)>>2)];var $cmp1=((($5))|0)>0;if($cmp1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $6=$wpm;var $7=HEAP32[((_voice)>>2)];var $speed_percent3=(($7+64)&4294967295);var $8=HEAP32[(($speed_percent3)>>2)];var $mul=((($8)*($6))&4294967295);var $div=((((($mul))|0)/100)|0);$wpm=$div;;}
var $9=$control_addr;var $and=($9)&2;var $tobool=((($and))|0)!=0;if($tobool){__label__=5;;}else{__label__=6;;}
if(__label__==5){__Z12DoSonicSpeedi(1024);;}
var $10=$wpm_value;var $cmp7=((($10))|0)>450;if($cmp7){__label__=10;;}else{__label__=7;;}
$if_then10$$lor_lhs_false$11:do{if(__label__==7){var $11=$wpm_value;var $12=HEAP32[((((_speed+32)&4294967295))>>2)];var $cmp8=((($11))|0)>((($12))|0);var $13=$wpm;if($cmp8){__label__=8;;}else{__label__=14;;}
$land_lhs_true$$if_end29$13:do{if(__label__==8){var $cmp9=((($13))|0)>350;if($cmp9){__label__=10;break $if_then10$$lor_lhs_false$11;}
var $_pr2=$wpm;__lastLabel__=9;__label__=16;break $land_lhs_true$$if_end29$13;}
else if(__label__==14){var $cmp30=((($13))|0)>450;if($cmp30){__lastLabel__=14;;}else{__lastLabel__=14;__label__=16;break $land_lhs_true$$if_end29$13;}
$wpm=450;__label__=17;break $land_lhs_true$$if_end29$13;}}while(0);$if_end32$$if_then34$18:do{if(__label__==16){var $29=__lastLabel__==9?$_pr2:($13);var $cmp33=((($29))|0)>360;if($cmp33){__label__=17;break $if_end32$$if_then34$18;}else{__label__=18;break $if_end32$$if_then34$18;}}}while(0);if(__label__==17){var $30=$wpm;var $sub=((($30)-360)&4294967295);var $div35=((((($sub))|0)/8)|0);HEAP32[((((_speed+28)&4294967295))>>2)]=$div35;;}
var $31=$wpm;$wpm2=$31;var $cmp37=((($31))|0)>359;if($cmp37){__lastLabel__=18;__label__=19;;}else{__lastLabel__=18;__label__=20;;}
if(__label__==19){$wpm2=359;var $_pr4=$wpm;__lastLabel__=19;;}
var $32=__lastLabel__==19?$_pr4:($31);var $cmp40=((($32))|0)<80;if($cmp40){__label__=21;;}else{__label__=22;;}
if(__label__==21){$wpm2=80;;}
var $33=$wpm2;var $sub43=((($33)-80)&4294967295);var $arrayidx=((__ZL12speed_lookup+$sub43)&4294967295);var $34=HEAPU8[($arrayidx)];var $conv44=((($34))&255);$x=$conv44;var $35=$wpm;var $cmp45=((($35))|0)>=380;if($cmp45){__label__=23;;}else{__label__=25;;}
$if_end47$$if_end50$29:do{if(__label__==23){$x=7;var $_pr5=$wpm;var $cmp48=((($_pr5))|0)>=400;if(!($cmp48)){__label__=25;break $if_end47$$if_end50$29;}
$x=6;;}}while(0);var $36=$control_addr;var $and51=($36)&1;var $tobool52=((($and51))|0)!=0;if($tobool52){__label__=26;;}else{__label__=28;;}
$if_then53$$if_end67$33:do{if(__label__==26){var $37=$x;var $38=HEAP32[((_voice)>>2)];var $speedf154=(($38+52)&4294967295);var $39=HEAP32[(($speedf154)>>2)];var $mul55=((($39)*($37))&4294967295);var $div56=((((($mul55))|0)/256)|0);HEAP32[((__ZL6speed1)>>2)]=$div56;var $40=$x;var $41=HEAP32[((_voice)>>2)];var $speedf257=(($41+56)&4294967295);var $42=HEAP32[(($speedf257)>>2)];var $mul58=((($42)*($40))&4294967295);var $div59=((((($mul58))|0)/256)|0);HEAP32[((__ZL6speed2)>>2)]=$div59;var $43=$x;var $44=HEAP32[((_voice)>>2)];var $speedf360=(($44+60)&4294967295);var $45=HEAP32[(($speedf360)>>2)];var $mul61=((($45)*($43))&4294967295);var $div62=((((($mul61))|0)/256)|0);HEAP32[((__ZL6speed3)>>2)]=$div62;var $46=$x;var $cmp63=((($46))|0)<=7;if(!($cmp63)){__label__=28;break $if_then53$$if_end67$33;}
var $47=$x;HEAP32[((__ZL6speed1)>>2)]=$47;var $48=$x;var $sub65=((($48)-1)&4294967295);HEAP32[((__ZL6speed3)>>2)]=$sub65;HEAP32[((__ZL6speed2)>>2)]=$sub65;;}}while(0);var $49=$control_addr;var $and68=($49)&2;var $tobool69=((($and68))|0)!=0;if(!($tobool69)){__label__=51;break $if_then10$$lor_lhs_false$11;}
var $50=$wpm;var $cmp71=((($50))|0)>350;var $51=$wpm;if($cmp71){__label__=30;;}else{__label__=31;;}
$if_then72$$if_else$38:do{if(__label__==30){var $sub73=((($51)-350)&4294967295);var $div74=((((($sub73))|0)/3)|0);var $sub75=((85-($div74))&4294967295);HEAP32[((((_speed+16)&4294967295))>>2)]=$sub75;var $52=$wpm;var $sub76=((($52)-350)&4294967295);var $div77=((((($sub76))|0)/8)|0);var $sub78=((60-($div77))&4294967295);HEAP32[((((_speed+20)&4294967295))>>2)]=$sub78;;}
else if(__label__==31){var $cmp79=((($51))|0)>250;if(!($cmp79)){__label__=33;break $if_then72$$if_else$38;}
var $53=$wpm;var $sub81=((($53)-250)&4294967295);var $div82=((((($sub81))|0)/4)|0);var $sub83=((110-($div82))&4294967295);HEAP32[((((_speed+16)&4294967295))>>2)]=$sub83;var $54=$wpm;var $sub84=((($54)-250)&4294967295);var $div85=((((($sub84))|0)/2)|0);var $sub86=((110-($div85))&4294967295);HEAP32[((((_speed+20)&4294967295))>>2)]=$sub86;;}}while(0);var $55=$x;var $56=HEAP32[((_voice)>>2)];var $speedf189=(($56+52)&4294967295);var $57=HEAP32[(($speedf189)>>2)];var $mul90=((($57)*($55))&4294967295);var $div91=((((($mul90))|0)/256)|0);$s1=$div91;var $58=$wpm;var $cmp92=((($58))|0)>=170;var $59=$s1;if($cmp92){__label__=34;;}else{__label__=35;;}
if(__label__==34){var $mul94=((($59)*150)&4294967295);var $div95=((((($mul94))|0)/128)|0);var $add=((($div95)+110)&4294967295);HEAP32[((((_speed+12)&4294967295))>>2)]=$add;;}
else if(__label__==35){var $mul97=((($59)*128)&4294967295);var $div98=((((($mul97))|0)/130)|0);var $add99=((($div98)+128)&4294967295);HEAP32[((((_speed+12)&4294967295))>>2)]=$add99;;}
var $60=$wpm;var $cmp101=((($60))|0)>=350;if($cmp101){__label__=37;;}else{__label__=40;;}
$if_end106$$if_end117$47:do{if(__label__==37){var $61=$wpm;var $sub103=((($61)-350)&4294967295);var $arrayidx104=((__ZL14wav_factor_350+$sub103)&4294967295);var $62=HEAPU8[($arrayidx104)];var $conv105=((($62))&255);HEAP32[((((_speed+12)&4294967295))>>2)]=$conv105;var $_pr7=$wpm;var $cmp107=((($_pr7))|0)>=390;if(!($cmp107)){__label__=40;break $if_end106$$if_end117$47;}
var $63=$wpm;var $sub109=((($63)-400)&4294967295);var $div110=((((($sub109))|0)/2)|0);var $sub111=((450-($div110))&4294967295);HEAP32[((((_speed+24)&4294967295))>>2)]=$sub111;var $64=$wpm;var $cmp112=((($64))|0)>440;if(!($cmp112)){__label__=40;break $if_end106$$if_end117$47;}
var $65=$wpm;var $_neg=(((-($65)))&4294967295);var $sub115=((($_neg)+860)&4294967295);HEAP32[((((_speed+24)&4294967295))>>2)]=$sub115;;}}while(0);var $66=$s1;var $mul118=((($66)*256)&4294967295);var $div119=((((($mul118))|0)/115)|0);HEAP32[((((_speed)&4294967295))>>2)]=$div119;HEAP32[((((_speed+4)&4294967295))>>2)]=0;var $67=$wpm;var $cmp120=((($67))|0)>430;if($cmp120){__label__=41;;}else{__label__=42;;}
$if_then121$$if_else122$52:do{if(__label__==41){HEAP32[((((_speed)&4294967295))>>2)]=12;;}
else if(__label__==42){var $68=$wpm;var $cmp123=((($68))|0)>400;if($cmp123){__label__=43;;}else{__label__=44;;}
if(__label__==43){HEAP32[((((_speed)&4294967295))>>2)]=13;;}
else if(__label__==44){var $69=$wpm;var $cmp126=((($69))|0)>374;if($cmp126){__label__=45;;}else{__label__=46;;}
if(__label__==45){HEAP32[((((_speed)&4294967295))>>2)]=14;;}
else if(__label__==46){var $70=$wpm;var $cmp129=((($70))|0)>350;if(!($cmp129)){__label__=48;break $if_then121$$if_else122$52;}
var $71=$wpm;var $sub131=((($71)-350)&4294967295);var $arrayidx132=((__ZL16pause_factor_350+$sub131)&4294967295);var $72=HEAPU8[($arrayidx132)];var $conv133=((($72))&255);HEAP32[((((_speed)&4294967295))>>2)]=$conv133;;}}}}while(0);var $73=HEAP32[((((_speed+4)&4294967295))>>2)];var $cmp138=((($73))|0)==0;if(!($cmp138)){__label__=51;break $if_then10$$lor_lhs_false$11;}
var $74=HEAP32[((((_speed)&4294967295))>>2)];HEAP32[((((_speed+4)&4294967295))>>2)]=$74;var $cmp140=((($74))|0)<16;if(!($cmp140)){__label__=51;break $if_then10$$lor_lhs_false$11;}
HEAP32[((((_speed+4)&4294967295))>>2)]=16;__label__=51;break $if_then10$$lor_lhs_false$11;}}while(0);$if_then10$$if_end144$65:do{if(__label__==10){var $14=$wpm;$wpm2=$14;$wpm=175;$x=73;var $15=$control_addr;var $and11=($15)&1;var $tobool12=((($and11))|0)!=0;if($tobool12){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $16=$x;var $17=HEAP32[((_voice)>>2)];var $speedf1=(($17+52)&4294967295);var $18=HEAP32[(($speedf1)>>2)];var $mul14=((($18)*($16))&4294967295);var $div15=((((($mul14))|0)/256)|0);HEAP32[((__ZL6speed1)>>2)]=$div15;var $19=$x;var $20=HEAP32[((_voice)>>2)];var $speedf2=(($20+56)&4294967295);var $21=HEAP32[(($speedf2)>>2)];var $mul16=((($21)*($19))&4294967295);var $div17=((((($mul16))|0)/256)|0);HEAP32[((__ZL6speed2)>>2)]=$div17;var $22=$x;var $23=HEAP32[((_voice)>>2)];var $speedf3=(($23+60)&4294967295);var $24=HEAP32[(($speedf3)>>2)];var $mul18=((($24)*($22))&4294967295);var $div19=((((($mul18))|0)/256)|0);HEAP32[((__ZL6speed3)>>2)]=$div19;;}
var $25=$control_addr;var $and21=($25)&2;var $tobool22=((($and21))|0)!=0;if(!($tobool22)){__label__=51;break $if_then10$$if_end144$65;}
var $26=$wpm2;var $conv=((($26))|0);var $27=$wpm;var $conv24=((($27))|0);var $div25=($conv)/($conv24);$sonic=$div25;var $28=$sonic;var $mul26=($28)*1024;var $conv27=((($mul26))|0);__Z12DoSonicSpeedi($conv27);HEAP32[((((_speed)&4294967295))>>2)]=85;HEAP32[((((_speed+4)&4294967295))>>2)]=80;HEAP32[((((_speed+8)&4294967295))>>2)]=22;HEAP32[((((_speed+24)&4294967295))>>2)]=900;HEAP32[((((_speed+12)&4294967295))>>2)]=211;HEAP32[((((_speed+16)&4294967295))>>2)]=210;HEAP32[((((_speed+20)&4294967295))>>2)]=170;;}}while(0);;return;return;}
function __Z12SetParameteriii($parameter,$value,$relative){;var __label__;var $parameter_addr;var $value_addr;var $relative_addr;var $new_value;var $default_value;$parameter_addr=$parameter;$value_addr=$value;$relative_addr=$relative;var $0=$value_addr;$new_value=$0;var $1=$relative_addr;var $tobool=((($1))|0)!=0;if($tobool){__label__=1;;}else{__label__=3;;}
$if_then$$if_end2$2:do{if(__label__==1){var $2=$parameter_addr;var $cmp=((($2))|0)<5;if(!($cmp)){__label__=3;break $if_then$$if_end2$2;}
var $3=$parameter_addr;var $arrayidx=((_param_defaults+$3*4)&4294967295);var $4=HEAP32[(($arrayidx)>>2)];$default_value=$4;var $5=$default_value;var $6=$default_value;var $7=$value_addr;var $mul=((($7)*($6))&4294967295);var $div=((((($mul))|0)/100)|0);var $add=((($div)+($5))&4294967295);$new_value=$add;;}}while(0);var $8=$new_value;var $9=$parameter_addr;var $arrayidx3=((((_param_stack+4)&4294967295)+$9*4)&4294967295);HEAP32[(($arrayidx3)>>2)]=$8;var $10=$parameter_addr;if($10==1){__label__=4;;}
else if($10==2){__label__=5;;}
else if($10==3){__label__=6;;}
else if($10==4){__label__=11;;}
else if($10==13){__label__=14;;}
else if($10==7){__label__=15;;}
else if($10==9){__label__=16;;}
else{__label__=19;;}
if(__label__==4){var $11=$new_value;HEAP32[((((_embedded_value+8)&4294967295))>>2)]=$11;var $12=$new_value;HEAP32[((((_embedded_value+32)&4294967295))>>2)]=$12;__Z8SetSpeedi(3);;}
else if(__label__==5){var $13=$new_value;HEAP32[((((_embedded_value+12)&4294967295))>>2)]=$13;var $call=__Z12GetAmplitudev();;}
else if(__label__==6){var $14=$new_value;var $cmp6=((($14))|0)>99;if($cmp6){__label__=7;;}else{__label__=8;;}
$if_end8_thread$$if_end8$10:do{if(__label__==7){$new_value=99;;}
else if(__label__==8){var $cmp9=((($14))|0)<0;if(!($cmp9)){__label__=10;break $if_end8_thread$$if_end8$10;}
$new_value=0;;}}while(0);var $15=$new_value;HEAP32[((((_embedded_value+4)&4294967295))>>2)]=$15;;}
else if(__label__==11){var $16=$new_value;var $cmp13=((($16))|0)>99;if($cmp13){__label__=12;;}else{__label__=13;;}
if(__label__==12){$new_value=99;;}
var $17=$new_value;HEAP32[((((_embedded_value+16)&4294967295))>>2)]=$17;;}
else if(__label__==14){var $18=$new_value;HEAP32[((_option_linelength)>>2)]=$18;;}
else if(__label__==15){var $19=$new_value;HEAP32[((_option_wordgap)>>2)]=$19;;}
else if(__label__==16){var $20=$new_value;var $and=($20)&255;var $cmp19=((($and))|0)!=0;if($cmp19){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $21=$new_value;var $and21=($21)&255;var $22=HEAP32[((_translator)>>2)];var $langopts=(($22)&4294967295);var $intonation_group=(($langopts+228)&4294967295);HEAP32[(($intonation_group)>>2)]=$and21;;}
var $23=$new_value;HEAP32[((_option_tone_flags)>>2)]=$23;;};return;return;}
function __Z11CalcLengthsP10Translator($tr){var __stackBase__=STACKTOP;STACKTOP+=156;_memset(__stackBase__,0,156);var __label__;var __lastLabel__=null;var $tr_addr;var $ix;var $ix2;var $prev;var $next;var $next2;var $next3;var $p;var $p2;var $stress;var $type;var $pre_sonorant;var $pre_voiced;var $last_pitch;var $pitch_start;var $length_mod;var $len;var $env2;var $end_of_clause;var $embedded_ix=__stackBase__;var $min_drop;var $pitch1;var $emphasized;var $tone_mod;var $pitch_env;var $phdata_tone=__stackBase__+4;$tr_addr=$tr;$pre_sonorant=0;$pre_voiced=0;$last_pitch=0;HEAP32[(($embedded_ix)>>2)]=0;$pitch_env=0;$ix=1;var $0=$ix;var $1=HEAP32[((_n_phoneme_list)>>2)];var $cmp7=((($0))|0)<((($1))|0);if($cmp7){__label__=1;;}else{__label__=193;;}
$for_body_lr_ph$$for_end733$2:do{if(__label__==1){var $pitch_env595=(($phdata_tone+124)&4294967295);;$for_body$4:while(1){var $2=$ix;var $sub=((($2)-1)&4294967295);var $arrayidx=((_phoneme_list+$sub*24)&4294967295);$prev=$arrayidx;var $3=$ix;var $arrayidx1=((_phoneme_list+$3*24)&4294967295);$p=$arrayidx1;var $4=$p;var $stresslevel=(($4+1)&4294967295);var $5=HEAPU8[($stresslevel)];var $conv=((($5))&255);var $and=($conv)&7;$stress=$and;var $6=$p;var $stresslevel2=(($6+1)&4294967295);var $7=HEAPU8[($stresslevel2)];var $conv3=((($7))&255);var $and4=($conv3)&8;$emphasized=$and4;var $8=$ix;var $add=((($8)+1)&4294967295);var $arrayidx5=((_phoneme_list+$add*24)&4294967295);$next=$arrayidx5;var $9=$p;var $synthflags=(($9+4)&4294967295);var $10=HEAPU16[(($synthflags)>>1)];var $conv6=((($10))&65535);var $and7=($conv6)&2;var $tobool=((($and7))|0)!=0;if($tobool){__label__=3;;}else{__label__=4;;}
if(__label__==3){__ZL11DoEmbedded2Pi($embedded_ix);;}
var $11=$p;var $type8=(($11+15)&4294967295);var $12=HEAPU8[($type8)];var $conv9=((($12))&255);$type=$conv9;var $13=$p;var $synthflags10=(($13+4)&4294967295);var $14=HEAPU16[(($synthflags10)>>1)];var $conv11=((($14))&65535);var $and12=($conv11)&4;var $tobool13=((($and12))|0)!=0;if($tobool13){__label__=5;;}else{__label__=6;;}
$if_end15_thread$$if_end15$9:do{if(__label__==5){$type=2;__label__=98;break $if_end15_thread$$if_end15$9;}
else if(__label__==6){var $_pr=$type;if($_pr==0){__label__=7;;}
else if($_pr==4){__label__=8;;}
else if($_pr==7){__label__=23;;}
else if($_pr==6){__label__=23;;}
else if($_pr==5){__label__=49;;}
else if($_pr==3){__label__=74;;}
else if($_pr==8){__label__=74;;}
else if($_pr==2){__label__=98;break $if_end15_thread$$if_end15$9;}
else{__label__=192;break $if_end15_thread$$if_end15$9;}
if(__label__==7){$last_pitch=0;__label__=192;break $if_end15_thread$$if_end15$9;}
else if(__label__==8){$last_pitch=0;var $15=$prev;var $type17=(($15+15)&4294967295);var $16=HEAPU8[($type17)];var $conv18=((($16))&255);var $cmp19=((($conv18))|0)==6;if($cmp19){__label__=9;;}else{__label__=10;;}
$if_then20$$if_else$15:do{if(__label__==9){var $17=$p;var $prepause=(($17+16)&4294967295);HEAP8[($prepause)]=25;;}
else if(__label__==10){var $18=HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)];var $cmp21=((($18))|0)>0;if($cmp21){__label__=12;;}else{__label__=11;;}
$if_then23$$lor_lhs_false$18:do{if(__label__==11){var $19=$stress;var $cmp22=((($19))|0)<4;if($cmp22){__label__=12;break $if_then23$$lor_lhs_false$18;}
var $21=$p;var $prepause26=(($21+16)&4294967295);HEAP8[($prepause26)]=60;__label__=14;break $if_then20$$if_else$15;}}while(0);var $20=$p;var $prepause24=(($20+16)&4294967295);HEAP8[($prepause24)]=48;;}}while(0);var $22=$prev;var $type29=(($22+15)&4294967295);var $23=HEAPU8[($type29)];var $conv30=((($23))&255);var $cmp31=((($conv30))|0)==4;if($cmp31){__label__=15;;}else{__label__=16;;}
if(__label__==15){var $24=$p;var $prepause33=(($24+16)&4294967295);HEAP8[($prepause33)]=60;;}
var $25=$tr_addr;var $langopts=(($25)&4294967295);var $word_gap=(($langopts)&4294967295);var $26=HEAP32[(($word_gap)>>2)];var $and35=($26)&16;var $tobool36=((($and35))|0)!=0;if($tobool36){__label__=17;;}else{__label__=19;;}
$land_lhs_true$$if_end40$26:do{if(__label__==17){var $27=$p;var $newword=(($27+19)&4294967295);var $28=HEAP8[($newword)];var $tobool37=(tempInt=(($28)),(tempInt>=128?tempInt-256:tempInt))!=0;if(!($tobool37)){__label__=19;break $land_lhs_true$$if_end40$26;}
var $29=$p;var $prepause39=(($29+16)&4294967295);HEAP8[($prepause39)]=60;;}}while(0);var $30=$p;var $ph=(($30+8)&4294967295);var $31=HEAP32[(($ph)>>2)];var $phflags=(($31+4)&4294967295);var $32=HEAP32[(($phflags)>>2)];var $and41=($32)&4194304;var $tobool42=((($and41))|0)!=0;if($tobool42){__label__=20;;}else{__label__=21;;}
if(__label__==20){var $33=$p;var $prepause44=(($33+16)&4294967295);var $34=HEAPU8[($prepause44)];var $conv45=((($34))&255);var $add46=((($conv45)+30)&4294967295);var $conv47=((($add46))&255);HEAP8[($prepause44)]=$conv47;;}
var $35=$p;var $synthflags49=(($35+4)&4294967295);var $36=HEAPU16[(($synthflags49)>>1)];var $conv50=((($36))&65535);var $and51=($conv50)&8;var $tobool52=((($and51))|0)!=0;if(!($tobool52)){__label__=192;break $if_end15_thread$$if_end15$9;}
var $37=$tr_addr;var $langopts54=(($37)&4294967295);var $long_stop=(($langopts54+240)&4294967295);var $38=HEAP32[(($long_stop)>>2)];var $39=$p;var $prepause55=(($39+16)&4294967295);var $40=HEAPU8[($prepause55)];var $conv56=((($40))&255);var $add57=((($conv56)+($38))&4294967295);var $conv58=((($add57))&255);HEAP8[($prepause55)]=$conv58;__label__=192;break $if_end15_thread$$if_end15$9;}
else if(__label__==23){var $41=$p;var $newword61=(($41+19)&4294967295);var $42=HEAP8[($newword61)];var $tobool62=(tempInt=(($42)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool62){__label__=24;;}else{__label__=27;;}
$if_then63$$if_end76$35:do{if(__label__==24){var $43=$prev;var $type64=(($43+15)&4294967295);var $44=HEAPU8[($type64)];var $conv65=((($44))&255);var $cmp66=((($conv65))|0)==2;if($cmp66){__label__=25;;}else{__label__=26;;}
if(__label__==25){var $45=$p;var $ph68=(($45+8)&4294967295);var $46=HEAP32[(($ph68)>>2)];var $phflags69=(($46+4)&4294967295);var $47=HEAP32[(($phflags69)>>2)];var $and70=($47)&16777216;var $tobool71=((($and70))|0)!=0;if($tobool71){__label__=27;break $if_then63$$if_end76$35;}}
var $48=$p;var $prepause74=(($48+16)&4294967295);HEAP8[($prepause74)]=15;;}}while(0);var $49=$next;var $type77=(($49+15)&4294967295);var $50=HEAPU8[($type77)];var $conv78=((($50))&255);var $cmp79=((($conv78))|0)==0;if($cmp79){__label__=28;;}else{__label__=31;;}
$land_lhs_true80$$if_end91$41:do{if(__label__==28){var $51=$prev;var $type81=(($51+15)&4294967295);var $52=HEAPU8[($type81)];var $conv82=((($52))&255);var $cmp83=((($conv82))|0)==8;if(!($cmp83)){__label__=31;break $land_lhs_true80$$if_end91$41;}
var $53=$p;var $ph85=(($53+8)&4294967295);var $54=HEAP32[(($ph85)>>2)];var $phflags86=(($54+4)&4294967295);var $55=HEAP32[(($phflags86)>>2)];var $and87=($55)&8;var $tobool88=((($and87))|0)!=0;if($tobool88){__label__=31;break $land_lhs_true80$$if_end91$41;}
var $56=$p;var $prepause90=(($56+16)&4294967295);HEAP8[($prepause90)]=25;;}}while(0);var $57=$prev;var $ph92=(($57+8)&4294967295);var $58=HEAP32[(($ph92)>>2)];var $phflags93=(($58+4)&4294967295);var $59=HEAP32[(($phflags93)>>2)];var $and94=($59)&16384;var $tobool95=((($and94))|0)!=0;if($tobool95){__label__=32;;}else{__label__=33;;}
if(__label__==32){var $60=$p;var $prepause97=(($60+16)&4294967295);HEAP8[($prepause97)]=30;;}
var $61=$tr_addr;var $langopts99=(($61)&4294967295);var $word_gap100=(($langopts99)&4294967295);var $62=HEAP32[(($word_gap100)>>2)];var $and101=($62)&16;var $tobool102=((($and101))|0)!=0;if($tobool102){__label__=34;;}else{__label__=36;;}
$land_lhs_true103$$if_end108$49:do{if(__label__==34){var $63=$p;var $newword104=(($63+19)&4294967295);var $64=HEAP8[($newword104)];var $tobool105=(tempInt=(($64)),(tempInt>=128?tempInt-256:tempInt))!=0;if(!($tobool105)){__label__=36;break $land_lhs_true103$$if_end108$49;}
var $65=$p;var $prepause107=(($65+16)&4294967295);HEAP8[($prepause107)]=30;;}}while(0);var $66=$p;var $ph109=(($66+8)&4294967295);var $67=HEAP32[(($ph109)>>2)];var $phflags110=(($67+4)&4294967295);var $68=HEAP32[(($phflags110)>>2)];var $and111=($68)&32;var $tobool112=((($and111))|0)!=0;if($tobool112){__label__=37;;}else{__label__=42;;}
$land_lhs_true113$$if_else128$53:do{if(__label__==37){var $69=$next;var $type114=(($69+15)&4294967295);var $70=HEAPU8[($type114)];var $conv115=((($70))&255);var $cmp116=((($conv115))|0)==4;if(!($cmp116)){__label__=42;break $land_lhs_true113$$if_else128$53;}
var $71=$next;var $newword118=(($71+19)&4294967295);var $72=HEAP8[($newword118)];var $tobool119=(tempInt=(($72)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool119){__label__=42;break $land_lhs_true113$$if_else128$53;}
var $73=$prev;var $type121=(($73+15)&4294967295);var $74=HEAPU8[($type121)];var $conv122=((($74))&255);var $cmp123=((($conv122))|0)==2;var $75=$p;var $length=(($75+12)&4294967295);if($cmp123){__label__=40;;}else{__label__=41;;}
if(__label__==40){HEAP16[(($length)>>1)]=200;__label__=43;break $land_lhs_true113$$if_else128$53;}
else if(__label__==41){HEAP16[(($length)>>1)]=150;__label__=43;break $land_lhs_true113$$if_else128$53;}}}while(0);if(__label__==42){var $76=$p;var $length129=(($76+12)&4294967295);HEAP16[(($length129)>>1)]=256;;}
var $77=$type;var $cmp131=((($77))|0)==7;if(!($cmp131)){__label__=192;break $if_end15_thread$$if_end15$9;}
var $78=$next;var $type133=(($78+15)&4294967295);var $79=HEAPU8[($type133)];var $conv134=((($79))&255);var $cmp135=((($conv134))|0)==2;if($cmp135){__label__=45;;}else{__label__=46;;}
if(__label__==45){$pre_voiced=1;;}
var $80=$prev;var $type138=(($80+15)&4294967295);var $81=HEAPU8[($type138)];var $conv139=((($81))&255);var $cmp140=((($conv139))|0)==2;if($cmp140){__label__=48;;}else{__label__=47;;}
if(__label__==47){var $82=$prev;var $type142=(($82+15)&4294967295);var $83=HEAPU8[($type142)];var $conv143=((($83))&255);var $cmp144=((($conv143))|0)==3;if(!($cmp144)){__label__=192;break $if_end15_thread$$if_end15$9;}}
var $84=$prev;var $length146=(($84+12)&4294967295);var $85=HEAP16[(($length146)>>1)];var $conv147=(tempInt=(($85)),(tempInt>=32768?tempInt-65536:tempInt));var $add148=((($conv147)+255)&4294967295);var $div=((((($add148))|0)/2)|0);var $conv149=((($div))&65535);var $86=$p;var $length150=(($86+12)&4294967295);HEAP16[(($length150)>>1)]=$conv149;__label__=192;break $if_end15_thread$$if_end15$9;}
else if(__label__==49){var $87=$prev;var $type154=(($87+15)&4294967295);var $88=HEAPU8[($type154)];var $conv155=((($88))&255);var $cmp156=((($conv155))|0)==7;if($cmp156){__label__=53;;}else{__label__=50;;}
$if_then170$$lor_lhs_false157$71:do{if(__label__==50){var $89=$prev;var $type158=(($89+15)&4294967295);var $90=HEAPU8[($type158)];var $conv159=((($90))&255);var $cmp160=((($conv159))|0)==6;if($cmp160){__label__=53;break $if_then170$$lor_lhs_false157$71;}
var $91=$prev;var $ph162=(($91+8)&4294967295);var $92=HEAP32[(($ph162)>>2)];var $phflags163=(($92+4)&4294967295);var $93=HEAP32[(($phflags163)>>2)];var $and164=($93)&32;var $tobool165=((($and164))|0)!=0;if($tobool165){__label__=53;break $if_then170$$lor_lhs_false157$71;}
var $94=$prev;var $type167=(($94+15)&4294967295);var $95=HEAPU8[($type167)];var $conv168=((($95))&255);var $cmp169=((($conv168))|0)==3;if($cmp169){__label__=53;break $if_then170$$lor_lhs_false157$71;}else{__label__=54;break $if_then170$$lor_lhs_false157$71;}}}while(0);if(__label__==53){var $96=$p;var $prepause171=(($96+16)&4294967295);HEAP8[($prepause171)]=30;;}
var $97=$next;var $type173=(($97+15)&4294967295);var $98=HEAPU8[($type173)];var $conv174=((($98))&255);var $cmp175=((($conv174))|0)==2;if($cmp175){__label__=56;;}else{__label__=55;;}
$if_then180$$lor_lhs_false176$78:do{if(__label__==55){var $99=$next;var $type177=(($99+15)&4294967295);var $100=HEAPU8[($type177)];var $conv178=((($100))&255);var $cmp179=((($conv178))|0)==3;if($cmp179){__label__=56;break $if_then180$$lor_lhs_false176$78;}else{__label__=70;break $if_then180$$lor_lhs_false176$78;}}}while(0);$if_then180$$if_end229$80:do{if(__label__==56){var $101=$next;var $type181=(($101+15)&4294967295);var $102=HEAPU8[($type181)];var $conv182=((($102))&255);var $cmp183=((($conv182))|0)==2;if($cmp183){__label__=58;;}else{__label__=57;;}
$if_then187$$lor_lhs_false184$82:do{if(__label__==57){var $103=$next;var $newword185=(($103+19)&4294967295);var $104=HEAP8[($newword185)];var $tobool186=(tempInt=(($104)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool186){__label__=59;break $if_then187$$lor_lhs_false184$82;}else{__label__=58;break $if_then187$$lor_lhs_false184$82;}}}while(0);if(__label__==58){$pre_voiced=1;;}
var $105=$p;var $prepause189=(($105+16)&4294967295);HEAP8[($prepause189)]=40;var $106=$prev;var $type190=(($106+15)&4294967295);var $107=HEAPU8[($type190)];var $conv191=((($107))&255);var $cmp192=((($conv191))|0)==0;if($cmp192){__label__=61;;}else{__label__=60;;}
$if_then197$$lor_lhs_false193$87:do{if(__label__==60){var $108=$prev;var $type194=(($108+15)&4294967295);var $109=HEAPU8[($type194)];var $conv195=((($109))&255);var $cmp196=((($conv195))|0)==2;if($cmp196){__label__=61;break $if_then197$$lor_lhs_false193$87;}
var $111=$p;var $newword200=(($111+19)&4294967295);var $112=HEAPU8[($newword200)];var $conv201=((($112))&255);var $cmp202=((($conv201))|0)==0;if(!($cmp202)){__label__=70;break $if_then180$$if_end229$80;}
var $113=$prev;var $type204=(($113+15)&4294967295);var $114=HEAPU8[($type204)];var $conv205=((($114))&255);var $cmp206=((($conv205))|0)==3;if($cmp206){__label__=64;;}else{__label__=65;;}
if(__label__==64){var $115=$p;var $prepause208=(($115+16)&4294967295);HEAP8[($prepause208)]=20;;}
var $116=$prev;var $type210=(($116+15)&4294967295);var $117=HEAPU8[($type210)];var $conv211=((($117))&255);var $cmp212=((($conv211))|0)==8;if($cmp212){__label__=66;;}else{__label__=67;;}
if(__label__==66){var $118=$p;var $prepause214=(($118+16)&4294967295);HEAP8[($prepause214)]=12;;}
var $119=$prev;var $type216=(($119+15)&4294967295);var $120=HEAPU8[($type216)];var $conv217=((($120))&255);var $cmp218=((($conv217))|0)==4;if(!($cmp218)){__label__=70;break $if_then180$$if_end229$80;}
var $121=$prev;var $ph220=(($121+8)&4294967295);var $122=HEAP32[(($ph220)>>2)];var $phflags221=(($122+4)&4294967295);var $123=HEAP32[(($phflags221)>>2)];var $and222=($123)&8;var $tobool223=((($and222))|0)!=0;if($tobool223){__label__=70;break $if_then180$$if_end229$80;}
var $124=$p;var $prepause225=(($124+16)&4294967295);HEAP8[($prepause225)]=0;__label__=70;break $if_then180$$if_end229$80;}}while(0);var $110=$p;var $prepause198=(($110+16)&4294967295);HEAP8[($prepause198)]=0;;}}while(0);var $125=$tr_addr;var $langopts230=(($125)&4294967295);var $word_gap231=(($langopts230)&4294967295);var $126=HEAP32[(($word_gap231)>>2)];var $and232=($126)&16;var $tobool233=((($and232))|0)!=0;if(!($tobool233)){__label__=192;break $if_end15_thread$$if_end15$9;}
var $127=$p;var $newword235=(($127+19)&4294967295);var $128=HEAP8[($newword235)];var $tobool236=(tempInt=(($128)),(tempInt>=128?tempInt-256:tempInt))!=0;if(!($tobool236)){__label__=192;break $if_end15_thread$$if_end15$9;}
var $129=$p;var $prepause238=(($129+16)&4294967295);var $130=HEAPU8[($prepause238)];var $conv239=((($130))&255);var $cmp240=((($conv239))|0)<20;if(!($cmp240)){__label__=192;break $if_end15_thread$$if_end15$9;}
var $131=$p;var $prepause242=(($131+16)&4294967295);HEAP8[($prepause242)]=20;__label__=192;break $if_end15_thread$$if_end15$9;}
else if(__label__==74){var $132=$tr_addr;var $stress_amps=(($132+660)&4294967295);var $arrayidx245=(($stress_amps)&4294967295);var $133=HEAP8[($arrayidx245)];var $134=$p;var $amp=(($134+18)&4294967295);HEAP8[($amp)]=$133;var $135=$p;var $length246=(($135+12)&4294967295);HEAP16[(($length246)>>1)]=256;$min_drop=0;var $136=$p;var $newword247=(($136+19)&4294967295);var $137=HEAP8[($newword247)];var $tobool248=(tempInt=(($137)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool248){__label__=75;;}else{__label__=80;;}
$if_then249$$if_end268$105:do{if(__label__==75){var $138=$prev;var $type250=(($138+15)&4294967295);var $139=HEAPU8[($type250)];var $conv251=((($139))&255);var $cmp252=((($conv251))|0)==3;if($cmp252){__label__=76;;}else{__label__=77;;}
if(__label__==76){var $140=$p;var $prepause254=(($140+16)&4294967295);HEAP8[($prepause254)]=25;;}
var $141=$prev;var $type256=(($141+15)&4294967295);var $142=HEAPU8[($type256)];var $conv257=((($142))&255);var $cmp258=((($conv257))|0)==2;if(!($cmp258)){__label__=80;break $if_then249$$if_end268$105;}
var $143=$p;var $ph260=(($143+8)&4294967295);var $144=HEAP32[(($ph260)>>2)];var $phflags261=(($144+4)&4294967295);var $145=HEAP32[(($phflags261)>>2)];var $and262=($145)&16777216;var $tobool263=((($and262))|0)!=0;if($tobool263){__label__=80;break $if_then249$$if_end268$105;}
var $146=$p;var $prepause265=(($146+16)&4294967295);HEAP8[($prepause265)]=12;;}}while(0);var $147=$next;var $type269=(($147+15)&4294967295);var $148=HEAPU8[($type269)];var $conv270=((($148))&255);var $cmp271=((($conv270))|0)==2;if($cmp271){__label__=81;;}else{__label__=82;;}
if(__label__==81){$pre_sonorant=1;__label__=192;break $if_end15_thread$$if_end15$9;}
else if(__label__==82){var $149=$last_pitch;var $conv274=((($149))&255);var $150=$p;var $pitch2=(($150+21)&4294967295);HEAP8[($pitch2)]=$conv274;var $151=$prev;var $type275=(($151+15)&4294967295);var $152=HEAPU8[($type275)];var $conv276=((($152))&255);var $cmp277=((($conv276))|0)==2;if($cmp277){__label__=84;;}else{__label__=83;;}
$if_then282$$lor_lhs_false278$116:do{if(__label__==83){var $153=$prev;var $type279=(($153+15)&4294967295);var $154=HEAPU8[($type279)];var $conv280=((($154))&255);var $cmp281=((($conv280))|0)==3;if($cmp281){__label__=84;break $if_then282$$lor_lhs_false278$116;}
var $172=$ix;$ix2=$172;;while(1){var $173=$ix2;var $174=HEAP32[((_n_phoneme_list)>>2)];var $cmp315=((($173))|0)<((($174))|0);if(!($cmp315)){__label__=95;break $if_then282$$lor_lhs_false278$116;}
var $175=$ix2;var $arrayidx317=((_phoneme_list+$175*24)&4294967295);var $type318=(($arrayidx317+15)&4294967295);var $176=HEAPU8[($type318)];var $conv319=((($176))&255);var $cmp320=((($conv319))|0)==2;var $177=$ix2;if($cmp320){__label__=93;break;}
var $inc=((($177)+1)&4294967295);$ix2=$inc;__label__=91;continue;}
var $arrayidx322=((_phoneme_list+$177*24)&4294967295);var $pitch2323=(($arrayidx322+21)&4294967295);var $178=HEAP8[($pitch2323)];var $179=$p;var $pitch2324=(($179+21)&4294967295);HEAP8[($pitch2324)]=$178;__label__=95;break $if_then282$$lor_lhs_false278$116;}}while(0);$if_then282$$if_end326$124:do{if(__label__==84){var $155=$prev;var $length283=(($155+12)&4294967295);var $156=HEAP16[(($length283)>>1)];var $157=$p;var $length284=(($157+12)&4294967295);HEAP16[(($length284)>>1)]=$156;var $158=$p;var $type285=(($158+15)&4294967295);var $159=HEAPU8[($type285)];var $conv286=((($159))&255);var $cmp287=((($conv286))|0)==3;if($cmp287){__label__=85;;}else{__label__=86;;}
if(__label__==85){var $160=HEAP32[((__ZL6speed1)>>2)];var $conv289=((($160))&65535);var $161=$p;var $length290=(($161+12)&4294967295);HEAP16[(($length290)>>1)]=$conv289;;}
var $162=$next;var $type292=(($162+15)&4294967295);var $163=HEAPU8[($type292)];var $conv293=((($163))&255);var $cmp294=((($conv293))|0)==5;if($cmp294){__label__=87;;}else{__label__=88;;}
if(__label__==87){var $164=$p;var $length296=(($164+12)&4294967295);var $165=HEAP16[(($length296)>>1)];var $conv297=(tempInt=(($165)),(tempInt>=32768?tempInt-65536:tempInt));var $mul=((($conv297)*160)&4294967295);var $div298=((((($mul))|0)/100)|0);var $conv299=((($div298))&65535);var $166=$p;var $length300=(($166+12)&4294967295);HEAP16[(($length300)>>1)]=$conv299;;}
var $167=$next;var $type302=(($167+15)&4294967295);var $168=HEAPU8[($type302)];var $conv303=((($168))&255);var $cmp304=((($conv303))|0)==7;if(!($cmp304)){__label__=95;break $if_then282$$if_end326$124;}
var $169=$p;var $length306=(($169+12)&4294967295);var $170=HEAP16[(($length306)>>1)];var $conv307=(tempInt=(($170)),(tempInt>=32768?tempInt-65536:tempInt));var $mul308=((($conv307)*120)&4294967295);var $div309=((((($mul308))|0)/100)|0);var $conv310=((($div309))&65535);var $171=$p;var $length311=(($171+12)&4294967295);HEAP16[(($length311)>>1)]=$conv310;;}}while(0);var $180=$p;var $pitch2327=(($180+21)&4294967295);var $181=HEAPU8[($pitch2327)];var $conv328=((($181))&255);var $sub329=((($conv328)-16)&4294967295);var $conv330=((($sub329))&255);var $182=$p;var $pitch1331=(($182+20)&4294967295);HEAP8[($pitch1331)]=$conv330;var $183=$p;var $pitch2332=(($183+21)&4294967295);var $184=HEAPU8[($pitch2332)];var $conv333=((($184))&255);var $cmp334=((($conv333))|0)<16;if($cmp334){__label__=96;;}else{__label__=97;;}
if(__label__==96){var $185=$p;var $pitch1336=(($185+20)&4294967295);HEAP8[($pitch1336)]=0;;}
var $186=$p;var $env=(($186+14)&4294967295);HEAP8[($env)]=0;$pre_voiced=0;__label__=192;break $if_end15_thread$$if_end15$9;}}}}while(0);if(__label__==98){$min_drop=0;var $187=$ix;var $add340=((($187)+2)&4294967295);var $arrayidx341=((_phoneme_list+$add340*24)&4294967295);$next2=$arrayidx341;var $188=$ix;var $add342=((($188)+3)&4294967295);var $arrayidx343=((_phoneme_list+$add342*24)&4294967295);$next3=$arrayidx343;var $189=$stress;var $cmp344=((($189))|0)>7;if($cmp344){__label__=99;;}else{__label__=100;;}
$if_end346_thread$$if_end346$139:do{if(__label__==99){$stress=7;;}
else if(__label__==100){var $cmp347=((($189))|0)<=1;if(!($cmp347)){__label__=102;break $if_end346_thread$$if_end346$139;}
var $190=$stress;var $xor=($190)^1;$stress=$xor;;}}while(0);var $191=$pre_sonorant;var $tobool350=((($191))|0)!=0;var $192=$stress;var $193=$tr_addr;var $stress_amps352=(($193+660)&4294967295);var $arrayidx353=(($stress_amps352+$192)&4294967295);var $194=HEAPU8[($arrayidx353)];if($tobool350){__label__=103;;}else{__label__=104;;}
if(__label__==103){var $conv354=((($194))&255);var $sub355=((($conv354)-1)&4294967295);var $conv356=((($sub355))&255);var $195=$p;var $amp357=(($195+18)&4294967295);HEAP8[($amp357)]=$conv356;;}
else if(__label__==104){var $196=$p;var $amp361=(($196+18)&4294967295);HEAP8[($amp361)]=$194;;}
var $197=$emphasized;var $tobool363=((($197))|0)!=0;if($tobool363){__label__=106;;}else{__label__=107;;}
if(__label__==106){var $198=$p;var $amp365=(($198+18)&4294967295);HEAP8[($amp365)]=25;;}
var $199=$ix;var $200=HEAP32[((_n_phoneme_list)>>2)];var $sub367=((($200)-3)&4294967295);var $cmp368=((($199))|0)>=((($sub367))|0);if($cmp368){__label__=108;;}else{__label__=110;;}
$if_then369$$if_end382$151:do{if(__label__==108){var $201=$p;var $amp370=(($201+18)&4294967295);var $202=HEAPU8[($amp370)];var $conv371=((($202))&255);var $203=$tr_addr;var $langopts372=(($203)&4294967295);var $param=(($langopts372+24)&4294967295);var $arrayidx373=(($param+36)&4294967295);var $204=HEAP32[(($arrayidx373)>>2)];var $cmp374=((($conv371))|0)>((($204))|0);if(!($cmp374)){__label__=110;break $if_then369$$if_end382$151;}
var $205=$tr_addr;var $langopts376=(($205)&4294967295);var $param377=(($langopts376+24)&4294967295);var $arrayidx378=(($param377+36)&4294967295);var $206=HEAP32[(($arrayidx378)>>2)];var $conv379=((($206))&255);var $207=$p;var $amp380=(($207+18)&4294967295);HEAP8[($amp380)]=$conv379;;}}while(0);HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)]=0;$end_of_clause=0;var $208=$p;var $add_ptr=(($208+24)&4294967295);$p2=$add_ptr;var $209=$p2;var $newword3843=(($209+19)&4294967295);var $210=HEAPU8[($newword3843)];var $conv3854=((($210))&255);var $cmp3865=((($conv3854))|0)==0;var $211=$p2;if($cmp3865){__lastLabel__=110;__label__=111;;}else{__lastLabel__=110;__label__=117;;}
$for_body387$$for_end405$155:do{if(__label__==111){$for_body387$156:while(1){var $212=__lastLabel__==116?$224:($211);var $type388=(($212+15)&4294967295);var $213=HEAPU8[($type388)];var $conv389=((($213))&255);var $cmp390=((($conv389))|0)==2;if($cmp390){__label__=112;;}else{__label__=114;;}
$land_lhs_true391$$if_end398$158:do{if(__label__==112){var $214=$p2;var $ph392=(($214+8)&4294967295);var $215=HEAP32[(($ph392)>>2)];var $phflags393=(($215+4)&4294967295);var $216=HEAP32[(($phflags393)>>2)];var $and394=($216)&1048576;var $tobool395=((($and394))|0)!=0;if($tobool395){__label__=114;break $land_lhs_true391$$if_end398$158;}
var $217=HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)];var $inc397=((($217)+1)&4294967295);HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)]=$inc397;;}}while(0);var $218=$p2;var $ph399=(($218+8)&4294967295);var $219=HEAP32[(($ph399)>>2)];var $code=(($219+10)&4294967295);var $220=HEAPU8[($code)];var $conv400=((($220))&255);var $cmp401=((($conv400))|0)==27;if($cmp401){__label__=115;;}else{__label__=116;;}
if(__label__==115){$end_of_clause=2;;}
var $221=$p2;var $incdec_ptr=(($221+24)&4294967295);$p2=$incdec_ptr;var $222=$p2;var $newword384=(($222+19)&4294967295);var $223=HEAPU8[($newword384)];var $conv385=((($223))&255);var $cmp386=((($conv385))|0)==0;var $224=$p2;if($cmp386){__lastLabel__=116;__label__=111;continue $for_body387$156;}else{__lastLabel__=116;__label__=117;break $for_body387$$for_end405$155;}}}}while(0);var $_lcssa=__lastLabel__==110?$211:($224);var $ph406=(($_lcssa+8)&4294967295);var $225=HEAP32[(($ph406)>>2)];var $code407=(($225+10)&4294967295);var $226=HEAPU8[($code407)];var $conv408=((($226))&255);var $cmp409=((($conv408))|0)==27;if($cmp409){__label__=118;;}else{__label__=119;;}
if(__label__==118){$end_of_clause=2;;}
var $227=$p2;var $newword412=(($227+19)&4294967295);var $228=HEAPU8[($newword412)];var $conv413=((($228))&255);var $and414=($conv413)&2;var $tobool415=((($and414))|0)!=0;var $229=HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)];var $cmp417=((($229))|0)==0;var $or_cond=($tobool415)&($cmp417);if($or_cond){__label__=120;;}else{__label__=121;;}
if(__label__==120){$end_of_clause=2;;}
var $230=$next;var $ph420=(($230+8)&4294967295);var $231=HEAP32[(($ph420)>>2)];var $code421=(($231+10)&4294967295);var $232=HEAPU8[($code421)];var $conv422=((($232))&255);var $cmp423=((($conv422))|0)==23;if($cmp423){__label__=122;;}else{__label__=124;;}
$land_lhs_true424$$if_end431$172:do{if(__label__==122){var $233=$next2;var $type425=(($233+15)&4294967295);var $234=HEAPU8[($type425)];var $conv426=((($234))&255);var $cmp427=((($conv426))|0)==0;if(!($cmp427)){__label__=124;break $land_lhs_true424$$if_end431$172;}
var $235=$next2;$next=$235;var $236=$next3;$next2=$236;var $237=$ix;var $add429=((($237)+4)&4294967295);var $arrayidx430=((_phoneme_list+$add429*24)&4294967295);$next3=$arrayidx430;;}}while(0);var $238=HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)];var $cmp432=((($238))|0)==0;var $239=$next2;var $ph434=(($239+8)&4294967295);var $240=HEAP32[(($ph434)>>2)];var $length_mod435=(($240+15)&4294967295);var $241=HEAPU8[($length_mod435)];var $conv436=((($241))&255);var $mul437=((($conv436)*10)&4294967295);var $242=$next;var $ph438=(($242+8)&4294967295);var $243=HEAP32[(($ph438)>>2)];var $length_mod439=(($243+15)&4294967295);var $244=HEAPU8[($length_mod439)];var $conv440=((($244))&255);var $add441=((($conv440)+($mul437))&4294967295);var $245=$tr_addr;var $langopts442=(($245)&4294967295);if($cmp432){__label__=125;;}else{__label__=129;;}
$if_then433$$if_else466$176:do{if(__label__==125){var $length_mods0=(($langopts442+180)&4294967295);var $246=HEAP32[(($length_mods0)>>2)];var $arrayidx443=(($246+$add441)&4294967295);var $247=HEAPU8[($arrayidx443)];var $conv444=((($247))&255);$len=$conv444;var $248=$next;var $newword445=(($248+19)&4294967295);var $249=HEAP8[($newword445)];var $tobool446=(tempInt=(($249)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool446){__label__=126;;}else{__label__=128;;}
$land_lhs_true447$$if_else464$178:do{if(__label__==126){var $250=$tr_addr;var $langopts448=(($250)&4294967295);var $word_gap449=(($langopts448)&4294967295);var $251=HEAP32[(($word_gap449)>>2)];var $and450=($251)&32;var $tobool451=((($and450))|0)!=0;if(!($tobool451)){__label__=128;break $land_lhs_true447$$if_else464$178;}
var $252=$len;var $253=$next;var $ph453=(($253+8)&4294967295);var $254=HEAP32[(($ph453)>>2)];var $length_mod454=(($254+15)&4294967295);var $255=HEAPU8[($length_mod454)];var $conv455=((($255))&255);var $mul456=((($conv455)*10)&4294967295);var $add457=((($mul456)+1)&4294967295);var $256=$tr_addr;var $langopts458=(($256)&4294967295);var $length_mods0459=(($langopts458+180)&4294967295);var $257=HEAP32[(($length_mods0459)>>2)];var $arrayidx460=(($257+$add457)&4294967295);var $258=HEAPU8[($arrayidx460)];var $conv461=((($258))&255);var $add462=((($conv461)+($252))&4294967295);var $div463=((((($add462))|0)/2)|0);$length_mod=$div463;__label__=134;break $if_then433$$if_else466$176;}}while(0);var $259=$len;$length_mod=$259;;}
else if(__label__==129){var $length_mods=(($langopts442+176)&4294967295);var $260=HEAP32[(($length_mods)>>2)];var $arrayidx476=(($260+$add441)&4294967295);var $261=HEAPU8[($arrayidx476)];var $conv477=((($261))&255);$length_mod=$conv477;var $262=$next;var $type478=(($262+15)&4294967295);var $263=HEAPU8[($type478)];var $conv479=((($263))&255);var $cmp480=((($conv479))|0)==8;if(!($cmp480)){__label__=134;break $if_then433$$if_else466$176;}
var $264=$next2;var $type482=(($264+15)&4294967295);var $265=HEAPU8[($type482)];var $conv483=((($265))&255);var $cmp484=((($conv483))|0)==4;if($cmp484){__label__=132;;}else{__label__=131;;}
if(__label__==131){var $266=$next2;var $type486=(($266+15)&4294967295);var $267=HEAPU8[($type486)];var $conv487=((($267))&255);var $cmp488=((($conv487))|0)==5;if(!($cmp488)){__label__=134;break $if_then433$$if_else466$176;}}
var $268=$next3;var $ph490=(($268+8)&4294967295);var $269=HEAP32[(($ph490)>>2)];var $phflags491=(($269+4)&4294967295);var $270=HEAP32[(($phflags491)>>2)];var $and492=($270)&8;var $tobool493=((($and492))|0)!=0;if(!($tobool493)){__label__=134;break $if_then433$$if_else466$176;}
var $271=$length_mod;var $sub495=((($271)-15)&4294967295);$length_mod=$sub495;;}}while(0);var $272=HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)];var $cmp498=((($272))|0)==0;if($cmp498){__label__=135;;}else{__label__=136;;}
if(__label__==135){var $273=HEAP32[((__ZL6speed1)>>2)];var $274=$length_mod;var $mul500=((($274)*($273))&4294967295);$length_mod=$mul500;;}
else if(__label__==136){var $275=HEAP32[((__ZZ11CalcLengthsP10TranslatorE14more_syllables)>>2)];var $cmp502=((($275))|0)==1;if($cmp502){__label__=137;;}else{__label__=138;;}
if(__label__==137){var $276=HEAP32[((__ZL6speed2)>>2)];var $277=$length_mod;var $mul504=((($277)*($276))&4294967295);$length_mod=$mul504;;}
else if(__label__==138){var $278=HEAP32[((__ZL6speed3)>>2)];var $279=$length_mod;var $mul506=((($279)*($278))&4294967295);$length_mod=$mul506;;}}
var $280=$length_mod;var $div509=((((($280))|0)/128)|0);$length_mod=$div509;var $cmp510=((($div509))|0)<8;if($cmp510){__label__=140;;}else{__label__=141;;}
if(__label__==140){$length_mod=8;;}
var $281=$stress;var $cmp513=((($281))|0)>=7;if($cmp513){__label__=142;;}else{__label__=144;;}
$if_then514$$if_else520$199:do{if(__label__==142){var $282=$length_mod;var $add515=((($282)+20)&4294967295);$length_mod=$add515;var $283=$emphasized;var $tobool516=((($283))|0)!=0;if(!($tobool516)){__label__=146;break $if_then514$$if_else520$199;}
var $284=$length_mod;var $add518=((($284)+10)&4294967295);$length_mod=$add518;;}
else if(__label__==144){var $285=$emphasized;var $tobool521=((($285))|0)!=0;if(!($tobool521)){__label__=146;break $if_then514$$if_else520$199;}
var $286=$length_mod;var $add523=((($286)+20)&4294967295);$length_mod=$add523;;}}while(0);var $287=$stress;var $288=$tr_addr;var $stress_lengths=(($288+676)&4294967295);var $arrayidx526=(($stress_lengths+$287*2)&4294967295);var $289=HEAP16[(($arrayidx526)>>1)];var $conv527=(tempInt=(($289)),(tempInt>=32768?tempInt-65536:tempInt));$len=$conv527;var $cmp528=((($conv527))|0)==0;if($cmp528){__label__=147;;}else{__label__=148;;}
if(__label__==147){var $290=$tr_addr;var $stress_lengths530=(($290+676)&4294967295);var $arrayidx531=(($stress_lengths530+12)&4294967295);var $291=HEAP16[(($arrayidx531)>>1)];var $conv532=(tempInt=(($291)),(tempInt>=32768?tempInt-65536:tempInt));$len=$conv532;;}
var $292=$length_mod;var $293=$len;var $mul534=((($293)*($292))&4294967295);$length_mod=$mul534;var $294=$p;var $tone_ph=(($294+3)&4294967295);var $295=HEAPU8[($tone_ph)];var $conv535=((($295))&255);var $cmp536=((($conv535))|0)!=0;if($cmp536){__label__=149;;}else{__label__=151;;}
$if_then537$$if_end546$208:do{if(__label__==149){var $296=$p;var $tone_ph538=(($296+3)&4294967295);var $297=HEAPU8[($tone_ph538)];var $idxprom=((($297))&255);var $arrayidx539=((_phoneme_tab+$idxprom*4)&4294967295);var $298=HEAP32[(($arrayidx539)>>2)];var $std_length=(($298+14)&4294967295);var $299=HEAPU8[($std_length)];var $conv540=((($299))&255);$tone_mod=$conv540;var $cmp541=((($conv540))|0)>0;if(!($cmp541)){__label__=151;break $if_then537$$if_end546$208;}
var $300=$length_mod;var $301=$tone_mod;var $mul543=((($301)*($300))&4294967295);var $div544=((((($mul543))|0)/100)|0);$length_mod=$div544;;}}while(0);var $302=$end_of_clause;var $cmp547=((($302))|0)==2;if($cmp547){__label__=152;;}else{__label__=155;;}
if(__label__==152){var $303=$p;var $ph549=(($303+8)&4294967295);var $304=HEAP32[(($ph549)>>2)];var $std_length550=(($304+14)&4294967295);var $305=HEAPU8[($std_length550)];var $conv551=((($305))&255);var $mul552=((($conv551)*2)&4294967295);$len=$mul552;var $306=$tr_addr;var $langopts553=(($306)&4294967295);var $stress_flags=(($langopts553+12)&4294967295);var $307=HEAP32[(($stress_flags)>>2)];var $and554=($307)&262144;var $tobool555=((($and554))|0)!=0;if($tobool555){__label__=153;;}else{__label__=154;;}
if(__label__==153){$len=200;;}
var $308=$length_mod;var $309=$len;var $sub558=((280-($309))&4294967295);var $div559=((((($sub558))|0)/3)|0);var $add560=((($div559)+256)&4294967295);var $mul561=((($add560)*($308))&4294967295);var $div562=((((($mul561))|0)/256)|0);$length_mod=$div562;;}
var $310=$length_mod;var $311=$tr_addr;var $langopts564=(($311)&4294967295);var $max_lengthmod=(($langopts564+272)&4294967295);var $312=HEAP32[(($max_lengthmod)>>2)];var $313=HEAP32[((__ZL6speed1)>>2)];var $mul565=((($313)*($312))&4294967295);var $cmp566=((($310))|0)>((($mul565))|0);if($cmp566){__label__=156;;}else{__label__=157;;}
if(__label__==156){var $314=$tr_addr;var $langopts568=(($314)&4294967295);var $max_lengthmod569=(($langopts568+272)&4294967295);var $315=HEAP32[(($max_lengthmod569)>>2)];var $316=HEAP32[((__ZL6speed1)>>2)];var $mul570=((($316)*($315))&4294967295);$length_mod=$mul570;;}
var $317=$length_mod;var $div572=((((($317))|0)/128)|0);$length_mod=$div572;var $318=$p;var $type573=(($318+15)&4294967295);var $319=HEAPU8[($type573)];var $conv574=((($319))&255);var $cmp575=((($conv574))|0)!=2;if($cmp575){__label__=158;;}else{__label__=159;;}
if(__label__==158){$length_mod=256;$min_drop=16;;}
var $320=$length_mod;var $conv578=((($320))&65535);var $321=$p;var $length579=(($321+12)&4294967295);HEAP16[(($length579)>>1)]=$conv578;var $322=$p;var $env580=(($322+14)&4294967295);var $323=HEAPU8[($env580)];var $conv581=((($323))&255);var $cmp582=((($conv581))|0)>=19;if($cmp582){__label__=160;;}else{__label__=161;;}
if(__label__==160){var $324=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($324+12)&4294967295);var $325=HEAP32[(($_stderr)>>2)];var $326=_fwrite(((__str294)&4294967295),28,1,$325);var $327=$p;var $env584=(($327+14)&4294967295);HEAP8[($env584)]=0;;}
var $328=$p;var $env586=(($328+14)&4294967295);var $329=HEAPU8[($env586)];var $conv587=((($329))&255);var $add588=((($conv587)+1)&4294967295);$env2=$add588;var $330=$p;var $tone_ph589=(($330+3)&4294967295);var $331=HEAPU8[($tone_ph589)];var $conv590=((($331))&255);var $cmp591=((($conv590))|0)!=0;if($cmp591){__label__=162;;}else{__label__=163;;}
if(__label__==162){var $332=$p;var $tone_ph593=(($332+3)&4294967295);var $333=HEAPU8[($tone_ph593)];var $conv594=((($333))&255);__Z17InterpretPhoneme2iP12PHONEME_DATA($conv594,$phdata_tone);var $334=HEAP32[(($pitch_env595)>>2)];var $call596=__Z11GetEnvelopei($334);$pitch_env=$call596;;}
else if(__label__==163){var $335=$env2;var $arrayidx598=((_envelope_data+$335*4)&4294967295);var $336=HEAP32[(($arrayidx598)>>2)];$pitch_env=$336;;}
var $337=$p;var $pitch1600=(($337+20)&4294967295);var $338=HEAPU8[($pitch1600)];var $conv601=((($338))&255);var $339=$p;var $pitch2602=(($339+21)&4294967295);var $340=HEAPU8[($pitch2602)];var $conv603=((($340))&255);var $341=$p;var $pitch1604=(($341+20)&4294967295);var $342=HEAPU8[($pitch1604)];var $conv605=((($342))&255);var $sub606=((($conv603)-($conv605))&4294967295);var $343=$pitch_env;var $arrayidx607=(($343)&4294967295);var $344=HEAPU8[($arrayidx607)];var $conv608=((($344))&255);var $mul609=((($conv608)*($sub606))&4294967295);var $div610=((((($mul609))|0)/256)|0);var $add611=((($div610)+($conv601))&4294967295);$pitch_start=$add611;var $345=$pre_sonorant;var $tobool612=((($345))|0)!=0;if($tobool612){__lastLabel__=164;__label__=167;;}else{__lastLabel__=164;__label__=165;;}
$if_then615$$lor_lhs_false613$231:do{if(__label__==165){var $346=$pre_voiced;var $tobool614=((($346))|0)!=0;if(!($tobool614)){__label__=177;break $if_then615$$lor_lhs_false613$231;}
var $_pr2=$pitch_start;__lastLabel__=166;__label__=167;break $if_then615$$lor_lhs_false613$231;}}while(0);$if_then615$$if_end650$234:do{if(__label__==167){var $347=__lastLabel__==166?$_pr2:($add611);var $cmp616=((($347))|0)==255;if($cmp616){__label__=168;;}else{__label__=169;;}
if(__label__==168){var $348=$pitch_start;$last_pitch=$348;;}
var $349=$pitch_start;var $350=$last_pitch;var $sub619=((($349)-($350))&4294967295);var $cmp620=((($sub619))|0)>16;if($cmp620){__label__=170;;}else{__label__=171;;}
if(__label__==170){var $351=$pitch_start;var $sub622=((($351)-16)&4294967295);$last_pitch=$sub622;;}
var $352=$last_pitch;var $conv624=((($352))&255);var $353=$prev;var $pitch1625=(($353+20)&4294967295);HEAP8[($pitch1625)]=$conv624;var $354=$pitch_start;var $conv626=((($354))&255);var $355=$prev;var $pitch2627=(($355+21)&4294967295);HEAP8[($pitch2627)]=$conv626;var $356=$last_pitch;var $357=$pitch_start;var $cmp628=((($356))|0)<((($357))|0);var $358=$prev;var $env630=(($358+14)&4294967295);if($cmp628){__label__=172;;}else{__label__=173;;}
if(__label__==172){HEAP8[($env630)]=2;var $359=$env2;var $conv631=((($359))&255);var $360=$p;var $env632=(($360+14)&4294967295);HEAP8[($env632)]=$conv631;;}
else if(__label__==173){HEAP8[($env630)]=0;;}
var $361=$length_mod;var $conv636=((($361))&65535);var $362=$prev;var $length637=(($362+12)&4294967295);HEAP16[(($length637)>>1)]=$conv636;var $363=$p;var $amp638=(($363+18)&4294967295);var $364=HEAP8[($amp638)];var $365=$prev;var $amp639=(($365+18)&4294967295);HEAP8[($amp639)]=$364;var $366=$prev;var $type640=(($366+15)&4294967295);var $367=HEAPU8[($type640)];var $conv641=((($367))&255);var $cmp642=((($conv641))|0)!=3;if(!($cmp642)){__label__=177;break $if_then615$$if_end650$234;}
var $368=$prev;var $amp644=(($368+18)&4294967295);var $369=HEAPU8[($amp644)];var $conv645=((($369))&255);var $cmp646=((($conv645))|0)>18;if(!($cmp646)){__label__=177;break $if_then615$$if_end650$234;}
var $370=$prev;var $amp648=(($370+18)&4294967295);HEAP8[($amp648)]=18;;}}while(0);var $371=$next;var $synthflags651=(($371+4)&4294967295);var $372=HEAPU16[(($synthflags651)>>1)];var $conv652=((($372))&65535);var $and653=($conv652)&-2;var $conv654=((($and653))&65535);HEAP16[(($synthflags651)>>1)]=$conv654;var $373=$next;var $type655=(($373+15)&4294967295);var $374=HEAPU8[($type655)];var $conv656=((($374))&255);var $cmp657=((($conv656))|0)==8;if($cmp657){__label__=178;;}else{__label__=180;;}
$land_lhs_true658$$if_end666$249:do{if(__label__==178){var $375=$next2;var $type659=(($375+15)&4294967295);var $376=HEAPU8[($type659)];var $conv660=((($376))&255);var $cmp661=((($conv660))|0)!=2;if(!($cmp661)){__label__=180;break $land_lhs_true658$$if_end666$249;}
var $377=$next;var $synthflags663=(($377+4)&4294967295);var $378=HEAPU16[(($synthflags663)>>1)];var $conv664=((($378))&65535);var $or=($conv664)|1;var $conv665=((($or))&65535);HEAP16[(($synthflags663)>>1)]=$conv665;;}}while(0);var $379=$next;var $type667=(($379+15)&4294967295);var $380=HEAPU8[($type667)];var $conv668=((($380))&255);var $cmp669=((($conv668))|0)==3;if($cmp669){__label__=181;;}else{__label__=186;;}
$if_then670$$if_end697$253:do{if(__label__==181){var $381=$next;var $synthflags671=(($381+4)&4294967295);var $382=HEAPU16[(($synthflags671)>>1)];var $conv672=((($382))&65535);var $or673=($conv672)|1;var $conv674=((($or673))&65535);HEAP16[(($synthflags671)>>1)]=$conv674;var $383=$next2;var $type675=(($383+15)&4294967295);var $384=HEAPU8[($type675)];var $conv676=((($384))&255);var $cmp677=((($conv676))|0)==2;if($cmp677){__label__=182;;}else{__label__=183;;}
if(__label__==182){var $385=$next;var $synthflags679=(($385+4)&4294967295);var $386=HEAPU16[(($synthflags679)>>1)];var $conv680=((($386))&65535);var $and681=($conv680)&-2;var $conv682=((($and681))&65535);HEAP16[(($synthflags679)>>1)]=$conv682;;}
var $387=$next2;var $type684=(($387+15)&4294967295);var $388=HEAPU8[($type684)];var $conv685=((($388))&255);var $cmp686=((($conv685))|0)!=2;if(!($cmp686)){__label__=186;break $if_then670$$if_end697$253;}
var $389=$next;var $ph688=(($389+8)&4294967295);var $390=HEAP32[(($ph688)>>2)];var $mnemonic=(($390)&4294967295);var $391=HEAP32[(($mnemonic)>>2)];var $cmp689=((($391))|0)==12146;if(!($cmp689)){__label__=186;break $if_then670$$if_end697$253;}
var $392=$next;var $synthflags691=(($392+4)&4294967295);var $393=HEAPU16[(($synthflags691)>>1)];var $conv692=((($393))&65535);var $and693=($conv692)&-2;var $conv694=((($and693))&65535);HEAP16[(($synthflags691)>>1)]=$conv694;;}}while(0);var $394=$min_drop;var $cmp698=((($394))|0)>0;if($cmp698){__label__=187;;}else{__label__=191;;}
$land_lhs_true699$$if_end715$261:do{if(__label__==187){var $395=$p;var $pitch2700=(($395+21)&4294967295);var $396=HEAPU8[($pitch2700)];var $conv701=((($396))&255);var $397=$p;var $pitch1702=(($397+20)&4294967295);var $398=HEAPU8[($pitch1702)];var $conv703=((($398))&255);var $sub704=((($conv701)-($conv703))&4294967295);var $399=$min_drop;var $cmp705=((($sub704))|0)<((($399))|0);if(!($cmp705)){__label__=191;break $land_lhs_true699$$if_end715$261;}
var $400=$p;var $pitch2707=(($400+21)&4294967295);var $401=HEAPU8[($pitch2707)];var $conv708=((($401))&255);var $402=$min_drop;var $sub709=((($conv708)-($402))&4294967295);$pitch1=$sub709;var $403=$pitch1;var $cmp710=((($403))|0)<0;if($cmp710){__label__=189;;}else{__label__=190;;}
if(__label__==189){$pitch1=0;;}
var $404=$pitch1;var $conv713=((($404))&255);var $405=$p;var $pitch1714=(($405+20)&4294967295);HEAP8[($pitch1714)]=$conv713;;}}while(0);var $406=$p;var $pitch1716=(($406+20)&4294967295);var $407=HEAPU8[($pitch1716)];var $conv717=((($407))&255);var $408=$p;var $pitch2718=(($408+21)&4294967295);var $409=HEAPU8[($pitch2718)];var $conv719=((($409))&255);var $410=$p;var $pitch1720=(($410+20)&4294967295);var $411=HEAPU8[($pitch1720)];var $conv721=((($411))&255);var $sub722=((($conv719)-($conv721))&4294967295);var $412=$p;var $env723=(($412+14)&4294967295);var $413=HEAPU8[($env723)];var $idxprom724=((($413))&255);var $arrayidx725=((_envelope_data+$idxprom724*4)&4294967295);var $414=HEAP32[(($arrayidx725)>>2)];var $arrayidx726=(($414+127)&4294967295);var $415=HEAPU8[($arrayidx726)];var $conv727=((($415))&255);var $mul728=((($conv727)*($sub722))&4294967295);var $div729=((((($mul728))|0)/256)|0);var $add730=((($div729)+($conv717))&4294967295);$last_pitch=$add730;$pre_sonorant=0;$pre_voiced=0;;}
var $416=$ix;var $inc732=((($416)+1)&4294967295);$ix=$inc732;var $417=$ix;var $418=HEAP32[((_n_phoneme_list)>>2)];var $cmp=((($417))|0)<((($418))|0);if($cmp){__label__=2;continue $for_body$4;}else{__label__=193;break $for_body_lr_ph$$for_end733$2;}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __ZL11DoEmbedded2Pi($embix){;var __label__;var $embix_addr;var $word;$embix_addr=$embix;;while(1){var $0=$embix_addr;var $1=HEAP32[(($0)>>2)];var $inc=((($1)+1)&4294967295);HEAP32[(($0)>>2)]=$inc;var $arrayidx=((_embedded_list+$1*4)&4294967295);var $2=HEAP32[(($arrayidx)>>2)];$word=$2;var $3=$word;var $and=($3)&31;var $cmp=((($and))|0)==2;if($cmp){__label__=2;;}else{__label__=3;;}
if(__label__==2){var $4=$word;var $and1=($4)&127;var $5=$word;var $shr=($5)>>>8;__Z11SetEmbeddedii($and1,$shr);__Z8SetSpeedi(1);;}
var $6=$word;var $and2=($6)&128;var $cmp3=((($and2))|0)==0;if($cmp3){__label__=1;continue;}else{__label__=4;break;}};return;return;}
function __Z20LookupAccentedLetterP10TranslatorjPc($tr,$letter,$ph_buf){var __stackBase__=STACKTOP;STACKTOP+=128;_memset(__stackBase__,0,128);var __label__;var __lastLabel__=null;var $tr_addr;var $letter_addr;var $ph_buf_addr;var $accent_data;var $accent1;var $accent2;var $basic_letter;var $letter2;var $ph_letter1=__stackBase__;var $ph_letter2=__stackBase__+32;var $ph_accent1=__stackBase__+64;var $ph_accent2=__stackBase__+96;$tr_addr=$tr;$letter_addr=$letter;$ph_buf_addr=$ph_buf;$accent_data=0;$accent1=0;$accent2=0;$letter2=0;var $arrayidx=(($ph_accent2)&4294967295);HEAP8[($arrayidx)]=0;var $0=$letter_addr;var $cmp=((($0))>>>0)>=224;var $1=$letter_addr;var $cmp1=((($1))>>>0)<383;var $or_cond=($cmp)&($cmp1);var $2=$letter_addr;if($or_cond){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $sub=((($2)-224)&4294967295);var $arrayidx2=((__ZL18letter_accents_0e0+$sub*2)&4294967295);var $3=HEAPU16[(($arrayidx2)>>1)];var $conv=((($3))&65535);$accent_data=$conv;__lastLabel__=1;;}
else if(__label__==2){var $cmp3=((($2))>>>0)>=592;var $4=$letter_addr;var $cmp5=((($4))>>>0)<=680;var $or_cond1=($cmp3)&($cmp5);if($or_cond1){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $5=$letter_addr;var $sub7=((($5)-592)&4294967295);var $arrayidx8=((__ZL18letter_accents_250+$sub7*2)&4294967295);var $6=HEAPU16[(($arrayidx8)>>1)];var $conv9=((($6))&65535);$accent_data=$conv9;__lastLabel__=3;;}
else if(__label__==4){var $_pr=$accent_data;__lastLabel__=4;;}}
var $7=__lastLabel__==4?$_pr:(__lastLabel__==3?$conv9:($conv));var $cmp11=((($7))|0)!=0;if($cmp11){__label__=6;;}else{__label__=24;;}
$if_then12$$if_end91$9:do{if(__label__==6){var $8=$accent_data;var $and=($8)&63;var $add=((($and)+59)&4294967295);$basic_letter=$add;var $9=$basic_letter;var $cmp13=((($9))|0)<97;if($cmp13){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $10=$basic_letter;var $sub15=((($10)-59)&4294967295);var $arrayidx16=((__ZL13non_ascii_tab+$sub15*2)&4294967295);var $11=HEAP16[(($arrayidx16)>>1)];var $conv17=(tempInt=(($11)),(tempInt>=32768?tempInt-65536:tempInt));$basic_letter=$conv17;;}
var $12=$accent_data;var $and19=($12)&32768;var $tobool=((($and19))|0)!=0;var $13=$accent_data;var $shr=($13)>>6;if($tobool){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $and21=($shr)&63;$letter2=$and21;var $14=$letter2;var $add22=((($14)+59)&4294967295);$letter2=$add22;var $15=$accent_data;var $shr23=($15)>>12;var $and24=($shr23)&7;$accent2=$and24;;}
else if(__label__==10){var $and27=($shr)&31;$accent1=$and27;var $16=$accent_data;var $shr28=($16)>>11;var $and29=($shr28)&15;$accent2=$and29;;}
var $17=$tr_addr;var $18=$accent1;var $arrayidx31=((__ZL11accents_tab+$18*8)&4294967295);var $name=(($arrayidx31)&4294967295);var $19=HEAP32[(($name)>>2)];var $arraydecay=(($ph_accent1)&4294967295);var $call=__Z6LookupP10TranslatorPKcPc($17,$19,$arraydecay);var $cmp32=((($call))|0)!=0;if(!($cmp32)){__label__=24;break $if_then12$$if_end91$9;}
var $20=$tr_addr;var $21=$basic_letter;var $arraydecay34=(($ph_letter1)&4294967295);var $call35=__ZL13LookupLetter2P10TranslatorjPc($20,$21,$arraydecay34);var $cmp36=((($call35))|0)!=0;if(!($cmp36)){__label__=24;break $if_then12$$if_end91$9;}
var $22=$accent2;var $cmp38=((($22))|0)!=0;if($cmp38){__label__=14;;}else{__label__=16;;}
$if_then39$$if_end56$20:do{if(__label__==14){var $23=$tr_addr;var $24=$accent2;var $arrayidx40=((__ZL11accents_tab+$24*8)&4294967295);var $name41=(($arrayidx40)&4294967295);var $25=HEAP32[(($name41)>>2)];var $arraydecay42=(($ph_accent2)&4294967295);var $call43=__Z6LookupP10TranslatorPKcPc($23,$25,$arraydecay42);var $26=$accent2;var $arrayidx47=((__ZL11accents_tab+$26*8)&4294967295);var $flags=(($arrayidx47+4)&4294967295);var $27=HEAP32[(($flags)>>2)];var $and48=($27)&1;var $tobool49=((($and48))|0)!=0;if(!($tobool49)){__label__=16;break $if_then39$$if_end56$20;}
var $28=$ph_buf_addr;var $arraydecay51=(($ph_accent2)&4294967295);var $call52=_strcpy($28,$arraydecay51);var $29=$ph_buf_addr;var $call53=_strlen($29);var $30=$ph_buf_addr;var $add_ptr=(($30+$call53)&4294967295);$ph_buf_addr=$add_ptr;var $arrayidx54=(($ph_accent2)&4294967295);HEAP8[($arrayidx54)]=0;;}}while(0);var $31=$letter2;var $cmp57=((($31))|0)!=0;if($cmp57){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $32=$tr_addr;var $33=$letter2;var $arraydecay59=(($ph_letter2)&4294967295);var $call60=__ZL13LookupLetter2P10TranslatorjPc($32,$33,$arraydecay59);var $34=$ph_buf_addr;var $arraydecay61=(($ph_accent1)&4294967295);var $arraydecay62=(($ph_letter1)&4294967295);var $arraydecay63=(($ph_letter2)&4294967295);var $arraydecay64=(($ph_accent2)&4294967295);var $call65=_sprintf($34,((__str297)&4294967295),allocate([$arraydecay61,0,0,0,23,0,0,0,$arraydecay62,0,0,0,6,0,0,0,$arraydecay63,0,0,0,$arraydecay64,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==18){var $35=$accent1;var $cmp67=((($35))|0)==0;if($cmp67){__label__=19;;}else{__label__=20;;}
if(__label__==19){var $36=$ph_buf_addr;var $arraydecay69=(($ph_letter1)&4294967295);var $call70=_strcpy($36,$arraydecay69);;}
else if(__label__==20){var $37=$tr_addr;var $langopts=(($37)&4294967295);var $accents=(($langopts+220)&4294967295);var $38=HEAP32[(($accents)>>2)];var $and72=($38)&1;var $tobool73=((($and72))|0)!=0;if($tobool73){__label__=22;;}else{__label__=21;;}
$if_then78$$lor_lhs_false$30:do{if(__label__==21){var $39=$accent1;var $arrayidx74=((__ZL11accents_tab+$39*8)&4294967295);var $flags75=(($arrayidx74+4)&4294967295);var $40=HEAP32[(($flags75)>>2)];var $and76=($40)&1;var $tobool77=((($and76))|0)!=0;if($tobool77){__label__=22;break $if_then78$$lor_lhs_false$30;}
var $42=$ph_buf_addr;var $arraydecay83=(($ph_letter1)&4294967295);var $arraydecay84=(($ph_accent1)&4294967295);var $call85=_sprintf($42,((__str2299)&4294967295),allocate([4,0,0,0,$arraydecay83,0,0,0,23,0,0,0,$arraydecay84,0,0,0,23,0,0,0],["i32",0,0,0,"i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));__label__=24;break $if_then12$$if_end91$9;}}while(0);var $41=$ph_buf_addr;var $arraydecay79=(($ph_accent1)&4294967295);var $arraydecay80=(($ph_letter1)&4294967295);var $call81=_sprintf($41,((__str1298)&4294967295),allocate([$arraydecay79,0,0,0,23,0,0,0,6,0,0,0,$arraydecay80,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __ZL13LookupLetter2P10TranslatorjPc($tr,$letter,$ph_buf){var __stackBase__=STACKTOP;STACKTOP+=12;_memset(__stackBase__,0,12);var __label__;var $tr_addr;var $letter_addr;var $ph_buf_addr;var $len;var $single_letter=__stackBase__;$tr_addr=$tr;$letter_addr=$letter;$ph_buf_addr=$ph_buf;var $arrayidx=(($single_letter)&4294967295);HEAP8[($arrayidx)]=0;var $arrayidx1=(($single_letter+1)&4294967295);HEAP8[($arrayidx1)]=95;var $0=$letter_addr;var $arrayidx2=(($single_letter+2)&4294967295);var $call=__Z8utf8_outjPc($0,$arrayidx2);$len=$call;var $1=$len;var $add=((($1)+2)&4294967295);var $arrayidx3=(($single_letter+$add)&4294967295);HEAP8[($arrayidx3)]=32;var $2=$len;var $add4=((($2)+3)&4294967295);var $arrayidx5=(($single_letter+$add4)&4294967295);HEAP8[($arrayidx5)]=0;var $3=$tr_addr;var $arrayidx6=(($single_letter+1)&4294967295);var $4=$ph_buf_addr;var $call7=__Z6LookupP10TranslatorPKcPc($3,$arrayidx6,$4);var $cmp=((($call7))|0)==0;if($cmp){__label__=1;;}else{__label__=3;;}
$if_then$$if_end15$2:do{if(__label__==1){var $arrayidx8=(($single_letter+1)&4294967295);HEAP8[($arrayidx8)]=32;var $5=$tr_addr;var $arrayidx9=(($single_letter+2)&4294967295);var $6=$ph_buf_addr;var $call10=__Z6LookupP10TranslatorPKcPc($5,$arrayidx9,$6);var $cmp11=((($call10))|0)==0;if(!($cmp11)){__label__=3;break $if_then$$if_end15$2;}
var $7=$tr_addr;var $arrayidx13=(($single_letter+2)&4294967295);var $8=$ph_buf_addr;var $call14=__Z14TranslateRulesP10TranslatorPcS1_iS1_iPj($7,$arrayidx13,$8,20,0,0,0);;}}while(0);var $9=$ph_buf_addr;var $arrayidx16=(($9)&4294967295);var $10=HEAP8[($arrayidx16)];var $conv=(tempInt=(($10)),(tempInt>=128?tempInt-256:tempInt));STACKTOP=__stackBase__;return $conv;return null;}
function __Z12LookupLetterP10TranslatorjiPci($tr,$letter,$next_byte,$ph_buf1,$control){var __stackBase__=STACKTOP;STACKTOP+=48;_memset(__stackBase__,0,48);var __label__;var $tr_addr;var $letter_addr;var $next_byte_addr;var $ph_buf1_addr;var $control_addr;var $len;var $dict_flags=__stackBase__;var $ph_buf3=__stackBase__+8;var $ptr;$tr_addr=$tr;$letter_addr=$letter;$next_byte_addr=$next_byte;$ph_buf1_addr=$ph_buf1;$control_addr=$control;var $0=$ph_buf1_addr;var $arrayidx=(($0)&4294967295);HEAP8[($arrayidx)]=0;var $1=$letter_addr;var $call=__Z8utf8_outjPc($1,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+2)&4294967295));$len=$call;var $2=$len;var $add=((($2)+2)&4294967295);var $arrayidx1=((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+$add)&4294967295);HEAP8[($arrayidx1)]=32;var $3=$next_byte_addr;var $cmp=((($3))|0)==-1;if($cmp){__label__=1;;}else{__label__=7;;}
$if_then$$if_end19$2:do{if(__label__==1){var $4=$tr_addr;var $5=$ph_buf1_addr;var $call2=__Z6LookupP10TranslatorPKcPc($4,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+2)&4294967295),$5);var $cmp3=((($call2))|0)!=0;if($cmp3){__label__=20;break $if_then$$if_end19$2;}
HEAP8[(((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295))]=95;var $6=$tr_addr;var $arraydecay=(($ph_buf3)&4294967295);var $call5=__Z6LookupP10TranslatorPKcPc($6,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295),$arraydecay);var $cmp6=((($call5))|0)!=0;if($cmp6){__label__=20;break $if_then$$if_end19$2;}
var $7=$tr_addr;var $translator_name=(($7+280)&4294967295);var $8=HEAP32[(($translator_name)>>2)];var $cmp9=((($8))|0)==25966;if($cmp9){__label__=20;break $if_then$$if_end19$2;}
var $call12=__Z14SetTranslator2PKc(((__str52704)&4294967295));var $9=HEAP32[((_translator2)>>2)];var $arraydecay13=(($ph_buf3)&4294967295);var $call14=__Z6LookupP10TranslatorPKcPc($9,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+2)&4294967295),$arraydecay13);var $cmp15=((($call14))|0)!=0;if($cmp15){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $10=$ph_buf1_addr;HEAP8[($10)]=21;var $nul=(($10+1)&4294967295);HEAP8[($nul)]=0;;}
var $11=HEAP32[((_voice)>>2)];var $phoneme_tab_ix=(($11+40)&4294967295);var $12=HEAP32[(($phoneme_tab_ix)>>2)];__Z18SelectPhonemeTablei($12);;}
else if(__label__==7){var $13=$letter_addr;var $cmp20=((($13))>>>0)<=32;if($cmp20){__label__=9;;}else{__label__=8;;}
$if_then22$$lor_lhs_false$11:do{if(__label__==8){var $14=$letter_addr;var $call21=_iswspace($14);var $tobool=((($call21))|0)!=0;if($tobool){__label__=9;break $if_then22$$lor_lhs_false$11;}
var $18=$next_byte_addr;var $cmp26=((($18))|0)!=32;if($cmp26){__label__=11;;}else{__label__=12;;}
if(__label__==11){$next_byte_addr=31;;}
var $19=$next_byte_addr;var $conv=((($19))&255);var $20=$len;var $add29=((($20)+3)&4294967295);var $arrayidx30=((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+$add29)&4294967295);HEAP8[($arrayidx30)]=$conv;HEAP8[(((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295))]=95;var $arrayidx31=(($dict_flags+4)&4294967295);HEAP32[(($arrayidx31)>>2)]=0;$ptr=((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295);var $21=$tr_addr;var $arraydecay32=(($ph_buf3)&4294967295);var $call33=__Z6LookupP10TranslatorPKcPc($21,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295),$arraydecay32);var $cmp34=((($call33))|0)==0;if($cmp34){__label__=13;;}else{__label__=15;;}
$if_then35$$if_end43$17:do{if(__label__==13){HEAP8[(((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295))]=32;var $22=$tr_addr;var $arraydecay36=(($ph_buf3)&4294967295);var $call37=__Z6LookupP10TranslatorPKcPc($22,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+2)&4294967295),$arraydecay36);var $cmp38=((($call37))|0)==0;if(!($cmp38)){__label__=15;break $if_then35$$if_end43$17;}
var $23=$tr_addr;var $arraydecay40=(($ph_buf3)&4294967295);var $call41=__Z14TranslateRulesP10TranslatorPcS1_iS1_iPj($23,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+2)&4294967295),$arraydecay40,40,0,268435456,0);;}}while(0);var $arrayidx44=(($ph_buf3)&4294967295);var $24=HEAP8[($arrayidx44)];var $conv45=(tempInt=(($24)),(tempInt>=128?tempInt-256:tempInt));var $cmp46=((($conv45))|0)==0;if($cmp46){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $25=$tr_addr;var $26=$letter_addr;var $arraydecay48=(($ph_buf3)&4294967295);__Z20LookupAccentedLetterP10TranslatorjPc($25,$26,$arraydecay48);;}
var $27=$ph_buf1_addr;var $arraydecay50=(($ph_buf3)&4294967295);var $call51=_strcpy($27,$arraydecay50);var $28=$ph_buf1_addr;var $arrayidx52=(($28)&4294967295);var $29=HEAP8[($arrayidx52)];var $conv53=(tempInt=(($29)),(tempInt>=128?tempInt-256:tempInt));var $cmp54=((($conv53))|0)==0;if($cmp54){__label__=20;break $if_then$$if_end19$2;}
var $30=$ph_buf1_addr;var $arrayidx56=(($30)&4294967295);var $31=HEAP8[($arrayidx56)];var $conv57=(tempInt=(($31)),(tempInt>=128?tempInt-256:tempInt));var $cmp58=((($conv57))|0)==21;if($cmp58){__label__=20;break $if_then$$if_end19$2;}
var $arrayidx61=(($dict_flags)&4294967295);HEAP32[(($arrayidx61)>>2)]=0;var $arrayidx62=(($dict_flags+4)&4294967295);HEAP32[(($arrayidx62)>>2)]=0;var $32=$tr_addr;var $33=$ph_buf1_addr;var $arraydecay63=(($dict_flags)&4294967295);var $34=$control_addr;var $and=($34)&1;__Z13SetWordStressP10TranslatorPcPjii($32,$33,$arraydecay63,-1,$and);__label__=20;break $if_then$$if_end19$2;}}while(0);var $15=$letter_addr;var $call23=_sprintf(((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295),((__str5302)&4294967295),allocate([$15,0,0,0],["i32",0,0,0],ALLOC_STACK));var $16=$tr_addr;var $17=$ph_buf1_addr;var $call24=__Z6LookupP10TranslatorPKcPc($16,((__ZZ12LookupLetterP10TranslatorjiPciE13single_letter+1)&4294967295),$17);;}}while(0);STACKTOP=__stackBase__;return;return;}
function __Z15TranslateLetterP10TranslatorPcS1_i($tr,$word,$phonemes,$control){var __stackBase__=STACKTOP;STACKTOP+=152;_memset(__stackBase__,0,152);var __label__;var $retval;var $tr_addr;var $word_addr;var $phonemes_addr;var $control_addr;var $n_bytes;var $letter=__stackBase__;var $len;var $save_option_phonemes;var $p2;var $pbuf;var $capital=__stackBase__+4;var $ph_buf=__stackBase__+24;var $ph_buf2=__stackBase__+84;var $hexbuf=__stackBase__+144;$tr_addr=$tr;$word_addr=$word;$phonemes_addr=$phonemes;$control_addr=$control;var $arrayidx=(($ph_buf)&4294967295);HEAP8[($arrayidx)]=0;var $arrayidx1=(($capital)&4294967295);HEAP8[($arrayidx1)]=0;var $0=$word_addr;var $call=__Z7utf8_inPiPKc($letter,$0);$n_bytes=$call;var $1=HEAP32[(($letter)>>2)];var $and=($1)&1048320;var $cmp=((($and))|0)==57344;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $2=HEAP32[(($letter)>>2)];var $and2=($2)&255;HEAP32[(($letter)>>2)]=$and2;;}
var $3=$control_addr;var $and3=($3)&2;var $tobool=((($and3))|0)!=0;if($tobool){__label__=3;;}else{__label__=5;;}
$if_then4$$if_end10$5:do{if(__label__==3){var $4=HEAP32[(($letter)>>2)];var $call5=_iswupper($4);var $tobool6=((($call5))|0)!=0;if(!($tobool6)){__label__=5;break $if_then4$$if_end10$5;}
var $5=$tr_addr;var $arraydecay=(($capital)&4294967295);var $call8=__Z6LookupP10TranslatorPKcPc($5,((__str6303)&4294967295),$arraydecay);;}}while(0);var $6=HEAP32[(($letter)>>2)];var $call11=__Z9towlower2j($6);HEAP32[(($letter)>>2)]=$call11;var $7=$tr_addr;var $8=HEAP32[(($letter)>>2)];var $9=$n_bytes;var $10=$word_addr;var $arrayidx12=(($10+$9)&4294967295);var $11=HEAP8[($arrayidx12)];var $conv=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $arraydecay13=(($ph_buf)&4294967295);var $12=$control_addr;var $and14=($12)&1;__Z12LookupLetterP10TranslatorjiPci($7,$8,$conv,$arraydecay13,$and14);var $arrayidx15=(($ph_buf)&4294967295);var $13=HEAP8[($arrayidx15)];var $conv16=(tempInt=(($13)),(tempInt>=128?tempInt-256:tempInt));var $cmp17=((($conv16))|0)==21;if($cmp17){__label__=6;;}else{__label__=7;;}
$if_then18$$if_end21$9:do{if(__label__==6){var $14=$phonemes_addr;var $arraydecay19=(($ph_buf)&4294967295);var $call20=_strcpy($14,$arraydecay19);$retval=0;;}
else if(__label__==7){var $arrayidx22=(($ph_buf)&4294967295);var $15=HEAP8[($arrayidx22)];var $conv23=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));var $cmp24=((($conv23))|0)==0;if($cmp24){__label__=8;;}else{__label__=11;;}
$land_lhs_true$$if_end38$12:do{if(__label__==8){var $16=$tr_addr;var $translator_name=(($16+280)&4294967295);var $17=HEAP32[(($translator_name)>>2)];var $cmp25=((($17))|0)!=25966;if(!($cmp25)){__label__=11;break $land_lhs_true$$if_end38$12;}
var $call27=__Z14SetTranslator2PKc(((__str52704)&4294967295));var $18=HEAP32[((_option_phonemes)>>2)];$save_option_phonemes=$18;HEAP32[((_option_phonemes)>>2)]=0;var $19=HEAP32[((_translator2)>>2)];var $20=HEAP32[(($letter)>>2)];var $21=$n_bytes;var $22=$word_addr;var $arrayidx28=(($22+$21)&4294967295);var $23=HEAP8[($arrayidx28)];var $conv29=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt));var $arraydecay30=(($ph_buf)&4294967295);var $24=$control_addr;var $and31=($24)&1;__Z12LookupLetterP10TranslatorjiPci($19,$20,$conv29,$arraydecay30,$and31);var $25=HEAP32[((_voice)>>2)];var $phoneme_tab_ix=(($25+40)&4294967295);var $26=HEAP32[(($phoneme_tab_ix)>>2)];__Z18SelectPhonemeTablei($26);var $27=$save_option_phonemes;HEAP32[((_option_phonemes)>>2)]=$27;var $arrayidx32=(($ph_buf)&4294967295);var $28=HEAP8[($arrayidx32)];var $conv33=(tempInt=(($28)),(tempInt>=128?tempInt-256:tempInt));var $cmp34=((($conv33))|0)!=0;if(!($cmp34)){__label__=11;break $land_lhs_true$$if_end38$12;}
var $29=$phonemes_addr;var $call36=_sprintf($29,((__str7304)&4294967295),allocate([21,0,0,0],["i32",0,0,0],ALLOC_STACK));$retval=0;__label__=26;break $if_then18$$if_end21$9;}}while(0);var $arrayidx39=(($ph_buf)&4294967295);var $30=HEAP8[($arrayidx39)];var $conv40=(tempInt=(($30)),(tempInt>=128?tempInt-256:tempInt));var $cmp41=((($conv40))|0)==0;if($cmp41){__label__=12;;}else{__label__=20;;}
$if_then42$$if_end73$17:do{if(__label__==12){var $31=HEAP32[(($letter)>>2)];var $call43=_iswalpha($31);var $tobool44=((($call43))|0)!=0;if($tobool44){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $32=$tr_addr;var $arraydecay46=(($ph_buf)&4294967295);var $call47=__Z6LookupP10TranslatorPKcPc($32,((__str8305)&4294967295),$arraydecay46);;}
var $arrayidx49=(($ph_buf)&4294967295);var $33=HEAP8[($arrayidx49)];var $conv50=(tempInt=(($33)),(tempInt>=128?tempInt-256:tempInt));var $cmp51=((($conv50))|0)==0;if($cmp51){__label__=15;;}else{__label__=17;;}
$land_lhs_true52$$if_end58$22:do{if(__label__==15){var $34=HEAP32[(($letter)>>2)];var $call53=_iswspace($34);var $tobool54=((($call53))|0)!=0;if($tobool54){__label__=17;break $land_lhs_true52$$if_end58$22;}
var $35=$tr_addr;var $arraydecay56=(($ph_buf)&4294967295);var $call57=__Z6LookupP10TranslatorPKcPc($35,((__str9306)&4294967295),$arraydecay56);;}}while(0);var $arrayidx59=(($ph_buf)&4294967295);var $36=HEAP8[($arrayidx59)];var $conv60=(tempInt=(($36)),(tempInt>=128?tempInt-256:tempInt));var $cmp61=((($conv60))|0)!=0;if(!($cmp61)){__label__=20;break $if_then42$$if_end73$17;}
var $arraydecay63=(($hexbuf)&4294967295);var $37=HEAP32[(($letter)>>2)];var $call64=_sprintf($arraydecay63,((__str10307)&4294967295),allocate([$37,0,0,0],["i32",0,0,0],ALLOC_STACK));var $arraydecay65=(($ph_buf)&4294967295);$pbuf=$arraydecay65;var $arraydecay66=(($hexbuf)&4294967295);$p2=$arraydecay66;var $38=$p2;var $39=HEAP8[($38)];var $conv671=(tempInt=(($39)),(tempInt>=128?tempInt-256:tempInt));var $cmp682=((($conv671))|0)!=0;if(!($cmp682)){__label__=20;break $if_then42$$if_end73$17;}
while(1){var $40=$pbuf;var $call69=_strlen($40);var $41=$pbuf;var $add_ptr=(($41+$call69)&4294967295);$pbuf=$add_ptr;var $42=$pbuf;var $incdec_ptr=(($42+1)&4294967295);$pbuf=$incdec_ptr;HEAP8[($42)]=23;var $43=$tr_addr;var $44=$p2;var $45=HEAP8[($44)];var $conv70=(tempInt=(($45)),(tempInt>=128?tempInt-256:tempInt));var $46=$pbuf;__Z12LookupLetterP10TranslatorjiPci($43,$conv70,0,$46,1);var $47=$p2;var $incdec_ptr71=(($47+1)&4294967295);$p2=$incdec_ptr71;var $48=$p2;var $49=HEAP8[($48)];var $conv67=(tempInt=(($49)),(tempInt>=128?tempInt-256:tempInt));var $cmp68=((($conv67))|0)!=0;if($cmp68){__label__=19;continue;}else{__label__=20;break $if_then42$$if_end73$17;}}}}while(0);var $50=$phonemes_addr;var $call74=_strlen($50);$len=$call74;var $51=$tr_addr;var $langopts=(($51)&4294967295);var $accents=(($langopts+220)&4294967295);var $52=HEAP32[(($accents)>>2)];var $and75=($52)&2;var $tobool76=((($and75))|0)!=0;var $arraydecay78=(($ph_buf2)&4294967295);if($tobool76){__label__=21;;}else{__label__=22;;}
if(__label__==21){var $arraydecay79=(($ph_buf)&4294967295);var $arraydecay80=(($capital)&4294967295);var $call81=_sprintf($arraydecay78,((__str11308)&4294967295),allocate([255,0,0,0,$arraydecay79,0,0,0,$arraydecay80,0,0,0],["i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==22){var $arraydecay83=(($capital)&4294967295);var $arraydecay84=(($ph_buf)&4294967295);var $call85=_sprintf($arraydecay78,((__str11308)&4294967295),allocate([255,0,0,0,$arraydecay83,0,0,0,$arraydecay84,0,0,0],["i32",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
var $53=$len;var $arraydecay87=(($ph_buf2)&4294967295);var $call88=_strlen($arraydecay87);var $add=((($call88)+($53))&4294967295);var $cmp89=((($add))>>>0)<160;if($cmp89){__label__=24;;}else{__label__=25;;}
if(__label__==24){var $54=$len;var $55=$phonemes_addr;var $arrayidx91=(($55+$54)&4294967295);var $arraydecay92=(($ph_buf2)&4294967295);var $call93=_strcpy($arrayidx91,$arraydecay92);;}
var $56=$n_bytes;$retval=$56;;}}while(0);var $57=$retval;STACKTOP=__stackBase__;return $57;return null;}
function __Z17SetSpellingStressP10TranslatorPcii($tr,$phonemes,$control,$n_chars){var __stackBase__=STACKTOP;STACKTOP+=160;_memset(__stackBase__,0,160);var __label__;var __lastLabel__=null;var $tr_addr;var $phonemes_addr;var $control_addr;var $n_chars_addr;var $ix;var $c;var $n_stress;var $count;var $buf=__stackBase__;$tr_addr=$tr;$phonemes_addr=$phonemes;$control_addr=$control;$n_chars_addr=$n_chars;$n_stress=0;$ix=0;var $0=$ix;var $1=$phonemes_addr;var $arrayidx4=(($1+$0)&4294967295);var $2=HEAP8[($arrayidx4)];var $conv5=(tempInt=(($2)),(tempInt>=128?tempInt-256:tempInt));$c=$conv5;var $cmp6=((($conv5))|0)!=0;if($cmp6){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=4;;}
$for_body$$for_end$2:do{if(__label__==1){while(1){var $3=__lastLabel__==0?$conv5:($conv);var $cmp1=((($3))|0)==6;if($cmp1){__label__=2;;}else{__label__=3;;}
if(__label__==2){var $4=$n_stress;var $inc=((($4)+1)&4294967295);$n_stress=$inc;;}
var $5=$c;var $conv2=((($5))&255);var $6=$ix;var $arrayidx3=(($buf+$6)&4294967295);HEAP8[($arrayidx3)]=$conv2;var $7=$ix;var $inc4=((($7)+1)&4294967295);$ix=$inc4;var $8=$ix;var $9=$phonemes_addr;var $arrayidx=(($9+$8)&4294967295);var $10=HEAP8[($arrayidx)];var $conv=(tempInt=(($10)),(tempInt>=128?tempInt-256:tempInt));$c=$conv;var $cmp=((($conv))|0)!=0;if($cmp){__lastLabel__=3;__label__=1;continue;}else{__lastLabel__=3;__label__=4;break $for_body$$for_end$2;}}}}while(0);var $11=$ix;var $arrayidx5=(($buf+$11)&4294967295);HEAP8[($arrayidx5)]=0;$count=0;$ix=0;var $12=$ix;var $arrayidx71=(($buf+$12)&4294967295);var $13=HEAPU8[($arrayidx71)];var $conv82=((($13))&255);$c=$conv82;var $cmp93=((($conv82))|0)!=0;if($cmp93){__lastLabel__=4;__label__=5;;}else{__lastLabel__=4;__label__=26;;}
$for_body10$$for_end52$9:do{if(__label__==5){$for_body10$10:while(1){var $14=__lastLabel__==4?$conv82:($conv8);var $cmp11=((($14))|0)==6;if($cmp11){__lastLabel__=5;__label__=6;;}else{__lastLabel__=5;__label__=15;;}
$land_lhs_true$$if_else29$12:do{if(__label__==6){var $15=$n_chars_addr;var $cmp12=((($15))|0)>1;if($cmp12){__label__=7;;}else{__label__=14;;}
if(__label__==7){var $16=$count;var $inc14=((($16)+1)&4294967295);$count=$inc14;var $17=$tr_addr;var $langopts=(($17)&4294967295);var $spelling_stress=(($langopts+249)&4294967295);var $18=HEAP8[($spelling_stress)];var $conv15=(tempInt=(($18)),(tempInt>=128?tempInt-256:tempInt));var $cmp16=((($conv15))|0)==1;var $19=$count;if($cmp16){__label__=8;;}else{__label__=10;;}
if(__label__==8){var $cmp18=((($19))|0)>1;if(!($cmp18)){__label__=24;break $land_lhs_true$$if_else29$12;}
$c=5;__label__=24;break $land_lhs_true$$if_else29$12;}
else if(__label__==10){var $20=$n_stress;var $cmp21=((($19))|0)!=((($20))|0);if(!($cmp21)){__label__=24;break $land_lhs_true$$if_else29$12;}
var $21=$count;var $rem=((($21))|0)%3;var $cmp23=((($rem))|0)!=0;if($cmp23){__label__=13;;}else{__label__=12;;}
if(__label__==12){var $22=$count;var $23=$n_stress;var $sub=((($23)-1)&4294967295);var $cmp24=((($22))|0)==((($sub))|0);if(!($cmp24)){__label__=24;break $land_lhs_true$$if_else29$12;}}
$c=5;__label__=24;break $land_lhs_true$$if_else29$12;}}
else if(__label__==14){var $_pr=$c;__lastLabel__=14;__label__=15;break $land_lhs_true$$if_else29$12;}}}while(0);$if_end48$$if_else29$25:do{if(__label__==15){var $24=__lastLabel__==14?$_pr:($14);var $cmp30=((($24))|0)==255;if(!($cmp30)){__label__=24;break $if_end48$$if_else29$25;}
var $25=$control_addr;var $cmp32=((($25))|0)<2;if($cmp32){__label__=25;break $if_end48$$if_else29$25;}
var $26=$ix;var $cmp34=((($26))|0)==0;if($cmp34){__label__=25;break $if_end48$$if_else29$25;}
var $27=$control_addr;var $cmp37=((($27))|0)==4;if($cmp37){__label__=19;;}else{__label__=20;;}
if(__label__==19){$c=9;;}
var $28=$count;var $rem40=((($28))|0)%3;var $cmp41=((($rem40))|0)==0;if($cmp41){__label__=22;;}else{__label__=21;;}
$if_then44$$lor_lhs_false42$33:do{if(__label__==21){var $29=$control_addr;var $cmp43=((($29))|0)>2;if($cmp43){__label__=22;break $if_then44$$lor_lhs_false42$33;}
$c=23;__label__=24;break $if_end48$$if_else29$25;}}while(0);$c=11;__label__=24;break $if_end48$$if_else29$25;}}while(0);if(__label__==24){var $30=$c;var $conv49=((($30))&255);var $31=$phonemes_addr;var $incdec_ptr=(($31+1)&4294967295);$phonemes_addr=$incdec_ptr;HEAP8[($31)]=$conv49;;}
var $32=$ix;var $inc51=((($32)+1)&4294967295);$ix=$inc51;var $33=$ix;var $arrayidx7=(($buf+$33)&4294967295);var $34=HEAPU8[($arrayidx7)];var $conv8=((($34))&255);$c=$conv8;var $cmp9=((($conv8))|0)!=0;if($cmp9){__lastLabel__=25;__label__=5;continue $for_body10$10;}else{__lastLabel__=25;__label__=26;break $for_body10$$for_end52$9;}}}}while(0);var $35=$control_addr;var $cmp53=((($35))|0)>=2;if($cmp53){__label__=27;;}else{__label__=28;;}
if(__label__==27){var $36=$phonemes_addr;var $incdec_ptr55=(($36+1)&4294967295);$phonemes_addr=$incdec_ptr55;HEAP8[($36)]=11;;}
var $37=$phonemes_addr;HEAP8[($37)]=0;STACKTOP=__stackBase__;return;return;}
function __Z14TranslateRomanP10TranslatorPcS1_P8WORD_TAB($tr,$word,$ph_out,$wtab){var __stackBase__=STACKTOP;STACKTOP+=200;_memset(__stackBase__,0,200);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $word_addr;var $ph_out_addr;var $wtab_addr;var $c;var $p;var $p2;var $acc;var $prev;var $value;var $subtract;var $repeat;var $n_digits;var $word_start;var $num_control;var $flags=__stackBase__;var $ph_roman=__stackBase__+8;var $number_chars=__stackBase__+40;$tr_addr=$tr;$word_addr=$word;$ph_out_addr=$ph_out;$wtab_addr=$wtab;$repeat=0;$n_digits=0;$num_control=0;$acc=0;$prev=0;$subtract=32767;var $0=$ph_out_addr;var $arrayidx=(($0)&4294967295);HEAP8[($arrayidx)]=0;var $arrayidx1=(($flags)&4294967295);HEAP32[(($arrayidx1)>>2)]=0;var $arrayidx2=(($flags+4)&4294967295);HEAP32[(($arrayidx2)>>2)]=0;var $1=$tr_addr;var $langopts=(($1)&4294967295);var $numbers=(($langopts+184)&4294967295);var $2=HEAP32[(($numbers)>>2)];var $and=($2)&33554432;var $tobool=((($and))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
$land_lhs_true$$lor_lhs_false$2:do{if(__label__==1){var $3=$wtab_addr;var $arrayidx3=(($3)&4294967295);var $flags4=(($arrayidx3)&4294967295);var $4=HEAP32[(($flags4)>>2)];var $and5=($4)&1;var $tobool6=((($and5))|0)!=0;if($tobool6){__label__=2;break $land_lhs_true$$lor_lhs_false$2;}else{__label__=3;break $land_lhs_true$$lor_lhs_false$2;}}}while(0);$lor_lhs_false$$if_then$4:do{if(__label__==2){var $5=$word_addr;var $arrayidx7=(($5+-2)&4294967295);var $6=HEAP8[($arrayidx7)];var $conv=(tempInt=(($6)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp=((($conv)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call=((($isdigit))&1);var $tobool8=((($call))|0)!=0;if($tobool8){__label__=3;break $lor_lhs_false$$if_then$4;}
var $7=$word_addr;$word_start=$7;;$while_cond$7:while(1){var $8=$word_addr;var $incdec_ptr=(($8+1)&4294967295);$word_addr=$incdec_ptr;var $9=HEAP8[($8)];var $conv9=(tempInt=(($9)),(tempInt>=128?tempInt-256:tempInt));$c=$conv9;var $cmp=((($conv9))|0)!=32;if(!($cmp)){__label__=25;break $while_cond$7;}
var $10=$c;var $memchr=_memchr(((__str12309)&4294967295),$10,8);$p2=$memchr;var $cmp11=((($memchr))|0)==0;if($cmp11){__label__=7;break $while_cond$7;}
var $11=$p2;var $sub_ptr_lhs_cast=($11);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-(__str12309))&4294967295);var $arrayidx14=((__ZZ14TranslateRomanP10TranslatorPcS1_P8WORD_TABE12roman_values+$sub_ptr_sub*4)&4294967295);var $12=HEAP32[(($arrayidx14)>>2)];$value=$12;var $13=$value;var $14=$prev;var $cmp15=((($13))|0)==((($14))|0);if($cmp15){__label__=9;;}else{__label__=11;;}
if(__label__==9){var $15=$repeat;var $inc=((($15)+1)&4294967295);$repeat=$inc;var $16=$repeat;var $cmp17=((($16))|0)>=3;if($cmp17){__label__=10;break $while_cond$7;}}
else if(__label__==11){$repeat=0;;}
var $17=$prev;var $cmp21=((($17))|0)>1;var $18=$prev;var $cmp23=((($18))|0)!=10;var $or_cond=($cmp21)&($cmp23);var $19=$prev;var $cmp25=((($19))|0)!=100;var $or_cond1=($or_cond)&($cmp25);if($or_cond1){__lastLabel__=12;__label__=13;;}else{__lastLabel__=12;__label__=15;;}
if(__label__==13){var $20=$value;var $21=$prev;var $cmp27=((($20))|0)>=((($21))|0);if($cmp27){__lastLabel__=13;__label__=14;break $while_cond$7;}else{__lastLabel__=13;;}}
var $22=__lastLabel__==13?$21:($19);var $cmp31=((($22))|0)!=0;if($cmp31){__label__=16;;}else{__label__=21;;}
$land_lhs_true32$$if_else40$18:do{if(__label__==16){var $23=$prev;var $24=$value;var $cmp33=((($23))|0)<((($24))|0);if(!($cmp33)){__label__=21;break $land_lhs_true32$$if_else40$18;}
var $25=$acc;var $rem=((($25))|0)%10;var $cmp35=((($rem))|0)!=0;if($cmp35){__label__=19;break $while_cond$7;}
var $26=$prev;var $mul=((($26)*10)&4294967295);var $27=$value;var $cmp37=((($mul))|0)<((($27))|0);if($cmp37){__label__=19;break $while_cond$7;}
var $28=$prev;$subtract=$28;var $29=$subtract;var $30=$value;var $sub=((($30)-($29))&4294967295);$value=$sub;__label__=24;break $land_lhs_true32$$if_else40$18;}}while(0);if(__label__==21){var $31=$value;var $32=$subtract;var $cmp41=((($31))|0)>=((($32))|0);if($cmp41){__label__=22;break $while_cond$7;}
var $33=$prev;var $34=$acc;var $add=((($34)+($33))&4294967295);$acc=$add;;}
var $35=$value;$prev=$35;var $36=$n_digits;var $inc46=((($36)+1)&4294967295);$n_digits=$inc46;__label__=5;continue $while_cond$7;}
if(__label__==25){var $37=$word_addr;var $arrayidx47=(($37)&4294967295);var $38=HEAP8[($arrayidx47)];var $conv48=(tempInt=(($38)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp2=((($conv48)-48)&4294967295);var $isdigit3=((($isdigittmp2))>>>0)<10;var $call49=((($isdigit3))&1);var $tobool50=((($call49))|0)!=0;if($tobool50){__label__=26;;}else{__label__=27;;}
if(__label__==26){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==27){var $39=$prev;var $40=$acc;var $add53=((($40)+($39))&4294967295);$acc=$add53;var $41=$acc;var $42=$tr_addr;var $langopts54=(($42)&4294967295);var $min_roman=(($langopts54+200)&4294967295);var $43=HEAP32[(($min_roman)>>2)];var $cmp55=((($41))|0)<((($43))|0);if($cmp55){__label__=28;;}else{__label__=29;;}
if(__label__==28){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==29){var $44=$acc;var $45=$tr_addr;var $langopts58=(($45)&4294967295);var $max_roman=(($langopts58+196)&4294967295);var $46=HEAP32[(($max_roman)>>2)];var $cmp59=((($44))|0)>((($46))|0);if($cmp59){__label__=30;;}else{__label__=31;;}
if(__label__==30){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==31){var $47=$tr_addr;var $arraydecay=(($ph_roman)&4294967295);var $call62=__Z6LookupP10TranslatorPKcPc($47,((__str13310)&4294967295),$arraydecay);var $48=$ph_out_addr;var $arrayidx63=(($48)&4294967295);$p=$arrayidx63;var $49=$tr_addr;var $langopts64=(($49)&4294967295);var $numbers65=(($langopts64+184)&4294967295);var $50=HEAP32[(($numbers65)>>2)];var $and66=($50)&67108864;var $cmp67=((($and66))|0)==0;if($cmp67){__label__=32;;}else{__label__=33;;}
if(__label__==32){var $51=$ph_out_addr;var $arraydecay69=(($ph_roman)&4294967295);var $call70=_strcpy($51,$arraydecay69);var $arraydecay71=(($ph_roman)&4294967295);var $call72=_strlen($arraydecay71);var $52=$ph_out_addr;var $arrayidx73=(($52+$call72)&4294967295);$p=$arrayidx73;;}
var $arraydecay75=(($number_chars)&4294967295);var $53=$acc;var $call76=_sprintf($arraydecay75,((__str14311)&4294967295),allocate([$53,0,0,0],["i32",0,0,0],ALLOC_STACK));var $54=$word_addr;var $arrayidx77=(($54)&4294967295);var $55=HEAP8[($arrayidx77)];var $conv78=(tempInt=(($55)),(tempInt>=128?tempInt-256:tempInt));var $cmp79=((($conv78))|0)==46;if($cmp79){__label__=34;;}else{__label__=35;;}
if(__label__==34){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==35){var $56=$tr_addr;var $57=$word_start;var $58=$word_addr;var $59=$wtab_addr;var $call82=__ZL15CheckDotOrdinalP10TranslatorPcS1_P8WORD_TABi($56,$57,$58,$59,1);var $tobool83=((($call82))|0)!=0;if($tobool83){__label__=36;;}else{__label__=37;;}
if(__label__==36){var $60=$wtab_addr;var $arrayidx85=(($60)&4294967295);var $flags86=(($arrayidx85)&4294967295);var $61=HEAP32[(($flags86)>>2)];var $or=($61)|32768;HEAP32[(($flags86)>>2)]=$or;;}
var $62=$tr_addr;var $langopts88=(($62)&4294967295);var $numbers89=(($langopts88+184)&4294967295);var $63=HEAP32[(($numbers89)>>2)];var $and90=($63)&134217728;var $tobool91=((($and90))|0)!=0;if($tobool91){__label__=38;;}else{__label__=45;;}
$if_then92$$if_end117$47:do{if(__label__==38){var $64=$tr_addr;var $translator_name=(($64+280)&4294967295);var $65=HEAP32[(($translator_name)>>2)];var $cmp93=((($65))|0)==26741;var $66=$wtab_addr;var $arrayidx95=(($66)&4294967295);var $flags96=(($arrayidx95)&4294967295);var $67=HEAP32[(($flags96)>>2)];if($cmp93){__label__=39;;}else{__label__=44;;}
if(__label__==39){var $and97=($67)&32768;var $tobool98=((($and97))|0)!=0;if($tobool98){__label__=45;break $if_then92$$if_end117$47;}
var $68=$wtab_addr;var $arrayidx100=(($68)&4294967295);var $flags101=(($arrayidx100)&4294967295);var $69=HEAP32[(($flags101)>>2)];var $and102=($69)&16384;var $tobool103=((($and102))|0)!=0;if($tobool103){__label__=41;;}else{__label__=43;;}
$land_lhs_true104$$if_else109$52:do{if(__label__==41){var $70=$word_addr;var $71=$acc;var $call105=__ZL11hu_number_ePKcii($70,0,$71);var $tobool106=((($call105))|0)!=0;if(!($tobool106)){__label__=43;break $land_lhs_true104$$if_else109$52;}
var $72=$num_control;var $or108=($72)|1;$num_control=$or108;__label__=45;break $if_then92$$if_end117$47;}}while(0);$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==44){var $or115=($67)|32768;HEAP32[(($flags96)>>2)]=$or115;;}}}while(0);var $73=$tr_addr;var $prev_dict_flags=(($73+8320)&4294967295);HEAP32[(($prev_dict_flags)>>2)]=0;var $74=$tr_addr;var $arrayidx118=(($number_chars+2)&4294967295);var $75=$p;var $arraydecay119=(($flags)&4294967295);var $76=$wtab_addr;var $77=$num_control;var $call120=__Z15TranslateNumberP10TranslatorPcS1_PjP8WORD_TABi($74,$arrayidx118,$75,$arraydecay119,$76,$77);var $78=$tr_addr;var $langopts121=(($78)&4294967295);var $numbers122=(($langopts121+184)&4294967295);var $79=HEAP32[(($numbers122)>>2)];var $and123=($79)&67108864;var $tobool124=((($and123))|0)!=0;if($tobool124){__label__=46;;}else{__label__=47;;}
if(__label__==46){var $80=$ph_out_addr;var $arraydecay126=(($ph_roman)&4294967295);var $call127=_strcat($80,$arraydecay126);;}
$retval=1;__label__=48;break $lor_lhs_false$$if_then$4;}}}}}
else if(__label__==7){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==10){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==14){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==19){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}
else if(__label__==22){$retval=0;__label__=48;break $lor_lhs_false$$if_then$4;}}}while(0);if(__label__==3){$retval=0;;}
var $81=$retval;STACKTOP=__stackBase__;return $81;return null;}
function __ZL15CheckDotOrdinalP10TranslatorPcS1_P8WORD_TABi($tr,$word,$word_end,$wtab,$roman){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $tr_addr;var $word_addr;var $word_end_addr;var $wtab_addr;var $roman_addr;var $ordinal;var $c2=__stackBase__;var $nextflags;$tr_addr=$tr;$word_addr=$word;$word_end_addr=$word_end;$wtab_addr=$wtab;$roman_addr=$roman;$ordinal=0;var $0=$tr_addr;var $langopts=(($0)&4294967295);var $numbers=(($langopts+184)&4294967295);var $1=HEAP32[(($numbers)>>2)];var $and=($1)&65536;var $tobool=((($and))|0)!=0;if($tobool){__label__=1;;}else{__label__=32;;}
$land_lhs_true$$if_end92$2:do{if(__label__==1){var $2=$word_end_addr;var $arrayidx=(($2)&4294967295);var $3=HEAP8[($arrayidx)];var $conv=(tempInt=(($3)),(tempInt>=128?tempInt-256:tempInt));var $cmp=((($conv))|0)==46;if($cmp){__label__=3;;}else{__label__=2;;}
if(__label__==2){var $4=$wtab_addr;var $arrayidx1=(($4)&4294967295);var $flags=(($arrayidx1)&4294967295);var $5=HEAP32[(($flags)>>2)];var $and2=($5)&65536;var $tobool3=((($and2))|0)!=0;if(!($tobool3)){__label__=32;break $land_lhs_true$$if_end92$2;}}
var $6=$wtab_addr;var $arrayidx5=(($6+12)&4294967295);var $flags6=(($arrayidx5)&4294967295);var $7=HEAP32[(($flags6)>>2)];var $and7=($7)&256;var $tobool8=((($and7))|0)!=0;if($tobool8){__label__=32;break $land_lhs_true$$if_end92$2;}
var $8=$roman_addr;var $tobool9=((($8))|0)!=0;if($tobool9){__label__=6;;}else{__label__=5;;}
if(__label__==5){var $9=$wtab_addr;var $arrayidx11=(($9+12)&4294967295);var $flags12=(($arrayidx11)&4294967295);var $10=HEAP32[(($flags12)>>2)];var $and13=($10)&2;var $tobool14=((($and13))|0)!=0;if($tobool14){__label__=32;break $land_lhs_true$$if_end92$2;}}
var $11=$word_end_addr;var $arrayidx16=(($11)&4294967295);var $12=HEAP8[($arrayidx16)];var $conv17=(tempInt=(($12)),(tempInt>=128?tempInt-256:tempInt));var $cmp18=((($conv17))|0)==46;var $13=$word_end_addr;if($cmp18){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $arrayidx20=(($13+2)&4294967295);var $call=__Z7utf8_inPiPKc($c2,$arrayidx20);;}
else if(__label__==8){var $arrayidx21=(($13)&4294967295);var $call22=__Z7utf8_inPiPKc($c2,$arrayidx21);;}
var $14=$word_end_addr;var $arrayidx23=(($14)&4294967295);var $15=HEAP8[($arrayidx23)];var $conv24=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));var $cmp25=((($conv24))|0)!=0;if(!($cmp25)){__label__=32;break $land_lhs_true$$if_end92$2;}
var $16=$word_end_addr;var $arrayidx27=(($16+1)&4294967295);var $17=HEAP8[($arrayidx27)];var $conv28=(tempInt=(($17)),(tempInt>=128?tempInt-256:tempInt));var $cmp29=((($conv28))|0)!=0;if(!($cmp29)){__label__=32;break $land_lhs_true$$if_end92$2;}
var $18=HEAP32[(($c2)>>2)];var $cmp31=((($18))|0)==0;if($cmp31){__label__=14;;}else{__label__=12;;}
$if_then40$$lor_lhs_false32$17:do{if(__label__==12){var $19=$wtab_addr;var $arrayidx33=(($19)&4294967295);var $flags34=(($arrayidx33)&4294967295);var $20=HEAP32[(($flags34)>>2)];var $and35=($20)&131072;var $tobool36=((($and35))|0)!=0;if($tobool36){__label__=14;break $if_then40$$lor_lhs_false32$17;}
var $21=HEAP32[(($c2)>>2)];var $call38=__Z7IsAlphaj($21);var $tobool39=((($call38))|0)!=0;if(!($tobool39)){__label__=32;break $land_lhs_true$$if_end92$2;}}}while(0);$ordinal=2;var $22=$word_end_addr;var $arrayidx41=(($22)&4294967295);var $23=HEAP8[($arrayidx41)];var $conv42=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt));var $cmp43=((($conv42))|0)==46;if($cmp43){__label__=15;;}else{__label__=16;;}
if(__label__==15){var $24=$word_end_addr;var $arrayidx45=(($24)&4294967295);HEAP8[($arrayidx45)]=32;;}
var $25=$roman_addr;var $cmp47=((($25))|0)==0;if(!($cmp47)){__label__=32;break $land_lhs_true$$if_end92$2;}
var $26=$tr_addr;var $translator_name=(($26+280)&4294967295);var $27=HEAP32[(($translator_name)>>2)];var $cmp49=((($27))|0)==26741;if(!($cmp49)){__label__=32;break $land_lhs_true$$if_end92$2;}
$nextflags=0;var $28=HEAP32[(($c2)>>2)];var $call51=__Z7IsAlphaj($28);var $tobool52=((($call51))|0)!=0;if($tobool52){__label__=19;;}else{__label__=20;;}
if(__label__==19){var $29=$tr_addr;var $30=$word_end_addr;var $arrayidx54=(($30+2)&4294967295);var $call55=__Z13TranslateWordP10TranslatorPciP8WORD_TAB($29,$arrayidx54,0,0);$nextflags=$call55;;}
var $31=$tr_addr;var $prev_dict_flags=(($31+8320)&4294967295);var $32=HEAP32[(($prev_dict_flags)>>2)];var $and57=($32)&1048576;var $tobool58=((($and57))|0)!=0;if($tobool58){__label__=21;;}else{__label__=25;;}
$land_lhs_true59$$if_end70$29:do{if(__label__==21){var $33=HEAP32[(($c2)>>2)];var $cmp60=((($33))|0)==0;if($cmp60){__label__=24;;}else{__label__=22;;}
$if_then69$$lor_lhs_false61$31:do{if(__label__==22){var $34=$wtab_addr;var $arrayidx62=(($34)&4294967295);var $flags63=(($arrayidx62)&4294967295);var $35=HEAP32[(($flags63)>>2)];var $and64=($35)&131072;var $tobool65=((($and64))|0)!=0;if($tobool65){__label__=24;break $if_then69$$lor_lhs_false61$31;}
var $36=HEAP32[(($c2)>>2)];var $call67=_iswdigit($36);var $tobool68=((($call67))|0)!=0;if(!($tobool68)){__label__=25;break $land_lhs_true59$$if_end70$29;}}}while(0);$ordinal=0;;}}while(0);var $37=$nextflags;var $and71=($37)&1048576;var $tobool72=((($and71))|0)!=0;if($tobool72){__label__=26;;}else{__label__=27;;}
if(__label__==26){$ordinal=0;;}
var $38=$nextflags;var $and75=($38)&4194304;var $tobool76=((($and75))|0)!=0;if(!($tobool76)){__label__=32;break $land_lhs_true$$if_end92$2;}
var $39=$word_addr;var $arrayidx78=(($39+-2)&4294967295);var $40=HEAP8[($arrayidx78)];var $conv79=(tempInt=(($40)),(tempInt>=128?tempInt-256:tempInt));var $cmp80=((($conv79))|0)==45;if($cmp80){__label__=29;;}else{__label__=30;;}
if(__label__==29){$ordinal=0;;}
var $41=$tr_addr;var $prev_dict_flags83=(($41+8320)&4294967295);var $42=HEAP32[(($prev_dict_flags83)>>2)];var $and84=($42)&5242880;var $tobool85=((($and84))|0)!=0;if(!($tobool85)){__label__=32;break $land_lhs_true$$if_end92$2;}
$ordinal=34;;}}while(0);var $43=$ordinal;STACKTOP=__stackBase__;return $43;return null;}
function __ZL11hu_number_ePKcii($word,$thousandplex,$value){;var __label__;var $retval;var $word_addr;var $thousandplex_addr;var $value_addr;$word_addr=$word;$thousandplex_addr=$thousandplex;$value_addr=$value;var $0=$word_addr;var $arrayidx=(($0)&4294967295);var $1=HEAP8[($arrayidx)];var $conv=(tempInt=(($1)),(tempInt>=128?tempInt-256:tempInt));var $cmp=((($conv))|0)==97;if($cmp){__label__=2;;}else{__label__=1;;}
$if_then$$lor_lhs_false$2:do{if(__label__==1){var $2=$word_addr;var $arrayidx1=(($2)&4294967295);var $3=HEAP8[($arrayidx1)];var $conv2=(tempInt=(($3)),(tempInt>=128?tempInt-256:tempInt));var $cmp3=((($conv2))|0)==101;if($cmp3){__label__=2;break $if_then$$lor_lhs_false$2;}
$retval=0;__label__=13;break $if_then$$lor_lhs_false$2;}}while(0);$if_then$$return$5:do{if(__label__==2){var $4=$word_addr;var $arrayidx4=(($4+1)&4294967295);var $5=HEAP8[($arrayidx4)];var $conv5=(tempInt=(($5)),(tempInt>=128?tempInt-256:tempInt));var $cmp6=((($conv5))|0)==32;if($cmp6){__label__=6;;}else{__label__=3;;}
$if_then18$$lor_lhs_false7$7:do{if(__label__==3){var $6=$word_addr;var $arrayidx8=(($6+1)&4294967295);var $7=HEAP8[($arrayidx8)];var $conv9=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $cmp10=((($conv9))|0)==122;if($cmp10){__label__=6;break $if_then18$$lor_lhs_false7$7;}
var $8=$word_addr;var $arrayidx12=(($8+1)&4294967295);var $9=HEAP8[($arrayidx12)];var $conv13=(tempInt=(($9)),(tempInt>=128?tempInt-256:tempInt));var $cmp14=((($conv13))|0)==116;if($cmp14){__label__=5;;}else{__label__=7;;}
if(__label__==5){var $10=$word_addr;var $arrayidx15=(($10+2)&4294967295);var $11=HEAP8[($arrayidx15)];var $conv16=(tempInt=(($11)),(tempInt>=128?tempInt-256:tempInt));var $cmp17=((($conv16))|0)==116;if($cmp17){__label__=6;break $if_then18$$lor_lhs_false7$7;}}
var $12=$thousandplex_addr;var $cmp19=((($12))|0)==1;if($cmp19){__label__=9;;}else{__label__=8;;}
$land_lhs_true22$$lor_lhs_false20$13:do{if(__label__==8){var $13=$value_addr;var $rem=((($13))|0)%1000;var $cmp21=((($rem))|0)==0;if($cmp21){__label__=9;break $land_lhs_true22$$lor_lhs_false20$13;}else{__label__=11;break $land_lhs_true22$$lor_lhs_false20$13;}}}while(0);$land_lhs_true22$$if_end27$15:do{if(__label__==9){var $14=$word_addr;var $arrayidx23=(($14+1)&4294967295);var $15=HEAP8[($arrayidx23)];var $conv24=(tempInt=(($15)),(tempInt>=128?tempInt-256:tempInt));var $cmp25=((($conv24))|0)==108;if(!($cmp25)){__label__=11;break $land_lhs_true22$$if_end27$15;}
$retval=0;__label__=13;break $if_then$$return$5;}}while(0);$retval=1;__label__=13;break $if_then$$return$5;}}while(0);$retval=0;;}}while(0);var $16=$retval;;return $16;return null;}
function __Z15TranslateNumberP10TranslatorPcS1_PjP8WORD_TABi($tr,$word1,$ph_out,$flags,$wtab,$control){;var __label__;var $retval;var $tr_addr;var $word1_addr;var $ph_out_addr;var $flags_addr;var $wtab_addr;var $control_addr;$tr_addr=$tr;$word1_addr=$word1;$ph_out_addr=$ph_out;$flags_addr=$flags;$wtab_addr=$wtab;$control_addr=$control;var $0=HEAP32[((_option_sayas)>>2)];var $cmp=((($0))|0)==193;if($cmp){__label__=2;;}else{__label__=1;;}
$if_then$$lor_lhs_false$2:do{if(__label__==1){var $1=$wtab_addr;var $arrayidx=(($1)&4294967295);var $flags1=(($arrayidx)&4294967295);var $2=HEAP32[(($flags1)>>2)];var $and=($2)&524288;var $tobool=((($and))|0)!=0;if($tobool){__label__=2;break $if_then$$lor_lhs_false$2;}
var $3=$tr_addr;var $langopts=(($3)&4294967295);var $numbers=(($langopts+184)&4294967295);var $4=HEAP32[(($numbers)>>2)];var $cmp2=((($4))|0)!=0;if($cmp2){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $5=$tr_addr;var $6=$word1_addr;var $7=$ph_out_addr;var $8=$flags_addr;var $9=$wtab_addr;var $10=$control_addr;var $call=__ZL17TranslateNumber_1P10TranslatorPcS1_PjP8WORD_TABi($5,$6,$7,$8,$9,$10);$retval=$call;__label__=6;break $if_then$$lor_lhs_false$2;}
else if(__label__==5){$retval=0;__label__=6;break $if_then$$lor_lhs_false$2;}}}while(0);if(__label__==2){$retval=0;;}
var $11=$retval;;return $11;return null;}
function __ZL17TranslateNumber_1P10TranslatorPcS1_PjP8WORD_TABi($tr,$word,$ph_out,$flags,$wtab,$control){var __stackBase__=STACKTOP;STACKTOP+=560;_memset(__stackBase__,0,560);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $word_addr;var $ph_out_addr;var $flags_addr;var $wtab_addr;var $control_addr;var $n_digits;var $value;var $ix;var $digix;var $c;var $suppress_null;var $decimal_point;var $thousandplex;var $thousands_exact;var $thousands_inc;var $prev_thousands;var $ordinal;var $dot_ordinal;var $this_value;var $decimal_count;var $max_decimal_count;var $decimal_mode;var $hyphen;var $suffix_ix;var $skipwords;var $p=__stackBase__;var $string=__stackBase__+4;var $buf1=__stackBase__+24;var $ph_append=__stackBase__+124;var $ph_buf=__stackBase__+176;var $ph_buf2=__stackBase__+376;var $ph_zeros=__stackBase__+428;var $suffix=__stackBase__+480;var $buf_digit_lookup=__stackBase__+500;var $p2=__stackBase__+552;var $next_char=__stackBase__+556;var $p562;$tr_addr=$tr;$word_addr=$word;$ph_out_addr=$ph_out;$flags_addr=$flags;$wtab_addr=$wtab;$control_addr=$control;$suppress_null=0;$decimal_point=0;$thousandplex=0;$thousands_exact=1;$thousands_inc=0;$prev_thousands=0;$ordinal=0;$skipwords=0;var $0=$flags_addr;HEAP32[(($0)>>2)]=0;HEAP32[((__ZL14n_digit_lookup)>>2)]=0;var $arrayidx=(($buf_digit_lookup)&4294967295);HEAP8[($arrayidx)]=0;var $arraydecay=(($buf_digit_lookup)&4294967295);HEAP32[((__ZL12digit_lookup)>>2)]=$arraydecay;var $1=$control_addr;HEAP32[((__ZL14number_control)>>2)]=$1;$ix=0;var $2=$ix;var $3=$word_addr;var $arrayidx167=(($3+$2)&4294967295);var $4=HEAP8[($arrayidx167)];var $conv68=(tempInt=(($4)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp69=((($conv68)-48)&4294967295);var $isdigit70=((($isdigittmp69))>>>0)<10;var $5=$ix;if($isdigit70){__lastLabel__=0;__label__=1;;}else{__lastLabel__=0;__label__=2;;}
$for_inc$$for_end$2:do{if(__label__==1){while(1){var $6=__lastLabel__==1?$10:($5);var $inc=((($6)+1)&4294967295);$ix=$inc;var $7=$ix;var $8=$word_addr;var $arrayidx1=(($8+$7)&4294967295);var $9=HEAP8[($arrayidx1)];var $conv=(tempInt=(($9)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp=((($conv)-48)&4294967295);var $isdigit=((($isdigittmp))>>>0)<10;var $call=((($isdigit))&1);var $tobool=((($call))|0)!=0;var $10=$ix;if($tobool){__lastLabel__=1;__label__=1;continue;}else{__lastLabel__=1;__label__=2;break $for_inc$$for_end$2;}}}}while(0);var $_lcssa65=__lastLabel__==0?$5:($10);$n_digits=$_lcssa65;var $11=$word_addr;var $call2=_atoi($11);$this_value=$call2;$value=$call2;var $cmp=((($_lcssa65))|0)==3;if($cmp){__label__=3;;}else{__label__=6;;}
$land_lhs_true$$if_else$6:do{if(__label__==3){var $12=$word_addr;var $arrayidx3=(($12+-2)&4294967295);var $13=HEAP8[($arrayidx3)];var $conv4=(tempInt=(($13)),(tempInt>=128?tempInt-256:tempInt));var $14=$tr_addr;var $langopts=(($14)&4294967295);var $thousands_sep=(($langopts+204)&4294967295);var $15=HEAP32[(($thousands_sep)>>2)];var $cmp5=((($conv4))|0)==((($15))|0);if(!($cmp5)){__label__=6;break $land_lhs_true$$if_else$6;}
var $16=$word_addr;var $arrayidx7=(($16+-3)&4294967295);var $17=HEAP8[($arrayidx7)];var $conv8=(tempInt=(($17)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp6=((($conv8)-48)&4294967295);var $isdigit7=((($isdigittmp6))>>>0)<10;var $call9=((($isdigit7))&1);var $tobool10=((($call9))|0)!=0;if(!($tobool10)){__label__=6;break $land_lhs_true$$if_else$6;}
$prev_thousands=1;__label__=14;break $land_lhs_true$$if_else$6;}}while(0);$if_end32$$if_else$10:do{if(__label__==6){var $18=$tr_addr;var $langopts11=(($18)&4294967295);var $thousands_sep12=(($langopts11+204)&4294967295);var $19=HEAP32[(($thousands_sep12)>>2)];var $cmp13=((($19))|0)==32;if($cmp13){__label__=8;;}else{__label__=7;;}
$if_then16$$lor_lhs_false$12:do{if(__label__==7){var $20=$tr_addr;var $langopts14=(($20)&4294967295);var $numbers=(($langopts14+184)&4294967295);var $21=HEAP32[(($numbers)>>2)];var $and=($21)&4096;var $tobool15=((($and))|0)!=0;if($tobool15){__label__=8;break $if_then16$$lor_lhs_false$12;}else{__label__=12;break $if_then16$$lor_lhs_false$12;}}}while(0);$if_then16$$if_end29$14:do{if(__label__==8){var $22=$n_digits;var $cmp17=((($22))|0)==3;if(!($cmp17)){__label__=12;break $if_then16$$if_end29$14;}
var $23=$wtab_addr;var $flags19=(($23)&4294967295);var $24=HEAP32[(($flags19)>>2)];var $and20=($24)&262144;var $tobool21=((($and20))|0)!=0;if($tobool21){__label__=12;break $if_then16$$if_end29$14;}
var $25=$word_addr;var $arrayidx23=(($25+-2)&4294967295);var $26=HEAP8[($arrayidx23)];var $conv24=(tempInt=(($26)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp8=((($conv24)-48)&4294967295);var $isdigit9=((($isdigittmp8))>>>0)<10;var $call25=((($isdigit9))&1);var $tobool26=((($call25))|0)!=0;if(!($tobool26)){__label__=12;break $if_then16$$if_end29$14;}
$prev_thousands=1;__label__=14;break $if_end32$$if_else$10;}}while(0);var $_pr=$prev_thousands;var $cmp30=((($_pr))|0)==0;if(!($cmp30)){__label__=14;break $if_end32$$if_else$10;}
HEAP32[((__ZL23speak_missing_thousands)>>2)]=0;;}}while(0);HEAP8[(((__ZL11ph_ordinal2)&4294967295))]=0;var $arrayidx33=(($ph_zeros)&4294967295);HEAP8[($arrayidx33)]=0;var $27=$prev_thousands;var $tobool34=((($27))|0)!=0;if($tobool34){__label__=16;;}else{__label__=15;;}
$if_then39$$lor_lhs_false35$22:do{if(__label__==15){var $28=$word_addr;var $arrayidx36=(($28)&4294967295);var $29=HEAP8[($arrayidx36)];var $conv37=(tempInt=(($29)),(tempInt>=128?tempInt-256:tempInt));var $cmp38=((($conv37))|0)!=48;if($cmp38){__label__=16;break $if_then39$$lor_lhs_false35$22;}else{__label__=18;break $if_then39$$lor_lhs_false35$22;}}}while(0);$if_then39$$if_end45$24:do{if(__label__==16){var $30=$tr_addr;var $31=$word_addr;var $32=$ix;var $33=$word_addr;var $arrayidx40=(($33+$32)&4294967295);var $34=$wtab_addr;var $call41=__ZL15CheckDotOrdinalP10TranslatorPcS1_P8WORD_TABi($30,$31,$arrayidx40,$34,0);$ordinal=$call41;var $cmp42=((($call41))|0)!=0;if(!($cmp42)){__label__=18;break $if_then39$$if_end45$24;}
$dot_ordinal=1;;}}while(0);var $35=$ix;var $36=$word_addr;var $arrayidx46=(($36+$35)&4294967295);var $37=HEAP8[($arrayidx46)];var $conv47=(tempInt=(($37)),(tempInt>=128?tempInt-256:tempInt));var $cmp48=((($conv47))|0)==46;if($cmp48){__label__=19;;}else{__label__=23;;}
$land_lhs_true49$$if_end67$28:do{if(__label__==19){var $38=$ix;var $add=((($38)+1)&4294967295);var $39=$word_addr;var $arrayidx50=(($39+$add)&4294967295);var $40=HEAP8[($arrayidx50)];var $conv51=(tempInt=(($40)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp10=((($conv51)-48)&4294967295);var $isdigit11=((($isdigittmp10))>>>0)<10;var $call52=((($isdigit11))&1);var $tobool53=((($call52))|0)!=0;if($tobool53){__label__=23;break $land_lhs_true49$$if_end67$28;}
var $41=$ix;var $add55=((($41)+2)&4294967295);var $42=$word_addr;var $arrayidx56=(($42+$add55)&4294967295);var $43=HEAP8[($arrayidx56)];var $conv57=(tempInt=(($43)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp12=((($conv57)-48)&4294967295);var $isdigit13=((($isdigittmp12))>>>0)<10;var $call58=((($isdigit13))&1);var $tobool59=((($call58))|0)!=0;if($tobool59){__label__=23;break $land_lhs_true49$$if_end67$28;}
var $44=$wtab_addr;var $arrayidx61=(($44+12)&4294967295);var $flags62=(($arrayidx61)&4294967295);var $45=HEAP32[(($flags62)>>2)];var $and63=($45)&256;var $tobool64=((($and63))|0)!=0;if($tobool64){__label__=23;break $land_lhs_true49$$if_end67$28;}
var $46=$ix;var $47=$word_addr;var $arrayidx66=(($47+$46)&4294967295);HEAP8[($arrayidx66)]=0;;}}while(0);var $48=$ordinal;var $cmp68=((($48))|0)==0;if($cmp68){__label__=25;;}else{__label__=24;;}
$if_then71$$lor_lhs_false69$34:do{if(__label__==24){var $49=$tr_addr;var $translator_name=(($49+280)&4294967295);var $50=HEAP32[(($translator_name)>>2)];var $cmp70=((($50))|0)==26741;if($cmp70){__label__=25;break $if_then71$$lor_lhs_false69$34;}else{__label__=38;break $if_then71$$lor_lhs_false69$34;}}}while(0);$if_then71$$if_end123$36:do{if(__label__==25){var $51=$ix;var $inc72=((($51)+1)&4294967295);$ix=$inc72;$hyphen=0;var $arraydecay73=(($suffix)&4294967295);HEAP32[(($p)>>2)]=$arraydecay73;var $52=$wtab_addr;var $arrayidx74=(($52)&4294967295);var $flags75=(($arrayidx74)&4294967295);var $53=HEAP32[(($flags75)>>2)];var $and76=($53)&16384;var $tobool77=((($and76))|0)!=0;if($tobool77){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $54=HEAP32[(($p)>>2)];var $incdec_ptr=(($54+1)&4294967295);HEAP32[(($p)>>2)]=$incdec_ptr;HEAP8[($54)]=45;$hyphen=1;var $55=$ix;var $inc79=((($55)+1)&4294967295);$ix=$inc79;;}
$while_cond$40:while(1){var $56=$ix;var $57=$word_addr;var $arrayidx81=(($57+$56)&4294967295);var $58=HEAP8[($arrayidx81)];var $conv82=(tempInt=(($58)),(tempInt>=128?tempInt-256:tempInt));var $cmp83=((($conv82))|0)!=0;if(!($cmp83)){__label__=31;break $while_cond$40;}
var $59=$ix;var $60=$word_addr;var $arrayidx85=(($60+$59)&4294967295);var $61=HEAP8[($arrayidx85)];var $conv86=(tempInt=(($61)),(tempInt>=128?tempInt-256:tempInt));var $cmp87=((($conv86))|0)!=32;if(!($cmp87)){__label__=31;break $while_cond$40;}
var $62=$ix;var $cmp88=((($62))|0)<19;if(!($cmp88)){__label__=31;break $while_cond$40;}
var $63=$ix;var $inc89=((($63)+1)&4294967295);$ix=$inc89;var $64=$word_addr;var $arrayidx90=(($64+$63)&4294967295);var $65=HEAP8[($arrayidx90)];var $66=HEAP32[(($p)>>2)];var $incdec_ptr91=(($66+1)&4294967295);HEAP32[(($p)>>2)]=$incdec_ptr91;HEAP8[($66)]=$65;__label__=27;continue $while_cond$40;}
var $67=HEAP32[(($p)>>2)];HEAP8[($67)]=0;var $arrayidx92=(($suffix)&4294967295);var $68=HEAP8[($arrayidx92)];var $conv93=(tempInt=(($68)),(tempInt>=128?tempInt-256:tempInt));var $cmp94=((($conv93))|0)!=0;if(!($cmp94)){__label__=38;break $if_then71$$if_end123$36;}
var $69=$tr_addr;var $langopts96=(($69)&4294967295);var $ordinal_indicator=(($langopts96+216)&4294967295);var $70=HEAP32[(($ordinal_indicator)>>2)];var $cmp97=((($70))|0)!=0;if($cmp97){__label__=33;;}else{__label__=35;;}
$land_lhs_true98$$if_else105$47:do{if(__label__==33){var $arraydecay99=(($suffix)&4294967295);var $71=$tr_addr;var $langopts100=(($71)&4294967295);var $ordinal_indicator101=(($langopts100+216)&4294967295);var $72=HEAP32[(($ordinal_indicator101)>>2)];var $call102=_strcmp($arraydecay99,$72);var $cmp103=((($call102))|0)==0;if(!($cmp103)){__label__=35;break $land_lhs_true98$$if_else105$47;}
$ordinal=2;__label__=38;break $if_then71$$if_end123$36;}}while(0);var $arrayidx106=(($suffix)&4294967295);var $73=HEAP8[($arrayidx106)];var $conv107=(tempInt=(($73)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp14=((($conv107)-48)&4294967295);var $isdigit15=((($isdigittmp14))>>>0)<10;var $call108=((($isdigit15))&1);var $tobool109=((($call108))|0)!=0;if($tobool109){__label__=38;break $if_then71$$if_end123$36;}
var $arraydecay111=(($string)&4294967295);var $arraydecay112=(($suffix)&4294967295);var $call113=_sprintf($arraydecay111,((__str15312)&4294967295),allocate([$arraydecay112,0,0,0],["i8*",0,0,0],ALLOC_STACK));var $74=$tr_addr;var $arraydecay114=(($string)&4294967295);var $call115=__Z6LookupP10TranslatorPKcPc($74,$arraydecay114,((__ZL11ph_ordinal2)&4294967295));var $tobool116=((($call115))|0)!=0;if(!($tobool116)){__label__=38;break $if_then71$$if_end123$36;}
$ordinal=2;var $75=$flags_addr;var $arrayidx118=(($75)&4294967295);var $76=HEAP32[(($arrayidx118)>>2)];var $or=($76)|128;HEAP32[(($arrayidx118)>>2)]=$or;$skipwords=1;;}}while(0);var $77=$wtab_addr;var $arrayidx124=(($77)&4294967295);var $flags125=(($arrayidx124)&4294967295);var $78=HEAP32[(($flags125)>>2)];var $and126=($78)&32768;var $tobool127=((($and126))|0)!=0;if($tobool127){__label__=39;;}else{__label__=40;;}
if(__label__==39){$ordinal=2;;}
var $arrayidx130=(($ph_append)&4294967295);HEAP8[($arrayidx130)]=0;var $arrayidx131=(($ph_buf2)&4294967295);HEAP8[($arrayidx131)]=0;var $79=$word_addr;var $arrayidx132=(($79)&4294967295);var $80=HEAP8[($arrayidx132)];var $conv133=(tempInt=(($80)),(tempInt>=128?tempInt-256:tempInt));var $cmp134=((($conv133))|0)==48;if($cmp134){__label__=41;;}else{__label__=55;;}
$land_lhs_true135$$if_end185$57:do{if(__label__==41){var $81=$prev_thousands;var $cmp136=((($81))|0)==0;if(!($cmp136)){__label__=55;break $land_lhs_true135$$if_end185$57;}
var $82=$word_addr;var $arrayidx138=(($82+1)&4294967295);var $83=HEAP8[($arrayidx138)];var $conv139=(tempInt=(($83)),(tempInt>=128?tempInt-256:tempInt));var $cmp140=((($conv139))|0)!=32;if(!($cmp140)){__label__=55;break $land_lhs_true135$$if_end185$57;}
var $84=$word_addr;var $arrayidx142=(($84+1)&4294967295);var $85=HEAP8[($arrayidx142)];var $conv143=(tempInt=(($85)),(tempInt>=128?tempInt-256:tempInt));var $86=$tr_addr;var $langopts144=(($86)&4294967295);var $decimal_sep=(($langopts144+208)&4294967295);var $87=HEAP32[(($decimal_sep)>>2)];var $cmp145=((($conv143))|0)!=((($87))|0);if(!($cmp145)){__label__=55;break $land_lhs_true135$$if_end185$57;}
var $88=$n_digits;var $cmp147=((($88))|0)==2;if($cmp147){__lastLabel__=44;__label__=45;;}else{__lastLabel__=44;__label__=49;;}
if(__label__==45){var $89=$word_addr;var $arrayidx149=(($89+3)&4294967295);var $90=HEAP8[($arrayidx149)];var $conv150=(tempInt=(($90)),(tempInt>=128?tempInt-256:tempInt));var $cmp151=((($conv150))|0)==58;if($cmp151){__label__=46;;}else{__label__=48;;}
$land_lhs_true152$$if_else163thread_pre_split$64:do{if(__label__==46){var $91=$word_addr;var $arrayidx153=(($91+5)&4294967295);var $92=HEAP8[($arrayidx153)];var $conv154=(tempInt=(($92)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp16=((($conv154)-48)&4294967295);var $isdigit17=((($isdigittmp16))>>>0)<10;var $call155=((($isdigit17))&1);var $tobool156=((($call155))|0)!=0;if(!($tobool156)){__label__=48;break $land_lhs_true152$$if_else163thread_pre_split$64;}
var $93=$word_addr;var $arrayidx158=(($93+7)&4294967295);var $94=HEAP8[($arrayidx158)];var $conv159=(tempInt=(($94)),(tempInt>=128?tempInt-256:tempInt));var $call160=_isspace($conv159);var $tobool161=((($call160))|0)!=0;if($tobool161){__label__=55;break $land_lhs_true135$$if_end185$57;}}}while(0);var $_pr43=$n_digits;__lastLabel__=48;;}
var $95=__lastLabel__==48?$_pr43:($88);var $cmp164=((($95))|0)>3;if($cmp164){__label__=50;;}else{__label__=51;;}
if(__label__==50){var $96=$flags_addr;var $arrayidx166=(($96)&4294967295);var $97=HEAP32[(($arrayidx166)>>2)];var $and167=($97)&-129;HEAP32[(($arrayidx166)>>2)]=$and167;$retval=0;__label__=157;break $land_lhs_true135$$if_end185$57;}
else if(__label__==51){$ix=0;var $arraydecay177=(($ph_zeros)&4294967295);;while(1){var $98=$ix;var $99=$word_addr;var $arrayidx170=(($99+$98)&4294967295);var $100=HEAP8[($arrayidx170)];var $conv171=(tempInt=(($100)),(tempInt>=128?tempInt-256:tempInt));var $cmp172=((($conv171))|0)==48;if(!($cmp172)){__label__=55;break $land_lhs_true135$$if_end185$57;}
var $101=$ix;var $102=$n_digits;var $sub=((($102)-1)&4294967295);var $cmp174=((($101))|0)<((($sub))|0);if(!($cmp174)){__label__=55;break $land_lhs_true135$$if_end185$57;}
var $103=$tr_addr;var $call178=_strlen($arraydecay177);var $arrayidx179=(($ph_zeros+$call178)&4294967295);var $call180=__Z6LookupP10TranslatorPKcPc($103,((__str16313)&4294967295),$arrayidx179);var $104=$ix;var $inc182=((($104)+1)&4294967295);$ix=$inc182;__label__=52;continue;}}}}while(0);if(__label__==55){var $105=$tr_addr;var $langopts186=(($105)&4294967295);var $numbers187=(($langopts186+184)&4294967295);var $106=HEAP32[(($numbers187)>>2)];var $and188=($106)&4096;var $tobool189=((($and188))|0)!=0;if($tobool189){__label__=56;;}else{__label__=58;;}
$land_lhs_true190$$if_else195$78:do{if(__label__==56){var $107=$n_digits;var $108=$word_addr;var $arrayidx191=(($108+$107)&4294967295);var $109=HEAP8[($arrayidx191)];var $conv192=(tempInt=(($109)),(tempInt>=128?tempInt-256:tempInt));var $cmp193=((($conv192))|0)==32;if(!($cmp193)){__label__=58;break $land_lhs_true190$$if_else195$78;}
$thousands_inc=1;__label__=60;break $land_lhs_true190$$if_else195$78;}}while(0);$if_end203_thread$$if_else195$81:do{if(__label__==58){var $110=$n_digits;var $111=$word_addr;var $arrayidx196=(($111+$110)&4294967295);var $112=HEAP8[($arrayidx196)];var $conv197=(tempInt=(($112)),(tempInt>=128?tempInt-256:tempInt));var $113=$tr_addr;var $langopts198=(($113)&4294967295);var $thousands_sep199=(($langopts198+204)&4294967295);var $114=HEAP32[(($thousands_sep199)>>2)];var $cmp200=((($conv197))|0)==((($114))|0);if($cmp200){__label__=59;;}else{__label__=61;;}
if(__label__==59){$thousands_inc=2;__label__=60;break $if_end203_thread$$if_else195$81;}
else if(__label__==61){var $_pr44=$thousands_inc;var $116=$n_digits;var $add204=((($116)+2)&4294967295);$suffix_ix=$add204;var $cmp205=((($_pr44))|0)>0;if($cmp205){__label__=62;break $if_end203_thread$$if_else195$81;}else{__label__=77;break $if_end203_thread$$if_else195$81;}}}}while(0);$if_end203_thread$$if_then206$$if_end282$86:do{if(__label__==60){var $115=$n_digits;var $add20445=((($115)+2)&4294967295);$suffix_ix=$add20445;__label__=62;break $if_end203_thread$$if_then206$$if_end282$86;}}while(0);$if_then206$$if_end282$88:do{if(__label__==62){var $117=$n_digits;var $118=$thousands_inc;var $add207=((($118)+($117))&4294967295);$digix=$add207;;$while_cond208$90:while(1){var $119=$thousandplex;var $add209=((($119)+1)&4294967295);var $120=$wtab_addr;var $arrayidx210=(($120+12*$add209)&4294967295);var $flags211=(($arrayidx210)&4294967295);var $121=HEAP32[(($flags211)>>2)];var $and212=($121)&262144;var $cmp213=((($and212))|0)==0;if(!($cmp213)){__label__=77;break $if_then206$$if_end282$88;}
var $122=$digix;var $123=$word_addr;var $arrayidx215=(($123+$122)&4294967295);var $124=HEAP8[($arrayidx215)];var $conv216=(tempInt=(($124)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp18=((($conv216)-48)&4294967295);var $isdigit19=((($isdigittmp18))>>>0)<10;var $call217=((($isdigit19))&1);var $tobool218=((($call217))|0)!=0;if(!($tobool218)){__label__=77;break $if_then206$$if_end282$88;}
var $125=$digix;var $add220=((($125)+1)&4294967295);var $126=$word_addr;var $arrayidx221=(($126+$add220)&4294967295);var $127=HEAP8[($arrayidx221)];var $conv222=(tempInt=(($127)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp20=((($conv222)-48)&4294967295);var $isdigit21=((($isdigittmp20))>>>0)<10;var $call223=((($isdigit21))&1);var $tobool224=((($call223))|0)!=0;if(!($tobool224)){__label__=77;break $if_then206$$if_end282$88;}
var $128=$digix;var $add226=((($128)+2)&4294967295);var $129=$word_addr;var $arrayidx227=(($129+$add226)&4294967295);var $130=HEAP8[($arrayidx227)];var $conv228=(tempInt=(($130)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp22=((($conv228)-48)&4294967295);var $isdigit23=((($isdigittmp22))>>>0)<10;var $call229=((($isdigit23))&1);var $tobool230=((($call229))|0)!=0;if(!($tobool230)){__label__=77;break $if_then206$$if_end282$88;}
var $131=$digix;var $add232=((($131)+3)&4294967295);var $132=$word_addr;var $arrayidx233=(($132+$add232)&4294967295);var $133=HEAP8[($arrayidx233)];var $conv234=(tempInt=(($133)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp24=((($conv234)-48)&4294967295);var $isdigit25=((($isdigittmp24))>>>0)<10;var $call235=((($isdigit25))&1);var $tobool236=((($call235))|0)!=0;if($tobool236){__label__=77;break $if_then206$$if_end282$88;}
var $134=$digix;var $sub238=((($134)-1)&4294967295);var $135=$word_addr;var $arrayidx239=(($135+$sub238)&4294967295);var $136=HEAP8[($arrayidx239)];var $conv240=(tempInt=(($136)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp26=((($conv240)-48)&4294967295);var $isdigit27=((($isdigittmp26))>>>0)<10;var $call241=((($isdigit27))&1);var $tobool242=((($call241))|0)!=0;var $lnot=($tobool242)^1;if(!($lnot)){__label__=77;break $if_then206$$if_end282$88;}
var $137=$digix;var $138=$word_addr;var $arrayidx245=(($138+$137)&4294967295);var $139=HEAP8[($arrayidx245)];var $conv246=(tempInt=(($139)),(tempInt>=128?tempInt-256:tempInt));var $cmp247=((($conv246))|0)!=48;if($cmp247){__label__=72;;}else{__label__=70;;}
$if_then258$$lor_lhs_false248$98:do{if(__label__==70){var $140=$digix;var $add249=((($140)+1)&4294967295);var $141=$word_addr;var $arrayidx250=(($141+$add249)&4294967295);var $142=HEAP8[($arrayidx250)];var $conv251=(tempInt=(($142)),(tempInt>=128?tempInt-256:tempInt));var $cmp252=((($conv251))|0)!=48;if($cmp252){__label__=72;break $if_then258$$lor_lhs_false248$98;}
var $143=$digix;var $add254=((($143)+2)&4294967295);var $144=$word_addr;var $arrayidx255=(($144+$add254)&4294967295);var $145=HEAP8[($arrayidx255)];var $conv256=(tempInt=(($145)),(tempInt>=128?tempInt-256:tempInt));var $cmp257=((($conv256))|0)!=48;if($cmp257){__label__=72;break $if_then258$$lor_lhs_false248$98;}else{__label__=73;break $if_then258$$lor_lhs_false248$98;}}}while(0);if(__label__==72){$thousands_exact=0;;}
var $146=$thousandplex;var $inc260=((($146)+1)&4294967295);$thousandplex=$inc260;var $147=$digix;var $add261=((($147)+3)&4294967295);$digix=$add261;var $148=$digix;var $149=$word_addr;var $arrayidx262=(($149+$148)&4294967295);var $150=HEAP8[($arrayidx262)];var $conv263=(tempInt=(($150)),(tempInt>=128?tempInt-256:tempInt));var $151=$tr_addr;var $langopts264=(($151)&4294967295);var $thousands_sep265=(($langopts264+204)&4294967295);var $152=HEAP32[(($thousands_sep265)>>2)];var $cmp266=((($conv263))|0)==((($152))|0);if($cmp266){__label__=76;;}else{__label__=74;;}
if(__label__==74){var $153=$tr_addr;var $langopts268=(($153)&4294967295);var $numbers269=(($langopts268+184)&4294967295);var $154=HEAP32[(($numbers269)>>2)];var $and270=($154)&4096;var $tobool271=((($and270))|0)!=0;if(!($tobool271)){__label__=77;break $if_then206$$if_end282$88;}
var $155=$digix;var $156=$word_addr;var $arrayidx273=(($156+$155)&4294967295);var $157=HEAP8[($arrayidx273)];var $conv274=(tempInt=(($157)),(tempInt>=128?tempInt-256:tempInt));var $cmp275=((($conv274))|0)==32;if(!($cmp275)){__label__=77;break $if_then206$$if_end282$88;}}
var $158=$digix;var $add277=((($158)+2)&4294967295);$suffix_ix=$add277;var $159=$thousands_inc;var $160=$digix;var $add278=((($160)+($159))&4294967295);$digix=$add278;__label__=63;continue $while_cond208$90;}}}while(0);var $161=$value;var $cmp283=((($161))|0)==0;if($cmp283){__label__=78;;}else{__label__=80;;}
$land_lhs_true284$$if_end287$109:do{if(__label__==78){var $162=$prev_thousands;var $tobool285=((($162))|0)!=0;if(!($tobool285)){__label__=80;break $land_lhs_true284$$if_end287$109;}
$suppress_null=1;;}}while(0);var $163=$tr_addr;var $translator_name288=(($163+280)&4294967295);var $164=HEAP32[(($translator_name288)>>2)];var $cmp289=((($164))|0)==26741;if($cmp289){__label__=81;;}else{__label__=85;;}
$if_then290$$if_end304$113:do{if(__label__==81){var $165=$thousandplex;var $166=$wtab_addr;var $arrayidx291=(($166+12*$165)&4294967295);var $flags292=(($arrayidx291)&4294967295);var $167=HEAP32[(($flags292)>>2)];var $and293=($167)&16384;var $tobool294=((($and293))|0)!=0;if(!($tobool294)){__label__=85;break $if_then290$$if_end304$113;}
var $168=$thousands_exact;var $cmp296=((($168))|0)==1;if(!($cmp296)){__label__=85;break $if_then290$$if_end304$113;}
var $169=$suffix_ix;var $170=$word_addr;var $arrayidx298=(($170+$169)&4294967295);var $171=$thousandplex;var $172=$value;var $call299=__ZL11hu_number_ePKcii($arrayidx298,$171,$172);var $tobool300=((($call299))|0)!=0;if(!($tobool300)){__label__=85;break $if_then290$$if_end304$113;}
var $173=HEAP32[((__ZL14number_control)>>2)];var $or302=($173)|1;HEAP32[((__ZL14number_control)>>2)]=$or302;;}}while(0);var $174=$n_digits;var $175=$word_addr;var $arrayidx305=(($175+$174)&4294967295);var $176=HEAP8[($arrayidx305)];var $conv306=(tempInt=(($176)),(tempInt>=128?tempInt-256:tempInt));var $177=$tr_addr;var $langopts307=(($177)&4294967295);var $decimal_sep308=(($langopts307+208)&4294967295);var $178=HEAP32[(($decimal_sep308)>>2)];var $cmp309=((($conv306))|0)==((($178))|0);if($cmp309){__label__=86;;}else{__label__=88;;}
$land_lhs_true310$$if_else319$119:do{if(__label__==86){var $179=$n_digits;var $add311=((($179)+1)&4294967295);var $180=$word_addr;var $arrayidx312=(($180+$add311)&4294967295);var $181=HEAP8[($arrayidx312)];var $conv313=(tempInt=(($181)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp28=((($conv313)-48)&4294967295);var $isdigit29=((($isdigittmp28))>>>0)<10;var $call314=((($isdigit29))&1);var $tobool315=((($call314))|0)!=0;if(!($tobool315)){__label__=88;break $land_lhs_true310$$if_else319$119;}
var $182=$tr_addr;var $arraydecay317=(($ph_append)&4294967295);var $call318=__Z6LookupP10TranslatorPKcPc($182,((__str17314)&4294967295),$arraydecay317);$decimal_point=1;__label__=98;break $land_lhs_true310$$if_else319$119;}}while(0);$if_end356$$if_else319$122:do{if(__label__==88){var $183=$suppress_null;var $cmp320=((($183))|0)==0;if($cmp320){__label__=89;;}else{__label__=95;;}
if(__label__==89){var $184=$thousands_inc;var $cmp322=((($184))|0)>0;if(!($cmp322)){__label__=98;break $if_end356$$if_else319$122;}
var $185=$thousandplex;var $cmp324=((($185))|0)>0;if(!($cmp324)){__label__=98;break $if_end356$$if_else319$122;}
var $186=$value;var $cmp326=((($186))|0)<1000;if(!($cmp326)){__label__=98;break $if_end356$$if_else319$122;}
var $187=$suppress_null;var $cmp328=((($187))|0)==0;if(!($cmp328)){__label__=98;break $if_end356$$if_else319$122;}
var $188=$tr_addr;var $189=$value;var $190=$thousandplex;var $191=$thousands_exact;var $arraydecay330=(($ph_append)&4294967295);var $call331=__ZL15LookupThousandsP10TranslatoriiiPc($188,$189,$190,$191,$arraydecay330);var $tobool332=((($call331))|0)!=0;if(!($tobool332)){__label__=98;break $if_end356$$if_else319$122;}
$value=0;$suppress_null=1;;}
else if(__label__==95){var $192=HEAP32[((__ZL23speak_missing_thousands)>>2)];var $cmp338=((($192))|0)==1;if(!($cmp338)){__label__=98;break $if_end356$$if_else319$122;}
var $arraydecay340=(($string)&4294967295);var $193=$thousandplex;var $add341=((($193)+1)&4294967295);var $call342=_sprintf($arraydecay340,((__str18315)&4294967295),allocate([$add341,0,0,0],["i32",0,0,0],ALLOC_STACK));var $194=$tr_addr;var $arraydecay343=(($string)&4294967295);var $arraydecay344=(($buf1)&4294967295);var $call345=__Z6LookupP10TranslatorPKcPc($194,$arraydecay343,$arraydecay344);var $cmp346=((($call345))|0)==0;if(!($cmp346)){__label__=98;break $if_end356$$if_else319$122;}
var $arraydecay348=(($string)&4294967295);var $195=$thousandplex;var $call349=_sprintf($arraydecay348,((__str18315)&4294967295),allocate([$195,0,0,0],["i32",0,0,0],ALLOC_STACK));var $196=$tr_addr;var $arraydecay350=(($string)&4294967295);var $arraydecay351=(($ph_append)&4294967295);var $call352=__Z6LookupP10TranslatorPKcPc($196,$arraydecay350,$arraydecay351);;}}}while(0);var $arrayidx357=(($ph_append)&4294967295);var $197=HEAP8[($arrayidx357)];var $conv358=(tempInt=(($197)),(tempInt>=128?tempInt-256:tempInt));var $cmp359=((($conv358))|0)==0;if($cmp359){__label__=99;;}else{__label__=102;;}
$land_lhs_true360$$if_end369$135:do{if(__label__==99){var $198=$n_digits;var $199=$word_addr;var $arrayidx361=(($199+$198)&4294967295);var $200=HEAP8[($arrayidx361)];var $conv362=(tempInt=(($200)),(tempInt>=128?tempInt-256:tempInt));var $cmp363=((($conv362))|0)==46;if(!($cmp363)){__label__=102;break $land_lhs_true360$$if_end369$135;}
var $201=$thousandplex;var $cmp365=((($201))|0)==0;if(!($cmp365)){__label__=112;break $land_lhs_true360$$if_end369$135;}
var $202=$tr_addr;var $arraydecay367=(($ph_append)&4294967295);var $call368=__Z6LookupP10TranslatorPKcPc($202,((__str19316)&4294967295),$arraydecay367);__label__=102;break $land_lhs_true360$$if_end369$135;}}while(0);$if_end369$$if_end404$139:do{if(__label__==102){var $_pr47=$thousandplex;var $cmp370=((($_pr47))|0)==0;if(!($cmp370)){__label__=112;break $if_end369$$if_end404$139;}
var $203=$word_addr;HEAP32[(($p)>>2)]=$203;var $204=HEAP32[(($p)>>2)];var $arrayidx37360=(($204+1)&4294967295);var $205=HEAP8[($arrayidx37360)];var $conv37461=(tempInt=(($205)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp3062=((($conv37461)-48)&4294967295);var $isdigit3163=((($isdigittmp3062))>>>0)<10;var $206=HEAPU32[(($p)>>2)];if($isdigit3163){__lastLabel__=103;__label__=104;;}else{__lastLabel__=103;__label__=105;;}
$while_body377$$while_end379$142:do{if(__label__==104){while(1){var $207=__lastLabel__==104?$210:($206);var $incdec_ptr378=(($207+1)&4294967295);HEAP32[(($p)>>2)]=$incdec_ptr378;var $208=HEAP32[(($p)>>2)];var $arrayidx373=(($208+1)&4294967295);var $209=HEAP8[($arrayidx373)];var $conv374=(tempInt=(($209)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp30=((($conv374)-48)&4294967295);var $isdigit31=((($isdigittmp30))>>>0)<10;var $call375=((($isdigit31))&1);var $tobool376=((($call375))|0)!=0;var $210=HEAPU32[(($p)>>2)];if($tobool376){__lastLabel__=104;__label__=104;continue;}else{__lastLabel__=104;__label__=105;break $while_body377$$while_end379$142;}}}}while(0);var $_lcssa=__lastLabel__==103?$206:($210);var $arrayidx380=(($_lcssa+-1)&4294967295);var $211=HEAP8[($arrayidx380)];var $conv381=(tempInt=(($211)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp32=((($conv381)-48)&4294967295);var $isdigit33=((($isdigittmp32))>>>0)<10;var $call382=((($isdigit33))&1);var $tobool383=((($call382))|0)!=0;if($tobool383){__label__=106;;}else{__label__=108;;}
$if_then384$$if_end390$146:do{if(__label__==106){var $212=HEAP32[(($p)>>2)];var $add_ptr=(($212+-1)&4294967295);HEAP32[(($p2)>>2)]=$add_ptr;var $213=$tr_addr;var $arraydecay385=(($buf_digit_lookup)&4294967295);var $214=$flags_addr;var $215=$wtab_addr;var $call386=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($213,$p2,$arraydecay385,$214,4,$215);var $tobool387=((($call386))|0)!=0;if(!($tobool387)){__label__=108;break $if_then384$$if_end390$146;}
HEAP32[((__ZL14n_digit_lookup)>>2)]=2;;}}while(0);var $arrayidx391=(($buf_digit_lookup)&4294967295);var $216=HEAP8[($arrayidx391)];var $conv392=(tempInt=(($216)),(tempInt>=128?tempInt-256:tempInt));var $cmp393=((($conv392))|0)==0;if(!($cmp393)){__label__=112;break $if_end369$$if_end404$139;}
var $217=HEAP32[(($p)>>2)];var $218=HEAP8[($217)];var $conv395=(tempInt=(($218)),(tempInt>=128?tempInt-256:tempInt));var $cmp396=((($conv395))|0)!=48;if(!($cmp396)){__label__=112;break $if_end369$$if_end404$139;}
var $219=$tr_addr;var $arraydecay398=(($buf_digit_lookup)&4294967295);var $220=$flags_addr;var $221=$wtab_addr;var $call399=__Z14LookupDictListP10TranslatorPPcS1_PjiP8WORD_TAB($219,$p,$arraydecay398,$220,4,$221);var $tobool400=((($call399))|0)!=0;if(!($tobool400)){__label__=112;break $if_end369$$if_end404$139;}
HEAP32[((__ZL14n_digit_lookup)>>2)]=1;;}}while(0);var $222=$tr_addr;var $223=$value;var $arraydecay405=(($ph_buf)&4294967295);var $224=$suppress_null;var $225=$thousandplex;var $226=$prev_thousands;var $227=$ordinal;var $or406=($227)|($226);__ZL10LookupNum3P10TranslatoriPciii($222,$223,$arraydecay405,$224,$225,$or406);var $228=$thousandplex;var $cmp408=((($228))|0)>0;if($cmp408){__label__=113;;}else{__label__=115;;}
$land_lhs_true409$$if_else419$154:do{if(__label__==113){var $229=$tr_addr;var $langopts410=(($229)&4294967295);var $numbers2=(($langopts410+188)&4294967295);var $230=HEAP32[(($numbers2)>>2)];var $and411=($230)&512;var $tobool412=((($and411))|0)!=0;if(!($tobool412)){__label__=115;break $land_lhs_true409$$if_else419$154;}
var $231=$ph_out_addr;var $arraydecay414=(($ph_zeros)&4294967295);var $arraydecay415=(($ph_append)&4294967295);var $arraydecay416=(($ph_buf2)&4294967295);var $arraydecay417=(($ph_buf)&4294967295);var $call418=_sprintf($231,((__str20317)&4294967295),allocate([$arraydecay414,0,0,0,$arraydecay415,0,0,0,$arraydecay416,0,0,0,$arraydecay417,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));__label__=116;break $land_lhs_true409$$if_else419$154;}}while(0);if(__label__==115){var $232=$ph_out_addr;var $arraydecay420=(($ph_zeros)&4294967295);var $arraydecay421=(($ph_buf2)&4294967295);var $arraydecay422=(($ph_buf)&4294967295);var $arraydecay423=(($ph_append)&4294967295);var $call424=_sprintf($232,((__str20317)&4294967295),allocate([$arraydecay420,0,0,0,$arraydecay421,0,0,0,$arraydecay422,0,0,0,$arraydecay423,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
var $arraydecay472=(($ph_buf)&4294967295);var $arraydecay480=(($string)&4294967295);var $arraydecay482=(($string)&4294967295);var $arraydecay483=(($buf1)&4294967295);var $arraydecay488=(($ph_buf)&4294967295);var $arraydecay489=(($buf1)&4294967295);var $arraydecay492=(($ph_buf)&4294967295);var $arraydecay504=(($buf1)&4294967295);var $arraydecay506=(($buf1)&4294967295);var $arraydecay463=(($buf1)&4294967295);var $arraydecay465=(($buf1)&4294967295);var $arraydecay448=(($buf1)&4294967295);var $arraydecay450=(($buf1)&4294967295);var $arraydecay524=(($buf1)&4294967295);var $arraydecay526=(($buf1)&4294967295);var $arraydecay529=(($buf1)&4294967295);var $arraydecay533=(($buf1)&4294967295);var $arraydecay547=(($buf1)&4294967295);var $arraydecay549=(($buf1)&4294967295);;$while_cond426thread_pre_split$160:while(1){var $_pr49=$decimal_point;__lastLabel__=117;;$while_cond426$162:while(1){var $233=__lastLabel__==117?$_pr49:(0);var $tobool427=((($233))|0)!=0;if(!($tobool427)){__label__=145;break $while_cond426thread_pre_split$160;}
var $234=$n_digits;var $inc429=((($234)+1)&4294967295);$n_digits=$inc429;$decimal_count=0;var $235=$n_digits;var $236=$decimal_count;var $add43153=((($236)+($235))&4294967295);var $237=$word_addr;var $arrayidx43254=(($237+$add43153)&4294967295);var $238=HEAP8[($arrayidx43254)];var $conv43355=(tempInt=(($238)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp3456=((($conv43355)-48)&4294967295);var $isdigit3557=((($isdigittmp3456))>>>0)<10;var $call43458=((($isdigit3557))&1);var $tobool43559=((($call43458))|0)!=0;if($tobool43559){__label__=120;;}else{__label__=121;;}
$while_body436$$while_end438$165:do{if(__label__==120){while(1){var $239=$decimal_count;var $inc437=((($239)+1)&4294967295);$decimal_count=$inc437;var $240=$n_digits;var $241=$decimal_count;var $add431=((($241)+($240))&4294967295);var $242=$word_addr;var $arrayidx432=(($242+$add431)&4294967295);var $243=HEAP8[($arrayidx432)];var $conv433=(tempInt=(($243)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp34=((($conv433)-48)&4294967295);var $isdigit35=((($isdigittmp34))>>>0)<10;var $call434=((($isdigit35))&1);var $tobool435=((($call434))|0)!=0;if($tobool435){__label__=120;continue;}else{__label__=121;break $while_body436$$while_end438$165;}}}}while(0);$max_decimal_count=2;var $244=$tr_addr;var $langopts439=(($244)&4294967295);var $numbers440=(($langopts439+184)&4294967295);var $245=HEAP32[(($numbers440)>>2)];var $and441=($245)&57344;$decimal_mode=$and441;if($and441==32768){__label__=122;;}
else if($and441==16384){__label__=123;;}
else if($and441==8192){__label__=128;;}
else if($and441==40960){__label__=128;;}
else if($and441==24576){__label__=133;;}
else{__label__=136;;}
$while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169:do{if(__label__==122){$max_decimal_count=5;__label__=123;break $while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169;}
else if(__label__==128){var $267=$tr_addr;var $268=$n_digits;var $269=$word_addr;var $arrayidx470=(($269+$268)&4294967295);var $call471=_atoi($arrayidx470);__ZL10LookupNum3P10TranslatoriPciii($267,$call471,$arraydecay472,0,0,0);var $270=$n_digits;var $271=$word_addr;var $arrayidx474=(($271+$270)&4294967295);var $272=HEAP8[($arrayidx474)];var $conv475=(tempInt=(($272)),(tempInt>=128?tempInt-256:tempInt));var $cmp476=((($conv475))|0)==48;if($cmp476){__label__=130;;}else{__label__=129;;}
$if_then479$$lor_lhs_false477$172:do{if(__label__==129){var $273=$decimal_mode;var $cmp478=((($273))|0)==40960;if($cmp478){__label__=130;break $if_then479$$lor_lhs_false477$172;}else{__label__=132;break $if_then479$$lor_lhs_false477$172;}}}while(0);if(__label__==130){var $274=$decimal_count;var $call481=_sprintf($arraydecay480,((__str21318)&4294967295),allocate([$274,0,0,0],["i32",0,0,0],ALLOC_STACK));var $275=$tr_addr;var $call484=__Z6LookupP10TranslatorPKcPc($275,$arraydecay482,$arraydecay483);var $cmp485=((($call484))|0)==0;if($cmp485){__label__=136;break $while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169;}
var $call490=_strcat($arraydecay488,$arraydecay489);;}
var $276=$ph_out_addr;var $call493=_strcat($276,$arraydecay492);var $277=$decimal_count;var $278=$n_digits;var $add494=((($278)+($277))&4294967295);$n_digits=$add494;__label__=136;break $while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169;}
else if(__label__==133){var $279=$decimal_count;var $cmp496=((($279))|0)<=4;if(!($cmp496)){__label__=136;break $while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169;}
var $280=$n_digits;var $281=$word_addr;var $arrayidx498=(($281+$280)&4294967295);var $282=HEAP8[($arrayidx498)];var $conv499=(tempInt=(($282)),(tempInt>=128?tempInt-256:tempInt));var $cmp500=((($conv499))|0)!=48;if(!($cmp500)){__label__=136;break $while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169;}
var $283=$tr_addr;var $284=$n_digits;var $285=$word_addr;var $arrayidx502=(($285+$284)&4294967295);var $call503=_atoi($arrayidx502);__ZL10LookupNum3P10TranslatoriPciii($283,$call503,$arraydecay504,0,0,0);var $286=$ph_out_addr;var $call507=_strcat($286,$arraydecay506);var $287=$decimal_count;var $288=$n_digits;var $add508=((($288)+($287))&4294967295);$n_digits=$add508;__label__=136;break $while_cond510$$sw_bb$$while_cond443_preheader$$sw_bb469$$sw_bb495$169;}}while(0);$while_cond510$$while_cond443_preheader$181:do{if(__label__==123){var $246=$n_digits;var $247=$word_addr;var $arrayidx44450=(($247+$246)&4294967295);var $248=HEAP8[($arrayidx44450)];var $conv44551=(tempInt=(($248)),(tempInt>=128?tempInt-256:tempInt));var $cmp44652=((($conv44551))|0)==48;if($cmp44652){__label__=124;;}else{__label__=125;;}
$while_body447$$while_end453$183:do{if(__label__==124){while(1){var $249=$tr_addr;var $call449=__Z6LookupP10TranslatorPKcPc($249,((__str16313)&4294967295),$arraydecay448);var $250=$ph_out_addr;var $call451=_strcat($250,$arraydecay450);var $251=$decimal_count;var $dec=((($251)-1)&4294967295);$decimal_count=$dec;var $252=$n_digits;var $inc452=((($252)+1)&4294967295);$n_digits=$inc452;var $253=$n_digits;var $254=$word_addr;var $arrayidx444=(($254+$253)&4294967295);var $255=HEAP8[($arrayidx444)];var $conv445=(tempInt=(($255)),(tempInt>=128?tempInt-256:tempInt));var $cmp446=((($conv445))|0)==48;if($cmp446){__label__=124;continue;}else{__label__=125;break $while_body447$$while_end453$183;}}}}while(0);var $256=$decimal_count;var $257=$max_decimal_count;var $cmp454=((($256))|0)<=((($257))|0);if(!($cmp454)){__label__=136;break $while_cond510$$while_cond443_preheader$181;}
var $258=$n_digits;var $259=$word_addr;var $arrayidx456=(($259+$258)&4294967295);var $260=HEAP8[($arrayidx456)];var $conv457=(tempInt=(($260)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp36=((($conv457)-48)&4294967295);var $isdigit37=((($isdigittmp36))>>>0)<10;var $call458=((($isdigit37))&1);var $tobool459=((($call458))|0)!=0;if(!($tobool459)){__label__=136;break $while_cond510$$while_cond443_preheader$181;}
var $261=$tr_addr;var $262=$n_digits;var $263=$word_addr;var $arrayidx461=(($263+$262)&4294967295);var $call462=_atoi($arrayidx461);__ZL10LookupNum3P10TranslatoriPciii($261,$call462,$arraydecay463,0,0,0);var $264=$ph_out_addr;var $call466=_strcat($264,$arraydecay465);var $265=$decimal_count;var $266=$n_digits;var $add467=((($266)+($265))&4294967295);$n_digits=$add467;;}}while(0);while(1){var $289=$n_digits;var $290=$word_addr;var $arrayidx511=(($290+$289)&4294967295);var $291=HEAPU8[($arrayidx511)];$c=$291;var $conv512=((($291))&255);var $isdigittmp38=((($conv512)-48)&4294967295);var $isdigit39=((($isdigittmp38))>>>0)<10;var $call513=((($isdigit39))&1);var $tobool514=((($call513))|0)!=0;if(!($tobool514)){__label__=139;break;}
var $292=$ph_out_addr;var $call516=_strlen($292);var $cmp517=((($call516))>>>0)<150;if(!($cmp517)){__label__=139;break;}
var $293=$n_digits;var $inc520=((($293)+1)&4294967295);$n_digits=$inc520;var $294=$word_addr;var $arrayidx521=(($294+$293)&4294967295);var $295=HEAP8[($arrayidx521)];var $conv522=(tempInt=(($295)),(tempInt>=128?tempInt-256:tempInt));var $sub523=((($conv522)-48)&4294967295);$value=$sub523;var $296=$tr_addr;var $297=$value;var $call525=__ZL10LookupNum2P10TranslatoriiPc($296,$297,2,$arraydecay524);var $298=$ph_out_addr;var $call527=_strcat($298,$arraydecay526);__label__=136;continue;}
var $299=$tr_addr;var $call530=__Z6LookupP10TranslatorPKcPc($299,((__str22319)&4294967295),$arraydecay529);var $tobool531=((($call530))|0)!=0;if($tobool531){__label__=140;;}else{__label__=141;;}
if(__label__==140){var $300=$ph_out_addr;var $call534=_strcat($300,$arraydecay533);;}
var $301=$c;var $conv536=((($301))&255);var $302=$tr_addr;var $langopts537=(($302)&4294967295);var $decimal_sep538=(($langopts537+208)&4294967295);var $303=HEAP32[(($decimal_sep538)>>2)];var $cmp539=((($conv536))|0)==((($303))|0);if($cmp539){__label__=142;;}else{__label__=144;;}
if(__label__==142){var $304=$n_digits;var $add541=((($304)+1)&4294967295);var $305=$word_addr;var $arrayidx542=(($305+$add541)&4294967295);var $306=HEAP8[($arrayidx542)];var $conv543=(tempInt=(($306)),(tempInt>=128?tempInt-256:tempInt));var $isdigittmp40=((($conv543)-48)&4294967295);var $isdigit41=((($isdigittmp40))>>>0)<10;var $call544=((($isdigit41))&1);var $tobool545=((($call544))|0)!=0;if($tobool545){__label__=143;break $while_cond426$162;}}
$decimal_point=0;__lastLabel__=144;__label__=118;continue $while_cond426$162;}
var $307=$tr_addr;var $call548=__Z6LookupP10TranslatorPKcPc($307,((__str17314)&4294967295),$arraydecay547);var $308=$ph_out_addr;var $call550=_strcat($308,$arraydecay549);__label__=117;continue $while_cond426thread_pre_split$160;}
var $309=$ph_out_addr;var $arrayidx554=(($309)&4294967295);var $310=HEAP8[($arrayidx554)];var $conv555=(tempInt=(($310)),(tempInt>=128?tempInt-256:tempInt));var $cmp556=((($conv555))|0)!=0;if($cmp556){__label__=146;;}else{__label__=154;;}
$land_lhs_true557$$if_end588$202:do{if(__label__==146){var $311=$ph_out_addr;var $arrayidx558=(($311)&4294967295);var $312=HEAP8[($arrayidx558)];var $conv559=(tempInt=(($312)),(tempInt>=128?tempInt-256:tempInt));var $cmp560=((($conv559))|0)!=21;if(!($cmp560)){__label__=154;break $land_lhs_true557$$if_end588$202;}
var $313=$n_digits;var $add563=((($313)+1)&4294967295);var $314=$word_addr;var $arrayidx564=(($314+$add563)&4294967295);$p562=$arrayidx564;var $315=$p562;var $call565=__Z7utf8_inPiPKc($next_char,$315);var $316=$p562;var $add_ptr566=(($316+$call565)&4294967295);$p562=$add_ptr566;var $317=$tr_addr;var $langopts567=(($317)&4294967295);var $numbers568=(($langopts567+184)&4294967295);var $318=HEAP32[(($numbers568)>>2)];var $and569=($318)&131072;var $tobool570=((($and569))|0)!=0;if($tobool570){__label__=148;;}else{__label__=150;;}
$land_lhs_true571$$if_end575$205:do{if(__label__==148){var $319=HEAP32[(($next_char)>>2)];var $cmp572=((($319))|0)==32;if(!($cmp572)){__label__=150;break $land_lhs_true571$$if_end575$205;}
var $320=$p562;var $call574=__Z7utf8_inPiPKc($next_char,$320);;}}while(0);var $321=HEAP32[(($next_char)>>2)];var $call576=_iswalpha($321);var $tobool577=((($call576))|0)!=0;if($tobool577){__label__=154;break $land_lhs_true557$$if_end588$202;}
var $322=$thousandplex;var $323=$wtab_addr;var $arrayidx579=(($323+12*$322)&4294967295);var $flags580=(($arrayidx579)&4294967295);var $324=HEAP32[(($flags580)>>2)];var $and581=($324)&16384;var $tobool582=((($and581))|0)!=0;if($tobool582){__label__=152;;}else{__label__=153;;}
if(__label__==152){var $325=$thousands_exact;var $cmp584=((($325))|0)!=0;if($cmp584){__label__=154;break $land_lhs_true557$$if_end588$202;}}
var $326=$ph_out_addr;var $strlen=_strlen($326);var $endptr=(($326+$strlen)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__ZZL17TranslateNumber_1P10TranslatorPcS1_PjP8WORD_TABiE9str_pause)&4294967295);$dest$=$endptr;$stop$=$src$+2;if(($dest$%4)==($src$%4)&&2>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};;}}while(0);var $327=$flags_addr;var $328=HEAP32[(($327)>>2)];var $or589=($328)|-2147483648;HEAP32[(($327)>>2)]=$or589;var $329=HEAP32[((__ZL23speak_missing_thousands)>>2)];var $dec590=((($329)-1)&4294967295);HEAP32[((__ZL23speak_missing_thousands)>>2)]=$dec590;var $330=$skipwords;var $tobool591=((($330))|0)!=0;if($tobool591){__label__=155;;}else{__label__=156;;}
if(__label__==155){var $331=$skipwords;HEAP32[((_dictionary_skipwords)>>2)]=$331;;}
$retval=1;;}
var $332=$retval;STACKTOP=__stackBase__;return $332;return null;}
function __ZL15LookupThousandsP10TranslatoriiiPc($tr,$value,$thousandplex,$thousands_exact,$ph_out){var __stackBase__=STACKTOP;STACKTOP+=104;_memset(__stackBase__,0,104);var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $value_addr;var $thousandplex_addr;var $thousands_exact_addr;var $ph_out_addr;var $found;var $found_value;var $string=__stackBase__;var $ph_of=__stackBase__+12;var $ph_thousands=__stackBase__+24;var $ph_buf=__stackBase__+64;$tr_addr=$tr;$value_addr=$value;$thousandplex_addr=$thousandplex;$thousands_exact_addr=$thousands_exact;$ph_out_addr=$ph_out;$found_value=0;var $arrayidx=(($ph_of)&4294967295);HEAP8[($arrayidx)]=0;var $0=$value_addr;var $cmp=((($0))|0)>0;if($cmp){__label__=1;;}else{__label__=12;;}
$if_then$$if_end36thread_pre_split$2:do{if(__label__==1){var $1=$thousands_exact_addr;var $and=($1)&1;var $tobool=((($and))|0)!=0;if($tobool){__label__=2;;}else{__label__=9;;}
$if_then1$$if_end27thread_pre_split$4:do{if(__label__==2){var $2=$thousands_exact_addr;var $and2=($2)&2;var $tobool3=((($and2))|0)!=0;if($tobool3){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $arraydecay=(($string)&4294967295);var $3=$value_addr;var $4=$thousandplex_addr;var $call=_sprintf($arraydecay,((__str42339)&4294967295),allocate([$3,0,0,0,$4,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $5=$tr_addr;var $arraydecay5=(($string)&4294967295);var $arraydecay6=(($ph_thousands)&4294967295);var $call7=__Z6LookupP10TranslatorPKcPc($5,$arraydecay5,$arraydecay6);$found_value=$call7;;}
var $6=$found_value;var $tobool8=((($6))|0)!=0;var $lnot=($tobool8)^1;var $conv=((($lnot))&1);var $7=HEAP32[((__ZL14number_control)>>2)];var $and9=($7)&1;var $and10=($and9)&($conv);var $tobool11=((($and10))|0)!=0;if($tobool11){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $arraydecay13=(($string)&4294967295);var $8=$value_addr;var $9=$thousandplex_addr;var $call14=_sprintf($arraydecay13,((__str43340)&4294967295),allocate([$8,0,0,0,$9,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $10=$tr_addr;var $arraydecay15=(($string)&4294967295);var $arraydecay16=(($ph_thousands)&4294967295);var $call17=__Z6LookupP10TranslatorPKcPc($10,$arraydecay15,$arraydecay16);$found_value=$call17;__lastLabel__=5;;}
else if(__label__==6){var $_pr=$found_value;__lastLabel__=6;;}
var $11=__lastLabel__==6?$_pr:($call17);var $tobool19=((($11))|0)!=0;if($tobool19){__label__=9;break $if_then1$$if_end27thread_pre_split$4;}
var $arraydecay21=(($string)&4294967295);var $12=$value_addr;var $13=$thousandplex_addr;var $call22=_sprintf($arraydecay21,((__str44341)&4294967295),allocate([$12,0,0,0,$13,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $14=$tr_addr;var $arraydecay23=(($string)&4294967295);var $arraydecay24=(($ph_thousands)&4294967295);var $call25=__Z6LookupP10TranslatorPKcPc($14,$arraydecay23,$arraydecay24);$found_value=$call25;__lastLabel__=8;__label__=10;break $if_then1$$if_end27thread_pre_split$4;}}while(0);if(__label__==9){var $_pr1=$found_value;__lastLabel__=9;;}
var $15=__lastLabel__==9?$_pr1:($call25);var $cmp28=((($15))|0)==0;if(!($cmp28)){__label__=12;break $if_then$$if_end36thread_pre_split$2;}
var $arraydecay30=(($string)&4294967295);var $16=$value_addr;var $17=$thousandplex_addr;var $call31=_sprintf($arraydecay30,((__str45342)&4294967295),allocate([$16,0,0,0,$17,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $18=$tr_addr;var $arraydecay32=(($string)&4294967295);var $arraydecay33=(($ph_thousands)&4294967295);var $call34=__Z6LookupP10TranslatorPKcPc($18,$arraydecay32,$arraydecay33);$found_value=$call34;__lastLabel__=11;__label__=13;break $if_then$$if_end36thread_pre_split$2;}}while(0);if(__label__==12){var $_pr2=$found_value;__lastLabel__=12;;}
var $19=__lastLabel__==12?$_pr2:($call34);var $cmp37=((($19))|0)==0;if($cmp37){__label__=14;;}else{__label__=36;;}
$if_then38$$if_end118$21:do{if(__label__==14){var $20=$value_addr;var $rem=((($20))|0)%100;var $cmp39=((($rem))|0)>=20;if($cmp39){__label__=15;;}else{__label__=16;;}
if(__label__==15){var $21=$tr_addr;var $arraydecay41=(($ph_of)&4294967295);var $call42=__Z6LookupP10TranslatorPKcPc($21,((__str46343)&4294967295),$arraydecay41);;}
$found=0;var $22=$thousands_exact_addr;var $and44=($22)&1;var $tobool45=((($and44))|0)!=0;if($tobool45){__label__=17;;}else{__label__=28;;}
if(__label__==17){var $23=$thousands_exact_addr;var $and47=($23)&2;var $tobool48=((($and47))|0)!=0;if($tobool48){__label__=18;;}else{__label__=19;;}
if(__label__==18){var $arraydecay50=(($string)&4294967295);var $24=$value_addr;var $call51=__ZL9M_Varianti($24);var $25=$thousandplex_addr;var $call52=_sprintf($arraydecay50,((__str47344)&4294967295),allocate([$call51,0,0,0,$25,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));var $26=$tr_addr;var $arraydecay53=(($string)&4294967295);var $arraydecay54=(($ph_thousands)&4294967295);var $call55=__Z6LookupP10TranslatorPKcPc($26,$arraydecay53,$arraydecay54);$found=$call55;__lastLabel__=18;;}
else if(__label__==19){var $_pr3=$found;__lastLabel__=19;;}
var $27=__lastLabel__==19?$_pr3:($call55);var $tobool57=((($27))|0)!=0;if($tobool57){__label__=23;;}else{__label__=21;;}
$if_end67thread_pre_split$$land_lhs_true$32:do{if(__label__==21){var $28=HEAP32[((__ZL14number_control)>>2)];var $and58=($28)&1;var $tobool59=((($and58))|0)!=0;if(!($tobool59)){__label__=23;break $if_end67thread_pre_split$$land_lhs_true$32;}
var $arraydecay61=(($string)&4294967295);var $29=$value_addr;var $call62=__ZL9M_Varianti($29);var $30=$thousandplex_addr;var $call63=_sprintf($arraydecay61,((__str48345)&4294967295),allocate([$call62,0,0,0,$30,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));var $31=$tr_addr;var $arraydecay64=(($string)&4294967295);var $arraydecay65=(($ph_thousands)&4294967295);var $call66=__Z6LookupP10TranslatorPKcPc($31,$arraydecay64,$arraydecay65);$found=$call66;__lastLabel__=22;__label__=24;break $if_end67thread_pre_split$$land_lhs_true$32;}}while(0);if(__label__==23){var $_pr4=$found;__lastLabel__=23;;}
var $32=__lastLabel__==23?$_pr4:($call66);var $tobool68=((($32))|0)!=0;if($tobool68){__label__=26;;}else{__label__=25;;}
if(__label__==26){var $_pr5=$found;__lastLabel__=26;;}
else if(__label__==25){var $arraydecay70=(($string)&4294967295);var $33=$value_addr;var $call71=__ZL9M_Varianti($33);var $34=$thousandplex_addr;var $call72=_sprintf($arraydecay70,((__str49346)&4294967295),allocate([$call71,0,0,0,$34,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));var $35=$tr_addr;var $arraydecay73=(($string)&4294967295);var $arraydecay74=(($ph_thousands)&4294967295);var $call75=__Z6LookupP10TranslatorPKcPc($35,$arraydecay73,$arraydecay74);$found=$call75;__lastLabel__=25;;}
var $36=__lastLabel__==26?$_pr5:($call75);var $cmp78=((($36))|0)==0;if(!($cmp78)){__label__=36;break $if_then38$$if_end118$21;}}
var $arraydecay80=(($string)&4294967295);var $37=$value_addr;var $call81=__ZL9M_Varianti($37);var $38=$thousandplex_addr;var $call82=_sprintf($arraydecay80,((__str50347)&4294967295),allocate([$call81,0,0,0,$38,0,0,0],["i8*",0,0,0,"i32",0,0,0],ALLOC_STACK));var $39=$tr_addr;var $arraydecay83=(($string)&4294967295);var $arraydecay84=(($ph_thousands)&4294967295);var $call85=__Z6LookupP10TranslatorPKcPc($39,$arraydecay83,$arraydecay84);var $cmp86=((($call85))|0)==0;if(!($cmp86)){__label__=36;break $if_then38$$if_end118$21;}
var $40=$thousandplex_addr;var $cmp88=((($40))|0)>3;if($cmp88){__label__=30;;}else{__label__=32;;}
$if_then89$$if_end100$44:do{if(__label__==30){var $arraydecay90=(($string)&4294967295);var $41=$thousandplex_addr;var $sub=((($41)-1)&4294967295);var $call91=_sprintf($arraydecay90,((__str18315)&4294967295),allocate([$sub,0,0,0],["i32",0,0,0],ALLOC_STACK));var $42=$tr_addr;var $arraydecay92=(($string)&4294967295);var $arraydecay93=(($ph_buf)&4294967295);var $call94=__Z6LookupP10TranslatorPKcPc($42,$arraydecay92,$arraydecay93);var $cmp95=((($call94))|0)==0;if(!($cmp95)){__label__=32;break $if_then89$$if_end100$44;}
var $43=$tr_addr;var $arraydecay97=(($ph_thousands)&4294967295);var $call98=__Z6LookupP10TranslatorPKcPc($43,((__str51348)&4294967295),$arraydecay97);HEAP32[((__ZL23speak_missing_thousands)>>2)]=3;;}}while(0);var $arrayidx101=(($ph_thousands)&4294967295);var $44=HEAP8[($arrayidx101)];var $conv102=(tempInt=(($44)),(tempInt>=128?tempInt-256:tempInt));var $cmp103=((($conv102))|0)==0;if(!($cmp103)){__label__=36;break $if_then38$$if_end118$21;}
var $arraydecay105=(($string)&4294967295);var $45=$value_addr;var $call106=_sprintf($arraydecay105,((__str52349)&4294967295),allocate([$45,0,0,0],["i32",0,0,0],ALLOC_STACK));var $46=$tr_addr;var $arraydecay107=(($string)&4294967295);var $arraydecay108=(($ph_thousands)&4294967295);var $call109=__Z6LookupP10TranslatorPKcPc($46,$arraydecay107,$arraydecay108);$found_value=$call109;var $cmp110=((($call109))|0)==0;if($cmp110){__label__=34;;}else{__label__=35;;}
if(__label__==34){var $47=$tr_addr;var $arraydecay112=(($ph_thousands)&4294967295);var $call113=__Z6LookupP10TranslatorPKcPc($47,((__str53350)&4294967295),$arraydecay112);;}
HEAP32[((__ZL23speak_missing_thousands)>>2)]=2;;}}while(0);var $48=$ph_out_addr;var $arraydecay119=(($ph_of)&4294967295);var $arraydecay120=(($ph_thousands)&4294967295);var $call121=_sprintf($48,((__str47699)&4294967295),allocate([$arraydecay119,0,0,0,$arraydecay120,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $49=$value_addr;var $cmp122=((($49))|0)==1;if($cmp122){__label__=37;;}else{__label__=40;;}
$land_lhs_true123$$if_end129$53:do{if(__label__==37){var $50=$thousandplex_addr;var $cmp124=((($50))|0)==1;if(!($cmp124)){__label__=40;break $land_lhs_true123$$if_end129$53;}
var $51=$tr_addr;var $langopts=(($51)&4294967295);var $numbers=(($langopts+184)&4294967295);var $52=HEAP32[(($numbers)>>2)];var $and126=($52)&2097152;var $tobool127=((($and126))|0)!=0;if(!($tobool127)){__label__=40;break $land_lhs_true123$$if_end129$53;}
$retval=1;__label__=41;break $land_lhs_true123$$if_end129$53;}}while(0);if(__label__==40){var $53=$found_value;$retval=$53;;}
var $54=$retval;STACKTOP=__stackBase__;return $54;return null;}
function __ZL10LookupNum3P10TranslatoriPciii($tr,$value,$ph_out,$suppress_null,$thousandplex,$control){var __stackBase__=STACKTOP;STACKTOP+=380;_memset(__stackBase__,0,380);var __label__;var __lastLabel__=null;var $tr_addr;var $value_addr;var $ph_out_addr;var $suppress_null_addr;var $thousandplex_addr;var $control_addr;var $found;var $hundreds;var $tensunits;var $x;var $ix;var $exact;var $ordinal;var $say_zero_hundred;var $string=__stackBase__;var $buf1=__stackBase__+12;var $buf2=__stackBase__+112;var $ph_100=__stackBase__+212;var $ph_10T=__stackBase__+232;var $ph_digits=__stackBase__+252;var $ph_thousands=__stackBase__+304;var $ph_hundred_and=__stackBase__+356;var $ph_thousand_and=__stackBase__+368;$tr_addr=$tr;$value_addr=$value;$ph_out_addr=$ph_out;$suppress_null_addr=$suppress_null;$thousandplex_addr=$thousandplex;$control_addr=$control;$say_zero_hundred=0;var $0=$control_addr;var $and=($0)&34;$ordinal=$and;var $1=$value_addr;var $div=((((($1))|0)/100)|0);$hundreds=$div;var $2=$value_addr;var $rem=((($2))|0)%100;$tensunits=$rem;var $arrayidx=(($buf1)&4294967295);HEAP8[($arrayidx)]=0;var $arrayidx1=(($ph_thousands)&4294967295);HEAP8[($arrayidx1)]=0;var $arrayidx2=(($ph_thousand_and)&4294967295);HEAP8[($arrayidx2)]=0;var $3=$tr_addr;var $langopts=(($3)&4294967295);var $numbers=(($langopts+184)&4294967295);var $4=HEAP32[(($numbers)>>2)];var $and3=($4)&4194304;var $tobool=((($and3))|0)!=0;if($tobool){__label__=1;;}else{__label__=4;;}
$land_lhs_true$$if_endthread_pre_split$2:do{if(__label__==1){var $5=$control_addr;var $and4=($5)&1;var $tobool5=((($and4))|0)!=0;if($tobool5){__label__=3;;}else{__label__=2;;}
if(__label__==2){var $6=$hundreds;var $cmp=((($6))|0)>=10;if($cmp){__lastLabel__=2;;}else{__lastLabel__=2;__label__=5;break $land_lhs_true$$if_endthread_pre_split$2;}}
$say_zero_hundred=1;__label__=4;break $land_lhs_true$$if_endthread_pre_split$2;}}while(0);if(__label__==4){var $_pr=$hundreds;__lastLabel__=4;;}
var $7=__lastLabel__==4?$_pr:($6);var $cmp6=((($7))|0)>0;if($cmp6){__label__=7;;}else{__label__=6;;}
$if_then9$$lor_lhs_false7$10:do{if(__label__==6){var $8=$say_zero_hundred;var $tobool8=((($8))|0)!=0;if($tobool8){__label__=7;break $if_then9$$lor_lhs_false7$10;}else{__label__=61;break $if_then9$$lor_lhs_false7$10;}}}while(0);if(__label__==7){$found=0;var $9=$ordinal;var $tobool10=((($9))|0)!=0;if($tobool10){__label__=8;;}else{__label__=12;;}
$land_lhs_true11$$if_then16$14:do{if(__label__==8){var $10=$tensunits;var $cmp12=((($10))|0)==0;if($cmp12){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $11=$tr_addr;var $arraydecay=(($ph_100)&4294967295);var $call=__Z6LookupP10TranslatorPKcPc($11,((__str35332)&4294967295),$arraydecay);$found=$call;__lastLabel__=9;;}
else if(__label__==10){var $_pr1=$found;__lastLabel__=10;;}
var $12=__lastLabel__==10?$_pr1:($call);var $cmp15=((($12))|0)==0;if($cmp15){__label__=12;break $land_lhs_true11$$if_then16$14;}else{__label__=17;break $land_lhs_true11$$if_then16$14;}}}while(0);$if_then16$$if_end27$20:do{if(__label__==12){var $13=$tensunits;var $cmp17=((($13))|0)==0;if($cmp17){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $14=$tr_addr;var $arraydecay19=(($ph_100)&4294967295);var $call20=__Z6LookupP10TranslatorPKcPc($14,((__str36333)&4294967295),$arraydecay19);$found=$call20;__lastLabel__=13;;}
else if(__label__==14){var $_pr3=$found;__lastLabel__=14;;}
var $15=__lastLabel__==14?$_pr3:($call20);var $tobool22=((($15))|0)!=0;if($tobool22){__label__=17;break $if_then16$$if_end27$20;}
var $16=$tr_addr;var $arraydecay24=(($ph_100)&4294967295);var $call25=__Z6LookupP10TranslatorPKcPc($16,((__str37334)&4294967295),$arraydecay24);;}}while(0);var $17=$tr_addr;var $langopts28=(($17)&4294967295);var $numbers29=(($langopts28+184)&4294967295);var $18=HEAP32[(($numbers29)>>2)];var $and30=($18)&2048;var $cmp31=((($and30))|0)!=0;var $19=$hundreds;if($cmp31){__label__=18;;}else{__label__=19;;}
$land_lhs_true32$$if_else$28:do{if(__label__==18){var $cmp33=((($19))|0)!=19;var $20=$hundreds;var $cmp35=((($20))|0)>=10;var $or_cond=($cmp33)&($cmp35);if($or_cond){__label__=20;break $land_lhs_true32$$if_else$28;}else{__label__=33;break $land_lhs_true32$$if_else$28;}}
else if(__label__==19){var $cmp35_old=((($19))|0)>=10;if($cmp35_old){__label__=20;break $land_lhs_true32$$if_else$28;}else{__label__=33;break $land_lhs_true32$$if_else$28;}}}while(0);if(__label__==20){var $arrayidx37=(($ph_digits)&4294967295);HEAP8[($arrayidx37)]=0;$exact=0;var $21=$value_addr;var $rem38=((($21))|0)%1000;var $cmp39=((($rem38))|0)==0;if($cmp39){__label__=21;;}else{__label__=22;;}
if(__label__==21){$exact=1;;}
var $22=$tr_addr;var $23=$hundreds;var $div42=((((($23))|0)/10)|0);var $24=$thousandplex_addr;var $add=((($24)+1)&4294967295);var $25=$exact;var $26=$ordinal;var $or=($26)|($25);var $arraydecay43=(($ph_10T)&4294967295);var $call44=__ZL15LookupThousandsP10TranslatoriiiPc($22,$div42,$add,$or,$arraydecay43);var $cmp45=((($call44))|0)==0;if($cmp45){__label__=23;;}else{__label__=26;;}
if(__label__==23){$x=0;var $27=$tr_addr;var $langopts47=(($27)&4294967295);var $numbers2=(($langopts47+188)&4294967295);var $28=HEAP32[(($numbers2)>>2)];var $29=$thousandplex_addr;var $add48=((($29)+1)&4294967295);var $shl=1<<($add48);var $and49=($shl)&($28);var $tobool50=((($and49))|0)!=0;if($tobool50){__label__=24;;}else{__label__=25;;}
if(__label__==24){$x=8;;}
var $30=$tr_addr;var $31=$hundreds;var $div53=((((($31))|0)/10)|0);var $32=$x;var $arraydecay54=(($ph_digits)&4294967295);var $call55=__ZL10LookupNum2P10TranslatoriiPc($30,$div53,$32,$arraydecay54);;}
var $33=$tr_addr;var $langopts57=(($33)&4294967295);var $numbers258=(($langopts57+188)&4294967295);var $34=HEAP32[(($numbers258)>>2)];var $and59=($34)&512;var $tobool60=((($and59))|0)!=0;var $arraydecay62=(($ph_thousands)&4294967295);if($tobool60){__label__=27;;}else{__label__=28;;}
if(__label__==27){var $arraydecay63=(($ph_10T)&4294967295);var $arraydecay64=(($ph_digits)&4294967295);var $call65=_sprintf($arraydecay62,((__str47699)&4294967295),allocate([$arraydecay63,0,0,0,$arraydecay64,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==28){var $arraydecay68=(($ph_digits)&4294967295);var $arraydecay69=(($ph_10T)&4294967295);var $call70=_sprintf($arraydecay62,((__str47699)&4294967295),allocate([$arraydecay68,0,0,0,$arraydecay69,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
var $35=$hundreds;var $rem72=((($35))|0)%10;$hundreds=$rem72;var $cmp73=((($rem72))|0)==0;if($cmp73){__label__=30;;}else{__label__=32;;}
$land_lhs_true74$$if_end78$46:do{if(__label__==30){var $36=$say_zero_hundred;var $cmp75=((($36))|0)==0;if(!($cmp75)){__label__=32;break $land_lhs_true74$$if_end78$46;}
var $arrayidx77=(($ph_100)&4294967295);HEAP8[($arrayidx77)]=0;;}}while(0);$suppress_null_addr=1;;}
var $arrayidx81=(($ph_digits)&4294967295);HEAP8[($arrayidx81)]=0;var $37=$hundreds;var $cmp82=((($37))|0)>0;if($cmp82){__label__=35;;}else{__label__=34;;}
$if_then85$$lor_lhs_false83$51:do{if(__label__==34){var $38=$say_zero_hundred;var $tobool84=((($38))|0)!=0;if($tobool84){__label__=35;break $if_then85$$lor_lhs_false83$51;}else{__label__=60;break $if_then85$$lor_lhs_false83$51;}}}while(0);$if_then85$$if_end166$53:do{if(__label__==35){var $39=$tr_addr;var $langopts86=(($39)&4294967295);var $numbers87=(($langopts86+184)&4294967295);var $40=HEAP32[(($numbers87)>>2)];var $and88=($40)&262144;var $tobool89=((($and88))|0)!=0;if($tobool89){__label__=36;;}else{__label__=39;;}
$land_lhs_true90$$if_end99$55:do{if(__label__==36){var $41=$control_addr;var $and91=($41)&1;var $tobool92=((($and91))|0)!=0;if($tobool92){__label__=38;;}else{__label__=37;;}
if(__label__==37){var $arrayidx94=(($ph_thousands)&4294967295);var $42=HEAP8[($arrayidx94)];var $conv=(tempInt=(($42)),(tempInt>=128?tempInt-256:tempInt));var $cmp95=((($conv))|0)!=0;if(!($cmp95)){__label__=39;break $land_lhs_true90$$if_end99$55;}}
var $43=$tr_addr;var $arraydecay97=(($ph_thousand_and)&4294967295);var $call98=__Z6LookupP10TranslatorPKcPc($43,((__str33330)&4294967295),$arraydecay97);;}}while(0);$suppress_null_addr=1;$found=0;var $44=$ordinal;var $tobool100=((($44))|0)!=0;if($tobool100){__label__=40;;}else{__label__=45;;}
$land_lhs_true101$$if_end124$61:do{if(__label__==40){var $45=$tensunits;var $cmp102=((($45))|0)==0;if($cmp102){__label__=42;;}else{__label__=41;;}
if(__label__==41){var $46=$tr_addr;var $langopts104=(($46)&4294967295);var $numbers2105=(($langopts104+188)&4294967295);var $47=HEAP32[(($numbers2105)>>2)];var $and106=($47)&4096;var $tobool107=((($and106))|0)!=0;if(!($tobool107)){__label__=45;break $land_lhs_true101$$if_end124$61;}}
var $arraydecay109=(($string)&4294967295);var $48=$hundreds;var $call110=_sprintf($arraydecay109,((__str39336)&4294967295),allocate([$48,0,0,0],["i32",0,0,0],ALLOC_STACK));var $49=$tr_addr;var $arraydecay111=(($string)&4294967295);var $arraydecay112=(($ph_digits)&4294967295);var $call113=__Z6LookupP10TranslatorPKcPc($49,$arraydecay111,$arraydecay112);$found=$call113;var $50=$tr_addr;var $langopts114=(($50)&4294967295);var $numbers2115=(($langopts114+188)&4294967295);var $51=HEAP32[(($numbers2115)>>2)];var $and116=($51)&4096;var $tobool117=((($and116))|0)!=0;if(!($tobool117)){__label__=45;break $land_lhs_true101$$if_end124$61;}
var $52=$tensunits;var $cmp119=((($52))|0)>0;if(!($cmp119)){__label__=45;break $land_lhs_true101$$if_end124$61;}
var $arraydecay121=(($ph_digits)&4294967295);var $call122=_strcat($arraydecay121,((__ZL11ph_ordinal2)&4294967295));;}}while(0);var $53=$hundreds;var $cmp125=((($53))|0)==0;if($cmp125){__label__=46;;}else{__label__=48;;}
$land_lhs_true126$$if_else131$69:do{if(__label__==46){var $54=$say_zero_hundred;var $tobool127=((($54))|0)!=0;if(!($tobool127)){__label__=48;break $land_lhs_true126$$if_else131$69;}
var $55=$tr_addr;var $arraydecay129=(($ph_digits)&4294967295);var $call130=__Z6LookupP10TranslatorPKcPc($55,((__str16313)&4294967295),$arraydecay129);__label__=60;break $if_then85$$if_end166$53;}}while(0);var $56=$found;var $tobool132=((($56))|0)!=0;if($tobool132){__label__=54;;}else{__label__=49;;}
$if_end149thread_pre_split$$land_lhs_true133$73:do{if(__label__==49){var $57=$tensunits;var $cmp134=((($57))|0)==0;if($cmp134){__label__=50;;}else{__label__=51;;}
if(__label__==50){var $arraydecay136=(($string)&4294967295);var $58=$hundreds;var $call137=_sprintf($arraydecay136,((__str40337)&4294967295),allocate([$58,0,0,0],["i32",0,0,0],ALLOC_STACK));var $59=$tr_addr;var $arraydecay138=(($string)&4294967295);var $arraydecay139=(($ph_digits)&4294967295);var $call140=__Z6LookupP10TranslatorPKcPc($59,$arraydecay138,$arraydecay139);$found=$call140;__lastLabel__=50;;}
else if(__label__==51){var $_pr4=$found;__lastLabel__=51;;}
var $60=__lastLabel__==51?$_pr4:($call140);var $tobool142=((($60))|0)!=0;if($tobool142){__label__=54;break $if_end149thread_pre_split$$land_lhs_true133$73;}
var $arraydecay144=(($string)&4294967295);var $61=$hundreds;var $call145=_sprintf($arraydecay144,((__str41338)&4294967295),allocate([$61,0,0,0],["i32",0,0,0],ALLOC_STACK));var $62=$tr_addr;var $arraydecay146=(($string)&4294967295);var $arraydecay147=(($ph_digits)&4294967295);var $call148=__Z6LookupP10TranslatorPKcPc($62,$arraydecay146,$arraydecay147);$found=$call148;__lastLabel__=53;__label__=55;break $if_end149thread_pre_split$$land_lhs_true133$73;}}while(0);if(__label__==54){var $_pr6=$found;__lastLabel__=54;;}
var $63=__lastLabel__==54?$_pr6:($call148);var $tobool150=((($63))|0)!=0;if($tobool150){__label__=56;;}else{__label__=57;;}
if(__label__==56){var $arrayidx152=(($ph_100)&4294967295);HEAP8[($arrayidx152)]=0;;}
else if(__label__==57){var $64=$hundreds;var $cmp154=((($64))|0)>1;if($cmp154){__label__=59;;}else{__label__=58;;}
if(__label__==58){var $65=$tr_addr;var $langopts156=(($65)&4294967295);var $numbers157=(($langopts156+184)&4294967295);var $66=HEAP32[(($numbers157)>>2)];var $and158=($66)&1024;var $cmp159=((($and158))|0)==0;if(!($cmp159)){__label__=60;break $if_then85$$if_end166$53;}}
var $67=$tr_addr;var $68=$hundreds;var $arraydecay161=(($ph_digits)&4294967295);var $call162=__ZL10LookupNum2P10TranslatoriiPc($67,$68,0,$arraydecay161);;}}}while(0);var $arraydecay167=(($buf1)&4294967295);var $arraydecay168=(($ph_thousands)&4294967295);var $arraydecay169=(($ph_thousand_and)&4294967295);var $arraydecay170=(($ph_digits)&4294967295);var $arraydecay171=(($ph_100)&4294967295);var $call172=_sprintf($arraydecay167,((__str20317)&4294967295),allocate([$arraydecay168,0,0,0,$arraydecay169,0,0,0,$arraydecay170,0,0,0,$arraydecay171,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
var $arrayidx174=(($ph_hundred_and)&4294967295);HEAP8[($arrayidx174)]=0;var $69=$tensunits;var $cmp175=((($69))|0)>0;if($cmp175){__label__=62;;}else{__label__=74;;}
$if_then176$$if_end217$91:do{if(__label__==62){var $70=$value_addr;var $cmp177=((($70))|0)>100;if($cmp177){__label__=65;;}else{__label__=63;;}
$if_then183$$lor_lhs_false178$93:do{if(__label__==63){var $71=$control_addr;var $and179=($71)&1;var $tobool180=((($and179))|0)!=0;if(!($tobool180)){__label__=69;break $if_then183$$lor_lhs_false178$93;}
var $72=$thousandplex_addr;var $cmp182=((($72))|0)==0;if($cmp182){__label__=65;break $if_then183$$lor_lhs_false178$93;}else{__label__=69;break $if_then183$$lor_lhs_false178$93;}}}while(0);$if_then183$$if_end199$96:do{if(__label__==65){var $73=$tr_addr;var $langopts184=(($73)&4294967295);var $numbers185=(($langopts184+184)&4294967295);var $74=HEAP32[(($numbers185)>>2)];var $and186=($74)&64;var $tobool187=((($and186))|0)!=0;if($tobool187){__label__=68;;}else{__label__=66;;}
if(__label__==66){var $75=$tr_addr;var $langopts189=(($75)&4294967295);var $numbers190=(($langopts189+184)&4294967295);var $76=HEAP32[(($numbers190)>>2)];var $and191=($76)&8388608;var $tobool192=((($and191))|0)!=0;if(!($tobool192)){__label__=69;break $if_then183$$if_end199$96;}
var $77=$tensunits;var $cmp194=((($77))|0)<10;if(!($cmp194)){__label__=69;break $if_then183$$if_end199$96;}}
var $78=$tr_addr;var $arraydecay196=(($ph_hundred_and)&4294967295);var $call197=__Z6LookupP10TranslatorPKcPc($78,((__str33330)&4294967295),$arraydecay196);;}}while(0);var $79=$tr_addr;var $langopts200=(($79)&4294967295);var $numbers201=(($langopts200+184)&4294967295);var $80=HEAP32[(($numbers201)>>2)];var $and202=($80)&524288;var $tobool203=((($and202))|0)!=0;if(!($tobool203)){__label__=74;break $if_then176$$if_end217$91;}
var $81=$hundreds;var $cmp205=((($81))|0)==0;if(!($cmp205)){__label__=74;break $if_then176$$if_end217$91;}
var $82=$control_addr;var $and207=($82)&1;var $tobool208=((($and207))|0)!=0;if($tobool208){__label__=73;;}else{__label__=72;;}
if(__label__==72){var $arrayidx210=(($ph_thousands)&4294967295);var $83=HEAP8[($arrayidx210)];var $conv211=(tempInt=(($83)),(tempInt>=128?tempInt-256:tempInt));var $cmp212=((($conv211))|0)!=0;if(!($cmp212)){__label__=74;break $if_then176$$if_end217$91;}}
var $84=$tr_addr;var $arraydecay214=(($ph_hundred_and)&4294967295);var $call215=__Z6LookupP10TranslatorPKcPc($84,((__str33330)&4294967295),$arraydecay214);;}}while(0);var $arrayidx218=(($buf2)&4294967295);HEAP8[($arrayidx218)]=0;var $85=$tensunits;var $cmp219=((($85))|0)!=0;if($cmp219){__label__=76;;}else{__label__=75;;}
$if_then222$$lor_lhs_false220$109:do{if(__label__==75){var $86=$suppress_null_addr;var $cmp221=((($86))|0)==0;if($cmp221){__label__=76;break $if_then222$$lor_lhs_false220$109;}
var $102=HEAP8[(((__ZL11ph_ordinal2)&4294967295))];var $conv262=(tempInt=(($102)),(tempInt>=128?tempInt-256:tempInt));var $cmp263=((($conv262))|0)!=0;if(!($cmp263)){__label__=94;break $if_then222$$lor_lhs_false220$109;}
var $arraydecay265=(($buf1)&4294967295);var $call266=_strlen($arraydecay265);$ix=$call266;var $103=$ix;var $cmp267=((($103))|0)>0;if($cmp267){__label__=91;;}else{__label__=93;;}
$land_lhs_true268$$if_end275$113:do{if(__label__==91){var $104=$ix;var $sub=((($104)-1)&4294967295);var $arrayidx269=(($buf1+$sub)&4294967295);var $105=HEAP8[($arrayidx269)];var $conv270=(tempInt=(($105)),(tempInt>=128?tempInt-256:tempInt));var $cmp271=((($conv270))|0)==10;if(!($cmp271)){__label__=93;break $land_lhs_true268$$if_end275$113;}
var $106=$ix;var $sub273=((($106)-1)&4294967295);var $arrayidx274=(($buf1+$sub273)&4294967295);HEAP8[($arrayidx274)]=0;;}}while(0);var $arraydecay276=(($buf2)&4294967295);var $call277=_strcpy($arraydecay276,((__ZL11ph_ordinal2)&4294967295));__label__=94;break $if_then222$$lor_lhs_false220$109;}}while(0);$if_then222$$if_end279$117:do{if(__label__==76){$x=0;var $87=$thousandplex_addr;var $cmp223=((($87))|0)==0;if($cmp223){__label__=77;;}else{__label__=84;;}
$if_then224$$if_else240$119:do{if(__label__==77){$x=2;var $88=$ordinal;var $tobool225=((($88))|0)!=0;if($tobool225){__label__=78;;}else{__label__=79;;}
if(__label__==78){$x=3;;}
var $89=$value_addr;var $cmp228=((($89))|0)<100;if($cmp228){__label__=80;;}else{__label__=82;;}
$land_lhs_true229$$if_end234$124:do{if(__label__==80){var $90=$control_addr;var $and230=($90)&1;var $tobool231=((($and230))|0)!=0;if($tobool231){__label__=82;break $land_lhs_true229$$if_end234$124;}
var $91=$x;var $or233=($91)|4;$x=$or233;;}}while(0);var $92=$ordinal;var $and235=($92)&32;var $tobool236=((($and235))|0)!=0;if(!($tobool236)){__label__=86;break $if_then224$$if_else240$119;}
var $93=$x;var $or238=($93)|32;$x=$or238;;}
else if(__label__==84){var $94=$tr_addr;var $langopts241=(($94)&4294967295);var $numbers2242=(($langopts241+188)&4294967295);var $95=HEAP32[(($numbers2242)>>2)];var $96=$thousandplex_addr;var $shl243=1<<($96);var $and244=($shl243)&($95);var $tobool245=((($and244))|0)!=0;if(!($tobool245)){__label__=86;break $if_then224$$if_else240$119;}
$x=8;;}}while(0);var $97=$tr_addr;var $98=$tensunits;var $99=$x;var $arraydecay249=(($buf2)&4294967295);var $call250=__ZL10LookupNum2P10TranslatoriiPc($97,$98,$99,$arraydecay249);var $cmp251=((($call250))|0)!=0;if(!($cmp251)){__label__=94;break $if_then222$$if_end279$117;}
var $100=$tr_addr;var $langopts253=(($100)&4294967295);var $numbers254=(($langopts253+184)&4294967295);var $101=HEAP32[(($numbers254)>>2)];var $and255=($101)&128;var $tobool256=((($and255))|0)!=0;if(!($tobool256)){__label__=94;break $if_then222$$if_end279$117;}
var $arrayidx258=(($ph_hundred_and)&4294967295);HEAP8[($arrayidx258)]=0;;}}while(0);var $107=$ph_out_addr;var $arraydecay280=(($buf1)&4294967295);var $arraydecay281=(($ph_hundred_and)&4294967295);var $arraydecay282=(($buf2)&4294967295);var $call283=_sprintf($107,((__str6549)&4294967295),allocate([$arraydecay280,0,0,0,$arraydecay281,0,0,0,$arraydecay282,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));STACKTOP=__stackBase__;return;return;}
function __ZL10LookupNum2P10TranslatoriiPc($tr,$value,$control,$ph_out){var __stackBase__=STACKTOP;STACKTOP+=148;_memset(__stackBase__,0,148);var __label__;var __lastLabel__=null;var $tr_addr;var $value_addr;var $control_addr;var $ph_out_addr;var $found;var $ix;var $units;var $tens;var $used_and;var $found_ordinal;var $next_phtype;var $ord_type;var $string=__stackBase__;var $ph_ordinal=__stackBase__+12;var $ph_tens=__stackBase__+32;var $ph_digits=__stackBase__+84;var $ph_and=__stackBase__+136;$tr_addr=$tr;$value_addr=$value;$control_addr=$control;$ph_out_addr=$ph_out;$used_and=0;$found_ordinal=0;$ord_type=111;var $0=$value_addr;var $rem=((($0))|0)%10;$units=$rem;var $1=$value_addr;var $div=((((($1))|0)/10)|0);$tens=$div;$found=0;var $arrayidx=(($ph_ordinal)&4294967295);HEAP8[($arrayidx)]=0;var $arrayidx1=(($ph_tens)&4294967295);HEAP8[($arrayidx1)]=0;var $arrayidx2=(($ph_digits)&4294967295);HEAP8[($arrayidx2)]=0;var $arrayidx3=(($ph_and)&4294967295);HEAP8[($arrayidx3)]=0;var $2=$control_addr;var $and=($2)&32;var $tobool=((($and))|0)!=0;if($tobool){__label__=1;;}else{__label__=2;;}
if(__label__==1){$ord_type=113;;}
var $3=$control_addr;var $and4=($3)&2;var $tobool5=((($and4))|0)!=0;var $4=HEAP32[((__ZL14n_digit_lookup)>>2)];var $cmp=((($4))|0)==2;var $or_cond=($tobool5)&($cmp);if($or_cond){__label__=3;;}else{__label__=4;;}
$if_then6$$if_else$5:do{if(__label__==3){var $5=$ph_out_addr;var $6=HEAP32[((__ZL12digit_lookup)>>2)];var $call=_strcpy($5,$6);;}
else if(__label__==4){var $7=HEAP32[((__ZL12digit_lookup)>>2)];var $arrayidx7=(($7)&4294967295);var $8=HEAP8[($arrayidx7)];var $conv=(tempInt=(($8)),(tempInt>=128?tempInt-256:tempInt));var $cmp8=((($conv))|0)==0;if($cmp8){__label__=5;;}else{__label__=23;;}
$if_then9$$if_end72$8:do{if(__label__==5){var $9=$control_addr;var $and10=($9)&8;var $tobool11=((($and10))|0)!=0;if($tobool11){__label__=6;;}else{__label__=7;;}
if(__label__==6){var $arraydecay=(($string)&4294967295);var $10=$value_addr;var $call13=_sprintf($arraydecay,((__str23320)&4294967295),allocate([$10,0,0,0],["i32",0,0,0],ALLOC_STACK));var $11=$tr_addr;var $arraydecay14=(($string)&4294967295);var $arraydecay15=(($ph_digits)&4294967295);var $call16=__Z6LookupP10TranslatorPKcPc($11,$arraydecay14,$arraydecay15);$found=$call16;__lastLabel__=6;;}
else if(__label__==7){var $12=$control_addr;var $and18=($12)&1;var $tobool19=((($and18))|0)!=0;if($tobool19){__label__=8;;}else{__label__=14;;}
if(__label__==8){var $arraydecay21=(($ph_ordinal)&4294967295);var $call22=_strcpy($arraydecay21,((__ZL11ph_ordinal2)&4294967295));var $13=$control_addr;var $and23=($13)&4;var $tobool24=((($and23))|0)!=0;if($tobool24){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $arraydecay26=(($string)&4294967295);var $14=$value_addr;var $15=$ord_type;var $call27=_sprintf($arraydecay26,((__str24321)&4294967295),allocate([$14,0,0,0,$15,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $16=$tr_addr;var $arraydecay28=(($string)&4294967295);var $arraydecay29=(($ph_digits)&4294967295);var $call30=__Z6LookupP10TranslatorPKcPc($16,$arraydecay28,$arraydecay29);$found=$call30;__lastLabel__=9;;}
else if(__label__==10){var $_pr=$found;__lastLabel__=10;;}
var $17=__lastLabel__==10?$_pr:($call30);var $cmp32=((($17))|0)==0;if($cmp32){__label__=12;;}else{__label__=13;;}
if(__label__==12){var $arraydecay34=(($string)&4294967295);var $18=$value_addr;var $19=$ord_type;var $call35=_sprintf($arraydecay34,((__str25322)&4294967295),allocate([$18,0,0,0,$19,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $20=$tr_addr;var $arraydecay36=(($string)&4294967295);var $arraydecay37=(($ph_digits)&4294967295);var $call38=__Z6LookupP10TranslatorPKcPc($20,$arraydecay36,$arraydecay37);$found=$call38;;}
var $21=$found;$found_ordinal=$21;__lastLabel__=13;;}
else if(__label__==14){var $_pr1=$found;__lastLabel__=14;;}}
var $22=__lastLabel__==14?$_pr1:(__lastLabel__==13?$21:($call16));var $cmp42=((($22))|0)==0;if(!($cmp42)){__label__=23;break $if_then9$$if_end72$8;}
var $23=$control_addr;var $and44=($23)&2;var $tobool45=((($and44))|0)!=0;if($tobool45){__label__=17;;}else{__label__=19;;}
if(__label__==17){var $24=HEAP32[((__ZL14number_control)>>2)];var $and47=($24)&1;var $tobool48=((($and47))|0)!=0;if($tobool48){__label__=18;;}else{__label__=20;;}
if(__label__==18){var $arraydecay50=(($string)&4294967295);var $25=$value_addr;var $call51=_sprintf($arraydecay50,((__str26323)&4294967295),allocate([$25,0,0,0],["i32",0,0,0],ALLOC_STACK));var $26=$tr_addr;var $arraydecay52=(($string)&4294967295);var $arraydecay53=(($ph_digits)&4294967295);var $call54=__Z6LookupP10TranslatorPKcPc($26,$arraydecay52,$arraydecay53);$found=$call54;__lastLabel__=18;;}
else if(__label__==20){var $_pr2=$found;__lastLabel__=20;;}}
else if(__label__==19){var $arraydecay57=(($string)&4294967295);var $27=$value_addr;var $call58=_sprintf($arraydecay57,((__str27324)&4294967295),allocate([$27,0,0,0],["i32",0,0,0],ALLOC_STACK));var $28=$tr_addr;var $arraydecay59=(($string)&4294967295);var $arraydecay60=(($ph_digits)&4294967295);var $call61=__Z6LookupP10TranslatorPKcPc($28,$arraydecay59,$arraydecay60);$found=$call61;__lastLabel__=19;;}
var $29=__lastLabel__==20?$_pr2:(__lastLabel__==18?$call54:($call61));var $tobool63=((($29))|0)!=0;if($tobool63){__label__=23;break $if_then9$$if_end72$8;}
var $arraydecay65=(($string)&4294967295);var $30=$value_addr;var $call66=_sprintf($arraydecay65,((__str28325)&4294967295),allocate([$30,0,0,0],["i32",0,0,0],ALLOC_STACK));var $31=$tr_addr;var $arraydecay67=(($string)&4294967295);var $arraydecay68=(($ph_digits)&4294967295);var $call69=__Z6LookupP10TranslatorPKcPc($31,$arraydecay67,$arraydecay68);$found=$call69;;}}while(0);var $32=$control_addr;var $and73=($32)&16;var $tobool74=((($and73))|0)!=0;if($tobool74){__label__=24;;}else{__label__=26;;}
$land_lhs_true75$$if_else80$34:do{if(__label__==24){var $33=$value_addr;var $cmp76=((($33))|0)<10;if(!($cmp76)){__label__=26;break $land_lhs_true75$$if_else80$34;}
var $34=$tr_addr;var $arraydecay78=(($ph_tens)&4294967295);var $call79=__Z6LookupP10TranslatorPKcPc($34,((__str16313)&4294967295),$arraydecay78);__label__=61;break $land_lhs_true75$$if_else80$34;}}while(0);$if_end221$$if_else80$37:do{if(__label__==26){var $35=$found;var $tobool81=((($35))|0)!=0;if($tobool81){__label__=27;;}else{__label__=28;;}
if(__label__==27){var $arrayidx83=(($ph_tens)&4294967295);HEAP8[($arrayidx83)]=0;;}
else if(__label__==28){var $36=$control_addr;var $and85=($36)&1;var $tobool86=((($and85))|0)!=0;if($tobool86){__label__=29;;}else{__label__=36;;}
$land_lhs_true87$$if_end114$42:do{if(__label__==29){var $37=$units;var $cmp88=((($37))|0)==0;if($cmp88){__label__=32;;}else{__label__=30;;}
$if_then95$$lor_lhs_false$44:do{if(__label__==30){var $38=$tr_addr;var $langopts=(($38)&4294967295);var $numbers=(($langopts+184)&4294967295);var $39=HEAP32[(($numbers)>>2)];var $and89=($39)&16;var $tobool90=((($and89))|0)!=0;if($tobool90){__label__=32;break $if_then95$$lor_lhs_false$44;}
var $40=$tr_addr;var $langopts92=(($40)&4294967295);var $numbers2=(($langopts92+188)&4294967295);var $41=HEAP32[(($numbers2)>>2)];var $and93=($41)&4096;var $tobool94=((($and93))|0)!=0;if(!($tobool94)){__label__=36;break $land_lhs_true87$$if_end114$42;}}}while(0);var $arraydecay96=(($string)&4294967295);var $42=$tens;var $43=$ord_type;var $call97=_sprintf($arraydecay96,((__str29326)&4294967295),allocate([$42,0,0,0,$43,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $44=$tr_addr;var $arraydecay98=(($string)&4294967295);var $arraydecay99=(($ph_tens)&4294967295);var $call100=__Z6LookupP10TranslatorPKcPc($44,$arraydecay98,$arraydecay99);var $cmp101=((($call100))|0)!=0;if(!($cmp101)){__label__=36;break $land_lhs_true87$$if_end114$42;}
$found_ordinal=1;var $45=$units;var $cmp103=((($45))|0)!=0;if(!($cmp103)){__label__=38;break $land_lhs_true87$$if_end114$42;}
var $46=$tr_addr;var $langopts105=(($46)&4294967295);var $numbers2106=(($langopts105+188)&4294967295);var $47=HEAP32[(($numbers2106)>>2)];var $and107=($47)&4096;var $tobool108=((($and107))|0)!=0;if(!($tobool108)){__label__=36;break $land_lhs_true87$$if_end114$42;}
var $arraydecay110=(($ph_tens)&4294967295);var $call111=_strcat($arraydecay110,((__ZL11ph_ordinal2)&4294967295));__label__=36;break $land_lhs_true87$$if_end114$42;}}while(0);$if_end114$$if_end122$51:do{if(__label__==36){var $_pr3=$found_ordinal;var $cmp115=((($_pr3))|0)==0;if(!($cmp115)){__label__=38;break $if_end114$$if_end122$51;}
var $arraydecay117=(($string)&4294967295);var $48=$tens;var $call118=_sprintf($arraydecay117,((__str30327)&4294967295),allocate([$48,0,0,0],["i32",0,0,0],ALLOC_STACK));var $49=$tr_addr;var $arraydecay119=(($string)&4294967295);var $arraydecay120=(($ph_tens)&4294967295);var $call121=__Z6LookupP10TranslatorPKcPc($49,$arraydecay119,$arraydecay120);;}}while(0);var $arrayidx123=(($ph_tens)&4294967295);var $50=HEAP8[($arrayidx123)];var $conv124=(tempInt=(($50)),(tempInt>=128?tempInt-256:tempInt));var $cmp125=((($conv124))|0)==0;if($cmp125){__label__=39;;}else{__label__=41;;}
$land_lhs_true126$$if_end139$55:do{if(__label__==39){var $51=$tr_addr;var $langopts127=(($51)&4294967295);var $numbers128=(($langopts127+184)&4294967295);var $52=HEAP32[(($numbers128)>>2)];var $and129=($52)&1048576;var $tobool130=((($and129))|0)!=0;if(!($tobool130)){__label__=41;break $land_lhs_true126$$if_end139$55;}
var $53=$value_addr;var $rem132=((($53))|0)%20;$units=$rem132;var $arraydecay133=(($string)&4294967295);var $54=$tens;var $and134=($54)&254;var $call135=_sprintf($arraydecay133,((__str30327)&4294967295),allocate([$and134,0,0,0],["i32",0,0,0],ALLOC_STACK));var $55=$tr_addr;var $arraydecay136=(($string)&4294967295);var $arraydecay137=(($ph_tens)&4294967295);var $call138=__Z6LookupP10TranslatorPKcPc($55,$arraydecay136,$arraydecay137);;}}while(0);var $arrayidx140=(($ph_digits)&4294967295);HEAP8[($arrayidx140)]=0;var $56=$units;var $cmp141=((($56))|0)>0;if(!($cmp141)){__label__=61;break $if_end221$$if_else80$37;}
$found=0;var $57=$control_addr;var $and143=($57)&2;var $tobool144=((($and143))|0)!=0;if($tobool144){__label__=43;;}else{__label__=45;;}
$land_lhs_true145$$if_else153$60:do{if(__label__==43){var $58=HEAP32[((__ZL12digit_lookup)>>2)];var $arrayidx146=(($58)&4294967295);var $59=HEAP8[($arrayidx146)];var $conv147=(tempInt=(($59)),(tempInt>=128?tempInt-256:tempInt));var $cmp148=((($conv147))|0)!=0;if(!($cmp148)){__label__=45;break $land_lhs_true145$$if_else153$60;}
var $arraydecay150=(($ph_digits)&4294967295);var $60=HEAP32[((__ZL12digit_lookup)>>2)];var $call151=_strcpy($arraydecay150,$60);$found_ordinal=1;var $arrayidx152=(($ph_ordinal)&4294967295);HEAP8[($arrayidx152)]=0;__label__=61;break $if_end221$$if_else80$37;}}while(0);var $61=$control_addr;var $and154=($61)&8;var $tobool155=((($and154))|0)!=0;if($tobool155){__label__=46;;}else{__label__=47;;}
if(__label__==46){var $arraydecay157=(($string)&4294967295);var $62=$units;var $call158=_sprintf($arraydecay157,((__str23320)&4294967295),allocate([$62,0,0,0],["i32",0,0,0],ALLOC_STACK));var $63=$tr_addr;var $arraydecay159=(($string)&4294967295);var $arraydecay160=(($ph_digits)&4294967295);var $call161=__Z6LookupP10TranslatorPKcPc($63,$arraydecay159,$arraydecay160);$found=$call161;;}
var $64=$control_addr;var $and163=($64)&1;var $tobool164=((($and163))|0)!=0;if($tobool164){__label__=48;;}else{__label__=51;;}
$land_lhs_true165$$if_end179$67:do{if(__label__==48){var $65=$tr_addr;var $langopts166=(($65)&4294967295);var $numbers167=(($langopts166+184)&4294967295);var $66=HEAP32[(($numbers167)>>2)];var $and168=($66)&16;var $cmp169=((($and168))|0)==0;if(!($cmp169)){__label__=51;break $land_lhs_true165$$if_end179$67;}
var $arraydecay171=(($string)&4294967295);var $67=$units;var $68=$ord_type;var $call172=_sprintf($arraydecay171,((__str25322)&4294967295),allocate([$67,0,0,0,$68,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $69=$tr_addr;var $arraydecay173=(($string)&4294967295);var $arraydecay174=(($ph_digits)&4294967295);var $call175=__Z6LookupP10TranslatorPKcPc($69,$arraydecay173,$arraydecay174);$found=$call175;var $cmp176=((($call175))|0)!=0;if(!($cmp176)){__label__=52;break $land_lhs_true165$$if_end179$67;}
$found_ordinal=1;__label__=51;break $land_lhs_true165$$if_end179$67;}}while(0);if(__label__==51){var $_pr5=$found;var $cmp180=((($_pr5))|0)==0;if(!($cmp180)){__label__=61;break $if_end221$$if_else80$37;}}
var $70=HEAP32[((__ZL14number_control)>>2)];var $and182=($70)&1;var $tobool183=((($and182))|0)!=0;if($tobool183){__label__=53;;}else{__label__=55;;}
$land_lhs_true184$$if_else193$74:do{if(__label__==53){var $71=$control_addr;var $and185=($71)&2;var $tobool186=((($and185))|0)!=0;if(!($tobool186)){__label__=55;break $land_lhs_true184$$if_else193$74;}
var $arraydecay188=(($string)&4294967295);var $72=$units;var $call189=_sprintf($arraydecay188,((__str26323)&4294967295),allocate([$72,0,0,0],["i32",0,0,0],ALLOC_STACK));var $73=$tr_addr;var $arraydecay190=(($string)&4294967295);var $arraydecay191=(($ph_digits)&4294967295);var $call192=__Z6LookupP10TranslatorPKcPc($73,$arraydecay190,$arraydecay191);$found=$call192;__lastLabel__=54;__label__=59;break $land_lhs_true184$$if_else193$74;}}while(0);$if_end209$$if_else193$77:do{if(__label__==55){var $74=$control_addr;var $and194=($74)&2;var $cmp195=((($and194))|0)==0;if($cmp195){__label__=57;;}else{__label__=56;;}
$if_then201$$lor_lhs_false196$79:do{if(__label__==56){var $75=$tr_addr;var $langopts197=(($75)&4294967295);var $numbers198=(($langopts197+184)&4294967295);var $76=HEAP32[(($numbers198)>>2)];var $and199=($76)&16;var $cmp200=((($and199))|0)!=0;if($cmp200){__label__=57;break $if_then201$$lor_lhs_false196$79;}
var $_pr7=$found;__lastLabel__=58;__label__=59;break $if_end209$$if_else193$77;}}while(0);var $arraydecay202=(($string)&4294967295);var $77=$units;var $call203=_sprintf($arraydecay202,((__str27324)&4294967295),allocate([$77,0,0,0],["i32",0,0,0],ALLOC_STACK));var $78=$tr_addr;var $arraydecay204=(($string)&4294967295);var $arraydecay205=(($ph_digits)&4294967295);var $call206=__Z6LookupP10TranslatorPKcPc($78,$arraydecay204,$arraydecay205);$found=$call206;__lastLabel__=57;;}}while(0);var $79=__lastLabel__==58?$_pr7:(__lastLabel__==54?$call192:($call206));var $cmp210=((($79))|0)==0;if(!($cmp210)){__label__=61;break $if_end221$$if_else80$37;}
var $arraydecay212=(($string)&4294967295);var $80=$units;var $call213=_sprintf($arraydecay212,((__str28325)&4294967295),allocate([$80,0,0,0],["i32",0,0,0],ALLOC_STACK));var $81=$tr_addr;var $arraydecay214=(($string)&4294967295);var $arraydecay215=(($ph_digits)&4294967295);var $call216=__Z6LookupP10TranslatorPKcPc($81,$arraydecay214,$arraydecay215);;}}}while(0);var $82=$control_addr;var $and222=($82)&1;var $tobool223=((($and222))|0)!=0;if($tobool223){__label__=62;;}else{__label__=70;;}
$land_lhs_true224$$if_end251$86:do{if(__label__==62){var $83=$found_ordinal;var $cmp225=((($83))|0)==0;if(!($cmp225)){__label__=70;break $land_lhs_true224$$if_end251$86;}
var $arrayidx227=(($ph_ordinal)&4294967295);var $84=HEAP8[($arrayidx227)];var $conv228=(tempInt=(($84)),(tempInt>=128?tempInt-256:tempInt));var $cmp229=((($conv228))|0)==0;if(!($cmp229)){__label__=70;break $land_lhs_true224$$if_end251$86;}
var $85=$value_addr;var $cmp231=((($85))|0)>=20;if($cmp231){__label__=65;;}else{__label__=68;;}
$land_lhs_true232$$if_end243$90:do{if(__label__==65){var $86=$value_addr;var $rem233=((($86))|0)%10;var $cmp234=((($rem233))|0)==0;if($cmp234){__label__=67;;}else{__label__=66;;}
if(__label__==66){var $87=$tr_addr;var $langopts236=(($87)&4294967295);var $numbers237=(($langopts236+184)&4294967295);var $88=HEAP32[(($numbers237)>>2)];var $and238=($88)&16;var $tobool239=((($and238))|0)!=0;if(!($tobool239)){__label__=68;break $land_lhs_true232$$if_end243$90;}}
var $89=$tr_addr;var $arraydecay241=(($ph_ordinal)&4294967295);var $call242=__Z6LookupP10TranslatorPKcPc($89,((__str31328)&4294967295),$arraydecay241);;}}while(0);var $arrayidx244=(($ph_ordinal)&4294967295);var $90=HEAP8[($arrayidx244)];var $conv245=(tempInt=(($90)),(tempInt>=128?tempInt-256:tempInt));var $cmp246=((($conv245))|0)==0;if(!($cmp246)){__label__=70;break $land_lhs_true224$$if_end251$86;}
var $91=$tr_addr;var $arraydecay248=(($ph_ordinal)&4294967295);var $call249=__Z6LookupP10TranslatorPKcPc($91,((__str32329)&4294967295),$arraydecay248);;}}while(0);var $92=$tr_addr;var $langopts252=(($92)&4294967295);var $numbers253=(($langopts252+184)&4294967295);var $93=HEAP32[(($numbers253)>>2)];var $and254=($93)&48;var $tobool255=((($and254))|0)!=0;if($tobool255){__label__=71;;}else{__label__=79;;}
$land_lhs_true256$$if_else291$98:do{if(__label__==71){var $arrayidx257=(($ph_tens)&4294967295);var $94=HEAP8[($arrayidx257)];var $conv258=(tempInt=(($94)),(tempInt>=128?tempInt-256:tempInt));var $cmp259=((($conv258))|0)!=0;if(!($cmp259)){__label__=79;break $land_lhs_true256$$if_else291$98;}
var $arrayidx261=(($ph_digits)&4294967295);var $95=HEAP8[($arrayidx261)];var $conv262=(tempInt=(($95)),(tempInt>=128?tempInt-256:tempInt));var $cmp263=((($conv262))|0)!=0;if(!($cmp263)){__label__=79;break $land_lhs_true256$$if_else291$98;}
var $96=$tr_addr;var $arraydecay265=(($ph_and)&4294967295);var $call266=__Z6LookupP10TranslatorPKcPc($96,((__str33330)&4294967295),$arraydecay265);var $97=$tr_addr;var $langopts267=(($97)&4294967295);var $numbers2268=(($langopts267+188)&4294967295);var $98=HEAP32[(($numbers2268)>>2)];var $and269=($98)&4096;var $tobool270=((($and269))|0)!=0;if($tobool270){__label__=74;;}else{__label__=75;;}
if(__label__==74){var $arrayidx272=(($ph_and)&4294967295);HEAP8[($arrayidx272)]=0;;}
var $99=$tr_addr;var $langopts274=(($99)&4294967295);var $numbers275=(($langopts274+184)&4294967295);var $100=HEAP32[(($numbers275)>>2)];var $and276=($100)&16;var $tobool277=((($and276))|0)!=0;var $101=$ph_out_addr;if($tobool277){__label__=76;;}else{__label__=77;;}
if(__label__==76){var $arraydecay279=(($ph_digits)&4294967295);var $arraydecay280=(($ph_and)&4294967295);var $arraydecay281=(($ph_tens)&4294967295);var $arraydecay282=(($ph_ordinal)&4294967295);var $call283=_sprintf($101,((__str20317)&4294967295),allocate([$arraydecay279,0,0,0,$arraydecay280,0,0,0,$arraydecay281,0,0,0,$arraydecay282,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
else if(__label__==77){var $arraydecay285=(($ph_tens)&4294967295);var $arraydecay286=(($ph_and)&4294967295);var $arraydecay287=(($ph_digits)&4294967295);var $arraydecay288=(($ph_ordinal)&4294967295);var $call289=_sprintf($101,((__str20317)&4294967295),allocate([$arraydecay285,0,0,0,$arraydecay286,0,0,0,$arraydecay287,0,0,0,$arraydecay288,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
$used_and=1;__label__=88;break $if_then6$$if_else$5;}}while(0);var $102=$tr_addr;var $langopts292=(($102)&4294967295);var $numbers293=(($langopts292+184)&4294967295);var $103=HEAP32[(($numbers293)>>2)];var $and294=($103)&512;var $tobool295=((($and294))|0)!=0;if($tobool295){__label__=80;;}else{__label__=87;;}
$if_then296$$if_end329$110:do{if(__label__==80){var $arraydecay297=(($ph_tens)&4294967295);var $call298=_strlen($arraydecay297);var $sub=((($call298)-1)&4294967295);$ix=$sub;var $cmp299=((($sub))|0)>=0;if(!($cmp299)){__label__=87;break $if_then296$$if_end329$110;}
var $arrayidx301=(($ph_digits)&4294967295);var $104=HEAP8[($arrayidx301)];var $conv302=(tempInt=(($104)),(tempInt>=128?tempInt-256:tempInt));var $cmp303=((($conv302))|0)!=0;if(!($cmp303)){__label__=87;break $if_then296$$if_end329$110;}
var $arrayidx305=(($ph_digits)&4294967295);var $105=HEAP8[($arrayidx305)];var $conv306=(tempInt=(($105)),(tempInt>=128?tempInt-256:tempInt));var $arrayidx307=((_phoneme_tab+$conv306*4)&4294967295);var $106=HEAP32[(($arrayidx307)>>2)];var $type=(($106+11)&4294967295);var $107=HEAPU8[($type)];var $conv308=((($107))&255);$next_phtype=$conv308;var $cmp309=((($conv308))|0)==1;if($cmp309){__label__=83;;}else{__label__=84;;}
if(__label__==83){var $arrayidx311=(($ph_digits+1)&4294967295);var $108=HEAP8[($arrayidx311)];var $conv312=(tempInt=(($108)),(tempInt>=128?tempInt-256:tempInt));var $arrayidx313=((_phoneme_tab+$conv312*4)&4294967295);var $109=HEAP32[(($arrayidx313)>>2)];var $type314=(($109+11)&4294967295);var $110=HEAPU8[($type314)];var $conv315=((($110))&255);$next_phtype=$conv315;;}
var $111=$ix;var $arrayidx317=(($ph_tens+$111)&4294967295);var $112=HEAP8[($arrayidx317)];var $conv318=(tempInt=(($112)),(tempInt>=128?tempInt-256:tempInt));var $arrayidx319=((_phoneme_tab+$conv318*4)&4294967295);var $113=HEAP32[(($arrayidx319)>>2)];var $type320=(($113+11)&4294967295);var $114=HEAPU8[($type320)];var $conv321=((($114))&255);var $cmp322=((($conv321))|0)==2;if(!($cmp322)){__label__=87;break $if_then296$$if_end329$110;}
var $115=$next_phtype;var $cmp324=((($115))|0)==2;if(!($cmp324)){__label__=87;break $if_then296$$if_end329$110;}
var $116=$ix;var $arrayidx326=(($ph_tens+$116)&4294967295);HEAP8[($arrayidx326)]=0;;}}while(0);var $117=$ph_out_addr;var $arraydecay330=(($ph_tens)&4294967295);var $arraydecay331=(($ph_digits)&4294967295);var $arraydecay332=(($ph_ordinal)&4294967295);var $call333=_sprintf($117,((__str6549)&4294967295),allocate([$arraydecay330,0,0,0,$arraydecay331,0,0,0,$arraydecay332,0,0,0],["i8*",0,0,0,"i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}}while(0);var $118=$tr_addr;var $langopts336=(($118)&4294967295);var $numbers337=(($langopts336+184)&4294967295);var $119=HEAP32[(($numbers337)>>2)];var $and338=($119)&256;var $tobool339=((($and338))|0)!=0;if($tobool339){__label__=89;;}else{__label__=95;;}
$if_then340$$if_end354$121:do{if(__label__==89){$found=0;var $120=$ph_out_addr;var $call341=_strlen($120);var $sub342=((($call341)-1)&4294967295);$ix=$sub342;var $cmp3439=((($sub342))|0)>=0;if(!($cmp3439)){__label__=95;break $if_then340$$if_end354$121;}
while(1){var $121=$ix;var $122=$ph_out_addr;var $arrayidx344=(($122+$121)&4294967295);var $123=HEAP8[($arrayidx344)];var $conv345=(tempInt=(($123)),(tempInt>=128?tempInt-256:tempInt));var $cmp346=((($conv345))|0)==6;if($cmp346){__label__=91;;}else{__label__=94;;}
if(__label__==91){var $124=$found;var $tobool348=((($124))|0)!=0;if($tobool348){__label__=92;;}else{__label__=93;;}
if(__label__==92){var $125=$ix;var $126=$ph_out_addr;var $arrayidx350=(($126+$125)&4294967295);HEAP8[($arrayidx350)]=5;;}
else if(__label__==93){$found=1;;}}
var $127=$ix;var $dec=((($127)-1)&4294967295);$ix=$dec;var $cmp343=((($dec))|0)>=0;if($cmp343){__label__=90;continue;}else{__label__=95;break $if_then340$$if_end354$121;}}}}while(0);var $128=$used_and;STACKTOP=__stackBase__;return $128;return null;}
function __ZL9M_Varianti($value){;var __label__;var $retval;var $value_addr;$value_addr=$value;var $0=HEAP32[((_translator)>>2)];var $langopts=(($0)&4294967295);var $numbers2=(($langopts+188)&4294967295);var $1=HEAP32[(($numbers2)>>2)];var $and=($1)&256;var $tobool=((($and))|0)!=0;if($tobool){__label__=1;;}else{__label__=3;;}
$land_lhs_true$$if_else$2:do{if(__label__==1){var $2=$value_addr;var $cmp=((($2))|0)>=2;var $3=$value_addr;var $cmp2=((($3))|0)<=4;var $or_cond=($cmp)&($cmp2);if(!($or_cond)){__label__=3;break $land_lhs_true$$if_else$2;}
$retval=((__str54351)&4294967295);__label__=13;break $land_lhs_true$$if_else$2;}}while(0);$return$$if_else$5:do{if(__label__==3){var $4=$value_addr;var $rem=((($4))|0)%100;var $cmp3=((($rem))|0)<10;if($cmp3){__label__=5;;}else{__label__=4;;}
$if_then6$$lor_lhs_false$7:do{if(__label__==4){var $5=$value_addr;var $rem4=((($5))|0)%100;var $cmp5=((($rem4))|0)>20;if($cmp5){__label__=5;break $if_then6$$lor_lhs_false$7;}else{__label__=12;break $if_then6$$lor_lhs_false$7;}}}while(0);$if_then6$$if_end28$9:do{if(__label__==5){var $6=HEAP32[((_translator)>>2)];var $langopts7=(($6)&4294967295);var $numbers28=(($langopts7+188)&4294967295);var $7=HEAP32[(($numbers28)>>2)];var $and9=($7)&64;var $tobool10=((($and9))|0)!=0;if($tobool10){__label__=6;;}else{__label__=9;;}
$land_lhs_true11$$if_end$11:do{if(__label__==6){var $8=$value_addr;var $rem12=((($8))|0)%10;var $cmp13=((($rem12))|0)>=2;if(!($cmp13)){__label__=9;break $land_lhs_true11$$if_end$11;}
var $9=$value_addr;var $rem15=((($9))|0)%10;var $cmp16=((($rem15))|0)<=4;if(!($cmp16)){__label__=9;break $land_lhs_true11$$if_end$11;}
$retval=((__str54351)&4294967295);__label__=13;break $return$$if_else$5;}}while(0);var $10=HEAP32[((_translator)>>2)];var $langopts18=(($10)&4294967295);var $numbers219=(($langopts18+188)&4294967295);var $11=HEAP32[(($numbers219)>>2)];var $and20=($11)&128;var $tobool21=((($and20))|0)!=0;if(!($tobool21)){__label__=12;break $if_then6$$if_end28$9;}
var $12=$value_addr;var $rem23=((($12))|0)%10;var $cmp24=((($rem23))|0)==1;if(!($cmp24)){__label__=12;break $if_then6$$if_end28$9;}
$retval=((__str55352)&4294967295);__label__=13;break $return$$if_else$5;}}while(0);$retval=((__str56353)&4294967295);;}}while(0);var $13=$retval;;return $13;return null;}
function __Z15LoadMbrolaTablePKcS0_i($mbrola_voice,$phtrans,$srate){var __stackBase__=STACKTOP;STACKTOP+=168;_memset(__stackBase__,0,168);var __label__;var $retval;var $mbrola_voice_addr;var $phtrans_addr;var $srate_addr;var $size;var $ix;var $pw;var $f_in;var $path=__stackBase__;$mbrola_voice_addr=$mbrola_voice;$phtrans_addr=$phtrans;$srate_addr=$srate;HEAP8[(((_mbrola_name)&4294967295))]=0;HEAP32[((_mbrola_delay)>>2)]=0;HEAP32[((__ZL15mbr_name_prefix)>>2)]=0;var $0=$mbrola_voice_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=HEAP32[((_samplerate_native)>>2)];HEAP32[((_samplerate)>>2)]=$1;__Z12SetParameteriii(14,0,0);$retval=0;;}
else if(__label__==2){var $arraydecay=(($path)&4294967295);var $2=$mbrola_voice_addr;var $call=_sprintf($arraydecay,((__str382)&4294967295),allocate([((_path_home)&4294967295),0,0,0,$2,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay1=(($path)&4294967295);var $call2=__Z13GetFileLengthPKc($arraydecay1);var $cmp3=((($call2))|0)<=0;if($cmp3){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $arraydecay5=(($path)&4294967295);var $3=$mbrola_voice_addr;var $call6=_sprintf($arraydecay5,((__str1383)&4294967295),allocate([$3,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
var $arraydecay8=(($path)&4294967295);var $call9=__Z13GetFileLengthPKc($arraydecay8);var $cmp10=((($call9))|0)<=0;if($cmp10){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $arraydecay12=(($path)&4294967295);var $4=$mbrola_voice_addr;var $5=$mbrola_voice_addr;var $call13=_sprintf($arraydecay12,((__str2384)&4294967295),allocate([$4,0,0,0,$5,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));;}
var $arraydecay15=(($path)&4294967295);var $call16=__Z13GetFileLengthPKc($arraydecay15);var $cmp17=((($call16))|0)<=0;if($cmp17){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $arraydecay19=(($path)&4294967295);var $6=$mbrola_voice_addr;var $call20=_sprintf($arraydecay19,((__str3385)&4294967295),allocate([$6,0,0,0],["i8*",0,0,0],ALLOC_STACK));;}
var $arraydecay22=(($path)&4294967295);var $call23=_init_MBR($arraydecay22);var $cmp24=((($call23))|0)!=0;if($cmp24){__label__=9;;}else{__label__=10;;}
if(__label__==9){$retval=2;;}
else if(__label__==10){_setNoError_MBR();var $arraydecay27=(($path)&4294967295);var $7=$phtrans_addr;var $call28=_sprintf($arraydecay27,((__str4386)&4294967295),allocate([((_path_home)&4294967295),0,0,0,$7,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay29=(($path)&4294967295);var $call30=__Z13GetFileLengthPKc($arraydecay29);$size=$call30;var $arraydecay31=(($path)&4294967295);var $call32=_fopen($arraydecay31,((__str18429)&4294967295));$f_in=$call32;var $cmp33=((($call32))|0)==0;if($cmp33){__label__=11;;}else{__label__=12;;}
if(__label__==11){_close_MBR();$retval=2;;}
else if(__label__==12){var $8=HEAP32[((__ZL10mbrola_tab)>>2)];var $9=$8;var $10=$size;var $call36=_realloc($9,$10);var $11=$call36;HEAP32[((__ZL10mbrola_tab)>>2)]=$11;var $cmp37=((($11))|0)==0;var $12=$f_in;if($cmp37){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $call39=_fclose($12);_close_MBR();$retval=-1;;}
else if(__label__==14){var $call41=__Z10Read4BytesP7__sFILE($12);HEAP32[((__ZL14mbrola_control)>>2)]=$call41;var $13=HEAP32[((__ZL10mbrola_tab)>>2)];var $14=$13;$pw=$14;$ix=4;var $15=$ix;var $16=$size;var $cmp421=((($15))|0)<((($16))|0);if($cmp421){__label__=15;;}else{__label__=16;;}
$for_body$$for_end$23:do{if(__label__==15){while(1){var $17=$f_in;var $call43=__Z10Read4BytesP7__sFILE($17);var $18=$pw;var $incdec_ptr=(($18+4)&4294967295);$pw=$incdec_ptr;HEAP32[(($18)>>2)]=$call43;var $19=$ix;var $add=((($19)+4)&4294967295);$ix=$add;var $20=$ix;var $21=$size;var $cmp42=((($20))|0)<((($21))|0);if($cmp42){__label__=15;continue;}else{__label__=16;break $for_body$$for_end$23;}}}}while(0);var $22=HEAP32[((__ZL10mbrola_tab)>>2)];var $23=$22;var $24=$size;var $25=$f_in;var $call44=_fread($23,1,$24,$25);$size=$call44;var $26=$f_in;var $call45=_fclose($26);var $27=HEAP32[((__ZL14mbrola_control)>>2)];var $and=($27)&255;var $conv=((($and))|0);var $div=($conv)/16;_setVolumeRatio_MBR($div);var $28=$srate_addr;HEAP32[((_samplerate)>>2)]=$28;var $cmp46=((($28))|0)==22050;if($cmp46){__label__=17;;}else{__label__=18;;}
if(__label__==17){__Z12SetParameteriii(14,0,0);;}
else if(__label__==18){__Z12SetParameteriii(14,1,0);;}
var $29=$mbrola_voice_addr;var $call49=_strcpy(((_mbrola_name)&4294967295),$29);HEAP32[((_mbrola_delay)>>2)]=1000;$retval=0;;}}}}
var $30=$retval;STACKTOP=__stackBase__;return $30;return null;}
function _setNoError_MBR(){;var __label__;;return;return;}
function __Z15MbrolaTranslateP12PHONEME_LISTiiP7__sFILE($plist,$n_phonemes,$resume,$f_mbrola){var __stackBase__=STACKTOP;STACKTOP+=332;_memset(__stackBase__,0,332);var __label__;var __lastLabel__=null;var $retval;var $plist_addr;var $n_phonemes_addr;var $resume_addr;var $f_mbrola_addr;var $name;var $len;var $len1;var $ph;var $ph_next;var $ph_prev;var $p;var $next;var $prev;var $phdata=__stackBase__;var $fmtp=__stackBase__+152;var $pause;var $released;var $name2=__stackBase__+200;var $control=__stackBase__+204;var $done;var $len_percent=__stackBase__+208;var $final_pitch;var $ptr;var $mbr_buf=__stackBase__+212;var $pitch;var $pitch101;var $res;$plist_addr=$plist;$n_phonemes_addr=$n_phonemes;$resume_addr=$resume;$f_mbrola_addr=$f_mbrola;$pause=0;var $0=$resume_addr;var $tobool=((($0))|0)!=0;if($tobool){__label__=2;;}else{__label__=1;;}
if(__label__==1){HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)]=1;HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE11embedded_ix)>>2)]=0;HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE10word_count)>>2)]=0;;}
var $arraydecay=(($mbr_buf)&4294967295);var $arraydecay233=(($mbr_buf)&4294967295);var $arraydecay234=(($mbr_buf)&4294967295);var $sub_ptr_rhs_cast=($arraydecay234);var $1=$fmtp;var $sound_addr=(($phdata+68)&4294967295);var $arrayidx176=(($sound_addr)&4294967295);var $fmt_addr=(($fmtp+8)&4294967295);;$while_cond$5:while(1){var $2=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $3=$n_phonemes_addr;var $cmp=((($2))|0)<((($3))|0);if(!($cmp)){__label__=64;break $while_cond$5;}
var $call=__Z9WcmdqFreev();var $cmp1=((($call))|0)<22;if($cmp1){__label__=5;break $while_cond$5;}
$ptr=$arraydecay;var $4=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $5=$plist_addr;var $arrayidx=(($5+24*$4)&4294967295);$p=$arrayidx;var $6=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $add=((($6)+1)&4294967295);var $7=$plist_addr;var $arrayidx4=(($7+24*$add)&4294967295);$next=$arrayidx4;var $8=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $sub=((($8)-1)&4294967295);var $9=$plist_addr;var $arrayidx5=(($9+24*$sub)&4294967295);$prev=$arrayidx5;var $10=$p;var $ph6=(($10+8)&4294967295);var $11=HEAP32[(($ph6)>>2)];$ph=$11;var $12=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $sub7=((($12)-1)&4294967295);var $13=$plist_addr;var $arrayidx8=(($13+24*$sub7)&4294967295);var $ph9=(($arrayidx8+8)&4294967295);var $14=HEAP32[(($ph9)>>2)];$ph_prev=$14;var $15=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $add10=((($15)+1)&4294967295);var $16=$plist_addr;var $arrayidx11=(($16+24*$add10)&4294967295);var $ph12=(($arrayidx11+8)&4294967295);var $17=HEAP32[(($ph12)>>2)];$ph_next=$17;var $18=$p;var $synthflags=(($18+4)&4294967295);var $19=HEAPU16[(($synthflags)>>1)];var $conv=((($19))&65535);var $and=($conv)&2;var $tobool13=((($and))|0)!=0;if($tobool13){__label__=7;;}else{__label__=8;;}
if(__label__==7){var $20=$p;var $sourceix=(($20+6)&4294967295);var $21=HEAPU16[(($sourceix)>>1)];var $conv15=((($21))&65535);__Z10DoEmbeddedPii(__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE11embedded_ix,$conv15);;}
var $22=$p;var $newword=(($22+19)&4294967295);var $23=HEAPU8[($newword)];var $conv17=((($23))&255);var $and18=($conv17)&4;var $tobool19=((($and18))|0)!=0;if($tobool19){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $24=$p;var $sourceix21=(($24+6)&4294967295);var $25=HEAPU16[(($sourceix21)>>1)];var $conv22=((($25))&65535);var $and23=($conv22)&2047;var $26=HEAP32[((_clause_start_char)>>2)];var $add24=((($and23)+($26))&4294967295);var $27=HEAP32[((_count_sentences)>>2)];__Z8DoMarkeriiii(2,$add24,0,$27);;}
var $28=$p;var $newword26=(($28+19)&4294967295);var $29=HEAPU8[($newword26)];var $conv27=((($29))&255);var $and28=($conv27)&1;var $tobool29=((($and28))|0)!=0;if($tobool29){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $30=$p;var $sourceix31=(($30+6)&4294967295);var $31=HEAPU16[(($sourceix31)>>1)];var $conv32=((($31))&65535);var $and33=($conv32)&2047;var $32=HEAP32[((_clause_start_char)>>2)];var $add34=((($and33)+($32))&4294967295);var $33=$p;var $sourceix35=(($33+6)&4294967295);var $34=HEAPU16[(($sourceix35)>>1)];var $conv36=((($34))&65535);var $shr=($conv36)>>11;var $35=HEAP32[((_clause_start_word)>>2)];var $36=HEAPU32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE10word_count)>>2)];var $inc=((($36)+1)&4294967295);HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE10word_count)>>2)]=$inc;var $add37=((($36)+($35))&4294967295);__Z8DoMarkeriiii(1,$add34,$shr,$add37);;}
var $37=$p;var $38=$ph;var $39=$ph_prev;var $40=$ph_next;var $call39=__ZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_($37,$38,$39,$40,$name2,$len_percent,$control);$name=$call39;var $41=HEAP32[(($control)>>2)];var $and40=($41)&1;var $tobool41=((($and40))|0)!=0;if($tobool41){__lastLabel__=12;__label__=13;;}else{__lastLabel__=12;__label__=14;;}
if(__label__==13){var $42=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $inc43=((($42)+1)&4294967295);HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)]=$inc43;var $_pr=$name;__lastLabel__=13;;}
var $43=__lastLabel__==13?$_pr:($call39);var $cmp45=((($43))|0)==0;if($cmp45){__label__=15;;}else{__label__=16;;}
if(__label__==15){var $44=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $inc47=((($44)+1)&4294967295);HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)]=$inc47;__label__=3;continue $while_cond$5;}
else if(__label__==16){var $45=$ph;var $type=(($45+11)&4294967295);var $46=HEAPU8[($type)];var $conv49=((($46))&255);var $cmp50=((($conv49))|0)==0;if($cmp50){__label__=17;;}else{__label__=20;;}
$land_lhs_true$$if_else$24:do{if(__label__==17){var $47=$name;var $48=$ph;var $mnemonic=(($48)&4294967295);var $49=HEAP32[(($mnemonic)>>2)];var $cmp51=((($47))|0)==((($49))|0);if(!($cmp51)){__label__=20;break $land_lhs_true$$if_else$24;}
$name=95;var $50=$p;var $length=(($50+12)&4294967295);var $51=HEAP16[(($length)>>1)];var $conv53=(tempInt=(($51)),(tempInt>=32768?tempInt-65536:tempInt));var $52=HEAP32[((((_speed)&4294967295))>>2)];var $mul=((($conv53)*($52))&4294967295);var $div=((((($mul))|0)/256)|0);$len=$div;var $53=$len;var $cmp54=((($53))|0)==0;if(!($cmp54)){__label__=21;break $land_lhs_true$$if_else$24;}
$len=1;__label__=21;break $land_lhs_true$$if_else$24;}}while(0);if(__label__==20){var $54=HEAP32[((((_speed+12)&4294967295))>>2)];var $mul57=((($54)*80)&4294967295);var $div58=((((($mul57))|0)/256)|0);$len=$div58;;}
var $55=$p;var $sourceix60=(($55+6)&4294967295);var $56=HEAPU16[(($sourceix60)>>1)];var $conv61=((($56))&65535);var $and62=($conv61)&2047;var $57=HEAP32[((_clause_start_char)>>2)];var $add63=((($and62)+($57))&4294967295);var $58=$ph;var $mnemonic64=(($58)&4294967295);var $59=HEAP32[(($mnemonic64)>>2)];__Z8DoMarkeriiii(7,$add63,0,$59);var $60=$ptr;var $61=$name;var $call65=__Z12WordToStringj($61);var $call66=_sprintf($60,((__str6388)&4294967295),allocate([((__ZZ12WordToStringjE3buf)&4294967295),0,0,0],["i8*",0,0,0],ALLOC_STACK));var $62=$ptr;var $add_ptr=(($62+$call66)&4294967295);$ptr=$add_ptr;var $63=HEAP32[(($name2)>>2)];var $cmp67=((($63))|0)==95;if($cmp67){__label__=22;;}else{__label__=23;;}
if(__label__==22){var $64=HEAP32[(($len_percent)>>2)];$pause=$64;HEAP32[(($name2)>>2)]=0;;}
$done=0;$final_pitch=((__str13643)&4294967295);var $65=$ph;var $type70=(($65+11)&4294967295);var $66=HEAPU8[($type70)];var $conv71=((($66))&255);if($conv71==2){__label__=24;;}
else if($conv71==4){__label__=32;;}
else if($conv71==5){__label__=40;;}
else if($conv71==6){__label__=41;;}
else if($conv71==8){__label__=44;;}
else if($conv71==3){__label__=48;;}
else{__label__=50;;}
$sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34:do{if(__label__==24){var $67=$ph;var $std_length=(($67+14)&4294967295);var $68=HEAPU8[($std_length)];var $conv72=((($68))&255);$len=$conv72;var $69=$p;var $synthflags73=(($69+4)&4294967295);var $70=HEAPU16[(($synthflags73)>>1)];var $conv74=((($70))&65535);var $and75=($conv74)&8;var $tobool76=((($and75))|0)!=0;if($tobool76){__label__=25;;}else{__label__=26;;}
if(__label__==25){var $71=HEAP32[((((_phoneme_tab+48)&4294967295))>>2)];var $std_length78=(($71+14)&4294967295);var $72=HEAPU8[($std_length78)];var $conv79=((($72))&255);var $73=$len;var $add80=((($73)+($conv79))&4294967295);$len=$add80;;}
var $74=$ph_next;var $type82=(($74+11)&4294967295);var $75=HEAPU8[($type82)];var $conv83=((($75))&255);var $cmp84=((($conv83))|0)==0;if($cmp84){__label__=27;;}else{__label__=28;;}
if(__label__==27){var $76=$len;var $add86=((($76)+50)&4294967295);$len=$add86;;}
var $77=$len;var $78=$p;var $length88=(($78+12)&4294967295);var $79=HEAP16[(($length88)>>1)];var $conv89=(tempInt=(($79)),(tempInt>=32768?tempInt-65536:tempInt));var $mul90=((($conv89)*($77))&4294967295);var $div91=((((($mul90))|0)/256)|0);$len=$div91;var $80=HEAP32[(($name2)>>2)];var $cmp92=((($80))|0)==0;var $81=$p;var $env=(($81+14)&4294967295);var $82=HEAPU8[($env)];var $conv94=((($82))&255);var $83=$p;var $pitch1=(($83+20)&4294967295);var $84=HEAPU8[($pitch1)];var $conv95=((($84))&255);var $85=$p;var $pitch2=(($85+21)&4294967295);var $86=HEAPU8[($pitch2)];var $conv96=((($86))&255);if($cmp92){__label__=29;;}else{__label__=30;;}
if(__label__==29){__ZL10WritePitchiiiii($conv94,$conv95,$conv96,0,0);$pitch=((__ZZL10WritePitchiiiiiE6output)&4294967295);var $87=$ptr;var $88=$len;var $89=$pitch;var $call98=_sprintf($87,((__str8390)&4294967295),allocate([$88,0,0,0,$89,0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $90=$ptr;var $add_ptr99=(($90+$call98)&4294967295);$ptr=$add_ptr99;;}
else if(__label__==30){var $91=HEAP32[(($len_percent)>>2)];__ZL10WritePitchiiiii($conv94,$conv95,$conv96,$91,0);$pitch101=((__ZZL10WritePitchiiiiiE6output)&4294967295);var $92=$len;var $93=HEAP32[(($len_percent)>>2)];var $mul109=((($93)*($92))&4294967295);var $div110=((((($mul109))|0)/100)|0);$len1=$div110;var $94=$ptr;var $95=$len1;var $96=$pitch101;var $call111=_sprintf($94,((__str8390)&4294967295),allocate([$95,0,0,0,$96,0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $97=$ptr;var $add_ptr112=(($97+$call111)&4294967295);$ptr=$add_ptr112;var $98=$p;var $env113=(($98+14)&4294967295);var $99=HEAPU8[($env113)];var $conv114=((($99))&255);var $100=$p;var $pitch1115=(($100+20)&4294967295);var $101=HEAPU8[($pitch1115)];var $conv116=((($101))&255);var $102=$p;var $pitch2117=(($102+21)&4294967295);var $103=HEAPU8[($pitch2117)];var $conv118=((($103))&255);var $104=HEAP32[(($len_percent)>>2)];var $sub119=(((-($104)))&4294967295);__ZL10WritePitchiiiii($conv114,$conv116,$conv118,$sub119,0);$pitch101=((__ZZL10WritePitchiiiiiE6output)&4294967295);var $105=$ptr;var $106=HEAP32[(($name2)>>2)];var $call121=__Z12WordToStringj($106);var $107=$len;var $108=$len1;var $sub122=((($107)-($108))&4294967295);var $109=$pitch101;var $call123=_sprintf($105,((__str9391)&4294967295),allocate([((__ZZ12WordToStringjE3buf)&4294967295),0,0,0,$sub122,0,0,0,$109,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $110=$ptr;var $add_ptr124=(($110+$call123)&4294967295);$ptr=$add_ptr124;;}
$done=1;__label__=54;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
else if(__label__==32){$released=0;var $111=$next;var $type127=(($111+15)&4294967295);var $112=HEAPU8[($type127)];var $conv128=((($112))&255);var $cmp129=((($conv128))|0)==2;if($cmp129){__label__=33;;}else{__label__=34;;}
if(__label__==33){$released=1;;}
var $113=$next;var $type132=(($113+15)&4294967295);var $114=HEAPU8[($type132)];var $conv133=((($114))&255);var $cmp134=((($conv133))|0)==3;if($cmp134){__label__=35;;}else{__label__=37;;}
$land_lhs_true135$$if_end139$50:do{if(__label__==35){var $115=$next;var $newword136=(($115+19)&4294967295);var $116=HEAP8[($newword136)];var $tobool137=(tempInt=(($116)),(tempInt>=128?tempInt-256:tempInt))!=0;if($tobool137){__label__=37;break $land_lhs_true135$$if_end139$50;}
$released=1;__label__=39;break $land_lhs_true135$$if_end139$50;}}while(0);$if_end139$$if_end145$53:do{if(__label__==37){var $_pr1=$released;var $cmp140=((($_pr1))|0)==0;if(!($cmp140)){__label__=39;break $if_end139$$if_end145$53;}
var $117=$p;var $synthflags142=(($117+4)&4294967295);var $118=HEAPU16[(($synthflags142)>>1)];var $conv143=((($118))&65535);var $or=($conv143)|8192;var $conv144=((($or))&65535);HEAP16[(($synthflags142)>>1)]=$conv144;;}}while(0);var $119=$p;__Z16InterpretPhonemeP10TranslatoriP12PHONEME_LISTP12PHONEME_DATA(0,0,$119,$phdata);var $call146=__Z9DoSample3P12PHONEME_DATAii($phdata,0,-1);$len=$call146;var $120=$len;var $mul147=((($120)*1000)&4294967295);var $121=HEAP32[((_samplerate)>>2)];var $div148=((((($mul147))|0)/((($121))|0))|0);$len=$div148;var $122=$p;var $prepause=(($122+16)&4294967295);var $123=HEAPU8[($prepause)];var $conv149=((($123))&255);var $call150=__Z11PauseLengthii($conv149,1);var $124=$len;var $add151=((($124)+($call150))&4294967295);$len=$add151;__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
else if(__label__==40){var $125=HEAP32[((((_speed+12)&4294967295))>>2)];var $mul153=((($125)*80)&4294967295);var $div154=((((($mul153))|0)/256)|0);$len=$div154;__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
else if(__label__==41){$len=0;var $126=$p;__Z16InterpretPhonemeP10TranslatoriP12PHONEME_LISTP12PHONEME_DATA(0,0,$126,$phdata);var $127=$p;var $synthflags156=(($127+4)&4294967295);var $128=HEAPU16[(($synthflags156)>>1)];var $conv157=((($128))&65535);var $and158=($conv157)&8;var $tobool159=((($and158))|0)!=0;if($tobool159){__label__=42;;}else{__label__=43;;}
if(__label__==42){var $129=$p;var $length161=(($129+12)&4294967295);var $130=HEAP16[(($length161)>>1)];var $conv162=(tempInt=(($130)),(tempInt>=32768?tempInt-65536:tempInt));var $call163=__Z9DoSample3P12PHONEME_DATAii($phdata,$conv162,-1);$len=$call163;;}
var $131=$p;var $length165=(($131+12)&4294967295);var $132=HEAP16[(($length165)>>1)];var $conv166=(tempInt=(($132)),(tempInt>=32768?tempInt-65536:tempInt));var $call167=__Z9DoSample3P12PHONEME_DATAii($phdata,$conv166,-1);var $133=$len;var $add168=((($133)+($call167))&4294967295);$len=$add168;var $134=$len;var $mul169=((($134)*1000)&4294967295);var $135=HEAP32[((_samplerate)>>2)];var $div170=((((($mul169))|0)/((($135))|0))|0);$len=$div170;__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
else if(__label__==44){var $136=$next;var $type172=(($136+15)&4294967295);var $137=HEAPU8[($type172)];var $conv173=((($137))&255);var $cmp174=((($conv173))|0)!=2;if(!($cmp174)){__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$1;$stop$=$dest$+48;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $138=$p;__Z16InterpretPhonemeP10TranslatoriP12PHONEME_LISTP12PHONEME_DATA(0,0,$138,$phdata);var $139=HEAP32[(($arrayidx176)>>2)];HEAP32[(($fmt_addr)>>2)]=$139;var $140=$p;var $ph177=(($140+8)&4294967295);var $141=HEAP32[(($ph177)>>2)];var $142=$p;var $call178=__Z8DoSpect2P11PHONEME_TABiP10FMT_PARAMSP12PHONEME_LISTi($141,0,$fmtp,$142,-1);$len=$call178;var $143=$len;var $mul179=((($143)*1000)&4294967295);var $144=HEAP32[((_samplerate)>>2)];var $div180=((((($mul179))|0)/((($144))|0))|0);$len=$div180;var $145=$next;var $type181=(($145+15)&4294967295);var $146=HEAPU8[($type181)];var $conv182=((($146))&255);var $cmp183=((($conv182))|0)==0;if($cmp183){__label__=46;;}else{__label__=47;;}
if(__label__==46){var $147=$len;var $add185=((($147)+50)&4294967295);$len=$add185;;}
var $148=$p;var $env187=(($148+14)&4294967295);var $149=HEAPU8[($env187)];var $conv188=((($149))&255);var $150=$p;var $pitch1189=(($150+20)&4294967295);var $151=HEAPU8[($pitch1189)];var $conv190=((($151))&255);var $152=$p;var $pitch2191=(($152+21)&4294967295);var $153=HEAPU8[($pitch2191)];var $conv192=((($153))&255);__ZL10WritePitchiiiii($conv188,$conv190,$conv192,0,1);$final_pitch=((__ZZL10WritePitchiiiiiE6output)&4294967295);__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
else if(__label__==48){var $154=$next;var $type196=(($154+15)&4294967295);var $155=HEAPU8[($type196)];var $conv197=((($155))&255);var $cmp198=((($conv197))|0)==0;if(!($cmp198)){__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}
var $156=$len;var $add200=((($156)+50)&4294967295);$len=$add200;var $157=$p;var $env201=(($157+14)&4294967295);var $158=HEAPU8[($env201)];var $conv202=((($158))&255);var $159=$p;var $pitch1203=(($159+20)&4294967295);var $160=HEAPU8[($pitch1203)];var $conv204=((($160))&255);var $161=$p;var $pitch2205=(($161+21)&4294967295);var $162=HEAPU8[($pitch2205)];var $conv206=((($162))&255);__ZL10WritePitchiiiii($conv202,$conv204,$conv206,0,1);$final_pitch=((__ZZL10WritePitchiiiiiE6output)&4294967295);__label__=50;break $sw_epilog$$sw_bb$$sw_bb126$$sw_bb152$$sw_bb155$$sw_bb171$$sw_bb195$34;}}while(0);$sw_epilog$$if_end222$69:do{if(__label__==50){var $_pr3=$done;var $tobool209=((($_pr3))|0)!=0;if($tobool209){__label__=54;break $sw_epilog$$if_end222$69;}
var $163=HEAP32[(($name2)>>2)];var $cmp211=((($163))|0)!=0;if($cmp211){__label__=52;;}else{__label__=53;;}
if(__label__==52){var $164=$len;var $165=HEAP32[(($len_percent)>>2)];var $mul213=((($165)*($164))&4294967295);var $div214=((((($mul213))|0)/100)|0);$len1=$div214;var $166=$ptr;var $167=$len1;var $168=HEAP32[(($name2)>>2)];var $call215=__Z12WordToStringj($168);var $call216=_sprintf($166,((__str10392)&4294967295),allocate([$167,0,0,0,((__ZZ12WordToStringjE3buf)&4294967295),0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $169=$ptr;var $add_ptr217=(($169+$call216)&4294967295);$ptr=$add_ptr217;var $170=$len1;var $171=$len;var $sub218=((($171)-($170))&4294967295);$len=$sub218;;}
var $172=$ptr;var $173=$len;var $174=$final_pitch;var $call220=_sprintf($172,((__str11393)&4294967295),allocate([$173,0,0,0,$174,0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $175=$ptr;var $add_ptr221=(($175+$call220)&4294967295);$ptr=$add_ptr221;;}}while(0);var $176=$pause;var $tobool223=((($176))|0)!=0;if($tobool223){__label__=55;;}else{__label__=56;;}
if(__label__==55){var $177=$pause;var $call225=__Z11PauseLengthii($177,0);var $178=$len;var $add226=((($178)+($call225))&4294967295);$len=$add226;var $179=$ptr;var $180=$pause;var $call227=__Z11PauseLengthii($180,0);var $call228=_sprintf($179,((__str12394)&4294967295),allocate([$call227,0,0,0],["i32",0,0,0],ALLOC_STACK));var $181=$ptr;var $add_ptr229=(($181+$call228)&4294967295);$ptr=$add_ptr229;$pause=0;;}
var $182=$f_mbrola_addr;var $tobool231=((($182))|0)!=0;if($tobool231){__label__=57;;}else{__label__=58;;}
if(__label__==57){var $183=$ptr;var $sub_ptr_lhs_cast=($183);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $184=$f_mbrola_addr;var $call235=_fwrite($arraydecay233,1,$sub_ptr_sub,$184);;}
else if(__label__==58){var $call238=_write_MBR($arraydecay233);$res=$call238;var $185=$res;var $cmp239=((($185))|0)<0;if($cmp239){__label__=59;break $while_cond$5;}
var $186=$res;var $cmp242=((($186))|0)==0;if($cmp242){__label__=61;break $while_cond$5;}
var $187=HEAP32[((_wcmdq_tail)>>2)];var $arrayidx245=((_wcmdq+$187*16)&4294967295);var $arrayidx246=(($arrayidx245)&4294967295);HEAP32[(($arrayidx246)>>2)]=13;var $188=$len;var $189=HEAP32[((_wcmdq_tail)>>2)];var $arrayidx247=((_wcmdq+$189*16)&4294967295);var $arrayidx248=(($arrayidx247+4)&4294967295);HEAP32[(($arrayidx248)>>2)]=$188;__Z8WcmdqIncv();;}
var $190=HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)];var $inc250=((($190)+1)&4294967295);HEAP32[((__ZZ15MbrolaTranslateP12PHONEME_LISTiiP7__sFILEE4phix)>>2)]=$inc250;__label__=3;continue $while_cond$5;}}
if(__label__==64){var $191=$f_mbrola_addr;var $tobool251=((($191))|0)!=0;if($tobool251){__label__=66;;}else{__label__=65;;}
if(__label__==65){var $call253=_flush_MBR();var $192=HEAP32[((_wcmdq_tail)>>2)];var $arrayidx254=((_wcmdq+$192*16)&4294967295);var $arrayidx255=(($arrayidx254)&4294967295);HEAP32[(($arrayidx255)>>2)]=13;var $193=HEAP32[((_wcmdq_tail)>>2)];var $arrayidx256=((_wcmdq+$193*16)&4294967295);var $arrayidx257=(($arrayidx256+4)&4294967295);HEAP32[(($arrayidx257)>>2)]=500;__Z8WcmdqIncv();;}
$retval=0;;}
else if(__label__==5){$retval=1;;}
else if(__label__==59){$retval=0;;}
else if(__label__==61){$retval=1;;}
var $194=$retval;STACKTOP=__stackBase__;return $194;return null;}
function __ZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_($plist,$ph,$ph_prev,$ph_next,$name2,$split,$control){;var __label__;var $retval;var $plist_addr;var $ph_addr;var $ph_prev_addr;var $ph_next_addr;var $name2_addr;var $split_addr;var $control_addr;var $pr;var $other_ph;var $found;$plist_addr=$plist;$ph_addr=$ph;$ph_prev_addr=$ph_prev;$ph_next_addr=$ph_next;$name2_addr=$name2;$split_addr=$split;$control_addr=$control;$found=0;var $0=$name2_addr;HEAP32[(($0)>>2)]=0;var $1=$split_addr;HEAP32[(($1)>>2)]=0;var $2=$control_addr;HEAP32[(($2)>>2)]=0;var $3=$ph_addr;var $mnemonic=(($3)&4294967295);var $4=HEAP32[(($mnemonic)>>2)];HEAP32[((__ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem)>>2)]=$4;var $5=HEAP32[((__ZL10mbrola_tab)>>2)];$pr=$5;;$while_cond$2:while(1){var $6=$pr;var $name=(($6)&4294967295);var $7=HEAP32[(($name)>>2)];var $cmp=((($7))|0)!=0;if(!($cmp)){__label__=28;break $while_cond$2;}
var $8=HEAP32[((__ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem)>>2)];var $9=$pr;var $name1=(($9)&4294967295);var $10=HEAP32[(($name1)>>2)];var $cmp2=((($8))|0)==((($10))|0);if($cmp2){__label__=3;;}else{__label__=27;;}
$if_then$$if_end60$5:do{if(__label__==3){var $11=$pr;var $next_phoneme=(($11+4)&4294967295);var $12=HEAP32[(($next_phoneme)>>2)];var $cmp3=((($12))|0)==0;if($cmp3){__label__=4;;}else{__label__=5;;}
$if_then4$$if_else$7:do{if(__label__==4){$found=1;;}
else if(__label__==5){var $13=$pr;var $next_phoneme5=(($13+4)&4294967295);var $14=HEAP32[(($next_phoneme5)>>2)];var $cmp6=((($14))|0)==58;if($cmp6){__label__=6;;}else{__label__=8;;}
$land_lhs_true$$if_else8$10:do{if(__label__==6){var $15=$plist_addr;var $synthflags=(($15+4)&4294967295);var $16=HEAPU16[(($synthflags)>>1)];var $conv=((($16))&65535);var $and=($conv)&8;var $tobool=((($and))|0)!=0;if(!($tobool)){__label__=8;break $land_lhs_true$$if_else8$10;}
$found=1;__label__=20;break $if_then4$$if_else$7;}}while(0);var $17=$pr;var $control9=(($17+20)&4294967295);var $18=HEAP32[(($control9)>>2)];var $and10=($18)&2;var $tobool11=((($and10))|0)!=0;if($tobool11){__label__=9;;}else{__label__=10;;}
$if_then12$$if_else13$14:do{if(__label__==9){var $19=$ph_prev_addr;$other_ph=$19;;}
else if(__label__==10){var $20=$pr;var $control14=(($20+20)&4294967295);var $21=HEAP32[(($control14)>>2)];var $and15=($21)&8;var $tobool16=((($and15))|0)!=0;if($tobool16){__label__=11;;}else{__label__=13;;}
$land_lhs_true17$$if_else20$17:do{if(__label__==11){var $22=$plist_addr;var $add_ptr=(($22+24)&4294967295);var $newword=(($add_ptr+19)&4294967295);var $23=HEAP8[($newword)];var $tobool18=(tempInt=(($23)),(tempInt>=128?tempInt-256:tempInt))!=0;if(!($tobool18)){__label__=13;break $land_lhs_true17$$if_else20$17;}
var $24=HEAP32[((((_phoneme_tab)&4294967295))>>2)];$other_ph=$24;__label__=14;break $if_then12$$if_else13$14;}}while(0);var $25=$ph_next_addr;$other_ph=$25;;}}while(0);var $26=$pr;var $next_phoneme22=(($26+4)&4294967295);var $27=HEAP32[(($next_phoneme22)>>2)];var $28=$other_ph;var $mnemonic23=(($28)&4294967295);var $29=HEAP32[(($mnemonic23)>>2)];var $cmp24=((($27))|0)==((($29))|0);if($cmp24){__label__=19;;}else{__label__=15;;}
$if_then37$$lor_lhs_false$22:do{if(__label__==15){var $30=$pr;var $next_phoneme25=(($30+4)&4294967295);var $31=HEAP32[(($next_phoneme25)>>2)];var $cmp26=((($31))|0)==2;if($cmp26){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $32=$other_ph;var $type=(($32+11)&4294967295);var $33=HEAPU8[($type)];var $conv28=((($33))&255);var $cmp29=((($conv28))|0)==2;if($cmp29){__label__=19;break $if_then37$$lor_lhs_false$22;}}
var $34=$pr;var $next_phoneme31=(($34+4)&4294967295);var $35=HEAP32[(($next_phoneme31)>>2)];var $cmp32=((($35))|0)==95;if(!($cmp32)){__label__=20;break $if_then4$$if_else$7;}
var $36=$other_ph;var $type34=(($36+11)&4294967295);var $37=HEAPU8[($type34)];var $conv35=((($37))&255);var $cmp36=((($conv35))|0)==0;if(!($cmp36)){__label__=20;break $if_then4$$if_else$7;}}}while(0);$found=1;;}}while(0);var $38=$pr;var $control41=(($38+20)&4294967295);var $39=HEAP32[(($control41)>>2)];var $and42=($39)&4;var $tobool43=((($and42))|0)!=0;if($tobool43){__label__=21;;}else{__label__=23;;}
$land_lhs_true44$$if_end49$30:do{if(__label__==21){var $40=$plist_addr;var $newword45=(($40+19)&4294967295);var $41=HEAPU8[($newword45)];var $conv46=((($41))&255);var $cmp47=((($conv46))|0)==0;if(!($cmp47)){__label__=23;break $land_lhs_true44$$if_end49$30;}
$found=0;__label__=27;break $if_then$$if_end60$5;}}while(0);var $_pr=$found;var $tobool50=((($_pr))|0)!=0;if($tobool50){__label__=24;break $while_cond$2;}}}while(0);var $55=$pr;var $incdec_ptr=(($55+24)&4294967295);$pr=$incdec_ptr;__label__=1;continue $while_cond$2;}
$while_end$$if_then51$35:do{if(__label__==24){var $42=$pr;var $mbr_name2=(($42+12)&4294967295);var $43=HEAP32[(($mbr_name2)>>2)];var $44=$name2_addr;HEAP32[(($44)>>2)]=$43;var $45=$pr;var $percent=(($45+16)&4294967295);var $46=HEAP32[(($percent)>>2)];var $47=$split_addr;HEAP32[(($47)>>2)]=$46;var $48=$pr;var $control52=(($48+20)&4294967295);var $49=HEAP32[(($control52)>>2)];var $50=$control_addr;HEAP32[(($50)>>2)]=$49;var $51=$pr;var $control53=(($51+20)&4294967295);var $52=HEAP32[(($control53)>>2)];var $and54=($52)&16;var $tobool55=((($and54))|0)!=0;var $53=$pr;var $mbr_name=(($53+8)&4294967295);var $54=HEAP32[(($mbr_name)>>2)];if($tobool55){__label__=25;;}else{__label__=26;;}
if(__label__==25){HEAP32[((__ZL15mbr_name_prefix)>>2)]=$54;$retval=0;__label__=31;break $while_end$$if_then51$35;}
else if(__label__==26){HEAP32[((__ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem)>>2)]=$54;__label__=28;break $while_end$$if_then51$35;}}}while(0);if(__label__==28){var $56=HEAP32[((__ZL15mbr_name_prefix)>>2)];var $cmp61=((($56))|0)!=0;if($cmp61){__label__=29;;}else{__label__=30;;}
if(__label__==29){var $57=HEAP32[((__ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem)>>2)];var $shl=($57)<<8;var $58=HEAP32[((__ZL15mbr_name_prefix)>>2)];var $and63=($58)&255;var $or=($and63)|($shl);HEAP32[((__ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem)>>2)]=$or;;}
HEAP32[((__ZL15mbr_name_prefix)>>2)]=0;var $59=HEAP32[((__ZZL10GetMbrNameP12PHONEME_LISTP11PHONEME_TABS2_S2_PiS3_S3_E4mnem)>>2)];$retval=$59;;}
var $60=$retval;;return $60;return null;}
function __ZL10WritePitchiiiii($env,$pitch1,$pitch2,$split,$final){var __stackBase__=STACKTOP;STACKTOP+=76;_memset(__stackBase__,0,76);var __label__;var __lastLabel__=null;var $env_addr;var $pitch1_addr;var $pitch2_addr;var $split_addr;var $final_addr;var $x;var $ix;var $pitch_base=__stackBase__;var $pitch_range=__stackBase__+4;var $p1;var $p2;var $p_end;var $pitch_env;var $max;var $min;var $y_max;var $y_min;var $env100;var $y2;var $y=__stackBase__+8;var $env_split;var $buf=__stackBase__+24;$env_addr=$env;$pitch1_addr=$pitch1;$pitch2_addr=$pitch2;$split_addr=$split;$final_addr=$final;$max=-1;$min=999;$y_max=0;$y_min=0;$env100=80;HEAP8[(((__ZZL10WritePitchiiiiiE6output)&4294967295))]=0;var $0=$env_addr;var $arrayidx=((_envelope_data+$0*4)&4294967295);var $1=HEAP32[(($arrayidx)>>2)];$pitch_env=$1;var $2=HEAP32[((_voice)>>2)];var $3=$pitch1_addr;var $4=$pitch2_addr;__Z9SetPitch2P7voice_tiiPiS1_($2,$3,$4,$pitch_base,$pitch_range);var $5=$split_addr;var $mul=((($5)*128)&4294967295);var $div=((((($mul))|0)/100)|0);$env_split=$div;var $6=$env_split;var $cmp=((($6))|0)<0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $7=$env_split;var $sub=(((-($7)))&4294967295);$env_split=$sub;;}
$x=0;;$for_body$5:while(1){var $8=$x;var $9=$pitch_env;var $arrayidx2=(($9+$8)&4294967295);var $10=HEAPU8[($arrayidx2)];var $conv=((($10))&255);var $11=$max;var $cmp3=((($conv))|0)>((($11))|0);if($cmp3){__label__=4;;}else{__label__=5;;}
if(__label__==4){var $12=$x;var $13=$pitch_env;var $arrayidx5=(($13+$12)&4294967295);var $14=HEAPU8[($arrayidx5)];var $conv6=((($14))&255);$max=$conv6;var $15=$x;$y_max=$15;;}
var $16=$x;var $17=$pitch_env;var $arrayidx8=(($17+$16)&4294967295);var $18=HEAPU8[($arrayidx8)];var $conv9=((($18))&255);var $19=$min;var $cmp10=((($conv9))|0)<((($19))|0);if($cmp10){__label__=6;;}else{__label__=7;;}
if(__label__==6){var $20=$x;var $21=$pitch_env;var $arrayidx12=(($21+$20)&4294967295);var $22=HEAPU8[($arrayidx12)];var $conv13=((($22))&255);$min=$conv13;var $23=$x;$y_min=$23;;}
var $24=$x;var $inc=((($24)+1)&4294967295);$x=$inc;var $cmp1=((($inc))|0)<128;if($cmp1){__label__=3;continue $for_body$5;}else{__label__=8;break $for_body$5;}}
var $arrayidx15=(($y+8)&4294967295);HEAP32[(($arrayidx15)>>2)]=64;var $25=$y_max;var $cmp16=((($25))|0)>0;var $26=$y_max;var $cmp17=((($26))|0)<127;var $or_cond=($cmp16)&($cmp17);if($or_cond){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $27=$y_max;var $arrayidx19=(($y+8)&4294967295);HEAP32[(($arrayidx19)>>2)]=$27;;}
var $28=$y_min;var $cmp21=((($28))|0)>0;var $29=$y_min;var $cmp23=((($29))|0)<127;var $or_cond1=($cmp21)&($cmp23);if($or_cond1){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $30=$y_min;var $arrayidx25=(($y+8)&4294967295);HEAP32[(($arrayidx25)>>2)]=$30;;}
var $arrayidx27=(($y+8)&4294967295);var $31=HEAP32[(($arrayidx27)>>2)];var $div28=((((($31))|0)/2)|0);var $arrayidx29=(($y+4)&4294967295);HEAP32[(($arrayidx29)>>2)]=$div28;var $arrayidx30=(($y+8)&4294967295);var $32=HEAP32[(($arrayidx30)>>2)];var $arrayidx31=(($y+8)&4294967295);var $33=HEAP32[(($arrayidx31)>>2)];var $sub32=((127-($33))&4294967295);var $div33=((((($sub32))|0)/2)|0);var $add=((($div33)+($32))&4294967295);var $arrayidx34=(($y+12)&4294967295);HEAP32[(($arrayidx34)>>2)]=$add;var $34=$pitch_env;var $arrayidx35=(($34)&4294967295);var $35=HEAPU8[($arrayidx35)];var $conv36=((($35))&255);var $36=HEAP32[(($pitch_range)>>2)];var $mul37=((($conv36)*($36))&4294967295);var $shr=($mul37)>>8;var $37=HEAP32[(($pitch_base)>>2)];var $add38=((($shr)+($37))&4294967295);$p1=$add38;var $38=$pitch_env;var $arrayidx39=(($38+127)&4294967295);var $39=HEAPU8[($arrayidx39)];var $conv40=((($39))&255);var $40=HEAP32[(($pitch_range)>>2)];var $mul41=((($conv40)*($40))&4294967295);var $shr42=($mul41)>>8;var $41=HEAP32[(($pitch_base)>>2)];var $add43=((($shr42)+($41))&4294967295);$p_end=$add43;var $42=$split_addr;var $cmp44=((($42))|0)>=0;if($cmp44){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $arraydecay=(($buf)&4294967295);var $43=$p1;var $div46=((((($43))|0)/4096)|0);var $call=_sprintf($arraydecay,((__str13395)&4294967295),allocate([$div46,0,0,0],["i32",0,0,0],ALLOC_STACK));var $arraydecay47=(($buf)&4294967295);var $call48=_strcat(((__ZZL10WritePitchiiiiiE6output)&4294967295),$arraydecay47);;}
var $44=$env_addr;var $cmp50=((($44))|0)>1;if($cmp50){__label__=15;;}else{__label__=25;;}
$if_then51$$if_end91$23:do{if(__label__==15){$ix=1;var $arraydecay82=(($buf)&4294967295);var $arraydecay85=(($buf)&4294967295);;$for_body54$25:while(1){var $45=$ix;var $arrayidx55=(($y+$45*4)&4294967295);var $46=HEAP32[(($arrayidx55)>>2)];var $47=$pitch_env;var $arrayidx56=(($47+$46)&4294967295);var $48=HEAPU8[($arrayidx56)];var $conv57=((($48))&255);var $49=HEAP32[(($pitch_range)>>2)];var $mul58=((($conv57)*($49))&4294967295);var $shr59=($mul58)>>8;var $50=HEAP32[(($pitch_base)>>2)];var $add60=((($shr59)+($50))&4294967295);$p2=$add60;var $51=$split_addr;var $cmp61=((($51))|0)>0;if($cmp61){__label__=17;;}else{__label__=18;;}
if(__label__==17){var $52=$ix;var $arrayidx63=(($y+$52*4)&4294967295);var $53=HEAP32[(($arrayidx63)>>2)];var $54=$env100;var $mul64=((($54)*($53))&4294967295);var $55=$env_split;var $div65=((((($mul64))|0)/((($55))|0))|0);$y2=$div65;__lastLabel__=17;;}
else if(__label__==18){var $56=$split_addr;var $cmp66=((($56))|0)<0;var $57=$ix;var $arrayidx68=(($y+$57*4)&4294967295);var $58=HEAP32[(($arrayidx68)>>2)];if($cmp66){__label__=19;;}else{__label__=20;;}
if(__label__==19){var $59=$env_split;var $sub69=((($58)-($59))&4294967295);var $60=$env100;var $mul70=((($sub69)*($60))&4294967295);var $61=$env_split;var $div71=((((($mul70))|0)/((($61))|0))|0);$y2=$div71;__lastLabel__=19;;}
else if(__label__==20){var $62=$env100;var $mul74=((($62)*($58))&4294967295);var $div75=((((($mul74))|0)/128)|0);$y2=$div75;__lastLabel__=20;;}}
var $63=__lastLabel__==19?$div71:(__lastLabel__==20?$div75:($div65));var $cmp78=((($63))|0)>0;if($cmp78){__label__=22;;}else{__label__=24;;}
$land_lhs_true79$$for_inc88$34:do{if(__label__==22){var $64=$y2;var $65=$env100;var $cmp80=((($64))|0)<=((($65))|0);if(!($cmp80)){__label__=24;break $land_lhs_true79$$for_inc88$34;}
var $66=$y2;var $67=$p2;var $div83=((((($67))|0)/4096)|0);var $call84=_sprintf($arraydecay82,((__str14396)&4294967295),allocate([$66,0,0,0,$div83,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $call86=_strcat(((__ZZL10WritePitchiiiiiE6output)&4294967295),$arraydecay85);;}}while(0);var $68=$ix;var $inc89=((($68)+1)&4294967295);$ix=$inc89;var $cmp53=((($inc89))|0)<4;if($cmp53){__label__=16;continue $for_body54$25;}else{__label__=25;break $if_then51$$if_end91$23;}}}}while(0);var $69=$p_end;var $div92=((((($69))|0)/4096)|0);$p_end=$div92;var $70=$split_addr;var $cmp93=((($70))|0)<=0;if($cmp93){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $arraydecay95=(($buf)&4294967295);var $71=$env100;var $72=$p_end;var $call96=_sprintf($arraydecay95,((__str14396)&4294967295),allocate([$71,0,0,0,$72,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $arraydecay97=(($buf)&4294967295);var $call98=_strcat(((__ZZL10WritePitchiiiiiE6output)&4294967295),$arraydecay97);;}
var $73=$env100;var $cmp100=((($73))|0)<100;if($cmp100){__label__=28;;}else{__label__=29;;}
if(__label__==28){var $arraydecay102=(($buf)&4294967295);var $74=$p_end;var $call103=_sprintf($arraydecay102,((__str14396)&4294967295),allocate([100,0,0,0,$74,0,0,0],["i32",0,0,0,"i32",0,0,0],ALLOC_STACK));var $arraydecay104=(($buf)&4294967295);var $call105=_strcat(((__ZZL10WritePitchiiiiiE6output)&4294967295),$arraydecay104);;}
var $strlen=_strlen(((__ZZL10WritePitchiiiiiE6output)&4294967295));var $endptr=((((__ZZL10WritePitchiiiiiE6output)&4294967295)+$strlen)&4294967295);var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=((__str15397)&4294967295);$dest$=$endptr;$stop$=$src$+2;if(($dest$%4)==($src$%4)&&2>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $75=$final_addr;var $tobool=((($75))|0)!=0;if($tobool){__label__=30;;}else{__label__=31;;}
if(__label__==30){var $76=$p_end;var $call109=_sprintf(((__ZZL10WritePitchiiiiiE6output)&4294967295),((__str16398)&4294967295),allocate([$76,0,0,0],["i32",0,0,0],ALLOC_STACK));;}
STACKTOP=__stackBase__;return;return;}
function __Z14MbrolaGenerateP12PHONEME_LISTPii($phoneme_list,$n_ph,$resume){;var __label__;var $retval;var $phoneme_list_addr;var $n_ph_addr;var $resume_addr;var $f_mbrola;var $again;$phoneme_list_addr=$phoneme_list;$n_ph_addr=$n_ph;$resume_addr=$resume;$f_mbrola=0;var $0=$n_ph_addr;var $1=HEAP32[(($0)>>2)];var $cmp=((($1))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=0;;}
else if(__label__==2){var $2=HEAP32[((_option_mbrola_phonemes)>>2)];var $tobool=((($2))|0)!=0;if($tobool){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $3=HEAP32[((_f_trans)>>2)];$f_mbrola=$3;;}
var $4=$phoneme_list_addr;var $5=$n_ph_addr;var $6=HEAP32[(($5)>>2)];var $7=$resume_addr;var $8=$f_mbrola;var $call=__Z15MbrolaTranslateP12PHONEME_LISTiiP7__sFILE($4,$6,$7,$8);$again=$call;var $tobool3=((($call))|0)!=0;if($tobool3){__label__=6;;}else{__label__=5;;}
if(__label__==5){var $9=$n_ph_addr;HEAP32[(($9)>>2)]=0;;}
var $10=$again;$retval=$10;;}
var $11=$retval;;return $11;return null;}
function __Z10MbrolaFillii($length,$resume){;var __label__;var $retval;var $length_addr;var $resume_addr;var $req_samples;var $result;$length_addr=$length;$resume_addr=$resume;var $0=$resume_addr;var $tobool=((($0))|0)!=0;if($tobool){__label__=2;;}else{__label__=1;;}
if(__label__==1){var $1=HEAP32[((_samplerate)>>2)];var $2=$length_addr;var $mul=((($2)*($1))&4294967295);var $div=((((($mul))|0)/1000)|0);HEAP32[((__ZZ10MbrolaFilliiE9n_samples)>>2)]=$div;;}
var $3=HEAP32[((_out_end)>>2)];var $4=HEAP32[((_out_ptr)>>2)];var $sub_ptr_lhs_cast=($3);var $sub_ptr_rhs_cast=($4);var $sub_ptr_sub=((($sub_ptr_lhs_cast)-($sub_ptr_rhs_cast))&4294967295);var $div1=((((($sub_ptr_sub))|0)/2)|0);$req_samples=$div1;var $5=$req_samples;var $6=HEAP32[((__ZZ10MbrolaFilliiE9n_samples)>>2)];var $cmp=((($5))|0)>((($6))|0);if($cmp){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $7=HEAP32[((__ZZ10MbrolaFilliiE9n_samples)>>2)];$req_samples=$7;;}
var $8=HEAP32[((_out_ptr)>>2)];var $9=$8;var $10=$9;var $11=$req_samples;var $call=_read_MBR($10,$11);$result=$call;var $cmp4=((($call))|0)<=0;if($cmp4){__label__=5;;}else{__label__=6;;}
if(__label__==5){$retval=0;;}
else if(__label__==6){var $12=$result;var $mul7=((($12)*2)&4294967295);var $13=HEAP32[((_out_ptr)>>2)];var $add_ptr=(($13+$mul7)&4294967295);HEAP32[((_out_ptr)>>2)]=$add_ptr;var $14=$result;var $15=HEAP32[((__ZZ10MbrolaFilliiE9n_samples)>>2)];var $sub=((($15)-($14))&4294967295);HEAP32[((__ZZ10MbrolaFilliiE9n_samples)>>2)]=$sub;var $16=HEAP32[((__ZZ10MbrolaFilliiE9n_samples)>>2)];var $tobool8=((($16))|0)!=0;var $cond=($tobool8)?1:0;$retval=$cond;;}
var $17=$retval;;return $17;return null;}
function __Z11MbrolaResetv(){;var __label__;var $call=_reset_MBR();;return;return;}
function __Z10LoadPhDatav(){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var $retval;var $ix;var $n_phonemes;var $version;var $result;var $length=__stackBase__;var $p;var $pw;$result=1;var $0=HEAP32[((__ZL16phoneme_tab_data)>>2)];var $call=__ZL10ReadPhFilePvPKcPi($0,((__str1412)&4294967295),0);HEAP32[((__ZL16phoneme_tab_data)>>2)]=$call;var $cmp=((($call))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=-1;;}
else if(__label__==2){var $1=HEAP32[((_phoneme_index)>>2)];var $2=$1;var $call1=__ZL10ReadPhFilePvPKcPi($2,((__str2413)&4294967295),0);var $3=$call1;HEAP32[((_phoneme_index)>>2)]=$3;var $cmp2=((($3))|0)==0;if($cmp2){__label__=3;;}else{__label__=4;;}
if(__label__==3){$retval=-1;;}
else if(__label__==4){var $4=HEAP32[((_phondata_ptr)>>2)];var $call5=__ZL10ReadPhFilePvPKcPi($4,((__str3414)&4294967295),0);HEAP32[((_phondata_ptr)>>2)]=$call5;var $cmp6=((($call5))|0)==0;if($cmp6){__label__=5;;}else{__label__=6;;}
if(__label__==5){$retval=-1;;}
else if(__label__==6){var $5=HEAP32[((_tunes)>>2)];var $6=$5;var $call9=__ZL10ReadPhFilePvPKcPi($6,((__str4415)&4294967295),$length);var $7=$call9;HEAP32[((_tunes)>>2)]=$7;var $cmp10=((($7))|0)==0;if($cmp10){__label__=7;;}else{__label__=8;;}
if(__label__==7){$retval=-1;;}
else if(__label__==8){var $8=HEAP32[((_phondata_ptr)>>2)];HEAP32[((_wavefile_data)>>2)]=$8;var $9=HEAPU32[(($length)>>2)];var $div=Math.floor(((($9))>>>0)/68);HEAP32[((_n_tunes)>>2)]=$div;$version=0;$ix=0;;$for_body$14:while(1){var $10=$ix;var $11=HEAP32[((_wavefile_data)>>2)];var $arrayidx=(($11+$10)&4294967295);var $12=HEAPU8[($arrayidx)];var $conv=((($12))&255);var $13=$ix;var $mul=((($13)*8)&4294967295);var $shl=($conv)<<($mul);var $14=$version;var $add=((($shl)+($14))&4294967295);$version=$add;var $15=$ix;var $inc=((($15)+1)&4294967295);$ix=$inc;var $cmp13=((($inc))|0)<4;if($cmp13){__label__=9;continue $for_body$14;}else{__label__=10;break $for_body$14;}}
var $16=$version;var $cmp14=((($16))|0)!=83200;if($cmp14){__label__=11;;}else{__label__=12;;}
if(__label__==11){var $17=$version;$result=$17;;}
var $18=HEAP32[((__ZL16phoneme_tab_data)>>2)];$p=$18;var $19=$p;var $arrayidx17=(($19)&4294967295);var $20=HEAPU8[($arrayidx17)];var $conv18=((($20))&255);HEAP32[((_n_phoneme_tables)>>2)]=$conv18;var $21=$p;var $add_ptr=(($21+4)&4294967295);$p=$add_ptr;$ix=0;var $22=$ix;var $23=HEAP32[((_n_phoneme_tables)>>2)];var $cmp201=((($22))|0)<((($23))|0);if($cmp201){__label__=13;;}else{__label__=14;;}
$for_body21$$for_end42$20:do{if(__label__==13){while(1){var $24=$p;var $arrayidx22=(($24)&4294967295);var $25=HEAPU8[($arrayidx22)];var $conv23=((($25))&255);$n_phonemes=$conv23;var $26=$p;var $arrayidx24=(($26)&4294967295);var $27=HEAPU8[($arrayidx24)];var $conv25=((($27))&255);var $28=$ix;var $arrayidx26=((_phoneme_tab_list+$28*48)&4294967295);var $n_phonemes27=(($arrayidx26+36)&4294967295);HEAP32[(($n_phonemes27)>>2)]=$conv25;var $29=$p;var $arrayidx28=(($29+1)&4294967295);var $30=HEAPU8[($arrayidx28)];var $conv29=((($30))&255);var $31=$ix;var $arrayidx30=((_phoneme_tab_list+$31*48)&4294967295);var $includes=(($arrayidx30+40)&4294967295);HEAP32[(($includes)>>2)]=$conv29;var $32=$p;var $33=$32;$pw=$33;var $34=$pw;var $arrayidx31=(($34+4)&4294967295);var $35=HEAP32[(($arrayidx31)>>2)];var $call32=__Z13Reverse4Bytesi($35);var $36=$ix;var $arrayidx33=((_phoneme_tab_list+$36*48)&4294967295);var $equivalence_tables=(($arrayidx33+44)&4294967295);HEAP32[(($equivalence_tables)>>2)]=$call32;var $37=$p;var $add_ptr34=(($37+8)&4294967295);$p=$add_ptr34;var $38=$ix;var $arrayidx35=((_phoneme_tab_list+$38*48)&4294967295);var $name=(($arrayidx35)&4294967295);var $arraydecay=(($name)&4294967295);var $39=$p;var $src$,$dest$,$stop$,$stop4$,$fast$;$src$=$39;$dest$=$arraydecay;$stop$=$src$+32;if(($dest$%4)==($src$%4)&&32>8){while($src$%4!==0&&$src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];}
$src$>>=2;$dest$>>=2;$stop4$=$stop$>>2;while($src$<$stop4$){;;;HEAP32[$dest$++]=HEAP32[$src$++];}
$src$<<=2;$dest$<<=2;}while($src$<$stop$){;HEAP8[$dest$++]=HEAP8[$src$++];};var $40=$p;var $add_ptr36=(($40+32)&4294967295);$p=$add_ptr36;var $41=$p;var $42=$41;var $43=$ix;var $arrayidx37=((_phoneme_tab_list+$43*48)&4294967295);var $phoneme_tab_ptr=(($arrayidx37+32)&4294967295);HEAP32[(($phoneme_tab_ptr)>>2)]=$42;var $44=$n_phonemes;var $mul38=((($44)*16)&4294967295);var $45=$p;var $add_ptr39=(($45+$mul38)&4294967295);$p=$add_ptr39;var $46=$ix;var $inc41=((($46)+1)&4294967295);$ix=$inc41;var $47=$ix;var $48=HEAP32[((_n_phoneme_tables)>>2)];var $cmp20=((($47))|0)<((($48))|0);if($cmp20){__label__=13;continue;}else{__label__=14;break $for_body21$$for_end42$20;}}}}while(0);var $49=HEAP32[((_phoneme_tab_number)>>2)];var $50=HEAP32[((_n_phoneme_tables)>>2)];var $cmp43=((($49))|0)>=((($50))|0);if($cmp43){__label__=15;;}else{__label__=16;;}
if(__label__==15){HEAP32[((_phoneme_tab_number)>>2)]=0;;}
var $51=$result;$retval=$51;;}}}}
var $52=$retval;STACKTOP=__stackBase__;return $52;return null;}
function __ZL10ReadPhFilePvPKcPi($ptr,$fname,$size){var __stackBase__=STACKTOP;STACKTOP+=192;_memset(__stackBase__,0,192);var __label__;var $retval;var $ptr_addr;var $fname_addr;var $size_addr;var $f_in;var $p;var $length;var $buf=__stackBase__;$ptr_addr=$ptr;$fname_addr=$fname;$size_addr=$size;var $arraydecay=(($buf)&4294967295);var $0=$fname_addr;var $call=_sprintf($arraydecay,((__str74726)&4294967295),allocate([((_path_home)&4294967295),0,0,0,47,0,0,0,$0,0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay1=(($buf)&4294967295);var $call2=__Z13GetFileLengthPKc($arraydecay1);$length=$call2;var $arraydecay3=(($buf)&4294967295);var $call4=_fopen($arraydecay3,((__str18429)&4294967295));$f_in=$call4;var $cmp=((($call4))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($1+12)&4294967295);var $2=HEAP32[(($_stderr)>>2)];var $arraydecay5=(($buf)&4294967295);var $call6=_fprintf($2,((__str19430)&4294967295),allocate([$arraydecay5,0,0,0],["i8*",0,0,0],ALLOC_STACK));$retval=0;;}
else if(__label__==2){var $3=$ptr_addr;var $cmp7=((($3))|0)!=0;if($cmp7){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $4=$ptr_addr;__Z4FreePv($4);;}
var $5=$length;var $call10=__Z5Alloci($5);$p=$call10;var $cmp11=((($call10))|0)==0;if($cmp11){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $6=$f_in;var $call13=_fclose($6);$retval=0;;}
else if(__label__==6){var $7=$p;var $8=$length;var $9=$f_in;var $call15=_fread($7,1,$8,$9);var $10=$length;var $cmp16=((($call15))|0)!=((($10))|0);var $11=$f_in;var $call18=_fclose($11);if($cmp16){__label__=7;;}else{__label__=8;;}
if(__label__==7){$retval=0;;}
else if(__label__==8){var $12=$size_addr;var $cmp21=((($12))|0)!=0;if($cmp21){__label__=9;;}else{__label__=10;;}
if(__label__==9){var $13=$length;var $14=$size_addr;HEAP32[(($14)>>2)]=$13;;}
var $15=$p;$retval=$15;;}}}
var $16=$retval;STACKTOP=__stackBase__;return $16;return null;}
function __Z10FreePhDatav(){;var __label__;var $0=HEAP32[((__ZL16phoneme_tab_data)>>2)];__Z4FreePv($0);var $1=HEAP32[((_phoneme_index)>>2)];var $2=$1;__Z4FreePv($2);var $3=HEAP32[((_phondata_ptr)>>2)];__Z4FreePv($3);HEAP32[((__ZL16phoneme_tab_data)>>2)]=0;HEAP32[((_phoneme_index)>>2)]=0;HEAP32[((_phondata_ptr)>>2)]=0;;return;return;}
function __Z11PhonemeCodej($mnem){;var __label__;var $retval;var $mnem_addr;var $ix;$mnem_addr=$mnem;$ix=0;;while(1){var $0=$ix;var $1=HEAP32[((_n_phoneme_tab)>>2)];var $cmp=((($0))|0)<((($1))|0);if(!($cmp)){__label__=6;break;}
var $2=$ix;var $arrayidx=((_phoneme_tab+$2*4)&4294967295);var $3=HEAP32[(($arrayidx)>>2)];var $cmp1=((($3))|0)==0;if($cmp1){__label__=5;;}else{__label__=3;;}
if(__label__==3){var $4=$ix;var $arrayidx2=((_phoneme_tab+$4*4)&4294967295);var $5=HEAP32[(($arrayidx2)>>2)];var $mnemonic=(($5)&4294967295);var $6=HEAP32[(($mnemonic)>>2)];var $7=$mnem_addr;var $cmp3=((($6))|0)==((($7))|0);if($cmp3){__label__=4;break;}}
var $11=$ix;var $inc=((($11)+1)&4294967295);$ix=$inc;__label__=1;continue;}
if(__label__==6){$retval=0;;}
else if(__label__==4){var $8=$ix;var $arrayidx5=((_phoneme_tab+$8*4)&4294967295);var $9=HEAP32[(($arrayidx5)>>2)];var $code=(($9+10)&4294967295);var $10=HEAPU8[($code)];var $conv=((($10))&255);$retval=$conv;;}
var $12=$retval;;return $12;return null;}
function __Z19LookupPhonemeStringPKc($string){;var __label__;var __lastLabel__=null;var $string_addr;var $ix;var $c;var $mnem;$string_addr=$string;$mnem=0;$ix=0;__lastLabel__=0;;while(1){var $0=__lastLabel__==3?$inc:(0);var $cmp=((($0))|0)<4;if(!($cmp)){__label__=4;break;}
var $1=$ix;var $2=$string_addr;var $arrayidx=(($2+$1)&4294967295);var $3=HEAP8[($arrayidx)];var $conv=(tempInt=(($3)),(tempInt>=128?tempInt-256:tempInt));var $cmp1=((($conv))|0)==0;if($cmp1){__label__=4;break;}
var $4=$ix;var $5=$string_addr;var $arrayidx2=(($5+$4)&4294967295);var $6=HEAP8[($arrayidx2)];$c=$6;var $7=$c;var $conv3=((($7))&255);var $8=$ix;var $mul=((($8)*8)&4294967295);var $shl=($conv3)<<($mul);var $9=$mnem;var $or=($shl)|($9);$mnem=$or;var $10=$ix;var $inc=((($10)+1)&4294967295);$ix=$inc;__lastLabel__=3;__label__=1;continue;}
var $11=$mnem;var $call=__Z11PhonemeCodej($11);;return $call;return null;}
function __Z11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LIST($this_ph,$which,$fmt_params,$n_frames,$plist){var __stackBase__=STACKTOP;STACKTOP+=4;_memset(__stackBase__,0,4);var __label__;var __lastLabel__=null;var $this_ph_addr;var $which_addr;var $fmt_params_addr;var $n_frames_addr;var $plist_addr;var $ix;var $nf=__stackBase__;var $nf1;var $seq_break;var $frames;var $length1;var $length_std;var $length_factor;var $seq;var $seq2;var $seqk;var $seqk2;var $frame;$this_ph_addr=$this_ph;$which_addr=$which;$fmt_params_addr=$fmt_params;$n_frames_addr=$n_frames;$plist_addr=$plist;var $0=$fmt_params_addr;var $fmt_addr=(($0+8)&4294967295);var $1=HEAP32[(($fmt_addr)>>2)];var $2=HEAP32[((_phondata_ptr)>>2)];var $arrayidx=(($2+$1)&4294967295);var $3=$arrayidx;$seq=$3;var $4=$seq;var $5=$4;$seqk=$5;var $6=$seq;var $n_frames1=(($6+2)&4294967295);var $7=HEAPU8[($n_frames1)];var $conv=((($7))&255);HEAP32[(($nf)>>2)]=$conv;var $8=HEAP32[(($nf)>>2)];var $cmp=((($8))|0)>=25;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){HEAP32[(($nf)>>2)]=24;;}
var $9=$fmt_params_addr;var $fmt2_lenadj=(($9+24)&4294967295);var $10=HEAP32[(($fmt2_lenadj)>>2)];var $11=$fmt_params_addr;var $fmt_length=(($11+12)&4294967295);var $12=HEAP32[(($fmt_length)>>2)];var $add=((($12)+($10))&4294967295);HEAP32[((_seq_len_adjust)>>2)]=$add;$seq_break=0;$ix=0;var $13=$ix;var $14=HEAP32[(($nf)>>2)];var $cmp29=((($13))|0)<((($14))|0);if($cmp29){__label__=4;;}else{__label__=3;;}
$for_body$$for_end_thread$5:do{if(__label__==4){while(1){var $15=$seq;var $frame3=(($15+4)&4294967295);var $arrayidx4=(($frame3)&4294967295);var $frflags=(($arrayidx4)&4294967295);var $16=HEAP16[(($frflags)>>1)];var $conv5=(tempInt=(($16)),(tempInt>=32768?tempInt-65536:tempInt));var $and=($conv5)&1;var $tobool=((($and))|0)!=0;var $17=$ix;if($tobool){__label__=5;;}else{__label__=6;;}
if(__label__==5){var $18=$seqk;var $frame7=(($18+4)&4294967295);var $arrayidx8=(($frame7+$17*64)&4294967295);$frame=$arrayidx8;;}
else if(__label__==6){var $19=$seq;var $frame9=(($19+4)&4294967295);var $arrayidx10=(($frame9+$17*44)&4294967295);var $20=$arrayidx10;$frame=$20;;}
var $21=$frame;var $22=$ix;var $arrayidx12=((__ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf+$22*8)&4294967295);var $frame13=(($arrayidx12+4)&4294967295);HEAP32[(($frame13)>>2)]=$21;var $23=$frame;var $frflags14=(($23)&4294967295);var $24=HEAP16[(($frflags14)>>1)];var $25=$ix;var $arrayidx15=((__ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf+$25*8)&4294967295);var $frflags16=(($arrayidx15+2)&4294967295);HEAP16[(($frflags16)>>1)]=$24;var $26=$frame;var $length=(($26+16)&4294967295);var $27=HEAPU8[($length)];var $conv17=((($27))&255);var $28=$ix;var $arrayidx18=((__ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf+$28*8)&4294967295);var $length19=(($arrayidx18)&4294967295);HEAP16[(($length19)>>1)]=$conv17;var $29=$frame;var $frflags20=(($29)&4294967295);var $30=HEAP16[(($frflags20)>>1)];var $conv21=(tempInt=(($30)),(tempInt>=32768?tempInt-65536:tempInt));var $and22=($conv21)&2;var $tobool23=((($and22))|0)!=0;if($tobool23){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $31=$ix;$seq_break=$31;;}
var $32=$ix;var $inc=((($32)+1)&4294967295);$ix=$inc;var $33=$ix;var $34=HEAP32[(($nf)>>2)];var $cmp2=((($33))|0)<((($34))|0);if($cmp2){__label__=4;continue;}else{__label__=10;break;}}
var $_pr10=$seq_break;$frames=((__ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf)&4294967295);var $cmp26=((($_pr10))|0)>0;if(!($cmp26)){__label__=14;break $for_body$$for_end_thread$5;}
var $35=$which_addr;var $cmp28=((($35))|0)==1;var $36=$seq_break;if($cmp28){__label__=12;;}else{__label__=13;;}
if(__label__==12){var $add30=((($36)+1)&4294967295);HEAP32[(($nf)>>2)]=$add30;;}
else if(__label__==13){var $arrayidx32=((__ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf+$36*8)&4294967295);$frames=$arrayidx32;var $37=$seq_break;var $38=HEAP32[(($nf)>>2)];var $sub=((($38)-($37))&4294967295);HEAP32[(($nf)>>2)]=$sub;;}}
else if(__label__==3){$frames=((__ZZ11LookupSpectP11PHONEME_TABiP10FMT_PARAMSPiP12PHONEME_LISTE10frames_buf)&4294967295);;}}while(0);var $39=$this_ph_addr;var $type=(($39+11)&4294967295);var $40=HEAPU8[($type)];var $conv35=((($40))&255);var $cmp36=((($conv35))|0)==2;if($cmp36){__label__=15;;}else{__label__=18;;}
$land_lhs_true$$if_end42$22:do{if(__label__==15){var $41=$fmt_params_addr;var $fmt2_addr=(($41+20)&4294967295);var $42=HEAP32[(($fmt2_addr)>>2)];var $cmp37=((($42))|0)==0;if(!($cmp37)){__label__=18;break $land_lhs_true$$if_end42$22;}
var $43=$fmt_params_addr;var $use_vowelin=(($43+4)&4294967295);var $44=HEAP32[(($use_vowelin)>>2)];var $tobool39=((($44))|0)!=0;if(!($tobool39)){__label__=18;break $land_lhs_true$$if_end42$22;}
var $45=$frames;var $46=$fmt_params_addr;var $transition0=(($46+36)&4294967295);var $47=HEAP32[(($transition0)>>2)];var $48=$fmt_params_addr;var $transition1=(($48+40)&4294967295);var $49=HEAP32[(($transition1)>>2)];var $50=$which_addr;var $call=__Z18FormantTransition2P10frameref_tRijjP11PHONEME_TABi($45,$nf,$47,$49,0,$50);var $51=HEAP32[((_seq_len_adjust)>>2)];var $add41=((($51)+($call))&4294967295);HEAP32[((_seq_len_adjust)>>2)]=$add41;;}}while(0);$length1=0;var $52=HEAP32[(($nf)>>2)];var $sub43=((($52)-1)&4294967295);$nf1=$sub43;$ix=0;var $53=$ix;var $54=$nf1;var $cmp457=((($53))|0)<((($54))|0);if($cmp457){__label__=19;;}else{__label__=20;;}
$for_body46$$for_end53$27:do{if(__label__==19){while(1){var $55=$ix;var $56=$frames;var $arrayidx47=(($56+8*$55)&4294967295);var $length48=(($arrayidx47)&4294967295);var $57=HEAP16[(($length48)>>1)];var $conv49=(tempInt=(($57)),(tempInt>=32768?tempInt-65536:tempInt));var $58=$length1;var $add50=((($58)+($conv49))&4294967295);$length1=$add50;var $59=$ix;var $inc52=((($59)+1)&4294967295);$ix=$inc52;var $60=$ix;var $61=$nf1;var $cmp45=((($60))|0)<((($61))|0);if($cmp45){__label__=19;continue;}else{__label__=20;break $for_body46$$for_end53$27;}}}}while(0);var $62=$fmt_params_addr;var $fmt2_addr54=(($62+20)&4294967295);var $63=HEAP32[(($fmt2_addr54)>>2)];var $cmp55=((($63))|0)!=0;if($cmp55){__label__=21;;}else{__label__=29;;}
if(__label__==21){var $64=$fmt_params_addr;var $fmt2_addr57=(($64+20)&4294967295);var $65=HEAP32[(($fmt2_addr57)>>2)];var $66=HEAP32[((_phondata_ptr)>>2)];var $arrayidx58=(($66+$65)&4294967295);var $67=$arrayidx58;$seq2=$67;var $68=$seq2;var $69=$68;$seqk2=$69;var $70=HEAP32[(($nf)>>2)];var $dec=((($70)-1)&4294967295);HEAP32[(($nf)>>2)]=$dec;$ix=0;var $71=$ix;var $72=$seq2;var $n_frames604=(($72+2)&4294967295);var $73=HEAPU8[($n_frames604)];var $conv615=((($73))&255);var $cmp626=((($71))|0)<((($conv615))|0);if($cmp626){__label__=22;;}else{__label__=28;;}
$for_body63$$for_end92$33:do{if(__label__==22){while(1){var $74=$seq2;var $frame64=(($74+4)&4294967295);var $arrayidx65=(($frame64)&4294967295);var $frflags66=(($arrayidx65)&4294967295);var $75=HEAP16[(($frflags66)>>1)];var $conv67=(tempInt=(($75)),(tempInt>=32768?tempInt-65536:tempInt));var $and68=($conv67)&1;var $tobool69=((($and68))|0)!=0;var $76=$ix;if($tobool69){__label__=23;;}else{__label__=24;;}
if(__label__==23){var $77=$seqk2;var $frame71=(($77+4)&4294967295);var $arrayidx72=(($frame71+$76*64)&4294967295);$frame=$arrayidx72;;}
else if(__label__==24){var $78=$seq2;var $frame74=(($78+4)&4294967295);var $arrayidx75=(($frame74+$76*44)&4294967295);var $79=$arrayidx75;$frame=$79;;}
var $80=$frame;var $length77=(($80+16)&4294967295);var $81=HEAPU8[($length77)];var $conv78=((($81))&255);var $82=HEAP32[(($nf)>>2)];var $83=$frames;var $arrayidx79=(($83+8*$82)&4294967295);var $length80=(($arrayidx79)&4294967295);HEAP16[(($length80)>>1)]=$conv78;var $84=$ix;var $cmp81=((($84))|0)>0;if($cmp81){__label__=26;;}else{__label__=27;;}
if(__label__==26){var $85=$frame;var $86=HEAP32[(($nf)>>2)];var $87=$frames;var $arrayidx83=(($87+8*$86)&4294967295);var $frame84=(($arrayidx83+4)&4294967295);HEAP32[(($frame84)>>2)]=$85;var $88=$frame;var $frflags85=(($88)&4294967295);var $89=HEAP16[(($frflags85)>>1)];var $90=HEAP32[(($nf)>>2)];var $91=$frames;var $arrayidx86=(($91+8*$90)&4294967295);var $frflags87=(($arrayidx86+2)&4294967295);HEAP16[(($frflags87)>>1)]=$89;;}
var $92=HEAP32[(($nf)>>2)];var $inc89=((($92)+1)&4294967295);HEAP32[(($nf)>>2)]=$inc89;var $93=$ix;var $inc91=((($93)+1)&4294967295);$ix=$inc91;var $94=$ix;var $95=$seq2;var $n_frames60=(($95+2)&4294967295);var $96=HEAPU8[($n_frames60)];var $conv61=((($96))&255);var $cmp62=((($94))|0)<((($conv61))|0);if($cmp62){__label__=22;continue;}else{__label__=28;break $for_body63$$for_end92$33;}}}}while(0);HEAP32[((_wavefile_ix)>>2)]=0;;}
var $97=$length1;var $cmp94=((($97))|0)>0;if($cmp94){__label__=30;;}else{__label__=47;;}
$if_then95$$if_end175$45:do{if(__label__==30){var $98=$which_addr;var $cmp96=((($98))|0)==2;if($cmp96){__label__=31;;}else{__label__=37;;}
if(__label__==31){var $99=$fmt_params_addr;var $std_length=(($99+44)&4294967295);var $100=HEAP32[(($std_length)>>2)];var $101=HEAP32[((_seq_len_adjust)>>2)];var $add98=((($100)-45)&4294967295);var $sub99=((($add98)+($101))&4294967295);$length_std=$sub99;var $102=$length_std;var $cmp100=((($102))|0)<10;if($cmp100){__label__=32;;}else{__label__=33;;}
if(__label__==32){$length_std=10;;}
var $103=$plist_addr;var $synthflags=(($103+4)&4294967295);var $104=HEAPU16[(($synthflags)>>1)];var $conv103=((($104))&65535);var $and104=($conv103)&8;var $tobool105=((($and104))|0)!=0;if($tobool105){__label__=34;;}else{__label__=35;;}
if(__label__==34){var $105=HEAP32[((((_phoneme_tab+48)&4294967295))>>2)];var $std_length107=(($105+14)&4294967295);var $106=HEAPU8[($std_length107)];var $conv108=((($106))&255);var $mul=((($conv108)*2)&4294967295);var $107=$length_std;var $add109=((($mul)+($107))&4294967295);$length_std=$add109;;}
var $108=$length_std;var $mul111=((($108)*256)&4294967295);var $109=$length1;var $div=((((($mul111))|0)/((($109))|0))|0);$length_factor=$div;$ix=0;var $110=$ix;var $111=$nf1;var $cmp1133=((($110))|0)<((($111))|0);if(!($cmp1133)){__label__=47;break $if_then95$$if_end175$45;}
while(1){var $112=$ix;var $113=$frames;var $arrayidx115=(($113+8*$112)&4294967295);var $length116=(($arrayidx115)&4294967295);var $114=HEAP16[(($length116)>>1)];var $conv117=(tempInt=(($114)),(tempInt>=32768?tempInt-65536:tempInt));var $115=$length_factor;var $mul118=((($conv117)*($115))&4294967295);var $div119=((((($mul118))|0)/256)|0);var $conv120=((($div119))&65535);var $116=$ix;var $117=$frames;var $arrayidx121=(($117+8*$116)&4294967295);var $length122=(($arrayidx121)&4294967295);HEAP16[(($length122)>>1)]=$conv120;var $118=$ix;var $inc124=((($118)+1)&4294967295);$ix=$inc124;var $119=$ix;var $120=$nf1;var $cmp113=((($119))|0)<((($120))|0);if($cmp113){__label__=36;continue;}else{__label__=47;break $if_then95$$if_end175$45;}}}
else if(__label__==37){var $121=$which_addr;var $cmp127=((($121))|0)==1;var $122=$fmt_params_addr;if($cmp127){__label__=38;;}else{__label__=41;;}
$if_then128$$if_else145$58:do{if(__label__==38){var $fmt_control=(($122)&4294967295);var $123=HEAP32[(($fmt_control)>>2)];var $cmp129=((($123))|0)==1;if(!($cmp129)){__label__=43;break $if_then128$$if_else145$58;}
var $124=$fmt_params_addr;var $std_length131=(($124+44)&4294967295);var $125=HEAP32[(($std_length131)>>2)];var $cmp132=((($125))|0)<130;if(!($cmp132)){__label__=43;break $if_then128$$if_else145$58;}
var $126=$frames;var $arrayidx134=(($126)&4294967295);var $length135=(($arrayidx134)&4294967295);var $127=HEAP16[(($length135)>>1)];var $conv136=(tempInt=(($127)),(tempInt>=32768?tempInt-65536:tempInt));var $128=$fmt_params_addr;var $std_length137=(($128+44)&4294967295);var $129=HEAP32[(($std_length137)>>2)];var $mul138=((($129)*($conv136))&4294967295);var $div139=((((($mul138))|0)/130)|0);var $conv140=((($div139))&65535);var $130=$frames;var $arrayidx141=(($130)&4294967295);var $length142=(($arrayidx141)&4294967295);HEAP16[(($length142)>>1)]=$conv140;__label__=43;break $if_then128$$if_else145$58;}
else if(__label__==41){var $std_length146=(($122+44)&4294967295);var $131=HEAP32[(($std_length146)>>2)];var $cmp147=((($131))|0)>0;if(!($cmp147)){__label__=43;break $if_then128$$if_else145$58;}
var $132=$fmt_params_addr;var $std_length149=(($132+44)&4294967295);var $133=HEAP32[(($std_length149)>>2)];var $134=$length1;var $sub150=((($133)-($134))&4294967295);var $135=HEAP32[((_seq_len_adjust)>>2)];var $add151=((($135)+($sub150))&4294967295);HEAP32[((_seq_len_adjust)>>2)]=$add151;__lastLabel__=42;__label__=44;break $if_then128$$if_else145$58;}}while(0);if(__label__==43){var $_pr=HEAP32[((_seq_len_adjust)>>2)];__lastLabel__=43;;}
var $136=__lastLabel__==43?$_pr:($add151);var $cmp154=((($136))|0)!=0;if(!($cmp154)){__label__=47;break $if_then95$$if_end175$45;}
var $137=$length1;var $138=HEAP32[((_seq_len_adjust)>>2)];var $add156=((($138)+($137))&4294967295);var $mul157=((($add156)*256)&4294967295);var $139=$length1;var $div158=((((($mul157))|0)/((($139))|0))|0);$length_factor=$div158;$ix=0;var $140=$ix;var $141=$nf1;var $cmp1601=((($140))|0)<((($141))|0);if(!($cmp1601)){__label__=47;break $if_then95$$if_end175$45;}
while(1){var $142=$ix;var $143=$frames;var $arrayidx162=(($143+8*$142)&4294967295);var $length163=(($arrayidx162)&4294967295);var $144=HEAP16[(($length163)>>1)];var $conv164=(tempInt=(($144)),(tempInt>=32768?tempInt-65536:tempInt));var $145=$length_factor;var $mul165=((($conv164)*($145))&4294967295);var $div166=((((($mul165))|0)/256)|0);var $conv167=((($div166))&65535);var $146=$ix;var $147=$frames;var $arrayidx168=(($147+8*$146)&4294967295);var $length169=(($arrayidx168)&4294967295);HEAP16[(($length169)>>1)]=$conv167;var $148=$ix;var $inc171=((($148)+1)&4294967295);$ix=$inc171;var $149=$ix;var $150=$nf1;var $cmp160=((($149))|0)<((($150))|0);if($cmp160){__label__=46;continue;}else{__label__=47;break $if_then95$$if_end175$45;}}}}}while(0);var $151=HEAP32[(($nf)>>2)];var $152=$n_frames_addr;HEAP32[(($152)>>2)]=$151;var $153=$frames;STACKTOP=__stackBase__;return $153;return null;}
function __Z11GetEnvelopei($index){;var __label__;var $retval;var $index_addr;$index_addr=$index;var $0=$index_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $1=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($1+12)&4294967295);var $2=HEAP32[(($_stderr)>>2)];var $3=_fwrite(((__str5416)&4294967295),20,1,$2);var $4=HEAP32[((((_envelope_data)&4294967295))>>2)];$retval=$4;;}
else if(__label__==2){var $5=$index_addr;var $6=HEAP32[((_phondata_ptr)>>2)];var $arrayidx=(($6+$5)&4294967295);$retval=$arrayidx;;}
var $7=$retval;;return $7;return null;}
function __Z18SelectPhonemeTablei($number){;var __label__;var $number_addr;$number_addr=$number;HEAP32[((_n_phoneme_tab)>>2)]=0;var $0=$number_addr;__ZL17SetUpPhonemeTableii($0,0);var $1=HEAP32[((_n_phoneme_tab)>>2)];var $inc=((($1)+1)&4294967295);HEAP32[((_n_phoneme_tab)>>2)]=$inc;var $2=$number_addr;HEAP32[((_current_phoneme_table)>>2)]=$2;;return;return;}
function __ZL17SetUpPhonemeTableii($number,$recursing){;var __label__;var $number_addr;var $recursing_addr;var $ix;var $includes;var $ph_code;var $phtab;$number_addr=$number;$recursing_addr=$recursing;var $0=$recursing_addr;var $cmp=((($0))|0)==0;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=((_phoneme_tab_flags)&4294967295);$stop$=$dest$+256;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};;}
var $1=$number_addr;var $arrayidx=((_phoneme_tab_list+$1*48)&4294967295);var $includes1=(($arrayidx+40)&4294967295);var $2=HEAP32[(($includes1)>>2)];$includes=$2;var $cmp2=((($2))|0)>0;if($cmp2){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $3=$includes;var $sub=((($3)-1)&4294967295);__ZL17SetUpPhonemeTableii($sub,1);;}
var $4=$number_addr;var $arrayidx5=((_phoneme_tab_list+$4*48)&4294967295);var $phoneme_tab_ptr=(($arrayidx5+32)&4294967295);var $5=HEAP32[(($phoneme_tab_ptr)>>2)];$phtab=$5;$ix=0;var $6=$ix;var $7=$number_addr;var $arrayidx61=((_phoneme_tab_list+$7*48)&4294967295);var $n_phonemes2=(($arrayidx61+36)&4294967295);var $8=HEAP32[(($n_phonemes2)>>2)];var $cmp73=((($6))|0)<((($8))|0);if($cmp73){__label__=5;;}else{__label__=10;;}
$for_body$$for_end$8:do{if(__label__==5){while(1){var $9=$ix;var $10=$phtab;var $arrayidx8=(($10+16*$9)&4294967295);var $code=(($arrayidx8+10)&4294967295);var $11=HEAPU8[($code)];var $conv=((($11))&255);$ph_code=$conv;var $12=$ix;var $13=$phtab;var $arrayidx9=(($13+16*$12)&4294967295);var $14=$ph_code;var $arrayidx10=((_phoneme_tab+$14*4)&4294967295);HEAP32[(($arrayidx10)>>2)]=$arrayidx9;var $15=$ph_code;var $16=HEAP32[((_n_phoneme_tab)>>2)];var $cmp11=((($15))|0)>((($16))|0);if($cmp11){__label__=6;;}else{__label__=7;;}
if(__label__==6){var $17=$ph_code;HEAP32[((_n_phoneme_tab)>>2)]=$17;;}
var $18=$recursing_addr;var $cmp14=((($18))|0)==0;if($cmp14){__label__=8;;}else{__label__=9;;}
if(__label__==8){var $19=$ph_code;var $arrayidx16=((_phoneme_tab_flags+$19)&4294967295);var $20=HEAPU8[($arrayidx16)];var $conv17=((($20))&255);var $or=($conv17)|1;var $conv18=((($or))&255);HEAP8[($arrayidx16)]=$conv18;;}
var $21=$ix;var $inc=((($21)+1)&4294967295);$ix=$inc;var $22=$ix;var $23=$number_addr;var $arrayidx6=((_phoneme_tab_list+$23*48)&4294967295);var $n_phonemes=(($arrayidx6+36)&4294967295);var $24=HEAP32[(($n_phonemes)>>2)];var $cmp7=((($22))|0)<((($24))|0);if($cmp7){__label__=5;continue;}else{__label__=10;break $for_body$$for_end$8;}}}}while(0);;return;return;}
function __Z18LookupPhonemeTablePKc($name){;var __label__;var $retval;var $name_addr;var $ix;$name_addr=$name;$ix=0;;while(1){var $0=$ix;var $1=HEAP32[((_n_phoneme_tables)>>2)];var $cmp=((($0))|0)<((($1))|0);if(!($cmp)){__label__=5;break;}
var $2=$name_addr;var $3=$ix;var $arrayidx=((_phoneme_tab_list+$3*48)&4294967295);var $name1=(($arrayidx)&4294967295);var $arraydecay=(($name1)&4294967295);var $call=_strcmp($2,$arraydecay);var $cmp2=((($call))|0)==0;var $4=$ix;if($cmp2){__label__=3;break;}
var $inc=((($4)+1)&4294967295);$ix=$inc;__label__=1;continue;}
if(__label__==3){HEAP32[((_phoneme_tab_number)>>2)]=$4;;}
var $5=$ix;var $6=HEAP32[((_n_phoneme_tables)>>2)];var $cmp3=((($5))|0)==((($6))|0);if($cmp3){__label__=6;;}else{__label__=7;;}
if(__label__==6){$retval=-1;;}
else if(__label__==7){var $7=$ix;$retval=$7;;}
var $8=$retval;;return $8;return null;}
function __Z22SelectPhonemeTableNamePKc($name){;var __label__;var $retval;var $name_addr;var $ix;$name_addr=$name;var $0=$name_addr;var $call=__Z18LookupPhonemeTablePKc($0);$ix=$call;var $cmp=((($call))|0)==-1;if($cmp){__label__=1;;}else{__label__=2;;}
if(__label__==1){$retval=-1;;}
else if(__label__==2){var $1=$ix;__Z18SelectPhonemeTablei($1);var $2=$ix;$retval=$2;;}
var $3=$retval;;return $3;return null;}
function __Z10LoadConfigv(){var __stackBase__=STACKTOP;STACKTOP+=364;_memset(__stackBase__,0,364);var __label__;var $buf=__stackBase__;var $f;var $ix;var $c1=__stackBase__+160;var $p;var $string=__stackBase__+164;HEAP32[((_logging_type)>>2)]=0;$ix=0;;$for_body$2:while(1){var $0=$ix;var $arrayidx=((_soundicon_tab+$0*16)&4294967295);var $filename=(($arrayidx+12)&4294967295);HEAP32[(($filename)>>2)]=0;var $1=$ix;var $arrayidx1=((_soundicon_tab+$1*16)&4294967295);var $data=(($arrayidx1+8)&4294967295);HEAP32[(($data)>>2)]=0;var $2=$ix;var $inc=((($2)+1)&4294967295);$ix=$inc;var $cmp=((($inc))|0)<4;if($cmp){__label__=1;continue $for_body$2;}else{__label__=2;break $for_body$2;}}
var $arraydecay=(($buf)&4294967295);var $call=_sprintf($arraydecay,((__str74726)&4294967295),allocate([((_path_home)&4294967295),0,0,0,47,0,0,0,((__str7418)&4294967295),0,0,0],["i8*",0,0,0,"i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $arraydecay2=(($buf)&4294967295);var $call3=_fopen($arraydecay2,((__str51703)&4294967295));$f=$call3;var $cmp4=((($call3))|0)==0;if($cmp4){__label__=17;;}else{__label__=3;;}
$while_end$$while_cond_preheader$5:do{if(__label__==3){var $arraydecay5=(($buf)&4294967295);var $3=$f;var $call61=_fgets($arraydecay5,160,$3);var $cmp72=((($call61))|0)!=0;if(!($cmp72)){__label__=17;break $while_end$$while_cond_preheader$5;}
var $arrayidx8=(($buf)&4294967295);var $arraydecay12=(($buf)&4294967295);var $arrayidx16=(($buf+4)&4294967295);var $arraydecay17=(($string)&4294967295);var $arraydecay21=(($string)&4294967295);var $arraydecay24=(($buf)&4294967295);var $arrayidx28=(($buf+5)&4294967295);var $arraydecay30=(($buf)&4294967295);var $arrayidx34=(($buf+10)&4294967295);var $arraydecay37=(($buf)&4294967295);var $arrayidx41=(($buf+10)&4294967295);var $arraydecay42=(($string)&4294967295);var $arraydecay48=(($string)&4294967295);var $arraydecay51=(($string)&4294967295);;$while_body$8:while(1){var $4=HEAP8[($arrayidx8)];var $conv=(tempInt=(($4)),(tempInt>=128?tempInt-256:tempInt));var $cmp9=((($conv))|0)==47;if($cmp9){__label__=6;;}else{__label__=7;;}
$while_cond_backedge$$if_end11$10:do{if(__label__==7){var $call13=_memcmp($arraydecay12,((__str9420)&4294967295),3);var $cmp14=((($call13))|0)==0;if($cmp14){__label__=8;;}else{__label__=10;;}
if(__label__==8){var $call18=_sscanf($arrayidx16,((__str10421)&4294967295),allocate([_logging_type,0,0,0,$arraydecay17,0,0,0],["i32*",0,0,0,"i8*",0,0,0],ALLOC_STACK));var $cmp19=((($call18))|0)==2;if(!($cmp19)){__label__=6;break $while_cond_backedge$$if_end11$10;}
var $call22=_fopen($arraydecay21,((__str11422)&4294967295));HEAP32[((_f_logespeak)>>2)]=$call22;;}
else if(__label__==10){var $call25=_memcmp($arraydecay24,((__str27677)&4294967295),4);var $cmp26=((($call25))|0)==0;if($cmp26){__label__=11;;}else{__label__=12;;}
if(__label__==11){__Z14ReadTonePointsPcPi($arrayidx28,((_tone_points)&4294967295));;}
else if(__label__==12){var $call31=_memcmp($arraydecay30,((__str13424)&4294967295),9);var $cmp32=((($call31))|0)==0;if($cmp32){__label__=13;;}else{__label__=14;;}
if(__label__==13){var $call35=_sscanf($arrayidx34,((__str63715)&4294967295),allocate([_option_device_number,0,0,0],["i32*",0,0,0],ALLOC_STACK));;}
else if(__label__==14){var $call38=_memcmp($arraydecay37,((__str15426)&4294967295),9);var $cmp39=((($call38))|0)==0;if(!($cmp39)){__label__=6;break $while_cond_backedge$$if_end11$10;}
var $call43=_sscanf($arrayidx41,((__str16427)&4294967295),allocate([$c1,0,0,0,$arraydecay42,0,0,0],["i8*",0,0,0,"i8*",0,0,0],ALLOC_STACK));$ix=$call43;var $6=$ix;var $cmp44=((($6))|0)==2;if(!($cmp44)){__label__=6;break $while_cond_backedge$$if_end11$10;}
var $7=HEAP8[($c1)];var $conv46=(tempInt=(($7)),(tempInt>=128?tempInt-256:tempInt));var $8=HEAP32[((_n_soundicon_tab)>>2)];var $arrayidx47=((_soundicon_tab+$8*16)&4294967295);var $name=(($arrayidx47)&4294967295);HEAP32[(($name)>>2)]=$conv46;var $call49=_strlen($arraydecay48);var $add=((($call49)+1)&4294967295);var $call50=__Z5Alloci($add);$p=$call50;var $9=$p;var $call52=_strcpy($9,$arraydecay51);var $10=$p;var $11=HEAP32[((_n_soundicon_tab)>>2)];var $arrayidx53=((_soundicon_tab+$11*16)&4294967295);var $filename54=(($arrayidx53+12)&4294967295);HEAP32[(($filename54)>>2)]=$10;var $12=HEAP32[((_n_soundicon_tab)>>2)];var $inc55=((($12)+1)&4294967295);HEAP32[((_n_soundicon_tab)>>2)]=$inc55;var $arrayidx56=((_soundicon_tab+$12*16)&4294967295);var $length=(($arrayidx56+4)&4294967295);HEAP32[(($length)>>2)]=0;;}}}}}while(0);var $5=$f;var $call6=_fgets($arraydecay5,160,$5);var $cmp7=((($call6))|0)!=0;if($cmp7){__label__=5;continue $while_body$8;}else{__label__=17;break $while_end$$while_cond_preheader$5;}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __Z16InterpretPhonemeP10TranslatoriP12PHONEME_LISTP12PHONEME_DATA($tr,$control,$plist,$phdata){var __stackBase__=STACKTOP;STACKTOP+=44;_memset(__stackBase__,0,44);var __label__;var __lastLabel__=null;var $tr_addr;var $control_addr;var $plist_addr;var $phdata_addr;var $ph;var $prog=__stackBase__;var $instn;var $instn2;var $or_flag;var $truth;var $data;var $end_flag;var $ix;var $param_sc;var $n_return;var $return_addr=__stackBase__+4;$tr_addr=$tr;$control_addr=$control;$plist_addr=$plist;$phdata_addr=$phdata;$n_return=0;var $0=$plist_addr;var $ph1=(($0+8)&4294967295);var $1=HEAP32[(($ph1)>>2)];$ph=$1;var $2=$phdata_addr;var $3=$2;var $dest$,$stop$,$stop4$,$fast$,$value4$;$dest$=$3;$stop$=$dest$+152;$value4$=0;if($value4$<0)$value4$+=256;$value4$=$value4$+($value4$<<8)+($value4$<<16)+($value4$*16777216);while($dest$%4!==0&&$dest$<$stop$){;;HEAP8[$dest$++]=0;}
$dest$>>=2;$stop4$=$stop$>>2;while($dest$<$stop4$){;;;;;;;HEAP32[$dest$++]=$value4$;}
$dest$<<=2;while($dest$<$stop$){;;HEAP8[$dest$++]=0;};var $4=$ph;var $std_length=(($4+14)&4294967295);var $5=HEAPU8[($std_length)];var $conv=((($5))&255);var $6=$phdata_addr;var $pd_param=(($6+4)&4294967295);var $arrayidx=(($pd_param+40)&4294967295);HEAP32[(($arrayidx)>>2)]=$conv;var $7=$ph;var $length_mod=(($7+15)&4294967295);var $8=HEAPU8[($length_mod)];var $conv2=((($8))&255);var $9=$phdata_addr;var $pd_param3=(($9+4)&4294967295);var $arrayidx4=(($pd_param3+36)&4294967295);HEAP32[(($arrayidx4)>>2)]=$conv2;var $10=$ph;var $program=(($10+8)&4294967295);var $11=HEAPU16[(($program)>>1)];var $conv5=((($11))&65535);var $cmp=((($conv5))|0)==0;if($cmp){__label__=69;;}else{__label__=1;;}
$for_end237$$if_end$2:do{if(__label__==1){$end_flag=0;var $12=$ph;var $program6=(($12+8)&4294967295);var $13=HEAPU16[(($program6)>>1)];var $idxprom=((($13))&65535);var $14=HEAP32[((_phoneme_index)>>2)];var $arrayidx7=(($14+2*$idxprom)&4294967295);HEAP32[(($prog)>>2)]=$arrayidx7;var $15=$end_flag;var $cmp89=((($15))|0)!=1;if(!($cmp89)){__label__=69;break $for_end237$$if_end$2;}
$for_body$4:while(1){var $16=HEAP32[(($prog)>>2)];var $17=HEAP16[(($16)>>1)];$instn=$17;var $18=$instn;var $conv9=((($18))&65535);var $shr=($conv9)>>8;var $and=($shr)&15;$instn2=$and;$or_flag=0;var $19=$instn;var $conv10=((($19))&65535);var $shr11=($conv10)>>12;if($shr11==0){__label__=3;;}
else if($shr11==1){__label__=21;;}
else if($shr11==2){__label__=25;;}
else if($shr11==3){__label__=25;;}
else if($shr11==6){__label__=40;;}
else if($shr11==9){__label__=44;;}
else if($shr11==10){__label__=49;;}
else if($shr11==11){__label__=53;;}
else if($shr11==12){__label__=53;;}
else if($shr11==13){__label__=53;;}
else if($shr11==14){__label__=53;;}
else if($shr11==15){__label__=53;;}
else{__label__=61;;}
$sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6:do{if(__label__==61){var $153=$ph;var $154=$instn;var $conv222=((($154))&65535);__ZL12InvalidInstnP11PHONEME_TABi($153,$conv222);;}
else if(__label__==3){var $20=$instn;var $conv12=((($20))&65535);var $and13=($conv12)&255;$data=$and13;var $21=$instn2;var $cmp14=((($21))|0)==0;if($cmp14){__label__=4;;}else{__label__=7;;}
if(__label__==4){var $22=$data;if($22==1){__label__=5;;}
else if($22==2){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
else{__label__=6;;}
if(__label__==6){var $23=$ph;var $24=$instn;var $conv17=((($24))&65535);__ZL12InvalidInstnP11PHONEME_TABi($23,$conv17);;}
else if(__label__==5){$end_flag=1;;}}
else if(__label__==7){var $25=$instn2;var $cmp18=((($25))|0)==5;if($cmp18){__label__=8;;}else{__label__=10;;}
if(__label__==8){var $26=$plist_addr;var $arrayidx20=(($26+24)&4294967295);var $phcode=(($arrayidx20)&4294967295);var $27=HEAPU8[($phcode)];var $idxprom21=((($27))&255);var $arrayidx22=((_phoneme_tab+$idxprom21*4)&4294967295);var $28=HEAP32[(($arrayidx22)>>2)];var $type=(($28+11)&4294967295);var $29=HEAPU8[($type)];var $conv23=((($29))&255);var $cmp24=((($conv23))|0)==2;if(!($cmp24)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $30=$data;var $31=$phdata_addr;var $pd_param26=(($31+4)&4294967295);var $arrayidx27=(($pd_param26+16)&4294967295);HEAP32[(($arrayidx27)>>2)]=$30;;}
else if(__label__==10){var $32=$instn2;var $cmp30=((($32))|0)==13;if($cmp30){__label__=11;;}else{__label__=14;;}
if(__label__==11){$ix=0;var $33=$ix;var $34=$data;var $cmp333=((($33))|0)<((($34))|0);var $35=$ix;var $cmp344=((($35))|0)<16;var $or_cond15=($cmp333)&($cmp344);if($or_cond15){__label__=12;;}else{__label__=13;;}
$for_body35$$for_end$21:do{if(__label__==12){while(1){var $36=HEAP32[(($prog)>>2)];var $incdec_ptr=(($36+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr;var $37=HEAP32[(($prog)>>2)];var $arrayidx36=(($37)&4294967295);var $38=HEAPU16[(($arrayidx36)>>1)];var $conv37=((($38))&65535);var $shr38=($conv37)>>8;var $conv39=((($shr38))&255);var $39=$ix;var $40=$phdata_addr;var $ipa_string=(($40+132)&4294967295);var $arrayidx40=(($ipa_string+$39)&4294967295);HEAP8[($arrayidx40)]=$conv39;var $41=HEAP32[(($prog)>>2)];var $arrayidx41=(($41)&4294967295);var $42=HEAPU16[(($arrayidx41)>>1)];var $conv42=((($42))&65535);var $and43=($conv42)&255;var $conv44=((($and43))&255);var $43=$ix;var $add=((($43)+1)&4294967295);var $44=$phdata_addr;var $ipa_string45=(($44+132)&4294967295);var $arrayidx46=(($ipa_string45+$add)&4294967295);HEAP8[($arrayidx46)]=$conv44;var $45=$ix;var $add47=((($45)+2)&4294967295);$ix=$add47;var $46=$ix;var $47=$data;var $cmp33=((($46))|0)<((($47))|0);var $48=$ix;var $cmp34=((($48))|0)<16;var $or_cond1=($cmp33)&($cmp34);if($or_cond1){__label__=12;continue;}else{__label__=13;break $for_body35$$for_end$21;}}}}while(0);var $49=$ix;var $50=$phdata_addr;var $ipa_string48=(($50+132)&4294967295);var $arrayidx49=(($ipa_string48+$49)&4294967295);HEAP8[($arrayidx49)]=0;;}
else if(__label__==14){var $51=$instn2;var $cmp51=((($51))|0)<16;if($cmp51){__label__=15;;}else{__label__=20;;}
if(__label__==15){var $52=$instn2;var $cmp53=((($52))|0)==12;if($cmp53){__label__=16;;}else{__label__=17;;}
if(__label__==16){var $53=$data;var $54=$phdata_addr;var $pd_param55=(($54+4)&4294967295);var $arrayidx56=(($pd_param55+4)&4294967295);HEAP32[(($arrayidx56)>>2)]=$53;;}
var $55=$data;var $56=$instn2;var $57=$phdata_addr;var $pd_param58=(($57+4)&4294967295);var $arrayidx59=(($pd_param58+$56*4)&4294967295);HEAP32[(($arrayidx59)>>2)]=$55;var $58=$instn2;var $cmp60=((($58))|0)==1;if(!($cmp60)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $59=$control_addr;var $and61=($59)&256;var $tobool=((($and61))|0)!=0;if(!($tobool)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
$end_flag=1;;}
else if(__label__==20){var $60=$ph;var $61=$instn;var $conv65=((($61))&65535);__ZL12InvalidInstnP11PHONEME_TABi($60,$conv65);;}}}}}
else if(__label__==21){var $62=$tr_addr;var $cmp71=((($62))|0)==0;if($cmp71){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $63=$instn2;var $cmp74=((($63))|0)<8;if(!($cmp74)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $64=$tr_addr;var $65=$plist_addr;var $66=$instn2;var $and76=($66)&7;var $call=__ZL15StressConditionP10TranslatorP12PHONEME_LISTii($64,$65,$and76,1);if(!($call)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $67=$instn;var $conv78=((($67))&65535);var $and79=($conv78)&255;var $68=$phdata_addr;var $pd_param80=(($68+4)&4294967295);var $arrayidx81=(($pd_param80+4)&4294967295);HEAP32[(($arrayidx81)>>2)]=$and79;$end_flag=1;;}
else if(__label__==25){$or_flag=0;$truth=1;var $69=$instn;var $conv856=((($69))&65535);var $and867=($conv856)&57344;var $cmp878=((($and867))|0)==8192;if($cmp878){__label__=26;;}else{__label__=34;;}
$while_body$$while_end$39:do{if(__label__==26){while(1){var $70=$or_flag;var $tobool88=((($70))|0)!=0;var $71=$truth;var $tobool90=((($71))&1);if($tobool88){__label__=27;;}else{__label__=30;;}
if(__label__==27){if($tobool90){__lastLabel__=27;__label__=29;;}else{__lastLabel__=27;__label__=28;;}
if(__label__==28){var $72=$tr_addr;var $73=$control_addr;var $74=$plist_addr;var $75=$instn;var $conv91=((($75))&65535);var $and92=($conv91)&4095;var $call93=__ZL18InterpretConditionP10TranslatoriP12PHONEME_LISTi($72,$73,$74,$and92);__lastLabel__=28;;}
var $76=__lastLabel__==27?1:($call93);var $frombool=((($76))&1);$truth=$frombool;;}
else if(__label__==30){if($tobool90){__lastLabel__=30;__label__=31;;}else{__lastLabel__=30;__label__=32;;}
if(__label__==31){var $77=$tr_addr;var $78=$control_addr;var $79=$plist_addr;var $80=$instn;var $conv97=((($80))&65535);var $and98=($conv97)&4095;var $call99=__ZL18InterpretConditionP10TranslatoriP12PHONEME_LISTi($77,$78,$79,$and98);__lastLabel__=31;;}
var $81=__lastLabel__==30?0:($call99);var $frombool101=((($81))&1);$truth=$frombool101;;}
var $82=$instn;var $conv103=((($82))&65535);var $and104=($conv103)&4096;$or_flag=$and104;var $83=HEAP32[(($prog)>>2)];var $incdec_ptr105=(($83+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr105;var $84=HEAP16[(($incdec_ptr105)>>1)];$instn=$84;var $85=$instn;var $conv85=((($85))&65535);var $and86=($conv85)&57344;var $cmp87=((($and86))|0)==8192;if($cmp87){__label__=26;continue;}else{__label__=34;break $while_body$$while_end$39;}}}}while(0);var $86=$truth;var $tobool106=((($86))&1);var $conv107=((($tobool106))&1);var $cmp108=((($conv107))|0)==0;if($cmp108){__label__=35;;}else{__label__=39;;}
$if_then109$$if_end127$53:do{if(__label__==35){var $87=$instn;var $conv110=((($87))&65535);var $and111=($conv110)&63488;var $cmp112=((($and111))|0)==26624;if($cmp112){__label__=36;;}else{__label__=37;;}
if(__label__==36){var $88=$instn;var $conv114=((($88))&65535);var $and115=($conv114)&255;var $89=HEAP32[(($prog)>>2)];var $add_ptr=(($89+2*$and115)&4294967295);HEAP32[(($prog)>>2)]=$add_ptr;;}
else if(__label__==37){var $90=HEAP32[(($prog)>>2)];var $call117=__ZL13NumInstnWordsPt($90);var $91=HEAP32[(($prog)>>2)];var $add_ptr118=(($91+2*$call117)&4294967295);HEAP32[(($prog)>>2)]=$add_ptr118;var $92=HEAP32[(($prog)>>2)];var $arrayidx119=(($92)&4294967295);var $93=HEAPU16[(($arrayidx119)>>1)];var $conv120=((($93))&65535);var $and121=($conv120)&65024;var $cmp122=((($and121))|0)==24576;if(!($cmp122)){__label__=39;break $if_then109$$if_end127$53;}
var $94=HEAP32[(($prog)>>2)];var $incdec_ptr124=(($94+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr124;;}}}while(0);var $95=HEAP32[(($prog)>>2)];var $incdec_ptr128=(($95+-2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr128;;}
else if(__label__==40){var $96=$instn2;var $shr130=($96)>>1;if($shr130==0){__label__=41;;}
else if($shr130==6){__label__=43;;}
else if($shr130==5){__label__=42;;}
else{__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
if(__label__==41){var $97=$instn;var $conv132=((($97))&65535);var $and133=($conv132)&255;var $sub=((($and133)-1)&4294967295);var $98=HEAP32[(($prog)>>2)];var $add_ptr134=(($98+2*$sub)&4294967295);HEAP32[(($prog)>>2)]=$add_ptr134;;}
else if(__label__==43){var $101=$plist_addr;var $102=$phdata_addr;__ZL15SwitchVowelTypeP12PHONEME_LISTP12PHONEME_DATAPPti($101,$102,$prog,3);;}
else if(__label__==42){var $99=$plist_addr;var $100=$phdata_addr;__ZL15SwitchVowelTypeP12PHONEME_LISTP12PHONEME_DATAPPti($99,$100,$prog,2);;}}
else if(__label__==44){var $103=$instn;var $conv139=((($103))&65535);var $and140=($conv139)&15;var $shl=((($and140)*65536)&4294967295);var $104=HEAP32[(($prog)>>2)];var $arrayidx141=(($104+2)&4294967295);var $105=HEAPU16[(($arrayidx141)>>1)];var $conv142=((($105))&65535);var $add143=((($shl)+($conv142))&4294967295);$data=$add143;var $106=HEAP32[(($prog)>>2)];var $incdec_ptr144=(($106+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr144;var $107=$instn2;if($107==1){__label__=45;;}
else if($107==2){__label__=47;;}
else if($107==3){__label__=48;;}
else{__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
if(__label__==45){var $108=$n_return;var $cmp146=((($108))|0)<10;if(!($cmp146)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $109=HEAP32[(($prog)>>2)];var $110=$n_return;var $inc=((($110)+1)&4294967295);$n_return=$inc;var $arrayidx148=(($return_addr+$110*4)&4294967295);HEAP32[(($arrayidx148)>>2)]=$109;var $111=$data;var $112=HEAP32[((_phoneme_index)>>2)];var $arrayidx149=(($112+2*$111)&4294967295);var $add_ptr150=(($arrayidx149+-2)&4294967295);HEAP32[(($prog)>>2)]=$add_ptr150;;}
else if(__label__==47){var $113=$data;var $114=$phdata_addr;var $pitch_env=(($114+124)&4294967295);HEAP32[(($pitch_env)>>2)]=$113;;}
else if(__label__==48){var $115=$data;var $116=$phdata_addr;var $amp_env=(($116+128)&4294967295);HEAP32[(($amp_env)>>2)]=$115;;}}
else if(__label__==49){var $117=$instn2;var $cmp156=((($117))|0)==1;if($cmp156){__label__=50;;}else{__label__=51;;}
if(__label__==50){$ix=0;;}
else if(__label__==51){$ix=2;;}
var $118=HEAP32[(($prog)>>2)];var $arrayidx160=(($118)&4294967295);var $119=HEAPU16[(($arrayidx160)>>1)];var $conv161=((($119))&65535);var $and162=($conv161)&255;var $shl163=((($and162)*65536)&4294967295);var $120=HEAP32[(($prog)>>2)];var $arrayidx164=(($120+2)&4294967295);var $121=HEAPU16[(($arrayidx164)>>1)];var $conv165=((($121))&65535);var $add166=((($shl163)+($conv165))&4294967295);var $122=$ix;var $123=$phdata_addr;var $vowel_transition=(($123+108)&4294967295);var $arrayidx167=(($vowel_transition+$122*4)&4294967295);HEAP32[(($arrayidx167)>>2)]=$add166;var $124=HEAP32[(($prog)>>2)];var $arrayidx168=(($124+4)&4294967295);var $125=HEAPU16[(($arrayidx168)>>1)];var $conv169=((($125))&65535);var $shl170=((($conv169)*65536)&4294967295);var $126=HEAP32[(($prog)>>2)];var $arrayidx171=(($126+6)&4294967295);var $127=HEAPU16[(($arrayidx171)>>1)];var $conv172=((($127))&65535);var $add173=((($conv172)+($shl170))&4294967295);var $128=$ix;var $add174=((($128)+1)&4294967295);var $129=$phdata_addr;var $vowel_transition175=(($129+108)&4294967295);var $arrayidx176=(($vowel_transition175+$add174*4)&4294967295);HEAP32[(($arrayidx176)>>2)]=$add173;var $130=HEAP32[(($prog)>>2)];var $add_ptr177=(($130+6)&4294967295);HEAP32[(($prog)>>2)]=$add_ptr177;;}
else if(__label__==53){var $131=$instn;var $conv179=((($131))&65535);var $shr180=($conv179)>>12;var $sub181=((($shr180)-11)&4294967295);$instn2=$sub181;var $132=$instn;var $conv182=((($132))&65535);var $and183=($conv182)&15;var $shl184=((($and183)*262144)&4294967295);var $133=HEAP32[(($prog)>>2)];var $arrayidx185=(($133+2)&4294967295);var $134=HEAPU16[(($arrayidx185)>>1)];var $conv186=((($134))&65535);var $shl187=((($conv186)*4)&4294967295);var $add188=((($shl187)+($shl184))&4294967295);var $135=$instn2;var $136=$phdata_addr;var $sound_addr=(($136+68)&4294967295);var $arrayidx189=(($sound_addr+$135*4)&4294967295);HEAP32[(($arrayidx189)>>2)]=$add188;var $137=$instn;var $conv190=((($137))&65535);var $shr191=($conv190)>>4;var $and192=($shr191)&255;var $138=$instn2;var $139=$phdata_addr;var $sound_param=(($139+88)&4294967295);var $arrayidx193=(($sound_param+$138*4)&4294967295);HEAP32[(($arrayidx193)>>2)]=$and192;var $conv194=((($and192))&255);$param_sc=$conv194;var $140=HEAP32[(($prog)>>2)];var $incdec_ptr195=(($140+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr195;var $141=HEAP32[(($prog)>>2)];var $arrayidx196=(($141+2)&4294967295);var $142=HEAPU16[(($arrayidx196)>>1)];var $conv197=((($142))&65535);var $cmp198=((($conv197))|0)!=2;if(!($cmp198)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $143=$instn2;var $cmp200=((($143))|0)<2;if($cmp200){__label__=55;;}else{__label__=57;;}
$if_then201$$if_else208$78:do{if(__label__==55){$end_flag=1;var $144=HEAP32[(($prog)>>2)];var $arrayidx202=(($144+2)&4294967295);var $145=HEAPU16[(($arrayidx202)>>1)];var $conv203=((($145))&65535);var $shr204=($conv203)>>12;var $cmp205=((($shr204))|0)==15;if(!($cmp205)){__label__=59;break $if_then201$$if_else208$78;}
$end_flag=2;;}
else if(__label__==57){var $146=$instn2;var $cmp209=((($146))|0)==4;if(!($cmp209)){__label__=59;break $if_then201$$if_else208$78;}
var $147=$end_flag;var $dec=((($147)-1)&4294967295);$end_flag=$dec;;}}while(0);var $148=$instn2;var $cmp213=((($148))|0)==2;var $149=$instn2;var $cmp214=((($149))|0)==3;var $or_cond=($cmp213)|($cmp214);if(!($or_cond)){__label__=62;break $sw_default221$$sw_bb$$sw_bb70$$sw_bb84$$sw_bb129$$sw_bb138$$sw_bb155$$sw_bb178$6;}
var $150=$param_sc;var $conv216=(tempInt=(($150)),(tempInt>=128?tempInt-256:tempInt));var $151=$instn2;var $152=$phdata_addr;var $sound_param217=(($152+88)&4294967295);var $arrayidx218=(($sound_param217+$151*4)&4294967295);HEAP32[(($arrayidx218)>>2)]=$conv216;;}}while(0);var $155=$ph;var $phflags=(($155+4)&4294967295);var $156=HEAP32[(($phflags)>>2)];var $and224=($156)&4096;var $tobool225=((($and224))|0)!=0;if($tobool225){__label__=63;;}else{__label__=64;;}
$if_end227_thread$$if_end227$86:do{if(__label__==63){$end_flag=1;;}
else if(__label__==64){var $_pr=$end_flag;var $cmp228=((($_pr))|0)==1;if($cmp228){__label__=66;break $if_end227_thread$$if_end227$86;}
var $157=HEAP32[(($prog)>>2)];var $incdec_ptr23611=(($157+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr23611;__label__=2;continue $for_body$4;}}while(0);var $158=$n_return;var $cmp230=((($158))|0)>0;if($cmp230){__label__=67;;}else{__label__=68;;}
if(__label__==67){$end_flag=0;var $159=$n_return;var $dec232=((($159)-1)&4294967295);$n_return=$dec232;var $arrayidx233=(($return_addr+$dec232*4)&4294967295);var $160=HEAP32[(($arrayidx233)>>2)];HEAP32[(($prog)>>2)]=$160;;}
var $_pr10=$end_flag;var $161=HEAP32[(($prog)>>2)];var $incdec_ptr236=(($161+2)&4294967295);HEAP32[(($prog)>>2)]=$incdec_ptr236;var $cmp8=((($_pr10))|0)!=1;if($cmp8){__label__=2;continue $for_body$4;}else{__label__=69;break $for_end237$$if_end$2;}}}}while(0);STACKTOP=__stackBase__;return;return;}
function __ZL12InvalidInstnP11PHONEME_TABi($ph,$instn){;var __label__;var $ph_addr;var $instn_addr;$ph_addr=$ph;$instn_addr=$instn;var $0=HEAP32[((__impure_ptr)>>2)];var $_stderr=(($0+12)&4294967295);var $1=HEAP32[(($_stderr)>>2)];var $2=$instn_addr;var $3=$ph_addr;var $mnemonic=(($3)&4294967295);var $4=HEAP32[(($mnemonic)>>2)];var $call=__Z12WordToStringj($4);var $call1=_fprintf($1,((__str17428)&4294967295),allocate([$2,0,0,0,((__ZZ12WordToStringjE3buf)&4294967295),0,0,0],["i32",0,0,0,"i8*",0,0,0],ALLOC_STACK));;return;return;}
function __ZL15StressConditionP10TranslatorP12PHONEME_LISTii($tr,$plist,$condition,$control){;var __label__;var $retval;var $tr_addr;var $plist_addr;var $condition_addr;var $control_addr;var $stress_level;var $pl;$tr_addr=$tr;$plist_addr=$plist;$condition_addr=$condition;$control_addr=$control;var $0=$plist_addr;var $arrayidx=(($0)&4294967295);var $phcode=(($arrayidx)&4294967295);var $1=HEAPU8[($phcode)];var $idxprom=((($1))&255);var $arrayidx1=((_phoneme_tab+$idxprom*4)&4294967295);var $2=HEAP32[(($arrayidx1)>>2)];var $type=(($2+11)&4294967295);var $3=HEAPU8[($type)];var $conv=((($3))&255);var $cmp=((($conv))|0)==2;var $4=$plist_addr;if($cmp){__label__=1;;}else{__label__=2;;}
$if_then$$if_else$2:do{if(__label__==1){$pl=$4;__label__=5;break $if_then$$if_else$2;}
else if(__label__==2){var $arrayidx2=(($4+24)&4294967295);var $phcode3=(($arrayidx2)&4294967295);var $5=HEAPU8[($phcode3)];var $idxprom4=((($5))&255);var $arrayidx5=((_phoneme_tab+$idxprom4*4)&4294967295);var $6=HEAP32[(($arrayidx5)>>2)];var $type6=(($6+11)&4294967295);var $7=HEAPU8[($type6)];var $conv7=((($7))&255);var $cmp8=((($conv7))|0)==2;if($cmp8){__label__=3;;}else{__label__=4;;}
if(__label__==3){var $8=$plist_addr;var $arrayidx10=(($8+24)&4294967295);$pl=$arrayidx10;__label__=5;break $if_then$$if_else$2;}
else if(__label__==4){$retval=0;__label__=21;break $if_then$$if_else$2;}}}while(0);$if_end12$$return$8:do{if(__label__==5){var $9=$pl;var $stresslevel=(($9+1)&4294967295);var $10=HEAPU8[($stresslevel)];var $conv13=((($10))&255);var $and=($conv13)&15;$stress_level=$and;var $11=$tr_addr;var $cmp14=((($11))|0)!=0;if($cmp14){__label__=6;;}else{__label__=13;;}
$if_then15$$if_end36$10:do{if(__label__==6){var $12=$control_addr;var $and16=($12)&1;var $tobool=((($and16))|0)!=0;if($tobool){__label__=7;;}else{__label__=10;;}
$land_lhs_true$$if_end25$12:do{if(__label__==7){var $13=$plist_addr;var $synthflags=(($13+4)&4294967295);var $14=HEAPU16[(($synthflags)>>1)];var $conv17=((($14))&65535);var $and18=($conv17)&16;var $tobool19=((($and18))|0)!=0;if(!($tobool19)){__label__=10;break $land_lhs_true$$if_end25$12;}
var $15=$tr_addr;var $langopts=(($15)&4294967295);var $param=(($langopts+24)&4294967295);var $arrayidx21=(($param+40)&4294967295);var $16=HEAP32[(($arrayidx21)>>2)];var $and22=($16)&1;var $cmp23=((($and22))|0)==0;if(!($cmp23)){__label__=10;break $land_lhs_true$$if_end25$12;}
$retval=0;__label__=21;break $if_end12$$return$8;}}while(0);var $17=$tr_addr;var $langopts26=(($17)&4294967295);var $param27=(($langopts26+24)&4294967295);var $arrayidx28=(($param27+40)&4294967295);var $18=HEAP32[(($arrayidx28)>>2)];var $and29=($18)&2;var $tobool30=((($and29))|0)!=0;if(!($tobool30)){__label__=13;break $if_then15$$if_end36$10;}
var $19=$stress_level;var $20=$pl;var $wordstress=(($20+2)&4294967295);var $21=HEAPU8[($wordstress)];var $conv32=((($21))&255);var $cmp33=((($19))|0)>=((($conv32))|0);if(!($cmp33)){__label__=13;break $if_then15$$if_end36$10;}
$stress_level=4;;}}while(0);var $22=$condition_addr;var $cmp37=((($22))|0)==4;if($cmp37){__label__=14;;}else{__label__=15;;}
if(__label__==14){var $23=$stress_level;var $24=$pl;var $wordstress39=(($24+2)&4294967295);var $25=HEAPU8[($wordstress39)];var $conv40=((($25))&255);var $cmp41=((($23))|0)>=((($conv40))|0);$retval=$cmp41;;}
else if(__label__==15){var $26=$condition_addr;var $cmp43=((($26))|0)==3;var $27=$stress_level;if($cmp43){__label__=16;;}else{__label__=18;;}
$if_then44$$if_else48$23:do{if(__label__==16){var $cmp45=((($27))|0)>3;if(!($cmp45)){__label__=20;break $if_then44$$if_else48$23;}
$retval=1;__label__=21;break $if_end12$$return$8;}
else if(__label__==18){var $28=$condition_addr;var $arrayidx49=((__ZZL15StressConditionP10TranslatorP12PHONEME_LISTiiE15condition_level+$28*4)&4294967295);var $29=HEAP32[(($arrayidx49)>>2)];var $cmp50=((($27))|0)<((($29))|0);if(!($cmp50)){__label__=20;break $if_then44$$if_else48$23;}
$retval=1;__label__=21;break $if_end12$$return$8;}}while(0);$retval=0;;}}}while(0);var $30=$retval;;return $30;return null;}
function __ZL18InterpretConditionP10TranslatoriP12PHONEME_LISTi($tr,$control,$plist,$instn){;var __label__;var __lastLabel__=null;var $retval;var $tr_addr;var $control_addr;var $plist_addr;var $instn_addr;var $which;var $data;var $instn2;var $count;var $ph;var $plist_this;$tr_addr=$tr;$control_addr=$control;$plist_addr=$plist;$instn_addr=$instn;var $0=$instn_addr;var $and=($0)&255;$data=$and;var $1=$instn_addr;var $shr=($1)>>8;$instn2=$shr;var $2=$instn2;var $cmp=((($2))|0)<14;var $3=$instn2;if($cmp){__label__=1;;}else{__label__=67;;}
$if_then$$if_else187$2:do{if(__label__==1){var $rem=((($3))|0)%7;$which=$rem;var $4=$which;var $cmp1=((($4))|0)==4;if($cmp1){__lastLabel__=1;__label__=2;;}else{__lastLabel__=1;__label__=5;;}
if(__label__==2){var $5=$plist_addr;var $arrayidx=(($5+24)&4294967295);var $sourceix=(($arrayidx+6)&4294967295);var $6=HEAP16[(($sourceix)>>1)];var $tobool=(tempInt=(($6)),(tempInt>=32768?tempInt-65536:tempInt))!=0;if($tobool){__label__=3;;}else{__label__=4;;}
if(__label__==3){$retval=0;__label__=73;break $if_then$$if_else187$2;}
else if(__label__==4){var $_pr=$which;__lastLabel__=4;;}}
var $7=__lastLabel__==4?$_pr:($4);var $cmp5=((($7))|0)==5;if($cmp5){__label__=6;;}else{__label__=8;;}
$if_then6$$if_end12$10:do{if(__label__==6){var $8=$plist_addr;var $arrayidx7=(($8)&4294967295);var $sourceix8=(($arrayidx7+6)&4294967295);var $9=HEAP16[(($sourceix8)>>1)];var $tobool9=(tempInt=(($9)),(tempInt>=32768?tempInt-65536:tempInt))!=0;if(!($tobool9)){__label__=8;break $if_then6$$if_end12$10;}
$retval=0;__label__=73;break $if_then$$if_else187$2;}}while(0);var $10=$which;var $cmp13=((($10))|0)==7;if($cmp13){__lastLabel__=8;__label__=9;;}else{__lastLabel__=8;__label__=13;;}
$if_then14$$if_end23$14:do{if(__label__==9){var $11=$plist_addr;var $arrayidx15=(($11+24)&4294967295);var $sourceix16=(($arrayidx15+6)&4294967295);var $12=HEAP16[(($sourceix16)>>1)];var $tobool17=(tempInt=(($12)),(tempInt>=32768?tempInt-65536:tempInt))!=0;if($tobool17){__label__=11;;}else{__label__=10;;}
$if_then21$$lor_lhs_false$16:do{if(__label__==10){var $13=$plist_addr;var $arrayidx18=(($13+48)&4294967295);var $sourceix19=(($arrayidx18+6)&4294967295);var $14=HEAP16[(($sourceix19)>>1)];var $tobool20=(tempInt=(($14)),(tempInt>=32768?tempInt-65536:tempInt))!=0;if($tobool20){__label__=11;break $if_then21$$lor_lhs_false$16;}
var $_pr1=$which;__lastLabel__=12;__label__=13;break $if_then14$$if_end23$14;}}while(0);$retval=0;__label__=73;break $if_then$$if_else187$2;}}while(0);var $15=__lastLabel__==12?$_pr1:($10);var $cmp24=((($15))|0)==6;if($cmp24){__label__=14;;}else{__label__=19;;}
$if_then25$$if_else$21:do{if(__label__==14){$which=2;;while(1){var $16=$which;var $sub=((($16)-1)&4294967295);var $17=$plist_addr;var $arrayidx26=(($17+24*$sub)&4294967295);var $sourceix27=(