﻿/**
 * file name     : app.js
 * author        : Axel Bluem (axel.bluem@gmail.com)
 * version       : v1.0
 * date          : 09/09/2014
 * description   : flashlight's script
 * utilisation   : /
 * documentation : https://developer.mozilla.org/en/Apps/Reference
 * details       : /
 *
 */

(function () {

    'use strict';

    var i,
        bgColor = '0, 0, 0',
        opacity = 0.5,
        isMenuVisible = false,
        options = document.getElementById('options'),
        menu = document.getElementById('menu'),
        brightness = document.getElementById('brightness'),
        color = document.getElementsByClassName('color');

    function changeColor() {
        switch (this.id) {
        case 'white':
            bgColor = '255, 255, 255';
            break;
        case 'grey':
            bgColor = '128, 128, 128';
            break;
        case 'red':
            bgColor = '255, 0, 0';
            break;
        case 'yellow':
            bgColor = '255, 255, 0';
            break;
        case 'blue':
            bgColor = '0, 0, 255';
            break;
        case 'purple':
            bgColor = '128, 0, 128';
            break;
        case 'orange':
            bgColor = '255, 69, 0';
            break;
        case 'green':
            bgColor = '0, 128, 0';
            break;
        case 'black':
            bgColor = '0, 0, 0';
            break;
        }
        document.body.style.backgroundColor = 'rgba(' + bgColor + ', ' + opacity + ')';
    }

    for (i = 0; i < color.length; i++) {
        color[i].addEventListener('click', changeColor, false);
    }

    options.addEventListener('click', function () {
        if (!isMenuVisible) {
            menu.style.display = 'block';
            isMenuVisible = true;
        } else {
            menu.style.display = 'none';
            isMenuVisible = false;
        }
    }, false);

    brightness.addEventListener('change', function () {
        opacity = 1 - this.value;
        document.body.style.backgroundColor = 'rgba(' + bgColor + ', ' + opacity + ')';
    }, false);

}());