//
//	ambient_light_controller.js
//
//	Created by Nikolas Hansen on 16.07.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function AmbientLightController(base) {
  this.base = base;
  this.name = "ambient_light";
  this.type = "full";

  this.generate_interval = null;
	this.duration = 5000;
	this.animation_time = 5000;
	this.run = true;
}


AmbientLightController.prototype.init = function() {
  this.templates = [];
  this.base.loadTemplate(this, "main");
}


AmbientLightController.prototype.setup = function() {
  color_chooser.inkScreen();
}


AmbientLightController.prototype.activate =  function() {
  Zepto('#settings_button').on('click', function() {view_controller.showView("settings");});
}


AmbientLightController.prototype.show = function() {
  //this.generate_interval = window.set(Zepto.proxy(function() {this.generateColor()}, this), this.duration);
	this.run = true;
	this.generateColor();
}


AmbientLightController.prototype.deactivate = function() {
  //window.clearInterval(this.generate_interval);
	this.run = false;
  Zepto("*").off();
}


//***********************************************

AmbientLightController.prototype.generateColor = function() {
	if (!this.run) {
		return;
	}
  var hue = Math.random();
  var saturation = 0.75 + Math.random()*0.25;
  var lightness = 0.5;//Math.random();

  color_chooser.setHsl(hue, saturation, lightness);
	var color = color_chooser.getRgbString();


  Zepto('#content').animate({"background-color": color}, this.duration, 'linear');
	window.setTimeout(Zepto.proxy(function() {
		this.generateColor();
	}, this), this.animation_time + this.duration);
}