//
//	simple_lightcontroller.js
//
//	Created by Nikolas Hansen on 16.07.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function SimpleLightController(base) {
    this.base = base;
    this.name = "simple_light";
    this.type = "full";

    this.power_on = true;
}

SimpleLightController.prototype.init = function() {
    this.templates = [];
    this.base.loadTemplate(this, "main");
}


SimpleLightController.prototype.setup = function() {
    Zepto('#content').css('background', '#ffffff');	
}


SimpleLightController.prototype.activate =  function() {
  Zepto('#settings_button').on('tap click', function() {view_controller.showView("settings");});

  Zepto("#power_button").on('tap click', Zepto.proxy(function(event) {
		this.onPowerButtonClick(event);
  }, this));

	//this.base.StartButtonResponse();
}


SimpleLightController.prototype.show = function() {
}


SimpleLightController.prototype.deactivate = function() {
    Zepto("*").off('click');
}

//*********************************************

SimpleLightController.prototype.onPowerButtonClick = function() {
    if (this.power_on) {
	Zepto('#content').css('background', '#000000');
	this.power_on = false;
    } else {
	Zepto('#content').css('background', '#ffffff');
	this.power_on = true;
    }
}
