//
//	view_controller.js
//
//	Created by Nikolas Hansen on 13.03.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function ViewController() {
  this.init();
}


ViewController.prototype.init = function() {
  this.view_names = new Array("simple_light", 
															"colored_light", 
															"morse_code", 
															"ambient_light",
															"settings",
															"info");

  this.view_controllers = new Array();
  this.view_controllers[0] = new SimpleLightController(this);
  this.view_controllers[1] = new ColoredLightController(this);
  this.view_controllers[2] = new MorseCodeController(this);
  this.view_controllers[3] = new AmbientLightController(this);
  this.view_controllers[4] = new SettingsController(this);
  this.view_controllers[5] = new InfoController(this);

  for (var i = 0; i < this.view_controllers.length; i++) {
		this.view_controllers[i].init();
  }

	this.fade_in_time = 0;
	this.fade_out_time = 0;
	
  this.view_id_history = [];
	this.going_back = false;
  this.current_view_id = null;

  this.storage = new Storage("view_controller");

  this._on_unload = this.on_unload.bind(this);
}



ViewController.prototype.show = function() {
  var view_id_history_backup = this.storage.get("view_id_history");

  //restore last view and view history if possible
  if (view_id_history_backup != null) {
		this.view_id_history = view_id_history_backup;
		this.current_view_id = view_id_history_backup[view_id_history_backup.length-1]
		
		// also show last fullscreen view if current is of popup type
		if (this.view_controllers[this.current_view_id].type == "popup") {
	    var last_full_view_id = this.getLastFullscreen();
			Zepto('#screen').append(this.view_controllers[last_full_view_id].templates.main);
	    this.view_controllers[last_full_view_id].setup();
	    this.view_controllers[last_full_view_id].show();
		}

		//clear old history
		this.view_id_history = [];

		//show
		this.showView(this.current_view_id);

  } else {
		this.showView(0);
  }


	//prevent screen dimming
	if (navigator.requestWakeLock != null) {
		this.screen_wake_lock = navigator.requestWakeLock('screen');
	}

	//set unload (app-close) listener
  Zepto(window).on('unload', this._on_unload);
}



ViewController.prototype.reInitViews = function() {
  for (var i = 0; i < this.view_controllers.length; i++) {
		this.view_controllers[i].init();
  }
}



ViewController.prototype.showView = function(view_id) {	
  if (!isNumeric(view_id)) {
		view_id = this.view_names.indexOf(view_id);
  }

	//deactivate previous view and put to background
  if (this.current_view_id != null) {
		this.view_controllers[this.current_view_id].deactivate();
		
		Zepto('#content').attr('id', 'content_old');
		Zepto('#content_old').find('*').removeAttr('id');
	}
	
	this.current_view_id = view_id;	

	//forward and backward history
	if (!this.going_back && this.view_controllers[view_id].type == "full") {
		this.historyPush(view_id);
		this.storage.set("view_id_history", this.view_id_history);
	}
	this.going_back = false;
	
	//console.debug("history: " + this.view_id_history);

  //cleanup if necessary
	Zepto('#shade').remove();

	//add shade layer for popups
  if (this.view_controllers[this.current_view_id].type == "popup") {
		Zepto("#screen").append("<div id='shade' style='position:absolute; top:0; left:0; height:100%; width:100%; background:#333;'></div>");
		Zepto("#shade").css('opacity', 0.0);
  }

	//setup content off-screen
  Zepto('#screen').append(this.view_controllers[view_id].templates.main);
  Zepto('#content').css('opacity', 0.0);

  var ready = this.view_controllers[view_id].setup(); 
  
	//synchronous or asynchronous completion of show
  if (ready || ready == null) {
		this.on_setupComplete();
  } else {
		Zepto(document).on("event_setupComplete", Zepto.proxy(function() {this.on_setupComplete()}, this));
  }
}



ViewController.prototype.on_setupComplete = function() {
  Zepto(document).off("event_setupComplete");

  //transition to new view after setup and all images loaded
	var current_type = this.view_controllers[this.current_view_id].type; 
	
/*var previous_type = null;
	if (this.view_id_history.length > 1) {
		var previous_type = this.view_controllers[this.view_id_history[this.view_id_history.length-2]].type;
	}*/

  if (current_type == "full") {
		// => remove old content and background
		Zepto('#content_background').remove();
		Zepto('#content_old').animate({opacity: 0.0}, this.fade_out_time, 'ease-out', function() {Zepto('#content_old').remove();});
		
	} else if (current_type == "popup") {
		if (Zepto('#content_background').length == 0) {
			//new popup after full => move content to background
			Zepto('#content_old').attr('id', 'content_background');
			Zepto('#content_background').find('*').removeAttr('id');
			Zepto('#shade').animate({opacity: 0.7}, this.fade_out_time, 'ease-out');
		
		} else {
			// from 2nd popup on => remove old content
			Zepto('#content_old').animate({opacity: 0.0}, this.fade_out_time, 'ease-out', function() {Zepto('#content_old').remove();});
			Zepto('#shade').animate({opacity: 0.75}, this.fade_out_time, 'ease-out');
		
		}
	}

	//fade in new content
  Zepto(document).ready(Zepto.proxy(function() {
		this.waitForImages(Zepto('#screen'), Zepto.proxy(function() {
			Zepto("#content").animate({opacity: 1.0}, this.fade_in_time, 'ease-in', Zepto.proxy(function() {
				this.on_renderComplete();
			}, this))
		}, this))
  }, this));
}



ViewController.prototype.on_renderComplete = function() {
	//activate view handlers
	this.view_controllers[this.current_view_id].activate();
	
	//show
	this.view_controllers[this.current_view_id].show();
}



//**************************

ViewController.prototype.reloadView = function() {
  this.showView(this.current_view_id);
}


ViewController.prototype.hidePopup = function() {
	if (this.view_id_history.length > 0) {
		var last_view_id = this.view_id_history[this.view_id_history.length-1];
		this.going_back = true;

		this.showView(last_view_id);
  } else {
		console.debug("view_controller.js: navBack() -> view history empty\n");
  }
}

ViewController.prototype.hidePopupAndShowView = function(view_id) {
	
}


ViewController.prototype.navigateBack = function() {
  if (this.view_id_history.length > 1) {
		this.view_id_history.pop();
		var last_view_id = this.view_id_history[this.view_id_history.length-1];
		this.going_back = true;
		this.showView(last_view_id);
  } else {
		console.debug("view_controller.js: navBack() -> view history empty\n");
  }
}


ViewController.prototype.on_unload = function() {
  if (this.view_controllers[this.current_view_id].on_unload != null) {
		this.view_controllers[this.current_view_id].on_unload();
  }

	if (navigator.requestWakeLock != null) {
		this.screen_wake_lock.unlock();
	}
}


//******************************************

ViewController.prototype.historyPush = function(view_id) {
	if (view_id != this.view_id_history[this.view_id_history.length-1]) {
		this.view_id_history.push(view_id);
	}
}


/* ************ Utility functions ************ */
ViewController.prototype.getLastFullscreen = function() {
  var ret = null;

  for (var id=this.view_controllers.length-2; id>=0; id--) {
		if (this.view_controllers[id].type == "full") {
	    ret = id;
	    break;
		}
  }
  
  return ret;
}

/*
ViewController.prototype.StartButtonResponse = function() {
	Zepto('.rect_button').on('mousedown', Zepto.proxy(function(event) {this.OnButtonResponseActive(event)}, this));
	Zepto('.rect_button').on('mouseup mouseout', Zepto.proxy(function(event) {this.OnButtonResponseInactive(event)}, this));
}

ViewController.prototype.OnButtonResponseActive = function(event) {
	var url = event.target.style.backgroundImage;
	var url_new = url.replace('button', 'button-active');
	event.target.style.backgroundImage = url_new;
}

ViewController.prototype.OnButtonResponseInactive = function(event) {
	var url = event.target.style.backgroundImage;
	var url_new = url.replace('button-active', 'button');
	event.target.style.backgroundImage = url_new;
}
*/


ViewController.prototype.loadTemplate = function(controller, template_name, lang_code) {
  if (name == undefined) {
		template_name = "main";
  }

  if (lang_code == undefined || lang_code == language.base_lang_code) {
		var base_path = appPath + "views/";
  } else {
		var base_path = appPath + "resources/" + lang_code + "/views/"
  }

  var filename = base_path + controller.name + "/" + template_name + ".html"
  
  controller.templates[template_name] = "";
  Zepto.ajax({
		async: false,
		type: 'GET',
		dataType: 'text',
		url: filename,
		success: Zepto.proxy(function(data){
	    controller.templates[template_name] = data
		}, controller),
		error: function(xhr, type){
	    console.log('ViewController->loadTemplate: Ajax error!')
		}
  });
}


ViewController.prototype.waitForImages = function (obj, finishedCallback) {
  var allImgsLength = 0;
  var allImgsLoaded = 0;

  var img_only = false;

  // Ensure callbacks are functions.
  if (!Zepto.isFunction(finishedCallback)) {
		throw new TypeError('An invalid callback was supplied.');
  }

  // CSS properties which contain references to images.
  hasImageProperties = ['backgroundImage', 'listStyleImage', 'borderImage', 'borderCornerImage'];

  eventNamespace = "waitForImages";

  // `img` elements with valid `src` attribute not already loaded.
  uncached = function(obj) {
		// Ensure we are dealing with an `img` element with a valid `src` attribute.
		if (!Zepto(obj).is('img')) {
      return false;
		}
		if (Zepto(obj).attr('src') != "") {
	    return false;
		}
		
		// Firefox's `complete` property will always be `true` even if the image has not been downloaded. Doing it this way works in Firefox.
		var img = new Image();
		img.src = obj.src;
		return !img.complete;
  };


  Zepto(obj).each(function () {
		// Build a list of all imgs, dependent on what images will be considered.
		var obj = Zepto(this);
		var allImgs = [];

		// CSS properties which may contain an image.
		var hasImgProperties = hasImageProperties || [];

		// To match `url()` references.
		// Spec: http://www.w3.org/TR/CSS2/syndata.html#value-def-uri
		var matchUrl = /url\(\s*(['"]?)(.*?)\1\s*\)/g;

		if (img_only) {
      // For images only, the task is simpler.
      obj.find('img')
				.each(function () {
					if (uncached(this)) {
						allImgs.push({
							src: this.src,
							element: this
						});
					}
				});
		} else {
      // Get all elements, as any one of them could have a background image.
      obj.find('*').each(function () {
				var element = Zepto(this);

				// If an `img` element, add it. But keep iterating in case it has a background image too.
				if (element.is('img')) {
					if (uncached(this)) {
						allImgs.push({
							src: element.src,
							element: element[0]
						});
					}
				}

				Zepto.each(hasImgProperties, function (i, property) {
          var propertyValue = element.css(property);
          var match;

          // If it doesn't contain this property, skip.
          if (!propertyValue) {
						return true;
          }

          // Get all url() of this element.
          while (match = matchUrl.exec(propertyValue)) {
						allImgs.push({
              src: match[2],
              element: element[0]
						});
          }
				});
      });
		}

		allImgsLength = allImgs.length;
		allImgsLoaded = 0;

		// If no images found, don't bother.
		if (allImgsLength === 0) {
      finishedCallback.call(obj[0]);
		}

		Zepto.each(allImgs, function (i, img) {

      var image = new Image();

      // Handle the image loading and error with the same callback.
      Zepto(image).bind('load.' + eventNamespace + ' error.' + eventNamespace, function (event) {
				allImgsLoaded++;

				// If an error occurred with loading the image, set the third argument accordingly.

				if (allImgsLoaded == allImgsLength) {
          finishedCallback.call(obj[0]);
          return false;
				}

      });

      image.src = img.src;
		});
  });
}
