function Language() {
    this.default_lang_code = "de_de";
    this.base_lang_code = "en_en";
    this.supported_lang_codes = ["en_en", "de_de"];
    this.supported_languages = ["English", "Deutsch"];
    this.lang_code = "";

    this.init();
}

Language.prototype.init = function() {
    var settings_language = settings.get("language");
    if (settings_language != null) {
	this.lang_code = settings_language;
    } else if (window.navigator.language) {
	var lang_tag = window.navigator.language.split('-',1);
	var lang_subtag = lang_tag[0]; 
	if (lang_subtag === "de") {
	    this.lang_code = "de_de";
	} else if (lang_subtag === "en") {
	    this.lang_code = "en_en";
	} else if (lang_subtag === "es") {
	    this.lang_code = "es_es";
	} else if (lang_subtag === "pl") {
	    this.lang_code = "pl_pl";
	}
    } else {
	this.lang_code = this.default_lang_code;
    }
    this.setLanguage(this.lang_code);
}


Language.prototype.isBaseLanguage = function() {
    return (this.lang_code === this.base_lang_code);
}


Language.prototype.setLanguage = function(lang_code) {
    if (this.supported_lang_codes.indexOf(lang_code) != -1) {
	this.lang_code = lang_code;	
	if (lang_code === this.base_lang_code) {
	    return;
	}

	var filename = appPath + "resources/" + lang_code + "/strings.json";
	Zepto.ajax({
	    async: false,
	    type: 'GET',
	    dataType: 'text',
	    url: filename,
	    success: Zepto.proxy(function(data){
		var str_obj = Zepto.parseJSON( data );
		this.strings = str_obj;
		//this.strings = data;
	    }, this),
	    error: function(xhr, type){
		console.log('Ajax error! Language.prototype.init')
	    }
	});
    
    } else {
	this.lang_code = this.default_lang_code;
	console.log("unsupported language code: " + lang_code);
    }
}


Language.prototype.getString = function(key) {
    if (this.lang_code === "en_en") {
	return key;
    }
    else {
	if (key in this.strings) {
	    return this.strings[key];
	} else {
	    console.warn("language.js: no translation for " + key + " found");
	    return '-' + key + '-';
	}
    }
}