'use strict';

/**
 *
 */
var CalculadoraController = {

//------------------------------------------------------------------------------
// Properties
//------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------

   /**
    * Add the event listeners for the main view
    */
   addEventListeners: function()
   {
       document.getElementById("calcular").addEventListener("click",CalculadoraController.validar,false);
       document.getElementById("sobre").addEventListener("click",CalculadoraController.sobre,false);
       document.getElementById("sugerirRecursos").addEventListener("click",CalculadoraController.sugerirRecursos,false);
       document.getElementById("reportarBugs").addEventListener("click",CalculadoraController.reportarBugs,false);

       document.getElementById("btn-back").addEventListener("click",CalculadoraController.voltar,false);
       document.getElementById("btn-call").addEventListener("click",CalculadoraController.call,false);
   },  

//-----------------------------------------------------------------------------

   /**
    * Valida as entradas antes de calcular o melhor combustível
    */
    validar: function(event)
    {
        
        var informouPrecoEtanol   = document.getElementById("preco-etanol").validity.valid && parseInt(document.getElementById('preco-etanol').value) > 0;
        var informouPrecoGasolina = document.getElementById("preco-etanol").validity.valid && parseInt(document.getElementById('preco-gasolina').value) > 0;
       
        if(informouPrecoEtanol && informouPrecoGasolina
          )
        {
           CalculadoraController.calcular(event); 
        }
        else
        {
           var n = $('#calculo-resultado').noty({text: 'Informe o pre&ccedil;o dos combust&iacute;veis '});n.close();
           //document.getElementById('calculo-resultado').innerHTML = 'Informe o pre&ccedil;o dos combust&iacute;veis';
        }
    },
//-----------------------------------------------------------------------------
  /**
   * Calcula a diferença entre o Etanol e Gasolina e indica o combustível a ser usado
   */
   calcular: function(event)
   {

       var etanol   = parseInt(document.getElementById("preco-etanol").value);
       var gasolina = parseInt(document.getElementById("preco-gasolina").value);

       var resultado = etanol / gasolina;

       if(resultado < 0.7)
       {
           //document.getElementById('calculo-resultado').innerHTML = 'Abasteça com Etanol';
           var n = $('#calculo-resultado').noty({text: 'Abasteça com Etanol'});

       }
       else
       {
           //document.getElementById('calculo-resultado').innerHTML = 'Abasteça com Gasolina';
           var n = $('#calculo-resultado').noty({text: 'Abasteça com Gasolina '});
       }

       var removeMensagem = function(){
        n.close();
       }

       setTimeout(removeMensagem,1100);
   },
//------------------------------------------------------------------------------

    /**
     * Envia um email com sugestão de recursos para o aplicativo
     */
     sugerirRecursos: function(event)
     {
          var activity = new MozActivity({
            name: "new",

            type: "mail"
          });

          activity.onsuccess = function()
          {
            alert(this.result);
          }

          activity.onerror = function()
          {
            alert(this.error);
          }

     },

//------------------------------------------------------------------------------

    /**
     * Envia um email com reporte de BUG no aplicativo
     */
     reportarBugs: function(event)
     {

     },
//------------------------------------------------------------------------------

    /**
     * Sobre o aplicativo
     */
     sobre: function(event)
     {
          $('#sidebar').hide();
          $('#drawer').hide();

          $('#sobre').show();
     },
//------------------------------------------------------------------------------
    
    /**
     * Faz uma chamada para o número especificado
     */
     call: function(event)
     {
          var activity = new MozActivity({
            name: "dial",
            type: "webtelephony/number",
            number:{
              regexp:/^[\\d\\s+#*().-]{0,50}$/
            },
            data:{
              number: "99921409"
            }

          });
     },
     exibirSplash: function()
     {
         $('#sidebar').hide();
         $('#drawer').hide();
         $('#toolbar-app').hide();
         $('#toolbar-about').hide();

         $('#splash').show();
     },
     removerSplash: function()
     {
         $('#splash').hide();
         $('#sidebar').show();
         $('#drawer').show();
         $('#toolbar-app').show();
         $('#toolbar-about').show();
     },
     voltar: function(event)
     {
         event.preventDefault();
         
         $('#sobre').hide();

         $('#sidebar').show();
         $('#drawer').show();
         //$('#toolbar-app').show();

     }
//------------------------------------------------------------------------------
};

//------------------------------------------------------------------------------
// Main
//------------------------------------------------------------------------------
$(document).ready(function()
{
   
   CalculadoraController.exibirSplash();

    var remover = function(){
         $('#splash').hide();
         $('#sidebar').show();
         $('#drawer').show();
         $('#toolbar-app').show();
         $('#toolbar-about').show();

    }

    window.setTimeout(remover,1800);
    
    //Solução para o problema da máscara no campo
    $('#preco-etanol').unbind();
    $('#preco-gasolina').unbind();

    $('#preco-etanol').mask('9,99');
    $('#preco-gasolina').mask('9,99');

    CalculadoraController.addEventListeners();      
});

