
function createPauseScreen(list) {
    Crafty.audio.stop();

    if(list != undefined ){
        hideImages(list, false);    
    }
    
    var bg = Crafty.e("2D, Canvas, Image, Mouse").image("images/menuBg.png");
    bg.x = Crafty.viewport.width/2-480/2; bg.y = Crafty.viewport.height/2-320/2;

    var resumeBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/btnResume.png");
    resumeBtn.x = bg._x+480/2 - 186/2; resumeBtn.y = bg._y+60;
    
    var onBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/on.png");
    onBtn.x = bg._x+480/2 - 186/2; onBtn.y = bg._y+110;
    onBtn.originX = onBtn._x;
    
    var offBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/off.png");
    offBtn.x = bg._x+480/2 - 186/2; offBtn.y = bg._y+110;
    offBtn.originX = offBtn._x;

    var helpBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/btnHelp.png");
    helpBtn.x = bg._x+480/2 - 186/2; helpBtn.y = bg._y+160;
    
    var mainMenuBtn = Crafty.e("2D, Canvas, Image, Mouse").image("images/main_menu.png");
    mainMenuBtn.x = bg._x+480/2 - 186/2; mainMenuBtn.y = bg._y+210;
    
    
    if(getAudioIsMuted()) {
        offBtn.visible = true;
        onBtn.visible = false;
        onBtn.x = -1000;
    } else {
        offBtn.visible = false;
        onBtn.visible = true;
        offBtn.x = -1000;
    }
    
    offBtn.bind("MouseDown", function(e) {
        console.log("off btn clicked");
        setAudioIsMuted(false)
        onBtn.visible = true;
        offBtn.visible = false;
        offBtn.x = -1000;
        onBtn.x = onBtn.originX
    });

    onBtn.bind("MouseDown", function(e) {
        console.log("on btn clicked");
        setAudioIsMuted(true)
        offBtn.visible = true;
        onBtn.visible = false;
        offBtn.x = offBtn.originX
        onBtn.x = -1000;
    });
    
    resumeBtn.bind("MouseDown", function(e) {
          console.log("resume button clicked, so resume the game ")
           this.unbind('Click', this.resumeBtn);
           if(list != undefined) {
                hideImages(list, true);
           }
          deleteImages([bg,resumeBtn,onBtn,offBtn,helpBtn, mainMenuBtn]);

        setTimeout(function(e) {
            setGameUnPaused();
          },100);
    
    });

   

    helpBtn.bind("MouseDown", function(e) {
         console.log('HELP BUTTON CLICKED');
         createHelpScreen();
    })

    mainMenuBtn.bind("MouseDown", function(e) {
        console.log('LEAVE GAME BUTTON CLICKED');
        Crafty.scene('GameMenu');
    })
    

}


