var storageSupported = (function() {
	try {
		localStorage.setItem('test', 'test');
		localStorage.removeItem('test');
		return true;
	} catch(e) {
		return false;
	}
})();

function create_node(type, parent) {
	var new_node = document.createElement(type);
	parent.appendChild(new_node);
	return new_node;
}

function clear_element(element) {
	while (element.lastChild)
		element.removeChild(element.lastChild);
}

function change_element_text(elem, text) {
	var text_node = document.createTextNode(text);
	clear_element(elem);
	elem.appendChild(text_node);
}

var fg = new Object();

var scheme_val = 0;

var size_val = 1;
var n_rows;
var n_cols;
var size_text="";
var max_moves;
var sizecls;

var shape_val = 0;

var spaced = 0;

var game_table;
var moves;
var finished;
var wins = 0, losses = 0;

function init() {
	fg.homecontent = document.getElementById("homecontent");
	fg.optionscontent = document.getElementById("optionscontent");
	fg.statscontent = document.getElementById("statscontent");
	fg.helpcontent = document.getElementById("helpcontent");
	fg.gamecontent = document.getElementById("gamecontent");
	fg.msgbox = document.getElementById("msgbox");
	fg.msgtext = document.getElementById("msgtext");
	fg.gametable = document.getElementById("gametable");
	fg.size = document.getElementById("size");
	fg.movecount = document.getElementById("moves");
	fg.maxmoves = document.getElementById("maxmoves");
	fg.gamesize = document.getElementById("gamesize");
	fg.gameswon = document.getElementById("gameswon");
	fg.totalgames = document.getElementById("totalgames");
	fg.percentage = document.getElementById("percentage");
	
	init_options();
	init_stats();
}

function init_options() {
	var i = 0,
		schemevals = document.getElementsByName('schemeopt'),
		sizevals = document.getElementsByName('sizeopt'),
		shapevals = document.getElementsByName('shapeopt'),
		spacevals = document.getElementsByName('spaceopt');
	
	if (storageSupported) {
		if (localStorage.getItem('colorscheme'))
			scheme_val = parseInt(localStorage.getItem('colorscheme'));
		else
			localStorage.setItem('colorscheme', scheme_val);
		
		if (localStorage.getItem('boardsize'))
			size_val = parseInt(localStorage.getItem('boardsize'));
		else
			localStorage.setItem('boardsize', size_val);
		
		if (localStorage.getItem('cellshape'))
			shape_val = parseInt(localStorage.getItem('cellshape'));
		else
			localStorage.setItem('cellshape', shape_val);
		
		if (localStorage.getItem('spacing'))
			spaced = parseInt(localStorage.getItem('spacing'));
		else
			localStorage.setItem('spacing', spaced);
	}
	
	for (i = 0; i < schemevals.length; i++) {
		if (parseInt(schemevals[i].value) === scheme_val) {
			schemevals[i].checked = true;
			document.getElementById('schemevalue').innerHTML = '<img src="' + ['schmone','schmtwo','schmthree','schmfour'][i] + '.png" />';
		}
	}
	
	for (i = 0; i < sizevals.length; i++) {
		if (parseInt(sizevals[i].value) === size_val) {
			sizevals[i].checked = true;
			document.getElementById('sizevalue').innerHTML = ['Tiny','Small','Medium','Large','Huge'][i];
		}
	}
	
	for (i = 0; i < shapevals.length; i++) {
		if (parseInt(shapevals[i].value) === shape_val) {
			shapevals[i].checked = true;
			document.getElementById('shapevalue').innerHTML = ['Square','Circle'][i];
		}
	}
	
	for (i = 0; i < spacevals.length; i++) {
		if (parseInt(spacevals[i].value) === spaced) {
			spacevals[i].checked = true;
			document.getElementById('spacevalue').innerHTML = ['Yes','No'][i];
		}
	}
	
	set_board_size_vals();
	set_scheme_button_vals();
}

function init_stats() {
	var i = 0, stats = [], nwon = 0, nlost = 0;
	for (i = 0; i < 5; i++) {
		if (storageSupported) {
			if (localStorage.getItem("stats"+i)) {
				stats = localStorage.getItem("stats"+i).split(",");
			}
			else {
				localStorage.setItem("stats"+i, "0,0");
				stats = "0,0".split(",");
			}
		}
		else {
			stats = "0,0".split(",");
		}
		
		nwon = parseInt(stats[0]);
		nlost = parseInt(stats[1]);
		document.getElementById("won"+i).innerHTML = nwon;
		document.getElementById("lost"+i).innerHTML = nlost;
		document.getElementById("total"+i).innerHTML = nwon + nlost;
		document.getElementById("percent"+i).innerHTML = ((nwon + nlost) ? Math.floor((nwon * 100) / (nwon + nlost)) : 0) + "%";
	}
	
	init_current_board_stats();
}

function init_current_board_stats() {
	var stats = [];
	if (storageSupported) {
		if (localStorage.getItem("stats"+size_val)) {
			stats = localStorage.getItem("stats"+size_val).split(",");
		}
		else {
			localStorage.setItem("stats"+size_val, "0,0");
			stats = "0,0".split(",");
		}
	}
	else {
		stats = "0,0".split(",");
	}
	
	wins = parseInt(stats[0]);
	losses = parseInt(stats[1]);
}

function update_current_board_stats() {
	if (storageSupported) {
		localStorage.setItem("stats"+size_val, wins+","+losses);
	}
	
	document.getElementById("won"+size_val).innerHTML = wins;
	document.getElementById("lost"+size_val).innerHTML = losses;
	document.getElementById("total"+size_val).innerHTML = wins+losses;
	document.getElementById("percent"+size_val).innerHTML = ((wins+losses) ? Math.floor((wins * 100) / (wins+losses)) : 0) + "%";
}

function reset_all_stats() {
	var i = 0;
	if (confirm('Are you sure you want to do this?\n\nThis will clear the stats for all board sizes.')) {
		for (i = 0; i < 5; i++) {
			if (storageSupported) {
				localStorage.setItem("stats"+i, "0,0");
			}
			
			document.getElementById("won"+i).innerHTML = 0;
			document.getElementById("lost"+i).innerHTML = 0;
			document.getElementById("total"+i).innerHTML = 0;
			document.getElementById("percent"+i).innerHTML = "0%";
		}
		
		wins = 0;
		losses = 0;
	}
}

function set_board_size_vals() {
	if (size_val === 0) {
		n_rows = 5;
		n_cols = 5;
		max_moves = 10;
		size_text = "Tiny";
		sizecls = "cellt";
		if (spaced)
			fg.gametable.className = "gametbl spacedt";
		else
			fg.gametable.className = "gametbl";
	} else if (size_val === 1) {
		n_rows = 7;
		n_cols = 7;
		max_moves = 13;
		size_text = "Small";
		sizecls = "cells";
		if (spaced)
			fg.gametable.className = "gametbl spaceds";
		else
			fg.gametable.className = "gametbl";
	} else if (size_val === 2) {
		n_rows = 10;
		n_cols = 10;
		max_moves = 20;
		size_text = "Medium";
		sizecls = "cellm";
		if (spaced)
			fg.gametable.className = "gametbl spacedm";
		else
			fg.gametable.className = "gametbl";
	} else if (size_val === 3) {
		n_rows = 14;
		n_cols = 14;
		max_moves = 25;
		size_text = "Large";
		sizecls = "celll";
		if (spaced)
			fg.gametable.className = "gametbl spacedl";
		else
			fg.gametable.className = "gametbl";
	} else {
		n_rows = 20;
		n_cols = 20;
		max_moves = 36;
		size_text = "Huge";
		sizecls = "cellh";
		if (spaced)
			fg.gametable.className = "gametbl spacedh";
		else
			fg.gametable.className = "gametbl";
	}
}

function toggle_list(listHeaderId, listId, listValId) {
	var listheader = document.getElementById(listHeaderId), list = document.getElementById(listId), listVal = document.getElementById(listValId);
	if (list.style.display === 'none') {
		listVal.style.display = 'none';
		list.style.display = 'block';
		listheader.className = 'optionlistheader open';
	}
	else {
		listVal.style.display = 'block';
		list.style.display = 'none';
		listheader.className = 'optionlistheader';
	}
}

function set_scheme(val, listValId, listItemId) {
	if (document.getElementById(listItemId).checked) {
		scheme_val = val;
		document.getElementById(listValId).innerHTML = '<img src="' + listItemId + '.png" />';
		
		set_scheme_button_vals();
		
		if (storageSupported)
			localStorage.setItem('colorscheme', scheme_val);
	}
}

function set_scheme_button_vals() {
	var i = 0;
	
	for (i = 0; i < 6; i++)
		document.getElementById('clrbtn' + i).className = "color clr" + scheme_val + "" + i;
}

function set_size(val, listValId, optionVal, listItemId) {
	if (document.getElementById(listItemId).checked) {
		size_val = val;
		document.getElementById(listValId).innerHTML = optionVal;
		
		set_board_size_vals();
		init_current_board_stats();
		
		if (storageSupported)
			localStorage.setItem('boardsize', size_val);
	}
}

function set_shape(val, listValId, optionVal, listItemId) {
	if (document.getElementById(listItemId).checked) {
		shape_val = val;
		document.getElementById(listValId).innerHTML = optionVal;
		
		if (storageSupported)
			localStorage.setItem('cellshape', shape_val);
	}
}

function set_space(val, listValId, optionVal, listItemId) {
	if (document.getElementById(listItemId).checked) {
		spaced = val;
		document.getElementById(listValId).innerHTML = optionVal;
		
		set_board_size_vals();
		
		if (storageSupported)
			localStorage.setItem('spacing', spaced);
	}
}

function show_result(msg, won, lost) {
	change_element_text(fg.msgtext, msg);
	change_element_text(fg.gamesize, size_text);
	change_element_text(fg.gameswon, won);
	change_element_text(fg.totalgames, won + lost);
	change_element_text(fg.percentage, (won + lost) ? Math.floor((won * 100) / (won + lost)) : 0);
	fg.msgbox.className = "msg";
}

function hide_result() {
    clear_element(fg.msgtext);
	fg.msgbox.className = "hide";
}

function flood_element(row, col, color) {
	game_table[row][col].color = color;
	game_table[row][col].element.className = sizecls + " " + "shape" + shape_val + " " + color;
}

function test_color_flood(row, col, color) {
	if (game_table[row][col].flooded)
		return;
	if (game_table[row][col].color == color) {
		game_table[row][col].flooded = true;
		flood_neighbours(row, col, color);
	}
}

function flood_neighbours(row, col, color) {
	if (row < n_rows - 1)
		test_color_flood(row + 1, col, color);
	if (row > 0)
		test_color_flood(row - 1, col, color);
	if (col < n_cols - 1)
		test_color_flood(row, col + 1, color);
	if (col > 0)
		test_color_flood(row, col - 1, color);
}

function all_flooded() {
	for (var row = 0; row < n_rows; row++) {
		for (var col = 0; col < n_cols; col++) {
			if (!game_table[row][col].flooded) {
				return false;
			}
		}
	}
	return true;
}

function flood(colorval, initial) {
	if (finished)
		return;
	
	var color = "clr" + scheme_val + "" + colorval;
	var old_color = game_table[0][0].color;
	if (!initial && color == old_color)
		return;
	
	moves++;
	change_element_text(fg.movecount, moves);
	for (var row = 0; row < n_rows; row++)
		for (var col = 0; col < n_cols; col++)
			if (game_table[row][col].flooded)
				flood_element(row, col, color);
	
	for (var row = 0; row < n_rows; row++)
		for (var col = 0; col < n_cols; col++)
			if (game_table[row][col].flooded)
				flood_neighbours(row, col, color);
	
	if (all_flooded()) {
		finished = true;
		wins++;
		update_current_board_stats();
		setTimeout(show_result, 600, "You win! You filled the board in " + moves + " steps.", wins, losses);
	} else if (moves === max_moves) {
		finished = true;
		losses++;
		update_current_board_stats();
		setTimeout(show_result, 400, "You lost!", wins, losses);
	}
}

function create_table() {
	moves = -1;
	finished = false;
	for (var row = 0; row < n_rows; row++) {
		var tr = create_node("tr", fg.gametable);
		for (var col = 0; col < n_cols; col++) {
			var td = create_node("td", tr);
			var color = "clr" + scheme_val + "" + Math.floor(Math.random() * 6);
			td.className = sizecls + " " + "shape" + shape_val + " " + color;
			game_table[row][col].color = color;
			game_table[row][col].element = td;
			game_table[row][col].flooded = false;
		}
	}
	game_table[0][0].flooded = true;
	flood(game_table[0][0].color.substr(-1), true);
	change_element_text(fg.size, size_text);
	change_element_text(fg.maxmoves, max_moves);
}

function new_game() {
	hide_result();
    clear_element(fg.gametable);
    create_table();
}
