function simpleObjInspect(oObj, key, tabLvl) {
	key = key || "";
	tabLvl = tabLvl || 1;
	var tabs = "";
	for (var i = 1; i < tabLvl; i++) {
		tabs += "\t";
	}
	var keyTypeStr = " (" + typeof key + ")";
	if (tabLvl == 1) {
		keyTypeStr = "(self)";
	}
	var s = tabs + key + keyTypeStr + " : ";
	if ( typeof oObj == "object" && oObj !== null) {
		s += typeof oObj + "\n";
		for (var k in oObj) {
			if (oObj.hasOwnProperty(k)) {
				s += simpleObjInspect(oObj[k], k, tabLvl + 1);
			}
		}
	} else {
		s += "" + oObj + " (" + typeof oObj + ") \n";
	}
	return s;
}

function findItemById(arr, id) {
	for (var item in arr) {
		if (arr[item].id == id)
			return arr[item];
		//console.log("item.id == id" + arr[item].id + " " + id);
	}
	return null;
}

function timeConverter(UNIX_timestamp) {
	var a = new Date(UNIX_timestamp * 1000);
	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
	var year = a.getFullYear();
	var month = months[a.getMonth()];
	var date = a.getDate();
	var hour = padLeft(a.getHours(), 2);
	var min = padLeft(a.getMinutes(), 2);
	var sec = padLeft(a.getSeconds(), 2);
	var time = date + '. ' + month + ' ' + year + ' ' + hour + ':' + min + ':' + sec;
	return time;
}

function padLeft(nr, n, str) {
	return Array(n - String(nr).length + 1).join(str || '0') + nr;
}

function saveUserdata(data) {

}

function toFixed(value, precision) {
	var power = Math.pow(10, precision || 0);
	return String(Math.round(value * power) / power);
}

function getUserData() {
	var data = new Object;
	data.compName = '111';
	data.userName = '222';
	data.surName = '333';
	data.streetName = '444';
	data.streetNo = '555';
	data.floorNo = '666';
	data.zipCode = '777';
	data.city = '888';
	data.phoneNo = '999';
	data.comments = '000';
	data.mail = '101010';
	return data
}

function validateEmail(email) {
	var pattern = new RegExp(/^(("[\w-+\s]+")|([\w-+]+(?:\.[\w-+]+)*)|("[\w-+\s]+")([\w-+]+(?:\.[\w-+]+)*))(@((?:[\w-+]+\.)*\w[\w-+]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][\d]\.|1[\d]{2}\.|[\d]{1,2}\.))((25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\.){2}(25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\]?$)/i);
	return pattern.test(email);
}

function validateSimpleString(string) {
	return (string.length > 1);
}

function validateSimpleNumber(number) {
	if (number.length == 0) {
		return false;
	}
	var result = number * 1.0;
	return (result != undefined && result != null );
}

function round(value) {
	var tmp = value * 20;
	tmp = Math.round(tmp);
	return tmp / 20;
}

function successMessage(name, phone) {
	var message = "Order successfully sent. Thank you for your order.\nIf you have any questions to {0} please call {1}";
	return message.format(name, phone);
}

function failMessage(result) {
	var doc = $(result);
	var res = doc[1].children[1].innerText;
	return "Error: " + res;
}

function defineLang(lng) {
	//alert("lang is" + lng);
	if (lng == "en") {
		return English;
	}
	if (lng == "fr") {
		return Franch;
	}
	if (lng == "de") {
		//alert(Deutsche.app_name);
		return Deutsche;
	}
}

function applyLang() {

	//} catch(e){
	//	alert("error!" + e);
	//}
	document.getElementById("currentLocationButton").innerText = Storage.lang.current_location;
	document.getElementById("zipCodeButton").innerText = Storage.lang.zip_code;
	document.getElementById("savedAddressButton").innerText = Storage.lang.saved_addresses;
	document.getElementById("menuH1").innerText = Storage.lang.menu;
	document.getElementById("toRest").innerText = Storage.lang.title_activity_restaurants;
	document.getElementById("toCart").innerText = Storage.lang.next;
	document.getElementById("menuH2").innerText = Storage.lang.menu;
	document.getElementById("toMenu").innerText = Storage.lang.back;
	document.getElementById("nextButton").innerText = Storage.lang.next;
	document.getElementById("zipNotFound").innerText = Storage.lang.error_getting_zip_code;
	document.getElementById("recomendViaTitle").innerText = Storage.lang.recomend_via;
	document.getElementById("backRestaurants").innerText = Storage.lang.back;
	document.getElementById("restaurantsH2").innerText = Storage.lang.title_activity_restaurants;
	document.getElementById("backSavedAddress").innerText = Storage.lang.back;
	document.getElementById("savedAddressTitle").innerText = Storage.lang.saved_addresses;
	document.getElementById("editSavedAddressButton").innerText = Storage.lang.edit;
	document.getElementById("conditionsBackButton").innerText = Storage.lang.back;
	document.getElementById("conditionsOfUseTitle").innerText = Storage.lang.conditions_of_use;
	document.getElementById("conditionsOfUseH1").innerText = Storage.lang.conditions_of_use;
	document.getElementById("orderTitle").innerText = Storage.lang.order;
	document.getElementById("tomenu").innerText = Storage.lang.back;
	document.getElementById("cont").innerText = Storage.lang.next;
	document.getElementById("deleteButton").innerText = Storage.lang.delete_;
	document.getElementById("deliveryColsLabel").innerText = Storage.lang.delivery_cost;
	document.getElementById("surchargeLabel").innerText = Storage.lang.card_surcharge + "(3%)";
	document.getElementById("totalLabel").innerText = Storage.lang.total;
	document.getElementById("paymentTypeLabel").innerText = Storage.lang.i_wish_to_pay;
	document.getElementById("voucherLabel").innerText = Storage.lang.cupon_code;
	document.getElementById("deliveryTimeLabel").innerText = Storage.lang.delivery_time;
	document.getElementById("userInfo").innerText = Storage.lang.user_info;
	document.getElementById("userInfoBack").innerText = Storage.lang.back;
	document.getElementById("orderbutton").innerText = Storage.lang.next;
	document.getElementById("orderDetailsTitle").innerText = Storage.lang.pls_enter_order_details;
	document.getElementById("companyLabel").innerText = Storage.lang.company;
	document.getElementById("nameLabel").innerText = Storage.lang.name;
	document.getElementById("lastNameLabel").innerText = Storage.lang.surname;
	document.getElementById("streetLabel").innerText = Storage.lang.street;
	document.getElementById("noLabel").innerText = Storage.lang.no;
	document.getElementById("floorLabel").innerText = Storage.lang.floor;
	document.getElementById("zipCodeLabel").innerText = Storage.lang.zip_code;
	document.getElementById("cityLabel").innerText = Storage.lang.city;
	document.getElementById("phoneNoLabel").innerText = Storage.lang.phone_no;
	document.getElementById("commentsLabel").innerText = Storage.lang.comments;
	document.getElementById("emailLabel").innerText = Storage.lang.email;
	document.getElementById("conditionsOfUseLabel").innerText = Storage.lang.conditions_of_use;
	document.getElementById("registerMeLabel").innerText = Storage.lang.register_me;
	document.getElementById("yes").innerText = Storage.lang.yes;
	document.getElementById("no").innerText = Storage.lang.no_question;
	document.getElementById("yourEmailLogin").innerText = Storage.lang.your_email_will_be_your_login;
	document.getElementById("passwordLabel").innerText = Storage.lang.password;
	document.getElementById("summaryTitle").innerText = Storage.lang.summary;
	document.getElementById("toUserReg").innerText = Storage.lang.user_info;
	document.getElementById("toSubmit").innerText = Storage.lang.submit;
	document.getElementById("totalCostWarning").innerText = Storage.lang.order_is_less_than;
	document.getElementById("repeatePasswordLabel").innerText = Storage.lang.repeate_password;
	document.getElementById("nextButton").innerText = Storage.lang.done;
	document.getElementById("orderbutton").innerText = Storage.lang.done;
	document.getElementById("slogan").innerText = Storage.lang.where_can_we_deliver;

}

