function Order()  { "use strict"

    this.items = new Array();
	this.paymentType = 0;
    
	this.setDetails = function(company, name, vorname, strasse, nr, floor_nr, plz, ort, email, DOB_day, DOB_month, DOB_year, phone, special_instructions, user_id, deliv_check, future_time, deliv_cost, id) {
		this.company     = company;
        this.name        = name;
        this.vorname     = vorname;
        this.strasse     = strasse;
        this.nr          = nr;
        this.floor_nr    = floor_nr;
        this.plz         = plz;
        this.ort         = ort;
        this.email       = email;
        this.DOB_day     = DOB_day;
        this.DOB_month   = DOB_month;
        this.DOB_year    = DOB_year;
        this.phone       = phone;
        this.special_instructions = special_instructions;
        this.user_id     = user_id;
        this.deliv_check = deliv_check;
        this.future_time = future_time;
        this.deliv_cost  = deliv_cost;
        this.id          = id;
        this.order_from  = 'HTML5';
	}
    this.add = function (item, qnty, priceId, extraIds) {
        var price = findItemById(item.itemPrices, priceId);
        var newItem = {'id':price.id, 
                        'item_number': item.id,
                        'price':price.itemPriceDeliver,
                        'price_desc':price.item_price_desc,
                        'name':item.itemTitle,
                        'qnty':qnty,
                        'total':price.itemPriceDeliver * qnty};
        
       var itemsExra = new Array();
       for(var extraIdIndx in extraIds) {
          var extra = findItemById(item.itemExtras, extraIds[extraIdIndx]);
           var newExtra = {'name':extra.itemExtraName, 
                        'extra_price': extra.itemExtraPrice};
           itemsExra.push(newExtra);
        }
        newItem.extras = itemsExra;
        this.items.push(newItem);
        
        
    }
	
	this.removeItemAt = function (itemIndex) {
		this.items.splice(itemIndex,1);
	}

    this.getItems = function () {
        return this.items;
    }
	
	 this.clearItems = function () {
        for(; this.items.length > 0;){
			this.items.splice(0,1);
		}
    }
	
	this.getCost = function () {
		var sum = 0;
        for(var i = 0; i < this.items.length; i++){
			sum += this.items[i].price/1.0;
			for(var j = 0; j < this.items[i].extras.length; j++){
				sum += this.items[i].extras[j].extra_price/1.0;
			}
		}
		return sum;
    }
    
    this.buildObjectsArray = function () {
		var result = {};
		for(var i = 0; i < this.items.length; i++){
			var curItem = {};
			curItem.id = this.items[i].id;
			curItem.item_number = this.items[i].price;
			curItem.name = this.items[i].name;
			curItem.qnty = this.items[i].qnty;
			curItem.total = this.items[i].total;
		}
    }
        
};
