function parseTime(restaurant){
	if(!(restaurant.current_delivery_hrs) || restaurant.current_delivery_hrs == ''){
		var time = [];
	}else{
		var time = restaurant.current_delivery_hrs.split(", ");
	}
	for(var i = 0; i < time.length; i++){
		restaurant.workTime[i] = {};
		restaurant.workTime[i]['from'] = time[i].split(" bis ")[0];
		restaurant.workTime[i]['to'] = time[i].split(" bis ")[1];
		if(!(restaurant.workTime[i]['from']) || restaurant.workTime[i]['from'] == ''){
			restaurant.workTime[i]['from'] ='00:00';
		}
		if(!(restaurant.workTime[i]['to']) || restaurant.workTime[i]['to'] == ''){
			restaurant.workTime[i]['to'] ='00:00';
		}
	}
}

function Restaurant(xml) {
	this.id = xml.attr('id');
    this.picture = xml.children('picture').text();
	this.title = decodeURIComponent(xml.children('title').text());
	this.address = decodeURIComponent(xml.children('address').text());
	this.phone = xml.children('phone').text();
	this.description = xml.children('description').text();
	this.current_delivery_hrs = xml.children('current_delivery_hrs').text();
	this.delivery_only = xml.children('delivery_only').text();
	this.offer_delivery = xml.children('offer_delivery').text();
	this.current_opening_hrs = xml.children('current_opening_hrs').text();
	this.min_order_value = xml.children('min_order_value').text();
	this.card_payment_option = ((xml.children('card_payment_option').text() * 1.0) == 1);
	this.workTime = [];
	if(this.min_order_value == ''){
		this.min_order_value = '0.00'
	
	}
	this.delivery_charge = xml.children('delivery_charge').text();
	if(this.delivery_charge == ''){
		this.delivery_charge = '0.00'
	
	}
	this.delivery_time = xml.children('delivery_time').text();

	this.preparation_time = xml.children('preparation_time').text();
	
	parseTime(this);
	this.current_delivery_hrs = this.current_delivery_hrs.replace(/,/g,"<br>");
	this.isOpened = false;
	var date = new Date();
	var curTime = date.getHours() + date.getMinutes()/60.0;
	//console.log(curTime);
	for(var i = 0; i < this.workTime.length; i++){
		var fromTime = this.workTime[i]['from'].substr(0,2)/1 + this.workTime[i]['from'].substr(3,2)/60.0;
		var toTime = this.workTime[i]['to'].substr(0,2)/1 + this.workTime[i]['to'].substr(3,2)/60.0;
		if(toTime < fromTime){
			toTime += 24;
		}
		if(curTime <= toTime && curTime >= fromTime){
			this.isOpened = true;
			break;
		}
		
	}
};



Restaurant.prototype.toString = function() {
    return "Title:" + this.title;
};

/*
Restaurant.prototype.play = function(song) {
  this.currentlyPlayingSong = song;
  this.isPlaying = true;
};
*/
