
var WeatherForecast = {
  ipInfoKey: '52f9fdb0072cb9054b23256938dc051730bdd9dc37461689a1ab3d8031243813',
  pulseWaitId: 0,
  gpsLockId: 0,
  unit: 'C',
  
  init: function () {
    if (localStorage.units == undefined) localStorage.units = 'metric';
    
    switch (localStorage.units) {
      case 'metric':
        WeatherForecast.unit = 'C';
        break;
      case 'imperial':
        WeatherForecast.unit = 'F';
        break;
      default:
        WeatherForecast.unit = 'K';
    };
    
    WeatherForecast.requestIpInfo();
  },
  
  startPulse: function () {
    WeatherForecast.pulseWaitId = setInterval(function () {
      $('body').animate({ backgroundColor: '#486bb6' },1000,function () { $('body').animate({ backgroundColor: '#4499ff' },1000) });
    },2000);
  },
  
  stopPulse: function () {
    if (WeatherForecast.pulseWaitId) {
      clearInterval(WeatherForecast.pulseWaitId);
      WeatherForecast.pulseWaitId = 0;
    }
  },
  
  requestIpInfo: function () {
    $.ajax({
      url: Mustache.render(
        'http://api.ipinfodb.com/v3/ip-city/?key={{apikey}}&format=json&callback=WeatherForecast.ipiCallback',
        { apikey: WeatherForecast.ipInfoKey }
      ),
      jsonp : false,
      jsonpCallback: 'WeatherForecast.ipiCallback',
      dataType : 'jsonp'
    });
  },
  
  ipiCallback: function (position) {
    WeatherForecast.gpsCallback({
      coords: {
        latitude: position.latitude,
        longitude: position.longitude
      } 
    });

    WeatherForecast.requestGps();
  },
  
  requestGps: function () {
    if ("geolocation" in navigator) {
      WeatherForecast.gpsLockId = navigator.geolocation.getCurrentPosition(WeatherForecast.gpsCallback);
    }
  },
      
  gpsCallback: function (position) {
    var request = {
      lat: position.coords.latitude,
      lon: position.coords.longitude,
      units: localStorage.units
    };
    
    $.ajax({
      url: Mustache.render(
        'http://api.openweathermap.org/data/2.5/weather?lat={{lat}}&lon={{lon}}&units={{units}}&callback=WeatherForecast.owmCallback',
        request
      ),
      jsonp : false,
      jsonpCallback: 'WeatherForecast.owmCallback',
      dataType : 'jsonp'
    });

    $.ajax({
      url: Mustache.render(
        'http://api.openweathermap.org/data/2.5/forecast?lat={{lat}}&lon={{lon}}&units={{units}}&callback=WeatherForecast.owmForecastCallback',
        request
      ),
      jsonp : false,
      jsonpCallback: 'WeatherForecast.owmForecastCallback',
      dataType : 'jsonp'
    });
  },
  
  releaseGps: function () {
    if (WeatherForecast.gpsLockId) navigator.geolocation.clearWatch(WeatherForecast.gpsLockId);
    WeatherForecast.gpsLockId = 0;
  },
  
  owmCallback: function (response) {
    if (!response.main) return;
    
    response.main.temp = Math.round(response.main.temp);
    response.weather = response.weather[0];
    response.unit = WeatherForecast.unit;
    
    var curConditions = FontConditions.decode(response);
    
    $('hr').show();
    
    $('.animate').removeClass('animate');
    $('#symbol').text(curConditions.weather.symbol.code);
    $('body').animate({ backgroundColor: curConditions.weather.symbol.color });
    $('#desc').text(curConditions.weather.description);
    
    $('#deg').text(curConditions.main.temp);
    $('#unit').text('°' + WeatherForecast.unit);
    $('#location').text(curConditions.name);
  },
  
  owmForecastCallback: function (response) {
    if (!response.city) return;
    $('#forecast').empty();
    
    for (i in response.list) {
      response.list[i].main.temp = Math.round(response.list[i].main.temp);
      response.list[i].weather = response.list[i].weather[0];
      response.list[i].unit = WeatherForecast.unit;
      
      var hour = new Date(response.list[i].dt * 1000);
          hour = hour.getHours();
      
      response.list[i].dt_hour = hour + ':00';
      response.list[i] = FontConditions.decode(response.list[i]);
      
      if (i > 0 && i < 6) {
        $('#forecast').append(
          Mustache.render(
            '<div class="item"><div class="pictogram">{{weather.symbol.code}}</div><div class="timestamp">{{main.temp}}°{{unit}}<br />{{dt_hour}}</div>',
            response.list[i]
          )
        );
      }
    }
  },

  onUnitChange: function () {
    if (localStorage.units == 'imperial') localStorage.units = 'metric';
    else localStorage.units = 'imperial';
    
    $('#unit').html('°&ndash;');
    WeatherForecast.init();
  },
  
  onResume: function () {
    if (!document.mozHidden) {
      WeatherForecast.init();
    }
    else if (WeatherForecast.gpsLockId) {
      WeatherForecast.releaseGps();
    }
  },
};

var FontConditions = {
  
  decode: function (item) {
    var symbol = FontConditions[item.weather.id];
    var isDay = item.weather.icon.match(/d$/) ? true : false;
    
    if (item.weather.id >= 800 && item.weather.id <= 804 && "d" in symbol) {
      if (isDay) symbol = symbol.d;
      else symbol = symbol.n;
    }
    
    item.weather.symbol = symbol;
    
    if (item.weather.id >= 200 && item.weather.id <= 232) {
      item.weather.description = 'thunderstorm';
    }
    if (item.weather.id >= 300 && item.weather.id <= 321) {
      item.weather.description = 'drizzle';
    }
    if (item.weather.id >= 500 && item.weather.id <= 522) {
      item.weather.description = item.weather.description.replace(/intensity shower /,'');
      item.weather.description = item.weather.description.replace(/intensity /,'');
    }
    
    return item;
  },
  
  200: { code: 'O', color: 'rgb(85,74,130)' }, // thunderstorm with light rain
  201: { code: 'O', color: 'rgb(80,60,105)' }, // thunderstorm with rain
  202: { code: '6', color: 'rgb(56,46,80)' }, // thunderstorm with heavy rain
  210: { code: 'O', color: 'rgb(85,74,130)' }, // light thunderstorm
  211: { code: '6', color: 'rgb(80,60,105)' }, // thunderstorm
  212: { code: '&', color: 'rgb(56,46,80)' }, // heavy thunderstorm
  221: { code: '&', color: 'rgb(56,46,80)' }, // ragged thunderstorm
  230: { code: '6', color: 'rgb(85,74,130)' }, // thunderstorm with light drizzle
  231: { code: '6', color: 'rgb(80,60,105)' }, // thunderstorm with drizzle
  232: { code: '&', color: 'rgb(56,46,80)' }, // thunderstorm with heavy drizzle

  300: { code: 'Q', color: 'rgb(160,160,190)' }, // light intensity drizzle
  301: { code: 'Q', color: 'rgb(130,130,160)' }, // drizzle
  302: { code: 'R', color: 'rgb(100,100,130)' }, // heavy intensity drizzle
  310: { code: 'R', color: 'rgb(160,160,190)' }, // light intensity drizzle rain
  311: { code: 'R', color: 'rgb(130,130,160)' }, // drizzle rain
  312: { code: '8', color: 'rgb(100,100,130)' }, // heavy intensity drizzle rain
  321: { code: '8', color: 'rgb(70,70,100)' }, // shower drizzle

  500: { code: 'Q', color: '#5c89e5' }, // light rain
  501: { code: 'R', color: '#3d5c99' }, // moderate rain
  502: { code: '8', color: '#293d66' }, // heavy intensity rain
  503: { code: '8', color: '#141f33' }, // very heavy rain
  504: { code: '8', color: '#141f33' }, // extreme rain
  511: { code: '#', color: '#8ea6b2' }, // freezing rain
  520: { code: '8', color: '#478db2' }, // light intensity shower rain
  521: { code: '8', color: '#336680' }, // shower rain
  522: { code: '8', color: '#1f3d4d' }, // heavy intensity shower rain

  600: { code: 'V', color: '#86adc0' }, // light snow
  601: { code: 'X', color: '#86adc0' }, // snow
  602: { code: '$', color: '#627e8c' }, // heavy snow
  611: { code: '$', color: '#3e5059' }, // sleet
  621: { code: '#', color: '#3e5059' }, // shower snow

  701: { code: 'M', color: '#a3c6d8' }, // mist
  711: { code: '%', color: '#dbdbdb' }, // smoke
  721: { code: 'J', color: '#f2ddb4' }, // haze
  731: { code: 'E', color: '#e6bf73' }, // Sand/Dust Whirls
  741: { code: 'L', color: '#b7c5cc' }, // Fog
  
  800: { d: { code: '1', color: '#4499ff' }, n: { code: '2', color: '#173254' } }, // sky is clear
  801: { d: { code: 'B', color: '#2299cc' }, n: { code: '2', color: '#384554' } }, // few clouds
  802: { d: { code: 'H', color: '#bbbbbb' }, n: { code: 'I', color: '#545454' } }, // scattered clouds
  803: { d: { code: '3', color: '#bbbbbb' }, n: { code: '4', color: '#545454' } }, // broken clouds
  804: { d: { code: '5', color: '#aaaaaa' }, n: { code: 'N', color: '#000000' } }, // overcast clouds
  
  900: { code: 'F', color: '#ff0000' }, // tornado
  901: { code: 'F', color: '#ff0000' }, // tropical storm
  902: { code: 'F', color: '#ff0000' }, // hurricane
  903: { code: 'G', color: 'rgb(120,187,255)' }, // cold
  904: { code: "'", color: '#cb0000' }, // hot
  905: { code: 'F', color: 'rgb(201,221,223)' }, // windy
  906: { code: 'F', color: 'rgb(76,110,147)' }  // hail
};

$(function () {
  document.addEventListener('mozvisibilitychange',WeatherForecast.onResume);
  $('#unit').click(WeatherForecast.onUnitChange);
  
  WeatherForecast.init();
});