/* global MozActivity, alert, console, Notification */"use strict";
(function(window, undefined) {
	// WebActivities

	var blob_img = null;

	var file_name = "";

	var server_ip = "http://50.20.79.109/fotocalle/";

	//var server_ip = "http://localhost/fotocalle/";

	var pickImage = document.querySelector("#pick-image");
	if (pickImage) {
		pickImage.onclick = function() {
			
			$("#img-loader_geo").show();

			$("#share-image").hide();

			var pick = new MozActivity({
				name : "pick",
				data : {
					type : ["image/png", "image/jpg", "image/jpeg"],
					nocrop : true // don't allow the user to crop the image
				}
			});

			pick.onsuccess = function() {

				var imagePresenter = document.querySelector("#image-presenter");

				imagePresenter.src = window.URL.createObjectURL(this.result.blob);

				var imagePresenter = new Image();
				imagePresenter.onload = function() {

					//imagePresenter.addEventListener("load", function() {

					var c = document.getElementById("myCanvas");

					var img = imagePresenter;

					c.width = imagePresenter.width;
					c.height = imagePresenter.height;
					var ctx = c.getContext("2d");

					ctx.drawImage(img, 0, 0);

					ctx.globalAlpha = 0.3;
					ctx.fillStyle = "#000000";
					ctx.fillRect(0, 0, imagePresenter.width, 90);
					ctx.globalAlpha = 1;
					ctx.fillStyle = "#FFFFFF";

					ctx.font = "20px Arial";
					ctx.fillText(ubicacion, 10, 20);

					ctx.font = "18px Arial";
					ctx.fillText(latLong, 10, 45);

					ctx.font = "20px Arial";
					ctx.fillText("#fotocalleVz @fotocallevz", 10, 65);

					ctx.font = "14px Arial";
					ctx.fillText(get_fecha(), 10, 80);
					
					
					

					// Export to blob and share through a Web Activitiy
					c.toBlob(function(blob) {

						var imageCompartir = document.querySelector("#image-compartir");

						imageCompartir.width = "300";
						imageCompartir.src = window.URL.createObjectURL(blob);

						imageCompartir.onload = function() {

							//recize_img(blob, imagePresenter);
							
							FileUpload(blob);

						};

					});

					//$("#img-loader_geo").show();$("#image-presenter").hide();

					$("#myCanvas").hide();

					//$("#myCanvas").show();

					$("#share-image").show();

					//}, false);
				};

				imagePresenter.src = window.URL.createObjectURL(this.result.blob);

			};

			pick.onerror = function() {
				console.log("Can't view the image");
				
				$("#img-loader_geo").hide();
			};
		};
	}

	var shareImage = document.querySelector("#share-image"), imgToShare = document.querySelector("#image-presenter");
	if (shareImage && imgToShare) {
		shareImage.onclick = function() {

			if (imgToShare.naturalWidth > 0) {
				//if(true) {
				// Create dummy canvas

				imgToShare.crossOrigin = "Anonymous";

				var blobCanvas = document.createElement("canvas");
				blobCanvas.width = imgToShare.width;
				blobCanvas.height = imgToShare.height;

				blobCanvas.crossOrigin = "Anonymous";

				// Get context and draw image
				var blobCanvasContext = blobCanvas.getContext("2d");
				blobCanvasContext.drawImage(document.querySelector("#myCanvas"), 0, 0);

				// Export to blob and share through a Web Activitiy
				
				if(longitude != 0 && latitude != 0){
					
					var mapsLink = '#FotoCalleVZ http://maps.google.com/?q=' + latitude+ ',' + longitude;
					
				}else{
					var mapsLink = '#FotoCalleVZ ';
				}
				
				blobCanvas.toBlob(function(blob) {
					new MozActivity({
						name : "share",
						data : {
							type : "image/*",
							number : 1,
							blobs : [blob],
							body : mapsLink, // for SMS
							url : mapsLink, // for emails,
						}
					});
				});
			} else {
				alert("Image failed to load, can't be shared");
			}
		};
	}

	function get_geolocation() {

		geolocationDisplay = document.querySelector("#geolocation-display");

		navigator.geolocation.getCurrentPosition(function(position) {
			geolocationDisplay.innerHTML = "<strong>Latitude:</strong> " + position.coords.latitude + ", <strong>Longitude:</strong> " + position.coords.longitude;
			geolocationDisplay.style.display = "block";

			ReverseGeocode(position.coords.latitude, position.coords.longitude);
		}, function() {
			geolocationDisplay.innerHTML = "Ubicación Desconocida";
			geolocationDisplay.style.display = "block";
		});
	}

	// Geolocation
	var geolocation = document.querySelector("#geolocation"), geolocationDisplay = document.querySelector("#geolocation-display");
	if (geolocation && geolocationDisplay) {
		geolocation.onclick = function() {
			navigator.geolocation.getCurrentPosition(function(position) {
				geolocationDisplay.innerHTML = "<strong>Latitude:</strong> " + position.coords.latitude + ", <strong>Longitude:</strong> " + position.coords.longitude;
				geolocationDisplay.style.display = "block";
			}, function() {
				geolocationDisplay.innerHTML = "Ubicación Desconocida";
				geolocationDisplay.style.display = "block";
			});
		};
	}

	// Device Orientation
	var deviceOrientation = document.querySelector("#device-orientation"), deviceOrientationDisplay = document.querySelector("#device-orientation-display");

	if (deviceOrientation && deviceOrientationDisplay) {
		deviceOrientation.onclick = function() {
			deviceOrientationDisplay.style.display = "block";
			window.ondeviceorientation = function(event) {
				var orientedTo = (event.beta > 45 && event.beta < 135) ? "top" : (event.beta < -45 && event.beta > -135) ? "bottom" : (event.gamma > 45) ? "right" : (event.gamma < -45) ? "left" : "flat";
				var orientation = "<strong>Absolute: </strong>" + event.absolute + "<br>" + "<strong>Alpha: </strong>" + event.alpha + "<br>" + "<strong>Beta: </strong>" + event.beta + "<br>" + "<strong>Gamma: </strong>" + event.gamma + "<br>" + "<strong>Device orientation: </strong>" + orientedTo;

				deviceOrientationDisplay.innerHTML = orientation;
			};
		};
	}

	// Log visibility of the app
	var logVisibility = document.querySelector("#log-visibility"), logVisibilityDisplay = document.querySelector("#log-visibility-display");
	if (logVisibility && logVisibilityDisplay) {
		logVisibility.onclick = function() {
			logVisibilityDisplay.style.display = "block";
			logVisibilityDisplay.innerHTML = "I have focus!<br>";
			document.addEventListener("visibilitychange", function() {
				if (document.hidden) {
					console.log("Firefox OS Boilerplate App is hidden");
					logVisibilityDisplay.innerHTML += "Now I'm in the background<br>";
				} else {
					console.log("Firefox OS Boilerplate App has focus");
					logVisibilityDisplay.innerHTML += "I have focus!<br>";
				}
			});
		};
	}

	function get_fecha() {

		var today = new Date();
		var dd = today.getDate();
		var mm = today.getMonth() + 1;
		//January is 0!

		var yyyy = today.getFullYear();
		if (dd < 10) {
			dd = '0' + dd;
		}
		if (mm < 10) {
			mm = '0' + mm;
		}
		return today = dd + '/' + mm + '/' + yyyy;
	}

	function FileUpload(base64Content) {

		var main = this;

		var formData = new FormData();
		
		$("#img-loader_geo").show();

		file_name = "img_" + Math.floor((Math.random() * 100000000) + 1) + ".jpg";

		//formData.append("file", base64Content);
		formData.append("filename", file_name);
		formData.append("latitude", latitude);
		formData.append("longitude", longitude);
		formData.append("timestamp", get_fecha());

		var xhr = new XMLHttpRequest({
			mozSystem : true
		});

		xhr.open("POST", server_ip + "uploadPhoto_fos_v12.php", true);
		xhr.onreadystatechange = function() {
			
			console.log("Subiendo...");

			if (xhr.readyState == 4) {

				console.log(xhr.responseText);
				
				$("#share-image").show();
				
				$("#img-loader_geo").hide();

			} else {

				console.log("FileUpload->en proceso... ", xhr.statusText);

			}
		};
		xhr.send(formData);
	};

	function recize_img(blob, imageCompartir) {

		var canvas = document.getElementById('myCanvas2');

		var width = (imageCompartir.width * 20) / 100;

		var height = (imageCompartir.height * 20) / 100;

		canvas.width = width;

		canvas.height = height;
		
		var ctx = canvas.getContext('2d');

		var img = new Image();

		img.addEventListener('load', function() {
			
			
			//new thumbnailer(canvas, this, 50, 1);
			
			ctx.drawImage(this, 0, 0, width, height);
			
			canvas.toBlob(function(blob) {

				FileUpload(blob);
			});

		});

		img.src = window.URL.createObjectURL(blob);
	}

	//returns a function that calculates lanczos weight
	function lanczosCreate(lobes) {
		return function(x) {
			if (x > lobes)
				return 0;
			x *= Math.PI;
			if (Math.abs(x) < 1e-16)
				return 1;
			var xx = x / lobes;
			return Math.sin(x) * Math.sin(xx) / x / xx;
		};
	}

	//elem: canvas element, img: image element, sx: scaled width, lobes: kernel radius
	function thumbnailer(elem, img, sx, lobes) {
		this.canvas = elem;
		elem.width = img.width;
		elem.height = img.height;
		elem.style.display = "none";
		this.ctx = elem.getContext("2d");
		this.ctx.drawImage(img, 0, 0);
		this.img = img;
		this.src = this.ctx.getImageData(0, 0, img.width, img.height);
		this.dest = {
			width : sx,
			height : Math.round(img.height * sx / img.width),
		};
		this.dest.data = new Array(this.dest.width * this.dest.height * 3);
		this.lanczos = lanczosCreate(lobes);
		this.ratio = img.width / sx;
		this.rcp_ratio = 2 / this.ratio;
		this.range2 = Math.ceil(this.ratio * lobes / 2);
		this.cacheLanc = {};
		this.center = {};
		this.icenter = {};
		setTimeout(this.process1, 0, this, 0);
	}


	thumbnailer.prototype.process1 = function(self, u) {
		self.center.x = (u + 0.5) * self.ratio;
		self.icenter.x = Math.floor(self.center.x);
		for (var v = 0; v < self.dest.height; v++) {
			self.center.y = (v + 0.5) * self.ratio;
			self.icenter.y = Math.floor(self.center.y);
			var a, r, g, b;
			a = r = g = b = 0;
			for (var i = self.icenter.x - self.range2; i <= self.icenter.x + self.range2; i++) {
				if (i < 0 || i >= self.src.width)
					continue;
				var f_x = Math.floor(1000 * Math.abs(i - self.center.x));
				if (!self.cacheLanc[f_x])
					self.cacheLanc[f_x] = {};
				for (var j = self.icenter.y - self.range2; j <= self.icenter.y + self.range2; j++) {
					if (j < 0 || j >= self.src.height)
						continue;
					var f_y = Math.floor(1000 * Math.abs(j - self.center.y));
					if (self.cacheLanc[f_x][f_y] == undefined)
						self.cacheLanc[f_x][f_y] = self.lanczos(Math.sqrt(Math.pow(f_x * self.rcp_ratio, 2) + Math.pow(f_y * self.rcp_ratio, 2)) / 1000);
					var weight = self.cacheLanc[f_x][f_y];
					if (weight > 0) {
						var idx = (j * self.src.width + i) * 4;
						a += weight;
						r += weight * self.src.data[idx];
						g += weight * self.src.data[idx + 1];
						b += weight * self.src.data[idx + 2];
					}
				}
			}
			var idx = (v * self.dest.width + u) * 3;
			self.dest.data[idx] = r / a;
			self.dest.data[idx + 1] = g / a;
			self.dest.data[idx + 2] = b / a;
		}

		if (++u < self.dest.width)
			setTimeout(self.process1, 0, self, u);
		else
			setTimeout(self.process2, 0, self);
	};
	thumbnailer.prototype.process2 = function(self) {
		self.canvas.width = self.dest.width;
		self.canvas.height = self.dest.height;
		self.ctx.drawImage(self.img, 0, 0);
		self.src = self.ctx.getImageData(0, 0, self.dest.width, self.dest.height);
		var idx, idx2;
		for (var i = 0; i < self.dest.width; i++) {
			for (var j = 0; j < self.dest.height; j++) {
				idx = (j * self.dest.width + i) * 3;
				idx2 = (j * self.dest.width + i) * 4;
				self.src.data[idx2] = self.dest.data[idx];
				self.src.data[idx2 + 1] = self.dest.data[idx + 1];
				self.src.data[idx2 + 2] = self.dest.data[idx + 2];
			}
		}
		self.ctx.putImageData(self.src, 0, 0);
		self.canvas.style.display = "block";
	};
})(window);

