//document.body.style.zoom="1000%"
var canvas = document.getElementById('sketch');
var ctx = canvas.getContext('2d');
canvas.width=window.innerWidth;
canvas.height=window.innerHeight;
h=canvas.height;
w=canvas.width;


ctx.fillStyle='#fff';	
ctx.fillRect(0,0,w,h);	
ctx.strokeStyle='#000'	
ctx.fillStyle='#000';


var mouse = {x: 0, y: 0};		
var last_mouse = {x: 0, y: 0};

canvas.addEventListener('mousemove', function(e) {	
	last_mouse.x = mouse.x;
	last_mouse.y = mouse.y;

	mouse.x = e.offsetX;//e.clientX - 10;
	mouse.y = e.offsetY;//e.clientY -10;
}, false);



var radius = 5;		
document.getElementById('rad').value=radius;

ctx.lineJoin = 'round';		
ctx.lineCap = 'round';

function aumenta(){
	radius=parseInt(document.getElementById('rad').value);
	if(radius<20){
		radius=radius+1;
		document.getElementById('rad').value=radius;
	}else{
		radius=radius+5;
		document.getElementById('rad').value=radius;
	}
}
function diminuisci(){
	radius=parseInt(document.getElementById('rad').value);
	if(radius>1){
		if(radius<20){
			radius= radius-1;
			document.getElementById('rad').value=radius;
		}else{
			radius = radius-5;
			document.getElementById('rad').value=radius;
		}
	}
}

function updateRad(){
	radius=parseInt(document.getElementById('rad').value);
	if (radius<1){
		radius=1
		parseInt(document.getElementById('rad').value)=1;
	}
}
canvas.addEventListener('mousedown', function(e) {		
	ctx.beginPath();
	ctx.arc(e.offsetX,e.offsetY,radius/2, 0, Math.PI*2);
	ctx.fill();
	console.log(radius);
	canvas.addEventListener('mousemove', draw, false);
}, false);

canvas.addEventListener('mouseup', function() {
	canvas.removeEventListener('mousemove', draw, false);
}, false);


var draw = function() {		

	ctx.lineWidth = radius;
	ctx.beginPath();
	ctx.moveTo(last_mouse.x, last_mouse.y);
	ctx.lineTo(mouse.x, mouse.y);
	ctx.closePath();
	ctx.stroke();
	
};

function clear(){		
	ctx.clearRect(0,0,w, h);
	ctx.fillStyle='#fff';
	ctx.fillRect(0,0,w,h);

}
document.getElementById('clear').addEventListener('click',clear);


function downloadCanvas(link, canvasId) {	
	var data = new Date();
	var n = data.getTime(); 
	var filename = "Fox-Sketch-"+n+".png";
    link.href = document.getElementById(canvasId).toDataURL('image/png');
    link.download = filename;
}

document.getElementById('download').addEventListener('click', function() {
    downloadCanvas(this, 'sketch');
}, false);




function erase(){		
	ctx.strokeStyle='#fff';
	ctx.fillStyle='#fff';
}


var arrayCanvas = new Array();	
var index = 0;
var dim = 20;	

arrayCanvas.push(canvas.toDataURL());	
	
canvas.addEventListener('mouseup', function() {
	
	if(arrayCanvas.length>=dim){	
		for(var i = 0; i<arrayCanvas.length-1;i++){
			arrayCanvas[i]=arrayCanvas[i+1];
		}
		arrayCanvas[index]=canvas.toDataURL();	
	}else{
		index++;	
		arrayCanvas[index]=canvas.toDataURL();
	}
	console.log(index);

	
}, false);

function undo(){	
	if(index>0){
		index--;	
		var imgCanvas = new Image();
		imgCanvas.src = arrayCanvas[index];
		imgCanvas.onload = function(){ctx.drawImage(imgCanvas, 0, 0); }
		console.log(index);
	}

}

function redo(){	
	if(index<arrayCanvas.length-1){
		index++;
		var imgCanvas = new Image();
		imgCanvas.src = arrayCanvas[index];
		imgCanvas.onload = function(){ctx.drawImage(imgCanvas, 0, 0); }
		console.log(index)
	}
	
}
	

var gradient=ctx.createLinearGradient(0,0,1000,0); 	
gradient.addColorStop("0","red");
gradient.addColorStop("0.3","#FFFF00");
gradient.addColorStop("0.5","#00FF00");
gradient.addColorStop("0.8","#00BFFF");
gradient.addColorStop("1","#BF00FF");

function color(colore){	
	if(colore!="gradient"){
		ctx.strokeStyle=colore;
		ctx.fillStyle=colore;
	}else{
		ctx.strokeStyle=gradient;
		ctx.fillStyle=gradient;
	}
}


/*window.addEventListener( 'resize', onWindowResize, false );		function onWindowResize(){
	canvas.width=window.innerWidth;
	canvas.height=window.innerHeight;
}*/


window.addEventListener('keydown',function(e){
	console.log(e.keyCode);
	if (e.keyCode==17 || e.keyCode==224){
		window.addEventListener('keydown',function(e){
			if(e.keyCode==173 || e.keyCode==171 || e.keyCode==107 || e.keyCode==109)
				e.preventDefault()
		},false)
	}
},false);

window.addEventListener('keydown',function(e){
	console.log(e.keyCode);
	if (e.keyCode==17 || e.keyCode==224){
		window.addEventListener('wheel',function(e){
			e.preventDefault()
		},false);
	}
},false);


