require=(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
var api = require("./rpcapi");
var state = require("./state");
var CARDS = require("./cards/cards");
var DB = require("./db");

window.onload = function() {
  $(".card").on("transitionend", function() {
    $("#main").removeClass("animating");
  });

  // EVENTS --------------------------------------------------------------------
  // TODO Find a better place to register these
  api.rpc.subscribe("Application.OnVolumeChanged", function(payload) {
    state.player.volume.update(payload.data.volume);
    state.player.muted.update(payload.data.muted);
  });

  api.rpc.subscribe("Player.OnPlay", function(payload) {
    state.player.id.update(payload.data.player.playerid);
    state.player.speed.update(payload.data.player.speed === undefined ? 1 : payload.data.player.speed);

    var np = state.nowplaying.val();

    switch(payload.data.item.type) {
      case 'episode':
        if (np.episodeid !== payload.data.item.id) {
          CARDS.NOWPLAYING.setNowPlayingEpisode(payload.data.item.id);
        }
        break;

      case 'movie':
        if (np.movieid !== payload.data.item.id) {
          CARDS.NOWPLAYING.setNowPlayingMovie(payload.data.item.id);
        }
        break;
    }
  });

  api.rpc.subscribe("Player.OnPause", function(payload) {
    state.player.id.update(payload.data.player.playerid);
    state.player.speed.update(payload.data.player.speed === undefined ? 0 : payload.data.player.speed);
  });

  api.rpc.subscribe("Player.OnSeek", function(payload) {
    CARDS.NOWPLAYING.handleSeekResponse(payload);
  });

  api.rpc.subscribe("Player.OnStop", function(payload) {
    state.player.id.update(-1);
    state.player.speed.update(0);
    state.player.position.update(-1);
    state.player.duration.update(-1);
    state.nowplaying.update({});
    CARDS.NOWPLAYING.updateItem();
  });

  // INIT ----------------------------------------------------------------------
  DB.init(function() {
    CARDS.SETTINGS.prepare();

    if (localStorage.cfg_host && localStorage.cfg_port) {
      // If we have a saved connection, reconnect
      CARDS.CONNECTION.tryConnect();

    } else {
      // Prompt the user to enter the host information
      CARDS.CONNECTION.activate();
    }
  });

  $("#nowplaying-button").click(function() {
    CARDS.NOWPLAYING.activate();
  });
  $("#classic-remote-button").click(function() {
    CARDS.CLASSIC_REMOTE.activate();
  });
};

},{"./cards/cards":13,"./db":14,"./rpcapi":22,"./state":23}],2:[function(require,module,exports){
var Handlebars = require('handlebars');
require("../handlebars_helpers")(Handlebars);
var templates = require("../templates")(Handlebars);
var util = require("../util");

// CARD ------------------------------------------------------------------------
function Card(num, id) {
  this.num = num;
  this.id = id;
  this.loaded = false;
}

Card.prototype.activate = function(forceReload) {
  if (forceReload || !this.loaded) {
    this.load();
    return;
  }
  this.show();
};
Card.prototype.deactivate = function() {};

Card.prototype.render = function(tplName, data, elem) {
  console.log("Rendering: " + tplName);
  $(elem || this.id).html(templates[tplName](data));
};
Card.prototype.show = function() {
  util.unfreezeUI();
};
Card.prototype.load = function() {};

module.exports = Card;

},{"../handlebars_helpers":16,"../templates":24,"../util":25,"handlebars":undefined}],3:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var Observable = require("../observable");
var _ = require("lodash");

// CLASSIC_REMOTE --------------------------------------------------------------
function ClassicRemoteCard() {
  Card.call(this, CARDNUM.CLASSIC_REMOTE, "#card-classic-remote");
}
ClassicRemoteCard.prototype = Object.create(Card.prototype);

ClassicRemoteCard.prototype.show = function() {
  var that = this;

  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader("Foxi");
  util.setSubheader("");
  util.showBackButton(function() {
    if (state.lastCard) {
      state.lastCard.activate();
    } else {
      CARDS.TVSHOWS.activate();
    }
  });
};


ClassicRemoteCard.prototype.activate = function() {
  Card.prototype.activate.call(this);

  // Show the button to switch to nowplaying
  $("#nowplaying-button").show();
  $("#classic-remote-button").hide();
};


ClassicRemoteCard.prototype.deactivate = function() {
  // Show the button to switch to classic remote
  $("#classic-remote-button").show();
  $("#nowplaying-button").hide();
};


function getActivePlayer() {
  api.Player.GetActivePlayers().then(function(data) {
    var players = data.result;
    if (_.isEmpty(players)) {
      return;
    }
    state.player.id.update(_.first(players).playerid);
  });
}


ClassicRemoteCard.prototype.load = function() {
  var card = this;
  card.render('classic_remote');

  $("#classic-playpause").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.PlayPause({ playerid: playerid });
    }
  });

  $("#classic-seek-forward").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Seek({ playerid: playerid, value: "smallforward" });
    }
  });

  $("#classic-seek-back").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Seek({ playerid: playerid, value: "smallbackward" });
    }
  });

  $("#classic-stop").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Stop({ playerid: playerid });
    }
  });

  $("#classic-up").on('click', function() {
    api.Input.Up({});
  });

  $("#classic-left").on('click', function() {
    api.Input.Left({});
  });

  $("#classic-right").on('click', function() {
    api.Input.Right({});
  });

  $("#classic-down").on('click', function() {
    api.Input.Down({});
  });

  $("#classic-select").on('click', function() {
    api.Input.Select({});
  });

  $("#classic-back").on('click', function() {
    api.Input.Back({});
  });

  $("#classic-context-menu").on('click', function() {
    api.Input.ContextMenu({});
  });

  $("#classic-home").on('click', function() {
    api.Input.Home({});
  });

  $("#classic-info").on('click', function() {
    api.Input.Info({});
  });

  card.show();
  card.loaded = true;
};


ClassicRemoteCard.prototype.update = function() {
};

module.exports = new ClassicRemoteCard();

},{"../observable":21,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13,"lodash":27}],4:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");

// SETTINGS --------------------------------------------------------------------
function ConnectionCard() {
  Card.call(this, CARDNUM.CONNECTION, "#card-connection");
}
ConnectionCard.prototype = Object.create(Card.prototype);

ConnectionCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader("Connection Setup");
  util.hideBackButton();
};

ConnectionCard.prototype.load = function() {
  var card = this;
  card.render('connection', {
    host: localStorage.cfg_host,
    port: localStorage.cfg_port
  });

  $("#cfg-connect-btn").on('click', function() {
    var host = $("#cfg-host-field").val();
    var port = $("#cfg-port-field").val();
    localStorage.cfg_host = host;
    localStorage.cfg_port = port;
    $("#cfg-connect-btn").removeClass("recommend");
    card.tryConnect();
  });

  this.show();
};

ConnectionCard.prototype.tryConnect = function() {
  api.rpc.connect(localStorage.cfg_host, localStorage.cfg_port).then(
      // Success
      function() {
        CARDS.INDEX.activate();
      },
      // Error
      function() {
        $("#cfg-connect-btn").addClass("recommend");
        CARDS.CONNECTION.activate();
      }
  );
};

module.exports = new ConnectionCard();

},{"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],5:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var imgUtil = require("../img");

// EPISODES --------------------------------------------------------------------
function EpisodesCard() {
  Card.call(this, CARDNUM.EPISODES, "#card-episodes");
}
EpisodesCard.prototype = Object.create(Card.prototype);

EpisodesCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader(state.show.title);
  util.setSubheader("Season " + state.season);
  util.showBackButton(function() {
    CARDS.SEASONS.activate();
  });
};

EpisodesCard.prototype.load = function() {
  var card = this;
  api.VideoLibrary.GetEpisodes({
    tvshowid: state.show.tvshowid,
    season: state.season,
    properties: ['title','art','episode'],
    sort: {
      order: 'ascending',
      method: 'episode'
    }
  }).then(function(data) {

    card.render('episode_list', data.result);
    $("#episode-list a").click(function() {
      util.freezeUI(this);
      var itemid = parseInt($(this).attr('data-libraryid'));
      api.Player.Open({ item: { episodeid: itemid } }).then(function() {
        CARDS.NOWPLAYING.activate(true);
      });
    });

    var imagesToLoad = $(".episode-banner > img[data-cache-url]");
    imgUtil.loadImages(imagesToLoad, imgUtil.dimensions.tv_thumb, 2500).then(function() {
      card.show();
      card.loaded = true;
    });
  });
};

module.exports = new EpisodesCard();

},{"../img":17,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],6:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var imgUtil = require("../img");

// INDEX -----------------------------------------------------------------------
function IndexCard() {
  Card.call(this, CARDNUM.INDEX, "#card-index");
}
IndexCard.prototype = Object.create(Card.prototype);

IndexCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader("Foxi");
  util.setSubheader();
  util.showBackButton(function() {
    CARDS.CONNECTION.activate();
  });
};

IndexCard.prototype.load = function() {
  var card = this;
  card.render('index');

  $("a[data-card-link]").on('click', function() {
    util.freezeUI(this);
    var linked = CARDS[$(this).attr('data-card-link')];
    linked.activate();
  });

  api.VideoLibrary.GetRecentlyAddedMovies({
    properties: [ 'art' ],
    limits: {
      end: 4
    }
  }).then(function(data) {
      card.render('index_recent_movies', data.result, '#index-recent-movies');
      imgUtil.loadImages($("#index-recent-movies img[data-cache-url]"), imgUtil.dimensions.movie);
  });

  api.VideoLibrary.GetRecentlyAddedEpisodes({
    properties: [ 'art' ],
    limits: {
      end: 4
    }
  }).then(function(data) {
      card.render('index_recent_episodes', data.result, '#index-recent-episodes');
      imgUtil.loadImages($("#index-recent-episodes img[data-cache-url]"), imgUtil.dimensions.tv_thumb);
  });

  this.loaded = true;
  this.show();
};

module.exports = new IndexCard();

},{"../img":17,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],7:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var imgUtil = require("../img");

// TV SHOWS --------------------------------------------------------------------
function MoviesCard() {
  Card.call(this, CARDNUM.MOVIES, "#card-movies");
}
MoviesCard.prototype = Object.create(Card.prototype);

MoviesCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader("Movies");
  util.setSubheader();
  util.showBackButton(function() {
    CARDS.INDEX.activate();
  });
};

MoviesCard.prototype.load = function() {
  var card = this;
  api.VideoLibrary.GetMovies({
    properties: ['title', 'art', 'year'],
    sort: {
      order: 'ascending',
      method: 'title'
    }
  }).then(function(data) {

    card.render('movie_list', data.result);

    $("#movie-list a").click(function() {
      util.freezeUI(this);
      var itemid = parseInt($(this).attr('data-libraryid'));
      api.Player.Open({ item: { movieid: itemid } }).then(function() {
        CARDS.NOWPLAYING.activate(true);
      });
    });

    var imagesToLoad = $("#movie-list .season-banner > img[data-cache-url]");
    imgUtil.loadImages(imagesToLoad, imgUtil.dimensions.movie, 2500).then(function() {
      card.show();
      card.loaded = true;
    });
  });
};

module.exports = new MoviesCard();

},{"../img":17,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],8:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var Observable = require("../observable");
var imgutil = require("../img");
var _ = require("lodash");

// NOWPLAYING ------------------------------------------------------------------
function NowPlayingCard() {
  Card.call(this, CARDNUM.NOWPLAYING, "#card-nowplaying");
  this.subs = {};
  this.seekHandler = new Observable(0);
  this.volumeHandler = new Observable(0);
}
NowPlayingCard.prototype = Object.create(Card.prototype);

NowPlayingCard.prototype.show = function() {
  var that = this;

  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader((state.show && state.show.label) ? state.show.label : "Now Playing");
  util.setSubheader(state.season ? ("Season " + state.season)  : "Now Playing");
  util.showBackButton(function() {
    if (state.lastCard) {
      state.lastCard.activate();
    } else {
      CARDS.TVSHOWS.activate();
    }
  });

  this.subs.playpause = state.player.speed.subscribe(this.updatePlayPauseButton.bind(this));
  this.subs.position = state.player.position.subscribe(this.updateSeekbar.bind(this));
  this.subs.duration = state.player.duration.subscribe(this.updateSeekbar.bind(this));
  this.subs.seektime = state.player.speed.subscribe(this.updateSeekTimer.bind(this));
  this.updateSeekTimer();
};


NowPlayingCard.prototype.activate = function() {
  Card.prototype.activate.call(this);

  // Show the button to switch to classic remote
  $("#classic-remote-button").show();
  $("#nowplaying-button").hide();
};


NowPlayingCard.prototype.deactivate = function() {
  this.subs.playpause.remove();
  this.subs.position.remove();
  this.subs.duration.remove();
  this.subs.seektime.remove();
  if (this.seekTimer) {
    clearInterval(this.seekTimer);
    delete this.seekTimer;
  }
  if (this.subs.muted) {
    this.subs.muted.remove();
  }

  // Show the button to switch to now playing
  $("#nowplaying-button").show();
  $("#classic-remote-button").hide();
};


NowPlayingCard.prototype.updateItem = function() {
  var item = state.nowplaying.val();

  if (!item || Object.keys(item).length === 0) {
    this.updateDetails({
      placeholder_img: '/assets/thumb.png'
    });
    return;
  }

  // Determine the type of the now playing item
  if (item.hasOwnProperty("episodeid"))
  { // TV Show
    this.updateDetails({
      thumb: util.getImageUrl(item.thumbnail),
      dimensions: imgutil.tv_thumb,
      img_size: 'hq',
      placeholder_img: '/assets/thumb.png',
      title: item.title,
      description: item.plot,
      header: item.showtitle,
      subheader: "Season " + item.season
    });
  }
  else if (item.hasOwnProperty("movieid"))
  { // Movie
    this.updateDetails({
      thumb: util.getImageUrl(item.thumbnail),
      dimensions: imgutil.movie,
      img_size: 'hq',
      placeholder_img: '/assets/movie.png',
      title: item.title,
      description: item.plot,
      header: item.title,
      subheader: ""
    });
  }
  else
  { // Unknown - something else
    this.updateDetails({
      placeholder_img: util.getImageUrl(item.thumbnail),
      title: item.title,
      description: item.plot,
      header: item.title,
      subheader: ""
    });
  }
};


NowPlayingCard.prototype.updateDetails = function(item) {
    // The image (thumnnail) for the now playing item
    $("#nowplaying-thumb").attr('src', item.placeholder_img);

    // If we have a cached thumbnail, load it
    if (item.thumb) {
      $("#nowplaying-thumb").attr('data-cache-url', item.thumb);
      $("#nowplaying-thumb").attr('data-image-size', item.img_size);

      // Start loading
      imgutil.loadImages($("#nowplaying-thumb"), item.dimensions);
    }

    // The title of the content that is playing
    $("#nowplaying-episode-title").text(item.title);

    // The description of the now playing content
    $("#nowplaying-episode-plot").text(item.description);

    // The text to show in the header
    util.setHeader(item.header);

    // The text to show in the subheader
    util.setSubheader(item.subheader);
};


// TODO Combine these two
NowPlayingCard.prototype.setNowPlayingEpisode = function(id) {
  var card = this;
  api.VideoLibrary.GetEpisodeDetails({
    episodeid: id, properties: ['title', 'showtitle', 'plot', 'thumbnail', 'season', 'runtime', 'resume']
  }).then(function(data) {
    state.nowplaying.update(data.result.episodedetails);
    state.player.position.update(data.result.episodedetails.resume.position || 0);
    state.player.duration.update(data.result.episodedetails.runtime);
    card.updateItem();
  });
};


// TODO Combine these two
NowPlayingCard.prototype.setNowPlayingMovie = function(id) {
  var card = this;
  api.VideoLibrary.GetMovieDetails({
    movieid: id, properties: ['title', 'plot', 'thumbnail', 'runtime', 'resume']
  }).then(function(data) {
    state.nowplaying.update(data.result.moviedetails);
    state.player.position.update(data.result.moviedetails.resume.position || 0);
    state.player.duration.update(data.result.moviedetails.runtime);
    card.updateItem();
  });
};


NowPlayingCard.prototype.updatePlayPauseButton = function() {
  $("#nowplaying-playpause").attr("data-icon", state.player.speed.val() === 0 ? "play" : "pause");
};


NowPlayingCard.prototype.updateSeekTimer = function() {
  var self = this;
  var speed = state.player.speed.val();
  if (speed === 0 && this.seekTimer) {
    clearInterval(this.seekTimer);
    delete this.seekTimer;
  } else if (speed !== 0) {
    if (this.seekTimer) {
      clearInterval(this.seekTimer);
    }

    // Workaround solution; when the phone goes into "standby" or something
    // the interval timer doesn't fire, so it may be longer than a second
    // between updates. This value should measure that time.
    self.lastTick = parseInt(new Date().getTime() / 1000);

    this.seekTimer = setInterval(function() {
      var pos = state.player.position.val();
      var tickNow = parseInt(new Date().getTime() / 1000);
      state.player.position.update(pos + (tickNow - self.lastTick));
      self.lastTick = tickNow;
    }, 1000 * speed);
  }
};


NowPlayingCard.prototype.updateSeekbar = function() {
  var position = state.player.position.val();
  var duration = state.player.duration.val();

  if (position === -1 || duration === -1) {
    $("#nowplaying-seek-cur").html("&ndash;");
    $("#nowplaying-seek-end").html("&ndash;");
    $("#nowplaying-seek progress").attr('value', '0');
    $("#nowplaying-seek progress").attr('max', '0');
    $("#nowplaying-seek-handler").css('left', '0%');
  } else {
    $("#nowplaying-seek-cur").html(seektime(position));
    $("#nowplaying-seek-end").html(seektime(duration));
    $("#nowplaying-seek progress").attr('value', position);
    $("#nowplaying-seek progress").attr('max', duration);

    if (!this.isSeeking) {
      $("#nowplaying-seek-handler").css('left', (100.0 * position / duration)+'%');
    }
  }
};


function seektime(secs) {
  var h = parseInt(secs / 3600);
  var xs = secs - h * 3600;
  var m = parseInt(xs / 60);
  var s = parseInt(xs - m * 60);

  if (h > 0) {
    return h + ":" + ('0'+m).slice(-2) + ":" + ('0'+s).slice(-2);
  } else if (m > 0) {
    return m + ":" + ('0'+s).slice(-2);
  } else {
    return "0:" + ('0'+s).slice(-2);
  }
}


NowPlayingCard.prototype.load = function() {
  var card = this;
  card.render('nowplaying', { show: state.show, season: state.season });

  this.updatePlayPauseButton(state.player.speed.val());

  $("#nowplaying-playpause").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.PlayPause({ playerid: playerid });
    }
  });

  $("#nowplaying-seek-forward").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Seek({ playerid: playerid, value: "smallforward" });
    }
  });

  $("#nowplaying-seek-back").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Seek({ playerid: playerid, value: "smallbackward" });
    }
  });

  $("#nowplaying-skip-forward").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Seek({ playerid: playerid, value: "bigforward" });
    }
  });

  $("#nowplaying-skip-back").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Seek({ playerid: playerid, value: "bigbackward" });
    }
  });

  $("#nowplaying-stop").on('click', function() {
    var playerid = state.player.id.val();
    if (playerid !== -1) {
      api.Player.Stop({ playerid: playerid });
    }
  });

  $("#nowplaying-more").on('click', function() {
    if ($("#nowplaying-controls").hasClass("expanded")) {
      $("#nowplaying-controls").removeClass("expanded");
      $("#nowplaying-more").attr('data-icon', 'dialpad');
    } else {
      $("#nowplaying-controls").addClass("expanded");
      $("#nowplaying-more").attr('data-icon', 'dismiss-keyboard');
    }
  });

  $("#nowplaying-seek-bar").on('touchstart', function() {
    console.log("Start seeking");
    card.isSeeking = true;

    card.subs.seekHandler = card.seekHandler.subscribe(function(x) {
      var playerid = state.player.id.val();
      if (playerid !== -1) {
        console.log("Seeking to " + (x * 100) + "%");
        api.Player.Seek({ playerid: playerid, value: (x * 100.0) });
      }
    });
  });

  $("#nowplaying-seek-bar").on('touchend', function() {
    console.log("End seeking");
    card.isSeeking = false;

    card.subs.seekHandler.remove();
  });

  $("#nowplaying-seek-bar").on('touchmove', function(evt) {
    if (card.isSeeking) {
      var playerid = state.player.id.val();
      if (playerid !== -1) {
        // target is the seek bar
        var touch = evt.touches[0];
        var target = document.getElementById("nowplaying-seek-bar");
        var x = (touch.clientX -16 - target.offsetLeft) / target.offsetWidth;

        // Register the seek value
        if (x < 0) {
          x = 0;
        }
        if (x > 1) {
          x = 1;
        }

        $("#nowplaying-seek-handler").css('left', (x * 100.0)+'%');
        card.seekHandler.throttledUpdate(x, 100);
      }
    }
  });
  
  $("#nowplaying-volume").on('click', function() {
    $("#overlay-volume").toggleClass('overlay-visible');
  });

  $("#overlay-volume").on('click', function() {
    $("#overlay-volume").removeClass('overlay-visible');
  });

  this.subs.volumeSlider = this.volumeHandler.subscribe(function(vol) {
    window.setTimeout(function() { $("#volume-indicator").addClass('fade'); }, 100);
    api.Application.SetVolume({ volume: vol });
  });

  function updateVolume(evt) {
    var ol = $("#volume-bar");
    var ymin = $(ol).position().top + 60;
    var ycur = evt.changedTouches[0].clientY;
    var ymax = $(ol).height() - 120;

    var vol = (((ymax - ycur) * 1.0) / (ymax - ymin)) * 100;
    vol = Math.max(0, Math.min(100, parseInt(vol)));
    console.log(ymin + " " + ycur + " " + ymax + " " + vol);

    card.volumeHandler.throttledUpdate(vol, 100);
    $("#volume-indicator").removeClass('fade').text(String(vol));
  }

  $("#volume-bar ol").on('touchstart', function() {
    $(this).on('touchmove', updateVolume);
    $(this).on('touchend', function() {
      $("#volume-bar ol").off('touchmove').off('touchend');
    });
  });

  // TODO Move this
  this.subs.muted = state.player.muted.subscribe(function(muted) {
    $("#nowplaying-volume").attr('data-icon', muted ? "mute" : "sound-max");
  });

  card.show();
  card.loaded = true;
};


NowPlayingCard.prototype.handleSeekResponse = function(resp) {
  var secs = util.timeToSecs(resp.data.player.time);
  state.player.position.update(secs);
};


NowPlayingCard.prototype.update = function() {
  $("#nowplaying-episode-title").text(state.nowplaying.title);
};

module.exports = new NowPlayingCard();

},{"../img":17,"../observable":21,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13,"lodash":27}],9:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var imgUtil = require("../img");

// SEASONS ---------------------------------------------------------------------
function SeasonsCard() {
  Card.call(this, CARDNUM.SEASONS, "#card-seasons");
}
SeasonsCard.prototype = Object.create(Card.prototype);

SeasonsCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader(state.show.title);
  util.setSubheader();
  util.showBackButton(function() {
    CARDS.TVSHOWS.activate();
  });
};

SeasonsCard.prototype.load = function() {
  var card = this;
  api.VideoLibrary.GetSeasons({
      tvshowid: state.show.tvshowid,
      properties: ['tvshowid', 'season', 'art', 'episode'],
      sort: {
        order: 'ascending',
        method: 'season'
      }
  }).then(function(data) {

    card.render('season_list', data.result);
    $("#season-list a").click(function() {
      util.freezeUI(this);
      state.season = parseInt($(this).attr('data-season'));
      // We have to reload when a new season is selected
      CARDS.EPISODES.activate(true);
    });

    var imagesToLoad = $(".season-banner > img[data-cache-url]");
    imgUtil.loadImages(imagesToLoad, imgUtil.dimensions.tv_season, 2500).then(function() {
      card.show();
      card.loaded = true;
    });
  });
};

module.exports = new SeasonsCard();

},{"../img":17,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],10:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");

var EFFECTS = {
  none: "No animations",
  fade: "Fade",
  blur: "Blur",
  slide: "Slide",
  swoop: "3D Swoop",
};

// SETTINGS --------------------------------------------------------------------
function SettingsCard() {
  Card.call(this, CARDNUM.SETTINGS, "#card-settings");
}
SettingsCard.prototype = Object.create(Card.prototype);

SettingsCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader("Settings");
  util.showBackButton(function() {
    CARDS.INDEX.activate();
  });
};

SettingsCard.prototype.load = function() {
  var card = this;
  card.render('settings', {
    effect_choices: EFFECTS
  });

  $("#cfg-effect").on("change", function() {
    localStorage.cfg_effect = $(this).val();
    card.prepare();
  }).val(localStorage.cfg_effect || "blur");

  $("#update-library").on("click", function() {
    api.VideoLibrary.Scan({});
  });

  this.show();
};

SettingsCard.prototype.prepare = function() {
  var effect = localStorage.cfg_effect || "blur";
  $("#main").attr("class", "animate-"+effect);
};

module.exports = new SettingsCard();

},{"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],11:[function(require,module,exports){
var Card = require("./Card");
var CARDS = require("./cards");
var CARDNUM = require("./cardnum");
var api = require("../rpcapi");
var util = require("../util");
var state = require("../state");
var imgUtil = require("../img");

// TV SHOWS --------------------------------------------------------------------
function TVShowsCard() {
  Card.call(this, CARDNUM.TVSHOWS, "#card-tv-shows");
}
TVShowsCard.prototype = Object.create(Card.prototype);

TVShowsCard.prototype.show = function() {
  Card.prototype.show.call(this);
  state.toCard(this);
  util.setHeader("TV Shows");
  util.setSubheader();
  util.showBackButton(function() {
    CARDS.INDEX.activate();
  });
};

TVShowsCard.prototype.load = function() {
  var card = this;
  api.VideoLibrary.GetTVShows({
    properties: ['title', 'art', 'year'],
    sort: {
      order: 'ascending',
      method: 'title'
    }
  }).then(function(data) {

    card.render('tv_show_list', data.result);
    $("a.tv-banner").click(function() {
      util.freezeUI(this);
      var showId = parseInt($(this).attr('data-show-id'));
      var showName = $(this).attr('data-show-name');
      state.show = {
        tvshowid: showId,
        title: showName,
      };
      // We have to reload when a new show is selected
      CARDS.SEASONS.activate(true);
    });
    
    var imagesToLoad = $("a.tv-banner > img[data-cache-url]");
    imgUtil.loadImages(imagesToLoad, imgUtil.dimensions.tv_banner, 2500).then(function() {
      card.show();
      card.loaded = true;
    });
  });
};

module.exports = new TVShowsCard();

},{"../img":17,"../rpcapi":22,"../state":23,"../util":25,"./Card":2,"./cardnum":12,"./cards":13}],12:[function(require,module,exports){
module.exports = {
  NONE:           -1,
  CONNECTION:     0,
  INDEX:          1,
  SETTINGS:       2,

  TVSHOWS:        10,
  SEASONS:        11,
  EPISODES:       12,

  MOVIES:         20,

  NOWPLAYING:     100,
  CLASSIC_REMOTE: 101 
};

},{}],13:[function(require,module,exports){
module.exports = {};
module.exports.CONNECTION      = require("./ConnectionCard");
module.exports.INDEX           = require("./IndexCard");
module.exports.SETTINGS        = require("./SettingsCard");
module.exports.TVSHOWS         = require("./TVShowsCard");
module.exports.SEASONS         = require("./SeasonsCard");
module.exports.EPISODES        = require("./EpisodesCard");
module.exports.MOVIES          = require("./MoviesCard");
module.exports.NOWPLAYING      = require("./NowPlayingCard");
module.exports.CLASSIC_REMOTE  = require("./ClassicRemoteCard");

},{"./ClassicRemoteCard":3,"./ConnectionCard":4,"./EpisodesCard":5,"./IndexCard":6,"./MoviesCard":7,"./NowPlayingCard":8,"./SeasonsCard":9,"./SettingsCard":10,"./TVShowsCard":11}],14:[function(require,module,exports){
// Support different versions of IndexedDB
var idb = window.indexedDB || window.webkitIndexedDB ||
  window.mozIndexedDB || window.msIndexedDB;

var FoxiDB = {
  init: function db_init(callback) {
    this.db.open(callback);
  },

  addImage: function db_addImage(uri, size, data) {
    this.db.createImage(uri, size, data);
  },

  getImage: function db_getImage(uri, size, callback) {
    this.db.getImage(uri, size, callback);
  },

  clearImages: function db_clearImages(callback) {
    this.db.clearImages(callback);
  }
};

FoxiDB.db = {
  _db: null,
  upgradeFrom: -1,

  open: function db_open(callback) {
    var DB_VERSION = 1;
    var DB_NAME = 'foxi';
    var request = idb.open(DB_NAME, DB_VERSION);

    request.onupgradeneeded = (function onUpgradeNeeded(e) {
      console.log('Foxi database upgrade needed, upgrading.');
      this.upgradeFrom = e.oldVersion;
      this._db = e.target.result;
      this.upgrade();
    }).bind(this);

    request.onsuccess = (function onSuccess(e) {
      this._db = e.target.result;
      callback();
      if (this.upgradeFrom != -1)
        FoxiDB.populate(this.upgradeFrom);
    }).bind(this);

    request.onerror = (function onDatabaseError(e) {
      console.log('Error opening foxi database');
    }).bind(this);
  },

  upgrade: function db_upgrade() {
    var db = this._db;
    var upgradeFrom = this.upgradeFrom;

    if (upgradeFrom < 1) {
      var imgCache = db.createObjectStore('imgCache', { keyPath: 'uri' });
    }
  },

  createImage: function db_createImage(uri, size, data) {
    var transaction = this._db.transaction(['imgCache'], 'readwrite');
    var imgData = { uri: size+"@"+uri, data: data };
    var objectStore = transaction.objectStore('imgCache');
    var writeRequest = objectStore.add(imgData);

    writeRequest.onsuccess = function onWriteSuccess(event) {
      console.log('successfully wrote image data ' + imgData.uri);
    };

    writeRequest.onerror = function onError(event) {
      console.log('error writing image data:' + imgData.uri);
    };

    transaction.onerror = function dbTransactionError(e) {
      console.log('Transaction error while trying to save image data ' + imgData.uri);
    };
  },

  getImage: function db_getPlace(uri, size, callback) {
    var db = this._db;
    var request = db.transaction('imgCache').objectStore('imgCache').get(size+"@"+uri);

    request.onsuccess = function onSuccess(event) {
      callback(event.target.result);
    };

    request.onerror = function onError(event) {
      if (event.target.errorCode == IDBDatabaseException.NOT_FOUND_ERR)
        callback();
    };
  },

  clearImages: function db_clearImages(callback) {
    var db = FoxiDB.db._db;
    var transaction = db.transaction('imgCache', 'readwrite');
    transaction.onerror = function dbTransactionError(e) {
      console.log('Transaction error while trying to clear images');
    };
    var objectStore = transaction.objectStore('imgCache');
    var request = objectStore.clear();
    request.onsuccess = function onSuccess() {
      callback();
    };
    request.onerror = function onError(e) {
      console.log('Error clearing images object store');
    };
  }
};

module.exports = FoxiDB;
window.clearImgCache = FoxiDB.clearImages.bind(FoxiDB);

},{}],15:[function(require,module,exports){
(function (process,global){
/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
 * @version   2.0.0
 */

(function() {
    "use strict";

    function $$utils$$objectOrFunction(x) {
      return typeof x === 'function' || (typeof x === 'object' && x !== null);
    }

    function $$utils$$isFunction(x) {
      return typeof x === 'function';
    }

    function $$utils$$isMaybeThenable(x) {
      return typeof x === 'object' && x !== null;
    }

    var $$utils$$_isArray;

    if (!Array.isArray) {
      $$utils$$_isArray = function (x) {
        return Object.prototype.toString.call(x) === '[object Array]';
      };
    } else {
      $$utils$$_isArray = Array.isArray;
    }

    var $$utils$$isArray = $$utils$$_isArray;
    var $$utils$$now = Date.now || function() { return new Date().getTime(); };
    function $$utils$$F() { }

    var $$utils$$o_create = (Object.create || function (o) {
      if (arguments.length > 1) {
        throw new Error('Second argument not supported');
      }
      if (typeof o !== 'object') {
        throw new TypeError('Argument must be an object');
      }
      $$utils$$F.prototype = o;
      return new $$utils$$F();
    });

    var $$asap$$len = 0;

    var $$asap$$default = function asap(callback, arg) {
      $$asap$$queue[$$asap$$len] = callback;
      $$asap$$queue[$$asap$$len + 1] = arg;
      $$asap$$len += 2;
      if ($$asap$$len === 2) {
        // If len is 1, that means that we need to schedule an async flush.
        // If additional callbacks are queued before the queue is flushed, they
        // will be processed by this flush that we are scheduling.
        $$asap$$scheduleFlush();
      }
    };

    var $$asap$$browserGlobal = (typeof window !== 'undefined') ? window : {};
    var $$asap$$BrowserMutationObserver = $$asap$$browserGlobal.MutationObserver || $$asap$$browserGlobal.WebKitMutationObserver;

    // test for web worker but not in IE10
    var $$asap$$isWorker = typeof Uint8ClampedArray !== 'undefined' &&
      typeof importScripts !== 'undefined' &&
      typeof MessageChannel !== 'undefined';

    // node
    function $$asap$$useNextTick() {
      return function() {
        process.nextTick($$asap$$flush);
      };
    }

    function $$asap$$useMutationObserver() {
      var iterations = 0;
      var observer = new $$asap$$BrowserMutationObserver($$asap$$flush);
      var node = document.createTextNode('');
      observer.observe(node, { characterData: true });

      return function() {
        node.data = (iterations = ++iterations % 2);
      };
    }

    // web worker
    function $$asap$$useMessageChannel() {
      var channel = new MessageChannel();
      channel.port1.onmessage = $$asap$$flush;
      return function () {
        channel.port2.postMessage(0);
      };
    }

    function $$asap$$useSetTimeout() {
      return function() {
        setTimeout($$asap$$flush, 1);
      };
    }

    var $$asap$$queue = new Array(1000);

    function $$asap$$flush() {
      for (var i = 0; i < $$asap$$len; i+=2) {
        var callback = $$asap$$queue[i];
        var arg = $$asap$$queue[i+1];

        callback(arg);

        $$asap$$queue[i] = undefined;
        $$asap$$queue[i+1] = undefined;
      }

      $$asap$$len = 0;
    }

    var $$asap$$scheduleFlush;

    // Decide what async method to use to triggering processing of queued callbacks:
    if (typeof process !== 'undefined' && {}.toString.call(process) === '[object process]') {
      $$asap$$scheduleFlush = $$asap$$useNextTick();
    } else if ($$asap$$BrowserMutationObserver) {
      $$asap$$scheduleFlush = $$asap$$useMutationObserver();
    } else if ($$asap$$isWorker) {
      $$asap$$scheduleFlush = $$asap$$useMessageChannel();
    } else {
      $$asap$$scheduleFlush = $$asap$$useSetTimeout();
    }

    function $$$internal$$noop() {}
    var $$$internal$$PENDING   = void 0;
    var $$$internal$$FULFILLED = 1;
    var $$$internal$$REJECTED  = 2;
    var $$$internal$$GET_THEN_ERROR = new $$$internal$$ErrorObject();

    function $$$internal$$selfFullfillment() {
      return new TypeError("You cannot resolve a promise with itself");
    }

    function $$$internal$$cannotReturnOwn() {
      return new TypeError('A promises callback cannot return that same promise.')
    }

    function $$$internal$$getThen(promise) {
      try {
        return promise.then;
      } catch(error) {
        $$$internal$$GET_THEN_ERROR.error = error;
        return $$$internal$$GET_THEN_ERROR;
      }
    }

    function $$$internal$$tryThen(then, value, fulfillmentHandler, rejectionHandler) {
      try {
        then.call(value, fulfillmentHandler, rejectionHandler);
      } catch(e) {
        return e;
      }
    }

    function $$$internal$$handleForeignThenable(promise, thenable, then) {
       $$asap$$default(function(promise) {
        var sealed = false;
        var error = $$$internal$$tryThen(then, thenable, function(value) {
          if (sealed) { return; }
          sealed = true;
          if (thenable !== value) {
            $$$internal$$resolve(promise, value);
          } else {
            $$$internal$$fulfill(promise, value);
          }
        }, function(reason) {
          if (sealed) { return; }
          sealed = true;

          $$$internal$$reject(promise, reason);
        }, 'Settle: ' + (promise._label || ' unknown promise'));

        if (!sealed && error) {
          sealed = true;
          $$$internal$$reject(promise, error);
        }
      }, promise);
    }

    function $$$internal$$handleOwnThenable(promise, thenable) {
      if (thenable._state === $$$internal$$FULFILLED) {
        $$$internal$$fulfill(promise, thenable._result);
      } else if (promise._state === $$$internal$$REJECTED) {
        $$$internal$$reject(promise, thenable._result);
      } else {
        $$$internal$$subscribe(thenable, undefined, function(value) {
          $$$internal$$resolve(promise, value);
        }, function(reason) {
          $$$internal$$reject(promise, reason);
        });
      }
    }

    function $$$internal$$handleMaybeThenable(promise, maybeThenable) {
      if (maybeThenable.constructor === promise.constructor) {
        $$$internal$$handleOwnThenable(promise, maybeThenable);
      } else {
        var then = $$$internal$$getThen(maybeThenable);

        if (then === $$$internal$$GET_THEN_ERROR) {
          $$$internal$$reject(promise, $$$internal$$GET_THEN_ERROR.error);
        } else if (then === undefined) {
          $$$internal$$fulfill(promise, maybeThenable);
        } else if ($$utils$$isFunction(then)) {
          $$$internal$$handleForeignThenable(promise, maybeThenable, then);
        } else {
          $$$internal$$fulfill(promise, maybeThenable);
        }
      }
    }

    function $$$internal$$resolve(promise, value) {
      if (promise === value) {
        $$$internal$$reject(promise, $$$internal$$selfFullfillment());
      } else if ($$utils$$objectOrFunction(value)) {
        $$$internal$$handleMaybeThenable(promise, value);
      } else {
        $$$internal$$fulfill(promise, value);
      }
    }

    function $$$internal$$publishRejection(promise) {
      if (promise._onerror) {
        promise._onerror(promise._result);
      }

      $$$internal$$publish(promise);
    }

    function $$$internal$$fulfill(promise, value) {
      if (promise._state !== $$$internal$$PENDING) { return; }

      promise._result = value;
      promise._state = $$$internal$$FULFILLED;

      if (promise._subscribers.length === 0) {
      } else {
        $$asap$$default($$$internal$$publish, promise);
      }
    }

    function $$$internal$$reject(promise, reason) {
      if (promise._state !== $$$internal$$PENDING) { return; }
      promise._state = $$$internal$$REJECTED;
      promise._result = reason;

      $$asap$$default($$$internal$$publishRejection, promise);
    }

    function $$$internal$$subscribe(parent, child, onFulfillment, onRejection) {
      var subscribers = parent._subscribers;
      var length = subscribers.length;

      parent._onerror = null;

      subscribers[length] = child;
      subscribers[length + $$$internal$$FULFILLED] = onFulfillment;
      subscribers[length + $$$internal$$REJECTED]  = onRejection;

      if (length === 0 && parent._state) {
        $$asap$$default($$$internal$$publish, parent);
      }
    }

    function $$$internal$$publish(promise) {
      var subscribers = promise._subscribers;
      var settled = promise._state;

      if (subscribers.length === 0) { return; }

      var child, callback, detail = promise._result;

      for (var i = 0; i < subscribers.length; i += 3) {
        child = subscribers[i];
        callback = subscribers[i + settled];

        if (child) {
          $$$internal$$invokeCallback(settled, child, callback, detail);
        } else {
          callback(detail);
        }
      }

      promise._subscribers.length = 0;
    }

    function $$$internal$$ErrorObject() {
      this.error = null;
    }

    var $$$internal$$TRY_CATCH_ERROR = new $$$internal$$ErrorObject();

    function $$$internal$$tryCatch(callback, detail) {
      try {
        return callback(detail);
      } catch(e) {
        $$$internal$$TRY_CATCH_ERROR.error = e;
        return $$$internal$$TRY_CATCH_ERROR;
      }
    }

    function $$$internal$$invokeCallback(settled, promise, callback, detail) {
      var hasCallback = $$utils$$isFunction(callback),
          value, error, succeeded, failed;

      if (hasCallback) {
        value = $$$internal$$tryCatch(callback, detail);

        if (value === $$$internal$$TRY_CATCH_ERROR) {
          failed = true;
          error = value.error;
          value = null;
        } else {
          succeeded = true;
        }

        if (promise === value) {
          $$$internal$$reject(promise, $$$internal$$cannotReturnOwn());
          return;
        }

      } else {
        value = detail;
        succeeded = true;
      }

      if (promise._state !== $$$internal$$PENDING) {
        // noop
      } else if (hasCallback && succeeded) {
        $$$internal$$resolve(promise, value);
      } else if (failed) {
        $$$internal$$reject(promise, error);
      } else if (settled === $$$internal$$FULFILLED) {
        $$$internal$$fulfill(promise, value);
      } else if (settled === $$$internal$$REJECTED) {
        $$$internal$$reject(promise, value);
      }
    }

    function $$$internal$$initializePromise(promise, resolver) {
      try {
        resolver(function resolvePromise(value){
          $$$internal$$resolve(promise, value);
        }, function rejectPromise(reason) {
          $$$internal$$reject(promise, reason);
        });
      } catch(e) {
        $$$internal$$reject(promise, e);
      }
    }

    function $$$enumerator$$makeSettledResult(state, position, value) {
      if (state === $$$internal$$FULFILLED) {
        return {
          state: 'fulfilled',
          value: value
        };
      } else {
        return {
          state: 'rejected',
          reason: value
        };
      }
    }

    function $$$enumerator$$Enumerator(Constructor, input, abortOnReject, label) {
      this._instanceConstructor = Constructor;
      this.promise = new Constructor($$$internal$$noop, label);
      this._abortOnReject = abortOnReject;

      if (this._validateInput(input)) {
        this._input     = input;
        this.length     = input.length;
        this._remaining = input.length;

        this._init();

        if (this.length === 0) {
          $$$internal$$fulfill(this.promise, this._result);
        } else {
          this.length = this.length || 0;
          this._enumerate();
          if (this._remaining === 0) {
            $$$internal$$fulfill(this.promise, this._result);
          }
        }
      } else {
        $$$internal$$reject(this.promise, this._validationError());
      }
    }

    $$$enumerator$$Enumerator.prototype._validateInput = function(input) {
      return $$utils$$isArray(input);
    };

    $$$enumerator$$Enumerator.prototype._validationError = function() {
      return new Error('Array Methods must be provided an Array');
    };

    $$$enumerator$$Enumerator.prototype._init = function() {
      this._result = new Array(this.length);
    };

    var $$$enumerator$$default = $$$enumerator$$Enumerator;

    $$$enumerator$$Enumerator.prototype._enumerate = function() {
      var length  = this.length;
      var promise = this.promise;
      var input   = this._input;

      for (var i = 0; promise._state === $$$internal$$PENDING && i < length; i++) {
        this._eachEntry(input[i], i);
      }
    };

    $$$enumerator$$Enumerator.prototype._eachEntry = function(entry, i) {
      var c = this._instanceConstructor;
      if ($$utils$$isMaybeThenable(entry)) {
        if (entry.constructor === c && entry._state !== $$$internal$$PENDING) {
          entry._onerror = null;
          this._settledAt(entry._state, i, entry._result);
        } else {
          this._willSettleAt(c.resolve(entry), i);
        }
      } else {
        this._remaining--;
        this._result[i] = this._makeResult($$$internal$$FULFILLED, i, entry);
      }
    };

    $$$enumerator$$Enumerator.prototype._settledAt = function(state, i, value) {
      var promise = this.promise;

      if (promise._state === $$$internal$$PENDING) {
        this._remaining--;

        if (this._abortOnReject && state === $$$internal$$REJECTED) {
          $$$internal$$reject(promise, value);
        } else {
          this._result[i] = this._makeResult(state, i, value);
        }
      }

      if (this._remaining === 0) {
        $$$internal$$fulfill(promise, this._result);
      }
    };

    $$$enumerator$$Enumerator.prototype._makeResult = function(state, i, value) {
      return value;
    };

    $$$enumerator$$Enumerator.prototype._willSettleAt = function(promise, i) {
      var enumerator = this;

      $$$internal$$subscribe(promise, undefined, function(value) {
        enumerator._settledAt($$$internal$$FULFILLED, i, value);
      }, function(reason) {
        enumerator._settledAt($$$internal$$REJECTED, i, reason);
      });
    };

    var $$promise$all$$default = function all(entries, label) {
      return new $$$enumerator$$default(this, entries, true /* abort on reject */, label).promise;
    };

    var $$promise$race$$default = function race(entries, label) {
      /*jshint validthis:true */
      var Constructor = this;

      var promise = new Constructor($$$internal$$noop, label);

      if (!$$utils$$isArray(entries)) {
        $$$internal$$reject(promise, new TypeError('You must pass an array to race.'));
        return promise;
      }

      var length = entries.length;

      function onFulfillment(value) {
        $$$internal$$resolve(promise, value);
      }

      function onRejection(reason) {
        $$$internal$$reject(promise, reason);
      }

      for (var i = 0; promise._state === $$$internal$$PENDING && i < length; i++) {
        $$$internal$$subscribe(Constructor.resolve(entries[i]), undefined, onFulfillment, onRejection);
      }

      return promise;
    };

    var $$promise$resolve$$default = function resolve(object, label) {
      /*jshint validthis:true */
      var Constructor = this;

      if (object && typeof object === 'object' && object.constructor === Constructor) {
        return object;
      }

      var promise = new Constructor($$$internal$$noop, label);
      $$$internal$$resolve(promise, object);
      return promise;
    };

    var $$promise$reject$$default = function reject(reason, label) {
      /*jshint validthis:true */
      var Constructor = this;
      var promise = new Constructor($$$internal$$noop, label);
      $$$internal$$reject(promise, reason);
      return promise;
    };

    var $$es6$promise$promise$$counter = 0;

    function $$es6$promise$promise$$needsResolver() {
      throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
    }

    function $$es6$promise$promise$$needsNew() {
      throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
    }

    var $$es6$promise$promise$$default = $$es6$promise$promise$$Promise;

    /**
      Promise objects represent the eventual result of an asynchronous operation. The
      primary way of interacting with a promise is through its `then` method, which
      registers callbacks to receive either a promise’s eventual value or the reason
      why the promise cannot be fulfilled.

      Terminology
      -----------

      - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
      - `thenable` is an object or function that defines a `then` method.
      - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
      - `exception` is a value that is thrown using the throw statement.
      - `reason` is a value that indicates why a promise was rejected.
      - `settled` the final resting state of a promise, fulfilled or rejected.

      A promise can be in one of three states: pending, fulfilled, or rejected.

      Promises that are fulfilled have a fulfillment value and are in the fulfilled
      state.  Promises that are rejected have a rejection reason and are in the
      rejected state.  A fulfillment value is never a thenable.

      Promises can also be said to *resolve* a value.  If this value is also a
      promise, then the original promise's settled state will match the value's
      settled state.  So a promise that *resolves* a promise that rejects will
      itself reject, and a promise that *resolves* a promise that fulfills will
      itself fulfill.


      Basic Usage:
      ------------

      ```js
      var promise = new Promise(function(resolve, reject) {
        // on success
        resolve(value);

        // on failure
        reject(reason);
      });

      promise.then(function(value) {
        // on fulfillment
      }, function(reason) {
        // on rejection
      });
      ```

      Advanced Usage:
      ---------------

      Promises shine when abstracting away asynchronous interactions such as
      `XMLHttpRequest`s.

      ```js
      function getJSON(url) {
        return new Promise(function(resolve, reject){
          var xhr = new XMLHttpRequest();

          xhr.open('GET', url);
          xhr.onreadystatechange = handler;
          xhr.responseType = 'json';
          xhr.setRequestHeader('Accept', 'application/json');
          xhr.send();

          function handler() {
            if (this.readyState === this.DONE) {
              if (this.status === 200) {
                resolve(this.response);
              } else {
                reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
              }
            }
          };
        });
      }

      getJSON('/posts.json').then(function(json) {
        // on fulfillment
      }, function(reason) {
        // on rejection
      });
      ```

      Unlike callbacks, promises are great composable primitives.

      ```js
      Promise.all([
        getJSON('/posts'),
        getJSON('/comments')
      ]).then(function(values){
        values[0] // => postsJSON
        values[1] // => commentsJSON

        return values;
      });
      ```

      @class Promise
      @param {function} resolver
      @param {String} label optional string for labeling the promise.
      Useful for tooling.
      @constructor
    */
    function $$es6$promise$promise$$Promise(resolver, label) {
      this._id = $$es6$promise$promise$$counter++;
      this._label = label;
      this._state = undefined;
      this._result = undefined;
      this._subscribers = [];

      if ($$$internal$$noop !== resolver) {
        if (!$$utils$$isFunction(resolver)) {
          $$es6$promise$promise$$needsResolver();
        }

        if (!(this instanceof $$es6$promise$promise$$Promise)) {
          $$es6$promise$promise$$needsNew();
        }

        $$$internal$$initializePromise(this, resolver);
      }
    }

    $$es6$promise$promise$$Promise.all = $$promise$all$$default;
    $$es6$promise$promise$$Promise.race = $$promise$race$$default;
    $$es6$promise$promise$$Promise.resolve = $$promise$resolve$$default;
    $$es6$promise$promise$$Promise.reject = $$promise$reject$$default;

    $$es6$promise$promise$$Promise.prototype = {
      constructor: $$es6$promise$promise$$Promise,

    /**
      The primary way of interacting with a promise is through its `then` method,
      which registers callbacks to receive either a promise's eventual value or the
      reason why the promise cannot be fulfilled.

      ```js
      findUser().then(function(user){
        // user is available
      }, function(reason){
        // user is unavailable, and you are given the reason why
      });
      ```

      Chaining
      --------

      The return value of `then` is itself a promise.  This second, 'downstream'
      promise is resolved with the return value of the first promise's fulfillment
      or rejection handler, or rejected if the handler throws an exception.

      ```js
      findUser().then(function (user) {
        return user.name;
      }, function (reason) {
        return 'default name';
      }).then(function (userName) {
        // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
        // will be `'default name'`
      });

      findUser().then(function (user) {
        throw new Error('Found user, but still unhappy');
      }, function (reason) {
        throw new Error('`findUser` rejected and we're unhappy');
      }).then(function (value) {
        // never reached
      }, function (reason) {
        // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
        // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
      });
      ```
      If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.

      ```js
      findUser().then(function (user) {
        throw new PedagogicalException('Upstream error');
      }).then(function (value) {
        // never reached
      }).then(function (value) {
        // never reached
      }, function (reason) {
        // The `PedgagocialException` is propagated all the way down to here
      });
      ```

      Assimilation
      ------------

      Sometimes the value you want to propagate to a downstream promise can only be
      retrieved asynchronously. This can be achieved by returning a promise in the
      fulfillment or rejection handler. The downstream promise will then be pending
      until the returned promise is settled. This is called *assimilation*.

      ```js
      findUser().then(function (user) {
        return findCommentsByAuthor(user);
      }).then(function (comments) {
        // The user's comments are now available
      });
      ```

      If the assimliated promise rejects, then the downstream promise will also reject.

      ```js
      findUser().then(function (user) {
        return findCommentsByAuthor(user);
      }).then(function (comments) {
        // If `findCommentsByAuthor` fulfills, we'll have the value here
      }, function (reason) {
        // If `findCommentsByAuthor` rejects, we'll have the reason here
      });
      ```

      Simple Example
      --------------

      Synchronous Example

      ```javascript
      var result;

      try {
        result = findResult();
        // success
      } catch(reason) {
        // failure
      }
      ```

      Errback Example

      ```js
      findResult(function(result, err){
        if (err) {
          // failure
        } else {
          // success
        }
      });
      ```

      Promise Example;

      ```javascript
      findResult().then(function(result){
        // success
      }, function(reason){
        // failure
      });
      ```

      Advanced Example
      --------------

      Synchronous Example

      ```javascript
      var author, books;

      try {
        author = findAuthor();
        books  = findBooksByAuthor(author);
        // success
      } catch(reason) {
        // failure
      }
      ```

      Errback Example

      ```js

      function foundBooks(books) {

      }

      function failure(reason) {

      }

      findAuthor(function(author, err){
        if (err) {
          failure(err);
          // failure
        } else {
          try {
            findBoooksByAuthor(author, function(books, err) {
              if (err) {
                failure(err);
              } else {
                try {
                  foundBooks(books);
                } catch(reason) {
                  failure(reason);
                }
              }
            });
          } catch(error) {
            failure(err);
          }
          // success
        }
      });
      ```

      Promise Example;

      ```javascript
      findAuthor().
        then(findBooksByAuthor).
        then(function(books){
          // found books
      }).catch(function(reason){
        // something went wrong
      });
      ```

      @method then
      @param {Function} onFulfilled
      @param {Function} onRejected
      @param {String} label optional string for labeling the promise.
      Useful for tooling.
      @return {Promise}
    */
      then: function(onFulfillment, onRejection, label) {
        var parent = this;
        var state = parent._state;

        if (state === $$$internal$$FULFILLED && !onFulfillment || state === $$$internal$$REJECTED && !onRejection) {
          return this;
        }

        parent._onerror = null;

        var child = new this.constructor($$$internal$$noop, label);
        var result = parent._result;

        if (state) {
          var callback = arguments[state - 1];
          $$asap$$default(function(){
            $$$internal$$invokeCallback(state, child, callback, result);
          });
        } else {
          $$$internal$$subscribe(parent, child, onFulfillment, onRejection);
        }

        return child;
      },

    /**
      `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
      as the catch block of a try/catch statement.

      ```js
      function findAuthor(){
        throw new Error('couldn't find that author');
      }

      // synchronous
      try {
        findAuthor();
      } catch(reason) {
        // something went wrong
      }

      // async with promises
      findAuthor().catch(function(reason){
        // something went wrong
      });
      ```

      @method catch
      @param {Function} onRejection
      @param {String} label optional string for labeling the promise.
      Useful for tooling.
      @return {Promise}
    */
      'catch': function(onRejection, label) {
        return this.then(null, onRejection, label);
      }
    };

    var $$es6$promise$polyfill$$default = function polyfill() {
      var local;

      if (typeof global !== 'undefined') {
        local = global;
      } else if (typeof window !== 'undefined' && window.document) {
        local = window;
      } else {
        local = self;
      }

      var es6PromiseSupport =
        "Promise" in local &&
        // Some of these methods are missing from
        // Firefox/Chrome experimental implementations
        "resolve" in local.Promise &&
        "reject" in local.Promise &&
        "all" in local.Promise &&
        "race" in local.Promise &&
        // Older version of the spec had a resolver object
        // as the arg rather than a function
        (function() {
          var resolve;
          new local.Promise(function(r) { resolve = r; });
          return $$utils$$isFunction(resolve);
        }());

      if (!es6PromiseSupport) {
        local.Promise = $$es6$promise$promise$$default;
      }
    };

    var es6$promise$umd$$ES6Promise = {
      Promise: $$es6$promise$promise$$default,
      polyfill: $$es6$promise$polyfill$$default
    };

    /* global define:true module:true window: true */
    if (typeof define === 'function' && define['amd']) {
      define(function() { return es6$promise$umd$$ES6Promise; });
    } else if (typeof module !== 'undefined' && module['exports']) {
      module['exports'] = es6$promise$umd$$ES6Promise;
    } else if (typeof this !== 'undefined') {
      this['ES6Promise'] = es6$promise$umd$$ES6Promise;
    }
}).call(this);
}).call(this,require('_process'),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"_process":26}],16:[function(require,module,exports){
var util = require("./util");
var DB = require("./db");
var imgUtil = require("./img");

module.exports = function(Handlebars) {

  Handlebars.registerHelper('img_thumbnail', function() {
    var img = Handlebars.escapeExpression(this.thumbnail);
    var src = util.getImageUrl(img);
    if (src) {
      return new Handlebars.SafeString('<img alt="thumb" data-image-size="list" src="'+src+'">');
    }
    return new Handlebars.SafeString('<img alt="missing" src="">');
  });

  Handlebars.registerHelper('tv_banner', function() {
    var title = Handlebars.escapeExpression(this.title);
    var tvshowid = Handlebars.escapeExpression(this.tvshowid);
    var img = Handlebars.escapeExpression(this.art.banner);
    var src = util.getImageUrl(img);
    
    return new Handlebars.SafeString('<a class="tv-banner selectable" data-show-name="'+title+'" data-show-id="'+tvshowid+'"><img data-image-size="list" data-cache-url="'+src+'" src="/assets/banner.png"><span>'+title+'</span></a>');
  });

  Handlebars.registerHelper('img_season_art', function() {
    var img = Handlebars.escapeExpression(this.art.poster);
    var src = util.getImageUrl(img);
    return new Handlebars.SafeString('<img data-image-size="list" data-cache-url="'+src+'" src="/assets/movie.png">');
  });

  Handlebars.registerHelper('img_movie_art', function() {
    var img = Handlebars.escapeExpression(this.art.poster);
    var src = util.getImageUrl(img);
    return new Handlebars.SafeString('<img data-image-size="list" data-cache-url="'+src+'" src="/assets/movie.png">');
  });

  Handlebars.registerHelper('img_movie_art_hq', function() {
    var img = Handlebars.escapeExpression(this.art.poster);
    var src = util.getImageUrl(img);
    return new Handlebars.SafeString('<img data-image-size="hq" data-cache-url="'+src+'" src="/assets/movie.png">');
  });

  Handlebars.registerHelper('img_episode_art', function() {
    var img = Handlebars.escapeExpression(this.art.thumb);
    var src = util.getImageUrl(img);
    return new Handlebars.SafeString('<img data-image-size="list" data-cache-url="'+src+'" src="/assets/thumb.png">');
  });

  Handlebars.registerHelper('img_episode_art_recent', function() {
    var img = Handlebars.escapeExpression(this.art.thumb);
    var src = util.getImageUrl(img);
    return new Handlebars.SafeString('<img data-image-size="recent" data-cache-url="'+src+'" src="/assets/thumb.png">');
  });

  Handlebars.registerHelper('img_episode_art_hq', function() {
    var img = Handlebars.escapeExpression(this.art.thumb);
    var src = util.getImageUrl(img);
    return new Handlebars.SafeString('<img data-image-size="hq" data-cache-url="'+src+'" src="/assets/thumb.png">');
  });
};

},{"./db":14,"./img":17,"./util":25}],17:[function(require,module,exports){
var DB = require("./db");

var dimensions = {
  tv_banner: {
    list: {
      width: 320, height: 60
    }
  },
  tv_season: {
    list: {
      width: 98, height: 142
    }
  },
  tv_thumb: {
    list: {
      width: 98, height: 55
    },
    recent: {
      width: 200, height: 112
    },
    hq: {
      width: 320, height: 180
    }
  },
  movie: {
    list: {
      width: 98, height: 142
    },
    hq: {
      width: 320, height: 457
    }
  }
};

function cache(url, sizes, whenLoaded) {
  console.log("[CACHE MISS] " + url);

  return new Promise(function(resolve, reject) {
    // mozSystem: Allow cross-domain requests in privileged app
    var xmlHTTP = new XMLHttpRequest({ mozSystem: true, mozAnon: true });
    xmlHTTP.open('GET', url, true);

    // Must include this line - specifies the response type we want
    xmlHTTP.responseType = 'arraybuffer';

    xmlHTTP.onload = function(e)
    {
      console.log("Loaded src for " + url);
      var arr = new Uint8Array(this.response);
      var raw = Uint8ToString(arr);

      var b64 = btoa(raw);
      var data ="data:image/jpeg;base64,"+b64;
      console.log("Encoded " + url);

      var thumbnailsReady = [];
      var res = {};
      
      function cb(thumbData) {
        console.log("created thumbnail for size: " + this.label + " " + this.url);
        res[this.label] = thumbData;
        try { DB.addImage(this.url, this.label, thumbData); } catch (e) { }
      }

      for (var label in sizes) {
        thumbnailsReady.push(createThumbnail(data, sizes[label]).then(cb.bind({label: label, url: url})));
      }

      Promise.all(thumbnailsReady).then(function() {
        resolve(res);
      });
    };

    xmlHTTP.send();
  });
}

function createThumbnail(src, size) {
  return new Promise(function(resolve, reject) {
    console.log("Creating thumbnail ["+size.width+"x"+size.height+"]");
    var img = new Image();

    img.onload = function() {
      var canvas = document.createElement("canvas");
      var ctx = canvas.getContext("2d");
      canvas.width = size.width;
      canvas.height = size.height;
      ctx.drawImage(img, 0, 0, size.width, size.height);
      resolve(canvas.toDataURL("image/png"));
    };

    img.src = src;
  });
}

function Uint8ToString(u8a){
  var CHUNK_SZ = 200000;
  var c = [];
  for (var i=0; i < u8a.length; i+=CHUNK_SZ) {
    c.push(String.fromCharCode.apply(null, u8a.subarray(i, i+CHUNK_SZ)));
  }
  return c.join("");
}

function loadImages(elements, dims, timeout) {
  var imgLoads = [];

  $(elements).forEach(function(elm) {
    var src = $(elm).attr('data-cache-url');
    var size = $(elm).attr('data-image-size') || 'list';

    var p = new Promise(function(resolve, reject) {
      DB.getImage(src, size, function(res) {
        $(elm).removeAttr('data-cache-url');
        $(elm).removeAttr('data-image-size');
        if (res) {
          $(elm).on("load", resolve).attr("src", res.data).parent().addClass("cache-loaded");
        } else {
          cache(src, dims).then(function(data) {
            if (data.hasOwnProperty(size)) {
              $(elm).on("load", resolve).attr("src", data[size]).parent().addClass("cache-loaded");
            }
          });
        }
      });
    });

    imgLoads.push(p);
  });

  var timer = new Promise(function(resolve,reject) {
    if (timeout) {
      window.setTimeout(resolve,timeout);
    }
  });

  return Promise.race([timer, Promise.all(imgLoads)]);
}

module.exports.cache = cache;
module.exports.dimensions = dimensions;
module.exports.loadImages = loadImages;

},{"./db":14}],18:[function(require,module,exports){
require('../es6-promise').polyfill();
var ctr = 0;
var ws;
var promises = {};
var subscriptions = {};
var _ = require("lodash");

function connect(host, port) {
  return connect_url('ws://'+host+':'+port+'/jsonrpc');
}

function connect_url(url) {
  /*
   * Return a promise that the connection will be established.
   * When the connection is successful, event handler are setup
   */
  return new Promise(function(resolve, reject) {
    if (!url) {
      reject();
      return;
    }

    ws = undefined;
    var connection = new WebSocket(url);

    // Show the connecting UI
    $("#dialog-connecting").show();
    $("#dialog-connecting button").on('click', function() {
      $(this).off('click');
      connection.close();
    });

    connection.onerror = function() {
      console.log("Connection refused");
      $("#dialog-connecting").hide();
      $("#dialog-connecting button").off('click');
      reject();
    };
    connection.onopen = function() {
      ws = connection;
      $("#dialog-connecting").hide();
      $("#dialog-connecting button").off('click');

      ws.onmessage = function(evt) {
        var data = JSON.parse(evt.data);
        console.log("<-- " + (data.id||"no-id") + " : " + (data.method||"no-method") + " : " + evt.data);

        if (data.id in promises) {
          console.log("Resolving promise [" + data.id + "]");
          var p = promises[data.id];
          p.resolve(data);
          delete promises[data.id];

        } else if (data.method in subscriptions) {
          console.log("Notifying subscription [" + data.method + "]");
          var s = subscriptions[data.method];
          s(data.params);
        
        } else {
          console.warn("Unhandled message [" + (data.id||"no-id") + " : " + (data.method||"no-method") +
              "]; Awaiting: [" + Object.keys(promises).join(', ') + "]");
        }
      };

      ws.onerror = function(err) {
        console.error(err);
      };

      resolve();
    };
  });
}

function send_msg(method, params) {
  console.log("Send msg");
  if (!ws) {
    throw "No WebSocket connection";
  }
  
  var idStr = "msg_"+(ctr++); 
  var msg = {
    jsonrpc: "2.0",
    method: method,
    id: idStr,
  };
  if (params) {
    msg.params = params;
  }

  return new Promise(function(resolve, reject) {
    console.log("--> " + JSON.stringify(msg));
    promises[idStr] = {
      resolve : resolve,
      reject: reject
    };

    if (ws.readyState === WebSocket.OPEN) {
      ws.send(JSON.stringify(msg));
    } else if (ws.url) {
      connect_url(ws.url).then(function() {
        if (ws.readyState === WebSocket.OPEN) {
          ws.send(JSON.stringify(msg));
        } else {
          throw "WebSocket reconnect failed";
        }
      });
    } else {
      throw "Connection failed";
    }
  });
}

function subscribe(method, fct) {
  subscriptions[method] = fct;
}

function unsubscribe(method) {
  // TODO
  delete subscriptions[method];
}

module.exports.connect = connect;
module.exports.send_msg = send_msg;
module.exports.subscribe = subscribe;
module.exports.unsubscribe = unsubscribe;

},{"../es6-promise":15,"lodash":27}],19:[function(require,module,exports){
var type = require("./validate_types");

function required(x, name) {
    if (x === undefined)  {
        throw new Error(name + " is required");
    }
}

function undefinedOrNull(x, name, t) {
  if (x !== undefined && x !== null) {
    throw new Error(name + " should be null");
  }
}

function integer(x, name, t) {
    if (x === undefined)
        return;
    number(x, name, t);
}

function number(x, name, t) {
    if (x === undefined)
        return;
    if (typeof x !== 'number') {
        throw new Error(name + " must be a number; got: " + x);
    }
    if (t.minimum !== undefined && x < t.minimum) {
        throw new Error(name + " must be at least " + t.min + "; actual: " + x);
    }
    if (t.maximum !== undefined && x > t.maximum) {
        throw new Error(name + " must be at most " + t.max + "; actual: " + x);
    }
}

function string(x, name, t) {
    if (x === undefined)
        return;
    if (typeof x !== 'string') {
        throw new Error(name + " must be a string; got: " + x);
    }
    if (t.minLength !== undefined && x.length < t.minLength) {
        throw new Error(name + " must be at least " + t.min + "; actual: " + x.length);
    }
    if (t.maxLength !== undefined && x.length > t.maxLength) {
        throw new Error(name + " must be at most " + t.max + "; actual: " + x.length);
    }
    if (t.enums !== undefined && t.enums.indexOf(x) === -1) {
      throw new Error(name + " must be one of the values: [" + t.enums.join(',') + "]");
    }
}

function boolean(x, name, t) {
  if (x === undefined)
    return;
  if (typeof x !== 'boolean') {
    throw new Error(name + " must be a boolean; got: " + x);
  }
}

function array(x, name, t) {
    if (x === undefined)
        return;
    if (x === undefined || x.length === undefined) {
        throw new Error(name + " must be an array; got: " + (typeof x));
    }
    if (t.minItems !== undefined && x.length < t.minItems) {
        throw new Error(name + " must have at least " + t.min + " items; actual: " + x.length);
    }
    if (t.maxItems !== undefined && x.length > t.maxItems) {
        throw new Error(name + " must have at most " + t.max + " items; actual: " + x.length);
    }
}

module.exports.required = required;
module.exports.undefinedOrNull = undefinedOrNull;
module.exports.boolean = boolean;
module.exports.integer = integer;
module.exports.number = number;
module.exports.string = string;
module.exports.array = array;
module.exports.type = type;

},{"./validate_types":20}],20:[function(require,module,exports){
var validate_type = {};
var validate = require('./validate');

validate_type["Addon.Content"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Addon.Content", {"enums":["unknown","video","audio","image","executable"]});
};

validate_type["Addon.Details"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.addonid, "addonid");
  validate.string(x.addonid, "addonid", {});
  validate.string(x.author, "author", {});
  var types_left = 2;
  try {
    validate.boolean(x.broken, "broken", {});
  } catch (type_ex) {
  }
  try {
    validate.string(x.broken, "broken", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("broken did not match any of the valid types");
    }
  }
  validate.array(x.dependencies, "dependencies", {});
  for (var itemIdx in x.dependencies.items) {
    validate.required(x.addonid, "addonid");
    validate.string(x.addonid, "addonid", {});
    validate.required(x.optional, "optional");
    validate.boolean(x.optional, "optional", {});
    validate.required(x.version, "version");
    validate.string(x.version, "version", {});
  }
  validate.string(x.description, "description", {});
  validate.string(x.disclaimer, "disclaimer", {});
  validate.boolean(x.enabled, "enabled", {});
  validate.array(x.extrainfo, "extrainfo", {});
  for (var itemIdx in x.extrainfo.items) {
    validate.required(x.key, "key");
    validate.string(x.key, "key", {});
    validate.required(x.value, "value");
    validate.string(x.value, "value", {});
  }
  validate.string(x.fanart, "fanart", {});
  validate.string(x.name, "name", {});
  validate.string(x.path, "path", {});
  validate.integer(x.rating, "rating", {});
  validate.string(x.summary, "summary", {});
  validate.string(x.thumbnail, "thumbnail", {});
  validate.required(x.type, "type");
  validate.type["Addon.Types"](x.type, "type");
  validate.string(x.version, "version", {});
  validate.type["Item.Details.Base"](x, "Addon.Details", x);
};

validate_type["Addon.Fields"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Addon.Fields", x);
};

validate_type["Addon.Types"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Addon.Types", {"enums":["unknown","xbmc.metadata.scraper.albums","xbmc.metadata.scraper.artists","xbmc.metadata.scraper.movies","xbmc.metadata.scraper.musicvideos","xbmc.metadata.scraper.tvshows","xbmc.ui.screensaver","xbmc.player.musicviz","xbmc.python.pluginsource","xbmc.python.script","xbmc.python.weather","xbmc.python.subtitles","xbmc.python.lyrics","xbmc.gui.skin","xbmc.gui.webinterface","xbmc.pvrclient","xbmc.addon.video","xbmc.addon.audio","xbmc.addon.image","xbmc.addon.executable","xbmc.service","xbmc.subtitle.module"]});
};

validate_type["Application.Property.Name"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Application.Property.Name", {"enums":["volume","muted","name","version"]});
};

validate_type["Application.Property.Value"] = function (x, name) {
  if (x === undefined) return;
  validate.boolean(x.muted, "muted", {});
  validate.string(x.name, "name", {"minLength":1});
  validate.required(x.major, "major");
  validate.integer(x.major, "major", {"minimum":0});
  validate.required(x.minor, "minor");
  validate.integer(x.minor, "minor", {"minimum":0});
  var types_left = 2;
  try {
    validate.string(x.revision, "revision", {});
  } catch (type_ex) {
  }
  try {
    validate.integer(x.revision, "revision", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("revision did not match any of the valid types");
    }
  }
  validate.required(x.tag, "tag");
  validate.string(x.tag, "tag", {"enums":["prealpha","alpha","beta","releasecandidate","stable"]});
  validate.integer(x.volume, "volume", {"minimum":0,"maximum":100});
};

validate_type["Array.Integer"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x, "Array.Integer", {});
  for (var itemIdx in x.items) {
    validate.integer(x.items[itemIdx], "x.items[itemIdx]", {});
  }
};

validate_type["Array.String"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x, "Array.String", {});
  for (var itemIdx in x.items) {
    validate.string(x.items[itemIdx], "x.items[itemIdx]", {"minLength":1});
  }
};

validate_type["Audio.Details.Album"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.albumid, "albumid");
  validate.type["Library.Id"](x.albumid, "albumid");
  validate.string(x.albumlabel, "albumlabel", {});
  validate.string(x.description, "description", {});
  validate.type["Array.String"](x.mood, "mood");
  validate.integer(x.playcount, "playcount", {});
  validate.type["Array.String"](x.style, "style");
  validate.type["Array.String"](x.theme, "theme");
  validate.string(x.type, "type", {});
  validate.type["Audio.Details.Media"](x, "Audio.Details.Album", x);
};

validate_type["Audio.Details.Artist"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.artist, "artist");
  validate.string(x.artist, "artist", {});
  validate.required(x.artistid, "artistid");
  validate.type["Library.Id"](x.artistid, "artistid");
  validate.string(x.born, "born", {});
  validate.boolean(x.compilationartist, "compilationartist", {});
  validate.string(x.description, "description", {});
  validate.string(x.died, "died", {});
  validate.string(x.disbanded, "disbanded", {});
  validate.string(x.formed, "formed", {});
  validate.type["Array.String"](x.instrument, "instrument");
  validate.type["Array.String"](x.mood, "mood");
  validate.string(x.musicbrainzartistid, "musicbrainzartistid", {});
  validate.type["Array.String"](x.style, "style");
  validate.type["Array.String"](x.yearsactive, "yearsactive");
  validate.type["Audio.Details.Base"](x, "Audio.Details.Artist", x);
};

validate_type["Audio.Details.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Array.String"](x.genre, "genre");
  validate.type["Media.Details.Base"](x, "Audio.Details.Base", x);
};

validate_type["Audio.Details.Media"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Array.String"](x.artist, "artist");
  validate.type["Array.Integer"](x.artistid, "artistid");
  validate.string(x.displayartist, "displayartist", {});
  validate.type["Array.Integer"](x.genreid, "genreid");
  validate.string(x.musicbrainzalbumartistid, "musicbrainzalbumartistid", {});
  validate.string(x.musicbrainzalbumid, "musicbrainzalbumid", {});
  validate.integer(x.rating, "rating", {});
  validate.string(x.title, "title", {});
  validate.integer(x.year, "year", {});
  validate.type["Audio.Details.Base"](x, "Audio.Details.Media", x);
};

validate_type["Audio.Details.Song"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.album, "album", {});
  validate.type["Array.String"](x.albumartist, "albumartist");
  validate.type["Array.Integer"](x.albumartistid, "albumartistid");
  validate.type["Library.Id"](x.albumid, "albumid");
  validate.string(x.comment, "comment", {});
  validate.integer(x.disc, "disc", {});
  validate.integer(x.duration, "duration", {});
  validate.string(x.file, "file", {});
  validate.string(x.lastplayed, "lastplayed", {});
  validate.string(x.lyrics, "lyrics", {});
  validate.string(x.musicbrainzartistid, "musicbrainzartistid", {});
  validate.string(x.musicbrainztrackid, "musicbrainztrackid", {});
  validate.integer(x.playcount, "playcount", {});
  validate.required(x.songid, "songid");
  validate.type["Library.Id"](x.songid, "songid");
  validate.integer(x.track, "track", {});
  validate.type["Audio.Details.Media"](x, "Audio.Details.Song", x);
};

validate_type["Audio.Fields.Album"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Audio.Fields.Album", x);
};

validate_type["Audio.Fields.Artist"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Audio.Fields.Artist", x);
};

validate_type["Audio.Fields.Song"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Audio.Fields.Song", x);
};

validate_type["Configuration"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.notifications, "notifications");
  validate.type["Configuration.Notifications"](x.notifications, "notifications");
};

validate_type["Configuration.Notifications"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.application, "application");
  validate.boolean(x.application, "application", {});
  validate.required(x.audiolibrary, "audiolibrary");
  validate.boolean(x.audiolibrary, "audiolibrary", {});
  validate.required(x.gui, "gui");
  validate.boolean(x.gui, "gui", {});
  validate.required(x.input, "input");
  validate.boolean(x.input, "input", {});
  validate.required(x.other, "other");
  validate.boolean(x.other, "other", {});
  validate.required(x.player, "player");
  validate.boolean(x.player, "player", {});
  validate.required(x.playlist, "playlist");
  validate.boolean(x.playlist, "playlist", {});
  validate.required(x.pvr, "pvr");
  validate.boolean(x.pvr, "pvr", {});
  validate.required(x.system, "system");
  validate.boolean(x.system, "system", {});
  validate.required(x.videolibrary, "videolibrary");
  validate.boolean(x.videolibrary, "videolibrary", {});
};

validate_type["Favourite.Details.Favourite"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.path, "path", {});
  validate.string(x.thumbnail, "thumbnail", {});
  validate.required(x.title, "title");
  validate.string(x.title, "title", {});
  validate.required(x.type, "type");
  validate.type["Favourite.Type"](x.type, "type");
  validate.string(x.window, "window", {});
  validate.string(x.windowparameter, "windowparameter", {});
};

validate_type["Favourite.Fields.Favourite"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Favourite.Fields.Favourite", x);
};

validate_type["Favourite.Type"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Favourite.Type", {"enums":["media","window","script","unknown"]});
};

validate_type["Files.Media"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Files.Media", {"enums":["video","music","pictures","files","programs"]});
};

validate_type["GUI.Property.Name"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "GUI.Property.Name", {"enums":["currentwindow","currentcontrol","skin","fullscreen","stereoscopicmode"]});
};

validate_type["GUI.Property.Value"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.label, "label");
  validate.string(x.label, "label", {});
  validate.required(x.id, "id");
  validate.integer(x.id, "id", {});
  validate.required(x.label, "label");
  validate.string(x.label, "label", {});
  validate.boolean(x.fullscreen, "fullscreen", {});
  validate.required(x.id, "id");
  validate.string(x.id, "id", {"minLength":1});
  validate.string(x.name, "name", {});
  validate.type["GUI.Stereoscopy.Mode"](x.stereoscopicmode, "stereoscopicmode");
};

validate_type["GUI.Stereoscopy.Mode"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.label, "label");
  validate.string(x.label, "label", {});
  validate.required(x.mode, "mode");
  validate.string(x.mode, "mode", {"enums":["off","split_vertical","split_horizontal","row_interleaved","hardware_based","anaglyph_cyan_red","anaglyph_green_magenta","monoscopic"]});
};

validate_type["GUI.Window"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "GUI.Window", {"enums":["home","programs","pictures","filemanager","files","settings","music","video","videos","tv","pvr","pvrguideinfo","pvrrecordinginfo","pvrtimersetting","pvrgroupmanager","pvrchannelmanager","pvrguidesearch","pvrchannelscan","pvrupdateprogress","pvrosdchannels","pvrosdguide","pvrosddirector","pvrosdcutter","pvrosdteletext","systeminfo","testpattern","screencalibration","guicalibration","picturessettings","programssettings","weathersettings","musicsettings","systemsettings","videossettings","networksettings","servicesettings","appearancesettings","pvrsettings","tvsettings","scripts","videofiles","videolibrary","videoplaylist","loginscreen","profiles","skinsettings","addonbrowser","yesnodialog","progressdialog","virtualkeyboard","volumebar","submenu","favourites","contextmenu","infodialog","numericinput","gamepadinput","shutdownmenu","mutebug","playercontrols","seekbar","musicosd","addonsettings","visualisationsettings","visualisationpresetlist","osdvideosettings","osdaudiosettings","videobookmarks","filebrowser","networksetup","mediasource","profilesettings","locksettings","contentsettings","songinformation","smartplaylisteditor","smartplaylistrule","busydialog","pictureinfo","accesspoints","fullscreeninfo","karaokeselector","karaokelargeselector","sliderdialog","addoninformation","subtitlesearch","musicplaylist","musicfiles","musiclibrary","musicplaylisteditor","teletext","selectdialog","musicinformation","okdialog","movieinformation","textviewer","fullscreenvideo","fullscreenlivetv","visualisation","slideshow","filestackingdialog","karaoke","weather","screensaver","videoosd","videomenu","videotimeseek","musicoverlay","videooverlay","startwindow","startup","peripherals","peripheralsettings","extendedprogressdialog","mediafilter","addon"]});
};

validate_type["Global.IncrementDecrement"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Global.IncrementDecrement", {"enums":["increment","decrement"]});
};

validate_type["Global.String.NotEmpty"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Global.String.NotEmpty", {"minLength":1});
};

validate_type["Global.Time"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.hours, "hours");
  validate.integer(x.hours, "hours", {"minimum":0,"maximum":23});
  validate.required(x.milliseconds, "milliseconds");
  validate.integer(x.milliseconds, "milliseconds", {"minimum":0,"maximum":999});
  validate.required(x.minutes, "minutes");
  validate.integer(x.minutes, "minutes", {"minimum":0,"maximum":59});
  validate.required(x.seconds, "seconds");
  validate.integer(x.seconds, "seconds", {"minimum":0,"maximum":59});
};

validate_type["Global.Toggle"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.boolean(x, "Global.Toggle", {});
  } catch (type_ex) {
  }
  try {
    validate.string(x, "Global.Toggle", {"enums":["toggle"]});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Global.Toggle did not match any of the valid types");
    }
  }
};

validate_type["Global.Weekday"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Global.Weekday", {"enums":["monday","tuesday","wednesday","thursday","friday","saturday","sunday"]});
};

validate_type["Input.Action"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Input.Action", {"enums":["left","right","up","down","pageup","pagedown","select","highlight","parentdir","parentfolder","back","previousmenu","info","pause","stop","skipnext","skipprevious","fullscreen","aspectratio","stepforward","stepback","bigstepforward","bigstepback","chapterorbigstepforward","chapterorbigstepback","osd","showsubtitles","nextsubtitle","codecinfo","nextpicture","previouspicture","zoomout","zoomin","playlist","queue","zoomnormal","zoomlevel1","zoomlevel2","zoomlevel3","zoomlevel4","zoomlevel5","zoomlevel6","zoomlevel7","zoomlevel8","zoomlevel9","nextcalibration","resetcalibration","analogmove","rotate","rotateccw","close","subtitledelayminus","subtitledelay","subtitledelayplus","audiodelayminus","audiodelay","audiodelayplus","subtitleshiftup","subtitleshiftdown","subtitlealign","audionextlanguage","verticalshiftup","verticalshiftdown","nextresolution","audiotoggledigital","number0","number1","number2","number3","number4","number5","number6","number7","number8","number9","osdleft","osdright","osdup","osddown","osdselect","osdvalueplus","osdvalueminus","smallstepback","fastforward","rewind","play","playpause","switchplayer","delete","copy","move","mplayerosd","hidesubmenu","screenshot","rename","togglewatched","scanitem","reloadkeymaps","volumeup","volumedown","mute","backspace","scrollup","scrolldown","analogfastforward","analogrewind","moveitemup","moveitemdown","contextmenu","shift","symbols","cursorleft","cursorright","showtime","analogseekforward","analogseekback","showpreset","presetlist","nextpreset","previouspreset","lockpreset","randompreset","increasevisrating","decreasevisrating","showvideomenu","enter","increaserating","decreaserating","togglefullscreen","nextscene","previousscene","nextletter","prevletter","jumpsms2","jumpsms3","jumpsms4","jumpsms5","jumpsms6","jumpsms7","jumpsms8","jumpsms9","filter","filterclear","filtersms2","filtersms3","filtersms4","filtersms5","filtersms6","filtersms7","filtersms8","filtersms9","firstpage","lastpage","guiprofile","red","green","yellow","blue","increasepar","decreasepar","volampup","volampdown","createbookmark","createepisodebookmark","settingsreset","settingslevelchange","stereomode","nextstereomode","previousstereomode","togglestereomode","stereomodetomono","channelup","channeldown","previouschannelgroup","nextchannelgroup","playpvr","playpvrtv","playpvrradio","record","leftclick","rightclick","middleclick","doubleclick","wheelup","wheeldown","mousedrag","mousemove","tap","longpress","pangesture","zoomgesture","rotategesture","swipeleft","swiperight","swipeup","swipedown","noop"]});
};

validate_type["Item.Details.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.label, "label");
  validate.string(x.label, "label", {});
};

validate_type["Item.Fields.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x, "Item.Fields.Base", {"uniqueItems":true});
  for (var itemIdx in x.items) {
    validate.string(x.items[itemIdx], "x.items[itemIdx]", {});
  }
};

validate_type["Library.Details.Genre"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.genreid, "genreid");
  validate.type["Library.Id"](x.genreid, "genreid");
  validate.string(x.thumbnail, "thumbnail", {});
  validate.string(x.title, "title", {});
  validate.type["Item.Details.Base"](x, "Library.Details.Genre", x);
};

validate_type["Library.Fields.Genre"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Library.Fields.Genre", x);
};

validate_type["Library.Id"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x, "Library.Id", {"minimum":1});
};

validate_type["List.Amount"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x, "List.Amount", {"minimum":0});
};

validate_type["List.Fields.All"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "List.Fields.All", x);
};

validate_type["List.Fields.Files"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "List.Fields.Files", x);
};

validate_type["List.Filter.Albums"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.Albums"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.Albums"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.Albums"](x, "List.Filter.Albums");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.Albums did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.Artists"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.Artists"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.Artists"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.Artists"](x, "List.Filter.Artists");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.Artists did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.Episodes"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.Episodes"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.Episodes"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.Episodes"](x, "List.Filter.Episodes");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.Episodes did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.Fields.Albums"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.Albums", {"enums":["genre","album","artist","albumartist","year","review","themes","moods","styles","type","label","rating","playcount","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.Artists"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.Artists", {"enums":["artist","genre","moods","styles","instruments","biography","born","bandformed","disbanded","died","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.Episodes"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.Episodes", {"enums":["title","tvshow","plot","votes","rating","time","writers","airdate","playcount","lastplayed","inprogress","genre","year","director","actor","episode","season","filename","path","studio","mpaarating","dateadded","videoresolution","audiochannels","videocodec","audiocodec","audiolanguage","subtitlelanguage","videoaspect","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.Movies"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.Movies", {"enums":["title","plot","plotoutline","tagline","votes","rating","time","writers","playcount","lastplayed","inprogress","genre","country","year","director","actor","mpaarating","top250","studio","hastrailer","filename","path","set","tag","dateadded","videoresolution","audiochannels","videocodec","audiocodec","audiolanguage","subtitlelanguage","videoaspect","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.MusicVideos"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.MusicVideos", {"enums":["title","genre","album","year","artist","filename","path","playcount","lastplayed","time","director","studio","plot","tag","dateadded","videoresolution","audiochannels","videocodec","audiocodec","audiolanguage","subtitlelanguage","videoaspect","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.Songs"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.Songs", {"enums":["genre","album","artist","albumartist","title","year","time","tracknumber","filename","path","playcount","lastplayed","rating","comment","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.TVShows"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.TVShows", {"enums":["title","plot","status","votes","rating","year","genre","director","actor","numepisodes","numwatched","playcount","path","studio","mpaarating","dateadded","lastplayed","inprogress","tag","playlist","virtualfolder"]});
};

validate_type["List.Filter.Fields.Textures"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Fields.Textures", {"enums":["textureid","url","cachedurl","lasthashcheck","imagehash","width","height","usecount","lastused"]});
};

validate_type["List.Filter.Movies"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.Movies"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.Movies"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.Movies"](x, "List.Filter.Movies");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.Movies did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.MusicVideos"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.MusicVideos"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.MusicVideos"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.MusicVideos"](x, "List.Filter.MusicVideos");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.MusicVideos did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.Operators"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "List.Filter.Operators", {"enums":["contains","doesnotcontain","is","isnot","startswith","endswith","greaterthan","lessthan","after","before","inthelast","notinthelast","true","false","between"]});
};

validate_type["List.Filter.Rule"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.operator, "operator");
  validate.type["List.Filter.Operators"](x.operator, "operator");
  validate.required(x.value, "value");
  var types_left = 2;
  try {
    validate.string(x.value, "value", {});
  } catch (type_ex) {
  }
  try {
    validate.array(x.value, "value", {});
    for (var itemIdx in x.value.items) {
      validate.string(x.value.items[itemIdx], "x.value.items[itemIdx]", {});
    }
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("value did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.Rule.Albums"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.Albums"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.Albums", x);
};

validate_type["List.Filter.Rule.Artists"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.Artists"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.Artists", x);
};

validate_type["List.Filter.Rule.Episodes"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.Episodes"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.Episodes", x);
};

validate_type["List.Filter.Rule.Movies"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.Movies"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.Movies", x);
};

validate_type["List.Filter.Rule.MusicVideos"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.MusicVideos"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.MusicVideos", x);
};

validate_type["List.Filter.Rule.Songs"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.Songs"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.Songs", x);
};

validate_type["List.Filter.Rule.TVShows"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.TVShows"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.TVShows", x);
};

validate_type["List.Filter.Rule.Textures"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.field, "field");
  validate.type["List.Filter.Fields.Textures"](x.field, "field");
  validate.type["List.Filter.Rule"](x, "List.Filter.Rule.Textures", x);
};

validate_type["List.Filter.Songs"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.Songs"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.Songs"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.Songs"](x, "List.Filter.Songs");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.Songs did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.TVShows"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.TVShows"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.TVShows"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.TVShows"](x, "List.Filter.TVShows");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.TVShows did not match any of the valid types");
    }
  }
};

validate_type["List.Filter.Textures"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 3;
  try {
    validate.required(x.and, "and");
    validate.array(x.and, "and", {"minItems":1});
    for (var itemIdx in x.and.items) {
      validate.type["List.Filter.Textures"](x.and.items[itemIdx], "x.and.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.required(x.or, "or");
    validate.array(x.or, "or", {"minItems":1});
    for (var itemIdx in x.or.items) {
      validate.type["List.Filter.Textures"](x.or.items[itemIdx], "x.or.items[itemIdx]");
    }
  } catch (type_ex) {
  }
  try {
    validate.type["List.Filter.Rule.Textures"](x, "List.Filter.Textures");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("List.Filter.Textures did not match any of the valid types");
    }
  }
};

validate_type["List.Item.All"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.channel, "channel", {});
  validate.integer(x.channelnumber, "channelnumber", {});
  validate.type["PVR.Channel.Type"](x.channeltype, "channeltype");
  validate.string(x.endtime, "endtime", {});
  validate.boolean(x.hidden, "hidden", {});
  validate.boolean(x.locked, "locked", {});
  validate.string(x.starttime, "starttime", {});
  validate.type["List.Item.Base"](x, "List.Item.All", x);
};

validate_type["List.Item.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.album, "album", {});
  validate.type["Array.String"](x.albumartist, "albumartist");
  validate.type["Array.Integer"](x.albumartistid, "albumartistid");
  validate.type["Library.Id"](x.albumid, "albumid");
  validate.string(x.albumlabel, "albumlabel", {});
  validate.type["Video.Cast"](x.cast, "cast");
  validate.string(x.comment, "comment", {});
  validate.type["Array.String"](x.country, "country");
  validate.string(x.description, "description", {});
  validate.integer(x.disc, "disc", {});
  validate.integer(x.duration, "duration", {});
  validate.integer(x.episode, "episode", {});
  validate.string(x.episodeguide, "episodeguide", {});
  validate.string(x.firstaired, "firstaired", {});
  validate.type["Library.Id"](x.id, "id");
  validate.string(x.imdbnumber, "imdbnumber", {});
  validate.string(x.lyrics, "lyrics", {});
  validate.type["Array.String"](x.mood, "mood");
  validate.string(x.mpaa, "mpaa", {});
  validate.string(x.musicbrainzartistid, "musicbrainzartistid", {});
  validate.string(x.musicbrainztrackid, "musicbrainztrackid", {});
  validate.string(x.originaltitle, "originaltitle", {});
  validate.string(x.plotoutline, "plotoutline", {});
  validate.string(x.premiered, "premiered", {});
  validate.string(x.productioncode, "productioncode", {});
  validate.integer(x.season, "season", {});
  validate.string(x.set, "set", {});
  validate.type["Library.Id"](x.setid, "setid");
  validate.type["Array.String"](x.showlink, "showlink");
  validate.string(x.showtitle, "showtitle", {});
  validate.string(x.sorttitle, "sorttitle", {});
  validate.type["Array.String"](x.studio, "studio");
  validate.type["Array.String"](x.style, "style");
  validate.type["Array.String"](x.tag, "tag");
  validate.string(x.tagline, "tagline", {});
  validate.type["Array.String"](x.theme, "theme");
  validate.integer(x.top250, "top250", {});
  validate.integer(x.track, "track", {});
  validate.string(x.trailer, "trailer", {});
  validate.type["Library.Id"](x.tvshowid, "tvshowid");
  validate.string(x.type, "type", {"enums":["unknown","movie","episode","musicvideo","song","picture","channel"]});
  validate.string(x.votes, "votes", {});
  validate.integer(x.watchedepisodes, "watchedepisodes", {});
  validate.type["Array.String"](x.writer, "writer");
  validate.type["Video.Details.File,Audio.Details.Media"](x, "List.Item.Base", x);
};

validate_type["List.Item.File"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.file, "file");
  validate.string(x.file, "file", {});
  validate.required(x.filetype, "filetype");
  validate.string(x.filetype, "filetype", {"enums":["file","directory"]});
  validate.string(x.lastmodified, "lastmodified", {});
  validate.string(x.mimetype, "mimetype", {});
  validate.integer(x.size, "size", {});
  validate.type["List.Item.Base"](x, "List.Item.File", x);
};

validate_type["List.Items.Sources"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x, "List.Items.Sources", {});
  for (var itemIdx in x.items) {
    validate.required(x.file, "file");
    validate.string(x.file, "file", {});
    validate.type["Item.Details.Base"](x, "x.items[itemIdx]", x);
  }
};

validate_type["List.Limits"] = function (x, name) {
  if (x === undefined) return;
  validate.type["List.Amount"](x.end, "end");
  validate.integer(x.start, "start", {"minimum":0});
};

validate_type["List.LimitsReturned"] = function (x, name) {
  if (x === undefined) return;
  validate.type["List.Amount"](x.end, "end");
  validate.integer(x.start, "start", {"minimum":0});
  validate.required(x.total, "total");
  validate.integer(x.total, "total", {"minimum":0});
};

validate_type["List.Sort"] = function (x, name) {
  if (x === undefined) return;
  validate.boolean(x.ignorearticle, "ignorearticle", {});
  validate.string(x.method, "method", {"enums":["none","label","date","size","file","path","drivetype","title","track","time","artist","album","albumtype","genre","country","year","rating","votes","top250","programcount","playlist","episode","season","totalepisodes","watchedepisodes","tvshowstatus","tvshowtitle","sorttitle","productioncode","mpaa","studio","dateadded","lastplayed","playcount","listeners","bitrate","random"]});
  validate.string(x.order, "order", {"enums":["ascending","descending"]});
};

validate_type["Media.Artwork"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Global.String.NotEmpty"](x.banner, "banner");
  validate.type["Global.String.NotEmpty"](x.fanart, "fanart");
  validate.type["Global.String.NotEmpty"](x.poster, "poster");
  validate.type["Global.String.NotEmpty"](x.thumb, "thumb");
};

validate_type["Media.Artwork.Set"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.undefinedOrNull(x.banner, "banner", undefined);
  } catch (type_ex) {
  }
  try {
    validate.type["Global.String.NotEmpty"](x.banner, "banner");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("banner did not match any of the valid types");
    }
  }
  var types_left = 2;
  try {
    validate.undefinedOrNull(x.fanart, "fanart", undefined);
  } catch (type_ex) {
  }
  try {
    validate.type["Global.String.NotEmpty"](x.fanart, "fanart");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("fanart did not match any of the valid types");
    }
  }
  var types_left = 2;
  try {
    validate.undefinedOrNull(x.poster, "poster", undefined);
  } catch (type_ex) {
  }
  try {
    validate.type["Global.String.NotEmpty"](x.poster, "poster");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("poster did not match any of the valid types");
    }
  }
  var types_left = 2;
  try {
    validate.undefinedOrNull(x.thumb, "thumb", undefined);
  } catch (type_ex) {
  }
  try {
    validate.type["Global.String.NotEmpty"](x.thumb, "thumb");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("thumb did not match any of the valid types");
    }
  }
};

validate_type["Media.Details.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.fanart, "fanart", {});
  validate.string(x.thumbnail, "thumbnail", {});
  validate.type["Item.Details.Base"](x, "Media.Details.Base", x);
};

validate_type["Notifications.Item"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 8;
  try {
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
  }
  try {
    validate.required(x.id, "id");
    validate.type["Library.Id"](x.id, "id");
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
  }
  try {
    validate.required(x.title, "title");
    validate.string(x.title, "title", {});
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
    validate.integer(x.year, "year", {});
  } catch (type_ex) {
  }
  try {
    validate.integer(x.episode, "episode", {});
    validate.integer(x.season, "season", {});
    validate.string(x.showtitle, "showtitle", {});
    validate.required(x.title, "title");
    validate.string(x.title, "title", {});
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
  }
  try {
    validate.string(x.album, "album", {});
    validate.string(x.artist, "artist", {});
    validate.required(x.title, "title");
    validate.string(x.title, "title", {});
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
  }
  try {
    validate.string(x.album, "album", {});
    validate.string(x.artist, "artist", {});
    validate.required(x.title, "title");
    validate.string(x.title, "title", {});
    validate.integer(x.track, "track", {});
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
  }
  try {
    validate.required(x.file, "file");
    validate.string(x.file, "file", {});
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
  }
  try {
    validate.required(x.channeltype, "channeltype");
    validate.type["PVR.Channel.Type"](x.channeltype, "channeltype");
    validate.required(x.id, "id");
    validate.type["Library.Id"](x.id, "id");
    validate.required(x.title, "title");
    validate.string(x.title, "title", {});
    validate.required(x.type, "type");
    validate.type["Notifications.Item.Type"](x.type, "type");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Notifications.Item did not match any of the valid types");
    }
  }
};

validate_type["Notifications.Item.Type"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Notifications.Item.Type", {"enums":["unknown","movie","episode","musicvideo","song","picture","channel"]});
};

validate_type["Optional.Boolean"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.undefinedOrNull(x, "Optional.Boolean", undefined);
  } catch (type_ex) {
  }
  try {
    validate.boolean(x, "Optional.Boolean", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Optional.Boolean did not match any of the valid types");
    }
  }
};

validate_type["Optional.Integer"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.undefinedOrNull(x, "Optional.Integer", undefined);
  } catch (type_ex) {
  }
  try {
    validate.integer(x, "Optional.Integer", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Optional.Integer did not match any of the valid types");
    }
  }
};

validate_type["Optional.Number"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.undefinedOrNull(x, "Optional.Number", undefined);
  } catch (type_ex) {
  }
  try {
    validate.number(x, "Optional.Number", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Optional.Number did not match any of the valid types");
    }
  }
};

validate_type["Optional.String"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.undefinedOrNull(x, "Optional.String", undefined);
  } catch (type_ex) {
  }
  try {
    validate.string(x, "Optional.String", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Optional.String did not match any of the valid types");
    }
  }
};

validate_type["PVR.Channel.Type"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "PVR.Channel.Type", {"enums":["tv","radio"]});
};

validate_type["PVR.ChannelGroup.Id"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 2;
  try {
    validate.type["Library.Id"](x, "PVR.ChannelGroup.Id");
  } catch (type_ex) {
  }
  try {
    validate.string(x, "PVR.ChannelGroup.Id", {"enums":["alltv","allradio"]});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("PVR.ChannelGroup.Id did not match any of the valid types");
    }
  }
};

validate_type["PVR.Details.Broadcast"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.broadcastid, "broadcastid");
  validate.type["Library.Id"](x.broadcastid, "broadcastid");
  validate.string(x.endtime, "endtime", {});
  validate.string(x.episodename, "episodename", {});
  validate.integer(x.episodenum, "episodenum", {});
  validate.integer(x.episodepart, "episodepart", {});
  validate.string(x.firstaired, "firstaired", {});
  validate.string(x.genre, "genre", {});
  validate.boolean(x.hastimer, "hastimer", {});
  validate.boolean(x.isactive, "isactive", {});
  validate.integer(x.parentalrating, "parentalrating", {});
  validate.string(x.plot, "plot", {});
  validate.string(x.plotoutline, "plotoutline", {});
  validate.integer(x.progress, "progress", {});
  validate.number(x.progresspercentage, "progresspercentage", {});
  validate.integer(x.rating, "rating", {});
  validate.integer(x.runtime, "runtime", {});
  validate.string(x.starttime, "starttime", {});
  validate.string(x.thumbnail, "thumbnail", {});
  validate.string(x.title, "title", {});
  validate.boolean(x.wasactive, "wasactive", {});
  validate.type["Item.Details.Base"](x, "PVR.Details.Broadcast", x);
};

validate_type["PVR.Details.Channel"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.channel, "channel", {});
  validate.required(x.channelid, "channelid");
  validate.type["Library.Id"](x.channelid, "channelid");
  validate.type["PVR.Channel.Type"](x.channeltype, "channeltype");
  validate.boolean(x.hidden, "hidden", {});
  validate.string(x.lastplayed, "lastplayed", {});
  validate.boolean(x.locked, "locked", {});
  validate.string(x.thumbnail, "thumbnail", {});
  validate.type["Item.Details.Base"](x, "PVR.Details.Channel", x);
};

validate_type["PVR.Details.ChannelGroup"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.channelgroupid, "channelgroupid");
  validate.type["Library.Id"](x.channelgroupid, "channelgroupid");
  validate.required(x.channeltype, "channeltype");
  validate.type["PVR.Channel.Type"](x.channeltype, "channeltype");
  validate.type["Item.Details.Base"](x, "PVR.Details.ChannelGroup", x);
};

validate_type["PVR.Details.ChannelGroup.Extended"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x.channels, "channels", {});
  for (var itemIdx in x.channels.items) {
    validate.type["PVR.Details.Channel"](x.channels.items[itemIdx], "x.channels.items[itemIdx]");
  }
  validate.required(x.limits, "limits");
  validate.type["List.LimitsReturned"](x.limits, "limits");
  validate.type["PVR.Details.ChannelGroup"](x, "PVR.Details.ChannelGroup.Extended", x);
};

validate_type["PVR.Details.Recording"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Media.Artwork"](x.art, "art");
  validate.string(x.channel, "channel", {});
  validate.string(x.directory, "directory", {});
  validate.string(x.endtime, "endtime", {});
  validate.string(x.file, "file", {});
  validate.string(x.genre, "genre", {});
  validate.string(x.icon, "icon", {});
  validate.integer(x.lifetime, "lifetime", {});
  validate.integer(x.playcount, "playcount", {});
  validate.string(x.plot, "plot", {});
  validate.string(x.plotoutline, "plotoutline", {});
  validate.required(x.recordingid, "recordingid");
  validate.type["Library.Id"](x.recordingid, "recordingid");
  validate.type["Video.Resume"](x.resume, "resume");
  validate.integer(x.runtime, "runtime", {});
  validate.string(x.starttime, "starttime", {});
  validate.string(x.streamurl, "streamurl", {});
  validate.string(x.title, "title", {});
  validate.type["Item.Details.Base"](x, "PVR.Details.Recording", x);
};

validate_type["PVR.Details.Timer"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Library.Id"](x.channelid, "channelid");
  validate.string(x.directory, "directory", {});
  validate.integer(x.endmargin, "endmargin", {});
  validate.string(x.endtime, "endtime", {});
  validate.string(x.file, "file", {});
  validate.string(x.firstday, "firstday", {});
  validate.boolean(x.isradio, "isradio", {});
  validate.integer(x.lifetime, "lifetime", {});
  validate.integer(x.priority, "priority", {});
  validate.boolean(x.repeating, "repeating", {});
  validate.integer(x.runtime, "runtime", {});
  validate.integer(x.startmargin, "startmargin", {});
  validate.string(x.starttime, "starttime", {});
  validate.type["PVR.TimerState"](x.state, "state");
  validate.string(x.summary, "summary", {});
  validate.required(x.timerid, "timerid");
  validate.type["Library.Id"](x.timerid, "timerid");
  validate.string(x.title, "title", {});
  validate.array(x.weekdays, "weekdays", {"uniqueItems":true});
  for (var itemIdx in x.weekdays.items) {
    validate.type["Global.Weekday"](x.weekdays.items[itemIdx], "x.weekdays.items[itemIdx]");
  }
  validate.type["Item.Details.Base"](x, "PVR.Details.Timer", x);
};

validate_type["PVR.Fields.Broadcast"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "PVR.Fields.Broadcast", x);
};

validate_type["PVR.Fields.Channel"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "PVR.Fields.Channel", x);
};

validate_type["PVR.Fields.Recording"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "PVR.Fields.Recording", x);
};

validate_type["PVR.Fields.Timer"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "PVR.Fields.Timer", x);
};

validate_type["PVR.Property.Name"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "PVR.Property.Name", {"enums":["available","recording","scanning"]});
};

validate_type["PVR.Property.Value"] = function (x, name) {
  if (x === undefined) return;
  validate.boolean(x.available, "available", {});
  validate.boolean(x.recording, "recording", {});
  validate.boolean(x.scanning, "scanning", {});
};

validate_type["PVR.TimerState"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "PVR.TimerState", {"enums":["unknown","new","scheduled","recording","completed","aborted","cancelled","conflict_ok","conflict_notok","error"]});
};

validate_type["Player.Audio.Stream"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.bitrate, "bitrate");
  validate.integer(x.bitrate, "bitrate", {});
  validate.required(x.channels, "channels");
  validate.integer(x.channels, "channels", {});
  validate.required(x.codec, "codec");
  validate.string(x.codec, "codec", {});
  validate.required(x.index, "index");
  validate.integer(x.index, "index", {"minimum":0});
  validate.required(x.language, "language");
  validate.string(x.language, "language", {});
  validate.required(x.name, "name");
  validate.string(x.name, "name", {});
};

validate_type["Player.Id"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x, "Player.Id", {"minimum":0,"maximum":2});
};

validate_type["Player.Notifications.Data"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.item, "item");
  validate.type["Notifications.Item"](x.item, "item");
  validate.required(x.player, "player");
  validate.type["Player.Notifications.Player"](x.player, "player");
};

validate_type["Player.Notifications.Player"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.playerid, "playerid");
  validate.type["Player.Id"](x.playerid, "playerid");
  validate.integer(x.speed, "speed", {});
};

validate_type["Player.Notifications.Player.Seek"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Global.Time"](x.seekoffset, "seekoffset");
  validate.type["Global.Time"](x.time, "time");
  validate.type["Player.Notifications.Player"](x, "Player.Notifications.Player.Seek", x);
};

validate_type["Player.Position.Percentage"] = function (x, name) {
  if (x === undefined) return;
  validate.number(x, "Player.Position.Percentage", {"minimum":0,"maximum":100});
};

validate_type["Player.Position.Time"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x.hours, "hours", {"minimum":0,"maximum":23});
  validate.integer(x.milliseconds, "milliseconds", {"minimum":0,"maximum":999});
  validate.integer(x.minutes, "minutes", {"minimum":0,"maximum":59});
  validate.integer(x.seconds, "seconds", {"minimum":0,"maximum":59});
};

validate_type["Player.Property.Name"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Player.Property.Name", {"enums":["type","partymode","speed","time","percentage","totaltime","playlistid","position","repeat","shuffled","canseek","canchangespeed","canmove","canzoom","canrotate","canshuffle","canrepeat","currentaudiostream","audiostreams","subtitleenabled","currentsubtitle","subtitles","live"]});
};

validate_type["Player.Property.Value"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x.audiostreams, "audiostreams", {});
  for (var itemIdx in x.audiostreams.items) {
    validate.type["Player.Audio.Stream"](x.audiostreams.items[itemIdx], "x.audiostreams.items[itemIdx]");
  }
  validate.boolean(x.canchangespeed, "canchangespeed", {});
  validate.boolean(x.canmove, "canmove", {});
  validate.boolean(x.canrepeat, "canrepeat", {});
  validate.boolean(x.canrotate, "canrotate", {});
  validate.boolean(x.canseek, "canseek", {});
  validate.boolean(x.canshuffle, "canshuffle", {});
  validate.boolean(x.canzoom, "canzoom", {});
  validate.type["Player.Audio.Stream"](x.currentaudiostream, "currentaudiostream");
  validate.type["Player.Subtitle"](x.currentsubtitle, "currentsubtitle");
  validate.boolean(x.live, "live", {});
  validate.boolean(x.partymode, "partymode", {});
  validate.type["Player.Position.Percentage"](x.percentage, "percentage");
  validate.type["Playlist.Id"](x.playlistid, "playlistid");
  validate.type["Playlist.Position"](x.position, "position");
  validate.type["Player.Repeat"](x.repeat, "repeat");
  validate.boolean(x.shuffled, "shuffled", {});
  validate.integer(x.speed, "speed", {});
  validate.boolean(x.subtitleenabled, "subtitleenabled", {});
  validate.array(x.subtitles, "subtitles", {});
  for (var itemIdx in x.subtitles.items) {
    validate.type["Player.Subtitle"](x.subtitles.items[itemIdx], "x.subtitles.items[itemIdx]");
  }
  validate.type["Global.Time"](x.time, "time");
  validate.type["Global.Time"](x.totaltime, "totaltime");
  validate.type["Player.Type"](x.type, "type");
};

validate_type["Player.Repeat"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Player.Repeat", {"enums":["off","one","all"]});
};

validate_type["Player.Speed"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x.speed, "speed", {});
};

validate_type["Player.Subtitle"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.index, "index");
  validate.integer(x.index, "index", {"minimum":0});
  validate.required(x.language, "language");
  validate.string(x.language, "language", {});
  validate.required(x.name, "name");
  validate.string(x.name, "name", {});
};

validate_type["Player.Type"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Player.Type", {"enums":["video","audio","picture"]});
};

validate_type["Playlist.Id"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x, "Playlist.Id", {"minimum":0,"maximum":2});
};

validate_type["Playlist.Item"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 9;
  try {
    validate.required(x.file, "file");
    validate.string(x.file, "file", {});
  } catch (type_ex) {
  }
  try {
    validate.required(x.directory, "directory");
    validate.string(x.directory, "directory", {});
    validate.type["Files.Media"](x.media, "media");
    validate.boolean(x.recursive, "recursive", {});
  } catch (type_ex) {
  }
  try {
    validate.required(x.movieid, "movieid");
    validate.type["Library.Id"](x.movieid, "movieid");
  } catch (type_ex) {
  }
  try {
    validate.required(x.episodeid, "episodeid");
    validate.type["Library.Id"](x.episodeid, "episodeid");
  } catch (type_ex) {
  }
  try {
    validate.required(x.musicvideoid, "musicvideoid");
    validate.type["Library.Id"](x.musicvideoid, "musicvideoid");
  } catch (type_ex) {
  }
  try {
    validate.required(x.artistid, "artistid");
    validate.type["Library.Id"](x.artistid, "artistid");
  } catch (type_ex) {
  }
  try {
    validate.required(x.albumid, "albumid");
    validate.type["Library.Id"](x.albumid, "albumid");
  } catch (type_ex) {
  }
  try {
    validate.required(x.songid, "songid");
    validate.type["Library.Id"](x.songid, "songid");
  } catch (type_ex) {
  }
  try {
    validate.required(x.genreid, "genreid");
    validate.type["Library.Id"](x.genreid, "genreid");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Playlist.Item did not match any of the valid types");
    }
  }
};

validate_type["Playlist.Position"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x, "Playlist.Position", {"minimum":0});
};

validate_type["Playlist.Property.Name"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Playlist.Property.Name", {"enums":["type","size"]});
};

validate_type["Playlist.Property.Value"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x.size, "size", {"minimum":0});
  validate.type["Playlist.Type"](x.type, "type");
};

validate_type["Playlist.Type"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Playlist.Type", {"enums":["unknown","video","audio","picture","mixed"]});
};

validate_type["Profiles.Details.Profile"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x.lockmode, "lockmode", {});
  validate.string(x.thumbnail, "thumbnail", {});
  validate.type["Item.Details.Base"](x, "Profiles.Details.Profile", x);
};

validate_type["Profiles.Fields.Profile"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Profiles.Fields.Profile", x);
};

validate_type["Profiles.Password"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.encryption, "encryption", {"enums":["none","md5"]});
  validate.required(x.value, "value");
  validate.string(x.value, "value", {});
};

validate_type["Setting.Details.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.help, "help", {});
  validate.required(x.id, "id");
  validate.string(x.id, "id", {"minLength":1});
  validate.required(x.label, "label");
  validate.string(x.label, "label", {});
};

validate_type["Setting.Details.Category"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x.groups, "groups", {"minItems":1,"uniqueItems":true});
  for (var itemIdx in x.groups.items) {
    validate.type["Setting.Details.Group"](x.groups.items[itemIdx], "x.groups.items[itemIdx]");
  }
  validate.type["Setting.Details.Base"](x, "Setting.Details.Category", x);
};

validate_type["Setting.Details.Control"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 5;
  try {
    validate.type["Setting.Details.ControlCheckmark"](x, "Setting.Details.Control");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.ControlSpinner"](x, "Setting.Details.Control");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.ControlEdit"](x, "Setting.Details.Control");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.ControlButton"](x, "Setting.Details.Control");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.ControlList"](x, "Setting.Details.Control");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Setting.Details.Control did not match any of the valid types");
    }
  }
};

validate_type["Setting.Details.ControlBase"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.delayed, "delayed");
  validate.boolean(x.delayed, "delayed", {});
  validate.required(x.format, "format");
  validate.string(x.format, "format", {});
  validate.required(x.type, "type");
  validate.string(x.type, "type", {});
};

validate_type["Setting.Details.ControlButton"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.type, "type");
  validate.string(x.type, "type", {"enums":["button"]});
  validate.type["Setting.Details.ControlHeading"](x, "Setting.Details.ControlButton", x);
};

validate_type["Setting.Details.ControlCheckmark"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.format, "format");
  validate.string(x.format, "format", {"enums":["boolean"]});
  validate.required(x.type, "type");
  validate.string(x.type, "type", {"enums":["toggle"]});
  validate.type["Setting.Details.ControlBase"](x, "Setting.Details.ControlCheckmark", x);
};

validate_type["Setting.Details.ControlEdit"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.hidden, "hidden");
  validate.boolean(x.hidden, "hidden", {});
  validate.required(x.type, "type");
  validate.string(x.type, "type", {"enums":["edit"]});
  validate.required(x.verifynewvalue, "verifynewvalue");
  validate.boolean(x.verifynewvalue, "verifynewvalue", {});
  validate.type["Setting.Details.ControlHeading"](x, "Setting.Details.ControlEdit", x);
};

validate_type["Setting.Details.ControlHeading"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.heading, "heading", {});
  validate.type["Setting.Details.ControlBase"](x, "Setting.Details.ControlHeading", x);
};

validate_type["Setting.Details.ControlList"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.multiselect, "multiselect");
  validate.boolean(x.multiselect, "multiselect", {});
  validate.required(x.type, "type");
  validate.string(x.type, "type", {"enums":["list"]});
  validate.type["Setting.Details.ControlHeading"](x, "Setting.Details.ControlList", x);
};

validate_type["Setting.Details.ControlSpinner"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.formatlabel, "formatlabel", {});
  validate.string(x.minimumlabel, "minimumlabel", {});
  validate.required(x.type, "type");
  validate.string(x.type, "type", {"enums":["spinner"]});
  validate.type["Setting.Details.ControlBase"](x, "Setting.Details.ControlSpinner", x);
};

validate_type["Setting.Details.Group"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.id, "id");
  validate.string(x.id, "id", {"minLength":1});
  validate.array(x.settings, "settings", {"minItems":1,"uniqueItems":true});
  for (var itemIdx in x.settings.items) {
    validate.type["Setting.Details.Setting"](x.settings.items[itemIdx], "x.settings.items[itemIdx]");
  }
};

validate_type["Setting.Details.Section"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x.categories, "categories", {"minItems":1,"uniqueItems":true});
  for (var itemIdx in x.categories.items) {
    validate.type["Setting.Details.Category"](x.categories.items[itemIdx], "x.categories.items[itemIdx]");
  }
  validate.type["Setting.Details.Base"](x, "Setting.Details.Section", x);
};

validate_type["Setting.Details.Setting"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 8;
  try {
    validate.type["Setting.Details.SettingBool"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingInt"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingNumber"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingString"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingAction"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingList"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingPath"](x, "Setting.Details.Setting");
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Details.SettingAddon"](x, "Setting.Details.Setting");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Setting.Details.Setting did not match any of the valid types");
    }
  }
};

validate_type["Setting.Details.SettingAction"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Setting.Details.SettingBase"](x, "Setting.Details.SettingAction", x);
};

validate_type["Setting.Details.SettingAddon"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.addontype, "addontype");
  validate.type["Addon.Types"](x.addontype, "addontype");
  validate.type["Setting.Details.SettingString"](x, "Setting.Details.SettingAddon", x);
};

validate_type["Setting.Details.SettingBase"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Setting.Details.Control"](x.control, "control");
  validate.required(x.enabled, "enabled");
  validate.boolean(x.enabled, "enabled", {});
  validate.required(x.level, "level");
  validate.integer(x.level, "level", {});
  validate.string(x.parent, "parent", {});
  validate.required(x.type, "type");
  validate.type["Setting.Type"](x.type, "type");
  validate.type["Setting.Details.Base"](x, "Setting.Details.SettingBase", x);
};

validate_type["Setting.Details.SettingBool"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.default, "default");
  validate.boolean(x.default, "default", {});
  validate.required(x.value, "value");
  validate.boolean(x.value, "value", {});
  validate.type["Setting.Details.SettingBase"](x, "Setting.Details.SettingBool", x);
};

validate_type["Setting.Details.SettingInt"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.default, "default");
  validate.integer(x.default, "default", {});
  validate.integer(x.maximum, "maximum", {});
  validate.integer(x.minimum, "minimum", {});
  validate.array(x.options, "options", {});
  for (var itemIdx in x.options.items) {
    validate.required(x.label, "label");
    validate.string(x.label, "label", {});
    validate.required(x.value, "value");
    validate.integer(x.value, "value", {});
  }
  validate.integer(x.step, "step", {});
  validate.required(x.value, "value");
  validate.integer(x.value, "value", {});
  validate.type["Setting.Details.SettingBase"](x, "Setting.Details.SettingInt", x);
};

validate_type["Setting.Details.SettingList"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.default, "default");
  validate.type["Setting.Value.List"](x.default, "default");
  validate.required(x.definition, "definition");
  validate.type["Setting.Details.Setting"](x.definition, "definition");
  validate.required(x.delimiter, "delimiter");
  validate.string(x.delimiter, "delimiter", {});
  validate.required(x.elementtype, "elementtype");
  validate.type["Setting.Type"](x.elementtype, "elementtype");
  validate.integer(x.maximumitems, "maximumitems", {});
  validate.integer(x.minimumitems, "minimumitems", {});
  validate.required(x.value, "value");
  validate.type["Setting.Value.List"](x.value, "value");
  validate.type["Setting.Details.SettingBase"](x, "Setting.Details.SettingList", x);
};

validate_type["Setting.Details.SettingNumber"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.default, "default");
  validate.number(x.default, "default", {});
  validate.required(x.maximum, "maximum");
  validate.number(x.maximum, "maximum", {});
  validate.required(x.minimum, "minimum");
  validate.number(x.minimum, "minimum", {});
  validate.required(x.step, "step");
  validate.number(x.step, "step", {});
  validate.required(x.value, "value");
  validate.number(x.value, "value", {});
  validate.type["Setting.Details.SettingBase"](x, "Setting.Details.SettingNumber", x);
};

validate_type["Setting.Details.SettingPath"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x.sources, "sources", {});
  for (var itemIdx in x.sources.items) {
    validate.string(x.sources.items[itemIdx], "x.sources.items[itemIdx]", {});
  }
  validate.required(x.writable, "writable");
  validate.boolean(x.writable, "writable", {});
  validate.type["Setting.Details.SettingString"](x, "Setting.Details.SettingPath", x);
};

validate_type["Setting.Details.SettingString"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.allowempty, "allowempty");
  validate.boolean(x.allowempty, "allowempty", {});
  validate.required(x.default, "default");
  validate.string(x.default, "default", {});
  validate.array(x.options, "options", {});
  for (var itemIdx in x.options.items) {
    validate.required(x.label, "label");
    validate.string(x.label, "label", {});
    validate.required(x.value, "value");
    validate.string(x.value, "value", {});
  }
  validate.required(x.value, "value");
  validate.string(x.value, "value", {});
  validate.type["Setting.Details.SettingBase"](x, "Setting.Details.SettingString", x);
};

validate_type["Setting.Level"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Setting.Level", {"enums":["basic","standard","advanced","expert"]});
};

validate_type["Setting.Type"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "Setting.Type", {"enums":["boolean","integer","number","string","action","list","path","addon"]});
};

validate_type["Setting.Value"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 4;
  try {
    validate.boolean(x, "Setting.Value", {});
  } catch (type_ex) {
  }
  try {
    validate.integer(x, "Setting.Value", {});
  } catch (type_ex) {
  }
  try {
    validate.number(x, "Setting.Value", {});
  } catch (type_ex) {
  }
  try {
    validate.string(x, "Setting.Value", {});
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Setting.Value did not match any of the valid types");
    }
  }
};

validate_type["Setting.Value.Extended"] = function (x, name) {
  if (x === undefined) return;
  var types_left = 5;
  try {
    validate.boolean(x, "Setting.Value.Extended", {});
  } catch (type_ex) {
  }
  try {
    validate.integer(x, "Setting.Value.Extended", {});
  } catch (type_ex) {
  }
  try {
    validate.number(x, "Setting.Value.Extended", {});
  } catch (type_ex) {
  }
  try {
    validate.string(x, "Setting.Value.Extended", {});
  } catch (type_ex) {
  }
  try {
    validate.type["Setting.Value.List"](x, "Setting.Value.Extended");
  } catch (type_ex) {
    if (--types_left === 0) {
      throw new Error("Setting.Value.Extended did not match any of the valid types");
    }
  }
};

validate_type["Setting.Value.List"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x, "Setting.Value.List", {});
  for (var itemIdx in x.items) {
    validate.type["Setting.Value"](x.items[itemIdx], "x.items[itemIdx]");
  }
};

validate_type["System.Property.Name"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x, "System.Property.Name", {"enums":["canshutdown","cansuspend","canhibernate","canreboot"]});
};

validate_type["System.Property.Value"] = function (x, name) {
  if (x === undefined) return;
  validate.boolean(x.canhibernate, "canhibernate", {});
  validate.boolean(x.canreboot, "canreboot", {});
  validate.boolean(x.canshutdown, "canshutdown", {});
  validate.boolean(x.cansuspend, "cansuspend", {});
};

validate_type["Textures.Details.Size"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x.height, "height", {});
  validate.string(x.lastused, "lastused", {});
  validate.integer(x.size, "size", {});
  validate.integer(x.usecount, "usecount", {});
  validate.integer(x.width, "width", {});
};

validate_type["Textures.Details.Texture"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.cachedurl, "cachedurl", {});
  validate.string(x.imagehash, "imagehash", {});
  validate.string(x.lasthashcheck, "lasthashcheck", {});
  validate.array(x.sizes, "sizes", {});
  for (var itemIdx in x.sizes.items) {
    validate.type["Textures.Details.Size"](x.sizes.items[itemIdx], "x.sizes.items[itemIdx]");
  }
  validate.type["Library.Id"](x.textureid, "textureid");
  validate.string(x.url, "url", {});
};

validate_type["Textures.Fields.Texture"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Textures.Fields.Texture", x);
};

validate_type["Video.Cast"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x, "Video.Cast", {});
  for (var itemIdx in x.items) {
    validate.required(x.name, "name");
    validate.string(x.name, "name", {});
    validate.required(x.order, "order");
    validate.integer(x.order, "order", {});
    validate.required(x.role, "role");
    validate.string(x.role, "role", {});
    validate.string(x.thumbnail, "thumbnail", {});
  }
};

validate_type["Video.Details.Base"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Media.Artwork"](x.art, "art");
  validate.integer(x.playcount, "playcount", {});
  validate.type["Media.Details.Base"](x, "Video.Details.Base", x);
};

validate_type["Video.Details.Episode"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Video.Cast"](x.cast, "cast");
  validate.integer(x.episode, "episode", {});
  validate.required(x.episodeid, "episodeid");
  validate.type["Library.Id"](x.episodeid, "episodeid");
  validate.string(x.firstaired, "firstaired", {});
  validate.string(x.originaltitle, "originaltitle", {});
  validate.string(x.productioncode, "productioncode", {});
  validate.number(x.rating, "rating", {});
  validate.integer(x.season, "season", {});
  validate.string(x.showtitle, "showtitle", {});
  validate.type["Library.Id"](x.tvshowid, "tvshowid");
  validate.string(x.votes, "votes", {});
  validate.type["Array.String"](x.writer, "writer");
  validate.type["Video.Details.File"](x, "Video.Details.Episode", x);
};

validate_type["Video.Details.File"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Array.String"](x.director, "director");
  validate.type["Video.Resume"](x.resume, "resume");
  validate.integer(x.runtime, "runtime", {});
  validate.type["Video.Streams"](x.streamdetails, "streamdetails");
  validate.type["Video.Details.Item"](x, "Video.Details.File", x);
};

validate_type["Video.Details.Item"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.dateadded, "dateadded", {});
  validate.string(x.file, "file", {});
  validate.string(x.lastplayed, "lastplayed", {});
  validate.string(x.plot, "plot", {});
  validate.type["Video.Details.Media"](x, "Video.Details.Item", x);
};

validate_type["Video.Details.Media"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.title, "title", {});
  validate.type["Video.Details.Base"](x, "Video.Details.Media", x);
};

validate_type["Video.Details.Movie"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Video.Cast"](x.cast, "cast");
  validate.type["Array.String"](x.country, "country");
  validate.type["Array.String"](x.genre, "genre");
  validate.string(x.imdbnumber, "imdbnumber", {});
  validate.required(x.movieid, "movieid");
  validate.type["Library.Id"](x.movieid, "movieid");
  validate.string(x.mpaa, "mpaa", {});
  validate.string(x.originaltitle, "originaltitle", {});
  validate.string(x.plotoutline, "plotoutline", {});
  validate.number(x.rating, "rating", {});
  validate.string(x.set, "set", {});
  validate.type["Library.Id"](x.setid, "setid");
  validate.type["Array.String"](x.showlink, "showlink");
  validate.string(x.sorttitle, "sorttitle", {});
  validate.type["Array.String"](x.studio, "studio");
  validate.type["Array.String"](x.tag, "tag");
  validate.string(x.tagline, "tagline", {});
  validate.integer(x.top250, "top250", {});
  validate.string(x.trailer, "trailer", {});
  validate.string(x.votes, "votes", {});
  validate.type["Array.String"](x.writer, "writer");
  validate.integer(x.year, "year", {});
  validate.type["Video.Details.File"](x, "Video.Details.Movie", x);
};

validate_type["Video.Details.MovieSet"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.setid, "setid");
  validate.type["Library.Id"](x.setid, "setid");
  validate.type["Video.Details.Media"](x, "Video.Details.MovieSet", x);
};

validate_type["Video.Details.MovieSet.Extended"] = function (x, name) {
  if (x === undefined) return;
  validate.required(x.limits, "limits");
  validate.type["List.LimitsReturned"](x.limits, "limits");
  validate.array(x.movies, "movies", {});
  for (var itemIdx in x.movies.items) {
    validate.type["Video.Details.Movie"](x.movies.items[itemIdx], "x.movies.items[itemIdx]");
  }
  validate.type["Video.Details.MovieSet"](x, "Video.Details.MovieSet.Extended", x);
};

validate_type["Video.Details.MusicVideo"] = function (x, name) {
  if (x === undefined) return;
  validate.string(x.album, "album", {});
  validate.type["Array.String"](x.artist, "artist");
  validate.type["Array.String"](x.genre, "genre");
  validate.required(x.musicvideoid, "musicvideoid");
  validate.type["Library.Id"](x.musicvideoid, "musicvideoid");
  validate.type["Array.String"](x.studio, "studio");
  validate.type["Array.String"](x.tag, "tag");
  validate.integer(x.track, "track", {});
  validate.integer(x.year, "year", {});
  validate.type["Video.Details.File"](x, "Video.Details.MusicVideo", x);
};

validate_type["Video.Details.Season"] = function (x, name) {
  if (x === undefined) return;
  validate.integer(x.episode, "episode", {});
  validate.required(x.season, "season");
  validate.integer(x.season, "season", {});
  validate.required(x.seasonid, "seasonid");
  validate.type["Library.Id"](x.seasonid, "seasonid");
  validate.string(x.showtitle, "showtitle", {});
  validate.type["Library.Id"](x.tvshowid, "tvshowid");
  validate.integer(x.watchedepisodes, "watchedepisodes", {});
  validate.type["Video.Details.Base"](x, "Video.Details.Season", x);
};

validate_type["Video.Details.TVShow"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Video.Cast"](x.cast, "cast");
  validate.integer(x.episode, "episode", {});
  validate.string(x.episodeguide, "episodeguide", {});
  validate.type["Array.String"](x.genre, "genre");
  validate.string(x.imdbnumber, "imdbnumber", {});
  validate.string(x.mpaa, "mpaa", {});
  validate.string(x.originaltitle, "originaltitle", {});
  validate.string(x.premiered, "premiered", {});
  validate.number(x.rating, "rating", {});
  validate.integer(x.season, "season", {});
  validate.string(x.sorttitle, "sorttitle", {});
  validate.type["Array.String"](x.studio, "studio");
  validate.type["Array.String"](x.tag, "tag");
  validate.required(x.tvshowid, "tvshowid");
  validate.type["Library.Id"](x.tvshowid, "tvshowid");
  validate.string(x.votes, "votes", {});
  validate.integer(x.watchedepisodes, "watchedepisodes", {});
  validate.integer(x.year, "year", {});
  validate.type["Video.Details.Item"](x, "Video.Details.TVShow", x);
};

validate_type["Video.Fields.Episode"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Video.Fields.Episode", x);
};

validate_type["Video.Fields.Movie"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Video.Fields.Movie", x);
};

validate_type["Video.Fields.MovieSet"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Video.Fields.MovieSet", x);
};

validate_type["Video.Fields.MusicVideo"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Video.Fields.MusicVideo", x);
};

validate_type["Video.Fields.Season"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Video.Fields.Season", x);
};

validate_type["Video.Fields.TVShow"] = function (x, name) {
  if (x === undefined) return;
  validate.type["Item.Fields.Base"](x, "Video.Fields.TVShow", x);
};

validate_type["Video.Resume"] = function (x, name) {
  if (x === undefined) return;
  validate.number(x.position, "position", {"minimum":0});
  validate.number(x.total, "total", {"minimum":0});
};

validate_type["Video.Streams"] = function (x, name) {
  if (x === undefined) return;
  validate.array(x.audio, "audio", {"minItems":1});
  for (var itemIdx in x.audio.items) {
    validate.integer(x.channels, "channels", {});
    validate.string(x.codec, "codec", {});
    validate.string(x.language, "language", {});
  }
  validate.array(x.subtitle, "subtitle", {"minItems":1});
  for (var itemIdx in x.subtitle.items) {
    validate.string(x.language, "language", {});
  }
  validate.array(x.video, "video", {"minItems":1});
  for (var itemIdx in x.video.items) {
    validate.number(x.aspect, "aspect", {});
    validate.string(x.codec, "codec", {});
    validate.integer(x.duration, "duration", {});
    validate.integer(x.height, "height", {});
    validate.integer(x.width, "width", {});
  }
};


module.exports = validate_type;
},{"./validate":19}],21:[function(require,module,exports){
var _ = require("lodash");
var subCtr = 0;

// XXX Experimental
function Observable(initialValue) {
  this.value = initialValue;
  this.subscriptions = {};
}

Observable.prototype.val = function() {
  return this.value;
};

Observable.prototype.update = function(value) {
  this.value = value;
  this.notifySubscribers();
};

Observable.prototype.throttledUpdate = function(value, threshold) {
  this.value = value;
  if (this.throttleTimer) {
    clearTimeout(this.throttleTimer);
  }
  this.throttleTimer = setTimeout(this.notifySubscribers.bind(this), threshold);
};

Observable.prototype.notifySubscribers = function() {
  _.each(this.subscriptions, function(sub) {
    sub.notify(this.value);
  }, this);

  if (this.throttleTimer) {
    clearTimeout(this.throttleTimer);
    delete this.throttleTimer;
  }
};

Observable.prototype.subscribe = function(cb) {
  var sub = new Subscription(this, cb);
  this.subscriptions[sub.id] = sub;
  return sub;
};

function Subscription(obs, cb) {
  this.cb = cb;
  this.obs = obs;
  this.id = "sub_" + (subCtr++);
}

Subscription.prototype.remove = function() {
  delete this.obs.subscriptions[this.id];
};

Subscription.prototype.notify = function(value) {
  this.cb(value);
};

module.exports = Observable;

},{"lodash":27}],22:[function(require,module,exports){
var rpc = require('./kodijs/rpc');
var validate = require('./kodijs/validate');

module.exports = {

  Addons: {

    /**
     * Addons.ExecuteAddon
     * 
     * Executes the given addon with the given parameters (if possible)
     * 
     * @param addonid: string
     * @param params: object | Array<string> | string
     * @param wait: boolean
     * 
     * @returns string
     */
    ExecuteAddon: function(x) {
      try {
        validate.required(x.addonid, "addonid");
        validate.string(x.addonid, "addonid", {});
        var types_left = 3;
        try {
        } catch (type_ex) {
        }
        try {
          validate.array(x.params, "params", {});
          for (var itemIdx in x.params.items) {
            validate.string(x.params.items[itemIdx], "x.params.items[itemIdx]", {});
          }
        } catch (type_ex) {
        }
        try {
          validate.string(x.params, "params", {});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("params did not match any of the valid types");
          }
        }
        validate.boolean(x.wait, "wait", {});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Addons.ExecuteAddon', x);
    },


    /**
     * Addons.GetAddonDetails
     * 
     * Gets the details of a specific addon
     * 
     * @param addonid: string
     * @param properties: $Addon.Fields
     * 
     * @returns {
     *   addon : $Addon.Details
     *   limits : $List.LimitsReturned
     * }
     */
    GetAddonDetails: function(x) {
      try {
        validate.required(x.addonid, "addonid");
        validate.string(x.addonid, "addonid", {});
        validate.type["Addon.Fields"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Addons.GetAddonDetails', x);
    },


    /**
     * Addons.GetAddons
     * 
     * Gets all available addons
     * 
     * @param type: $Addon.Types
     * @param content: $Addon.Content
     * @param enabled: boolean | string
     * @param properties: $Addon.Fields
     * @param limits: $List.Limits
     * 
     * @returns {
     *   [addons] : Array<$Addon.Details>
     *   limits : $List.LimitsReturned
     * }
     */
    GetAddons: function(x) {
      try {
        validate.type["Addon.Types"](x.type, "type");
        validate.type["Addon.Content"](x.content, "content");
        var types_left = 2;
        try {
          validate.boolean(x.enabled, "enabled", {});
        } catch (type_ex) {
        }
        try {
          validate.string(x.enabled, "enabled", {"enums":["all"]});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("enabled did not match any of the valid types");
          }
        }
        validate.type["Addon.Fields"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Addons.GetAddons', x);
    },


    /**
     * Addons.SetAddonEnabled
     * 
     * Enables/Disables a specific addon
     * 
     * @param addonid: string
     * @param enabled: $Global.Toggle
     * 
     * @returns string
     */
    SetAddonEnabled: function(x) {
      try {
        validate.required(x.addonid, "addonid");
        validate.string(x.addonid, "addonid", {});
        validate.required(x.enabled, "enabled");
        validate.type["Global.Toggle"](x.enabled, "enabled");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Addons.SetAddonEnabled', x);
    },

  },


  Application: {

    /**
     * Application.GetProperties
     * 
     * Retrieves the values of the given properties
     * 
     * @param properties: Array<$Application.Property.Name>
     * 
     * @returns $Application.Property.Value
     */
    GetProperties: function(x) {
      try {
        validate.required(x.properties, "properties");
        validate.array(x.properties, "properties", {"uniqueItems":true});
        for (var itemIdx in x.properties.items) {
          validate.type["Application.Property.Name"](x.properties.items[itemIdx], "x.properties.items[itemIdx]");
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Application.GetProperties', x);
    },


    /**
     * Application.Quit
     * 
     * Quit application
     * 
     * 
     * @returns string
     */
    Quit: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Application.Quit', x);
    },


    /**
     * Application.SetMute
     * 
     * Toggle mute/unmute
     * 
     * @param mute: $Global.Toggle
     * 
     * @returns boolean
     */
    SetMute: function(x) {
      try {
        validate.required(x.mute, "mute");
        validate.type["Global.Toggle"](x.mute, "mute");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Application.SetMute', x);
    },


    /**
     * Application.SetVolume
     * 
     * Set the current volume
     * 
     * @param volume: integer | $Global.IncrementDecrement
     * 
     * @returns integer
     */
    SetVolume: function(x) {
      try {
        validate.required(x.volume, "volume");
        var types_left = 2;
        try {
          validate.integer(x.volume, "volume", {"minimum":0,"maximum":100});
        } catch (type_ex) {
        }
        try {
          validate.type["Global.IncrementDecrement"](x.volume, "volume");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("volume did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Application.SetVolume', x);
    },

  },


  AudioLibrary: {

    /**
     * AudioLibrary.Clean
     * 
     * Cleans the audio library from non-existent items
     * 
     * 
     * @returns string
     */
    Clean: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.Clean', x);
    },


    /**
     * AudioLibrary.Export
     * 
     * Exports all items from the audio library
     * 
     * @param options: {,  path : string,} | {,  [images] : boolean,  [overwrite] : boolean,}
     * 
     * @returns string
     */
    Export: function(x) {
      try {
        var types_left = 2;
        try {
          validate.required(x.path, "path");
          validate.string(x.path, "path", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.boolean(x.images, "images", {});
          validate.boolean(x.overwrite, "overwrite", {});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("options did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.Export', x);
    },


    /**
     * AudioLibrary.GetAlbumDetails
     * 
     * Retrieve details about a specific album
     * 
     * @param albumid: $Library.Id
     * @param properties: $Audio.Fields.Album
     * 
     * @returns {
     *   [albumdetails] : $Audio.Details.Album
     * }
     */
    GetAlbumDetails: function(x) {
      try {
        validate.required(x.albumid, "albumid");
        validate.type["Library.Id"](x.albumid, "albumid");
        validate.type["Audio.Fields.Album"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetAlbumDetails', x);
    },


    /**
     * AudioLibrary.GetAlbums
     * 
     * Retrieve all albums from specified artist or genre
     * 
     * @param properties: $Audio.Fields.Album
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  genreid : $Library.Id,} | {,  genre : string,} | {,  artistid : $Library.Id,} | {,  artist : string,} | $List.Filter.Albums
     * 
     * @returns {
     *   [albums] : Array<$Audio.Details.Album>
     *   limits : $List.LimitsReturned
     * }
     */
    GetAlbums: function(x) {
      try {
        validate.type["Audio.Fields.Album"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 5;
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.artistid, "artistid");
          validate.type["Library.Id"](x.artistid, "artistid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.artist, "artist");
          validate.string(x.artist, "artist", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.Albums"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetAlbums', x);
    },


    /**
     * AudioLibrary.GetArtistDetails
     * 
     * Retrieve details about a specific artist
     * 
     * @param artistid: $Library.Id
     * @param properties: $Audio.Fields.Artist
     * 
     * @returns {
     *   [artistdetails] : $Audio.Details.Artist
     * }
     */
    GetArtistDetails: function(x) {
      try {
        validate.required(x.artistid, "artistid");
        validate.type["Library.Id"](x.artistid, "artistid");
        validate.type["Audio.Fields.Artist"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetArtistDetails', x);
    },


    /**
     * AudioLibrary.GetArtists
     * 
     * Retrieve all artists
     * 
     * @param albumartistsonly: $Optional.Boolean
     * @param properties: $Audio.Fields.Artist
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  genreid : $Library.Id,} | {,  genre : string,} | {,  albumid : $Library.Id,} | {,  album : string,} | {,  songid : $Library.Id,} | $List.Filter.Artists
     * 
     * @returns {
     *   [artists] : Array<$Audio.Details.Artist>
     *   limits : $List.LimitsReturned
     * }
     */
    GetArtists: function(x) {
      try {
        validate.type["Optional.Boolean"](x.albumartistsonly, "albumartistsonly");
        validate.type["Audio.Fields.Artist"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 6;
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.albumid, "albumid");
          validate.type["Library.Id"](x.albumid, "albumid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.album, "album");
          validate.string(x.album, "album", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.songid, "songid");
          validate.type["Library.Id"](x.songid, "songid");
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.Artists"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetArtists', x);
    },


    /**
     * AudioLibrary.GetGenres
     * 
     * Retrieve all genres
     * 
     * @param properties: $Library.Fields.Genre
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   genres : Array<$Library.Details.Genre>
     *   limits : $List.LimitsReturned
     * }
     */
    GetGenres: function(x) {
      try {
        validate.type["Library.Fields.Genre"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetGenres', x);
    },


    /**
     * AudioLibrary.GetRecentlyAddedAlbums
     * 
     * Retrieve recently added albums
     * 
     * @param properties: $Audio.Fields.Album
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   [albums] : Array<$Audio.Details.Album>
     *   limits : $List.LimitsReturned
     * }
     */
    GetRecentlyAddedAlbums: function(x) {
      try {
        validate.type["Audio.Fields.Album"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetRecentlyAddedAlbums', x);
    },


    /**
     * AudioLibrary.GetRecentlyAddedSongs
     * 
     * Retrieve recently added songs
     * 
     * @param albumlimit: $List.Amount
     * @param properties: $Audio.Fields.Song
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [songs] : Array<$Audio.Details.Song>
     * }
     */
    GetRecentlyAddedSongs: function(x) {
      try {
        validate.type["List.Amount"](x.albumlimit, "albumlimit");
        validate.type["Audio.Fields.Song"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetRecentlyAddedSongs', x);
    },


    /**
     * AudioLibrary.GetRecentlyPlayedAlbums
     * 
     * Retrieve recently played albums
     * 
     * @param properties: $Audio.Fields.Album
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   [albums] : Array<$Audio.Details.Album>
     *   limits : $List.LimitsReturned
     * }
     */
    GetRecentlyPlayedAlbums: function(x) {
      try {
        validate.type["Audio.Fields.Album"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetRecentlyPlayedAlbums', x);
    },


    /**
     * AudioLibrary.GetRecentlyPlayedSongs
     * 
     * Retrieve recently played songs
     * 
     * @param properties: $Audio.Fields.Song
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [songs] : Array<$Audio.Details.Song>
     * }
     */
    GetRecentlyPlayedSongs: function(x) {
      try {
        validate.type["Audio.Fields.Song"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetRecentlyPlayedSongs', x);
    },


    /**
     * AudioLibrary.GetSongDetails
     * 
     * Retrieve details about a specific song
     * 
     * @param songid: $Library.Id
     * @param properties: $Audio.Fields.Song
     * 
     * @returns {
     *   [songdetails] : $Audio.Details.Song
     * }
     */
    GetSongDetails: function(x) {
      try {
        validate.required(x.songid, "songid");
        validate.type["Library.Id"](x.songid, "songid");
        validate.type["Audio.Fields.Song"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetSongDetails', x);
    },


    /**
     * AudioLibrary.GetSongs
     * 
     * Retrieve all songs from specified album, artist or genre
     * 
     * @param properties: $Audio.Fields.Song
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  genreid : $Library.Id,} | {,  genre : string,} | {,  artistid : $Library.Id,} | {,  artist : string,} | {,  albumid : $Library.Id,} | {,  album : string,} | $List.Filter.Songs
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [songs] : Array<$Audio.Details.Song>
     * }
     */
    GetSongs: function(x) {
      try {
        validate.type["Audio.Fields.Song"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 7;
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.artistid, "artistid");
          validate.type["Library.Id"](x.artistid, "artistid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.artist, "artist");
          validate.string(x.artist, "artist", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.albumid, "albumid");
          validate.type["Library.Id"](x.albumid, "albumid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.album, "album");
          validate.string(x.album, "album", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.Songs"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.GetSongs', x);
    },


    /**
     * AudioLibrary.Scan
     * 
     * Scans the audio sources for new library items
     * 
     * @param directory: string
     * 
     * @returns string
     */
    Scan: function(x) {
      try {
        validate.string(x.directory, "directory", {});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.Scan', x);
    },


    /**
     * AudioLibrary.SetAlbumDetails
     * 
     * Update the given album with the given details
     * 
     * @param albumid: $Library.Id
     * @param title: $Optional.String
     * @param artist: null | $Array.String
     * @param description: $Optional.String
     * @param genre: null | $Array.String
     * @param theme: null | $Array.String
     * @param mood: null | $Array.String
     * @param style: null | $Array.String
     * @param type: $Optional.String
     * @param albumlabel: $Optional.String
     * @param rating: $Optional.Integer
     * @param year: $Optional.Integer
     * 
     * @returns string
     */
    SetAlbumDetails: function(x) {
      try {
        validate.required(x.albumid, "albumid");
        validate.type["Library.Id"](x.albumid, "albumid");
        validate.type["Optional.String"](x.title, "title");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.artist, "artist", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.artist, "artist");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("artist did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.description, "description");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.genre, "genre", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.genre, "genre");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("genre did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.theme, "theme", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.theme, "theme");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("theme did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.mood, "mood", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.mood, "mood");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("mood did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.style, "style", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.style, "style");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("style did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.type, "type");
        validate.type["Optional.String"](x.albumlabel, "albumlabel");
        validate.type["Optional.Integer"](x.rating, "rating");
        validate.type["Optional.Integer"](x.year, "year");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.SetAlbumDetails', x);
    },


    /**
     * AudioLibrary.SetArtistDetails
     * 
     * Update the given artist with the given details
     * 
     * @param artistid: $Library.Id
     * @param artist: $Optional.String
     * @param instrument: null | $Array.String
     * @param style: null | $Array.String
     * @param mood: null | $Array.String
     * @param born: $Optional.String
     * @param formed: $Optional.String
     * @param description: $Optional.String
     * @param genre: null | $Array.String
     * @param died: $Optional.String
     * @param disbanded: $Optional.String
     * @param yearsactive: null | $Array.String
     * 
     * @returns string
     */
    SetArtistDetails: function(x) {
      try {
        validate.required(x.artistid, "artistid");
        validate.type["Library.Id"](x.artistid, "artistid");
        validate.type["Optional.String"](x.artist, "artist");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.instrument, "instrument", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.instrument, "instrument");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("instrument did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.style, "style", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.style, "style");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("style did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.mood, "mood", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.mood, "mood");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("mood did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.born, "born");
        validate.type["Optional.String"](x.formed, "formed");
        validate.type["Optional.String"](x.description, "description");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.genre, "genre", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.genre, "genre");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("genre did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.died, "died");
        validate.type["Optional.String"](x.disbanded, "disbanded");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.yearsactive, "yearsactive", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.yearsactive, "yearsactive");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("yearsactive did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.SetArtistDetails', x);
    },


    /**
     * AudioLibrary.SetSongDetails
     * 
     * Update the given song with the given details
     * 
     * @param songid: $Library.Id
     * @param title: $Optional.String
     * @param artist: null | $Array.String
     * @param albumartist: null | $Array.String
     * @param genre: null | $Array.String
     * @param year: $Optional.Integer
     * @param rating: $Optional.Integer
     * @param album: $Optional.String
     * @param track: $Optional.Integer
     * @param disc: $Optional.Integer
     * @param duration: $Optional.Integer
     * @param comment: $Optional.String
     * @param musicbrainztrackid: $Optional.String
     * @param musicbrainzartistid: $Optional.String
     * @param musicbrainzalbumid: $Optional.String
     * @param musicbrainzalbumartistid: $Optional.String
     * 
     * @returns string
     */
    SetSongDetails: function(x) {
      try {
        validate.required(x.songid, "songid");
        validate.type["Library.Id"](x.songid, "songid");
        validate.type["Optional.String"](x.title, "title");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.artist, "artist", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.artist, "artist");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("artist did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.albumartist, "albumartist", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.albumartist, "albumartist");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("albumartist did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.genre, "genre", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.genre, "genre");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("genre did not match any of the valid types");
          }
        }
        validate.type["Optional.Integer"](x.year, "year");
        validate.type["Optional.Integer"](x.rating, "rating");
        validate.type["Optional.String"](x.album, "album");
        validate.type["Optional.Integer"](x.track, "track");
        validate.type["Optional.Integer"](x.disc, "disc");
        validate.type["Optional.Integer"](x.duration, "duration");
        validate.type["Optional.String"](x.comment, "comment");
        validate.type["Optional.String"](x.musicbrainztrackid, "musicbrainztrackid");
        validate.type["Optional.String"](x.musicbrainzartistid, "musicbrainzartistid");
        validate.type["Optional.String"](x.musicbrainzalbumid, "musicbrainzalbumid");
        validate.type["Optional.String"](x.musicbrainzalbumartistid, "musicbrainzalbumartistid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('AudioLibrary.SetSongDetails', x);
    },

  },


  Favourites: {

    /**
     * Favourites.AddFavourite
     * 
     * Add a favourite with the given details
     * 
     * @param title: string
     * @param type: $Favourite.Type
     * @param path: $Optional.String
     * @param window: $Optional.String
     * @param windowparameter: $Optional.String
     * @param thumbnail: $Optional.String
     * 
     * @returns string
     */
    AddFavourite: function(x) {
      try {
        validate.required(x.title, "title");
        validate.string(x.title, "title", {});
        validate.required(x.type, "type");
        validate.type["Favourite.Type"](x.type, "type");
        validate.type["Optional.String"](x.path, "path");
        validate.type["Optional.String"](x.window, "window");
        validate.type["Optional.String"](x.windowparameter, "windowparameter");
        validate.type["Optional.String"](x.thumbnail, "thumbnail");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Favourites.AddFavourite', x);
    },


    /**
     * Favourites.GetFavourites
     * 
     * Retrieve all favourites
     * 
     * @param type: null | $Favourite.Type
     * @param properties: $Favourite.Fields.Favourite
     * 
     * @returns {
     *   [favourites] : Array<$Favourite.Details.Favourite>
     *   limits : $List.LimitsReturned
     * }
     */
    GetFavourites: function(x) {
      try {
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.type, "type", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Favourite.Type"](x.type, "type");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("type did not match any of the valid types");
          }
        }
        validate.type["Favourite.Fields.Favourite"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Favourites.GetFavourites', x);
    },

  },


  Files: {

    /**
     * Files.GetDirectory
     * 
     * Get the directories and files in the given directory
     * 
     * @param directory: string
     * @param media: $Files.Media
     * @param properties: $List.Fields.Files
     * @param sort: $List.Sort
     * @param limits: $List.Limits
     * 
     * @returns {
     *   files : Array<$List.Item.File>
     *   limits : $List.LimitsReturned
     * }
     */
    GetDirectory: function(x) {
      try {
        validate.required(x.directory, "directory");
        validate.string(x.directory, "directory", {});
        validate.type["Files.Media"](x.media, "media");
        validate.type["List.Fields.Files"](x.properties, "properties");
        validate.type["List.Sort"](x.sort, "sort");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Files.GetDirectory', x);
    },


    /**
     * Files.GetFileDetails
     * 
     * Get details for a specific file
     * 
     * @param file: string
     * @param media: $Files.Media
     * @param properties: $List.Fields.Files
     * 
     * @returns {
     *   filedetails : $List.Item.File
     * }
     */
    GetFileDetails: function(x) {
      try {
        validate.required(x.file, "file");
        validate.string(x.file, "file", {});
        validate.type["Files.Media"](x.media, "media");
        validate.type["List.Fields.Files"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Files.GetFileDetails', x);
    },


    /**
     * Files.GetSources
     * 
     * Get the sources of the media windows
     * 
     * @param media: $Files.Media
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   sources : $List.Items.Sources
     * }
     */
    GetSources: function(x) {
      try {
        validate.required(x.media, "media");
        validate.type["Files.Media"](x.media, "media");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Files.GetSources', x);
    },

  },


  GUI: {

    /**
     * GUI.ActivateWindow
     * 
     * Activates the given window
     * 
     * @param window: $GUI.Window
     * @param parameters: Array<string>
     * 
     * @returns string
     */
    ActivateWindow: function(x) {
      try {
        validate.required(x.window, "window");
        validate.type["GUI.Window"](x.window, "window");
        validate.array(x.parameters, "parameters", {"minItems":1});
        for (var itemIdx in x.parameters.items) {
          validate.string(x.parameters.items[itemIdx], "x.parameters.items[itemIdx]", {"minLength":1});
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('GUI.ActivateWindow', x);
    },


    /**
     * GUI.GetProperties
     * 
     * Retrieves the values of the given properties
     * 
     * @param properties: Array<$GUI.Property.Name>
     * 
     * @returns $GUI.Property.Value
     */
    GetProperties: function(x) {
      try {
        validate.required(x.properties, "properties");
        validate.array(x.properties, "properties", {"uniqueItems":true});
        for (var itemIdx in x.properties.items) {
          validate.type["GUI.Property.Name"](x.properties.items[itemIdx], "x.properties.items[itemIdx]");
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('GUI.GetProperties', x);
    },


    /**
     * GUI.GetStereoscopicModes
     * 
     * Returns the supported stereoscopic modes of the GUI
     * 
     * 
     * @returns {
     *   [stereoscopicmodes] : Array<$GUI.Stereoscopy.Mode>
     * }
     */
    GetStereoscopicModes: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('GUI.GetStereoscopicModes', x);
    },


    /**
     * GUI.SetFullscreen
     * 
     * Toggle fullscreen/GUI
     * 
     * @param fullscreen: $Global.Toggle
     * 
     * @returns boolean
     */
    SetFullscreen: function(x) {
      try {
        validate.required(x.fullscreen, "fullscreen");
        validate.type["Global.Toggle"](x.fullscreen, "fullscreen");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('GUI.SetFullscreen', x);
    },


    /**
     * GUI.SetStereoscopicMode
     * 
     * Sets the stereoscopic mode of the GUI to the given mode
     * 
     * @param mode: string
     * 
     * @returns string
     */
    SetStereoscopicMode: function(x) {
      try {
        validate.required(x.mode, "mode");
        validate.string(x.mode, "mode", {"enums":["toggle","tomono","next","previous","select","off","split_vertical","split_horizontal","row_interleaved","hardware_based","anaglyph_cyan_red","anaglyph_green_magenta","monoscopic"]});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('GUI.SetStereoscopicMode', x);
    },


    /**
     * GUI.ShowNotification
     * 
     * Shows a GUI notification
     * 
     * @param title: string
     * @param message: string
     * @param image: string | string
     * @param displaytime: integer
     * 
     * @returns string
     */
    ShowNotification: function(x) {
      try {
        validate.required(x.title, "title");
        validate.string(x.title, "title", {});
        validate.required(x.message, "message");
        validate.string(x.message, "message", {});
        var types_left = 2;
        try {
          validate.string(x.image, "image", {"enums":["info","warning","error"]});
        } catch (type_ex) {
        }
        try {
          validate.string(x.image, "image", {});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("image did not match any of the valid types");
          }
        }
        validate.integer(x.displaytime, "displaytime", {"minimum":1500});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('GUI.ShowNotification', x);
    },

  },


  Input: {

    /**
     * Input.Back
     * 
     * Goes back in GUI
     * 
     * 
     * @returns string
     */
    Back: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Back', x);
    },


    /**
     * Input.ContextMenu
     * 
     * Shows the context menu
     * 
     * 
     * @returns string
     */
    ContextMenu: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.ContextMenu', x);
    },


    /**
     * Input.Down
     * 
     * Navigate down in GUI
     * 
     * 
     * @returns string
     */
    Down: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Down', x);
    },


    /**
     * Input.ExecuteAction
     * 
     * Execute a specific action
     * 
     * @param action: $Input.Action
     * 
     * @returns string
     */
    ExecuteAction: function(x) {
      try {
        validate.required(x.action, "action");
        validate.type["Input.Action"](x.action, "action");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.ExecuteAction', x);
    },


    /**
     * Input.Home
     * 
     * Goes to home window in GUI
     * 
     * 
     * @returns string
     */
    Home: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Home', x);
    },


    /**
     * Input.Info
     * 
     * Shows the information dialog
     * 
     * 
     * @returns string
     */
    Info: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Info', x);
    },


    /**
     * Input.Left
     * 
     * Navigate left in GUI
     * 
     * 
     * @returns string
     */
    Left: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Left', x);
    },


    /**
     * Input.Right
     * 
     * Navigate right in GUI
     * 
     * 
     * @returns string
     */
    Right: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Right', x);
    },


    /**
     * Input.Select
     * 
     * Select current item in GUI
     * 
     * 
     * @returns string
     */
    Select: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Select', x);
    },


    /**
     * Input.SendText
     * 
     * Send a generic (unicode) text
     * 
     * @param text: string
     * @param done: boolean
     * 
     * @returns string
     */
    SendText: function(x) {
      try {
        validate.required(x.text, "text");
        validate.string(x.text, "text", {});
        validate.boolean(x.done, "done", {});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.SendText', x);
    },


    /**
     * Input.ShowCodec
     * 
     * Show codec information of the playing item
     * 
     * 
     * @returns string
     */
    ShowCodec: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.ShowCodec', x);
    },


    /**
     * Input.ShowOSD
     * 
     * Show the on-screen display for the current player
     * 
     * 
     * @returns string
     */
    ShowOSD: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.ShowOSD', x);
    },


    /**
     * Input.Up
     * 
     * Navigate up in GUI
     * 
     * 
     * @returns string
     */
    Up: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Input.Up', x);
    },

  },


  JSONRPC: {

    /**
     * JSONRPC.GetConfiguration
     * 
     * Get client-specific configurations
     * 
     * 
     * @returns $Configuration
     */
    GetConfiguration: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.GetConfiguration', x);
    },


    /**
     * JSONRPC.Introspect
     * 
     * Enumerates all actions and descriptions
     * 
     * @param getdescriptions: boolean
     * @param getmetadata: boolean
     * @param filterbytransport: boolean
     * @param filter: {
     *   [getreferences] : boolean
     *   id : string
     *   type : string
     * }
     * 
     * @returns object
     */
    Introspect: function(x) {
      try {
        validate.boolean(x.getdescriptions, "getdescriptions", {});
        validate.boolean(x.getmetadata, "getmetadata", {});
        validate.boolean(x.filterbytransport, "filterbytransport", {});
        validate.boolean(x.getreferences, "getreferences", {});
        validate.required(x.id, "id");
        validate.string(x.id, "id", {});
        validate.required(x.type, "type");
        validate.string(x.type, "type", {"enums":["method","namespace","type","notification"]});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.Introspect', x);
    },


    /**
     * JSONRPC.NotifyAll
     * 
     * Notify all other connected clients
     * 
     * @param sender: string
     * @param message: string
     * @param data: any
     * 
     * @returns any
     */
    NotifyAll: function(x) {
      try {
        validate.required(x.sender, "sender");
        validate.string(x.sender, "sender", {});
        validate.required(x.message, "message");
        validate.string(x.message, "message", {});
        // missing type check - unknown type
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.NotifyAll', x);
    },


    /**
     * JSONRPC.Permission
     * 
     * Retrieve the clients permissions
     * 
     * 
     * @returns {
     *   controlgui : boolean
     *   controlnotify : boolean
     *   controlplayback : boolean
     *   controlpower : boolean
     *   controlpvr : boolean
     *   controlsystem : boolean
     *   executeaddon : boolean
     *   manageaddon : boolean
     *   navigate : boolean
     *   readdata : boolean
     *   removedata : boolean
     *   updatedata : boolean
     *   writefile : boolean
     * }
     */
    Permission: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.Permission', x);
    },


    /**
     * JSONRPC.Ping
     * 
     * Ping responder
     * 
     * 
     * @returns string
     */
    Ping: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.Ping', x);
    },


    /**
     * JSONRPC.SetConfiguration
     * 
     * Change the client-specific configuration
     * 
     * @param notifications: {
     *   [application] : $Optional.Boolean
     *   [audiolibrary] : $Optional.Boolean
     *   [gui] : $Optional.Boolean
     *   [input] : $Optional.Boolean
     *   [other] : $Optional.Boolean
     *   [player] : $Optional.Boolean
     *   [playlist] : $Optional.Boolean
     *   [system] : $Optional.Boolean
     *   [videolibrary] : $Optional.Boolean
     * }
     * 
     * @returns $Configuration
     */
    SetConfiguration: function(x) {
      try {
        validate.type["Optional.Boolean"](x.application, "application");
        validate.type["Optional.Boolean"](x.audiolibrary, "audiolibrary");
        validate.type["Optional.Boolean"](x.gui, "gui");
        validate.type["Optional.Boolean"](x.input, "input");
        validate.type["Optional.Boolean"](x.other, "other");
        validate.type["Optional.Boolean"](x.player, "player");
        validate.type["Optional.Boolean"](x.playlist, "playlist");
        validate.type["Optional.Boolean"](x.system, "system");
        validate.type["Optional.Boolean"](x.videolibrary, "videolibrary");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.SetConfiguration', x);
    },


    /**
     * JSONRPC.Version
     * 
     * Retrieve the JSON-RPC protocol version.
     * 
     * 
     * @returns {
     *   version : {,  major : integer,  minor : integer,  patch : integer,}
     * }
     */
    Version: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('JSONRPC.Version', x);
    },

  },


  PVR: {

    /**
     * PVR.GetBroadcastDetails
     * 
     * Retrieves the details of a specific broadcast
     * 
     * @param broadcastid: $Library.Id
     * @param properties: $PVR.Fields.Broadcast
     * 
     * @returns {
     *   [broadcastdetails] : $PVR.Details.Broadcast
     * }
     */
    GetBroadcastDetails: function(x) {
      try {
        validate.required(x.broadcastid, "broadcastid");
        validate.type["Library.Id"](x.broadcastid, "broadcastid");
        validate.type["PVR.Fields.Broadcast"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetBroadcastDetails', x);
    },


    /**
     * PVR.GetBroadcasts
     * 
     * Retrieves the program of a specific channel
     * 
     * @param channelid: $Library.Id
     * @param properties: $PVR.Fields.Broadcast
     * @param limits: $List.Limits
     * 
     * @returns {
     *   broadcasts : Array<$PVR.Details.Broadcast>
     *   limits : $List.LimitsReturned
     * }
     */
    GetBroadcasts: function(x) {
      try {
        validate.required(x.channelid, "channelid");
        validate.type["Library.Id"](x.channelid, "channelid");
        validate.type["PVR.Fields.Broadcast"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetBroadcasts', x);
    },


    /**
     * PVR.GetChannelDetails
     * 
     * Retrieves the details of a specific channel
     * 
     * @param channelid: $Library.Id
     * @param properties: $PVR.Fields.Channel
     * 
     * @returns {
     *   [channeldetails] : $PVR.Details.Channel
     * }
     */
    GetChannelDetails: function(x) {
      try {
        validate.required(x.channelid, "channelid");
        validate.type["Library.Id"](x.channelid, "channelid");
        validate.type["PVR.Fields.Channel"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetChannelDetails', x);
    },


    /**
     * PVR.GetChannelGroupDetails
     * 
     * Retrieves the details of a specific channel group
     * 
     * @param channelgroupid: $PVR.ChannelGroup.Id
     * @param channels: {
     *   [limits] : $List.Limits
     *   [properties] : $PVR.Fields.Channel
     * }
     * 
     * @returns {
     *   [channelgroupdetails] : $PVR.Details.ChannelGroup.Extended
     * }
     */
    GetChannelGroupDetails: function(x) {
      try {
        validate.required(x.channelgroupid, "channelgroupid");
        validate.type["PVR.ChannelGroup.Id"](x.channelgroupid, "channelgroupid");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["PVR.Fields.Channel"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetChannelGroupDetails', x);
    },


    /**
     * PVR.GetChannelGroups
     * 
     * Retrieves the channel groups for the specified type
     * 
     * @param channeltype: $PVR.Channel.Type
     * @param limits: $List.Limits
     * 
     * @returns {
     *   channelgroups : Array<$PVR.Details.ChannelGroup>
     *   limits : $List.LimitsReturned
     * }
     */
    GetChannelGroups: function(x) {
      try {
        validate.required(x.channeltype, "channeltype");
        validate.type["PVR.Channel.Type"](x.channeltype, "channeltype");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetChannelGroups', x);
    },


    /**
     * PVR.GetChannels
     * 
     * Retrieves the channel list
     * 
     * @param channelgroupid: $PVR.ChannelGroup.Id
     * @param properties: $PVR.Fields.Channel
     * @param limits: $List.Limits
     * 
     * @returns {
     *   channels : Array<$PVR.Details.Channel>
     *   limits : $List.LimitsReturned
     * }
     */
    GetChannels: function(x) {
      try {
        validate.required(x.channelgroupid, "channelgroupid");
        validate.type["PVR.ChannelGroup.Id"](x.channelgroupid, "channelgroupid");
        validate.type["PVR.Fields.Channel"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetChannels', x);
    },


    /**
     * PVR.GetProperties
     * 
     * Retrieves the values of the given properties
     * 
     * @param properties: Array<$PVR.Property.Name>
     * 
     * @returns $PVR.Property.Value
     */
    GetProperties: function(x) {
      try {
        validate.required(x.properties, "properties");
        validate.array(x.properties, "properties", {"uniqueItems":true});
        for (var itemIdx in x.properties.items) {
          validate.type["PVR.Property.Name"](x.properties.items[itemIdx], "x.properties.items[itemIdx]");
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetProperties', x);
    },


    /**
     * PVR.GetRecordingDetails
     * 
     * Retrieves the details of a specific recording
     * 
     * @param recordingid: $Library.Id
     * @param properties: $PVR.Fields.Recording
     * 
     * @returns {
     *   [recordingdetails] : $PVR.Details.Recording
     * }
     */
    GetRecordingDetails: function(x) {
      try {
        validate.required(x.recordingid, "recordingid");
        validate.type["Library.Id"](x.recordingid, "recordingid");
        validate.type["PVR.Fields.Recording"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetRecordingDetails', x);
    },


    /**
     * PVR.GetRecordings
     * 
     * Retrieves the recordings
     * 
     * @param properties: $PVR.Fields.Recording
     * @param limits: $List.Limits
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   recordings : Array<$PVR.Details.Recording>
     * }
     */
    GetRecordings: function(x) {
      try {
        validate.type["PVR.Fields.Recording"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetRecordings', x);
    },


    /**
     * PVR.GetTimerDetails
     * 
     * Retrieves the details of a specific timer
     * 
     * @param timerid: $Library.Id
     * @param properties: $PVR.Fields.Timer
     * 
     * @returns {
     *   [timerdetails] : $PVR.Details.Timer
     * }
     */
    GetTimerDetails: function(x) {
      try {
        validate.required(x.timerid, "timerid");
        validate.type["Library.Id"](x.timerid, "timerid");
        validate.type["PVR.Fields.Timer"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetTimerDetails', x);
    },


    /**
     * PVR.GetTimers
     * 
     * Retrieves the timers
     * 
     * @param properties: $PVR.Fields.Timer
     * @param limits: $List.Limits
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   timers : Array<$PVR.Details.Timer>
     * }
     */
    GetTimers: function(x) {
      try {
        validate.type["PVR.Fields.Timer"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.GetTimers', x);
    },


    /**
     * PVR.Record
     * 
     * Toggle recording of a channel
     * 
     * @param record: $Global.Toggle
     * @param channel: string | $Library.Id
     * 
     * @returns string
     */
    Record: function(x) {
      try {
        validate.type["Global.Toggle"](x.record, "record");
        var types_left = 2;
        try {
          validate.string(x.channel, "channel", {"enums":["current"]});
        } catch (type_ex) {
        }
        try {
          validate.type["Library.Id"](x.channel, "channel");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("channel did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.Record', x);
    },


    /**
     * PVR.Scan
     * 
     * Starts a channel scan
     * 
     * 
     * @returns string
     */
    Scan: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('PVR.Scan', x);
    },

  },


  Player: {

    /**
     * Player.GetActivePlayers
     * 
     * Returns all active players
     * 
     * 
     * @returns Array<{
     *   playerid : $Player.Id
     *   type : $Player.Type
     * }>
     */
    GetActivePlayers: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.GetActivePlayers', x);
    },


    /**
     * Player.GetItem
     * 
     * Retrieves the currently played item
     * 
     * @param playerid: $Player.Id
     * @param properties: $List.Fields.All
     * 
     * @returns {
     *   item : $List.Item.All
     * }
     */
    GetItem: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.type["List.Fields.All"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.GetItem', x);
    },


    /**
     * Player.GetProperties
     * 
     * Retrieves the values of the given properties
     * 
     * @param playerid: $Player.Id
     * @param properties: Array<$Player.Property.Name>
     * 
     * @returns $Player.Property.Value
     */
    GetProperties: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.properties, "properties");
        validate.array(x.properties, "properties", {"uniqueItems":true});
        for (var itemIdx in x.properties.items) {
          validate.type["Player.Property.Name"](x.properties.items[itemIdx], "x.properties.items[itemIdx]");
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.GetProperties', x);
    },


    /**
     * Player.GoTo
     * 
     * Go to previous/next/specific item in the playlist
     * 
     * @param playerid: $Player.Id
     * @param to: string | $Playlist.Position
     * 
     * @returns string
     */
    GoTo: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.to, "to");
        var types_left = 2;
        try {
          validate.string(x.to, "to", {"enums":["previous","next"]});
        } catch (type_ex) {
        }
        try {
          validate.type["Playlist.Position"](x.to, "to");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("to did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.GoTo', x);
    },


    /**
     * Player.Move
     * 
     * If picture is zoomed move viewport left/right/up/down otherwise skip
     * previous/next
     * 
     * @param playerid: $Player.Id
     * @param direction: string
     * 
     * @returns string
     */
    Move: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.direction, "direction");
        validate.string(x.direction, "direction", {"enums":["left","right","up","down"]});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.Move', x);
    },


    /**
     * Player.Open
     * 
     * Start playback of either the playlist with the given ID, a slideshow with the
     * pictures from the given directory or a single file or an item from the
     * database.
     * 
     * @param item: {,  playlistid : $Playlist.Id,  [position] : $Playlist.Position,} | $Playlist.Item | {,  path : string,  [random] : boolean,  [recursive] : boolean,} | {,  [partymode] : string | string,} | {,  channelid : $Library.Id,}
     * @param options: {
     *   [repeat] : null | $Player.Repeat
     *   [resume] : boolean | $Player.Position.Percentage | $Player.Position.Time
     *   [shuffled] : $Optional.Boolean
     * }
     * 
     * @returns string
     */
    Open: function(x) {
      try {
        var types_left = 5;
        try {
          validate.required(x.playlistid, "playlistid");
          validate.type["Playlist.Id"](x.playlistid, "playlistid");
          validate.type["Playlist.Position"](x.position, "position");
        } catch (type_ex) {
        }
        try {
          validate.type["Playlist.Item"](x.item, "item");
        } catch (type_ex) {
        }
        try {
          validate.required(x.path, "path");
          validate.string(x.path, "path", {});
          validate.boolean(x.random, "random", {});
          validate.boolean(x.recursive, "recursive", {});
        } catch (type_ex) {
        }
        try {
          var types_left = 2;
          try {
            validate.string(x.partymode, "partymode", {"enums":["music","video"]});
          } catch (type_ex) {
          }
          try {
            validate.string(x.partymode, "partymode", {"minLength":5});
          } catch (type_ex) {
            if (--types_left === 0) {
              throw new Error("partymode did not match any of the valid types");
            }
          }
        } catch (type_ex) {
        }
        try {
          validate.required(x.channelid, "channelid");
          validate.type["Library.Id"](x.channelid, "channelid");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("item did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.repeat, "repeat", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Player.Repeat"](x.repeat, "repeat");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("repeat did not match any of the valid types");
          }
        }
        var types_left = 3;
        try {
          validate.boolean(x.resume, "resume", {});
        } catch (type_ex) {
        }
        try {
          validate.type["Player.Position.Percentage"](x.resume, "resume");
        } catch (type_ex) {
        }
        try {
          validate.type["Player.Position.Time"](x.resume, "resume");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("resume did not match any of the valid types");
          }
        }
        validate.type["Optional.Boolean"](x.shuffled, "shuffled");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.Open', x);
    },


    /**
     * Player.PlayPause
     * 
     * Pauses or unpause playback and returns the new state
     * 
     * @param playerid: $Player.Id
     * @param play: $Global.Toggle
     * 
     * @returns $Player.Speed
     */
    PlayPause: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.type["Global.Toggle"](x.play, "play");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.PlayPause', x);
    },


    /**
     * Player.Rotate
     * 
     * Rotates current picture
     * 
     * @param playerid: $Player.Id
     * @param value: string
     * 
     * @returns string
     */
    Rotate: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.string(x.value, "value", {"enums":["clockwise","counterclockwise"]});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.Rotate', x);
    },


    /**
     * Player.Seek
     * 
     * Seek through the playing item
     * 
     * @param playerid: $Player.Id
     * @param value: $Player.Position.Percentage | $Player.Position.Time | string
     * 
     * @returns {
     *   [percentage] : $Player.Position.Percentage
     *   [time] : $Global.Time
     *   [totaltime] : $Global.Time
     * }
     */
    Seek: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.value, "value");
        var types_left = 3;
        try {
          validate.type["Player.Position.Percentage"](x.value, "value");
        } catch (type_ex) {
        }
        try {
          validate.type["Player.Position.Time"](x.value, "value");
        } catch (type_ex) {
        }
        try {
          validate.string(x.value, "value", {"enums":["smallforward","smallbackward","bigforward","bigbackward"]});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("value did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.Seek', x);
    },


    /**
     * Player.SetAudioStream
     * 
     * Set the audio stream played by the player
     * 
     * @param playerid: $Player.Id
     * @param stream: string | integer
     * 
     * @returns string
     */
    SetAudioStream: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.stream, "stream");
        var types_left = 2;
        try {
          validate.string(x.stream, "stream", {"enums":["previous","next"]});
        } catch (type_ex) {
        }
        try {
          validate.integer(x.stream, "stream", {"minimum":0});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("stream did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.SetAudioStream', x);
    },


    /**
     * Player.SetPartymode
     * 
     * Turn partymode on or off
     * 
     * @param playerid: $Player.Id
     * @param partymode: $Global.Toggle
     * 
     * @returns string
     */
    SetPartymode: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.partymode, "partymode");
        validate.type["Global.Toggle"](x.partymode, "partymode");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.SetPartymode', x);
    },


    /**
     * Player.SetRepeat
     * 
     * Set the repeat mode of the player
     * 
     * @param playerid: $Player.Id
     * @param repeat: $Player.Repeat | string
     * 
     * @returns string
     */
    SetRepeat: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.repeat, "repeat");
        var types_left = 2;
        try {
          validate.type["Player.Repeat"](x.repeat, "repeat");
        } catch (type_ex) {
        }
        try {
          validate.string(x.repeat, "repeat", {"enums":["cycle"]});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("repeat did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.SetRepeat', x);
    },


    /**
     * Player.SetShuffle
     * 
     * Shuffle/Unshuffle items in the player
     * 
     * @param playerid: $Player.Id
     * @param shuffle: $Global.Toggle
     * 
     * @returns string
     */
    SetShuffle: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.shuffle, "shuffle");
        validate.type["Global.Toggle"](x.shuffle, "shuffle");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.SetShuffle', x);
    },


    /**
     * Player.SetSpeed
     * 
     * Set the speed of the current playback
     * 
     * @param playerid: $Player.Id
     * @param speed: integer | $Global.IncrementDecrement
     * 
     * @returns $Player.Speed
     */
    SetSpeed: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.speed, "speed");
        var types_left = 2;
        try {
          validate.integer(x.speed, "speed", {"enums":[-32,-16,-8,-4,-2,-1,0,1,2,4,8,16,32]});
        } catch (type_ex) {
        }
        try {
          validate.type["Global.IncrementDecrement"](x.speed, "speed");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("speed did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.SetSpeed', x);
    },


    /**
     * Player.SetSubtitle
     * 
     * Set the subtitle displayed by the player
     * 
     * @param playerid: $Player.Id
     * @param subtitle: string | integer
     * @param enable: boolean
     * 
     * @returns string
     */
    SetSubtitle: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.subtitle, "subtitle");
        var types_left = 2;
        try {
          validate.string(x.subtitle, "subtitle", {"enums":["previous","next","off","on"]});
        } catch (type_ex) {
        }
        try {
          validate.integer(x.subtitle, "subtitle", {"minimum":0});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("subtitle did not match any of the valid types");
          }
        }
        validate.boolean(x.enable, "enable", {});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.SetSubtitle', x);
    },


    /**
     * Player.Stop
     * 
     * Stops playback
     * 
     * @param playerid: $Player.Id
     * 
     * @returns string
     */
    Stop: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.Stop', x);
    },


    /**
     * Player.Zoom
     * 
     * Zoom current picture
     * 
     * @param playerid: $Player.Id
     * @param zoom: string | integer
     * 
     * @returns string
     */
    Zoom: function(x) {
      try {
        validate.required(x.playerid, "playerid");
        validate.type["Player.Id"](x.playerid, "playerid");
        validate.required(x.zoom, "zoom");
        var types_left = 2;
        try {
          validate.string(x.zoom, "zoom", {"enums":["in","out"]});
        } catch (type_ex) {
        }
        try {
          validate.integer(x.zoom, "zoom", {"minimum":1,"maximum":10});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("zoom did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Player.Zoom', x);
    },

  },


  Playlist: {

    /**
     * Playlist.Add
     * 
     * Add item(s) to playlist
     * 
     * @param playlistid: $Playlist.Id
     * @param item: $Playlist.Item | Array<$Playlist.Item>
     * 
     * @returns string
     */
    Add: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
        validate.required(x.item, "item");
        var types_left = 2;
        try {
          validate.type["Playlist.Item"](x.item, "item");
        } catch (type_ex) {
        }
        try {
          validate.array(x.item, "item", {});
          for (var itemIdx in x.item.items) {
            validate.type["Playlist.Item"](x.item.items[itemIdx], "x.item.items[itemIdx]");
          }
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("item did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.Add', x);
    },


    /**
     * Playlist.Clear
     * 
     * Clear playlist
     * 
     * @param playlistid: $Playlist.Id
     * 
     * @returns string
     */
    Clear: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.Clear', x);
    },


    /**
     * Playlist.GetItems
     * 
     * Get all items from playlist
     * 
     * @param playlistid: $Playlist.Id
     * @param properties: $List.Fields.All
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   items : Array<$List.Item.All>
     *   limits : $List.LimitsReturned
     * }
     */
    GetItems: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
        validate.type["List.Fields.All"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.GetItems', x);
    },


    /**
     * Playlist.GetPlaylists
     * 
     * Returns all existing playlists
     * 
     * 
     * @returns Array<{
     *   playlistid : $Playlist.Id
     *   type : $Playlist.Type
     * }>
     */
    GetPlaylists: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.GetPlaylists', x);
    },


    /**
     * Playlist.GetProperties
     * 
     * Retrieves the values of the given properties
     * 
     * @param playlistid: $Playlist.Id
     * @param properties: Array<$Playlist.Property.Name>
     * 
     * @returns $Playlist.Property.Value
     */
    GetProperties: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
        validate.required(x.properties, "properties");
        validate.array(x.properties, "properties", {"uniqueItems":true});
        for (var itemIdx in x.properties.items) {
          validate.type["Playlist.Property.Name"](x.properties.items[itemIdx], "x.properties.items[itemIdx]");
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.GetProperties', x);
    },


    /**
     * Playlist.Insert
     * 
     * Insert item(s) into playlist. Does not work for picture playlists (aka
     * slideshows).
     * 
     * @param playlistid: $Playlist.Id
     * @param position: $Playlist.Position
     * @param item: $Playlist.Item | Array<$Playlist.Item>
     * 
     * @returns string
     */
    Insert: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
        validate.required(x.position, "position");
        validate.type["Playlist.Position"](x.position, "position");
        validate.required(x.item, "item");
        var types_left = 2;
        try {
          validate.type["Playlist.Item"](x.item, "item");
        } catch (type_ex) {
        }
        try {
          validate.array(x.item, "item", {});
          for (var itemIdx in x.item.items) {
            validate.type["Playlist.Item"](x.item.items[itemIdx], "x.item.items[itemIdx]");
          }
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("item did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.Insert', x);
    },


    /**
     * Playlist.Remove
     * 
     * Remove item from playlist. Does not work for picture playlists (aka
     * slideshows).
     * 
     * @param playlistid: $Playlist.Id
     * @param position: $Playlist.Position
     * 
     * @returns string
     */
    Remove: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
        validate.required(x.position, "position");
        validate.type["Playlist.Position"](x.position, "position");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.Remove', x);
    },


    /**
     * Playlist.Swap
     * 
     * Swap items in the playlist. Does not work for picture playlists (aka
     * slideshows).
     * 
     * @param playlistid: $Playlist.Id
     * @param position1: $Playlist.Position
     * @param position2: $Playlist.Position
     * 
     * @returns string
     */
    Swap: function(x) {
      try {
        validate.required(x.playlistid, "playlistid");
        validate.type["Playlist.Id"](x.playlistid, "playlistid");
        validate.required(x.position1, "position1");
        validate.type["Playlist.Position"](x.position1, "position1");
        validate.required(x.position2, "position2");
        validate.type["Playlist.Position"](x.position2, "position2");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Playlist.Swap', x);
    },

  },


  Profiles: {

    /**
     * Profiles.GetCurrentProfile
     * 
     * Retrieve the current profile
     * 
     * @param properties: $Profiles.Fields.Profile
     * 
     * @returns $Profiles.Details.Profile
     */
    GetCurrentProfile: function(x) {
      try {
        validate.type["Profiles.Fields.Profile"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Profiles.GetCurrentProfile', x);
    },


    /**
     * Profiles.GetProfiles
     * 
     * Retrieve all profiles
     * 
     * @param properties: $Profiles.Fields.Profile
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   profiles : Array<$Profiles.Details.Profile>
     * }
     */
    GetProfiles: function(x) {
      try {
        validate.type["Profiles.Fields.Profile"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Profiles.GetProfiles', x);
    },


    /**
     * Profiles.LoadProfile
     * 
     * Load the specified profile
     * 
     * @param profile: string
     * @param prompt: boolean
     * @param password: $Profiles.Password
     * 
     * @returns string
     */
    LoadProfile: function(x) {
      try {
        validate.required(x.profile, "profile");
        validate.string(x.profile, "profile", {});
        validate.boolean(x.prompt, "prompt", {});
        validate.type["Profiles.Password"](x.password, "password");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Profiles.LoadProfile', x);
    },

  },


  Settings: {

    /**
     * Settings.GetCategories
     * 
     * Retrieves all setting categories
     * 
     * @param level: $Setting.Level
     * @param section: string
     * @param properties: unknown
     * 
     * @returns {
     *   [categories] : Array<$Setting.Details.Category>
     * }
     */
    GetCategories: function(x) {
      try {
        validate.type["Setting.Level"](x.level, "level");
        validate.string(x.section, "section", {});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Settings.GetCategories', x);
    },


    /**
     * Settings.GetSections
     * 
     * Retrieves all setting sections
     * 
     * @param level: $Setting.Level
     * @param properties: unknown
     * 
     * @returns {
     *   [sections] : Array<$Setting.Details.Section>
     * }
     */
    GetSections: function(x) {
      try {
        validate.type["Setting.Level"](x.level, "level");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Settings.GetSections', x);
    },


    /**
     * Settings.GetSettingValue
     * 
     * Retrieves the value of a setting
     * 
     * @param setting: string
     * 
     * @returns {
     *   value : $Setting.Value.Extended
     * }
     */
    GetSettingValue: function(x) {
      try {
        validate.required(x.setting, "setting");
        validate.string(x.setting, "setting", {"minLength":1});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Settings.GetSettingValue', x);
    },


    /**
     * Settings.GetSettings
     * 
     * Retrieves all settings
     * 
     * @param level: $Setting.Level
     * @param filter: {,  category : string,  section : string,}
     * 
     * @returns {
     *   [settings] : Array<$Setting.Details.Setting>
     * }
     */
    GetSettings: function(x) {
      try {
        validate.type["Setting.Level"](x.level, "level");
        var types_left = 1;
        try {
          validate.required(x.category, "category");
          validate.string(x.category, "category", {"minLength":1});
          validate.required(x.section, "section");
          validate.string(x.section, "section", {"minLength":1});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Settings.GetSettings', x);
    },


    /**
     * Settings.ResetSettingValue
     * 
     * Resets the value of a setting
     * 
     * @param setting: string
     * 
     * @returns string
     */
    ResetSettingValue: function(x) {
      try {
        validate.required(x.setting, "setting");
        validate.string(x.setting, "setting", {"minLength":1});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Settings.ResetSettingValue', x);
    },


    /**
     * Settings.SetSettingValue
     * 
     * Changes the value of a setting
     * 
     * @param setting: string
     * @param value: $Setting.Value.Extended
     * 
     * @returns boolean
     */
    SetSettingValue: function(x) {
      try {
        validate.required(x.setting, "setting");
        validate.string(x.setting, "setting", {"minLength":1});
        validate.required(x.value, "value");
        validate.type["Setting.Value.Extended"](x.value, "value");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Settings.SetSettingValue', x);
    },

  },


  System: {

    /**
     * System.EjectOpticalDrive
     * 
     * Ejects or closes the optical disc drive (if available)
     * 
     * 
     * @returns string
     */
    EjectOpticalDrive: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('System.EjectOpticalDrive', x);
    },


    /**
     * System.GetProperties
     * 
     * Retrieves the values of the given properties
     * 
     * @param properties: Array<$System.Property.Name>
     * 
     * @returns $System.Property.Value
     */
    GetProperties: function(x) {
      try {
        validate.required(x.properties, "properties");
        validate.array(x.properties, "properties", {"uniqueItems":true});
        for (var itemIdx in x.properties.items) {
          validate.type["System.Property.Name"](x.properties.items[itemIdx], "x.properties.items[itemIdx]");
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('System.GetProperties', x);
    },


    /**
     * System.Hibernate
     * 
     * Puts the system running XBMC into hibernate mode
     * 
     * 
     * @returns string
     */
    Hibernate: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('System.Hibernate', x);
    },


    /**
     * System.Reboot
     * 
     * Reboots the system running XBMC
     * 
     * 
     * @returns string
     */
    Reboot: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('System.Reboot', x);
    },


    /**
     * System.Shutdown
     * 
     * Shuts the system running XBMC down
     * 
     * 
     * @returns string
     */
    Shutdown: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('System.Shutdown', x);
    },


    /**
     * System.Suspend
     * 
     * Suspends the system running XBMC
     * 
     * 
     * @returns string
     */
    Suspend: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('System.Suspend', x);
    },

  },


  Textures: {

    /**
     * Textures.GetTextures
     * 
     * Retrieve all textures
     * 
     * @param properties: $Textures.Fields.Texture
     * @param filter: $List.Filter.Textures
     * 
     * @returns {
     *   textures : Array<$Textures.Details.Texture>
     * }
     */
    GetTextures: function(x) {
      try {
        validate.type["Textures.Fields.Texture"](x.properties, "properties");
        validate.type["List.Filter.Textures"](x.filter, "filter");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Textures.GetTextures', x);
    },


    /**
     * Textures.RemoveTexture
     * 
     * Remove the specified texture
     * 
     * @param textureid: $Library.Id
     * 
     * @returns string
     */
    RemoveTexture: function(x) {
      try {
        validate.required(x.textureid, "textureid");
        validate.type["Library.Id"](x.textureid, "textureid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('Textures.RemoveTexture', x);
    },

  },


  VideoLibrary: {

    /**
     * VideoLibrary.Clean
     * 
     * Cleans the video library from non-existent items
     * 
     * 
     * @returns string
     */
    Clean: function(x) {
      try {
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.Clean', x);
    },


    /**
     * VideoLibrary.Export
     * 
     * Exports all items from the video library
     * 
     * @param options: {,  path : string,} | {,  [actorthumbs] : boolean,  [images] : boolean,  [overwrite] : boolean,}
     * 
     * @returns string
     */
    Export: function(x) {
      try {
        var types_left = 2;
        try {
          validate.required(x.path, "path");
          validate.string(x.path, "path", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.boolean(x.actorthumbs, "actorthumbs", {});
          validate.boolean(x.images, "images", {});
          validate.boolean(x.overwrite, "overwrite", {});
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("options did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.Export', x);
    },


    /**
     * VideoLibrary.GetEpisodeDetails
     * 
     * Retrieve details about a specific tv show episode
     * 
     * @param episodeid: $Library.Id
     * @param properties: $Video.Fields.Episode
     * 
     * @returns {
     *   [episodedetails] : $Video.Details.Episode
     * }
     */
    GetEpisodeDetails: function(x) {
      try {
        validate.required(x.episodeid, "episodeid");
        validate.type["Library.Id"](x.episodeid, "episodeid");
        validate.type["Video.Fields.Episode"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetEpisodeDetails', x);
    },


    /**
     * VideoLibrary.GetEpisodes
     * 
     * Retrieve all tv show episodes
     * 
     * @param tvshowid: $Library.Id
     * @param season: integer
     * @param properties: $Video.Fields.Episode
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  genreid : $Library.Id,} | {,  genre : string,} | {,  year : integer,} | {,  actor : string,} | {,  director : string,} | $List.Filter.Episodes
     * 
     * @returns {
     *   [episodes] : Array<$Video.Details.Episode>
     *   limits : $List.LimitsReturned
     * }
     */
    GetEpisodes: function(x) {
      try {
        validate.type["Library.Id"](x.tvshowid, "tvshowid");
        validate.integer(x.season, "season", {"minimum":0});
        validate.type["Video.Fields.Episode"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 6;
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.year, "year");
          validate.integer(x.year, "year", {"minimum":0});
        } catch (type_ex) {
        }
        try {
          validate.required(x.actor, "actor");
          validate.string(x.actor, "actor", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.director, "director");
          validate.string(x.director, "director", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.Episodes"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetEpisodes', x);
    },


    /**
     * VideoLibrary.GetGenres
     * 
     * Retrieve all genres
     * 
     * @param type: string
     * @param properties: $Library.Fields.Genre
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   genres : Array<$Library.Details.Genre>
     *   limits : $List.LimitsReturned
     * }
     */
    GetGenres: function(x) {
      try {
        validate.required(x.type, "type");
        validate.string(x.type, "type", {"enums":["movie","tvshow","musicvideo"]});
        validate.type["Library.Fields.Genre"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetGenres', x);
    },


    /**
     * VideoLibrary.GetMovieDetails
     * 
     * Retrieve details about a specific movie
     * 
     * @param movieid: $Library.Id
     * @param properties: $Video.Fields.Movie
     * 
     * @returns {
     *   [moviedetails] : $Video.Details.Movie
     * }
     */
    GetMovieDetails: function(x) {
      try {
        validate.required(x.movieid, "movieid");
        validate.type["Library.Id"](x.movieid, "movieid");
        validate.type["Video.Fields.Movie"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetMovieDetails', x);
    },


    /**
     * VideoLibrary.GetMovieSetDetails
     * 
     * Retrieve details about a specific movie set
     * 
     * @param setid: $Library.Id
     * @param properties: $Video.Fields.MovieSet
     * @param movies: {
     *   [limits] : $List.Limits
     *   [properties] : $Video.Fields.Movie
     *   [sort] : $List.Sort
     * }
     * 
     * @returns {
     *   [setdetails] : $Video.Details.MovieSet.Extended
     * }
     */
    GetMovieSetDetails: function(x) {
      try {
        validate.required(x.setid, "setid");
        validate.type["Library.Id"](x.setid, "setid");
        validate.type["Video.Fields.MovieSet"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["Video.Fields.Movie"](x.properties, "properties");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetMovieSetDetails', x);
    },


    /**
     * VideoLibrary.GetMovieSets
     * 
     * Retrieve all movie sets
     * 
     * @param properties: $Video.Fields.MovieSet
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [sets] : Array<$Video.Details.MovieSet>
     * }
     */
    GetMovieSets: function(x) {
      try {
        validate.type["Video.Fields.MovieSet"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetMovieSets', x);
    },


    /**
     * VideoLibrary.GetMovies
     * 
     * Retrieve all movies
     * 
     * @param properties: $Video.Fields.Movie
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  genreid : $Library.Id,} | {,  genre : string,} | {,  year : integer,} | {,  actor : string,} | {,  director : string,} | {,  studio : string,} | {,  country : string,} | {,  setid : $Library.Id,} | {,  set : string,} | {,  tag : string,} | $List.Filter.Movies
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [movies] : Array<$Video.Details.Movie>
     * }
     */
    GetMovies: function(x) {
      try {
        validate.type["Video.Fields.Movie"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 11;
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.year, "year");
          validate.integer(x.year, "year", {"minimum":0});
        } catch (type_ex) {
        }
        try {
          validate.required(x.actor, "actor");
          validate.string(x.actor, "actor", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.director, "director");
          validate.string(x.director, "director", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.studio, "studio");
          validate.string(x.studio, "studio", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.country, "country");
          validate.string(x.country, "country", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.setid, "setid");
          validate.type["Library.Id"](x.setid, "setid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.set, "set");
          validate.string(x.set, "set", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.tag, "tag");
          validate.string(x.tag, "tag", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.Movies"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetMovies', x);
    },


    /**
     * VideoLibrary.GetMusicVideoDetails
     * 
     * Retrieve details about a specific music video
     * 
     * @param musicvideoid: $Library.Id
     * @param properties: $Video.Fields.MusicVideo
     * 
     * @returns {
     *   [musicvideodetails] : $Video.Details.MusicVideo
     * }
     */
    GetMusicVideoDetails: function(x) {
      try {
        validate.required(x.musicvideoid, "musicvideoid");
        validate.type["Library.Id"](x.musicvideoid, "musicvideoid");
        validate.type["Video.Fields.MusicVideo"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetMusicVideoDetails', x);
    },


    /**
     * VideoLibrary.GetMusicVideos
     * 
     * Retrieve all music videos
     * 
     * @param properties: $Video.Fields.MusicVideo
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  artist : string,} | {,  genreid : $Library.Id,} | {,  genre : string,} | {,  year : integer,} | {,  director : string,} | {,  studio : string,} | {,  tag : string,} | $List.Filter.MusicVideos
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [musicvideos] : Array<$Video.Details.MusicVideo>
     * }
     */
    GetMusicVideos: function(x) {
      try {
        validate.type["Video.Fields.MusicVideo"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 8;
        try {
          validate.required(x.artist, "artist");
          validate.string(x.artist, "artist", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.year, "year");
          validate.integer(x.year, "year", {"minimum":0});
        } catch (type_ex) {
        }
        try {
          validate.required(x.director, "director");
          validate.string(x.director, "director", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.studio, "studio");
          validate.string(x.studio, "studio", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.tag, "tag");
          validate.string(x.tag, "tag", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.MusicVideos"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetMusicVideos', x);
    },


    /**
     * VideoLibrary.GetRecentlyAddedEpisodes
     * 
     * Retrieve all recently added tv episodes
     * 
     * @param properties: $Video.Fields.Episode
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   [episodes] : Array<$Video.Details.Episode>
     *   limits : $List.LimitsReturned
     * }
     */
    GetRecentlyAddedEpisodes: function(x) {
      try {
        validate.type["Video.Fields.Episode"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetRecentlyAddedEpisodes', x);
    },


    /**
     * VideoLibrary.GetRecentlyAddedMovies
     * 
     * Retrieve all recently added movies
     * 
     * @param properties: $Video.Fields.Movie
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [movies] : Array<$Video.Details.Movie>
     * }
     */
    GetRecentlyAddedMovies: function(x) {
      try {
        validate.type["Video.Fields.Movie"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetRecentlyAddedMovies', x);
    },


    /**
     * VideoLibrary.GetRecentlyAddedMusicVideos
     * 
     * Retrieve all recently added music videos
     * 
     * @param properties: $Video.Fields.MusicVideo
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [musicvideos] : Array<$Video.Details.MusicVideo>
     * }
     */
    GetRecentlyAddedMusicVideos: function(x) {
      try {
        validate.type["Video.Fields.MusicVideo"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetRecentlyAddedMusicVideos', x);
    },


    /**
     * VideoLibrary.GetSeasonDetails
     * 
     * Retrieve details about a specific tv show season
     * 
     * @param seasonid: $Library.Id
     * @param properties: $Video.Fields.Season
     * 
     * @returns {
     *   [seasondetails] : $Video.Details.Season
     * }
     */
    GetSeasonDetails: function(x) {
      try {
        validate.required(x.seasonid, "seasonid");
        validate.type["Library.Id"](x.seasonid, "seasonid");
        validate.type["Video.Fields.Season"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetSeasonDetails', x);
    },


    /**
     * VideoLibrary.GetSeasons
     * 
     * Retrieve all tv seasons
     * 
     * @param tvshowid: $Library.Id
     * @param properties: $Video.Fields.Season
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [seasons] : Array<$Video.Details.Season>
     * }
     */
    GetSeasons: function(x) {
      try {
        validate.required(x.tvshowid, "tvshowid");
        validate.type["Library.Id"](x.tvshowid, "tvshowid");
        validate.type["Video.Fields.Season"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetSeasons', x);
    },


    /**
     * VideoLibrary.GetTVShowDetails
     * 
     * Retrieve details about a specific tv show
     * 
     * @param tvshowid: $Library.Id
     * @param properties: $Video.Fields.TVShow
     * 
     * @returns {
     *   [tvshowdetails] : $Video.Details.TVShow
     * }
     */
    GetTVShowDetails: function(x) {
      try {
        validate.required(x.tvshowid, "tvshowid");
        validate.type["Library.Id"](x.tvshowid, "tvshowid");
        validate.type["Video.Fields.TVShow"](x.properties, "properties");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetTVShowDetails', x);
    },


    /**
     * VideoLibrary.GetTVShows
     * 
     * Retrieve all tv shows
     * 
     * @param properties: $Video.Fields.TVShow
     * @param limits: $List.Limits
     * @param sort: $List.Sort
     * @param filter: {,  genreid : $Library.Id,} | {,  genre : string,} | {,  year : integer,} | {,  actor : string,} | {,  studio : string,} | {,  tag : string,} | $List.Filter.TVShows
     * 
     * @returns {
     *   limits : $List.LimitsReturned
     *   [tvshows] : Array<$Video.Details.TVShow>
     * }
     */
    GetTVShows: function(x) {
      try {
        validate.type["Video.Fields.TVShow"](x.properties, "properties");
        validate.type["List.Limits"](x.limits, "limits");
        validate.type["List.Sort"](x.sort, "sort");
        var types_left = 7;
        try {
          validate.required(x.genreid, "genreid");
          validate.type["Library.Id"](x.genreid, "genreid");
        } catch (type_ex) {
        }
        try {
          validate.required(x.genre, "genre");
          validate.string(x.genre, "genre", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.year, "year");
          validate.integer(x.year, "year", {"minimum":0});
        } catch (type_ex) {
        }
        try {
          validate.required(x.actor, "actor");
          validate.string(x.actor, "actor", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.studio, "studio");
          validate.string(x.studio, "studio", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.required(x.tag, "tag");
          validate.string(x.tag, "tag", {"minLength":1});
        } catch (type_ex) {
        }
        try {
          validate.type["List.Filter.TVShows"](x.filter, "filter");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("filter did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.GetTVShows', x);
    },


    /**
     * VideoLibrary.RemoveEpisode
     * 
     * Removes the given episode from the library
     * 
     * @param episodeid: $Library.Id
     * 
     * @returns string
     */
    RemoveEpisode: function(x) {
      try {
        validate.required(x.episodeid, "episodeid");
        validate.type["Library.Id"](x.episodeid, "episodeid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.RemoveEpisode', x);
    },


    /**
     * VideoLibrary.RemoveMovie
     * 
     * Removes the given movie from the library
     * 
     * @param movieid: $Library.Id
     * 
     * @returns string
     */
    RemoveMovie: function(x) {
      try {
        validate.required(x.movieid, "movieid");
        validate.type["Library.Id"](x.movieid, "movieid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.RemoveMovie', x);
    },


    /**
     * VideoLibrary.RemoveMusicVideo
     * 
     * Removes the given music video from the library
     * 
     * @param musicvideoid: $Library.Id
     * 
     * @returns string
     */
    RemoveMusicVideo: function(x) {
      try {
        validate.required(x.musicvideoid, "musicvideoid");
        validate.type["Library.Id"](x.musicvideoid, "musicvideoid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.RemoveMusicVideo', x);
    },


    /**
     * VideoLibrary.RemoveTVShow
     * 
     * Removes the given tv show from the library
     * 
     * @param tvshowid: $Library.Id
     * 
     * @returns string
     */
    RemoveTVShow: function(x) {
      try {
        validate.required(x.tvshowid, "tvshowid");
        validate.type["Library.Id"](x.tvshowid, "tvshowid");
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.RemoveTVShow', x);
    },


    /**
     * VideoLibrary.Scan
     * 
     * Scans the video sources for new library items
     * 
     * @param directory: string
     * 
     * @returns string
     */
    Scan: function(x) {
      try {
        validate.string(x.directory, "directory", {});
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.Scan', x);
    },


    /**
     * VideoLibrary.SetEpisodeDetails
     * 
     * Update the given episode with the given details
     * 
     * @param episodeid: $Library.Id
     * @param title: $Optional.String
     * @param playcount: $Optional.Integer
     * @param runtime: $Optional.Integer
     * @param director: null | $Array.String
     * @param plot: $Optional.String
     * @param rating: $Optional.Number
     * @param votes: $Optional.String
     * @param lastplayed: $Optional.String
     * @param writer: null | $Array.String
     * @param firstaired: $Optional.String
     * @param productioncode: $Optional.String
     * @param season: $Optional.Integer
     * @param episode: $Optional.Integer
     * @param originaltitle: $Optional.String
     * @param thumbnail: $Optional.String
     * @param fanart: $Optional.String
     * @param art: null | $Media.Artwork.Set
     * @param resume: null | $Video.Resume
     * 
     * @returns string
     */
    SetEpisodeDetails: function(x) {
      try {
        validate.required(x.episodeid, "episodeid");
        validate.type["Library.Id"](x.episodeid, "episodeid");
        validate.type["Optional.String"](x.title, "title");
        validate.type["Optional.Integer"](x.playcount, "playcount");
        validate.type["Optional.Integer"](x.runtime, "runtime");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.director, "director", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.director, "director");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("director did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.plot, "plot");
        validate.type["Optional.Number"](x.rating, "rating");
        validate.type["Optional.String"](x.votes, "votes");
        validate.type["Optional.String"](x.lastplayed, "lastplayed");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.writer, "writer", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.writer, "writer");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("writer did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.firstaired, "firstaired");
        validate.type["Optional.String"](x.productioncode, "productioncode");
        validate.type["Optional.Integer"](x.season, "season");
        validate.type["Optional.Integer"](x.episode, "episode");
        validate.type["Optional.String"](x.originaltitle, "originaltitle");
        validate.type["Optional.String"](x.thumbnail, "thumbnail");
        validate.type["Optional.String"](x.fanart, "fanart");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.art, "art", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Media.Artwork.Set"](x.art, "art");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("art did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.resume, "resume", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Video.Resume"](x.resume, "resume");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("resume did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.SetEpisodeDetails', x);
    },


    /**
     * VideoLibrary.SetMovieDetails
     * 
     * Update the given movie with the given details
     * 
     * @param movieid: $Library.Id
     * @param title: $Optional.String
     * @param playcount: $Optional.Integer
     * @param runtime: $Optional.Integer
     * @param director: null | $Array.String
     * @param studio: null | $Array.String
     * @param year: $Optional.Integer
     * @param plot: $Optional.String
     * @param genre: null | $Array.String
     * @param rating: $Optional.Number
     * @param mpaa: $Optional.String
     * @param imdbnumber: $Optional.String
     * @param votes: $Optional.String
     * @param lastplayed: $Optional.String
     * @param originaltitle: $Optional.String
     * @param trailer: $Optional.String
     * @param tagline: $Optional.String
     * @param plotoutline: $Optional.String
     * @param writer: null | $Array.String
     * @param country: null | $Array.String
     * @param top250: $Optional.Integer
     * @param sorttitle: $Optional.String
     * @param set: $Optional.String
     * @param showlink: null | $Array.String
     * @param thumbnail: $Optional.String
     * @param fanart: $Optional.String
     * @param tag: null | $Array.String
     * @param art: null | $Media.Artwork.Set
     * @param resume: null | $Video.Resume
     * 
     * @returns string
     */
    SetMovieDetails: function(x) {
      try {
        validate.required(x.movieid, "movieid");
        validate.type["Library.Id"](x.movieid, "movieid");
        validate.type["Optional.String"](x.title, "title");
        validate.type["Optional.Integer"](x.playcount, "playcount");
        validate.type["Optional.Integer"](x.runtime, "runtime");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.director, "director", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.director, "director");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("director did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.studio, "studio", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.studio, "studio");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("studio did not match any of the valid types");
          }
        }
        validate.type["Optional.Integer"](x.year, "year");
        validate.type["Optional.String"](x.plot, "plot");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.genre, "genre", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.genre, "genre");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("genre did not match any of the valid types");
          }
        }
        validate.type["Optional.Number"](x.rating, "rating");
        validate.type["Optional.String"](x.mpaa, "mpaa");
        validate.type["Optional.String"](x.imdbnumber, "imdbnumber");
        validate.type["Optional.String"](x.votes, "votes");
        validate.type["Optional.String"](x.lastplayed, "lastplayed");
        validate.type["Optional.String"](x.originaltitle, "originaltitle");
        validate.type["Optional.String"](x.trailer, "trailer");
        validate.type["Optional.String"](x.tagline, "tagline");
        validate.type["Optional.String"](x.plotoutline, "plotoutline");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.writer, "writer", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.writer, "writer");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("writer did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.country, "country", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.country, "country");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("country did not match any of the valid types");
          }
        }
        validate.type["Optional.Integer"](x.top250, "top250");
        validate.type["Optional.String"](x.sorttitle, "sorttitle");
        validate.type["Optional.String"](x.set, "set");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.showlink, "showlink", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.showlink, "showlink");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("showlink did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.thumbnail, "thumbnail");
        validate.type["Optional.String"](x.fanart, "fanart");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.tag, "tag", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.tag, "tag");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("tag did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.art, "art", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Media.Artwork.Set"](x.art, "art");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("art did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.resume, "resume", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Video.Resume"](x.resume, "resume");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("resume did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.SetMovieDetails', x);
    },


    /**
     * VideoLibrary.SetMovieSetDetails
     * 
     * Update the given movie set with the given details
     * 
     * @param setid: $Library.Id
     * @param title: $Optional.String
     * @param art: null | $Media.Artwork.Set
     * 
     * @returns string
     */
    SetMovieSetDetails: function(x) {
      try {
        validate.required(x.setid, "setid");
        validate.type["Library.Id"](x.setid, "setid");
        validate.type["Optional.String"](x.title, "title");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.art, "art", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Media.Artwork.Set"](x.art, "art");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("art did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.SetMovieSetDetails', x);
    },


    /**
     * VideoLibrary.SetMusicVideoDetails
     * 
     * Update the given music video with the given details
     * 
     * @param musicvideoid: $Library.Id
     * @param title: $Optional.String
     * @param playcount: $Optional.Integer
     * @param runtime: $Optional.Integer
     * @param director: null | $Array.String
     * @param studio: null | $Array.String
     * @param year: $Optional.Integer
     * @param plot: $Optional.String
     * @param album: $Optional.String
     * @param artist: null | $Array.String
     * @param genre: null | $Array.String
     * @param track: $Optional.Integer
     * @param lastplayed: $Optional.String
     * @param thumbnail: $Optional.String
     * @param fanart: $Optional.String
     * @param tag: null | $Array.String
     * @param art: null | $Media.Artwork.Set
     * @param resume: null | $Video.Resume
     * 
     * @returns string
     */
    SetMusicVideoDetails: function(x) {
      try {
        validate.required(x.musicvideoid, "musicvideoid");
        validate.type["Library.Id"](x.musicvideoid, "musicvideoid");
        validate.type["Optional.String"](x.title, "title");
        validate.type["Optional.Integer"](x.playcount, "playcount");
        validate.type["Optional.Integer"](x.runtime, "runtime");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.director, "director", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.director, "director");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("director did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.studio, "studio", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.studio, "studio");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("studio did not match any of the valid types");
          }
        }
        validate.type["Optional.Integer"](x.year, "year");
        validate.type["Optional.String"](x.plot, "plot");
        validate.type["Optional.String"](x.album, "album");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.artist, "artist", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.artist, "artist");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("artist did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.genre, "genre", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.genre, "genre");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("genre did not match any of the valid types");
          }
        }
        validate.type["Optional.Integer"](x.track, "track");
        validate.type["Optional.String"](x.lastplayed, "lastplayed");
        validate.type["Optional.String"](x.thumbnail, "thumbnail");
        validate.type["Optional.String"](x.fanart, "fanart");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.tag, "tag", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.tag, "tag");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("tag did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.art, "art", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Media.Artwork.Set"](x.art, "art");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("art did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.resume, "resume", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Video.Resume"](x.resume, "resume");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("resume did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.SetMusicVideoDetails', x);
    },


    /**
     * VideoLibrary.SetSeasonDetails
     * 
     * Update the given season with the given details
     * 
     * @param seasonid: $Library.Id
     * @param art: null | $Media.Artwork.Set
     * 
     * @returns string
     */
    SetSeasonDetails: function(x) {
      try {
        validate.required(x.seasonid, "seasonid");
        validate.type["Library.Id"](x.seasonid, "seasonid");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.art, "art", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Media.Artwork.Set"](x.art, "art");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("art did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.SetSeasonDetails', x);
    },


    /**
     * VideoLibrary.SetTVShowDetails
     * 
     * Update the given tvshow with the given details
     * 
     * @param tvshowid: $Library.Id
     * @param title: $Optional.String
     * @param playcount: $Optional.Integer
     * @param studio: null | $Array.String
     * @param plot: $Optional.String
     * @param genre: null | $Array.String
     * @param rating: $Optional.Number
     * @param mpaa: $Optional.String
     * @param imdbnumber: $Optional.String
     * @param premiered: $Optional.String
     * @param votes: $Optional.String
     * @param lastplayed: $Optional.String
     * @param originaltitle: $Optional.String
     * @param sorttitle: $Optional.String
     * @param episodeguide: $Optional.String
     * @param thumbnail: $Optional.String
     * @param fanart: $Optional.String
     * @param tag: null | $Array.String
     * @param art: null | $Media.Artwork.Set
     * 
     * @returns string
     */
    SetTVShowDetails: function(x) {
      try {
        validate.required(x.tvshowid, "tvshowid");
        validate.type["Library.Id"](x.tvshowid, "tvshowid");
        validate.type["Optional.String"](x.title, "title");
        validate.type["Optional.Integer"](x.playcount, "playcount");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.studio, "studio", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.studio, "studio");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("studio did not match any of the valid types");
          }
        }
        validate.type["Optional.String"](x.plot, "plot");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.genre, "genre", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.genre, "genre");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("genre did not match any of the valid types");
          }
        }
        validate.type["Optional.Number"](x.rating, "rating");
        validate.type["Optional.String"](x.mpaa, "mpaa");
        validate.type["Optional.String"](x.imdbnumber, "imdbnumber");
        validate.type["Optional.String"](x.premiered, "premiered");
        validate.type["Optional.String"](x.votes, "votes");
        validate.type["Optional.String"](x.lastplayed, "lastplayed");
        validate.type["Optional.String"](x.originaltitle, "originaltitle");
        validate.type["Optional.String"](x.sorttitle, "sorttitle");
        validate.type["Optional.String"](x.episodeguide, "episodeguide");
        validate.type["Optional.String"](x.thumbnail, "thumbnail");
        validate.type["Optional.String"](x.fanart, "fanart");
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.tag, "tag", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Array.String"](x.tag, "tag");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("tag did not match any of the valid types");
          }
        }
        var types_left = 2;
        try {
          validate.undefinedOrNull(x.art, "art", undefined);
        } catch (type_ex) {
        }
        try {
          validate.type["Media.Artwork.Set"](x.art, "art");
        } catch (type_ex) {
          if (--types_left === 0) {
            throw new Error("art did not match any of the valid types");
          }
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('VideoLibrary.SetTVShowDetails', x);
    },

  },


  XBMC: {

    /**
     * XBMC.GetInfoBooleans
     * 
     * Retrieve info booleans about XBMC and the system
     * 
     * @param booleans: Array<string>
     * 
     * @returns object
     */
    GetInfoBooleans: function(x) {
      try {
        validate.required(x.booleans, "booleans");
        validate.array(x.booleans, "booleans", {"minItems":1});
        for (var itemIdx in x.booleans.items) {
          validate.string(x.booleans.items[itemIdx], "x.booleans.items[itemIdx]", {});
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('XBMC.GetInfoBooleans', x);
    },


    /**
     * XBMC.GetInfoLabels
     * 
     * Retrieve info labels about XBMC and the system
     * 
     * @param labels: Array<string>
     * 
     * @returns object
     */
    GetInfoLabels: function(x) {
      try {
        validate.required(x.labels, "labels");
        validate.array(x.labels, "labels", {"minItems":1});
        for (var itemIdx in x.labels.items) {
          validate.string(x.labels.items[itemIdx], "x.labels.items[itemIdx]", {});
        }
      } catch (validation_err) {
        throw validation_err.message + "\n" + validation_err.stack;
      }
      return rpc.send_msg('XBMC.GetInfoLabels', x);
    },

  },

};

module.exports.rpc = rpc;
},{"./kodijs/rpc":18,"./kodijs/validate":19}],23:[function(require,module,exports){
var _ = require("lodash");
var Observable = require("./observable");
var activeCard;
var CARDNUM = require("./cards/cardnum");

module.exports = {
  show: null,
  season: null,
  episode: null,
  nowplaying: new Observable({}),
  player: {
    // TODO Support multiple player ids?
    id: new Observable(1), // XXX: Hardcoded for now...
    volume: new Observable(0),
    muted: new Observable(false),
    speed: new Observable(0),
    position: new Observable(-1),
    duration: new Observable(-1)
  },
  lastCard: null
};

module.exports.toCard = function(card) {
  if (activeCard === card) {
    console.log("Card: " + card.id + " is already visible, nothing to do.");
  }
  $("#main").addClass("animating");

  console.log("Showing card: " + card.id);
  // If there is no active card, just show the new one
  if (activeCard) {
    var dir = activeCard.num < card.num ? 'left' : 'right';
    $(activeCard.id).removeClass("card-active").addClass(dir);
    activeCard.deactivate();
  }

  $(card.id).removeClass("left right").addClass("card-active");
  activeCard = card;

  // TODO This is very sloppy. Don't really do this.
  // Don't go back and forth between classic remote and now playing
  if (activeCard.num !== CARDNUM.NOWPLAYING && activeCard.num !== CARDNUM.CLASSIC_REMOTE) {
    this.lastCard = activeCard;
  }
};

},{"./cards/cardnum":12,"./observable":21,"lodash":27}],24:[function(require,module,exports){
module.exports = function(Handlebars) {

this["JST"] = this["JST"] || {};

this["JST"]["classic_remote"] = Handlebars.template({"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  return "<div id=\"classic-remote\">\n<div class=\"row three-buttons\"><button id=\"classic-home\"><span data-icon=\"wallpaper\"></span></button><button id=\"classic-up\">&#8657;</button><button id=\"classic-info\"><span data-icon=\"info\"></span></button></div>\n<div class=\"row three-buttons\"><button id=\"classic-left\">&#8656;</button><button id=\"classic-select\">&#10042;</button><button id=\"classic-right\">&#8658;</button></div>\n<div class=\"row three-buttons\"><button id=\"classic-context-menu\"><span data-icon=\"menu\"></span></button><button id=\"classic-down\">&#8659;</button><button id=\"classic-back\"><span data-icon=\"undo\"></span></button></div>\n</div>\n";
  },"useData":true});



this["JST"]["connection"] = Handlebars.template({"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return "<form id=\"cfg-form\">\n  <p>\n    <input id=\"cfg-host-field\" type=\"text\" placeholder=\"Host\" required=\"\" value=\""
    + escapeExpression(((helper = (helper = helpers.host || (depth0 != null ? depth0.host : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"host","hash":{},"data":data}) : helper)))
    + "\">\n    <button type=\"reset\">Clear</button>\n  </p>\n  <p>\n    <input id=\"cfg-port-field\" type=\"number\" required=\"\" value=\""
    + escapeExpression(((helper = (helper = helpers.port || (depth0 != null ? depth0.port : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"port","hash":{},"data":data}) : helper)))
    + "\">\n    <button type=\"reset\">Clear</button> \n  </p>\n  <p>\n    <a id=\"cfg-connect-btn\" class=\"bb-button recommend\" href=\"#\">Connect</a> \n  </p>\n</form>\n";
},"useData":true});



this["JST"]["episode_list"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return "  <li class=\"episode-list-item\">\n    <a href=\"#\" data-libraryid=\""
    + escapeExpression(((helper = (helper = helpers.episodeid || (depth0 != null ? depth0.episodeid : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"episodeid","hash":{},"data":data}) : helper)))
    + "\" class=\"selectable\">\n      <aside class=\"episode-banner\">\n        "
    + escapeExpression(((helper = (helper = helpers.img_episode_art || (depth0 != null ? depth0.img_episode_art : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"img_episode_art","hash":{},"data":data}) : helper)))
    + "\n      </aside>\n      <p class=\"episode-title\">\n        "
    + escapeExpression(((helper = (helper = helpers.title || (depth0 != null ? depth0.title : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"title","hash":{},"data":data}) : helper)))
    + "\n      </p>\n      <p class=\"episode-number\">\n        Episode "
    + escapeExpression(((helper = (helper = helpers.episode || (depth0 != null ? depth0.episode : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"episode","hash":{},"data":data}) : helper)))
    + "\n      </p>\n    </a>\n  </li>\n";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "<ul id=\"episode-list\" class=\"banner-list\">\n";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.episodes : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer + "</ul>\n";
},"useData":true});



this["JST"]["index"] = Handlebars.template({"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  return "<ul id=\"index-list\">\n  <li>\n    <a data-card-link=\"TVSHOWS\" href=\"#\" class=\"selectable\">\n      <span data-icon=\"video-size\"></span> TV Shows\n      <div id=\"index-recent-episodes\" class=\"recent\">recent...</div>\n    </a>\n  </li>\n  <li>\n    <a data-card-link=\"MOVIES\" href=\"#\" class=\"selectable\">\n      <span data-icon=\"video\"></span> Movies\n      <div id=\"index-recent-movies\" class=\"recent\">recent...</div>\n    </a>\n  </li>\n  <li>\n    <a data-card-link=\"SETTINGS\" href=\"#\">\n      <span data-icon=\"settings\"></span> Settings\n    </a>\n  </li>\n</ul>\n";
  },"useData":true});



this["JST"]["index_recent_episodes"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return escapeExpression(((helper = (helper = helpers.img_episode_art_recent || (depth0 != null ? depth0.img_episode_art_recent : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"img_episode_art_recent","hash":{},"data":data}) : helper)))
    + "\n";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.episodes : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer;
},"useData":true});



this["JST"]["index_recent_movies"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return escapeExpression(((helper = (helper = helpers.img_movie_art || (depth0 != null ? depth0.img_movie_art : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"img_movie_art","hash":{},"data":data}) : helper)))
    + "\n";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.movies : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer;
},"useData":true});



this["JST"]["movie_list"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return "  <li>\n    <a data-libraryid=\""
    + escapeExpression(((helper = (helper = helpers.movieid || (depth0 != null ? depth0.movieid : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"movieid","hash":{},"data":data}) : helper)))
    + "\" href=\"#\" class=\"selectable\">\n      <aside class=\"season-banner\">\n        "
    + escapeExpression(((helper = (helper = helpers.img_movie_art || (depth0 != null ? depth0.img_movie_art : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"img_movie_art","hash":{},"data":data}) : helper)))
    + "\n      </aside>\n      <p class=\"season-label\">\n        "
    + escapeExpression(((helper = (helper = helpers.title || (depth0 != null ? depth0.title : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"title","hash":{},"data":data}) : helper)))
    + "\n      </p>\n    </a>\n  </li>\n";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "<ul id=\"movie-list\" class=\"large-side-banners\">\n";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.movies : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer + "</ul>\n";
},"useData":true});



this["JST"]["nowplaying"] = Handlebars.template({"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  return "<div id=\"nowplaying-info\" class=\"scrollable\">\n  <img id=\"nowplaying-thumb\" alt=\"\" src=\"/assets/thumb.png\">\n  <h3 id=\"nowplaying-episode-title\"></h3>\n  <p id=\"nowplaying-episode-plot\"></p>\n</div>\n\n<div id=\"nowplaying-controls\" role=\"toolbar\">\n<button id=\"nowplaying-more\" data-icon=\"dialpad\"></button><button id=\"nowplaying-seek-back\" data-icon=\"seek-back\"></button><button id=\"nowplaying-playpause\" data-icon=\"play\"></button><button id=\"nowplaying-seek-forward\" data-icon=\"seek-forward\"></button><button id=\"nowplaying-volume\" data-icon=\"sound-max\"></button>\n<button id=\"nowplaying-media-info\" data-icon=\"info\" disabled></button><button id=\"nowplaying-skip-back\" data-icon=\"skip-back\"></button><button id=\"nowplaying-stop\" data-icon=\"stop\"></button><button id=\"nowplaying-skip-forward\" data-icon=\"skip-forward\"></button><button id=\"nowplaying-help\" data-icon=\"help\" disabled></button>\n<div id=\"nowplaying-seek\" role=\"slider\">\n  <label id=\"nowplaying-seek-cur\">&ndash;</label>\n  <label id=\"nowplaying-seek-end\">&ndash;</label>\n  <div id=\"nowplaying-seek-bar\">\n    <progress value=\"0\" max=\"0\"></progress>\n    <button id=\"nowplaying-seek-handler\">handler</button>\n  </div>\n</div>\n</div>\n";
  },"useData":true});



this["JST"]["season_list"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return "  <li>\n    <a data-show-id=\""
    + escapeExpression(((helper = (helper = helpers.tvshowid || (depth0 != null ? depth0.tvshowid : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"tvshowid","hash":{},"data":data}) : helper)))
    + "\" data-season=\""
    + escapeExpression(((helper = (helper = helpers.season || (depth0 != null ? depth0.season : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"season","hash":{},"data":data}) : helper)))
    + "\" href=\"#\" class=\"selectable\">\n      <aside class=\"season-banner\">\n        "
    + escapeExpression(((helper = (helper = helpers.img_season_art || (depth0 != null ? depth0.img_season_art : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"img_season_art","hash":{},"data":data}) : helper)))
    + "\n      </aside>\n      <p class=\"season-label\">\n        Season "
    + escapeExpression(((helper = (helper = helpers.season || (depth0 != null ? depth0.season : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"season","hash":{},"data":data}) : helper)))
    + "\n      </p>\n      <p class=\"season-episode-ct\">\n        "
    + escapeExpression(((helper = (helper = helpers.episode || (depth0 != null ? depth0.episode : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"episode","hash":{},"data":data}) : helper)))
    + " episodes\n      </p>\n    </a>\n  </li>\n";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "<ul id=\"season-list\" class=\"large-side-banners\">\n";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.seasons : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer + "</ul>\n";
},"useData":true});



this["JST"]["settings"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var lambda=this.lambda, escapeExpression=this.escapeExpression;
  return "<option value=\""
    + escapeExpression(lambda((data && data.key), depth0))
    + "\">"
    + escapeExpression(lambda(depth0, depth0))
    + "</option>";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "<form id=\"settings-form\">\n  <fieldset>\n    <legend class=\"action\">Kodi Settings</legend>\n    <section>\n      <p>\n        <button id=\"update-library\">Update Library</button>\n      </p>\n    </section>\n  </fieldset>\n  <fieldset>\n    <legend class=\"action\">Animations</legend>\n    <section>\n      <p>\n        <select id=\"cfg-effect\">\n        ";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.effect_choices : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer + "\n        </select>\n      </p>\n    </settings>\n  </fieldset>\n  <fieldset>\n    <legend class=\"action\">Foxi v0.1.0</legend>\n    <a class=\"bb-button\" href=\"https://github.com/soupytwist/foxi/issues/\" target=\"_blank\"><i data-icon=\"bug\" class=\"icon-small\"></i>  Report an Issue</a>\n    <section>\n      <ul>\n      <li><b>v0.1.0</b>: Initial Release; supports Movies and TV Shows\n      </ul>\n    </section>\n  </fieldset>\n</form>\n";
},"useData":true});



this["JST"]["tv_show_list"] = Handlebars.template({"1":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return "<li>"
    + escapeExpression(((helper = (helper = helpers.tv_banner || (depth0 != null ? depth0.tv_banner : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"tv_banner","hash":{},"data":data}) : helper)))
    + "</li>";
},"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var stack1, buffer = "<ul id=\"tv-show-list\" class=\"banner-list\">\n  ";
  stack1 = helpers.each.call(depth0, (depth0 != null ? depth0.tvshows : depth0), {"name":"each","hash":{},"fn":this.program(1, data),"inverse":this.noop,"data":data});
  if (stack1 != null) { buffer += stack1; }
  return buffer + "\n</ul>\n";
},"useData":true});



this["JST"]["volume"] = Handlebars.template({"compiler":[6,">= 2.0.0-beta.1"],"main":function(depth0,helpers,partials,data) {
  var helper, functionType="function", helperMissing=helpers.helperMissing, escapeExpression=this.escapeExpression;
  return "<nav id=\"volume-bar\" data-type=\"scrollbar\">\n  <p id=\"volume-indicator\">"
    + escapeExpression(((helper = (helper = helpers.volume || (depth0 != null ? depth0.volume : depth0)) != null ? helper : helperMissing),(typeof helper === functionType ? helper.call(depth0, {"name":"volume","hash":{},"data":data}) : helper)))
    + "</p>\n  <ol>\n    <li><a href=\"#\">100</a></li>\n    <li><a href=\"#\">95</a></li>\n    <li><a href=\"#\">90</a></li>\n    <li><a href=\"#\">85</a></li>\n    <li><a href=\"#\">80</a></li>\n    <li><a href=\"#\">75</a></li>\n    <li><a href=\"#\">70</a></li>\n    <li><a href=\"#\">65</a></li>\n    <li><a href=\"#\">60</a></li>\n    <li><a href=\"#\">55</a></li>\n    <li><a href=\"#\">50</a></li>\n    <li><a href=\"#\">45</a></li>\n    <li><a href=\"#\">40</a></li>\n    <li><a href=\"#\">35</a></li>\n    <li><a href=\"#\">30</a></li>\n    <li><a href=\"#\">25</a></li>\n    <li><a href=\"#\">20</a></li>\n    <li><a href=\"#\">15</a></li>\n    <li><a href=\"#\">10</a></li>\n    <li><a href=\"#\">5</a></li>\n    <li><a href=\"#\">0</a></li>\n  </ol>\n</nav>\n";
},"useData":true});

return this["JST"];

};
},{}],25:[function(require,module,exports){
function hideBackButton() {
  $("#back-button").hide();
}


function showBackButton(action) {
  if (action) {
    $("#back-button").show().off('click').on('click', action);
  } else {
    $("#back-button").show();
  }
}


function setHeader(text) { 
  if (!text) {
    $("#header > h1").text("Foxi");
    return;
  }
  $("#header > h1").text(text);
  $("#header").show();
}


function setSubheader(text) { 
  if (!text) {
    $("#app").removeClass("subheader-visible");
    return;
  }
  $("#subheader > h2").text(text);
  $("#app").addClass("subheader-visible");
}


// HANDLEBARS HELPERS ----------------------------------------------------------
function getImageUrl(img) {
  if (img.startsWith('image://')) {
    var src = decodeURIComponent(img.substr(8, img.length-9));
    if (src.startsWith('/')) {
      // TODO This really need to be more robust. More testing required to figure out
      // other strategies for loading images on the filesystem
      src = 'http://' + localStorage.cfg_host + ":8080/vfs/" + encodeURIComponent(src);
    }
    return src;
  }
  return null;
}


// LOGIC HELPERS ---------------------------------------------------------------
function timeToSecs(t) {
  return ((t.hours||0) * 3600) + ((t.minutes||0) * 60) + (t.seconds||0);
}


function freezeUI(selected) {
  $("#freeze-fg").show();
  $(selected).addClass("freeze-selected");
}

function unfreezeUI() {
  $(".freeze-selected").removeClass("freeze-selected");
  $("#freeze-fg").hide();
}


module.exports.hideBackButton = hideBackButton;
module.exports.showBackButton = showBackButton;
module.exports.setHeader = setHeader;
module.exports.setSubheader = setSubheader;
module.exports.getImageUrl = getImageUrl;
module.exports.timeToSecs = timeToSecs;
module.exports.freezeUI = freezeUI;
module.exports.unfreezeUI = unfreezeUI;

},{}],26:[function(require,module,exports){
// shim for using process in browser

var process = module.exports = {};

process.nextTick = (function () {
    var canSetImmediate = typeof window !== 'undefined'
    && window.setImmediate;
    var canPost = typeof window !== 'undefined'
    && window.postMessage && window.addEventListener
    ;

    if (canSetImmediate) {
        return function (f) { return window.setImmediate(f) };
    }

    if (canPost) {
        var queue = [];
        window.addEventListener('message', function (ev) {
            var source = ev.source;
            if ((source === window || source === null) && ev.data === 'process-tick') {
                ev.stopPropagation();
                if (queue.length > 0) {
                    var fn = queue.shift();
                    fn();
                }
            }
        }, true);

        return function nextTick(fn) {
            queue.push(fn);
            window.postMessage('process-tick', '*');
        };
    }

    return function nextTick(fn) {
        setTimeout(fn, 0);
    };
})();

process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;

process.binding = function (name) {
    throw new Error('process.binding is not supported');
}

// TODO(shtylman)
process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};

},{}],27:[function(require,module,exports){
(function (global){
/**
 * @license
 * Lo-Dash 2.4.1 (Custom Build) <http://lodash.com/>
 * Build: `lodash modern -o ./dist/lodash.js`
 * Copyright 2012-2013 The Dojo Foundation <http://dojofoundation.org/>
 * Based on Underscore.js 1.5.2 <http://underscorejs.org/LICENSE>
 * Copyright 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 * Available under MIT license <http://lodash.com/license>
 */
;(function() {

  /** Used as a safe reference for `undefined` in pre ES5 environments */
  var undefined;

  /** Used to pool arrays and objects used internally */
  var arrayPool = [],
      objectPool = [];

  /** Used to generate unique IDs */
  var idCounter = 0;

  /** Used to prefix keys to avoid issues with `__proto__` and properties on `Object.prototype` */
  var keyPrefix = +new Date + '';

  /** Used as the size when optimizations are enabled for large arrays */
  var largeArraySize = 75;

  /** Used as the max size of the `arrayPool` and `objectPool` */
  var maxPoolSize = 40;

  /** Used to detect and test whitespace */
  var whitespace = (
    // whitespace
    ' \t\x0B\f\xA0\ufeff' +

    // line terminators
    '\n\r\u2028\u2029' +

    // unicode category "Zs" space separators
    '\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000'
  );

  /** Used to match empty string literals in compiled template source */
  var reEmptyStringLeading = /\b__p \+= '';/g,
      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;

  /**
   * Used to match ES6 template delimiters
   * http://people.mozilla.org/~jorendorff/es6-draft.html#sec-literals-string-literals
   */
  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;

  /** Used to match regexp flags from their coerced string values */
  var reFlags = /\w*$/;

  /** Used to detected named functions */
  var reFuncName = /^\s*function[ \n\r\t]+\w/;

  /** Used to match "interpolate" template delimiters */
  var reInterpolate = /<%=([\s\S]+?)%>/g;

  /** Used to match leading whitespace and zeros to be removed */
  var reLeadingSpacesAndZeros = RegExp('^[' + whitespace + ']*0+(?=.$)');

  /** Used to ensure capturing order of template delimiters */
  var reNoMatch = /($^)/;

  /** Used to detect functions containing a `this` reference */
  var reThis = /\bthis\b/;

  /** Used to match unescaped characters in compiled string literals */
  var reUnescapedString = /['\n\r\t\u2028\u2029\\]/g;

  /** Used to assign default `context` object properties */
  var contextProps = [
    'Array', 'Boolean', 'Date', 'Function', 'Math', 'Number', 'Object',
    'RegExp', 'String', '_', 'attachEvent', 'clearTimeout', 'isFinite', 'isNaN',
    'parseInt', 'setTimeout'
  ];

  /** Used to make template sourceURLs easier to identify */
  var templateCounter = 0;

  /** `Object#toString` result shortcuts */
  var argsClass = '[object Arguments]',
      arrayClass = '[object Array]',
      boolClass = '[object Boolean]',
      dateClass = '[object Date]',
      funcClass = '[object Function]',
      numberClass = '[object Number]',
      objectClass = '[object Object]',
      regexpClass = '[object RegExp]',
      stringClass = '[object String]';

  /** Used to identify object classifications that `_.clone` supports */
  var cloneableClasses = {};
  cloneableClasses[funcClass] = false;
  cloneableClasses[argsClass] = cloneableClasses[arrayClass] =
  cloneableClasses[boolClass] = cloneableClasses[dateClass] =
  cloneableClasses[numberClass] = cloneableClasses[objectClass] =
  cloneableClasses[regexpClass] = cloneableClasses[stringClass] = true;

  /** Used as an internal `_.debounce` options object */
  var debounceOptions = {
    'leading': false,
    'maxWait': 0,
    'trailing': false
  };

  /** Used as the property descriptor for `__bindData__` */
  var descriptor = {
    'configurable': false,
    'enumerable': false,
    'value': null,
    'writable': false
  };

  /** Used to determine if values are of the language type Object */
  var objectTypes = {
    'boolean': false,
    'function': true,
    'object': true,
    'number': false,
    'string': false,
    'undefined': false
  };

  /** Used to escape characters for inclusion in compiled string literals */
  var stringEscapes = {
    '\\': '\\',
    "'": "'",
    '\n': 'n',
    '\r': 'r',
    '\t': 't',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  /** Used as a reference to the global object */
  var root = (objectTypes[typeof window] && window) || this;

  /** Detect free variable `exports` */
  var freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;

  /** Detect free variable `module` */
  var freeModule = objectTypes[typeof module] && module && !module.nodeType && module;

  /** Detect the popular CommonJS extension `module.exports` */
  var moduleExports = freeModule && freeModule.exports === freeExports && freeExports;

  /** Detect free variable `global` from Node.js or Browserified code and use it as `root` */
  var freeGlobal = objectTypes[typeof global] && global;
  if (freeGlobal && (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal)) {
    root = freeGlobal;
  }

  /*--------------------------------------------------------------------------*/

  /**
   * The base implementation of `_.indexOf` without support for binary searches
   * or `fromIndex` constraints.
   *
   * @private
   * @param {Array} array The array to search.
   * @param {*} value The value to search for.
   * @param {number} [fromIndex=0] The index to search from.
   * @returns {number} Returns the index of the matched value or `-1`.
   */
  function baseIndexOf(array, value, fromIndex) {
    var index = (fromIndex || 0) - 1,
        length = array ? array.length : 0;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }

  /**
   * An implementation of `_.contains` for cache objects that mimics the return
   * signature of `_.indexOf` by returning `0` if the value is found, else `-1`.
   *
   * @private
   * @param {Object} cache The cache object to inspect.
   * @param {*} value The value to search for.
   * @returns {number} Returns `0` if `value` is found, else `-1`.
   */
  function cacheIndexOf(cache, value) {
    var type = typeof value;
    cache = cache.cache;

    if (type == 'boolean' || value == null) {
      return cache[value] ? 0 : -1;
    }
    if (type != 'number' && type != 'string') {
      type = 'object';
    }
    var key = type == 'number' ? value : keyPrefix + value;
    cache = (cache = cache[type]) && cache[key];

    return type == 'object'
      ? (cache && baseIndexOf(cache, value) > -1 ? 0 : -1)
      : (cache ? 0 : -1);
  }

  /**
   * Adds a given value to the corresponding cache object.
   *
   * @private
   * @param {*} value The value to add to the cache.
   */
  function cachePush(value) {
    var cache = this.cache,
        type = typeof value;

    if (type == 'boolean' || value == null) {
      cache[value] = true;
    } else {
      if (type != 'number' && type != 'string') {
        type = 'object';
      }
      var key = type == 'number' ? value : keyPrefix + value,
          typeCache = cache[type] || (cache[type] = {});

      if (type == 'object') {
        (typeCache[key] || (typeCache[key] = [])).push(value);
      } else {
        typeCache[key] = true;
      }
    }
  }

  /**
   * Used by `_.max` and `_.min` as the default callback when a given
   * collection is a string value.
   *
   * @private
   * @param {string} value The character to inspect.
   * @returns {number} Returns the code unit of given character.
   */
  function charAtCallback(value) {
    return value.charCodeAt(0);
  }

  /**
   * Used by `sortBy` to compare transformed `collection` elements, stable sorting
   * them in ascending order.
   *
   * @private
   * @param {Object} a The object to compare to `b`.
   * @param {Object} b The object to compare to `a`.
   * @returns {number} Returns the sort order indicator of `1` or `-1`.
   */
  function compareAscending(a, b) {
    var ac = a.criteria,
        bc = b.criteria,
        index = -1,
        length = ac.length;

    while (++index < length) {
      var value = ac[index],
          other = bc[index];

      if (value !== other) {
        if (value > other || typeof value == 'undefined') {
          return 1;
        }
        if (value < other || typeof other == 'undefined') {
          return -1;
        }
      }
    }
    // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
    // that causes it, under certain circumstances, to return the same value for
    // `a` and `b`. See https://github.com/jashkenas/underscore/pull/1247
    //
    // This also ensures a stable sort in V8 and other engines.
    // See http://code.google.com/p/v8/issues/detail?id=90
    return a.index - b.index;
  }

  /**
   * Creates a cache object to optimize linear searches of large arrays.
   *
   * @private
   * @param {Array} [array=[]] The array to search.
   * @returns {null|Object} Returns the cache object or `null` if caching should not be used.
   */
  function createCache(array) {
    var index = -1,
        length = array.length,
        first = array[0],
        mid = array[(length / 2) | 0],
        last = array[length - 1];

    if (first && typeof first == 'object' &&
        mid && typeof mid == 'object' && last && typeof last == 'object') {
      return false;
    }
    var cache = getObject();
    cache['false'] = cache['null'] = cache['true'] = cache['undefined'] = false;

    var result = getObject();
    result.array = array;
    result.cache = cache;
    result.push = cachePush;

    while (++index < length) {
      result.push(array[index]);
    }
    return result;
  }

  /**
   * Used by `template` to escape characters for inclusion in compiled
   * string literals.
   *
   * @private
   * @param {string} match The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  function escapeStringChar(match) {
    return '\\' + stringEscapes[match];
  }

  /**
   * Gets an array from the array pool or creates a new one if the pool is empty.
   *
   * @private
   * @returns {Array} The array from the pool.
   */
  function getArray() {
    return arrayPool.pop() || [];
  }

  /**
   * Gets an object from the object pool or creates a new one if the pool is empty.
   *
   * @private
   * @returns {Object} The object from the pool.
   */
  function getObject() {
    return objectPool.pop() || {
      'array': null,
      'cache': null,
      'criteria': null,
      'false': false,
      'index': 0,
      'null': false,
      'number': null,
      'object': null,
      'push': null,
      'string': null,
      'true': false,
      'undefined': false,
      'value': null
    };
  }

  /**
   * Releases the given array back to the array pool.
   *
   * @private
   * @param {Array} [array] The array to release.
   */
  function releaseArray(array) {
    array.length = 0;
    if (arrayPool.length < maxPoolSize) {
      arrayPool.push(array);
    }
  }

  /**
   * Releases the given object back to the object pool.
   *
   * @private
   * @param {Object} [object] The object to release.
   */
  function releaseObject(object) {
    var cache = object.cache;
    if (cache) {
      releaseObject(cache);
    }
    object.array = object.cache = object.criteria = object.object = object.number = object.string = object.value = null;
    if (objectPool.length < maxPoolSize) {
      objectPool.push(object);
    }
  }

  /**
   * Slices the `collection` from the `start` index up to, but not including,
   * the `end` index.
   *
   * Note: This function is used instead of `Array#slice` to support node lists
   * in IE < 9 and to ensure dense arrays are returned.
   *
   * @private
   * @param {Array|Object|string} collection The collection to slice.
   * @param {number} start The start index.
   * @param {number} end The end index.
   * @returns {Array} Returns the new array.
   */
  function slice(array, start, end) {
    start || (start = 0);
    if (typeof end == 'undefined') {
      end = array ? array.length : 0;
    }
    var index = -1,
        length = end - start || 0,
        result = Array(length < 0 ? 0 : length);

    while (++index < length) {
      result[index] = array[start + index];
    }
    return result;
  }

  /*--------------------------------------------------------------------------*/

  /**
   * Create a new `lodash` function using the given context object.
   *
   * @static
   * @memberOf _
   * @category Utilities
   * @param {Object} [context=root] The context object.
   * @returns {Function} Returns the `lodash` function.
   */
  function runInContext(context) {
    // Avoid issues with some ES3 environments that attempt to use values, named
    // after built-in constructors like `Object`, for the creation of literals.
    // ES5 clears this up by stating that literals must use built-in constructors.
    // See http://es5.github.io/#x11.1.5.
    context = context ? _.defaults(root.Object(), context, _.pick(root, contextProps)) : root;

    /** Native constructor references */
    var Array = context.Array,
        Boolean = context.Boolean,
        Date = context.Date,
        Function = context.Function,
        Math = context.Math,
        Number = context.Number,
        Object = context.Object,
        RegExp = context.RegExp,
        String = context.String,
        TypeError = context.TypeError;

    /**
     * Used for `Array` method references.
     *
     * Normally `Array.prototype` would suffice, however, using an array literal
     * avoids issues in Narwhal.
     */
    var arrayRef = [];

    /** Used for native method references */
    var objectProto = Object.prototype;

    /** Used to restore the original `_` reference in `noConflict` */
    var oldDash = context._;

    /** Used to resolve the internal [[Class]] of values */
    var toString = objectProto.toString;

    /** Used to detect if a method is native */
    var reNative = RegExp('^' +
      String(toString)
        .replace(/[.*+?^${}()|[\]\\]/g, '\\$&')
        .replace(/toString| for [^\]]+/g, '.*?') + '$'
    );

    /** Native method shortcuts */
    var ceil = Math.ceil,
        clearTimeout = context.clearTimeout,
        floor = Math.floor,
        fnToString = Function.prototype.toString,
        getPrototypeOf = isNative(getPrototypeOf = Object.getPrototypeOf) && getPrototypeOf,
        hasOwnProperty = objectProto.hasOwnProperty,
        push = arrayRef.push,
        setTimeout = context.setTimeout,
        splice = arrayRef.splice,
        unshift = arrayRef.unshift;

    /** Used to set meta data on functions */
    var defineProperty = (function() {
      // IE 8 only accepts DOM elements
      try {
        var o = {},
            func = isNative(func = Object.defineProperty) && func,
            result = func(o, o, o) && func;
      } catch(e) { }
      return result;
    }());

    /* Native method shortcuts for methods with the same name as other `lodash` methods */
    var nativeCreate = isNative(nativeCreate = Object.create) && nativeCreate,
        nativeIsArray = isNative(nativeIsArray = Array.isArray) && nativeIsArray,
        nativeIsFinite = context.isFinite,
        nativeIsNaN = context.isNaN,
        nativeKeys = isNative(nativeKeys = Object.keys) && nativeKeys,
        nativeMax = Math.max,
        nativeMin = Math.min,
        nativeParseInt = context.parseInt,
        nativeRandom = Math.random;

    /** Used to lookup a built-in constructor by [[Class]] */
    var ctorByClass = {};
    ctorByClass[arrayClass] = Array;
    ctorByClass[boolClass] = Boolean;
    ctorByClass[dateClass] = Date;
    ctorByClass[funcClass] = Function;
    ctorByClass[objectClass] = Object;
    ctorByClass[numberClass] = Number;
    ctorByClass[regexpClass] = RegExp;
    ctorByClass[stringClass] = String;

    /*--------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object which wraps the given value to enable intuitive
     * method chaining.
     *
     * In addition to Lo-Dash methods, wrappers also have the following `Array` methods:
     * `concat`, `join`, `pop`, `push`, `reverse`, `shift`, `slice`, `sort`, `splice`,
     * and `unshift`
     *
     * Chaining is supported in custom builds as long as the `value` method is
     * implicitly or explicitly included in the build.
     *
     * The chainable wrapper functions are:
     * `after`, `assign`, `bind`, `bindAll`, `bindKey`, `chain`, `compact`,
     * `compose`, `concat`, `countBy`, `create`, `createCallback`, `curry`,
     * `debounce`, `defaults`, `defer`, `delay`, `difference`, `filter`, `flatten`,
     * `forEach`, `forEachRight`, `forIn`, `forInRight`, `forOwn`, `forOwnRight`,
     * `functions`, `groupBy`, `indexBy`, `initial`, `intersection`, `invert`,
     * `invoke`, `keys`, `map`, `max`, `memoize`, `merge`, `min`, `object`, `omit`,
     * `once`, `pairs`, `partial`, `partialRight`, `pick`, `pluck`, `pull`, `push`,
     * `range`, `reject`, `remove`, `rest`, `reverse`, `shuffle`, `slice`, `sort`,
     * `sortBy`, `splice`, `tap`, `throttle`, `times`, `toArray`, `transform`,
     * `union`, `uniq`, `unshift`, `unzip`, `values`, `where`, `without`, `wrap`,
     * and `zip`
     *
     * The non-chainable wrapper functions are:
     * `clone`, `cloneDeep`, `contains`, `escape`, `every`, `find`, `findIndex`,
     * `findKey`, `findLast`, `findLastIndex`, `findLastKey`, `has`, `identity`,
     * `indexOf`, `isArguments`, `isArray`, `isBoolean`, `isDate`, `isElement`,
     * `isEmpty`, `isEqual`, `isFinite`, `isFunction`, `isNaN`, `isNull`, `isNumber`,
     * `isObject`, `isPlainObject`, `isRegExp`, `isString`, `isUndefined`, `join`,
     * `lastIndexOf`, `mixin`, `noConflict`, `parseInt`, `pop`, `random`, `reduce`,
     * `reduceRight`, `result`, `shift`, `size`, `some`, `sortedIndex`, `runInContext`,
     * `template`, `unescape`, `uniqueId`, and `value`
     *
     * The wrapper functions `first` and `last` return wrapped values when `n` is
     * provided, otherwise they return unwrapped values.
     *
     * Explicit chaining can be enabled by using the `_.chain` method.
     *
     * @name _
     * @constructor
     * @category Chaining
     * @param {*} value The value to wrap in a `lodash` instance.
     * @returns {Object} Returns a `lodash` instance.
     * @example
     *
     * var wrapped = _([1, 2, 3]);
     *
     * // returns an unwrapped value
     * wrapped.reduce(function(sum, num) {
     *   return sum + num;
     * });
     * // => 6
     *
     * // returns a wrapped value
     * var squares = wrapped.map(function(num) {
     *   return num * num;
     * });
     *
     * _.isArray(squares);
     * // => false
     *
     * _.isArray(squares.value());
     * // => true
     */
    function lodash(value) {
      // don't wrap if already wrapped, even if wrapped by a different `lodash` constructor
      return (value && typeof value == 'object' && !isArray(value) && hasOwnProperty.call(value, '__wrapped__'))
       ? value
       : new lodashWrapper(value);
    }

    /**
     * A fast path for creating `lodash` wrapper objects.
     *
     * @private
     * @param {*} value The value to wrap in a `lodash` instance.
     * @param {boolean} chainAll A flag to enable chaining for all methods
     * @returns {Object} Returns a `lodash` instance.
     */
    function lodashWrapper(value, chainAll) {
      this.__chain__ = !!chainAll;
      this.__wrapped__ = value;
    }
    // ensure `new lodashWrapper` is an instance of `lodash`
    lodashWrapper.prototype = lodash.prototype;

    /**
     * An object used to flag environments features.
     *
     * @static
     * @memberOf _
     * @type Object
     */
    var support = lodash.support = {};

    /**
     * Detect if functions can be decompiled by `Function#toString`
     * (all but PS3 and older Opera mobile browsers & avoided in Windows 8 apps).
     *
     * @memberOf _.support
     * @type boolean
     */
    support.funcDecomp = !isNative(context.WinRTError) && reThis.test(runInContext);

    /**
     * Detect if `Function#name` is supported (all but IE).
     *
     * @memberOf _.support
     * @type boolean
     */
    support.funcNames = typeof Function.name == 'string';

    /**
     * By default, the template delimiters used by Lo-Dash are similar to those in
     * embedded Ruby (ERB). Change the following template settings to use alternative
     * delimiters.
     *
     * @static
     * @memberOf _
     * @type Object
     */
    lodash.templateSettings = {

      /**
       * Used to detect `data` property values to be HTML-escaped.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'escape': /<%-([\s\S]+?)%>/g,

      /**
       * Used to detect code to be evaluated.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'evaluate': /<%([\s\S]+?)%>/g,

      /**
       * Used to detect `data` property values to inject.
       *
       * @memberOf _.templateSettings
       * @type RegExp
       */
      'interpolate': reInterpolate,

      /**
       * Used to reference the data object in the template text.
       *
       * @memberOf _.templateSettings
       * @type string
       */
      'variable': '',

      /**
       * Used to import variables into the compiled template.
       *
       * @memberOf _.templateSettings
       * @type Object
       */
      'imports': {

        /**
         * A reference to the `lodash` function.
         *
         * @memberOf _.templateSettings.imports
         * @type Function
         */
        '_': lodash
      }
    };

    /*--------------------------------------------------------------------------*/

    /**
     * The base implementation of `_.bind` that creates the bound function and
     * sets its meta data.
     *
     * @private
     * @param {Array} bindData The bind data array.
     * @returns {Function} Returns the new bound function.
     */
    function baseBind(bindData) {
      var func = bindData[0],
          partialArgs = bindData[2],
          thisArg = bindData[4];

      function bound() {
        // `Function#bind` spec
        // http://es5.github.io/#x15.3.4.5
        if (partialArgs) {
          // avoid `arguments` object deoptimizations by using `slice` instead
          // of `Array.prototype.slice.call` and not assigning `arguments` to a
          // variable as a ternary expression
          var args = slice(partialArgs);
          push.apply(args, arguments);
        }
        // mimic the constructor's `return` behavior
        // http://es5.github.io/#x13.2.2
        if (this instanceof bound) {
          // ensure `new bound` is an instance of `func`
          var thisBinding = baseCreate(func.prototype),
              result = func.apply(thisBinding, args || arguments);
          return isObject(result) ? result : thisBinding;
        }
        return func.apply(thisArg, args || arguments);
      }
      setBindData(bound, bindData);
      return bound;
    }

    /**
     * The base implementation of `_.clone` without argument juggling or support
     * for `thisArg` binding.
     *
     * @private
     * @param {*} value The value to clone.
     * @param {boolean} [isDeep=false] Specify a deep clone.
     * @param {Function} [callback] The function to customize cloning values.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates clones with source counterparts.
     * @returns {*} Returns the cloned value.
     */
    function baseClone(value, isDeep, callback, stackA, stackB) {
      if (callback) {
        var result = callback(value);
        if (typeof result != 'undefined') {
          return result;
        }
      }
      // inspect [[Class]]
      var isObj = isObject(value);
      if (isObj) {
        var className = toString.call(value);
        if (!cloneableClasses[className]) {
          return value;
        }
        var ctor = ctorByClass[className];
        switch (className) {
          case boolClass:
          case dateClass:
            return new ctor(+value);

          case numberClass:
          case stringClass:
            return new ctor(value);

          case regexpClass:
            result = ctor(value.source, reFlags.exec(value));
            result.lastIndex = value.lastIndex;
            return result;
        }
      } else {
        return value;
      }
      var isArr = isArray(value);
      if (isDeep) {
        // check for circular references and return corresponding clone
        var initedStack = !stackA;
        stackA || (stackA = getArray());
        stackB || (stackB = getArray());

        var length = stackA.length;
        while (length--) {
          if (stackA[length] == value) {
            return stackB[length];
          }
        }
        result = isArr ? ctor(value.length) : {};
      }
      else {
        result = isArr ? slice(value) : assign({}, value);
      }
      // add array properties assigned by `RegExp#exec`
      if (isArr) {
        if (hasOwnProperty.call(value, 'index')) {
          result.index = value.index;
        }
        if (hasOwnProperty.call(value, 'input')) {
          result.input = value.input;
        }
      }
      // exit for shallow clone
      if (!isDeep) {
        return result;
      }
      // add the source value to the stack of traversed objects
      // and associate it with its clone
      stackA.push(value);
      stackB.push(result);

      // recursively populate clone (susceptible to call stack limits)
      (isArr ? forEach : forOwn)(value, function(objValue, key) {
        result[key] = baseClone(objValue, isDeep, callback, stackA, stackB);
      });

      if (initedStack) {
        releaseArray(stackA);
        releaseArray(stackB);
      }
      return result;
    }

    /**
     * The base implementation of `_.create` without support for assigning
     * properties to the created object.
     *
     * @private
     * @param {Object} prototype The object to inherit from.
     * @returns {Object} Returns the new object.
     */
    function baseCreate(prototype, properties) {
      return isObject(prototype) ? nativeCreate(prototype) : {};
    }
    // fallback for browsers without `Object.create`
    if (!nativeCreate) {
      baseCreate = (function() {
        function Object() {}
        return function(prototype) {
          if (isObject(prototype)) {
            Object.prototype = prototype;
            var result = new Object;
            Object.prototype = null;
          }
          return result || context.Object();
        };
      }());
    }

    /**
     * The base implementation of `_.createCallback` without support for creating
     * "_.pluck" or "_.where" style callbacks.
     *
     * @private
     * @param {*} [func=identity] The value to convert to a callback.
     * @param {*} [thisArg] The `this` binding of the created callback.
     * @param {number} [argCount] The number of arguments the callback accepts.
     * @returns {Function} Returns a callback function.
     */
    function baseCreateCallback(func, thisArg, argCount) {
      if (typeof func != 'function') {
        return identity;
      }
      // exit early for no `thisArg` or already bound by `Function#bind`
      if (typeof thisArg == 'undefined' || !('prototype' in func)) {
        return func;
      }
      var bindData = func.__bindData__;
      if (typeof bindData == 'undefined') {
        if (support.funcNames) {
          bindData = !func.name;
        }
        bindData = bindData || !support.funcDecomp;
        if (!bindData) {
          var source = fnToString.call(func);
          if (!support.funcNames) {
            bindData = !reFuncName.test(source);
          }
          if (!bindData) {
            // checks if `func` references the `this` keyword and stores the result
            bindData = reThis.test(source);
            setBindData(func, bindData);
          }
        }
      }
      // exit early if there are no `this` references or `func` is bound
      if (bindData === false || (bindData !== true && bindData[1] & 1)) {
        return func;
      }
      switch (argCount) {
        case 1: return function(value) {
          return func.call(thisArg, value);
        };
        case 2: return function(a, b) {
          return func.call(thisArg, a, b);
        };
        case 3: return function(value, index, collection) {
          return func.call(thisArg, value, index, collection);
        };
        case 4: return function(accumulator, value, index, collection) {
          return func.call(thisArg, accumulator, value, index, collection);
        };
      }
      return bind(func, thisArg);
    }

    /**
     * The base implementation of `createWrapper` that creates the wrapper and
     * sets its meta data.
     *
     * @private
     * @param {Array} bindData The bind data array.
     * @returns {Function} Returns the new function.
     */
    function baseCreateWrapper(bindData) {
      var func = bindData[0],
          bitmask = bindData[1],
          partialArgs = bindData[2],
          partialRightArgs = bindData[3],
          thisArg = bindData[4],
          arity = bindData[5];

      var isBind = bitmask & 1,
          isBindKey = bitmask & 2,
          isCurry = bitmask & 4,
          isCurryBound = bitmask & 8,
          key = func;

      function bound() {
        var thisBinding = isBind ? thisArg : this;
        if (partialArgs) {
          var args = slice(partialArgs);
          push.apply(args, arguments);
        }
        if (partialRightArgs || isCurry) {
          args || (args = slice(arguments));
          if (partialRightArgs) {
            push.apply(args, partialRightArgs);
          }
          if (isCurry && args.length < arity) {
            bitmask |= 16 & ~32;
            return baseCreateWrapper([func, (isCurryBound ? bitmask : bitmask & ~3), args, null, thisArg, arity]);
          }
        }
        args || (args = arguments);
        if (isBindKey) {
          func = thisBinding[key];
        }
        if (this instanceof bound) {
          thisBinding = baseCreate(func.prototype);
          var result = func.apply(thisBinding, args);
          return isObject(result) ? result : thisBinding;
        }
        return func.apply(thisBinding, args);
      }
      setBindData(bound, bindData);
      return bound;
    }

    /**
     * The base implementation of `_.difference` that accepts a single array
     * of values to exclude.
     *
     * @private
     * @param {Array} array The array to process.
     * @param {Array} [values] The array of values to exclude.
     * @returns {Array} Returns a new array of filtered values.
     */
    function baseDifference(array, values) {
      var index = -1,
          indexOf = getIndexOf(),
          length = array ? array.length : 0,
          isLarge = length >= largeArraySize && indexOf === baseIndexOf,
          result = [];

      if (isLarge) {
        var cache = createCache(values);
        if (cache) {
          indexOf = cacheIndexOf;
          values = cache;
        } else {
          isLarge = false;
        }
      }
      while (++index < length) {
        var value = array[index];
        if (indexOf(values, value) < 0) {
          result.push(value);
        }
      }
      if (isLarge) {
        releaseObject(values);
      }
      return result;
    }

    /**
     * The base implementation of `_.flatten` without support for callback
     * shorthands or `thisArg` binding.
     *
     * @private
     * @param {Array} array The array to flatten.
     * @param {boolean} [isShallow=false] A flag to restrict flattening to a single level.
     * @param {boolean} [isStrict=false] A flag to restrict flattening to arrays and `arguments` objects.
     * @param {number} [fromIndex=0] The index to start from.
     * @returns {Array} Returns a new flattened array.
     */
    function baseFlatten(array, isShallow, isStrict, fromIndex) {
      var index = (fromIndex || 0) - 1,
          length = array ? array.length : 0,
          result = [];

      while (++index < length) {
        var value = array[index];

        if (value && typeof value == 'object' && typeof value.length == 'number'
            && (isArray(value) || isArguments(value))) {
          // recursively flatten arrays (susceptible to call stack limits)
          if (!isShallow) {
            value = baseFlatten(value, isShallow, isStrict);
          }
          var valIndex = -1,
              valLength = value.length,
              resIndex = result.length;

          result.length += valLength;
          while (++valIndex < valLength) {
            result[resIndex++] = value[valIndex];
          }
        } else if (!isStrict) {
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.isEqual`, without support for `thisArg` binding,
     * that allows partial "_.where" style comparisons.
     *
     * @private
     * @param {*} a The value to compare.
     * @param {*} b The other value to compare.
     * @param {Function} [callback] The function to customize comparing values.
     * @param {Function} [isWhere=false] A flag to indicate performing partial comparisons.
     * @param {Array} [stackA=[]] Tracks traversed `a` objects.
     * @param {Array} [stackB=[]] Tracks traversed `b` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */
    function baseIsEqual(a, b, callback, isWhere, stackA, stackB) {
      // used to indicate that when comparing objects, `a` has at least the properties of `b`
      if (callback) {
        var result = callback(a, b);
        if (typeof result != 'undefined') {
          return !!result;
        }
      }
      // exit early for identical values
      if (a === b) {
        // treat `+0` vs. `-0` as not equal
        return a !== 0 || (1 / a == 1 / b);
      }
      var type = typeof a,
          otherType = typeof b;

      // exit early for unlike primitive values
      if (a === a &&
          !(a && objectTypes[type]) &&
          !(b && objectTypes[otherType])) {
        return false;
      }
      // exit early for `null` and `undefined` avoiding ES3's Function#call behavior
      // http://es5.github.io/#x15.3.4.4
      if (a == null || b == null) {
        return a === b;
      }
      // compare [[Class]] names
      var className = toString.call(a),
          otherClass = toString.call(b);

      if (className == argsClass) {
        className = objectClass;
      }
      if (otherClass == argsClass) {
        otherClass = objectClass;
      }
      if (className != otherClass) {
        return false;
      }
      switch (className) {
        case boolClass:
        case dateClass:
          // coerce dates and booleans to numbers, dates to milliseconds and booleans
          // to `1` or `0` treating invalid dates coerced to `NaN` as not equal
          return +a == +b;

        case numberClass:
          // treat `NaN` vs. `NaN` as equal
          return (a != +a)
            ? b != +b
            // but treat `+0` vs. `-0` as not equal
            : (a == 0 ? (1 / a == 1 / b) : a == +b);

        case regexpClass:
        case stringClass:
          // coerce regexes to strings (http://es5.github.io/#x15.10.6.4)
          // treat string primitives and their corresponding object instances as equal
          return a == String(b);
      }
      var isArr = className == arrayClass;
      if (!isArr) {
        // unwrap any `lodash` wrapped values
        var aWrapped = hasOwnProperty.call(a, '__wrapped__'),
            bWrapped = hasOwnProperty.call(b, '__wrapped__');

        if (aWrapped || bWrapped) {
          return baseIsEqual(aWrapped ? a.__wrapped__ : a, bWrapped ? b.__wrapped__ : b, callback, isWhere, stackA, stackB);
        }
        // exit for functions and DOM nodes
        if (className != objectClass) {
          return false;
        }
        // in older versions of Opera, `arguments` objects have `Array` constructors
        var ctorA = a.constructor,
            ctorB = b.constructor;

        // non `Object` object instances with different constructors are not equal
        if (ctorA != ctorB &&
              !(isFunction(ctorA) && ctorA instanceof ctorA && isFunction(ctorB) && ctorB instanceof ctorB) &&
              ('constructor' in a && 'constructor' in b)
            ) {
          return false;
        }
      }
      // assume cyclic structures are equal
      // the algorithm for detecting cyclic structures is adapted from ES 5.1
      // section 15.12.3, abstract operation `JO` (http://es5.github.io/#x15.12.3)
      var initedStack = !stackA;
      stackA || (stackA = getArray());
      stackB || (stackB = getArray());

      var length = stackA.length;
      while (length--) {
        if (stackA[length] == a) {
          return stackB[length] == b;
        }
      }
      var size = 0;
      result = true;

      // add `a` and `b` to the stack of traversed objects
      stackA.push(a);
      stackB.push(b);

      // recursively compare objects and arrays (susceptible to call stack limits)
      if (isArr) {
        // compare lengths to determine if a deep comparison is necessary
        length = a.length;
        size = b.length;
        result = size == length;

        if (result || isWhere) {
          // deep compare the contents, ignoring non-numeric properties
          while (size--) {
            var index = length,
                value = b[size];

            if (isWhere) {
              while (index--) {
                if ((result = baseIsEqual(a[index], value, callback, isWhere, stackA, stackB))) {
                  break;
                }
              }
            } else if (!(result = baseIsEqual(a[size], value, callback, isWhere, stackA, stackB))) {
              break;
            }
          }
        }
      }
      else {
        // deep compare objects using `forIn`, instead of `forOwn`, to avoid `Object.keys`
        // which, in this case, is more costly
        forIn(b, function(value, key, b) {
          if (hasOwnProperty.call(b, key)) {
            // count the number of properties.
            size++;
            // deep compare each property value.
            return (result = hasOwnProperty.call(a, key) && baseIsEqual(a[key], value, callback, isWhere, stackA, stackB));
          }
        });

        if (result && !isWhere) {
          // ensure both objects have the same number of properties
          forIn(a, function(value, key, a) {
            if (hasOwnProperty.call(a, key)) {
              // `size` will be `-1` if `a` has more properties than `b`
              return (result = --size > -1);
            }
          });
        }
      }
      stackA.pop();
      stackB.pop();

      if (initedStack) {
        releaseArray(stackA);
        releaseArray(stackB);
      }
      return result;
    }

    /**
     * The base implementation of `_.merge` without argument juggling or support
     * for `thisArg` binding.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {Function} [callback] The function to customize merging properties.
     * @param {Array} [stackA=[]] Tracks traversed source objects.
     * @param {Array} [stackB=[]] Associates values with source counterparts.
     */
    function baseMerge(object, source, callback, stackA, stackB) {
      (isArray(source) ? forEach : forOwn)(source, function(source, key) {
        var found,
            isArr,
            result = source,
            value = object[key];

        if (source && ((isArr = isArray(source)) || isPlainObject(source))) {
          // avoid merging previously merged cyclic sources
          var stackLength = stackA.length;
          while (stackLength--) {
            if ((found = stackA[stackLength] == source)) {
              value = stackB[stackLength];
              break;
            }
          }
          if (!found) {
            var isShallow;
            if (callback) {
              result = callback(value, source);
              if ((isShallow = typeof result != 'undefined')) {
                value = result;
              }
            }
            if (!isShallow) {
              value = isArr
                ? (isArray(value) ? value : [])
                : (isPlainObject(value) ? value : {});
            }
            // add `source` and associated `value` to the stack of traversed objects
            stackA.push(source);
            stackB.push(value);

            // recursively merge objects and arrays (susceptible to call stack limits)
            if (!isShallow) {
              baseMerge(value, source, callback, stackA, stackB);
            }
          }
        }
        else {
          if (callback) {
            result = callback(value, source);
            if (typeof result == 'undefined') {
              result = source;
            }
          }
          if (typeof result != 'undefined') {
            value = result;
          }
        }
        object[key] = value;
      });
    }

    /**
     * The base implementation of `_.random` without argument juggling or support
     * for returning floating-point numbers.
     *
     * @private
     * @param {number} min The minimum possible value.
     * @param {number} max The maximum possible value.
     * @returns {number} Returns a random number.
     */
    function baseRandom(min, max) {
      return min + floor(nativeRandom() * (max - min + 1));
    }

    /**
     * The base implementation of `_.uniq` without support for callback shorthands
     * or `thisArg` binding.
     *
     * @private
     * @param {Array} array The array to process.
     * @param {boolean} [isSorted=false] A flag to indicate that `array` is sorted.
     * @param {Function} [callback] The function called per iteration.
     * @returns {Array} Returns a duplicate-value-free array.
     */
    function baseUniq(array, isSorted, callback) {
      var index = -1,
          indexOf = getIndexOf(),
          length = array ? array.length : 0,
          result = [];

      var isLarge = !isSorted && length >= largeArraySize && indexOf === baseIndexOf,
          seen = (callback || isLarge) ? getArray() : result;

      if (isLarge) {
        var cache = createCache(seen);
        indexOf = cacheIndexOf;
        seen = cache;
      }
      while (++index < length) {
        var value = array[index],
            computed = callback ? callback(value, index, array) : value;

        if (isSorted
              ? !index || seen[seen.length - 1] !== computed
              : indexOf(seen, computed) < 0
            ) {
          if (callback || isLarge) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
      if (isLarge) {
        releaseArray(seen.array);
        releaseObject(seen);
      } else if (callback) {
        releaseArray(seen);
      }
      return result;
    }

    /**
     * Creates a function that aggregates a collection, creating an object composed
     * of keys generated from the results of running each element of the collection
     * through a callback. The given `setter` function sets the keys and values
     * of the composed object.
     *
     * @private
     * @param {Function} setter The setter function.
     * @returns {Function} Returns the new aggregator function.
     */
    function createAggregator(setter) {
      return function(collection, callback, thisArg) {
        var result = {};
        callback = lodash.createCallback(callback, thisArg, 3);

        var index = -1,
            length = collection ? collection.length : 0;

        if (typeof length == 'number') {
          while (++index < length) {
            var value = collection[index];
            setter(result, value, callback(value, index, collection), collection);
          }
        } else {
          forOwn(collection, function(value, key, collection) {
            setter(result, value, callback(value, key, collection), collection);
          });
        }
        return result;
      };
    }

    /**
     * Creates a function that, when called, either curries or invokes `func`
     * with an optional `this` binding and partially applied arguments.
     *
     * @private
     * @param {Function|string} func The function or method name to reference.
     * @param {number} bitmask The bitmask of method flags to compose.
     *  The bitmask may be composed of the following flags:
     *  1 - `_.bind`
     *  2 - `_.bindKey`
     *  4 - `_.curry`
     *  8 - `_.curry` (bound)
     *  16 - `_.partial`
     *  32 - `_.partialRight`
     * @param {Array} [partialArgs] An array of arguments to prepend to those
     *  provided to the new function.
     * @param {Array} [partialRightArgs] An array of arguments to append to those
     *  provided to the new function.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new function.
     */
    function createWrapper(func, bitmask, partialArgs, partialRightArgs, thisArg, arity) {
      var isBind = bitmask & 1,
          isBindKey = bitmask & 2,
          isCurry = bitmask & 4,
          isCurryBound = bitmask & 8,
          isPartial = bitmask & 16,
          isPartialRight = bitmask & 32;

      if (!isBindKey && !isFunction(func)) {
        throw new TypeError;
      }
      if (isPartial && !partialArgs.length) {
        bitmask &= ~16;
        isPartial = partialArgs = false;
      }
      if (isPartialRight && !partialRightArgs.length) {
        bitmask &= ~32;
        isPartialRight = partialRightArgs = false;
      }
      var bindData = func && func.__bindData__;
      if (bindData && bindData !== true) {
        // clone `bindData`
        bindData = slice(bindData);
        if (bindData[2]) {
          bindData[2] = slice(bindData[2]);
        }
        if (bindData[3]) {
          bindData[3] = slice(bindData[3]);
        }
        // set `thisBinding` is not previously bound
        if (isBind && !(bindData[1] & 1)) {
          bindData[4] = thisArg;
        }
        // set if previously bound but not currently (subsequent curried functions)
        if (!isBind && bindData[1] & 1) {
          bitmask |= 8;
        }
        // set curried arity if not yet set
        if (isCurry && !(bindData[1] & 4)) {
          bindData[5] = arity;
        }
        // append partial left arguments
        if (isPartial) {
          push.apply(bindData[2] || (bindData[2] = []), partialArgs);
        }
        // append partial right arguments
        if (isPartialRight) {
          unshift.apply(bindData[3] || (bindData[3] = []), partialRightArgs);
        }
        // merge flags
        bindData[1] |= bitmask;
        return createWrapper.apply(null, bindData);
      }
      // fast path for `_.bind`
      var creater = (bitmask == 1 || bitmask === 17) ? baseBind : baseCreateWrapper;
      return creater([func, bitmask, partialArgs, partialRightArgs, thisArg, arity]);
    }

    /**
     * Used by `escape` to convert characters to HTML entities.
     *
     * @private
     * @param {string} match The matched character to escape.
     * @returns {string} Returns the escaped character.
     */
    function escapeHtmlChar(match) {
      return htmlEscapes[match];
    }

    /**
     * Gets the appropriate "indexOf" function. If the `_.indexOf` method is
     * customized, this method returns the custom method, otherwise it returns
     * the `baseIndexOf` function.
     *
     * @private
     * @returns {Function} Returns the "indexOf" function.
     */
    function getIndexOf() {
      var result = (result = lodash.indexOf) === indexOf ? baseIndexOf : result;
      return result;
    }

    /**
     * Checks if `value` is a native function.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a native function, else `false`.
     */
    function isNative(value) {
      return typeof value == 'function' && reNative.test(value);
    }

    /**
     * Sets `this` binding data on a given function.
     *
     * @private
     * @param {Function} func The function to set data on.
     * @param {Array} value The data array to set.
     */
    var setBindData = !defineProperty ? noop : function(func, value) {
      descriptor.value = value;
      defineProperty(func, '__bindData__', descriptor);
    };

    /**
     * A fallback implementation of `isPlainObject` which checks if a given value
     * is an object created by the `Object` constructor, assuming objects created
     * by the `Object` constructor have no inherited enumerable properties and that
     * there are no `Object.prototype` extensions.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
     */
    function shimIsPlainObject(value) {
      var ctor,
          result;

      // avoid non Object objects, `arguments` objects, and DOM elements
      if (!(value && toString.call(value) == objectClass) ||
          (ctor = value.constructor, isFunction(ctor) && !(ctor instanceof ctor))) {
        return false;
      }
      // In most environments an object's own properties are iterated before
      // its inherited properties. If the last iterated property is an object's
      // own property then there are no inherited enumerable properties.
      forIn(value, function(value, key) {
        result = key;
      });
      return typeof result == 'undefined' || hasOwnProperty.call(value, result);
    }

    /**
     * Used by `unescape` to convert HTML entities to characters.
     *
     * @private
     * @param {string} match The matched character to unescape.
     * @returns {string} Returns the unescaped character.
     */
    function unescapeHtmlChar(match) {
      return htmlUnescapes[match];
    }

    /*--------------------------------------------------------------------------*/

    /**
     * Checks if `value` is an `arguments` object.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is an `arguments` object, else `false`.
     * @example
     *
     * (function() { return _.isArguments(arguments); })(1, 2, 3);
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */
    function isArguments(value) {
      return value && typeof value == 'object' && typeof value.length == 'number' &&
        toString.call(value) == argsClass || false;
    }

    /**
     * Checks if `value` is an array.
     *
     * @static
     * @memberOf _
     * @type Function
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is an array, else `false`.
     * @example
     *
     * (function() { return _.isArray(arguments); })();
     * // => false
     *
     * _.isArray([1, 2, 3]);
     * // => true
     */
    var isArray = nativeIsArray || function(value) {
      return value && typeof value == 'object' && typeof value.length == 'number' &&
        toString.call(value) == arrayClass || false;
    };

    /**
     * A fallback implementation of `Object.keys` which produces an array of the
     * given object's own enumerable property names.
     *
     * @private
     * @type Function
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns an array of property names.
     */
    var shimKeys = function(object) {
      var index, iterable = object, result = [];
      if (!iterable) return result;
      if (!(objectTypes[typeof object])) return result;
        for (index in iterable) {
          if (hasOwnProperty.call(iterable, index)) {
            result.push(index);
          }
        }
      return result
    };

    /**
     * Creates an array composed of the own enumerable property names of an object.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns an array of property names.
     * @example
     *
     * _.keys({ 'one': 1, 'two': 2, 'three': 3 });
     * // => ['one', 'two', 'three'] (property order is not guaranteed across environments)
     */
    var keys = !nativeKeys ? shimKeys : function(object) {
      if (!isObject(object)) {
        return [];
      }
      return nativeKeys(object);
    };

    /**
     * Used to convert characters to HTML entities:
     *
     * Though the `>` character is escaped for symmetry, characters like `>` and `/`
     * don't require escaping in HTML and have no special meaning unless they're part
     * of a tag or an unquoted attribute value.
     * http://mathiasbynens.be/notes/ambiguous-ampersands (under "semi-related fun fact")
     */
    var htmlEscapes = {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#39;'
    };

    /** Used to convert HTML entities to characters */
    var htmlUnescapes = invert(htmlEscapes);

    /** Used to match HTML entities and HTML characters */
    var reEscapedHtml = RegExp('(' + keys(htmlUnescapes).join('|') + ')', 'g'),
        reUnescapedHtml = RegExp('[' + keys(htmlEscapes).join('') + ']', 'g');

    /*--------------------------------------------------------------------------*/

    /**
     * Assigns own enumerable properties of source object(s) to the destination
     * object. Subsequent sources will overwrite property assignments of previous
     * sources. If a callback is provided it will be executed to produce the
     * assigned values. The callback is bound to `thisArg` and invoked with two
     * arguments; (objectValue, sourceValue).
     *
     * @static
     * @memberOf _
     * @type Function
     * @alias extend
     * @category Objects
     * @param {Object} object The destination object.
     * @param {...Object} [source] The source objects.
     * @param {Function} [callback] The function to customize assigning values.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns the destination object.
     * @example
     *
     * _.assign({ 'name': 'fred' }, { 'employer': 'slate' });
     * // => { 'name': 'fred', 'employer': 'slate' }
     *
     * var defaults = _.partialRight(_.assign, function(a, b) {
     *   return typeof a == 'undefined' ? b : a;
     * });
     *
     * var object = { 'name': 'barney' };
     * defaults(object, { 'name': 'fred', 'employer': 'slate' });
     * // => { 'name': 'barney', 'employer': 'slate' }
     */
    var assign = function(object, source, guard) {
      var index, iterable = object, result = iterable;
      if (!iterable) return result;
      var args = arguments,
          argsIndex = 0,
          argsLength = typeof guard == 'number' ? 2 : args.length;
      if (argsLength > 3 && typeof args[argsLength - 2] == 'function') {
        var callback = baseCreateCallback(args[--argsLength - 1], args[argsLength--], 2);
      } else if (argsLength > 2 && typeof args[argsLength - 1] == 'function') {
        callback = args[--argsLength];
      }
      while (++argsIndex < argsLength) {
        iterable = args[argsIndex];
        if (iterable && objectTypes[typeof iterable]) {
        var ownIndex = -1,
            ownProps = objectTypes[typeof iterable] && keys(iterable),
            length = ownProps ? ownProps.length : 0;

        while (++ownIndex < length) {
          index = ownProps[ownIndex];
          result[index] = callback ? callback(result[index], iterable[index]) : iterable[index];
        }
        }
      }
      return result
    };

    /**
     * Creates a clone of `value`. If `isDeep` is `true` nested objects will also
     * be cloned, otherwise they will be assigned by reference. If a callback
     * is provided it will be executed to produce the cloned values. If the
     * callback returns `undefined` cloning will be handled by the method instead.
     * The callback is bound to `thisArg` and invoked with one argument; (value).
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to clone.
     * @param {boolean} [isDeep=false] Specify a deep clone.
     * @param {Function} [callback] The function to customize cloning values.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the cloned value.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * var shallow = _.clone(characters);
     * shallow[0] === characters[0];
     * // => true
     *
     * var deep = _.clone(characters, true);
     * deep[0] === characters[0];
     * // => false
     *
     * _.mixin({
     *   'clone': _.partialRight(_.clone, function(value) {
     *     return _.isElement(value) ? value.cloneNode(false) : undefined;
     *   })
     * });
     *
     * var clone = _.clone(document.body);
     * clone.childNodes.length;
     * // => 0
     */
    function clone(value, isDeep, callback, thisArg) {
      // allows working with "Collections" methods without using their `index`
      // and `collection` arguments for `isDeep` and `callback`
      if (typeof isDeep != 'boolean' && isDeep != null) {
        thisArg = callback;
        callback = isDeep;
        isDeep = false;
      }
      return baseClone(value, isDeep, typeof callback == 'function' && baseCreateCallback(callback, thisArg, 1));
    }

    /**
     * Creates a deep clone of `value`. If a callback is provided it will be
     * executed to produce the cloned values. If the callback returns `undefined`
     * cloning will be handled by the method instead. The callback is bound to
     * `thisArg` and invoked with one argument; (value).
     *
     * Note: This method is loosely based on the structured clone algorithm. Functions
     * and DOM nodes are **not** cloned. The enumerable properties of `arguments` objects and
     * objects created by constructors other than `Object` are cloned to plain `Object` objects.
     * See http://www.w3.org/TR/html5/infrastructure.html#internal-structured-cloning-algorithm.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to deep clone.
     * @param {Function} [callback] The function to customize cloning values.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the deep cloned value.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * var deep = _.cloneDeep(characters);
     * deep[0] === characters[0];
     * // => false
     *
     * var view = {
     *   'label': 'docs',
     *   'node': element
     * };
     *
     * var clone = _.cloneDeep(view, function(value) {
     *   return _.isElement(value) ? value.cloneNode(true) : undefined;
     * });
     *
     * clone.node == view.node;
     * // => false
     */
    function cloneDeep(value, callback, thisArg) {
      return baseClone(value, true, typeof callback == 'function' && baseCreateCallback(callback, thisArg, 1));
    }

    /**
     * Creates an object that inherits from the given `prototype` object. If a
     * `properties` object is provided its own enumerable properties are assigned
     * to the created object.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} prototype The object to inherit from.
     * @param {Object} [properties] The properties to assign to the object.
     * @returns {Object} Returns the new object.
     * @example
     *
     * function Shape() {
     *   this.x = 0;
     *   this.y = 0;
     * }
     *
     * function Circle() {
     *   Shape.call(this);
     * }
     *
     * Circle.prototype = _.create(Shape.prototype, { 'constructor': Circle });
     *
     * var circle = new Circle;
     * circle instanceof Circle;
     * // => true
     *
     * circle instanceof Shape;
     * // => true
     */
    function create(prototype, properties) {
      var result = baseCreate(prototype);
      return properties ? assign(result, properties) : result;
    }

    /**
     * Assigns own enumerable properties of source object(s) to the destination
     * object for all destination properties that resolve to `undefined`. Once a
     * property is set, additional defaults of the same property will be ignored.
     *
     * @static
     * @memberOf _
     * @type Function
     * @category Objects
     * @param {Object} object The destination object.
     * @param {...Object} [source] The source objects.
     * @param- {Object} [guard] Allows working with `_.reduce` without using its
     *  `key` and `object` arguments as sources.
     * @returns {Object} Returns the destination object.
     * @example
     *
     * var object = { 'name': 'barney' };
     * _.defaults(object, { 'name': 'fred', 'employer': 'slate' });
     * // => { 'name': 'barney', 'employer': 'slate' }
     */
    var defaults = function(object, source, guard) {
      var index, iterable = object, result = iterable;
      if (!iterable) return result;
      var args = arguments,
          argsIndex = 0,
          argsLength = typeof guard == 'number' ? 2 : args.length;
      while (++argsIndex < argsLength) {
        iterable = args[argsIndex];
        if (iterable && objectTypes[typeof iterable]) {
        var ownIndex = -1,
            ownProps = objectTypes[typeof iterable] && keys(iterable),
            length = ownProps ? ownProps.length : 0;

        while (++ownIndex < length) {
          index = ownProps[ownIndex];
          if (typeof result[index] == 'undefined') result[index] = iterable[index];
        }
        }
      }
      return result
    };

    /**
     * This method is like `_.findIndex` except that it returns the key of the
     * first element that passes the callback check, instead of the element itself.
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to search.
     * @param {Function|Object|string} [callback=identity] The function called per
     *  iteration. If a property name or object is provided it will be used to
     *  create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {string|undefined} Returns the key of the found element, else `undefined`.
     * @example
     *
     * var characters = {
     *   'barney': {  'age': 36, 'blocked': false },
     *   'fred': {    'age': 40, 'blocked': true },
     *   'pebbles': { 'age': 1,  'blocked': false }
     * };
     *
     * _.findKey(characters, function(chr) {
     *   return chr.age < 40;
     * });
     * // => 'barney' (property order is not guaranteed across environments)
     *
     * // using "_.where" callback shorthand
     * _.findKey(characters, { 'age': 1 });
     * // => 'pebbles'
     *
     * // using "_.pluck" callback shorthand
     * _.findKey(characters, 'blocked');
     * // => 'fred'
     */
    function findKey(object, callback, thisArg) {
      var result;
      callback = lodash.createCallback(callback, thisArg, 3);
      forOwn(object, function(value, key, object) {
        if (callback(value, key, object)) {
          result = key;
          return false;
        }
      });
      return result;
    }

    /**
     * This method is like `_.findKey` except that it iterates over elements
     * of a `collection` in the opposite order.
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to search.
     * @param {Function|Object|string} [callback=identity] The function called per
     *  iteration. If a property name or object is provided it will be used to
     *  create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {string|undefined} Returns the key of the found element, else `undefined`.
     * @example
     *
     * var characters = {
     *   'barney': {  'age': 36, 'blocked': true },
     *   'fred': {    'age': 40, 'blocked': false },
     *   'pebbles': { 'age': 1,  'blocked': true }
     * };
     *
     * _.findLastKey(characters, function(chr) {
     *   return chr.age < 40;
     * });
     * // => returns `pebbles`, assuming `_.findKey` returns `barney`
     *
     * // using "_.where" callback shorthand
     * _.findLastKey(characters, { 'age': 40 });
     * // => 'fred'
     *
     * // using "_.pluck" callback shorthand
     * _.findLastKey(characters, 'blocked');
     * // => 'pebbles'
     */
    function findLastKey(object, callback, thisArg) {
      var result;
      callback = lodash.createCallback(callback, thisArg, 3);
      forOwnRight(object, function(value, key, object) {
        if (callback(value, key, object)) {
          result = key;
          return false;
        }
      });
      return result;
    }

    /**
     * Iterates over own and inherited enumerable properties of an object,
     * executing the callback for each property. The callback is bound to `thisArg`
     * and invoked with three arguments; (value, key, object). Callbacks may exit
     * iteration early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @type Function
     * @category Objects
     * @param {Object} object The object to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function Shape() {
     *   this.x = 0;
     *   this.y = 0;
     * }
     *
     * Shape.prototype.move = function(x, y) {
     *   this.x += x;
     *   this.y += y;
     * };
     *
     * _.forIn(new Shape, function(value, key) {
     *   console.log(key);
     * });
     * // => logs 'x', 'y', and 'move' (property order is not guaranteed across environments)
     */
    var forIn = function(collection, callback, thisArg) {
      var index, iterable = collection, result = iterable;
      if (!iterable) return result;
      if (!objectTypes[typeof iterable]) return result;
      callback = callback && typeof thisArg == 'undefined' ? callback : baseCreateCallback(callback, thisArg, 3);
        for (index in iterable) {
          if (callback(iterable[index], index, collection) === false) return result;
        }
      return result
    };

    /**
     * This method is like `_.forIn` except that it iterates over elements
     * of a `collection` in the opposite order.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function Shape() {
     *   this.x = 0;
     *   this.y = 0;
     * }
     *
     * Shape.prototype.move = function(x, y) {
     *   this.x += x;
     *   this.y += y;
     * };
     *
     * _.forInRight(new Shape, function(value, key) {
     *   console.log(key);
     * });
     * // => logs 'move', 'y', and 'x' assuming `_.forIn ` logs 'x', 'y', and 'move'
     */
    function forInRight(object, callback, thisArg) {
      var pairs = [];

      forIn(object, function(value, key) {
        pairs.push(key, value);
      });

      var length = pairs.length;
      callback = baseCreateCallback(callback, thisArg, 3);
      while (length--) {
        if (callback(pairs[length--], pairs[length], object) === false) {
          break;
        }
      }
      return object;
    }

    /**
     * Iterates over own enumerable properties of an object, executing the callback
     * for each property. The callback is bound to `thisArg` and invoked with three
     * arguments; (value, key, object). Callbacks may exit iteration early by
     * explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @type Function
     * @category Objects
     * @param {Object} object The object to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * _.forOwn({ '0': 'zero', '1': 'one', 'length': 2 }, function(num, key) {
     *   console.log(key);
     * });
     * // => logs '0', '1', and 'length' (property order is not guaranteed across environments)
     */
    var forOwn = function(collection, callback, thisArg) {
      var index, iterable = collection, result = iterable;
      if (!iterable) return result;
      if (!objectTypes[typeof iterable]) return result;
      callback = callback && typeof thisArg == 'undefined' ? callback : baseCreateCallback(callback, thisArg, 3);
        var ownIndex = -1,
            ownProps = objectTypes[typeof iterable] && keys(iterable),
            length = ownProps ? ownProps.length : 0;

        while (++ownIndex < length) {
          index = ownProps[ownIndex];
          if (callback(iterable[index], index, collection) === false) return result;
        }
      return result
    };

    /**
     * This method is like `_.forOwn` except that it iterates over elements
     * of a `collection` in the opposite order.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns `object`.
     * @example
     *
     * _.forOwnRight({ '0': 'zero', '1': 'one', 'length': 2 }, function(num, key) {
     *   console.log(key);
     * });
     * // => logs 'length', '1', and '0' assuming `_.forOwn` logs '0', '1', and 'length'
     */
    function forOwnRight(object, callback, thisArg) {
      var props = keys(object),
          length = props.length;

      callback = baseCreateCallback(callback, thisArg, 3);
      while (length--) {
        var key = props[length];
        if (callback(object[key], key, object) === false) {
          break;
        }
      }
      return object;
    }

    /**
     * Creates a sorted array of property names of all enumerable properties,
     * own and inherited, of `object` that have function values.
     *
     * @static
     * @memberOf _
     * @alias methods
     * @category Objects
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns an array of property names that have function values.
     * @example
     *
     * _.functions(_);
     * // => ['all', 'any', 'bind', 'bindAll', 'clone', 'compact', 'compose', ...]
     */
    function functions(object) {
      var result = [];
      forIn(object, function(value, key) {
        if (isFunction(value)) {
          result.push(key);
        }
      });
      return result.sort();
    }

    /**
     * Checks if the specified property name exists as a direct property of `object`,
     * instead of an inherited property.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to inspect.
     * @param {string} key The name of the property to check.
     * @returns {boolean} Returns `true` if key is a direct property, else `false`.
     * @example
     *
     * _.has({ 'a': 1, 'b': 2, 'c': 3 }, 'b');
     * // => true
     */
    function has(object, key) {
      return object ? hasOwnProperty.call(object, key) : false;
    }

    /**
     * Creates an object composed of the inverted keys and values of the given object.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to invert.
     * @returns {Object} Returns the created inverted object.
     * @example
     *
     * _.invert({ 'first': 'fred', 'second': 'barney' });
     * // => { 'fred': 'first', 'barney': 'second' }
     */
    function invert(object) {
      var index = -1,
          props = keys(object),
          length = props.length,
          result = {};

      while (++index < length) {
        var key = props[index];
        result[object[key]] = key;
      }
      return result;
    }

    /**
     * Checks if `value` is a boolean value.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a boolean value, else `false`.
     * @example
     *
     * _.isBoolean(null);
     * // => false
     */
    function isBoolean(value) {
      return value === true || value === false ||
        value && typeof value == 'object' && toString.call(value) == boolClass || false;
    }

    /**
     * Checks if `value` is a date.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a date, else `false`.
     * @example
     *
     * _.isDate(new Date);
     * // => true
     */
    function isDate(value) {
      return value && typeof value == 'object' && toString.call(value) == dateClass || false;
    }

    /**
     * Checks if `value` is a DOM element.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a DOM element, else `false`.
     * @example
     *
     * _.isElement(document.body);
     * // => true
     */
    function isElement(value) {
      return value && value.nodeType === 1 || false;
    }

    /**
     * Checks if `value` is empty. Arrays, strings, or `arguments` objects with a
     * length of `0` and objects with no own enumerable properties are considered
     * "empty".
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Array|Object|string} value The value to inspect.
     * @returns {boolean} Returns `true` if the `value` is empty, else `false`.
     * @example
     *
     * _.isEmpty([1, 2, 3]);
     * // => false
     *
     * _.isEmpty({});
     * // => true
     *
     * _.isEmpty('');
     * // => true
     */
    function isEmpty(value) {
      var result = true;
      if (!value) {
        return result;
      }
      var className = toString.call(value),
          length = value.length;

      if ((className == arrayClass || className == stringClass || className == argsClass ) ||
          (className == objectClass && typeof length == 'number' && isFunction(value.splice))) {
        return !length;
      }
      forOwn(value, function() {
        return (result = false);
      });
      return result;
    }

    /**
     * Performs a deep comparison between two values to determine if they are
     * equivalent to each other. If a callback is provided it will be executed
     * to compare values. If the callback returns `undefined` comparisons will
     * be handled by the method instead. The callback is bound to `thisArg` and
     * invoked with two arguments; (a, b).
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} a The value to compare.
     * @param {*} b The other value to compare.
     * @param {Function} [callback] The function to customize comparing values.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'name': 'fred' };
     * var copy = { 'name': 'fred' };
     *
     * object == copy;
     * // => false
     *
     * _.isEqual(object, copy);
     * // => true
     *
     * var words = ['hello', 'goodbye'];
     * var otherWords = ['hi', 'goodbye'];
     *
     * _.isEqual(words, otherWords, function(a, b) {
     *   var reGreet = /^(?:hello|hi)$/i,
     *       aGreet = _.isString(a) && reGreet.test(a),
     *       bGreet = _.isString(b) && reGreet.test(b);
     *
     *   return (aGreet || bGreet) ? (aGreet == bGreet) : undefined;
     * });
     * // => true
     */
    function isEqual(a, b, callback, thisArg) {
      return baseIsEqual(a, b, typeof callback == 'function' && baseCreateCallback(callback, thisArg, 2));
    }

    /**
     * Checks if `value` is, or can be coerced to, a finite number.
     *
     * Note: This is not the same as native `isFinite` which will return true for
     * booleans and empty strings. See http://es5.github.io/#x15.1.2.5.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is finite, else `false`.
     * @example
     *
     * _.isFinite(-101);
     * // => true
     *
     * _.isFinite('10');
     * // => true
     *
     * _.isFinite(true);
     * // => false
     *
     * _.isFinite('');
     * // => false
     *
     * _.isFinite(Infinity);
     * // => false
     */
    function isFinite(value) {
      return nativeIsFinite(value) && !nativeIsNaN(parseFloat(value));
    }

    /**
     * Checks if `value` is a function.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     */
    function isFunction(value) {
      return typeof value == 'function';
    }

    /**
     * Checks if `value` is the language type of Object.
     * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(1);
     * // => false
     */
    function isObject(value) {
      // check if the value is the ECMAScript language type of Object
      // http://es5.github.io/#x8
      // and avoid a V8 bug
      // http://code.google.com/p/v8/issues/detail?id=2291
      return !!(value && objectTypes[typeof value]);
    }

    /**
     * Checks if `value` is `NaN`.
     *
     * Note: This is not the same as native `isNaN` which will return `true` for
     * `undefined` and other non-numeric values. See http://es5.github.io/#x15.1.2.4.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is `NaN`, else `false`.
     * @example
     *
     * _.isNaN(NaN);
     * // => true
     *
     * _.isNaN(new Number(NaN));
     * // => true
     *
     * isNaN(undefined);
     * // => true
     *
     * _.isNaN(undefined);
     * // => false
     */
    function isNaN(value) {
      // `NaN` as a primitive is the only value that is not equal to itself
      // (perform the [[Class]] check first to avoid errors with some host objects in IE)
      return isNumber(value) && value != +value;
    }

    /**
     * Checks if `value` is `null`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is `null`, else `false`.
     * @example
     *
     * _.isNull(null);
     * // => true
     *
     * _.isNull(undefined);
     * // => false
     */
    function isNull(value) {
      return value === null;
    }

    /**
     * Checks if `value` is a number.
     *
     * Note: `NaN` is considered a number. See http://es5.github.io/#x8.5.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a number, else `false`.
     * @example
     *
     * _.isNumber(8.4 * 5);
     * // => true
     */
    function isNumber(value) {
      return typeof value == 'number' ||
        value && typeof value == 'object' && toString.call(value) == numberClass || false;
    }

    /**
     * Checks if `value` is an object created by the `Object` constructor.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
     * @example
     *
     * function Shape() {
     *   this.x = 0;
     *   this.y = 0;
     * }
     *
     * _.isPlainObject(new Shape);
     * // => false
     *
     * _.isPlainObject([1, 2, 3]);
     * // => false
     *
     * _.isPlainObject({ 'x': 0, 'y': 0 });
     * // => true
     */
    var isPlainObject = !getPrototypeOf ? shimIsPlainObject : function(value) {
      if (!(value && toString.call(value) == objectClass)) {
        return false;
      }
      var valueOf = value.valueOf,
          objProto = isNative(valueOf) && (objProto = getPrototypeOf(valueOf)) && getPrototypeOf(objProto);

      return objProto
        ? (value == objProto || getPrototypeOf(value) == objProto)
        : shimIsPlainObject(value);
    };

    /**
     * Checks if `value` is a regular expression.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a regular expression, else `false`.
     * @example
     *
     * _.isRegExp(/fred/);
     * // => true
     */
    function isRegExp(value) {
      return value && typeof value == 'object' && toString.call(value) == regexpClass || false;
    }

    /**
     * Checks if `value` is a string.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is a string, else `false`.
     * @example
     *
     * _.isString('fred');
     * // => true
     */
    function isString(value) {
      return typeof value == 'string' ||
        value && typeof value == 'object' && toString.call(value) == stringClass || false;
    }

    /**
     * Checks if `value` is `undefined`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if the `value` is `undefined`, else `false`.
     * @example
     *
     * _.isUndefined(void 0);
     * // => true
     */
    function isUndefined(value) {
      return typeof value == 'undefined';
    }

    /**
     * Creates an object with the same keys as `object` and values generated by
     * running each own enumerable property of `object` through the callback.
     * The callback is bound to `thisArg` and invoked with three arguments;
     * (value, key, object).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new object with values of the results of each `callback` execution.
     * @example
     *
     * _.mapValues({ 'a': 1, 'b': 2, 'c': 3} , function(num) { return num * 3; });
     * // => { 'a': 3, 'b': 6, 'c': 9 }
     *
     * var characters = {
     *   'fred': { 'name': 'fred', 'age': 40 },
     *   'pebbles': { 'name': 'pebbles', 'age': 1 }
     * };
     *
     * // using "_.pluck" callback shorthand
     * _.mapValues(characters, 'age');
     * // => { 'fred': 40, 'pebbles': 1 }
     */
    function mapValues(object, callback, thisArg) {
      var result = {};
      callback = lodash.createCallback(callback, thisArg, 3);

      forOwn(object, function(value, key, object) {
        result[key] = callback(value, key, object);
      });
      return result;
    }

    /**
     * Recursively merges own enumerable properties of the source object(s), that
     * don't resolve to `undefined` into the destination object. Subsequent sources
     * will overwrite property assignments of previous sources. If a callback is
     * provided it will be executed to produce the merged values of the destination
     * and source properties. If the callback returns `undefined` merging will
     * be handled by the method instead. The callback is bound to `thisArg` and
     * invoked with two arguments; (objectValue, sourceValue).
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The destination object.
     * @param {...Object} [source] The source objects.
     * @param {Function} [callback] The function to customize merging properties.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns the destination object.
     * @example
     *
     * var names = {
     *   'characters': [
     *     { 'name': 'barney' },
     *     { 'name': 'fred' }
     *   ]
     * };
     *
     * var ages = {
     *   'characters': [
     *     { 'age': 36 },
     *     { 'age': 40 }
     *   ]
     * };
     *
     * _.merge(names, ages);
     * // => { 'characters': [{ 'name': 'barney', 'age': 36 }, { 'name': 'fred', 'age': 40 }] }
     *
     * var food = {
     *   'fruits': ['apple'],
     *   'vegetables': ['beet']
     * };
     *
     * var otherFood = {
     *   'fruits': ['banana'],
     *   'vegetables': ['carrot']
     * };
     *
     * _.merge(food, otherFood, function(a, b) {
     *   return _.isArray(a) ? a.concat(b) : undefined;
     * });
     * // => { 'fruits': ['apple', 'banana'], 'vegetables': ['beet', 'carrot] }
     */
    function merge(object) {
      var args = arguments,
          length = 2;

      if (!isObject(object)) {
        return object;
      }
      // allows working with `_.reduce` and `_.reduceRight` without using
      // their `index` and `collection` arguments
      if (typeof args[2] != 'number') {
        length = args.length;
      }
      if (length > 3 && typeof args[length - 2] == 'function') {
        var callback = baseCreateCallback(args[--length - 1], args[length--], 2);
      } else if (length > 2 && typeof args[length - 1] == 'function') {
        callback = args[--length];
      }
      var sources = slice(arguments, 1, length),
          index = -1,
          stackA = getArray(),
          stackB = getArray();

      while (++index < length) {
        baseMerge(object, sources[index], callback, stackA, stackB);
      }
      releaseArray(stackA);
      releaseArray(stackB);
      return object;
    }

    /**
     * Creates a shallow clone of `object` excluding the specified properties.
     * Property names may be specified as individual arguments or as arrays of
     * property names. If a callback is provided it will be executed for each
     * property of `object` omitting the properties the callback returns truey
     * for. The callback is bound to `thisArg` and invoked with three arguments;
     * (value, key, object).
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The source object.
     * @param {Function|...string|string[]} [callback] The properties to omit or the
     *  function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns an object without the omitted properties.
     * @example
     *
     * _.omit({ 'name': 'fred', 'age': 40 }, 'age');
     * // => { 'name': 'fred' }
     *
     * _.omit({ 'name': 'fred', 'age': 40 }, function(value) {
     *   return typeof value == 'number';
     * });
     * // => { 'name': 'fred' }
     */
    function omit(object, callback, thisArg) {
      var result = {};
      if (typeof callback != 'function') {
        var props = [];
        forIn(object, function(value, key) {
          props.push(key);
        });
        props = baseDifference(props, baseFlatten(arguments, true, false, 1));

        var index = -1,
            length = props.length;

        while (++index < length) {
          var key = props[index];
          result[key] = object[key];
        }
      } else {
        callback = lodash.createCallback(callback, thisArg, 3);
        forIn(object, function(value, key, object) {
          if (!callback(value, key, object)) {
            result[key] = value;
          }
        });
      }
      return result;
    }

    /**
     * Creates a two dimensional array of an object's key-value pairs,
     * i.e. `[[key1, value1], [key2, value2]]`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns new array of key-value pairs.
     * @example
     *
     * _.pairs({ 'barney': 36, 'fred': 40 });
     * // => [['barney', 36], ['fred', 40]] (property order is not guaranteed across environments)
     */
    function pairs(object) {
      var index = -1,
          props = keys(object),
          length = props.length,
          result = Array(length);

      while (++index < length) {
        var key = props[index];
        result[index] = [key, object[key]];
      }
      return result;
    }

    /**
     * Creates a shallow clone of `object` composed of the specified properties.
     * Property names may be specified as individual arguments or as arrays of
     * property names. If a callback is provided it will be executed for each
     * property of `object` picking the properties the callback returns truey
     * for. The callback is bound to `thisArg` and invoked with three arguments;
     * (value, key, object).
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The source object.
     * @param {Function|...string|string[]} [callback] The function called per
     *  iteration or property names to pick, specified as individual property
     *  names or arrays of property names.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns an object composed of the picked properties.
     * @example
     *
     * _.pick({ 'name': 'fred', '_userid': 'fred1' }, 'name');
     * // => { 'name': 'fred' }
     *
     * _.pick({ 'name': 'fred', '_userid': 'fred1' }, function(value, key) {
     *   return key.charAt(0) != '_';
     * });
     * // => { 'name': 'fred' }
     */
    function pick(object, callback, thisArg) {
      var result = {};
      if (typeof callback != 'function') {
        var index = -1,
            props = baseFlatten(arguments, true, false, 1),
            length = isObject(object) ? props.length : 0;

        while (++index < length) {
          var key = props[index];
          if (key in object) {
            result[key] = object[key];
          }
        }
      } else {
        callback = lodash.createCallback(callback, thisArg, 3);
        forIn(object, function(value, key, object) {
          if (callback(value, key, object)) {
            result[key] = value;
          }
        });
      }
      return result;
    }

    /**
     * An alternative to `_.reduce` this method transforms `object` to a new
     * `accumulator` object which is the result of running each of its own
     * enumerable properties through a callback, with each callback execution
     * potentially mutating the `accumulator` object. The callback is bound to
     * `thisArg` and invoked with four arguments; (accumulator, value, key, object).
     * Callbacks may exit iteration early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Array|Object} object The object to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [accumulator] The custom accumulator value.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * var squares = _.transform([1, 2, 3, 4, 5, 6, 7, 8, 9, 10], function(result, num) {
     *   num *= num;
     *   if (num % 2) {
     *     return result.push(num) < 3;
     *   }
     * });
     * // => [1, 9, 25]
     *
     * var mapped = _.transform({ 'a': 1, 'b': 2, 'c': 3 }, function(result, num, key) {
     *   result[key] = num * 3;
     * });
     * // => { 'a': 3, 'b': 6, 'c': 9 }
     */
    function transform(object, callback, accumulator, thisArg) {
      var isArr = isArray(object);
      if (accumulator == null) {
        if (isArr) {
          accumulator = [];
        } else {
          var ctor = object && object.constructor,
              proto = ctor && ctor.prototype;

          accumulator = baseCreate(proto);
        }
      }
      if (callback) {
        callback = lodash.createCallback(callback, thisArg, 4);
        (isArr ? forEach : forOwn)(object, function(value, index, object) {
          return callback(accumulator, value, index, object);
        });
      }
      return accumulator;
    }

    /**
     * Creates an array composed of the own enumerable property values of `object`.
     *
     * @static
     * @memberOf _
     * @category Objects
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns an array of property values.
     * @example
     *
     * _.values({ 'one': 1, 'two': 2, 'three': 3 });
     * // => [1, 2, 3] (property order is not guaranteed across environments)
     */
    function values(object) {
      var index = -1,
          props = keys(object),
          length = props.length,
          result = Array(length);

      while (++index < length) {
        result[index] = object[props[index]];
      }
      return result;
    }

    /*--------------------------------------------------------------------------*/

    /**
     * Creates an array of elements from the specified indexes, or keys, of the
     * `collection`. Indexes may be specified as individual arguments or as arrays
     * of indexes.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {...(number|number[]|string|string[])} [index] The indexes of `collection`
     *   to retrieve, specified as individual indexes or arrays of indexes.
     * @returns {Array} Returns a new array of elements corresponding to the
     *  provided indexes.
     * @example
     *
     * _.at(['a', 'b', 'c', 'd', 'e'], [0, 2, 4]);
     * // => ['a', 'c', 'e']
     *
     * _.at(['fred', 'barney', 'pebbles'], 0, 2);
     * // => ['fred', 'pebbles']
     */
    function at(collection) {
      var args = arguments,
          index = -1,
          props = baseFlatten(args, true, false, 1),
          length = (args[2] && args[2][args[1]] === collection) ? 1 : props.length,
          result = Array(length);

      while(++index < length) {
        result[index] = collection[props[index]];
      }
      return result;
    }

    /**
     * Checks if a given value is present in a collection using strict equality
     * for comparisons, i.e. `===`. If `fromIndex` is negative, it is used as the
     * offset from the end of the collection.
     *
     * @static
     * @memberOf _
     * @alias include
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {*} target The value to check for.
     * @param {number} [fromIndex=0] The index to search from.
     * @returns {boolean} Returns `true` if the `target` element is found, else `false`.
     * @example
     *
     * _.contains([1, 2, 3], 1);
     * // => true
     *
     * _.contains([1, 2, 3], 1, 2);
     * // => false
     *
     * _.contains({ 'name': 'fred', 'age': 40 }, 'fred');
     * // => true
     *
     * _.contains('pebbles', 'eb');
     * // => true
     */
    function contains(collection, target, fromIndex) {
      var index = -1,
          indexOf = getIndexOf(),
          length = collection ? collection.length : 0,
          result = false;

      fromIndex = (fromIndex < 0 ? nativeMax(0, length + fromIndex) : fromIndex) || 0;
      if (isArray(collection)) {
        result = indexOf(collection, target, fromIndex) > -1;
      } else if (typeof length == 'number') {
        result = (isString(collection) ? collection.indexOf(target, fromIndex) : indexOf(collection, target, fromIndex)) > -1;
      } else {
        forOwn(collection, function(value) {
          if (++index >= fromIndex) {
            return !(result = value === target);
          }
        });
      }
      return result;
    }

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` through the callback. The corresponding value
     * of each key is the number of times the key was returned by the callback.
     * The callback is bound to `thisArg` and invoked with three arguments;
     * (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.countBy([4.3, 6.1, 6.4], function(num) { return Math.floor(num); });
     * // => { '4': 1, '6': 2 }
     *
     * _.countBy([4.3, 6.1, 6.4], function(num) { return this.floor(num); }, Math);
     * // => { '4': 1, '6': 2 }
     *
     * _.countBy(['one', 'two', 'three'], 'length');
     * // => { '3': 2, '5': 1 }
     */
    var countBy = createAggregator(function(result, value, key) {
      (hasOwnProperty.call(result, key) ? result[key]++ : result[key] = 1);
    });

    /**
     * Checks if the given callback returns truey value for **all** elements of
     * a collection. The callback is bound to `thisArg` and invoked with three
     * arguments; (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias all
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {boolean} Returns `true` if all elements passed the callback check,
     *  else `false`.
     * @example
     *
     * _.every([true, 1, null, 'yes']);
     * // => false
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.every(characters, 'age');
     * // => true
     *
     * // using "_.where" callback shorthand
     * _.every(characters, { 'age': 36 });
     * // => false
     */
    function every(collection, callback, thisArg) {
      var result = true;
      callback = lodash.createCallback(callback, thisArg, 3);

      var index = -1,
          length = collection ? collection.length : 0;

      if (typeof length == 'number') {
        while (++index < length) {
          if (!(result = !!callback(collection[index], index, collection))) {
            break;
          }
        }
      } else {
        forOwn(collection, function(value, index, collection) {
          return (result = !!callback(value, index, collection));
        });
      }
      return result;
    }

    /**
     * Iterates over elements of a collection, returning an array of all elements
     * the callback returns truey for. The callback is bound to `thisArg` and
     * invoked with three arguments; (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias select
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new array of elements that passed the callback check.
     * @example
     *
     * var evens = _.filter([1, 2, 3, 4, 5, 6], function(num) { return num % 2 == 0; });
     * // => [2, 4, 6]
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36, 'blocked': false },
     *   { 'name': 'fred',   'age': 40, 'blocked': true }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.filter(characters, 'blocked');
     * // => [{ 'name': 'fred', 'age': 40, 'blocked': true }]
     *
     * // using "_.where" callback shorthand
     * _.filter(characters, { 'age': 36 });
     * // => [{ 'name': 'barney', 'age': 36, 'blocked': false }]
     */
    function filter(collection, callback, thisArg) {
      var result = [];
      callback = lodash.createCallback(callback, thisArg, 3);

      var index = -1,
          length = collection ? collection.length : 0;

      if (typeof length == 'number') {
        while (++index < length) {
          var value = collection[index];
          if (callback(value, index, collection)) {
            result.push(value);
          }
        }
      } else {
        forOwn(collection, function(value, index, collection) {
          if (callback(value, index, collection)) {
            result.push(value);
          }
        });
      }
      return result;
    }

    /**
     * Iterates over elements of a collection, returning the first element that
     * the callback returns truey for. The callback is bound to `thisArg` and
     * invoked with three arguments; (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias detect, findWhere
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the found element, else `undefined`.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney',  'age': 36, 'blocked': false },
     *   { 'name': 'fred',    'age': 40, 'blocked': true },
     *   { 'name': 'pebbles', 'age': 1,  'blocked': false }
     * ];
     *
     * _.find(characters, function(chr) {
     *   return chr.age < 40;
     * });
     * // => { 'name': 'barney', 'age': 36, 'blocked': false }
     *
     * // using "_.where" callback shorthand
     * _.find(characters, { 'age': 1 });
     * // =>  { 'name': 'pebbles', 'age': 1, 'blocked': false }
     *
     * // using "_.pluck" callback shorthand
     * _.find(characters, 'blocked');
     * // => { 'name': 'fred', 'age': 40, 'blocked': true }
     */
    function find(collection, callback, thisArg) {
      callback = lodash.createCallback(callback, thisArg, 3);

      var index = -1,
          length = collection ? collection.length : 0;

      if (typeof length == 'number') {
        while (++index < length) {
          var value = collection[index];
          if (callback(value, index, collection)) {
            return value;
          }
        }
      } else {
        var result;
        forOwn(collection, function(value, index, collection) {
          if (callback(value, index, collection)) {
            result = value;
            return false;
          }
        });
        return result;
      }
    }

    /**
     * This method is like `_.find` except that it iterates over elements
     * of a `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the found element, else `undefined`.
     * @example
     *
     * _.findLast([1, 2, 3, 4], function(num) {
     *   return num % 2 == 1;
     * });
     * // => 3
     */
    function findLast(collection, callback, thisArg) {
      var result;
      callback = lodash.createCallback(callback, thisArg, 3);
      forEachRight(collection, function(value, index, collection) {
        if (callback(value, index, collection)) {
          result = value;
          return false;
        }
      });
      return result;
    }

    /**
     * Iterates over elements of a collection, executing the callback for each
     * element. The callback is bound to `thisArg` and invoked with three arguments;
     * (value, index|key, collection). Callbacks may exit iteration early by
     * explicitly returning `false`.
     *
     * Note: As with other "Collections" methods, objects with a `length` property
     * are iterated like arrays. To avoid this behavior `_.forIn` or `_.forOwn`
     * may be used for object iteration.
     *
     * @static
     * @memberOf _
     * @alias each
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array|Object|string} Returns `collection`.
     * @example
     *
     * _([1, 2, 3]).forEach(function(num) { console.log(num); }).join(',');
     * // => logs each number and returns '1,2,3'
     *
     * _.forEach({ 'one': 1, 'two': 2, 'three': 3 }, function(num) { console.log(num); });
     * // => logs each number and returns the object (property order is not guaranteed across environments)
     */
    function forEach(collection, callback, thisArg) {
      var index = -1,
          length = collection ? collection.length : 0;

      callback = callback && typeof thisArg == 'undefined' ? callback : baseCreateCallback(callback, thisArg, 3);
      if (typeof length == 'number') {
        while (++index < length) {
          if (callback(collection[index], index, collection) === false) {
            break;
          }
        }
      } else {
        forOwn(collection, callback);
      }
      return collection;
    }

    /**
     * This method is like `_.forEach` except that it iterates over elements
     * of a `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @alias eachRight
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array|Object|string} Returns `collection`.
     * @example
     *
     * _([1, 2, 3]).forEachRight(function(num) { console.log(num); }).join(',');
     * // => logs each number from right to left and returns '3,2,1'
     */
    function forEachRight(collection, callback, thisArg) {
      var length = collection ? collection.length : 0;
      callback = callback && typeof thisArg == 'undefined' ? callback : baseCreateCallback(callback, thisArg, 3);
      if (typeof length == 'number') {
        while (length--) {
          if (callback(collection[length], length, collection) === false) {
            break;
          }
        }
      } else {
        var props = keys(collection);
        length = props.length;
        forOwn(collection, function(value, key, collection) {
          key = props ? props[--length] : --length;
          return callback(collection[key], key, collection);
        });
      }
      return collection;
    }

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of a collection through the callback. The corresponding value
     * of each key is an array of the elements responsible for generating the key.
     * The callback is bound to `thisArg` and invoked with three arguments;
     * (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.groupBy([4.2, 6.1, 6.4], function(num) { return Math.floor(num); });
     * // => { '4': [4.2], '6': [6.1, 6.4] }
     *
     * _.groupBy([4.2, 6.1, 6.4], function(num) { return this.floor(num); }, Math);
     * // => { '4': [4.2], '6': [6.1, 6.4] }
     *
     * // using "_.pluck" callback shorthand
     * _.groupBy(['one', 'two', 'three'], 'length');
     * // => { '3': ['one', 'two'], '5': ['three'] }
     */
    var groupBy = createAggregator(function(result, value, key) {
      (hasOwnProperty.call(result, key) ? result[key] : result[key] = []).push(value);
    });

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of the collection through the given callback. The corresponding
     * value of each key is the last element responsible for generating the key.
     * The callback is bound to `thisArg` and invoked with three arguments;
     * (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * var keys = [
     *   { 'dir': 'left', 'code': 97 },
     *   { 'dir': 'right', 'code': 100 }
     * ];
     *
     * _.indexBy(keys, 'dir');
     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
     *
     * _.indexBy(keys, function(key) { return String.fromCharCode(key.code); });
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     *
     * _.indexBy(characters, function(key) { this.fromCharCode(key.code); }, String);
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     */
    var indexBy = createAggregator(function(result, value, key) {
      result[key] = value;
    });

    /**
     * Invokes the method named by `methodName` on each element in the `collection`
     * returning an array of the results of each invoked method. Additional arguments
     * will be provided to each invoked method. If `methodName` is a function it
     * will be invoked for, and `this` bound to, each element in the `collection`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|string} methodName The name of the method to invoke or
     *  the function invoked per iteration.
     * @param {...*} [arg] Arguments to invoke the method with.
     * @returns {Array} Returns a new array of the results of each invoked method.
     * @example
     *
     * _.invoke([[5, 1, 7], [3, 2, 1]], 'sort');
     * // => [[1, 5, 7], [1, 2, 3]]
     *
     * _.invoke([123, 456], String.prototype.split, '');
     * // => [['1', '2', '3'], ['4', '5', '6']]
     */
    function invoke(collection, methodName) {
      var args = slice(arguments, 2),
          index = -1,
          isFunc = typeof methodName == 'function',
          length = collection ? collection.length : 0,
          result = Array(typeof length == 'number' ? length : 0);

      forEach(collection, function(value) {
        result[++index] = (isFunc ? methodName : value[methodName]).apply(value, args);
      });
      return result;
    }

    /**
     * Creates an array of values by running each element in the collection
     * through the callback. The callback is bound to `thisArg` and invoked with
     * three arguments; (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias collect
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new array of the results of each `callback` execution.
     * @example
     *
     * _.map([1, 2, 3], function(num) { return num * 3; });
     * // => [3, 6, 9]
     *
     * _.map({ 'one': 1, 'two': 2, 'three': 3 }, function(num) { return num * 3; });
     * // => [3, 6, 9] (property order is not guaranteed across environments)
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.map(characters, 'name');
     * // => ['barney', 'fred']
     */
    function map(collection, callback, thisArg) {
      var index = -1,
          length = collection ? collection.length : 0;

      callback = lodash.createCallback(callback, thisArg, 3);
      if (typeof length == 'number') {
        var result = Array(length);
        while (++index < length) {
          result[index] = callback(collection[index], index, collection);
        }
      } else {
        result = [];
        forOwn(collection, function(value, key, collection) {
          result[++index] = callback(value, key, collection);
        });
      }
      return result;
    }

    /**
     * Retrieves the maximum value of a collection. If the collection is empty or
     * falsey `-Infinity` is returned. If a callback is provided it will be executed
     * for each value in the collection to generate the criterion by which the value
     * is ranked. The callback is bound to `thisArg` and invoked with three
     * arguments; (value, index, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the maximum value.
     * @example
     *
     * _.max([4, 2, 8, 6]);
     * // => 8
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * _.max(characters, function(chr) { return chr.age; });
     * // => { 'name': 'fred', 'age': 40 };
     *
     * // using "_.pluck" callback shorthand
     * _.max(characters, 'age');
     * // => { 'name': 'fred', 'age': 40 };
     */
    function max(collection, callback, thisArg) {
      var computed = -Infinity,
          result = computed;

      // allows working with functions like `_.map` without using
      // their `index` argument as a callback
      if (typeof callback != 'function' && thisArg && thisArg[callback] === collection) {
        callback = null;
      }
      if (callback == null && isArray(collection)) {
        var index = -1,
            length = collection.length;

        while (++index < length) {
          var value = collection[index];
          if (value > result) {
            result = value;
          }
        }
      } else {
        callback = (callback == null && isString(collection))
          ? charAtCallback
          : lodash.createCallback(callback, thisArg, 3);

        forEach(collection, function(value, index, collection) {
          var current = callback(value, index, collection);
          if (current > computed) {
            computed = current;
            result = value;
          }
        });
      }
      return result;
    }

    /**
     * Retrieves the minimum value of a collection. If the collection is empty or
     * falsey `Infinity` is returned. If a callback is provided it will be executed
     * for each value in the collection to generate the criterion by which the value
     * is ranked. The callback is bound to `thisArg` and invoked with three
     * arguments; (value, index, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the minimum value.
     * @example
     *
     * _.min([4, 2, 8, 6]);
     * // => 2
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * _.min(characters, function(chr) { return chr.age; });
     * // => { 'name': 'barney', 'age': 36 };
     *
     * // using "_.pluck" callback shorthand
     * _.min(characters, 'age');
     * // => { 'name': 'barney', 'age': 36 };
     */
    function min(collection, callback, thisArg) {
      var computed = Infinity,
          result = computed;

      // allows working with functions like `_.map` without using
      // their `index` argument as a callback
      if (typeof callback != 'function' && thisArg && thisArg[callback] === collection) {
        callback = null;
      }
      if (callback == null && isArray(collection)) {
        var index = -1,
            length = collection.length;

        while (++index < length) {
          var value = collection[index];
          if (value < result) {
            result = value;
          }
        }
      } else {
        callback = (callback == null && isString(collection))
          ? charAtCallback
          : lodash.createCallback(callback, thisArg, 3);

        forEach(collection, function(value, index, collection) {
          var current = callback(value, index, collection);
          if (current < computed) {
            computed = current;
            result = value;
          }
        });
      }
      return result;
    }

    /**
     * Retrieves the value of a specified property from all elements in the collection.
     *
     * @static
     * @memberOf _
     * @type Function
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {string} property The name of the property to pluck.
     * @returns {Array} Returns a new array of property values.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * _.pluck(characters, 'name');
     * // => ['barney', 'fred']
     */
    var pluck = map;

    /**
     * Reduces a collection to a value which is the accumulated result of running
     * each element in the collection through the callback, where each successive
     * callback execution consumes the return value of the previous execution. If
     * `accumulator` is not provided the first element of the collection will be
     * used as the initial `accumulator` value. The callback is bound to `thisArg`
     * and invoked with four arguments; (accumulator, value, index|key, collection).
     *
     * @static
     * @memberOf _
     * @alias foldl, inject
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [accumulator] Initial value of the accumulator.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * var sum = _.reduce([1, 2, 3], function(sum, num) {
     *   return sum + num;
     * });
     * // => 6
     *
     * var mapped = _.reduce({ 'a': 1, 'b': 2, 'c': 3 }, function(result, num, key) {
     *   result[key] = num * 3;
     *   return result;
     * }, {});
     * // => { 'a': 3, 'b': 6, 'c': 9 }
     */
    function reduce(collection, callback, accumulator, thisArg) {
      if (!collection) return accumulator;
      var noaccum = arguments.length < 3;
      callback = lodash.createCallback(callback, thisArg, 4);

      var index = -1,
          length = collection.length;

      if (typeof length == 'number') {
        if (noaccum) {
          accumulator = collection[++index];
        }
        while (++index < length) {
          accumulator = callback(accumulator, collection[index], index, collection);
        }
      } else {
        forOwn(collection, function(value, index, collection) {
          accumulator = noaccum
            ? (noaccum = false, value)
            : callback(accumulator, value, index, collection)
        });
      }
      return accumulator;
    }

    /**
     * This method is like `_.reduce` except that it iterates over elements
     * of a `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @alias foldr
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function} [callback=identity] The function called per iteration.
     * @param {*} [accumulator] Initial value of the accumulator.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * var list = [[0, 1], [2, 3], [4, 5]];
     * var flat = _.reduceRight(list, function(a, b) { return a.concat(b); }, []);
     * // => [4, 5, 2, 3, 0, 1]
     */
    function reduceRight(collection, callback, accumulator, thisArg) {
      var noaccum = arguments.length < 3;
      callback = lodash.createCallback(callback, thisArg, 4);
      forEachRight(collection, function(value, index, collection) {
        accumulator = noaccum
          ? (noaccum = false, value)
          : callback(accumulator, value, index, collection);
      });
      return accumulator;
    }

    /**
     * The opposite of `_.filter` this method returns the elements of a
     * collection that the callback does **not** return truey for.
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new array of elements that failed the callback check.
     * @example
     *
     * var odds = _.reject([1, 2, 3, 4, 5, 6], function(num) { return num % 2 == 0; });
     * // => [1, 3, 5]
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36, 'blocked': false },
     *   { 'name': 'fred',   'age': 40, 'blocked': true }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.reject(characters, 'blocked');
     * // => [{ 'name': 'barney', 'age': 36, 'blocked': false }]
     *
     * // using "_.where" callback shorthand
     * _.reject(characters, { 'age': 36 });
     * // => [{ 'name': 'fred', 'age': 40, 'blocked': true }]
     */
    function reject(collection, callback, thisArg) {
      callback = lodash.createCallback(callback, thisArg, 3);
      return filter(collection, function(value, index, collection) {
        return !callback(value, index, collection);
      });
    }

    /**
     * Retrieves a random element or `n` random elements from a collection.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to sample.
     * @param {number} [n] The number of elements to sample.
     * @param- {Object} [guard] Allows working with functions like `_.map`
     *  without using their `index` arguments as `n`.
     * @returns {Array} Returns the random sample(s) of `collection`.
     * @example
     *
     * _.sample([1, 2, 3, 4]);
     * // => 2
     *
     * _.sample([1, 2, 3, 4], 2);
     * // => [3, 1]
     */
    function sample(collection, n, guard) {
      if (collection && typeof collection.length != 'number') {
        collection = values(collection);
      }
      if (n == null || guard) {
        return collection ? collection[baseRandom(0, collection.length - 1)] : undefined;
      }
      var result = shuffle(collection);
      result.length = nativeMin(nativeMax(0, n), result.length);
      return result;
    }

    /**
     * Creates an array of shuffled values, using a version of the Fisher-Yates
     * shuffle. See http://en.wikipedia.org/wiki/Fisher-Yates_shuffle.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to shuffle.
     * @returns {Array} Returns a new shuffled collection.
     * @example
     *
     * _.shuffle([1, 2, 3, 4, 5, 6]);
     * // => [4, 1, 6, 3, 5, 2]
     */
    function shuffle(collection) {
      var index = -1,
          length = collection ? collection.length : 0,
          result = Array(typeof length == 'number' ? length : 0);

      forEach(collection, function(value) {
        var rand = baseRandom(0, ++index);
        result[index] = result[rand];
        result[rand] = value;
      });
      return result;
    }

    /**
     * Gets the size of the `collection` by returning `collection.length` for arrays
     * and array-like objects or the number of own enumerable properties for objects.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to inspect.
     * @returns {number} Returns `collection.length` or number of own enumerable properties.
     * @example
     *
     * _.size([1, 2]);
     * // => 2
     *
     * _.size({ 'one': 1, 'two': 2, 'three': 3 });
     * // => 3
     *
     * _.size('pebbles');
     * // => 7
     */
    function size(collection) {
      var length = collection ? collection.length : 0;
      return typeof length == 'number' ? length : keys(collection).length;
    }

    /**
     * Checks if the callback returns a truey value for **any** element of a
     * collection. The function returns as soon as it finds a passing value and
     * does not iterate over the entire collection. The callback is bound to
     * `thisArg` and invoked with three arguments; (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias any
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {boolean} Returns `true` if any element passed the callback check,
     *  else `false`.
     * @example
     *
     * _.some([null, 0, 'yes', false], Boolean);
     * // => true
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36, 'blocked': false },
     *   { 'name': 'fred',   'age': 40, 'blocked': true }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.some(characters, 'blocked');
     * // => true
     *
     * // using "_.where" callback shorthand
     * _.some(characters, { 'age': 1 });
     * // => false
     */
    function some(collection, callback, thisArg) {
      var result;
      callback = lodash.createCallback(callback, thisArg, 3);

      var index = -1,
          length = collection ? collection.length : 0;

      if (typeof length == 'number') {
        while (++index < length) {
          if ((result = callback(collection[index], index, collection))) {
            break;
          }
        }
      } else {
        forOwn(collection, function(value, index, collection) {
          return !(result = callback(value, index, collection));
        });
      }
      return !!result;
    }

    /**
     * Creates an array of elements, sorted in ascending order by the results of
     * running each element in a collection through the callback. This method
     * performs a stable sort, that is, it will preserve the original sort order
     * of equal elements. The callback is bound to `thisArg` and invoked with
     * three arguments; (value, index|key, collection).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an array of property names is provided for `callback` the collection
     * will be sorted by each property value.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Array|Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new array of sorted elements.
     * @example
     *
     * _.sortBy([1, 2, 3], function(num) { return Math.sin(num); });
     * // => [3, 1, 2]
     *
     * _.sortBy([1, 2, 3], function(num) { return this.sin(num); }, Math);
     * // => [3, 1, 2]
     *
     * var characters = [
     *   { 'name': 'barney',  'age': 36 },
     *   { 'name': 'fred',    'age': 40 },
     *   { 'name': 'barney',  'age': 26 },
     *   { 'name': 'fred',    'age': 30 }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.map(_.sortBy(characters, 'age'), _.values);
     * // => [['barney', 26], ['fred', 30], ['barney', 36], ['fred', 40]]
     *
     * // sorting by multiple properties
     * _.map(_.sortBy(characters, ['name', 'age']), _.values);
     * // = > [['barney', 26], ['barney', 36], ['fred', 30], ['fred', 40]]
     */
    function sortBy(collection, callback, thisArg) {
      var index = -1,
          isArr = isArray(callback),
          length = collection ? collection.length : 0,
          result = Array(typeof length == 'number' ? length : 0);

      if (!isArr) {
        callback = lodash.createCallback(callback, thisArg, 3);
      }
      forEach(collection, function(value, key, collection) {
        var object = result[++index] = getObject();
        if (isArr) {
          object.criteria = map(callback, function(key) { return value[key]; });
        } else {
          (object.criteria = getArray())[0] = callback(value, key, collection);
        }
        object.index = index;
        object.value = value;
      });

      length = result.length;
      result.sort(compareAscending);
      while (length--) {
        var object = result[length];
        result[length] = object.value;
        if (!isArr) {
          releaseArray(object.criteria);
        }
        releaseObject(object);
      }
      return result;
    }

    /**
     * Converts the `collection` to an array.
     *
     * @static
     * @memberOf _
     * @category Collections
     * @param {Array|Object|string} collection The collection to convert.
     * @returns {Array} Returns the new converted array.
     * @example
     *
     * (function() { return _.toArray(arguments).slice(1); })(1, 2, 3, 4);
     * // => [2, 3, 4]
     */
    function toArray(collection) {
      if (collection && typeof collection.length == 'number') {
        return slice(collection);
      }
      return values(collection);
    }

    /**
     * Performs a deep comparison of each element in a `collection` to the given
     * `properties` object, returning an array of all elements that have equivalent
     * property values.
     *
     * @static
     * @memberOf _
     * @type Function
     * @category Collections
     * @param {Array|Object|string} collection The collection to iterate over.
     * @param {Object} props The object of property values to filter by.
     * @returns {Array} Returns a new array of elements that have the given properties.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36, 'pets': ['hoppy'] },
     *   { 'name': 'fred',   'age': 40, 'pets': ['baby puss', 'dino'] }
     * ];
     *
     * _.where(characters, { 'age': 36 });
     * // => [{ 'name': 'barney', 'age': 36, 'pets': ['hoppy'] }]
     *
     * _.where(characters, { 'pets': ['dino'] });
     * // => [{ 'name': 'fred', 'age': 40, 'pets': ['baby puss', 'dino'] }]
     */
    var where = filter;

    /*--------------------------------------------------------------------------*/

    /**
     * Creates an array with all falsey values removed. The values `false`, `null`,
     * `0`, `""`, `undefined`, and `NaN` are all falsey.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to compact.
     * @returns {Array} Returns a new array of filtered values.
     * @example
     *
     * _.compact([0, 1, false, 2, '', 3]);
     * // => [1, 2, 3]
     */
    function compact(array) {
      var index = -1,
          length = array ? array.length : 0,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (value) {
          result.push(value);
        }
      }
      return result;
    }

    /**
     * Creates an array excluding all values of the provided arrays using strict
     * equality for comparisons, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to process.
     * @param {...Array} [values] The arrays of values to exclude.
     * @returns {Array} Returns a new array of filtered values.
     * @example
     *
     * _.difference([1, 2, 3, 4, 5], [5, 2, 10]);
     * // => [1, 3, 4]
     */
    function difference(array) {
      return baseDifference(array, baseFlatten(arguments, true, true, 1));
    }

    /**
     * This method is like `_.find` except that it returns the index of the first
     * element that passes the callback check, instead of the element itself.
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to search.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney',  'age': 36, 'blocked': false },
     *   { 'name': 'fred',    'age': 40, 'blocked': true },
     *   { 'name': 'pebbles', 'age': 1,  'blocked': false }
     * ];
     *
     * _.findIndex(characters, function(chr) {
     *   return chr.age < 20;
     * });
     * // => 2
     *
     * // using "_.where" callback shorthand
     * _.findIndex(characters, { 'age': 36 });
     * // => 0
     *
     * // using "_.pluck" callback shorthand
     * _.findIndex(characters, 'blocked');
     * // => 1
     */
    function findIndex(array, callback, thisArg) {
      var index = -1,
          length = array ? array.length : 0;

      callback = lodash.createCallback(callback, thisArg, 3);
      while (++index < length) {
        if (callback(array[index], index, array)) {
          return index;
        }
      }
      return -1;
    }

    /**
     * This method is like `_.findIndex` except that it iterates over elements
     * of a `collection` from right to left.
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to search.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney',  'age': 36, 'blocked': true },
     *   { 'name': 'fred',    'age': 40, 'blocked': false },
     *   { 'name': 'pebbles', 'age': 1,  'blocked': true }
     * ];
     *
     * _.findLastIndex(characters, function(chr) {
     *   return chr.age > 30;
     * });
     * // => 1
     *
     * // using "_.where" callback shorthand
     * _.findLastIndex(characters, { 'age': 36 });
     * // => 0
     *
     * // using "_.pluck" callback shorthand
     * _.findLastIndex(characters, 'blocked');
     * // => 2
     */
    function findLastIndex(array, callback, thisArg) {
      var length = array ? array.length : 0;
      callback = lodash.createCallback(callback, thisArg, 3);
      while (length--) {
        if (callback(array[length], length, array)) {
          return length;
        }
      }
      return -1;
    }

    /**
     * Gets the first element or first `n` elements of an array. If a callback
     * is provided elements at the beginning of the array are returned as long
     * as the callback returns truey. The callback is bound to `thisArg` and
     * invoked with three arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias head, take
     * @category Arrays
     * @param {Array} array The array to query.
     * @param {Function|Object|number|string} [callback] The function called
     *  per element or the number of elements to return. If a property name or
     *  object is provided it will be used to create a "_.pluck" or "_.where"
     *  style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the first element(s) of `array`.
     * @example
     *
     * _.first([1, 2, 3]);
     * // => 1
     *
     * _.first([1, 2, 3], 2);
     * // => [1, 2]
     *
     * _.first([1, 2, 3], function(num) {
     *   return num < 3;
     * });
     * // => [1, 2]
     *
     * var characters = [
     *   { 'name': 'barney',  'blocked': true,  'employer': 'slate' },
     *   { 'name': 'fred',    'blocked': false, 'employer': 'slate' },
     *   { 'name': 'pebbles', 'blocked': true,  'employer': 'na' }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.first(characters, 'blocked');
     * // => [{ 'name': 'barney', 'blocked': true, 'employer': 'slate' }]
     *
     * // using "_.where" callback shorthand
     * _.pluck(_.first(characters, { 'employer': 'slate' }), 'name');
     * // => ['barney', 'fred']
     */
    function first(array, callback, thisArg) {
      var n = 0,
          length = array ? array.length : 0;

      if (typeof callback != 'number' && callback != null) {
        var index = -1;
        callback = lodash.createCallback(callback, thisArg, 3);
        while (++index < length && callback(array[index], index, array)) {
          n++;
        }
      } else {
        n = callback;
        if (n == null || thisArg) {
          return array ? array[0] : undefined;
        }
      }
      return slice(array, 0, nativeMin(nativeMax(0, n), length));
    }

    /**
     * Flattens a nested array (the nesting can be to any depth). If `isShallow`
     * is truey, the array will only be flattened a single level. If a callback
     * is provided each element of the array is passed through the callback before
     * flattening. The callback is bound to `thisArg` and invoked with three
     * arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to flatten.
     * @param {boolean} [isShallow=false] A flag to restrict flattening to a single level.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new flattened array.
     * @example
     *
     * _.flatten([1, [2], [3, [[4]]]]);
     * // => [1, 2, 3, 4];
     *
     * _.flatten([1, [2], [3, [[4]]]], true);
     * // => [1, 2, 3, [[4]]];
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 30, 'pets': ['hoppy'] },
     *   { 'name': 'fred',   'age': 40, 'pets': ['baby puss', 'dino'] }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.flatten(characters, 'pets');
     * // => ['hoppy', 'baby puss', 'dino']
     */
    function flatten(array, isShallow, callback, thisArg) {
      // juggle arguments
      if (typeof isShallow != 'boolean' && isShallow != null) {
        thisArg = callback;
        callback = (typeof isShallow != 'function' && thisArg && thisArg[isShallow] === array) ? null : isShallow;
        isShallow = false;
      }
      if (callback != null) {
        array = map(array, callback, thisArg);
      }
      return baseFlatten(array, isShallow);
    }

    /**
     * Gets the index at which the first occurrence of `value` is found using
     * strict equality for comparisons, i.e. `===`. If the array is already sorted
     * providing `true` for `fromIndex` will run a faster binary search.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to search.
     * @param {*} value The value to search for.
     * @param {boolean|number} [fromIndex=0] The index to search from or `true`
     *  to perform a binary search on a sorted array.
     * @returns {number} Returns the index of the matched value or `-1`.
     * @example
     *
     * _.indexOf([1, 2, 3, 1, 2, 3], 2);
     * // => 1
     *
     * _.indexOf([1, 2, 3, 1, 2, 3], 2, 3);
     * // => 4
     *
     * _.indexOf([1, 1, 2, 2, 3, 3], 2, true);
     * // => 2
     */
    function indexOf(array, value, fromIndex) {
      if (typeof fromIndex == 'number') {
        var length = array ? array.length : 0;
        fromIndex = (fromIndex < 0 ? nativeMax(0, length + fromIndex) : fromIndex || 0);
      } else if (fromIndex) {
        var index = sortedIndex(array, value);
        return array[index] === value ? index : -1;
      }
      return baseIndexOf(array, value, fromIndex);
    }

    /**
     * Gets all but the last element or last `n` elements of an array. If a
     * callback is provided elements at the end of the array are excluded from
     * the result as long as the callback returns truey. The callback is bound
     * to `thisArg` and invoked with three arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to query.
     * @param {Function|Object|number|string} [callback=1] The function called
     *  per element or the number of elements to exclude. If a property name or
     *  object is provided it will be used to create a "_.pluck" or "_.where"
     *  style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a slice of `array`.
     * @example
     *
     * _.initial([1, 2, 3]);
     * // => [1, 2]
     *
     * _.initial([1, 2, 3], 2);
     * // => [1]
     *
     * _.initial([1, 2, 3], function(num) {
     *   return num > 1;
     * });
     * // => [1]
     *
     * var characters = [
     *   { 'name': 'barney',  'blocked': false, 'employer': 'slate' },
     *   { 'name': 'fred',    'blocked': true,  'employer': 'slate' },
     *   { 'name': 'pebbles', 'blocked': true,  'employer': 'na' }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.initial(characters, 'blocked');
     * // => [{ 'name': 'barney',  'blocked': false, 'employer': 'slate' }]
     *
     * // using "_.where" callback shorthand
     * _.pluck(_.initial(characters, { 'employer': 'na' }), 'name');
     * // => ['barney', 'fred']
     */
    function initial(array, callback, thisArg) {
      var n = 0,
          length = array ? array.length : 0;

      if (typeof callback != 'number' && callback != null) {
        var index = length;
        callback = lodash.createCallback(callback, thisArg, 3);
        while (index-- && callback(array[index], index, array)) {
          n++;
        }
      } else {
        n = (callback == null || thisArg) ? 1 : callback || n;
      }
      return slice(array, 0, nativeMin(nativeMax(0, length - n), length));
    }

    /**
     * Creates an array of unique values present in all provided arrays using
     * strict equality for comparisons, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {...Array} [array] The arrays to inspect.
     * @returns {Array} Returns an array of shared values.
     * @example
     *
     * _.intersection([1, 2, 3], [5, 2, 1, 4], [2, 1]);
     * // => [1, 2]
     */
    function intersection() {
      var args = [],
          argsIndex = -1,
          argsLength = arguments.length,
          caches = getArray(),
          indexOf = getIndexOf(),
          trustIndexOf = indexOf === baseIndexOf,
          seen = getArray();

      while (++argsIndex < argsLength) {
        var value = arguments[argsIndex];
        if (isArray(value) || isArguments(value)) {
          args.push(value);
          caches.push(trustIndexOf && value.length >= largeArraySize &&
            createCache(argsIndex ? args[argsIndex] : seen));
        }
      }
      var array = args[0],
          index = -1,
          length = array ? array.length : 0,
          result = [];

      outer:
      while (++index < length) {
        var cache = caches[0];
        value = array[index];

        if ((cache ? cacheIndexOf(cache, value) : indexOf(seen, value)) < 0) {
          argsIndex = argsLength;
          (cache || seen).push(value);
          while (--argsIndex) {
            cache = caches[argsIndex];
            if ((cache ? cacheIndexOf(cache, value) : indexOf(args[argsIndex], value)) < 0) {
              continue outer;
            }
          }
          result.push(value);
        }
      }
      while (argsLength--) {
        cache = caches[argsLength];
        if (cache) {
          releaseObject(cache);
        }
      }
      releaseArray(caches);
      releaseArray(seen);
      return result;
    }

    /**
     * Gets the last element or last `n` elements of an array. If a callback is
     * provided elements at the end of the array are returned as long as the
     * callback returns truey. The callback is bound to `thisArg` and invoked
     * with three arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to query.
     * @param {Function|Object|number|string} [callback] The function called
     *  per element or the number of elements to return. If a property name or
     *  object is provided it will be used to create a "_.pluck" or "_.where"
     *  style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {*} Returns the last element(s) of `array`.
     * @example
     *
     * _.last([1, 2, 3]);
     * // => 3
     *
     * _.last([1, 2, 3], 2);
     * // => [2, 3]
     *
     * _.last([1, 2, 3], function(num) {
     *   return num > 1;
     * });
     * // => [2, 3]
     *
     * var characters = [
     *   { 'name': 'barney',  'blocked': false, 'employer': 'slate' },
     *   { 'name': 'fred',    'blocked': true,  'employer': 'slate' },
     *   { 'name': 'pebbles', 'blocked': true,  'employer': 'na' }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.pluck(_.last(characters, 'blocked'), 'name');
     * // => ['fred', 'pebbles']
     *
     * // using "_.where" callback shorthand
     * _.last(characters, { 'employer': 'na' });
     * // => [{ 'name': 'pebbles', 'blocked': true, 'employer': 'na' }]
     */
    function last(array, callback, thisArg) {
      var n = 0,
          length = array ? array.length : 0;

      if (typeof callback != 'number' && callback != null) {
        var index = length;
        callback = lodash.createCallback(callback, thisArg, 3);
        while (index-- && callback(array[index], index, array)) {
          n++;
        }
      } else {
        n = callback;
        if (n == null || thisArg) {
          return array ? array[length - 1] : undefined;
        }
      }
      return slice(array, nativeMax(0, length - n));
    }

    /**
     * Gets the index at which the last occurrence of `value` is found using strict
     * equality for comparisons, i.e. `===`. If `fromIndex` is negative, it is used
     * as the offset from the end of the collection.
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to search.
     * @param {*} value The value to search for.
     * @param {number} [fromIndex=array.length-1] The index to search from.
     * @returns {number} Returns the index of the matched value or `-1`.
     * @example
     *
     * _.lastIndexOf([1, 2, 3, 1, 2, 3], 2);
     * // => 4
     *
     * _.lastIndexOf([1, 2, 3, 1, 2, 3], 2, 3);
     * // => 1
     */
    function lastIndexOf(array, value, fromIndex) {
      var index = array ? array.length : 0;
      if (typeof fromIndex == 'number') {
        index = (fromIndex < 0 ? nativeMax(0, index + fromIndex) : nativeMin(fromIndex, index - 1)) + 1;
      }
      while (index--) {
        if (array[index] === value) {
          return index;
        }
      }
      return -1;
    }

    /**
     * Removes all provided values from the given array using strict equality for
     * comparisons, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to modify.
     * @param {...*} [value] The values to remove.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3, 1, 2, 3];
     * _.pull(array, 2, 3);
     * console.log(array);
     * // => [1, 1]
     */
    function pull(array) {
      var args = arguments,
          argsIndex = 0,
          argsLength = args.length,
          length = array ? array.length : 0;

      while (++argsIndex < argsLength) {
        var index = -1,
            value = args[argsIndex];
        while (++index < length) {
          if (array[index] === value) {
            splice.call(array, index--, 1);
            length--;
          }
        }
      }
      return array;
    }

    /**
     * Creates an array of numbers (positive and/or negative) progressing from
     * `start` up to but not including `end`. If `start` is less than `stop` a
     * zero-length range is created unless a negative `step` is specified.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {number} [start=0] The start of the range.
     * @param {number} end The end of the range.
     * @param {number} [step=1] The value to increment or decrement by.
     * @returns {Array} Returns a new range array.
     * @example
     *
     * _.range(4);
     * // => [0, 1, 2, 3]
     *
     * _.range(1, 5);
     * // => [1, 2, 3, 4]
     *
     * _.range(0, 20, 5);
     * // => [0, 5, 10, 15]
     *
     * _.range(0, -4, -1);
     * // => [0, -1, -2, -3]
     *
     * _.range(1, 4, 0);
     * // => [1, 1, 1]
     *
     * _.range(0);
     * // => []
     */
    function range(start, end, step) {
      start = +start || 0;
      step = typeof step == 'number' ? step : (+step || 1);

      if (end == null) {
        end = start;
        start = 0;
      }
      // use `Array(length)` so engines like Chakra and V8 avoid slower modes
      // http://youtu.be/XAqIpGU8ZZk#t=17m25s
      var index = -1,
          length = nativeMax(0, ceil((end - start) / (step || 1))),
          result = Array(length);

      while (++index < length) {
        result[index] = start;
        start += step;
      }
      return result;
    }

    /**
     * Removes all elements from an array that the callback returns truey for
     * and returns an array of removed elements. The callback is bound to `thisArg`
     * and invoked with three arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to modify.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a new array of removed elements.
     * @example
     *
     * var array = [1, 2, 3, 4, 5, 6];
     * var evens = _.remove(array, function(num) { return num % 2 == 0; });
     *
     * console.log(array);
     * // => [1, 3, 5]
     *
     * console.log(evens);
     * // => [2, 4, 6]
     */
    function remove(array, callback, thisArg) {
      var index = -1,
          length = array ? array.length : 0,
          result = [];

      callback = lodash.createCallback(callback, thisArg, 3);
      while (++index < length) {
        var value = array[index];
        if (callback(value, index, array)) {
          result.push(value);
          splice.call(array, index--, 1);
          length--;
        }
      }
      return result;
    }

    /**
     * The opposite of `_.initial` this method gets all but the first element or
     * first `n` elements of an array. If a callback function is provided elements
     * at the beginning of the array are excluded from the result as long as the
     * callback returns truey. The callback is bound to `thisArg` and invoked
     * with three arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias drop, tail
     * @category Arrays
     * @param {Array} array The array to query.
     * @param {Function|Object|number|string} [callback=1] The function called
     *  per element or the number of elements to exclude. If a property name or
     *  object is provided it will be used to create a "_.pluck" or "_.where"
     *  style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a slice of `array`.
     * @example
     *
     * _.rest([1, 2, 3]);
     * // => [2, 3]
     *
     * _.rest([1, 2, 3], 2);
     * // => [3]
     *
     * _.rest([1, 2, 3], function(num) {
     *   return num < 3;
     * });
     * // => [3]
     *
     * var characters = [
     *   { 'name': 'barney',  'blocked': true,  'employer': 'slate' },
     *   { 'name': 'fred',    'blocked': false,  'employer': 'slate' },
     *   { 'name': 'pebbles', 'blocked': true, 'employer': 'na' }
     * ];
     *
     * // using "_.pluck" callback shorthand
     * _.pluck(_.rest(characters, 'blocked'), 'name');
     * // => ['fred', 'pebbles']
     *
     * // using "_.where" callback shorthand
     * _.rest(characters, { 'employer': 'slate' });
     * // => [{ 'name': 'pebbles', 'blocked': true, 'employer': 'na' }]
     */
    function rest(array, callback, thisArg) {
      if (typeof callback != 'number' && callback != null) {
        var n = 0,
            index = -1,
            length = array ? array.length : 0;

        callback = lodash.createCallback(callback, thisArg, 3);
        while (++index < length && callback(array[index], index, array)) {
          n++;
        }
      } else {
        n = (callback == null || thisArg) ? 1 : nativeMax(0, callback);
      }
      return slice(array, n);
    }

    /**
     * Uses a binary search to determine the smallest index at which a value
     * should be inserted into a given sorted array in order to maintain the sort
     * order of the array. If a callback is provided it will be executed for
     * `value` and each element of `array` to compute their sort ranking. The
     * callback is bound to `thisArg` and invoked with one argument; (value).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedIndex([20, 30, 50], 40);
     * // => 2
     *
     * // using "_.pluck" callback shorthand
     * _.sortedIndex([{ 'x': 20 }, { 'x': 30 }, { 'x': 50 }], { 'x': 40 }, 'x');
     * // => 2
     *
     * var dict = {
     *   'wordToNumber': { 'twenty': 20, 'thirty': 30, 'fourty': 40, 'fifty': 50 }
     * };
     *
     * _.sortedIndex(['twenty', 'thirty', 'fifty'], 'fourty', function(word) {
     *   return dict.wordToNumber[word];
     * });
     * // => 2
     *
     * _.sortedIndex(['twenty', 'thirty', 'fifty'], 'fourty', function(word) {
     *   return this.wordToNumber[word];
     * }, dict);
     * // => 2
     */
    function sortedIndex(array, value, callback, thisArg) {
      var low = 0,
          high = array ? array.length : low;

      // explicitly reference `identity` for better inlining in Firefox
      callback = callback ? lodash.createCallback(callback, thisArg, 1) : identity;
      value = callback(value);

      while (low < high) {
        var mid = (low + high) >>> 1;
        (callback(array[mid]) < value)
          ? low = mid + 1
          : high = mid;
      }
      return low;
    }

    /**
     * Creates an array of unique values, in order, of the provided arrays using
     * strict equality for comparisons, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {...Array} [array] The arrays to inspect.
     * @returns {Array} Returns an array of combined values.
     * @example
     *
     * _.union([1, 2, 3], [5, 2, 1, 4], [2, 1]);
     * // => [1, 2, 3, 5, 4]
     */
    function union() {
      return baseUniq(baseFlatten(arguments, true, true));
    }

    /**
     * Creates a duplicate-value-free version of an array using strict equality
     * for comparisons, i.e. `===`. If the array is sorted, providing
     * `true` for `isSorted` will use a faster algorithm. If a callback is provided
     * each element of `array` is passed through the callback before uniqueness
     * is computed. The callback is bound to `thisArg` and invoked with three
     * arguments; (value, index, array).
     *
     * If a property name is provided for `callback` the created "_.pluck" style
     * callback will return the property value of the given element.
     *
     * If an object is provided for `callback` the created "_.where" style callback
     * will return `true` for elements that have the properties of the given object,
     * else `false`.
     *
     * @static
     * @memberOf _
     * @alias unique
     * @category Arrays
     * @param {Array} array The array to process.
     * @param {boolean} [isSorted=false] A flag to indicate that `array` is sorted.
     * @param {Function|Object|string} [callback=identity] The function called
     *  per iteration. If a property name or object is provided it will be used
     *  to create a "_.pluck" or "_.where" style callback, respectively.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns a duplicate-value-free array.
     * @example
     *
     * _.uniq([1, 2, 1, 3, 1]);
     * // => [1, 2, 3]
     *
     * _.uniq([1, 1, 2, 2, 3], true);
     * // => [1, 2, 3]
     *
     * _.uniq(['A', 'b', 'C', 'a', 'B', 'c'], function(letter) { return letter.toLowerCase(); });
     * // => ['A', 'b', 'C']
     *
     * _.uniq([1, 2.5, 3, 1.5, 2, 3.5], function(num) { return this.floor(num); }, Math);
     * // => [1, 2.5, 3]
     *
     * // using "_.pluck" callback shorthand
     * _.uniq([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 1 }, { 'x': 2 }]
     */
    function uniq(array, isSorted, callback, thisArg) {
      // juggle arguments
      if (typeof isSorted != 'boolean' && isSorted != null) {
        thisArg = callback;
        callback = (typeof isSorted != 'function' && thisArg && thisArg[isSorted] === array) ? null : isSorted;
        isSorted = false;
      }
      if (callback != null) {
        callback = lodash.createCallback(callback, thisArg, 3);
      }
      return baseUniq(array, isSorted, callback);
    }

    /**
     * Creates an array excluding all provided values using strict equality for
     * comparisons, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {Array} array The array to filter.
     * @param {...*} [value] The values to exclude.
     * @returns {Array} Returns a new array of filtered values.
     * @example
     *
     * _.without([1, 2, 1, 0, 3, 1, 4], 0, 1);
     * // => [2, 3, 4]
     */
    function without(array) {
      return baseDifference(array, slice(arguments, 1));
    }

    /**
     * Creates an array that is the symmetric difference of the provided arrays.
     * See http://en.wikipedia.org/wiki/Symmetric_difference.
     *
     * @static
     * @memberOf _
     * @category Arrays
     * @param {...Array} [array] The arrays to inspect.
     * @returns {Array} Returns an array of values.
     * @example
     *
     * _.xor([1, 2, 3], [5, 2, 1, 4]);
     * // => [3, 5, 4]
     *
     * _.xor([1, 2, 5], [2, 3, 5], [3, 4, 5]);
     * // => [1, 4, 5]
     */
    function xor() {
      var index = -1,
          length = arguments.length;

      while (++index < length) {
        var array = arguments[index];
        if (isArray(array) || isArguments(array)) {
          var result = result
            ? baseUniq(baseDifference(result, array).concat(baseDifference(array, result)))
            : array;
        }
      }
      return result || [];
    }

    /**
     * Creates an array of grouped elements, the first of which contains the first
     * elements of the given arrays, the second of which contains the second
     * elements of the given arrays, and so on.
     *
     * @static
     * @memberOf _
     * @alias unzip
     * @category Arrays
     * @param {...Array} [array] Arrays to process.
     * @returns {Array} Returns a new array of grouped elements.
     * @example
     *
     * _.zip(['fred', 'barney'], [30, 40], [true, false]);
     * // => [['fred', 30, true], ['barney', 40, false]]
     */
    function zip() {
      var array = arguments.length > 1 ? arguments : arguments[0],
          index = -1,
          length = array ? max(pluck(array, 'length')) : 0,
          result = Array(length < 0 ? 0 : length);

      while (++index < length) {
        result[index] = pluck(array, index);
      }
      return result;
    }

    /**
     * Creates an object composed from arrays of `keys` and `values`. Provide
     * either a single two dimensional array, i.e. `[[key1, value1], [key2, value2]]`
     * or two arrays, one of `keys` and one of corresponding `values`.
     *
     * @static
     * @memberOf _
     * @alias object
     * @category Arrays
     * @param {Array} keys The array of keys.
     * @param {Array} [values=[]] The array of values.
     * @returns {Object} Returns an object composed of the given keys and
     *  corresponding values.
     * @example
     *
     * _.zipObject(['fred', 'barney'], [30, 40]);
     * // => { 'fred': 30, 'barney': 40 }
     */
    function zipObject(keys, values) {
      var index = -1,
          length = keys ? keys.length : 0,
          result = {};

      if (!values && length && !isArray(keys[0])) {
        values = [];
      }
      while (++index < length) {
        var key = keys[index];
        if (values) {
          result[key] = values[index];
        } else if (key) {
          result[key[0]] = key[1];
        }
      }
      return result;
    }

    /*--------------------------------------------------------------------------*/

    /**
     * Creates a function that executes `func`, with  the `this` binding and
     * arguments of the created function, only after being called `n` times.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {number} n The number of times the function must be called before
     *  `func` is executed.
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * var saves = ['profile', 'settings'];
     *
     * var done = _.after(saves.length, function() {
     *   console.log('Done saving!');
     * });
     *
     * _.forEach(saves, function(type) {
     *   asyncSave({ 'type': type, 'complete': done });
     * });
     * // => logs 'Done saving!', after all saves have completed
     */
    function after(n, func) {
      if (!isFunction(func)) {
        throw new TypeError;
      }
      return function() {
        if (--n < 1) {
          return func.apply(this, arguments);
        }
      };
    }

    /**
     * Creates a function that, when called, invokes `func` with the `this`
     * binding of `thisArg` and prepends any additional `bind` arguments to those
     * provided to the bound function.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to bind.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {...*} [arg] Arguments to be partially applied.
     * @returns {Function} Returns the new bound function.
     * @example
     *
     * var func = function(greeting) {
     *   return greeting + ' ' + this.name;
     * };
     *
     * func = _.bind(func, { 'name': 'fred' }, 'hi');
     * func();
     * // => 'hi fred'
     */
    function bind(func, thisArg) {
      return arguments.length > 2
        ? createWrapper(func, 17, slice(arguments, 2), null, thisArg)
        : createWrapper(func, 1, null, null, thisArg);
    }

    /**
     * Binds methods of an object to the object itself, overwriting the existing
     * method. Method names may be specified as individual arguments or as arrays
     * of method names. If no method names are provided all the function properties
     * of `object` will be bound.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Object} object The object to bind and assign the bound methods to.
     * @param {...string} [methodName] The object method names to
     *  bind, specified as individual method names or arrays of method names.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var view = {
     *   'label': 'docs',
     *   'onClick': function() { console.log('clicked ' + this.label); }
     * };
     *
     * _.bindAll(view);
     * jQuery('#docs').on('click', view.onClick);
     * // => logs 'clicked docs', when the button is clicked
     */
    function bindAll(object) {
      var funcs = arguments.length > 1 ? baseFlatten(arguments, true, false, 1) : functions(object),
          index = -1,
          length = funcs.length;

      while (++index < length) {
        var key = funcs[index];
        object[key] = createWrapper(object[key], 1, null, null, object);
      }
      return object;
    }

    /**
     * Creates a function that, when called, invokes the method at `object[key]`
     * and prepends any additional `bindKey` arguments to those provided to the bound
     * function. This method differs from `_.bind` by allowing bound functions to
     * reference methods that will be redefined or don't yet exist.
     * See http://michaux.ca/articles/lazy-function-definition-pattern.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Object} object The object the method belongs to.
     * @param {string} key The key of the method.
     * @param {...*} [arg] Arguments to be partially applied.
     * @returns {Function} Returns the new bound function.
     * @example
     *
     * var object = {
     *   'name': 'fred',
     *   'greet': function(greeting) {
     *     return greeting + ' ' + this.name;
     *   }
     * };
     *
     * var func = _.bindKey(object, 'greet', 'hi');
     * func();
     * // => 'hi fred'
     *
     * object.greet = function(greeting) {
     *   return greeting + 'ya ' + this.name + '!';
     * };
     *
     * func();
     * // => 'hiya fred!'
     */
    function bindKey(object, key) {
      return arguments.length > 2
        ? createWrapper(key, 19, slice(arguments, 2), null, object)
        : createWrapper(key, 3, null, null, object);
    }

    /**
     * Creates a function that is the composition of the provided functions,
     * where each function consumes the return value of the function that follows.
     * For example, composing the functions `f()`, `g()`, and `h()` produces `f(g(h()))`.
     * Each function is executed with the `this` binding of the composed function.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {...Function} [func] Functions to compose.
     * @returns {Function} Returns the new composed function.
     * @example
     *
     * var realNameMap = {
     *   'pebbles': 'penelope'
     * };
     *
     * var format = function(name) {
     *   name = realNameMap[name.toLowerCase()] || name;
     *   return name.charAt(0).toUpperCase() + name.slice(1).toLowerCase();
     * };
     *
     * var greet = function(formatted) {
     *   return 'Hiya ' + formatted + '!';
     * };
     *
     * var welcome = _.compose(greet, format);
     * welcome('pebbles');
     * // => 'Hiya Penelope!'
     */
    function compose() {
      var funcs = arguments,
          length = funcs.length;

      while (length--) {
        if (!isFunction(funcs[length])) {
          throw new TypeError;
        }
      }
      return function() {
        var args = arguments,
            length = funcs.length;

        while (length--) {
          args = [funcs[length].apply(this, args)];
        }
        return args[0];
      };
    }

    /**
     * Creates a function which accepts one or more arguments of `func` that when
     * invoked either executes `func` returning its result, if all `func` arguments
     * have been provided, or returns a function that accepts one or more of the
     * remaining `func` arguments, and so on. The arity of `func` can be specified
     * if `func.length` is not sufficient.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to curry.
     * @param {number} [arity=func.length] The arity of `func`.
     * @returns {Function} Returns the new curried function.
     * @example
     *
     * var curried = _.curry(function(a, b, c) {
     *   console.log(a + b + c);
     * });
     *
     * curried(1)(2)(3);
     * // => 6
     *
     * curried(1, 2)(3);
     * // => 6
     *
     * curried(1, 2, 3);
     * // => 6
     */
    function curry(func, arity) {
      arity = typeof arity == 'number' ? arity : (+arity || func.length);
      return createWrapper(func, 4, null, null, null, arity);
    }

    /**
     * Creates a function that will delay the execution of `func` until after
     * `wait` milliseconds have elapsed since the last time it was invoked.
     * Provide an options object to indicate that `func` should be invoked on
     * the leading and/or trailing edge of the `wait` timeout. Subsequent calls
     * to the debounced function will return the result of the last `func` call.
     *
     * Note: If `leading` and `trailing` options are `true` `func` will be called
     * on the trailing edge of the timeout only if the the debounced function is
     * invoked more than once during the `wait` timeout.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to debounce.
     * @param {number} wait The number of milliseconds to delay.
     * @param {Object} [options] The options object.
     * @param {boolean} [options.leading=false] Specify execution on the leading edge of the timeout.
     * @param {number} [options.maxWait] The maximum time `func` is allowed to be delayed before it's called.
     * @param {boolean} [options.trailing=true] Specify execution on the trailing edge of the timeout.
     * @returns {Function} Returns the new debounced function.
     * @example
     *
     * // avoid costly calculations while the window size is in flux
     * var lazyLayout = _.debounce(calculateLayout, 150);
     * jQuery(window).on('resize', lazyLayout);
     *
     * // execute `sendMail` when the click event is fired, debouncing subsequent calls
     * jQuery('#postbox').on('click', _.debounce(sendMail, 300, {
     *   'leading': true,
     *   'trailing': false
     * });
     *
     * // ensure `batchLog` is executed once after 1 second of debounced calls
     * var source = new EventSource('/stream');
     * source.addEventListener('message', _.debounce(batchLog, 250, {
     *   'maxWait': 1000
     * }, false);
     */
    function debounce(func, wait, options) {
      var args,
          maxTimeoutId,
          result,
          stamp,
          thisArg,
          timeoutId,
          trailingCall,
          lastCalled = 0,
          maxWait = false,
          trailing = true;

      if (!isFunction(func)) {
        throw new TypeError;
      }
      wait = nativeMax(0, wait) || 0;
      if (options === true) {
        var leading = true;
        trailing = false;
      } else if (isObject(options)) {
        leading = options.leading;
        maxWait = 'maxWait' in options && (nativeMax(wait, options.maxWait) || 0);
        trailing = 'trailing' in options ? options.trailing : trailing;
      }
      var delayed = function() {
        var remaining = wait - (now() - stamp);
        if (remaining <= 0) {
          if (maxTimeoutId) {
            clearTimeout(maxTimeoutId);
          }
          var isCalled = trailingCall;
          maxTimeoutId = timeoutId = trailingCall = undefined;
          if (isCalled) {
            lastCalled = now();
            result = func.apply(thisArg, args);
            if (!timeoutId && !maxTimeoutId) {
              args = thisArg = null;
            }
          }
        } else {
          timeoutId = setTimeout(delayed, remaining);
        }
      };

      var maxDelayed = function() {
        if (timeoutId) {
          clearTimeout(timeoutId);
        }
        maxTimeoutId = timeoutId = trailingCall = undefined;
        if (trailing || (maxWait !== wait)) {
          lastCalled = now();
          result = func.apply(thisArg, args);
          if (!timeoutId && !maxTimeoutId) {
            args = thisArg = null;
          }
        }
      };

      return function() {
        args = arguments;
        stamp = now();
        thisArg = this;
        trailingCall = trailing && (timeoutId || !leading);

        if (maxWait === false) {
          var leadingCall = leading && !timeoutId;
        } else {
          if (!maxTimeoutId && !leading) {
            lastCalled = stamp;
          }
          var remaining = maxWait - (stamp - lastCalled),
              isCalled = remaining <= 0;

          if (isCalled) {
            if (maxTimeoutId) {
              maxTimeoutId = clearTimeout(maxTimeoutId);
            }
            lastCalled = stamp;
            result = func.apply(thisArg, args);
          }
          else if (!maxTimeoutId) {
            maxTimeoutId = setTimeout(maxDelayed, remaining);
          }
        }
        if (isCalled && timeoutId) {
          timeoutId = clearTimeout(timeoutId);
        }
        else if (!timeoutId && wait !== maxWait) {
          timeoutId = setTimeout(delayed, wait);
        }
        if (leadingCall) {
          isCalled = true;
          result = func.apply(thisArg, args);
        }
        if (isCalled && !timeoutId && !maxTimeoutId) {
          args = thisArg = null;
        }
        return result;
      };
    }

    /**
     * Defers executing the `func` function until the current call stack has cleared.
     * Additional arguments will be provided to `func` when it is invoked.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to defer.
     * @param {...*} [arg] Arguments to invoke the function with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.defer(function(text) { console.log(text); }, 'deferred');
     * // logs 'deferred' after one or more milliseconds
     */
    function defer(func) {
      if (!isFunction(func)) {
        throw new TypeError;
      }
      var args = slice(arguments, 1);
      return setTimeout(function() { func.apply(undefined, args); }, 1);
    }

    /**
     * Executes the `func` function after `wait` milliseconds. Additional arguments
     * will be provided to `func` when it is invoked.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay execution.
     * @param {...*} [arg] Arguments to invoke the function with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.delay(function(text) { console.log(text); }, 1000, 'later');
     * // => logs 'later' after one second
     */
    function delay(func, wait) {
      if (!isFunction(func)) {
        throw new TypeError;
      }
      var args = slice(arguments, 2);
      return setTimeout(function() { func.apply(undefined, args); }, wait);
    }

    /**
     * Creates a function that memoizes the result of `func`. If `resolver` is
     * provided it will be used to determine the cache key for storing the result
     * based on the arguments provided to the memoized function. By default, the
     * first argument provided to the memoized function is used as the cache key.
     * The `func` is executed with the `this` binding of the memoized function.
     * The result cache is exposed as the `cache` property on the memoized function.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to have its output memoized.
     * @param {Function} [resolver] A function used to resolve the cache key.
     * @returns {Function} Returns the new memoizing function.
     * @example
     *
     * var fibonacci = _.memoize(function(n) {
     *   return n < 2 ? n : fibonacci(n - 1) + fibonacci(n - 2);
     * });
     *
     * fibonacci(9)
     * // => 34
     *
     * var data = {
     *   'fred': { 'name': 'fred', 'age': 40 },
     *   'pebbles': { 'name': 'pebbles', 'age': 1 }
     * };
     *
     * // modifying the result cache
     * var get = _.memoize(function(name) { return data[name]; }, _.identity);
     * get('pebbles');
     * // => { 'name': 'pebbles', 'age': 1 }
     *
     * get.cache.pebbles.name = 'penelope';
     * get('pebbles');
     * // => { 'name': 'penelope', 'age': 1 }
     */
    function memoize(func, resolver) {
      if (!isFunction(func)) {
        throw new TypeError;
      }
      var memoized = function() {
        var cache = memoized.cache,
            key = resolver ? resolver.apply(this, arguments) : keyPrefix + arguments[0];

        return hasOwnProperty.call(cache, key)
          ? cache[key]
          : (cache[key] = func.apply(this, arguments));
      }
      memoized.cache = {};
      return memoized;
    }

    /**
     * Creates a function that is restricted to execute `func` once. Repeat calls to
     * the function will return the value of the first call. The `func` is executed
     * with the `this` binding of the created function.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * var initialize = _.once(createApplication);
     * initialize();
     * initialize();
     * // `initialize` executes `createApplication` once
     */
    function once(func) {
      var ran,
          result;

      if (!isFunction(func)) {
        throw new TypeError;
      }
      return function() {
        if (ran) {
          return result;
        }
        ran = true;
        result = func.apply(this, arguments);

        // clear the `func` variable so the function may be garbage collected
        func = null;
        return result;
      };
    }

    /**
     * Creates a function that, when called, invokes `func` with any additional
     * `partial` arguments prepended to those provided to the new function. This
     * method is similar to `_.bind` except it does **not** alter the `this` binding.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to partially apply arguments to.
     * @param {...*} [arg] Arguments to be partially applied.
     * @returns {Function} Returns the new partially applied function.
     * @example
     *
     * var greet = function(greeting, name) { return greeting + ' ' + name; };
     * var hi = _.partial(greet, 'hi');
     * hi('fred');
     * // => 'hi fred'
     */
    function partial(func) {
      return createWrapper(func, 16, slice(arguments, 1));
    }

    /**
     * This method is like `_.partial` except that `partial` arguments are
     * appended to those provided to the new function.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to partially apply arguments to.
     * @param {...*} [arg] Arguments to be partially applied.
     * @returns {Function} Returns the new partially applied function.
     * @example
     *
     * var defaultsDeep = _.partialRight(_.merge, _.defaults);
     *
     * var options = {
     *   'variable': 'data',
     *   'imports': { 'jq': $ }
     * };
     *
     * defaultsDeep(options, _.templateSettings);
     *
     * options.variable
     * // => 'data'
     *
     * options.imports
     * // => { '_': _, 'jq': $ }
     */
    function partialRight(func) {
      return createWrapper(func, 32, null, slice(arguments, 1));
    }

    /**
     * Creates a function that, when executed, will only call the `func` function
     * at most once per every `wait` milliseconds. Provide an options object to
     * indicate that `func` should be invoked on the leading and/or trailing edge
     * of the `wait` timeout. Subsequent calls to the throttled function will
     * return the result of the last `func` call.
     *
     * Note: If `leading` and `trailing` options are `true` `func` will be called
     * on the trailing edge of the timeout only if the the throttled function is
     * invoked more than once during the `wait` timeout.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {Function} func The function to throttle.
     * @param {number} wait The number of milliseconds to throttle executions to.
     * @param {Object} [options] The options object.
     * @param {boolean} [options.leading=true] Specify execution on the leading edge of the timeout.
     * @param {boolean} [options.trailing=true] Specify execution on the trailing edge of the timeout.
     * @returns {Function} Returns the new throttled function.
     * @example
     *
     * // avoid excessively updating the position while scrolling
     * var throttled = _.throttle(updatePosition, 100);
     * jQuery(window).on('scroll', throttled);
     *
     * // execute `renewToken` when the click event is fired, but not more than once every 5 minutes
     * jQuery('.interactive').on('click', _.throttle(renewToken, 300000, {
     *   'trailing': false
     * }));
     */
    function throttle(func, wait, options) {
      var leading = true,
          trailing = true;

      if (!isFunction(func)) {
        throw new TypeError;
      }
      if (options === false) {
        leading = false;
      } else if (isObject(options)) {
        leading = 'leading' in options ? options.leading : leading;
        trailing = 'trailing' in options ? options.trailing : trailing;
      }
      debounceOptions.leading = leading;
      debounceOptions.maxWait = wait;
      debounceOptions.trailing = trailing;

      return debounce(func, wait, debounceOptions);
    }

    /**
     * Creates a function that provides `value` to the wrapper function as its
     * first argument. Additional arguments provided to the function are appended
     * to those provided to the wrapper function. The wrapper is executed with
     * the `this` binding of the created function.
     *
     * @static
     * @memberOf _
     * @category Functions
     * @param {*} value The value to wrap.
     * @param {Function} wrapper The wrapper function.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var p = _.wrap(_.escape, function(func, text) {
     *   return '<p>' + func(text) + '</p>';
     * });
     *
     * p('Fred, Wilma, & Pebbles');
     * // => '<p>Fred, Wilma, &amp; Pebbles</p>'
     */
    function wrap(value, wrapper) {
      return createWrapper(wrapper, 16, [value]);
    }

    /*--------------------------------------------------------------------------*/

    /**
     * Creates a function that returns `value`.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {*} value The value to return from the new function.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var object = { 'name': 'fred' };
     * var getter = _.constant(object);
     * getter() === object;
     * // => true
     */
    function constant(value) {
      return function() {
        return value;
      };
    }

    /**
     * Produces a callback bound to an optional `thisArg`. If `func` is a property
     * name the created callback will return the property value for a given element.
     * If `func` is an object the created callback will return `true` for elements
     * that contain the equivalent object properties, otherwise it will return `false`.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {*} [func=identity] The value to convert to a callback.
     * @param {*} [thisArg] The `this` binding of the created callback.
     * @param {number} [argCount] The number of arguments the callback accepts.
     * @returns {Function} Returns a callback function.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * // wrap to create custom callback shorthands
     * _.createCallback = _.wrap(_.createCallback, function(func, callback, thisArg) {
     *   var match = /^(.+?)__([gl]t)(.+)$/.exec(callback);
     *   return !match ? func(callback, thisArg) : function(object) {
     *     return match[2] == 'gt' ? object[match[1]] > match[3] : object[match[1]] < match[3];
     *   };
     * });
     *
     * _.filter(characters, 'age__gt38');
     * // => [{ 'name': 'fred', 'age': 40 }]
     */
    function createCallback(func, thisArg, argCount) {
      var type = typeof func;
      if (func == null || type == 'function') {
        return baseCreateCallback(func, thisArg, argCount);
      }
      // handle "_.pluck" style callback shorthands
      if (type != 'object') {
        return property(func);
      }
      var props = keys(func),
          key = props[0],
          a = func[key];

      // handle "_.where" style callback shorthands
      if (props.length == 1 && a === a && !isObject(a)) {
        // fast path the common case of providing an object with a single
        // property containing a primitive value
        return function(object) {
          var b = object[key];
          return a === b && (a !== 0 || (1 / a == 1 / b));
        };
      }
      return function(object) {
        var length = props.length,
            result = false;

        while (length--) {
          if (!(result = baseIsEqual(object[props[length]], func[props[length]], null, true))) {
            break;
          }
        }
        return result;
      };
    }

    /**
     * Converts the characters `&`, `<`, `>`, `"`, and `'` in `string` to their
     * corresponding HTML entities.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {string} string The string to escape.
     * @returns {string} Returns the escaped string.
     * @example
     *
     * _.escape('Fred, Wilma, & Pebbles');
     * // => 'Fred, Wilma, &amp; Pebbles'
     */
    function escape(string) {
      return string == null ? '' : String(string).replace(reUnescapedHtml, escapeHtmlChar);
    }

    /**
     * This method returns the first argument provided to it.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {*} value Any value.
     * @returns {*} Returns `value`.
     * @example
     *
     * var object = { 'name': 'fred' };
     * _.identity(object) === object;
     * // => true
     */
    function identity(value) {
      return value;
    }

    /**
     * Adds function properties of a source object to the destination object.
     * If `object` is a function methods will be added to its prototype as well.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {Function|Object} [object=lodash] object The destination object.
     * @param {Object} source The object of functions to add.
     * @param {Object} [options] The options object.
     * @param {boolean} [options.chain=true] Specify whether the functions added are chainable.
     * @example
     *
     * function capitalize(string) {
     *   return string.charAt(0).toUpperCase() + string.slice(1).toLowerCase();
     * }
     *
     * _.mixin({ 'capitalize': capitalize });
     * _.capitalize('fred');
     * // => 'Fred'
     *
     * _('fred').capitalize().value();
     * // => 'Fred'
     *
     * _.mixin({ 'capitalize': capitalize }, { 'chain': false });
     * _('fred').capitalize();
     * // => 'Fred'
     */
    function mixin(object, source, options) {
      var chain = true,
          methodNames = source && functions(source);

      if (!source || (!options && !methodNames.length)) {
        if (options == null) {
          options = source;
        }
        ctor = lodashWrapper;
        source = object;
        object = lodash;
        methodNames = functions(source);
      }
      if (options === false) {
        chain = false;
      } else if (isObject(options) && 'chain' in options) {
        chain = options.chain;
      }
      var ctor = object,
          isFunc = isFunction(ctor);

      forEach(methodNames, function(methodName) {
        var func = object[methodName] = source[methodName];
        if (isFunc) {
          ctor.prototype[methodName] = function() {
            var chainAll = this.__chain__,
                value = this.__wrapped__,
                args = [value];

            push.apply(args, arguments);
            var result = func.apply(object, args);
            if (chain || chainAll) {
              if (value === result && isObject(result)) {
                return this;
              }
              result = new ctor(result);
              result.__chain__ = chainAll;
            }
            return result;
          };
        }
      });
    }

    /**
     * Reverts the '_' variable to its previous value and returns a reference to
     * the `lodash` function.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @returns {Function} Returns the `lodash` function.
     * @example
     *
     * var lodash = _.noConflict();
     */
    function noConflict() {
      context._ = oldDash;
      return this;
    }

    /**
     * A no-operation function.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @example
     *
     * var object = { 'name': 'fred' };
     * _.noop(object) === undefined;
     * // => true
     */
    function noop() {
      // no operation performed
    }

    /**
     * Gets the number of milliseconds that have elapsed since the Unix epoch
     * (1 January 1970 00:00:00 UTC).
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @example
     *
     * var stamp = _.now();
     * _.defer(function() { console.log(_.now() - stamp); });
     * // => logs the number of milliseconds it took for the deferred function to be called
     */
    var now = isNative(now = Date.now) && now || function() {
      return new Date().getTime();
    };

    /**
     * Converts the given value into an integer of the specified radix.
     * If `radix` is `undefined` or `0` a `radix` of `10` is used unless the
     * `value` is a hexadecimal, in which case a `radix` of `16` is used.
     *
     * Note: This method avoids differences in native ES3 and ES5 `parseInt`
     * implementations. See http://es5.github.io/#E.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {string} value The value to parse.
     * @param {number} [radix] The radix used to interpret the value to parse.
     * @returns {number} Returns the new integer value.
     * @example
     *
     * _.parseInt('08');
     * // => 8
     */
    var parseInt = nativeParseInt(whitespace + '08') == 8 ? nativeParseInt : function(value, radix) {
      // Firefox < 21 and Opera < 15 follow the ES3 specified implementation of `parseInt`
      return nativeParseInt(isString(value) ? value.replace(reLeadingSpacesAndZeros, '') : value, radix || 0);
    };

    /**
     * Creates a "_.pluck" style function, which returns the `key` value of a
     * given object.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {string} key The name of the property to retrieve.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var characters = [
     *   { 'name': 'fred',   'age': 40 },
     *   { 'name': 'barney', 'age': 36 }
     * ];
     *
     * var getName = _.property('name');
     *
     * _.map(characters, getName);
     * // => ['barney', 'fred']
     *
     * _.sortBy(characters, getName);
     * // => [{ 'name': 'barney', 'age': 36 }, { 'name': 'fred',   'age': 40 }]
     */
    function property(key) {
      return function(object) {
        return object[key];
      };
    }

    /**
     * Produces a random number between `min` and `max` (inclusive). If only one
     * argument is provided a number between `0` and the given number will be
     * returned. If `floating` is truey or either `min` or `max` are floats a
     * floating-point number will be returned instead of an integer.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {number} [min=0] The minimum possible value.
     * @param {number} [max=1] The maximum possible value.
     * @param {boolean} [floating=false] Specify returning a floating-point number.
     * @returns {number} Returns a random number.
     * @example
     *
     * _.random(0, 5);
     * // => an integer between 0 and 5
     *
     * _.random(5);
     * // => also an integer between 0 and 5
     *
     * _.random(5, true);
     * // => a floating-point number between 0 and 5
     *
     * _.random(1.2, 5.2);
     * // => a floating-point number between 1.2 and 5.2
     */
    function random(min, max, floating) {
      var noMin = min == null,
          noMax = max == null;

      if (floating == null) {
        if (typeof min == 'boolean' && noMax) {
          floating = min;
          min = 1;
        }
        else if (!noMax && typeof max == 'boolean') {
          floating = max;
          noMax = true;
        }
      }
      if (noMin && noMax) {
        max = 1;
      }
      min = +min || 0;
      if (noMax) {
        max = min;
        min = 0;
      } else {
        max = +max || 0;
      }
      if (floating || min % 1 || max % 1) {
        var rand = nativeRandom();
        return nativeMin(min + (rand * (max - min + parseFloat('1e-' + ((rand +'').length - 1)))), max);
      }
      return baseRandom(min, max);
    }

    /**
     * Resolves the value of property `key` on `object`. If `key` is a function
     * it will be invoked with the `this` binding of `object` and its result returned,
     * else the property value is returned. If `object` is falsey then `undefined`
     * is returned.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {Object} object The object to inspect.
     * @param {string} key The name of the property to resolve.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = {
     *   'cheese': 'crumpets',
     *   'stuff': function() {
     *     return 'nonsense';
     *   }
     * };
     *
     * _.result(object, 'cheese');
     * // => 'crumpets'
     *
     * _.result(object, 'stuff');
     * // => 'nonsense'
     */
    function result(object, key) {
      if (object) {
        var value = object[key];
        return isFunction(value) ? object[key]() : value;
      }
    }

    /**
     * A micro-templating method that handles arbitrary delimiters, preserves
     * whitespace, and correctly escapes quotes within interpolated code.
     *
     * Note: In the development build, `_.template` utilizes sourceURLs for easier
     * debugging. See http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl
     *
     * For more information on precompiling templates see:
     * http://lodash.com/custom-builds
     *
     * For more information on Chrome extension sandboxes see:
     * http://developer.chrome.com/stable/extensions/sandboxingEval.html
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {string} text The template text.
     * @param {Object} data The data object used to populate the text.
     * @param {Object} [options] The options object.
     * @param {RegExp} [options.escape] The "escape" delimiter.
     * @param {RegExp} [options.evaluate] The "evaluate" delimiter.
     * @param {Object} [options.imports] An object to import into the template as local variables.
     * @param {RegExp} [options.interpolate] The "interpolate" delimiter.
     * @param {string} [sourceURL] The sourceURL of the template's compiled source.
     * @param {string} [variable] The data object variable name.
     * @returns {Function|string} Returns a compiled function when no `data` object
     *  is given, else it returns the interpolated text.
     * @example
     *
     * // using the "interpolate" delimiter to create a compiled template
     * var compiled = _.template('hello <%= name %>');
     * compiled({ 'name': 'fred' });
     * // => 'hello fred'
     *
     * // using the "escape" delimiter to escape HTML in data property values
     * _.template('<b><%- value %></b>', { 'value': '<script>' });
     * // => '<b>&lt;script&gt;</b>'
     *
     * // using the "evaluate" delimiter to generate HTML
     * var list = '<% _.forEach(people, function(name) { %><li><%- name %></li><% }); %>';
     * _.template(list, { 'people': ['fred', 'barney'] });
     * // => '<li>fred</li><li>barney</li>'
     *
     * // using the ES6 delimiter as an alternative to the default "interpolate" delimiter
     * _.template('hello ${ name }', { 'name': 'pebbles' });
     * // => 'hello pebbles'
     *
     * // using the internal `print` function in "evaluate" delimiters
     * _.template('<% print("hello " + name); %>!', { 'name': 'barney' });
     * // => 'hello barney!'
     *
     * // using a custom template delimiters
     * _.templateSettings = {
     *   'interpolate': /{{([\s\S]+?)}}/g
     * };
     *
     * _.template('hello {{ name }}!', { 'name': 'mustache' });
     * // => 'hello mustache!'
     *
     * // using the `imports` option to import jQuery
     * var list = '<% jq.each(people, function(name) { %><li><%- name %></li><% }); %>';
     * _.template(list, { 'people': ['fred', 'barney'] }, { 'imports': { 'jq': jQuery } });
     * // => '<li>fred</li><li>barney</li>'
     *
     * // using the `sourceURL` option to specify a custom sourceURL for the template
     * var compiled = _.template('hello <%= name %>', null, { 'sourceURL': '/basic/greeting.jst' });
     * compiled(data);
     * // => find the source of "greeting.jst" under the Sources tab or Resources panel of the web inspector
     *
     * // using the `variable` option to ensure a with-statement isn't used in the compiled template
     * var compiled = _.template('hi <%= data.name %>!', null, { 'variable': 'data' });
     * compiled.source;
     * // => function(data) {
     *   var __t, __p = '', __e = _.escape;
     *   __p += 'hi ' + ((__t = ( data.name )) == null ? '' : __t) + '!';
     *   return __p;
     * }
     *
     * // using the `source` property to inline compiled templates for meaningful
     * // line numbers in error messages and a stack trace
     * fs.writeFileSync(path.join(cwd, 'jst.js'), '\
     *   var JST = {\
     *     "main": ' + _.template(mainText).source + '\
     *   };\
     * ');
     */
    function template(text, data, options) {
      // based on John Resig's `tmpl` implementation
      // http://ejohn.org/blog/javascript-micro-templating/
      // and Laura Doktorova's doT.js
      // https://github.com/olado/doT
      var settings = lodash.templateSettings;
      text = String(text || '');

      // avoid missing dependencies when `iteratorTemplate` is not defined
      options = defaults({}, options, settings);

      var imports = defaults({}, options.imports, settings.imports),
          importsKeys = keys(imports),
          importsValues = values(imports);

      var isEvaluating,
          index = 0,
          interpolate = options.interpolate || reNoMatch,
          source = "__p += '";

      // compile the regexp to match each delimiter
      var reDelimiters = RegExp(
        (options.escape || reNoMatch).source + '|' +
        interpolate.source + '|' +
        (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + '|' +
        (options.evaluate || reNoMatch).source + '|$'
      , 'g');

      text.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
        interpolateValue || (interpolateValue = esTemplateValue);

        // escape characters that cannot be included in string literals
        source += text.slice(index, offset).replace(reUnescapedString, escapeStringChar);

        // replace delimiters with snippets
        if (escapeValue) {
          source += "' +\n__e(" + escapeValue + ") +\n'";
        }
        if (evaluateValue) {
          isEvaluating = true;
          source += "';\n" + evaluateValue + ";\n__p += '";
        }
        if (interpolateValue) {
          source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
        }
        index = offset + match.length;

        // the JS engine embedded in Adobe products requires returning the `match`
        // string in order to produce the correct `offset` value
        return match;
      });

      source += "';\n";

      // if `variable` is not specified, wrap a with-statement around the generated
      // code to add the data object to the top of the scope chain
      var variable = options.variable,
          hasVariable = variable;

      if (!hasVariable) {
        variable = 'obj';
        source = 'with (' + variable + ') {\n' + source + '\n}\n';
      }
      // cleanup code by stripping empty strings
      source = (isEvaluating ? source.replace(reEmptyStringLeading, '') : source)
        .replace(reEmptyStringMiddle, '$1')
        .replace(reEmptyStringTrailing, '$1;');

      // frame code as the function body
      source = 'function(' + variable + ') {\n' +
        (hasVariable ? '' : variable + ' || (' + variable + ' = {});\n') +
        "var __t, __p = '', __e = _.escape" +
        (isEvaluating
          ? ', __j = Array.prototype.join;\n' +
            "function print() { __p += __j.call(arguments, '') }\n"
          : ';\n'
        ) +
        source +
        'return __p\n}';

      // Use a sourceURL for easier debugging.
      // http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl
      var sourceURL = '\n/*\n//# sourceURL=' + (options.sourceURL || '/lodash/template/source[' + (templateCounter++) + ']') + '\n*/';

      try {
        var result = Function(importsKeys, 'return ' + source + sourceURL).apply(undefined, importsValues);
      } catch(e) {
        e.source = source;
        throw e;
      }
      if (data) {
        return result(data);
      }
      // provide the compiled function's source by its `toString` method, in
      // supported environments, or the `source` property as a convenience for
      // inlining compiled templates during the build process
      result.source = source;
      return result;
    }

    /**
     * Executes the callback `n` times, returning an array of the results
     * of each callback execution. The callback is bound to `thisArg` and invoked
     * with one argument; (index).
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {number} n The number of times to execute the callback.
     * @param {Function} callback The function called per iteration.
     * @param {*} [thisArg] The `this` binding of `callback`.
     * @returns {Array} Returns an array of the results of each `callback` execution.
     * @example
     *
     * var diceRolls = _.times(3, _.partial(_.random, 1, 6));
     * // => [3, 6, 4]
     *
     * _.times(3, function(n) { mage.castSpell(n); });
     * // => calls `mage.castSpell(n)` three times, passing `n` of `0`, `1`, and `2` respectively
     *
     * _.times(3, function(n) { this.cast(n); }, mage);
     * // => also calls `mage.castSpell(n)` three times
     */
    function times(n, callback, thisArg) {
      n = (n = +n) > -1 ? n : 0;
      var index = -1,
          result = Array(n);

      callback = baseCreateCallback(callback, thisArg, 1);
      while (++index < n) {
        result[index] = callback(index);
      }
      return result;
    }

    /**
     * The inverse of `_.escape` this method converts the HTML entities
     * `&amp;`, `&lt;`, `&gt;`, `&quot;`, and `&#39;` in `string` to their
     * corresponding characters.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {string} string The string to unescape.
     * @returns {string} Returns the unescaped string.
     * @example
     *
     * _.unescape('Fred, Barney &amp; Pebbles');
     * // => 'Fred, Barney & Pebbles'
     */
    function unescape(string) {
      return string == null ? '' : String(string).replace(reEscapedHtml, unescapeHtmlChar);
    }

    /**
     * Generates a unique ID. If `prefix` is provided the ID will be appended to it.
     *
     * @static
     * @memberOf _
     * @category Utilities
     * @param {string} [prefix] The value to prefix the ID with.
     * @returns {string} Returns the unique ID.
     * @example
     *
     * _.uniqueId('contact_');
     * // => 'contact_104'
     *
     * _.uniqueId();
     * // => '105'
     */
    function uniqueId(prefix) {
      var id = ++idCounter;
      return String(prefix == null ? '' : prefix) + id;
    }

    /*--------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object that wraps the given value with explicit
     * method chaining enabled.
     *
     * @static
     * @memberOf _
     * @category Chaining
     * @param {*} value The value to wrap.
     * @returns {Object} Returns the wrapper object.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney',  'age': 36 },
     *   { 'name': 'fred',    'age': 40 },
     *   { 'name': 'pebbles', 'age': 1 }
     * ];
     *
     * var youngest = _.chain(characters)
     *     .sortBy('age')
     *     .map(function(chr) { return chr.name + ' is ' + chr.age; })
     *     .first()
     *     .value();
     * // => 'pebbles is 1'
     */
    function chain(value) {
      value = new lodashWrapper(value);
      value.__chain__ = true;
      return value;
    }

    /**
     * Invokes `interceptor` with the `value` as the first argument and then
     * returns `value`. The purpose of this method is to "tap into" a method
     * chain in order to perform operations on intermediate results within
     * the chain.
     *
     * @static
     * @memberOf _
     * @category Chaining
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @returns {*} Returns `value`.
     * @example
     *
     * _([1, 2, 3, 4])
     *  .tap(function(array) { array.pop(); })
     *  .reverse()
     *  .value();
     * // => [3, 2, 1]
     */
    function tap(value, interceptor) {
      interceptor(value);
      return value;
    }

    /**
     * Enables explicit method chaining on the wrapper object.
     *
     * @name chain
     * @memberOf _
     * @category Chaining
     * @returns {*} Returns the wrapper object.
     * @example
     *
     * var characters = [
     *   { 'name': 'barney', 'age': 36 },
     *   { 'name': 'fred',   'age': 40 }
     * ];
     *
     * // without explicit chaining
     * _(characters).first();
     * // => { 'name': 'barney', 'age': 36 }
     *
     * // with explicit chaining
     * _(characters).chain()
     *   .first()
     *   .pick('age')
     *   .value();
     * // => { 'age': 36 }
     */
    function wrapperChain() {
      this.__chain__ = true;
      return this;
    }

    /**
     * Produces the `toString` result of the wrapped value.
     *
     * @name toString
     * @memberOf _
     * @category Chaining
     * @returns {string} Returns the string result.
     * @example
     *
     * _([1, 2, 3]).toString();
     * // => '1,2,3'
     */
    function wrapperToString() {
      return String(this.__wrapped__);
    }

    /**
     * Extracts the wrapped value.
     *
     * @name valueOf
     * @memberOf _
     * @alias value
     * @category Chaining
     * @returns {*} Returns the wrapped value.
     * @example
     *
     * _([1, 2, 3]).valueOf();
     * // => [1, 2, 3]
     */
    function wrapperValueOf() {
      return this.__wrapped__;
    }

    /*--------------------------------------------------------------------------*/

    // add functions that return wrapped values when chaining
    lodash.after = after;
    lodash.assign = assign;
    lodash.at = at;
    lodash.bind = bind;
    lodash.bindAll = bindAll;
    lodash.bindKey = bindKey;
    lodash.chain = chain;
    lodash.compact = compact;
    lodash.compose = compose;
    lodash.constant = constant;
    lodash.countBy = countBy;
    lodash.create = create;
    lodash.createCallback = createCallback;
    lodash.curry = curry;
    lodash.debounce = debounce;
    lodash.defaults = defaults;
    lodash.defer = defer;
    lodash.delay = delay;
    lodash.difference = difference;
    lodash.filter = filter;
    lodash.flatten = flatten;
    lodash.forEach = forEach;
    lodash.forEachRight = forEachRight;
    lodash.forIn = forIn;
    lodash.forInRight = forInRight;
    lodash.forOwn = forOwn;
    lodash.forOwnRight = forOwnRight;
    lodash.functions = functions;
    lodash.groupBy = groupBy;
    lodash.indexBy = indexBy;
    lodash.initial = initial;
    lodash.intersection = intersection;
    lodash.invert = invert;
    lodash.invoke = invoke;
    lodash.keys = keys;
    lodash.map = map;
    lodash.mapValues = mapValues;
    lodash.max = max;
    lodash.memoize = memoize;
    lodash.merge = merge;
    lodash.min = min;
    lodash.omit = omit;
    lodash.once = once;
    lodash.pairs = pairs;
    lodash.partial = partial;
    lodash.partialRight = partialRight;
    lodash.pick = pick;
    lodash.pluck = pluck;
    lodash.property = property;
    lodash.pull = pull;
    lodash.range = range;
    lodash.reject = reject;
    lodash.remove = remove;
    lodash.rest = rest;
    lodash.shuffle = shuffle;
    lodash.sortBy = sortBy;
    lodash.tap = tap;
    lodash.throttle = throttle;
    lodash.times = times;
    lodash.toArray = toArray;
    lodash.transform = transform;
    lodash.union = union;
    lodash.uniq = uniq;
    lodash.values = values;
    lodash.where = where;
    lodash.without = without;
    lodash.wrap = wrap;
    lodash.xor = xor;
    lodash.zip = zip;
    lodash.zipObject = zipObject;

    // add aliases
    lodash.collect = map;
    lodash.drop = rest;
    lodash.each = forEach;
    lodash.eachRight = forEachRight;
    lodash.extend = assign;
    lodash.methods = functions;
    lodash.object = zipObject;
    lodash.select = filter;
    lodash.tail = rest;
    lodash.unique = uniq;
    lodash.unzip = zip;

    // add functions to `lodash.prototype`
    mixin(lodash);

    /*--------------------------------------------------------------------------*/

    // add functions that return unwrapped values when chaining
    lodash.clone = clone;
    lodash.cloneDeep = cloneDeep;
    lodash.contains = contains;
    lodash.escape = escape;
    lodash.every = every;
    lodash.find = find;
    lodash.findIndex = findIndex;
    lodash.findKey = findKey;
    lodash.findLast = findLast;
    lodash.findLastIndex = findLastIndex;
    lodash.findLastKey = findLastKey;
    lodash.has = has;
    lodash.identity = identity;
    lodash.indexOf = indexOf;
    lodash.isArguments = isArguments;
    lodash.isArray = isArray;
    lodash.isBoolean = isBoolean;
    lodash.isDate = isDate;
    lodash.isElement = isElement;
    lodash.isEmpty = isEmpty;
    lodash.isEqual = isEqual;
    lodash.isFinite = isFinite;
    lodash.isFunction = isFunction;
    lodash.isNaN = isNaN;
    lodash.isNull = isNull;
    lodash.isNumber = isNumber;
    lodash.isObject = isObject;
    lodash.isPlainObject = isPlainObject;
    lodash.isRegExp = isRegExp;
    lodash.isString = isString;
    lodash.isUndefined = isUndefined;
    lodash.lastIndexOf = lastIndexOf;
    lodash.mixin = mixin;
    lodash.noConflict = noConflict;
    lodash.noop = noop;
    lodash.now = now;
    lodash.parseInt = parseInt;
    lodash.random = random;
    lodash.reduce = reduce;
    lodash.reduceRight = reduceRight;
    lodash.result = result;
    lodash.runInContext = runInContext;
    lodash.size = size;
    lodash.some = some;
    lodash.sortedIndex = sortedIndex;
    lodash.template = template;
    lodash.unescape = unescape;
    lodash.uniqueId = uniqueId;

    // add aliases
    lodash.all = every;
    lodash.any = some;
    lodash.detect = find;
    lodash.findWhere = find;
    lodash.foldl = reduce;
    lodash.foldr = reduceRight;
    lodash.include = contains;
    lodash.inject = reduce;

    mixin(function() {
      var source = {}
      forOwn(lodash, function(func, methodName) {
        if (!lodash.prototype[methodName]) {
          source[methodName] = func;
        }
      });
      return source;
    }(), false);

    /*--------------------------------------------------------------------------*/

    // add functions capable of returning wrapped and unwrapped values when chaining
    lodash.first = first;
    lodash.last = last;
    lodash.sample = sample;

    // add aliases
    lodash.take = first;
    lodash.head = first;

    forOwn(lodash, function(func, methodName) {
      var callbackable = methodName !== 'sample';
      if (!lodash.prototype[methodName]) {
        lodash.prototype[methodName]= function(n, guard) {
          var chainAll = this.__chain__,
              result = func(this.__wrapped__, n, guard);

          return !chainAll && (n == null || (guard && !(callbackable && typeof n == 'function')))
            ? result
            : new lodashWrapper(result, chainAll);
        };
      }
    });

    /*--------------------------------------------------------------------------*/

    /**
     * The semantic version number.
     *
     * @static
     * @memberOf _
     * @type string
     */
    lodash.VERSION = '2.4.1';

    // add "Chaining" functions to the wrapper
    lodash.prototype.chain = wrapperChain;
    lodash.prototype.toString = wrapperToString;
    lodash.prototype.value = wrapperValueOf;
    lodash.prototype.valueOf = wrapperValueOf;

    // add `Array` functions that return unwrapped values
    forEach(['join', 'pop', 'shift'], function(methodName) {
      var func = arrayRef[methodName];
      lodash.prototype[methodName] = function() {
        var chainAll = this.__chain__,
            result = func.apply(this.__wrapped__, arguments);

        return chainAll
          ? new lodashWrapper(result, chainAll)
          : result;
      };
    });

    // add `Array` functions that return the existing wrapped value
    forEach(['push', 'reverse', 'sort', 'unshift'], function(methodName) {
      var func = arrayRef[methodName];
      lodash.prototype[methodName] = function() {
        func.apply(this.__wrapped__, arguments);
        return this;
      };
    });

    // add `Array` functions that return new wrapped values
    forEach(['concat', 'slice', 'splice'], function(methodName) {
      var func = arrayRef[methodName];
      lodash.prototype[methodName] = function() {
        return new lodashWrapper(func.apply(this.__wrapped__, arguments), this.__chain__);
      };
    });

    return lodash;
  }

  /*--------------------------------------------------------------------------*/

  // expose Lo-Dash
  var _ = runInContext();

  // some AMD build optimizers like r.js check for condition patterns like the following:
  if (typeof define == 'function' && typeof define.amd == 'object' && define.amd) {
    // Expose Lo-Dash to the global object even when an AMD loader is present in
    // case Lo-Dash is loaded with a RequireJS shim config.
    // See http://requirejs.org/docs/api.html#config-shim
    root._ = _;

    // define as an anonymous module so, through path mapping, it can be
    // referenced as the "underscore" module
    define(function() {
      return _;
    });
  }
  // check for `exports` after `define` in case a build optimizer adds an `exports` object
  else if (freeExports && freeModule) {
    // in Node.js or RingoJS
    if (moduleExports) {
      (freeModule.exports = _)._ = _;
    }
    // in Narwhal or Rhino -require
    else {
      freeExports._ = _;
    }
  }
  else {
    // in a browser or Rhino
    root._ = _;
  }
}.call(this));

}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{}],"handlebars":[function(require,module,exports){
/*!

 handlebars v2.0.0

Copyright (C) 2011-2014 by Yehuda Katz

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

@license
*/
!function(a,b){"function"==typeof define&&define.amd?define([],b):"object"==typeof exports?module.exports=b():a.Handlebars=a.Handlebars||b()}(this,function(){var a=function(){"use strict";function a(a){this.string=a}var b;return a.prototype.toString=function(){return""+this.string},b=a}(),b=function(a){"use strict";function b(a){return i[a]}function c(a){for(var b=1;b<arguments.length;b++)for(var c in arguments[b])Object.prototype.hasOwnProperty.call(arguments[b],c)&&(a[c]=arguments[b][c]);return a}function d(a){return a instanceof h?a.toString():null==a?"":a?(a=""+a,k.test(a)?a.replace(j,b):a):a+""}function e(a){return a||0===a?n(a)&&0===a.length?!0:!1:!0}function f(a,b){return(a?a+".":"")+b}var g={},h=a,i={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},j=/[&<>"'`]/g,k=/[&<>"'`]/;g.extend=c;var l=Object.prototype.toString;g.toString=l;var m=function(a){return"function"==typeof a};m(/x/)&&(m=function(a){return"function"==typeof a&&"[object Function]"===l.call(a)});var m;g.isFunction=m;var n=Array.isArray||function(a){return a&&"object"==typeof a?"[object Array]"===l.call(a):!1};return g.isArray=n,g.escapeExpression=d,g.isEmpty=e,g.appendContextPath=f,g}(a),c=function(){"use strict";function a(a,b){var d;b&&b.firstLine&&(d=b.firstLine,a+=" - "+d+":"+b.firstColumn);for(var e=Error.prototype.constructor.call(this,a),f=0;f<c.length;f++)this[c[f]]=e[c[f]];d&&(this.lineNumber=d,this.column=b.firstColumn)}var b,c=["description","fileName","lineNumber","message","name","number","stack"];return a.prototype=new Error,b=a}(),d=function(a,b){"use strict";function c(a,b){this.helpers=a||{},this.partials=b||{},d(this)}function d(a){a.registerHelper("helperMissing",function(){if(1===arguments.length)return void 0;throw new g("Missing helper: '"+arguments[arguments.length-1].name+"'")}),a.registerHelper("blockHelperMissing",function(b,c){var d=c.inverse,e=c.fn;if(b===!0)return e(this);if(b===!1||null==b)return d(this);if(k(b))return b.length>0?(c.ids&&(c.ids=[c.name]),a.helpers.each(b,c)):d(this);if(c.data&&c.ids){var g=q(c.data);g.contextPath=f.appendContextPath(c.data.contextPath,c.name),c={data:g}}return e(b,c)}),a.registerHelper("each",function(a,b){if(!b)throw new g("Must pass iterator to #each");var c,d,e=b.fn,h=b.inverse,i=0,j="";if(b.data&&b.ids&&(d=f.appendContextPath(b.data.contextPath,b.ids[0])+"."),l(a)&&(a=a.call(this)),b.data&&(c=q(b.data)),a&&"object"==typeof a)if(k(a))for(var m=a.length;m>i;i++)c&&(c.index=i,c.first=0===i,c.last=i===a.length-1,d&&(c.contextPath=d+i)),j+=e(a[i],{data:c});else for(var n in a)a.hasOwnProperty(n)&&(c&&(c.key=n,c.index=i,c.first=0===i,d&&(c.contextPath=d+n)),j+=e(a[n],{data:c}),i++);return 0===i&&(j=h(this)),j}),a.registerHelper("if",function(a,b){return l(a)&&(a=a.call(this)),!b.hash.includeZero&&!a||f.isEmpty(a)?b.inverse(this):b.fn(this)}),a.registerHelper("unless",function(b,c){return a.helpers["if"].call(this,b,{fn:c.inverse,inverse:c.fn,hash:c.hash})}),a.registerHelper("with",function(a,b){l(a)&&(a=a.call(this));var c=b.fn;if(f.isEmpty(a))return b.inverse(this);if(b.data&&b.ids){var d=q(b.data);d.contextPath=f.appendContextPath(b.data.contextPath,b.ids[0]),b={data:d}}return c(a,b)}),a.registerHelper("log",function(b,c){var d=c.data&&null!=c.data.level?parseInt(c.data.level,10):1;a.log(d,b)}),a.registerHelper("lookup",function(a,b){return a&&a[b]})}var e={},f=a,g=b,h="2.0.0";e.VERSION=h;var i=6;e.COMPILER_REVISION=i;var j={1:"<= 1.0.rc.2",2:"== 1.0.0-rc.3",3:"== 1.0.0-rc.4",4:"== 1.x.x",5:"== 2.0.0-alpha.x",6:">= 2.0.0-beta.1"};e.REVISION_CHANGES=j;var k=f.isArray,l=f.isFunction,m=f.toString,n="[object Object]";e.HandlebarsEnvironment=c,c.prototype={constructor:c,logger:o,log:p,registerHelper:function(a,b){if(m.call(a)===n){if(b)throw new g("Arg not supported with multiple helpers");f.extend(this.helpers,a)}else this.helpers[a]=b},unregisterHelper:function(a){delete this.helpers[a]},registerPartial:function(a,b){m.call(a)===n?f.extend(this.partials,a):this.partials[a]=b},unregisterPartial:function(a){delete this.partials[a]}};var o={methodMap:{0:"debug",1:"info",2:"warn",3:"error"},DEBUG:0,INFO:1,WARN:2,ERROR:3,level:3,log:function(a,b){if(o.level<=a){var c=o.methodMap[a];"undefined"!=typeof console&&console[c]&&console[c].call(console,b)}}};e.logger=o;var p=o.log;e.log=p;var q=function(a){var b=f.extend({},a);return b._parent=a,b};return e.createFrame=q,e}(b,c),e=function(a,b,c){"use strict";function d(a){var b=a&&a[0]||1,c=m;if(b!==c){if(c>b){var d=n[c],e=n[b];throw new l("Template was precompiled with an older version of Handlebars than the current runtime. Please update your precompiler to a newer version ("+d+") or downgrade your runtime to an older version ("+e+").")}throw new l("Template was precompiled with a newer version of Handlebars than the current runtime. Please update your runtime to a newer version ("+a[1]+").")}}function e(a,b){if(!b)throw new l("No environment passed to template");if(!a||!a.main)throw new l("Unknown template object: "+typeof a);b.VM.checkRevision(a.compiler);var c=function(c,d,e,f,g,h,i,j,m){g&&(f=k.extend({},f,g));var n=b.VM.invokePartial.call(this,c,e,f,h,i,j,m);if(null==n&&b.compile){var o={helpers:h,partials:i,data:j,depths:m};i[e]=b.compile(c,{data:void 0!==j,compat:a.compat},b),n=i[e](f,o)}if(null!=n){if(d){for(var p=n.split("\n"),q=0,r=p.length;r>q&&(p[q]||q+1!==r);q++)p[q]=d+p[q];n=p.join("\n")}return n}throw new l("The partial "+e+" could not be compiled when running in runtime-only mode")},d={lookup:function(a,b){for(var c=a.length,d=0;c>d;d++)if(a[d]&&null!=a[d][b])return a[d][b]},lambda:function(a,b){return"function"==typeof a?a.call(b):a},escapeExpression:k.escapeExpression,invokePartial:c,fn:function(b){return a[b]},programs:[],program:function(a,b,c){var d=this.programs[a],e=this.fn(a);return b||c?d=f(this,a,e,b,c):d||(d=this.programs[a]=f(this,a,e)),d},data:function(a,b){for(;a&&b--;)a=a._parent;return a},merge:function(a,b){var c=a||b;return a&&b&&a!==b&&(c=k.extend({},b,a)),c},noop:b.VM.noop,compilerInfo:a.compiler},e=function(b,c){c=c||{};var f=c.data;e._setup(c),!c.partial&&a.useData&&(f=i(b,f));var g;return a.useDepths&&(g=c.depths?[b].concat(c.depths):[b]),a.main.call(d,b,d.helpers,d.partials,f,g)};return e.isTop=!0,e._setup=function(c){c.partial?(d.helpers=c.helpers,d.partials=c.partials):(d.helpers=d.merge(c.helpers,b.helpers),a.usePartial&&(d.partials=d.merge(c.partials,b.partials)))},e._child=function(b,c,e){if(a.useDepths&&!e)throw new l("must pass parent depths");return f(d,b,a[b],c,e)},e}function f(a,b,c,d,e){var f=function(b,f){return f=f||{},c.call(a,b,a.helpers,a.partials,f.data||d,e&&[b].concat(e))};return f.program=b,f.depth=e?e.length:0,f}function g(a,b,c,d,e,f,g){var h={partial:!0,helpers:d,partials:e,data:f,depths:g};if(void 0===a)throw new l("The partial "+b+" could not be found");return a instanceof Function?a(c,h):void 0}function h(){return""}function i(a,b){return b&&"root"in b||(b=b?o(b):{},b.root=a),b}var j={},k=a,l=b,m=c.COMPILER_REVISION,n=c.REVISION_CHANGES,o=c.createFrame;return j.checkRevision=d,j.template=e,j.program=f,j.invokePartial=g,j.noop=h,j}(b,c,d),f=function(a,b,c,d,e){"use strict";var f,g=a,h=b,i=c,j=d,k=e,l=function(){var a=new g.HandlebarsEnvironment;return j.extend(a,g),a.SafeString=h,a.Exception=i,a.Utils=j,a.escapeExpression=j.escapeExpression,a.VM=k,a.template=function(b){return k.template(b,a)},a},m=l();return m.create=l,m["default"]=m,f=m}(d,a,c,b,e),g=function(a){"use strict";function b(a){a=a||{},this.firstLine=a.first_line,this.firstColumn=a.first_column,this.lastColumn=a.last_column,this.lastLine=a.last_line}var c,d=a,e={ProgramNode:function(a,c,d){b.call(this,d),this.type="program",this.statements=a,this.strip=c},MustacheNode:function(a,c,d,f,g){if(b.call(this,g),this.type="mustache",this.strip=f,null!=d&&d.charAt){var h=d.charAt(3)||d.charAt(2);this.escaped="{"!==h&&"&"!==h}else this.escaped=!!d;this.sexpr=a instanceof e.SexprNode?a:new e.SexprNode(a,c),this.id=this.sexpr.id,this.params=this.sexpr.params,this.hash=this.sexpr.hash,this.eligibleHelper=this.sexpr.eligibleHelper,this.isHelper=this.sexpr.isHelper},SexprNode:function(a,c,d){b.call(this,d),this.type="sexpr",this.hash=c;var e=this.id=a[0],f=this.params=a.slice(1);this.isHelper=!(!f.length&&!c),this.eligibleHelper=this.isHelper||e.isSimple},PartialNode:function(a,c,d,e,f){b.call(this,f),this.type="partial",this.partialName=a,this.context=c,this.hash=d,this.strip=e,this.strip.inlineStandalone=!0},BlockNode:function(a,c,d,e,f){b.call(this,f),this.type="block",this.mustache=a,this.program=c,this.inverse=d,this.strip=e,d&&!c&&(this.isInverse=!0)},RawBlockNode:function(a,c,f,g){if(b.call(this,g),a.sexpr.id.original!==f)throw new d(a.sexpr.id.original+" doesn't match "+f,this);c=new e.ContentNode(c,g),this.type="block",this.mustache=a,this.program=new e.ProgramNode([c],{},g)},ContentNode:function(a,c){b.call(this,c),this.type="content",this.original=this.string=a},HashNode:function(a,c){b.call(this,c),this.type="hash",this.pairs=a},IdNode:function(a,c){b.call(this,c),this.type="ID";for(var e="",f=[],g=0,h="",i=0,j=a.length;j>i;i++){var k=a[i].part;if(e+=(a[i].separator||"")+k,".."===k||"."===k||"this"===k){if(f.length>0)throw new d("Invalid path: "+e,this);".."===k?(g++,h+="../"):this.isScoped=!0}else f.push(k)}this.original=e,this.parts=f,this.string=f.join("."),this.depth=g,this.idName=h+this.string,this.isSimple=1===a.length&&!this.isScoped&&0===g,this.stringModeValue=this.string},PartialNameNode:function(a,c){b.call(this,c),this.type="PARTIAL_NAME",this.name=a.original},DataNode:function(a,c){b.call(this,c),this.type="DATA",this.id=a,this.stringModeValue=a.stringModeValue,this.idName="@"+a.stringModeValue},StringNode:function(a,c){b.call(this,c),this.type="STRING",this.original=this.string=this.stringModeValue=a},NumberNode:function(a,c){b.call(this,c),this.type="NUMBER",this.original=this.number=a,this.stringModeValue=Number(a)},BooleanNode:function(a,c){b.call(this,c),this.type="BOOLEAN",this.bool=a,this.stringModeValue="true"===a},CommentNode:function(a,c){b.call(this,c),this.type="comment",this.comment=a,this.strip={inlineStandalone:!0}}};return c=e}(c),h=function(){"use strict";var a,b=function(){function a(){this.yy={}}var b={trace:function(){},yy:{},symbols_:{error:2,root:3,program:4,EOF:5,program_repetition0:6,statement:7,mustache:8,block:9,rawBlock:10,partial:11,CONTENT:12,COMMENT:13,openRawBlock:14,END_RAW_BLOCK:15,OPEN_RAW_BLOCK:16,sexpr:17,CLOSE_RAW_BLOCK:18,openBlock:19,block_option0:20,closeBlock:21,openInverse:22,block_option1:23,OPEN_BLOCK:24,CLOSE:25,OPEN_INVERSE:26,inverseAndProgram:27,INVERSE:28,OPEN_ENDBLOCK:29,path:30,OPEN:31,OPEN_UNESCAPED:32,CLOSE_UNESCAPED:33,OPEN_PARTIAL:34,partialName:35,param:36,partial_option0:37,partial_option1:38,sexpr_repetition0:39,sexpr_option0:40,dataName:41,STRING:42,NUMBER:43,BOOLEAN:44,OPEN_SEXPR:45,CLOSE_SEXPR:46,hash:47,hash_repetition_plus0:48,hashSegment:49,ID:50,EQUALS:51,DATA:52,pathSegments:53,SEP:54,$accept:0,$end:1},terminals_:{2:"error",5:"EOF",12:"CONTENT",13:"COMMENT",15:"END_RAW_BLOCK",16:"OPEN_RAW_BLOCK",18:"CLOSE_RAW_BLOCK",24:"OPEN_BLOCK",25:"CLOSE",26:"OPEN_INVERSE",28:"INVERSE",29:"OPEN_ENDBLOCK",31:"OPEN",32:"OPEN_UNESCAPED",33:"CLOSE_UNESCAPED",34:"OPEN_PARTIAL",42:"STRING",43:"NUMBER",44:"BOOLEAN",45:"OPEN_SEXPR",46:"CLOSE_SEXPR",50:"ID",51:"EQUALS",52:"DATA",54:"SEP"},productions_:[0,[3,2],[4,1],[7,1],[7,1],[7,1],[7,1],[7,1],[7,1],[10,3],[14,3],[9,4],[9,4],[19,3],[22,3],[27,2],[21,3],[8,3],[8,3],[11,5],[11,4],[17,3],[17,1],[36,1],[36,1],[36,1],[36,1],[36,1],[36,3],[47,1],[49,3],[35,1],[35,1],[35,1],[41,2],[30,1],[53,3],[53,1],[6,0],[6,2],[20,0],[20,1],[23,0],[23,1],[37,0],[37,1],[38,0],[38,1],[39,0],[39,2],[40,0],[40,1],[48,1],[48,2]],performAction:function(a,b,c,d,e,f){var g=f.length-1;switch(e){case 1:return d.prepareProgram(f[g-1].statements,!0),f[g-1];case 2:this.$=new d.ProgramNode(d.prepareProgram(f[g]),{},this._$);break;case 3:this.$=f[g];break;case 4:this.$=f[g];break;case 5:this.$=f[g];break;case 6:this.$=f[g];break;case 7:this.$=new d.ContentNode(f[g],this._$);break;case 8:this.$=new d.CommentNode(f[g],this._$);break;case 9:this.$=new d.RawBlockNode(f[g-2],f[g-1],f[g],this._$);break;case 10:this.$=new d.MustacheNode(f[g-1],null,"","",this._$);break;case 11:this.$=d.prepareBlock(f[g-3],f[g-2],f[g-1],f[g],!1,this._$);break;case 12:this.$=d.prepareBlock(f[g-3],f[g-2],f[g-1],f[g],!0,this._$);break;case 13:this.$=new d.MustacheNode(f[g-1],null,f[g-2],d.stripFlags(f[g-2],f[g]),this._$);break;case 14:this.$=new d.MustacheNode(f[g-1],null,f[g-2],d.stripFlags(f[g-2],f[g]),this._$);break;case 15:this.$={strip:d.stripFlags(f[g-1],f[g-1]),program:f[g]};break;case 16:this.$={path:f[g-1],strip:d.stripFlags(f[g-2],f[g])};break;case 17:this.$=new d.MustacheNode(f[g-1],null,f[g-2],d.stripFlags(f[g-2],f[g]),this._$);break;case 18:this.$=new d.MustacheNode(f[g-1],null,f[g-2],d.stripFlags(f[g-2],f[g]),this._$);break;case 19:this.$=new d.PartialNode(f[g-3],f[g-2],f[g-1],d.stripFlags(f[g-4],f[g]),this._$);break;case 20:this.$=new d.PartialNode(f[g-2],void 0,f[g-1],d.stripFlags(f[g-3],f[g]),this._$);break;case 21:this.$=new d.SexprNode([f[g-2]].concat(f[g-1]),f[g],this._$);break;case 22:this.$=new d.SexprNode([f[g]],null,this._$);break;case 23:this.$=f[g];break;case 24:this.$=new d.StringNode(f[g],this._$);break;case 25:this.$=new d.NumberNode(f[g],this._$);break;case 26:this.$=new d.BooleanNode(f[g],this._$);break;case 27:this.$=f[g];break;case 28:f[g-1].isHelper=!0,this.$=f[g-1];break;case 29:this.$=new d.HashNode(f[g],this._$);break;case 30:this.$=[f[g-2],f[g]];break;case 31:this.$=new d.PartialNameNode(f[g],this._$);break;case 32:this.$=new d.PartialNameNode(new d.StringNode(f[g],this._$),this._$);break;case 33:this.$=new d.PartialNameNode(new d.NumberNode(f[g],this._$));break;case 34:this.$=new d.DataNode(f[g],this._$);break;case 35:this.$=new d.IdNode(f[g],this._$);break;case 36:f[g-2].push({part:f[g],separator:f[g-1]}),this.$=f[g-2];break;case 37:this.$=[{part:f[g]}];break;case 38:this.$=[];break;case 39:f[g-1].push(f[g]);break;case 48:this.$=[];break;case 49:f[g-1].push(f[g]);break;case 52:this.$=[f[g]];break;case 53:f[g-1].push(f[g])}},table:[{3:1,4:2,5:[2,38],6:3,12:[2,38],13:[2,38],16:[2,38],24:[2,38],26:[2,38],31:[2,38],32:[2,38],34:[2,38]},{1:[3]},{5:[1,4]},{5:[2,2],7:5,8:6,9:7,10:8,11:9,12:[1,10],13:[1,11],14:16,16:[1,20],19:14,22:15,24:[1,18],26:[1,19],28:[2,2],29:[2,2],31:[1,12],32:[1,13],34:[1,17]},{1:[2,1]},{5:[2,39],12:[2,39],13:[2,39],16:[2,39],24:[2,39],26:[2,39],28:[2,39],29:[2,39],31:[2,39],32:[2,39],34:[2,39]},{5:[2,3],12:[2,3],13:[2,3],16:[2,3],24:[2,3],26:[2,3],28:[2,3],29:[2,3],31:[2,3],32:[2,3],34:[2,3]},{5:[2,4],12:[2,4],13:[2,4],16:[2,4],24:[2,4],26:[2,4],28:[2,4],29:[2,4],31:[2,4],32:[2,4],34:[2,4]},{5:[2,5],12:[2,5],13:[2,5],16:[2,5],24:[2,5],26:[2,5],28:[2,5],29:[2,5],31:[2,5],32:[2,5],34:[2,5]},{5:[2,6],12:[2,6],13:[2,6],16:[2,6],24:[2,6],26:[2,6],28:[2,6],29:[2,6],31:[2,6],32:[2,6],34:[2,6]},{5:[2,7],12:[2,7],13:[2,7],16:[2,7],24:[2,7],26:[2,7],28:[2,7],29:[2,7],31:[2,7],32:[2,7],34:[2,7]},{5:[2,8],12:[2,8],13:[2,8],16:[2,8],24:[2,8],26:[2,8],28:[2,8],29:[2,8],31:[2,8],32:[2,8],34:[2,8]},{17:21,30:22,41:23,50:[1,26],52:[1,25],53:24},{17:27,30:22,41:23,50:[1,26],52:[1,25],53:24},{4:28,6:3,12:[2,38],13:[2,38],16:[2,38],24:[2,38],26:[2,38],28:[2,38],29:[2,38],31:[2,38],32:[2,38],34:[2,38]},{4:29,6:3,12:[2,38],13:[2,38],16:[2,38],24:[2,38],26:[2,38],28:[2,38],29:[2,38],31:[2,38],32:[2,38],34:[2,38]},{12:[1,30]},{30:32,35:31,42:[1,33],43:[1,34],50:[1,26],53:24},{17:35,30:22,41:23,50:[1,26],52:[1,25],53:24},{17:36,30:22,41:23,50:[1,26],52:[1,25],53:24},{17:37,30:22,41:23,50:[1,26],52:[1,25],53:24},{25:[1,38]},{18:[2,48],25:[2,48],33:[2,48],39:39,42:[2,48],43:[2,48],44:[2,48],45:[2,48],46:[2,48],50:[2,48],52:[2,48]},{18:[2,22],25:[2,22],33:[2,22],46:[2,22]},{18:[2,35],25:[2,35],33:[2,35],42:[2,35],43:[2,35],44:[2,35],45:[2,35],46:[2,35],50:[2,35],52:[2,35],54:[1,40]},{30:41,50:[1,26],53:24},{18:[2,37],25:[2,37],33:[2,37],42:[2,37],43:[2,37],44:[2,37],45:[2,37],46:[2,37],50:[2,37],52:[2,37],54:[2,37]},{33:[1,42]},{20:43,27:44,28:[1,45],29:[2,40]},{23:46,27:47,28:[1,45],29:[2,42]},{15:[1,48]},{25:[2,46],30:51,36:49,38:50,41:55,42:[1,52],43:[1,53],44:[1,54],45:[1,56],47:57,48:58,49:60,50:[1,59],52:[1,25],53:24},{25:[2,31],42:[2,31],43:[2,31],44:[2,31],45:[2,31],50:[2,31],52:[2,31]},{25:[2,32],42:[2,32],43:[2,32],44:[2,32],45:[2,32],50:[2,32],52:[2,32]},{25:[2,33],42:[2,33],43:[2,33],44:[2,33],45:[2,33],50:[2,33],52:[2,33]},{25:[1,61]},{25:[1,62]},{18:[1,63]},{5:[2,17],12:[2,17],13:[2,17],16:[2,17],24:[2,17],26:[2,17],28:[2,17],29:[2,17],31:[2,17],32:[2,17],34:[2,17]},{18:[2,50],25:[2,50],30:51,33:[2,50],36:65,40:64,41:55,42:[1,52],43:[1,53],44:[1,54],45:[1,56],46:[2,50],47:66,48:58,49:60,50:[1,59],52:[1,25],53:24},{50:[1,67]},{18:[2,34],25:[2,34],33:[2,34],42:[2,34],43:[2,34],44:[2,34],45:[2,34],46:[2,34],50:[2,34],52:[2,34]},{5:[2,18],12:[2,18],13:[2,18],16:[2,18],24:[2,18],26:[2,18],28:[2,18],29:[2,18],31:[2,18],32:[2,18],34:[2,18]},{21:68,29:[1,69]},{29:[2,41]},{4:70,6:3,12:[2,38],13:[2,38],16:[2,38],24:[2,38],26:[2,38],29:[2,38],31:[2,38],32:[2,38],34:[2,38]},{21:71,29:[1,69]},{29:[2,43]},{5:[2,9],12:[2,9],13:[2,9],16:[2,9],24:[2,9],26:[2,9],28:[2,9],29:[2,9],31:[2,9],32:[2,9],34:[2,9]},{25:[2,44],37:72,47:73,48:58,49:60,50:[1,74]},{25:[1,75]},{18:[2,23],25:[2,23],33:[2,23],42:[2,23],43:[2,23],44:[2,23],45:[2,23],46:[2,23],50:[2,23],52:[2,23]},{18:[2,24],25:[2,24],33:[2,24],42:[2,24],43:[2,24],44:[2,24],45:[2,24],46:[2,24],50:[2,24],52:[2,24]},{18:[2,25],25:[2,25],33:[2,25],42:[2,25],43:[2,25],44:[2,25],45:[2,25],46:[2,25],50:[2,25],52:[2,25]},{18:[2,26],25:[2,26],33:[2,26],42:[2,26],43:[2,26],44:[2,26],45:[2,26],46:[2,26],50:[2,26],52:[2,26]},{18:[2,27],25:[2,27],33:[2,27],42:[2,27],43:[2,27],44:[2,27],45:[2,27],46:[2,27],50:[2,27],52:[2,27]},{17:76,30:22,41:23,50:[1,26],52:[1,25],53:24},{25:[2,47]},{18:[2,29],25:[2,29],33:[2,29],46:[2,29],49:77,50:[1,74]},{18:[2,37],25:[2,37],33:[2,37],42:[2,37],43:[2,37],44:[2,37],45:[2,37],46:[2,37],50:[2,37],51:[1,78],52:[2,37],54:[2,37]},{18:[2,52],25:[2,52],33:[2,52],46:[2,52],50:[2,52]},{12:[2,13],13:[2,13],16:[2,13],24:[2,13],26:[2,13],28:[2,13],29:[2,13],31:[2,13],32:[2,13],34:[2,13]},{12:[2,14],13:[2,14],16:[2,14],24:[2,14],26:[2,14],28:[2,14],29:[2,14],31:[2,14],32:[2,14],34:[2,14]},{12:[2,10]},{18:[2,21],25:[2,21],33:[2,21],46:[2,21]},{18:[2,49],25:[2,49],33:[2,49],42:[2,49],43:[2,49],44:[2,49],45:[2,49],46:[2,49],50:[2,49],52:[2,49]},{18:[2,51],25:[2,51],33:[2,51],46:[2,51]},{18:[2,36],25:[2,36],33:[2,36],42:[2,36],43:[2,36],44:[2,36],45:[2,36],46:[2,36],50:[2,36],52:[2,36],54:[2,36]},{5:[2,11],12:[2,11],13:[2,11],16:[2,11],24:[2,11],26:[2,11],28:[2,11],29:[2,11],31:[2,11],32:[2,11],34:[2,11]},{30:79,50:[1,26],53:24},{29:[2,15]},{5:[2,12],12:[2,12],13:[2,12],16:[2,12],24:[2,12],26:[2,12],28:[2,12],29:[2,12],31:[2,12],32:[2,12],34:[2,12]},{25:[1,80]},{25:[2,45]},{51:[1,78]},{5:[2,20],12:[2,20],13:[2,20],16:[2,20],24:[2,20],26:[2,20],28:[2,20],29:[2,20],31:[2,20],32:[2,20],34:[2,20]},{46:[1,81]},{18:[2,53],25:[2,53],33:[2,53],46:[2,53],50:[2,53]},{30:51,36:82,41:55,42:[1,52],43:[1,53],44:[1,54],45:[1,56],50:[1,26],52:[1,25],53:24},{25:[1,83]},{5:[2,19],12:[2,19],13:[2,19],16:[2,19],24:[2,19],26:[2,19],28:[2,19],29:[2,19],31:[2,19],32:[2,19],34:[2,19]},{18:[2,28],25:[2,28],33:[2,28],42:[2,28],43:[2,28],44:[2,28],45:[2,28],46:[2,28],50:[2,28],52:[2,28]},{18:[2,30],25:[2,30],33:[2,30],46:[2,30],50:[2,30]},{5:[2,16],12:[2,16],13:[2,16],16:[2,16],24:[2,16],26:[2,16],28:[2,16],29:[2,16],31:[2,16],32:[2,16],34:[2,16]}],defaultActions:{4:[2,1],44:[2,41],47:[2,43],57:[2,47],63:[2,10],70:[2,15],73:[2,45]},parseError:function(a){throw new Error(a)},parse:function(a){function b(){var a;return a=c.lexer.lex()||1,"number"!=typeof a&&(a=c.symbols_[a]||a),a}var c=this,d=[0],e=[null],f=[],g=this.table,h="",i=0,j=0,k=0;this.lexer.setInput(a),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,this.yy.parser=this,"undefined"==typeof this.lexer.yylloc&&(this.lexer.yylloc={});var l=this.lexer.yylloc;f.push(l);var m=this.lexer.options&&this.lexer.options.ranges;"function"==typeof this.yy.parseError&&(this.parseError=this.yy.parseError);for(var n,o,p,q,r,s,t,u,v,w={};;){if(p=d[d.length-1],this.defaultActions[p]?q=this.defaultActions[p]:((null===n||"undefined"==typeof n)&&(n=b()),q=g[p]&&g[p][n]),"undefined"==typeof q||!q.length||!q[0]){var x="";if(!k){v=[];for(s in g[p])this.terminals_[s]&&s>2&&v.push("'"+this.terminals_[s]+"'");x=this.lexer.showPosition?"Parse error on line "+(i+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+v.join(", ")+", got '"+(this.terminals_[n]||n)+"'":"Parse error on line "+(i+1)+": Unexpected "+(1==n?"end of input":"'"+(this.terminals_[n]||n)+"'"),this.parseError(x,{text:this.lexer.match,token:this.terminals_[n]||n,line:this.lexer.yylineno,loc:l,expected:v})}}if(q[0]instanceof Array&&q.length>1)throw new Error("Parse Error: multiple actions possible at state: "+p+", token: "+n);switch(q[0]){case 1:d.push(n),e.push(this.lexer.yytext),f.push(this.lexer.yylloc),d.push(q[1]),n=null,o?(n=o,o=null):(j=this.lexer.yyleng,h=this.lexer.yytext,i=this.lexer.yylineno,l=this.lexer.yylloc,k>0&&k--);break;case 2:if(t=this.productions_[q[1]][1],w.$=e[e.length-t],w._$={first_line:f[f.length-(t||1)].first_line,last_line:f[f.length-1].last_line,first_column:f[f.length-(t||1)].first_column,last_column:f[f.length-1].last_column},m&&(w._$.range=[f[f.length-(t||1)].range[0],f[f.length-1].range[1]]),r=this.performAction.call(w,h,j,i,this.yy,q[1],e,f),"undefined"!=typeof r)return r;t&&(d=d.slice(0,-1*t*2),e=e.slice(0,-1*t),f=f.slice(0,-1*t)),d.push(this.productions_[q[1]][0]),e.push(w.$),f.push(w._$),u=g[d[d.length-2]][d[d.length-1]],d.push(u);break;case 3:return!0}}return!0}},c=function(){var a={EOF:1,parseError:function(a,b){if(!this.yy.parser)throw new Error(a);this.yy.parser.parseError(a,b)},setInput:function(a){return this._input=a,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this.options.ranges&&(this.yylloc.range=[0,0]),this.offset=0,this},input:function(){var a=this._input[0];this.yytext+=a,this.yyleng++,this.offset++,this.match+=a,this.matched+=a;var b=a.match(/(?:\r\n?|\n).*/g);return b?(this.yylineno++,this.yylloc.last_line++):this.yylloc.last_column++,this.options.ranges&&this.yylloc.range[1]++,this._input=this._input.slice(1),a},unput:function(a){var b=a.length,c=a.split(/(?:\r\n?|\n)/g);this._input=a+this._input,this.yytext=this.yytext.substr(0,this.yytext.length-b-1),this.offset-=b;var d=this.match.split(/(?:\r\n?|\n)/g);this.match=this.match.substr(0,this.match.length-1),this.matched=this.matched.substr(0,this.matched.length-1),c.length-1&&(this.yylineno-=c.length-1);var e=this.yylloc.range;return this.yylloc={first_line:this.yylloc.first_line,last_line:this.yylineno+1,first_column:this.yylloc.first_column,last_column:c?(c.length===d.length?this.yylloc.first_column:0)+d[d.length-c.length].length-c[0].length:this.yylloc.first_column-b},this.options.ranges&&(this.yylloc.range=[e[0],e[0]+this.yyleng-b]),this},more:function(){return this._more=!0,this},less:function(a){this.unput(this.match.slice(a))},pastInput:function(){var a=this.matched.substr(0,this.matched.length-this.match.length);return(a.length>20?"...":"")+a.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var a=this.match;return a.length<20&&(a+=this._input.substr(0,20-a.length)),(a.substr(0,20)+(a.length>20?"...":"")).replace(/\n/g,"")},showPosition:function(){var a=this.pastInput(),b=new Array(a.length+1).join("-");return a+this.upcomingInput()+"\n"+b+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0);var a,b,c,d,e;this._more||(this.yytext="",this.match="");for(var f=this._currentRules(),g=0;g<f.length&&(c=this._input.match(this.rules[f[g]]),!c||b&&!(c[0].length>b[0].length)||(b=c,d=g,this.options.flex));g++);return b?(e=b[0].match(/(?:\r\n?|\n).*/g),e&&(this.yylineno+=e.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:e?e[e.length-1].length-e[e.length-1].match(/\r?\n?/)[0].length:this.yylloc.last_column+b[0].length},this.yytext+=b[0],this.match+=b[0],this.matches=b,this.yyleng=this.yytext.length,this.options.ranges&&(this.yylloc.range=[this.offset,this.offset+=this.yyleng]),this._more=!1,this._input=this._input.slice(b[0].length),this.matched+=b[0],a=this.performAction.call(this,this.yy,this,f[d],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),a?a:void 0):""===this._input?this.EOF:this.parseError("Lexical error on line "+(this.yylineno+1)+". Unrecognized text.\n"+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var a=this.next();return"undefined"!=typeof a?a:this.lex()},begin:function(a){this.conditionStack.push(a)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(a){this.begin(a)}};return a.options={},a.performAction=function(a,b,c,d){function e(a,c){return b.yytext=b.yytext.substr(a,b.yyleng-c)}switch(c){case 0:if("\\\\"===b.yytext.slice(-2)?(e(0,1),this.begin("mu")):"\\"===b.yytext.slice(-1)?(e(0,1),this.begin("emu")):this.begin("mu"),b.yytext)return 12;break;case 1:return 12;case 2:return this.popState(),12;case 3:return b.yytext=b.yytext.substr(5,b.yyleng-9),this.popState(),15;case 4:return 12;case 5:return e(0,4),this.popState(),13;case 6:return 45;case 7:return 46;case 8:return 16;case 9:return this.popState(),this.begin("raw"),18;case 10:return 34;case 11:return 24;case 12:return 29;case 13:return this.popState(),28;case 14:return this.popState(),28;case 15:return 26;case 16:return 26;case 17:return 32;case 18:return 31;case 19:this.popState(),this.begin("com");break;case 20:return e(3,5),this.popState(),13;case 21:return 31;case 22:return 51;case 23:return 50;case 24:return 50;case 25:return 54;case 26:break;case 27:return this.popState(),33;case 28:return this.popState(),25;case 29:return b.yytext=e(1,2).replace(/\\"/g,'"'),42;case 30:return b.yytext=e(1,2).replace(/\\'/g,"'"),42;case 31:return 52;case 32:return 44;case 33:return 44;case 34:return 43;case 35:return 50;case 36:return b.yytext=e(1,2),50;case 37:return"INVALID";case 38:return 5}},a.rules=[/^(?:[^\x00]*?(?=(\{\{)))/,/^(?:[^\x00]+)/,/^(?:[^\x00]{2,}?(?=(\{\{|\\\{\{|\\\\\{\{|$)))/,/^(?:\{\{\{\{\/[^\s!"#%-,\.\/;->@\[-\^`\{-~]+(?=[=}\s\/.])\}\}\}\})/,/^(?:[^\x00]*?(?=(\{\{\{\{\/)))/,/^(?:[\s\S]*?--\}\})/,/^(?:\()/,/^(?:\))/,/^(?:\{\{\{\{)/,/^(?:\}\}\}\})/,/^(?:\{\{(~)?>)/,/^(?:\{\{(~)?#)/,/^(?:\{\{(~)?\/)/,/^(?:\{\{(~)?\^\s*(~)?\}\})/,/^(?:\{\{(~)?\s*else\s*(~)?\}\})/,/^(?:\{\{(~)?\^)/,/^(?:\{\{(~)?\s*else\b)/,/^(?:\{\{(~)?\{)/,/^(?:\{\{(~)?&)/,/^(?:\{\{!--)/,/^(?:\{\{![\s\S]*?\}\})/,/^(?:\{\{(~)?)/,/^(?:=)/,/^(?:\.\.)/,/^(?:\.(?=([=~}\s\/.)])))/,/^(?:[\/.])/,/^(?:\s+)/,/^(?:\}(~)?\}\})/,/^(?:(~)?\}\})/,/^(?:"(\\["]|[^"])*")/,/^(?:'(\\[']|[^'])*')/,/^(?:@)/,/^(?:true(?=([~}\s)])))/,/^(?:false(?=([~}\s)])))/,/^(?:-?[0-9]+(?:\.[0-9]+)?(?=([~}\s)])))/,/^(?:([^\s!"#%-,\.\/;->@\[-\^`\{-~]+(?=([=~}\s\/.)]))))/,/^(?:\[[^\]]*\])/,/^(?:.)/,/^(?:$)/],a.conditions={mu:{rules:[6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38],inclusive:!1},emu:{rules:[2],inclusive:!1},com:{rules:[5],inclusive:!1},raw:{rules:[3,4],inclusive:!1},INITIAL:{rules:[0,1,38],inclusive:!0}},a}();return b.lexer=c,a.prototype=b,b.Parser=a,new a}();return a=b}(),i=function(a){"use strict";function b(a,b){return{left:"~"===a.charAt(2),right:"~"===b.charAt(b.length-3)}}function c(a,b,c,d,i,k){if(a.sexpr.id.original!==d.path.original)throw new j(a.sexpr.id.original+" doesn't match "+d.path.original,a);var l=c&&c.program,m={left:a.strip.left,right:d.strip.right,openStandalone:f(b.statements),closeStandalone:e((l||b).statements)};if(a.strip.right&&g(b.statements,null,!0),l){var n=c.strip;n.left&&h(b.statements,null,!0),n.right&&g(l.statements,null,!0),d.strip.left&&h(l.statements,null,!0),e(b.statements)&&f(l.statements)&&(h(b.statements),g(l.statements))}else d.strip.left&&h(b.statements,null,!0);return i?new this.BlockNode(a,l,b,m,k):new this.BlockNode(a,b,l,m,k)}function d(a,b){for(var c=0,d=a.length;d>c;c++){var i=a[c],j=i.strip;if(j){var k=e(a,c,b,"partial"===i.type),l=f(a,c,b),m=j.openStandalone&&k,n=j.closeStandalone&&l,o=j.inlineStandalone&&k&&l;j.right&&g(a,c,!0),j.left&&h(a,c,!0),o&&(g(a,c),h(a,c)&&"partial"===i.type&&(i.indent=/([ \t]+$)/.exec(a[c-1].original)?RegExp.$1:"")),m&&(g((i.program||i.inverse).statements),h(a,c)),n&&(g(a,c),h((i.inverse||i.program).statements))}}return a}function e(a,b,c){void 0===b&&(b=a.length);var d=a[b-1],e=a[b-2];return d?"content"===d.type?(e||!c?/\r?\n\s*?$/:/(^|\r?\n)\s*?$/).test(d.original):void 0:c}function f(a,b,c){void 0===b&&(b=-1);var d=a[b+1],e=a[b+2];return d?"content"===d.type?(e||!c?/^\s*?\r?\n/:/^\s*?(\r?\n|$)/).test(d.original):void 0:c}function g(a,b,c){var d=a[null==b?0:b+1];if(d&&"content"===d.type&&(c||!d.rightStripped)){var e=d.string;d.string=d.string.replace(c?/^\s+/:/^[ \t]*\r?\n?/,""),d.rightStripped=d.string!==e}}function h(a,b,c){var d=a[null==b?a.length-1:b-1];if(d&&"content"===d.type&&(c||!d.leftStripped)){var e=d.string;return d.string=d.string.replace(c?/\s+$/:/[ \t]+$/,""),d.leftStripped=d.string!==e,d.leftStripped}}var i={},j=a;return i.stripFlags=b,i.prepareBlock=c,i.prepareProgram=d,i}(c),j=function(a,b,c,d){"use strict";function e(a){return a.constructor===h.ProgramNode?a:(g.yy=k,g.parse(a))}var f={},g=a,h=b,i=c,j=d.extend;f.parser=g;var k={};return j(k,i,h),f.parse=e,f}(h,g,i,b),k=function(a,b){"use strict";function c(){}function d(a,b,c){if(null==a||"string"!=typeof a&&a.constructor!==c.AST.ProgramNode)throw new h("You must pass a string or Handlebars AST to Handlebars.precompile. You passed "+a);b=b||{},"data"in b||(b.data=!0),b.compat&&(b.useDepths=!0);var d=c.parse(a),e=(new c.Compiler).compile(d,b);return(new c.JavaScriptCompiler).compile(e,b)}function e(a,b,c){function d(){var d=c.parse(a),e=(new c.Compiler).compile(d,b),f=(new c.JavaScriptCompiler).compile(e,b,void 0,!0);return c.template(f)}if(null==a||"string"!=typeof a&&a.constructor!==c.AST.ProgramNode)throw new h("You must pass a string or Handlebars AST to Handlebars.compile. You passed "+a);b=b||{},"data"in b||(b.data=!0),b.compat&&(b.useDepths=!0);var e,f=function(a,b){return e||(e=d()),e.call(this,a,b)};return f._setup=function(a){return e||(e=d()),e._setup(a)},f._child=function(a,b,c){return e||(e=d()),e._child(a,b,c)},f}function f(a,b){if(a===b)return!0;if(i(a)&&i(b)&&a.length===b.length){for(var c=0;c<a.length;c++)if(!f(a[c],b[c]))return!1;return!0}}var g={},h=a,i=b.isArray,j=[].slice;return g.Compiler=c,c.prototype={compiler:c,equals:function(a){var b=this.opcodes.length;if(a.opcodes.length!==b)return!1;for(var c=0;b>c;c++){var d=this.opcodes[c],e=a.opcodes[c];if(d.opcode!==e.opcode||!f(d.args,e.args))return!1}for(b=this.children.length,c=0;b>c;c++)if(!this.children[c].equals(a.children[c]))return!1;return!0},guid:0,compile:function(a,b){this.opcodes=[],this.children=[],this.depths={list:[]},this.options=b,this.stringParams=b.stringParams,this.trackIds=b.trackIds;var c=this.options.knownHelpers;if(this.options.knownHelpers={helperMissing:!0,blockHelperMissing:!0,each:!0,"if":!0,unless:!0,"with":!0,log:!0,lookup:!0},c)for(var d in c)this.options.knownHelpers[d]=c[d];return this.accept(a)},accept:function(a){return this[a.type](a)},program:function(a){for(var b=a.statements,c=0,d=b.length;d>c;c++)this.accept(b[c]);return this.isSimple=1===d,this.depths.list=this.depths.list.sort(function(a,b){return a-b}),this},compileProgram:function(a){var b,c=(new this.compiler).compile(a,this.options),d=this.guid++;
this.usePartial=this.usePartial||c.usePartial,this.children[d]=c;for(var e=0,f=c.depths.list.length;f>e;e++)b=c.depths.list[e],2>b||this.addDepth(b-1);return d},block:function(a){var b=a.mustache,c=a.program,d=a.inverse;c&&(c=this.compileProgram(c)),d&&(d=this.compileProgram(d));var e=b.sexpr,f=this.classifySexpr(e);"helper"===f?this.helperSexpr(e,c,d):"simple"===f?(this.simpleSexpr(e),this.opcode("pushProgram",c),this.opcode("pushProgram",d),this.opcode("emptyHash"),this.opcode("blockValue",e.id.original)):(this.ambiguousSexpr(e,c,d),this.opcode("pushProgram",c),this.opcode("pushProgram",d),this.opcode("emptyHash"),this.opcode("ambiguousBlockValue")),this.opcode("append")},hash:function(a){var b,c,d=a.pairs;for(this.opcode("pushHash"),b=0,c=d.length;c>b;b++)this.pushParam(d[b][1]);for(;b--;)this.opcode("assignToHash",d[b][0]);this.opcode("popHash")},partial:function(a){var b=a.partialName;this.usePartial=!0,a.hash?this.accept(a.hash):this.opcode("push","undefined"),a.context?this.accept(a.context):(this.opcode("getContext",0),this.opcode("pushContext")),this.opcode("invokePartial",b.name,a.indent||""),this.opcode("append")},content:function(a){a.string&&this.opcode("appendContent",a.string)},mustache:function(a){this.sexpr(a.sexpr),a.escaped&&!this.options.noEscape?this.opcode("appendEscaped"):this.opcode("append")},ambiguousSexpr:function(a,b,c){var d=a.id,e=d.parts[0],f=null!=b||null!=c;this.opcode("getContext",d.depth),this.opcode("pushProgram",b),this.opcode("pushProgram",c),this.ID(d),this.opcode("invokeAmbiguous",e,f)},simpleSexpr:function(a){var b=a.id;"DATA"===b.type?this.DATA(b):b.parts.length?this.ID(b):(this.addDepth(b.depth),this.opcode("getContext",b.depth),this.opcode("pushContext")),this.opcode("resolvePossibleLambda")},helperSexpr:function(a,b,c){var d=this.setupFullMustacheParams(a,b,c),e=a.id,f=e.parts[0];if(this.options.knownHelpers[f])this.opcode("invokeKnownHelper",d.length,f);else{if(this.options.knownHelpersOnly)throw new h("You specified knownHelpersOnly, but used the unknown helper "+f,a);e.falsy=!0,this.ID(e),this.opcode("invokeHelper",d.length,e.original,e.isSimple)}},sexpr:function(a){var b=this.classifySexpr(a);"simple"===b?this.simpleSexpr(a):"helper"===b?this.helperSexpr(a):this.ambiguousSexpr(a)},ID:function(a){this.addDepth(a.depth),this.opcode("getContext",a.depth);var b=a.parts[0];b?this.opcode("lookupOnContext",a.parts,a.falsy,a.isScoped):this.opcode("pushContext")},DATA:function(a){this.options.data=!0,this.opcode("lookupData",a.id.depth,a.id.parts)},STRING:function(a){this.opcode("pushString",a.string)},NUMBER:function(a){this.opcode("pushLiteral",a.number)},BOOLEAN:function(a){this.opcode("pushLiteral",a.bool)},comment:function(){},opcode:function(a){this.opcodes.push({opcode:a,args:j.call(arguments,1)})},addDepth:function(a){0!==a&&(this.depths[a]||(this.depths[a]=!0,this.depths.list.push(a)))},classifySexpr:function(a){var b=a.isHelper,c=a.eligibleHelper,d=this.options;if(c&&!b){var e=a.id.parts[0];d.knownHelpers[e]?b=!0:d.knownHelpersOnly&&(c=!1)}return b?"helper":c?"ambiguous":"simple"},pushParams:function(a){for(var b=0,c=a.length;c>b;b++)this.pushParam(a[b])},pushParam:function(a){this.stringParams?(a.depth&&this.addDepth(a.depth),this.opcode("getContext",a.depth||0),this.opcode("pushStringParam",a.stringModeValue,a.type),"sexpr"===a.type&&this.sexpr(a)):(this.trackIds&&this.opcode("pushId",a.type,a.idName||a.stringModeValue),this.accept(a))},setupFullMustacheParams:function(a,b,c){var d=a.params;return this.pushParams(d),this.opcode("pushProgram",b),this.opcode("pushProgram",c),a.hash?this.hash(a.hash):this.opcode("emptyHash"),d}},g.precompile=d,g.compile=e,g}(c,b),l=function(a,b){"use strict";function c(a){this.value=a}function d(){}var e,f=a.COMPILER_REVISION,g=a.REVISION_CHANGES,h=b;d.prototype={nameLookup:function(a,b){return d.isValidJavaScriptVariableName(b)?a+"."+b:a+"['"+b+"']"},depthedLookup:function(a){return this.aliases.lookup="this.lookup",'lookup(depths, "'+a+'")'},compilerInfo:function(){var a=f,b=g[a];return[a,b]},appendToBuffer:function(a){return this.environment.isSimple?"return "+a+";":{appendToBuffer:!0,content:a,toString:function(){return"buffer += "+a+";"}}},initializeBuffer:function(){return this.quotedString("")},namespace:"Handlebars",compile:function(a,b,c,d){this.environment=a,this.options=b,this.stringParams=this.options.stringParams,this.trackIds=this.options.trackIds,this.precompile=!d,this.name=this.environment.name,this.isChild=!!c,this.context=c||{programs:[],environments:[]},this.preamble(),this.stackSlot=0,this.stackVars=[],this.aliases={},this.registers={list:[]},this.hashes=[],this.compileStack=[],this.inlineStack=[],this.compileChildren(a,b),this.useDepths=this.useDepths||a.depths.list.length||this.options.compat;var e,f,g,i=a.opcodes;for(f=0,g=i.length;g>f;f++)e=i[f],this[e.opcode].apply(this,e.args);if(this.pushSource(""),this.stackSlot||this.inlineStack.length||this.compileStack.length)throw new h("Compile completed with content left on stack");var j=this.createFunctionContext(d);if(this.isChild)return j;var k={compiler:this.compilerInfo(),main:j},l=this.context.programs;for(f=0,g=l.length;g>f;f++)l[f]&&(k[f]=l[f]);return this.environment.usePartial&&(k.usePartial=!0),this.options.data&&(k.useData=!0),this.useDepths&&(k.useDepths=!0),this.options.compat&&(k.compat=!0),d||(k.compiler=JSON.stringify(k.compiler),k=this.objectLiteral(k)),k},preamble:function(){this.lastContext=0,this.source=[]},createFunctionContext:function(a){var b="",c=this.stackVars.concat(this.registers.list);c.length>0&&(b+=", "+c.join(", "));for(var d in this.aliases)this.aliases.hasOwnProperty(d)&&(b+=", "+d+"="+this.aliases[d]);var e=["depth0","helpers","partials","data"];this.useDepths&&e.push("depths");var f=this.mergeSource(b);return a?(e.push(f),Function.apply(this,e)):"function("+e.join(",")+") {\n  "+f+"}"},mergeSource:function(a){for(var b,c,d="",e=!this.forceBuffer,f=0,g=this.source.length;g>f;f++){var h=this.source[f];h.appendToBuffer?b=b?b+"\n    + "+h.content:h.content:(b&&(d?d+="buffer += "+b+";\n  ":(c=!0,d=b+";\n  "),b=void 0),d+=h+"\n  ",this.environment.isSimple||(e=!1))}return e?(b||!d)&&(d+="return "+(b||'""')+";\n"):(a+=", buffer = "+(c?"":this.initializeBuffer()),d+=b?"return buffer + "+b+";\n":"return buffer;\n"),a&&(d="var "+a.substring(2)+(c?"":";\n  ")+d),d},blockValue:function(a){this.aliases.blockHelperMissing="helpers.blockHelperMissing";var b=[this.contextName(0)];this.setupParams(a,0,b);var c=this.popStack();b.splice(1,0,c),this.push("blockHelperMissing.call("+b.join(", ")+")")},ambiguousBlockValue:function(){this.aliases.blockHelperMissing="helpers.blockHelperMissing";var a=[this.contextName(0)];this.setupParams("",0,a,!0),this.flushInline();var b=this.topStack();a.splice(1,0,b),this.pushSource("if (!"+this.lastHelper+") { "+b+" = blockHelperMissing.call("+a.join(", ")+"); }")},appendContent:function(a){this.pendingContent&&(a=this.pendingContent+a),this.pendingContent=a},append:function(){this.flushInline();var a=this.popStack();this.pushSource("if ("+a+" != null) { "+this.appendToBuffer(a)+" }"),this.environment.isSimple&&this.pushSource("else { "+this.appendToBuffer("''")+" }")},appendEscaped:function(){this.aliases.escapeExpression="this.escapeExpression",this.pushSource(this.appendToBuffer("escapeExpression("+this.popStack()+")"))},getContext:function(a){this.lastContext=a},pushContext:function(){this.pushStackLiteral(this.contextName(this.lastContext))},lookupOnContext:function(a,b,c){var d=0,e=a.length;for(c||!this.options.compat||this.lastContext?this.pushContext():this.push(this.depthedLookup(a[d++]));e>d;d++)this.replaceStack(function(c){var e=this.nameLookup(c,a[d],"context");return b?" && "+e:" != null ? "+e+" : "+c})},lookupData:function(a,b){a?this.pushStackLiteral("this.data(data, "+a+")"):this.pushStackLiteral("data");for(var c=b.length,d=0;c>d;d++)this.replaceStack(function(a){return" && "+this.nameLookup(a,b[d],"data")})},resolvePossibleLambda:function(){this.aliases.lambda="this.lambda",this.push("lambda("+this.popStack()+", "+this.contextName(0)+")")},pushStringParam:function(a,b){this.pushContext(),this.pushString(b),"sexpr"!==b&&("string"==typeof a?this.pushString(a):this.pushStackLiteral(a))},emptyHash:function(){this.pushStackLiteral("{}"),this.trackIds&&this.push("{}"),this.stringParams&&(this.push("{}"),this.push("{}"))},pushHash:function(){this.hash&&this.hashes.push(this.hash),this.hash={values:[],types:[],contexts:[],ids:[]}},popHash:function(){var a=this.hash;this.hash=this.hashes.pop(),this.trackIds&&this.push("{"+a.ids.join(",")+"}"),this.stringParams&&(this.push("{"+a.contexts.join(",")+"}"),this.push("{"+a.types.join(",")+"}")),this.push("{\n    "+a.values.join(",\n    ")+"\n  }")},pushString:function(a){this.pushStackLiteral(this.quotedString(a))},push:function(a){return this.inlineStack.push(a),a},pushLiteral:function(a){this.pushStackLiteral(a)},pushProgram:function(a){null!=a?this.pushStackLiteral(this.programExpression(a)):this.pushStackLiteral(null)},invokeHelper:function(a,b,c){this.aliases.helperMissing="helpers.helperMissing";var d=this.popStack(),e=this.setupHelper(a,b),f=(c?e.name+" || ":"")+d+" || helperMissing";this.push("(("+f+").call("+e.callParams+"))")},invokeKnownHelper:function(a,b){var c=this.setupHelper(a,b);this.push(c.name+".call("+c.callParams+")")},invokeAmbiguous:function(a,b){this.aliases.functionType='"function"',this.aliases.helperMissing="helpers.helperMissing",this.useRegister("helper");var c=this.popStack();this.emptyHash();var d=this.setupHelper(0,a,b),e=this.lastHelper=this.nameLookup("helpers",a,"helper");this.push("((helper = (helper = "+e+" || "+c+") != null ? helper : helperMissing"+(d.paramsInit?"),("+d.paramsInit:"")+"),(typeof helper === functionType ? helper.call("+d.callParams+") : helper))")},invokePartial:function(a,b){var c=[this.nameLookup("partials",a,"partial"),"'"+b+"'","'"+a+"'",this.popStack(),this.popStack(),"helpers","partials"];this.options.data?c.push("data"):this.options.compat&&c.push("undefined"),this.options.compat&&c.push("depths"),this.push("this.invokePartial("+c.join(", ")+")")},assignToHash:function(a){var b,c,d,e=this.popStack();this.trackIds&&(d=this.popStack()),this.stringParams&&(c=this.popStack(),b=this.popStack());var f=this.hash;b&&f.contexts.push("'"+a+"': "+b),c&&f.types.push("'"+a+"': "+c),d&&f.ids.push("'"+a+"': "+d),f.values.push("'"+a+"': ("+e+")")},pushId:function(a,b){"ID"===a||"DATA"===a?this.pushString(b):"sexpr"===a?this.pushStackLiteral("true"):this.pushStackLiteral("null")},compiler:d,compileChildren:function(a,b){for(var c,d,e=a.children,f=0,g=e.length;g>f;f++){c=e[f],d=new this.compiler;var h=this.matchExistingProgram(c);null==h?(this.context.programs.push(""),h=this.context.programs.length,c.index=h,c.name="program"+h,this.context.programs[h]=d.compile(c,b,this.context,!this.precompile),this.context.environments[h]=c,this.useDepths=this.useDepths||d.useDepths):(c.index=h,c.name="program"+h)}},matchExistingProgram:function(a){for(var b=0,c=this.context.environments.length;c>b;b++){var d=this.context.environments[b];if(d&&d.equals(a))return b}},programExpression:function(a){var b=this.environment.children[a],c=(b.depths.list,this.useDepths),d=[b.index,"data"];return c&&d.push("depths"),"this.program("+d.join(", ")+")"},useRegister:function(a){this.registers[a]||(this.registers[a]=!0,this.registers.list.push(a))},pushStackLiteral:function(a){return this.push(new c(a))},pushSource:function(a){this.pendingContent&&(this.source.push(this.appendToBuffer(this.quotedString(this.pendingContent))),this.pendingContent=void 0),a&&this.source.push(a)},pushStack:function(a){this.flushInline();var b=this.incrStack();return this.pushSource(b+" = "+a+";"),this.compileStack.push(b),b},replaceStack:function(a){{var b,d,e,f="";this.isInline()}if(!this.isInline())throw new h("replaceStack on non-inline");var g=this.popStack(!0);if(g instanceof c)f=b=g.value,e=!0;else{d=!this.stackSlot;var i=d?this.incrStack():this.topStackName();f="("+this.push(i)+" = "+g+")",b=this.topStack()}var j=a.call(this,b);e||this.popStack(),d&&this.stackSlot--,this.push("("+f+j+")")},incrStack:function(){return this.stackSlot++,this.stackSlot>this.stackVars.length&&this.stackVars.push("stack"+this.stackSlot),this.topStackName()},topStackName:function(){return"stack"+this.stackSlot},flushInline:function(){var a=this.inlineStack;if(a.length){this.inlineStack=[];for(var b=0,d=a.length;d>b;b++){var e=a[b];e instanceof c?this.compileStack.push(e):this.pushStack(e)}}},isInline:function(){return this.inlineStack.length},popStack:function(a){var b=this.isInline(),d=(b?this.inlineStack:this.compileStack).pop();if(!a&&d instanceof c)return d.value;if(!b){if(!this.stackSlot)throw new h("Invalid stack pop");this.stackSlot--}return d},topStack:function(){var a=this.isInline()?this.inlineStack:this.compileStack,b=a[a.length-1];return b instanceof c?b.value:b},contextName:function(a){return this.useDepths&&a?"depths["+a+"]":"depth"+a},quotedString:function(a){return'"'+a.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\u2028/g,"\\u2028").replace(/\u2029/g,"\\u2029")+'"'},objectLiteral:function(a){var b=[];for(var c in a)a.hasOwnProperty(c)&&b.push(this.quotedString(c)+":"+a[c]);return"{"+b.join(",")+"}"},setupHelper:function(a,b,c){var d=[],e=this.setupParams(b,a,d,c),f=this.nameLookup("helpers",b,"helper");return{params:d,paramsInit:e,name:f,callParams:[this.contextName(0)].concat(d).join(", ")}},setupOptions:function(a,b,c){var d,e,f,g={},h=[],i=[],j=[];g.name=this.quotedString(a),g.hash=this.popStack(),this.trackIds&&(g.hashIds=this.popStack()),this.stringParams&&(g.hashTypes=this.popStack(),g.hashContexts=this.popStack()),e=this.popStack(),f=this.popStack(),(f||e)&&(f||(f="this.noop"),e||(e="this.noop"),g.fn=f,g.inverse=e);for(var k=b;k--;)d=this.popStack(),c[k]=d,this.trackIds&&(j[k]=this.popStack()),this.stringParams&&(i[k]=this.popStack(),h[k]=this.popStack());return this.trackIds&&(g.ids="["+j.join(",")+"]"),this.stringParams&&(g.types="["+i.join(",")+"]",g.contexts="["+h.join(",")+"]"),this.options.data&&(g.data="data"),g},setupParams:function(a,b,c,d){var e=this.objectLiteral(this.setupOptions(a,b,c));return d?(this.useRegister("options"),c.push("options"),"options="+e):(c.push(e),"")}};for(var i="break else new var case finally return void catch for switch while continue function this with default if throw delete in try do instanceof typeof abstract enum int short boolean export interface static byte extends long super char final native synchronized class float package throws const goto private transient debugger implements protected volatile double import public let yield".split(" "),j=d.RESERVED_WORDS={},k=0,l=i.length;l>k;k++)j[i[k]]=!0;return d.isValidJavaScriptVariableName=function(a){return!d.RESERVED_WORDS[a]&&/^[a-zA-Z_$][0-9a-zA-Z_$]*$/.test(a)},e=d}(d,c),m=function(a,b,c,d,e){"use strict";var f,g=a,h=b,i=c.parser,j=c.parse,k=d.Compiler,l=d.compile,m=d.precompile,n=e,o=g.create,p=function(){var a=o();return a.compile=function(b,c){return l(b,c,a)},a.precompile=function(b,c){return m(b,c,a)},a.AST=h,a.Compiler=k,a.JavaScriptCompiler=n,a.Parser=i,a.parse=j,a};return g=p(),g.create=p,g["default"]=g,f=g}(f,g,j,k,l);return m});
},{}]},{},[1]);
