
var fruits = new Array();
var score = 0;
var scoreText;
var level = 1;
var levelText;
var heart1;
var heart2;
var heart3;
var gameEnd = false;
var fruitsQuantity = 0;
var delayTime = 0;
var groupCount = 0;

var state_game = {

	preload: function() {

		game.load.image('background', 'assets/background.png');
		game.load.spritesheet('fruit', 'assets/fruit.png', 48, 60);
		game.load.spritesheet('badfruit', 'assets/badfruit.png', 48, 60);
		game.load.image('btn_pause', 'assets/btn_pause.png');
		game.load.image('btn_restart', 'assets/btn_restart.png');
		game.load.image('heart', 'assets/heart.png');
		game.load.spritesheet('pointup', 'assets/pointup.png', 48, 16);
		game.load.image('newhiscore', 'assets/newhiscore.png');
		game.load.image('yourscore', 'assets/yourscore.png');
	},

	create: function() {

		game.add.sprite(0, 0, 'background');	

		score = 0;
		level = 1;
		fruits.length = 0;
		gameEnd = false;
		fruitsQuantity = 0;
		levelText = game.add.text(16, 16, 'Level: 1', {font: '24px Sans', fill: '#fff'});
		scoreText = game.add.text(16, 48, 'Score: 0', {font: '24px Sans', fill: '#fff'});

		heart1 = game.add.sprite(272, 432, 'heart');
		heart2 = game.add.sprite(232, 432, 'heart');
		heart3 = game.add.sprite(192, 432, 'heart');

		var btn_pause = game.add.sprite(232, 16, 'btn_pause');

		btn_pause.inputEnabled = true;
		btn_pause.events.onInputDown.add(function() {

			game.paused = true;			
		});

		var btn_restart = game.add.sprite(272, 16, 'btn_restart');

		btn_restart.inputEnabled = true;
		btn_restart.events.onInputDown.add(function() {

			game.state.start('game');
		})
	},

	update: function() {

		if (gameEnd) {
			return;
		}

		if (groupCount >= 7) {
			level++;
			groupCount = 0;
		}

		if (fruitsQuantity <= 0) {
			delayTime += game.time.elapsed;
		}
		
		if (delayTime >= 1000 && fruitsQuantity <= 0) {

			delayTime = 0;
			groupCount++;

			var qyLimit = Math.floor(Math.random() * level + 1);

			if (level >= 5) {

				var qyLimit = Math.floor(Math.random() * (level - 4) + 2);
			}

			for (var qy = 0; qy < qyLimit; qy++) {

				var qxLimit = 1;

				if (level >= 2) {
					qxLimit = Math.floor(Math.random() * 2 + 1);
				}

				if (level >= 5) {
					qxLimit = Math.floor(Math.random() * 3 + 1);
				}

				if (level >= 8) {
					qxLimit = Math.floor(Math.random() * 4 + 1);
				}

				for (qx = 0; qx < qxLimit; qx++) {

					var fruitIndex = fruits.length

					var fruitType = Math.floor(Math.random() * 10 + 1);

					if (fruitType >= 5 && fruitType <= 7 && level >= 3) {
						fruits[fruitIndex] = game.add.sprite(Math.floor(Math.random() * (272 / qxLimit) + ((272 / qxLimit) * qx) + 1), qy * - 96, 'badfruit', 3);						
					}					
					else {
						fruits[fruitIndex] = game.add.sprite(Math.floor(Math.random() * 272), qy * - 96, 'fruit', 3);	
					}

					if (fruitType >= 9 && fruitType <= 10 && level >= 3) {
						fruits[fruitIndex].body.velocity.x = 150;
					}

					fruitsQuantity++;

					fruits[fruitIndex].body.velocity.y = 150 + (Math.floor(Math.random() * level * 10));
					fruits[fruitIndex].body.immovable = true;

					fruits[fruitIndex].events.onOutOfBounds.add(function(fruit) {
						
						if (fruit.y > 480) {
							
							if (fruit.key == 'fruit') {
								damage();
							}

							fruit.kill();	
						}
					});

					fruits[fruitIndex].inputEnabled = true;
					fruits[fruitIndex].events.onInputDown.add(function(fruit) {

						if (gameEnd) {
							return;
						}

						if (fruit.key == 'fruit') {

							var pointup = game.add.sprite(fruit.x - 8, fruit.y, 'pointup');
							pointup.animations.add('fadeout', [0, 1, 2, 3], 5);
							pointup.animations.play('fadeout');
							pointup.events.onAnimationComplete.add(function(obj) {
								obj.kill();
							});
							
							pointup.body.velocity.y = -20;

							score += 100;	
						}

						if (fruit.key == 'badfruit') {
							damage();
						}

						fruit.kill();
					});

					fruits[fruitIndex].events.onKilled.add(function() {
						fruitsQuantity--;
					});
				}				
				
			}
		}

		for (var i = 0; i < fruits.length; i++) {
			
			if (fruits[i].alive) {

				if (fruits[i].x < 0 && fruits[i].body.velocity.x < 0) {
					fruits[i].body.velocity.x = 150;
				}
				if (fruits[i].x > 272 && fruits[i].body.velocity.x > 0) {
					fruits[i].body.velocity.x = -150;
				}

			}
		};

		levelText.content = 'Level: ' + level;
		scoreText.content = 'Score: ' + score;
	}
}

function damage() {

	if (heart3.alive) {
		heart3.kill();
	}
	else if (heart2.alive) {
		heart2.kill();
	}
	else if (heart1.alive) {
		heart1.kill();

		var yourscore;

		if (score > localStorage.getItem('hiscore')) {

			localStorage.setItem('hiscore', score);

			yourscore = game.add.sprite(72, 128, 'newhiscore');
		}
		else {
			yourscore = game.add.sprite(72, 128, 'yourscore');
		}

		yourscore.inputEnabled = true;
		yourscore.events.onInputDown.add(function() {

			game.state.start('menu');
		});

		game.add.text(104, 176, new String(score), {font: '24px Sans', fill: '#fff'});

		gameEnd = true;

		var ad_options = {

			APP_ID: 'LEGENDARYPIXELGAMES_FruitCatcher_other',
			TYPE: 'Rectangle',
			REFRESH_RATE: 30
		}	

		var ad_instance = Inneractive.createAd(ad_options);

		ad_instance.placement('center', 'center');
		ad_instance.addTo(document.body);		

		var b_close = game.add.sprite(256, 64, 'b_close');

		ad_instance.placement('center', 'center');
		ad_instance.addTo(document.body);

		b_close.inputEnabled = true;
		b_close.events.onInputDown.add(function() {

			if (ad_instance) {

				ad_instance.remove();	
				ad_instance = null;
				b_close.destroy();
			}
		});
	}
}