

var state_menu = {
	
	preload: function() {
		
		game.load.image('menu_bg', 'assets/menu_bg.png');
		game.load.image('btn_play', 'assets/btn_play.png');
		game.load.image('btn_erase', 'assets/btn_erase.png');
		game.load.image('b_close', 'assets/b_close.png');
	},

	create: function() {

		game.add.sprite(0, 0, 'menu_bg');

		var ad_options = {

			APP_ID: 'LEGENDARYPIXELGAMES_FruitCatcher_other',
			TYPE: 'Rectangle',
			REFRESH_RATE: 30
		}	

		var ad_instance = Inneractive.createAd(ad_options);

		ad_instance.placement('center', 'center');
		ad_instance.addTo(document.body);		

		var b_close = game.add.sprite(256, 64, 'b_close');

		ad_instance.placement('center', 'center');
		ad_instance.addTo(document.body);

		b_close.inputEnabled = true;
		b_close.events.onInputDown.add(function() {

			if (ad_instance) {

				ad_instance.remove();	
				ad_instance = null;
				b_close.destroy();
			}
		});
		
		var btn_play = game.add.sprite(96, 176, 'btn_play');

		btn_play.inputEnabled = true;
		btn_play.events.onInputDown.add(function() {

			game.state.start('game');
		});

		var btn_erase = game.add.sprite(228, 360, 'btn_erase');

		btn_erase.inputEnabled = true;
		btn_erase.events.onInputDown.add(function() {

			localStorage.clear();
			game.state.start('menu');
		});

		var hiscore = 0;

		if (localStorage.getItem('hiscore')) {

			hiscore = localStorage.getItem('hiscore');
		}
		else {
			localStorage.setItem('hiscore', 0);
		}

		game.add.text(114, 364, new String(hiscore), {font: '24px Sans', fill: '#fff'});
	}
}