
var game = {
  // constants
  ICON_SIZE: 40,
  NB_LINES: 8,
  NB_COLS: 8,
  NB_ICONS: 6,
  ANIM_LENGTH: 300,

  // variables
  debug_mode: false,
  hint_mode: false,
  best_score: 0,
  score: 0,
  best_combo: 0,
  combo: 0,
  finger_init_x: 0,
  finger_init_y: 0,
  $icon: undefined,
  $buddy: undefined,
  $zone_message: undefined,
  $zone_game: undefined,
  $best_score_num: undefined,
  $best_combo_num: undefined,
  $current_score_num: undefined,
  $current_combo_num: undefined,
  $moves: undefined,
  icon_line: 0,
  icon_col: 0,
  dragmove: false,
  movement_in_progress: false,
  movement_forbidden: false,
  hint_timeout: null,
  fast_move_timeout: null,
  tab_icons: [],
  tab_suppr: [],
  test_horiz: [],
  test_verti: [],
  tab_test: [],
  icon_pool: [],
  multiplier: 0,
  images: [
    'images/game/sprite.png',
    'images/game/fire.gif',
    'images/game/star.gif',
    'images/game/explosion.png'
  ],

  init: function () {

    $(window).resize(game.on_resize);

    game.$zone_message = $('#zone_message');
    game.$zone_game = $('#zone_game');
    game.$best_score_num = $('#best_score_num');
    game.$best_combo_num = $('#best_combo_num');
    game.$current_score_num = $('#current_score_num');
    game.$current_combo_num = $('#current_combo_num');
    game.$moves = $('#moves');

    $('.icon').live('dragstart', function (e) {
      // prevent image dragging
      e.preventDefault();
    });

    game.$zone_message.live('touchmove mousemove', function (e) {
      // prevent window scrolling
      e.preventDefault();
    });

    $('.icon').live('touchstart mousedown', function (e) {
      if (!game.movement_in_progress && !game.movement_forbidden) {
        game.dragmove = false;
        game.$icon = $(this);
        game.$icon.css('z-index', 20);
        game.icon_line = Number(game.$icon.data('line'));
        game.icon_col = Number(game.$icon.data('col'));
        if (e.originalEvent.type === 'touchstart') {
          game.finger_init_x = e.originalEvent.touches[0].clientX;
          game.finger_init_y = e.originalEvent.touches[0].clientY;
        }
        if (e.originalEvent.type === 'mousedown') {
          game.finger_init_x = e.originalEvent.clientX;
          game.finger_init_y = e.originalEvent.clientY;
        }
        game.movement_in_progress = true;
      }
    });

    game.$zone_game.live('touchmove mousemove', function (e) {
      // prevent window scrolling
      e.preventDefault();

      if (game.movement_in_progress) {

        var distance_x, distance_y;

        if (e.originalEvent.type === 'touchmove') {
          distance_x = e.originalEvent.touches[0].clientX - game.finger_init_x;
          distance_y = e.originalEvent.touches[0].clientY - game.finger_init_y;
        }
        if (e.originalEvent.type === 'mousemove') {
          distance_x = e.originalEvent.clientX - game.finger_init_x;
          distance_y = e.originalEvent.clientY - game.finger_init_y;
        }

        if (Math.abs(distance_x) > Math.abs(distance_y)) {
          if (distance_x > game.ICON_SIZE / 2) {
            // right
            if (game.icon_col < game.NB_COLS - 1) {
              game.dragmove = true;
              $('.icon').removeClass('click adjacent');
              game.move_icons(game.icon_line, game.icon_col, game.icon_line, game.icon_col + 1);
            }
          }

          if (distance_x < -game.ICON_SIZE / 2) {
            // left
            if (game.icon_col > 0) {
              game.dragmove = true;
              $('.icon').removeClass('click adjacent');
              game.move_icons(game.icon_line, game.icon_col, game.icon_line, game.icon_col - 1);
            }
          }
        } else {
          if (distance_y > game.ICON_SIZE / 2) {
            // down
            if (game.icon_line < game.NB_LINES - 1) {
              game.dragmove = true;
              $('.icon').removeClass('click adjacent');
              game.move_icons(game.icon_line, game.icon_col, game.icon_line + 1, game.icon_col);
            }
          }

          if (distance_y < -game.ICON_SIZE / 2) {
            // up
            if (game.icon_line > 0) {
              game.dragmove = true;
              $('.icon').removeClass('click adjacent');
              game.move_icons(game.icon_line, game.icon_col, game.icon_line - 1, game.icon_col);
            }
          }
        }
      }
    });

    game.$zone_game.live('touchend mouseup', function () {
      if (game.movement_in_progress) {
        game.movement_in_progress = false;
        game.$icon.css('z-index', 10);
        if(!game.dragmove){
          game.check_click(game.$icon);
        }
      }
    });

    $('.bt_new_game').live('click', function () {
      game.init_game();
    });

    // wait until every image is loaded to launch the game
    game.loadimages(game.images, function () {
      game.init_game();
    });

  },

  check_click: function ($icon_test) {
    var icon_test_line = Number($icon_test.data('line'));
    var icon_test_col = Number($icon_test.data('col'));
    if(!$('.icon.click').length){
      $icon_test.addClass('click');
      game.add_adjacent(icon_test_line, icon_test_col);
    } else {
      var $icon_ref = $('.icon.click');
      var icon_ref_line = Number($icon_ref.data('line'));
      var icon_ref_col = Number($icon_ref.data('col'));
      // proximity check
      if (
        (icon_ref_line === icon_test_line && icon_ref_col === icon_test_col - 1) ||
        (icon_ref_line === icon_test_line && icon_ref_col === icon_test_col + 1) ||
        (icon_ref_line === icon_test_line - 1 && icon_ref_col === icon_test_col) ||
        (icon_ref_line === icon_test_line + 1 && icon_ref_col === icon_test_col) 
      ) {
        game.$icon = $icon_ref;
        game.move_icons(icon_ref_line, icon_ref_col, icon_test_line, icon_test_col);
        $('.icon').removeClass('click adjacent');
      } else {
        $('.icon').removeClass('click adjacent');
        $icon_test.addClass('click');
        game.add_adjacent(icon_test_line, icon_test_col);
      }
    }

  },

  add_adjacent: function (line, col) {
    if (line>0) {
      game.tab_icons[line-1][col].icon.addClass('adjacent');
    }
    if (col>0) {
      game.tab_icons[line][col-1].icon.addClass('adjacent');
    }
    if (col<game.NB_COLS-1) {
      game.tab_icons[line][col+1].icon.addClass('adjacent');
    }
    if (line<game.NB_LINES-1) {
      game.tab_icons[line+1][col].icon.addClass('adjacent');
    }
  },


  init_game: function () {

    game.$zone_message.html('');

    game.score = 0;
    game.combo = 0;
    game.NB_ICONS = 6; // initial difficulty : 6 icons (then 7, then 8)

    game.tab_icons = [];

    clearTimeout(game.hint_timeout);
    $('.hint').removeClass('hint');
    game.hint_mode = false;

    game.on_resize();

    game.$zone_game.html('');
    for (var i = 0 ; i < game.NB_LINES ; i++) {
      game.tab_icons[i] = [];
      for (var j = 0 ; j < game.NB_COLS ; j++) {
        game.tab_icons[i][j] = {};
        var nb_icon = Math.ceil(Math.random() * game.NB_ICONS);

        if (i > 1) {
          while(game.tab_icons[i-2][j].value === nb_icon && game.tab_icons[i-1][j].value === nb_icon){
            nb_icon = Math.ceil(Math.random() * game.NB_ICONS);
          }
        }
        if (j > 1) {
          while(game.tab_icons[i][j-2].value === nb_icon && game.tab_icons[i][j-1].value === nb_icon){
            nb_icon = Math.ceil(Math.random() * game.NB_ICONS);

            if (i > 1) {
              while(game.tab_icons[i-2][j].value === nb_icon && game.tab_icons[i-1][j].value === nb_icon){
                nb_icon = Math.ceil(Math.random() * game.NB_ICONS);
              }
            }

          }
        }

        game.tab_icons[i][j].value = nb_icon;
        var $new_icon = $('<div class="icon icon_' + nb_icon + '"></div>');
        $new_icon.data('line', i);
        $new_icon.data('col', j);
        $new_icon.data('icon', nb_icon);
        $new_icon.css('transform', 'translate3d(' + Number(j*game.ICON_SIZE) + 'px, ' + Number(i*game.ICON_SIZE) + 'px, 0px)');
        game.$zone_game.append($new_icon);
        game.tab_icons[i][j].icon = $new_icon;
      }
    }  

    var local_best_score = localStorage.getItem('best_score');
    if (local_best_score) {
      game.best_score = local_best_score;
    }
    game.$best_score_num.html(game.best_score);

    var local_best_combo = localStorage.getItem('best_combo');
    if (local_best_combo) {
      game.best_combo = local_best_combo;
    }
    game.$best_combo_num.html(game.best_combo);

    // initial check
    game.multiplier = 0;
    game.check_board();

    game.$current_score_num.html(game.score);
    game.$current_combo_num.html(game.combo);

  },

  move_icons: function (icon_line, icon_col, buddy_line, buddy_col) {
    game.movement_in_progress = false;
    game.movement_forbidden = true;

    clearTimeout(game.hint_timeout);
    $('.hint').removeClass('hint');
    game.hint_mode = false;

    game.$buddy = game.tab_icons[buddy_line][buddy_col].icon;

    game.$icon.css('z-index', 10);

    // icons switch positions

    var icon_line_origin = icon_line;
    var icon_col_origin = icon_col;
    var icon_num_origin = game.tab_icons[icon_line][icon_col].value;
    var buddy_line_origin = buddy_line;
    var buddy_col_origin = buddy_col;
    var buddy_num_origin = game.tab_icons[buddy_line][buddy_col].value;

    game.$icon.data('line', buddy_line_origin);
    game.$icon.data('col', buddy_col_origin);
    game.$buddy.data('line', icon_line_origin);
    game.$buddy.data('col', icon_col_origin);

    game.$icon.css({
      'transform': 'translate3d(' + buddy_col_origin*game.ICON_SIZE + 'px, ' + buddy_line_origin*game.ICON_SIZE + 'px, 0px)'
    });
    game.$buddy.css({
      'transform': 'translate3d(' + icon_col_origin*game.ICON_SIZE + 'px, ' + icon_line_origin*game.ICON_SIZE + 'px, 0px)'
    });

    game.tab_icons[icon_line_origin][icon_col_origin].value = buddy_num_origin;
    game.tab_icons[icon_line_origin][icon_col_origin].icon = game.$buddy;
    game.tab_icons[buddy_line_origin][buddy_col_origin].value = icon_num_origin;
    game.tab_icons[buddy_line_origin][buddy_col_origin].icon = game.$icon;

    // after the movement : check for new chains
    setTimeout(function () {
      if (!game.check_board()) {
        // no chain found : back to initial position

        game.$icon.data('line', icon_line_origin);
        game.$icon.data('col', icon_col_origin);
        game.$buddy.data('line', buddy_line_origin);
        game.$buddy.data('col', buddy_col_origin);

        game.$icon.css('transform', 'translate3d(' + icon_col_origin*game.ICON_SIZE + 'px, ' + icon_line_origin*game.ICON_SIZE + 'px, 0px)');
        game.$buddy.css('transform', 'translate3d(' + buddy_col_origin*game.ICON_SIZE + 'px, ' + buddy_line_origin*game.ICON_SIZE + 'px, 0px)');

        game.tab_icons[icon_line_origin][icon_col_origin].value = icon_num_origin;
        game.tab_icons[icon_line_origin][icon_col_origin].icon = game.$icon;
        game.tab_icons[buddy_line_origin][buddy_col_origin].value = buddy_num_origin;
        game.tab_icons[buddy_line_origin][buddy_col_origin].icon = game.$buddy;

        setTimeout(function () {
          game.check_board();
        }, game.ANIM_LENGTH);
        
      }

      game.$icon = undefined;
      game.$buddy = undefined;

    }, game.ANIM_LENGTH);
    
  },

  check_board: function () {
    var i = 0;
    var j = 0;

    for (i = 0; i < game.NB_LINES; i++) {
      game.tab_suppr[i] = [];
      game.test_horiz[i] = [];
      game.test_verti[i] = [];
      for (j = 0; j < game.NB_COLS; j++) {
        game.tab_suppr[i][j] = false;
        game.test_horiz[i][j] = false;
        game.test_verti[i][j] = false;
      }
    }

    $('.icon.hyperfruit').removeClass('new');

    var chain_found = false;
    for (i = 0; i < game.NB_LINES; i++) {
      for (j = 0 ; j < game.NB_COLS; j++) {
        if (game.test_chain(i, j)) {
          chain_found = true;
        }
      }
    }

    // check for hyperfruit move
    if (game.$icon && game.$buddy) {
      if (game.$icon.hasClass('hyperfruit') && !game.$icon.hasClass('new')) {
        game.destroy_color(game.$buddy.data('icon'), game.$icon.data('line'), game.$icon.data('col'));
        game.tab_suppr[game.$icon.data('line')][game.$icon.data('col')] = true;
        chain_found = true;
        game.multiplier++;
        if(game.multiplier > game.combo){
          game.combo = game.multiplier;
          game.$current_combo_num.html(game.combo);
        }
        game.$zone_message.append('<div class="hyperfruit">EXCELLENT!</div>');

      }
      if (game.$buddy.hasClass('hyperfruit') && !game.$buddy.hasClass('new')) {
        game.destroy_color(game.$icon.data('icon'), game.$buddy.data('line'), game.$buddy.data('col'));
        game.tab_suppr[game.$buddy.data('line')][game.$buddy.data('col')] = true;
        chain_found = true;
        game.multiplier++;
        if(game.multiplier > game.combo){
          game.combo = game.multiplier;
          game.$current_combo_num.html(game.combo);
        }
        game.$zone_message.append('<div class="hyperfruit">EXCELLENT!</div>');
      }
    }

    if (chain_found) {
      clearTimeout(game.fast_move_timeout);
      var points = 10 * game.multiplier;
      for (i = 0; i < game.NB_LINES; i++) {
        for (j = 0 ; j < game.NB_COLS; j++) {
          if (game.tab_suppr[i][j]) {
            game.tab_icons[i][j].value = 0;
            game.tab_icons[i][j].icon.css({'opacity': 0});
            game.icon_pool.push(game.tab_icons[i][j].icon);
            game.score += points;
          }          
        }
      }
      game.$current_score_num.html(game.score);
      setTimeout(function () {
        game.$zone_message.html('');
      }, 700);


      setTimeout(function () {
        game.icons_fall();
        setTimeout(function () {
          game.check_board();
        }, 400);
      }, 400);
    } else {
      // no chain found

      if (game.$icon === undefined && game.$buddy === undefined) {
        if (game.test_possible_move()) {
          game.movement_forbidden = false;
          if (game.score > 1000) {
            // difficulty++
            game.NB_ICONS = 7;
          }
          if (game.score > 2000) {
            // difficulty++
            game.NB_ICONS = 8;
          }

          // reset multiplier if the player do not find new chain fast
          game.fast_move_timeout = setTimeout(function () {
            game.multiplier = 0;
          }, 1500);

          // display hint after a few seconds
          game.hint_timeout = setTimeout(function () {
            game.hint_mode = true;
            game.test_possible_move();
          }, 7000);
        } else {
          game.$zone_message.html('<div class="bad">GAME OVER</div>');
          game.$zone_message.append('<div class="good">' + game.score + ' points</div>');
          if (game.score > game.best_score) {
            game.best_score = game.score;
            localStorage.setItem('best_score', game.best_score);
            game.$best_score_num.html(game.best_score);
          }
          game.$zone_message.append('<div class="good">combo x ' + game.combo + '</div>');
          if (game.combo > game.best_combo) {
            game.best_combo = game.combo;
            localStorage.setItem('best_combo', game.best_combo);
            game.$best_combo_num.html(game.best_combo);
          }
          game.$zone_message.append('<div class="bt_new_game">Play again</div>');

        }
      }
    }

    return chain_found;
  },

  test_chain: function (line, col) {
    var chain_found = false;
    var num_icon = game.tab_icons[line][col].value;
    var sequence_verti = 1;
    var sequence_horiz = 1;
    var i;
    var $display_combo;

    // down
    if (!game.test_verti[line][col]) {
      i = 1;
      while(line+i < game.NB_COLS && game.tab_icons[line+i][col].value === num_icon && !game.test_verti[line+i][col]) {
        sequence_verti++;
        i++;
      }

      if (sequence_verti >= 3) {
        chain_found = true;
        game.multiplier++;
        if(game.multiplier > game.combo){
          game.combo = game.multiplier;
          game.$current_combo_num.html(game.combo);
        }
        if (game.multiplier > 1) {
          $display_combo = $('<div class="display_combo" style="left:' + (col*game.ICON_SIZE) + 'px; top:' + (line*game.ICON_SIZE) + 'px;">x' + game.multiplier + '</div>');
          game.$zone_game.append($display_combo);
          $display_combo.animate(
            {
              top : '-=' + (game.ICON_SIZE/2),
              opacity : 0
            },
            600,
            function (){
              $(this).remove();
            }
          );
        }

        if (game.tab_icons[line][col].icon.hasClass('fire')) {
          game.destroy_around(line, col);
        }
        if (game.tab_icons[line][col].icon.hasClass('star')) {
          game.destroy_line_column(line, col);
        }

        game.tab_suppr[line][col] = true;
        game.test_verti[line][col] = true;

        if(sequence_verti === 4){
          // animate fireball creation
          game.tab_icons[line][col].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + (line+1)*game.ICON_SIZE + 'px, 0px)');
        }
        if(sequence_verti === 5){
          // animate hyperfruit creation
          game.tab_icons[line][col].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + (line+2)*game.ICON_SIZE + 'px, 0px)');
        }

        // down
        i = 1;
        while(line+i < game.NB_COLS && game.tab_icons[line+i][col].value === num_icon) {
          if (game.tab_icons[line+i][col].icon.hasClass('fire')) {
            game.destroy_around(line+i, col);
          }
          if (game.tab_icons[line+i][col].icon.hasClass('star')) {
            game.destroy_line_column(line+i, col);
          }
          if(sequence_verti === 4){
            // animate fireball creation
            game.tab_icons[line+i][col].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + (line+1)*game.ICON_SIZE + 'px, 0px)');
          }
          if(sequence_verti === 5){
            // animate hyperfruit creation
            game.tab_icons[line+i][col].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + (line+2)*game.ICON_SIZE + 'px, 0px)');
          }
          if(i === 1 && game.multiplier%5 === 0){
            // create a star gem (can destroy line and column)
            game.tab_icons[line+i][col].icon.addClass('star');
            game.$zone_message.append('<div class="star">SUPER COMBO!</div>');
          } else {
            if(i === 1 && sequence_verti === 4){
              // create a fire gem (can destroy 8 surrounding icons)
              game.tab_icons[line+i][col].icon.addClass('fire');
              game.$zone_message.append('<div class="fire">FIREBALL!</div>');
            } else {
              if(i === 2 && sequence_verti === 5){
                // create a hyperfruit (can destroy all icons)
                game.tab_icons[line+i][col].icon
                  .removeClass('icon_1 icon_2 icon_3 icon_4 icon_5 icon_6 icon_7 icon_8')
                  .addClass('hyperfruit new');
                game.tab_icons[line+i][col].value = 10;
                game.$zone_message.append('<div class="hyperfruit">HYPERFRUIT!</div>');
              } else {
                game.tab_suppr[line+i][col] = true;
                game.test_verti[line+i][col] = true;
              }
            }
          }
          
          i++;
        }
      }
    }

    // right
    if (!game.test_horiz[line][col]) {
      i = 1;
      while(col+i < game.NB_LINES && game.tab_icons[line][col+i].value === num_icon && !game.test_horiz[line][col+i]) {
        sequence_horiz++;
        i++;
      }

      if (sequence_horiz >= 3) {
        chain_found = true;
        game.multiplier++;
        if(game.multiplier > game.combo){
          game.combo = game.multiplier;
          game.$current_combo_num.html(game.combo);
        }
        if (game.multiplier > 1) {
         $display_combo = $('<div class="display_combo" style="left:' + (col*game.ICON_SIZE) + 'px; top:' + (line*game.ICON_SIZE) + 'px;">x' + game.multiplier + '</div>');
          game.$zone_game.append($display_combo);
          $display_combo.animate(
            {
              top : '-=' + (game.ICON_SIZE/2),
              opacity : 0
            },
            600,
            function (){
              $(this).remove();
            }
          );
        }

        if (game.tab_icons[line][col].icon.hasClass('fire')) {
          game.destroy_around(line, col);
        }
        if (game.tab_icons[line][col].icon.hasClass('star')) {
          game.destroy_line_column(line, col);
        }

        game.tab_suppr[line][col] = true;
        game.test_horiz[line][col] = true;

        if(sequence_horiz === 4){
          // animate fireball creation
          game.tab_icons[line][col].icon.css('transform', 'translate3d(' + (col+1)*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
        }
        if(sequence_horiz === 5){
          // animate hyperfruit creation
          game.tab_icons[line][col].icon.css('transform', 'translate3d(' + (col+2)*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
        }

        // right
        i = 1;
        while(col+i < game.NB_LINES && game.tab_icons[line][col+i].value === num_icon) {
          if (game.tab_icons[line][col+i].icon.hasClass('fire')) {
            game.destroy_around(line, col+i);
          }
          if (game.tab_icons[line][col+i].icon.hasClass('star')) {
            game.destroy_line_column(line, col+i);
          }
          if(sequence_horiz === 4){
            // animate fireball creation
            game.tab_icons[line][col+i].icon.css('transform', 'translate3d(' + (col+1)*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
          }
          if(sequence_horiz === 5){
            // animate hyperfruit creation
            game.tab_icons[line][col+i].icon.css('transform', 'translate3d(' + (col+2)*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
          }
          if(i === 1 && game.multiplier%5 === 0){
            // create a star gem (can destroy line and column)
            game.tab_icons[line][col+i].icon.addClass('star');
            game.$zone_message.append('<div class="star">SUPER COMBO!</div>');
          } else {
            if (i === 1 && sequence_horiz === 4) {
              // create a fire gem (can destroy 8 surrounding icons)
              game.tab_icons[line][col+i].icon.addClass('fire');
              game.$zone_message.append('<div class="fire">FIREBALL!</div>');
            } else {
              if (i === 2 && sequence_horiz === 5) {
                // create a hyperfruit (can destroy all icons)
                game.tab_icons[line][col+i].icon
                  .removeClass('icon_1 icon_2 icon_3 icon_4 icon_5 icon_6 icon_7 icon_8')
                  .addClass('hyperfruit new');
                game.tab_icons[line][col+i].value = 10;
              game.$zone_message.append('<div class="hyperfruit">HYPERFRUIT!</div>');
              } else {
                game.tab_suppr[line][col+i] = true;
                game.test_horiz[line][col+i] = true;
              }
            }
          }

          i++;
        } 
      }
    } 
    return chain_found;
  },

  destroy_around: function (line, col) {
    if (line>0 && col>0) {
      game.tab_suppr[line-1][col-1] = true;
    }
    if (line>0) {
      game.tab_suppr[line-1][col] = true;
    }
    if (line>0 && col<game.NB_COLS-1) {
      game.tab_suppr[line-1][col+1] = true;
    }
    if (col>0) {
      game.tab_suppr[line][col-1] = true;
    }
    if (col<game.NB_COLS-1) {
      game.tab_suppr[line][col+1] = true;
    }
    if (line<game.NB_LINES-1 && col>0) {
      game.tab_suppr[line+1][col-1] = true;
    }
    if (line<game.NB_LINES-1) {
      game.tab_suppr[line+1][col] = true;
    }
    if (line<game.NB_LINES-1 && col<game.NB_COLS-1) {
      game.tab_suppr[line+1][col+1] = true;
    }
    game.explosion(line, col);
  },

  explosion: function (line, col) {
    var $explosion = $('<div class="explosion"></div>');
    $explosion.css({
      'left': (col-1)*game.ICON_SIZE,
      'top': (line-1)*game.ICON_SIZE
    });
    game.$zone_game.append($explosion);
    game.$zone_message.append('<div class="fire">GREAT!</div>');
    setTimeout(function () {
      $explosion.remove();
    }, 600);

  },

  destroy_color: function (num_icon, line, col) {
    num_icon = Number(num_icon);
    line = Number(line);
    col = Number(col);
    for (var i = 0; i < game.NB_LINES; i++) {
      for (var j = 0 ; j < game.NB_COLS; j++) {
        if (game.tab_icons[i][j].value === num_icon) {
          game.tab_suppr[i][j] = true;
          game.tab_icons[i][j].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
        }
      }
    }
  },

  destroy_line_column: function (line, col) {
    var i = 0;
    game.$zone_message.append('<div class="star">GREAT!</div>');
    for (i = 0; i < game.NB_LINES; i++) {
      game.tab_suppr[i][col] = true;
      game.tab_icons[i][col].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
    }
    for (i = 0; i < game.NB_LINES; i++) {
      game.tab_suppr[line][i] = true;
      game.tab_icons[line][i].icon.css('transform', 'translate3d(' + col*game.ICON_SIZE + 'px, ' + line*game.ICON_SIZE + 'px, 0px)');
    }
  },

  icons_fall: function () {
    var tab_fall = [];
    for (var i = game.NB_LINES-1; i >= 0 ; i--) {
      for (var j = 0 ; j < game.NB_COLS; j++) {
        if (game.tab_icons[i][j].value === 0) {
          // look above for an icon to fill the hole
          var k = 1;
          while((i - k) >= 0 && game.tab_icons[i-k][j].value === 0) {
            k++;
          }
          if ((i - k) < 0) {
            // no icon found above : create random new icon
            var random_icon = Math.ceil(Math.random() * game.NB_ICONS);
            var $new_icon = game.icon_pool.pop();
            $new_icon.data({
                'line': i,
                'col': j,
                'icon': random_icon
              });
            $new_icon.removeClass();
            $new_icon.addClass('icon icon_' + random_icon);
            $new_icon.css({
              'transition': 'transform 0s ease-in, opacity 0s linear'
            });
            $new_icon.css({
              'transform': 'translate3d(' + j*game.ICON_SIZE + 'px, ' + (-game.ICON_SIZE) + 'px, 0px)',
              'opacity': 1
            });

            tab_fall.push({
              icon: $new_icon,
              x: j,
              y: i
            });

            game.tab_icons[i][j].value = random_icon;
            game.tab_icons[i][j].icon = $new_icon;
          } else {
            // icon found above : icon falling animation
            var $icon_fall = game.tab_icons[i-k][j].icon;
            // update icon properties (correct line and column numbers)
            $icon_fall.data('line', i);
            $icon_fall.css('transform', 'translate3d(' + j*game.ICON_SIZE + 'px, ' + i*game.ICON_SIZE + 'px, 0px)');

            game.tab_icons[i][j].value = game.tab_icons[i-k][j].value;
            game.tab_icons[i][j].icon = $icon_fall;
            game.tab_icons[i-k][j].value = 0;
          }
        }
      }
    }
    setTimeout(function () {
      for (var l = 0; l < tab_fall.length; l++) {
        tab_fall[l].icon.css({
                'transition': 'transform .2s ease-in, opacity .2s linear'
              });
        tab_fall[l].icon.css({
          'transform': 'translate3d(' + tab_fall[l].x*game.ICON_SIZE + 'px, ' + tab_fall[l].y*game.ICON_SIZE + 'px, 0px)',
          'opacity': 1
        });
      }
    }, 200);
  },

  test_possible_move: function () {
    var move_found = false;
    var hint_displayed = false;
    var nb_possible_moves = 0;
    var i = 0;
    var j = 0;

    for (i = 0; i < game.NB_LINES; i++) {
      game.tab_test[i] = [];
      for (j = 0; j < game.NB_COLS; j++) {
        game.tab_test[i][j] = game.tab_icons[i][j].value;
      }
    }

    for (i = 0; i < game.NB_LINES; i++) {
      for (j = 0; j < game.NB_COLS; j++) {
        // test right move
        if (j < game.NB_COLS-1) {
          game.tab_test[i][j] = game.tab_icons[i][j+1].value;
          game.tab_test[i][j+1] = game.tab_icons[i][j].value;
          if (game.test_chain_game_over(i, j)) {
            move_found = true;
            nb_possible_moves++;
            if (nb_possible_moves > 3) {
              game.$moves.html('');
              return move_found;
            }
            if(game.debug_mode){
              game.tab_icons[i][j+1].icon.addClass('hint');
            }
            if (game.hint_mode && !hint_displayed) {
              game.tab_icons[i][j+1].icon.addClass('hint');
              hint_displayed = true;
            }
          }
          if (game.test_chain_game_over(i, j+1)) {
            move_found = true;
            nb_possible_moves++;
            if (nb_possible_moves > 3) {
              game.$moves.html('');
              return move_found;
            }
            if(game.debug_mode){
              game.tab_icons[i][j].icon.addClass('hint');
            }
            if (game.hint_mode && !hint_displayed) {
              game.tab_icons[i][j].icon.addClass('hint');
              hint_displayed = true;
            }
          }
          game.tab_test[i][j] = game.tab_icons[i][j].value;
          game.tab_test[i][j+1] = game.tab_icons[i][j+1].value;
        }

        // test down move
        if (i < game.NB_LINES-1) {
          game.tab_test[i][j] = game.tab_icons[i+1][j].value;
          game.tab_test[i+1][j] = game.tab_icons[i][j].value;
          if (game.test_chain_game_over(i, j)) {
            move_found = true;
            nb_possible_moves++;
            if (nb_possible_moves > 3) {
              game.$moves.html('');
              return move_found;
            }
            if(game.debug_mode){
              game.tab_icons[i+1][j].icon.addClass('hint');
            }
            if (game.hint_mode && !hint_displayed) {
              game.tab_icons[i+1][j].icon.addClass('hint');
              hint_displayed = true;
            }
          }
          if (game.test_chain_game_over(i+1, j)) {
            move_found = true;
            nb_possible_moves++;
            if (nb_possible_moves > 3) {
              game.$moves.html('');
              return move_found;
            }
            if(game.debug_mode){
              game.tab_icons[i][j].icon.addClass('hint');
            }
            if (game.hint_mode && !hint_displayed) {
              game.tab_icons[i][j].icon.addClass('hint');
              hint_displayed = true;
            }
          }
          game.tab_test[i][j] = game.tab_icons[i][j].value;
          game.tab_test[i+1][j] = game.tab_icons[i+1][j].value;
        }
      }
    }

    if(nb_possible_moves <= 3) {
      if(nb_possible_moves <= 1) {
        game.$moves.addClass('critical').html(nb_possible_moves + '<br>move');
      } else {
        game.$moves.removeClass('critical').html(nb_possible_moves + '<br>moves');
      }
    }
    return move_found;
  },

  test_chain_game_over: function (line, col) {
    var num_icon = game.tab_test[line][col];
    var sequence_verti = 1;
    var sequence_horiz = 1;
    var i;
    // up
    i = 1;
    while(line-i >= 0 && game.tab_test[line-i][col] === num_icon) {
      sequence_verti++;
      if (sequence_verti >= 3) {
        return true;
      }
      i++;
    }
    // down
    i = 1;
    while(line+i < game.NB_COLS && game.tab_test[line+i][col] === num_icon) {
      sequence_verti++;
      if (sequence_verti >= 3) {
        return true;
      }
      i++;
    }
    // left
    i = 1;
    while(col-i >= 0 && game.tab_test[line][col-i] === num_icon) {
      sequence_horiz++;
      if (sequence_horiz >= 3) {
        return true;
      }
      i++;
    }
    // right
    i = 1;
    while(col+i < game.NB_LINES && game.tab_test[line][col+i] === num_icon) {
      sequence_horiz++;
      if (sequence_horiz >= 3) {
        return true;
      }
      i++;
    }

    if (game.tab_test[line][col] === 10) {
      // hyperfruit
      return true;
    }
    return false;
  },

  on_resize: function () {
    var board_size = game.$zone_game.width();
    game.ICON_SIZE = board_size/8;

    game.$zone_game.css({
      'height': board_size + 'px',
      'background-size': board_size/4 + 'px ' + board_size/4 + 'px'
    });
    if (game.tab_icons.length) {
      for (var i = 0; i < game.NB_LINES; i++) {
        for (var j = 0 ; j < game.NB_COLS; j++) {
          game.tab_icons[i][j].icon.css('transform', 'translate3d(' + j*game.ICON_SIZE + 'px, ' + i*game.ICON_SIZE + 'px, 0px)');
        }
      }
    }

    setTimeout(function () {
      // hide the address bar
      window.scrollTo(0, 1);
    }, 0);

  },

  loadimages: function (imgArr,callback) {
    //Keep track of the images that are loaded
    var imagesLoaded = 0;
    function _loadAllImages(callback) {
      //Create an temp image and load the url
      var img = new Image();
      $(img).attr('src',imgArr[imagesLoaded]);
      if (img.complete || img.readyState === 4) {
        // image is cached
        imagesLoaded++;
        //Check if all images are loaded
        if (imagesLoaded === imgArr.length) {
          //If all images loaded do the callback
          callback();
        } else {
          //If not all images are loaded call own function again
          _loadAllImages(callback);
        }
      } else {
        $(img).load(function () {
          //Increment the images loaded variable
          imagesLoaded++;
          //Check if all images are loaded
          if (imagesLoaded === imgArr.length) {
            //If all images loaded do the callback
            callback();
          } else {
            //If not all images are loaded call own function again
            _loadAllImages(callback);
          }
        });
      }
    }
    _loadAllImages(callback);
  }
};

$(function () { // DOM ready

  game.init();

});