function Calculator ()
{
	var maxDigits = 17;
	var maxDisplay = 7;
	var regBack;
	var regMain;
	var operator;
	var decimal;
	var locked;
	
	var update = function ()
	{
		var element;
		element = document.getElementsByClassName('memory')[0];
		if (regBack != null)
		{
			element.innerHTML = regBack.toString().substr(0,(maxDigits -1));
			if (operator != null)
				element.innerHTML += operator.toString();
		}
		else
			element.innerHTML = "";
		
		element = document.getElementsByClassName('display')[0];
		if ((regMain != null) && (regMain != 0))
			element.innerHTML = rightString(appendZeroes(regMain.toString()), maxDisplay);
		else if(locked)
			element.innerHTML = "ERR";
		else
			element.innerHTML = '0';
	};
	
	var rightString = function (stringa, n)
	{
		var app;
		if (stringa.length <= n)
			return stringa;
		app = stringa.substr(stringa.length - n, n);
		return app;
	};

	this.sendDigit = function (digit)
	{
		switch (digit)
		{
			case "0":
				insertMain(0);
				break;
			case "1":
				insertMain(1);
				break;
			case "2":
				insertMain(2);
				break;
			case "3":
				insertMain(3);
				break;
			case "4":
				insertMain(4);
				break;
			case "5":
				insertMain(5);
				break;
			case "6":
				insertMain(6);
				break;
			case "7":
				insertMain(7);
				break;
			case "8":
				insertMain(8);
				break;
			case "9":
				insertMain(9);
				break;
			case "=":
				result();
				break;
			case ".":
				insertMain(".");
				break;
			case "+":
			case "-":
			case "/":
			case "*":
				sendOperator(digit);
				break;
			case "CE":
				valueFunction('CE');
				break;
			default:
				throw "invalid command";
		}
	};
	
	var sendOperator = function (operazione)
	{
		if (operator != null)
			return;
		operator = operazione;
		if (regBack == null)
			regBack = regMain;
		decimal = -1;
		regMain = null;
		update();
	};
	
	var insertMain = function (digit)
	{
		if (locked)
			return;
		
		if (regMain == null)
		{
			if ((regBack != null) && (operator == null))
				regBack = null;
			regMain = 0;
		}
		
		if (regMain.toString().length >= maxDigits - 1)
			throw "reached max digits";
		
		
		if (digit == ".")
		{
			if (decimal == -1)
				decimal = 0;
			else return;
		}
		
		else if (decimal >= 0)
		{
			var app = regMain.toString();
			app = appendZeroes(app);
			decimal++;
			app = app + digit.toString();
			regMain = Number(app);
		}
		
		else
		{
			regMain *= 10;
			regMain += digit;
		}
		
		update();
	};
	
	var appendZeroes = function (stringa)
	{
		var app = stringa.split(".")[1];
		var pos;
		
		if (decimal == -1)
			return stringa;
		
		if ((app == undefined))
		{
			stringa += ".";
			pos = 0;
		}
		else pos = app.length;

		for (var i = pos; i < decimal; i++)
			stringa += "0";
		
		return stringa;
	};
	
	var valueFunction = function (funzione)
	{
		switch (funzione)
		{
			case 'CE':
				clear();
				break;
			case '+':
				return (regMain + regBack);
			case '-':
				return (regBack - regMain);
			case '*':
				return (regMain * regBack);
			case '/':
				return (regBack / regMain);
			default:
				throw "invalid command";
		}
	};
	
	var clear = function ()
	{
		if (locked)
		{
			regBack = null;
			operator = null;
			locked = false;
		}
		if ((regBack != null) && (regMain == null))
		{
			regBack = null;
			operator = null;
		}
		regMain = null;
		decimal = -1;
		update();
	};
	
	var result = function ()
	{
		var app;
		
		if (operator == null)
			throw "no operator";
		
		regBack = valueFunction(operator);
		
		app = regBack.toString().split(".");
		if (app[1] != undefined)
			if (app[0].length < (maxDigits - 2))
				regBack = Number(regBack.toFixed(maxDigits - 2 - app[0].length));
			
		if (regBack == 'Infinity')
			locked = true;
		if (regBack.toString().length > (maxDigits - 1))
			locked = true;
		
		regMain = null;
		operator = null;
		update();
	};
	
	// Costruttore
	operator = null;
	regBack = null;
	regMain = null;
	decimal = -1;
	locked = false;
	update();
	
}