/*
 * This file is part of FSub.
 *
 * FSub is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or any later version.
 *
 * FSub is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FSub.  If not, see <http://www.gnu.org/licenses/>.
 */

var SUB_API_VERSION = "1.8.0";
var SUB_API_CLIENT = "FSub";

var ALBUM_LIST_SIZE = 15;
var ARTIST_LIST_SIZE = 15;

var VIEW_ALBUM_LIST_RANDOM = 0;
var VIEW_ALBUM_LIST_NEWEST = 1;
var VIEW_ALBUM_LIST_FREQUENT = 2;
var VIEW_ALBUM_LIST_RECENT = 3;
var VIEW_ALBUM_LIST_STARRED = 4;
var VIEW_ARTIST_LIST = 5;

var fsub = null;

var currentSongList = [];

var sdcard = null;
var cacheEnable = null;
var cacheDir = '';
var songsDir = '';
var coverArtDir = '';

var currentMainView = VIEW_ALBUM_LIST_RANDOM;
var currentAlbumOffset = 0;
var dataArtistList = [];
var currentArtistOffset = 0;

var dataSearchResult = [];

function addAlbumItem(selector, album) {
	$(selector).append('<li id="' + album.id + '"><a href="#"><img src="img/cover-cd-128.png"><h2>' + album.name + '</h2><p>' + album.artist + '</p></a></li>');

	if (typeof album.coverArt !== 'undefined' && cacheEnable !== '0') {
		var req = sdcard.get(coverArtDir + album.coverArt + '.jpeg');

		req.onsuccess = function() {
			$("#" + album.id + " a").find("img").attr("src", URL.createObjectURL(this.result));
		};

		req.onerror = function() {
			downloadCoverArt(album);
		};
	} else if (typeof album.coverArt !== 'undefined') {
		var param = '?u=' + encodeURIComponent(fsub.username);
		param += '&p=' + encodeURIComponent(fsub.password);
		param += '&v=' + encodeURIComponent(fsub.version);
		param += '&c=' + encodeURIComponent(fsub.appname);
		param += '&id=' + album.coverArt;
		param += '&f=json';
		$("#" + album.id + " a").find("img").attr("src", fsub.server + 'getCoverArt.view' + param);
	}

	$(selector).listview("refresh");
}

function addArtistItem(selector, artist) {
	$(selector).append('<li id="' + artist.id + '"><a href="#"><img src="img/cover-cd-128.png"><h2>' + artist.name + '</h2><p>' + artist.albumCount + ' album(s)</p></a></li>');

	if (typeof artist.coverArt !== 'undefined' && cacheEnable !== '0') {
		var req = sdcard.get(coverArtDir + artist.coverArt + '.jpeg');

		req.onsuccess = function() {
			$("#" + artist.id + " a").find("img").attr("src", URL.createObjectURL(this.result));
		};

		req.onerror = function() {
			downloadCoverArt(artist);
		};
	} else if (typeof artist.coverArt !== 'undefined') {
		var param = '?u=' + encodeURIComponent(fsub.username);
		param += '&p=' + encodeURIComponent(fsub.password);
		param += '&v=' + encodeURIComponent(fsub.version);
		param += '&c=' + encodeURIComponent(fsub.appname);
		param += '&id=' + artist.coverArt;
		param += '&f=json';
		$("#" + artist.id + " a").find("img").attr("src", fsub.server + 'getCoverArt.view' + param);
	}

	$(selector).listview("refresh");
}

function addSongItem(song, idList) {
	$("#songList").append('<input value="' + idList + '" id="sg-' + song.id + '" type="checkbox"><label for="sg-' + song.id + '">' + song.title + ' (' + song.artist + ')</label>');

	$("#songList input").checkboxradio({
		defaults: true
	});
}

function showAlbumList(data) {
	if (data.status === 'failed')
		return;

	$("#globalList").empty();

	loadAlbumList(data);
}

function loadAlbumList(data) {
	if (typeof data.albumList2.album === 'undefined') { // no album
		return;
	}

	if (typeof data.albumList2.album.id !== 'undefined') {
		addAlbumItem('#globalList', data.albumList2.album);
	} else {
		$.each(data.albumList2.album, function(i, album) {
			addAlbumItem('#globalList', album);
		});
	}
}

function showArtistList(data) {
	if (data.status === 'failed')
		return;

	$("#globalList").empty();
	currentMainView = VIEW_ARTIST_LIST;
	currentArtistOffset = 0;

	dataArtistList = [];
	$.each(data.artists.index, function(i, index) {
		if (typeof index.artist.id !== 'undefined') {
			dataArtistList.push(index.artist);
		} else {
			$.each(index.artist, function(j, artist) {
				dataArtistList.push(artist);
			});
		}
	});

	loadArtistList();
}

function loadArtistList() {
	for (var i = currentArtistOffset; i < currentArtistOffset + ARTIST_LIST_SIZE; i++) {
		if (typeof dataArtistList[i] === 'undefined') // none artist
			break;

		addArtistItem("#globalList", dataArtistList[i]);
	}

	currentArtistOffset += ARTIST_LIST_SIZE;
}

function showAlbumListByArtist(data) {
	if (data.status === 'failed')
		return;

  $(":mobile-pagecontainer").pagecontainer("change", "#pAlbumListByArtist");
	$("#pAlbumListByArtist h1").html(data.artist.name);
	$("#albumListByArtist").empty();

	if (typeof data.artist.album.id !== 'undefined') {
		addAlbumItem('#albumListByArtist', data.artist.album);
	} else {
		$.each(data.artist.album, function(i, album) {
			addAlbumItem('#albumListByArtist', album);
		});
	}
}

function showAlbum(data) {
	if (data.status === 'failed')
		return;

  $(":mobile-pagecontainer").pagecontainer("change", "#pSong");
	$("#pSong h1").html(data.album.name);
	$("#songList").empty();

	if (typeof data.album.song.id !== 'undefined') { // one song only
		currentSongList = [data.album.song];
		addSongItem(data.album.song, 0);
	} else {
		currentSongList = data.album.song;
		$.each(data.album.song, function(i, song) {
			addSongItem(song, i);
		});
	}
}

function showSearch(data) {
	if (data.status === 'failed')
		return;

	dataSearchResult = data.searchResult3;

	$(":mobile-pagecontainer").pagecontainer("change", "#pSearch");
	$("#searchAlbumList").empty();
	$("#searchArtistList").empty();

	if (typeof dataSearchResult.album === 'undefined') {
		$("#nbAlbumsFound").html(0);
	} else if (typeof dataSearchResult.album.id !== 'undefined') {
		$("#nbAlbumsFound").html(1);
		$("#searchAlbumList").append('<li id="sr-al-' + dataSearchResult.album.id + '"><a href="#">' + dataSearchResult.album.name + '</a></li>');
	} else {
		$("#nbAlbumsFound").html(dataSearchResult.album.length);
		$.each(dataSearchResult.album, function(i, album) {
			$("#searchAlbumList").append('<li id="sr-al-' + album.id + '"><a href="#">' + album.name + '</a></li>');
		});
	}
	$("#searchAlbumList").listview("refresh");

	if (typeof dataSearchResult.artist === 'undefined') {
		$("#nbArtistFound").html(0);
	} else if (typeof dataSearchResult.artist.id !== 'undefined') {
		$("#nbArtistFound").html(1);
		$("#searchArtistList").append('<li id="sr-ar-' + dataSearchResult.artist.id + '"><a href="#">' + dataSearchResult.artist.name + '</a></li>');
	} else {
		$("#nbArtistFound").html(dataSearchResult.artist.length);
		$.each(dataSearchResult.artist, function(i, artist) {
			$("#searchArtistList").append('<li id="sr-ar-' + artist.id + '"><a href="#">' + artist.name + '</a></li>');
		});
	}
	$("#searchArtistList").listview("refresh");

	if (typeof dataSearchResult.song === 'undefined') {
		$("#nbSongFound").html(0);
	} else if (typeof dataSearchResult.song.id !== 'undefined') {
		$("#nbSongFound").html(1);
	} else {
		$("#nbSongFound").html(dataSearchResult.song.length);
	}
}

function refreshPlayList() {
	if (playList.length === 0)
		return;

	$("#playlist").empty();
	for (var i = 0; i < playList.length; i++) {
		$("#playlist").append('<a href="#" class="ui-btn ui-corner-all" id="pl-' + i + '">' + playList[i].title + ' (' + playList[i].artist + ')</a>');
	}

	updateSongPlaying();
}

function updateSongPlaying() {
	$("#playlist").find(".ui-icon-play").removeClass("ui-icon-play ui-btn-icon-left"); // remove previous icon play

	if (indexOfPlaying !== -1) {
		$("#pl-" + indexOfPlaying).addClass("ui-icon-play ui-btn-icon-left");
	}
}

function showOptions() {
	$(":mobile-pagecontainer").pagecontainer("change", "#pOptions");

	var server = localStorage.getItem("server");
	var username = localStorage.getItem("username");
	var password = localStorage.getItem("password");

	if (server !== null) {
		$("#opServer").val(server);
		$("#opUsername").val(username);
		password = password.substr(4, password.length); // get only after 'enc:'
		password = hexToString(password); // convert hex to string
		$("#opPassword").val(password);
	}

	var sdcards = navigator.getDeviceStorages("sdcard");
	// disable cache option if non SDcard
	// on Firefox simulator, have one SDcard but not have name
	if (sdcards.length === 0 || sdcards[0].storageName === '') {
		$("#opCacheEnable").slider("disable");
		$("#opCacheDir").selectmenu("disable");
		$("#clearCache").addClass("ui-state-disabled");
	} else {
		$("#opCacheEnable").slider("enable");

		$("#opCacheDir").empty();
		for (var i = 0; i < sdcards.length; i++)
			$("#opCacheDir").append('<option value="' + sdcards[i].storageName + '">' + sdcards[i].storageName + '</option>');

		var cacheEnable = localStorage.getItem("cacheEnable");
		var cacheDir = localStorage.getItem("cacheDir");

		if (cacheEnable !== null && cacheEnable === '1') {
			$("#opCacheEnable").val(1);
			$("#opCacheDir").selectmenu("enable");
			$("#opCacheDir option[value=" + cacheDir + "]").attr("selected", "selected");
		} else { // disable cache dir if cache is off
			$("#opCacheEnable").val(0);
			$("#opCacheDir").selectmenu("disable");
			$("#clearCache").addClass("ui-state-disabled");
		}

		$("#opCacheEnable").slider("refresh");
		$("#opCacheDir").selectmenu("refresh");
	}
}

function testPing(data) {
	$("#test.Server").button("enable");
	if (data.status === 'ok')
		alert(_('test-ok'));
	else
		alert(_('test-nok', {
			msg: data.error.message
		}));
}

$("#globalList").delegate("li", "click", function() {
	var id = $(this).attr('id');

	switch (currentMainView) {
		case VIEW_ALBUM_LIST_RANDOM:
    case VIEW_ALBUM_LIST_NEWEST:
    case VIEW_ALBUM_LIST_FREQUENT:
    case VIEW_ALBUM_LIST_RECENT:
    case VIEW_ALBUM_LIST_STARRED:
			fsub.getAlbum(showAlbum, id);
			break;
		case VIEW_ARTIST_LIST:
			fsub.getArtist(showAlbumListByArtist, id);
			break;
	}
});

$("#albumListByArtist").delegate("li", "click", function() {
	var id = $(this).attr('id');
	fsub.getAlbum(showAlbum, id);
});

$("#searchAlbumList").delegate("li", "click", function() {
	var id = $(this).attr('id').slice(6);
	fsub.getAlbum(showAlbum, id);
});

$("#searchArtistList").delegate("li", "click", function() {
	var id = $(this).attr('id').slice(6);
	fsub.getArtist(showAlbumListByArtist, id);
});

$("#opCacheEnable").on("change", function() {
	if ($("#opCacheEnable").val() === "1") {
		$("#opCacheDir").selectmenu("enable");
		$("#clearCache").removeClass("ui-state-disabled");
	} else {
		$("#opCacheDir").selectmenu("disable");
		$("#clearCache").addClass("ui-state-disabled");
	}
	$("#opCacheDir").selectmenu("refresh");
});

$("#fSearch").submit(function(e) {
	e.preventDefault();
	var str = $("#search").val();
	if (str.length > 2) {
		fsub.search3(showSearch, str);
	}
});

function getSelectedSongs() {
	var list = [];
	var nbSongsSelected = $("#songList input:checked").length;

	if (nbSongsSelected > 0) {
		$("#songList input:checked").each(function() {
			var idList = $(this).val();
			list.push(currentSongList[idList]);
		});
	}

	return list;
}

$("#playSongs").click(function() {
  $(":mobile-pagecontainer").pagecontainer("change", "#pPlayer");
	playList = getSelectedSongs();

	if (playList.length === 0) // play all is non selected
		playList = currentSongList;

	refreshPlayList();
	startPlaylist();
});

$("#addSongs").click(function() {
	var list = getSelectedSongs();
	if (list.length === 0)
		playList = playList.concat(currentSongList);
	else
		playList = playList.concat(list);

	refreshPlayList();
});

$("#downloadSongs").click(function() {
	if (cacheEnable === '0')
		alert(_('download-nok'));
	else {
		var list = getSelectedSongs();
		if (list.length === 0) // download all
			downloadSong(currentSongList);
		else
			downloadSong(list);
	}
});

$("#showSongFound h2").click(function() {
	$("#showSongFound").collapsible("expand");

  $(":mobile-pagecontainer").pagecontainer("change", "#pSong");
	$("#pSong h1").html("Search");
	$("#songList").empty();

	if (typeof dataSearchResult.song.id !== 'undefined') { // only one song
		currentSongList = [dataSearchResult.song];
		addSongItem(dataSearchResult.song, 0);
	} else {
		$.each(dataSearchResult.song, function(i, song) {
			currentSongList = dataSearchResult.song;
			addSongItem(song, i);
		});
	}
});

$("#testServer").click(function() {
	var server = $("#opServer").val();
	var username = $("#opUsername").val();
	var password = $("#opPassword").val();

	if (server === '' || username === '' || password === '') {
		alert(_('fill-all-parameters'));
		return;
	}

	var t_fsub = new Subsonic(username, 'enc:' + stringToHex(password), server, SUB_API_CLIENT, SUB_API_VERSION);
	$("#test.Server").button("disable");
	t_fsub.ping(testPing);
});

$("#clearCache").click(function() {
	if (cacheEnable === '0') {
		alert(_('cache-disabled'));
	} else if (confirm(_('confirm-clear-cache'))) {
		var req = sdcard.delete(cacheDir);

		req.onsuccess = function() {
			console.log(cacheDir + ' successfully removed');
			alert(_('clear-cache-ok'));
		};

		req.onerror = function() {
			console.error('Unable to remove ' + cacheDir);
			alert(_('clear-cache-nok'));
		};
	}
});

$("#resetFSub").click(function() {
	if (confirm(_('confirm-rest-fsub'))) {
		localStorage.clear();
		location.href = 'index.html';
	}
});

$("#opSave").click(function() {
	var server = $("#opServer").val();
	var username = $("#opUsername").val();
	var password = $("#opPassword").val();

	var cacheEnable = $("#opCacheEnable").val();
	var cacheDir = $("#opCacheDir").val();

	if (server === '' || username === '' || password === '') {
		alert(_('fill-all-parameters'));
		return;
	}

	localStorage.setItem("server", server);
	localStorage.setItem("username", username);
	localStorage.setItem("password", 'enc:' + stringToHex(password));

	localStorage.setItem("cacheEnable", cacheEnable);
	localStorage.setItem("cacheDir", cacheDir);

	location.href = 'index.html';
});

$("#playerPlayOrPause").click(function() {
	PlayPause();
});

$("#playerStop").click(function() {
	stop();
});

$("#playerPrevious").click(function() {
	playPrevious();
});

$("#playerNext").click(function() {
	playNext();
});

$(document).scroll(function() {
	if ($.mobile.activePage.attr("id") === 'pMain' && $('#panel').hasClass('ui-panel-open') !== true) {
		if ($(window).scrollTop() + $(window).height() === $(document).height() && fsub !== null) {
      switch (currentMainView) {
        case VIEW_ALBUM_LIST_RANDOM:
          currentAlbumOffset += ALBUM_LIST_SIZE;
          fsub.getAlbumList2(loadAlbumList, "random", ALBUM_LIST_SIZE, currentAlbumOffset);
          break;
        case VIEW_ALBUM_LIST_NEWEST:
          currentAlbumOffset += ALBUM_LIST_SIZE;
          fsub.getAlbumList2(loadAlbumList, "newest", ALBUM_LIST_SIZE, currentAlbumOffset);
          break;
        case VIEW_ALBUM_LIST_FREQUENT:
          currentAlbumOffset += ALBUM_LIST_SIZE;
          fsub.getAlbumList2(loadAlbumList, "frequent", ALBUM_LIST_SIZE, currentAlbumOffset);
          break;
        case VIEW_ALBUM_LIST_RECENT:
          currentAlbumOffset += ALBUM_LIST_SIZE;
          fsub.getAlbumList2(loadAlbumList, "recent", ALBUM_LIST_SIZE, currentAlbumOffset);
          break;
        case VIEW_ALBUM_LIST_STARRED:
          currentAlbumOffset += ALBUM_LIST_SIZE;
          fsub.getAlbumList2(loadAlbumList, "starred", ALBUM_LIST_SIZE, currentAlbumOffset);
          break;
        case VIEW_ARTIST_LIST:
          loadArtistList();
          break;
      }
		}
	}
});

$("#panel a").click(function(e) {
  switch($(this).attr("href")) {
    case "#player" :
      $(":mobile-pagecontainer").pagecontainer("change", "#pPlayer");
      break;
    case "#album-random" :
      currentAlbumOffset = 0;
      currentMainView = VIEW_ALBUM_LIST_RANDOM;
      fsub.getAlbumList2(showAlbumList, "random", ALBUM_LIST_SIZE);
      break;
    case "#album-newest" :
      currentAlbumOffset = 0;
      currentMainView = VIEW_ALBUM_LIST_NEWEST;
      fsub.getAlbumList2(showAlbumList, "newest", ALBUM_LIST_SIZE);
      break;
    case "#album-frequent" :
      currentAlbumOffset = 0;
      currentMainView = VIEW_ALBUM_LIST_FREQUENT;
      fsub.getAlbumList2(showAlbumList, "frequent", ALBUM_LIST_SIZE);
      break;
    case "#album-recent" :
      currentAlbumOffset = 0;
      currentMainView = VIEW_ALBUM_LIST_RECENT;
      fsub.getAlbumList2(showAlbumList, "recent", ALBUM_LIST_SIZE);
      break;
    case "#album-starred" :
      currentAlbumOffset = 0;
      currentMainView = VIEW_ALBUM_LIST_STARRED;
      fsub.getAlbumList2(showAlbumList, "starred", ALBUM_LIST_SIZE);
      break;
    case "#all-artists" :
      fsub.getArtists(showArtistList);
      break;
    case "#settings" :
      showOptions();
      break;
    case "#about" :
      $(":mobile-pagecontainer").pagecontainer("change", "#pAbout");
      break;
  }
});

$(function() {
	$.getJSON("manifest.webapp", function(json) {
		$("#fsubVersion").html(json.version);
	});

	var server = localStorage.getItem("server");
	var username = localStorage.getItem("username");
	var password = localStorage.getItem("password");

	if (server === null || username === null || password === null) {
		showOptions();
	} else {
		fsub = new Subsonic(username, password, server, SUB_API_CLIENT, SUB_API_VERSION);
		if (fsub === null) {
			alert(_('server-connection-nok'));
		} else {
			fsub.getAlbumList2(showAlbumList, "random", ALBUM_LIST_SIZE);
			cacheEnable = localStorage.getItem('cacheEnable');
			if (cacheEnable !== '0') {
				sdcard = navigator.getDeviceStorage('sdcard');
				cacheDir = '/' + localStorage.getItem('cacheDir') + '/subsonic/';
				songsDir = cacheDir + 'songs/';
				coverArtDir = cacheDir + 'coverArt/';
			} else {
				$("#downloadSongs").hide();
			}
		}
	}
});
