/*
 * FuelControl - Acompanhamento de gastos com combustível
 * 
 * Copyright (c) 2014 Cárlisson Galdino <bardo@carlissongaldino.com.br>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
window.addEvent('domready', function(){
	function table_add_line(table, header, value) {
		var tr = new Element("tr");
		var tdh = new Element("td", {class: "col-header"}).appendText(header);
		var tdv = new Element("td", {class: "col-value"}).appendText(value);
		tr.adopt(tdh);
		tr.adopt(tdv);
		table.adopt(tr);
	}

	function table_add_log_line(table, id) {
		var item = fuelControl.memory.entries[id];
		var tr = new Element("tr", {item: id});
		var tdh = new Element("td", {class: "col-day"}).appendText(item.day);
		var tdv = new Element("td", {class: "col-value"}).appendText(item.value);
		var tdd = new Element("td", {class: "col-display"}).appendText(item.display);
		var tdd2 = new Element("td", {class: "col-distance"});
		if (id > 0) {
			tdd2.appendText(format_number(item.display - fuelControl.memory.entries[id-1].display));
		} else {
			tdd2.appendText("-");
		}
		tr.adopt(tdh);
		tr.adopt(tdv);
		tr.adopt(tdd);
		tr.adopt(tdd2);
		tr.addEvent("click", function() {
			this.highlight("#ff0000");
			fuelControl.toRemove = this.getProperty("item");
			setTimeout(function() {
				if (confirm("Remover esta entrada?")) {
					fuelControl.remove(fuelControl.toRemove);
					fuelControl.save();
					fuelControl.transition("log-page");
				}
				fuelControl.toRemove = false;
			}, 600);
		});
		table.adopt(tr);
	}

	function format_number(v) {
		var x = Math.round(100 * v)/100;
		return x;
	}

	function zebra(t) {
		fuelControl.zebra = false;
		t.getChildren('tr').each(function(l) {
			var c_class = (fuelControl.zebra) ? "zebra1" : "zebra2";
			l.addClass(c_class);
			fuelControl.zebra = ! fuelControl.zebra;
		});
	}


	var fuelControl = {
		transitionF: new Element("div", {class: "fuel-transition"}).appendText("F"),
		transitionU: new Element("div", {class: "fuel-transition-rv"}).appendText("U"),
		transitionE: new Element("div", {class: "fuel-transition"}).appendText("E"),
		transitionL: new Element("div", {class: "fuel-transition-rv"}).appendText("L"),
		page: "menu-page",
		storageKey: "fuelControl",
		initialize: function() {
			var ws = {x: 320, y: 480};
			var block_w = ws.y / 4;
			this.transitionF.setStyle("width", ws.x);
			this.transitionF.setStyle("height", block_w);
			this.transitionF.setStyle("font-size", block_w* 0.8);
			this.transitionF.setStyle("margin-left", 0);
			this.transitionU.setStyle("width", ws.x);
			this.transitionU.setStyle("height", block_w);
			this.transitionU.setStyle("top", block_w);
			this.transitionU.setStyle("font-size", block_w* 0.8);
			this.transitionU.setStyle("margin-left", 0);
			this.transitionE.setStyle("width", ws.x);
			this.transitionE.setStyle("height", block_w);
			this.transitionE.setStyle("top", 2 * block_w);
			this.transitionE.setStyle("font-size", block_w* 0.8);
			this.transitionE.setStyle("margin-left", 0);
			this.transitionL.setStyle("width", ws.x);
			this.transitionL.setStyle("height", block_w);
			this.transitionL.setStyle("top", 3 * block_w);
			this.transitionL.setStyle("font-size", block_w* 0.8);
			this.transitionL.setStyle("margin-left", 0);
			$("full-area").adopt(this.transitionF);
			$("full-area").adopt(this.transitionU);
			$("full-area").adopt(this.transitionE);
			$("full-area").adopt(this.transitionL);
			$("form-save").addEvent("click", function() {
				fuelControl.add($("form-date").get("value"), 
					$("form-value").get("value"),
					$("form-display").get("value")
				);
				fuelControl.save();
				fuelControl.transition("menu-page");
			});
			this.load();
		},
		transition: function(page) {
			$$("section").fade("out");
			this.page = page;
			var w = 320;
			this.transitionF.tween("margin-left", 0);
			this.transitionU.tween("margin-left", 0);
			this.transitionE.tween("margin-left", 0);
			this.transitionL.tween("margin-left", 0);
			switch (page) {
				case "log-page":
					this.logPage();
					break;
				case "stats-page":
					this.statsResume();
					break;
				case "graph-page":
					fuelControl.buildGraph("svg-graph");
					break;
			}
			window.setTimeout(function() {
				if (fuelControl.page == "menu-page") {
					$("back-button").setStyle("display", "none");
				} else {
					$("back-button").setStyle("display", "inline");
				}
				$(fuelControl.page).fade("in");
				fuelControl.transitionF.tween("margin-left", -w);
				fuelControl.transitionU.tween("margin-left", w);
				fuelControl.transitionE.tween("margin-left", -w);
				fuelControl.transitionL.tween("margin-left", w);
			}, 500);
		},
		memory: {
			version: "0.1",
			entries: []
		},
		add: function(d, v, s) {
			this.memory.entries.push({day: d, value: format_number(v), display: format_number(s)});
		},
		remove: function(i) {
			if (i < this.memory.entries.length) {
				this.memory.entries.splice(i, 1);
			}
		},
		getTable: function() {
			var tab = new Element("table");
			var header = new Element("tr");
			header.adopt(new Element("th").appendText("Day"));
			header.adopt(new Element("th").appendText("Value"));
			header.adopt(new Element("th").appendText("Display"));
			tab.adopt(header);
			this.memory.entries.each(function(e) {
				var line = new Element("tr");
				line.adopt(new Element("td", {class: "date"}).appendText(e.day));
				line.adopt(new Element("td", {class: "money"}).appendText(e.value));
				line.adopt(new Element("td", {class: "distance"}).appendText(e.display));
				tab.adopt(line);
			});
			return tab;
		},
       save: function() {
			localStorage.setItem(this.storageKey, JSON.stringify(this.memory));
        },
        
        // load from localStorage
        load: function() {
			var m = JSON.parse(localStorage.getItem(this.storageKey));
			if (m != undefined)
				this.memory = m;
		},
		buildGraph: function(el) {
			
            Raphael(function () {
				var dim = {
					x1: 0,
					x2: 320,
					y1: 30,
					y2: 220
				};
				if (fuelControl.paper)
					fuelControl.paper.clear()
				else
					fuelControl.paper = Raphael(el, 320, 400);
                var e = [],
                    clr = [],
                    modes = ["Valor", "Distância", "Dist. Total"],
                    values = [],
                    actual = 0,
                    mode = fuelControl.paper.text(110, 17, modes[actual]).attr({fill: "#A00000", stroke: "none", "font": '100 18px "Helvetica Neue", Helvetica, "Arial Unicode MS", Arial, sans-serif'}),
                    arena = fuelControl.paper.rect(dim.x1, dim.y1, dim.x2, dim.y2).attr("stroke", "#000"),
                    rightc = fuelControl.paper.circle(164, 17, 10).attr({fill: "#A00000", stroke: "none"}),
                    right = fuelControl.paper.path("M160,12l10,5 -10,5z").attr({fill: "#fff"}),
                    leftc = fuelControl.paper.circle(56, 17, 10).attr({fill: "#A00000", stroke: "none"}),
                    left = fuelControl.paper.path("M60,12l-10,5 10,5z").attr({fill: "#fff"}),
                    c = fuelControl.paper.path("M0,0").attr({fill: "none", "stroke-width": 4, "stroke-linecap": "round"}),
                    bg = fuelControl.paper.path("M0,0").attr({stroke: "none", opacity: .3}),
                    maxv = fuelControl.paper.text(dim.x1+57, dim.y1+7, "1.000.000").attr("fill", "#a00"),
                    midv = fuelControl.paper.text(dim.x1+57, (dim.y2 + dim.y1)/2 +7, "500.000").attr("fill", "#a00"),
                    minv = fuelControl.paper.text(dim.x1+57, dim.y1 + dim.y2 - 7, "0").attr("fill", "#a00"),
                    dotsy = [];
                function buildPath(m, j) {
                    var path = "", x = 0, y = 0, big = 0, aux = 0;
                    dotsy[j] = dotsy[j] || [];
                    if (m == "value") {
						for (var i = 0; i < fuelControl.memory.entries.length; i++) {
							dotsy[j][i] = fuelControl.memory.entries[i].value;
							big = (big > dotsy[j][i]) ? big : dotsy[j][i];
						}
					} else if (m == "distance") {
						for (var i = 0; i < fuelControl.memory.entries.length; i++) {
							if (i > 0) {
								dotsy[j][i-1] = fuelControl.memory.entries[i].display - aux;
								big = (big > dotsy[j][i-1]) ? big : dotsy[j][i-1];
							}
							aux = fuelControl.memory.entries[i].display;
						}
					} else if (m == "total-distance") {
						for (var i = 0; i < fuelControl.memory.entries.length; i++) {
							dotsy[j][i] = fuelControl.memory.entries[i].display;
							big = (big > dotsy[j][i]) ? big : dotsy[j][i];
						}						
					} else {
						for (var i = 0; i < m; i++) {
							dotsy[j][i] = Math.round(Math.random() * 200);
							big = (big > dotsy[j][i]) ? big : dotsy[j][i];
						}
					}
					var scale_y = (dim.y2 - dim.y1)/big;
					var scale_x = dim.x2/(dotsy[j].length - 1);
					dotsy[j].each(function(di) {
						if (x > 0) {
							x += scale_x;
							y = dim.y1 + dim.y2 - (di * scale_y);
							path += "L" + [x, y];
						} else {
							x = 10;
							path += "M" + [0, (y = dim.y1 + dim.y2 - (di * scale_y))] + " ";
						}
					});
                    return {
						path: path,
						max: Math.floor(big),
						mid: Math.floor(big / 2)
					};
                }
                /*values[0] = buildPath(10, 0);*/
                values[0] = buildPath("value", 1);
                values[1] = buildPath("distance", 2);
                values[2] = buildPath("total-distance", 3);
                for (var i = 0; i < modes.length; i++) {
                    values[i].color = Raphael.getColor(1);
                }
                c.attr({path: values[0], stroke: clr[0]});
                bg.attr({path: values[0] + "L590,250 10,250z", fill: clr[0]});
                var animation = function () {
                    var time = 500;
                    actual %= modes.length;
                    var anim = Raphael.animation({path: values[actual].path, stroke: values[actual].color}, time, "<>");
                    c.animate(anim);
                    bg.animateWith(c, anim, {path: values[actual].path + "L590,250 2,250z", fill: values[actual].color}, time, "<>");
                    mode.attr({text: modes[actual]});
                    midv.attr({text: values[actual].mid});
                    maxv.attr({text: values[actual].max});
                };
                var next = function () {
                        actual++;
                        animation();
                    },
                    prev = function () {
                        actual--;
                        animation();
                    };
                rightc.click(next);
                right.click(next);
                leftc.click(prev);
                left.click(prev);
				animation();
            });
		},
		statsResume: function() {
			$("stats-table").empty();
			$("stats-table").destroy();
			var tb = new Element("table", {id: "stats-table"}),
				tr = false,
				tdh = false,
				tdv = false;
			var total_count = this.memory.entries.length,
				total_distance = 0,
				total_value = 0,
				total_ratio = 0,
				max_distance = 0,
				min_distance = Infinity,
				mid_distance = 0,
				max_value = 0,
				min_value = Infinity,
				max_ratio = 0,
				min_ratio = Infinity,
				d = 0,
				v = 0,
				r = 0;

			table_add_line(tb, "Total de Entradas", total_count);
			
			if (total_count > 0) {

				for (var i = 0; i < total_count; i++ ) {
					v = fuelControl.memory.entries[i].value;
					total_value += v;
					if (max_value < v)
						max_value = v;
					if (min_value > v)
						min_value = v;
					if (i < total_count - 1) {
						d = fuelControl.memory.entries[i+1].display - fuelControl.memory.entries[i].display;
						r = d / v;
						if (max_distance < d)
							max_distance = d;
						if (min_distance > d)
							min_distance = d;
						if (max_ratio < r)
							max_ratio = r;
						if (min_ratio > r)
							min_ratio = r;
					}
				}
				total_distance = format_number(fuelControl.memory.entries[total_count - 1].display - fuelControl.memory.entries[0].display);
				total_ratio = format_number(total_distance / total_value);
				if (total_count == 1) {
					min_distance = 0;
					min_ratio = 0;
					mid_distance = total_distance;
				} else {
					mid_distance = total_distance/(total_count-1);
				}
				
								
				table_add_line(tb, "Gasto total", "R$ " + format_number(total_value));
				table_add_line(tb, "Distância total", total_distance + " km");
				table_add_line(tb, "Desempenho", total_ratio + " km/R$");

				table_add_line(tb, "Valor Mínimo", "R$ " + format_number(min_value));
				table_add_line(tb, "Valor Médio", "R$ " + format_number(total_value/total_count));
				table_add_line(tb, "Valor Máximo", "R$ " + format_number(max_value));

				table_add_line(tb, "Distância Mínima", format_number(min_distance) + " km");
				table_add_line(tb, "Distância Média", format_number(mid_distance) + " km");
				table_add_line(tb, "Distância Máxima", format_number(max_distance) + " km");

				table_add_line(tb, "Desempenho Mínimo", format_number(min_ratio) + " km/R$");
				table_add_line(tb, "Desempenho Máximo", format_number(max_ratio) + " km/R$");
			}

			zebra(tb);
			$("stats-page").adopt(tb);
		},
		logPage: function() {
			$("log-table").empty();
			$("log-table").destroy();
			var ltb = new Element("table", {id: "log-table"});
			var hea = new Element("tr");
			var prev = false;
			hea.adopt(new Element("th").appendText("Dia"));
			hea.adopt(new Element("th").appendText("Valor"));
			hea.adopt(new Element("th").appendText("Contador"));
			hea.adopt(new Element("th").appendText("Distância"));
			ltb.adopt(hea);
			
			for (var i = 0; i < this.memory.entries.length; i++) {
				table_add_log_line(ltb, i);
			}
			$("log-page").adopt(ltb);
			zebra(ltb);
		},
		mainPage: function() {
			var a_add = new Element("a", {id: "add-link"}).appendText("Add"),
				a_stats = new Element("a", {id: "stats-link"}).appendText("Stats"),
				a_graph = new Element("a", {id: "graph-link"}).appendText("Graph"),
				a_log = new Element("a", {id: "log-link"}).appendText("Log"),
				a_about = new Element("a", {id: "about-link"}).appendText("About");
			
			a_add.addEvent("click", function() {
				fuelControl.transition("add-page");
			});
			a_stats.addEvent("click", function() {
				fuelControl.transition("stats-page");
			});
			a_graph.addEvent("click", function() {
				fuelControl.transition("graph-page");
			});
			a_log.addEvent("click", function() {
				fuelControl.transition("log-page");
			});
			a_about.addEvent("click", function() {
				fuelControl.transition("about-page");
			});
			
			$("menu-page").adopt(a_add);
			$("menu-page").adopt(a_stats);
			$("menu-page").adopt(a_graph);
			$("menu-page").adopt(a_log);
			$("menu-page").adopt(a_about);
		}
	};
	
	$("back-button").addEvent("click", function() {
		fuelControl.transition("menu-page");
	});
	
	fuelControl.initialize();
	window.setTimeout(function() {
		fuelControl.transition("menu-page");
	}, 500);
	
	var svg_graph = new Element("div", {id: "svg-graph"});
	$("graph-page").adopt(svg_graph);
	fuelControl.mainPage();
	
});
