var battery = navigator.battery || navigator.mozBattery || navigator.webkitBattery;
var fullLevel = null;

function setFullLevel(level){
  if (level === null || level > 100 || level < 0){
    fullLevel = 100;
  } else {
    fullLevel = level;
  }
  localforage.setItem("fullLevel", fullLevel);
  updateFullLevelInput(fullLevel);
}

function updateFullLevelInput(level){
  document.getElementById('fullSelect').value = level;
}

function updateText(battery) {
  document.getElementById('level').innerHTML = Math.round(getLevel(battery))+"%" + (isFull(battery) ? " (Full)" : "") ;
  document.getElementById('status').innerHTML = battery.charging ? "Charging" : "On Battery";
}

function getLevel(battery){
  return battery.level * 100;
}

function isFull(battery){
  return (getLevel(battery) >= fullLevel);
}

var alarm = {
  audioElem: document.getElementById('alarm'),
  vibTimer: null,
  startAlarm: function(){
    this.audioElem.play();
    this.vibTimer = setInterval(function(){
      navigator.vibrate([1000]);
    }, 1500);

    document.getElementById('instr-battery').classList.add('hidden');
    document.getElementById('instr-alarm').classList.remove('hidden');

    //set timeout if set
  },
  stopAlarm: function(){
    this.audioElem.pause();
    this.audioElem.time = 0;

    clearInterval(this.vibTimer);
    navigator.vibrate(0);

    document.getElementById('instr-battery').classList.remove('hidden');
    document.getElementById('instr-alarm').classList.add('hidden');
  }
};

function check(){ //callback has no arg?
  updateText(battery);
  if (!battery.charging) {
    alarm.stopAlarm();
    return;
  }

  if (isFull(battery)){
    alarm.startAlarm();
  } else {
    alarm.stopAlarm();
  }
}

function toggleSettings(){
  var setting = document.getElementById('settings');
  if (setting.classList.contains('hidden')){
    setting.classList.remove('hidden');
  } else {
    setting.classList.add('hidden');
  }
}

battery.addEventListener("chargingchange", check);
battery.addEventListener("levelchange", check);
document.getElementById('settingsBtn').onclick = toggleSettings;
document.getElementById('fullSelect').onchange = function(){
  setFullLevel(document.getElementById('fullSelect').value);
  check();
};

localforage.getItem('fullLevel', function(level){
  setFullLevel(level);
  check();
});
document.getElementById('alarm').load();

