function startLoadGame() {
	ISG.GameLoader({
		gameName: 'FunFlurry',
		game: ISG.Games['FunFlurry'],
		parentId: "fill",
		showFps: true,
		api: new ISG.ClayAPIProvider({
			disableLogin: false,
			disableAds: false,
			disablePrerollAds: false,
			disableInapp: true,
			premiumVersion: false,
			gameId: 'funflurry',
			gameKey: 'funflurry'
		}),
		manifest: [{"id":"DefaultLogoPicture","type":"image","src":"Content/Image/Perfil.png"},{"id":"PremiumVersionImg","type":"image","src":"Content/Image/google_play_icon.png"},{"id":"IndiesparkImg","type":"image","src":"Content/Image/Logo_3.png"},{"id":"GameIslandSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/The-Hard-Luck-Gang-short.ogg"},{"id":"GameTownSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/Goofy-Mischief-short.ogg"},{"id":"MenuSquadSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/Sideburn-Squad-short.ogg"},{"id":"GameOverSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/game-over.ogg"},{"id":"GameSuccessSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/game-success.ogg"},{"id":"MenuClickSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/menu-click.ogg"},{"id":"PieceMoveSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/NFF-switchy-03.ogg"},{"id":"GameMenuWinSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/NFF-day-special-in.ogg"},{"id":"WinStarSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/NFF-coin-04.ogg"},{"id":"NoMoveSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/NFF-funny-cancel.ogg"},{"id":"HintSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/NFF-chromatic-rise.ogg"},{"id":"CountSound","type":"sound","src":"Scripts/Games/FunFlurry/lib/sounds/NFF-glassy-tap-02.ogg"}]
		});
}

function startGameFullScreenMode(fullscreen) {
	var fullscreenElement = document.getElementById("fullscreen");
	fullscreenElement.style.display = 'none';

	if (fullscreen && ISG.Utils.fullscreenEnabled) {
		ISG.Utils.requestFullscreen(document.body);
	}
	startLoadGame();
}
window.addEventListener("load", function() {
	var fsYesElem = document.getElementById("fsYes");
	var fsNoElem = document.getElementById("fsNo");
	
	fsYesElem.onclick = function() {
      startGameFullScreenMode(true);
    };
	
	fsNoElem.onclick = function() {
      startGameFullScreenMode(false);
    };
	
	if (document.fullscreenElement ||    // alternative standard method
		document.mozFullScreenElement ||
		document.webkitFullscreenElement ||
		document.msFullscreenElement )
	{
		var fullscreenElement = document.getElementById("fullscreen");
		fullscreenElement.style.display = 'none';
		startLoadGame();
	}
}, false);