angular.module('futbalapi', ['restangular', 'LocalStorageModule'])

  .factory('CacheApi', ['localStorageService', function (localStorageService) {
    return {
      'notExpired' : function (timestamp, expires) {
        return timestamp + expires > parseInt(moment().format('X'), 10);
      },
      'load' : function (key, lifetime, dataCallback, serverCallback) {
        var cache = localStorageService.get(key);

        if (cache && cache.importedAt && this.notExpired(cache.importedAt, lifetime)) {
          dataCallback(cache.data);
          Futbal.log('loaded data from cache (' + key + ')');
          return;
        }

        serverCallback().then(function (serverData) {
          dataCallback(serverData);

          localStorageService.set(key, {
            importedAt : parseInt(moment().format('X'), 10),
            data : serverData
          });
        });
      }
    }
  }])

  .factory('FeedApi', ['CacheApi', 'Restangular', function (CacheApi, Restangular) {
    return {
      'favorites' : function (favorites, callback) {
        return Restangular.one('favorites').one('post', JSON.stringify(favorites)).get().then(callback);
      },
      'all' : function (callback, limit, now) {
        var lifetime = 60 * 30;

        if (!limit) {
          limit = 20;
        }

        if (now || now == null) {
          lifetime = 0;
        }

        return CacheApi.load('allFeed', lifetime, callback, function () {
          return Restangular.one('feed', limit).getList();
        });
      }
    }
  }])

  .factory('FavoriteApi', ['localStorageService', function (localStorageService) {
    return {
      'toggleFeedItem' : function (item) {
        var id = item.id,
          favorites = localStorageService.get('favorites');

        if (!favorites[item.type]) {
          return;
        }

        // Teams are special
        if (favorites[item.type].indexOf(id) === -1) {
          favorites[item.type].push(id);
          item = Futbal.addFavoriteItemProperties(item, true);
        } else {
          favorites[item.type] = _.without(favorites[item.type], id);
          item = Futbal.addFavoriteItemProperties(item, false);
        }

        favorites[item.type] = _.filter(favorites[item.type]);

        localStorageService.set('favorites', favorites);

        return item;
      }
    }
  }])

  .factory('MatchApi', ['CacheApi', 'Restangular', function (CacheApi, Restangular) {
    return {
      'all' : function (callback) {
        return CacheApi.load('allMatches', 60 * 15, callback, function () {
          return Restangular.all('matches').getList();
        });
      },
      'one' : function (id, callback, now) {
        var lifetime = 60 * 15;

        if (now || now == null) {
          lifetime = 0;
        }

        return CacheApi.load('match_' + id, lifetime, callback, function () {
          return Restangular.one('matches', id).get();
        });
      }
    }
  }])

  .factory('TeamApi', ['CacheApi', 'Restangular', function (CacheApi, Restangular) {
    return {
      'all' : function (callback) {
        return CacheApi.load('allTeams', 60 * 60 * 24, callback, function () {
          return Restangular.all('teams').getList();
        });
      },
      'one' : function (id, callback) {
        var lifetime = 60 * 15;

        return CacheApi.load('team_' + id, lifetime, callback, function () {
          return Restangular.one('teams', id).get();
        });
      }
    }
  }])
;
