angular.module('starter', ['ionic', 'starter.controllers', 'pascalprecht.translate'])

.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    if(window.StatusBar) {
      // org.apache.cordova.statusbar required
      StatusBar.styleDefault();
    }
  });
})

.config(function($stateProvider, $urlRouterProvider, $translateProvider, RestangularProvider, $compileProvider) {
  // Rest API Configuration
  RestangularProvider.setBaseUrl(Futbal.API);

  $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|app|file):/);
  $compileProvider.imgSrcSanitizationWhitelist(/^\s*(https?|app|file):/);

  // Route Configuration
  $stateProvider

    .state('app', {
      url: "/app",
      abstract: true,
      templateUrl: "templates/menu.html",
      controller: 'AppCtrl'
    })

    .state('app.home', {
      url: "/home",
      views: {
        'home-tab' : {
          templateUrl: "templates/home.html",
          controller: 'HomeCtrl'
        }
      }
    })

    .state('app.data', {
      url: "/data",
      views: {
        'score-tab' : {
          templateUrl: "templates/data.html",
          controller: "DataCtrl"
        }
      }
    })

    .state('app.match', {
      url: "/match/:id",
      views: {
        'score-tab' : {
          templateUrl: "templates/match.html",
          controller: "DetailMatchCtrl"
        }
      }
    })

    .state('app.team', {
      url: "/team/:id",
      views: {
        'score-tab' : {
          templateUrl: "templates/team.html",
          controller: "DetailTeamCtrl"
        }
      }
    })

    .state('app.favorites', {
      url: "/favorites",
      views: {
        'favorite-tab' : {
          templateUrl: "templates/favorites.html",
          controller: "FavoriteCtrl"
        }
      }
    })
  ;

  // Translations
  $translateProvider.translations('en', {
    'Home' : 'Home',
    'World Cup' : 'WC',
    'Favorites' : 'Favorites',
    'Posts' : 'Posts',
    'Revert': 'Revert'
  });

  $translateProvider.translations('de', {
    'Home' : 'Home',
    'World Cup' : 'WM',
    'Favorites' : 'Favoriten',
    'Posts' : 'Posts',
    'Share' : 'Teilen',
    'Read original news' : 'News lesen',
    'Open post' : 'Beitrag ansehen',
    'Revert' : 'Gefällt mir nicht mehr',
    'Go back' : 'Zurück',
    'Standings' : 'Tabelle',
    'Round' : 'Runde',
    'Detail View' : 'Detailansicht',
    'Odds - Bets' : 'Quoten - Wetten',
    'Date' : 'Datum',
    'Location' : 'Ort',
    'Group' : 'Gruppe',
    'Win' : 'Sieg',
    'Draw' : 'Unentschieden',
    'Game not yet started' : 'Spiel hat noch nicht begonnen',
    'No likes set' : 'Keine Favoriten',
    'Load More' : 'Mehr laden',
    'Matches' : 'Spiele',
    'Teams': 'Mannschaften',
    'Like': 'Gefällt mir',
    'Likes': 'Likes',
    'Team Detail' : 'Team Detail',
    'Team' : 'Mannschaft',
    'P' : 'SP',
    'W' : 'S',
    'D' : 'U',
    'L' : 'N',
    'GD' : 'DIFF',
    'PTS' : 'PKT'
  });

  $translateProvider.translations('es', {
    'Home' : 'Casa',
    'World Cup' : 'Mundial',
    'Favorites' : 'Favoritos',
    'Posts' : 'Contribuciones',
    'Share' : 'Compartir',
    'Read original news' : 'Leer noticia',
    'Open post' : 'Ver contribución',
    'Revert' : 'No me gusta más',
    'Go back' : 'Regresar',
    'Standings' : 'Clasificación',
    'Round' : 'Jornada',
    'Detail View' : 'Mostrar detalles',
    'Odds - Bets' : 'Cuotas de apuestas',
    'Date' : 'Fecha',
    'Location' : 'Localidad',
    'Group' : 'Grupo',
    'Win' : 'Victoria',
    'Draw' : 'Empate',
    'Game not yet started' : 'El partido no ha empezado',
    'No likes set' : 'No tienes favoritos',
    'Load More' : 'Cargue más',
    'Matches' : 'Partidos',
    'Teams': 'Equipos',
    'Like': 'Me gusta',
    'Likes': 'Me gusta',
    'Team Detail' : 'Detalles del equipo',
    'Team' : 'Equipo',
    'P' : 'PJ',
    'W' : 'PG',
    'D' : 'PE',
    'L' : 'PP',
    'GD' : 'Dif',
    'PTS' : 'PTS'
  });

  // Set the browser standard to default if available
  angular.forEach(['en','de','es'], function(index){
    if( navigator.language.indexOf(index) > -1 ) {
      $translateProvider.use(index);
      moment.lang(index);
    }
  });

  // if none of the above states are matched, use this as the fallback
  $urlRouterProvider.otherwise('/app/home');
});
