Futbal = {
  'API' : 'http://futbal.kickitaway.com/',

  'log' : function (msg) {
    if (console && console.log) {
      console.log(msg);
    }
  },

  nameToPicture : function (name) {
    return name.replace(' ', '-');
  },

  isTeamFake : function(teamName)
  {
      if(2 === teamName.length) {
          return true;
      }

      if(teamName.indexOf("Winner") > -1) {
          return true;
      }

      if(teamName.indexOf("Loser") > -1) {
          return true;
      }

      return false;
  },

  addFavoriteItemProperties : function (item, isInLocalStorage) {
    if (isInLocalStorage) {
      item.action = 'Revert';
      item.favoriteClass = 'favorite';
      return item;
    }

    item.action = 'Like';
    item.favoriteClass = '';

    return item;
  },

  enhanceItem : function (item, favorites) {
    switch (item.type) {
      case 'social_media' :
        item.niceDescription = twttr.txt.autoLink(item.description);
        item.niceSource = item.source.slice(0, 1).toUpperCase() + item.source.slice(1).toLowerCase();
        item.niceCreatedAt = moment(item.created_at.date).fromNow();

        item.shareMessage = item.url + ' (shared via Futbal)';

        if (favorites && favorites.social_media) {
          item = Futbal.addFavoriteItemProperties(item, favorites.social_media.indexOf(item.id) !== -1);
        }

        break;
      case 'news' :
        item.niceSource = item.source;
        item.niceCreatedAt = moment(item.created_at.date).fromNow();
        item.thumbnail_url = item.media_url.replace('.jpg', '_thumb.jpg');
        item.large_url = item.media_url.replace('.jpg', '_herol.jpg');

        item.shareMessage = item.title + ' ' + item.url + ' (shared via Futbal)';

        if (favorites && favorites.news) {
          item = Futbal.addFavoriteItemProperties(item, favorites.news.indexOf(item.id) !== -1);
        }
        break;
      case 'game' :
        item.niceCreatedAt = moment(item.created_at.date).fromNow();
          item.niceDate = moment.utc(item.date.date).local().format('DD.MM.YYYY, H:mm');

        if (favorites && favorites.game) {
          item = Futbal.addFavoriteItemProperties(item, favorites.game.indexOf(item.id) !== -1);
        }

        item = Futbal.enhanceMatchData(item);
        break;
      default:
        break;
    }

    if (item.type) {
      item.modal_url = './templates/modal/' + item.type + '.html';
    }

    return item;
  },

  enhanceTeam : function (prefix, match, overview) {
    match[prefix + '_team'] = match[prefix + '_team'].replace('-', ' ');
    match[prefix + '_team_picture'] = Futbal.isTeamFake(match[prefix + '_team']) ? 'Unknown' : Futbal.nameToPicture(match[prefix + '_team']);
    match[prefix + '_team_fake'] = Futbal.isTeamFake(match[prefix + '_team']);

    if (match.date) {
      match.niceDate = moment.utc(match.date.date).local().format('DD.MM.YYYY, H:mm');
      match.hasStarted = parseInt(moment().format('X'), 10) - parseInt(moment.utc(match.date.date).local().format('X'), 10) < 0;
    }

    if (match[prefix + '_team_yellow_card_details']) {
        match[prefix + '_team_yellowCardDetails'] = match[prefix + '_team_yellow_card_details'].split(';').length;
    }

    if (match[prefix + '_team_red_card_details']) {
      match[prefix + '_team_redCardDetails'] = match[prefix + '_team_red_card_details'].split(';').length;
    }

    return match;
  },

  enhanceMatchData : function (match, overview) {
    match = this.enhanceTeam('home', match, overview);
    match = this.enhanceTeam('away', match, overview);

    return match;
  },

  enhanceStandingsData : function (standings) {
    standings.team_picture = Futbal.nameToPicture(standings.team);

    return standings;
  },

  enhanceTeamData : function (team, favorites) {
    team.name = team.name.replace('-', ' ');
    team.picture_name = Futbal.nameToPicture(team.name);
    team.fake = Futbal.isTeamFake(team.name);

    if (favorites && favorites.teams) {
      team = Futbal.addFavoriteItemProperties(team, favorites.teams.indexOf(team.id) !== -1);

      if (team.favoriteClass == 'favorite') {
        team.favoriteClass = 'button-royal';
      }
    }

    return team;
  },

  initDetailItemModal : function ($ionicModal, $scope, localStorageService, FavoriteApi, toggleCallback, $rootScope) {
    $ionicModal.fromTemplateUrl('./templates/itemModal.html', {
      scope: $scope,
      animation: 'slide-in-up'
    }).then(function(modal) {
      $scope.modal = modal;

      $scope.triggerModal = function() {
        var favorites = localStorageService.get('favorites');

        if ($scope.modal.isShown()) {
          $scope.modal.hide();
          $scope.detail = {};

          return;
        }

        $scope.modal.show();
        $scope.detail = Futbal.enhanceItem(this.item, favorites);
        $scope.detail.bar_title = 'Post Item Detail';
      };

      $scope.toggleAction = function () {
        _.isFunction(toggleCallback) && toggleCallback($scope);
        $scope.detail = FavoriteApi.toggleFeedItem($scope.detail);
      };

      $scope.hideAction = function () {
        $scope.modal.hide();
      };

      $scope.shareAction = function (msg) {
        if( 'firefoxos' !== device.platform ) {

          window.plugins.socialsharing.share(msg);
        }else{
          //twitter fallback for firefox os
          window.open('http://twitter.com/home?status=' + msg, '_blank');
        }
      };

      if (!$rootScope) {
        return;
      }

      $scope.linkAction = function () {
        $scope.hideAction();
        $rootScope.fromModal = true;
      }
    });
  }
};